/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginUtil;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.IntObjectMap;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexId;
import org.jetbrains.kotlin.com.intellij.util.io.SimpleStringPersistentEnumerator;

public class ID<K, V>
extends IndexId<K, V> {
    private static final Logger LOG = Logger.getInstance(ID.class);
    private static final IntObjectMap<ID<?, ?>> ourRegistry = ContainerUtil.createConcurrentIntObjectMap();
    private static final SimpleStringPersistentEnumerator ourNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
    private static final Map<ID<?, ?>, PluginId> ourIdToPluginId = Collections.synchronizedMap(new HashMap());
    private static final Map<ID<?, ?>, Throwable> ourIdToRegistrationStackTrace = Collections.synchronizedMap(new HashMap());
    private final short myUniqueId;

    @NotNull
    private static Path getEnumFile() {
        Path path = PathManager.getIndexRoot().resolve("indices.enum");
        if (path == null) {
            ID.$$$reportNull$$$0(0);
        }
        return path;
    }

    @ApiStatus.Internal
    protected ID(@NotNull String name2, @Nullable PluginId pluginId) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(1);
        }
        super(name2);
        this.myUniqueId = ID.stringToId(name2);
        ID old = ourRegistry.put(this.myUniqueId, this);
        assert (old == null) : "ID with name '" + name2 + "' is already registered";
        PluginId oldPluginId = ourIdToPluginId.put(this, pluginId);
        assert (oldPluginId == null) : "ID with name '" + name2 + "' is already registered in " + oldPluginId + " but current caller is " + pluginId;
        ourIdToRegistrationStackTrace.put(this, new Throwable());
    }

    private static short stringToId(@NotNull String name2) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(2);
        }
        return ourNameToIdRegistry.enumerate(name2);
    }

    @NotNull
    public static synchronized <K, V> ID<K, V> create(@NonNls @NotNull String name2) {
        PluginId pluginId;
        ID<K, V> found;
        if (name2 == null) {
            ID.$$$reportNull$$$0(3);
        }
        ID<K, V> iD = (found = ID.findByName(name2, true, pluginId = ID.getCallerPluginId())) == null ? new ID<K, V>(name2, pluginId) : found;
        if (iD == null) {
            ID.$$$reportNull$$$0(4);
        }
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name2) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(5);
        }
        return ID.findByName(name2, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected static <K, V> ID<K, V> findByName(@NotNull String name2, boolean checkCallerPlugin, @Nullable PluginId requiredPluginId) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(6);
        }
        ID<?, ?> id = ID.findById(ID.stringToId(name2));
        if (checkCallerPlugin && id != null) {
            String requiredPluginIdStr;
            PluginId actualPluginId = ourIdToPluginId.get(id);
            String actualPluginIdStr = actualPluginId == null ? "IDEA Core" : actualPluginId.getIdString();
            String string2 = requiredPluginIdStr = requiredPluginId == null ? "IDEA Core" : requiredPluginId.getIdString();
            if (!Objects.equals(actualPluginIdStr, requiredPluginIdStr)) {
                Throwable registrationStackTrace = ourIdToRegistrationStackTrace.get(id);
                String message = ID.getInvalidIdAccessMessage(name2, actualPluginIdStr, requiredPluginIdStr, registrationStackTrace);
                if (registrationStackTrace != null) {
                    throw new AssertionError(message, registrationStackTrace);
                }
                throw new AssertionError((Object)message);
            }
        }
        return id;
    }

    @NotNull
    private static String getInvalidIdAccessMessage(@NotNull String name2, @Nullable String actualPluginIdStr, @Nullable String requiredPluginIdStr, @Nullable Throwable registrationStackTrace) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(7);
        }
        String string2 = "ID with name '" + name2 + "' requested for plugin " + requiredPluginIdStr + " but registered for " + actualPluginIdStr + " plugin. Please use an instance field to access corresponding ID." + (registrationStackTrace == null ? " Registration stack trace: " : "");
        if (string2 == null) {
            ID.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public Throwable getRegistrationTrace() {
        Throwable throwable = ourIdToRegistrationStackTrace.get(this);
        if (throwable == null) {
            ID.$$$reportNull$$$0(9);
        }
        return throwable;
    }

    public final int hashCode() {
        return this.myUniqueId;
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginId getPluginId() {
        return ourIdToPluginId.get(this);
    }

    public static ID<?, ?> findById(int id) {
        return ourRegistry.get(id);
    }

    @ApiStatus.Internal
    @Nullable
    protected static PluginId getCallerPluginId() {
        return PluginUtil.getInstance().getCallerPlugin(4);
    }

    @ApiStatus.Internal
    public static synchronized void unloadId(@NotNull ID<?, ?> id) {
        if (id == null) {
            ID.$$$reportNull$$$0(10);
        }
        ID<?, ?> oldID = ourRegistry.remove(id.getUniqueId());
        LOG.assertTrue(id.equals(oldID));
        ourIdToPluginId.remove(id);
        ourIdToRegistrationStackTrace.remove(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/ID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/ID";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIdAccessMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationTrace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stringToId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidIdAccessMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unloadId";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

