/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeprecationInfoProvider;
import org.jetbrains.kotlin.fir.declarations.RequireKotlinDeprecationInfo;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.CommonDeprecationUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/RequireKotlinProvider;", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationInfoProvider;", "versionRequirement", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;)V", "computeDeprecationInfo", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "providers"})
@SourceDebugExtension(value={"SMAP\ndeprecationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deprecationUtils.kt\norg/jetbrains/kotlin/fir/declarations/RequireKotlinProvider\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,477:1\n227#2:478\n*S KotlinDebug\n*F\n+ 1 deprecationUtils.kt\norg/jetbrains/kotlin/fir/declarations/RequireKotlinProvider\n*L\n402#1:478\n*E\n"})
public final class RequireKotlinProvider
extends DeprecationInfoProvider {
    @NotNull
    private final VersionRequirement versionRequirement;

    public RequireKotlinProvider(@NotNull VersionRequirement versionRequirement) {
        Intrinsics.checkNotNullParameter((Object)versionRequirement, (String)"versionRequirement");
        this.versionRequirement = versionRequirement;
    }

    @Override
    @Nullable
    public DeprecationInfo computeDeprecationInfo(@NotNull FirSession session2) {
        RequireKotlinDeprecationInfo requireKotlinDeprecationInfo;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        boolean condition$iv = CommonDeprecationUtilsKt.isFulfilled(this.versionRequirement, FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2));
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            requireKotlinDeprecationInfo = null;
        } else {
            DeprecationLevelValue deprecationLevelValue;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.versionRequirement.getLevel().ordinal()]) {
                case 1: {
                    deprecationLevelValue = DeprecationLevelValue.WARNING;
                    break;
                }
                case 2: {
                    deprecationLevelValue = DeprecationLevelValue.ERROR;
                    break;
                }
                case 3: {
                    deprecationLevelValue = DeprecationLevelValue.HIDDEN;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            requireKotlinDeprecationInfo = new RequireKotlinDeprecationInfo(deprecationLevelValue, this.versionRequirement);
        }
        return requireKotlinDeprecationInfo;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevel.values().length];
            try {
                nArray[DeprecationLevel.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevel.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevel.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

