/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceConversionStrategy;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R#\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\n\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceAdaptation;", "", "argumentTypes", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coercionStrategy", "Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;", "defaults", "", "mappedArguments", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceMappedArguments;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "suspendConversionStrategy", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;", "<init>", "([Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;ILjava/util/Map;Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;)V", "getArgumentTypes", "()[Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "[Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getCoercionStrategy", "()Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;", "getDefaults", "()I", "getMappedArguments", "()Ljava/util/Map;", "Ljava/util/Map;", "getSuspendConversionStrategy", "()Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;", "resolve"})
@SourceDebugExtension(value={"SMAP\nCallableReferenceResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableReferenceResolution.kt\norg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceAdaptation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,506:1\n1755#2,3:507\n*S KotlinDebug\n*F\n+ 1 CallableReferenceResolution.kt\norg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceAdaptation\n*L\n209#1:507,3\n*E\n"})
public final class CallableReferenceAdaptation {
    @NotNull
    private final ConeKotlinType[] argumentTypes;
    @NotNull
    private final CoercionStrategy coercionStrategy;
    private final int defaults;
    @NotNull
    private final Map<FirValueParameter, ResolvedCallArgument> mappedArguments;
    @NotNull
    private final CallableReferenceConversionStrategy suspendConversionStrategy;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableReferenceAdaptation(@NotNull ConeKotlinType[] argumentTypes, @NotNull CoercionStrategy coercionStrategy, int defaults, @NotNull Map<FirValueParameter, ? extends ResolvedCallArgument> mappedArguments, @NotNull CallableReferenceConversionStrategy suspendConversionStrategy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)((Object)coercionStrategy), (String)"coercionStrategy");
        Intrinsics.checkNotNullParameter(mappedArguments, (String)"mappedArguments");
        Intrinsics.checkNotNullParameter((Object)suspendConversionStrategy, (String)"suspendConversionStrategy");
        this.argumentTypes = argumentTypes;
        this.coercionStrategy = coercionStrategy;
        this.defaults = defaults;
        this.mappedArguments = mappedArguments;
        this.suspendConversionStrategy = suspendConversionStrategy;
        if (!AbstractTypeChecker.RUN_SLOW_ASSERTIONS) return;
        if (this.defaults != 0) return;
        if (!Intrinsics.areEqual((Object)this.suspendConversionStrategy, (Object)CallableReferenceConversionStrategy.NoConversion.INSTANCE)) return;
        if (this.coercionStrategy != CoercionStrategy.NO_COERCION) return;
        Iterable $this$any$iv = this.mappedArguments.values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                ResolvedCallArgument it = (ResolvedCallArgument)element$iv;
                boolean bl2 = false;
                if (!(it instanceof ResolvedCallArgument.VarargArgument)) continue;
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl3 = false;
        if (bl3) return;
        boolean bl4 = false;
        String string2 = "Adaptation must be non-trivial.";
        throw new IllegalArgumentException(string2.toString());
    }

    @NotNull
    public final ConeKotlinType[] getArgumentTypes() {
        return this.argumentTypes;
    }

    @NotNull
    public final CoercionStrategy getCoercionStrategy() {
        return this.coercionStrategy;
    }

    public final int getDefaults() {
        return this.defaults;
    }

    @NotNull
    public final Map<FirValueParameter, ResolvedCallArgument> getMappedArguments() {
        return this.mappedArguments;
    }

    @NotNull
    public final CallableReferenceConversionStrategy getSuspendConversionStrategy() {
        return this.suspendConversionStrategy;
    }
}

