/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ApiVersionClassifierUsageChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "<init>", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class ApiVersionClassifierUsageChecker
implements ClassifierUsageChecker {
    @NotNull
    public static final ApiVersionClassifierUsageChecker INSTANCE = new ApiVersionClassifierUsageChecker();

    private ApiVersionClassifierUsageChecker() {
    }

    @Override
    public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(targetDescriptor, context2.getLanguageVersionSettings());
        if (accessibility instanceof SinceKotlinAccessibility.NotAccessible) {
            context2.getTrace().report(Errors.API_NOT_AVAILABLE.on(element, ((SinceKotlinAccessibility.NotAccessible)accessibility).getVersion().getVersionString(), context2.getLanguageVersionSettings().getApiVersion().getVersionString()));
        }
    }
}

