/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.inline.clean.RedundantVariableDeclarationElimination;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/RedundantVariableDeclarationElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "usages", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "hasChanges", "", "apply", "analyze", "", "perform", "js.translator"})
public final class RedundantVariableDeclarationElimination {
    @NotNull
    private final JsStatement root;
    @NotNull
    private final Set<JsName> usages;
    private boolean hasChanges;

    public RedundantVariableDeclarationElimination(@NotNull JsStatement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.usages = new LinkedHashSet();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantVariableDeclarationElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(JsNameRef x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsName name2 = x.getName();
                if (name2 != null && x.getQualifier() == null) {
                    ((Collection)RedundantVariableDeclarationElimination.access$getUsages$p(this.this$0)).add(name2);
                }
                return super.visit(x, ctx);
            }

            public boolean visit(JsBreak x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            public boolean visit(JsContinue x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            public boolean visit(JsFunction x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                CollectionsKt.addAll((Collection)RedundantVariableDeclarationElimination.access$getUsages$p(this.this$0), (Iterable)CollectUtilsKt.collectFreeVariables(x));
                return false;
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantVariableDeclarationElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void endVisit(JsVars x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    List<JsVars.JsVar> list = x.getVars();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getVars(...)");
                    if (CollectionsKt.removeAll(list, arg_0 -> perform.1.endVisit$lambda$0(this, this.this$0, arg_0))) {
                        RedundantVariableDeclarationElimination.access$setHasChanges$p(this.this$0, true);
                    }
                    if (x.getVars().isEmpty()) {
                        ctx.removeMe();
                    }
                }
                super.endVisit(x, ctx);
            }

            private final boolean isPure(JsExpression $this$isPure) {
                return $this$isPure == null || MetadataProperties.getConstant($this$isPure) || MetadataProperties.getSideEffects($this$isPure) == SideEffectKind.PURE;
            }

            public boolean visit(JsFunction x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            private static final boolean endVisit$lambda$0(perform.1 this$0, RedundantVariableDeclarationElimination this$1, JsVars.JsVar it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                return this$0.isPure(it.getInitExpression()) && !RedundantVariableDeclarationElimination.access$getUsages$p(this$1).contains(it.getName());
            }
        }.accept((JsNode)this.root);
    }

    public static final /* synthetic */ Set access$getUsages$p(RedundantVariableDeclarationElimination $this) {
        return $this.usages;
    }

    public static final /* synthetic */ void access$setHasChanges$p(RedundantVariableDeclarationElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

