// Generated by JFlex 1.9.2 http://jflex.de/  (tweaked for IntelliJ platform)
// source: src/org/jetbrains/kotlin/lexer/Kotlin.flex

package org.jetbrains.kotlin.lexer;

import java.util.*;
import com.intellij.lexer.*;
import com.intellij.psi.*;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.lexer.KotlinLexerException;
import org.jetbrains.kotlin.lexer.KtTokens;


class _JetLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING_PREFIX = 2;
  public static final int STRING = 4;
  public static final int RAW_STRING = 6;
  public static final int SHORT_TEMPLATE_ENTRY = 8;
  public static final int BLOCK_COMMENT = 10;
  public static final int DOC_COMMENT = 12;
  public static final int LONG_TEMPLATE_ENTRY = 14;
  public static final int UNMATCHED_BACKTICK = 16;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  5,  5,  6,  6, 
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u1f00\1\u3600\1\u3700\1\u3800\1\u3900"+
    "\1\u0100\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u4000"+
    "\1\u1f00\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700"+
    "\1\u4800\1\u4900\1\u4a00\1\u4b00\1\u4c00\1\u1f00\1\u4d00\1\u4e00"+
    "\1\u4f00\1\u1f00\3\u0100\1\u5000\1\u5100\1\u5200\12\u1f00\4\u0100"+
    "\1\u5300\17\u1f00\2\u0100\1\u5400\41\u1f00\2\u0100\1\u5500\1\u5600"+
    "\2\u1f00\1\u5700\1\u5800\27\u0100\1\u5900\2\u0100\1\u5a00\45\u1f00"+
    "\1\u0100\1\u5b00\1\u5c00\11\u1f00\1\u5d00\27\u1f00\1\u5e00\1\u5f00"+
    "\1\u6000\1\u6100\11\u1f00\1\u6200\1\u6300\5\u1f00\1\u6400\1\u6500"+
    "\4\u1f00\1\u6600\21\u1f00\246\u0100\1\u6700\20\u0100\1\u6800\1\u6900"+
    "\25\u0100\1\u6a00\34\u0100\1\u6b00\14\u1f00\2\u0100\1\u6c00\u0e05\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\1\3\1\4\1\3\22\0\1\1"+
    "\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\11\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\2\35\1\37\1\40\5\41\1\42\10\41"+
    "\1\43\2\41\1\44\2\41\1\45\1\46\1\47\1\0"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\1\41\1\66"+
    "\1\67\1\70\1\41\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\44\1\77\1\41\1\100\1\101\1\102\7\0"+
    "\1\3\44\0\1\41\12\0\1\41\4\0\1\41\5\0"+
    "\27\41\1\0\37\41\1\0\u01ca\41\4\0\14\41\16\0"+
    "\5\41\7\0\1\41\1\0\1\41\201\0\5\41\1\0"+
    "\2\41\2\0\4\41\1\0\1\41\6\0\1\41\1\0"+
    "\3\41\1\0\1\41\1\0\24\41\1\0\123\41\1\0"+
    "\213\41\10\0\246\41\1\0\46\41\2\0\1\41\6\0"+
    "\51\41\107\0\33\41\4\0\4\41\55\0\53\41\25\0"+
    "\12\103\4\0\2\41\1\0\143\41\1\0\1\41\17\0"+
    "\2\41\7\0\2\41\12\103\3\41\2\0\1\41\20\0"+
    "\1\41\1\0\36\41\35\0\131\41\13\0\1\41\16\0"+
    "\12\103\41\41\11\0\2\41\4\0\1\41\5\0\26\41"+
    "\4\0\1\41\11\0\1\41\3\0\1\41\27\0\31\41"+
    "\7\0\13\41\65\0\25\41\1\0\10\41\106\0\66\41"+
    "\3\0\1\41\22\0\1\41\7\0\12\41\4\0\12\103"+
    "\1\0\20\41\4\0\10\41\2\0\2\41\2\0\26\41"+
    "\1\0\7\41\1\0\1\41\3\0\4\41\3\0\1\41"+
    "\20\0\1\41\15\0\2\41\1\0\3\41\4\0\12\103"+
    "\2\41\12\0\1\41\10\0\6\41\4\0\2\41\2\0"+
    "\26\41\1\0\7\41\1\0\2\41\1\0\2\41\1\0"+
    "\2\41\37\0\4\41\1\0\1\41\7\0\12\103\2\0"+
    "\3\41\20\0\11\41\1\0\3\41\1\0\26\41\1\0"+
    "\7\41\1\0\2\41\1\0\5\41\3\0\1\41\22\0"+
    "\1\41\17\0\2\41\4\0\12\103\11\0\1\41\13\0"+
    "\10\41\2\0\2\41\2\0\26\41\1\0\7\41\1\0"+
    "\2\41\1\0\5\41\3\0\1\41\36\0\2\41\1\0"+
    "\3\41\4\0\12\103\1\0\1\41\21\0\1\41\1\0"+
    "\6\41\3\0\3\41\1\0\4\41\3\0\2\41\1\0"+
    "\1\41\1\0\2\41\3\0\2\41\3\0\3\41\3\0"+
    "\14\41\26\0\1\41\25\0\12\103\25\0\10\41\1\0"+
    "\3\41\1\0\27\41\1\0\20\41\3\0\1\41\32\0"+
    "\3\41\5\0\2\41\4\0\12\103\20\0\1\41\4\0"+
    "\10\41\1\0\3\41\1\0\27\41\1\0\12\41\1\0"+
    "\5\41\3\0\1\41\40\0\1\41\1\0\2\41\4\0"+
    "\12\103\1\0\2\41\22\0\10\41\1\0\3\41\1\0"+
    "\51\41\2\0\1\41\20\0\1\41\5\0\3\41\10\0"+
    "\3\41\4\0\12\103\12\0\6\41\5\0\22\41\3\0"+
    "\30\41\1\0\11\41\1\0\1\41\2\0\7\41\37\0"+
    "\12\103\21\0\60\41\1\0\2\41\14\0\7\41\11\0"+
    "\12\103\47\0\2\41\1\0\1\41\1\0\5\41\1\0"+
    "\30\41\1\0\1\41\1\0\12\41\1\0\2\41\11\0"+
    "\1\41\2\0\5\41\1\0\1\41\11\0\12\103\2\0"+
    "\4\41\40\0\1\41\37\0\12\103\26\0\10\41\1\0"+
    "\44\41\33\0\5\41\163\0\53\41\24\0\1\41\12\103"+
    "\6\0\6\41\4\0\4\41\3\0\1\41\3\0\2\41"+
    "\7\0\3\41\4\0\15\41\14\0\1\41\1\0\12\103"+
    "\6\0\46\41\1\0\1\41\5\0\1\41\2\0\53\41"+
    "\1\0\115\41\1\0\4\41\2\0\7\41\1\0\1\41"+
    "\1\0\4\41\2\0\51\41\1\0\4\41\2\0\41\41"+
    "\1\0\4\41\2\0\7\41\1\0\1\41\1\0\4\41"+
    "\2\0\17\41\1\0\71\41\1\0\4\41\2\0\103\41"+
    "\45\0\20\41\20\0\126\41\2\0\6\41\3\0\u016c\41"+
    "\2\0\21\41\1\0\32\41\5\0\113\41\6\0\10\41"+
    "\7\0\15\41\1\0\4\41\16\0\22\41\16\0\22\41"+
    "\16\0\15\41\1\0\3\41\17\0\64\41\43\0\1\41"+
    "\4\0\1\41\3\0\12\103\46\0\12\103\6\0\131\41"+
    "\7\0\5\41\2\0\42\41\1\0\1\41\5\0\106\41"+
    "\12\0\37\41\47\0\12\103\36\41\2\0\5\41\13\0"+
    "\54\41\4\0\32\41\6\0\12\103\46\0\27\41\11\0"+
    "\65\41\53\0\12\103\6\0\12\103\15\0\1\41\135\0"+
    "\57\41\21\0\7\41\4\0\12\103\51\0\36\41\15\0"+
    "\2\41\12\103\54\41\32\0\44\41\34\0\12\103\3\0"+
    "\3\41\12\103\44\41\2\0\11\41\7\0\53\41\2\0"+
    "\3\41\51\0\4\41\1\0\6\41\1\0\2\41\3\0"+
    "\1\41\5\0\300\41\100\0\26\41\2\0\6\41\2\0"+
    "\46\41\2\0\6\41\2\0\10\41\1\0\1\41\1\0"+
    "\1\41\1\0\1\41\1\0\37\41\2\0\65\41\1\0"+
    "\7\41\1\0\1\41\3\0\3\41\1\0\7\41\3\0"+
    "\4\41\2\0\6\41\4\0\15\41\5\0\3\41\1\0"+
    "\7\41\53\0\2\3\107\0\1\41\15\0\1\41\20\0"+
    "\15\41\145\0\1\41\4\0\1\41\2\0\12\41\1\0"+
    "\1\41\3\0\5\41\6\0\1\41\1\0\1\41\1\0"+
    "\1\41\1\0\4\41\1\0\13\41\2\0\4\41\5\0"+
    "\5\41\4\0\1\41\64\0\2\41\u017b\0\57\41\1\0"+
    "\57\41\1\0\205\41\6\0\4\41\3\0\2\41\14\0"+
    "\46\41\1\0\1\41\5\0\1\41\2\0\70\41\7\0"+
    "\1\41\20\0\27\41\11\0\7\41\1\0\7\41\1\0"+
    "\7\41\1\0\7\41\1\0\7\41\1\0\7\41\1\0"+
    "\7\41\1\0\7\41\120\0\1\41\325\0\2\41\52\0"+
    "\5\41\5\0\2\41\4\0\126\41\6\0\3\41\1\0"+
    "\132\41\1\0\4\41\5\0\53\41\1\0\136\41\21\0"+
    "\33\41\65\0\306\41\112\0\360\41\20\0\215\41\103\0"+
    "\56\41\2\0\15\41\3\0\20\41\12\103\2\41\24\0"+
    "\57\41\20\0\37\41\2\0\106\41\61\0\11\41\2\0"+
    "\147\41\2\0\65\41\2\0\5\41\60\0\13\41\1\0"+
    "\3\41\1\0\4\41\1\0\27\41\35\0\64\41\16\0"+
    "\62\41\34\0\12\103\30\0\6\41\3\0\1\41\1\0"+
    "\2\41\1\0\12\103\34\41\12\0\27\41\31\0\35\41"+
    "\7\0\57\41\34\0\1\41\12\103\6\0\5\41\1\0"+
    "\12\41\12\103\5\41\1\0\51\41\27\0\3\41\1\0"+
    "\10\41\4\0\12\103\6\0\27\41\3\0\1\41\3\0"+
    "\62\41\1\0\1\41\3\0\2\41\2\0\5\41\2\0"+
    "\1\41\1\0\1\41\30\0\3\41\2\0\13\41\7\0"+
    "\3\41\14\0\6\41\2\0\6\41\2\0\6\41\11\0"+
    "\7\41\1\0\7\41\1\0\53\41\1\0\14\41\10\0"+
    "\163\41\15\0\12\103\6\0\244\41\14\0\27\41\4\0"+
    "\61\41\4\0\u0100\3\156\41\2\0\152\41\46\0\7\41"+
    "\14\0\5\41\5\0\1\41\1\0\12\41\1\0\15\41"+
    "\1\0\5\41\1\0\1\41\1\0\2\41\1\0\2\41"+
    "\1\0\154\41\41\0\153\41\22\0\100\41\2\0\66\41"+
    "\50\0\14\41\164\0\5\41\1\0\207\41\23\0\12\103"+
    "\7\0\32\41\6\0\32\41\13\0\131\41\3\0\6\41"+
    "\2\0\6\41\2\0\6\41\2\0\3\41\43\0\14\41"+
    "\1\0\32\41\1\0\23\41\1\0\2\41\1\0\17\41"+
    "\2\0\16\41\42\0\173\41\205\0\35\41\3\0\61\41"+
    "\57\0\40\41\15\0\24\41\1\0\10\41\6\0\46\41"+
    "\12\0\36\41\2\0\44\41\4\0\10\41\60\0\236\41"+
    "\2\0\12\103\6\0\44\41\4\0\44\41\4\0\50\41"+
    "\10\0\64\41\234\0\67\41\11\0\26\41\12\0\10\41"+
    "\230\0\6\41\2\0\1\41\1\0\54\41\1\0\2\41"+
    "\3\0\1\41\2\0\27\41\12\0\27\41\11\0\37\41"+
    "\101\0\23\41\1\0\2\41\12\0\26\41\12\0\32\41"+
    "\106\0\70\41\6\0\2\41\100\0\1\41\17\0\4\41"+
    "\1\0\3\41\1\0\35\41\52\0\35\41\3\0\35\41"+
    "\43\0\10\41\1\0\34\41\33\0\66\41\12\0\26\41"+
    "\12\0\23\41\15\0\22\41\156\0\111\41\67\0\63\41"+
    "\15\0\63\41\15\0\44\41\14\0\12\103\306\0\35\41"+
    "\12\0\1\41\10\0\26\41\232\0\27\41\14\0\65\41"+
    "\56\0\12\103\23\0\55\41\40\0\31\41\7\0\12\103"+
    "\11\0\44\41\17\0\12\103\4\0\1\41\13\0\43\41"+
    "\3\0\1\41\14\0\60\41\16\0\4\41\13\0\12\103"+
    "\1\41\1\0\1\41\43\0\22\41\1\0\31\41\124\0"+
    "\7\41\1\0\1\41\1\0\4\41\1\0\17\41\1\0"+
    "\12\41\7\0\57\41\21\0\12\103\13\0\10\41\2\0"+
    "\2\41\2\0\26\41\1\0\7\41\1\0\2\41\1\0"+
    "\5\41\3\0\1\41\22\0\1\41\14\0\5\41\236\0"+
    "\65\41\22\0\4\41\5\0\12\103\5\0\1\41\40\0"+
    "\60\41\24\0\2\41\1\0\1\41\10\0\12\103\246\0"+
    "\57\41\51\0\4\41\44\0\60\41\24\0\1\41\13\0"+
    "\12\103\46\0\53\41\15\0\1\41\7\0\12\103\66\0"+
    "\33\41\25\0\12\103\306\0\54\41\164\0\100\41\12\103"+
    "\25\0\1\41\240\0\10\41\2\0\47\41\20\0\1\41"+
    "\1\0\1\41\34\0\1\41\12\0\50\41\7\0\1\41"+
    "\25\0\1\41\13\0\56\41\23\0\1\41\42\0\71\41"+
    "\7\0\11\41\1\0\45\41\21\0\1\41\17\0\12\103"+
    "\30\0\36\41\160\0\7\41\1\0\2\41\1\0\46\41"+
    "\25\0\1\41\11\0\12\103\6\0\6\41\1\0\2\41"+
    "\1\0\40\41\16\0\1\41\7\0\12\103\u0136\0\23\41"+
    "\15\0\232\41\346\0\304\41\274\0\57\41\321\0\107\41"+
    "\271\0\71\41\7\0\37\41\1\0\12\103\146\0\36\41"+
    "\22\0\60\41\20\0\4\41\14\0\12\103\11\0\25\41"+
    "\5\0\23\41\260\0\100\41\200\0\113\41\5\0\1\41"+
    "\102\0\15\41\100\0\2\41\1\0\1\41\34\0\370\41"+
    "\10\0\363\41\15\0\37\41\61\0\3\41\21\0\4\41"+
    "\10\0\u018c\41\4\0\153\41\5\0\15\41\3\0\11\41"+
    "\7\0\12\41\146\0\125\41\1\0\107\41\1\0\2\41"+
    "\2\0\1\41\2\0\2\41\2\0\4\41\1\0\14\41"+
    "\1\0\1\41\1\0\7\41\1\0\101\41\1\0\4\41"+
    "\2\0\10\41\1\0\7\41\1\0\34\41\1\0\4\41"+
    "\1\0\5\41\1\0\1\41\3\0\7\41\1\0\u0154\41"+
    "\2\0\31\41\1\0\31\41\1\0\37\41\1\0\31\41"+
    "\1\0\37\41\1\0\31\41\1\0\37\41\1\0\31\41"+
    "\1\0\37\41\1\0\31\41\1\0\10\41\2\0\62\103"+
    "\55\41\12\0\7\41\2\0\12\103\4\0\1\41\u0171\0"+
    "\54\41\4\0\12\103\6\0\305\41\73\0\104\41\7\0"+
    "\1\41\4\0\12\103\246\0\4\41\1\0\33\41\1\0"+
    "\2\41\1\0\1\41\2\0\1\41\1\0\12\41\1\0"+
    "\4\41\1\0\1\41\1\0\1\41\6\0\1\41\4\0"+
    "\1\41\1\0\1\41\1\0\1\41\1\0\3\41\1\0"+
    "\2\41\1\0\1\41\2\0\1\41\1\0\1\41\1\0"+
    "\1\41\1\0\1\41\1\0\1\41\1\0\2\41\1\0"+
    "\1\41\2\0\4\41\1\0\7\41\1\0\4\41\1\0"+
    "\4\41\1\0\1\41\1\0\12\41\1\0\21\41\5\0"+
    "\3\41\1\0\5\41\1\0\21\41\104\0\327\41\51\0"+
    "\65\41\13\0\336\41\2\0\u0182\41\16\0\u0131\41\37\0"+
    "\36\41\342\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27904];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\7\0\1\1\1\2\1\3\1\4\1\5\1\1\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\2\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\17\31\1\35"+
    "\1\1\1\36\1\37\1\40\1\41\1\42\1\40\1\1"+
    "\2\40\1\43\1\1\1\43\3\44\1\45\1\46\1\47"+
    "\1\0\1\50\1\0\1\51\1\0\1\52\1\53\2\10"+
    "\1\54\1\55\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\64\1\65\1\66\2\0\1\21\2\63\3\21\1\67"+
    "\1\70\1\71\1\72\1\73\1\74\1\0\1\75\3\31"+
    "\1\76\4\31\1\77\1\100\1\101\12\31\1\102\2\0"+
    "\1\103\1\0\1\104\2\105\2\0\1\43\1\106\1\107"+
    "\1\110\1\111\1\112\1\0\1\113\1\114\1\115\1\116"+
    "\2\0\1\63\1\117\1\31\1\120\5\31\1\121\1\122"+
    "\11\31\1\123\1\31\1\124\1\125\2\31\1\126\2\0"+
    "\1\127\2\43\1\130\1\51\1\131\3\31\1\132\2\31"+
    "\1\133\4\31\1\134\1\31\1\135\1\31\1\136\1\31"+
    "\1\103\1\0\1\137\1\140\1\141\1\31\1\142\4\31"+
    "\1\143\1\144\2\31\1\145\1\0\2\31\1\146\1\31"+
    "\1\147\1\31\1\150\2\31\1\151\1\31\1\152\2\31"+
    "\1\153\1\154";

  private static int [] zzUnpackAction() {
    int [] result = new int[237];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\104\0\210\0\314\0\u0110\0\u0154\0\u0198\0\u01dc"+
    "\0\u0220\0\u0264\0\u01dc\0\u02a8\0\u02ec\0\u0330\0\u0374\0\u03b8"+
    "\0\u01dc\0\u01dc\0\u03fc\0\u0440\0\u01dc\0\u0484\0\u04c8\0\u050c"+
    "\0\u0550\0\u0594\0\u05d8\0\u061c\0\u0660\0\u06a4\0\u06e8\0\u01dc"+
    "\0\u01dc\0\u072c\0\u01dc\0\u01dc\0\u0770\0\u07b4\0\u07f8\0\u083c"+
    "\0\u0880\0\u08c4\0\u0908\0\u094c\0\u0990\0\u09d4\0\u0a18\0\u0a5c"+
    "\0\u0aa0\0\u0ae4\0\u0b28\0\u0b6c\0\u01dc\0\u0bb0\0\u01dc\0\u0bf4"+
    "\0\u0c38\0\u01dc\0\u01dc\0\u0c7c\0\u0cc0\0\u01dc\0\u0d04\0\u0d48"+
    "\0\u0d8c\0\u0dd0\0\u01dc\0\u0e14\0\u0e58\0\u01dc\0\u01dc\0\u0e9c"+
    "\0\u0ee0\0\u0f24\0\u0f68\0\u0fac\0\u0ff0\0\u01dc\0\u01dc\0\u01dc"+
    "\0\u1034\0\u01dc\0\u01dc\0\u01dc\0\u01dc\0\u01dc\0\u01dc\0\u1078"+
    "\0\u10bc\0\u1100\0\u1144\0\u01dc\0\u1188\0\u11cc\0\u1210\0\u1254"+
    "\0\u01dc\0\u1298\0\u12dc\0\u1320\0\u01dc\0\u01dc\0\u01dc\0\u1364"+
    "\0\u01dc\0\u01dc\0\u13a8\0\u13ec\0\u1430\0\u1474\0\u14b8\0\u072c"+
    "\0\u14fc\0\u1540\0\u1584\0\u15c8\0\u072c\0\u160c\0\u072c\0\u1650"+
    "\0\u1694\0\u16d8\0\u171c\0\u1760\0\u17a4\0\u17e8\0\u182c\0\u1870"+
    "\0\u18b4\0\u01dc\0\u18f8\0\u0c7c\0\u193c\0\u1980\0\u01dc\0\u01dc"+
    "\0\u19c4\0\u1a08\0\u1a4c\0\u1a90\0\u01dc\0\u01dc\0\u01dc\0\u1ad4"+
    "\0\u1ad4\0\u1b18\0\u01dc\0\u01dc\0\u1b5c\0\u01dc\0\u1ba0\0\u1be4"+
    "\0\u1c28\0\u01dc\0\u01dc\0\u01dc\0\u1c6c\0\u1cb0\0\u1cf4\0\u1d38"+
    "\0\u1d7c\0\u072c\0\u072c\0\u1dc0\0\u1e04\0\u1e48\0\u1e8c\0\u1ed0"+
    "\0\u1f14\0\u1f58\0\u1f9c\0\u1fe0\0\u072c\0\u2024\0\u072c\0\u072c"+
    "\0\u2068\0\u20ac\0\u01dc\0\u20f0\0\u2134\0\u1a08\0\u01dc\0\u2178"+
    "\0\u01dc\0\u01dc\0\u01dc\0\u21bc\0\u2200\0\u2244\0\u072c\0\u2288"+
    "\0\u22cc\0\u072c\0\u2310\0\u2354\0\u2398\0\u23dc\0\u072c\0\u2420"+
    "\0\u072c\0\u2464\0\u072c\0\u24a8\0\u01dc\0\u24ec\0\u0d48\0\u072c"+
    "\0\u072c\0\u2530\0\u072c\0\u2574\0\u25b8\0\u25fc\0\u2640\0\u072c"+
    "\0\u072c\0\u2684\0\u26c8\0\u072c\0\u270c\0\u2750\0\u2794\0\u072c"+
    "\0\u27d8\0\u072c\0\u281c\0\u072c\0\u2860\0\u28a4\0\u072c\0\u28e8"+
    "\0\u072c\0\u292c\0\u2970\0\u072c\0\u072c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[237];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\10\2\11\1\10\1\11\1\12\1\13\1\14\1\15"+
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\41\10\42\1\43\1\10\1\44"+
    "\1\42\1\45\1\46\1\47\1\50\1\51\1\52\1\53"+
    "\2\42\1\54\3\42\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\42\1\63\1\64\1\42\1\65\1\66\1\67"+
    "\1\10\6\0\1\70\75\0\2\71\1\72\3\71\1\73"+
    "\1\71\1\74\35\71\1\75\37\71\1\76\3\71\1\77"+
    "\1\71\1\74\35\71\1\76\35\71\2\10\3\0\30\10"+
    "\10\100\3\10\1\100\1\101\21\100\1\102\4\100\4\10"+
    "\16\103\1\104\4\103\1\105\60\103\1\10\2\11\1\10"+
    "\1\11\1\12\1\13\1\14\1\15\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\10\42\1\43\1\10\1\44\1\42\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\2\42\1\54\3\42"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\42\1\63"+
    "\1\64\1\42\1\106\1\66\1\107\1\10\105\0\2\11"+
    "\1\0\1\11\130\0\1\110\30\0\1\111\26\0\1\112"+
    "\104\0\1\13\1\0\1\113\24\0\10\114\3\0\1\114"+
    "\1\115\26\114\35\0\1\116\64\0\1\117\71\0\2\20"+
    "\1\0\10\20\1\120\32\20\1\121\35\20\31\0\1\122"+
    "\71\0\1\123\11\0\1\124\73\0\1\125\7\0\1\126"+
    "\1\127\73\0\1\130\1\0\2\131\74\0\1\132\4\0"+
    "\1\133\5\0\1\134\74\0\1\135\1\0\2\136\10\0"+
    "\1\137\1\140\1\141\1\0\1\142\1\143\1\144\3\0"+
    "\1\136\2\0\1\137\2\0\1\140\1\141\5\0\1\142"+
    "\6\0\1\143\31\0\1\135\1\0\2\32\11\0\1\140"+
    "\1\141\1\0\1\142\1\143\4\0\1\32\5\0\1\140"+
    "\1\141\5\0\1\142\6\0\1\143\35\0\1\145\104\0"+
    "\1\146\105\0\1\147\103\0\1\150\1\151\102\0\1\152"+
    "\76\0\2\42\7\0\10\42\3\0\1\42\1\0\26\42"+
    "\3\0\1\42\2\153\1\0\46\153\1\0\32\153\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\20\42\1\154"+
    "\5\42\3\0\1\42\24\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\17\42\1\155\6\42\3\0\1\42\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\13\42\1\156"+
    "\1\42\1\157\10\42\3\0\1\42\24\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\15\42\1\160\10\42\3\0"+
    "\1\42\24\0\2\42\7\0\10\42\3\0\1\42\1\0"+
    "\13\42\1\161\12\42\3\0\1\42\24\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\1\162\14\42\1\163\4\42"+
    "\1\164\3\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\5\42\1\165\6\42\1\166\3\42"+
    "\1\167\5\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\22\42\1\170\3\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\1\42"+
    "\1\171\24\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\1\172\25\42\3\0\1\42\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\4\42\1\173"+
    "\21\42\3\0\1\42\24\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\22\42\1\174\3\42\3\0\1\42\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\7\42\1\175"+
    "\7\42\1\176\5\42\1\177\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\1\200\25\42\3\0"+
    "\1\42\24\0\2\42\7\0\10\42\3\0\1\42\1\0"+
    "\7\42\1\201\16\42\3\0\1\42\101\0\1\202\10\0"+
    "\1\203\75\0\2\71\1\0\3\71\1\0\1\71\1\0"+
    "\35\71\1\0\35\71\10\0\1\204\24\0\10\205\3\0"+
    "\1\205\1\206\26\205\1\207\3\0\2\210\1\0\71\210"+
    "\1\211\7\210\6\0\1\212\121\0\2\100\7\0\10\100"+
    "\3\0\1\100\1\0\26\100\3\0\1\100\2\213\1\0"+
    "\46\213\1\0\32\213\24\0\2\100\7\0\10\100\3\0"+
    "\1\100\1\0\7\100\1\214\16\100\3\0\1\100\23\0"+
    "\1\215\76\0\1\216\116\0\1\217\140\0\1\220\3\0"+
    "\1\221\11\0\2\112\1\0\101\112\6\0\1\13\1\0"+
    "\1\113\117\0\2\114\7\0\10\114\3\0\1\114\1\0"+
    "\26\114\3\0\1\114\2\222\1\0\46\222\1\0\32\222"+
    "\2\20\1\0\101\20\22\0\1\223\5\0\1\224\77\0"+
    "\2\131\11\0\1\140\1\141\7\0\1\131\5\0\1\140"+
    "\1\141\42\0\1\225\65\0\2\133\1\0\101\133\22\0"+
    "\1\226\1\0\2\131\100\0\1\227\1\0\2\136\11\0"+
    "\1\140\1\141\7\0\1\136\5\0\1\140\1\141\46\0"+
    "\1\230\1\0\2\137\14\0\1\142\1\143\4\0\1\137"+
    "\14\0\1\142\6\0\1\143\26\0\1\231\1\0\1\231"+
    "\2\0\2\231\12\0\1\141\7\0\1\231\6\0\1\141"+
    "\46\0\1\230\103\0\1\230\17\0\1\142\22\0\1\142"+
    "\40\0\1\230\1\0\2\144\7\0\4\144\1\0\1\142"+
    "\1\143\4\0\1\144\1\0\6\144\5\0\1\142\6\0"+
    "\1\143\40\0\1\232\52\0\2\153\1\0\46\153\1\233"+
    "\32\153\24\0\2\42\5\0\1\234\1\0\10\42\3\0"+
    "\1\42\1\0\26\42\3\0\1\42\24\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\4\42\1\235\21\42\3\0"+
    "\1\42\24\0\2\42\7\0\10\42\3\0\1\42\1\0"+
    "\1\236\25\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\14\42\1\237\11\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\20\42"+
    "\1\240\5\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\13\42\1\241\12\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\17\42"+
    "\1\242\6\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\14\42\1\243\11\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\21\42"+
    "\1\244\4\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\13\42\1\245\12\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\11\42"+
    "\1\246\14\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\2\42\1\247\23\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\21\42"+
    "\1\250\4\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\16\42\1\251\7\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\10\42"+
    "\1\252\6\42\1\253\6\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\22\42\1\254\2\42"+
    "\1\255\3\0\1\42\24\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\16\42\1\256\7\42\3\0\1\42\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\13\42\1\257"+
    "\3\42\1\260\6\42\3\0\1\42\24\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\4\42\1\261\3\42\1\262"+
    "\15\42\3\0\1\42\6\0\1\263\121\0\2\205\7\0"+
    "\10\205\3\0\1\205\1\0\26\205\3\0\1\205\2\264"+
    "\1\0\46\264\1\0\32\264\24\0\2\265\7\0\4\265"+
    "\11\0\6\265\32\0\1\266\75\0\2\213\1\0\46\213"+
    "\1\267\32\213\24\0\2\100\7\0\10\100\3\0\1\100"+
    "\1\0\10\100\1\270\15\100\3\0\1\100\24\0\2\271"+
    "\7\0\10\271\3\0\1\271\1\0\26\271\3\0\1\271"+
    "\2\222\1\0\46\222\1\272\32\222\23\0\1\273\104\0"+
    "\2\131\100\0\1\226\105\0\2\231\12\0\1\141\7\0"+
    "\1\231\6\0\1\141\50\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\1\274\25\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\20\42\1\275\5\42"+
    "\3\0\1\42\24\0\2\42\7\0\10\42\3\0\1\42"+
    "\1\0\21\42\1\276\4\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\4\42\1\277\21\42"+
    "\3\0\1\42\24\0\2\42\7\0\10\42\3\0\1\42"+
    "\1\0\20\42\1\300\5\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\4\42\1\301\21\42"+
    "\3\0\1\42\24\0\2\42\7\0\10\42\3\0\1\42"+
    "\1\0\13\42\1\302\12\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\4\42\1\303\21\42"+
    "\3\0\1\42\24\0\2\42\7\0\10\42\3\0\1\42"+
    "\1\0\12\42\1\304\13\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\22\42\1\305\3\42"+
    "\3\0\1\42\24\0\2\42\7\0\10\42\3\0\1\42"+
    "\1\0\4\42\1\306\21\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\20\42\1\307\5\42"+
    "\3\0\1\42\24\0\2\42\7\0\10\42\3\0\1\42"+
    "\1\0\15\42\1\310\10\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\4\42\1\311\21\42"+
    "\3\0\1\42\24\0\2\42\7\0\10\42\3\0\1\42"+
    "\1\0\4\42\1\312\21\42\3\0\1\42\24\0\2\42"+
    "\7\0\10\42\3\0\1\42\1\0\14\42\1\313\11\42"+
    "\3\0\1\42\24\0\2\42\7\0\10\42\3\0\1\42"+
    "\1\0\13\42\1\314\12\42\3\0\1\42\2\264\1\0"+
    "\46\264\1\315\32\264\24\0\2\316\7\0\4\316\11\0"+
    "\6\316\50\0\2\100\7\0\10\100\3\0\1\100\1\0"+
    "\20\100\1\317\5\100\3\0\1\100\24\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\12\42\1\320\13\42\3\0"+
    "\1\42\24\0\2\42\7\0\10\42\3\0\1\42\1\0"+
    "\20\42\1\321\5\42\3\0\1\42\24\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\10\42\1\322\15\42\3\0"+
    "\1\42\24\0\2\42\7\0\10\42\3\0\1\42\1\0"+
    "\4\42\1\323\21\42\3\0\1\42\24\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\17\42\1\324\6\42\3\0"+
    "\1\42\24\0\2\42\7\0\10\42\3\0\1\42\1\0"+
    "\2\42\1\325\23\42\3\0\1\42\24\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\1\326\25\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\17\42"+
    "\1\327\6\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\17\42\1\330\6\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\24\42"+
    "\1\331\1\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\1\332\14\42\1\333\10\42\3\0"+
    "\1\42\24\0\2\42\7\0\10\42\3\0\1\42\1\0"+
    "\4\42\1\334\21\42\3\0\1\42\24\0\2\335\7\0"+
    "\4\335\11\0\6\335\50\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\14\42\1\336\11\42\3\0\1\42\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\5\42\1\337"+
    "\20\42\3\0\1\42\24\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\21\42\1\340\4\42\3\0\1\42\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\6\42\1\341"+
    "\17\42\3\0\1\42\24\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\14\42\1\342\11\42\3\0\1\42\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\13\42\1\343"+
    "\12\42\3\0\1\42\24\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\5\42\1\344\20\42\3\0\1\42\24\0"+
    "\2\210\7\0\4\210\11\0\6\210\50\0\2\42\7\0"+
    "\10\42\3\0\1\42\1\0\22\42\1\345\3\42\3\0"+
    "\1\42\24\0\2\42\7\0\10\42\3\0\1\42\1\0"+
    "\1\346\25\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\4\42\1\347\21\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\10\42"+
    "\1\350\15\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\4\42\1\351\21\42\3\0\1\42"+
    "\24\0\2\42\7\0\10\42\3\0\1\42\1\0\2\42"+
    "\1\352\23\42\3\0\1\42\24\0\2\42\7\0\10\42"+
    "\3\0\1\42\1\0\1\353\25\42\3\0\1\42\24\0"+
    "\2\42\7\0\10\42\3\0\1\42\1\0\4\42\1\354"+
    "\21\42\3\0\1\42\24\0\2\42\7\0\10\42\3\0"+
    "\1\42\1\0\20\42\1\355\5\42\3\0\1\42";

  private static int [] zzUnpacktrans() {
    int [] result = new int[10676];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\7\0\1\11\2\1\1\11\5\1\2\11\2\1\1\11"+
    "\12\1\2\11\1\1\2\11\20\1\1\11\1\1\1\11"+
    "\2\1\2\11\2\1\1\11\4\1\1\11\2\1\2\11"+
    "\1\1\1\0\1\1\1\0\1\1\1\0\3\11\1\1"+
    "\6\11\4\1\1\11\2\0\2\1\1\11\3\1\3\11"+
    "\1\1\2\11\1\0\26\1\1\11\2\0\1\1\1\0"+
    "\2\11\1\1\2\0\1\1\3\11\2\1\1\0\2\11"+
    "\1\1\1\11\2\0\1\1\3\11\26\1\1\11\2\0"+
    "\1\1\1\11\1\1\3\11\21\1\1\11\1\0\16\1"+
    "\1\0\20\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[237];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  protected int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  private boolean zzEOFDone;

  /* user code: */
    private static final class State {
        final int lBraceCount;
        final int requiredInterpolationPrefix;
        final int state;

        public State(int state, int lBraceCount, int requiredInterpolationPrefix) {
            this.state = state;
            this.lBraceCount = lBraceCount;
            this.requiredInterpolationPrefix = requiredInterpolationPrefix;
        }

        @Override
        public String toString() {
            return "yystate = " + state
                + (lBraceCount == 0 ? "" : "lBraceCount = " + lBraceCount)
                + (requiredInterpolationPrefix == -1 ? "" : "requiredInterpolationPrefix = " + requiredInterpolationPrefix);
        }
    }

    private final Stack<State> states = new Stack<State>();
    private int lBraceCount;
    private int requiredInterpolationPrefix;

    private int commentStart;
    private int commentDepth;

    private void pushState(int state) {
        states.push(new State(yystate(), lBraceCount, requiredInterpolationPrefix));
        lBraceCount = 0;
        requiredInterpolationPrefix = -1;
        yybegin(state);
    }

    private void pushInterpolationPrefix(int interpolationPrefix) {
        states.push(new State(yystate(), lBraceCount, requiredInterpolationPrefix));
        lBraceCount = 0;
        requiredInterpolationPrefix = interpolationPrefix;
        yybegin(STRING_PREFIX);
    }

    private void popState() {
        State state = states.pop();
        lBraceCount = state.lBraceCount;
        requiredInterpolationPrefix = state.requiredInterpolationPrefix;
        yybegin(state.state);
    }

    private IElementType commentStateToTokenType(int state) {
        switch (state) {
            case BLOCK_COMMENT:
                return KtTokens.BLOCK_COMMENT;
            case DOC_COMMENT:
                return KtTokens.DOC_COMMENT;
            default:
                throw new IllegalArgumentException("Unexpected state: " + state);
        }
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _JetLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) throws KotlinLexerException {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new KotlinLexerException(message + "\n at '" + yytext() + "'\n" + zzBuffer);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  throws KotlinLexerException {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
    
  return;
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException,
     KotlinLexerException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case BLOCK_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }  // fall though
            case 238: break;
            case DOC_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }  // fall though
            case 239: break;
            default:
        return null;
        }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return TokenType.BAD_CHARACTER;
            }
          // fall through
          case 109: break;
          case 2:
            { return KtTokens.WHITE_SPACE;
            }
          // fall through
          case 110: break;
          case 3:
            { return KtTokens.EXCL      ;
            }
          // fall through
          case 111: break;
          case 4:
            { int interpolationPrefix = yylength() - 1;
                       pushInterpolationPrefix(Math.max(interpolationPrefix, 1));
                       yypushback(1);
                       if (interpolationPrefix != 0) return KtTokens.INTERPOLATION_PREFIX;
            }
          // fall through
          case 112: break;
          case 5:
            { return KtTokens.HASH      ;
            }
          // fall through
          case 113: break;
          case 6:
            { return KtTokens.PERC      ;
            }
          // fall through
          case 114: break;
          case 7:
            { return KtTokens.AND       ;
            }
          // fall through
          case 115: break;
          case 8:
            { return KtTokens.CHARACTER_LITERAL;
            }
          // fall through
          case 116: break;
          case 9:
            { return KtTokens.LPAR      ;
            }
          // fall through
          case 117: break;
          case 10:
            { return KtTokens.RPAR      ;
            }
          // fall through
          case 118: break;
          case 11:
            { return KtTokens.MUL       ;
            }
          // fall through
          case 119: break;
          case 12:
            { return KtTokens.PLUS      ;
            }
          // fall through
          case 120: break;
          case 13:
            { return KtTokens.COMMA     ;
            }
          // fall through
          case 121: break;
          case 14:
            { return KtTokens.MINUS     ;
            }
          // fall through
          case 122: break;
          case 15:
            { return KtTokens.DOT       ;
            }
          // fall through
          case 123: break;
          case 16:
            { return KtTokens.DIV       ;
            }
          // fall through
          case 124: break;
          case 17:
            { return KtTokens.INTEGER_LITERAL;
            }
          // fall through
          case 125: break;
          case 18:
            { return KtTokens.COLON     ;
            }
          // fall through
          case 126: break;
          case 19:
            { return KtTokens.SEMICOLON ;
            }
          // fall through
          case 127: break;
          case 20:
            { return KtTokens.LT        ;
            }
          // fall through
          case 128: break;
          case 21:
            { return KtTokens.EQ        ;
            }
          // fall through
          case 129: break;
          case 22:
            { return KtTokens.GT        ;
            }
          // fall through
          case 130: break;
          case 23:
            { return KtTokens.QUEST     ;
            }
          // fall through
          case 131: break;
          case 24:
            { return KtTokens.AT        ;
            }
          // fall through
          case 132: break;
          case 25:
            { return KtTokens.IDENTIFIER;
            }
          // fall through
          case 133: break;
          case 26:
            { return KtTokens.LBRACKET  ;
            }
          // fall through
          case 134: break;
          case 27:
            { return KtTokens.RBRACKET  ;
            }
          // fall through
          case 135: break;
          case 28:
            { pushState(UNMATCHED_BACKTICK); return TokenType.BAD_CHARACTER;
            }
          // fall through
          case 136: break;
          case 29:
            { return KtTokens.LBRACE    ;
            }
          // fall through
          case 137: break;
          case 30:
            { return KtTokens.RBRACE    ;
            }
          // fall through
          case 138: break;
          case 31:
            { yybegin(STRING); return KtTokens.OPEN_QUOTE;
            }
          // fall through
          case 139: break;
          case 32:
            { return KtTokens.REGULAR_STRING_PART;
            }
          // fall through
          case 140: break;
          case 33:
            { popState(); yypushback(1); return KtTokens.DANGLING_NEWLINE;
            }
          // fall through
          case 141: break;
          case 34:
            { popState(); return KtTokens.CLOSING_QUOTE;
            }
          // fall through
          case 142: break;
          case 35:
            { popState(); return KtTokens.IDENTIFIER;
            }
          // fall through
          case 143: break;
          case 36:
            { 
            }
          // fall through
          case 144: break;
          case 37:
            { lBraceCount++; return KtTokens.LBRACE;
            }
          // fall through
          case 145: break;
          case 38:
            { if (lBraceCount == 0) {
                                             popState();
                                             return KtTokens.LONG_TEMPLATE_ENTRY_END;
                                           }
                                           lBraceCount--;
                                           return KtTokens.RBRACE;
            }
          // fall through
          case 146: break;
          case 39:
            { return KtTokens.EXCLEQ    ;
            }
          // fall through
          case 147: break;
          case 40:
            { if (zzCurrentPos == 0) {
                return KtTokens.SHEBANG_COMMENT;
            }
            else {
                yypushback(yylength() - 1);
                return KtTokens.HASH;
            }
            }
          // fall through
          case 148: break;
          case 41:
            { return KtTokens.FIELD_IDENTIFIER;
            }
          // fall through
          case 149: break;
          case 42:
            { return KtTokens.PERCEQ    ;
            }
          // fall through
          case 150: break;
          case 43:
            { return KtTokens.ANDAND    ;
            }
          // fall through
          case 151: break;
          case 44:
            { return KtTokens.MULTEQ    ;
            }
          // fall through
          case 152: break;
          case 45:
            { return KtTokens.PLUSPLUS  ;
            }
          // fall through
          case 153: break;
          case 46:
            { return KtTokens.PLUSEQ    ;
            }
          // fall through
          case 154: break;
          case 47:
            { return KtTokens.MINUSMINUS;
            }
          // fall through
          case 155: break;
          case 48:
            { return KtTokens.MINUSEQ   ;
            }
          // fall through
          case 156: break;
          case 49:
            { return KtTokens.ARROW     ;
            }
          // fall through
          case 157: break;
          case 50:
            { return KtTokens.RANGE     ;
            }
          // fall through
          case 158: break;
          case 51:
            { return KtTokens.FLOAT_LITERAL;
            }
          // fall through
          case 159: break;
          case 52:
            { pushState(BLOCK_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
            }
          // fall through
          case 160: break;
          case 53:
            { return KtTokens.EOL_COMMENT;
            }
          // fall through
          case 161: break;
          case 54:
            { return KtTokens.DIVEQ     ;
            }
          // fall through
          case 162: break;
          case 55:
            { return KtTokens.COLONCOLON;
            }
          // fall through
          case 163: break;
          case 56:
            { return KtTokens.DOUBLE_SEMICOLON;
            }
          // fall through
          case 164: break;
          case 57:
            { return KtTokens.LTEQ      ;
            }
          // fall through
          case 165: break;
          case 58:
            { return KtTokens.EQEQ      ;
            }
          // fall through
          case 166: break;
          case 59:
            { return KtTokens.DOUBLE_ARROW;
            }
          // fall through
          case 167: break;
          case 60:
            { return KtTokens.GTEQ      ;
            }
          // fall through
          case 168: break;
          case 61:
            { return KtTokens.AS_KEYWORD ;
            }
          // fall through
          case 169: break;
          case 62:
            { return KtTokens.DO_KEYWORD ;
            }
          // fall through
          case 170: break;
          case 63:
            { return KtTokens.IF_KEYWORD ;
            }
          // fall through
          case 171: break;
          case 64:
            { return KtTokens.IN_KEYWORD ;
            }
          // fall through
          case 172: break;
          case 65:
            { return KtTokens.IS_KEYWORD ;
            }
          // fall through
          case 173: break;
          case 66:
            { return KtTokens.OROR      ;
            }
          // fall through
          case 174: break;
          case 67:
            { int interpolationPrefix = 0;
                                           for (int i = 0; i < yylength(); i++) {
                                               if (yycharat(i) == '$') { interpolationPrefix++; }
                                               else { break; }
                                           }
                                           int rest = yylength() - interpolationPrefix;
                                           if (interpolationPrefix == requiredInterpolationPrefix) {
                                               pushState(SHORT_TEMPLATE_ENTRY);
                                               yypushback(yylength() - interpolationPrefix);
                                               return KtTokens.SHORT_TEMPLATE_ENTRY_START;
                                           } else if (interpolationPrefix < requiredInterpolationPrefix) {
                                               return KtTokens.REGULAR_STRING_PART;
                                           } else {
                                               yypushback(requiredInterpolationPrefix + rest);
                                               return KtTokens.REGULAR_STRING_PART;
                                           }
            }
          // fall through
          case 175: break;
          case 68:
            { int interpolationPrefix = yylength() - 1;
                                           if (interpolationPrefix == requiredInterpolationPrefix) {
                                               pushState(LONG_TEMPLATE_ENTRY);
                                               return KtTokens.LONG_TEMPLATE_ENTRY_START;
                                           } else if (interpolationPrefix < requiredInterpolationPrefix) {
                                               return KtTokens.REGULAR_STRING_PART;
                                           } else {
                                               yypushback(requiredInterpolationPrefix + 1);
                                               return KtTokens.REGULAR_STRING_PART;
                                           }
            }
          // fall through
          case 176: break;
          case 69:
            { return KtTokens.ESCAPE_SEQUENCE;
            }
          // fall through
          case 177: break;
          case 70:
            { if (commentDepth > 0) {
            commentDepth--;
        }
        else {
             int state = yystate();
             popState();
             zzStartRead = commentStart;
             return commentStateToTokenType(state);
        }
            }
          // fall through
          case 178: break;
          case 71:
            { commentDepth++;
            }
          // fall through
          case 179: break;
          case 72:
            { return KtTokens.EXCLEQEQEQ;
            }
          // fall through
          case 180: break;
          case 73:
            { return KtTokens.NOT_IN;
            }
          // fall through
          case 181: break;
          case 74:
            { return KtTokens.NOT_IS;
            }
          // fall through
          case 182: break;
          case 75:
            { return KtTokens.RESERVED  ;
            }
          // fall through
          case 183: break;
          case 76:
            { return KtTokens.RANGE_UNTIL;
            }
          // fall through
          case 184: break;
          case 77:
            { pushState(DOC_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
            }
          // fall through
          case 185: break;
          case 78:
            { yypushback(2); return KtTokens.INTEGER_LITERAL;
            }
          // fall through
          case 186: break;
          case 79:
            { return KtTokens.EQEQEQ    ;
            }
          // fall through
          case 187: break;
          case 80:
            { return KtTokens.AS_SAFE;
            }
          // fall through
          case 188: break;
          case 81:
            { return KtTokens.FOR_KEYWORD ;
            }
          // fall through
          case 189: break;
          case 82:
            { return KtTokens.FUN_KEYWORD ;
            }
          // fall through
          case 190: break;
          case 83:
            { return KtTokens.TRY_KEYWORD ;
            }
          // fall through
          case 191: break;
          case 84:
            { return KtTokens.VAL_KEYWORD ;
            }
          // fall through
          case 192: break;
          case 85:
            { return KtTokens.VAR_KEYWORD ;
            }
          // fall through
          case 193: break;
          case 86:
            { yybegin(RAW_STRING); return KtTokens.OPEN_QUOTE;
            }
          // fall through
          case 194: break;
          case 87:
            { int length = yytext().length();
                                    if (length <= 3) { // closing """
                                        popState();
                                        return KtTokens.CLOSING_QUOTE;
                                    }
                                    else { // some quotes at the end of a string, e.g. """ "foo""""
                                        yypushback(3); // return the closing quotes (""") to the stream
                                        return KtTokens.REGULAR_STRING_PART;
                                    }
            }
          // fall through
          case 195: break;
          case 88:
            { yypushback(3); return KtTokens.EXCL;
            }
          // fall through
          case 196: break;
          case 89:
            { return KtTokens.BLOCK_COMMENT;
            }
          // fall through
          case 197: break;
          case 90:
            { return KtTokens.ELSE_KEYWORD ;
            }
          // fall through
          case 198: break;
          case 91:
            { return KtTokens.NULL_KEYWORD ;
            }
          // fall through
          case 199: break;
          case 92:
            { return KtTokens.THIS_KEYWORD ;
            }
          // fall through
          case 200: break;
          case 93:
            { return KtTokens.TRUE_KEYWORD ;
            }
          // fall through
          case 201: break;
          case 94:
            { return KtTokens.WHEN_KEYWORD ;
            }
          // fall through
          case 202: break;
          case 95:
            { popState(); return KtTokens.THIS_KEYWORD;
            }
          // fall through
          case 203: break;
          case 96:
            { return KtTokens.BREAK_KEYWORD ;
            }
          // fall through
          case 204: break;
          case 97:
            { return KtTokens.CLASS_KEYWORD ;
            }
          // fall through
          case 205: break;
          case 98:
            { return KtTokens.FALSE_KEYWORD ;
            }
          // fall through
          case 206: break;
          case 99:
            { return KtTokens.SUPER_KEYWORD ;
            }
          // fall through
          case 207: break;
          case 100:
            { return KtTokens.THROW_KEYWORD ;
            }
          // fall through
          case 208: break;
          case 101:
            { return KtTokens.WHILE_KEYWORD ;
            }
          // fall through
          case 209: break;
          case 102:
            { return KtTokens.OBJECT_KEYWORD ;
            }
          // fall through
          case 210: break;
          case 103:
            { return KtTokens.RETURN_KEYWORD ;
            }
          // fall through
          case 211: break;
          case 104:
            { return KtTokens.TYPEOF_KEYWORD ;
            }
          // fall through
          case 212: break;
          case 105:
            { return KtTokens.PACKAGE_KEYWORD ;
            }
          // fall through
          case 213: break;
          case 106:
            { return KtTokens.CONTINUE_KEYWORD ;
            }
          // fall through
          case 214: break;
          case 107:
            { return KtTokens.INTERFACE_KEYWORD ;
            }
          // fall through
          case 215: break;
          case 108:
            { return KtTokens.TYPE_ALIAS_KEYWORD ;
            }
          // fall through
          case 216: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
