/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/ir/ir.tree/tree-generator/ReadMe.md.
// DO NOT MODIFY IT MANUALLY.

package org.jetbrains.kotlin.ir.visitors

import org.jetbrains.kotlin.ir.IrElement
import org.jetbrains.kotlin.ir.declarations.*
import org.jetbrains.kotlin.ir.expressions.*
import org.jetbrains.kotlin.ir.types.IrType

/**
 * Auto-generated by [org.jetbrains.kotlin.ir.generator.print.TypeTransformerVoidPrinter]
 */
abstract class IrTypeTransformerVoid : IrTypeTransformer<Unit, Nothing?>, IrElementVisitorVoid {
    abstract fun <Type : IrType?> transformType(container: IrElement, type: Type): Type

    final override fun <Type : IrType?> transformType(container: IrElement, type: Type, data: Nothing?): Type =
        transformType(container, type)

    final override fun visitValueParameter(declaration: IrValueParameter, data: Nothing?) {
        visitValueParameter(declaration)
    }

    override fun visitValueParameter(declaration: IrValueParameter) {
        declaration.varargElementType = transformType(declaration, declaration.varargElementType)
        declaration.type = transformType(declaration, declaration.type)
        super<IrElementVisitorVoid>.visitValueParameter(declaration)
    }

    final override fun visitClass(declaration: IrClass, data: Nothing?) {
        visitClass(declaration)
    }

    override fun visitClass(declaration: IrClass) {
        declaration.valueClassRepresentation?.mapUnderlyingType {
            transformType(declaration, it)
        }
        declaration.superTypes = declaration.superTypes.map { transformType(declaration, it) }
        super<IrElementVisitorVoid>.visitClass(declaration)
    }

    final override fun visitTypeParameter(declaration: IrTypeParameter, data: Nothing?) {
        visitTypeParameter(declaration)
    }

    override fun visitTypeParameter(declaration: IrTypeParameter) {
        declaration.superTypes = declaration.superTypes.map { transformType(declaration, it) }
        super<IrElementVisitorVoid>.visitTypeParameter(declaration)
    }

    final override fun visitFunction(declaration: IrFunction, data: Nothing?) {
        visitFunction(declaration)
    }

    override fun visitFunction(declaration: IrFunction) {
        declaration.returnType = transformType(declaration, declaration.returnType)
        super<IrElementVisitorVoid>.visitFunction(declaration)
    }

    final override fun visitField(declaration: IrField, data: Nothing?) {
        visitField(declaration)
    }

    override fun visitField(declaration: IrField) {
        declaration.type = transformType(declaration, declaration.type)
        super<IrElementVisitorVoid>.visitField(declaration)
    }

    final override fun visitLocalDelegatedProperty(declaration: IrLocalDelegatedProperty, data: Nothing?) {
        visitLocalDelegatedProperty(declaration)
    }

    override fun visitLocalDelegatedProperty(declaration: IrLocalDelegatedProperty) {
        declaration.type = transformType(declaration, declaration.type)
        super<IrElementVisitorVoid>.visitLocalDelegatedProperty(declaration)
    }

    final override fun visitScript(declaration: IrScript, data: Nothing?) {
        visitScript(declaration)
    }

    override fun visitScript(declaration: IrScript) {
        declaration.baseClass = transformType(declaration, declaration.baseClass)
        super<IrElementVisitorVoid>.visitScript(declaration)
    }

    final override fun visitTypeAlias(declaration: IrTypeAlias, data: Nothing?) {
        visitTypeAlias(declaration)
    }

    override fun visitTypeAlias(declaration: IrTypeAlias) {
        declaration.expandedType = transformType(declaration, declaration.expandedType)
        super<IrElementVisitorVoid>.visitTypeAlias(declaration)
    }

    final override fun visitVariable(declaration: IrVariable, data: Nothing?) {
        visitVariable(declaration)
    }

    override fun visitVariable(declaration: IrVariable) {
        declaration.type = transformType(declaration, declaration.type)
        super<IrElementVisitorVoid>.visitVariable(declaration)
    }

    final override fun visitExpression(expression: IrExpression, data: Nothing?) {
        visitExpression(expression)
    }

    override fun visitExpression(expression: IrExpression) {
        expression.type = transformType(expression, expression.type)
        super<IrElementVisitorVoid>.visitExpression(expression)
    }

    final override fun visitMemberAccess(expression: IrMemberAccessExpression<*>, data: Nothing?) {
        visitMemberAccess(expression)
    }

    override fun visitMemberAccess(expression: IrMemberAccessExpression<*>) {
        (0 until expression.typeArgumentsCount).forEach {
            expression.getTypeArgument(it)?.let { type ->
                expression.putTypeArgument(it, transformType(expression, type))
            }
        }
        super<IrElementVisitorVoid>.visitMemberAccess(expression)
    }

    final override fun visitClassReference(expression: IrClassReference, data: Nothing?) {
        visitClassReference(expression)
    }

    override fun visitClassReference(expression: IrClassReference) {
        expression.classType = transformType(expression, expression.classType)
        super<IrElementVisitorVoid>.visitClassReference(expression)
    }

    final override fun visitConstantObject(expression: IrConstantObject, data: Nothing?) {
        visitConstantObject(expression)
    }

    override fun visitConstantObject(expression: IrConstantObject) {
        for (i in 0 until expression.typeArguments.size) {
            expression.typeArguments[i] = transformType(expression, expression.typeArguments[i])
        }
        super<IrElementVisitorVoid>.visitConstantObject(expression)
    }

    final override fun visitTypeOperator(expression: IrTypeOperatorCall, data: Nothing?) {
        visitTypeOperator(expression)
    }

    override fun visitTypeOperator(expression: IrTypeOperatorCall) {
        expression.typeOperand = transformType(expression, expression.typeOperand)
        super<IrElementVisitorVoid>.visitTypeOperator(expression)
    }

    final override fun visitVararg(expression: IrVararg, data: Nothing?) {
        visitVararg(expression)
    }

    override fun visitVararg(expression: IrVararg) {
        expression.varargElementType = transformType(expression, expression.varargElementType)
        super<IrElementVisitorVoid>.visitVararg(expression)
    }
}
