/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.NameReplacingVisitor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u0006\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "fillCoroutineMetadata", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl$WithDestructuringDeclaration;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nLiteralFunctionTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiteralFunctionTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1863#2,2:265\n*S KotlinDebug\n*F\n+ 1 LiteralFunctionTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator\n*L\n59#1:265,2\n*E\n"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    public LiteralFunctionTranslator(@NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PsiElement finalElement = UtilsKt.getFinalElement(declaration);
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context(...)");
        TranslationContext invokingContext = translationContext;
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionDescriptor(...)");
        FunctionDescriptor descriptor = functionDescriptor;
        JsFunction jsFunction = invokingContext.getFunctionObject(descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"getFunctionObject(...)");
        JsFunction lambda = jsFunction;
        TranslationContext translationContext2 = invokingContext.newFunctionBodyWithUsageTracker(lambda, descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext2, (String)"newFunctionBodyWithUsageTracker(...)");
        List<JsParameter> list = lambda.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        TranslationContext functionContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext2, descriptor, list);
        List<ValueParameterDescriptor> list2 = descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            if (!(it instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration)) continue;
            lambda.getBody().getStatements().add(this.translate((ValueParameterDescriptorImpl.WithDestructuringDeclaration)it, functionContext));
        }
        List<JsStatement> list3 = lambda.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getStatements(...)");
        $this$forEach$iv = list3;
        List<JsStatement> list4 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor, functionContext);
        Intrinsics.checkNotNullExpressionValue(list4, (String)"setDefaultValueForArguments(...)");
        CollectionsKt.addAll((Collection)$this$forEach$iv, (Iterable)list4);
        List<JsStatement> list5 = lambda.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"getStatements(...)");
        $this$forEach$iv = list5;
        $this$forEach$iv.add(FunctionBodyTranslator.translateFunctionBody(descriptor, declaration, functionContext));
        MetadataProperties.setFunctionDescriptor(lambda, descriptor);
        lambda.setSource(declaration);
        lambda.getBody().setSource(finalElement instanceof LeafPsiElement ? (LeafPsiElement)finalElement : null);
        UsageTracker usageTracker = functionContext.usageTracker();
        Intrinsics.checkNotNull((Object)usageTracker);
        UsageTracker tracker = usageTracker;
        JsName jsName = invokingContext.getInnerNameForDescriptor(descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getInnerNameForDescriptor(...)");
        JsName name2 = jsName;
        if (UsageTrackerKt.hasCapturedExceptContaining(tracker)) {
            JsFunction jsFunction2 = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda.source(declaration));
            Intrinsics.checkNotNullExpressionValue((Object)jsFunction2, (String)"simpleReturnFunction(...)");
            JsFunction lambdaCreator = jsFunction2;
            MetadataProperties.setLocal(lambdaCreator, true);
            if (tracker.getCapturedDescriptors().contains(descriptor) && !DescriptorUtilsKt.isCoroutineLambda(descriptor)) {
                lambda.setName(UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor));
            }
            MetadataProperties.setStaticRef(name2, lambdaCreator);
            this.fillCoroutineMetadata(lambdaCreator, invokingContext, descriptor);
            lambdaCreator.setSource(declaration);
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, functionContext, name2, invokingContext, declaration);
        }
        if (tracker.getCapturedDescriptors().contains(descriptor)) {
            JsName jsName2 = UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor);
            Intrinsics.checkNotNull((Object)jsName2);
            JsName capturedName = jsName2;
            JsName jsName3 = invokingContext.getInnerNameForDescriptor(descriptor);
            Intrinsics.checkNotNullExpressionValue((Object)jsName3, (String)"getInnerNameForDescriptor(...)");
            JsName globalName = jsName3;
            NameReplacingVisitor replacingVisitor = new NameReplacingVisitor(MapsKt.mapOf((Pair)TuplesKt.to((Object)capturedName, (Object)JsAstUtils.pureFqn(globalName, null))));
            replacingVisitor.accept((JsNode)lambda);
        }
        MetadataProperties.setLocal(lambda, true);
        LiteralFunctionTranslatorKt.access$addFunctionDeclaration(invokingContext, name2, lambda, declaration);
        this.fillCoroutineMetadata(lambda, invokingContext, descriptor);
        MetadataProperties.setStaticRef(name2, lambda);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(name2, null);
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"pureFqn(...)");
        return jsNameRef;
    }

    public final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context, @NotNull FunctionDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$fillCoroutineMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!descriptor.isSuspend()) {
            return;
        }
        UtilsKt.fillCoroutineMetadata($this$fillCoroutineMetadata, context, descriptor, descriptor.getExtensionReceiverParameter() != null);
        MetadataProperties.setForceStateMachine($this$fillCoroutineMetadata, true);
    }

    @NotNull
    public final JsVars translate(@NotNull ValueParameterDescriptorImpl.WithDestructuringDeclaration $this$translate, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$translate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($this$translate);
        ASTDelegatePsiElement aSTDelegatePsiElement = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
        if (aSTDelegatePsiElement == null || (aSTDelegatePsiElement = aSTDelegatePsiElement.getDestructuringDeclaration()) == null) {
            throw new IllegalStateException(("Destructuring declaration for descriptor " + $this$translate + " not found").toString());
        }
        ASTDelegatePsiElement destructuringDeclaration = aSTDelegatePsiElement;
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference($this$translate, context);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"translateAsValueReference(...)");
        JsExpression parameterRef = jsExpression;
        JsVars jsVars = DestructuringDeclarationTranslator.translate((KtDestructuringDeclaration)destructuringDeclaration, parameterRef, context);
        Intrinsics.checkNotNullExpressionValue((Object)jsVars, (String)"translate(...)");
        return jsVars;
    }
}

