/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.AbstractNativeAnnotationsChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/resolve/AbstractNativeIndexerChecker;", "Lorg/jetbrains/kotlin/js/resolve/AbstractNativeAnnotationsChecker;", "requiredAnnotation", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "indexerKind", "", "requiredParametersCount", "", "<init>", "(Lorg/jetbrains/kotlin/js/PredefinedAnnotation;Ljava/lang/String;I)V", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "js.frontend"})
public abstract class AbstractNativeIndexerChecker
extends AbstractNativeAnnotationsChecker {
    @NotNull
    private final String indexerKind;
    private final int requiredParametersCount;

    public AbstractNativeIndexerChecker(@NotNull PredefinedAnnotation requiredAnnotation, @NotNull String indexerKind, int requiredParametersCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)requiredAnnotation), (String)"requiredAnnotation");
        Intrinsics.checkNotNullParameter((Object)indexerKind, (String)"indexerKind");
        super(requiredAnnotation);
        this.indexerKind = indexerKind;
        this.requiredParametersCount = requiredParametersCount;
    }

    @Override
    public void additionalCheck(@NotNull KtNamedFunction declaration, @NotNull FunctionDescriptor descriptor, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        List<ValueParameterDescriptor> list = descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        List<ValueParameterDescriptor> parameters = list;
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(descriptor);
        if (!((Collection)parameters).isEmpty()) {
            KotlinType kotlinType = ((ValueParameterDescriptor)CollectionsKt.first(parameters)).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            KotlinType firstParamType = kotlinType;
            if (!KotlinBuiltIns.isString(firstParamType)) {
                SimpleType simpleType = builtIns.getNumber().getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
                if (!TypeUtilsKt.isSubtypeOf(firstParamType, simpleType)) {
                    List<KtParameter> list2 = declaration.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
                    diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_KEY_SHOULD_BE_STRING_OR_NUMBER.on((KtElement)((PsiElement)CollectionsKt.first(list2)), this.indexerKind));
                }
            }
        }
        if (parameters.size() != this.requiredParametersCount) {
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_WRONG_PARAMETER_COUNT.on((KtElement)((PsiElement)declaration), this.requiredParametersCount, this.indexerKind));
        }
        for (KtParameter parameter : declaration.getValueParameters()) {
            if (!parameter.hasDefaultValue()) continue;
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_CAN_NOT_HAVE_DEFAULT_ARGUMENTS.on((KtElement)((PsiElement)parameter), this.indexerKind));
        }
    }
}

