/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.AbstractCharList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharSpliterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharUnaryOperator;

public interface CharList
extends CharCollection,
Comparable<List<? extends Character>>,
List<Character> {
    @Override
    public CharListIterator iterator();

    @Override
    default public CharSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractCharList.IndexBasedSpliterator(this, 0);
        }
        return CharSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public CharListIterator listIterator();

    public CharListIterator listIterator(int var1);

    public CharList subList(int var1, int var2);

    public void getElements(int var1, char[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(char[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index, char[] a) {
        this.setElements(index, a, 0, a.length);
    }

    default public void setElements(int index, char[] a, int offset, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        CharArrays.ensureOffsetLength(a, offset, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        CharListIterator iter = this.listIterator(index);
        int i = 0;
        while (i < length) {
            iter.nextChar();
            iter.set(a[offset + i++]);
        }
    }

    @Override
    public boolean add(char var1);

    @Override
    public void add(int var1, char var2);

    @Override
    @Deprecated
    default public void add(int index, Character key) {
        this.add(index, key.charValue());
    }

    @Override
    public char set(int var1, char var2);

    default public void replaceAll(CharUnaryOperator operator) {
        CharListIterator iter = this.listIterator();
        while (iter.hasNext()) {
            iter.set(operator.apply(iter.nextChar()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Character> operator) {
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof CharUnaryOperator ? (CharUnaryOperator)operator : operator::apply);
    }

    public char getChar(int var1);

    public int indexOf(char var1);

    public int lastIndexOf(char var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return CharCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Character get(int index) {
        return Character.valueOf(this.getChar(index));
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf(((Character)o).charValue());
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf(((Character)o).charValue());
    }

    @Override
    @Deprecated
    default public boolean add(Character k) {
        return this.add(k.charValue());
    }

    public char removeChar(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return CharCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Character remove(int index) {
        return Character.valueOf(this.removeChar(index));
    }

    @Override
    @Deprecated
    default public Character set(int index, Character k) {
        return Character.valueOf(this.set(index, k.charValue()));
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Character> comparator) {
        this.sort(CharComparators.asCharComparator(comparator));
    }

    default public void sort(CharComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            char[] elements = this.toCharArray();
            CharArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    default public void unstableSort(CharComparator comparator) {
        char[] elements = this.toCharArray();
        if (comparator == null) {
            CharArrays.unstableSort(elements);
        } else {
            CharArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

