/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.scopes.AbstractLocalRedeclarationChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/ThrowingLocalRedeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/scopes/AbstractLocalRedeclarationChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "<init>", "(Lorg/jetbrains/kotlin/resolve/OverloadChecker;)V", "handleRedeclaration", "", "first", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "second", "handleConflictingOverloads", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "frontend"})
public final class ThrowingLocalRedeclarationChecker
extends AbstractLocalRedeclarationChecker {
    public ThrowingLocalRedeclarationChecker(@NotNull OverloadChecker overloadChecker) {
        Intrinsics.checkNotNullParameter((Object)overloadChecker, (String)"overloadChecker");
        super(overloadChecker);
    }

    @Override
    protected void handleRedeclaration(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String string2 = "Redeclaration: %s (%s) and %s (%s) (no line info available)";
        Object[] objectArray = new Object[]{DescriptorUtils.getFqName(first), first, DescriptorUtils.getFqName(second), second};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        throw new IllegalStateException(string3);
    }

    @Override
    protected void handleConflictingOverloads(@NotNull CallableMemberDescriptor first, @NotNull CallableMemberDescriptor second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String string2 = "Conflicting overloads: %s (%s) and %s (%s) (no line info available)";
        Object[] objectArray = new Object[]{DescriptorUtils.getFqName(first), first, DescriptorUtils.getFqName(second), second};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        throw new IllegalStateException(string3);
    }
}

