/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.expression;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionChecker;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrConstTypeChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrConstChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrConstTypeChecker
implements IrExpressionChecker<IrConst> {
    @NotNull
    public static final IrConstTypeChecker INSTANCE = new IrConstTypeChecker();

    private IrConstTypeChecker() {
    }

    @Override
    public void check(@NotNull IrConst expression2, @NotNull CheckerContext context) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrBuiltIns irBuiltIns = context.getIrBuiltIns();
        IrConstKind irConstKind = expression2.getKind();
        if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Null.INSTANCE)) {
            if (!IrTypeUtilsKt.isNullable(expression2.getType())) {
                context.error(expression2, "expected a nullable type, got " + RenderIrElementKt.render$default(expression2.getType(), null, 1, null));
            }
            return;
        }
        if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Boolean.INSTANCE)) {
            irType = irBuiltIns.getBooleanType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Char.INSTANCE)) {
            irType = irBuiltIns.getCharType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Byte.INSTANCE)) {
            irType = irBuiltIns.getByteType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Short.INSTANCE)) {
            irType = irBuiltIns.getShortType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Int.INSTANCE)) {
            irType = irBuiltIns.getIntType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Long.INSTANCE)) {
            irType = irBuiltIns.getLongType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.String.INSTANCE)) {
            irType = irBuiltIns.getStringType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Float.INSTANCE)) {
            irType = irBuiltIns.getFloatType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Double.INSTANCE)) {
            irType = irBuiltIns.getDoubleType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrType naturalType = irType;
    }
}

