/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.ExpectSymbolTransformer;
import org.jetbrains.kotlin.backend.jvm.FakeActualClassConstructorDescriptor;
import org.jetbrains.kotlin.backend.jvm.FakeActualClassDescriptor;
import org.jetbrains.kotlin.backend.jvm.FakeActualFunctionDescriptor;
import org.jetbrains.kotlin.backend.jvm.FakeActualPropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolverKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\nH\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\rH\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0010H\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0013H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\f\u0010\u001e\u001a\u00020\u001b*\u00020\u001fH\u0002J\u0014\u0010 \u001a\u00020!*\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/jvm/StubOrphanedExpectSymbolTransformer;", "Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer;", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;)V", "getStubGenerator", "()Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "stubbedClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "stubbedProperties", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer$ActualPropertyResult;", "stubbedConstructors", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "stubbedFunctions", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getActualClass", "descriptor", "getActualProperty", "getActualConstructor", "getActualFunction", "isTargetDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isOrphanedExpect", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "ensureClassParent", "", "backend.jvm.entrypoint"})
@SourceDebugExtension(value={"SMAP\nOrphanedExpectUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrphanedExpectUtils.kt\norg/jetbrains/kotlin/backend/jvm/StubOrphanedExpectSymbolTransformer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n384#2,7:143\n384#2,3:150\n387#2,4:154\n384#2,7:158\n384#2,7:165\n1#3:153\n*S KotlinDebug\n*F\n+ 1 OrphanedExpectUtils.kt\norg/jetbrains/kotlin/backend/jvm/StubOrphanedExpectSymbolTransformer\n*L\n45#1:143,7\n53#1:150,3\n53#1:154,4\n65#1:158,7\n73#1:165,7\n*E\n"})
final class StubOrphanedExpectSymbolTransformer
extends ExpectSymbolTransformer {
    @NotNull
    private final DeclarationStubGenerator stubGenerator;
    @NotNull
    private final Map<ClassDescriptor, IrClassSymbol> stubbedClasses;
    @NotNull
    private final Map<PropertyDescriptor, ExpectSymbolTransformer.ActualPropertyResult> stubbedProperties;
    @NotNull
    private final Map<ClassConstructorDescriptor, IrConstructorSymbol> stubbedConstructors;
    @NotNull
    private final Map<FunctionDescriptor, IrSimpleFunctionSymbol> stubbedFunctions;

    public StubOrphanedExpectSymbolTransformer(@NotNull DeclarationStubGenerator stubGenerator) {
        Intrinsics.checkNotNullParameter((Object)stubGenerator, (String)"stubGenerator");
        this.stubGenerator = stubGenerator;
        this.stubbedClasses = new LinkedHashMap();
        this.stubbedProperties = new LinkedHashMap();
        this.stubbedConstructors = new LinkedHashMap();
        this.stubbedFunctions = new LinkedHashMap();
    }

    @NotNull
    public final DeclarationStubGenerator getStubGenerator() {
        return this.stubGenerator;
    }

    @Override
    @Nullable
    protected IrClassSymbol getActualClass(@NotNull ClassDescriptor descriptor) {
        IrClassSymbol irClassSymbol;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.isOrphanedExpect(descriptor)) {
            return null;
        }
        Map<ClassDescriptor, IrClassSymbol> $this$getOrPut$iv = this.stubbedClasses;
        boolean $i$f$getOrPut = false;
        IrClassSymbol value$iv = $this$getOrPut$iv.get(descriptor);
        if (value$iv == null) {
            boolean bl = false;
            IrClassSymbol answer$iv = this.stubGenerator.generateClassStub(new FakeActualClassDescriptor(descriptor)).getSymbol();
            $this$getOrPut$iv.put(descriptor, answer$iv);
            irClassSymbol = answer$iv;
        } else {
            irClassSymbol = value$iv;
        }
        return irClassSymbol;
    }

    @Override
    @Nullable
    protected ExpectSymbolTransformer.ActualPropertyResult getActualProperty(@NotNull PropertyDescriptor descriptor) {
        ExpectSymbolTransformer.ActualPropertyResult actualPropertyResult;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.isOrphanedExpect(descriptor)) {
            return null;
        }
        Map<PropertyDescriptor, ExpectSymbolTransformer.ActualPropertyResult> $this$getOrPut$iv = this.stubbedProperties;
        boolean $i$f$getOrPut = false;
        ExpectSymbolTransformer.ActualPropertyResult value$iv = $this$getOrPut$iv.get(descriptor);
        if (value$iv == null) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
            IrProperty irProperty;
            boolean bl = false;
            IrProperty $this$getActualProperty_u24lambda_u243_u24lambda_u241 = irProperty = this.stubGenerator.generatePropertyStub(new FakeActualPropertyDescriptor(descriptor));
            boolean bl2 = false;
            this.ensureClassParent($this$getActualProperty_u24lambda_u243_u24lambda_u241, descriptor);
            IrProperty irProperty2 = irProperty;
            PropertyGetterDescriptor propertyGetterDescriptor = descriptor.getGetter();
            if (propertyGetterDescriptor != null) {
                FunctionDescriptor p0 = propertyGetterDescriptor;
                boolean bl3 = false;
                irSimpleFunctionSymbol2 = this.getActualFunction(p0);
            } else {
                irSimpleFunctionSymbol2 = null;
            }
            IrSimpleFunctionSymbol irGetter = irSimpleFunctionSymbol2;
            PropertySetterDescriptor propertySetterDescriptor = descriptor.getSetter();
            if (propertySetterDescriptor != null) {
                FunctionDescriptor p0 = propertySetterDescriptor;
                boolean bl4 = false;
                irSimpleFunctionSymbol = this.getActualFunction(p0);
            } else {
                irSimpleFunctionSymbol = null;
            }
            IrSimpleFunctionSymbol irSetter = irSimpleFunctionSymbol;
            ExpectSymbolTransformer.ActualPropertyResult answer$iv = new ExpectSymbolTransformer.ActualPropertyResult(irProperty2.getSymbol(), irGetter, irSetter);
            $this$getOrPut$iv.put(descriptor, answer$iv);
            actualPropertyResult = answer$iv;
        } else {
            actualPropertyResult = value$iv;
        }
        return actualPropertyResult;
    }

    @Override
    @Nullable
    protected IrConstructorSymbol getActualConstructor(@NotNull ClassConstructorDescriptor descriptor) {
        IrConstructorSymbol irConstructorSymbol;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.isOrphanedExpect(descriptor)) {
            return null;
        }
        Map<ClassConstructorDescriptor, IrConstructorSymbol> $this$getOrPut$iv = this.stubbedConstructors;
        boolean $i$f$getOrPut = false;
        IrConstructorSymbol value$iv = $this$getOrPut$iv.get(descriptor);
        if (value$iv == null) {
            boolean bl = false;
            IrConstructorSymbol answer$iv = this.stubGenerator.generateConstructorStub(new FakeActualClassConstructorDescriptor(descriptor)).getSymbol();
            $this$getOrPut$iv.put(descriptor, answer$iv);
            irConstructorSymbol = answer$iv;
        } else {
            irConstructorSymbol = value$iv;
        }
        return irConstructorSymbol;
    }

    @Override
    @Nullable
    protected IrSimpleFunctionSymbol getActualFunction(@NotNull FunctionDescriptor descriptor) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.isOrphanedExpect(descriptor)) {
            return null;
        }
        Map<FunctionDescriptor, IrSimpleFunctionSymbol> $this$getOrPut$iv = this.stubbedFunctions;
        boolean $i$f$getOrPut = false;
        IrSimpleFunctionSymbol value$iv = $this$getOrPut$iv.get(descriptor);
        if (value$iv == null) {
            IrSimpleFunction irSimpleFunction;
            boolean bl = false;
            IrSimpleFunction $this$getActualFunction_u24lambda_u246_u24lambda_u245 = irSimpleFunction = this.stubGenerator.generateFunctionStub(new FakeActualFunctionDescriptor(descriptor), false);
            boolean bl2 = false;
            this.ensureClassParent($this$getActualFunction_u24lambda_u246_u24lambda_u245, descriptor);
            IrSimpleFunctionSymbol answer$iv = irSimpleFunction.getSymbol();
            $this$getOrPut$iv.put(descriptor, answer$iv);
            irSimpleFunctionSymbol = answer$iv;
        } else {
            irSimpleFunctionSymbol = value$iv;
        }
        return irSimpleFunctionSymbol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isTargetDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (super.isTargetDeclaration(declaration)) return true;
        if (!(declaration instanceof IrSimpleFunction)) return false;
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
        Object object = irPropertySymbol;
        if (irPropertySymbol == null) return false;
        IrProperty irProperty = (IrProperty)object.getOwner();
        object = irProperty;
        if (irProperty == null) return false;
        if (!((IrProperty)object).isExpect()) return false;
        return true;
    }

    private final boolean isOrphanedExpect(MemberDescriptor $this$isOrphanedExpect) {
        return ExpectedActualResolverKt.findCompatibleActualsForExpected$default($this$isOrphanedExpect, DescriptorUtilsKt.getModule($this$isOrphanedExpect), null, 2, null).isEmpty();
    }

    private final void ensureClassParent(IrDeclaration $this$ensureClassParent, MemberDescriptor descriptor) {
        if (!($this$ensureClassParent.getParent() instanceof IrClass)) {
            IrClass irClass = this.stubGenerator.generateOrGetFacadeClass(descriptor);
            if (irClass == null) {
                return;
            }
            $this$ensureClassParent.setParent(irClass);
        }
    }
}

