/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatComparator;

public final class FloatArrays {
    public static final float[] EMPTY_ARRAY = new float[0];
    public static final float[] DEFAULT_EMPTY_ARRAY = new float[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<float[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(float[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void insertionSort(float[] a, int from2, int to, FloatComparator comp) {
        int i = from2;
        while (++i < to) {
            float t = a[i];
            int j = i;
            float u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void insertionSort(float[] a, int from2, int to) {
        int i = from2;
        while (++i < to) {
            float t = a[i];
            int j = i;
            float u = a[j - 1];
            while (Float.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void mergeSort(float[] a, int from2, int to, float[] supp) {
        int len = to - from2;
        if (len < 16) {
            FloatArrays.insertionSort(a, from2, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from2 + to >>> 1;
        FloatArrays.mergeSort(supp, from2, mid, a);
        FloatArrays.mergeSort(supp, mid, to, a);
        if (Float.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && Float.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from2, int to) {
        FloatArrays.mergeSort(a, from2, to, (float[])null);
    }

    public static void mergeSort(float[] a, int from2, int to, FloatComparator comp, float[] supp) {
        int len = to - from2;
        if (len < 16) {
            FloatArrays.insertionSort(a, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from2 + to >>> 1;
        FloatArrays.mergeSort(supp, from2, mid, comp, a);
        FloatArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from2, int to, FloatComparator comp) {
        FloatArrays.mergeSort(a, from2, to, comp, null);
    }

    public static void stableSort(float[] a, int from2, int to) {
        FloatArrays.mergeSort(a, from2, to);
    }

    public static void stableSort(float[] a) {
        FloatArrays.stableSort(a, 0, a.length);
    }

    public static void stableSort(float[] a, int from2, int to, FloatComparator comp) {
        FloatArrays.mergeSort(a, from2, to, comp);
    }

    public static void stableSort(float[] a, FloatComparator comp) {
        FloatArrays.stableSort(a, 0, a.length, comp);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<float[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(float[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(float[] a, float[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

