/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.SyntaxTreeBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParserUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class BasicModuleParser {
    private static final Set<String> STATEMENT_KEYWORDS = ContainerUtil.newHashSet("requires", "exports", "uses", "provides");
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicModuleParser(@NotNull BasicJavaParser parser) {
        if (parser == null) {
            BasicModuleParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = parser;
        this.myJavaElementTypeContainer = parser.getJavaElementTypeFactory().getContainer();
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker modifierList2;
        String text;
        if (builder == null) {
            BasicModuleParser.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker module2 = builder.mark();
        PsiBuilder.Marker firstAnnotation = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType type2 = builder.getTokenType();
        String string2 = text = type2 == JavaTokenType.IDENTIFIER ? builder.getTokenText() : null;
        if (!"open".equals(text) && !"module".equals(text)) {
            module2.rollbackTo();
            return null;
        }
        PsiBuilder.Marker marker = modifierList2 = firstAnnotation != null ? firstAnnotation.precede() : builder.mark();
        if ("open".equals(text)) {
            BasicModuleParser.mapAndAdvance(builder, JavaTokenType.OPEN_KEYWORD);
            text = builder.getTokenText();
        }
        BasicJavaParserUtil.done(modifierList2, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
        if (!"module".equals(text)) {
            module2.drop();
            BasicModuleParser.parseExtras(builder, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            return module2;
        }
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.MODULE_KEYWORD);
        if (this.parseName(builder) == null) {
            module2.drop();
            if (builder.getTokenType() != null) {
                BasicModuleParser.parseExtras(builder, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            return module2;
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACE)) {
            if (builder.getTokenType() != null) {
                BasicModuleParser.parseExtras(builder, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            }
        } else {
            this.parseModuleContent(builder);
        }
        BasicJavaParserUtil.done(module2, this.myJavaElementTypeContainer.MODULE, this.myWhiteSpaceAndCommentSetHolder);
        if (builder.getTokenType() != null) {
            BasicModuleParser.parseExtras(builder, JavaPsiBundle.message("unexpected.tokens", new Object[0]));
        }
        return module2;
    }

    private PsiBuilder.Marker parseName(PsiBuilder builder) {
        PsiBuilder.Marker nameElement = builder.mark();
        boolean empty = true;
        boolean idExpected = true;
        while (true) {
            IElementType t;
            if ((t = builder.getTokenType()) == JavaTokenType.IDENTIFIER) {
                if (!idExpected) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.dot", new Object[0]));
                }
                idExpected = false;
            } else {
                if (t != JavaTokenType.DOT) break;
                if (idExpected) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                idExpected = true;
            }
            builder.advanceLexer();
            empty = false;
        }
        if (!empty) {
            if (idExpected) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            nameElement.done(this.myJavaElementTypeContainer.MODULE_REFERENCE);
            return nameElement;
        }
        nameElement.drop();
        return null;
    }

    private void parseModuleContent(PsiBuilder builder) {
        IElementType token;
        SyntaxTreeBuilder.Marker invalid = null;
        while ((token = builder.getTokenType()) != null && token != JavaTokenType.RBRACE) {
            if (token == JavaTokenType.SEMICOLON) {
                if (invalid != null) {
                    invalid.error(JavaPsiBundle.message("expected.module.statement", new Object[0]));
                    invalid = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = this.parseStatement(builder);
            if (statement == null) {
                if (invalid == null) {
                    invalid = builder.mark();
                }
                builder.advanceLexer();
                continue;
            }
            if (invalid == null) continue;
            invalid.errorBefore(JavaPsiBundle.message("expected.module.statement", new Object[0]), statement);
            invalid = null;
        }
        if (invalid != null) {
            invalid.error(JavaPsiBundle.message("expected.module.statement", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACE) && invalid == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbrace", new Object[0]));
        }
    }

    private PsiBuilder.Marker parseStatement(PsiBuilder builder) {
        String kw = builder.getTokenText();
        if ("requires".equals(kw)) {
            return this.parseRequiresStatement(builder);
        }
        if ("exports".equals(kw)) {
            return this.parseExportsStatement(builder);
        }
        if ("opens".equals(kw)) {
            return this.parseOpensStatement(builder);
        }
        if ("uses".equals(kw)) {
            return this.parseUsesStatement(builder);
        }
        if ("provides".equals(kw)) {
            return this.parseProvidesStatement(builder);
        }
        return null;
    }

    private PsiBuilder.Marker parseRequiresStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.REQUIRES_KEYWORD);
        PsiBuilder.Marker modifierList2 = builder.mark();
        while (true) {
            if (PsiBuilderUtil.expect(builder, BasicElementTypes.BASIC_MODIFIER_BIT_SET)) {
                continue;
            }
            if (builder.getTokenType() != JavaTokenType.IDENTIFIER || !"transitive".equals(builder.getTokenText())) break;
            BasicModuleParser.mapAndAdvance(builder, JavaTokenType.TRANSITIVE_KEYWORD);
        }
        BasicJavaParserUtil.done(modifierList2, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
        if (this.parseNameRef(builder) != null) {
            BasicJavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.REQUIRES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseExportsStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.EXPORTS_KEYWORD);
        return this.parsePackageStatement(builder, statement, this.myJavaElementTypeContainer.EXPORTS_STATEMENT);
    }

    private PsiBuilder.Marker parseOpensStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.OPENS_KEYWORD);
        return this.parsePackageStatement(builder, statement, this.myJavaElementTypeContainer.OPENS_STATEMENT);
    }

    @NotNull
    private PsiBuilder.Marker parsePackageStatement(PsiBuilder builder, PsiBuilder.Marker statement, IElementType type2) {
        boolean hasError = false;
        if (this.parseClassOrPackageRef(builder) != null) {
            if ("to".equals(builder.getTokenText())) {
                PsiBuilder.Marker ref;
                BasicModuleParser.mapAndAdvance(builder, JavaTokenType.TO_KEYWORD);
                do {
                    ref = this.parseNameRef(builder);
                } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
                if (ref == null) {
                    hasError = true;
                }
            }
        } else {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.package.reference", new Object[0]));
            hasError = true;
        }
        if (!hasError) {
            BasicJavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement.done(type2);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicModuleParser.$$$reportNull$$$0(2);
        }
        return marker;
    }

    private PsiBuilder.Marker parseUsesStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.USES_KEYWORD);
        if (this.parseClassOrPackageRef(builder) != null) {
            BasicJavaParserUtil.semicolon(builder);
        } else {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.class.reference", new Object[0]));
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.USES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseProvidesStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        boolean hasError = false;
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.PROVIDES_KEYWORD);
        if (this.parseClassOrPackageRef(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.class.reference", new Object[0]));
            hasError = true;
        }
        if ("with".equals(builder.getTokenText())) {
            builder.remapCurrentToken(JavaTokenType.WITH_KEYWORD);
            hasError = this.myParser.getReferenceParser().parseReferenceList(builder, JavaTokenType.WITH_KEYWORD, this.myJavaElementTypeContainer.PROVIDES_WITH_LIST, JavaTokenType.COMMA);
        } else if (!hasError) {
            IElementType next = builder.getTokenType();
            if (next == JavaTokenType.IDENTIFIER && !STATEMENT_KEYWORDS.contains(builder.getTokenText())) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                marker.error(JavaPsiBundle.message("expected.with", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.with", new Object[0]));
            }
            hasError = true;
        }
        if (!hasError) {
            BasicJavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect(builder, JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.PROVIDES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseNameRef(PsiBuilder builder) {
        PsiBuilder.Marker name2 = this.parseName(builder);
        if (name2 == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
        }
        return name2;
    }

    private static void mapAndAdvance(PsiBuilder builder, IElementType keyword) {
        builder.remapCurrentToken(keyword);
        builder.advanceLexer();
    }

    private static void parseExtras(PsiBuilder builder, @NotNull String message2) {
        if (message2 == null) {
            BasicModuleParser.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker extras = builder.mark();
        while (builder.getTokenType() != null) {
            builder.advanceLexer();
        }
        extras.error(message2);
    }

    private PsiBuilder.Marker parseClassOrPackageRef(PsiBuilder builder) {
        return this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicModuleParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicModuleParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseExtras";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

