/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.diagnostics.AbstractTestDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u001f\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "platform", "", "withNewInference", "", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;Ljava/lang/String;Z)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getPlatform", "()Ljava/lang/String;", "inferenceCompatibility", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "getInferenceCompatibility", "()Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "setInferenceCompatibility", "(Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;)V", "name", "getName", "file", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/psi/PsiFile;", "compareTo", "", "other", "enhanceInferenceCompatibility", "", "equals", "", "hashCode", "toString", "frontend"})
public final class ActualDiagnostic
implements AbstractTestDiagnostic {
    @NotNull
    private final Diagnostic diagnostic;
    @Nullable
    private final String platform;
    @NotNull
    private TextDiagnostic.InferenceCompatibility inferenceCompatibility;

    public ActualDiagnostic(@NotNull Diagnostic diagnostic, @Nullable String platform, boolean withNewInference) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        this.diagnostic = diagnostic;
        this.platform = platform;
        this.inferenceCompatibility = withNewInference ? TextDiagnostic.InferenceCompatibility.NEW : TextDiagnostic.InferenceCompatibility.OLD;
    }

    @NotNull
    public final Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    @Override
    @Nullable
    public String getPlatform() {
        return this.platform;
    }

    @Override
    @NotNull
    public TextDiagnostic.InferenceCompatibility getInferenceCompatibility() {
        return this.inferenceCompatibility;
    }

    public void setInferenceCompatibility(@NotNull TextDiagnostic.InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkNotNullParameter((Object)((Object)inferenceCompatibility), (String)"<set-?>");
        this.inferenceCompatibility = inferenceCompatibility;
    }

    @Override
    @NotNull
    public String getName() {
        return this.diagnostic.getFactory().getName();
    }

    @NotNull
    public final PsiFile getFile() {
        return this.diagnostic.getPsiFile();
    }

    @Override
    public int compareTo(@NotNull AbstractTestDiagnostic other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.diagnostic instanceof DiagnosticWithParameters1 && other instanceof ActualDiagnostic && ((ActualDiagnostic)other).diagnostic instanceof DiagnosticWithParameters1 ? (this.getName() + ((DiagnosticWithParameters1)this.diagnostic).getA()).compareTo(((ActualDiagnostic)other).getName() + ((DiagnosticWithParameters1)((ActualDiagnostic)other).diagnostic).getA()) : (this.diagnostic instanceof DiagnosticWithParameters1 ? (this.getName() + ((DiagnosticWithParameters1)this.diagnostic).getA()).compareTo(other.getName()) : (other instanceof ActualDiagnostic && ((ActualDiagnostic)other).diagnostic instanceof DiagnosticWithParameters1 ? this.getName().compareTo(((ActualDiagnostic)other).getName() + ((DiagnosticWithParameters1)((ActualDiagnostic)other).diagnostic).getA()) : this.getName().compareTo(other.getName())));
    }

    @Override
    public void enhanceInferenceCompatibility(@NotNull TextDiagnostic.InferenceCompatibility inferenceCompatibility) {
        Intrinsics.checkNotNullParameter((Object)((Object)inferenceCompatibility), (String)"inferenceCompatibility");
        this.setInferenceCompatibility(inferenceCompatibility);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (!(other instanceof ActualDiagnostic)) {
            return false;
        }
        if (((ActualDiagnostic)other).diagnostic != this.diagnostic) return false;
        if (((ActualDiagnostic)other).getPlatform() == null) {
            if (this.getPlatform() != null) return false;
            bl = true;
        } else {
            bl = Intrinsics.areEqual((Object)((ActualDiagnostic)other).getPlatform(), (Object)this.getPlatform());
        }
        if (!bl) return false;
        if (((ActualDiagnostic)other).getInferenceCompatibility() != this.getInferenceCompatibility()) return false;
        return true;
    }

    public int hashCode() {
        int result2 = System.identityHashCode(this.diagnostic);
        String string2 = this.getPlatform();
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        result2 = 31 * result2 + this.getInferenceCompatibility().hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        String inferenceAbbreviation = this.getInferenceCompatibility().getAbbreviation$frontend();
        return (inferenceAbbreviation != null ? inferenceAbbreviation + ';' : "") + (this.getPlatform() != null ? this.getPlatform() + ':' : "") + this.diagnostic;
    }
}

