/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginUtil;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexId;
import org.jetbrains.kotlin.com.intellij.util.io.SimpleStringPersistentEnumerator;

public class ID<K, V>
extends IndexId<K, V> {
    private static final Logger LOG = Logger.getInstance(ID.class);
    private static volatile SimpleStringPersistentEnumerator ourNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
    private static final Map<String, ID<?, ?>> ourIdObjects = new ConcurrentHashMap();
    private static final Map<ID<?, ?>, PluginId> ourIdToPluginId = Collections.synchronizedMap(new HashMap());
    private static final Map<ID<?, ?>, Throwable> ourIdToRegistrationStackTrace = Collections.synchronizedMap(new HashMap());
    private volatile int myUniqueId;

    @ApiStatus.Internal
    @NotNull
    private static Path getEnumFile() {
        Path path = PathManager.getIndexRoot().resolve("indices.enum");
        if (path == null) {
            ID.$$$reportNull$$$0(0);
        }
        return path;
    }

    @ApiStatus.Internal
    public static void reloadEnumFile() {
        ID.reloadEnumFile(ID.getEnumFile());
    }

    private static void reloadEnumFile(@NotNull Path enumFile) {
        if (enumFile == null) {
            ID.$$$reportNull$$$0(1);
        }
        if (enumFile.equals(ourNameToIdRegistry.getFile())) {
            return;
        }
        SimpleStringPersistentEnumerator newNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
        Map<String, Integer> newInvertedState = newNameToIdRegistry.getInvertedState();
        Map<String, Integer> oldInvertedState = ourNameToIdRegistry.getInvertedState();
        oldInvertedState.forEach((oldKey, oldId) -> {
            Integer newId = (Integer)newInvertedState.get(oldKey);
            if (newId == null) {
                int createdId = newNameToIdRegistry.enumerate((String)oldKey);
                if (createdId != oldId) {
                    ID.reassign(oldKey, createdId);
                }
            } else if (oldId.intValue() != newId.intValue()) {
                ID.reassign(oldKey, newId);
            }
        });
        ourNameToIdRegistry = newNameToIdRegistry;
    }

    private static void reassign(String name2, int newId) {
        ID<?, ?> id = ourIdObjects.get(name2);
        if (id != null) {
            id.myUniqueId = newId;
        }
    }

    @ApiStatus.Internal
    protected ID(@NotNull String name2, @Nullable PluginId pluginId) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(2);
        }
        super(name2);
        this.myUniqueId = ID.stringToId(name2);
        ID old = ourIdObjects.put(name2, this);
        assert (old == null) : "ID with name '" + name2 + "' is already registered";
        PluginId oldPluginId = ourIdToPluginId.put(this, pluginId);
        assert (oldPluginId == null) : "ID with name '" + name2 + "' is already registered in " + oldPluginId + " but current caller is " + pluginId;
        ourIdToRegistrationStackTrace.put(this, new Throwable());
    }

    private static int stringToId(@NotNull String name2) {
        int id;
        if (name2 == null) {
            ID.$$$reportNull$$$0(3);
        }
        if ((id = ourNameToIdRegistry.enumerate(name2)) != (short)id) {
            throw new AssertionError((Object)"Too many indexes registered");
        }
        return id;
    }

    @NotNull
    public static synchronized <K, V> ID<K, V> create(@NonNls @NotNull String name2) {
        PluginId pluginId;
        ID<K, V> found;
        if (name2 == null) {
            ID.$$$reportNull$$$0(4);
        }
        ID<K, V> iD = (found = ID.findByName(name2, true, pluginId = ID.getCallerPluginId())) == null ? new ID<K, V>(name2, pluginId) : found;
        if (iD == null) {
            ID.$$$reportNull$$$0(5);
        }
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name2) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(6);
        }
        return ID.findByName(name2, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected static <K, V> ID<K, V> findByName(@NotNull String name2, boolean checkCallerPlugin, @Nullable PluginId requiredPluginId) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(7);
        }
        ID<?, ?> id = ID.findById(ID.stringToId(name2));
        if (checkCallerPlugin && id != null) {
            String requiredPluginIdStr;
            PluginId actualPluginId = ourIdToPluginId.get(id);
            String actualPluginIdStr = actualPluginId == null ? "IJ Core" : actualPluginId.getIdString();
            String string2 = requiredPluginIdStr = requiredPluginId == null ? "IJ Core" : requiredPluginId.getIdString();
            if (!Objects.equals(actualPluginIdStr, requiredPluginIdStr)) {
                Throwable registrationStackTrace = ourIdToRegistrationStackTrace.get(id);
                String message2 = ID.getInvalidIdAccessMessage(name2, actualPluginIdStr, requiredPluginIdStr, registrationStackTrace);
                if (registrationStackTrace != null) {
                    throw new AssertionError(message2, registrationStackTrace);
                }
                throw new AssertionError((Object)message2);
            }
        }
        return id;
    }

    @NotNull
    private static String getInvalidIdAccessMessage(@NotNull String name2, @Nullable String actualPluginIdStr, @Nullable String requiredPluginIdStr, @Nullable Throwable registrationStackTrace) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(8);
        }
        String string2 = "ID with name '" + name2 + "' requested for plugin " + requiredPluginIdStr + " but registered for " + actualPluginIdStr + " plugin. Please use an instance field to access corresponding ID." + (registrationStackTrace == null ? " Registration stack trace: " : "");
        if (string2 == null) {
            ID.$$$reportNull$$$0(9);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static Collection<ID<?, ?>> getRegisteredIds() {
        Map<ID<?, ?>, PluginId> map = ourIdToPluginId;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet(ourIdToPluginId.keySet()));
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Throwable getRegistrationTrace() {
        Throwable throwable = ourIdToRegistrationStackTrace.get(this);
        if (throwable == null) {
            ID.$$$reportNull$$$0(10);
        }
        return throwable;
    }

    @ApiStatus.Internal
    public int getUniqueId() {
        return this.myUniqueId;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginId getPluginId() {
        return ourIdToPluginId.get(this);
    }

    @ApiStatus.Internal
    public static ID<?, ?> findById(int id) {
        String key = ourNameToIdRegistry.valueOf(id);
        return key == null ? null : ourIdObjects.get(key);
    }

    @ApiStatus.Internal
    @Nullable
    protected static PluginId getCallerPluginId() {
        return PluginUtil.getInstance().getCallerPlugin(4);
    }

    @ApiStatus.Internal
    public static synchronized void unloadId(@NotNull ID<?, ?> id) {
        if (id == null) {
            ID.$$$reportNull$$$0(11);
        }
        String name2 = id.getName();
        ID<?, ?> oldID = ourIdObjects.remove(name2);
        LOG.assertTrue(id.equals(oldID), "Failed to unload: " + name2);
        ourIdToPluginId.remove(id);
        ourIdToRegistrationStackTrace.remove(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/ID";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIdAccessMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationTrace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reloadEnumFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stringToId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidIdAccessMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unloadId";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

