/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/ir/ir.tree/tree-generator/ReadMe.md.
// DO NOT MODIFY IT MANUALLY.

package org.jetbrains.kotlin.ir.util

import org.jetbrains.kotlin.ir.symbols.*

/**
 * Auto-generated by [org.jetbrains.kotlin.ir.generator.print.symbol.ReferencedSymbolVisitorInterfacePrinter]
 */
interface ReferencedSymbolVisitor {

    fun visitReferencedClass(symbol: IrClassSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedProperty(symbol: IrPropertySymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedScript(symbol: IrScriptSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedConstructor(symbol: IrConstructorSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedEnumEntry(symbol: IrEnumEntrySymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedFunction(symbol: IrFunctionSymbol) {
        when (symbol) {
            is IrConstructorSymbol -> visitReferencedConstructor(symbol)
            is IrSimpleFunctionSymbol -> visitReferencedSimpleFunction(symbol)
        }
    }

    fun visitReferencedSimpleFunction(symbol: IrSimpleFunctionSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedField(symbol: IrFieldSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedLocalDelegatedProperty(symbol: IrLocalDelegatedPropertySymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedVariable(symbol: IrVariableSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedDeclarationWithAccessors(symbol: IrDeclarationWithAccessorsSymbol) {
        when (symbol) {
            is IrPropertySymbol -> visitReferencedProperty(symbol)
            is IrLocalDelegatedPropertySymbol -> visitReferencedLocalDelegatedProperty(symbol)
        }
    }

    fun visitReferencedClassifier(symbol: IrClassifierSymbol) {
        when (symbol) {
            is IrClassSymbol -> visitReferencedClass(symbol)
            is IrScriptSymbol -> visitReferencedScript(symbol)
            is IrTypeParameterSymbol -> visitReferencedTypeParameter(symbol)
        }
    }

    fun visitReferencedTypeParameter(symbol: IrTypeParameterSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedReturnTarget(symbol: IrReturnTargetSymbol) {
        when (symbol) {
            is IrFunctionSymbol -> visitReferencedFunction(symbol)
            is IrReturnableBlockSymbol -> visitReferencedReturnableBlock(symbol)
        }
    }

    fun visitReferencedReturnableBlock(symbol: IrReturnableBlockSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedValue(symbol: IrValueSymbol) {
        when (symbol) {
            is IrValueParameterSymbol -> visitReferencedValueParameter(symbol)
            is IrVariableSymbol -> visitReferencedVariable(symbol)
        }
    }

    fun visitReferencedValueParameter(symbol: IrValueParameterSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedTypeAlias(symbol: IrTypeAliasSymbol) { visitReferencedSymbol(symbol) }

    fun visitReferencedSymbol(symbol: IrSymbol)
}
