/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.SecondaryCtorLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallsiteRedirectionTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "defaultThrowableConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "isSecondaryConstructorCall", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)Z", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "data", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "replaceSecondaryConstructorWithFactoryFunction", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "call", "newTarget", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nSecondaryCtorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecondaryCtorLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/CallsiteRedirectionTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,327:1\n1#2:328\n*E\n"})
final class CallsiteRedirectionTransformer
extends IrTransformer<IrFunction> {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrConstructorSymbol defaultThrowableConstructor;

    public CallsiteRedirectionTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.defaultThrowableConstructor = this.context.getDefaultThrowableCtor();
    }

    private final boolean isSecondaryConstructorCall(IrConstructor $this$isSecondaryConstructorCall) {
        return !$this$isSecondaryConstructorCall.isPrimary() && !Intrinsics.areEqual((Object)$this$isSecondaryConstructorCall, (Object)this.defaultThrowableConstructor) && !$this$isSecondaryConstructorCall.isExternal() && !this.context.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass($this$isSecondaryConstructorCall));
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @Nullable IrFunction data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return super.visitFunction(declaration, declaration);
    }

    @Override
    @NotNull
    public IrFunctionAccessExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrFunction data) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitConstructorCall(expression2, data);
        IrConstructor target = (IrConstructor)expression2.getSymbol().getOwner();
        if (this.isSecondaryConstructorCall(target)) {
            IrSimpleFunction factory = SecondaryCtorLoweringKt.access$buildConstructorFactory(this.context, target, IrUtilsKt.getParentAsClass(target));
            irFunctionAccessExpression = this.replaceSecondaryConstructorWithFactoryFunction(expression2, factory.getSymbol());
        } else {
            irFunctionAccessExpression = expression2;
        }
        return irFunctionAccessExpression;
    }

    @Override
    @NotNull
    public IrFunctionAccessExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrFunction data) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitDelegatingConstructorCall(expression2, data);
        IrConstructor target = (IrConstructor)expression2.getSymbol().getOwner();
        if (this.isSecondaryConstructorCall(target)) {
            IrCall irCall;
            IrGetValueImpl irGetValueImpl;
            IrClass klass = IrUtilsKt.getParentAsClass(target);
            IrSimpleFunction delegate = SecondaryCtorLoweringKt.access$buildConstructorDelegate(this.context, target, klass);
            IrCall newCall = this.replaceSecondaryConstructorWithFactoryFunction(expression2, delegate.getSymbol());
            IrDelegatingConstructorCall $this$visitDelegatingConstructorCall_u24lambda_u240 = expression2;
            boolean bl = false;
            IrFunction irFunction = data;
            if (irFunction instanceof IrConstructor) {
                IrValueParameter irValueParameter = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)data).getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter);
                IrValueParameter thisReceiver = irValueParameter;
                irGetValueImpl = BuildersKt.IrGetValueImpl$default($this$visitDelegatingConstructorCall_u24lambda_u240.getStartOffset(), $this$visitDelegatingConstructorCall_u24lambda_u240.getEndOffset(), thisReceiver.getType(), thisReceiver.getSymbol(), null, 16, null);
            } else if (irFunction instanceof IrSimpleFunction) {
                IrValueParameter lastValueParameter = (IrValueParameter)CollectionsKt.last(((IrSimpleFunction)data).getParameters());
                irGetValueImpl = BuildersKt.IrGetValueImpl$default($this$visitDelegatingConstructorCall_u24lambda_u240.getStartOffset(), $this$visitDelegatingConstructorCall_u24lambda_u240.getEndOffset(), lastValueParameter.getType(), lastValueParameter.getSymbol(), null, 16, null);
            } else {
                if (irFunction == null) {
                    CompilationExceptionKt.compilationException("Parent function can't be null", expression2);
                    throw new KotlinNothingValueException();
                }
                throw new NoWhenBranchMatchedException();
            }
            IrGetValueImpl readThis = irGetValueImpl;
            IrCall $this$visitDelegatingConstructorCall_u24lambda_u241 = irCall = newCall;
            boolean bl2 = false;
            $this$visitDelegatingConstructorCall_u24lambda_u241.getArguments().add(readThis);
            irFunctionAccessExpression = irCall;
        } else {
            irFunctionAccessExpression = expression2;
        }
        return irFunctionAccessExpression;
    }

    private final IrCall replaceSecondaryConstructorWithFactoryFunction(IrFunctionAccessExpression call2, IrSimpleFunctionSymbol newTarget) {
        IrClass irClass = IrUtilsKt.getParentAsClass(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        Object object = irClass.getSymbol();
        IrClassSymbol irClassSymbol = object;
        IrStatementOrigin irStatementOrigin = null;
        int n2 = call2.getTypeArguments().size();
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = newTarget;
        IrType irType = call2.getType();
        int n3 = call2.getEndOffset();
        int n4 = call2.getStartOffset();
        boolean bl = false;
        boolean bl2 = this.context.getEs6mode() && ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement(call2);
        Object $this$replaceSecondaryConstructorWithFactoryFunction_u24lambda_u243 = object = BuildersKt.IrCallImpl$default(n4, n3, irType, irSimpleFunctionSymbol, n2, irStatementOrigin, (IrClassSymbol)(bl2 ? object : null), 32, null);
        boolean bl3 = false;
        IrExpressionsKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$replaceSecondaryConstructorWithFactoryFunction_u24lambda_u243, call2, 0, 2, null);
        AddToStdlibKt.assignFrom(((IrMemberAccessExpression)$this$replaceSecondaryConstructorWithFactoryFunction_u24lambda_u243).getArguments(), call2.getArguments());
        return (IrCall)object;
    }
}

