/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilderKt;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstrWithLocation;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010 \u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\"\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010$\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J8\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100.H\u0086\b\u00f8\u0001\u0000J6\u0010/\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010*\u001a\u0004\u0018\u0001002\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100.H\u0086\b\u00f8\u0001\u0000J6\u00101\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010*\u001a\u0004\u0018\u0001002\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100.H\u0086\b\u00f8\u0001\u0000J)\u00102\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0002\u00a2\u0006\u0002\u00103J\u001c\u00104\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010*\u001a\u0004\u0018\u000100J\u0012\u00105\u001a\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0012\u0010/\u001a\u00020\u000e2\n\b\u0002\u0010*\u001a\u0004\u0018\u000100J\u0012\u00106\u001a\u00020\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001e\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J>\u0010:\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010@\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010A\u001a\u00020\u00102\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010C\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010D\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010*\u001a\u0004\u0018\u000100J*\u0010E\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020H0G2\n\b\u0002\u0010*\u001a\u0004\u0018\u000100J\u001c\u0010I\u001a\u00020H2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u00109\u001a\u00020\u000eJ\u000e\u0010J\u001a\u00020H2\u0006\u00109\u001a\u00020\u000eJ\u000e\u0010K\u001a\u00020H2\u0006\u00109\u001a\u00020\u000eJ*\u0010L\u001a\u00020H2\u0006\u0010M\u001a\u00020N2\u0006\u00109\u001a\u00020\u000e2\u0010\b\u0002\u0010B\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010%H\u0002J\u001e\u0010O\u001a\u00020\u00102\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0006\u0010P\u001a\u00020\u0010J\u0016\u0010Q\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010R\u001a\u00020\u00102\f\u0010S\u001a\b\u0012\u0004\u0012\u00020T0%2\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010U\u001a\u00020\u00102\f\u0010S\u001a\b\u0012\u0004\u0012\u00020,0%2\u000e\b\u0002\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000e0+2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010W\u001a\u00020\u00102\u0006\u0010X\u001a\u00020Y2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010Z\u001a\u00020\u00102\u0006\u0010X\u001a\u00020Y2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010[\u001a\u00020\u00102\u0006\u0010X\u001a\u00020Y2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\\\u001a\u00020\u00102\f\u0010]\u001a\b\u0012\u0004\u0012\u00020^0%2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010_\u001a\u00020\u00102\f\u0010]\u001a\b\u0012\u0004\u0012\u00020^0%2\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010`\u001a\u00020\u00102\f\u0010a\u001a\b\u0012\u0004\u0012\u00020b0%2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010d\u001a\u00020\u00102\f\u0010a\u001a\b\u0012\u0004\u0012\u00020b0%2\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010e\u001a\u00020\u00102\f\u0010a\u001a\b\u0012\u0004\u0012\u00020b0%2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010f\u001a\u00020\u00102\f\u0010g\u001a\b\u0012\u0004\u0012\u00020b0+2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010h\u001a\u00020\u00102\f\u0010g\u001a\b\u0012\u0004\u0012\u00020b0+2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010i\u001a\u00020\u00102\f\u0010g\u001a\b\u0012\u0004\u0012\u00020b0+2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010j\u001a\u00020\u00102\u0006\u0010k\u001a\u00020>2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010l\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010m\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010n\u001a\u00020\u00102\f\u0010o\u001a\b\u0012\u0004\u0012\u00020)0pH\u0086\b\u00f8\u0001\u0000J\u001a\u0010q\u001a\u00020\u00102\f\u0010o\u001a\b\u0012\u0004\u0012\u00020)0pH\u0086\b\u00f8\u0001\u0000J\u0006\u0010r\u001a\u00020\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006s"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "", "expression", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "skipCommentInstructions", "", "<init>", "(Ljava/util/List;Z)V", "getExpression", "()Ljava/util/List;", "getSkipCommentInstructions", "()Z", "_numberOfNestedBlocks", "", "buildInstr", "", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "numberOfNestedBlocks", "getNumberOfNestedBlocks", "()I", "buildConstI32", "value", "buildConstI64", "", "buildConstF32", "", "buildConstF64", "", "buildConstI32Symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "buildUnreachable", "buildFunctionTypedBlock", "label", "", "resultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "body", "Lkotlin/Function1;", "buildBlock", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "buildLoop", "buildInstrWithNoLocation", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildIf", "buildElse", "buildEnd", "buildBrInstr", "brOp", "absoluteBlockLevel", "buildBrOnCastInstr", "fromIsNullable", "toIsNullable", "from", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "to", "buildBr", "buildThrow", "tagIdx", "buildThrowRef", "buildTry", "buildTryTable", "catches", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch;", "createNewCatch", "createNewCatchAll", "createNewCatchAllRef", "createNewCatchImmediate", "catchType", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch$CatchType;", "buildCatch", "buildCatchAll", "buildBrIf", "buildCall", "symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "buildCallIndirect", "tableIdx", "buildGetLocal", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "buildSetLocal", "buildTeeLocal", "buildGetGlobal", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "buildSetGlobal", "buildStructGet", "struct", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "fieldId", "buildStructNew", "buildStructSet", "buildRefCastNullStatic", "toType", "buildRefCastStatic", "buildRefTestStatic", "buildRefNull", "type", "buildDrop", "buildNop", "commentPreviousInstr", "text", "Lkotlin/Function0;", "commentGroupStart", "commentGroupEnd", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,329:1\n1#2:330\n37#3:331\n36#3,3:332\n*S KotlinDebug\n*F\n+ 1 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n*L\n177#1:331\n177#1:332,3\n*E\n"})
public final class WasmExpressionBuilder {
    @NotNull
    private final List<WasmInstr> expression;
    private final boolean skipCommentInstructions;
    private int _numberOfNestedBlocks;

    public WasmExpressionBuilder(@NotNull List<WasmInstr> expression2, boolean skipCommentInstructions) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        this.expression = expression2;
        this.skipCommentInstructions = skipCommentInstructions;
    }

    public /* synthetic */ WasmExpressionBuilder(List list, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(list, bl);
    }

    @NotNull
    public final List<WasmInstr> getExpression() {
        return this.expression;
    }

    public final boolean getSkipCommentInstructions() {
        return this.skipCommentInstructions;
    }

    public final void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location, WasmImmediate ... immediates) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)immediates, (String)"immediates");
        if (WasmExpressionBuilderKt.isBlockStart(op)) {
            int n2 = this._numberOfNestedBlocks;
            this._numberOfNestedBlocks = n2 + 1;
        } else if (WasmExpressionBuilderKt.isBlockEnd(op)) {
            int n3 = this._numberOfNestedBlocks;
            this._numberOfNestedBlocks = n3 + -1;
        }
        ((Collection)this.expression).add(new WasmInstrWithLocation(op, (List<? extends WasmImmediate>)ArraysKt.toList((Object[])immediates), location));
    }

    public final int getNumberOfNestedBlocks() {
        return this._numberOfNestedBlocks;
    }

    public final void buildConstI32(int value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI32(value2)};
        this.buildInstr(WasmOp.I32_CONST, location, wasmImmediateArray);
    }

    public final void buildConstI64(long value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI64(value2)};
        this.buildInstr(WasmOp.I64_CONST, location, wasmImmediateArray);
    }

    public final void buildConstF32(float value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstF32(UInt.constructor-impl((int)Float.floatToRawIntBits(value2)), null)};
        this.buildInstr(WasmOp.F32_CONST, location, wasmImmediateArray);
    }

    public final void buildConstF64(double value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstF64(ULong.constructor-impl((long)Double.doubleToRawLongBits(value2)), null)};
        this.buildInstr(WasmOp.F64_CONST, location, wasmImmediateArray);
    }

    public final void buildConstI32Symbol(@NotNull WasmSymbol<Integer> value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.SymbolI32(value2)};
        this.buildInstr(WasmOp.I32_CONST, location, wasmImmediateArray);
    }

    public final void buildUnreachable(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.UNREACHABLE, location, new WasmImmediate[0]);
    }

    public final void buildFunctionTypedBlock(@Nullable String label, @NotNull WasmSymbolReadOnly<WasmFunctionType> resultType, @NotNull Function1<? super Integer, Unit> body) {
        Intrinsics.checkNotNullParameter(resultType, (String)"resultType");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$buildFunctionTypedBlock = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Function(resultType)};
        this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        body.invoke((Object)this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default(this, null, 1, null);
    }

    public final void buildBlock(@Nullable String label, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$buildBlock = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        body.invoke((Object)this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default(this, null, 1, null);
    }

    public static /* synthetic */ void buildBlock$default(WasmExpressionBuilder $this, String label, WasmType resultType, Function1 body, int n2, Object wasmImmediateArray) {
        if ((n2 & 2) != 0) {
            resultType = null;
        }
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        boolean $i$f$buildBlock = false;
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        $this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        body.invoke((Object)$this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default($this, null, 1, null);
    }

    public final void buildLoop(@Nullable String label, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$buildLoop = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        body.invoke((Object)this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default(this, null, 1, null);
    }

    public static /* synthetic */ void buildLoop$default(WasmExpressionBuilder $this, String label, WasmType resultType, Function1 body, int n2, Object wasmImmediateArray) {
        if ((n2 & 2) != 0) {
            resultType = null;
        }
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        boolean $i$f$buildLoop = false;
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        $this.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        body.invoke((Object)$this.getNumberOfNestedBlocks());
        WasmExpressionBuilder.buildEnd$default($this, null, 1, null);
    }

    private final void buildInstrWithNoLocation(WasmOp op, WasmImmediate ... immediates) {
        this.buildInstr(op, SourceLocation.Companion.NoLocation(op.getMnemonic()), Arrays.copyOf(immediates, immediates.length));
    }

    public final void buildIf(@Nullable String label, @Nullable WasmType resultType) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.IF, wasmImmediateArray);
    }

    public static /* synthetic */ void buildIf$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildIf(string, wasmType);
    }

    public final void buildElse(@Nullable SourceLocation location) {
        if (location != null) {
            this.buildInstr(WasmOp.ELSE, location, new WasmImmediate[0]);
        } else {
            this.buildInstrWithNoLocation(WasmOp.ELSE, new WasmImmediate[0]);
        }
    }

    public static /* synthetic */ void buildElse$default(WasmExpressionBuilder wasmExpressionBuilder, SourceLocation sourceLocation, int n2, Object object) {
        if ((n2 & 1) != 0) {
            sourceLocation = null;
        }
        wasmExpressionBuilder.buildElse(sourceLocation);
    }

    public final int buildBlock(@Nullable WasmType resultType) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.BLOCK, wasmImmediateArray);
        return this.getNumberOfNestedBlocks();
    }

    public static /* synthetic */ int buildBlock$default(WasmExpressionBuilder wasmExpressionBuilder, WasmType wasmType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            wasmType = null;
        }
        return wasmExpressionBuilder.buildBlock(wasmType);
    }

    public final void buildEnd(@Nullable SourceLocation location) {
        if (location != null) {
            this.buildInstr(WasmOp.END, location, new WasmImmediate[0]);
        } else {
            this.buildInstrWithNoLocation(WasmOp.END, new WasmImmediate[0]);
        }
    }

    public static /* synthetic */ void buildEnd$default(WasmExpressionBuilder wasmExpressionBuilder, SourceLocation sourceLocation, int n2, Object object) {
        if ((n2 & 1) != 0) {
            sourceLocation = null;
        }
        wasmExpressionBuilder.buildEnd(sourceLocation);
    }

    public final void buildBrInstr(@NotNull WasmOp brOp, int absoluteBlockLevel, @NotNull SourceLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)brOp), (String)"brOp");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Negative relative block index";
            throw new AssertionError((Object)string);
        }
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LabelIdx(relativeLevel)};
        this.buildInstr(brOp, location, wasmImmediateArray);
    }

    public final void buildBrOnCastInstr(@NotNull WasmOp brOp, int absoluteBlockLevel, boolean fromIsNullable, boolean toIsNullable, @NotNull WasmHeapType from2, @NotNull WasmHeapType to, @NotNull SourceLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)brOp), (String)"brOp");
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22 = false;
            String $i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22 = "Negative relative block index";
            throw new AssertionError((Object)$i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22);
        }
        int fromTypeFlag = fromIsNullable ? 1 : 0;
        int toTypeFlag = toIsNullable ? 2 : 0;
        int flags = fromTypeFlag | toTypeFlag;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstU8(UByte.constructor-impl((byte)((byte)flags)), null), new WasmImmediate.LabelIdx(relativeLevel), new WasmImmediate.HeapType(from2), new WasmImmediate.HeapType(to)};
        this.buildInstr(brOp, location, wasmImmediateArray);
    }

    public final void buildBr(int absoluteBlockLevel, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildBrInstr(WasmOp.BR, absoluteBlockLevel, location);
    }

    public final void buildThrow(@NotNull WasmSymbol<Integer> tagIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(tagIdx, (String)"tagIdx");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TagIdx(tagIdx)};
        this.buildInstr(WasmOp.THROW, location, wasmImmediateArray);
    }

    public final void buildThrowRef(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.THROW_REF, location, new WasmImmediate[0]);
    }

    public final void buildTry(@Nullable String label, @Nullable WasmType resultType) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.TRY, wasmImmediateArray);
    }

    public static /* synthetic */ void buildTry$default(WasmExpressionBuilder wasmExpressionBuilder, String string, WasmType wasmType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildTry(string, wasmType);
    }

    public final void buildTryTable(@Nullable String label, @NotNull List<WasmImmediate.Catch> catches, @Nullable WasmType resultType) {
        Intrinsics.checkNotNullParameter(catches, (String)"catches");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)new WasmImmediate.BlockType.Value(resultType));
        spreadBuilder.add((Object)new WasmImmediate.ConstI32(catches.size()));
        Collection $this$toTypedArray$iv = catches;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new WasmImmediate.Catch[0]));
        this.buildInstrWithNoLocation(WasmOp.TRY_TABLE, (WasmImmediate[])spreadBuilder.toArray((Object[])new WasmImmediate[spreadBuilder.size()]));
    }

    public static /* synthetic */ void buildTryTable$default(WasmExpressionBuilder wasmExpressionBuilder, String string, List list, WasmType wasmType, int n2, Object object) {
        if ((n2 & 4) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildTryTable(string, list, wasmType);
    }

    @NotNull
    public final WasmImmediate.Catch createNewCatch(@NotNull WasmSymbol<Integer> tagIdx, int absoluteBlockLevel) {
        Intrinsics.checkNotNullParameter(tagIdx, (String)"tagIdx");
        return this.createNewCatchImmediate(WasmImmediate.Catch.CatchType.CATCH, absoluteBlockLevel, tagIdx);
    }

    @NotNull
    public final WasmImmediate.Catch createNewCatchAll(int absoluteBlockLevel) {
        return WasmExpressionBuilder.createNewCatchImmediate$default(this, WasmImmediate.Catch.CatchType.CATCH_ALL, absoluteBlockLevel, null, 4, null);
    }

    @NotNull
    public final WasmImmediate.Catch createNewCatchAllRef(int absoluteBlockLevel) {
        return WasmExpressionBuilder.createNewCatchImmediate$default(this, WasmImmediate.Catch.CatchType.CATCH_ALL_REF, absoluteBlockLevel, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final WasmImmediate.Catch createNewCatchImmediate(WasmImmediate.Catch.CatchType catchType, int absoluteBlockLevel, WasmSymbol<Integer> tagIdx) {
        WasmImmediate.TableIdx tableIdx;
        Object[] objectArray;
        boolean bl;
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Negative relative block index";
            throw new AssertionError((Object)string);
        }
        WasmImmediate.Catch.CatchType catchType2 = catchType;
        Object[] objectArray2 = objectArray = new WasmImmediate[2];
        int n2 = 0;
        WasmSymbol<Integer> wasmSymbol = tagIdx;
        if (wasmSymbol != null) {
            void p0;
            WasmSymbolReadOnly wasmSymbolReadOnly = wasmSymbol;
            int n3 = n2;
            Object[] objectArray3 = objectArray2;
            WasmImmediate.Catch.CatchType catchType3 = catchType2;
            boolean bl4 = false;
            WasmImmediate.TableIdx tableIdx2 = new WasmImmediate.TableIdx((WasmSymbolReadOnly<Integer>)p0);
            catchType2 = catchType3;
            objectArray2 = objectArray3;
            n2 = n3;
            tableIdx = tableIdx2;
        } else {
            tableIdx = null;
        }
        objectArray2[n2] = tableIdx;
        objectArray[1] = new WasmImmediate.LabelIdx(relativeLevel);
        List list = CollectionsKt.listOfNotNull((Object[])objectArray);
        WasmImmediate.Catch.CatchType catchType4 = catchType2;
        return new WasmImmediate.Catch(catchType4, list);
    }

    static /* synthetic */ WasmImmediate.Catch createNewCatchImmediate$default(WasmExpressionBuilder wasmExpressionBuilder, WasmImmediate.Catch.CatchType catchType, int n2, WasmSymbol wasmSymbol, int n3, Object object) {
        if ((n3 & 4) != 0) {
            wasmSymbol = null;
        }
        return wasmExpressionBuilder.createNewCatchImmediate(catchType, n2, wasmSymbol);
    }

    public final void buildCatch(@NotNull WasmSymbol<Integer> tagIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(tagIdx, (String)"tagIdx");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TagIdx(tagIdx)};
        this.buildInstr(WasmOp.CATCH, location, wasmImmediateArray);
    }

    public static /* synthetic */ void buildCatch$default(WasmExpressionBuilder wasmExpressionBuilder, WasmSymbol wasmSymbol, SourceLocation sourceLocation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            sourceLocation = SourceLocation.Companion.NoLocation("Catch");
        }
        wasmExpressionBuilder.buildCatch(wasmSymbol, sourceLocation);
    }

    public final void buildCatchAll() {
        this.buildInstrWithNoLocation(WasmOp.CATCH_ALL, new WasmImmediate[0]);
    }

    public final void buildBrIf(int absoluteBlockLevel, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildBrInstr(WasmOp.BR_IF, absoluteBlockLevel, location);
    }

    public final void buildCall(@NotNull WasmSymbol<? extends WasmFunction> symbol, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(symbol)};
        this.buildInstr(WasmOp.CALL, location, wasmImmediateArray);
    }

    public final void buildCallIndirect(@NotNull WasmSymbol<WasmFunctionType> symbol, @NotNull WasmSymbolReadOnly<Integer> tableIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter(tableIdx, (String)"tableIdx");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)symbol), new WasmImmediate.TableIdx(tableIdx)};
        this.buildInstr(WasmOp.CALL_INDIRECT, location, wasmImmediateArray);
    }

    public static /* synthetic */ void buildCallIndirect$default(WasmExpressionBuilder wasmExpressionBuilder, WasmSymbol wasmSymbol, WasmSymbolReadOnly wasmSymbolReadOnly, SourceLocation sourceLocation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            wasmSymbolReadOnly = new WasmSymbol<Integer>(0);
        }
        wasmExpressionBuilder.buildCallIndirect(wasmSymbol, wasmSymbolReadOnly, sourceLocation);
    }

    public final void buildGetLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_GET, location, wasmImmediateArray);
    }

    public final void buildSetLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_SET, location, wasmImmediateArray);
    }

    public final void buildTeeLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_TEE, location, wasmImmediateArray);
    }

    public final void buildGetGlobal(@NotNull WasmSymbol<WasmGlobal> global, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(global, (String)"global");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_GET, location, wasmImmediateArray);
    }

    public final void buildSetGlobal(@NotNull WasmSymbol<WasmGlobal> global, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(global, (String)"global");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_SET, location, wasmImmediateArray);
    }

    public final void buildStructGet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter(fieldId, (String)"fieldId");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_GET, location, wasmImmediateArray);
    }

    public final void buildStructNew(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct)};
        this.buildInstr(WasmOp.STRUCT_NEW, location, wasmImmediateArray);
    }

    public final void buildStructSet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, (String)"struct");
        Intrinsics.checkNotNullParameter(fieldId, (String)"fieldId");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_SET, location, wasmImmediateArray);
    }

    public final void buildRefCastNullStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_CAST_NULL, location, wasmImmediateArray);
    }

    public final void buildRefCastStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_CAST, location, wasmImmediateArray);
    }

    public final void buildRefTestStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, (String)"toType");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_TEST, location, wasmImmediateArray);
    }

    public final void buildRefNull(@NotNull WasmHeapType type, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmRefType(type))};
        this.buildInstr(WasmOp.REF_NULL, location, wasmImmediateArray);
    }

    public final void buildDrop(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.DROP, location, new WasmImmediate[0]);
    }

    public final void buildNop(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.buildInstr(WasmOp.NOP, location, new WasmImmediate[0]);
    }

    public final void commentPreviousInstr(@NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        boolean $i$f$commentPreviousInstr = false;
        if (!this.getSkipCommentInstructions()) {
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstString((String)text.invoke())};
            this.buildInstr(WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR, SourceLocation.Companion.NoLocation("Pseudo-instruction"), wasmImmediateArray);
        }
    }

    public final void commentGroupStart(@NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        boolean $i$f$commentGroupStart = false;
        if (!this.getSkipCommentInstructions()) {
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstString((String)text.invoke())};
            this.buildInstr(WasmOp.PSEUDO_COMMENT_GROUP_START, SourceLocation.Companion.NoLocation("Pseudo-instruction"), wasmImmediateArray);
        }
    }

    public final void commentGroupEnd() {
        if (!this.skipCommentInstructions) {
            this.buildInstr(WasmOp.PSEUDO_COMMENT_GROUP_END, SourceLocation.Companion.NoLocation("Pseudo-instruction"), new WasmImmediate[0]);
        }
    }
}

