/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import org.jetbrains.kotlin.fir.scopes.DelicateScopeAPI;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH$J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u001c\u0010\u0012\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0017H&J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00002\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getKlass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getNestedClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "isEmpty", "", "getCallableNames", "", "scopeOwnerLookupNames", "", "", "getScopeOwnerLookupNames", "()Ljava/util/List;", "withReplacedSessionOrNull", "newSession", "newScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirNestedClassifierScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNestedClassifierScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1205#2,2:134\n1282#2,4:136\n*S KotlinDebug\n*F\n+ 1 FirNestedClassifierScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope\n*L\n42#1:134,2\n42#1:136,4\n*E\n"})
public abstract class FirNestedClassifierScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final FirClass klass;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final List<String> scopeOwnerLookupNames;

    public FirNestedClassifierScope(@NotNull FirClass klass, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        this.klass = klass;
        this.useSiteSession = useSiteSession;
        this.scopeOwnerLookupNames = this.klass.isLocal() ? CollectionsKt.emptyList() : (List)new SmartList<String>(FirDeclarationUtilKt.getClassId(this.klass).asFqNameString());
    }

    @NotNull
    public final FirClass getKlass() {
        return this.klass;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @Nullable
    protected abstract FirClassLikeSymbol<?> getNestedClassSymbol(@NotNull Name var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        ConeSubstitutor coneSubstitutor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getNestedClassSymbol(name2);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> matchedClass = firClassLikeSymbol;
        if (this.klass.getTypeParameters().isEmpty()) {
            coneSubstitutor = ConeSubstitutor.Empty.INSTANCE;
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = this.klass.getTypeParameters();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getSymbol(), (Object)FirNestedClassifierScopeKt.toConeType(it));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map substitution = destination$iv$iv;
            coneSubstitutor = ConeSubstitutorByMapKt.substitutorByMap(substitution, this.useSiteSession, true);
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        processor.invoke(matchedClass, (Object)substitutor2);
    }

    public abstract boolean isEmpty();

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public List<String> getScopeOwnerLookupNames() {
        return this.scopeOwnerLookupNames;
    }

    @Override
    @DelicateScopeAPI
    @Nullable
    public abstract FirNestedClassifierScope withReplacedSessionOrNull(@NotNull FirSession var1, @NotNull ScopeSession var2);
}

