/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.lower.WebCallableReferenceLowering;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0014J$\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0014J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\u0007*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/WebCallableReferenceLowering;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "compileSuspendAsJsGenerator", "", "getConstructorCallOrigin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "shouldAddContinuation", "getShouldAddContinuation", "(Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;)Z", "getClassOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "generateSuperClassConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "superClassType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "functionReference", "getSuperClassType", "getExtraConstructorParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCallableReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCallableReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCallableReferenceLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,83:1\n629#2,12:84\n363#3,4:96\n*S KotlinDebug\n*F\n+ 1 JsCallableReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCallableReferenceLowering\n*L\n51#1:84,12\n74#1:96,4\n*E\n"})
public final class JsCallableReferenceLowering
extends WebCallableReferenceLowering {
    private final boolean compileSuspendAsJsGenerator;

    public JsCallableReferenceLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.compileSuspendAsJsGenerator = MiscKt.getCompileSuspendAsJsGenerator(context2);
    }

    @Override
    @NotNull
    protected IrStatementOriginImpl getConstructorCallOrigin(@NotNull IrRichFunctionReference reference2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        return JsStatementOrigins.INSTANCE.getCALLABLE_REFERENCE_CREATE();
    }

    private final boolean getShouldAddContinuation(IrRichFunctionReference $this$shouldAddContinuation) {
        return this.isLambda($this$shouldAddContinuation) && $this$shouldAddContinuation.getInvokeFunction().isSuspend() && !this.compileSuspendAsJsGenerator;
    }

    @Override
    @NotNull
    protected IrDeclarationOrigin getClassOrigin(@NotNull IrRichFunctionReference reference2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        return this.isKReference(reference2) || !this.isLambda(reference2) ? (IrDeclarationOrigin)WebCallableReferenceLowering.Companion.getFUNCTION_REFERENCE_IMPL() : (IrDeclarationOrigin)WebCallableReferenceLowering.Companion.getLAMBDA_IMPL();
    }

    @Override
    @NotNull
    protected IrDelegatingConstructorCall generateSuperClassConstructorCall(@NotNull IrBuilderWithScope $this$generateSuperClassConstructorCall, @NotNull IrConstructor constructor, @NotNull IrType superClassType, @NotNull IrRichFunctionReference functionReference) {
        IrDelegatingConstructorCall irDelegatingConstructorCall;
        Intrinsics.checkNotNullParameter((Object)$this$generateSuperClassConstructorCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)superClassType, (String)"superClassType");
        Intrinsics.checkNotNullParameter((Object)functionReference, (String)"functionReference");
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)IrTypesKt.getClassOrFail(superClassType).getOwner());
        if (irConstructor == null) {
            CompilationExceptionKt.compilationException("Missing primary constructor", (IrDeclaration)IrTypesKt.getClassOrFail(superClassType).getOwner());
            throw new KotlinNothingValueException();
        }
        IrConstructor superConstructor = irConstructor;
        IrDelegatingConstructorCall $this$generateSuperClassConstructorCall_u24lambda_u240 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall($this$generateSuperClassConstructorCall, superConstructor);
        boolean bl = false;
        if (this.getShouldAddContinuation(functionReference)) {
            Iterable $this$single$iv = constructor.getParameters();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.Companion.getCONTINUATION())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrValueParameter continuation2 = single$iv;
            $this$generateSuperClassConstructorCall_u24lambda_u240.getArguments().set(0, BuildersKt.IrGetValueImpl(-1, -1, continuation2.getType(), continuation2.getSymbol(), JsStatementOrigins.INSTANCE.getCALLABLE_REFERENCE_INVOKE()));
        }
        return irDelegatingConstructorCall;
    }

    @Override
    @NotNull
    protected IrType getSuperClassType(@NotNull IrRichFunctionReference reference2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        return this.getShouldAddContinuation(reference2) ? (IrType)IrUtilsKt.getDefaultType((IrClass)this.getContext().getSymbols().getCoroutineImpl().getOwner()) : this.getContext().getIrBuiltIns().getAnyType();
    }

    @Override
    @NotNull
    protected List<IrValueParameter> getExtraConstructorParameters(@NotNull IrConstructor constructor, @NotNull IrRichFunctionReference reference2) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        if (!this.getShouldAddContinuation(reference2)) {
            return CollectionsKt.emptyList();
        }
        IrDeclaration declaration$iv = constructor;
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u241$iv = new IrValueParameterBuilder();
        boolean bl = false;
        IrValueParameterBuilder $this$getExtraConstructorParameters_u24lambda_u240 = $this$buildValueParameter_u24lambda_u241$iv;
        boolean bl2 = false;
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)this.getContext().getSymbols().getCoroutineImpl().getOwner());
        Intrinsics.checkNotNull((Object)irConstructor);
        IrValueParameter superContinuation = (IrValueParameter)CollectionsKt.single(irConstructor.getParameters());
        $this$getExtraConstructorParameters_u24lambda_u240.setName(superContinuation.getName());
        $this$getExtraConstructorParameters_u24lambda_u240.setType(superContinuation.getType());
        $this$getExtraConstructorParameters_u24lambda_u240.setOrigin(IrDeclarationOrigin.Companion.getCONTINUATION());
        $this$getExtraConstructorParameters_u24lambda_u240.setKind(IrParameterKind.Regular);
        return CollectionsKt.listOf((Object)DeclarationBuildersKt.buildValueParameter(declaration$iv.getFactory(), $this$buildValueParameter_u24lambda_u241$iv, (IrDeclarationParent)((Object)declaration$iv)));
    }
}

