/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.konan.InlineClassesSupport;
import org.jetbrains.kotlin.backend.konan.InteropFqNames;
import org.jetbrains.kotlin.backend.konan.ir.UtilsKt;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0011\u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0094\u0010J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/konan/IrTypeInlineClassesSupport;", "Lorg/jetbrains/kotlin/backend/konan/InlineClassesSupport;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "()V", "isNullable", "", "type", "makeNullable", "erase", "computeFullErasure", "Lkotlin/sequences/Sequence;", "hasInlineModifier", "clazz", "getNativePointedSuperclass", "getInlinedClassUnderlyingType", "getPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getName", "Lorg/jetbrains/kotlin/name/Name;", "isTopLevelClass", "ir.backend.native"})
@PublishedApi
@SourceDebugExtension(value={"SMAP\nIrTypeInlineClassesSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeInlineClassesSupport.kt\norg/jetbrains/kotlin/backend/konan/IrTypeInlineClassesSupport\n+ 2 IrUtils.kt\norg/jetbrains/kotlin/ir/util/IrUtilsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1460#2:96\n184#3,2:97\n812#4,12:99\n777#4:112\n873#4:113\n874#4:115\n77#5:111\n1#6:114\n*S KotlinDebug\n*F\n+ 1 IrTypeInlineClassesSupport.kt\norg/jetbrains/kotlin/backend/konan/IrTypeInlineClassesSupport\n*L\n71#1:96\n84#1:97,2\n85#1:99,12\n85#1:112\n85#1:113\n85#1:115\n85#1:111\n*E\n"})
public final class IrTypeInlineClassesSupport
extends InlineClassesSupport<IrClass, IrType> {
    @NotNull
    public static final IrTypeInlineClassesSupport INSTANCE = new IrTypeInlineClassesSupport();

    private IrTypeInlineClassesSupport() {
    }

    @Override
    public boolean isNullable(@NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return IrTypeUtilsKt.isNullable(type);
    }

    @Override
    @NotNull
    public IrType makeNullable(@NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return IrTypesKt.makeNullable(type);
    }

    @Override
    @NotNull
    protected IrClass erase(@NotNull IrType type) {
        IrClassifierSymbol classifier;
        IrClassifierSymbol irClassifierSymbol;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        IrTypeInlineClassesSupport irTypeInlineClassesSupport = this;
        while (!((irClassifierSymbol = (classifier = IrTypesKt.getClassifierOrFail(type))) instanceof IrClassSymbol)) {
            if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
                IrTypeInlineClassesSupport irTypeInlineClassesSupport2 = irTypeInlineClassesSupport;
                IrType irType = (IrType)CollectionsKt.first(((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes());
                irTypeInlineClassesSupport = irTypeInlineClassesSupport2;
                type = irType;
                continue;
            }
            throw new IllegalStateException(classifier.toString());
        }
        return (IrClass)((IrClassSymbol)classifier).getOwner();
    }

    @Override
    @NotNull
    protected Sequence<IrClass> computeFullErasure(@NotNull IrType type) {
        Sequence sequence2;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        IrClassifierSymbol classifier = IrTypesKt.getClassifierOrFail(type);
        if (classifier instanceof IrClassSymbol) {
            sequence2 = SequencesKt.sequenceOf(((IrClassSymbol)classifier).getOwner());
        } else if (classifier instanceof IrTypeParameterSymbol) {
            sequence2 = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes()), IrTypeInlineClassesSupport::computeFullErasure$lambda$0);
        } else {
            if (classifier instanceof IrScriptSymbol) {
                IrSymbol $this$unexpectedSymbolKind$iv = classifier;
                boolean $i$f$unexpectedSymbolKind = false;
                throw new IllegalArgumentException("Unexpected kind of " + IrClassifierSymbol.class.getTypeName() + ": " + $this$unexpectedSymbolKind$iv);
            }
            throw new NoWhenBranchMatchedException();
        }
        return sequence2;
    }

    @Override
    protected boolean hasInlineModifier(@NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return IrDeclarationsKt.isSingleFieldValueClass(clazz);
    }

    @Override
    @Nullable
    protected IrClass getNativePointedSuperclass(@NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        IrClass superClass = clazz;
        while (superClass != null && !Intrinsics.areEqual((Object)InteropFqNames.INSTANCE.getNativePointed().toSafe(), (Object)IrUtilsKt.getFqNameWhenAvailable(superClass))) {
            superClass = UtilsKt.getSuperClassNotAny(superClass);
        }
        return superClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrType getInlinedClassUnderlyingType(@NotNull IrClass clazz) {
        Object object;
        Object v0;
        block8: {
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Sequence<IrConstructor> $this$firstOrNull$iv = IrUtilsKt.getConstructors(clazz);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl = false;
                if (!it.isPrimary()) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        if ((object = (IrConstructor)v0) == null || (object = ((IrFunction)object).getParameters()) == null || (object = (IrValueParameter)CollectionsKt.single((List)object)) == null || (object = object.getType()) == null) {
            void $this$filterTo$iv$iv$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = clazz.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo22 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$atMostOne$iv = (List)destination$iv$iv;
            boolean $i$f$atMostOne = false;
            Iterable $this$filter$iv$iv = $this$atMostOne$iv;
            boolean $i$f$filter = false;
            Iterable $i$f$filterIsInstanceTo22 = $this$filter$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                IrField irField;
                IrProperty it = (IrProperty)element$iv$iv$iv;
                boolean bl = false;
                if (it.getBackingField() != null) {
                    IrField irField2;
                    IrField it2 = irField2;
                    boolean bl2 = false;
                    irField = !it2.isStatic() ? irField2 : null;
                } else {
                    irField = null;
                }
                if (!(irField != null)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            IrDeclarationBase irDeclarationBase = (IrProperty)CollectionUtilKt.atMostOne((List)destination$iv$iv$iv);
            if (irDeclarationBase != null && (irDeclarationBase = ((IrProperty)irDeclarationBase).getBackingField()) != null) {
                object = ((IrField)irDeclarationBase).getType();
            } else {
                InlineClassRepresentation<IrSimpleType> inlineClassRepresentation = IrDeclarationsKt.getInlineClassRepresentation(clazz);
                Intrinsics.checkNotNull(inlineClassRepresentation);
                object = inlineClassRepresentation.getUnderlyingType();
            }
        }
        return object;
    }

    @Override
    @Nullable
    protected FqName getPackageFqName(@NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return AdditionalIrUtilsKt.getPackageFqName(clazz);
    }

    @Override
    @Nullable
    protected Name getName(@NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return clazz.getName();
    }

    @Override
    public boolean isTopLevelClass(@NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return IrUtilsKt.isTopLevel(clazz);
    }

    private static final Sequence computeFullErasure$lambda$0(IrType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.computeFullErasure(it);
    }
}

