/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsExportDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructedClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ5\u0010\u0014\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ3\u0010\u001b\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ=\u0010\u001c\u001a\u00020\u000f*\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010 J5\u0010\u001c\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ-\u0010#\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020$H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010%R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R%\u0010!\u001a\u00020\u000f*\u00020\u00158BX\u0082\u0004b\u00020\b\u008a\u0001\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "isInsideInterface", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "isInlineWithReified", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isExportableReturn", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "currentlyProcessed", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Set;)Z", "isExportableTypeArguments", "isExportable", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "declarationSite", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;Ljava/util/Set;)Z", "isPrimitiveExportableConeKotlinType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "validateDeclarationOnConsumableName", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)V", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExportDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExportDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n35#2:322\n53#2:323\n54#2:324\n53#2:325\n53#2:327\n50#2:328\n53#2:329\n1#3:326\n83#4:330\n34#5:331\n1807#6,3:332\n*S KotlinDebug\n*F\n+ 1 FirJsExportDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker\n*L\n76#1:322\n84#1:323\n97#1:324\n128#1:325\n147#1:327\n170#1:328\n192#1:329\n202#1:330\n202#1:331\n210#1:332,3\n*E\n"})
public final class FirJsExportDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExportDeclarationChecker INSTANCE = new FirJsExportDeclarationChecker();

    private FirJsExportDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!FirJsHelpersKt.isExportedObject(context2, declaration.getSymbol()) || !(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        boolean hasJsName = FirAnnotationUtilsKt.hasAnnotation(declaration, JsStandardClassIds.Annotations.JsName, context2.getSession());
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowExpectDeclarationsInJsExport)) {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "expect");
            }
        }
        this.validateDeclarationOnConsumableName(context2, reporter, (FirMemberDeclaration)declaration);
        FirMemberDeclaration firMemberDeclaration = (FirMemberDeclaration)declaration;
        if (firMemberDeclaration instanceof FirFunction) {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context2)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "external function");
                return;
            }
            for (FirTypeParameterRef typeParameter : ((FirFunction)declaration).getTypeParameters()) {
                FirJsExportDeclarationChecker.check$checkTypeParameter(context2, declaration, reporter, typeParameter);
            }
            if (this.isInlineWithReified((FirCallableSymbol)((FirFunction)declaration).getSymbol())) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "inline function with reified type parameters");
                return;
            }
            FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend() && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowExportingSuspendFunctions)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "suspend function");
                return;
            }
            if (declaration instanceof FirConstructor && !((FirConstructor)declaration).isPrimary() && !hasJsName) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "secondary constructor without @JsName");
            }
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            List allCheckedParameters = CollectionsKt.plus((Collection)((FirFunction)declaration).getContextParameters(), (Iterable)((FirFunction)declaration).getValueParameters());
            for (FirValueParameter parameter : allCheckedParameters) {
                FirJsExportDeclarationChecker.check$checkValueParameter(context2, declaration, reporter, parameter);
            }
            ConeKotlinType returnType = FirTypeUtilsKt.getConeType(((FirFunction)declaration).getReturnTypeRef());
            if (!(declaration instanceof FirConstructor) && !FirJsExportDeclarationChecker.isExportableReturn$default(this, context2, returnType, context2.getSession(), null, 4, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"return", (Object)returnType, null, 32, null);
            }
        } else if (firMemberDeclaration instanceof FirProperty) {
            boolean bl;
            FirClassSymbol containingClass;
            KtSourceElement ktSourceElement = ((FirProperty)declaration).getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                return;
            }
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal22 = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context2)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "external property");
                return;
            }
            if (FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "extension property");
                return;
            }
            FirClassLikeSymbol<?> $i$f$isExternal22 = ContainingClassUtilsKt.getContainingClassSymbol(declaration);
            FirClassSymbol firClassSymbol = containingClass = $i$f$isExternal22 instanceof FirClassSymbol ? (FirClassSymbol)$i$f$isExternal22 : null;
            if (firClassSymbol != null) {
                FirClassSymbol firClassSymbol2 = firClassSymbol;
                FirProperty firProperty = (FirProperty)declaration;
                FirClassSymbol p0 = firClassSymbol2;
                boolean bl2 = false;
                bl = UtilsKt.isEnumEntries((FirVariable)firProperty, p0);
            } else {
                bl = false;
            }
            boolean enumEntriesProperty = bl;
            ConeKotlinType returnType = FirTypeUtilsKt.getConeType(((FirProperty)declaration).getReturnTypeRef());
            if (!enumEntriesProperty && !FirJsExportDeclarationChecker.isExportable$default(this, context2, returnType, context2.getSession(), null, 4, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirProperty)declaration).getSource(), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"property", (Object)returnType, null, 32, null);
            }
        } else if (firMemberDeclaration instanceof FirClass) {
            Object wrongDeclaration;
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal() && FirHelpersKt.isTopLevel(context2)) {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration).getClassKind().ordinal()]) {
                    case 1: {
                        string = "external class";
                        break;
                    }
                    case 2: {
                        string = null;
                        break;
                    }
                    case 3: {
                        string = "external enum class";
                        break;
                    }
                    case 4: {
                        string = "external enum entry";
                        break;
                    }
                    case 5: {
                        string = "external annotation class";
                        break;
                    }
                    case 6: {
                        string = "external object";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                wrongDeclaration = string;
                if (wrongDeclaration != null) {
                    FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, (String)wrongDeclaration);
                    return;
                }
            }
            wrongDeclaration = ((FirClass)declaration).getTypeParameters().iterator();
            while (wrongDeclaration.hasNext()) {
                FirTypeParameterRef typeParameter = wrongDeclaration.next();
                FirJsExportDeclarationChecker.check$checkTypeParameter(context2, declaration, reporter, typeParameter);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration).getClassKind().ordinal()]) {
                case 5: {
                    Object object = "annotation class";
                    break;
                }
                case 1: {
                    Object object;
                    if (this.isInsideInterface(context2)) {
                        object = "nested class inside exported interface";
                        break;
                    }
                    FirClass $this$isInlineOrValue$iv = (FirClass)declaration;
                    boolean $i$f$isInlineOrValue = false;
                    if ($this$isInlineOrValue$iv.getStatus().isInline() || $this$isInlineOrValue$iv.getStatus().isValue()) {
                        object = "value class";
                        break;
                    }
                    object = null;
                    break;
                }
                default: {
                    Object object = wrongDeclaration = this.isInsideInterface(context2) && !((FirClass)declaration).getStatus().isCompanion() ? "nested/inner declaration inside exported interface" : null;
                }
            }
            if (this.isInsideInterface(context2) && ((FirClass)declaration).getStatus().isCompanion() && !Intrinsics.areEqual((Object)FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)declaration), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirClass)declaration).getSource(), FirJsErrors.INSTANCE.getNAMED_COMPANION_IN_EXPORTED_INTERFACE(), null, 8, null);
            }
            if (wrongDeclaration != null) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, (String)wrongDeclaration);
            }
        } else if (firMemberDeclaration instanceof FirTypeAlias) {
            FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "typealias");
        } else {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(context2, reporter, declaration, "external declaration");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideInterface(CheckerContext $this$isInsideInterface) {
        Object object = CollectionsKt.lastOrNull($this$isInsideInterface.getContainingDeclarations());
        if (!(object instanceof FirClassSymbol)) return false;
        FirClassSymbol firClassSymbol = (FirClassSymbol)object;
        FirClassSymbol parent2 = firClassSymbol;
        if (parent2 == null) return false;
        FirClassSymbol $this$isInterface$iv = parent2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    private final boolean isInlineWithReified(FirCallableSymbol<?> $this$isInlineWithReified) {
        boolean bl;
        block5: {
            if ($this$isInlineWithReified instanceof FirPropertyAccessorSymbol) {
                bl = this.isInlineWithReified(((FirPropertyAccessorSymbol)$this$isInlineWithReified).getPropertySymbol());
            } else {
                Iterable $this$any$iv = $this$isInlineWithReified.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private final boolean isExportableReturn(CheckerContext context2, ConeKotlinType $this$isExportableReturn, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        return ConeBuiltinTypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable(context2, $this$isExportableReturn, session, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, CheckerContext checkerContext, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n2, Object object) {
        if ((n2 & 4) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportableReturn(checkerContext, coneKotlinType, firSession, set);
    }

    private final boolean isExportableTypeArguments(CheckerContext context2, ConeKotlinType $this$isExportableTypeArguments, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        if ($this$isExportableTypeArguments.getTypeArguments().length == 0) {
            return true;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, $this$isExportableTypeArguments);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        int n2 = $this$isExportableTypeArguments.getTypeArguments().length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FirTypeParameterSymbol parameter;
            if ((FirTypeParameterSymbol)CollectionsKt.getOrNull(symbol.getTypeParameterSymbols(), (int)i2) == null) {
                return false;
            }
            if (this.isExportable(context2, $this$isExportableTypeArguments.getTypeArguments()[i2], session, parameter, currentlyProcessed)) continue;
            return false;
        }
        return true;
    }

    private final boolean isExportable(CheckerContext context2, ConeTypeProjection $this$isExportable, FirSession session, FirTypeParameterSymbol declarationSite, Set<ConeKotlinType> currentlyProcessed) {
        ConeKotlinType coneKotlinType;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$isExportable.getKind().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                coneKotlinType = ConeTypeProjectionKt.getType($this$isExportable);
                break;
            }
            case 4: {
                if (WhenMappings.$EnumSwitchMapping$1[declarationSite.getVariance().ordinal()] == 1) {
                    coneKotlinType = null;
                    break;
                }
                coneKotlinType = TypeUtilsKt.getProjectionForRawType(declarationSite, session, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType typeFromProjection = coneKotlinType;
        return declarationSite.getVariance() == Variance.OUT_VARIANCE && ConeBuiltinTypeUtilsKt.isUnit(typeFromProjection) || this.isExportable(context2, typeFromProjection, session, currentlyProcessed);
    }

    private final boolean isExportable(CheckerContext context2, ConeKotlinType $this$isExportable, FirSession session, Set<ConeKotlinType> currentlyProcessed) {
        boolean bl;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        ConeKotlinType expandedType2 = TypeExpansionUtilsKt.fullyExpandedType($this$isExportable, session, (Function1<? super FirTypeAlias, ? extends ConeClassLikeType>)((Function1)isExportable.expandedType.1.INSTANCE));
        boolean isExportableFunctionType = FunctionalTypeUtilsKt.isBasicFunctionType(expandedType2, session);
        boolean isExportableArgs = this.isExportableTypeArguments(context2, expandedType2, session, currentlyProcessed);
        currentlyProcessed.remove($this$isExportable);
        if (isExportableFunctionType || !isExportableArgs) {
            return isExportableArgs;
        }
        ConeKotlinType nonNullable = TypeUtilsKt.withNullability$default(expandedType2, false, TypeComponentsKt.getTypeContext(session), null, false, 12, null);
        boolean isPrimitiveExportableType = ConeBuiltinTypeUtilsKt.isAny(nonNullable) || ConeBuiltinTypeUtilsKt.isNullableAny(nonNullable) || nonNullable instanceof ConeDynamicType || this.isPrimitiveExportableConeKotlinType(context2, nonNullable);
        FirClassifierSymbol<?> symbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, expandedType2);
        if (isPrimitiveExportableType) {
            bl = true;
        } else {
            FirClassifierSymbol<?> firClassifierSymbol = symbol;
            bl = !(firClassifierSymbol != null ? FirDeclarationUtilKt.isMemberDeclaration((FirBasedSymbol)firClassifierSymbol) : false) ? false : (ConeBuiltinTypeUtilsKt.isEnum(expandedType2) ? true : FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)symbol, session) || FirJsHelpersKt.isExportedObject((FirBasedSymbol)symbol, session));
        }
        return bl;
    }

    static /* synthetic */ boolean isExportable$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, CheckerContext checkerContext, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n2, Object object) {
        if ((n2 & 4) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportable(checkerContext, coneKotlinType, firSession, set);
    }

    private final boolean isPrimitiveExportableConeKotlinType(CheckerContext context2, ConeKotlinType $this$isPrimitiveExportableConeKotlinType) {
        return $this$isPrimitiveExportableConeKotlinType instanceof ConeTypeParameterType || ConeBuiltinTypeUtilsKt.isBoolean($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isString($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveNumberOrNullableType($this$isPrimitiveExportableConeKotlinType) && (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowLongInExportedDeclarations) || !ConeBuiltinTypeUtilsKt.isLong($this$isPrimitiveExportableConeKotlinType)) || ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNonPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMap($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableMap($this$isPrimitiveExportableConeKotlinType);
    }

    private final void validateDeclarationOnConsumableName(CheckerContext context2, DiagnosticReporter reporter, FirMemberDeclaration declaration) {
        if (!FirHelpersKt.isTopLevel(context2) || FirDeclarationUtilKt.getNameOrSpecialName(declaration).isSpecial()) {
            return;
        }
        FirExpression jsNameArgument = FirHelpersKt.getAnnotationFirstArgument(declaration.getSymbol(), JsStandardClassIds.Annotations.JsName, context2.getSession());
        Object object = jsNameArgument;
        if (object == null || (object = ((FirExpression)object).getSource()) == null) {
            object = declaration.getSource();
        }
        Object reportTarget = object;
        FirLiteralExpression firLiteralExpression = jsNameArgument instanceof FirLiteralExpression ? (FirLiteralExpression)jsNameArgument : null;
        Object object2 = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String string = object2 instanceof String ? (String)object2 : null;
        if (string == null) {
            String string2 = FirDeclarationUtilKt.getNameOrSpecialName(declaration).asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        String name2 = string;
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name2) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name2) && Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name2), (Object)name2)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)reportTarget, FirJsErrors.INSTANCE.getNON_CONSUMABLE_EXPORTED_IDENTIFIER(), (Object)name2, null, 16, null);
    }

    private static final void check$checkTypeParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirTypeParameterRef typeParameter) {
        if (typeParameter instanceof FirConstructedClassTypeParameterRef) {
            return;
        }
        for (FirResolvedTypeRef upperBound : typeParameter.getSymbol().getResolvedBounds()) {
            if (FirJsExportDeclarationChecker.isExportable$default(INSTANCE, $context, upperBound.getConeType(), $context.getSession(), null, 4, null)) continue;
            KtSourceElement ktSourceElement = upperBound.getSource();
            if (ktSourceElement == null && (ktSourceElement = typeParameter.getSource()) == null) {
                ktSourceElement = ((FirMemberDeclaration)$declaration).getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"upper bound", (Object)upperBound.getConeType(), null, 32, null);
        }
    }

    private static final void check$checkValueParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirValueParameter valueParameter2) {
        ConeKotlinType type = FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef());
        if (!FirJsExportDeclarationChecker.isExportable$default(INSTANCE, $context, type, $context.getSession(), null, 4, null)) {
            KtSourceElement ktSourceElement = valueParameter2.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = ((FirMemberDeclaration)$declaration).getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"parameter", (Object)type, null, 32, null);
        }
    }

    private static final void check$reportWrongExportedDeclaration(CheckerContext $context, DiagnosticReporter $reporter, FirDeclaration $declaration, String kind) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)((FirMemberDeclaration)$declaration).getSource(), FirJsErrors.INSTANCE.getWRONG_EXPORTED_DECLARATION(), (Object)kind, null, 16, null);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

