/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.inline.InlineFunctionResolver;
import org.jetbrains.kotlin.ir.inline.InlineMode;
import org.jetbrains.kotlin.ir.overrides.IrVisibilityUtilKt;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolverReplacingCoroutineIntrinsics;", "Ctx", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "context", "inlineMode", "Lorg/jetbrains/kotlin/ir/inline/InlineMode;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lorg/jetbrains/kotlin/ir/inline/InlineMode;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "getInlineMode", "()Lorg/jetbrains/kotlin/ir/inline/InlineMode;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "ir.inline"})
public abstract class InlineFunctionResolverReplacingCoroutineIntrinsics<Ctx extends LoweringContext>
extends InlineFunctionResolver {
    @NotNull
    private final Ctx context;
    @NotNull
    private final InlineMode inlineMode;

    public InlineFunctionResolverReplacingCoroutineIntrinsics(@NotNull Ctx context2, @NotNull InlineMode inlineMode) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)inlineMode), (String)"inlineMode");
        this.context = context2;
        this.inlineMode = inlineMode;
    }

    @NotNull
    protected final Ctx getContext() {
        return this.context;
    }

    @NotNull
    protected final InlineMode getInlineMode() {
        return this.inlineMode;
    }

    @Override
    @Nullable
    protected IrFunction getFunctionDeclaration(@NotNull IrFunctionSymbol symbol) {
        Object result2;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!symbol.isBound()) {
            return null;
        }
        IrFunction realOwner = IrFakeOverrideUtilsKt.resolveFakeOverrideOrSelf(symbol.getOwner());
        if (!realOwner.isInline()) {
            return null;
        }
        if (realOwner.isExternal() && !this.context.getAllowInliningOfExternalFunctions()) {
            return null;
        }
        Object object = AdditionalIrUtilsKt.isBuiltInSuspendCoroutineUninterceptedOrReturn(realOwner) ? this.context.getSymbols().getSuspendCoroutineUninterceptedOrReturn().getOwner() : (result2 = Intrinsics.areEqual((Object)realOwner.getSymbol(), (Object)this.context.getSymbols().getCoroutineContextGetter()) ? this.context.getSymbols().getCoroutineGetContext().getOwner() : realOwner);
        if (this.inlineMode == InlineMode.PRIVATE_INLINE_FUNCTIONS && !IrVisibilityUtilKt.isEffectivelyPrivate((IrDeclarationWithVisibility)result2)) {
            return null;
        }
        return result2;
    }
}

