/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMapMappingConsumer;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMapBuilderConsumer;", "Lorg/jetbrains/kotlin/js/backend/SourceLocationConsumer;", "sourceBaseDir", "Ljava/io/File;", "mappingConsumer", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMapMappingConsumer;", "pathResolver", "Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;", "provideExternalModuleContent", "", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/js/sourceMap/SourceMapMappingConsumer;Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;Z)V", "sourceStack", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocationWithSource;", "newLine", "", "pushSourceInfo", "info", "popSourceInfo", "addMapping", "sourceInfo", "js.sourcemap"})
public final class SourceMapBuilderConsumer
implements SourceLocationConsumer {
    @NotNull
    private final File sourceBaseDir;
    @NotNull
    private final SourceMapMappingConsumer mappingConsumer;
    @NotNull
    private final SourceFilePathResolver pathResolver;
    private final boolean provideExternalModuleContent;
    @NotNull
    private final List<JsLocationWithSource> sourceStack;

    public SourceMapBuilderConsumer(@NotNull File sourceBaseDir, @NotNull SourceMapMappingConsumer mappingConsumer, @NotNull SourceFilePathResolver pathResolver, boolean provideExternalModuleContent) {
        Intrinsics.checkNotNullParameter((Object)sourceBaseDir, (String)"sourceBaseDir");
        Intrinsics.checkNotNullParameter((Object)mappingConsumer, (String)"mappingConsumer");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        this.sourceBaseDir = sourceBaseDir;
        this.mappingConsumer = mappingConsumer;
        this.pathResolver = pathResolver;
        this.provideExternalModuleContent = provideExternalModuleContent;
        this.sourceStack = new ArrayList();
    }

    @Override
    public void newLine() {
        this.mappingConsumer.newLine();
    }

    @Override
    public void pushSourceInfo(@Nullable JsLocationWithSource info) {
        this.sourceStack.add(info);
        this.addMapping(info);
    }

    @Override
    public void popSourceInfo() {
        AddToStdlibKt.popLast(this.sourceStack);
        this.addMapping((JsLocationWithSource)CollectionsKt.lastOrNull(this.sourceStack));
    }

    private final void addMapping(JsLocationWithSource sourceInfo) {
        String string;
        File absFile;
        if (sourceInfo == null) {
            this.mappingConsumer.addEmptyMapping();
            return;
        }
        Function0<Reader> contentSupplier = this.provideExternalModuleContent ? sourceInfo.getSourceProvider() : SourceMapBuilderConsumer::addMapping$lambda$0;
        File sourceFile = new File(sourceInfo.getFile());
        File file = absFile = sourceFile.isAbsolute() ? sourceFile : new File(this.sourceBaseDir, sourceInfo.getFile());
        if (absFile.isAbsolute()) {
            String string2;
            try {
                string2 = this.pathResolver.getPathRelativeToSourceRoots(absFile);
            }
            catch (IOException e2) {
                string2 = sourceInfo.getFile();
            }
            string = string2;
        } else {
            string = sourceInfo.getFile();
        }
        String path = string;
        this.mappingConsumer.addMapping(path, sourceInfo.getFileIdentity(), () -> SourceMapBuilderConsumer.addMapping$lambda$1(contentSupplier), sourceInfo.getStartLine(), sourceInfo.getStartChar(), sourceInfo.getName());
    }

    private static final Reader addMapping$lambda$0() {
        return null;
    }

    private static final Reader addMapping$lambda$1(Function0 $tmp0) {
        return (Reader)$tmp0.invoke();
    }
}

