/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.reader.impl;

import org.jetbrains.kotlin.org.jline.reader.LineReader;
import org.jetbrains.kotlin.org.jline.utils.Levenshtein;

public class ReaderUtils {
    public static boolean isSet(LineReader reader, LineReader.Option option2) {
        return reader != null && reader.isSet(option2);
    }

    public static String getString(LineReader reader, String name2, String def) {
        Object v2 = reader != null ? reader.getVariable(name2) : null;
        return v2 != null ? v2.toString() : def;
    }

    public static boolean getBoolean(LineReader reader, String name2, boolean def) {
        Object v2;
        Object object = v2 = reader != null ? reader.getVariable(name2) : null;
        if (v2 instanceof Boolean) {
            return (Boolean)v2;
        }
        if (v2 != null) {
            String s2 = v2.toString();
            return s2.isEmpty() || s2.equalsIgnoreCase("on") || s2.equalsIgnoreCase("1") || s2.equalsIgnoreCase("true");
        }
        return def;
    }

    public static int getInt(LineReader reader, String name2, int def) {
        Object v2;
        int nb = def;
        Object object = v2 = reader != null ? reader.getVariable(name2) : null;
        if (v2 instanceof Number) {
            return ((Number)v2).intValue();
        }
        if (v2 != null) {
            nb = 0;
            try {
                nb = Integer.parseInt(v2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nb;
    }

    public static long getLong(LineReader reader, String name2, long def) {
        Object v2;
        long nb = def;
        Object object = v2 = reader != null ? reader.getVariable(name2) : null;
        if (v2 instanceof Number) {
            return ((Number)v2).longValue();
        }
        if (v2 != null) {
            nb = 0L;
            try {
                nb = Long.parseLong(v2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nb;
    }

    public static int distance(String word, String cand) {
        if (word.length() < cand.length()) {
            int d1 = Levenshtein.distance(word, cand.substring(0, Math.min(cand.length(), word.length())));
            int d2 = Levenshtein.distance(word, cand);
            return Math.min(d1, d2);
        }
        return Levenshtein.distance(word, cand);
    }
}

