/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.sun.jdi.Location;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.backend.handlers.DebugRunner;
import org.jetbrains.kotlin.test.backend.handlers.DebugRunnerKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.SteppingTestLoggedData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000bj\b\u0012\u0004\u0012\u00020\n`\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SteppingDebugRunner;", "Lorg/jetbrains/kotlin/test/backend/handlers/DebugRunner;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "storeStep", "", "loggedItems", "Lkotlin/collections/ArrayList;", "Lorg/jetbrains/kotlin/test/utils/SteppingTestLoggedData;", "Ljava/util/ArrayList;", "event", "Lcom/sun/jdi/event/Event;", "(Ljava/util/ArrayList;Lcom/sun/jdi/event/Event;)V", "tests-common-new_test"})
public final class SteppingDebugRunner
extends DebugRunner {
    public SteppingDebugRunner(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    public void storeStep(@NotNull ArrayList<SteppingTestLoggedData> loggedItems, @NotNull Event event) {
        Intrinsics.checkNotNullParameter(loggedItems, (String)"loggedItems");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean bl = event instanceof LocatableEvent;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Location location = ((LocatableEvent)event).location();
        Intrinsics.checkNotNull((Object)location);
        SteppingTestLoggedData data = DebugRunnerKt.access$isIndyLambda(location) ? new SteppingTestLoggedData(-1, true, "<lambda>") : new SteppingTestLoggedData(location.lineNumber(), location.method().isSynthetic(), DebugRunner.formatAsExpectation$default(this, location, null, 1, null));
        loggedItems.add(data);
    }
}

