/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousSuper;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeFunctionExpectedError;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "check", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "typeName", "", "processAfterAllModules", "someAssertionWasFailed", "", "Visitor", "ConeTypeStatus", "tests-common-new_test"})
public final class FirResolvedTypesVerifier
extends FirAnalysisHandler {
    public FirResolvedTypesVerifier(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, true, false, 4, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Visitor visitor = new Visitor();
        for (FirFile firFile : info.getMainFirFiles().values()) {
            firFile.acceptChildren((FirVisitor)visitor, (Object)firFile);
        }
        boolean ignored = module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getIGNORE_LEAKED_INTERNAL_TYPES());
        try {
            Function0[] function0Array = new Function0[]{() -> FirResolvedTypesVerifier.processModule$lambda$0(this, visitor), () -> FirResolvedTypesVerifier.processModule$lambda$1(this, visitor), () -> FirResolvedTypesVerifier.processModule$lambda$2(this, visitor)};
            this.getAssertions().assertAll(function0Array);
        }
        catch (AssertionError assertionError) {
            if (ignored) {
                return;
            }
            throw assertionError;
        }
        if (ignored) {
            this.getAssertions().fail((Function0<String>)((Function0)FirResolvedTypesVerifier::processModule$lambda$3));
            throw null;
        }
    }

    private final void check(Collection<? extends FirElement> $this$check, String typeName) {
        this.getAssertions().assertTrue($this$check.isEmpty(), (Function0<String>)((Function0)() -> FirResolvedTypesVerifier.check$lambda$6($this$check, typeName)));
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    private static final Unit processModule$lambda$0(FirResolvedTypesVerifier this$0, Visitor $visitor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$visitor), (String)"$visitor");
        this$0.check((Collection<? extends FirElement>)$visitor.getDetectedImplicitTypesParents(), "implicit");
        return Unit.INSTANCE;
    }

    private static final Unit processModule$lambda$1(FirResolvedTypesVerifier this$0, Visitor $visitor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$visitor), (String)"$visitor");
        this$0.check((Collection<? extends FirElement>)$visitor.getDetectedTypeVariableTypesParents(), "type variable");
        return Unit.INSTANCE;
    }

    private static final Unit processModule$lambda$2(FirResolvedTypesVerifier this$0, Visitor $visitor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$visitor), (String)"$visitor");
        this$0.check((Collection<? extends FirElement>)$visitor.getDetectedStubTypesParents(), "stub");
        return Unit.INSTANCE;
    }

    private static final String processModule$lambda$3() {
        return "There is no leaked internal types in test. Please remove " + FirDiagnosticsDirectives.INSTANCE.getIGNORE_LEAKED_INTERNAL_TYPES() + " directive";
    }

    private static final CharSequence check$lambda$6$lambda$5$lambda$4(FirElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "   - Type in " + UtilsKt.render((FirElement)it);
    }

    private static final String check$lambda$6(Collection $this_check, String $typeName) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)$this_check, (String)"$this_check");
        Intrinsics.checkNotNullParameter((Object)$typeName, (String)"$typeName");
        StringBuilder $this$check_u24lambda_u246_u24lambda_u245 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        int count = $this_check.size();
        if (count == 1) {
            StringBuilder stringBuilder3 = $this$check_u24lambda_u246_u24lambda_u245.append("One " + $typeName + " type was found:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder3.append('\n');
            stringBuilder = stringBuilder4;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        } else {
            StringBuilder stringBuilder5 = $this$check_u24lambda_u246_u24lambda_u245.append("" + count + ' ' + $typeName + " types were found:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            StringBuilder stringBuilder6 = stringBuilder5.append('\n');
            stringBuilder = stringBuilder6;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        }
        String types = CollectionsKt.joinToString$default((Iterable)$this_check, (CharSequence)"\n", null, null, (int)0, null, FirResolvedTypesVerifier::check$lambda$6$lambda$5$lambda$4, (int)30, null);
        $this$check_u24lambda_u246_u24lambda_u245.append(types);
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier$ConeTypeStatus;", "", "<init>", "(Ljava/lang/String;I)V", "TypeVariableFound", "StubFound", "tests-common-new_test"})
    private static final class ConeTypeStatus
    extends Enum<ConeTypeStatus> {
        public static final /* enum */ ConeTypeStatus TypeVariableFound = new ConeTypeStatus();
        public static final /* enum */ ConeTypeStatus StubFound = new ConeTypeStatus();
        private static final /* synthetic */ ConeTypeStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConeTypeStatus[] values() {
            return (ConeTypeStatus[])$VALUES.clone();
        }

        public static ConeTypeStatus valueOf(String value) {
            return Enum.valueOf(ConeTypeStatus.class, value);
        }

        @NotNull
        public static EnumEntries<ConeTypeStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = coneTypeStatusArray = new ConeTypeStatus[]{ConeTypeStatus.TypeVariableFound, ConeTypeStatus.StubFound};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#*\u00020$H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier$Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "<init>", "(Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier;)V", "detectedImplicitTypesParents", "", "getDetectedImplicitTypesParents", "()Ljava/util/Set;", "detectedTypeVariableTypesParents", "getDetectedTypeVariableTypesParents", "detectedStubTypesParents", "getDetectedStubTypesParents", "visitElement", "element", "data", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitLoopJump", "loopJump", "Lorg/jetbrains/kotlin/fir/expressions/FirLoopJump;", "visitImplicitTypeRef", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "checkElementWithConeType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkConeType", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier$ConeTypeStatus;", "coneTypes", "", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nFirResolvedTypesVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirResolvedTypesVerifier.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirResolvedTypesVerifier$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
    private final class Visitor
    extends FirDefaultVisitor<Unit, FirElement> {
        @NotNull
        private final Set<FirElement> detectedImplicitTypesParents = new LinkedHashSet();
        @NotNull
        private final Set<FirElement> detectedTypeVariableTypesParents = new LinkedHashSet();
        @NotNull
        private final Set<FirElement> detectedStubTypesParents = new LinkedHashSet();

        @NotNull
        public final Set<FirElement> getDetectedImplicitTypesParents() {
            return this.detectedImplicitTypesParents;
        }

        @NotNull
        public final Set<FirElement> getDetectedTypeVariableTypesParents() {
            return this.detectedTypeVariableTypesParents;
        }

        @NotNull
        public final Set<FirElement> getDetectedStubTypesParents() {
            return this.detectedStubTypesParents;
        }

        public void visitElement(@NotNull FirElement element, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (element instanceof FirDiagnosticHolder) {
                for (ConeKotlinType coneType : this.coneTypes(((FirDiagnosticHolder)element).getDiagnostic())) {
                    this.checkElementWithConeType(element, coneType);
                }
            }
            element.acceptChildren((FirVisitor)this, (Object)element);
        }

        public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull FirElement data) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitElement((FirElement)resolvedTypeRef, data);
                this.checkElementWithConeType((FirElement)resolvedTypeRef, resolvedTypeRef.getType());
                FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
                if (firTypeRef == null) break block0;
                FirTypeRef it = firTypeRef;
                boolean bl = false;
                this.visitElement((FirElement)it, data);
            }
        }

        public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitElement((FirElement)errorTypeRef, data);
            FirTypeRef firTypeRef = errorTypeRef.getDelegatedTypeRef();
            if (firTypeRef != null) {
                FirTypeRef it = firTypeRef;
                boolean bl = false;
                this.visitElement((FirElement)it, data);
            }
            this.checkElementWithConeType((FirElement)errorTypeRef, errorTypeRef.getType());
        }

        public void visitLoopJump(@NotNull FirLoopJump loopJump, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)loopJump, (String)"loopJump");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitElement((FirElement)loopJump, data);
            if (loopJump.getTarget().getLabeledElement() instanceof FirErrorLoop) {
                this.visitElement((FirElement)loopJump.getTarget().getLabeledElement(), data);
            }
        }

        public void visitImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @NotNull FirElement data) {
            Intrinsics.checkNotNullParameter((Object)implicitTypeRef, (String)"implicitTypeRef");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ((Collection)this.detectedImplicitTypesParents).add(data);
        }

        private final void checkElementWithConeType(FirElement element, ConeKotlinType type) {
            ConeTypeStatus coneTypeStatus = this.checkConeType(type);
            switch (coneTypeStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[coneTypeStatus.ordinal()]) {
                case 1: {
                    ((Collection)this.detectedTypeVariableTypesParents).add(element);
                    break;
                }
                case 2: {
                    ((Collection)this.detectedStubTypesParents).add(element);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final ConeTypeStatus checkConeType(ConeKotlinType type) {
            Ref.BooleanRef typeVariableFound = new Ref.BooleanRef();
            Ref.BooleanRef stubTypeFound = new Ref.BooleanRef();
            ConeTypeUtilsKt.contains((ConeKotlinType)type, arg_0 -> Visitor.checkConeType$lambda$2(typeVariableFound, stubTypeFound, arg_0));
            return stubTypeFound.element ? ConeTypeStatus.StubFound : (typeVariableFound.element ? ConeTypeStatus.TypeVariableFound : null);
        }

        private final List<ConeKotlinType> coneTypes(ConeDiagnostic $this$coneTypes) {
            ConeDiagnostic coneDiagnostic = $this$coneTypes;
            return coneDiagnostic instanceof ConeAmbiguousSuper ? ((ConeAmbiguousSuper)$this$coneTypes).getCandidateTypes() : (coneDiagnostic instanceof ConeFunctionExpectedError ? CollectionsKt.listOf((Object)((ConeFunctionExpectedError)$this$coneTypes).getType()) : CollectionsKt.emptyList());
        }

        private static final boolean checkConeType$lambda$2(Ref.BooleanRef $typeVariableFound, Ref.BooleanRef $stubTypeFound, ConeKotlinType it) {
            Intrinsics.checkNotNullParameter((Object)$typeVariableFound, (String)"$typeVariableFound");
            Intrinsics.checkNotNullParameter((Object)$stubTypeFound, (String)"$stubTypeFound");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ConeKotlinType coneKotlinType = it;
            if (coneKotlinType instanceof ConeTypeVariableType) {
                $typeVariableFound.element = true;
            } else if (coneKotlinType instanceof ConeStubType) {
                $stubTypeFound.element = true;
            }
            return false;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConeTypeStatus.values().length];
                try {
                    nArray[ConeTypeStatus.TypeVariableFound.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConeTypeStatus.StubFound.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

