/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.codegen.AbstractBytecodeTextTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/codegen/bytecodeText")
@TestDataPath(value="$PROJECT_ROOT")
public class BytecodeTextTestGenerated
extends AbstractBytecodeTextTest {
    @Test
    @TestMetadata(value="accessorForOverridenVal.kt")
    public void testAccessorForOverridenVal() {
        this.runTest("compiler/testData/codegen/bytecodeText/accessorForOverridenVal.kt");
    }

    @Test
    @TestMetadata(value="accessorForProtected.kt")
    public void testAccessorForProtected() {
        this.runTest("compiler/testData/codegen/bytecodeText/accessorForProtected.kt");
    }

    @Test
    @TestMetadata(value="accessorNaming.kt")
    public void testAccessorNaming() {
        this.runTest("compiler/testData/codegen/bytecodeText/accessorNaming.kt");
    }

    @Test
    public void testAllFilesPresentInBytecodeText() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
    }

    @Test
    @TestMetadata(value="annotationDefaultValue.kt")
    public void testAnnotationDefaultValue() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValue.kt");
    }

    @Test
    @TestMetadata(value="annotationJavaRetentionPolicyRuntime.kt")
    public void testAnnotationJavaRetentionPolicyRuntime() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationJavaRetentionPolicyRuntime.kt");
    }

    @Test
    @TestMetadata(value="annotationRetentionPolicyClass.kt")
    public void testAnnotationRetentionPolicyClass() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyClass.kt");
    }

    @Test
    @TestMetadata(value="annotationRetentionPolicyRuntime.kt")
    public void testAnnotationRetentionPolicyRuntime() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyRuntime.kt");
    }

    @Test
    @TestMetadata(value="annotationRetentionPolicySource.kt")
    public void testAnnotationRetentionPolicySource() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicySource.kt");
    }

    @Test
    @TestMetadata(value="boxedNotNumberTypeOnUnboxing.kt")
    public void testBoxedNotNumberTypeOnUnboxing() {
        this.runTest("compiler/testData/codegen/bytecodeText/boxedNotNumberTypeOnUnboxing.kt");
    }

    @Test
    @TestMetadata(value="bridgeForFakeOverride.kt")
    public void testBridgeForFakeOverride() {
        this.runTest("compiler/testData/codegen/bytecodeText/bridgeForFakeOverride.kt");
    }

    @Test
    @TestMetadata(value="charConstant.kt")
    public void testCharConstant() {
        this.runTest("compiler/testData/codegen/bytecodeText/charConstant.kt");
    }

    @Test
    @TestMetadata(value="collectionStubs.kt")
    public void testCollectionStubs() {
        this.runTest("compiler/testData/codegen/bytecodeText/collectionStubs.kt");
    }

    @Test
    @TestMetadata(value="componentEvaluatesOnlyOnce.kt")
    public void testComponentEvaluatesOnlyOnce() {
        this.runTest("compiler/testData/codegen/bytecodeText/componentEvaluatesOnlyOnce.kt");
    }

    @Test
    @TestMetadata(value="constClosureOptimization.kt")
    public void testConstClosureOptimization() {
        this.runTest("compiler/testData/codegen/bytecodeText/constClosureOptimization.kt");
    }

    @Test
    @TestMetadata(value="defaultMethodBody.kt")
    public void testDefaultMethodBody() {
        this.runTest("compiler/testData/codegen/bytecodeText/defaultMethodBody.kt");
    }

    @Test
    @TestMetadata(value="doNotStoreNullForTmpInDestructuring.kt")
    public void testDoNotStoreNullForTmpInDestructuring() {
        this.runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullForTmpInDestructuring.kt");
    }

    @Test
    @TestMetadata(value="doNotStoreNullsForCapturedVars.kt")
    public void testDoNotStoreNullsForCapturedVars() {
        this.runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullsForCapturedVars.kt");
    }

    @Test
    @TestMetadata(value="falseSmartCast.kt")
    public void testFalseSmartCast() {
        this.runTest("compiler/testData/codegen/bytecodeText/falseSmartCast.kt");
    }

    @Test
    @TestMetadata(value="flagsInMultiFileInherit.kt")
    public void testFlagsInMultiFileInherit() {
        this.runTest("compiler/testData/codegen/bytecodeText/flagsInMultiFileInherit.kt");
    }

    @Test
    @TestMetadata(value="iincGeneration.kt")
    public void testIincGeneration() {
        this.runTest("compiler/testData/codegen/bytecodeText/iincGeneration.kt");
    }

    @Test
    @TestMetadata(value="inheritedPropertyAnnotations.kt")
    public void testInheritedPropertyAnnotations() {
        this.runTest("compiler/testData/codegen/bytecodeText/inheritedPropertyAnnotations.kt");
    }

    @Test
    @TestMetadata(value="inlineFromOtherModule.kt")
    public void testInlineFromOtherModule() {
        this.runTest("compiler/testData/codegen/bytecodeText/inlineFromOtherModule.kt");
    }

    @Test
    @TestMetadata(value="inlineJavaConstantFromSubclass.kt")
    public void testInlineJavaConstantFromSubclass() {
        this.runTest("compiler/testData/codegen/bytecodeText/inlineJavaConstantFromSubclass.kt");
    }

    @Test
    @TestMetadata(value="inlineJavaStaticFields.kt")
    public void testInlineJavaStaticFields() {
        this.runTest("compiler/testData/codegen/bytecodeText/inlineJavaStaticFields.kt");
    }

    @Test
    @TestMetadata(value="inlineProtectedJavaConstantFromOtherPackage.kt")
    public void testInlineProtectedJavaConstantFromOtherPackage() {
        this.runTest("compiler/testData/codegen/bytecodeText/inlineProtectedJavaConstantFromOtherPackage.kt");
    }

    @Test
    @TestMetadata(value="intConstantNotNull.kt")
    public void testIntConstantNotNull() {
        this.runTest("compiler/testData/codegen/bytecodeText/intConstantNotNull.kt");
    }

    @Test
    @TestMetadata(value="intConstantNullable.kt")
    public void testIntConstantNullable() {
        this.runTest("compiler/testData/codegen/bytecodeText/intConstantNullable.kt");
    }

    @Test
    @TestMetadata(value="intConstantNullableSafeCall.kt")
    public void testIntConstantNullableSafeCall() {
        this.runTest("compiler/testData/codegen/bytecodeText/intConstantNullableSafeCall.kt");
    }

    @Test
    @TestMetadata(value="intConstantSafeCall.kt")
    public void testIntConstantSafeCall() {
        this.runTest("compiler/testData/codegen/bytecodeText/intConstantSafeCall.kt");
    }

    @Test
    @TestMetadata(value="intProgressionNoBoxing.kt")
    public void testIntProgressionNoBoxing() {
        this.runTest("compiler/testData/codegen/bytecodeText/intProgressionNoBoxing.kt");
    }

    @Test
    @TestMetadata(value="intRangeNoBoxing.kt")
    public void testIntRangeNoBoxing() {
        this.runTest("compiler/testData/codegen/bytecodeText/intRangeNoBoxing.kt");
    }

    @Test
    @TestMetadata(value="interfaceDefaultImpl.kt")
    public void testInterfaceDefaultImpl() {
        this.runTest("compiler/testData/codegen/bytecodeText/interfaceDefaultImpl.kt");
    }

    @Test
    @TestMetadata(value="isArrayOf.kt")
    public void testIsArrayOf() {
        this.runTest("compiler/testData/codegen/bytecodeText/isArrayOf.kt");
    }

    @Test
    @TestMetadata(value="javaExtensionPropertyIntrinsic.kt")
    public void testJavaExtensionPropertyIntrinsic() {
        this.runTest("compiler/testData/codegen/bytecodeText/javaExtensionPropertyIntrinsic.kt");
    }

    @Test
    @TestMetadata(value="javaFieldsWithIntersectionTypes_k1.kt")
    public void testJavaFieldsWithIntersectionTypes_k1() {
        this.runTest("compiler/testData/codegen/bytecodeText/javaFieldsWithIntersectionTypes_k1.kt");
    }

    @Test
    @TestMetadata(value="javaFields_k1.kt")
    public void testJavaFields_k1() {
        this.runTest("compiler/testData/codegen/bytecodeText/javaFields_k1.kt");
    }

    @Test
    @TestMetadata(value="javaStatics.kt")
    public void testJavaStatics() {
        this.runTest("compiler/testData/codegen/bytecodeText/javaStatics.kt");
    }

    @Test
    @TestMetadata(value="jvmField.kt")
    public void testJvmField() {
        this.runTest("compiler/testData/codegen/bytecodeText/jvmField.kt");
    }

    @Test
    @TestMetadata(value="jvmStaticInternalMangling.kt")
    public void testJvmStaticInternalMangling() {
        this.runTest("compiler/testData/codegen/bytecodeText/jvmStaticInternalMangling.kt");
    }

    @Test
    @TestMetadata(value="kt10259.kt")
    public void testKt10259() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt10259.kt");
    }

    @Test
    @TestMetadata(value="kt10259_2.kt")
    public void testKt10259_2() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt10259_2.kt");
    }

    @Test
    @TestMetadata(value="kt10259_3.kt")
    public void testKt10259_3() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt10259_3.kt");
    }

    @Test
    @TestMetadata(value="kt2202.kt")
    public void testKt2202() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt2202.kt");
    }

    @Test
    @TestMetadata(value="kt2887.kt")
    public void testKt2887() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt2887.kt");
    }

    @Test
    @TestMetadata(value="kt3845.kt")
    public void testKt3845() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt3845.kt");
    }

    @Test
    @TestMetadata(value="kt48367.kt")
    public void testKt48367() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt48367.kt");
    }

    @Test
    @TestMetadata(value="kt5016.kt")
    public void testKt5016() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt5016.kt");
    }

    @Test
    @TestMetadata(value="kt5016int.kt")
    public void testKt5016int() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt5016int.kt");
    }

    @Test
    @TestMetadata(value="kt5016intOrNull.kt")
    public void testKt5016intOrNull() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt5016intOrNull.kt");
    }

    @Test
    @TestMetadata(value="kt56923.kt")
    public void testKt56923() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt56923.kt");
    }

    @Test
    @TestMetadata(value="kt7188.kt")
    public void testKt7188() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt7188.kt");
    }

    @Test
    @TestMetadata(value="kt7769.kt")
    public void testKt7769() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt7769.kt");
    }

    @Test
    @TestMetadata(value="kt9603.kt")
    public void testKt9603() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt9603.kt");
    }

    @Test
    @TestMetadata(value="mapGetOrDefault.kt")
    public void testMapGetOrDefault() {
        this.runTest("compiler/testData/codegen/bytecodeText/mapGetOrDefault.kt");
    }

    @Test
    @TestMetadata(value="maxStackAfterOptimizations.kt")
    public void testMaxStackAfterOptimizations() {
        this.runTest("compiler/testData/codegen/bytecodeText/maxStackAfterOptimizations.kt");
    }

    @Test
    @TestMetadata(value="noAccessorForProtectedInSamePackageCrossinline.kt")
    public void testNoAccessorForProtectedInSamePackageCrossinline() {
        this.runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackageCrossinline.kt");
    }

    @Test
    @TestMetadata(value="noAccessorForProtectedInSamePackagePrivateInline.kt")
    public void testNoAccessorForProtectedInSamePackagePrivateInline() {
        this.runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackagePrivateInline.kt");
    }

    @Test
    @TestMetadata(value="noFlagAnnotations.kt")
    public void testNoFlagAnnotations() {
        this.runTest("compiler/testData/codegen/bytecodeText/noFlagAnnotations.kt");
    }

    @Test
    @TestMetadata(value="noNumberCheckCast.kt")
    public void testNoNumberCheckCast() {
        this.runTest("compiler/testData/codegen/bytecodeText/noNumberCheckCast.kt");
    }

    @Test
    @TestMetadata(value="noSuperCheckInDefaultConstuctor.kt")
    public void testNoSuperCheckInDefaultConstuctor() {
        this.runTest("compiler/testData/codegen/bytecodeText/noSuperCheckInDefaultConstuctor.kt");
    }

    @Test
    @TestMetadata(value="noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt")
    public void testNoSyntheticAccessorForPrivateCompanionObjectWhenNotRequired() {
        this.runTest("compiler/testData/codegen/bytecodeText/noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt");
    }

    @Test
    @TestMetadata(value="noWrapperForMethodReturningPrimitive.kt")
    public void testNoWrapperForMethodReturningPrimitive() {
        this.runTest("compiler/testData/codegen/bytecodeText/noWrapperForMethodReturningPrimitive.kt");
    }

    @Test
    @TestMetadata(value="nopsInDoWhile.kt")
    public void testNopsInDoWhile() {
        this.runTest("compiler/testData/codegen/bytecodeText/nopsInDoWhile.kt");
    }

    @Test
    @TestMetadata(value="partMembersCall.kt")
    public void testPartMembersCall() {
        this.runTest("compiler/testData/codegen/bytecodeText/partMembersCall.kt");
    }

    @Test
    @TestMetadata(value="partMembersInline.kt")
    public void testPartMembersInline() {
        this.runTest("compiler/testData/codegen/bytecodeText/partMembersInline.kt");
    }

    @Test
    @TestMetadata(value="preEvaluateInlineJavaStaticFields.kt")
    public void testPreEvaluateInlineJavaStaticFields() {
        this.runTest("compiler/testData/codegen/bytecodeText/preEvaluateInlineJavaStaticFields.kt");
    }

    @Test
    @TestMetadata(value="prefixIntVarIncrement.kt")
    public void testPrefixIntVarIncrement() {
        this.runTest("compiler/testData/codegen/bytecodeText/prefixIntVarIncrement.kt");
    }

    @Test
    @TestMetadata(value="privateDefaultArgs.kt")
    public void testPrivateDefaultArgs() {
        this.runTest("compiler/testData/codegen/bytecodeText/privateDefaultArgs.kt");
    }

    @Test
    @TestMetadata(value="redundantGotoRemoving.kt")
    public void testRedundantGotoRemoving() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantGotoRemoving.kt");
    }

    @Test
    @TestMetadata(value="redundantInitializer.kt")
    public void testRedundantInitializer() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantInitializer.kt");
    }

    @Test
    @TestMetadata(value="redundantInitializerNumber.kt")
    public void testRedundantInitializerNumber() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantInitializerNumber.kt");
    }

    @Test
    @TestMetadata(value="redundantValInitializer.kt")
    public void testRedundantValInitializer() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantValInitializer.kt");
    }

    @Test
    @TestMetadata(value="redundantValInitializerInObject.kt")
    public void testRedundantValInitializerInObject() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantValInitializerInObject.kt");
    }

    @Test
    @TestMetadata(value="redundantVarInitializer.kt")
    public void testRedundantVarInitializer() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializer.kt");
    }

    @Test
    @TestMetadata(value="redundantVarInitializerInObject.kt")
    public void testRedundantVarInitializerInObject() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializerInObject.kt");
    }

    @Test
    @TestMetadata(value="reifiedAsCheck.kt")
    public void testReifiedAsCheck() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheck.kt");
    }

    @Test
    @TestMetadata(value="reifiedAsCheckWithNullable.kt")
    public void testReifiedAsCheckWithNullable() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheckWithNullable.kt");
    }

    @Test
    @TestMetadata(value="reifiedIsCheck.kt")
    public void testReifiedIsCheck() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheck.kt");
    }

    @Test
    @TestMetadata(value="reifiedIsCheckWithNullable.kt")
    public void testReifiedIsCheckWithNullable() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheckWithNullable.kt");
    }

    @Test
    @TestMetadata(value="reifiedSafeAsCheck.kt")
    public void testReifiedSafeAsCheck() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedSafeAsCheck.kt");
    }

    @Test
    @TestMetadata(value="safeAsWithMutable.kt")
    public void testSafeAsWithMutable() {
        this.runTest("compiler/testData/codegen/bytecodeText/safeAsWithMutable.kt");
    }

    @Test
    @TestMetadata(value="superFlagInMultiFileFacade.kt")
    public void testSuperFlagInMultiFileFacade() {
        this.runTest("compiler/testData/codegen/bytecodeText/superFlagInMultiFileFacade.kt");
    }

    @Test
    @TestMetadata(value="superToString.kt")
    public void testSuperToString() {
        this.runTest("compiler/testData/codegen/bytecodeText/superToString.kt");
    }

    @Test
    @TestMetadata(value="suspendCoroutineUninterceptedOrReturn.kt")
    public void testSuspendCoroutineUninterceptedOrReturn() {
        this.runTest("compiler/testData/codegen/bytecodeText/suspendCoroutineUninterceptedOrReturn.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunWithDefaultArgs.kt")
    public void testTopLevelFunWithDefaultArgs() {
        this.runTest("compiler/testData/codegen/bytecodeText/topLevelFunWithDefaultArgs.kt");
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/whenStringOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WhenStringOptimization {
        @Test
        public void testAllFilesPresentInWhenStringOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenStringOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="denseHashCode.kt")
        public void testDenseHashCode() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/denseHashCode.kt");
        }

        @Test
        @TestMetadata(value="duplicatingItems.kt")
        public void testDuplicatingItems() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItems.kt");
        }

        @Test
        @TestMetadata(value="duplicatingItemsSameHashCodeFewBranches.kt")
        public void testDuplicatingItemsSameHashCodeFewBranches() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeFewBranches.kt");
        }

        @Test
        @TestMetadata(value="duplicatingItemsSameHashCodeMoreBranches.kt")
        public void testDuplicatingItemsSameHashCodeMoreBranches() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeMoreBranches.kt");
        }

        @Test
        @TestMetadata(value="expression.kt")
        public void testExpression() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/expression.kt");
        }

        @Test
        @TestMetadata(value="inlineStringConstInsideWhen.kt")
        public void testInlineStringConstInsideWhen() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/inlineStringConstInsideWhen.kt");
        }

        @Test
        @TestMetadata(value="nullability.kt")
        public void testNullability() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/nullability.kt");
        }

        @Test
        @TestMetadata(value="sameHashCode.kt")
        public void testSameHashCode() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/sameHashCode.kt");
        }

        @Test
        @TestMetadata(value="statement.kt")
        public void testStatement() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/statement.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/whenEnumOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WhenEnumOptimization {
        @Test
        public void testAllFilesPresentInWhenEnumOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenEnumOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="bigEnum.kt")
        public void testBigEnum() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/bigEnum.kt");
        }

        @Test
        @TestMetadata(value="differentEnumClasses.kt")
        public void testDifferentEnumClasses() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses.kt");
        }

        @Test
        @TestMetadata(value="differentEnumClasses2.kt")
        public void testDifferentEnumClasses2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses2.kt");
        }

        @Test
        @TestMetadata(value="duplicatingItems.kt")
        public void testDuplicatingItems() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/duplicatingItems.kt");
        }

        @Test
        @TestMetadata(value="expression.kt")
        public void testExpression() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/expression.kt");
        }

        @Test
        @TestMetadata(value="functionLiteralInTopLevel.kt")
        public void testFunctionLiteralInTopLevel() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/functionLiteralInTopLevel.kt");
        }

        @Test
        @TestMetadata(value="importedEnumEntry.kt")
        public void testImportedEnumEntry() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/importedEnumEntry.kt");
        }

        @Test
        @TestMetadata(value="kt14597_full.kt")
        public void testKt14597_full() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14597_full.kt");
        }

        @Test
        @TestMetadata(value="kt14802.kt")
        public void testKt14802() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14802.kt");
        }

        @Test
        @TestMetadata(value="manyWhensWithinClass.kt")
        public void testManyWhensWithinClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/manyWhensWithinClass.kt");
        }

        @Test
        @TestMetadata(value="nestedWhenInCondition.kt")
        public void testNestedWhenInCondition() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nestedWhenInCondition.kt");
        }

        @Test
        @TestMetadata(value="nonConstantEnum.kt")
        public void testNonConstantEnum() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nonConstantEnum.kt");
        }

        @Test
        @TestMetadata(value="nullability.kt")
        public void testNullability() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nullability.kt");
        }

        @Test
        @TestMetadata(value="subjectAny.kt")
        public void testSubjectAny() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/subjectAny.kt");
        }

        @Test
        @TestMetadata(value="whenOr.kt")
        public void testWhenOr() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/whenOr.kt");
        }

        @Test
        @TestMetadata(value="withoutElse.kt")
        public void testWithoutElse() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/withoutElse.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/when")
    @TestDataPath(value="$PROJECT_ROOT")
    public class When {
        @Test
        public void testAllFilesPresentInWhen() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/when"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="edgeCases.kt")
        public void testEdgeCases() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/edgeCases.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenInitialization.kt")
        public void testExhaustiveWhenInitialization() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenInitialization.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenReturn.kt")
        public void testExhaustiveWhenReturn() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenReturn.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenSpecialCases.kt")
        public void testExhaustiveWhenSpecialCases() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenSpecialCases.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenUnit.kt")
        public void testExhaustiveWhenUnit() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnit.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenUnitStatement.kt")
        public void testExhaustiveWhenUnitStatement() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnitStatement.kt");
        }

        @Test
        @TestMetadata(value="inlineConstValsInsideWhen.kt")
        public void testInlineConstValsInsideWhen() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/inlineConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata(value="integralWhenWithNoInlinedConstants.kt")
        public void testIntegralWhenWithNoInlinedConstants() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/integralWhenWithNoInlinedConstants.kt");
        }

        @Test
        @TestMetadata(value="kt18818.kt")
        public void testKt18818() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/kt18818.kt");
        }

        @Test
        @TestMetadata(value="lookupSwitch.kt")
        public void testLookupSwitch() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitch.kt");
        }

        @Test
        @TestMetadata(value="lookupSwitchWithSubjectVal.kt")
        public void testLookupSwitchWithSubjectVal() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata(value="noBoxingInDefaultWhenWithSpecialCases.kt")
        public void testNoBoxingInDefaultWhenWithSpecialCases() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/noBoxingInDefaultWhenWithSpecialCases.kt");
        }

        @Test
        @TestMetadata(value="qualifiedConstValsInsideWhen.kt")
        public void testQualifiedConstValsInsideWhen() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/qualifiedConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata(value="sealedWhenInitialization.kt")
        public void testSealedWhenInitialization() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/sealedWhenInitialization.kt");
        }

        @Test
        @TestMetadata(value="simpleConstValsInsideWhen.kt")
        public void testSimpleConstValsInsideWhen() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/simpleConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata(value="stringSwitchWithSubjectVal.kt")
        public void testStringSwitchWithSubjectVal() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/stringSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata(value="subjectValHasLocalVariableSlot.kt")
        public void testSubjectValHasLocalVariableSlot() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata(value="subjectValInEnumWhenHasLocalVariableSlot.kt")
        public void testSubjectValInEnumWhenHasLocalVariableSlot() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInEnumWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata(value="subjectValInIntWhenHasLocalVariableSlot.kt")
        public void testSubjectValInIntWhenHasLocalVariableSlot() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInIntWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata(value="subjectValInStringWhenHasLocalVariableSlot.kt")
        public void testSubjectValInStringWhenHasLocalVariableSlot() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInStringWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata(value="switchOptimizationDuplicates.kt")
        public void testSwitchOptimizationDuplicates() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/switchOptimizationDuplicates.kt");
        }

        @Test
        @TestMetadata(value="tableSwitch.kt")
        public void testTableSwitch() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/tableSwitch.kt");
        }

        @Test
        @TestMetadata(value="tableSwitchWithSubjectVal.kt")
        public void testTableSwitchWithSubjectVal() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/tableSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata(value="whenNull.kt")
        public void testWhenNull() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/whenNull.kt");
        }

        @Test
        @TestMetadata(value="whenZero.kt")
        public void testWhenZero() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/whenZero.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/varargs")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Varargs {
        @Test
        public void testAllFilesPresentInVarargs() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="doNotCopyImmediatelyCreatedArrays.kt")
        public void testDoNotCopyImmediatelyCreatedArrays() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/varargs/doNotCopyImmediatelyCreatedArrays.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/valueClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ValueClasses {
        @Test
        public void testAllFilesPresentInValueClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/unsignedTypes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class UnsignedTypes {
        @Test
        public void testAllFilesPresentInUnsignedTypes() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/unsignedTypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="unsignedIntCompare_jvm18.kt")
        public void testUnsignedIntCompare_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntCompare_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntDivide_jvm18.kt")
        public void testUnsignedIntDivide_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntDivide_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntRemainder_jvm18.kt")
        public void testUnsignedIntRemainder_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntRemainder_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntSmartCasts_jvm18.kt")
        public void testUnsignedIntSmartCasts_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntSmartCasts_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntToString_jvm18.kt")
        public void testUnsignedIntToString_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntToString_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedLongCompare_jvm18.kt")
        public void testUnsignedLongCompare_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongCompare_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedLongDivide_jvm18.kt")
        public void testUnsignedLongDivide_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongDivide_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedLongRemainder_jvm18.kt")
        public void testUnsignedLongRemainder_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongRemainder_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedLongToString_jvm18.kt")
        public void testUnsignedLongToString_jvm18() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongToString_jvm18.kt");
        }

        @Test
        @TestMetadata(value="whenByUnsigned.kt")
        public void testWhenByUnsigned() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/whenByUnsigned.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/toArray")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ToArray {
        @Test
        public void testAllFilesPresentInToArray() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="noAccessorForToArray.kt")
        public void testNoAccessorForToArray() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/toArray/noAccessorForToArray.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/temporaryVals")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TemporaryVals {
        @Test
        public void testAllFilesPresentInTemporaryVals() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/temporaryVals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrayCompoundAssignment.kt")
        public void testArrayCompoundAssignment() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/arrayCompoundAssignment.kt");
        }

        @Test
        @TestMetadata(value="elvisChain.kt")
        public void testElvisChain() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/elvisChain.kt");
        }

        @Test
        @TestMetadata(value="noTemporaryInCheckedCast.kt")
        public void testNoTemporaryInCheckedCast() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/noTemporaryInCheckedCast.kt");
        }

        @Test
        @TestMetadata(value="notNullReceiversInChain.kt")
        public void testNotNullReceiversInChain() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/notNullReceiversInChain.kt");
        }

        @Test
        @TestMetadata(value="safeCallChain1.kt")
        public void testSafeCallChain1() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain1.kt");
        }

        @Test
        @TestMetadata(value="safeCallChain2.kt")
        public void testSafeCallChain2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain2.kt");
        }

        @Test
        @TestMetadata(value="safeCallChainMemberExt1.kt")
        public void testSafeCallChainMemberExt1() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt1.kt");
        }

        @Test
        @TestMetadata(value="safeCallChainMemberExt2.kt")
        public void testSafeCallChainMemberExt2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt2.kt");
        }

        @Test
        @TestMetadata(value="safeCallElvisSafeCallElvisSomething.kt")
        public void testSafeCallElvisSafeCallElvisSomething() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallElvisSafeCallElvisSomething.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithElvis.kt")
        public void testSafeCallWithElvis() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallWithElvis.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/stringOperations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class StringOperations {
        @Test
        public void testAllFilesPresentInStringOperations() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/stringOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="concat.kt")
        public void testConcat() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concat.kt");
        }

        @Test
        @TestMetadata(value="concatDynamic.kt")
        public void testConcatDynamic() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic.kt");
        }

        @Test
        @TestMetadata(value="concatDynamic199.kt")
        public void testConcatDynamic199() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic199.kt");
        }

        @Test
        @TestMetadata(value="concatDynamic200.kt")
        public void testConcatDynamic200() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic200.kt");
        }

        @Test
        @TestMetadata(value="concatDynamic201.kt")
        public void testConcatDynamic201() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic201.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicConstants.kt")
        public void testConcatDynamicConstants() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicConstants.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicDataClass.kt")
        public void testConcatDynamicDataClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicDataClass.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicIndy.kt")
        public void testConcatDynamicIndy() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicIndy201.kt")
        public void testConcatDynamicIndy201() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy201.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicIndyDataClass.kt")
        public void testConcatDynamicIndyDataClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndyDataClass.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicSpecialSymbols.kt")
        public void testConcatDynamicSpecialSymbols() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicSpecialSymbols.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicUnit.kt")
        public void testConcatDynamicUnit() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicUnit.kt");
        }

        @Test
        @TestMetadata(value="concatNotDynamic.kt")
        public void testConcatNotDynamic() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatNotDynamic.kt");
        }

        @Test
        @TestMetadata(value="constConcat.kt")
        public void testConstConcat() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/constConcat.kt");
        }

        @Test
        @TestMetadata(value="constValConcat.kt")
        public void testConstValConcat() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/constValConcat.kt");
        }

        @Test
        @TestMetadata(value="doNotAppendEmptyString.kt")
        public void testDoNotAppendEmptyString() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/doNotAppendEmptyString.kt");
        }

        @Test
        @TestMetadata(value="interpolation.kt")
        public void testInterpolation() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/interpolation.kt");
        }

        @Test
        @TestMetadata(value="kt15235.kt")
        public void testKt15235() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt15235.kt");
        }

        @Test
        @TestMetadata(value="kt19037.kt")
        public void testKt19037() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt19037.kt");
        }

        @Test
        @TestMetadata(value="kt42457_old.kt")
        public void testKt42457_old() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt42457_old.kt");
        }

        @Test
        @TestMetadata(value="multipleNestedConcat.kt")
        public void testMultipleNestedConcat() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/multipleNestedConcat.kt");
        }

        @Test
        @TestMetadata(value="nestedConcat.kt")
        public void testNestedConcat() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nestedConcat.kt");
        }

        @Test
        @TestMetadata(value="nonNullableStringPlus.kt")
        public void testNonNullableStringPlus() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nonNullableStringPlus.kt");
        }

        @Test
        @TestMetadata(value="nullableStringPlus.kt")
        public void testNullableStringPlus() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nullableStringPlus.kt");
        }

        @Test
        @TestMetadata(value="partiallyConstConcat.kt")
        public void testPartiallyConstConcat() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/partiallyConstConcat.kt");
        }

        @Test
        @TestMetadata(value="plusAssign.kt")
        public void testPlusAssign() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/plusAssign.kt");
        }

        @Test
        @TestMetadata(value="primitiveToString.kt")
        public void testPrimitiveToString() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToString.kt");
        }

        @Test
        @TestMetadata(value="primitiveToStringNotOptimizable.kt")
        public void testPrimitiveToStringNotOptimizable() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToStringNotOptimizable.kt");
        }

        @Test
        @TestMetadata(value="primitivesAsStringTemplates.kt")
        public void testPrimitivesAsStringTemplates() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitivesAsStringTemplates.kt");
        }

        @Test
        @TestMetadata(value="singleConcat.kt")
        public void testSingleConcat() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/singleConcat.kt");
        }

        @Test
        @TestMetadata(value="stringBuilderToString.kt")
        public void testStringBuilderToString() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringBuilderToString.kt");
        }

        @Test
        @TestMetadata(value="stringPlus.kt")
        public void testStringPlus() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringPlus.kt");
        }

        @Test
        @TestMetadata(value="useAppendCharForOneCharStringInTemplate.kt")
        public void testUseAppendCharForOneCharStringInTemplate() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate.kt");
        }

        @Test
        @TestMetadata(value="useAppendCharForOneCharStringInTemplate_2.kt")
        public void testUseAppendCharForOneCharStringInTemplate_2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate_2.kt");
        }

        @Test
        @TestMetadata(value="useAppendCharForOneCharStringUsingPlus.kt")
        public void testUseAppendCharForOneCharStringUsingPlus() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringUsingPlus.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/storeStackBeforeInline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class StoreStackBeforeInline {
        @Test
        public void testAllFilesPresentInStoreStackBeforeInline() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrayConstructor.kt")
        public void testArrayConstructor() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/arrayConstructor.kt");
        }

        @Test
        @TestMetadata(value="differentTypes.kt")
        public void testDifferentTypes() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/differentTypes.kt");
        }

        @Test
        @TestMetadata(value="primitiveMerge.kt")
        public void testPrimitiveMerge() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/primitiveMerge.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/simple.kt");
        }

        @Test
        @TestMetadata(value="unreachableMarker.kt")
        public void testUnreachableMarker() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/unreachableMarker.kt");
        }

        @Test
        @TestMetadata(value="withLambda.kt")
        public void testWithLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/withLambda.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/staticFields")
    @TestDataPath(value="$PROJECT_ROOT")
    public class StaticFields {
        @Test
        public void testAllFilesPresentInStaticFields() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/staticFields"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="classObject.kt")
        public void testClassObject() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/staticFields/classObject.kt");
        }

        @Test
        @TestMetadata(value="object.kt")
        public void testObject() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/staticFields/object.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/statements")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Statements {
        @Test
        public void testAllFilesPresentInStatements() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/statements"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="ifSingleBranch.kt")
        public void testIfSingleBranch() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifSingleBranch.kt");
        }

        @Test
        @TestMetadata(value="ifThenElse.kt")
        public void testIfThenElse() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElse.kt");
        }

        @Test
        @TestMetadata(value="ifThenElseEmpty.kt")
        public void testIfThenElseEmpty() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElseEmpty.kt");
        }

        @Test
        @TestMetadata(value="labeled.kt")
        public void testLabeled() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/labeled.kt");
        }

        @Test
        @TestMetadata(value="statementsComposition.kt")
        public void testStatementsComposition() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/statementsComposition.kt");
        }

        @Test
        @TestMetadata(value="tryCatchFinally.kt")
        public void testTryCatchFinally() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/tryCatchFinally.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/when.kt");
        }

        @Test
        @TestMetadata(value="whenSubject.kt")
        public void testWhenSubject() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/whenSubject.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/sam")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Sam {
        @Test
        public void testAllFilesPresentInSam() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="samWrapperForNullInitialization.kt")
        public void testSamWrapperForNullInitialization() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullInitialization.kt");
        }

        @Test
        @TestMetadata(value="samWrapperForNullableInitialization.kt")
        public void testSamWrapperForNullableInitialization() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullableInitialization.kt");
        }

        @Test
        @TestMetadata(value="samWrapperInInlineLambda.kt")
        public void testSamWrapperInInlineLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda.kt");
        }

        @Test
        @TestMetadata(value="samWrapperInInlineLambda2.kt")
        public void testSamWrapperInInlineLambda2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda2.kt");
        }

        @Test
        @TestMetadata(value="samWrapperOfLambda.kt")
        public void testSamWrapperOfLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfLambda.kt");
        }

        @Test
        @TestMetadata(value="samWrapperOfReference.kt")
        public void testSamWrapperOfReference() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfReference.kt");
        }

        @Test
        @TestMetadata(value="samWrapperRawTypes.kt")
        public void testSamWrapperRawTypes() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperRawTypes.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/ranges")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Ranges {
        @Test
        public void testAllFilesPresentInRanges() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ranges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="ifNotInRange.kt")
        public void testIfNotInRange() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/ifNotInRange.kt");
        }

        @Test
        @TestMetadata(value="inArrayIndices.kt")
        public void testInArrayIndices() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inArrayIndices.kt");
        }

        @Test
        @TestMetadata(value="inCharSequenceIndices.kt")
        public void testInCharSequenceIndices() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inCharSequenceIndices.kt");
        }

        @Test
        @TestMetadata(value="inCollectionIndices.kt")
        public void testInCollectionIndices() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inCollectionIndices.kt");
        }

        @Test
        @TestMetadata(value="inComparableRangeLiteral.kt")
        public void testInComparableRangeLiteral() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inComparableRangeLiteral.kt");
        }

        @Test
        @TestMetadata(value="inMixedUnsignedRange.kt")
        public void testInMixedUnsignedRange() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange.kt");
        }

        @Test
        @TestMetadata(value="inMixedUnsignedRange_2.kt")
        public void testInMixedUnsignedRange_2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange_2.kt");
        }

        @Test
        @TestMetadata(value="inNonMatchingRangeIntrinsified.kt")
        public void testInNonMatchingRangeIntrinsified() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRangeIntrinsified.kt");
        }

        @Test
        @TestMetadata(value="inOptimizableRange.kt")
        public void testInOptimizableRange() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableRange.kt");
        }

        @Test
        @TestMetadata(value="inOptimizableUnsignedRange.kt")
        public void testInOptimizableUnsignedRange() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableUnsignedRange.kt");
        }

        @Test
        @TestMetadata(value="inRangeUntil.kt")
        public void testInRangeUntil() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inRangeUntil.kt");
        }

        @Test
        @TestMetadata(value="inUntil.kt")
        public void testInUntil() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inUntil.kt");
        }

        @Test
        @TestMetadata(value="noDupXForLiteralRangeContains.kt")
        public void testNoDupXForLiteralRangeContains() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/noDupXForLiteralRangeContains.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/properties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Properties {
        @Test
        public void testAllFilesPresentInProperties() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="dataClass.kt")
        public void testDataClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/dataClass.kt");
        }

        @Test
        @TestMetadata(value="openDataClass.kt")
        public void testOpenDataClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/openDataClass.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/properties/lateinit")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Lateinit {
            @Test
            public void testAllFilesPresentInLateinit() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="companionObject.kt")
            public void testCompanionObject() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObject.kt");
            }

            @Test
            @TestMetadata(value="companionObjectFromLambda.kt")
            public void testCompanionObjectFromLambda() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObjectFromLambda.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/parameterlessMain")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ParameterlessMain {
        @Test
        public void testAllFilesPresentInParameterlessMain() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/parameterlessMain"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="dontGenerateOnExtensionReceiver.kt")
        public void testDontGenerateOnExtensionReceiver() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnExtensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnJvmNameMain.kt")
        public void testDontGenerateOnJvmNameMain() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmNameMain.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnJvmOverloads.kt")
        public void testDontGenerateOnJvmOverloads() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmOverloads.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnMain.kt")
        public void testDontGenerateOnMain() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMain.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnMainExtension.kt")
        public void testDontGenerateOnMainExtension() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMainExtension.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnNullableArray.kt")
        public void testDontGenerateOnNullableArray() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableArray.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnNullableString.kt")
        public void testDontGenerateOnNullableString() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableString.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnVarargsString.kt")
        public void testDontGenerateOnVarargsString() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnVarargsString.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/outerClass")
    @TestDataPath(value="$PROJECT_ROOT")
    public class OuterClass {
        @Test
        public void testAllFilesPresentInOuterClass() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/outerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="classInClinit.kt")
        public void testClassInClinit() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/outerClass/classInClinit.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class OptimizedDelegatedProperties {
        @Test
        public void testAllFilesPresentInOptimizedDelegatedProperties() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="definedInSources.kt")
        public void testDefinedInSources() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/definedInSources.kt");
        }

        @Test
        @TestMetadata(value="delegateToAnother.kt")
        public void testDelegateToAnother() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/delegateToAnother.kt");
        }

        @Test
        @TestMetadata(value="inSeparateModule.kt")
        public void testInSeparateModule() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/inSeparateModule.kt");
        }

        @Test
        @TestMetadata(value="lazy.kt")
        public void testLazy() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/lazy.kt");
        }

        @Test
        @TestMetadata(value="withNonNullMetadataParameter.kt")
        public void testWithNonNullMetadataParameter() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/withNonNullMetadataParameter.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/nullCheckOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NullCheckOptimization {
        @Test
        public void testAllFilesPresentInNullCheckOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="alreadyCheckedForIs.kt")
        public void testAlreadyCheckedForIs() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForIs.kt");
        }

        @Test
        @TestMetadata(value="alreadyCheckedForNull.kt")
        public void testAlreadyCheckedForNull() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForNull.kt");
        }

        @Test
        @TestMetadata(value="deterministicNotNullChecks.kt")
        public void testDeterministicNotNullChecks() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/deterministicNotNullChecks.kt");
        }

        @Test
        @TestMetadata(value="exclExclAsNotNullType.kt")
        public void testExclExclAsNotNullType() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/exclExclAsNotNullType.kt");
        }

        @Test
        @TestMetadata(value="expressionValueIsNotNull.kt")
        public void testExpressionValueIsNotNull() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNull.kt");
        }

        @Test
        @TestMetadata(value="expressionValueIsNotNullAfterExclExcl.kt")
        public void testExpressionValueIsNotNullAfterExclExcl() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullAfterExclExcl.kt");
        }

        @Test
        @TestMetadata(value="ifNullEqualsNull.kt")
        public void testIfNullEqualsNull() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNull.kt");
        }

        @Test
        @TestMetadata(value="ifNullEqualsNullInline.kt")
        public void testIfNullEqualsNullInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNullInline.kt");
        }

        @Test
        @TestMetadata(value="ifUnitEqualsNull.kt")
        public void testIfUnitEqualsNull() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNull.kt");
        }

        @Test
        @TestMetadata(value="ifUnitEqualsNullInline.kt")
        public void testIfUnitEqualsNullInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNullInline.kt");
        }

        @Test
        @TestMetadata(value="kt12839.kt")
        public void testKt12839() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/kt12839.kt");
        }

        @Test
        @TestMetadata(value="multipleExclExcl_1_4.kt")
        public void testMultipleExclExcl_1_4() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/multipleExclExcl_1_4.kt");
        }

        @Test
        @TestMetadata(value="noNullCheckAfterCast.kt")
        public void testNoNullCheckAfterCast() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/noNullCheckAfterCast.kt");
        }

        @Test
        @TestMetadata(value="notNullAsNotNullable.kt")
        public void testNotNullAsNotNullable() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullAsNotNullable.kt");
        }

        @Test
        @TestMetadata(value="notNullExpressionValueTwice_1_4.kt")
        public void testNotNullExpressionValueTwice_1_4() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullExpressionValueTwice_1_4.kt");
        }

        @Test
        @TestMetadata(value="nullCheckAfterExclExcl_1_4.kt")
        public void testNullCheckAfterExclExcl_1_4() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullCheckAfterExclExcl_1_4.kt");
        }

        @Test
        @TestMetadata(value="nullabilityAssertionOnDispatchReceiver.kt")
        public void testNullabilityAssertionOnDispatchReceiver() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullabilityAssertionOnDispatchReceiver.kt");
        }

        @Test
        @TestMetadata(value="primitiveCheck.kt")
        public void testPrimitiveCheck() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/primitiveCheck.kt");
        }

        @Test
        @TestMetadata(value="redundantSafeCall.kt")
        public void testRedundantSafeCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall.kt");
        }

        @Test
        @TestMetadata(value="redundantSafeCall_1_4.kt")
        public void testRedundantSafeCall_1_4() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall_1_4.kt");
        }

        @Test
        @TestMetadata(value="reifiedIs.kt")
        public void testReifiedIs() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedIs.kt");
        }

        @Test
        @TestMetadata(value="reifiedNullIs.kt")
        public void testReifiedNullIs() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedNullIs.kt");
        }

        @Test
        @TestMetadata(value="safeCallAndElvisChains.kt")
        public void testSafeCallAndElvisChains() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/safeCallAndElvisChains.kt");
        }

        @Test
        @TestMetadata(value="trivialInstanceOf.kt")
        public void testTrivialInstanceOf() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/trivialInstanceOf.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalLateinit {
            @Test
            public void testAllFilesPresentInLocalLateinit() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="checkedAlways.kt")
            public void testCheckedAlways() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedAlways.kt");
            }

            @Test
            @TestMetadata(value="checkedOnce.kt")
            public void testCheckedOnce() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedOnce.kt");
            }

            @Test
            @TestMetadata(value="initialized.kt")
            public void testInitialized() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/initialized.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/notNullAssertions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NotNullAssertions {
        @Test
        public void testAllFilesPresentInNotNullAssertions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrayListGet.kt")
        public void testArrayListGet() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/arrayListGet.kt");
        }

        @Test
        @TestMetadata(value="assertionForNotNullCaptured.kt")
        public void testAssertionForNotNullCaptured() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullCaptured.kt");
        }

        @Test
        @TestMetadata(value="assertionForNotNullTypeParam.kt")
        public void testAssertionForNotNullTypeParam() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam.kt");
        }

        @Test
        @TestMetadata(value="assertionForNotNullTypeParam_1_4.kt")
        public void testAssertionForNotNullTypeParam_1_4() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam_1_4.kt");
        }

        @Test
        @TestMetadata(value="doNotGenerateParamAssertions.kt")
        public void testDoNotGenerateParamAssertions() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/doNotGenerateParamAssertions.kt");
        }

        @Test
        @TestMetadata(value="javaMultipleSubstitutions.kt")
        public void testJavaMultipleSubstitutions() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/javaMultipleSubstitutions.kt");
        }

        @Test
        @TestMetadata(value="noAssertionForNullableCaptured.kt")
        public void testNoAssertionForNullableCaptured() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableCaptured.kt");
        }

        @Test
        @TestMetadata(value="noAssertionForNullableGenericMethod.kt")
        public void testNoAssertionForNullableGenericMethod() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethod.kt");
        }

        @Test
        @TestMetadata(value="noAssertionForNullableGenericMethodCall.kt")
        public void testNoAssertionForNullableGenericMethodCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethodCall.kt");
        }

        @Test
        @TestMetadata(value="noAssertionForPrivateMethod.kt")
        public void testNoAssertionForPrivateMethod() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForPrivateMethod.kt");
        }

        @Test
        @TestMetadata(value="noAssertionsForKotlin.kt")
        public void testNoAssertionsForKotlin() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionsForKotlin.kt");
        }

        @Test
        @TestMetadata(value="noTemporaryVariableInNullCheckOnExpression.kt")
        public void testNoTemporaryVariableInNullCheckOnExpression() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noTemporaryVariableInNullCheckOnExpression.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/multifileClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="defaultFunctionInMultifileClass.kt")
        public void testDefaultFunctionInMultifileClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/defaultFunctionInMultifileClass.kt");
        }

        @Test
        @TestMetadata(value="optimizedMultifileClassFacadeMethods.kt")
        public void testOptimizedMultifileClassFacadeMethods() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/optimizedMultifileClassFacadeMethods.kt");
        }

        @Test
        @TestMetadata(value="privateFunctionName.kt")
        public void testPrivateFunctionName() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/privateFunctionName.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/mangling")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Mangling {
        @Test
        public void testAllFilesPresentInMangling() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/mangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="parentheses.kt")
        public void testParentheses() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mangling/parentheses.kt");
        }

        @Test
        @TestMetadata(value="parenthesesNoSanitize.kt")
        public void testParenthesesNoSanitize() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mangling/parenthesesNoSanitize.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/localInitializationLVT")
    @TestDataPath(value="$PROJECT_ROOT")
    public class LocalInitializationLVT {
        @Test
        public void testAllFilesPresentInLocalInitializationLVT() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/localInitializationLVT"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="boxing.kt")
        public void testBoxing() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxing.kt");
        }

        @Test
        @TestMetadata(value="boxingVar.kt")
        public void testBoxingVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxingVar.kt");
        }

        @Test
        @TestMetadata(value="contract.kt")
        public void testContract() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contract.kt");
        }

        @Test
        @TestMetadata(value="contractVar.kt")
        public void testContractVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contractVar.kt");
        }

        @Test
        @TestMetadata(value="generics.kt")
        public void testGenerics() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/generics.kt");
        }

        @Test
        @TestMetadata(value="genericsVar.kt")
        public void testGenericsVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/genericsVar.kt");
        }

        @Test
        @TestMetadata(value="ifStatement.kt")
        public void testIfStatement() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatement.kt");
        }

        @Test
        @TestMetadata(value="ifStatementVar.kt")
        public void testIfStatementVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementVar.kt");
        }

        @Test
        @TestMetadata(value="ifStatementWithoutBlock.kt")
        public void testIfStatementWithoutBlock() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlock.kt");
        }

        @Test
        @TestMetadata(value="ifStatementWithoutBlockVar.kt")
        public void testIfStatementWithoutBlockVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlockVar.kt");
        }

        @Test
        @TestMetadata(value="inlineClass.kt")
        public void testInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClass.kt");
        }

        @Test
        @TestMetadata(value="inlineClassVar.kt")
        public void testInlineClassVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClassVar.kt");
        }

        @Test
        @TestMetadata(value="lateinit.kt")
        public void testLateinit() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/lateinit.kt");
        }

        @Test
        @TestMetadata(value="run.kt")
        public void testRun() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/run.kt");
        }

        @Test
        @TestMetadata(value="runVar.kt")
        public void testRunVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/runVar.kt");
        }

        @Test
        @TestMetadata(value="singleBlock.kt")
        public void testSingleBlock() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlock.kt");
        }

        @Test
        @TestMetadata(value="singleBlockVar.kt")
        public void testSingleBlockVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlockVar.kt");
        }

        @Test
        @TestMetadata(value="whenStatement.kt")
        public void testWhenStatement() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatement.kt");
        }

        @Test
        @TestMetadata(value="whenStatementVar.kt")
        public void testWhenStatementVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatementVar.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/lineNumbers")
    @TestDataPath(value="$PROJECT_ROOT")
    public class LineNumbers {
        @Test
        public void testAllFilesPresentInLineNumbers() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lineNumbers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="delegationToList.kt")
        public void testDelegationToList() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/delegationToList.kt");
        }

        @Test
        @TestMetadata(value="ifConsts.kt")
        public void testIfConsts() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifConsts.kt");
        }

        @Test
        @TestMetadata(value="ifElse.kt")
        public void testIfElse() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifElse.kt");
        }

        @Test
        @TestMetadata(value="ifFalse.kt")
        public void testIfFalse() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalse.kt");
        }

        @Test
        @TestMetadata(value="ifFalseElse.kt")
        public void testIfFalseElse() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalseElse.kt");
        }

        @Test
        @TestMetadata(value="ifTrue.kt")
        public void testIfTrue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrue.kt");
        }

        @Test
        @TestMetadata(value="ifTrueElse.kt")
        public void testIfTrueElse() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrueElse.kt");
        }

        @Test
        @TestMetadata(value="inlineCondition.kt")
        public void testInlineCondition() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition.kt");
        }

        @Test
        @TestMetadata(value="inlineCondition2.kt")
        public void testInlineCondition2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition2.kt");
        }

        @Test
        @TestMetadata(value="inlineLambdaObjectInit.kt")
        public void testInlineLambdaObjectInit() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineLambdaObjectInit.kt");
        }

        @Test
        @TestMetadata(value="singleThen.kt")
        public void testSingleThen() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/singleThen.kt");
        }

        @Test
        @TestMetadata(value="tryCatch.kt")
        public void testTryCatch() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryCatch.kt");
        }

        @Test
        @TestMetadata(value="tryFinally.kt")
        public void testTryFinally() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryFinally.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/when.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/lazyCodegen")
    @TestDataPath(value="$PROJECT_ROOT")
    public class LazyCodegen {
        @Test
        public void testAllFilesPresentInLazyCodegen() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="inlineConstInsideComparison.kt")
        public void testInlineConstInsideComparison() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/inlineConstInsideComparison.kt");
        }

        @Test
        @TestMetadata(value="negateConst.kt")
        public void testNegateConst() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConst.kt");
        }

        @Test
        @TestMetadata(value="negateObjectComp.kt")
        public void testNegateObjectComp() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectComp.kt");
        }

        @Test
        @TestMetadata(value="negateObjectCompChaing.kt")
        public void testNegateObjectCompChaing() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectCompChaing.kt");
        }

        @Test
        @TestMetadata(value="negateVar.kt")
        public void testNegateVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVar.kt");
        }

        @Test
        @TestMetadata(value="negateVarChain.kt")
        public void testNegateVarChain() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVarChain.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Jvm8 {
        @Test
        public void testAllFilesPresentInJvm8() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/jvmDefault")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmDefault {
            @Test
            public void testAllFilesPresentInJvmDefault() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility")
            @TestDataPath(value="$PROJECT_ROOT")
            public class AllCompatibility {
                @Test
                public void testAllFilesPresentInAllCompatibility() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
                }

                @Test
                @TestMetadata(value="defaultArgs.kt")
                public void testDefaultArgs() {
                    BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/defaultArgs.kt");
                }

                @Test
                @TestMetadata(value="simpleDiamond.kt")
                public void testSimpleDiamond() {
                    BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleDiamond.kt");
                }

                @Test
                @TestMetadata(value="simpleFunction.kt")
                public void testSimpleFunction() {
                    BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunction.kt");
                }

                @Test
                @TestMetadata(value="simpleFunctionWithAbstractOverride.kt")
                public void testSimpleFunctionWithAbstractOverride() {
                    BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunctionWithAbstractOverride.kt");
                }

                @Test
                @TestMetadata(value="simpleProperty.kt")
                public void testSimpleProperty() {
                    BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleProperty.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/hashCode")
        @TestDataPath(value="$PROJECT_ROOT")
        public class HashCode {
            @Test
            public void testAllFilesPresentInHashCode() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dataClass.kt")
            public void testDataClass() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/dataClass.kt");
            }

            @Test
            @TestMetadata(value="hashCode.kt")
            public void testHashCode() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/hashCode.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/invokedynamic")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Invokedynamic {
        @Test
        public void testAllFilesPresentInInvokedynamic() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="functionRefToJavaInterface.kt")
        public void testFunctionRefToJavaInterface() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/functionRefToJavaInterface.kt");
        }

        @Test
        @TestMetadata(value="lambdas.kt")
        public void testLambdas() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/lambdas.kt");
        }

        @Test
        @TestMetadata(value="streamApi.kt")
        public void testStreamApi() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/streamApi.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsicsTrim")
    @TestDataPath(value="$PROJECT_ROOT")
    public class IntrinsicsTrim {
        @Test
        public void testAllFilesPresentInIntrinsicsTrim() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsTrim"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="trimIndentNegative.kt")
        public void testTrimIndentNegative() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentNegative.kt");
        }

        @Test
        @TestMetadata(value="trimIndentPositive.kt")
        public void testTrimIndentPositive() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentPositive.kt");
        }

        @Test
        @TestMetadata(value="trimMarginNegative.kt")
        public void testTrimMarginNegative() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginNegative.kt");
        }

        @Test
        @TestMetadata(value="trimMarginPositive.kt")
        public void testTrimMarginPositive() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginPositive.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsicsCompare")
    @TestDataPath(value="$PROJECT_ROOT")
    public class IntrinsicsCompare {
        @Test
        public void testAllFilesPresentInIntrinsicsCompare() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsCompare"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="byteSmartCast_after.kt")
        public void testByteSmartCast_after() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_after.kt");
        }

        @Test
        @TestMetadata(value="byteSmartCast_before.kt")
        public void testByteSmartCast_before() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_before.kt");
        }

        @Test
        @TestMetadata(value="charSmartCast.kt")
        public void testCharSmartCast() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/charSmartCast.kt");
        }

        @Test
        @TestMetadata(value="differentTypes_after.kt")
        public void testDifferentTypes_after() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_after.kt");
        }

        @Test
        @TestMetadata(value="differentTypes_before.kt")
        public void testDifferentTypes_before() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_before.kt");
        }

        @Test
        @TestMetadata(value="intSmartCast_after.kt")
        public void testIntSmartCast_after() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_after.kt");
        }

        @Test
        @TestMetadata(value="intSmartCast_before.kt")
        public void testIntSmartCast_before() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_before.kt");
        }

        @Test
        @TestMetadata(value="longSmartCast.kt")
        public void testLongSmartCast() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/longSmartCast.kt");
        }

        @Test
        @TestMetadata(value="shortSmartCast_after.kt")
        public void testShortSmartCast_after() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_after.kt");
        }

        @Test
        @TestMetadata(value="shortSmartCast_before.kt")
        public void testShortSmartCast_before() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_before.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsics")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Intrinsics {
        @Test
        public void testAllFilesPresentInIntrinsics() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="javaObjectType.kt")
        public void testJavaObjectType() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaObjectType.kt");
        }

        @Test
        @TestMetadata(value="javaPrimitiveType.kt")
        public void testJavaPrimitiveType() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaPrimitiveType.kt");
        }

        @Test
        @TestMetadata(value="postfixIncrDecr.kt")
        public void testPostfixIncrDecr() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/postfixIncrDecr.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/interfaces")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Interfaces {
        @Test
        @TestMetadata(value="addedInterfaceBridge.kt")
        public void testAddedInterfaceBridge() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/addedInterfaceBridge.kt");
        }

        @Test
        public void testAllFilesPresentInInterfaces() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/interfaces"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="firstInheritedMethodIsAbstract.kt")
        public void testFirstInheritedMethodIsAbstract() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstract.kt");
        }

        @Test
        @TestMetadata(value="noAnyMethodsOnInterfaceInheritance.kt")
        public void testNoAnyMethodsOnInterfaceInheritance() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noAnyMethodsOnInterfaceInheritance.kt");
        }

        @Test
        @TestMetadata(value="noNullCheckOnThisInDefaultMethod.kt")
        public void testNoNullCheckOnThisInDefaultMethod() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noNullCheckOnThisInDefaultMethod.kt");
        }

        @Test
        @TestMetadata(value="noPrivateMemberInJavaInterface.kt")
        public void testNoPrivateMemberInJavaInterface() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noPrivateMemberInJavaInterface.kt");
        }

        @Test
        @TestMetadata(value="traitImplGeneratedOnce.kt")
        public void testTraitImplGeneratedOnce() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/traitImplGeneratedOnce.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/innerClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InnerClasses {
        @Test
        public void testAllFilesPresentInInnerClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="nestedClassInAnnotationArgument.kt")
        public void testNestedClassInAnnotationArgument() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgument.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/inlineClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="asCastForInlineClass.kt")
        public void testAsCastForInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/asCastForInlineClass.kt");
        }

        @Test
        @TestMetadata(value="assertionsForParametersOfInlineClassTypes.kt")
        public void testAssertionsForParametersOfInlineClassTypes() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/assertionsForParametersOfInlineClassTypes.kt");
        }

        @Test
        @TestMetadata(value="boxInlineClassInsideElvisWithNullConstant.kt")
        public void testBoxInlineClassInsideElvisWithNullConstant() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassInsideElvisWithNullConstant.kt");
        }

        @Test
        @TestMetadata(value="boxInlineClassesOnPassingToVarargs.kt")
        public void testBoxInlineClassesOnPassingToVarargs() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassesOnPassingToVarargs.kt");
        }

        @Test
        @TestMetadata(value="boxMethodCalledByInlineClass.kt")
        public void testBoxMethodCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxMethodCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="boxResultAfterConstructorCall.kt")
        public void testBoxResultAfterConstructorCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultAfterConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="boxResultInlineClassOfConstructorCall.kt")
        public void testBoxResultInlineClassOfConstructorCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultInlineClassOfConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="boxThisOfInlineClass.kt")
        public void testBoxThisOfInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxThisOfInlineClass.kt");
        }

        @Test
        @TestMetadata(value="boxUnboxInlineClassFromMethodReturnType.kt")
        public void testBoxUnboxInlineClassFromMethodReturnType() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInlineClassFromMethodReturnType.kt");
        }

        @Test
        @TestMetadata(value="boxUnboxInsideLambdaAsLastExpression.kt")
        public void testBoxUnboxInsideLambdaAsLastExpression() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInsideLambdaAsLastExpression.kt");
        }

        @Test
        @TestMetadata(value="boxUnboxOfInlineClassesWithFunctionalTypes.kt")
        public void testBoxUnboxOfInlineClassesWithFunctionalTypes() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOfInlineClassesWithFunctionalTypes.kt");
        }

        @Test
        @TestMetadata(value="boxUnboxOnInlinedParameters.kt")
        public void testBoxUnboxOnInlinedParameters() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOnInlinedParameters.kt");
        }

        @Test
        @TestMetadata(value="boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt")
        public void testBoxingForNonLocalAndLabeledReturnsOfInlineClasses() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt");
        }

        @Test
        @TestMetadata(value="callMemberMethodsInsideInlineClass.kt")
        public void testCallMemberMethodsInsideInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/callMemberMethodsInsideInlineClass.kt");
        }

        @Test
        @TestMetadata(value="checkBoxingInInlineClass.kt")
        public void testCheckBoxingInInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkBoxingInInlineClass.kt");
        }

        @Test
        @TestMetadata(value="checkOuterInlineFunctionCall.kt")
        public void testCheckOuterInlineFunctionCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkOuterInlineFunctionCall.kt");
        }

        @Test
        @TestMetadata(value="constructorBridge.kt")
        public void testConstructorBridge() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorBridge.kt");
        }

        @Test
        @TestMetadata(value="constructorWithDefaultArguments.kt")
        public void testConstructorWithDefaultArguments() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorWithDefaultArguments.kt");
        }

        @Test
        @TestMetadata(value="defaultParametersDontBox.kt")
        public void testDefaultParametersDontBox() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/defaultParametersDontBox.kt");
        }

        @Test
        @TestMetadata(value="delegatedPropertyMangling.kt")
        public void testDelegatedPropertyMangling() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/delegatedPropertyMangling.kt");
        }

        @Test
        @TestMetadata(value="equalsDoesNotBox.kt")
        public void testEqualsDoesNotBox() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsDoesNotBox.kt");
        }

        @Test
        @TestMetadata(value="equalsIsCalledByInlineClass.kt")
        public void testEqualsIsCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsIsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="factoryMethodForSecondaryConstructorsCalledByInlineClass.kt")
        public void testFactoryMethodForSecondaryConstructorsCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/factoryMethodForSecondaryConstructorsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="functionsWithInlineClassParametersHaveStableMangledNames.kt")
        public void testFunctionsWithInlineClassParametersHaveStableMangledNames() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/functionsWithInlineClassParametersHaveStableMangledNames.kt");
        }

        @Test
        @TestMetadata(value="generationOfAccessorToUnderlyingValue.kt")
        public void testGenerationOfAccessorToUnderlyingValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/generationOfAccessorToUnderlyingValue.kt");
        }

        @Test
        @TestMetadata(value="genericNoUnbox.kt")
        public void testGenericNoUnbox() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/genericNoUnbox.kt");
        }

        @Test
        @TestMetadata(value="hashCodeIsCalledByInlineClass.kt")
        public void testHashCodeIsCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/hashCodeIsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="inlineClassBoxingOnAssignment.kt")
        public void testInlineClassBoxingOnAssignment() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnAssignment.kt");
        }

        @Test
        @TestMetadata(value="inlineClassBoxingOnFunctionCall.kt")
        public void testInlineClassBoxingOnFunctionCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnFunctionCall.kt");
        }

        @Test
        @TestMetadata(value="inlineClassBoxingUnboxingInsideInlinedLambda.kt")
        public void testInlineClassBoxingUnboxingInsideInlinedLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingUnboxingInsideInlinedLambda.kt");
        }

        @Test
        @TestMetadata(value="inlineClassInGeneratedToString.kt")
        public void testInlineClassInGeneratedToString() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInGeneratedToString.kt");
        }

        @Test
        @TestMetadata(value="inlineClassInStringTemplate.kt")
        public void testInlineClassInStringTemplate() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInStringTemplate.kt");
        }

        @Test
        @TestMetadata(value="inlineClassesUnboxingAfterAssertionOperator.kt")
        public void testInlineClassesUnboxingAfterAssertionOperator() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassesUnboxingAfterAssertionOperator.kt");
        }

        @Test
        @TestMetadata(value="interfaceDefaultImplStubs.kt")
        public void testInterfaceDefaultImplStubs() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/interfaceDefaultImplStubs.kt");
        }

        @Test
        @TestMetadata(value="isCheckForInlineClass.kt")
        public void testIsCheckForInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/isCheckForInlineClass.kt");
        }

        @Test
        @TestMetadata(value="mangledInlineClassInterfaceImplementation.kt")
        public void testMangledInlineClassInterfaceImplementation() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledInlineClassInterfaceImplementation.kt");
        }

        @Test
        @TestMetadata(value="mangledSamWrappers.kt")
        public void testMangledSamWrappers() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappers.kt");
        }

        @Test
        @TestMetadata(value="mangledSamWrappersIndy.kt")
        public void testMangledSamWrappersIndy() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersIndy.kt");
        }

        @Test
        @TestMetadata(value="mangledSamWrappersOld.kt")
        public void testMangledSamWrappersOld() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersOld.kt");
        }

        @Test
        @TestMetadata(value="noActualCallsOfInlineFunctionsOfInlineClass.kt")
        public void testNoActualCallsOfInlineFunctionsOfInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noActualCallsOfInlineFunctionsOfInlineClass.kt");
        }

        @Test
        @TestMetadata(value="noAssertionsForInlineClassesBasedOnNullableTypes.kt")
        public void testNoAssertionsForInlineClassesBasedOnNullableTypes() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noAssertionsForInlineClassesBasedOnNullableTypes.kt");
        }

        @Test
        @TestMetadata(value="noBoxingInMethod.kt")
        public void testNoBoxingInMethod() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingInMethod.kt");
        }

        @Test
        @TestMetadata(value="noBoxingOnCastOperations.kt")
        public void testNoBoxingOnCastOperations() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOnCastOperations.kt");
        }

        @Test
        @TestMetadata(value="noBoxingOperationsOnNonTrivialSpread.kt")
        public void testNoBoxingOperationsOnNonTrivialSpread() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOperationsOnNonTrivialSpread.kt");
        }

        @Test
        @TestMetadata(value="noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt")
        public void testNoBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt");
        }

        @Test
        @TestMetadata(value="noManglingForFunctionsWithJvmName.kt")
        public void testNoManglingForFunctionsWithJvmName() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noManglingForFunctionsWithJvmName.kt");
        }

        @Test
        @TestMetadata(value="noReturnTypeMangling.kt")
        public void testNoReturnTypeMangling() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noReturnTypeMangling.kt");
        }

        @Test
        @TestMetadata(value="nonOverridingMethodsAreCalledByInlineClass.kt")
        public void testNonOverridingMethodsAreCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/nonOverridingMethodsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="overridingMethodsAreCalledByInlineClass.kt")
        public void testOverridingMethodsAreCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/overridingMethodsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="passInlineClassesWithSpreadOperatorToVarargs.kt")
        public void testPassInlineClassesWithSpreadOperatorToVarargs() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/passInlineClassesWithSpreadOperatorToVarargs.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorCalledByInlineClass.kt")
        public void testPrimaryConstructorCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/primaryConstructorCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="propertyAccessorsAreCalledByInlineClass.kt")
        public void testPropertyAccessorsAreCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertyAccessorsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="propertySetterWithInlineClassTypeArgument.kt")
        public void testPropertySetterWithInlineClassTypeArgument() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertySetterWithInlineClassTypeArgument.kt");
        }

        @Test
        @TestMetadata(value="resultApiDoesntCallSpecializedEquals.kt")
        public void testResultApiDoesntCallSpecializedEquals() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntCallSpecializedEquals.kt");
        }

        @Test
        @TestMetadata(value="resultApiDoesntUseBox.kt")
        public void testResultApiDoesntUseBox() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntUseBox.kt");
        }

        @Test
        @TestMetadata(value="resultApiEqualsDoesntBox.kt")
        public void testResultApiEqualsDoesntBox() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiEqualsDoesntBox.kt");
        }

        @Test
        @TestMetadata(value="resultApiRunCatchingDoesntBox.kt")
        public void testResultApiRunCatchingDoesntBox() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiRunCatchingDoesntBox.kt");
        }

        @Test
        @TestMetadata(value="resultApiStringInterpolationDoesntBox.kt")
        public void testResultApiStringInterpolationDoesntBox() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiStringInterpolationDoesntBox.kt");
        }

        @Test
        @TestMetadata(value="resultMangling.kt")
        public void testResultMangling() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultMangling.kt");
        }

        @Test
        @TestMetadata(value="skipCallToUnderlyingValueOfInlineClass.kt")
        public void testSkipCallToUnderlyingValueOfInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/skipCallToUnderlyingValueOfInlineClass.kt");
        }

        @Test
        @TestMetadata(value="suspendFunctionMangling.kt")
        public void testSuspendFunctionMangling() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/suspendFunctionMangling.kt");
        }

        @Test
        @TestMetadata(value="toStringOfInlineClassValue.kt")
        public void testToStringOfInlineClassValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfInlineClassValue.kt");
        }

        @Test
        @TestMetadata(value="toStringOfReferenceInlineClassValue.kt")
        public void testToStringOfReferenceInlineClassValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfReferenceInlineClassValue.kt");
        }

        @Test
        @TestMetadata(value="uIntArrayIteratorWithoutBoxing.kt")
        public void testUIntArrayIteratorWithoutBoxing() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArrayIteratorWithoutBoxing.kt");
        }

        @Test
        @TestMetadata(value="uIntArraySwapBoxing.kt")
        public void testUIntArraySwapBoxing() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArraySwapBoxing.kt");
        }

        @Test
        @TestMetadata(value="unboxInlineClassAfterElvis.kt")
        public void testUnboxInlineClassAfterElvis() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterElvis.kt");
        }

        @Test
        @TestMetadata(value="unboxInlineClassAfterSafeCall.kt")
        public void testUnboxInlineClassAfterSafeCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterSafeCall.kt");
        }

        @Test
        @TestMetadata(value="unboxInlineClassFromParameterizedType.kt")
        public void testUnboxInlineClassFromParameterizedType() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassFromParameterizedType.kt");
        }

        @Test
        @TestMetadata(value="unboxInlineClassesAfterSmartCasts.kt")
        public void testUnboxInlineClassesAfterSmartCasts() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassesAfterSmartCasts.kt");
        }

        @Test
        @TestMetadata(value="unboxMethodCalledByInlineClass.kt")
        public void testUnboxMethodCalledByInlineClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxMethodCalledByInlineClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/inlineArgsInPlace")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InlineArgsInPlace {
        @Test
        public void testAllFilesPresentInInlineArgsInPlace() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="kotlinMathMax.kt")
        public void testKotlinMathMax() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/kotlinMathMax.kt");
        }

        @Test
        @TestMetadata(value="println.kt")
        public void testPrintln() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/println.kt");
        }

        @Test
        @TestMetadata(value="sin.kt")
        public void testSin() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/sin.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/inline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Inline {
        @Test
        public void testAllFilesPresentInInline() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="defaultLambda.kt")
        public void testDefaultLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/defaultLambda.kt");
        }

        @Test
        @TestMetadata(value="deleteClassOnTransformation.kt")
        public void testDeleteClassOnTransformation() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/deleteClassOnTransformation.kt");
        }

        @Test
        @TestMetadata(value="finallyMarkers.kt")
        public void testFinallyMarkers() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/finallyMarkers.kt");
        }

        @Test
        @TestMetadata(value="inlineArgumentSlots.kt")
        public void testInlineArgumentSlots() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineArgumentSlots.kt");
        }

        @Test
        @TestMetadata(value="inlineReturnsNothing1.kt")
        public void testInlineReturnsNothing1() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing1.kt");
        }

        @Test
        @TestMetadata(value="inlineReturnsNothing2.kt")
        public void testInlineReturnsNothing2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing2.kt");
        }

        @Test
        @TestMetadata(value="inlineReturnsNothing3.kt")
        public void testInlineReturnsNothing3() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing3.kt");
        }

        @Test
        @TestMetadata(value="inlineSuspendReifiedNoSpilling.kt")
        public void testInlineSuspendReifiedNoSpilling() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineSuspendReifiedNoSpilling.kt");
        }

        @Test
        @TestMetadata(value="interfaceDefaultMethod.kt")
        public void testInterfaceDefaultMethod() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/interfaceDefaultMethod.kt");
        }

        @Test
        @TestMetadata(value="linenumberForOneParametersArgumentCall.kt")
        public void testLinenumberForOneParametersArgumentCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/linenumberForOneParametersArgumentCall.kt");
        }

        @Test
        @TestMetadata(value="noFakeVariableForInlineOnlyFun.kt")
        public void testNoFakeVariableForInlineOnlyFun() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFun.kt");
        }

        @Test
        @TestMetadata(value="noFakeVariableForInlineOnlyFunFromStdlib.kt")
        public void testNoFakeVariableForInlineOnlyFunFromStdlib() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunFromStdlib.kt");
        }

        @Test
        @TestMetadata(value="noFakeVariableForInlineOnlyFunMap.kt")
        public void testNoFakeVariableForInlineOnlyFunMap() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunMap.kt");
        }

        @Test
        @TestMetadata(value="noFakeVariableForInlineOnlyFunWithLambda.kt")
        public void testNoFakeVariableForInlineOnlyFunWithLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunWithLambda.kt");
        }

        @Test
        @TestMetadata(value="noSynAccessor.kt")
        public void testNoSynAccessor() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessor.kt");
        }

        @Test
        @TestMetadata(value="noSynAccessorToDirectFieldAccess.kt")
        public void testNoSynAccessorToDirectFieldAccess() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToDirectFieldAccess.kt");
        }

        @Test
        @TestMetadata(value="noSynAccessorToSuper.kt")
        public void testNoSynAccessorToSuper() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToSuper.kt");
        }

        @Test
        @TestMetadata(value="notSplitedExceptionTable.kt")
        public void testNotSplitedExceptionTable() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/notSplitedExceptionTable.kt");
        }

        @Test
        @TestMetadata(value="reifiedSafeAsWithMutable.kt")
        public void testReifiedSafeAsWithMutable() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/reifiedSafeAsWithMutable.kt");
        }

        @Test
        @TestMetadata(value="remappedLocalVar.kt")
        public void testRemappedLocalVar() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/remappedLocalVar.kt");
        }

        @Test
        @TestMetadata(value="removedFinallyMarkers.kt")
        public void testRemovedFinallyMarkers() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/removedFinallyMarkers.kt");
        }

        @Test
        @TestMetadata(value="specialEnumFunction.kt")
        public void testSpecialEnumFunction() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/specialEnumFunction.kt");
        }

        @Test
        @TestMetadata(value="splitedExceptionTable.kt")
        public void testSplitedExceptionTable() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/splitedExceptionTable.kt");
        }

        @Test
        @TestMetadata(value="whenMappingOnCallSite.kt")
        public void testWhenMappingOnCallSite() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/whenMappingOnCallSite.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/inline/property")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Property {
            @Test
            public void testAllFilesPresentInProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/property/simple.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/ieee754")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Ieee754 {
        @Test
        public void testAllFilesPresentInIeee754() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="nullableDoubleEquals.kt")
        public void testNullableDoubleEquals() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleEquals.kt");
        }

        @Test
        @TestMetadata(value="nullableDoubleNotEquals.kt")
        public void testNullableDoubleNotEquals() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleNotEquals.kt");
        }

        @Test
        @TestMetadata(value="nullableFloatEquals.kt")
        public void testNullableFloatEquals() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatEquals.kt");
        }

        @Test
        @TestMetadata(value="nullableFloatNotEquals.kt")
        public void testNullableFloatNotEquals() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatNotEquals.kt");
        }

        @Test
        @TestMetadata(value="smartCastsForDouble.kt")
        public void testSmartCastsForDouble() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForDouble.kt");
        }

        @Test
        @TestMetadata(value="smartCastsForFloat.kt")
        public void testSmartCastsForFloat() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForFloat.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/when.kt");
        }

        @Test
        @TestMetadata(value="whenNullableSmartCast.kt")
        public void testWhenNullableSmartCast() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/whenNullableSmartCast.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/hashCode")
    @TestDataPath(value="$PROJECT_ROOT")
    public class HashCode {
        @Test
        public void testAllFilesPresentInHashCode() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="interfaceHashCode.kt")
        public void testInterfaceHashCode() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCode.kt");
        }

        @Test
        @TestMetadata(value="interfaceHashCodeWithSmartCast.kt")
        public void testInterfaceHashCodeWithSmartCast() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCodeWithSmartCast.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ForLoop {
        @Test
        public void testAllFilesPresentInForLoop() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="forInCharSequence.kt")
        public void testForInCharSequence() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequence.kt");
        }

        @Test
        @TestMetadata(value="forInCharSequenceTypeParameter.kt")
        public void testForInCharSequenceTypeParameter() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="forInDownToCharMinValue.kt")
        public void testForInDownToCharMinValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToCharMinValue.kt");
        }

        @Test
        @TestMetadata(value="forInDownToIntMinValue.kt")
        public void testForInDownToIntMinValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToIntMinValue.kt");
        }

        @Test
        @TestMetadata(value="forInDownToLongConstNoUnderflow.kt")
        public void testForInDownToLongConstNoUnderflow() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongConstNoUnderflow.kt");
        }

        @Test
        @TestMetadata(value="forInDownToLongMinValue.kt")
        public void testForInDownToLongMinValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongMinValue.kt");
        }

        @Test
        @TestMetadata(value="forInObjectArray.kt")
        public void testForInObjectArray() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInObjectArray.kt");
        }

        @Test
        @TestMetadata(value="forInPrimitiveArray.kt")
        public void testForInPrimitiveArray() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInPrimitiveArray.kt");
        }

        @Test
        @TestMetadata(value="forInRangeInlinedFromStdlib.kt")
        public void testForInRangeInlinedFromStdlib() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeInlinedFromStdlib.kt");
        }

        @Test
        @TestMetadata(value="forInRangeSpecializedToUntil.kt")
        public void testForInRangeSpecializedToUntil() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeSpecializedToUntil.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToCharConst.kt")
        public void testForInRangeToCharConst() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharConst.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToCharMaxValue.kt")
        public void testForInRangeToCharMaxValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharMaxValue.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToConst.kt")
        public void testForInRangeToConst() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToConst.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToIntMaxValue.kt")
        public void testForInRangeToIntMaxValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToIntMaxValue.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToLongConst.kt")
        public void testForInRangeToLongConst() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongConst.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToLongMaxValue.kt")
        public void testForInRangeToLongMaxValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongMaxValue.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToQualifiedConst.kt")
        public void testForInRangeToQualifiedConst() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToQualifiedConst.kt");
        }

        @Test
        @TestMetadata(value="forInRangeWithImplicitReceiver.kt")
        public void testForInRangeWithImplicitReceiver() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithImplicitReceiver.kt");
        }

        @Test
        @TestMetadata(value="forInStringSpecialized.kt")
        public void testForInStringSpecialized() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInStringSpecialized.kt");
        }

        @Test
        @TestMetadata(value="forIntInDownTo.kt")
        public void testForIntInDownTo() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forIntInDownTo.kt");
        }

        @Test
        @TestMetadata(value="iincGeneration.kt")
        public void testIincGeneration() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/iincGeneration.kt");
        }

        @Test
        @TestMetadata(value="intrinsicArrayConstructorsUseCounterLoop.kt")
        public void testIntrinsicArrayConstructorsUseCounterLoop() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/intrinsicArrayConstructorsUseCounterLoop.kt");
        }

        @Test
        @TestMetadata(value="loopVarInterval.kt")
        public void testLoopVarInterval() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/loopVarInterval.kt");
        }

        @Test
        @TestMetadata(value="primitiveLiteralRange1.kt")
        public void testPrimitiveLiteralRange1() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange1.kt");
        }

        @Test
        @TestMetadata(value="primitiveLiteralRange2.kt")
        public void testPrimitiveLiteralRange2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange2.kt");
        }

        @Test
        @TestMetadata(value="primitiveProgression.kt")
        public void testPrimitiveProgression() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveProgression.kt");
        }

        @Test
        @TestMetadata(value="primitiveRange.kt")
        public void testPrimitiveRange() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveRange.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/unsigned")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Unsigned {
            @Test
            public void testAllFilesPresentInUnsigned() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/unsigned"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInConstBoundUnsignedRange.kt")
            public void testForInConstBoundUnsignedRange() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInConstBoundUnsignedRange.kt");
            }

            @Test
            @TestMetadata(value="forInDownToUIntMinValue.kt")
            public void testForInDownToUIntMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToUIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInDownToULongMinValue.kt")
            public void testForInDownToULongMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToULongMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInOptimizableUnsignedRange.kt")
            public void testForInOptimizableUnsignedRange() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInOptimizableUnsignedRange.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToUIntMaxValue.kt")
            public void testForInRangeToUIntMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToUIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToULongMaxValue.kt")
            public void testForInRangeToULongMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToULongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUnsignedArray.kt")
            public void testForInUnsignedArray() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArray.kt");
            }

            @Test
            @TestMetadata(value="forInUnsignedArrayIndices.kt")
            public void testForInUnsignedArrayIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="forInUnsignedArrayWithIndex.kt")
            public void testForInUnsignedArrayWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInUntilUIntMaxValue.kt")
            public void testForInUntilUIntMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilUIntMinValue.kt")
            public void testForInUntilUIntMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilULongMaxValue.kt")
            public void testForInUntilULongMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilULongMinValue.kt")
            public void testForInUntilULongMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMinValue.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/stepped")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Stepped {
            @Test
            public void testAllFilesPresentInStepped() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/stepped"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInUntil")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInUntil {
            @Test
            public void testAllFilesPresentInForInUntil() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInUntilChar.kt")
            public void testForInUntilChar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilChar.kt");
            }

            @Test
            @TestMetadata(value="forInUntilCharMaxValue.kt")
            public void testForInUntilCharMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilCharMinValue.kt")
            public void testForInUntilCharMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilInt.kt")
            public void testForInUntilInt() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilInt.kt");
            }

            @Test
            @TestMetadata(value="forInUntilIntMaxValue.kt")
            public void testForInUntilIntMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilIntMinValue.kt")
            public void testForInUntilIntMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilLong.kt")
            public void testForInUntilLong() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLong.kt");
            }

            @Test
            @TestMetadata(value="forInUntilLongMaxValue.kt")
            public void testForInUntilLongMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilLongMinValue.kt")
            public void testForInUntilLongMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMinValue.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInSequenceWithIndex {
            @Test
            public void testAllFilesPresentInForInSequenceWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInEmptySequenceWithIndex.kt")
            public void testForInEmptySequenceWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceTypeParameterWithIndex.kt")
            public void testForInSequenceTypeParameterWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndex.kt")
            public void testForInSequenceWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndexNoElementVar.kt")
            public void testForInSequenceWithIndexNoElementVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndexNoIndexVar.kt")
            public void testForInSequenceWithIndexNoIndexVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndexThrowsCME.kt")
            public void testForInSequenceWithIndexThrowsCME() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInReversed")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInReversed {
            @Test
            public void testAllFilesPresentInForInReversed() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInReversedArrayIndices.kt")
            public void testForInReversedArrayIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="forInReversedCharSequenceIndices.kt")
            public void testForInReversedCharSequenceIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCharSequenceIndices.kt");
            }

            @Test
            @TestMetadata(value="forInReversedCollectionIndices.kt")
            public void testForInReversedCollectionIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCollectionIndices.kt");
            }

            @Test
            @TestMetadata(value="forInReversedDownTo.kt")
            public void testForInReversedDownTo() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedDownTo.kt");
            }

            @Test
            @TestMetadata(value="forInReversedEmptyRangeLiteral.kt")
            public void testForInReversedEmptyRangeLiteral() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedEmptyRangeLiteral.kt");
            }

            @Test
            @TestMetadata(value="forInReversedRange.kt")
            public void testForInReversedRange() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRange.kt");
            }

            @Test
            @TestMetadata(value="forInReversedRangeLiteral.kt")
            public void testForInReversedRangeLiteral() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRangeLiteral.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedArrayIndices.kt")
            public void testForInReversedReversedArrayIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedDownTo.kt")
            public void testForInReversedReversedDownTo() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedDownTo.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedRange.kt")
            public void testForInReversedReversedRange() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedRange.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedReversedRange.kt")
            public void testForInReversedReversedReversedRange() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedReversedRange.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedUntil.kt")
            public void testForInReversedReversedUntil() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedUntil.kt");
            }

            @Test
            @TestMetadata(value="forInReversedUntil.kt")
            public void testForInReversedUntil() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedUntil.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInRangeWithUpperBoundMinus1 {
            @Test
            public void testAllFilesPresentInForInRangeWithUpperBoundMinus1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInRangeUntil {
            @Test
            public void testAllFilesPresentInForInRangeUntil() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInRangeUntilChar.kt")
            public void testForInRangeUntilChar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilChar.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilCharMaxValue.kt")
            public void testForInRangeUntilCharMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilCharMinValue.kt")
            public void testForInRangeUntilCharMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilInt.kt")
            public void testForInRangeUntilInt() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilInt.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilIntMaxValue.kt")
            public void testForInRangeUntilIntMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilIntMinValue.kt")
            public void testForInRangeUntilIntMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilLong.kt")
            public void testForInRangeUntilLong() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLong.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilLongMaxValue.kt")
            public void testForInRangeUntilLongMaxValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilLongMinValue.kt")
            public void testForInRangeUntilLongMinValue() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMinValue.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInProgressionWithIndex {
            @Test
            public void testAllFilesPresentInForInProgressionWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInDownToWithIndex.kt")
            public void testForInDownToWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInDownToWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInIndicesWithIndex.kt")
            public void testForInIndicesWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInIndicesWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToWithIndex.kt")
            public void testForInRangeToWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInRangeToWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInReversedStepWithIndex.kt")
            public void testForInReversedStepWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedStepWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInReversedWithIndex.kt")
            public void testForInReversedWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInStepReversedWithIndex.kt")
            public void testForInStepReversedWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepReversedWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInStepWithIndex.kt")
            public void testForInStepWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInUntilWithIndex.kt")
            public void testForInUntilWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInUntilWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInWithIndexNoIndexOrElementVar.kt")
            public void testForInWithIndexNoIndexOrElementVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNoIndexOrElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInWithIndexNotDestructured.kt")
            public void testForInWithIndexNotDestructured() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNotDestructured.kt");
            }

            @Test
            @TestMetadata(value="forInWithIndexReversed.kt")
            public void testForInWithIndexReversed() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexReversed.kt");
            }

            @Test
            @TestMetadata(value="forInWithIndexWithIndex.kt")
            public void testForInWithIndexWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexWithIndex.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInIterableWithIndex {
            @Test
            public void testAllFilesPresentInForInIterableWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInEmptyListWithIndex.kt")
            public void testForInEmptyListWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInEmptyListWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInIterableTypeParameterWithIndex.kt")
            public void testForInIterableTypeParameterWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInListWithIndex.kt")
            public void testForInListWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInListWithIndexNoElementVar.kt")
            public void testForInListWithIndexNoElementVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInListWithIndexNoIndexVar.kt")
            public void testForInListWithIndexNoIndexVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata(value="forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInListWithIndexWithExplicitlyTypedIndexVariable() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInIndices")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInIndices {
            @Test
            public void testAllFilesPresentInForInIndices() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIndices"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInArrayListIndices.kt")
            public void testForInArrayListIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInArrayListIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCharSequenceIndices.kt")
            public void testForInCharSequenceIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCharSequenceTypeParameterIndices.kt")
            public void testForInCharSequenceTypeParameterIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceTypeParameterIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCollectionImplicitReceiverIndices.kt")
            public void testForInCollectionImplicitReceiverIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionImplicitReceiverIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCollectionIndices.kt")
            public void testForInCollectionIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCollectionTypeParameterIndices.kt")
            public void testForInCollectionTypeParameterIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionTypeParameterIndices.kt");
            }

            @Test
            @TestMetadata(value="forInNonOptimizedIndices.kt")
            public void testForInNonOptimizedIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInNonOptimizedIndices.kt");
            }

            @Test
            @TestMetadata(value="forInObjectArrayIndices.kt")
            public void testForInObjectArrayIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInObjectArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="forInPrimitiveArrayIndices.kt")
            public void testForInPrimitiveArrayIndices() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInPrimitiveArrayIndices.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInCharSequenceWithIndex {
            @Test
            public void testAllFilesPresentInForInCharSequenceWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInCharSequenceWithIndex.kt")
            public void testForInCharSequenceWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInEmptyStringWithIndex.kt")
            public void testForInEmptyStringWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInStringWithIndex.kt")
            public void testForInStringWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInStringWithIndexNoElementVar.kt")
            public void testForInStringWithIndexNoElementVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInStringWithIndexNoIndexVar.kt")
            public void testForInStringWithIndexNoIndexVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata(value="forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInArrayWithIndex {
            @Test
            public void testAllFilesPresentInForInArrayWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInArrayWithIndexNoElementVar.kt")
            public void testForInArrayWithIndexNoElementVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInArrayWithIndexNoIndexVar.kt")
            public void testForInArrayWithIndexNoIndexVar() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata(value="forInEmptyArrayWithIndex.kt")
            public void testForInEmptyArrayWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInIntArrayWithIndex.kt")
            public void testForInIntArrayWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInIntArrayWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInObjectArrayWithIndex.kt")
            public void testForInObjectArrayWithIndex() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/fieldsForCapturedValues")
    @TestDataPath(value="$PROJECT_ROOT")
    public class FieldsForCapturedValues {
        @Test
        public void testAllFilesPresentInFieldsForCapturedValues() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="constructorOnly.kt")
        public void testConstructorOnly() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/constructorOnly.kt");
        }

        @Test
        @TestMetadata(value="extensionLambdaExtensionReceiver.kt")
        public void testExtensionLambdaExtensionReceiver() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionLambdaExtensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="extensionReceiver.kt")
        public void testExtensionReceiver() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="innerAndOuterThis.kt")
        public void testInnerAndOuterThis() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/innerAndOuterThis.kt");
        }

        @Test
        @TestMetadata(value="labeledExtensionLambdaExtensionReceiver.kt")
        public void testLabeledExtensionLambdaExtensionReceiver() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/labeledExtensionLambdaExtensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="multipleExtensionReceivers.kt")
        public void testMultipleExtensionReceivers() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/multipleExtensionReceivers.kt");
        }

        @Test
        @TestMetadata(value="outerThis.kt")
        public void testOuterThis() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThis.kt");
        }

        @Test
        @TestMetadata(value="outerThisInInnerConstructor.kt")
        public void testOuterThisInInnerConstructor() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerConstructor.kt");
        }

        @Test
        @TestMetadata(value="outerThisInInnerInitBlock.kt")
        public void testOuterThisInInnerInitBlock() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerInitBlock.kt");
        }

        @Test
        @TestMetadata(value="this.kt")
        public void testThis() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/this.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/exclExcl")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ExclExcl {
        @Test
        public void testAllFilesPresentInExclExcl() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="exclExclOnPlatformType.kt")
        public void testExclExclOnPlatformType() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/exclExcl/exclExclOnPlatformType.kt");
        }

        @Test
        @TestMetadata(value="primitive.kt")
        public void testPrimitive() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/exclExcl/primitive.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/enum")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Enum {
        @Test
        public void testAllFilesPresentInEnum() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="constructorAccessors.kt")
        public void testConstructorAccessors() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/constructorAccessors.kt");
        }

        @Test
        @TestMetadata(value="enumCheckcasts.kt")
        public void testEnumCheckcasts() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumCheckcasts.kt");
        }

        @Test
        @TestMetadata(value="kt18731.kt")
        public void testKt18731() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt18731.kt");
        }

        @Test
        @TestMetadata(value="kt18731_2.kt")
        public void testKt18731_2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt18731_2.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/disabledOptimizations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DisabledOptimizations {
        @Test
        public void testAllFilesPresentInDisabledOptimizations() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/disabledOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="noJumpInLastBranch.kt")
        public void testNoJumpInLastBranch() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInLastBranch.kt");
        }

        @Test
        @TestMetadata(value="noJumpInSingleBranch.kt")
        public void testNoJumpInSingleBranch() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInSingleBranch.kt");
        }

        @Test
        @TestMetadata(value="noObjectCastAfterReification.kt")
        public void testNoObjectCastAfterReification() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noObjectCastAfterReification.kt");
        }

        @Test
        @TestMetadata(value="noUnitInstanceInDefaultParameterInitialization.kt")
        public void testNoUnitInstanceInDefaultParameterInitialization() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceInDefaultParameterInitialization.kt");
        }

        @Test
        @TestMetadata(value="noUnitInstanceOnVoidFunctionCall.kt")
        public void testNoUnitInstanceOnVoidFunctionCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceOnVoidFunctionCall.kt");
        }

        @Test
        @TestMetadata(value="noUnusedLabel.kt")
        public void testNoUnusedLabel() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnusedLabel.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/directInvoke")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DirectInvoke {
        @Test
        public void testAllFilesPresentInDirectInvoke() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/directInvoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="callableReference.kt")
        public void testCallableReference() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/callableReference.kt");
        }

        @Test
        @TestMetadata(value="inplaceClosure.kt")
        public void testInplaceClosure() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/inplaceClosure.kt");
        }

        @Test
        @TestMetadata(value="localFun.kt")
        public void testLocalFun() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/localFun.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/defaultArguments")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="inheritedInterfaceFunction.kt")
        public void testInheritedInterfaceFunction() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/inheritedInterfaceFunction.kt");
        }

        @Test
        @TestMetadata(value="kt11962.kt")
        public void testKt11962() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/kt11962.kt");
        }

        @Test
        @TestMetadata(value="localVariablesInInlinedDefaultStubs.kt")
        public void testLocalVariablesInInlinedDefaultStubs() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/localVariablesInInlinedDefaultStubs.kt");
        }

        @Test
        @TestMetadata(value="maskAndArgumentElimination.kt")
        public void testMaskAndArgumentElimination() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskAndArgumentElimination.kt");
        }

        @Test
        @TestMetadata(value="maskCheckSequence.kt")
        public void testMaskCheckSequence() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskCheckSequence.kt");
        }

        @Test
        @TestMetadata(value="methodHandlerElimination.kt")
        public void testMethodHandlerElimination() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/methodHandlerElimination.kt");
        }

        @Test
        @TestMetadata(value="noAccessorForDefault.kt")
        public void testNoAccessorForDefault() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAccessorForDefault.kt");
        }

        @Test
        @TestMetadata(value="noAnonymousObjectRegenerationInDefaultStub.kt")
        public void testNoAnonymousObjectRegenerationInDefaultStub() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAnonymousObjectRegenerationInDefaultStub.kt");
        }

        @Test
        @TestMetadata(value="noEmptyArray.kt")
        public void testNoEmptyArray() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noEmptyArray.kt");
        }

        @Test
        @TestMetadata(value="noSyntheticParameters.kt")
        public void testNoSyntheticParameters() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noSyntheticParameters.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/deadCodeElimination")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DeadCodeElimination {
        @Test
        public void testAllFilesPresentInDeadCodeElimination() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrayConstructor.kt")
        public void testArrayConstructor() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/arrayConstructor.kt");
        }

        @Test
        @TestMetadata(value="boxing.kt")
        public void testBoxing() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxing.kt");
        }

        @Test
        @TestMetadata(value="boxingNotOptimizable.kt")
        public void testBoxingNotOptimizable() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxingNotOptimizable.kt");
        }

        @Test
        @TestMetadata(value="emptyVariableRange.kt")
        public void testEmptyVariableRange() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/emptyVariableRange.kt");
        }

        @Test
        @TestMetadata(value="kt14357.kt")
        public void testKt14357() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/kt14357.kt");
        }

        @Test
        @TestMetadata(value="lastReturn.kt")
        public void testLastReturn() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/lastReturn.kt");
        }

        @Test
        @TestMetadata(value="literal.kt")
        public void testLiteral() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/literal.kt");
        }

        @Test
        @TestMetadata(value="simpleConstructor.kt")
        public void testSimpleConstructor() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructor.kt");
        }

        @Test
        @TestMetadata(value="simpleConstructorNotRedundant.kt")
        public void testSimpleConstructorNotRedundant() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundant.kt");
        }

        @Test
        @TestMetadata(value="simpleConstructorNotRedundantNotOptimizable.kt")
        public void testSimpleConstructorNotRedundantNotOptimizable() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundantNotOptimizable.kt");
        }

        @Test
        @TestMetadata(value="unusedPrimitiveAndObjectEquals.kt")
        public void testUnusedPrimitiveAndObjectEquals() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/unusedPrimitiveAndObjectEquals.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Coroutines {
        @Test
        public void testAllFilesPresentInCoroutines() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="crossinlineSuspendContinuation_1_3.kt")
        public void testCrossinlineSuspendContinuation_1_3() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/crossinlineSuspendContinuation_1_3.kt");
        }

        @Test
        @TestMetadata(value="doNotReassignContinuation.kt")
        public void testDoNotReassignContinuation() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/doNotReassignContinuation.kt");
        }

        @Test
        @TestMetadata(value="effectivelyInlineOnly.kt")
        public void testEffectivelyInlineOnly() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/effectivelyInlineOnly.kt");
        }

        @Test
        @TestMetadata(value="internalInlineSuspend.kt")
        public void testInternalInlineSuspend() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/internalInlineSuspend.kt");
        }

        @Test
        @TestMetadata(value="mergeLvt.kt")
        public void testMergeLvt() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/mergeLvt.kt");
        }

        @Test
        @TestMetadata(value="nonLocalReturn.kt")
        public void testNonLocalReturn() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata(value="returnUnitInLambda.kt")
        public void testReturnUnitInLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/returnUnitInLambda.kt");
        }

        @Test
        @TestMetadata(value="suspendMain.kt")
        public void testSuspendMain() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/suspendMain.kt");
        }

        @Test
        @TestMetadata(value="throwOnFailure.kt")
        public void testThrowOnFailure() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/throwOnFailure.kt");
        }

        @Test
        @TestMetadata(value="varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable.kt");
        }

        @Test
        @TestMetadata(value="varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/stateMachine")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StateMachine {
            @Test
            public void testAllFilesPresentInStateMachine() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt25893.kt")
            public void testKt25893() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/kt25893.kt");
            }

            @Test
            @TestMetadata(value="withTypeParameter.kt")
            public void testWithTypeParameter() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/withTypeParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class IntLikeVarSpilling {
            @Test
            public void testAllFilesPresentInIntLikeVarSpilling() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="complicatedMerge.kt")
            public void testComplicatedMerge() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt");
            }

            @Test
            @TestMetadata(value="i2bResult.kt")
            public void testI2bResult() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt");
            }

            @Test
            @TestMetadata(value="loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
            }

            @Test
            @TestMetadata(value="loadFromByteArray.kt")
            public void testLoadFromByteArray() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
            }

            @Test
            @TestMetadata(value="noVariableInTable.kt")
            public void testNoVariableInTable() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt");
            }

            @Test
            @TestMetadata(value="sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
            }

            @Test
            @TestMetadata(value="usedInArrayStore.kt")
            public void testUsedInArrayStore() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
            }

            @Test
            @TestMetadata(value="usedInMethodCall.kt")
            public void testUsedInMethodCall() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
            }

            @Test
            @TestMetadata(value="usedInPutfield.kt")
            public void testUsedInPutfield() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt");
            }

            @Test
            @TestMetadata(value="usedInVarStore.kt")
            public void testUsedInVarStore() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inlineClassBoxingInSuspendFunReturn_Primitive.kt")
            public void testInlineClassBoxingInSuspendFunReturn_Primitive() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/inlineClassBoxingInSuspendFunReturn_Primitive.kt");
            }

            @Test
            @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_Any.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_Any() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_Any.kt");
            }

            @Test
            @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_InlineAny.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_InlineAny() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_InlineAny.kt");
            }

            @Test
            @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_SameJvmType() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt");
            }

            @Test
            @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_String.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_String() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_String.kt");
            }

            @Test
            @TestMetadata(value="returnResult.kt")
            public void testReturnResult() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnResult.kt");
            }

            @Test
            @TestMetadata(value="returnStringOverride.kt")
            public void testReturnStringOverride() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnStringOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DestructuringInLambda {
            @Test
            public void testAllFilesPresentInDestructuringInLambda() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inlineSeparateFiles.kt")
            public void testInlineSeparateFiles() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda/inlineSeparateFiles.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/debug")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Debug {
            @Test
            public void testAllFilesPresentInDebug() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="continuationInLvt.kt")
            public void testContinuationInLvt() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/continuationInLvt.kt");
            }

            @Test
            @TestMetadata(value="localVariableCorrectLabel.kt")
            public void testLocalVariableCorrectLabel() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/localVariableCorrectLabel.kt");
            }

            @Test
            @TestMetadata(value="probeCoroutineSuspended.kt")
            public void testProbeCoroutineSuspended() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/probeCoroutineSuspended.kt");
            }

            @Test
            @TestMetadata(value="shrinkLvtTopLevel.kt")
            public void testShrinkLvtTopLevel() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/shrinkLvtTopLevel.kt");
            }

            @Test
            @TestMetadata(value="thisAndResultInLvt.kt")
            public void testThisAndResultInLvt() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/thisAndResultInLvt.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/controlStructures")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ControlStructures {
        @Test
        public void testAllFilesPresentInControlStructures() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="ifConsts.kt")
        public void testIfConsts() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/controlStructures/ifConsts.kt");
        }

        @Test
        @TestMetadata(value="kt17110.kt")
        public void testKt17110() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/controlStructures/kt17110.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/constructors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Constructors {
        @Test
        public void testAllFilesPresentInConstructors() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constructors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="enumPrimaryDefaults.kt")
        public void testEnumPrimaryDefaults() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/enumPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="inlineArgumentPrimaryDefaults.kt")
        public void testInlineArgumentPrimaryDefaults() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/inlineArgumentPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="inlinePrimaryDefaults.kt")
        public void testInlinePrimaryDefaults() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/inlinePrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="innerClassConstructor.kt")
        public void testInnerClassConstructor() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/innerClassConstructor.kt");
        }

        @Test
        @TestMetadata(value="innerPrimaryDefaults.kt")
        public void testInnerPrimaryDefaults() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/innerPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="internalPrimaryDefaults.kt")
        public void testInternalPrimaryDefaults() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/internalPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="localPrimaryDefaults.kt")
        public void testLocalPrimaryDefaults() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/localPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="parameterlessPrimary.kt")
        public void testParameterlessPrimary() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/parameterlessPrimary.kt");
        }

        @Test
        @TestMetadata(value="privatePrimaryDefaults.kt")
        public void testPrivatePrimaryDefaults() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/privatePrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="protectedPrimaryDefaults.kt")
        public void testProtectedPrimaryDefaults() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/protectedPrimaryDefaults.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/constants")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Constants {
        @Test
        public void testAllFilesPresentInConstants() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="byte.kt")
        public void testByte() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/byte.kt");
        }

        @Test
        @TestMetadata(value="floatingPoints.kt")
        public void testFloatingPoints() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/floatingPoints.kt");
        }

        @Test
        @TestMetadata(value="inlineUnsignedIntConstant.kt")
        public void testInlineUnsignedIntConstant() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/inlineUnsignedIntConstant.kt");
        }

        @Test
        @TestMetadata(value="kt9532.kt")
        public void testKt9532() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/kt9532.kt");
        }

        @Test
        @TestMetadata(value="noInlineNonConst.kt")
        public void testNoInlineNonConst() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonConst.kt");
        }

        @Test
        @TestMetadata(value="noInlineNonStaticJavaField.kt")
        public void testNoInlineNonStaticJavaField() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonStaticJavaField.kt");
        }

        @Test
        @TestMetadata(value="nullableByteAndShort.kt")
        public void testNullableByteAndShort() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/nullableByteAndShort.kt");
        }

        @Test
        @TestMetadata(value="partialString.kt")
        public void testPartialString() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/partialString.kt");
        }

        @Test
        @TestMetadata(value="short.kt")
        public void testShort() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/short.kt");
        }

        @Test
        @TestMetadata(value="string.kt")
        public void testString() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/string.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/constantConditions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ConstantConditions {
        @Test
        public void testAllFilesPresentInConstantConditions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constantConditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="cmpIntWith0.kt")
        public void testCmpIntWith0() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/cmpIntWith0.kt");
        }

        @Test
        @TestMetadata(value="constantFlag.kt")
        public void testConstantFlag() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantFlag.kt");
        }

        @Test
        @TestMetadata(value="constantInt.kt")
        public void testConstantInt() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantInt.kt");
        }

        @Test
        @TestMetadata(value="inlineIfFalse.kt")
        public void testInlineIfFalse() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/inlineIfFalse.kt");
        }

        @Test
        @TestMetadata(value="kt3098.kt")
        public void testKt3098() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/kt3098.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/constProperty")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ConstProperty {
        @Test
        public void testAllFilesPresentInConstProperty() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="noAccessorsForPrivateConstants.kt")
        public void testNoAccessorsForPrivateConstants() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/noAccessorsForPrivateConstants.kt");
        }

        @Test
        @TestMetadata(value="nonConstValHasNoDefaultValue_after.kt")
        public void testNonConstValHasNoDefaultValue_after() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_after.kt");
        }

        @Test
        @TestMetadata(value="nonConstValHasNoDefaultValue_before.kt")
        public void testNonConstValHasNoDefaultValue_before() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_before.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/conditions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Conditions {
        @Test
        public void testAllFilesPresentInConditions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/conditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="conjunction.kt")
        public void testConjunction() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunction.kt");
        }

        @Test
        @TestMetadata(value="conjunctionInDoWhile.kt")
        public void testConjunctionInDoWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="conjunctionInWhile.kt")
        public void testConjunctionInWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInWhile.kt");
        }

        @Test
        @TestMetadata(value="disjunction.kt")
        public void testDisjunction() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/disjunction.kt");
        }

        @Test
        @TestMetadata(value="negatedConjuction.kt")
        public void testNegatedConjuction() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedConjuction.kt");
        }

        @Test
        @TestMetadata(value="negatedDisjunction.kt")
        public void testNegatedDisjunction() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedDisjunction.kt");
        }

        @Test
        @TestMetadata(value="negatedNonZeroCompareInDoWhile.kt")
        public void testNegatedNonZeroCompareInDoWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedNonZeroCompareInIf.kt")
        public void testNegatedNonZeroCompareInIf() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="negatedNonZeroCompareInWhile.kt")
        public void testNegatedNonZeroCompareInWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedNullCompareInDoWhile.kt")
        public void testNegatedNullCompareInDoWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedNullCompareInIf.kt")
        public void testNegatedNullCompareInIf() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="negatedNullCompareInWhile.kt")
        public void testNegatedNullCompareInWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedZeroCompareInDoWhile.kt")
        public void testNegatedZeroCompareInDoWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedZeroCompareInIf.kt")
        public void testNegatedZeroCompareInIf() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="negatedZeroCompareInWhile.kt")
        public void testNegatedZeroCompareInWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="noBoxingForBoxedEqPrimitive.kt")
        public void testNoBoxingForBoxedEqPrimitive() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForBoxedEqPrimitive.kt");
        }

        @Test
        @TestMetadata(value="noBoxingForPrimitiveEqBoxed.kt")
        public void testNoBoxingForPrimitiveEqBoxed() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqBoxed.kt");
        }

        @Test
        @TestMetadata(value="noBoxingForPrimitiveEqObject.kt")
        public void testNoBoxingForPrimitiveEqObject() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqObject.kt");
        }

        @Test
        @TestMetadata(value="nonZeroCompareInDoWhile.kt")
        public void testNonZeroCompareInDoWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="nonZeroCompareInIf.kt")
        public void testNonZeroCompareInIf() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="nonZeroCompareInWhile.kt")
        public void testNonZeroCompareInWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="nullCompareConst.kt")
        public void testNullCompareConst() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareConst.kt");
        }

        @Test
        @TestMetadata(value="nullCompareInDoWhile.kt")
        public void testNullCompareInDoWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="nullCompareInIf.kt")
        public void testNullCompareInIf() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="nullCompareInWhile.kt")
        public void testNullCompareInWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="zeroCompareInDoWhile.kt")
        public void testZeroCompareInDoWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="zeroCompareInIf.kt")
        public void testZeroCompareInIf() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="zeroCompareInWhile.kt")
        public void testZeroCompareInWhile() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInWhile.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/companion")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Companion {
        @Test
        public void testAllFilesPresentInCompanion() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="directAccessToBackingField.kt")
        public void testDirectAccessToBackingField() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/directAccessToBackingField.kt");
        }

        @Test
        @TestMetadata(value="floatingPointCompanionAccess.kt")
        public void testFloatingPointCompanionAccess() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/floatingPointCompanionAccess.kt");
        }

        @Test
        @TestMetadata(value="inlineFunctionCompanionPropertyAccess.kt")
        public void testInlineFunctionCompanionPropertyAccess() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionCompanionPropertyAccess.kt");
        }

        @Test
        @TestMetadata(value="inlineFunctionObjectCompanionPropertyAccess.kt")
        public void testInlineFunctionObjectCompanionPropertyAccess() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionObjectCompanionPropertyAccess.kt");
        }

        @Test
        @TestMetadata(value="kt14258_1.kt")
        public void testKt14258_1() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_1.kt");
        }

        @Test
        @TestMetadata(value="kt14258_2.kt")
        public void testKt14258_2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_2.kt");
        }

        @Test
        @TestMetadata(value="kt14258_3.kt")
        public void testKt14258_3() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_3.kt");
        }

        @Test
        @TestMetadata(value="kt14258_4.kt")
        public void testKt14258_4() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_4.kt");
        }

        @Test
        @TestMetadata(value="kt14258_5.kt")
        public void testKt14258_5() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_5.kt");
        }

        @Test
        @TestMetadata(value="nonDefaultAccessors.kt")
        public void testNonDefaultAccessors() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/nonDefaultAccessors.kt");
        }

        @Test
        @TestMetadata(value="privateCompanionObjectAccessors_after.kt")
        public void testPrivateCompanionObjectAccessors_after() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_after.kt");
        }

        @Test
        @TestMetadata(value="privateCompanionObjectAccessors_before.kt")
        public void testPrivateCompanionObjectAccessors_before() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_before.kt");
        }

        @Test
        @TestMetadata(value="protectedCompanionObjectAccessors_after.kt")
        public void testProtectedCompanionObjectAccessors_after() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_after.kt");
        }

        @Test
        @TestMetadata(value="protectedCompanionObjectAccessors_before.kt")
        public void testProtectedCompanionObjectAccessors_before() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_before.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/coercionToUnitOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CoercionToUnitOptimization {
        @Test
        public void testAllFilesPresentInCoercionToUnitOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="inRangeCheckWithConst.kt")
        public void testInRangeCheckWithConst() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/inRangeCheckWithConst.kt");
        }

        @Test
        @TestMetadata(value="kt14360.kt")
        public void testKt14360() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/kt14360.kt");
        }

        @Test
        @TestMetadata(value="largeMethodWithCoercionToUnit.kt")
        public void testLargeMethodWithCoercionToUnit() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/largeMethodWithCoercionToUnit.kt");
        }

        @Test
        @TestMetadata(value="nopInlineFuns.kt")
        public void testNopInlineFuns() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/nopInlineFuns.kt");
        }

        @Test
        @TestMetadata(value="returnsUnit.kt")
        public void testReturnsUnit() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/returnsUnit.kt");
        }

        @Test
        @TestMetadata(value="safeCall.kt")
        public void testSafeCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCall.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithReturnValue.kt")
        public void testSafeCallWithReturnValue() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCallWithReturnValue.kt");
        }

        @Test
        @TestMetadata(value="safeLet.kt")
        public void testSafeLet() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeLet.kt");
        }

        @Test
        @TestMetadata(value="tryInlined.kt")
        public void testTryInlined() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/tryInlined.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/checkcast")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Checkcast {
        @Test
        public void testAllFilesPresentInCheckcast() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/checkcast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="kt14811.kt")
        public void testKt14811() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14811.kt");
        }

        @Test
        @TestMetadata(value="kt14963.kt")
        public void testKt14963() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14963.kt");
        }

        @Test
        @TestMetadata(value="kt15411.kt")
        public void testKt15411() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt15411.kt");
        }

        @Test
        @TestMetadata(value="kt22714.kt")
        public void testKt22714() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt22714.kt");
        }

        @Test
        @TestMetadata(value="noCheckcastOnDelegatingDefaultImplsCall.kt")
        public void testNoCheckcastOnDelegatingDefaultImplsCall() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnDelegatingDefaultImplsCall.kt");
        }

        @Test
        @TestMetadata(value="noCheckcastOnSuper.kt")
        public void testNoCheckcastOnSuper() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnSuper.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/capturedVarsOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CapturedVarsOptimization {
        @Test
        public void testAllFilesPresentInCapturedVarsOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="capturedInChainOfInlineFuns.kt")
        public void testCapturedInChainOfInlineFuns() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInChainOfInlineFuns.kt");
        }

        @Test
        @TestMetadata(value="capturedInInlineOnly.kt")
        public void testCapturedInInlineOnly() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInInlineOnly.kt");
        }

        @Test
        @TestMetadata(value="capturedInLocalObject.kt")
        public void testCapturedInLocalObject() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInLocalObject.kt");
        }

        @Test
        @TestMetadata(value="capturedInNoInlineOnly.kt")
        public void testCapturedInNoInlineOnly() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlineOnly.kt");
        }

        @Test
        @TestMetadata(value="capturedInNoInlneInsideChainOfInlineFuns.kt")
        public void testCapturedInNoInlneInsideChainOfInlineFuns() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlneInsideChainOfInlineFuns.kt");
        }

        @Test
        @TestMetadata(value="capturedValInLambdaInitializedInside.kt")
        public void testCapturedValInLambdaInitializedInside() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedInside.kt");
        }

        @Test
        @TestMetadata(value="capturedValInLambdaInitializedOutside.kt")
        public void testCapturedValInLambdaInitializedOutside() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedOutside.kt");
        }

        @Test
        @TestMetadata(value="capturedVarsOfSize2.kt")
        public void testCapturedVarsOfSize2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedVarsOfSize2.kt");
        }

        @Test
        @TestMetadata(value="returnValueOfArrayConstructor.kt")
        public void testReturnValueOfArrayConstructor() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/returnValueOfArrayConstructor.kt");
        }

        @Test
        @TestMetadata(value="sharedSlotsWithCapturedVars.kt")
        public void testSharedSlotsWithCapturedVars() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
        }

        @Test
        @TestMetadata(value="withStackNormalization.kt")
        public void testWithStackNormalization() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/withStackNormalization.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/callableReference")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CallableReference {
        @Test
        public void testAllFilesPresentInCallableReference() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="boundFieldReferenceInInline.kt")
        public void testBoundFieldReferenceInInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFieldReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="boundFunReferenceInInline.kt")
        public void testBoundFunReferenceInInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFunReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="boundPropertyReferenceInInline.kt")
        public void testBoundPropertyReferenceInInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundPropertyReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="kt36975.kt")
        public void testKt36975() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/kt36975.kt");
        }

        @Test
        @TestMetadata(value="kt39612.kt")
        public void testKt39612() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/kt39612.kt");
        }

        @Test
        @TestMetadata(value="nameIntrinsicWithImplicitThis.kt")
        public void testNameIntrinsicWithImplicitThis() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/nameIntrinsicWithImplicitThis.kt");
        }

        @Test
        @TestMetadata(value="unboundFieldReferenceInInline.kt")
        public void testUnboundFieldReferenceInInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFieldReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="unboundFunReferenceInInline.kt")
        public void testUnboundFunReferenceInInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFunReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="unboundPropertyReferenceInInline.kt")
        public void testUnboundPropertyReferenceInInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundPropertyReferenceInInline.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/builtinFunctions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BuiltinFunctions {
        @Test
        public void testAllFilesPresentInBuiltinFunctions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="charSequence.kt")
        public void testCharSequence() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/charSequence.kt");
        }

        @Test
        @TestMetadata(value="contains.kt")
        public void testContains() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/contains.kt");
        }

        @Test
        @TestMetadata(value="removeAt.kt")
        public void testRemoveAt() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/removeAt.kt");
        }

        @Test
        @TestMetadata(value="size.kt")
        public void testSize() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/size.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge")
        @TestDataPath(value="$PROJECT_ROOT")
        public class GenericParameterBridge {
            @Test
            @TestMetadata(value="abstractList.kt")
            public void testAbstractList() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/abstractList.kt");
            }

            @Test
            public void testAllFilesPresentInGenericParameterBridge() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="IntMC.kt")
            public void testIntMC() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/IntMC.kt");
            }

            @Test
            @TestMetadata(value="mutableCollection.kt")
            public void testMutableCollection() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableCollection.kt");
            }

            @Test
            @TestMetadata(value="mutableSetInterfaces.kt")
            public void testMutableSetInterfaces() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableSetInterfaces.kt");
            }

            @Test
            @TestMetadata(value="notNullAnyMC.kt")
            public void testNotNullAnyMC() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullAnyMC.kt");
            }

            @Test
            @TestMetadata(value="notNullParamMC.kt")
            public void testNotNullParamMC() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullParamMC.kt");
            }

            @Test
            @TestMetadata(value="nullableAnyMC.kt")
            public void testNullableAnyMC() {
                BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/nullableAnyMC.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/boxingOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BoxingOptimization {
        @Test
        public void testAllFilesPresentInBoxingOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="boxingAndEquals.kt")
        public void testBoxingAndEquals() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/boxingAndEquals.kt");
        }

        @Test
        @TestMetadata(value="casts.kt")
        public void testCasts() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/casts.kt");
        }

        @Test
        @TestMetadata(value="checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf.kt");
        }

        @Test
        @TestMetadata(value="fold.kt")
        public void testFold() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/fold.kt");
        }

        @Test
        @TestMetadata(value="hashCodeOnNonNull.kt")
        public void testHashCodeOnNonNull() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/hashCodeOnNonNull.kt");
        }

        @Test
        @TestMetadata(value="inlineClassesAndInlinedLambda.kt")
        public void testInlineClassesAndInlinedLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/inlineClassesAndInlinedLambda.kt");
        }

        @Test
        @TestMetadata(value="intCompareTo.kt")
        public void testIntCompareTo() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/intCompareTo.kt");
        }

        @Test
        @TestMetadata(value="kClassInAnnotation.kt")
        public void testKClassInAnnotation() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotation.kt");
        }

        @Test
        @TestMetadata(value="kClassInAnnotationEscaping.kt")
        public void testKClassInAnnotationEscaping() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotationEscaping.kt");
        }

        @Test
        @TestMetadata(value="kt15862.kt")
        public void testKt15862() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862.kt");
        }

        @Test
        @TestMetadata(value="kt15862_2.kt")
        public void testKt15862_2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862_2.kt");
        }

        @Test
        @TestMetadata(value="kt6842.kt")
        public void testKt6842() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt6842.kt");
        }

        @Test
        @TestMetadata(value="kt7224.kt")
        public void testKt7224() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt7224.kt");
        }

        @Test
        @TestMetadata(value="maxMinByOrNull.kt")
        public void testMaxMinByOrNull() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/maxMinByOrNull.kt");
        }

        @Test
        @TestMetadata(value="nullCheck.kt")
        public void testNullCheck() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/nullCheck.kt");
        }

        @Test
        @TestMetadata(value="progressions.kt")
        public void testProgressions() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/progressions.kt");
        }

        @Test
        @TestMetadata(value="safeCallToPrimitiveEquality1.kt")
        public void testSafeCallToPrimitiveEquality1() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality1.kt");
        }

        @Test
        @TestMetadata(value="safeCallToPrimitiveEquality2.kt")
        public void testSafeCallToPrimitiveEquality2() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality2.kt");
        }

        @Test
        @TestMetadata(value="safeCallToPrimitiveEquality3.kt")
        public void testSafeCallToPrimitiveEquality3() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality3.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithElvis.kt")
        public void testSafeCallWithElvis() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvis.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithElvisMultipleFiles.kt")
        public void testSafeCallWithElvisMultipleFiles() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
        }

        @Test
        @TestMetadata(value="severalInlines.kt")
        public void testSeveralInlines() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/severalInlines.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simple.kt");
        }

        @Test
        @TestMetadata(value="simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simpleUninitializedMerge.kt");
        }

        @Test
        @TestMetadata(value="suspendBoxing.kt")
        public void testSuspendBoxing() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/suspendBoxing.kt");
        }

        @Test
        @TestMetadata(value="unsafeRemoving.kt")
        public void testUnsafeRemoving() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsafeRemoving.kt");
        }

        @Test
        @TestMetadata(value="unsignedRangeIteratorSpecialization.kt")
        public void testUnsignedRangeIteratorSpecialization() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsignedRangeIteratorSpecialization.kt");
        }

        @Test
        @TestMetadata(value="variableClash.kt")
        public void testVariableClash() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variableClash.kt");
        }

        @Test
        @TestMetadata(value="variables.kt")
        public void testVariables() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variables.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/boxing")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Boxing {
        @Test
        public void testAllFilesPresentInBoxing() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="crossinlineSuspend.kt")
        public void testCrossinlineSuspend() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/crossinlineSuspend.kt");
        }

        @Test
        @TestMetadata(value="inlineSuspend.kt")
        public void testInlineSuspend() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/inlineSuspend.kt");
        }

        @Test
        @TestMetadata(value="suspend.kt")
        public void testSuspend() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/suspend.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/assert")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Assert {
        @Test
        public void testAllFilesPresentInAssert() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="jvmCrossinline.kt")
        public void testJvmCrossinline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinline.kt");
        }

        @Test
        @TestMetadata(value="jvmCrossinlineAssertInLambda.kt")
        public void testJvmCrossinlineAssertInLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinlineAssertInLambda.kt");
        }

        @Test
        @TestMetadata(value="jvmInline.kt")
        public void testJvmInline() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmInline.kt");
        }

        @Test
        @TestMetadata(value="jvmInlineLambda.kt")
        public void testJvmInlineLambda() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmInlineLambda.kt");
        }

        @Test
        @TestMetadata(value="jvmNestedClass.kt")
        public void testJvmNestedClass() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmNestedClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/argumentOrder")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ArgumentOrder {
        @Test
        public void testAllFilesPresentInArgumentOrder() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="sameOrder.kt")
        public void testSameOrder() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrder.kt");
        }

        @Test
        @TestMetadata(value="sameOrderWithDefault.kt")
        public void testSameOrderWithDefault() {
            BytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrderWithDefault.kt");
        }
    }
}

