/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.IrVerificationMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.JsEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.CompilerTestMessageRenderer;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.util.AbstractArrayMapOwner;
import org.jetbrains.kotlin.util.ArrayMapAccessor;
import org.jetbrains.kotlin.util.TypeRegistry;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0007\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u001a2\u0010\u0011\u001a\u00020\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\u0006\u0010\u0017\u001a\u0002H\u0013H\u0082\u0002\u00a2\u0006\u0002\u0010\u0018\"\u001f\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0019"}, d2={"compilerConfigurationProvider", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getCompilerConfigurationProvider", "(Lorg/jetbrains/kotlin/test/services/TestServices;)Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "compilerConfigurationProvider$delegate", "Lorg/jetbrains/kotlin/util/ArrayMapAccessor;", "platformToEnvironmentConfigFiles", "Lorg/jetbrains/kotlin/cli/jvm/compiler/EnvironmentConfigFiles;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "createCompilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "configurators", "", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "set", "", "T", "", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "value", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;Ljava/lang/Object;)V", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nCompilerConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerConfigurationProvider.kt\norg/jetbrains/kotlin/test/services/CompilerConfigurationProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServices$Companion\n*L\n1#1,166:1\n1863#2,2:167\n34#3:169\n*S KotlinDebug\n*F\n+ 1 CompilerConfigurationProvider.kt\norg/jetbrains/kotlin/test/services/CompilerConfigurationProviderKt\n*L\n158#1:167,2\n70#1:169\n*E\n"})
public final class CompilerConfigurationProviderKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ArrayMapAccessor compilerConfigurationProvider$delegate;

    @NotNull
    public static final CompilerConfigurationProvider getCompilerConfigurationProvider(@NotNull TestServices $this$compilerConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$compilerConfigurationProvider), (String)"<this>");
        return (CompilerConfigurationProvider)compilerConfigurationProvider$delegate.getValue((AbstractArrayMapOwner)$this$compilerConfigurationProvider, $$delegatedProperties[0]);
    }

    @TestInfrastructureInternals
    @NotNull
    public static final EnvironmentConfigFiles platformToEnvironmentConfigFiles(@NotNull TargetPlatform $this$platformToEnvironmentConfigFiles) {
        EnvironmentConfigFiles environmentConfigFiles;
        Intrinsics.checkNotNullParameter((Object)$this$platformToEnvironmentConfigFiles, (String)"<this>");
        if (JvmPlatformKt.isJvm((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.JS_CONFIG_FILES;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.NATIVE_CONFIG_FILES;
        } else if (WasmPlatformKt.isWasm((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.WASM_CONFIG_FILES;
        } else if (TargetPlatformKt.isCommon((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.METADATA_CONFIG_FILES;
        } else {
            throw new IllegalStateException(("Unknown platform: " + $this$platformToEnvironmentConfigFiles).toString());
        }
        return environmentConfigFiles;
    }

    @TestInfrastructureInternals
    @NotNull
    public static final CompilerConfiguration createCompilerConfiguration(@NotNull TestModule module, @NotNull List<? extends AbstractEnvironmentConfigurator> configurators) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
        CompilerConfiguration configuration2 = new CompilerConfiguration();
        CompilerConfigurationProviderKt.set(configuration2, CommonConfigurationKeys.MODULE_NAME, module.getName());
        if (module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getGENERATE_STRICT_IMPLICIT_EXPORT())) {
            configuration2.put(JSConfigurationKeys.GENERATE_STRICT_IMPLICIT_EXPORT, (Object)true);
        }
        if (module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getGENERATE_DTS())) {
            configuration2.put(JSConfigurationKeys.GENERATE_DTS, (Object)true);
        }
        if (module.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getES6_MODE())) {
            configuration2.put(JSConfigurationKeys.USE_ES6_CLASSES, (Object)true);
            configuration2.put(JSConfigurationKeys.COMPILE_SUSPEND_AS_JS_GENERATOR, (Object)true);
        }
        if (Intrinsics.areEqual(module.getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE)) {
            CompilerConfigurationProviderKt.set(configuration2, CommonConfigurationKeys.USE_FIR, true);
        }
        configuration2.put(CommonConfigurationKeys.VERIFY_IR, (Object)IrVerificationMode.ERROR);
        configuration2.put(CommonConfigurationKeys.ENABLE_IR_VISIBILITY_CHECKS, (Object)(!CollectionsKt.contains((Iterable)module.getDirectives().get(CodegenTestDirectives.INSTANCE.getDISABLE_IR_VISIBILITY_CHECKS()), (Object)((Object)module.getTargetBackend())) && !module.getDirectives().get(CodegenTestDirectives.INSTANCE.getDISABLE_IR_VISIBILITY_CHECKS()).contains((Object)TargetBackend.ANY) ? 1 : 0));
        configuration2.put(CommonConfigurationKeys.ENABLE_IR_VISIBILITY_CHECKS_AFTER_INLINING, (Object)module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getENABLE_IR_VISIBILITY_CHECKS_AFTER_INLINING()));
        PrintingMessageCollector messageCollector = new PrintingMessageCollector(System.err, (MessageRenderer)new CompilerTestMessageRenderer(module), false);
        CommonConfigurationKeysKt.setMessageCollector((CompilerConfiguration)configuration2, (MessageCollector)((MessageCollector)messageCollector));
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration2, (LanguageVersionSettings)module.getLanguageVersionSettings());
        Iterable $this$forEach$iv = configurators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractEnvironmentConfigurator it = (AbstractEnvironmentConfigurator)element$iv;
            boolean bl = false;
            it.configureCompileConfigurationWithAdditionalConfigurationKeys(configuration2, module);
        }
        return configuration2;
    }

    private static final <T> void set(CompilerConfiguration $this$set, CompilerConfigurationKey<T> key, T value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        $this$set.put(key, value);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Reflection.getOrCreateKotlinPackage(CompilerConfigurationProviderKt.class, (String)"tests-common-new_test"), "compilerConfigurationProvider", "getCompilerConfigurationProvider(Lorg/jetbrains/kotlin/test/services/TestServices;)Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;")))};
        $$delegatedProperties = kPropertyArray;
        TestServices.Companion this_$iv = TestServices.Companion;
        boolean $i$f$testServiceAccessor = false;
        compilerConfigurationProvider$delegate = TypeRegistry.generateAccessor$default((TypeRegistry)((TypeRegistry)this_$iv), (KClass)Reflection.getOrCreateKotlinClass(CompilerConfigurationProvider.class), null, (int)2, null);
    }
}

