/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/test/utils/BackendWithDirectives;", "", "backend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "<init>", "(Lorg/jetbrains/kotlin/test/TargetBackend;)V", "getBackend", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "directives", "", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "addDirectiveIfConsidered", "", "directive", "contains", "", "registeredDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "directivesInTestFile", "", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nSteppingTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteppingTestUtils.kt\norg/jetbrains/kotlin/test/utils/BackendWithDirectives\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n774#2:233\n865#2,2:234\n*S KotlinDebug\n*F\n+ 1 SteppingTestUtils.kt\norg/jetbrains/kotlin/test/utils/BackendWithDirectives\n*L\n79#1:233\n79#1:234,2\n*E\n"})
public final class BackendWithDirectives {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TargetBackend backend;
    @NotNull
    private final Set<Directive> directives;
    @NotNull
    private static final Set<SimpleDirective> directivesToConsider;

    public BackendWithDirectives(@NotNull TargetBackend backend) {
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        this.backend = backend;
        this.directives = new LinkedHashSet();
    }

    @NotNull
    public final TargetBackend getBackend() {
        return this.backend;
    }

    public final void addDirectiveIfConsidered(@NotNull Directive directive) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        if (CollectionsKt.contains((Iterable)directivesToConsider, (Object)directive)) {
            ((Collection)this.directives).add(directive);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(@NotNull RegisteredDirectives registeredDirectives, @NotNull Set<? extends Directive> directivesInTestFile) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)registeredDirectives, (String)"registeredDirectives");
        Intrinsics.checkNotNullParameter(directivesInTestFile, (String)"directivesInTestFile");
        if (directivesInTestFile.isEmpty()) {
            return true;
        }
        Iterable $this$filter$iv = registeredDirectives;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Directive it = (Directive)element$iv$iv;
            boolean bl = false;
            if (!(CollectionsKt.contains((Iterable)directivesToConsider, (Object)it) && directivesInTestFile.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), this.directives);
    }

    @NotNull
    public final TargetBackend component1() {
        return this.backend;
    }

    @NotNull
    public final BackendWithDirectives copy(@NotNull TargetBackend backend) {
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        return new BackendWithDirectives(backend);
    }

    public static /* synthetic */ BackendWithDirectives copy$default(BackendWithDirectives backendWithDirectives, TargetBackend targetBackend, int n, Object object) {
        if ((n & 1) != 0) {
            targetBackend = backendWithDirectives.backend;
        }
        return backendWithDirectives.copy(targetBackend);
    }

    @NotNull
    public String toString() {
        return "BackendWithDirectives(backend=" + (Object)((Object)this.backend) + ')';
    }

    public int hashCode() {
        return this.backend.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BackendWithDirectives)) {
            return false;
        }
        BackendWithDirectives backendWithDirectives = (BackendWithDirectives)other;
        return this.backend == backendWithDirectives.backend;
    }

    static {
        Object[] objectArray = new SimpleDirective[]{LanguageSettingsDirectives.INSTANCE.getUSE_INLINE_SCOPES_NUMBERS()};
        directivesToConsider = SetsKt.mutableSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/utils/BackendWithDirectives$Companion;", "", "<init>", "()V", "directivesToConsider", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

