/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.test.generators.GenerateCompilerTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend")
@TestDataPath("$PROJECT_ROOT")
public class DiagnosticsTestWithJvmIrBackendGenerated extends AbstractDiagnosticsTestWithJvmIrBackend {
  @Test
  public void testAllFilesPresentInTestsWithJvmBackend() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
  }

  @Test
  @TestMetadata("indirectInlineCycle.kt")
  public void testIndirectInlineCycle() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/indirectInlineCycle.kt");
  }

  @Test
  @TestMetadata("inlineCycle.kt")
  public void testInlineCycle() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/inlineCycle.kt");
  }

  @Test
  @TestMetadata("kt57104.kt")
  public void testKt57104() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/kt57104.kt");
  }

  @Test
  @TestMetadata("kt57104_2.kt")
  public void testKt57104_2() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/kt57104_2.kt");
  }

  @Test
  @TestMetadata("multipleBigArityFunsImplemented.kt")
  public void testMultipleBigArityFunsImplemented() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/multipleBigArityFunsImplemented.kt");
  }

  @Test
  @TestMetadata("noWarningInLV1_5.kt")
  public void testNoWarningInLV1_5() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/noWarningInLV1_5.kt");
  }

  @Test
  @TestMetadata("nothingToOverrideWithRawParameter.kt")
  public void testNothingToOverrideWithRawParameter() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/nothingToOverrideWithRawParameter.kt");
  }

  @Test
  @TestMetadata("propertyInlineCycle.kt")
  public void testPropertyInlineCycle() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/propertyInlineCycle.kt");
  }

  @Test
  @TestMetadata("signatureConflictHiddenByTypeParameter.kt")
  public void testSignatureConflictHiddenByTypeParameter() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/signatureConflictHiddenByTypeParameter.kt");
  }

  @Test
  @TestMetadata("suspendInlineCycle.kt")
  public void testSuspendInlineCycle() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/suspendInlineCycle.kt");
  }

  @Test
  @TestMetadata("suspensionPointInMonitor.kt")
  public void testSuspensionPointInMonitor() {
    runTest("compiler/testData/diagnostics/testsWithJvmBackend/suspensionPointInMonitor.kt");
  }

  @Nested
  @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/contextReceivers")
  @TestDataPath("$PROJECT_ROOT")
  public class ContextReceivers {
    @Test
    public void testAllFilesPresentInContextReceivers() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/contextReceivers"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("kt59590.kt")
    public void testKt59590() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextReceivers/kt59590.kt");
    }

    @Test
    @TestMetadata("kt59590WithContextReceiver.kt")
    public void testKt59590WithContextReceiver() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextReceivers/kt59590WithContextReceiver.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature")
  @TestDataPath("$PROJECT_ROOT")
  public class DuplicateJvmSignature {
    @Test
    public void testAllFilesPresentInDuplicateJvmSignature() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("caseInProperties.kt")
    public void testCaseInProperties() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/caseInProperties.kt");
    }

    @Test
    @TestMetadata("changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt")
    public void testChangingNullabilityOfOrdinaryClassIsBinaryCompatibleChange() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt");
    }

    @Test
    @TestMetadata("vararg.kt")
    public void testVararg() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/vararg.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides")
    @TestDataPath("$PROJECT_ROOT")
    public class AccidentalOverrides {
      @Test
      @TestMetadata("accidentalOverrideFromGrandparent.kt")
      public void testAccidentalOverrideFromGrandparent() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/accidentalOverrideFromGrandparent.kt");
      }

      @Test
      public void testAllFilesPresentInAccidentalOverrides() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("classFunctionOverriddenByProperty.kt")
      public void testClassFunctionOverriddenByProperty() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByProperty.kt");
      }

      @Test
      @TestMetadata("classFunctionOverriddenByPropertyInConstructor.kt")
      public void testClassFunctionOverriddenByPropertyInConstructor() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyInConstructor.kt");
      }

      @Test
      @TestMetadata("classFunctionOverriddenByPropertyNoGetter.kt")
      public void testClassFunctionOverriddenByPropertyNoGetter() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyNoGetter.kt");
      }

      @Test
      @TestMetadata("classPropertyOverriddenByFunction.kt")
      public void testClassPropertyOverriddenByFunction() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classPropertyOverriddenByFunction.kt");
      }

      @Test
      @TestMetadata("defaultFunction.kt")
      public void testDefaultFunction() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/defaultFunction.kt");
      }

      @Test
      @TestMetadata("delegatedFunctionOverriddenByProperty.kt")
      public void testDelegatedFunctionOverriddenByProperty() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/delegatedFunctionOverriddenByProperty.kt");
      }

      @Test
      @TestMetadata("genericClassFunction.kt")
      public void testGenericClassFunction() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/genericClassFunction.kt");
      }

      @Test
      @TestMetadata("overridesNothing.kt")
      public void testOverridesNothing() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/overridesNothing.kt");
      }

      @Test
      @TestMetadata("privateClassFunctionOverriddenByProperty.kt")
      public void testPrivateClassFunctionOverriddenByProperty() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/privateClassFunctionOverriddenByProperty.kt");
      }

      @Test
      @TestMetadata("traitFunctionOverriddenByProperty.kt")
      public void testTraitFunctionOverriddenByProperty() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByProperty.kt");
      }

      @Test
      @TestMetadata("traitFunctionOverriddenByPropertyNoImpl.kt")
      public void testTraitFunctionOverriddenByPropertyNoImpl() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByPropertyNoImpl.kt");
      }

      @Test
      @TestMetadata("traitPropertyOverriddenByFunction.kt")
      public void testTraitPropertyOverriddenByFunction() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunction.kt");
      }

      @Test
      @TestMetadata("traitPropertyOverriddenByFunctionNoImpl.kt")
      public void testTraitPropertyOverriddenByFunctionNoImpl() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunctionNoImpl.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges")
    @TestDataPath("$PROJECT_ROOT")
    public class Bridges {
      @Test
      public void testAllFilesPresentInBridges() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("class.kt")
      public void testClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/class.kt");
      }

      @Test
      @TestMetadata("fakeOverrideTrait.kt")
      public void testFakeOverrideTrait() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/fakeOverrideTrait.kt");
      }

      @Test
      @TestMetadata("trait.kt")
      public void testTrait() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/trait.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure")
    @TestDataPath("$PROJECT_ROOT")
    public class Erasure {
      @Test
      public void testAllFilesPresentInErasure() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("clashFromInterfaceAndSuperClass.kt")
      public void testClashFromInterfaceAndSuperClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/clashFromInterfaceAndSuperClass.kt");
      }

      @Test
      @TestMetadata("collections.kt")
      public void testCollections() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/collections.kt");
      }

      @Test
      @TestMetadata("delegateToTwoTraits.kt")
      public void testDelegateToTwoTraits() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegateToTwoTraits.kt");
      }

      @Test
      @TestMetadata("delegationAndOwnMethod.kt")
      public void testDelegationAndOwnMethod() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegationAndOwnMethod.kt");
      }

      @Test
      @TestMetadata("delegationToTraitImplAndOwnMethod.kt")
      public void testDelegationToTraitImplAndOwnMethod() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegationToTraitImplAndOwnMethod.kt");
      }

      @Test
      @TestMetadata("differentTypeParameterLists.kt")
      public void testDifferentTypeParameterLists() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/differentTypeParameterLists.kt");
      }

      @Test
      @TestMetadata("extensionProperties.kt")
      public void testExtensionProperties() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/extensionProperties.kt");
      }

      @Test
      @TestMetadata("genericFunctions.kt")
      public void testGenericFunctions() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/genericFunctions.kt");
      }

      @Test
      @TestMetadata("genericType.kt")
      public void testGenericType() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/genericType.kt");
      }

      @Test
      @TestMetadata("inheritFromTwoTraits.kt")
      public void testInheritFromTwoTraits() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/inheritFromTwoTraits.kt");
      }

      @Test
      @TestMetadata("inheritGenericMethodsWithDifferentSubstitution.kt")
      public void testInheritGenericMethodsWithDifferentSubstitution() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/inheritGenericMethodsWithDifferentSubstitution.kt");
      }

      @Test
      @TestMetadata("kotlinAndJavaCollections.kt")
      public void testKotlinAndJavaCollections() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/kotlinAndJavaCollections.kt");
      }

      @Test
      @TestMetadata("nullableType.kt")
      public void testNullableType() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/nullableType.kt");
      }

      @Test
      @TestMetadata("superTraitAndDelegationToTraitImpl.kt")
      public void testSuperTraitAndDelegationToTraitImpl() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/superTraitAndDelegationToTraitImpl.kt");
      }

      @Test
      @TestMetadata("twoTraitsAndOwnFunction.kt")
      public void testTwoTraitsAndOwnFunction() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/twoTraitsAndOwnFunction.kt");
      }

      @Test
      @TestMetadata("typeMappedToJava.kt")
      public void testTypeMappedToJava() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeMappedToJava.kt");
      }

      @Test
      @TestMetadata("typeParameter.kt")
      public void testTypeParameter() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameter.kt");
      }

      @Test
      @TestMetadata("typeParameterWithBound.kt")
      public void testTypeParameterWithBound() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithBound.kt");
      }

      @Test
      @TestMetadata("typeParameterWithTwoBounds.kt")
      public void testTypeParameterWithTwoBounds() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithTwoBounds.kt");
      }

      @Test
      @TestMetadata("typeParameterWithTwoBoundsInWhere.kt")
      public void testTypeParameterWithTwoBoundsInWhere() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithTwoBoundsInWhere.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns")
    @TestDataPath("$PROJECT_ROOT")
    public class FinalMembersFromBuiltIns {
      @Test
      public void testAllFilesPresentInFinalMembersFromBuiltIns() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("enumMembers.kt")
      public void testEnumMembers() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns/enumMembers.kt");
      }

      @Test
      @TestMetadata("waitNotifyGetClass.kt")
      public void testWaitNotifyGetClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns/waitNotifyGetClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class FunctionAndProperty {
      @Test
      public void testAllFilesPresentInFunctionAndProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("class.kt")
      public void testClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/class.kt");
      }

      @Test
      @TestMetadata("classObject.kt")
      public void testClassObject() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/classObject.kt");
      }

      @Test
      @TestMetadata("classPropertyInConstructor.kt")
      public void testClassPropertyInConstructor() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/classPropertyInConstructor.kt");
      }

      @Test
      @TestMetadata("extensionFunctionAndNormalFunction.kt")
      public void testExtensionFunctionAndNormalFunction() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/extensionFunctionAndNormalFunction.kt");
      }

      @Test
      @TestMetadata("extensionPropertyAndFunction.kt")
      public void testExtensionPropertyAndFunction() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/extensionPropertyAndFunction.kt");
      }

      @Test
      @TestMetadata("functionAndSetter.kt")
      public void testFunctionAndSetter() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/functionAndSetter.kt");
      }

      @Test
      @TestMetadata("functionAndVar.kt")
      public void testFunctionAndVar() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/functionAndVar.kt");
      }

      @Test
      @TestMetadata("localClass.kt")
      public void testLocalClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/localClass.kt");
      }

      @Test
      @TestMetadata("localClassInClass.kt")
      public void testLocalClassInClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/localClassInClass.kt");
      }

      @Test
      @TestMetadata("nestedClass.kt")
      public void testNestedClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/nestedClass.kt");
      }

      @Test
      @TestMetadata("object.kt")
      public void testObject() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/object.kt");
      }

      @Test
      @TestMetadata("objectExpression.kt")
      public void testObjectExpression() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/objectExpression.kt");
      }

      @Test
      @TestMetadata("objectExpressionInConstructor.kt")
      public void testObjectExpressionInConstructor() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/objectExpressionInConstructor.kt");
      }

      @Test
      @TestMetadata("privateClassPropertyNoClash.kt")
      public void testPrivateClassPropertyNoClash() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/privateClassPropertyNoClash.kt");
      }

      @Test
      @TestMetadata("topLevel.kt")
      public void testTopLevel() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevel.kt");
      }

      @Test
      @TestMetadata("topLevelDifferentFiles.kt")
      public void testTopLevelDifferentFiles() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevelDifferentFiles.kt");
      }

      @Test
      @TestMetadata("topLevelGetter.kt")
      public void testTopLevelGetter() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevelGetter.kt");
      }

      @Test
      @TestMetadata("trait.kt")
      public void testTrait() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/trait.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
      @Test
      public void testAllFilesPresentInInlineClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/inlineClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("declarationClash.kt")
      public void testDeclarationClash() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/inlineClasses/declarationClash.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop")
    @TestDataPath("$PROJECT_ROOT")
    public class JavaInterop {
      @Test
      public void testAllFilesPresentInJavaInterop() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("charAtAndOverload.kt")
      public void testCharAtAndOverload() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverload.kt");
      }

      @Test
      @TestMetadata("charAtAndOverloadWithAbstractGet.kt")
      public void testCharAtAndOverloadWithAbstractGet() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverloadWithAbstractGet.kt");
      }

      @Test
      @TestMetadata("charAtAndOverloadWithAbstractGetAndProxy.kt")
      public void testCharAtAndOverloadWithAbstractGetAndProxy() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverloadWithAbstractGetAndProxy.kt");
      }

      @Test
      @TestMetadata("charAtAndOverloadWithAbstractGetOpenCharAt.kt")
      public void testCharAtAndOverloadWithAbstractGetOpenCharAt() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverloadWithAbstractGetOpenCharAt.kt");
      }

      @Test
      @TestMetadata("charAtAndOverloadWithFinalGet.kt")
      public void testCharAtAndOverloadWithFinalGet() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverloadWithFinalGet.kt");
      }

      @Test
      @TestMetadata("charAtFinalAndOverload.kt")
      public void testCharAtFinalAndOverload() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtFinalAndOverload.kt");
      }

      @Test
      @TestMetadata("inheritFromJavaCollectionSubclassWithContainsOverload.kt")
      public void testInheritFromJavaCollectionSubclassWithContainsOverload() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/inheritFromJavaCollectionSubclassWithContainsOverload.kt");
      }

      @Test
      @TestMetadata("kjkPropertyAndExtensionProperty.kt")
      public void testKjkPropertyAndExtensionProperty() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/kjkPropertyAndExtensionProperty.kt");
      }

      @Test
      @TestMetadata("overridesBuiltinNoMagic.kt")
      public void testOverridesBuiltinNoMagic() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/overridesBuiltinNoMagic.kt");
      }

      @Test
      @TestMetadata("supertypeDifferentParameterNullability.kt")
      public void testSupertypeDifferentParameterNullability() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/supertypeDifferentParameterNullability.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmName")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmName {
      @Test
      public void testAllFilesPresentInJvmName() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmName"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("conflictsWIthJvmNameInClass.kt")
      public void testConflictsWIthJvmNameInClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmName/conflictsWIthJvmNameInClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmOverloads")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmOverloads {
      @Test
      public void testAllFilesPresentInJvmOverloads() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmOverloads"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("jvmOverloads.kt")
      public void testJvmOverloads() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmOverloads/jvmOverloads.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmStatic {
      @Test
      public void testAllFilesPresentInJvmStatic() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("jjk.kt")
      public void testJjk() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jjk.kt");
      }

      @Test
      @TestMetadata("jk.kt")
      public void testJk() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jk.kt");
      }

      @Test
      @TestMetadata("jkjk.kt")
      public void testJkjk() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jkjk.kt");
      }

      @Test
      @TestMetadata("jvmStaticInCompanionObject.kt")
      public void testJvmStaticInCompanionObject() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jvmStaticInCompanionObject.kt");
      }

      @Test
      @TestMetadata("jvmStaticInObject.kt")
      public void testJvmStaticInObject() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jvmStaticInObject.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames")
    @TestDataPath("$PROJECT_ROOT")
    public class SpecialNames {
      @Test
      public void testAllFilesPresentInSpecialNames() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("classInitializer.kt")
      public void testClassInitializer() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classInitializer.kt");
      }

      @Test
      @TestMetadata("classObject.kt")
      public void testClassObject() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObject.kt");
      }

      @Test
      @TestMetadata("classObjectCopiedField.kt")
      public void testClassObjectCopiedField() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObjectCopiedField.kt");
      }

      @Test
      @TestMetadata("classObjectCopiedFieldObject.kt")
      public void testClassObjectCopiedFieldObject() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObjectCopiedFieldObject.kt");
      }

      @Test
      @TestMetadata("dataClassCopy.kt")
      public void testDataClassCopy() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/dataClassCopy.kt");
      }

      @Test
      @TestMetadata("defaults.kt")
      public void testDefaults() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/defaults.kt");
      }

      @Test
      @TestMetadata("delegationBy.kt")
      public void testDelegationBy() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/delegationBy.kt");
      }

      @Test
      @TestMetadata("enum.kt")
      public void testEnum() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/enum.kt");
      }

      @Test
      @TestMetadata("innerClass.kt")
      public void testInnerClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/innerClass.kt");
      }

      @Test
      @TestMetadata("innerClassField.kt")
      public void testInnerClassField() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/innerClassField.kt");
      }

      @Test
      @TestMetadata("instance.kt")
      public void testInstance() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/instance.kt");
      }

      @Test
      @TestMetadata("propertyMetadataCache.kt")
      public void testPropertyMetadataCache() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/propertyMetadataCache.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics")
    @TestDataPath("$PROJECT_ROOT")
    public class Statics {
      @Test
      public void testAllFilesPresentInStatics() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("jkjk.kt")
      public void testJkjk() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/jkjk.kt");
      }

      @Test
      @TestMetadata("kotlinClassExtendsJavaClass.kt")
      public void testKotlinClassExtendsJavaClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassExtendsJavaClass.kt");
      }

      @Test
      @TestMetadata("kotlinClassExtendsJavaClassExtendsJavaClass.kt")
      public void testKotlinClassExtendsJavaClassExtendsJavaClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassExtendsJavaClassExtendsJavaClass.kt");
      }

      @Test
      @TestMetadata("kotlinClassImplementsJavaInterface.kt")
      public void testKotlinClassImplementsJavaInterface() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterface.kt");
      }

      @Test
      @TestMetadata("kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt")
      public void testKotlinClassImplementsJavaInterfaceExtendsJavaInteface() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt");
      }

      @Test
      @TestMetadata("kotlinMembersVsJavaNonVisibleStatics.kt")
      public void testKotlinMembersVsJavaNonVisibleStatics() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinMembersVsJavaNonVisibleStatics.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized")
    @TestDataPath("$PROJECT_ROOT")
    public class Synthesized {
      @Test
      public void testAllFilesPresentInSynthesized() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("enumValuesValueOf.kt")
      public void testEnumValuesValueOf() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized/enumValuesValueOf.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl")
    @TestDataPath("$PROJECT_ROOT")
    public class TraitImpl {
      @Test
      public void testAllFilesPresentInTraitImpl() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("defaultVsNonDefault.kt")
      public void testDefaultVsNonDefault() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/defaultVsNonDefault.kt");
      }

      @Test
      @TestMetadata("kt43611.kt")
      public void testKt43611() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/kt43611.kt");
      }

      @Test
      @TestMetadata("oneTrait.kt")
      public void testOneTrait() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/oneTrait.kt");
      }

      @Test
      @TestMetadata("traitFunctionOverriddenByPropertyInTrait.kt")
      public void testTraitFunctionOverriddenByPropertyInTrait() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/traitFunctionOverriddenByPropertyInTrait.kt");
      }

      @Test
      @TestMetadata("traitPropertyOverriddenByFunctionInTrait.kt")
      public void testTraitPropertyOverriddenByFunctionInTrait() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/traitPropertyOverriddenByFunctionInTrait.kt");
      }

      @Test
      @TestMetadata("twoTraits.kt")
      public void testTwoTraits() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/twoTraits.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class ValueClasses {
      @Test
      public void testAllFilesPresentInValueClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt")
      public void testChangingNullabilityOfOrdinaryClassIsBinaryCompatibleChange() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt");
      }

      @Test
      @TestMetadata("constructorsJvmSignaturesClash.kt")
      public void testConstructorsJvmSignaturesClash() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/constructorsJvmSignaturesClash.kt");
      }

      @Test
      @TestMetadata("constructorsJvmSignaturesClashInlineClass.kt")
      public void testConstructorsJvmSignaturesClashInlineClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/constructorsJvmSignaturesClashInlineClass.kt");
      }

      @Test
      @TestMetadata("declarationClash.kt")
      public void testDeclarationClash() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/declarationClash.kt");
      }

      @Test
      @TestMetadata("functionsJvmSignaturesClash.kt")
      public void testFunctionsJvmSignaturesClash() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/functionsJvmSignaturesClash.kt");
      }

      @Test
      @TestMetadata("functionsJvmSignaturesClashInlineClass.kt")
      public void testFunctionsJvmSignaturesClashInlineClass() {
        runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/functionsJvmSignaturesClashInlineClass.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class MultifileClasses {
    @Test
    public void testAllFilesPresentInMultifileClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("jvmSynthetic.kt")
    public void testJvmSynthetic() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses/jvmSynthetic.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/scripts")
  @TestDataPath("$PROJECT_ROOT")
  public class Scripts {
    @Test
    public void testAllFilesPresentInScripts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/scripts"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("enumCapturesProperty.kts")
    public void testEnumCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/enumCapturesProperty.kts");
    }

    @Test
    @TestMetadata("enumEntryCapturesProperty.kts")
    public void testEnumEntryCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/enumEntryCapturesProperty.kts");
    }

    @Test
    @TestMetadata("interfaceCapturesProperty.kts")
    public void testInterfaceCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/interfaceCapturesProperty.kts");
    }

    @Test
    @TestMetadata("nestedAndOuterClassesCaptureProperty.kts")
    public void testNestedAndOuterClassesCaptureProperty() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/nestedAndOuterClassesCaptureProperty.kts");
    }

    @Test
    @TestMetadata("nestedClassCapturesProperty.kts")
    public void testNestedClassCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/nestedClassCapturesProperty.kts");
    }

    @Test
    @TestMetadata("nestedToObjectClassCapturesProperty.kts")
    public void testNestedToObjectClassCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/nestedToObjectClassCapturesProperty.kts");
    }

    @Test
    @TestMetadata("objectCapturesProperty.kts")
    public void testObjectCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/objectCapturesProperty.kts");
    }

    @Test
    @TestMetadata("objectCapturesPropertyIndirect.kts")
    public void testObjectCapturesPropertyIndirect() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/objectCapturesPropertyIndirect.kts");
    }

    @Test
    @TestMetadata("objectCapturesPropertyViaExtension1.kts")
    public void testObjectCapturesPropertyViaExtension1() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/objectCapturesPropertyViaExtension1.kts");
    }

    @Test
    @TestMetadata("objectCapturesPropertyViaExtension2.kts")
    public void testObjectCapturesPropertyViaExtension2() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/scripts/objectCapturesPropertyViaExtension2.kts");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/typeOf")
  @TestDataPath("$PROJECT_ROOT")
  public class TypeOf {
    @Test
    public void testAllFilesPresentInTypeOf() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/typeOf"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("nonReifiedTypeParameterWithRecursiveBound.kt")
    public void testNonReifiedTypeParameterWithRecursiveBound() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/typeOf/nonReifiedTypeParameterWithRecursiveBound.kt");
    }

    @Test
    @TestMetadata("suspendType.kt")
    public void testSuspendType() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/typeOf/suspendType.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class ValueClasses {
    @Test
    public void testAllFilesPresentInValueClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("cloneable.kt")
    public void testCloneable() {
      runTest("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses/cloneable.kt");
    }
  }
}
