/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Tag;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.test.generators.GenerateCompilerTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
public class JvmAbiConsistencyTestRestGenerated extends AbstractJvmAbiConsistencyTest {
  @Nested
  @TestMetadata("compiler/testData/codegen/boxInline")
  @TestDataPath("$PROJECT_ROOT")
  public class BoxInline {
    @Test
    public void testAllFilesPresentInBoxInline() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
      @Test
      public void testAllFilesPresentInAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotationInstanceInlining.kt")
      public void testAnnotationInstanceInlining() {
        runTest("compiler/testData/codegen/boxInline/annotations/annotationInstanceInlining.kt");
      }

      @Test
      @TestMetadata("instanceInAnonymousClass.kt")
      public void testInstanceInAnonymousClass() {
        runTest("compiler/testData/codegen/boxInline/annotations/instanceInAnonymousClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject")
    @TestDataPath("$PROJECT_ROOT")
    public class AnonymousObject {
      @Test
      public void testAllFilesPresentInAnonymousObject() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("anonymousObjectInCallChildren.kt")
      public void testAnonymousObjectInCallChildren() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInCallChildren.kt");
      }

      @Test
      @TestMetadata("anonymousObjectInDefault.kt")
      public void testAnonymousObjectInDefault() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInDefault.kt");
      }

      @Test
      @TestMetadata("anonymousObjectOnCallSite.kt")
      public void testAnonymousObjectOnCallSite() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSite.kt");
      }

      @Test
      @TestMetadata("anonymousObjectOnCallSiteSuperParams.kt")
      public void testAnonymousObjectOnCallSiteSuperParams() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSiteSuperParams.kt");
      }

      @Test
      @TestMetadata("anonymousObjectOnDeclarationSite.kt")
      public void testAnonymousObjectOnDeclarationSite() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSite.kt");
      }

      @Test
      @TestMetadata("anonymousObjectOnDeclarationSiteSuperParams.kt")
      public void testAnonymousObjectOnDeclarationSiteSuperParams() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSiteSuperParams.kt");
      }

      @Test
      @TestMetadata("capturedLambdaInInline.kt")
      public void testCapturedLambdaInInline() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline.kt");
      }

      @Test
      @TestMetadata("capturedLambdaInInline2.kt")
      public void testCapturedLambdaInInline2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline2.kt");
      }

      @Test
      @TestMetadata("capturedLambdaInInline3.kt")
      public void testCapturedLambdaInInline3() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline3.kt");
      }

      @Test
      @TestMetadata("capturedLambdaInInlineObject.kt")
      public void testCapturedLambdaInInlineObject() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInlineObject.kt");
      }

      @Test
      @TestMetadata("capturedLocalFun.kt")
      public void testCapturedLocalFun() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFun.kt");
      }

      @Test
      @TestMetadata("capturedLocalFunRef.kt")
      public void testCapturedLocalFunRef() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFunRef.kt");
      }

      @Test
      @TestMetadata("capturedLocalFunTwice.kt")
      public void testCapturedLocalFunTwice() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFunTwice.kt");
      }

      @Test
      @TestMetadata("changingReturnType.kt")
      public void testChangingReturnType() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/changingReturnType.kt");
      }

      @Test
      @TestMetadata("constructOriginalInRegenerated.kt")
      public void testConstructOriginalInRegenerated() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/constructOriginalInRegenerated.kt");
      }

      @Test
      @TestMetadata("constructorVisibility.kt")
      public void testConstructorVisibility() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibility.kt");
      }

      @Test
      @TestMetadata("constructorVisibilityInConstLambda.kt")
      public void testConstructorVisibilityInConstLambda() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInConstLambda.kt");
      }

      @Test
      @TestMetadata("constructorVisibilityInLambda.kt")
      public void testConstructorVisibilityInLambda() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInLambda.kt");
      }

      @Test
      @TestMetadata("defineClass.kt")
      public void testDefineClass() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/defineClass.kt");
      }

      @Test
      @TestMetadata("fakeOverrideInDefaultMultiModule.kt")
      public void testFakeOverrideInDefaultMultiModule() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/fakeOverrideInDefaultMultiModule.kt");
      }

      @Test
      @TestMetadata("fakeOverrideMultiModule.kt")
      public void testFakeOverrideMultiModule() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/fakeOverrideMultiModule.kt");
      }

      @Test
      @TestMetadata("functionExpression.kt")
      public void testFunctionExpression() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/functionExpression.kt");
      }

      @Test
      @TestMetadata("inlineCallInsideInlineLambda.kt")
      public void testInlineCallInsideInlineLambda() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/inlineCallInsideInlineLambda.kt");
      }

      @Test
      @TestMetadata("kt13133.kt")
      public void testKt13133() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13133.kt");
      }

      @Test
      @TestMetadata("kt13182.kt")
      public void testKt13182() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13182.kt");
      }

      @Test
      @TestMetadata("kt13374.kt")
      public void testKt13374() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13374.kt");
      }

      @Test
      @TestMetadata("kt14011.kt")
      public void testKt14011() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011.kt");
      }

      @Test
      @TestMetadata("kt14011_2.kt")
      public void testKt14011_2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_2.kt");
      }

      @Test
      @TestMetadata("kt14011_3.kt")
      public void testKt14011_3() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_3.kt");
      }

      @Test
      @TestMetadata("kt15751.kt")
      public void testKt15751() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt15751.kt");
      }

      @Test
      @TestMetadata("kt16193.kt")
      public void testKt16193() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt16193.kt");
      }

      @Test
      @TestMetadata("kt17972.kt")
      public void testKt17972() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972.kt");
      }

      @Test
      @TestMetadata("kt17972_2.kt")
      public void testKt17972_2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_2.kt");
      }

      @Test
      @TestMetadata("kt17972_3.kt")
      public void testKt17972_3() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_3.kt");
      }

      @Test
      @TestMetadata("kt17972_4.kt")
      public void testKt17972_4() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_4.kt");
      }

      @Test
      @TestMetadata("kt17972_5.kt")
      public void testKt17972_5() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_5.kt");
      }

      @Test
      @TestMetadata("kt17972_super.kt")
      public void testKt17972_super() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super.kt");
      }

      @Test
      @TestMetadata("kt17972_super2.kt")
      public void testKt17972_super2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super2.kt");
      }

      @Test
      @TestMetadata("kt17972_super3.kt")
      public void testKt17972_super3() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super3.kt");
      }

      @Test
      @TestMetadata("kt19389.kt")
      public void testKt19389() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19389.kt");
      }

      @Test
      @TestMetadata("kt19399.kt")
      public void testKt19399() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19399.kt");
      }

      @Test
      @TestMetadata("kt19434.kt")
      public void testKt19434() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434.kt");
      }

      @Test
      @TestMetadata("kt19434_2.kt")
      public void testKt19434_2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434_2.kt");
      }

      @Test
      @TestMetadata("kt19723.kt")
      public void testKt19723() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19723.kt");
      }

      @Test
      @TestMetadata("kt29595.kt")
      public void testKt29595() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt29595.kt");
      }

      @Test
      @TestMetadata("kt30696.kt")
      public void testKt30696() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt30696.kt");
      }

      @Test
      @TestMetadata("kt34656.kt")
      public void testKt34656() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt34656.kt");
      }

      @Test
      @TestMetadata("kt38197.kt")
      public void testKt38197() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt38197.kt");
      }

      @Test
      @TestMetadata("kt41174.kt")
      public void testKt41174() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt41174.kt");
      }

      @Test
      @TestMetadata("kt42815.kt")
      public void testKt42815() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815.kt");
      }

      @Test
      @TestMetadata("kt42815_delegated.kt")
      public void testKt42815_delegated() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815_delegated.kt");
      }

      @Test
      @TestMetadata("kt51950.kt")
      public void testKt51950() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt51950.kt");
      }

      @Test
      @TestMetadata("kt52795.kt")
      public void testKt52795() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795.kt");
      }

      @Test
      @TestMetadata("kt52795_2.kt")
      public void testKt52795_2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_2.kt");
      }

      @Test
      @TestMetadata("kt52795_3.kt")
      public void testKt52795_3() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_3.kt");
      }

      @Test
      @TestMetadata("kt52795_4.kt")
      public void testKt52795_4() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_4.kt");
      }

      @Test
      @TestMetadata("kt52795_5.kt")
      public void testKt52795_5() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_5.kt");
      }

      @Test
      @TestMetadata("kt57053.kt")
      public void testKt57053() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt57053.kt");
      }

      @Test
      @TestMetadata("kt6007.kt")
      public void testKt6007() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6007.kt");
      }

      @Test
      @TestMetadata("kt65503.kt")
      public void testKt65503() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt65503.kt");
      }

      @Test
      @TestMetadata("kt65503_2.kt")
      public void testKt65503_2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt65503_2.kt");
      }

      @Test
      @TestMetadata("kt6552.kt")
      public void testKt6552() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6552.kt");
      }

      @Test
      @TestMetadata("kt8133.kt")
      public void testKt8133() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt8133.kt");
      }

      @Test
      @TestMetadata("kt9064.kt")
      public void testKt9064() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064.kt");
      }

      @Test
      @TestMetadata("kt9064v2.kt")
      public void testKt9064v2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064v2.kt");
      }

      @Test
      @TestMetadata("kt9591.kt")
      public void testKt9591() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9591.kt");
      }

      @Test
      @TestMetadata("kt9877.kt")
      public void testKt9877() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877.kt");
      }

      @Test
      @TestMetadata("kt9877_2.kt")
      public void testKt9877_2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877_2.kt");
      }

      @Test
      @TestMetadata("objectInLambdaCapturesAnotherObject.kt")
      public void testObjectInLambdaCapturesAnotherObject() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/objectInLambdaCapturesAnotherObject.kt");
      }

      @Test
      @TestMetadata("safeCall.kt")
      public void testSafeCall() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall.kt");
      }

      @Test
      @TestMetadata("safeCall_2.kt")
      public void testSafeCall_2() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall_2.kt");
      }

      @Test
      @TestMetadata("sam.kt")
      public void testSam() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/sam.kt");
      }

      @Test
      @TestMetadata("sharedFromCrossinline.kt")
      public void testSharedFromCrossinline() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/sharedFromCrossinline.kt");
      }

      @Test
      @TestMetadata("superConstructorWithObjectParameter.kt")
      public void testSuperConstructorWithObjectParameter() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/superConstructorWithObjectParameter.kt");
      }

      @Test
      @TestMetadata("twoAnonymousObjects.kt")
      public void testTwoAnonymousObjects() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/twoAnonymousObjects.kt");
      }

      @Test
      @TestMetadata("typeInfo.kt")
      public void testTypeInfo() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/typeInfo.kt");
      }

      @Test
      @TestMetadata("withInlineMethod.kt")
      public void testWithInlineMethod() {
        runTest("compiler/testData/codegen/boxInline/anonymousObject/withInlineMethod.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumEntries")
      @TestDataPath("$PROJECT_ROOT")
      public class EnumEntries {
        @Test
        public void testAllFilesPresentInEnumEntries() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumEntries"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callSite.kt")
        public void testCallSite() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/callSite.kt");
        }

        @Test
        @TestMetadata("declSite.kt")
        public void testDeclSite() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSite.kt");
        }

        @Test
        @TestMetadata("declSiteSeveralMappings.kt")
        public void testDeclSiteSeveralMappings() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSiteSeveralMappings.kt");
        }

        @Test
        @TestMetadata("declSiteSeveralMappingsDifOrder.kt")
        public void testDeclSiteSeveralMappingsDifOrder() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSiteSeveralMappingsDifOrder.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/enumWhen")
      @TestDataPath("$PROJECT_ROOT")
      public class EnumWhen {
        @Test
        public void testAllFilesPresentInEnumWhen() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumWhen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callSite.kt")
        public void testCallSite() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/callSite.kt");
        }

        @Test
        @TestMetadata("declSite.kt")
        public void testDeclSite() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSite.kt");
        }

        @Test
        @TestMetadata("declSiteSeveralMappings.kt")
        public void testDeclSiteSeveralMappings() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappings.kt");
        }

        @Test
        @TestMetadata("declSiteSeveralMappingsDifOrder.kt")
        public void testDeclSiteSeveralMappingsDifOrder() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappingsDifOrder.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing")
      @TestDataPath("$PROJECT_ROOT")
      public class ProperRecapturing {
        @Test
        public void testAllFilesPresentInProperRecapturing() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineChain.kt")
        public void testInlineChain() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/inlineChain.kt");
        }

        @Test
        @TestMetadata("lambdaChain.kt")
        public void testLambdaChain() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain.kt");
        }

        @Test
        @TestMetadata("lambdaChainSimple.kt")
        public void testLambdaChainSimple() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChainSimple.kt");
        }

        @Test
        @TestMetadata("lambdaChain_2.kt")
        public void testLambdaChain_2() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_2.kt");
        }

        @Test
        @TestMetadata("lambdaChain_3.kt")
        public void testLambdaChain_3() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_3.kt");
        }

        @Test
        @TestMetadata("noInlineLambda.kt")
        public void testNoInlineLambda() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/noInlineLambda.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass")
      @TestDataPath("$PROJECT_ROOT")
      public class ProperRecapturingInClass {
        @Test
        public void testAllFilesPresentInProperRecapturingInClass() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineChain.kt")
        public void testInlineChain() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlineChain.kt");
        }

        @Test
        @TestMetadata("inlinelambdaChain.kt")
        public void testInlinelambdaChain() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlinelambdaChain.kt");
        }

        @Test
        @TestMetadata("lambdaChain.kt")
        public void testLambdaChain() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain.kt");
        }

        @Test
        @TestMetadata("lambdaChainSimple.kt")
        public void testLambdaChainSimple() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple.kt");
        }

        @Test
        @TestMetadata("lambdaChainSimple_2.kt")
        public void testLambdaChainSimple_2() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple_2.kt");
        }

        @Test
        @TestMetadata("lambdaChain_2.kt")
        public void testLambdaChain_2() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_2.kt");
        }

        @Test
        @TestMetadata("lambdaChain_3.kt")
        public void testLambdaChain_3() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_3.kt");
        }

        @Test
        @TestMetadata("noCapturedThisOnCallSite.kt")
        public void testNoCapturedThisOnCallSite() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noCapturedThisOnCallSite.kt");
        }

        @Test
        @TestMetadata("noInlineLambda.kt")
        public void testNoInlineLambda() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noInlineLambda.kt");
        }

        @Test
        @TestMetadata("twoInlineLambda.kt")
        public void testTwoInlineLambda() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambda.kt");
        }

        @Test
        @TestMetadata("twoInlineLambdaComplex.kt")
        public void testTwoInlineLambdaComplex() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex.kt");
        }

        @Test
        @TestMetadata("twoInlineLambdaComplex_2.kt")
        public void testTwoInlineLambdaComplex_2() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex_2.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/sam")
      @TestDataPath("$PROJECT_ROOT")
      public class Sam {
        @Test
        public void testAllFilesPresentInSam() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("anonymousObjectToSam.kt")
        public void testAnonymousObjectToSam() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/anonymousObjectToSam.kt");
        }

        @Test
        @TestMetadata("kt17091.kt")
        public void testKt17091() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt17091.kt");
        }

        @Test
        @TestMetadata("kt21671.kt")
        public void testKt21671() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671.kt");
        }

        @Test
        @TestMetadata("kt21671_2.kt")
        public void testKt21671_2() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_2.kt");
        }

        @Test
        @TestMetadata("kt21671_3.kt")
        public void testKt21671_3() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_3.kt");
        }

        @Test
        @TestMetadata("kt22304.kt")
        public void testKt22304() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt22304.kt");
        }

        @Test
        @TestMetadata("samOnCallSite.kt")
        public void testSamOnCallSite() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/samOnCallSite.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers")
      @TestDataPath("$PROJECT_ROOT")
      public class TwoCapturedReceivers {
        @Test
        public void testAllFilesPresentInTwoCapturedReceivers() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt8668.kt")
        public void testKt8668() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668.kt");
        }

        @Test
        @TestMetadata("kt8668_2.kt")
        public void testKt8668_2() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_2.kt");
        }

        @Test
        @TestMetadata("kt8668_3.kt")
        public void testKt8668_3() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_3.kt");
        }

        @Test
        @TestMetadata("kt8668_nested.kt")
        public void testKt8668_nested() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested.kt");
        }

        @Test
        @TestMetadata("kt8668_nested_2.kt")
        public void testKt8668_nested_2() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested_2.kt");
        }

        @Test
        @TestMetadata("twoDifferentDispatchReceivers.kt")
        public void testTwoDifferentDispatchReceivers() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoDifferentDispatchReceivers.kt");
        }

        @Test
        @TestMetadata("twoExtensionReceivers.kt")
        public void testTwoExtensionReceivers() {
          runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoExtensionReceivers.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    public class ArgumentOrder {
      @Test
      public void testAllFilesPresentInArgumentOrder() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("boundFunctionReference.kt")
      public void testBoundFunctionReference() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference.kt");
      }

      @Test
      @TestMetadata("boundFunctionReference2.kt")
      public void testBoundFunctionReference2() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference2.kt");
      }

      @Test
      @TestMetadata("captured.kt")
      public void testCaptured() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/captured.kt");
      }

      @Test
      @TestMetadata("capturedInExtension.kt")
      public void testCapturedInExtension() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/capturedInExtension.kt");
      }

      @Test
      @TestMetadata("defaultParametersAndLastVararg.kt")
      public void testDefaultParametersAndLastVararg() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVararg.kt");
      }

      @Test
      @TestMetadata("defaultParametersAndLastVarargWithCorrectOrder.kt")
      public void testDefaultParametersAndLastVarargWithCorrectOrder() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVarargWithCorrectOrder.kt");
      }

      @Test
      @TestMetadata("extension.kt")
      public void testExtension() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/extension.kt");
      }

      @Test
      @TestMetadata("extensionInClass.kt")
      public void testExtensionInClass() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/extensionInClass.kt");
      }

      @Test
      @TestMetadata("lambdaMigration.kt")
      public void testLambdaMigration() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigration.kt");
      }

      @Test
      @TestMetadata("lambdaMigrationInClass.kt")
      public void testLambdaMigrationInClass() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigrationInClass.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/simple.kt");
      }

      @Test
      @TestMetadata("simpleInClass.kt")
      public void testSimpleInClass() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/simpleInClass.kt");
      }

      @Test
      @TestMetadata("varargAndDefaultParameters.kt")
      public void testVarargAndDefaultParameters() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParameters.kt");
      }

      @Test
      @TestMetadata("varargAndDefaultParametersWithCorrectOrder.kt")
      public void testVarargAndDefaultParametersWithCorrectOrder() {
        runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParametersWithCorrectOrder.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/arrayConvention")
    @TestDataPath("$PROJECT_ROOT")
    public class ArrayConvention {
      @Test
      public void testAllFilesPresentInArrayConvention() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/arrayConvention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("simpleAccess.kt")
      public void testSimpleAccess() {
        runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccess.kt");
      }

      @Test
      @TestMetadata("simpleAccessInClass.kt")
      public void testSimpleAccessInClass() {
        runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessInClass.kt");
      }

      @Test
      @TestMetadata("simpleAccessWithDefault.kt")
      public void testSimpleAccessWithDefault() {
        runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefault.kt");
      }

      @Test
      @TestMetadata("simpleAccessWithDefaultInClass.kt")
      public void testSimpleAccessWithDefaultInClass() {
        runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefaultInClass.kt");
      }

      @Test
      @TestMetadata("simpleAccessWithLambda.kt")
      public void testSimpleAccessWithLambda() {
        runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambda.kt");
      }

      @Test
      @TestMetadata("simpleAccessWithLambdaInClass.kt")
      public void testSimpleAccessWithLambdaInClass() {
        runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambdaInClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/assert")
    @TestDataPath("$PROJECT_ROOT")
    public class Assert {
      @Test
      public void testAllFilesPresentInAssert() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("jvmAssertInlineFunctionAssertionsDisabled.kt")
      public void testJvmAssertInlineFunctionAssertionsDisabled() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsDisabled.kt");
      }

      @Test
      @TestMetadata("jvmAssertInlineFunctionAssertionsEnabled.kt")
      public void testJvmAssertInlineFunctionAssertionsEnabled() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsEnabled.kt");
      }

      @Test
      @TestMetadata("jvmAssertInlineLambda.kt")
      public void testJvmAssertInlineLambda() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineLambda.kt");
      }

      @Test
      @TestMetadata("jvmClassInitializer.kt")
      public void testJvmClassInitializer() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmClassInitializer.kt");
      }

      @Test
      @TestMetadata("jvmCompanion.kt")
      public void testJvmCompanion() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmCompanion.kt");
      }

      @Test
      @TestMetadata("jvmCrossinlineLambda.kt")
      public void testJvmCrossinlineLambda() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda.kt");
      }

      @Test
      @TestMetadata("jvmCrossinlineLambda2.kt")
      public void testJvmCrossinlineLambda2() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda2.kt");
      }

      @Test
      @TestMetadata("jvmCrossinlineLambdaDeclarationSite.kt")
      public void testJvmCrossinlineLambdaDeclarationSite() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSite.kt");
      }

      @Test
      @TestMetadata("jvmCrossinlineLambdaDeclarationSiteOnly.kt")
      public void testJvmCrossinlineLambdaDeclarationSiteOnly() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSiteOnly.kt");
      }

      @Test
      @TestMetadata("jvmCrossinlineRedundant.kt")
      public void testJvmCrossinlineRedundant() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineRedundant.kt");
      }

      @Test
      @TestMetadata("jvmCrossinlineSAMDeclarationSite.kt")
      public void testJvmCrossinlineSAMDeclarationSite() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineSAMDeclarationSite.kt");
      }

      @Test
      @TestMetadata("jvmDoubleInline.kt")
      public void testJvmDoubleInline() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmDoubleInline.kt");
      }

      @Test
      @TestMetadata("jvmInlineIntoTwoMethods.kt")
      public void testJvmInlineIntoTwoMethods() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmInlineIntoTwoMethods.kt");
      }

      @Test
      @TestMetadata("jvmInlineUsedAsNoinline.kt")
      public void testJvmInlineUsedAsNoinline() {
        runTest("compiler/testData/codegen/boxInline/assert/jvmInlineUsedAsNoinline.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/builders")
    @TestDataPath("$PROJECT_ROOT")
    public class Builders {
      @Test
      public void testAllFilesPresentInBuilders() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/builders"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("builders.kt")
      public void testBuilders() {
        runTest("compiler/testData/codegen/boxInline/builders/builders.kt");
      }

      @Test
      @TestMetadata("buildersAndLambdaCapturing.kt")
      public void testBuildersAndLambdaCapturing() {
        runTest("compiler/testData/codegen/boxInline/builders/buildersAndLambdaCapturing.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/bytecodePreprocessing")
    @TestDataPath("$PROJECT_ROOT")
    public class BytecodePreprocessing {
      @Test
      public void testAllFilesPresentInBytecodePreprocessing() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/bytecodePreprocessing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("apiVersionAtLeast1.kt")
      public void testApiVersionAtLeast1() {
        runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/apiVersionAtLeast1.kt");
      }

      @Test
      @TestMetadata("inlineApiVersionAtLeastInStdlibInlineFunction.kt")
      public void testInlineApiVersionAtLeastInStdlibInlineFunction() {
        runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/inlineApiVersionAtLeastInStdlibInlineFunction.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReference {
      @Test
      @TestMetadata("adapted.kt")
      public void testAdapted() {
        runTest("compiler/testData/codegen/boxInline/callableReference/adapted.kt");
      }

      @Test
      public void testAllFilesPresentInCallableReference() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("classLevel.kt")
      public void testClassLevel() {
        runTest("compiler/testData/codegen/boxInline/callableReference/classLevel.kt");
      }

      @Test
      @TestMetadata("classLevel2.kt")
      public void testClassLevel2() {
        runTest("compiler/testData/codegen/boxInline/callableReference/classLevel2.kt");
      }

      @Test
      @TestMetadata("constructor.kt")
      public void testConstructor() {
        runTest("compiler/testData/codegen/boxInline/callableReference/constructor.kt");
      }

      @Test
      @TestMetadata("inlineCallableReference.kt")
      public void testInlineCallableReference() {
        runTest("compiler/testData/codegen/boxInline/callableReference/inlineCallableReference.kt");
      }

      @Test
      @TestMetadata("innerGenericConstuctor.kt")
      public void testInnerGenericConstuctor() {
        runTest("compiler/testData/codegen/boxInline/callableReference/innerGenericConstuctor.kt");
      }

      @Test
      @TestMetadata("intrinsic.kt")
      public void testIntrinsic() {
        runTest("compiler/testData/codegen/boxInline/callableReference/intrinsic.kt");
      }

      @Test
      @TestMetadata("jvmFieldProperty.kt")
      public void testJvmFieldProperty() {
        runTest("compiler/testData/codegen/boxInline/callableReference/jvmFieldProperty.kt");
      }

      @Test
      @TestMetadata("kt15449.kt")
      public void testKt15449() {
        runTest("compiler/testData/codegen/boxInline/callableReference/kt15449.kt");
      }

      @Test
      @TestMetadata("kt15751_2.kt")
      public void testKt15751_2() {
        runTest("compiler/testData/codegen/boxInline/callableReference/kt15751_2.kt");
      }

      @Test
      @TestMetadata("kt16411.kt")
      public void testKt16411() {
        runTest("compiler/testData/codegen/boxInline/callableReference/kt16411.kt");
      }

      @Test
      @TestMetadata("kt35101.kt")
      public void testKt35101() {
        runTest("compiler/testData/codegen/boxInline/callableReference/kt35101.kt");
      }

      @Test
      @TestMetadata("propertyIntrinsic.kt")
      public void testPropertyIntrinsic() {
        runTest("compiler/testData/codegen/boxInline/callableReference/propertyIntrinsic.kt");
      }

      @Test
      @TestMetadata("propertyReference.kt")
      public void testPropertyReference() {
        runTest("compiler/testData/codegen/boxInline/callableReference/propertyReference.kt");
      }

      @Test
      @TestMetadata("topLevel.kt")
      public void testTopLevel() {
        runTest("compiler/testData/codegen/boxInline/callableReference/topLevel.kt");
      }

      @Test
      @TestMetadata("topLevelExtension.kt")
      public void testTopLevelExtension() {
        runTest("compiler/testData/codegen/boxInline/callableReference/topLevelExtension.kt");
      }

      @Test
      @TestMetadata("topLevelProperty.kt")
      public void testTopLevelProperty() {
        runTest("compiler/testData/codegen/boxInline/callableReference/topLevelProperty.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/callableReference/adaptedReferences")
      @TestDataPath("$PROJECT_ROOT")
      public class AdaptedReferences {
        @Test
        public void testAllFilesPresentInAdaptedReferences() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineBound.kt")
        public void testInlineBound() {
          runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineBound.kt");
        }

        @Test
        @TestMetadata("inlineDefault.kt")
        public void testInlineDefault() {
          runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineDefault.kt");
        }

        @Test
        @TestMetadata("inlineVararg.kt")
        public void testInlineVararg() {
          runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVararg.kt");
        }

        @Test
        @TestMetadata("inlineVarargAndDefault.kt")
        public void testInlineVarargAndDefault() {
          runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
        }

        @Test
        @TestMetadata("inlineVarargInts.kt")
        public void testInlineVarargInts() {
          runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargInts.kt");
        }

        @Test
        @TestMetadata("inlineVarargWithLetCall.kt")
        public void testInlineVarargWithLetCall() {
          runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargWithLetCall.kt");
        }

        @Test
        @TestMetadata("multipleCallableReferenceUsage.kt")
        public void testMultipleCallableReferenceUsage() {
          runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/multipleCallableReferenceUsage.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/callableReference/bound")
      @TestDataPath("$PROJECT_ROOT")
      public class Bound {
        @Test
        public void testAllFilesPresentInBound() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("classProperty.kt")
        public void testClassProperty() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/classProperty.kt");
        }

        @Test
        @TestMetadata("doubleBoundToThis.kt")
        public void testDoubleBoundToThis() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/doubleBoundToThis.kt");
        }

        @Test
        @TestMetadata("emptyLhsFunction.kt")
        public void testEmptyLhsFunction() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsFunction.kt");
        }

        @Test
        @TestMetadata("emptyLhsOnInlineProperty.kt")
        public void testEmptyLhsOnInlineProperty() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsOnInlineProperty.kt");
        }

        @Test
        @TestMetadata("emptyLhsProperty.kt")
        public void testEmptyLhsProperty() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsProperty.kt");
        }

        @Test
        @TestMetadata("expression.kt")
        public void testExpression() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/expression.kt");
        }

        @Test
        @TestMetadata("extensionReceiver.kt")
        public void testExtensionReceiver() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/extensionReceiver.kt");
        }

        @Test
        @TestMetadata("filter.kt")
        public void testFilter() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/filter.kt");
        }

        @Test
        @TestMetadata("inlineValueParameterInsteadOfReceiver.kt")
        public void testInlineValueParameterInsteadOfReceiver() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/inlineValueParameterInsteadOfReceiver.kt");
        }

        @Test
        @TestMetadata("innerGenericConstuctor.kt")
        public void testInnerGenericConstuctor() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/innerGenericConstuctor.kt");
        }

        @Test
        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/intrinsic.kt");
        }

        @Test
        @TestMetadata("jvmFieldProperty.kt")
        public void testJvmFieldProperty() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/jvmFieldProperty.kt");
        }

        @Test
        @TestMetadata("kt18728.kt")
        public void testKt18728() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728.kt");
        }

        @Test
        @TestMetadata("kt18728_2.kt")
        public void testKt18728_2() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_2.kt");
        }

        @Test
        @TestMetadata("kt18728_3.kt")
        public void testKt18728_3() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_3.kt");
        }

        @Test
        @TestMetadata("kt18728_4.kt")
        public void testKt18728_4() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_4.kt");
        }

        @Test
        @TestMetadata("kt30933.kt")
        public void testKt30933() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt30933.kt");
        }

        @Test
        @TestMetadata("lambdaOnLhs.kt")
        public void testLambdaOnLhs() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/lambdaOnLhs.kt");
        }

        @Test
        @TestMetadata("map.kt")
        public void testMap() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/map.kt");
        }

        @Test
        @TestMetadata("mixed.kt")
        public void testMixed() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/mixed.kt");
        }

        @Test
        @TestMetadata("objectProperty.kt")
        public void testObjectProperty() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/objectProperty.kt");
        }

        @Test
        @TestMetadata("propertyImportedFromObject.kt")
        public void testPropertyImportedFromObject() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/propertyImportedFromObject.kt");
        }

        @Test
        @TestMetadata("sideEffect.kt")
        public void testSideEffect() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/sideEffect.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/simple.kt");
        }

        @Test
        @TestMetadata("simpleVal.kt")
        public void testSimpleVal() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal.kt");
        }

        @Test
        @TestMetadata("simpleVal2.kt")
        public void testSimpleVal2() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal2.kt");
        }

        @Test
        @TestMetadata("topLevelExtensionProperty.kt")
        public void testTopLevelExtensionProperty() {
          runTest("compiler/testData/codegen/boxInline/callableReference/bound/topLevelExtensionProperty.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/capture")
    @TestDataPath("$PROJECT_ROOT")
    public class Capture {
      @Test
      public void testAllFilesPresentInCapture() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/capture"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("captureInlinable.kt")
      public void testCaptureInlinable() {
        runTest("compiler/testData/codegen/boxInline/capture/captureInlinable.kt");
      }

      @Test
      @TestMetadata("captureInlinableAndOther.kt")
      public void testCaptureInlinableAndOther() {
        runTest("compiler/testData/codegen/boxInline/capture/captureInlinableAndOther.kt");
      }

      @Test
      @TestMetadata("captureThisAndReceiver.kt")
      public void testCaptureThisAndReceiver() {
        runTest("compiler/testData/codegen/boxInline/capture/captureThisAndReceiver.kt");
      }

      @Test
      @TestMetadata("generics.kt")
      public void testGenerics() {
        runTest("compiler/testData/codegen/boxInline/capture/generics.kt");
      }

      @Test
      @TestMetadata("kt48230.kt")
      public void testKt48230() {
        runTest("compiler/testData/codegen/boxInline/capture/kt48230.kt");
      }

      @Test
      @TestMetadata("kt48230_2.kt")
      public void testKt48230_2() {
        runTest("compiler/testData/codegen/boxInline/capture/kt48230_2.kt");
      }

      @Test
      @TestMetadata("kt56500.kt")
      public void testKt56500() {
        runTest("compiler/testData/codegen/boxInline/capture/kt56500.kt");
      }

      @Test
      @TestMetadata("kt56965.kt")
      public void testKt56965() {
        runTest("compiler/testData/codegen/boxInline/capture/kt56965.kt");
      }

      @Test
      @TestMetadata("kt56965_2.kt")
      public void testKt56965_2() {
        runTest("compiler/testData/codegen/boxInline/capture/kt56965_2.kt");
      }

      @Test
      @TestMetadata("simpleCapturingInClass.kt")
      public void testSimpleCapturingInClass() {
        runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInClass.kt");
      }

      @Test
      @TestMetadata("simpleCapturingInPackage.kt")
      public void testSimpleCapturingInPackage() {
        runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInPackage.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/complex")
    @TestDataPath("$PROJECT_ROOT")
    public class Complex {
      @Test
      public void testAllFilesPresentInComplex() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("closureChain.kt")
      public void testClosureChain() {
        runTest("compiler/testData/codegen/boxInline/complex/closureChain.kt");
      }

      @Test
      @TestMetadata("forEachLine.kt")
      public void testForEachLine() {
        runTest("compiler/testData/codegen/boxInline/complex/forEachLine.kt");
      }

      @Test
      @TestMetadata("kt44429.kt")
      public void testKt44429() {
        runTest("compiler/testData/codegen/boxInline/complex/kt44429.kt");
      }

      @Test
      @TestMetadata("kt44429MustFail.kt")
      public void testKt44429MustFail() {
        runTest("compiler/testData/codegen/boxInline/complex/kt44429MustFail.kt");
      }

      @Test
      @TestMetadata("lambdaInLambda.kt")
      public void testLambdaInLambda() {
        runTest("compiler/testData/codegen/boxInline/complex/lambdaInLambda.kt");
      }

      @Test
      @TestMetadata("nestedCallsWithGeneric.kt")
      public void testNestedCallsWithGeneric() {
        runTest("compiler/testData/codegen/boxInline/complex/nestedCallsWithGeneric.kt");
      }

      @Test
      @TestMetadata("nestedCallsWithGenericToInt.kt")
      public void testNestedCallsWithGenericToInt() {
        runTest("compiler/testData/codegen/boxInline/complex/nestedCallsWithGenericToInt.kt");
      }

      @Test
      @TestMetadata("swapAndWith.kt")
      public void testSwapAndWith() {
        runTest("compiler/testData/codegen/boxInline/complex/swapAndWith.kt");
      }

      @Test
      @TestMetadata("swapAndWith2.kt")
      public void testSwapAndWith2() {
        runTest("compiler/testData/codegen/boxInline/complex/swapAndWith2.kt");
      }

      @Test
      @TestMetadata("use.kt")
      public void testUse() {
        runTest("compiler/testData/codegen/boxInline/complex/use.kt");
      }

      @Test
      @TestMetadata("with.kt")
      public void testWith() {
        runTest("compiler/testData/codegen/boxInline/complex/with.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/complexStack")
    @TestDataPath("$PROJECT_ROOT")
    public class ComplexStack {
      @Test
      public void testAllFilesPresentInComplexStack() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complexStack"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("asCheck.kt")
      public void testAsCheck() {
        runTest("compiler/testData/codegen/boxInline/complexStack/asCheck.kt");
      }

      @Test
      @TestMetadata("asCheck2.kt")
      public void testAsCheck2() {
        runTest("compiler/testData/codegen/boxInline/complexStack/asCheck2.kt");
      }

      @Test
      @TestMetadata("breakContinueInInlineLambdaArgument.kt")
      public void testBreakContinueInInlineLambdaArgument() {
        runTest("compiler/testData/codegen/boxInline/complexStack/breakContinueInInlineLambdaArgument.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/boxInline/complexStack/simple.kt");
      }

      @Test
      @TestMetadata("simple2.kt")
      public void testSimple2() {
        runTest("compiler/testData/codegen/boxInline/complexStack/simple2.kt");
      }

      @Test
      @TestMetadata("simple3.kt")
      public void testSimple3() {
        runTest("compiler/testData/codegen/boxInline/complexStack/simple3.kt");
      }

      @Test
      @TestMetadata("simple4.kt")
      public void testSimple4() {
        runTest("compiler/testData/codegen/boxInline/complexStack/simple4.kt");
      }

      @Test
      @TestMetadata("simpleExtension.kt")
      public void testSimpleExtension() {
        runTest("compiler/testData/codegen/boxInline/complexStack/simpleExtension.kt");
      }

      @Test
      @TestMetadata("spillConstructorArgumentsAndInlineLambdaParameter.kt")
      public void testSpillConstructorArgumentsAndInlineLambdaParameter() {
        runTest("compiler/testData/codegen/boxInline/complexStack/spillConstructorArgumentsAndInlineLambdaParameter.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/contracts")
    @TestDataPath("$PROJECT_ROOT")
    public class Contracts {
      @Test
      public void testAllFilesPresentInContracts() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("cfgDependendValInitialization.kt")
      public void testCfgDependendValInitialization() {
        runTest("compiler/testData/codegen/boxInline/contracts/cfgDependendValInitialization.kt");
      }

      @Test
      @TestMetadata("complexInitializer.kt")
      public void testComplexInitializer() {
        runTest("compiler/testData/codegen/boxInline/contracts/complexInitializer.kt");
      }

      @Test
      @TestMetadata("complexInitializerWithStackTransformation.kt")
      public void testComplexInitializerWithStackTransformation() {
        runTest("compiler/testData/codegen/boxInline/contracts/complexInitializerWithStackTransformation.kt");
      }

      @Test
      @TestMetadata("crossinlineCallableReference.kt")
      public void testCrossinlineCallableReference() {
        runTest("compiler/testData/codegen/boxInline/contracts/crossinlineCallableReference.kt");
      }

      @Test
      @TestMetadata("definiteLongValInitialization.kt")
      public void testDefiniteLongValInitialization() {
        runTest("compiler/testData/codegen/boxInline/contracts/definiteLongValInitialization.kt");
      }

      @Test
      @TestMetadata("definiteNestedValInitialization.kt")
      public void testDefiniteNestedValInitialization() {
        runTest("compiler/testData/codegen/boxInline/contracts/definiteNestedValInitialization.kt");
      }

      @Test
      @TestMetadata("definiteValInitInInitializer.kt")
      public void testDefiniteValInitInInitializer() {
        runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitInInitializer.kt");
      }

      @Test
      @TestMetadata("definiteValInitialization.kt")
      public void testDefiniteValInitialization() {
        runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitialization.kt");
      }

      @Test
      @TestMetadata("exactlyOnceCrossinline.kt")
      public void testExactlyOnceCrossinline() {
        runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline.kt");
      }

      @Test
      @TestMetadata("exactlyOnceCrossinline2.kt")
      public void testExactlyOnceCrossinline2() {
        runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline2.kt");
      }

      @Test
      @TestMetadata("exactlyOnceNoinline.kt")
      public void testExactlyOnceNoinline() {
        runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceNoinline.kt");
      }

      @Test
      @TestMetadata("nonLocalReturn.kt")
      public void testNonLocalReturn() {
        runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturn.kt");
      }

      @Test
      @TestMetadata("nonLocalReturnWithCycle.kt")
      public void testNonLocalReturnWithCycle() {
        runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturnWithCycle.kt");
      }

      @Test
      @TestMetadata("propertyInitialization.kt")
      public void testPropertyInitialization() {
        runTest("compiler/testData/codegen/boxInline/contracts/propertyInitialization.kt");
      }

      @Test
      @TestMetadata("valInitializationAndUsageInNestedLambda.kt")
      public void testValInitializationAndUsageInNestedLambda() {
        runTest("compiler/testData/codegen/boxInline/contracts/valInitializationAndUsageInNestedLambda.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/defaultValues")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultValues {
      @Test
      @TestMetadata("33Parameters.kt")
      public void test33Parameters() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/33Parameters.kt");
      }

      @Test
      @TestMetadata("33ParametersInConstructor.kt")
      public void test33ParametersInConstructor() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/33ParametersInConstructor.kt");
      }

      @Test
      public void testAllFilesPresentInDefaultValues() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("defaultInExtension.kt")
      public void testDefaultInExtension() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/defaultInExtension.kt");
      }

      @Test
      @TestMetadata("defaultMethod.kt")
      public void testDefaultMethod() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethod.kt");
      }

      @Test
      @TestMetadata("defaultMethodInClass.kt")
      public void testDefaultMethodInClass() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethodInClass.kt");
      }

      @Test
      @TestMetadata("defaultParamRemapping.kt")
      public void testDefaultParamRemapping() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/defaultParamRemapping.kt");
      }

      @Test
      @TestMetadata("inlineInDefaultParameter.kt")
      public void testInlineInDefaultParameter() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/inlineInDefaultParameter.kt");
      }

      @Test
      @TestMetadata("inlineLambdaInNoInlineDefault.kt")
      public void testInlineLambdaInNoInlineDefault() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/inlineLambdaInNoInlineDefault.kt");
      }

      @Test
      @TestMetadata("kt11479.kt")
      public void testKt11479() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479.kt");
      }

      @Test
      @TestMetadata("kt11479InlinedDefaultParameter.kt")
      public void testKt11479InlinedDefaultParameter() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479InlinedDefaultParameter.kt");
      }

      @Test
      @TestMetadata("kt14564.kt")
      public void testKt14564() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564.kt");
      }

      @Test
      @TestMetadata("kt14564_2.kt")
      public void testKt14564_2() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564_2.kt");
      }

      @Test
      @TestMetadata("kt16496.kt")
      public void testKt16496() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt16496.kt");
      }

      @Test
      @TestMetadata("kt18689.kt")
      public void testKt18689() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689.kt");
      }

      @Test
      @TestMetadata("kt18689_2.kt")
      public void testKt18689_2() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_2.kt");
      }

      @Test
      @TestMetadata("kt18689_3.kt")
      public void testKt18689_3() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_3.kt");
      }

      @Test
      @TestMetadata("kt18689_4.kt")
      public void testKt18689_4() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_4.kt");
      }

      @Test
      @TestMetadata("kt5685.kt")
      public void testKt5685() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/kt5685.kt");
      }

      @Test
      @TestMetadata("simpleDefaultMethod.kt")
      public void testSimpleDefaultMethod() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/simpleDefaultMethod.kt");
      }

      @Test
      @TestMetadata("varArgNoInline.kt")
      public void testVarArgNoInline() {
        runTest("compiler/testData/codegen/boxInline/defaultValues/varArgNoInline.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining")
      @TestDataPath("$PROJECT_ROOT")
      public class LambdaInlining {
        @Test
        public void testAllFilesPresentInLambdaInlining() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("checkLambdaClassIsPresent.kt")
        public void testCheckLambdaClassIsPresent() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassIsPresent.kt");
        }

        @Test
        @TestMetadata("checkLambdaClassesArePresent.kt")
        public void testCheckLambdaClassesArePresent() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassesArePresent.kt");
        }

        @Test
        @TestMetadata("checkObjectClassIsPresent.kt")
        public void testCheckObjectClassIsPresent() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkObjectClassIsPresent.kt");
        }

        @Test
        @TestMetadata("checkStaticLambdaClassIsPresent.kt")
        public void testCheckStaticLambdaClassIsPresent() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassIsPresent.kt");
        }

        @Test
        @TestMetadata("checkStaticLambdaClassesArePresent.kt")
        public void testCheckStaticLambdaClassesArePresent() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassesArePresent.kt");
        }

        @Test
        @TestMetadata("checkStaticObjectClassIsPresent.kt")
        public void testCheckStaticObjectClassIsPresent() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticObjectClassIsPresent.kt");
        }

        @Test
        @TestMetadata("defaultAfterCapturing.kt")
        public void testDefaultAfterCapturing() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultAfterCapturing.kt");
        }

        @Test
        @TestMetadata("defaultCallInDefaultLambda.kt")
        public void testDefaultCallInDefaultLambda() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultCallInDefaultLambda.kt");
        }

        @Test
        @TestMetadata("defaultLambdaInNoInline.kt")
        public void testDefaultLambdaInNoInline() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultLambdaInNoInline.kt");
        }

        @Test
        @TestMetadata("differentInvokeSignature.kt")
        public void testDifferentInvokeSignature() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/differentInvokeSignature.kt");
        }

        @Test
        @TestMetadata("genericLambda.kt")
        public void testGenericLambda() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/genericLambda.kt");
        }

        @Test
        @TestMetadata("instanceCapturedInClass.kt")
        public void testInstanceCapturedInClass() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInClass.kt");
        }

        @Test
        @TestMetadata("instanceCapturedInInterface.kt")
        public void testInstanceCapturedInInterface() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInInterface.kt");
        }

        @Test
        @TestMetadata("jvmStaticDefault.kt")
        public void testJvmStaticDefault() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/jvmStaticDefault.kt");
        }

        @Test
        @TestMetadata("kt21827.kt")
        public void testKt21827() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21827.kt");
        }

        @Test
        @TestMetadata("kt21946.kt")
        public void testKt21946() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21946.kt");
        }

        @Test
        @TestMetadata("kt24477.kt")
        public void testKt24477() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt24477.kt");
        }

        @Test
        @TestMetadata("kt25106.kt")
        public void testKt25106() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt25106.kt");
        }

        @Test
        @TestMetadata("kt26636.kt")
        public void testKt26636() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt26636.kt");
        }

        @Test
        @TestMetadata("lambdaTakesResult.kt")
        public void testLambdaTakesResult() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/lambdaTakesResult.kt");
        }

        @Test
        @TestMetadata("noInline.kt")
        public void testNoInline() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/noInline.kt");
        }

        @Test
        @TestMetadata("nonDefaultInlineInNoInline.kt")
        public void testNonDefaultInlineInNoInline() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/nonDefaultInlineInNoInline.kt");
        }

        @Test
        @TestMetadata("receiverClash.kt")
        public void testReceiverClash() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash.kt");
        }

        @Test
        @TestMetadata("receiverClash2.kt")
        public void testReceiverClash2() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash2.kt");
        }

        @Test
        @TestMetadata("receiverClashInClass.kt")
        public void testReceiverClashInClass() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass.kt");
        }

        @Test
        @TestMetadata("receiverClashInClass2.kt")
        public void testReceiverClashInClass2() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass2.kt");
        }

        @Test
        @TestMetadata("reordering.kt")
        public void testReordering() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/reordering.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simple.kt");
        }

        @Test
        @TestMetadata("simpleErased.kt")
        public void testSimpleErased() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErased.kt");
        }

        @Test
        @TestMetadata("simpleErasedStaticInstance.kt")
        public void testSimpleErasedStaticInstance() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErasedStaticInstance.kt");
        }

        @Test
        @TestMetadata("simpleExtension.kt")
        public void testSimpleExtension() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleExtension.kt");
        }

        @Test
        @TestMetadata("simpleGeneric.kt")
        public void testSimpleGeneric() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleGeneric.kt");
        }

        @Test
        @TestMetadata("simpleStaticInstance.kt")
        public void testSimpleStaticInstance() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleStaticInstance.kt");
        }

        @Test
        @TestMetadata("thisClash.kt")
        public void testThisClash() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClash.kt");
        }

        @Test
        @TestMetadata("thisClashInClass.kt")
        public void testThisClashInClass() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClashInClass.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences")
        @TestDataPath("$PROJECT_ROOT")
        public class CallableReferences {
          @Test
          public void testAllFilesPresentInCallableReferences() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("boundFunctionReference.kt")
          public void testBoundFunctionReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReference.kt");
          }

          @Test
          @TestMetadata("boundFunctionReferenceOnInt.kt")
          public void testBoundFunctionReferenceOnInt() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnInt.kt");
          }

          @Test
          @TestMetadata("boundFunctionReferenceOnLong.kt")
          public void testBoundFunctionReferenceOnLong() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnLong.kt");
          }

          @Test
          @TestMetadata("boundInlineClassMethod.kt")
          public void testBoundInlineClassMethod() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethod.kt");
          }

          @Test
          @TestMetadata("boundInlineClassMethodWithAny.kt")
          public void testBoundInlineClassMethodWithAny() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithAny.kt");
          }

          @Test
          @TestMetadata("boundInlineClassMethodWithInt.kt")
          public void testBoundInlineClassMethodWithInt() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithInt.kt");
          }

          @Test
          @TestMetadata("boundPropertyReference.kt")
          public void testBoundPropertyReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReference.kt");
          }

          @Test
          @TestMetadata("boundPropertyReferenceOnInt.kt")
          public void testBoundPropertyReferenceOnInt() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnInt.kt");
          }

          @Test
          @TestMetadata("boundPropertyReferenceOnLong.kt")
          public void testBoundPropertyReferenceOnLong() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnLong.kt");
          }

          @Test
          @TestMetadata("constuctorReference.kt")
          public void testConstuctorReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/constuctorReference.kt");
          }

          @Test
          @TestMetadata("defaultAfterBoundReference.kt")
          public void testDefaultAfterBoundReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/defaultAfterBoundReference.kt");
          }

          @Test
          @TestMetadata("defaultThatCapturesPreviousParameter.kt")
          public void testDefaultThatCapturesPreviousParameter() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/defaultThatCapturesPreviousParameter.kt");
          }

          @Test
          @TestMetadata("differentInvokeSignature.kt")
          public void testDifferentInvokeSignature() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature.kt");
          }

          @Test
          @TestMetadata("differentInvokeSignature2.kt")
          public void testDifferentInvokeSignature2() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature2.kt");
          }

          @Test
          @TestMetadata("differentInvokeSignature3.kt")
          public void testDifferentInvokeSignature3() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature3.kt");
          }

          @Test
          @TestMetadata("functionImportedFromObject.kt")
          public void testFunctionImportedFromObject() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionImportedFromObject.kt");
          }

          @Test
          @TestMetadata("functionReference.kt")
          public void testFunctionReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReference.kt");
          }

          @Test
          @TestMetadata("functionReferenceFromClass.kt")
          public void testFunctionReferenceFromClass() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromClass.kt");
          }

          @Test
          @TestMetadata("functionReferenceFromObject.kt")
          public void testFunctionReferenceFromObject() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromObject.kt");
          }

          @Test
          @TestMetadata("innerClassConstuctorReference.kt")
          public void testInnerClassConstuctorReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/innerClassConstuctorReference.kt");
          }

          @Test
          @TestMetadata("mutableBoundPropertyReferenceFromClass.kt")
          public void testMutableBoundPropertyReferenceFromClass() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutableBoundPropertyReferenceFromClass.kt");
          }

          @Test
          @TestMetadata("mutablePropertyReferenceFromClass.kt")
          public void testMutablePropertyReferenceFromClass() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutablePropertyReferenceFromClass.kt");
          }

          @Test
          @TestMetadata("privateFunctionReference.kt")
          public void testPrivateFunctionReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privateFunctionReference.kt");
          }

          @Test
          @TestMetadata("privatePropertyReference.kt")
          public void testPrivatePropertyReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privatePropertyReference.kt");
          }

          @Test
          @TestMetadata("propertyImportedFromObject.kt")
          public void testPropertyImportedFromObject() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyImportedFromObject.kt");
          }

          @Test
          @TestMetadata("propertyReference.kt")
          public void testPropertyReference() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReference.kt");
          }

          @Test
          @TestMetadata("propertyReferenceFromClass.kt")
          public void testPropertyReferenceFromClass() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromClass.kt");
          }

          @Test
          @TestMetadata("propertyReferenceFromObject.kt")
          public void testPropertyReferenceFromObject() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromObject.kt");
          }

          @Test
          @TestMetadata("withInlineClassParameter.kt")
          public void testWithInlineClassParameter() {
            runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/withInlineClassParameter.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/defaultValues/maskElimination")
      @TestDataPath("$PROJECT_ROOT")
      public class MaskElimination {
        @Test
        @TestMetadata("32Parameters.kt")
        public void test32Parameters() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/32Parameters.kt");
        }

        @Test
        @TestMetadata("33Parameters.kt")
        public void test33Parameters() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/33Parameters.kt");
        }

        @Test
        public void testAllFilesPresentInMaskElimination() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/maskElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt18792.kt")
        public void testKt18792() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt18792.kt");
        }

        @Test
        @TestMetadata("kt19679.kt")
        public void testKt19679() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679.kt");
        }

        @Test
        @TestMetadata("kt19679_2.kt")
        public void testKt19679_2() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_2.kt");
        }

        @Test
        @TestMetadata("kt19679_3.kt")
        public void testKt19679_3() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_3.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/simple.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegatedProperty {
      @Test
      public void testAllFilesPresentInDelegatedProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt16864.kt")
      public void testKt16864() {
        runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt16864.kt");
      }

      @Test
      @TestMetadata("kt48498.kt")
      public void testKt48498() {
        runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt48498.kt");
      }

      @Test
      @TestMetadata("local.kt")
      public void testLocal() {
        runTest("compiler/testData/codegen/boxInline/delegatedProperty/local.kt");
      }

      @Test
      @TestMetadata("localDeclaredInLambda.kt")
      public void testLocalDeclaredInLambda() {
        runTest("compiler/testData/codegen/boxInline/delegatedProperty/localDeclaredInLambda.kt");
      }

      @Test
      @TestMetadata("localInAnonymousObject.kt")
      public void testLocalInAnonymousObject() {
        runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInAnonymousObject.kt");
      }

      @Test
      @TestMetadata("localInLambda.kt")
      public void testLocalInLambda() {
        runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInLambda.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/dontReify")
    @TestDataPath("$PROJECT_ROOT")
    public class DontReify {
      @Test
      public void testAllFilesPresentInDontReify() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/dontReify"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayRead.kt")
      public void testArrayRead() {
        runTest("compiler/testData/codegen/boxInline/dontReify/arrayRead.kt");
      }

      @Test
      @TestMetadata("arrayWrite.kt")
      public void testArrayWrite() {
        runTest("compiler/testData/codegen/boxInline/dontReify/arrayWrite.kt");
      }

      @Test
      @TestMetadata("dispatchReceiver.kt")
      public void testDispatchReceiver() {
        runTest("compiler/testData/codegen/boxInline/dontReify/dispatchReceiver.kt");
      }

      @Test
      @TestMetadata("extensionReceiver.kt")
      public void testExtensionReceiver() {
        runTest("compiler/testData/codegen/boxInline/dontReify/extensionReceiver.kt");
      }

      @Test
      @TestMetadata("lambdaParameter.kt")
      public void testLambdaParameter() {
        runTest("compiler/testData/codegen/boxInline/dontReify/lambdaParameter.kt");
      }

      @Test
      @TestMetadata("localDelegatedProperty.kt")
      public void testLocalDelegatedProperty() {
        runTest("compiler/testData/codegen/boxInline/dontReify/localDelegatedProperty.kt");
      }

      @Test
      @TestMetadata("localObjectProperty.kt")
      public void testLocalObjectProperty() {
        runTest("compiler/testData/codegen/boxInline/dontReify/localObjectProperty.kt");
      }

      @Test
      @TestMetadata("localVariable.kt")
      public void testLocalVariable() {
        runTest("compiler/testData/codegen/boxInline/dontReify/localVariable.kt");
      }

      @Test
      @TestMetadata("methodReturnType.kt")
      public void testMethodReturnType() {
        runTest("compiler/testData/codegen/boxInline/dontReify/methodReturnType.kt");
      }

      @Test
      @TestMetadata("parameterInLocalObject.kt")
      public void testParameterInLocalObject() {
        runTest("compiler/testData/codegen/boxInline/dontReify/parameterInLocalObject.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/enclosingInfo")
    @TestDataPath("$PROJECT_ROOT")
    public class EnclosingInfo {
      @Test
      public void testAllFilesPresentInEnclosingInfo() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("anonymousInLambda.kt")
      public void testAnonymousInLambda() {
        runTest("compiler/testData/codegen/boxInline/enclosingInfo/anonymousInLambda.kt");
      }

      @Test
      @TestMetadata("inlineChain.kt")
      public void testInlineChain() {
        runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain.kt");
      }

      @Test
      @TestMetadata("inlineChain2.kt")
      public void testInlineChain2() {
        runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain2.kt");
      }

      @Test
      @TestMetadata("kt52417.kt")
      public void testKt52417() {
        runTest("compiler/testData/codegen/boxInline/enclosingInfo/kt52417.kt");
      }

      @Test
      @TestMetadata("objectInInlineFun.kt")
      public void testObjectInInlineFun() {
        runTest("compiler/testData/codegen/boxInline/enclosingInfo/objectInInlineFun.kt");
      }

      @Test
      @TestMetadata("transformedConstructor.kt")
      public void testTransformedConstructor() {
        runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructor.kt");
      }

      @Test
      @TestMetadata("transformedConstructorWithAdditionalObject.kt")
      public void testTransformedConstructorWithAdditionalObject() {
        runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithAdditionalObject.kt");
      }

      @Test
      @TestMetadata("transformedConstructorWithNestedInline.kt")
      public void testTransformedConstructorWithNestedInline() {
        runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithNestedInline.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/enum")
    @TestDataPath("$PROJECT_ROOT")
    public class Enum {
      @Test
      public void testAllFilesPresentInEnum() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("enumEntries.kt")
      public void testEnumEntries() {
        runTest("compiler/testData/codegen/boxInline/enum/enumEntries.kt");
      }

      @Test
      @TestMetadata("enumEntriesChainCapturedType.kt")
      public void testEnumEntriesChainCapturedType() {
        runTest("compiler/testData/codegen/boxInline/enum/enumEntriesChainCapturedType.kt");
      }

      @Test
      @TestMetadata("javaEnumEntries.kt")
      public void testJavaEnumEntries() {
        runTest("compiler/testData/codegen/boxInline/enum/javaEnumEntries.kt");
      }

      @Test
      @TestMetadata("javaEnumEntriesChainCapturedType.kt")
      public void testJavaEnumEntriesChainCapturedType() {
        runTest("compiler/testData/codegen/boxInline/enum/javaEnumEntriesChainCapturedType.kt");
      }

      @Test
      @TestMetadata("kt10569.kt")
      public void testKt10569() {
        runTest("compiler/testData/codegen/boxInline/enum/kt10569.kt");
      }

      @Test
      @TestMetadata("kt18254.kt")
      public void testKt18254() {
        runTest("compiler/testData/codegen/boxInline/enum/kt18254.kt");
      }

      @Test
      @TestMetadata("valueOf.kt")
      public void testValueOf() {
        runTest("compiler/testData/codegen/boxInline/enum/valueOf.kt");
      }

      @Test
      @TestMetadata("valueOfCapturedType.kt")
      public void testValueOfCapturedType() {
        runTest("compiler/testData/codegen/boxInline/enum/valueOfCapturedType.kt");
      }

      @Test
      @TestMetadata("valueOfChain.kt")
      public void testValueOfChain() {
        runTest("compiler/testData/codegen/boxInline/enum/valueOfChain.kt");
      }

      @Test
      @TestMetadata("valueOfChainCapturedType.kt")
      public void testValueOfChainCapturedType() {
        runTest("compiler/testData/codegen/boxInline/enum/valueOfChainCapturedType.kt");
      }

      @Test
      @TestMetadata("valueOfNonReified.kt")
      public void testValueOfNonReified() {
        runTest("compiler/testData/codegen/boxInline/enum/valueOfNonReified.kt");
      }

      @Test
      @TestMetadata("values.kt")
      public void testValues() {
        runTest("compiler/testData/codegen/boxInline/enum/values.kt");
      }

      @Test
      @TestMetadata("valuesAsArray.kt")
      public void testValuesAsArray() {
        runTest("compiler/testData/codegen/boxInline/enum/valuesAsArray.kt");
      }

      @Test
      @TestMetadata("valuesCapturedType.kt")
      public void testValuesCapturedType() {
        runTest("compiler/testData/codegen/boxInline/enum/valuesCapturedType.kt");
      }

      @Test
      @TestMetadata("valuesChain.kt")
      public void testValuesChain() {
        runTest("compiler/testData/codegen/boxInline/enum/valuesChain.kt");
      }

      @Test
      @TestMetadata("valuesChainCapturedType.kt")
      public void testValuesChainCapturedType() {
        runTest("compiler/testData/codegen/boxInline/enum/valuesChainCapturedType.kt");
      }

      @Test
      @TestMetadata("valuesNonReified.kt")
      public void testValuesNonReified() {
        runTest("compiler/testData/codegen/boxInline/enum/valuesNonReified.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/functionExpression")
    @TestDataPath("$PROJECT_ROOT")
    public class FunctionExpression {
      @Test
      public void testAllFilesPresentInFunctionExpression() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("extension.kt")
      public void testExtension() {
        runTest("compiler/testData/codegen/boxInline/functionExpression/extension.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/inlineArgsInplace")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineArgsInplace {
      @Test
      public void testAllFilesPresentInInlineArgsInplace() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineArgsInplace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("callArgumentReordering.kt")
      public void testCallArgumentReordering() {
        runTest("compiler/testData/codegen/boxInline/inlineArgsInplace/callArgumentReordering.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
      @Test
      public void testAllFilesPresentInInlineClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("anonymousObject.kt")
      public void testAnonymousObject() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/anonymousObject.kt");
      }

      @Test
      @TestMetadata("inlineClassWithInlineValReturningInlineClass.kt")
      public void testInlineClassWithInlineValReturningInlineClass() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineClassWithInlineValReturningInlineClass.kt");
      }

      @Test
      @TestMetadata("inlineFunctionInsideInlineClassesBox.kt")
      public void testInlineFunctionInsideInlineClassesBox() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineFunctionInsideInlineClassesBox.kt");
      }

      @Test
      @TestMetadata("kt62313.kt")
      public void testKt62313() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/kt62313.kt");
      }

      @Test
      @TestMetadata("noReturnTypeManglingFun.kt")
      public void testNoReturnTypeManglingFun() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFun.kt");
      }

      @Test
      @TestMetadata("noReturnTypeManglingFunJvmName.kt")
      public void testNoReturnTypeManglingFunJvmName() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFunJvmName.kt");
      }

      @Test
      @TestMetadata("noReturnTypeManglingVal.kt")
      public void testNoReturnTypeManglingVal() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingVal.kt");
      }

      @Test
      @TestMetadata("withReturnTypeManglingFun.kt")
      public void testWithReturnTypeManglingFun() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFun.kt");
      }

      @Test
      @TestMetadata("withReturnTypeManglingFunJvmName.kt")
      public void testWithReturnTypeManglingFunJvmName() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFunJvmName.kt");
      }

      @Test
      @TestMetadata("withReturnTypeManglingVal.kt")
      public void testWithReturnTypeManglingVal() {
        runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingVal.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter")
      @TestDataPath("$PROJECT_ROOT")
      public class UnboxGenericParameter {
        @Test
        public void testAllFilesPresentInUnboxGenericParameter() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface")
        @TestDataPath("$PROJECT_ROOT")
        public class FunInterface {
          @Test
          public void testAllFilesPresentInFunInterface() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("any.kt")
          public void testAny() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/any.kt");
          }

          @Test
          @TestMetadata("anyN.kt")
          public void testAnyN() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/anyN.kt");
          }

          @Test
          @TestMetadata("iface.kt")
          public void testIface() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/iface.kt");
          }

          @Test
          @TestMetadata("ifaceChild.kt")
          public void testIfaceChild() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/ifaceChild.kt");
          }

          @Test
          @TestMetadata("primitive.kt")
          public void testPrimitive() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/primitive.kt");
          }

          @Test
          @TestMetadata("string.kt")
          public void testString() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/string.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda")
        @TestDataPath("$PROJECT_ROOT")
        public class Lambda {
          @Test
          public void testAllFilesPresentInLambda() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("any.kt")
          public void testAny() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/any.kt");
          }

          @Test
          @TestMetadata("anyN.kt")
          public void testAnyN() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/anyN.kt");
          }

          @Test
          @TestMetadata("iface.kt")
          public void testIface() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/iface.kt");
          }

          @Test
          @TestMetadata("ifaceChild.kt")
          public void testIfaceChild() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/ifaceChild.kt");
          }

          @Test
          @TestMetadata("primitive.kt")
          public void testPrimitive() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/primitive.kt");
          }

          @Test
          @TestMetadata("string.kt")
          public void testString() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/string.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral")
        @TestDataPath("$PROJECT_ROOT")
        public class ObjectLiteral {
          @Test
          public void testAllFilesPresentInObjectLiteral() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("any.kt")
          public void testAny() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/any.kt");
          }

          @Test
          @TestMetadata("anyN.kt")
          public void testAnyN() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/anyN.kt");
          }

          @Test
          @TestMetadata("iface.kt")
          public void testIface() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/iface.kt");
          }

          @Test
          @TestMetadata("ifaceChild.kt")
          public void testIfaceChild() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/ifaceChild.kt");
          }

          @Test
          @TestMetadata("primitive.kt")
          public void testPrimitive() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/primitive.kt");
          }

          @Test
          @TestMetadata("string.kt")
          public void testString() {
            runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/string.kt");
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/innerClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InnerClasses {
      @Test
      public void testAllFilesPresentInInnerClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("captureThisAndOuter.kt")
      public void testCaptureThisAndOuter() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/captureThisAndOuter.kt");
      }

      @Test
      @TestMetadata("fakeOverride.kt")
      public void testFakeOverride() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/fakeOverride.kt");
      }

      @Test
      @TestMetadata("innerInlineFunCapturesOuter.kt")
      public void testInnerInlineFunCapturesOuter() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuter.kt");
      }

      @Test
      @TestMetadata("innerInlineFunCapturesOuterByAnotherInlineFun.kt")
      public void testInnerInlineFunCapturesOuterByAnotherInlineFun() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterByAnotherInlineFun.kt");
      }

      @Test
      @TestMetadata("innerInlineFunCapturesOuterDeep.kt")
      public void testInnerInlineFunCapturesOuterDeep() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterDeep.kt");
      }

      @Test
      @TestMetadata("innerInlineFunCapturesOuterFunRef.kt")
      public void testInnerInlineFunCapturesOuterFunRef() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterFunRef.kt");
      }

      @Test
      @TestMetadata("innerInlineFunCapturesOuterWithInlineClass.kt")
      public void testInnerInlineFunCapturesOuterWithInlineClass() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterWithInlineClass.kt");
      }

      @Test
      @TestMetadata("innerLambda.kt")
      public void testInnerLambda() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/innerLambda.kt");
      }

      @Test
      @TestMetadata("kt10259.kt")
      public void testKt10259() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/kt10259.kt");
      }

      @Test
      @TestMetadata("kt12126.kt")
      public void testKt12126() {
        runTest("compiler/testData/codegen/boxInline/innerClasses/kt12126.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic")
    @TestDataPath("$PROJECT_ROOT")
    public class Invokedynamic {
      @Test
      public void testAllFilesPresentInInvokedynamic() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic/lambdas")
      @TestDataPath("$PROJECT_ROOT")
      public class Lambdas {
        @Test
        public void testAllFilesPresentInLambdas() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("crossinlineLambda1.kt")
        public void testCrossinlineLambda1() {
          runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda1.kt");
        }

        @Test
        @TestMetadata("crossinlineLambda2.kt")
        public void testCrossinlineLambda2() {
          runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda2.kt");
        }

        @Test
        @TestMetadata("inlineFunInDifferentPackage.kt")
        public void testInlineFunInDifferentPackage() {
          runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineFunInDifferentPackage.kt");
        }

        @Test
        @TestMetadata("inlineLambda1.kt")
        public void testInlineLambda1() {
          runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineLambda1.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/invokedynamic/sam")
      @TestDataPath("$PROJECT_ROOT")
      public class Sam {
        @Test
        public void testAllFilesPresentInSam() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("crossinlineLambda1.kt")
        public void testCrossinlineLambda1() {
          runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda1.kt");
        }

        @Test
        @TestMetadata("crossinlineLambda2.kt")
        public void testCrossinlineLambda2() {
          runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda2.kt");
        }

        @Test
        @TestMetadata("inlineFunInDifferentPackage.kt")
        public void testInlineFunInDifferentPackage() {
          runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineFunInDifferentPackage.kt");
        }

        @Test
        @TestMetadata("inlineLambda1.kt")
        public void testInlineLambda1() {
          runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineLambda1.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/jvmName")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmName {
      @Test
      public void testAllFilesPresentInJvmName() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/boxInline/jvmName/simple.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/jvmPackageName")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmPackageName {
      @Test
      public void testAllFilesPresentInJvmPackageName() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmPackageName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/boxInline/jvmPackageName/simple.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/lambdaClassClash")
    @TestDataPath("$PROJECT_ROOT")
    public class LambdaClassClash {
      @Test
      public void testAllFilesPresentInLambdaClassClash() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaClassClash"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("lambdaClassClash.kt")
      public void testLambdaClassClash() {
        runTest("compiler/testData/codegen/boxInline/lambdaClassClash/lambdaClassClash.kt");
      }

      @Test
      @TestMetadata("noInlineLambdaX2.kt")
      public void testNoInlineLambdaX2() {
        runTest("compiler/testData/codegen/boxInline/lambdaClassClash/noInlineLambdaX2.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/lambdaTransformation")
    @TestDataPath("$PROJECT_ROOT")
    public class LambdaTransformation {
      @Test
      public void testAllFilesPresentInLambdaTransformation() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaTransformation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("lambdaCloning.kt")
      public void testLambdaCloning() {
        runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaCloning.kt");
      }

      @Test
      @TestMetadata("lambdaInLambda2.kt")
      public void testLambdaInLambda2() {
        runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambda2.kt");
      }

      @Test
      @TestMetadata("lambdaInLambdaNoInline.kt")
      public void testLambdaInLambdaNoInline() {
        runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambdaNoInline.kt");
      }

      @Test
      @TestMetadata("regeneratedLambdaName.kt")
      public void testRegeneratedLambdaName() {
        runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName.kt");
      }

      @Test
      @TestMetadata("regeneratedLambdaName2.kt")
      public void testRegeneratedLambdaName2() {
        runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName2.kt");
      }

      @Test
      @TestMetadata("sameCaptured.kt")
      public void testSameCaptured() {
        runTest("compiler/testData/codegen/boxInline/lambdaTransformation/sameCaptured.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/localFunInLambda")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalFunInLambda {
      @Test
      public void testAllFilesPresentInLocalFunInLambda() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/localFunInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("defaultParam.kt")
      public void testDefaultParam() {
        runTest("compiler/testData/codegen/boxInline/localFunInLambda/defaultParam.kt");
      }

      @Test
      @TestMetadata("lambdaInLambdaCapturesAnotherFun.kt")
      public void testLambdaInLambdaCapturesAnotherFun() {
        runTest("compiler/testData/codegen/boxInline/localFunInLambda/lambdaInLambdaCapturesAnotherFun.kt");
      }

      @Test
      @TestMetadata("localFunInLambda.kt")
      public void testLocalFunInLambda() {
        runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambda.kt");
      }

      @Test
      @TestMetadata("localFunInLambdaCapturesAnotherFun.kt")
      public void testLocalFunInLambdaCapturesAnotherFun() {
        runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambdaCapturesAnotherFun.kt");
      }

      @Test
      @TestMetadata("localFunInLambdaCapturesOuterVariable.kt")
      public void testLocalFunInLambdaCapturesOuterVariable() {
        runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambdaCapturesOuterVariable.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/multiModule")
    @TestDataPath("$PROJECT_ROOT")
    public class MultiModule {
      @Test
      public void testAllFilesPresentInMultiModule() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("tryCatchWithRecursiveInline.kt")
      public void testTryCatchWithRecursiveInline() {
        runTest("compiler/testData/codegen/boxInline/multiModule/tryCatchWithRecursiveInline.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class MultifileClasses {
      @Test
      public void testAllFilesPresentInMultifileClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("defaultArguments.kt")
      public void testDefaultArguments() {
        runTest("compiler/testData/codegen/boxInline/multifileClasses/defaultArguments.kt");
      }

      @Test
      @TestMetadata("inlineFromOptimizedMultifileClass.kt")
      public void testInlineFromOptimizedMultifileClass() {
        runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOptimizedMultifileClass.kt");
      }

      @Test
      @TestMetadata("inlineFromOtherPackage.kt")
      public void testInlineFromOtherPackage() {
        runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOtherPackage.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/multiplatform")
    @TestDataPath("$PROJECT_ROOT")
    public class Multiplatform {
      @Test
      public void testAllFilesPresentInMultiplatform() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/multiplatform/defaultArguments")
      @TestDataPath("$PROJECT_ROOT")
      public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("receiversAndParametersInLambda.kt")
        public void testReceiversAndParametersInLambda() {
          runTest("compiler/testData/codegen/boxInline/multiplatform/defaultArguments/receiversAndParametersInLambda.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/noInline")
    @TestDataPath("$PROJECT_ROOT")
    public class NoInline {
      @Test
      public void testAllFilesPresentInNoInline() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/noInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("extensionReceiver.kt")
      public void testExtensionReceiver() {
        runTest("compiler/testData/codegen/boxInline/noInline/extensionReceiver.kt");
      }

      @Test
      @TestMetadata("lambdaAsGeneric.kt")
      public void testLambdaAsGeneric() {
        runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsGeneric.kt");
      }

      @Test
      @TestMetadata("lambdaAsNonFunction.kt")
      public void testLambdaAsNonFunction() {
        runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsNonFunction.kt");
      }

      @Test
      @TestMetadata("noInline.kt")
      public void testNoInline() {
        runTest("compiler/testData/codegen/boxInline/noInline/noInline.kt");
      }

      @Test
      @TestMetadata("noInlineLambdaChain.kt")
      public void testNoInlineLambdaChain() {
        runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChain.kt");
      }

      @Test
      @TestMetadata("noInlineLambdaChainWithCapturedInline.kt")
      public void testNoInlineLambdaChainWithCapturedInline() {
        runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChainWithCapturedInline.kt");
      }

      @Test
      @TestMetadata("withoutInline.kt")
      public void testWithoutInline() {
        runTest("compiler/testData/codegen/boxInline/noInline/withoutInline.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns")
    @TestDataPath("$PROJECT_ROOT")
    public class NonLocalReturns {
      @Test
      public void testAllFilesPresentInNonLocalReturns() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("explicitLocalReturn.kt")
      public void testExplicitLocalReturn() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/explicitLocalReturn.kt");
      }

      @Test
      @TestMetadata("fromArrayGenerator.kt")
      public void testFromArrayGenerator() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGenerator.kt");
      }

      @Test
      @TestMetadata("fromArrayGeneratorCatch.kt")
      public void testFromArrayGeneratorCatch() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorCatch.kt");
      }

      @Test
      @TestMetadata("fromArrayGeneratorNested.kt")
      public void testFromArrayGeneratorNested() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorNested.kt");
      }

      @Test
      @TestMetadata("fromArrayGeneratorWithCapture.kt")
      public void testFromArrayGeneratorWithCapture() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCapture.kt");
      }

      @Test
      @TestMetadata("fromArrayGeneratorWithCatch.kt")
      public void testFromArrayGeneratorWithCatch() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCatch.kt");
      }

      @Test
      @TestMetadata("fromArrayGeneratorWithFinally.kt")
      public void testFromArrayGeneratorWithFinally() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinally.kt");
      }

      @Test
      @TestMetadata("fromArrayGeneratorWithFinallyX2.kt")
      public void testFromArrayGeneratorWithFinallyX2() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2.kt");
      }

      @Test
      @TestMetadata("fromArrayGeneratorWithFinallyX2_2.kt")
      public void testFromArrayGeneratorWithFinallyX2_2() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2_2.kt");
      }

      @Test
      @TestMetadata("fromInterfaceDefaultGetter.kt")
      public void testFromInterfaceDefaultGetter() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromInterfaceDefaultGetter.kt");
      }

      @Test
      @TestMetadata("justReturnInLambda.kt")
      public void testJustReturnInLambda() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/justReturnInLambda.kt");
      }

      @Test
      @TestMetadata("kt5199.kt")
      public void testKt5199() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt5199.kt");
      }

      @Test
      @TestMetadata("kt8948.kt")
      public void testKt8948() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948.kt");
      }

      @Test
      @TestMetadata("kt8948v2.kt")
      public void testKt8948v2() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948v2.kt");
      }

      @Test
      @TestMetadata("kt9304.kt")
      public void testKt9304() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt9304.kt");
      }

      @Test
      @TestMetadata("nestedNonLocals.kt")
      public void testNestedNonLocals() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nestedNonLocals.kt");
      }

      @Test
      @TestMetadata("noInlineLocalReturn.kt")
      public void testNoInlineLocalReturn() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/noInlineLocalReturn.kt");
      }

      @Test
      @TestMetadata("nonLocalReturnFromOuterLambda.kt")
      public void testNonLocalReturnFromOuterLambda() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nonLocalReturnFromOuterLambda.kt");
      }

      @Test
      @TestMetadata("propertyAccessors.kt")
      public void testPropertyAccessors() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/propertyAccessors.kt");
      }

      @Test
      @TestMetadata("returnFromFunctionExpr.kt")
      public void testReturnFromFunctionExpr() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/returnFromFunctionExpr.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simple.kt");
      }

      @Test
      @TestMetadata("simpleFunctional.kt")
      public void testSimpleFunctional() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleFunctional.kt");
      }

      @Test
      @TestMetadata("simpleVoid.kt")
      public void testSimpleVoid() {
        runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleVoid.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize")
      @TestDataPath("$PROJECT_ROOT")
      public class Deparenthesize {
        @Test
        public void testAllFilesPresentInDeparenthesize() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("bracket.kt")
        public void testBracket() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/bracket.kt");
        }

        @Test
        @TestMetadata("labeled.kt")
        public void testLabeled() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/labeled.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally")
      @TestDataPath("$PROJECT_ROOT")
      public class TryFinally {
        @Test
        public void testAllFilesPresentInTryFinally() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt16417.kt")
        public void testKt16417() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt16417.kt");
        }

        @Test
        @TestMetadata("kt20433.kt")
        public void testKt20433() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433.kt");
        }

        @Test
        @TestMetadata("kt20433_2.kt")
        public void testKt20433_2() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2.kt");
        }

        @Test
        @TestMetadata("kt20433_2_void.kt")
        public void testKt20433_2_void() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2_void.kt");
        }

        @Test
        @TestMetadata("kt20433_void.kt")
        public void testKt20433_void() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_void.kt");
        }

        @Test
        @TestMetadata("kt26384.kt")
        public void testKt26384() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384.kt");
        }

        @Test
        @TestMetadata("kt26384_2.kt")
        public void testKt26384_2() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384_2.kt");
        }

        @Test
        @TestMetadata("kt28546.kt")
        public void testKt28546() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt28546.kt");
        }

        @Test
        @TestMetadata("kt6956.kt")
        public void testKt6956() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt6956.kt");
        }

        @Test
        @TestMetadata("kt7273.kt")
        public void testKt7273() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt7273.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnFromCatchBlock.kt")
        public void testNonLocalReturnFromCatchBlock() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromCatchBlock.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnFromOuterLambda.kt")
        public void testNonLocalReturnFromOuterLambda() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromOuterLambda.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnToCatchBlock.kt")
        public void testNonLocalReturnToCatchBlock() {
          runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnToCatchBlock.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite")
        @TestDataPath("$PROJECT_ROOT")
        public class CallSite {
          @Test
          public void testAllFilesPresentInCallSite() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("callSite.kt")
          public void testCallSite() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSite.kt");
          }

          @Test
          @TestMetadata("callSiteComplex.kt")
          public void testCallSiteComplex() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSiteComplex.kt");
          }

          @Test
          @TestMetadata("exceptionTableSplit.kt")
          public void testExceptionTableSplit() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplit.kt");
          }

          @Test
          @TestMetadata("exceptionTableSplitNoReturn.kt")
          public void testExceptionTableSplitNoReturn() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplitNoReturn.kt");
          }

          @Test
          @TestMetadata("finallyInFinally.kt")
          public void testFinallyInFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/finallyInFinally.kt");
          }

          @Test
          @TestMetadata("wrongVarInterval.kt")
          public void testWrongVarInterval() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/wrongVarInterval.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained")
        @TestDataPath("$PROJECT_ROOT")
        public class Chained {
          @Test
          public void testAllFilesPresentInChained() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("finallyInFinally.kt")
          public void testFinallyInFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally.kt");
          }

          @Test
          @TestMetadata("finallyInFinally2.kt")
          public void testFinallyInFinally2() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally2.kt");
          }

          @Test
          @TestMetadata("intReturn.kt")
          public void testIntReturn() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturn.kt");
          }

          @Test
          @TestMetadata("intReturnComplex.kt")
          public void testIntReturnComplex() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex.kt");
          }

          @Test
          @TestMetadata("intReturnComplex2.kt")
          public void testIntReturnComplex2() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex2.kt");
          }

          @Test
          @TestMetadata("intReturnComplex3.kt")
          public void testIntReturnComplex3() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex3.kt");
          }

          @Test
          @TestMetadata("intReturnComplex4.kt")
          public void testIntReturnComplex4() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex4.kt");
          }

          @Test
          @TestMetadata("nestedLambda.kt")
          public void testNestedLambda() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/nestedLambda.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite")
        @TestDataPath("$PROJECT_ROOT")
        public class DeclSite {
          @Test
          public void testAllFilesPresentInDeclSite() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("complex.kt")
          public void testComplex() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/complex.kt");
          }

          @Test
          @TestMetadata("intReturn.kt")
          public void testIntReturn() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturn.kt");
          }

          @Test
          @TestMetadata("intReturnComplex.kt")
          public void testIntReturnComplex() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturnComplex.kt");
          }

          @Test
          @TestMetadata("longReturn.kt")
          public void testLongReturn() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/longReturn.kt");
          }

          @Test
          @TestMetadata("nested.kt")
          public void testNested() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/nested.kt");
          }

          @Test
          @TestMetadata("returnInFinally.kt")
          public void testReturnInFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInFinally.kt");
          }

          @Test
          @TestMetadata("returnInTry.kt")
          public void testReturnInTry() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTry.kt");
          }

          @Test
          @TestMetadata("returnInTryAndFinally.kt")
          public void testReturnInTryAndFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTryAndFinally.kt");
          }

          @Test
          @TestMetadata("severalInTry.kt")
          public void testSeveralInTry() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTry.kt");
          }

          @Test
          @TestMetadata("severalInTryComplex.kt")
          public void testSeveralInTryComplex() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTryComplex.kt");
          }

          @Test
          @TestMetadata("voidInlineFun.kt")
          public void testVoidInlineFun() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidInlineFun.kt");
          }

          @Test
          @TestMetadata("voidNonLocal.kt")
          public void testVoidNonLocal() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidNonLocal.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable")
        @TestDataPath("$PROJECT_ROOT")
        public class ExceptionTable {
          @Test
          public void testAllFilesPresentInExceptionTable() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("break.kt")
          public void testBreak() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/break.kt");
          }

          @Test
          @TestMetadata("continue.kt")
          public void testContinue() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/continue.kt");
          }

          @Test
          @TestMetadata("exceptionInFinally.kt")
          public void testExceptionInFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/exceptionInFinally.kt");
          }

          @Test
          @TestMetadata("forInFinally.kt")
          public void testForInFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/forInFinally.kt");
          }

          @Test
          @TestMetadata("innerAndExternal.kt")
          public void testInnerAndExternal() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternal.kt");
          }

          @Test
          @TestMetadata("innerAndExternalNested.kt")
          public void testInnerAndExternalNested() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalNested.kt");
          }

          @Test
          @TestMetadata("innerAndExternalSimple.kt")
          public void testInnerAndExternalSimple() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalSimple.kt");
          }

          @Test
          @TestMetadata("kt31653.kt")
          public void testKt31653() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653.kt");
          }

          @Test
          @TestMetadata("kt31653_2.kt")
          public void testKt31653_2() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653_2.kt");
          }

          @Test
          @TestMetadata("kt31923.kt")
          public void testKt31923() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923.kt");
          }

          @Test
          @TestMetadata("kt31923_2.kt")
          public void testKt31923_2() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_2.kt");
          }

          @Test
          @TestMetadata("kt31923_wrong.kt")
          public void testKt31923_wrong() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_wrong.kt");
          }

          @Test
          @TestMetadata("nested.kt")
          public void testNested() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nested.kt");
          }

          @Test
          @TestMetadata("nestedWithReturns.kt")
          public void testNestedWithReturns() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturns.kt");
          }

          @Test
          @TestMetadata("nestedWithReturnsSimple.kt")
          public void testNestedWithReturnsSimple() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturnsSimple.kt");
          }

          @Test
          @TestMetadata("noFinally.kt")
          public void testNoFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/noFinally.kt");
          }

          @Test
          @TestMetadata("severalCatchClause.kt")
          public void testSeveralCatchClause() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/severalCatchClause.kt");
          }

          @Test
          @TestMetadata("simpleThrow.kt")
          public void testSimpleThrow() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/simpleThrow.kt");
          }

          @Test
          @TestMetadata("synchonized.kt")
          public void testSynchonized() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/synchonized.kt");
          }

          @Test
          @TestMetadata("throwInFinally.kt")
          public void testThrowInFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/throwInFinally.kt");
          }

          @Test
          @TestMetadata("tryCatchInFinally.kt")
          public void testTryCatchInFinally() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/tryCatchInFinally.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables")
        @TestDataPath("$PROJECT_ROOT")
        public class Variables {
          @Test
          public void testAllFilesPresentInVariables() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("kt7792.kt")
          public void testKt7792() {
            runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables/kt7792.kt");
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/optimizations")
    @TestDataPath("$PROJECT_ROOT")
    public class Optimizations {
      @Test
      public void testAllFilesPresentInOptimizations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/optimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt20844.kt")
      public void testKt20844() {
        runTest("compiler/testData/codegen/boxInline/optimizations/kt20844.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/private")
    @TestDataPath("$PROJECT_ROOT")
    public class Private {
      @Test
      @TestMetadata("accessorForConst.kt")
      public void testAccessorForConst() {
        runTest("compiler/testData/codegen/boxInline/private/accessorForConst.kt");
      }

      @Test
      @TestMetadata("accessorStability.kt")
      public void testAccessorStability() {
        runTest("compiler/testData/codegen/boxInline/private/accessorStability.kt");
      }

      @Test
      @TestMetadata("accessorStabilityInClass.kt")
      public void testAccessorStabilityInClass() {
        runTest("compiler/testData/codegen/boxInline/private/accessorStabilityInClass.kt");
      }

      @Test
      public void testAllFilesPresentInPrivate() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("effectivePrivate.kt")
      public void testEffectivePrivate() {
        runTest("compiler/testData/codegen/boxInline/private/effectivePrivate.kt");
      }

      @Test
      @TestMetadata("kt6453.kt")
      public void testKt6453() {
        runTest("compiler/testData/codegen/boxInline/private/kt6453.kt");
      }

      @Test
      @TestMetadata("kt8094.kt")
      public void testKt8094() {
        runTest("compiler/testData/codegen/boxInline/private/kt8094.kt");
      }

      @Test
      @TestMetadata("kt8095.kt")
      public void testKt8095() {
        runTest("compiler/testData/codegen/boxInline/private/kt8095.kt");
      }

      @Test
      @TestMetadata("nestedInPrivateClass.kt")
      public void testNestedInPrivateClass() {
        runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass.kt");
      }

      @Test
      @TestMetadata("nestedInPrivateClass2.kt")
      public void testNestedInPrivateClass2() {
        runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass2.kt");
      }

      @Test
      @TestMetadata("privateClass.kt")
      public void testPrivateClass() {
        runTest("compiler/testData/codegen/boxInline/private/privateClass.kt");
      }

      @Test
      @TestMetadata("privateClassExtensionLambda.kt")
      public void testPrivateClassExtensionLambda() {
        runTest("compiler/testData/codegen/boxInline/private/privateClassExtensionLambda.kt");
      }

      @Test
      @TestMetadata("privateInInlineInMultiFileFacade.kt")
      public void testPrivateInInlineInMultiFileFacade() {
        runTest("compiler/testData/codegen/boxInline/private/privateInInlineInMultiFileFacade.kt");
      }

      @Test
      @TestMetadata("privateInline.kt")
      public void testPrivateInline() {
        runTest("compiler/testData/codegen/boxInline/private/privateInline.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/property")
    @TestDataPath("$PROJECT_ROOT")
    public class Property {
      @Test
      public void testAllFilesPresentInProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("augAssignmentAndInc.kt")
      public void testAugAssignmentAndInc() {
        runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndInc.kt");
      }

      @Test
      @TestMetadata("augAssignmentAndIncInClass.kt")
      public void testAugAssignmentAndIncInClass() {
        runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClass.kt");
      }

      @Test
      @TestMetadata("augAssignmentAndIncInClassViaConvention.kt")
      public void testAugAssignmentAndIncInClassViaConvention() {
        runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClassViaConvention.kt");
      }

      @Test
      @TestMetadata("augAssignmentAndIncOnExtension.kt")
      public void testAugAssignmentAndIncOnExtension() {
        runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtension.kt");
      }

      @Test
      @TestMetadata("augAssignmentAndIncOnExtensionInClass.kt")
      public void testAugAssignmentAndIncOnExtensionInClass() {
        runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtensionInClass.kt");
      }

      @Test
      @TestMetadata("augAssignmentAndIncViaConvention.kt")
      public void testAugAssignmentAndIncViaConvention() {
        runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncViaConvention.kt");
      }

      @Test
      @TestMetadata("crossinlineFunctional.kt")
      public void testCrossinlineFunctional() {
        runTest("compiler/testData/codegen/boxInline/property/crossinlineFunctional.kt");
      }

      @Test
      @TestMetadata("fromObject.kt")
      public void testFromObject() {
        runTest("compiler/testData/codegen/boxInline/property/fromObject.kt");
      }

      @Test
      @TestMetadata("kt22649.kt")
      public void testKt22649() {
        runTest("compiler/testData/codegen/boxInline/property/kt22649.kt");
      }

      @Test
      @TestMetadata("noinlineFunctional.kt")
      public void testNoinlineFunctional() {
        runTest("compiler/testData/codegen/boxInline/property/noinlineFunctional.kt");
      }

      @Test
      @TestMetadata("property.kt")
      public void testProperty() {
        runTest("compiler/testData/codegen/boxInline/property/property.kt");
      }

      @Test
      @TestMetadata("reifiedVal.kt")
      public void testReifiedVal() {
        runTest("compiler/testData/codegen/boxInline/property/reifiedVal.kt");
      }

      @Test
      @TestMetadata("reifiedValMultiModule.kt")
      public void testReifiedValMultiModule() {
        runTest("compiler/testData/codegen/boxInline/property/reifiedValMultiModule.kt");
      }

      @Test
      @TestMetadata("reifiedVar.kt")
      public void testReifiedVar() {
        runTest("compiler/testData/codegen/boxInline/property/reifiedVar.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/boxInline/property/simple.kt");
      }

      @Test
      @TestMetadata("simpleExtension.kt")
      public void testSimpleExtension() {
        runTest("compiler/testData/codegen/boxInline/property/simpleExtension.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/reified")
    @TestDataPath("$PROJECT_ROOT")
    public class Reified {
      @Test
      public void testAllFilesPresentInReified() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayConstructor.kt")
      public void testArrayConstructor() {
        runTest("compiler/testData/codegen/boxInline/reified/arrayConstructor.kt");
      }

      @Test
      @TestMetadata("arrayOf.kt")
      public void testArrayOf() {
        runTest("compiler/testData/codegen/boxInline/reified/arrayOf.kt");
      }

      @Test
      @TestMetadata("capturedLambda.kt")
      public void testCapturedLambda() {
        runTest("compiler/testData/codegen/boxInline/reified/capturedLambda.kt");
      }

      @Test
      @TestMetadata("capturedLambda2.kt")
      public void testCapturedLambda2() {
        runTest("compiler/testData/codegen/boxInline/reified/capturedLambda2.kt");
      }

      @Test
      @TestMetadata("dontSubstituteNonReified.kt")
      public void testDontSubstituteNonReified() {
        runTest("compiler/testData/codegen/boxInline/reified/dontSubstituteNonReified.kt");
      }

      @Test
      @TestMetadata("kt11081.kt")
      public void testKt11081() {
        runTest("compiler/testData/codegen/boxInline/reified/kt11081.kt");
      }

      @Test
      @TestMetadata("kt11677.kt")
      public void testKt11677() {
        runTest("compiler/testData/codegen/boxInline/reified/kt11677.kt");
      }

      @Test
      @TestMetadata("kt15956.kt")
      public void testKt15956() {
        runTest("compiler/testData/codegen/boxInline/reified/kt15956.kt");
      }

      @Test
      @TestMetadata("kt15997.kt")
      public void testKt15997() {
        runTest("compiler/testData/codegen/boxInline/reified/kt15997.kt");
      }

      @Test
      @TestMetadata("kt15997_2.kt")
      public void testKt15997_2() {
        runTest("compiler/testData/codegen/boxInline/reified/kt15997_2.kt");
      }

      @Test
      @TestMetadata("kt18977.kt")
      public void testKt18977() {
        runTest("compiler/testData/codegen/boxInline/reified/kt18977.kt");
      }

      @Test
      @TestMetadata("kt28234.kt")
      public void testKt28234() {
        runTest("compiler/testData/codegen/boxInline/reified/kt28234.kt");
      }

      @Test
      @TestMetadata("kt35511.kt")
      public void testKt35511() {
        runTest("compiler/testData/codegen/boxInline/reified/kt35511.kt");
      }

      @Test
      @TestMetadata("kt35511_try.kt")
      public void testKt35511_try() {
        runTest("compiler/testData/codegen/boxInline/reified/kt35511_try.kt");
      }

      @Test
      @TestMetadata("kt35511_try_valueOf.kt")
      public void testKt35511_try_valueOf() {
        runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_valueOf.kt");
      }

      @Test
      @TestMetadata("kt35511_try_values.kt")
      public void testKt35511_try_values() {
        runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_values.kt");
      }

      @Test
      @TestMetadata("kt44770.kt")
      public void testKt44770() {
        runTest("compiler/testData/codegen/boxInline/reified/kt44770.kt");
      }

      @Test
      @TestMetadata("kt44770_2.kt")
      public void testKt44770_2() {
        runTest("compiler/testData/codegen/boxInline/reified/kt44770_2.kt");
      }

      @Test
      @TestMetadata("kt46584.kt")
      public void testKt46584() {
        runTest("compiler/testData/codegen/boxInline/reified/kt46584.kt");
      }

      @Test
      @TestMetadata("kt46584_2.kt")
      public void testKt46584_2() {
        runTest("compiler/testData/codegen/boxInline/reified/kt46584_2.kt");
      }

      @Test
      @TestMetadata("kt55398.kt")
      public void testKt55398() {
        runTest("compiler/testData/codegen/boxInline/reified/kt55398.kt");
      }

      @Test
      @TestMetadata("kt6988.kt")
      public void testKt6988() {
        runTest("compiler/testData/codegen/boxInline/reified/kt6988.kt");
      }

      @Test
      @TestMetadata("kt6988_2.kt")
      public void testKt6988_2() {
        runTest("compiler/testData/codegen/boxInline/reified/kt6988_2.kt");
      }

      @Test
      @TestMetadata("kt6990.kt")
      public void testKt6990() {
        runTest("compiler/testData/codegen/boxInline/reified/kt6990.kt");
      }

      @Test
      @TestMetadata("kt7017.kt")
      public void testKt7017() {
        runTest("compiler/testData/codegen/boxInline/reified/kt7017.kt");
      }

      @Test
      @TestMetadata("kt8047.kt")
      public void testKt8047() {
        runTest("compiler/testData/codegen/boxInline/reified/kt8047.kt");
      }

      @Test
      @TestMetadata("kt8047_2.kt")
      public void testKt8047_2() {
        runTest("compiler/testData/codegen/boxInline/reified/kt8047_2.kt");
      }

      @Test
      @TestMetadata("kt9637.kt")
      public void testKt9637() {
        runTest("compiler/testData/codegen/boxInline/reified/kt9637.kt");
      }

      @Test
      @TestMetadata("kt9637_2.kt")
      public void testKt9637_2() {
        runTest("compiler/testData/codegen/boxInline/reified/kt9637_2.kt");
      }

      @Test
      @TestMetadata("nameClash.kt")
      public void testNameClash() {
        runTest("compiler/testData/codegen/boxInline/reified/nameClash.kt");
      }

      @Test
      @TestMetadata("nonCapturingObjectInLambda.kt")
      public void testNonCapturingObjectInLambda() {
        runTest("compiler/testData/codegen/boxInline/reified/nonCapturingObjectInLambda.kt");
      }

      @Test
      @TestMetadata("packages.kt")
      public void testPackages() {
        runTest("compiler/testData/codegen/boxInline/reified/packages.kt");
      }

      @Test
      @TestMetadata("singletonLambda.kt")
      public void testSingletonLambda() {
        runTest("compiler/testData/codegen/boxInline/reified/singletonLambda.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/reified/checkCast")
      @TestDataPath("$PROJECT_ROOT")
      public class CheckCast {
        @Test
        public void testAllFilesPresentInCheckCast() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/checkCast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("chain.kt")
        public void testChain() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/chain.kt");
        }

        @Test
        @TestMetadata("kt26435.kt")
        public void testKt26435() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435.kt");
        }

        @Test
        @TestMetadata("kt26435_2.kt")
        public void testKt26435_2() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_2.kt");
        }

        @Test
        @TestMetadata("kt26435_3.kt")
        public void testKt26435_3() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_3.kt");
        }

        @Test
        @TestMetadata("kt8043.kt")
        public void testKt8043() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt8043.kt");
        }

        @Test
        @TestMetadata("maxStack.kt")
        public void testMaxStack() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/maxStack.kt");
        }

        @Test
        @TestMetadata("nullable.kt")
        public void testNullable() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/nullable.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple.kt");
        }

        @Test
        @TestMetadata("simpleSafe.kt")
        public void testSimpleSafe() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/simpleSafe.kt");
        }

        @Test
        @TestMetadata("simple_1_3.kt")
        public void testSimple_1_3() {
          runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple_1_3.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/reified/defaultLambda")
      @TestDataPath("$PROJECT_ROOT")
      public class DefaultLambda {
        @Test
        public void testAllFilesPresentInDefaultLambda() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("chain.kt")
        public void testChain() {
          runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/chain.kt");
        }

        @Test
        @TestMetadata("nested.kt")
        public void testNested() {
          runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested.kt");
        }

        @Test
        @TestMetadata("nested2.kt")
        public void testNested2() {
          runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2.kt");
        }

        @Test
        @TestMetadata("nested2Static.kt")
        public void testNested2Static() {
          runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2Static.kt");
        }

        @Test
        @TestMetadata("nestedStatic.kt")
        public void testNestedStatic() {
          runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nestedStatic.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/simple.kt");
        }

        @Test
        @TestMetadata("transitiveChain.kt")
        public void testTransitiveChain() {
          runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChain.kt");
        }

        @Test
        @TestMetadata("transitiveChainStatic.kt")
        public void testTransitiveChainStatic() {
          runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChainStatic.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/reified/isCheck")
      @TestDataPath("$PROJECT_ROOT")
      public class IsCheck {
        @Test
        public void testAllFilesPresentInIsCheck() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/isCheck"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("chain.kt")
        public void testChain() {
          runTest("compiler/testData/codegen/boxInline/reified/isCheck/chain.kt");
        }

        @Test
        @TestMetadata("nullable.kt")
        public void testNullable() {
          runTest("compiler/testData/codegen/boxInline/reified/isCheck/nullable.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/boxInline/reified/isCheck/simple.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/signature")
    @TestDataPath("$PROJECT_ROOT")
    public class Signature {
      @Test
      public void testAllFilesPresentInSignature() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("byteIteratorWithForLoop.kt")
      public void testByteIteratorWithForLoop() {
        runTest("compiler/testData/codegen/boxInline/signature/byteIteratorWithForLoop.kt");
      }

      @Test
      @TestMetadata("byteIteratorWithWhileLoop.kt")
      public void testByteIteratorWithWhileLoop() {
        runTest("compiler/testData/codegen/boxInline/signature/byteIteratorWithWhileLoop.kt");
      }

      @Test
      @TestMetadata("inProjectionSubstitution.kt")
      public void testInProjectionSubstitution() {
        runTest("compiler/testData/codegen/boxInline/signature/inProjectionSubstitution.kt");
      }

      @Test
      @TestMetadata("outProjectionSubstitution.kt")
      public void testOutProjectionSubstitution() {
        runTest("compiler/testData/codegen/boxInline/signature/outProjectionSubstitution.kt");
      }

      @Test
      @TestMetadata("recursion.kt")
      public void testRecursion() {
        runTest("compiler/testData/codegen/boxInline/signature/recursion.kt");
      }

      @Test
      @TestMetadata("sameFormalParameterName.kt")
      public void testSameFormalParameterName() {
        runTest("compiler/testData/codegen/boxInline/signature/sameFormalParameterName.kt");
      }

      @Test
      @TestMetadata("sameReifiedFormalParameterName.kt")
      public void testSameReifiedFormalParameterName() {
        runTest("compiler/testData/codegen/boxInline/signature/sameReifiedFormalParameterName.kt");
      }

      @Test
      @TestMetadata("starProjectionSubstitution.kt")
      public void testStarProjectionSubstitution() {
        runTest("compiler/testData/codegen/boxInline/signature/starProjectionSubstitution.kt");
      }

      @Test
      @TestMetadata("typeParameterInLambda.kt")
      public void testTypeParameterInLambda() {
        runTest("compiler/testData/codegen/boxInline/signature/typeParameterInLambda.kt");
      }

      @Test
      @TestMetadata("typeParametersSubstitution.kt")
      public void testTypeParametersSubstitution() {
        runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution.kt");
      }

      @Test
      @TestMetadata("typeParametersSubstitution2.kt")
      public void testTypeParametersSubstitution2() {
        runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution2.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/signatureMangling")
    @TestDataPath("$PROJECT_ROOT")
    public class SignatureMangling {
      @Test
      public void testAllFilesPresentInSignatureMangling() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signatureMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("flexibleType.kt")
      public void testFlexibleType() {
        runTest("compiler/testData/codegen/boxInline/signatureMangling/flexibleType.kt");
      }

      @Test
      @TestMetadata("indices.kt")
      public void testIndices() {
        runTest("compiler/testData/codegen/boxInline/signatureMangling/indices.kt");
      }

      @Test
      @TestMetadata("inheritFromJava.kt")
      public void testInheritFromJava() {
        runTest("compiler/testData/codegen/boxInline/signatureMangling/inheritFromJava.kt");
      }

      @Test
      @TestMetadata("rawType.kt")
      public void testRawType() {
        runTest("compiler/testData/codegen/boxInline/signatureMangling/rawType.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/simple")
    @TestDataPath("$PROJECT_ROOT")
    public class Simple {
      @Test
      public void testAllFilesPresentInSimple() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/simple"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("captureAndArgumentIncompatibleTypes.kt")
      public void testCaptureAndArgumentIncompatibleTypes() {
        runTest("compiler/testData/codegen/boxInline/simple/captureAndArgumentIncompatibleTypes.kt");
      }

      @Test
      @TestMetadata("classObject.kt")
      public void testClassObject() {
        runTest("compiler/testData/codegen/boxInline/simple/classObject.kt");
      }

      @Test
      @TestMetadata("destructuring.kt")
      public void testDestructuring() {
        runTest("compiler/testData/codegen/boxInline/simple/destructuring.kt");
      }

      @Test
      @TestMetadata("destructuringIndexClash.kt")
      public void testDestructuringIndexClash() {
        runTest("compiler/testData/codegen/boxInline/simple/destructuringIndexClash.kt");
      }

      @Test
      @TestMetadata("extension.kt")
      public void testExtension() {
        runTest("compiler/testData/codegen/boxInline/simple/extension.kt");
      }

      @Test
      @TestMetadata("extensionLambda.kt")
      public void testExtensionLambda() {
        runTest("compiler/testData/codegen/boxInline/simple/extensionLambda.kt");
      }

      @Test
      @TestMetadata("funImportedFromObject.kt")
      public void testFunImportedFromObject() {
        runTest("compiler/testData/codegen/boxInline/simple/funImportedFromObject.kt");
      }

      @Test
      @TestMetadata("importedJavaStaticField.kt")
      public void testImportedJavaStaticField() {
        runTest("compiler/testData/codegen/boxInline/simple/importedJavaStaticField.kt");
      }

      @Test
      @TestMetadata("inlineCallInInlineLambda.kt")
      public void testInlineCallInInlineLambda() {
        runTest("compiler/testData/codegen/boxInline/simple/inlineCallInInlineLambda.kt");
      }

      @Test
      @TestMetadata("kt17431.kt")
      public void testKt17431() {
        runTest("compiler/testData/codegen/boxInline/simple/kt17431.kt");
      }

      @Test
      @TestMetadata("kt28547.kt")
      public void testKt28547() {
        runTest("compiler/testData/codegen/boxInline/simple/kt28547.kt");
      }

      @Test
      @TestMetadata("kt28547_2.kt")
      public void testKt28547_2() {
        runTest("compiler/testData/codegen/boxInline/simple/kt28547_2.kt");
      }

      @Test
      @TestMetadata("params.kt")
      public void testParams() {
        runTest("compiler/testData/codegen/boxInline/simple/params.kt");
      }

      @Test
      @TestMetadata("propImportedFromObject.kt")
      public void testPropImportedFromObject() {
        runTest("compiler/testData/codegen/boxInline/simple/propImportedFromObject.kt");
      }

      @Test
      @TestMetadata("rootConstructor.kt")
      public void testRootConstructor() {
        runTest("compiler/testData/codegen/boxInline/simple/rootConstructor.kt");
      }

      @Test
      @TestMetadata("safeCall.kt")
      public void testSafeCall() {
        runTest("compiler/testData/codegen/boxInline/simple/safeCall.kt");
      }

      @Test
      @TestMetadata("severalClosures.kt")
      public void testSeveralClosures() {
        runTest("compiler/testData/codegen/boxInline/simple/severalClosures.kt");
      }

      @Test
      @TestMetadata("severalUsage.kt")
      public void testSeveralUsage() {
        runTest("compiler/testData/codegen/boxInline/simple/severalUsage.kt");
      }

      @Test
      @TestMetadata("simpleDouble.kt")
      public void testSimpleDouble() {
        runTest("compiler/testData/codegen/boxInline/simple/simpleDouble.kt");
      }

      @Test
      @TestMetadata("simpleEnum.kt")
      public void testSimpleEnum() {
        runTest("compiler/testData/codegen/boxInline/simple/simpleEnum.kt");
      }

      @Test
      @TestMetadata("simpleGenerics.kt")
      public void testSimpleGenerics() {
        runTest("compiler/testData/codegen/boxInline/simple/simpleGenerics.kt");
      }

      @Test
      @TestMetadata("simpleInt.kt")
      public void testSimpleInt() {
        runTest("compiler/testData/codegen/boxInline/simple/simpleInt.kt");
      }

      @Test
      @TestMetadata("simpleLambda.kt")
      public void testSimpleLambda() {
        runTest("compiler/testData/codegen/boxInline/simple/simpleLambda.kt");
      }

      @Test
      @TestMetadata("simpleObject.kt")
      public void testSimpleObject() {
        runTest("compiler/testData/codegen/boxInline/simple/simpleObject.kt");
      }

      @Test
      @TestMetadata("vararg.kt")
      public void testVararg() {
        runTest("compiler/testData/codegen/boxInline/simple/vararg.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/smap")
    @TestDataPath("$PROJECT_ROOT")
    public class Smap {
      @Test
      public void testAllFilesPresentInSmap() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("assertion.kt")
      public void testAssertion() {
        runTest("compiler/testData/codegen/boxInline/smap/assertion.kt");
      }

      @Test
      @TestMetadata("classCycle.kt")
      public void testClassCycle() {
        runTest("compiler/testData/codegen/boxInline/smap/classCycle.kt");
      }

      @Test
      @TestMetadata("classFromDefaultPackage.kt")
      public void testClassFromDefaultPackage() {
        runTest("compiler/testData/codegen/boxInline/smap/classFromDefaultPackage.kt");
      }

      @Test
      @TestMetadata("coroutinesWithTailCallOtpimization.kt")
      public void testCoroutinesWithTailCallOtpimization() {
        runTest("compiler/testData/codegen/boxInline/smap/coroutinesWithTailCallOtpimization.kt");
      }

      @Test
      @TestMetadata("crossroutines.kt")
      public void testCrossroutines() {
        runTest("compiler/testData/codegen/boxInline/smap/crossroutines.kt");
      }

      @Test
      @TestMetadata("defaultFunction.kt")
      public void testDefaultFunction() {
        runTest("compiler/testData/codegen/boxInline/smap/defaultFunction.kt");
      }

      @Test
      @TestMetadata("defaultFunctionWithInlineCall.kt")
      public void testDefaultFunctionWithInlineCall() {
        runTest("compiler/testData/codegen/boxInline/smap/defaultFunctionWithInlineCall.kt");
      }

      @Test
      @TestMetadata("forInline.kt")
      public void testForInline() {
        runTest("compiler/testData/codegen/boxInline/smap/forInline.kt");
      }

      @Test
      @TestMetadata("inlineProperty.kt")
      public void testInlineProperty() {
        runTest("compiler/testData/codegen/boxInline/smap/inlineProperty.kt");
      }

      @Test
      @TestMetadata("interleavedFiles.kt")
      public void testInterleavedFiles() {
        runTest("compiler/testData/codegen/boxInline/smap/interleavedFiles.kt");
      }

      @Test
      @TestMetadata("kt23369.kt")
      public void testKt23369() {
        runTest("compiler/testData/codegen/boxInline/smap/kt23369.kt");
      }

      @Test
      @TestMetadata("kt23369_2.kt")
      public void testKt23369_2() {
        runTest("compiler/testData/codegen/boxInline/smap/kt23369_2.kt");
      }

      @Test
      @TestMetadata("kt23369_3.kt")
      public void testKt23369_3() {
        runTest("compiler/testData/codegen/boxInline/smap/kt23369_3.kt");
      }

      @Test
      @TestMetadata("kt35006.kt")
      public void testKt35006() {
        runTest("compiler/testData/codegen/boxInline/smap/kt35006.kt");
      }

      @Test
      @TestMetadata("multiFileFacade.kt")
      public void testMultiFileFacade() {
        runTest("compiler/testData/codegen/boxInline/smap/multiFileFacade.kt");
      }

      @Test
      @TestMetadata("oneFile.kt")
      public void testOneFile() {
        runTest("compiler/testData/codegen/boxInline/smap/oneFile.kt");
      }

      @Test
      @TestMetadata("rangeFolding.kt")
      public void testRangeFolding() {
        runTest("compiler/testData/codegen/boxInline/smap/rangeFolding.kt");
      }

      @Test
      @TestMetadata("rangeFoldingInClass.kt")
      public void testRangeFoldingInClass() {
        runTest("compiler/testData/codegen/boxInline/smap/rangeFoldingInClass.kt");
      }

      @Test
      @TestMetadata("smap.kt")
      public void testSmap() {
        runTest("compiler/testData/codegen/boxInline/smap/smap.kt");
      }

      @Test
      @TestMetadata("smapWithNewSyntax.kt")
      public void testSmapWithNewSyntax() {
        runTest("compiler/testData/codegen/boxInline/smap/smapWithNewSyntax.kt");
      }

      @Test
      @TestMetadata("smapWithOldSyntax.kt")
      public void testSmapWithOldSyntax() {
        runTest("compiler/testData/codegen/boxInline/smap/smapWithOldSyntax.kt");
      }

      @Test
      @TestMetadata("tryFinally1.kt")
      public void testTryFinally1() {
        runTest("compiler/testData/codegen/boxInline/smap/tryFinally1.kt");
      }

      @Test
      @TestMetadata("tryFinally2.kt")
      public void testTryFinally2() {
        runTest("compiler/testData/codegen/boxInline/smap/tryFinally2.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/smap/anonymous")
      @TestDataPath("$PROJECT_ROOT")
      public class Anonymous {
        @Test
        public void testAllFilesPresentInAnonymous() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/anonymous"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt19175.kt")
        public void testKt19175() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/kt19175.kt");
        }

        @Test
        @TestMetadata("lambda.kt")
        public void testLambda() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambda.kt");
        }

        @Test
        @TestMetadata("lambdaOnCallSite.kt")
        public void testLambdaOnCallSite() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnCallSite.kt");
        }

        @Test
        @TestMetadata("lambdaOnInlineCallSite.kt")
        public void testLambdaOnInlineCallSite() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnInlineCallSite.kt");
        }

        @Test
        @TestMetadata("object.kt")
        public void testObject() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/object.kt");
        }

        @Test
        @TestMetadata("objectOnCallSite.kt")
        public void testObjectOnCallSite() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnCallSite.kt");
        }

        @Test
        @TestMetadata("objectOnInlineCallSite.kt")
        public void testObjectOnInlineCallSite() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite.kt");
        }

        @Test
        @TestMetadata("objectOnInlineCallSite2.kt")
        public void testObjectOnInlineCallSite2() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite2.kt");
        }

        @Test
        @TestMetadata("objectOnInlineCallSiteWithCapture.kt")
        public void testObjectOnInlineCallSiteWithCapture() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSiteWithCapture.kt");
        }

        @Test
        @TestMetadata("severalMappingsForDefaultFile.kt")
        public void testSeveralMappingsForDefaultFile() {
          runTest("compiler/testData/codegen/boxInline/smap/anonymous/severalMappingsForDefaultFile.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/smap/defaultLambda")
      @TestDataPath("$PROJECT_ROOT")
      public class DefaultLambda {
        @Test
        public void testAllFilesPresentInDefaultLambda() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("defaultLambdaInAnonymous.kt")
        public void testDefaultLambdaInAnonymous() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/defaultLambdaInAnonymous.kt");
        }

        @Test
        @TestMetadata("inlineAnonymousInDefault.kt")
        public void testInlineAnonymousInDefault() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault.kt");
        }

        @Test
        @TestMetadata("inlineAnonymousInDefault2.kt")
        public void testInlineAnonymousInDefault2() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault2.kt");
        }

        @Test
        @TestMetadata("inlineInDefault.kt")
        public void testInlineInDefault() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineInDefault.kt");
        }

        @Test
        @TestMetadata("inlineInDefault2.kt")
        public void testInlineInDefault2() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineInDefault2.kt");
        }

        @Test
        @TestMetadata("kt21827.kt")
        public void testKt21827() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/kt21827.kt");
        }

        @Test
        @TestMetadata("nested.kt")
        public void testNested() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/nested.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple.kt");
        }

        @Test
        @TestMetadata("simple2.kt")
        public void testSimple2() {
          runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple2.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/smap/inlineOnly")
      @TestDataPath("$PROJECT_ROOT")
      public class InlineOnly {
        @Test
        public void testAllFilesPresentInInlineOnly() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/inlineOnly"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("noSmap.kt")
        public void testNoSmap() {
          runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmap.kt");
        }

        @Test
        @TestMetadata("noSmapWithProperty.kt")
        public void testNoSmapWithProperty() {
          runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmapWithProperty.kt");
        }

        @Test
        @TestMetadata("reified.kt")
        public void testReified() {
          runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reified.kt");
        }

        @Test
        @TestMetadata("reifiedProperty.kt")
        public void testReifiedProperty() {
          runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reifiedProperty.kt");
        }

        @Test
        @TestMetadata("stdlibInlineOnly.kt")
        public void testStdlibInlineOnly() {
          runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnly.kt");
        }

        @Test
        @TestMetadata("stdlibInlineOnlyOneLine.kt")
        public void testStdlibInlineOnlyOneLine() {
          runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnlyOneLine.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/smap/newsmap")
      @TestDataPath("$PROJECT_ROOT")
      public class Newsmap {
        @Test
        public void testAllFilesPresentInNewsmap() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/newsmap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("differentMapping.kt")
        public void testDifferentMapping() {
          runTest("compiler/testData/codegen/boxInline/smap/newsmap/differentMapping.kt");
        }

        @Test
        @TestMetadata("mappingInInlineFunLambda.kt")
        public void testMappingInInlineFunLambda() {
          runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInInlineFunLambda.kt");
        }

        @Test
        @TestMetadata("mappingInSubInlineLambda.kt")
        public void testMappingInSubInlineLambda() {
          runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambda.kt");
        }

        @Test
        @TestMetadata("mappingInSubInlineLambdaSameFileInline.kt")
        public void testMappingInSubInlineLambdaSameFileInline() {
          runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambdaSameFileInline.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/smap/resolve")
      @TestDataPath("$PROJECT_ROOT")
      public class Resolve {
        @Test
        public void testAllFilesPresentInResolve() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/resolve"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineComponent.kt")
        public void testInlineComponent() {
          runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineComponent.kt");
        }

        @Test
        @TestMetadata("inlineIterator.kt")
        public void testInlineIterator() {
          runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineIterator.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/special")
    @TestDataPath("$PROJECT_ROOT")
    public class Special {
      @Test
      public void testAllFilesPresentInSpecial() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/special"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("blockReturnsNullableUnit.kt")
      public void testBlockReturnsNullableUnit() {
        runTest("compiler/testData/codegen/boxInline/special/blockReturnsNullableUnit.kt");
      }

      @Test
      @TestMetadata("identityCheck.kt")
      public void testIdentityCheck() {
        runTest("compiler/testData/codegen/boxInline/special/identityCheck.kt");
      }

      @Test
      @TestMetadata("ifBranches.kt")
      public void testIfBranches() {
        runTest("compiler/testData/codegen/boxInline/special/ifBranches.kt");
      }

      @Test
      @TestMetadata("iinc.kt")
      public void testIinc() {
        runTest("compiler/testData/codegen/boxInline/special/iinc.kt");
      }

      @Test
      @TestMetadata("inlineChain.kt")
      public void testInlineChain() {
        runTest("compiler/testData/codegen/boxInline/special/inlineChain.kt");
      }

      @Test
      @TestMetadata("loopInStoreLoadChains.kt")
      public void testLoopInStoreLoadChains() {
        runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains.kt");
      }

      @Test
      @TestMetadata("loopInStoreLoadChains2.kt")
      public void testLoopInStoreLoadChains2() {
        runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains2.kt");
      }

      @Test
      @TestMetadata("monitorEnterExit.kt")
      public void testMonitorEnterExit() {
        runTest("compiler/testData/codegen/boxInline/special/monitorEnterExit.kt");
      }

      @Test
      @TestMetadata("plusAssign.kt")
      public void testPlusAssign() {
        runTest("compiler/testData/codegen/boxInline/special/plusAssign.kt");
      }

      @Test
      @TestMetadata("stackHeightBug.kt")
      public void testStackHeightBug() {
        runTest("compiler/testData/codegen/boxInline/special/stackHeightBug.kt");
      }

      @Test
      @TestMetadata("unusedInlineLambda.kt")
      public void testUnusedInlineLambda() {
        runTest("compiler/testData/codegen/boxInline/special/unusedInlineLambda.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/stackOnReturn")
    @TestDataPath("$PROJECT_ROOT")
    public class StackOnReturn {
      @Test
      public void testAllFilesPresentInStackOnReturn() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/stackOnReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("elvis.kt")
      public void testElvis() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/elvis.kt");
      }

      @Test
      @TestMetadata("ifThenElse.kt")
      public void testIfThenElse() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/ifThenElse.kt");
      }

      @Test
      @TestMetadata("kt11499.kt")
      public void testKt11499() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt11499.kt");
      }

      @Test
      @TestMetadata("kt17591.kt")
      public void testKt17591() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591.kt");
      }

      @Test
      @TestMetadata("kt17591a.kt")
      public void testKt17591a() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591a.kt");
      }

      @Test
      @TestMetadata("kt17591b.kt")
      public void testKt17591b() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591b.kt");
      }

      @Test
      @TestMetadata("mixedTypesOnStack1.kt")
      public void testMixedTypesOnStack1() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack1.kt");
      }

      @Test
      @TestMetadata("mixedTypesOnStack2.kt")
      public void testMixedTypesOnStack2() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack2.kt");
      }

      @Test
      @TestMetadata("mixedTypesOnStack3.kt")
      public void testMixedTypesOnStack3() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack3.kt");
      }

      @Test
      @TestMetadata("nonLocalReturn1.kt")
      public void testNonLocalReturn1() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn1.kt");
      }

      @Test
      @TestMetadata("nonLocalReturn2.kt")
      public void testNonLocalReturn2() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn2.kt");
      }

      @Test
      @TestMetadata("nonLocalReturn3.kt")
      public void testNonLocalReturn3() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn3.kt");
      }

      @Test
      @TestMetadata("poppedLocalReturn.kt")
      public void testPoppedLocalReturn() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn.kt");
      }

      @Test
      @TestMetadata("poppedLocalReturn2.kt")
      public void testPoppedLocalReturn2() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn2.kt");
      }

      @Test
      @TestMetadata("returnLong.kt")
      public void testReturnLong() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/returnLong.kt");
      }

      @Test
      @TestMetadata("tryFinally.kt")
      public void testTryFinally() {
        runTest("compiler/testData/codegen/boxInline/stackOnReturn/tryFinally.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/suspend")
    @TestDataPath("$PROJECT_ROOT")
    public class Suspend {
      @Test
      public void testAllFilesPresentInSuspend() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("capturedVariables.kt")
      public void testCapturedVariables() {
        runTest("compiler/testData/codegen/boxInline/suspend/capturedVariables.kt");
      }

      @Test
      @TestMetadata("crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt")
      public void testCrossinlineSuspendLambdaInsideCrossinlineSuspendLambda() {
        runTest("compiler/testData/codegen/boxInline/suspend/crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt");
      }

      @Test
      @TestMetadata("debugMetadataCrossinline.kt")
      public void testDebugMetadataCrossinline() {
        runTest("compiler/testData/codegen/boxInline/suspend/debugMetadataCrossinline.kt");
      }

      @Test
      @TestMetadata("delegatedProperties.kt")
      public void testDelegatedProperties() {
        runTest("compiler/testData/codegen/boxInline/suspend/delegatedProperties.kt");
      }

      @Test
      @TestMetadata("doubleRegenerationWithNonSuspendingLambda.kt")
      public void testDoubleRegenerationWithNonSuspendingLambda() {
        runTest("compiler/testData/codegen/boxInline/suspend/doubleRegenerationWithNonSuspendingLambda.kt");
      }

      @Test
      @TestMetadata("enclodingMethod.kt")
      public void testEnclodingMethod() {
        runTest("compiler/testData/codegen/boxInline/suspend/enclodingMethod.kt");
      }

      @Test
      @TestMetadata("fileNameInMetadata.kt")
      public void testFileNameInMetadata() {
        runTest("compiler/testData/codegen/boxInline/suspend/fileNameInMetadata.kt");
      }

      @Test
      @TestMetadata("inlineOrdinaryOfCrossinlineSuspend.kt")
      public void testInlineOrdinaryOfCrossinlineSuspend() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfCrossinlineSuspend.kt");
      }

      @Test
      @TestMetadata("inlineOrdinaryOfNoinlineSuspend.kt")
      public void testInlineOrdinaryOfNoinlineSuspend() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfNoinlineSuspend.kt");
      }

      @Test
      @TestMetadata("inlinePassthrough.kt")
      public void testInlinePassthrough() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthrough.kt");
      }

      @Test
      @TestMetadata("inlinePassthroughWithSuspendConversion.kt")
      public void testInlinePassthroughWithSuspendConversion() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthroughWithSuspendConversion.kt");
      }

      @Test
      @TestMetadata("inlineSuspendContinuation.kt")
      public void testInlineSuspendContinuation() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendContinuation.kt");
      }

      @Test
      @TestMetadata("inlineSuspendInMultifileClass.kt")
      public void testInlineSuspendInMultifileClass() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendInMultifileClass.kt");
      }

      @Test
      @TestMetadata("inlineSuspendOfCrossinlineOrdinary.kt")
      public void testInlineSuspendOfCrossinlineOrdinary() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineOrdinary.kt");
      }

      @Test
      @TestMetadata("inlineSuspendOfCrossinlineSuspend.kt")
      public void testInlineSuspendOfCrossinlineSuspend() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineSuspend.kt");
      }

      @Test
      @TestMetadata("inlineSuspendOfNoinlineOrdinary.kt")
      public void testInlineSuspendOfNoinlineOrdinary() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineOrdinary.kt");
      }

      @Test
      @TestMetadata("inlineSuspendOfNoinlineSuspend.kt")
      public void testInlineSuspendOfNoinlineSuspend() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineSuspend.kt");
      }

      @Test
      @TestMetadata("inlineSuspendOfOrdinary.kt")
      public void testInlineSuspendOfOrdinary() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfOrdinary.kt");
      }

      @Test
      @TestMetadata("inlineSuspendOfSuspend.kt")
      public void testInlineSuspendOfSuspend() {
        runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfSuspend.kt");
      }

      @Test
      @TestMetadata("jvmName.kt")
      public void testJvmName() {
        runTest("compiler/testData/codegen/boxInline/suspend/jvmName.kt");
      }

      @Test
      @TestMetadata("kt26658.kt")
      public void testKt26658() {
        runTest("compiler/testData/codegen/boxInline/suspend/kt26658.kt");
      }

      @Test
      @TestMetadata("kt52198.kt")
      public void testKt52198() {
        runTest("compiler/testData/codegen/boxInline/suspend/kt52198.kt");
      }

      @Test
      @TestMetadata("maxStackWithCrossinline.kt")
      public void testMaxStackWithCrossinline() {
        runTest("compiler/testData/codegen/boxInline/suspend/maxStackWithCrossinline.kt");
      }

      @Test
      @TestMetadata("multipleLocals.kt")
      public void testMultipleLocals() {
        runTest("compiler/testData/codegen/boxInline/suspend/multipleLocals.kt");
      }

      @Test
      @TestMetadata("multipleSuspensionPoints.kt")
      public void testMultipleSuspensionPoints() {
        runTest("compiler/testData/codegen/boxInline/suspend/multipleSuspensionPoints.kt");
      }

      @Test
      @TestMetadata("nestedMethodWith2XParameter.kt")
      public void testNestedMethodWith2XParameter() {
        runTest("compiler/testData/codegen/boxInline/suspend/nestedMethodWith2XParameter.kt");
      }

      @Test
      @TestMetadata("nonLocalReturn.kt")
      public void testNonLocalReturn() {
        runTest("compiler/testData/codegen/boxInline/suspend/nonLocalReturn.kt");
      }

      @Test
      @TestMetadata("nonSuspendCrossinline.kt")
      public void testNonSuspendCrossinline() {
        runTest("compiler/testData/codegen/boxInline/suspend/nonSuspendCrossinline.kt");
      }

      @Test
      @TestMetadata("returnValue.kt")
      public void testReturnValue() {
        runTest("compiler/testData/codegen/boxInline/suspend/returnValue.kt");
      }

      @Test
      @TestMetadata("tryCatchReceiver.kt")
      public void testTryCatchReceiver() {
        runTest("compiler/testData/codegen/boxInline/suspend/tryCatchReceiver.kt");
      }

      @Test
      @TestMetadata("tryCatchStackTransform.kt")
      public void testTryCatchStackTransform() {
        runTest("compiler/testData/codegen/boxInline/suspend/tryCatchStackTransform.kt");
      }

      @Test
      @TestMetadata("twiceRegeneratedAnonymousObject.kt")
      public void testTwiceRegeneratedAnonymousObject() {
        runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedAnonymousObject.kt");
      }

      @Test
      @TestMetadata("twiceRegeneratedSuspendLambda.kt")
      public void testTwiceRegeneratedSuspendLambda() {
        runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedSuspendLambda.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/suspend/callableReference")
      @TestDataPath("$PROJECT_ROOT")
      public class CallableReference {
        @Test
        public void testAllFilesPresentInCallableReference() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("isAsReified.kt")
        public void testIsAsReified() {
          runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified.kt");
        }

        @Test
        @TestMetadata("isAsReified2.kt")
        public void testIsAsReified2() {
          runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified2.kt");
        }

        @Test
        @TestMetadata("nonTailCall.kt")
        public void testNonTailCall() {
          runTest("compiler/testData/codegen/boxInline/suspend/callableReference/nonTailCall.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/boxInline/suspend/callableReference/simple.kt");
        }

        @Test
        @TestMetadata("unitReturn.kt")
        public void testUnitReturn() {
          runTest("compiler/testData/codegen/boxInline/suspend/callableReference/unitReturn.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/suspend/defaultParameter")
      @TestDataPath("$PROJECT_ROOT")
      public class DefaultParameter {
        @Test
        public void testAllFilesPresentInDefaultParameter() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/defaultParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("defaultInlineLambda.kt")
        public void testDefaultInlineLambda() {
          runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineLambda.kt");
        }

        @Test
        @TestMetadata("defaultInlineReference.kt")
        public void testDefaultInlineReference() {
          runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineReference.kt");
        }

        @Test
        @TestMetadata("defaultValueCrossinline.kt")
        public void testDefaultValueCrossinline() {
          runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueCrossinline.kt");
        }

        @Test
        @TestMetadata("defaultValueInClass.kt")
        public void testDefaultValueInClass() {
          runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInClass.kt");
        }

        @Test
        @TestMetadata("defaultValueInline.kt")
        public void testDefaultValueInline() {
          runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInline.kt");
        }

        @Test
        @TestMetadata("defaultValueInlineFromMultiFileFacade.kt")
        public void testDefaultValueInlineFromMultiFileFacade() {
          runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInlineFromMultiFileFacade.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/suspend/inlineClass")
      @TestDataPath("$PROJECT_ROOT")
      public class InlineClass {
        @Test
        public void testAllFilesPresentInInlineClass() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("returnBoxedFromLambda.kt")
        public void testReturnBoxedFromLambda() {
          runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnBoxedFromLambda.kt");
        }

        @Test
        @TestMetadata("returnUnboxedDirect.kt")
        public void testReturnUnboxedDirect() {
          runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedDirect.kt");
        }

        @Test
        @TestMetadata("returnUnboxedFromLambda.kt")
        public void testReturnUnboxedFromLambda() {
          runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedFromLambda.kt");
        }

        @Test
        @TestMetadata("returnUnboxedResume.kt")
        public void testReturnUnboxedResume() {
          runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedResume.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline")
      @TestDataPath("$PROJECT_ROOT")
      public class InlineUsedAsNoinline {
        @Test
        public void testAllFilesPresentInInlineUsedAsNoinline() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineOnly.kt")
        public void testInlineOnly() {
          runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/inlineOnly.kt");
        }

        @Test
        @TestMetadata("simpleNamed.kt")
        public void testSimpleNamed() {
          runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/simpleNamed.kt");
        }

        @Test
        @TestMetadata("withCapturedInlineLambda.kt")
        public void testWithCapturedInlineLambda() {
          runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda.kt");
        }

        @Test
        @TestMetadata("withCapturedInlineLambda2.kt")
        public void testWithCapturedInlineLambda2() {
          runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda2.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/suspend/receiver")
      @TestDataPath("$PROJECT_ROOT")
      public class Receiver {
        @Test
        public void testAllFilesPresentInReceiver() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/receiver"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineOrdinaryOfCrossinlineSuspend.kt")
        public void testInlineOrdinaryOfCrossinlineSuspend() {
          runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfCrossinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlineOrdinaryOfNoinlineSuspend.kt")
        public void testInlineOrdinaryOfNoinlineSuspend() {
          runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfNoinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfCrossinlineOrdinary.kt")
        public void testInlineSuspendOfCrossinlineOrdinary() {
          runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineOrdinary.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfCrossinlineSuspend.kt")
        public void testInlineSuspendOfCrossinlineSuspend() {
          runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfNoinlineOrdinary.kt")
        public void testInlineSuspendOfNoinlineOrdinary() {
          runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineOrdinary.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfNoinlineSuspend.kt")
        public void testInlineSuspendOfNoinlineSuspend() {
          runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfOrdinary.kt")
        public void testInlineSuspendOfOrdinary() {
          runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfOrdinary.kt");
        }

        @Test
        @TestMetadata("inlineSuspendOfSuspend.kt")
        public void testInlineSuspendOfSuspend() {
          runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfSuspend.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/suspend/stateMachine")
      @TestDataPath("$PROJECT_ROOT")
      public class StateMachine {
        @Test
        public void testAllFilesPresentInStateMachine() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("crossingCoroutineBoundaries.kt")
        public void testCrossingCoroutineBoundaries() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/crossingCoroutineBoundaries.kt");
        }

        @Test
        @TestMetadata("independentInline.kt")
        public void testIndependentInline() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/independentInline.kt");
        }

        @Test
        @TestMetadata("innerLambda.kt")
        public void testInnerLambda() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambda.kt");
        }

        @Test
        @TestMetadata("innerLambdaInsideLambda.kt")
        public void testInnerLambdaInsideLambda() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaInsideLambda.kt");
        }

        @Test
        @TestMetadata("innerLambdaWithoutCrossinline.kt")
        public void testInnerLambdaWithoutCrossinline() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaWithoutCrossinline.kt");
        }

        @Test
        @TestMetadata("innerMadness.kt")
        public void testInnerMadness() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadness.kt");
        }

        @Test
        @TestMetadata("innerMadnessCallSite.kt")
        public void testInnerMadnessCallSite() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadnessCallSite.kt");
        }

        @Test
        @TestMetadata("innerObject.kt")
        public void testInnerObject() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObject.kt");
        }

        @Test
        @TestMetadata("innerObjectInsideInnerObject.kt")
        public void testInnerObjectInsideInnerObject() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectInsideInnerObject.kt");
        }

        @Test
        @TestMetadata("innerObjectRetransformation.kt")
        public void testInnerObjectRetransformation() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectRetransformation.kt");
        }

        @Test
        @TestMetadata("innerObjectSeveralFunctions.kt")
        public void testInnerObjectSeveralFunctions() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectSeveralFunctions.kt");
        }

        @Test
        @TestMetadata("innerObjectWithoutCapturingCrossinline.kt")
        public void testInnerObjectWithoutCapturingCrossinline() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectWithoutCapturingCrossinline.kt");
        }

        @Test
        @TestMetadata("insideObject.kt")
        public void testInsideObject() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/insideObject.kt");
        }

        @Test
        @TestMetadata("kt30708.kt")
        public void testKt30708() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/kt30708.kt");
        }

        @Test
        @TestMetadata("lambdaTransformation.kt")
        public void testLambdaTransformation() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/lambdaTransformation.kt");
        }

        @Test
        @TestMetadata("normalInline.kt")
        public void testNormalInline() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/normalInline.kt");
        }

        @Test
        @TestMetadata("numberOfSuspentions.kt")
        public void testNumberOfSuspentions() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/numberOfSuspentions.kt");
        }

        @Test
        @TestMetadata("objectInsideLambdas.kt")
        public void testObjectInsideLambdas() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/objectInsideLambdas.kt");
        }

        @Test
        @TestMetadata("oneInlineTwoCaptures.kt")
        public void testOneInlineTwoCaptures() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/oneInlineTwoCaptures.kt");
        }

        @Test
        @TestMetadata("passLambda.kt")
        public void testPassLambda() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passLambda.kt");
        }

        @Test
        @TestMetadata("passParameter.kt")
        public void testPassParameter() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameter.kt");
        }

        @Test
        @TestMetadata("passParameterLambda.kt")
        public void testPassParameterLambda() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameterLambda.kt");
        }

        @Test
        @TestMetadata("unreachableSuspendMarker.kt")
        public void testUnreachableSuspendMarker() {
          runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/unreachableSuspendMarker.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/syntheticAccessors")
    @TestDataPath("$PROJECT_ROOT")
    public class SyntheticAccessors {
      @Test
      public void testAllFilesPresentInSyntheticAccessors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("constField.kt")
      public void testConstField() {
        runTest("compiler/testData/codegen/boxInline/syntheticAccessors/constField.kt");
      }

      @Test
      @TestMetadata("packagePrivateMembers.kt")
      public void testPackagePrivateMembers() {
        runTest("compiler/testData/codegen/boxInline/syntheticAccessors/packagePrivateMembers.kt");
      }

      @Test
      @TestMetadata("propertyModifiers.kt")
      public void testPropertyModifiers() {
        runTest("compiler/testData/codegen/boxInline/syntheticAccessors/propertyModifiers.kt");
      }

      @Test
      @TestMetadata("protectedMembers.kt")
      public void testProtectedMembers() {
        runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembers.kt");
      }

      @Test
      @TestMetadata("protectedMembersFromSuper.kt")
      public void testProtectedMembersFromSuper() {
        runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembersFromSuper.kt");
      }

      @Test
      @TestMetadata("superCall.kt")
      public void testSuperCall() {
        runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCall.kt");
      }

      @Test
      @TestMetadata("superCallFromMultipleSubclasses.kt")
      public void testSuperCallFromMultipleSubclasses() {
        runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCallFromMultipleSubclasses.kt");
      }

      @Test
      @TestMetadata("superProperty.kt")
      public void testSuperProperty() {
        runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superProperty.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda")
      @TestDataPath("$PROJECT_ROOT")
      public class WithinInlineLambda {
        @Test
        public void testAllFilesPresentInWithinInlineLambda() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("directFieldAccess.kt")
        public void testDirectFieldAccess() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccess.kt");
        }

        @Test
        @TestMetadata("directFieldAccessInCrossInline.kt")
        public void testDirectFieldAccessInCrossInline() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccessInCrossInline.kt");
        }

        @Test
        @TestMetadata("privateCall.kt")
        public void testPrivateCall() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateCall.kt");
        }

        @Test
        @TestMetadata("privateInCrossInline.kt")
        public void testPrivateInCrossInline() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInCrossInline.kt");
        }

        @Test
        @TestMetadata("privateInDefaultStubArgument.kt")
        public void testPrivateInDefaultStubArgument() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInDefaultStubArgument.kt");
        }

        @Test
        @TestMetadata("protectedInCrossinline.kt")
        public void testProtectedInCrossinline() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedInCrossinline.kt");
        }

        @Test
        @TestMetadata("protectedMembersFromSuper.kt")
        public void testProtectedMembersFromSuper() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedMembersFromSuper.kt");
        }

        @Test
        @TestMetadata("superCall.kt")
        public void testSuperCall() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superCall.kt");
        }

        @Test
        @TestMetadata("superInCrossInline.kt")
        public void testSuperInCrossInline() {
          runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superInCrossInline.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/trait")
    @TestDataPath("$PROJECT_ROOT")
    public class Trait {
      @Test
      public void testAllFilesPresentInTrait() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/trait"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("trait.kt")
      public void testTrait() {
        runTest("compiler/testData/codegen/boxInline/trait/trait.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/tryCatchFinally")
    @TestDataPath("$PROJECT_ROOT")
    public class TryCatchFinally {
      @Test
      public void testAllFilesPresentInTryCatchFinally() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/tryCatchFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt5863.kt")
      public void testKt5863() {
        runTest("compiler/testData/codegen/boxInline/tryCatchFinally/kt5863.kt");
      }

      @Test
      @TestMetadata("tryCatch.kt")
      public void testTryCatch() {
        runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch.kt");
      }

      @Test
      @TestMetadata("tryCatch2.kt")
      public void testTryCatch2() {
        runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch2.kt");
      }

      @Test
      @TestMetadata("tryCatchFinally.kt")
      public void testTryCatchFinally() {
        runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatchFinally.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/typeParameters")
    @TestDataPath("$PROJECT_ROOT")
    public class TypeParameters {
      @Test
      public void testAllFilesPresentInTypeParameters() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/typeParameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("anonymousObject.kt")
      public void testAnonymousObject() {
        runTest("compiler/testData/codegen/boxInline/typeParameters/anonymousObject.kt");
      }

      @Test
      @TestMetadata("basic.kt")
      public void testBasic() {
        runTest("compiler/testData/codegen/boxInline/typeParameters/basic.kt");
      }

      @Test
      @TestMetadata("projectionTypeArguments.kt")
      public void testProjectionTypeArguments() {
        runTest("compiler/testData/codegen/boxInline/typeParameters/projectionTypeArguments.kt");
      }

      @Test
      @TestMetadata("severalUpperBounds.kt")
      public void testSeveralUpperBounds() {
        runTest("compiler/testData/codegen/boxInline/typeParameters/severalUpperBounds.kt");
      }

      @Test
      @TestMetadata("typeArgFromGenericBaseClass.kt")
      public void testTypeArgFromGenericBaseClass() {
        runTest("compiler/testData/codegen/boxInline/typeParameters/typeArgFromGenericBaseClass.kt");
      }

      @Test
      @TestMetadata("uncheckedCastToNothing.kt")
      public void testUncheckedCastToNothing() {
        runTest("compiler/testData/codegen/boxInline/typeParameters/uncheckedCastToNothing.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/varargs")
    @TestDataPath("$PROJECT_ROOT")
    public class Varargs {
      @Test
      public void testAllFilesPresentInVarargs() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt17653.kt")
      public void testKt17653() {
        runTest("compiler/testData/codegen/boxInline/varargs/kt17653.kt");
      }

      @Test
      @TestMetadata("varargAndDefaultParameters.kt")
      public void testVarargAndDefaultParameters() {
        runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters.kt");
      }

      @Test
      @TestMetadata("varargAndDefaultParameters2.kt")
      public void testVarargAndDefaultParameters2() {
        runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters2.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxInline/wasm-new-exception-handling")
    @TestDataPath("$PROJECT_ROOT")
    public class Wasm_new_exception_handling {
      @Test
      public void testAllFilesPresentInWasm_new_exception_handling() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/wasm-new-exception-handling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/boxModernJdk")
  @TestDataPath("$PROJECT_ROOT")
  public class BoxModernJdk {
    @Test
    public void testAllFilesPresentInBoxModernJdk() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @Tag("<modernJava>")
    @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava11")
    @TestDataPath("$PROJECT_ROOT")
    public class TestsWithJava11 {
      @Test
      public void testAllFilesPresentInTestsWithJava11() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("concatDynamic.kt")
      public void testConcatDynamic() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic.kt");
      }

      @Test
      @TestMetadata("concatDynamic199Long.kt")
      public void testConcatDynamic199Long() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic199Long.kt");
      }

      @Test
      @TestMetadata("concatDynamic200.kt")
      public void testConcatDynamic200() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic200.kt");
      }

      @Test
      @TestMetadata("concatDynamic200Long.kt")
      public void testConcatDynamic200Long() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic200Long.kt");
      }

      @Test
      @TestMetadata("concatDynamic201.kt")
      public void testConcatDynamic201() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic201.kt");
      }

      @Test
      @TestMetadata("concatDynamicIndy199Long.kt")
      public void testConcatDynamicIndy199Long() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy199Long.kt");
      }

      @Test
      @TestMetadata("concatDynamicIndy200.kt")
      public void testConcatDynamicIndy200() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy200.kt");
      }

      @Test
      @TestMetadata("concatDynamicIndy200Long.kt")
      public void testConcatDynamicIndy200Long() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy200Long.kt");
      }

      @Test
      @TestMetadata("concatDynamicIndy201.kt")
      public void testConcatDynamicIndy201() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy201.kt");
      }

      @Test
      @TestMetadata("concatDynamicInlineClasses.kt")
      public void testConcatDynamicInlineClasses() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicInlineClasses.kt");
      }

      @Test
      @TestMetadata("concatDynamicSpecialSymbols.kt")
      public void testConcatDynamicSpecialSymbols() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicSpecialSymbols.kt");
      }

      @Test
      @TestMetadata("concatDynamicWithInline.kt")
      public void testConcatDynamicWithInline() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicWithInline.kt");
      }

      @Test
      @TestMetadata("kt36984.kt")
      public void testKt36984() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt36984.kt");
      }

      @Test
      @TestMetadata("kt47917.kt")
      public void testKt47917() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917.kt");
      }

      @Test
      @TestMetadata("kt47917_oldBackend.kt")
      public void testKt47917_oldBackend() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_oldBackend.kt");
      }

      @Test
      @TestMetadata("kt47917_russian.kt")
      public void testKt47917_russian() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_russian.kt");
      }

      @Test
      @TestMetadata("kt47917_surrogatePairs.kt")
      public void testKt47917_surrogatePairs() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_surrogatePairs.kt");
      }

      @Test
      @TestMetadata("varHandle.kt")
      public void testVarHandle() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/varHandle.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag")
      @TestDataPath("$PROJECT_ROOT")
      public class ReleaseFlag {
        @Test
        public void testAllFilesPresentInReleaseFlag() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer")
        @TestDataPath("$PROJECT_ROOT")
        public class ByteBuffer {
          @Test
          public void testAllFilesPresentInByteBuffer() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("byteBuffer.kt")
          public void testByteBuffer() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer.kt");
          }

          @Test
          @TestMetadata("byteBuffer_10.kt")
          public void testByteBuffer_10() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_10.kt");
          }

          @Test
          @TestMetadata("byteBuffer_11.kt")
          public void testByteBuffer_11() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_11.kt");
          }

          @Test
          @TestMetadata("byteBuffer_6.kt")
          public void testByteBuffer_6() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_6.kt");
          }

          @Test
          @TestMetadata("byteBuffer_8.kt")
          public void testByteBuffer_8() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_8.kt");
          }

          @Test
          @TestMetadata("byteBuffer_9.kt")
          public void testByteBuffer_9() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_9.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass")
        @TestDataPath("$PROJECT_ROOT")
        public class InnerClass {
          @Test
          public void testAllFilesPresentInInnerClass() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("threadState_10.kt")
          public void testThreadState_10() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_10.kt");
          }

          @Test
          @TestMetadata("threadState_11.kt")
          public void testThreadState_11() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_11.kt");
          }

          @Test
          @TestMetadata("threadState_8.kt")
          public void testThreadState_8() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_8.kt");
          }

          @Test
          @TestMetadata("threadState_9.kt")
          public void testThreadState_9() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_9.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective")
        @TestDataPath("$PROJECT_ROOT")
        public class Reflective {
          @Test
          public void testAllFilesPresentInReflective() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("reflective.kt")
          public void testReflective() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective.kt");
          }

          @Test
          @TestMetadata("reflective_10.kt")
          public void testReflective_10() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_10.kt");
          }

          @Test
          @TestMetadata("reflective_11.kt")
          public void testReflective_11() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_11.kt");
          }

          @Test
          @TestMetadata("reflective_6.kt")
          public void testReflective_6() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_6.kt");
          }

          @Test
          @TestMetadata("reflective_8.kt")
          public void testReflective_8() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_8.kt");
          }

          @Test
          @TestMetadata("reflective_9.kt")
          public void testReflective_9() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_9.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava")
        @TestDataPath("$PROJECT_ROOT")
        public class WithJava {
          @Test
          public void testAllFilesPresentInWithJava() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("withJava_10.kt")
          public void testWithJava_10() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_10.kt");
          }

          @Test
          @TestMetadata("withJava_11.kt")
          public void testWithJava_11() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_11.kt");
          }

          @Test
          @TestMetadata("withJava_6.kt")
          public void testWithJava_6() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_6.kt");
          }

          @Test
          @TestMetadata("withJava_8.kt")
          public void testWithJava_8() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_8.kt");
          }

          @Test
          @TestMetadata("withJava_9.kt")
          public void testWithJava_9() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_9.kt");
          }
        }
      }
    }

    @Nested
    @Tag("<modernJava>")
    @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava17")
    @TestDataPath("$PROJECT_ROOT")
    public class TestsWithJava17 {
      @Test
      public void testAllFilesPresentInTestsWithJava17() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava17/records")
      @TestDataPath("$PROJECT_ROOT")
      public class Records {
        @Test
        public void testAllFilesPresentInRecords() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/records"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("binaryRecord.kt")
        public void testBinaryRecord() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/binaryRecord.kt");
        }

        @Test
        @TestMetadata("bytecodeShapeForJava.kt")
        public void testBytecodeShapeForJava() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/bytecodeShapeForJava.kt");
        }

        @Test
        @TestMetadata("callableReferenceToGenericRecord.kt")
        public void testCallableReferenceToGenericRecord() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/callableReferenceToGenericRecord.kt");
        }

        @Test
        @TestMetadata("collectionSizeOverrides.kt")
        public void testCollectionSizeOverrides() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/collectionSizeOverrides.kt");
        }

        @Test
        @TestMetadata("dataJvmRecord.kt")
        public void testDataJvmRecord() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/dataJvmRecord.kt");
        }

        @Test
        @TestMetadata("jvmRecordBinary.kt")
        public void testJvmRecordBinary() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/jvmRecordBinary.kt");
        }

        @Test
        @TestMetadata("kt54573.kt")
        public void testKt54573() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/kt54573.kt");
        }

        @Test
        @TestMetadata("propertiesOverrides.kt")
        public void testPropertiesOverrides() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverrides.kt");
        }

        @Test
        @TestMetadata("propertiesOverridesAllCompatibilityJvmDefault.kt")
        public void testPropertiesOverridesAllCompatibilityJvmDefault() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverridesAllCompatibilityJvmDefault.kt");
        }

        @Test
        @TestMetadata("propertiesOverridesAllJvmDefault.kt")
        public void testPropertiesOverridesAllJvmDefault() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverridesAllJvmDefault.kt");
        }

        @Test
        @TestMetadata("recordDifferentPropertyOverride.kt")
        public void testRecordDifferentPropertyOverride() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordDifferentPropertyOverride.kt");
        }

        @Test
        @TestMetadata("recordDifferentSyntheticProperty.kt")
        public void testRecordDifferentSyntheticProperty() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordDifferentSyntheticProperty.kt");
        }

        @Test
        @TestMetadata("recordPropertyAccess.kt")
        public void testRecordPropertyAccess() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordPropertyAccess.kt");
        }

        @Test
        @TestMetadata("recordWithCompanion.kt")
        public void testRecordWithCompanion() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordWithCompanion.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag")
      @TestDataPath("$PROJECT_ROOT")
      public class ReleaseFlag {
        @Test
        public void testAllFilesPresentInReleaseFlag() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer")
        @TestDataPath("$PROJECT_ROOT")
        public class ByteBuffer {
          @Test
          public void testAllFilesPresentInByteBuffer() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("byteBuffer.kt")
          public void testByteBuffer() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer.kt");
          }

          @Test
          @TestMetadata("byteBuffer_10.kt")
          public void testByteBuffer_10() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_10.kt");
          }

          @Test
          @TestMetadata("byteBuffer_11.kt")
          public void testByteBuffer_11() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_11.kt");
          }

          @Test
          @TestMetadata("byteBuffer_12.kt")
          public void testByteBuffer_12() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_12.kt");
          }

          @Test
          @TestMetadata("byteBuffer_13.kt")
          public void testByteBuffer_13() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_13.kt");
          }

          @Test
          @TestMetadata("byteBuffer_14.kt")
          public void testByteBuffer_14() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_14.kt");
          }

          @Test
          @TestMetadata("byteBuffer_15.kt")
          public void testByteBuffer_15() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_15.kt");
          }

          @Test
          @TestMetadata("byteBuffer_16.kt")
          public void testByteBuffer_16() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_16.kt");
          }

          @Test
          @TestMetadata("byteBuffer_17.kt")
          public void testByteBuffer_17() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_17.kt");
          }

          @Test
          @TestMetadata("byteBuffer_8.kt")
          public void testByteBuffer_8() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_8.kt");
          }

          @Test
          @TestMetadata("byteBuffer_9.kt")
          public void testByteBuffer_9() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_9.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable")
        @TestDataPath("$PROJECT_ROOT")
        public class Constable {
          @Test
          public void testAllFilesPresentInConstable() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("constable.kt")
          public void testConstable() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable.kt");
          }

          @Test
          @TestMetadata("constable_10.kt")
          public void testConstable_10() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_10.kt");
          }

          @Test
          @TestMetadata("constable_11.kt")
          public void testConstable_11() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_11.kt");
          }

          @Test
          @TestMetadata("constable_12.kt")
          public void testConstable_12() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_12.kt");
          }

          @Test
          @TestMetadata("constable_13.kt")
          public void testConstable_13() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_13.kt");
          }

          @Test
          @TestMetadata("constable_14.kt")
          public void testConstable_14() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_14.kt");
          }

          @Test
          @TestMetadata("constable_15.kt")
          public void testConstable_15() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_15.kt");
          }

          @Test
          @TestMetadata("constable_16.kt")
          public void testConstable_16() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_16.kt");
          }

          @Test
          @TestMetadata("constable_17.kt")
          public void testConstable_17() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_17.kt");
          }

          @Test
          @TestMetadata("constable_8.kt")
          public void testConstable_8() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_8.kt");
          }

          @Test
          @TestMetadata("constable_9.kt")
          public void testConstable_9() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_9.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass")
        @TestDataPath("$PROJECT_ROOT")
        public class InnerClass {
          @Test
          public void testAllFilesPresentInInnerClass() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("threadState_10.kt")
          public void testThreadState_10() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_10.kt");
          }

          @Test
          @TestMetadata("threadState_11.kt")
          public void testThreadState_11() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_11.kt");
          }

          @Test
          @TestMetadata("threadState_12.kt")
          public void testThreadState_12() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_12.kt");
          }

          @Test
          @TestMetadata("threadState_13.kt")
          public void testThreadState_13() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_13.kt");
          }

          @Test
          @TestMetadata("threadState_14.kt")
          public void testThreadState_14() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_14.kt");
          }

          @Test
          @TestMetadata("threadState_15.kt")
          public void testThreadState_15() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_15.kt");
          }

          @Test
          @TestMetadata("threadState_16.kt")
          public void testThreadState_16() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_16.kt");
          }

          @Test
          @TestMetadata("threadState_17.kt")
          public void testThreadState_17() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_17.kt");
          }

          @Test
          @TestMetadata("threadState_8.kt")
          public void testThreadState_8() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_8.kt");
          }

          @Test
          @TestMetadata("threadState_9.kt")
          public void testThreadState_9() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_9.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava")
        @TestDataPath("$PROJECT_ROOT")
        public class WithJava {
          @Test
          public void testAllFilesPresentInWithJava() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("withJava_10.kt")
          public void testWithJava_10() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_10.kt");
          }

          @Test
          @TestMetadata("withJava_11.kt")
          public void testWithJava_11() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_11.kt");
          }

          @Test
          @TestMetadata("withJava_12.kt")
          public void testWithJava_12() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_12.kt");
          }

          @Test
          @TestMetadata("withJava_13.kt")
          public void testWithJava_13() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_13.kt");
          }

          @Test
          @TestMetadata("withJava_14.kt")
          public void testWithJava_14() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_14.kt");
          }

          @Test
          @TestMetadata("withJava_15.kt")
          public void testWithJava_15() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_15.kt");
          }

          @Test
          @TestMetadata("withJava_16.kt")
          public void testWithJava_16() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_16.kt");
          }

          @Test
          @TestMetadata("withJava_17.kt")
          public void testWithJava_17() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_17.kt");
          }

          @Test
          @TestMetadata("withJava_8.kt")
          public void testWithJava_8() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_8.kt");
          }

          @Test
          @TestMetadata("withJava_9.kt")
          public void testWithJava_9() {
            runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_9.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed")
      @TestDataPath("$PROJECT_ROOT")
      public class Sealed {
        @Test
        public void testAllFilesPresentInSealed() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("compiledJavaSealedClass.kt")
        public void testCompiledJavaSealedClass() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/compiledJavaSealedClass.kt");
        }

        @Test
        @TestMetadata("compiledJavaSealedInterface.kt")
        public void testCompiledJavaSealedInterface() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/compiledJavaSealedInterface.kt");
        }

        @Test
        @TestMetadata("javaExhaustiveWhenOnKotlinSealedClass.kt")
        public void testJavaExhaustiveWhenOnKotlinSealedClass() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaExhaustiveWhenOnKotlinSealedClass.kt");
        }

        @Test
        @TestMetadata("javaRecordsViaKotlinReflection.kt")
        public void testJavaRecordsViaKotlinReflection() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaRecordsViaKotlinReflection.kt");
        }

        @Test
        @TestMetadata("javaSealedClass.kt")
        public void testJavaSealedClass() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaSealedClass.kt");
        }

        @Test
        @TestMetadata("javaSealedInterface.kt")
        public void testJavaSealedInterface() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaSealedInterface.kt");
        }

        @Test
        @TestMetadata("kotlinExhaustiveWhenOnJavaSealedClass.kt")
        public void testKotlinExhaustiveWhenOnJavaSealedClass() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/kotlinExhaustiveWhenOnJavaSealedClass.kt");
        }

        @Test
        @TestMetadata("permittedSubclassesOfSealedKotlinClass.kt")
        public void testPermittedSubclassesOfSealedKotlinClass() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/permittedSubclassesOfSealedKotlinClass.kt");
        }

        @Test
        @TestMetadata("sealedJavaClassViaJavaReflection.kt")
        public void testSealedJavaClassViaJavaReflection() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaClassViaJavaReflection.kt");
        }

        @Test
        @TestMetadata("sealedJavaClassViaKotlinReflection.kt")
        public void testSealedJavaClassViaKotlinReflection() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaClassViaKotlinReflection.kt");
        }

        @Test
        @TestMetadata("sealedJavaInterfaceViaKotlinReflection.kt")
        public void testSealedJavaInterfaceViaKotlinReflection() {
          runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaInterfaceViaKotlinReflection.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/boxModernJdk/testsWithJava21")
    @TestDataPath("$PROJECT_ROOT")
    public class TestsWithJava21 {
      @Test
      @TestMetadata("addRemoveOnMutableList.kt")
      public void testAddRemoveOnMutableList() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava21/addRemoveOnMutableList.kt");
      }

      @Test
      public void testAllFilesPresentInTestsWithJava21() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava21"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("EnumsWithNonNullaryConstructors.kt")
      public void testEnumsWithNonNullaryConstructors() {
        runTest("compiler/testData/codegen/boxModernJdk/testsWithJava21/EnumsWithNonNullaryConstructors.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeText")
  @TestDataPath("$PROJECT_ROOT")
  public class BytecodeText {
    @Test
    @TestMetadata("accessorForOverridenVal.kt")
    public void testAccessorForOverridenVal() {
      runTest("compiler/testData/codegen/bytecodeText/accessorForOverridenVal.kt");
    }

    @Test
    @TestMetadata("accessorForProtected.kt")
    public void testAccessorForProtected() {
      runTest("compiler/testData/codegen/bytecodeText/accessorForProtected.kt");
    }

    @Test
    @TestMetadata("accessorNaming.kt")
    public void testAccessorNaming() {
      runTest("compiler/testData/codegen/bytecodeText/accessorNaming.kt");
    }

    @Test
    public void testAllFilesPresentInBytecodeText() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotationDefaultValue.kt")
    public void testAnnotationDefaultValue() {
      runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValue.kt");
    }

    @Test
    @TestMetadata("annotationDefaultValueOfUnsigned.kt")
    public void testAnnotationDefaultValueOfUnsigned() {
      runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValueOfUnsigned.kt");
    }

    @Test
    @TestMetadata("annotationJavaRetentionPolicyRuntime.kt")
    public void testAnnotationJavaRetentionPolicyRuntime() {
      runTest("compiler/testData/codegen/bytecodeText/annotationJavaRetentionPolicyRuntime.kt");
    }

    @Test
    @TestMetadata("annotationRetentionPolicyClass.kt")
    public void testAnnotationRetentionPolicyClass() {
      runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyClass.kt");
    }

    @Test
    @TestMetadata("annotationRetentionPolicyRuntime.kt")
    public void testAnnotationRetentionPolicyRuntime() {
      runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyRuntime.kt");
    }

    @Test
    @TestMetadata("annotationRetentionPolicySource.kt")
    public void testAnnotationRetentionPolicySource() {
      runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicySource.kt");
    }

    @Test
    @TestMetadata("boxedNotNumberTypeOnUnboxing.kt")
    public void testBoxedNotNumberTypeOnUnboxing() {
      runTest("compiler/testData/codegen/bytecodeText/boxedNotNumberTypeOnUnboxing.kt");
    }

    @Test
    @TestMetadata("bridgeForFakeOverride.kt")
    public void testBridgeForFakeOverride() {
      runTest("compiler/testData/codegen/bytecodeText/bridgeForFakeOverride.kt");
    }

    @Test
    @TestMetadata("charConstant.kt")
    public void testCharConstant() {
      runTest("compiler/testData/codegen/bytecodeText/charConstant.kt");
    }

    @Test
    @TestMetadata("checkcastOnThrow.kt")
    public void testCheckcastOnThrow() {
      runTest("compiler/testData/codegen/bytecodeText/checkcastOnThrow.kt");
    }

    @Test
    @TestMetadata("collectionStubs.kt")
    public void testCollectionStubs() {
      runTest("compiler/testData/codegen/bytecodeText/collectionStubs.kt");
    }

    @Test
    @TestMetadata("componentEvaluatesOnlyOnce.kt")
    public void testComponentEvaluatesOnlyOnce() {
      runTest("compiler/testData/codegen/bytecodeText/componentEvaluatesOnlyOnce.kt");
    }

    @Test
    @TestMetadata("constClosureOptimization.kt")
    public void testConstClosureOptimization() {
      runTest("compiler/testData/codegen/bytecodeText/constClosureOptimization.kt");
    }

    @Test
    @TestMetadata("defaultMethodBody.kt")
    public void testDefaultMethodBody() {
      runTest("compiler/testData/codegen/bytecodeText/defaultMethodBody.kt");
    }

    @Test
    @TestMetadata("doNotStoreNullForTmpInDestructuring.kt")
    public void testDoNotStoreNullForTmpInDestructuring() {
      runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullForTmpInDestructuring.kt");
    }

    @Test
    @TestMetadata("doNotStoreNullsForCapturedVars.kt")
    public void testDoNotStoreNullsForCapturedVars() {
      runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullsForCapturedVars.kt");
    }

    @Test
    @TestMetadata("falseSmartCast.kt")
    public void testFalseSmartCast() {
      runTest("compiler/testData/codegen/bytecodeText/falseSmartCast.kt");
    }

    @Test
    @TestMetadata("flagsInMultiFileInherit.kt")
    public void testFlagsInMultiFileInherit() {
      runTest("compiler/testData/codegen/bytecodeText/flagsInMultiFileInherit.kt");
    }

    @Test
    @TestMetadata("iincGeneration.kt")
    public void testIincGeneration() {
      runTest("compiler/testData/codegen/bytecodeText/iincGeneration.kt");
    }

    @Test
    @TestMetadata("inheritedPropertyAnnotations.kt")
    public void testInheritedPropertyAnnotations() {
      runTest("compiler/testData/codegen/bytecodeText/inheritedPropertyAnnotations.kt");
    }

    @Test
    @TestMetadata("inlineFromOtherModule.kt")
    public void testInlineFromOtherModule() {
      runTest("compiler/testData/codegen/bytecodeText/inlineFromOtherModule.kt");
    }

    @Test
    @TestMetadata("inlineJavaConstantFromSubclass.kt")
    public void testInlineJavaConstantFromSubclass() {
      runTest("compiler/testData/codegen/bytecodeText/inlineJavaConstantFromSubclass.kt");
    }

    @Test
    @TestMetadata("inlineJavaStaticFields.kt")
    public void testInlineJavaStaticFields() {
      runTest("compiler/testData/codegen/bytecodeText/inlineJavaStaticFields.kt");
    }

    @Test
    @TestMetadata("inlineProtectedJavaConstantFromOtherPackage.kt")
    public void testInlineProtectedJavaConstantFromOtherPackage() {
      runTest("compiler/testData/codegen/bytecodeText/inlineProtectedJavaConstantFromOtherPackage.kt");
    }

    @Test
    @TestMetadata("intConstantNotNull.kt")
    public void testIntConstantNotNull() {
      runTest("compiler/testData/codegen/bytecodeText/intConstantNotNull.kt");
    }

    @Test
    @TestMetadata("intConstantNullable.kt")
    public void testIntConstantNullable() {
      runTest("compiler/testData/codegen/bytecodeText/intConstantNullable.kt");
    }

    @Test
    @TestMetadata("intConstantNullableSafeCall.kt")
    public void testIntConstantNullableSafeCall() {
      runTest("compiler/testData/codegen/bytecodeText/intConstantNullableSafeCall.kt");
    }

    @Test
    @TestMetadata("intConstantSafeCall.kt")
    public void testIntConstantSafeCall() {
      runTest("compiler/testData/codegen/bytecodeText/intConstantSafeCall.kt");
    }

    @Test
    @TestMetadata("intProgressionNoBoxing.kt")
    public void testIntProgressionNoBoxing() {
      runTest("compiler/testData/codegen/bytecodeText/intProgressionNoBoxing.kt");
    }

    @Test
    @TestMetadata("intRangeNoBoxing.kt")
    public void testIntRangeNoBoxing() {
      runTest("compiler/testData/codegen/bytecodeText/intRangeNoBoxing.kt");
    }

    @Test
    @TestMetadata("interfaceDefaultImpl.kt")
    public void testInterfaceDefaultImpl() {
      runTest("compiler/testData/codegen/bytecodeText/interfaceDefaultImpl.kt");
    }

    @Test
    @TestMetadata("isArrayOf.kt")
    public void testIsArrayOf() {
      runTest("compiler/testData/codegen/bytecodeText/isArrayOf.kt");
    }

    @Test
    @TestMetadata("javaExtensionPropertyIntrinsic.kt")
    public void testJavaExtensionPropertyIntrinsic() {
      runTest("compiler/testData/codegen/bytecodeText/javaExtensionPropertyIntrinsic.kt");
    }

    @Test
    @TestMetadata("javaFields.kt")
    public void testJavaFields() {
      runTest("compiler/testData/codegen/bytecodeText/javaFields.kt");
    }

    @Test
    @TestMetadata("javaFieldsWithIntersectionTypes.kt")
    public void testJavaFieldsWithIntersectionTypes() {
      runTest("compiler/testData/codegen/bytecodeText/javaFieldsWithIntersectionTypes.kt");
    }

    @Test
    @TestMetadata("javaStatics.kt")
    public void testJavaStatics() {
      runTest("compiler/testData/codegen/bytecodeText/javaStatics.kt");
    }

    @Test
    @TestMetadata("jvmField.kt")
    public void testJvmField() {
      runTest("compiler/testData/codegen/bytecodeText/jvmField.kt");
    }

    @Test
    @TestMetadata("jvmStaticInternalMangling.kt")
    public void testJvmStaticInternalMangling() {
      runTest("compiler/testData/codegen/bytecodeText/jvmStaticInternalMangling.kt");
    }

    @Test
    @TestMetadata("kt10259.kt")
    public void testKt10259() {
      runTest("compiler/testData/codegen/bytecodeText/kt10259.kt");
    }

    @Test
    @TestMetadata("kt10259_2.kt")
    public void testKt10259_2() {
      runTest("compiler/testData/codegen/bytecodeText/kt10259_2.kt");
    }

    @Test
    @TestMetadata("kt10259_3.kt")
    public void testKt10259_3() {
      runTest("compiler/testData/codegen/bytecodeText/kt10259_3.kt");
    }

    @Test
    @TestMetadata("kt2202.kt")
    public void testKt2202() {
      runTest("compiler/testData/codegen/bytecodeText/kt2202.kt");
    }

    @Test
    @TestMetadata("kt2887.kt")
    public void testKt2887() {
      runTest("compiler/testData/codegen/bytecodeText/kt2887.kt");
    }

    @Test
    @TestMetadata("kt3845.kt")
    public void testKt3845() {
      runTest("compiler/testData/codegen/bytecodeText/kt3845.kt");
    }

    @Test
    @TestMetadata("kt46615.kt")
    public void testKt46615() {
      runTest("compiler/testData/codegen/bytecodeText/kt46615.kt");
    }

    @Test
    @TestMetadata("kt48367.kt")
    public void testKt48367() {
      runTest("compiler/testData/codegen/bytecodeText/kt48367.kt");
    }

    @Test
    @TestMetadata("kt5016.kt")
    public void testKt5016() {
      runTest("compiler/testData/codegen/bytecodeText/kt5016.kt");
    }

    @Test
    @TestMetadata("kt5016int.kt")
    public void testKt5016int() {
      runTest("compiler/testData/codegen/bytecodeText/kt5016int.kt");
    }

    @Test
    @TestMetadata("kt5016intOrNull.kt")
    public void testKt5016intOrNull() {
      runTest("compiler/testData/codegen/bytecodeText/kt5016intOrNull.kt");
    }

    @Test
    @TestMetadata("kt56923.kt")
    public void testKt56923() {
      runTest("compiler/testData/codegen/bytecodeText/kt56923.kt");
    }

    @Test
    @TestMetadata("kt7188.kt")
    public void testKt7188() {
      runTest("compiler/testData/codegen/bytecodeText/kt7188.kt");
    }

    @Test
    @TestMetadata("kt7769.kt")
    public void testKt7769() {
      runTest("compiler/testData/codegen/bytecodeText/kt7769.kt");
    }

    @Test
    @TestMetadata("kt9603.kt")
    public void testKt9603() {
      runTest("compiler/testData/codegen/bytecodeText/kt9603.kt");
    }

    @Test
    @TestMetadata("mapGetOrDefault.kt")
    public void testMapGetOrDefault() {
      runTest("compiler/testData/codegen/bytecodeText/mapGetOrDefault.kt");
    }

    @Test
    @TestMetadata("maxStackAfterOptimizations.kt")
    public void testMaxStackAfterOptimizations() {
      runTest("compiler/testData/codegen/bytecodeText/maxStackAfterOptimizations.kt");
    }

    @Test
    @TestMetadata("mergedProgression.kt")
    public void testMergedProgression() {
      runTest("compiler/testData/codegen/bytecodeText/mergedProgression.kt");
    }

    @Test
    @TestMetadata("noAccessorForProtectedInSamePackageCrossinline.kt")
    public void testNoAccessorForProtectedInSamePackageCrossinline() {
      runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackageCrossinline.kt");
    }

    @Test
    @TestMetadata("noAccessorForProtectedInSamePackagePrivateInline.kt")
    public void testNoAccessorForProtectedInSamePackagePrivateInline() {
      runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackagePrivateInline.kt");
    }

    @Test
    @TestMetadata("noFlagAnnotations.kt")
    public void testNoFlagAnnotations() {
      runTest("compiler/testData/codegen/bytecodeText/noFlagAnnotations.kt");
    }

    @Test
    @TestMetadata("noNumberCheckCast.kt")
    public void testNoNumberCheckCast() {
      runTest("compiler/testData/codegen/bytecodeText/noNumberCheckCast.kt");
    }

    @Test
    @TestMetadata("noSuperCheckInDefaultConstuctor.kt")
    public void testNoSuperCheckInDefaultConstuctor() {
      runTest("compiler/testData/codegen/bytecodeText/noSuperCheckInDefaultConstuctor.kt");
    }

    @Test
    @TestMetadata("noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt")
    public void testNoSyntheticAccessorForPrivateCompanionObjectWhenNotRequired() {
      runTest("compiler/testData/codegen/bytecodeText/noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt");
    }

    @Test
    @TestMetadata("noWrapperForMethodReturningPrimitive.kt")
    public void testNoWrapperForMethodReturningPrimitive() {
      runTest("compiler/testData/codegen/bytecodeText/noWrapperForMethodReturningPrimitive.kt");
    }

    @Test
    @TestMetadata("nopsInDoWhile.kt")
    public void testNopsInDoWhile() {
      runTest("compiler/testData/codegen/bytecodeText/nopsInDoWhile.kt");
    }

    @Test
    @TestMetadata("partMembersCall.kt")
    public void testPartMembersCall() {
      runTest("compiler/testData/codegen/bytecodeText/partMembersCall.kt");
    }

    @Test
    @TestMetadata("partMembersInline.kt")
    public void testPartMembersInline() {
      runTest("compiler/testData/codegen/bytecodeText/partMembersInline.kt");
    }

    @Test
    @TestMetadata("preEvaluateInlineJavaStaticFields.kt")
    public void testPreEvaluateInlineJavaStaticFields() {
      runTest("compiler/testData/codegen/bytecodeText/preEvaluateInlineJavaStaticFields.kt");
    }

    @Test
    @TestMetadata("prefixIntVarIncrement.kt")
    public void testPrefixIntVarIncrement() {
      runTest("compiler/testData/codegen/bytecodeText/prefixIntVarIncrement.kt");
    }

    @Test
    @TestMetadata("privateDefaultArgs.kt")
    public void testPrivateDefaultArgs() {
      runTest("compiler/testData/codegen/bytecodeText/privateDefaultArgs.kt");
    }

    @Test
    @TestMetadata("redundantGotoRemoving.kt")
    public void testRedundantGotoRemoving() {
      runTest("compiler/testData/codegen/bytecodeText/redundantGotoRemoving.kt");
    }

    @Test
    @TestMetadata("redundantInitializer.kt")
    public void testRedundantInitializer() {
      runTest("compiler/testData/codegen/bytecodeText/redundantInitializer.kt");
    }

    @Test
    @TestMetadata("redundantInitializerNumber.kt")
    public void testRedundantInitializerNumber() {
      runTest("compiler/testData/codegen/bytecodeText/redundantInitializerNumber.kt");
    }

    @Test
    @TestMetadata("redundantValInitializer.kt")
    public void testRedundantValInitializer() {
      runTest("compiler/testData/codegen/bytecodeText/redundantValInitializer.kt");
    }

    @Test
    @TestMetadata("redundantValInitializerInObject.kt")
    public void testRedundantValInitializerInObject() {
      runTest("compiler/testData/codegen/bytecodeText/redundantValInitializerInObject.kt");
    }

    @Test
    @TestMetadata("redundantVarInitializer.kt")
    public void testRedundantVarInitializer() {
      runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializer.kt");
    }

    @Test
    @TestMetadata("redundantVarInitializerInObject.kt")
    public void testRedundantVarInitializerInObject() {
      runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializerInObject.kt");
    }

    @Test
    @TestMetadata("reifiedAsCheck.kt")
    public void testReifiedAsCheck() {
      runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheck.kt");
    }

    @Test
    @TestMetadata("reifiedAsCheckWithNullable.kt")
    public void testReifiedAsCheckWithNullable() {
      runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheckWithNullable.kt");
    }

    @Test
    @TestMetadata("reifiedIsCheck.kt")
    public void testReifiedIsCheck() {
      runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheck.kt");
    }

    @Test
    @TestMetadata("reifiedIsCheckWithNullable.kt")
    public void testReifiedIsCheckWithNullable() {
      runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheckWithNullable.kt");
    }

    @Test
    @TestMetadata("reifiedSafeAsCheck.kt")
    public void testReifiedSafeAsCheck() {
      runTest("compiler/testData/codegen/bytecodeText/reifiedSafeAsCheck.kt");
    }

    @Test
    @TestMetadata("safeAsWithMutable.kt")
    public void testSafeAsWithMutable() {
      runTest("compiler/testData/codegen/bytecodeText/safeAsWithMutable.kt");
    }

    @Test
    @TestMetadata("superFlagInMultiFileFacade.kt")
    public void testSuperFlagInMultiFileFacade() {
      runTest("compiler/testData/codegen/bytecodeText/superFlagInMultiFileFacade.kt");
    }

    @Test
    @TestMetadata("superToString.kt")
    public void testSuperToString() {
      runTest("compiler/testData/codegen/bytecodeText/superToString.kt");
    }

    @Test
    @TestMetadata("suspendCoroutineUninterceptedOrReturn.kt")
    public void testSuspendCoroutineUninterceptedOrReturn() {
      runTest("compiler/testData/codegen/bytecodeText/suspendCoroutineUninterceptedOrReturn.kt");
    }

    @Test
    @TestMetadata("topLevelFunWithDefaultArgs.kt")
    public void testTopLevelFunWithDefaultArgs() {
      runTest("compiler/testData/codegen/bytecodeText/topLevelFunWithDefaultArgs.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    public class ArgumentOrder {
      @Test
      public void testAllFilesPresentInArgumentOrder() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("sameOrder.kt")
      public void testSameOrder() {
        runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrder.kt");
      }

      @Test
      @TestMetadata("sameOrderWithDefault.kt")
      public void testSameOrderWithDefault() {
        runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrderWithDefault.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/assert")
    @TestDataPath("$PROJECT_ROOT")
    public class Assert {
      @Test
      public void testAllFilesPresentInAssert() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("jvmCrossinline.kt")
      public void testJvmCrossinline() {
        runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinline.kt");
      }

      @Test
      @TestMetadata("jvmCrossinlineAssertInLambda.kt")
      public void testJvmCrossinlineAssertInLambda() {
        runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinlineAssertInLambda.kt");
      }

      @Test
      @TestMetadata("jvmInline.kt")
      public void testJvmInline() {
        runTest("compiler/testData/codegen/bytecodeText/assert/jvmInline.kt");
      }

      @Test
      @TestMetadata("jvmInlineLambda.kt")
      public void testJvmInlineLambda() {
        runTest("compiler/testData/codegen/bytecodeText/assert/jvmInlineLambda.kt");
      }

      @Test
      @TestMetadata("jvmNestedClass.kt")
      public void testJvmNestedClass() {
        runTest("compiler/testData/codegen/bytecodeText/assert/jvmNestedClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/boxing")
    @TestDataPath("$PROJECT_ROOT")
    public class Boxing {
      @Test
      public void testAllFilesPresentInBoxing() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("crossinlineSuspend.kt")
      public void testCrossinlineSuspend() {
        runTest("compiler/testData/codegen/bytecodeText/boxing/crossinlineSuspend.kt");
      }

      @Test
      @TestMetadata("inlineSuspend.kt")
      public void testInlineSuspend() {
        runTest("compiler/testData/codegen/bytecodeText/boxing/inlineSuspend.kt");
      }

      @Test
      @TestMetadata("suspend.kt")
      public void testSuspend() {
        runTest("compiler/testData/codegen/bytecodeText/boxing/suspend.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class BoxingOptimization {
      @Test
      public void testAllFilesPresentInBoxingOptimization() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("boxingAndEquals.kt")
      public void testBoxingAndEquals() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/boxingAndEquals.kt");
      }

      @Test
      @TestMetadata("casts.kt")
      public void testCasts() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/casts.kt");
      }

      @Test
      @TestMetadata("checkcastAndInstanceOf.kt")
      public void testCheckcastAndInstanceOf() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf.kt");
      }

      @Test
      @TestMetadata("fold.kt")
      public void testFold() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/fold.kt");
      }

      @Test
      @TestMetadata("hashCodeOnNonNull.kt")
      public void testHashCodeOnNonNull() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/hashCodeOnNonNull.kt");
      }

      @Test
      @TestMetadata("inlineClassesAndInlinedLambda.kt")
      public void testInlineClassesAndInlinedLambda() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/inlineClassesAndInlinedLambda.kt");
      }

      @Test
      @TestMetadata("intCompareTo.kt")
      public void testIntCompareTo() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/intCompareTo.kt");
      }

      @Test
      @TestMetadata("kClassInAnnotation.kt")
      public void testKClassInAnnotation() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotation.kt");
      }

      @Test
      @TestMetadata("kClassInAnnotationEscaping.kt")
      public void testKClassInAnnotationEscaping() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotationEscaping.kt");
      }

      @Test
      @TestMetadata("kt15862.kt")
      public void testKt15862() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862.kt");
      }

      @Test
      @TestMetadata("kt15862_2.kt")
      public void testKt15862_2() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862_2.kt");
      }

      @Test
      @TestMetadata("kt6842.kt")
      public void testKt6842() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt6842.kt");
      }

      @Test
      @TestMetadata("kt7224.kt")
      public void testKt7224() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt7224.kt");
      }

      @Test
      @TestMetadata("maxMinByOrNull.kt")
      public void testMaxMinByOrNull() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/maxMinByOrNull.kt");
      }

      @Test
      @TestMetadata("nullCheck.kt")
      public void testNullCheck() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/nullCheck.kt");
      }

      @Test
      @TestMetadata("progressions.kt")
      public void testProgressions() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/progressions.kt");
      }

      @Test
      @TestMetadata("safeCallToPrimitiveEquality1.kt")
      public void testSafeCallToPrimitiveEquality1() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality1.kt");
      }

      @Test
      @TestMetadata("safeCallToPrimitiveEquality2.kt")
      public void testSafeCallToPrimitiveEquality2() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality2.kt");
      }

      @Test
      @TestMetadata("safeCallToPrimitiveEquality3.kt")
      public void testSafeCallToPrimitiveEquality3() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality3.kt");
      }

      @Test
      @TestMetadata("safeCallWithElvis.kt")
      public void testSafeCallWithElvis() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvis.kt");
      }

      @Test
      @TestMetadata("safeCallWithElvisMultipleFiles.kt")
      public void testSafeCallWithElvisMultipleFiles() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
      }

      @Test
      @TestMetadata("severalInlines.kt")
      public void testSeveralInlines() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/severalInlines.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simple.kt");
      }

      @Test
      @TestMetadata("simpleUninitializedMerge.kt")
      public void testSimpleUninitializedMerge() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simpleUninitializedMerge.kt");
      }

      @Test
      @TestMetadata("suspendBoxing.kt")
      public void testSuspendBoxing() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/suspendBoxing.kt");
      }

      @Test
      @TestMetadata("unsafeRemoving.kt")
      public void testUnsafeRemoving() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsafeRemoving.kt");
      }

      @Test
      @TestMetadata("unsignedRangeIteratorSpecialization.kt")
      public void testUnsignedRangeIteratorSpecialization() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsignedRangeIteratorSpecialization.kt");
      }

      @Test
      @TestMetadata("variableClash.kt")
      public void testVariableClash() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variableClash.kt");
      }

      @Test
      @TestMetadata("variables.kt")
      public void testVariables() {
        runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variables.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions")
    @TestDataPath("$PROJECT_ROOT")
    public class BuiltinFunctions {
      @Test
      public void testAllFilesPresentInBuiltinFunctions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("charSequence.kt")
      public void testCharSequence() {
        runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/charSequence.kt");
      }

      @Test
      @TestMetadata("contains.kt")
      public void testContains() {
        runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/contains.kt");
      }

      @Test
      @TestMetadata("removeAt.kt")
      public void testRemoveAt() {
        runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/removeAt.kt");
      }

      @Test
      @TestMetadata("size.kt")
      public void testSize() {
        runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/size.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge")
      @TestDataPath("$PROJECT_ROOT")
      public class GenericParameterBridge {
        @Test
        @TestMetadata("abstractList.kt")
        public void testAbstractList() {
          runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/abstractList.kt");
        }

        @Test
        public void testAllFilesPresentInGenericParameterBridge() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("IntMC.kt")
        public void testIntMC() {
          runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/IntMC.kt");
        }

        @Test
        @TestMetadata("mutableCollection.kt")
        public void testMutableCollection() {
          runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableCollection.kt");
        }

        @Test
        @TestMetadata("mutableSetInterfaces.kt")
        public void testMutableSetInterfaces() {
          runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableSetInterfaces.kt");
        }

        @Test
        @TestMetadata("notNullAnyMC.kt")
        public void testNotNullAnyMC() {
          runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullAnyMC.kt");
        }

        @Test
        @TestMetadata("notNullParamMC.kt")
        public void testNotNullParamMC() {
          runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullParamMC.kt");
        }

        @Test
        @TestMetadata("nullableAnyMC.kt")
        public void testNullableAnyMC() {
          runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/nullableAnyMC.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReference {
      @Test
      public void testAllFilesPresentInCallableReference() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("boundFieldReferenceInInline.kt")
      public void testBoundFieldReferenceInInline() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFieldReferenceInInline.kt");
      }

      @Test
      @TestMetadata("boundFunReferenceInInline.kt")
      public void testBoundFunReferenceInInline() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFunReferenceInInline.kt");
      }

      @Test
      @TestMetadata("boundPropertyReferenceInInline.kt")
      public void testBoundPropertyReferenceInInline() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/boundPropertyReferenceInInline.kt");
      }

      @Test
      @TestMetadata("kt36975.kt")
      public void testKt36975() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/kt36975.kt");
      }

      @Test
      @TestMetadata("kt39612.kt")
      public void testKt39612() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/kt39612.kt");
      }

      @Test
      @TestMetadata("nameIntrinsicWithImplicitThis.kt")
      public void testNameIntrinsicWithImplicitThis() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/nameIntrinsicWithImplicitThis.kt");
      }

      @Test
      @TestMetadata("noMetadata.kt")
      public void testNoMetadata() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/noMetadata.kt");
      }

      @Test
      @TestMetadata("unboundFieldReferenceInInline.kt")
      public void testUnboundFieldReferenceInInline() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFieldReferenceInInline.kt");
      }

      @Test
      @TestMetadata("unboundFunReferenceInInline.kt")
      public void testUnboundFunReferenceInInline() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFunReferenceInInline.kt");
      }

      @Test
      @TestMetadata("unboundPropertyReferenceInInline.kt")
      public void testUnboundPropertyReferenceInInline() {
        runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundPropertyReferenceInInline.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/capturedVarsOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class CapturedVarsOptimization {
      @Test
      public void testAllFilesPresentInCapturedVarsOptimization() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("capturedInChainOfInlineFuns.kt")
      public void testCapturedInChainOfInlineFuns() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInChainOfInlineFuns.kt");
      }

      @Test
      @TestMetadata("capturedInInlineOnly.kt")
      public void testCapturedInInlineOnly() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInInlineOnly.kt");
      }

      @Test
      @TestMetadata("capturedInLocalObject.kt")
      public void testCapturedInLocalObject() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInLocalObject.kt");
      }

      @Test
      @TestMetadata("capturedInNoInlineOnly.kt")
      public void testCapturedInNoInlineOnly() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlineOnly.kt");
      }

      @Test
      @TestMetadata("capturedInNoInlneInsideChainOfInlineFuns.kt")
      public void testCapturedInNoInlneInsideChainOfInlineFuns() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlneInsideChainOfInlineFuns.kt");
      }

      @Test
      @TestMetadata("capturedValInLambdaInitializedInside.kt")
      public void testCapturedValInLambdaInitializedInside() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedInside.kt");
      }

      @Test
      @TestMetadata("capturedValInLambdaInitializedOutside.kt")
      public void testCapturedValInLambdaInitializedOutside() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedOutside.kt");
      }

      @Test
      @TestMetadata("capturedVarsOfSize2.kt")
      public void testCapturedVarsOfSize2() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedVarsOfSize2.kt");
      }

      @Test
      @TestMetadata("returnValueOfArrayConstructor.kt")
      public void testReturnValueOfArrayConstructor() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/returnValueOfArrayConstructor.kt");
      }

      @Test
      @TestMetadata("sharedSlotsWithCapturedVars.kt")
      public void testSharedSlotsWithCapturedVars() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
      }

      @Test
      @TestMetadata("withStackNormalization.kt")
      public void testWithStackNormalization() {
        runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/withStackNormalization.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/checkcast")
    @TestDataPath("$PROJECT_ROOT")
    public class Checkcast {
      @Test
      public void testAllFilesPresentInCheckcast() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/checkcast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt14811.kt")
      public void testKt14811() {
        runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14811.kt");
      }

      @Test
      @TestMetadata("kt14963.kt")
      public void testKt14963() {
        runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14963.kt");
      }

      @Test
      @TestMetadata("kt15411.kt")
      public void testKt15411() {
        runTest("compiler/testData/codegen/bytecodeText/checkcast/kt15411.kt");
      }

      @Test
      @TestMetadata("kt22714.kt")
      public void testKt22714() {
        runTest("compiler/testData/codegen/bytecodeText/checkcast/kt22714.kt");
      }

      @Test
      @TestMetadata("kt53465.kt")
      public void testKt53465() {
        runTest("compiler/testData/codegen/bytecodeText/checkcast/kt53465.kt");
      }

      @Test
      @TestMetadata("noCheckcastOnDelegatingDefaultImplsCall.kt")
      public void testNoCheckcastOnDelegatingDefaultImplsCall() {
        runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnDelegatingDefaultImplsCall.kt");
      }

      @Test
      @TestMetadata("noCheckcastOnSuper.kt")
      public void testNoCheckcastOnSuper() {
        runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnSuper.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class CoercionToUnitOptimization {
      @Test
      public void testAllFilesPresentInCoercionToUnitOptimization() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("inRangeCheckWithConst.kt")
      public void testInRangeCheckWithConst() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/inRangeCheckWithConst.kt");
      }

      @Test
      @TestMetadata("kt14360.kt")
      public void testKt14360() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/kt14360.kt");
      }

      @Test
      @TestMetadata("largeMethodWithCoercionToUnit.kt")
      public void testLargeMethodWithCoercionToUnit() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/largeMethodWithCoercionToUnit.kt");
      }

      @Test
      @TestMetadata("nopInlineFuns.kt")
      public void testNopInlineFuns() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/nopInlineFuns.kt");
      }

      @Test
      @TestMetadata("returnsUnit.kt")
      public void testReturnsUnit() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/returnsUnit.kt");
      }

      @Test
      @TestMetadata("safeCall.kt")
      public void testSafeCall() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCall.kt");
      }

      @Test
      @TestMetadata("safeCallWithReturnValue.kt")
      public void testSafeCallWithReturnValue() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCallWithReturnValue.kt");
      }

      @Test
      @TestMetadata("safeLet.kt")
      public void testSafeLet() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeLet.kt");
      }

      @Test
      @TestMetadata("tryInlined.kt")
      public void testTryInlined() {
        runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/tryInlined.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/companion")
    @TestDataPath("$PROJECT_ROOT")
    public class Companion {
      @Test
      public void testAllFilesPresentInCompanion() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("directAccessToBackingField.kt")
      public void testDirectAccessToBackingField() {
        runTest("compiler/testData/codegen/bytecodeText/companion/directAccessToBackingField.kt");
      }

      @Test
      @TestMetadata("floatingPointCompanionAccess.kt")
      public void testFloatingPointCompanionAccess() {
        runTest("compiler/testData/codegen/bytecodeText/companion/floatingPointCompanionAccess.kt");
      }

      @Test
      @TestMetadata("inlineFunctionCompanionPropertyAccess.kt")
      public void testInlineFunctionCompanionPropertyAccess() {
        runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionCompanionPropertyAccess.kt");
      }

      @Test
      @TestMetadata("inlineFunctionObjectCompanionPropertyAccess.kt")
      public void testInlineFunctionObjectCompanionPropertyAccess() {
        runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionObjectCompanionPropertyAccess.kt");
      }

      @Test
      @TestMetadata("kt14258_1.kt")
      public void testKt14258_1() {
        runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_1.kt");
      }

      @Test
      @TestMetadata("kt14258_2.kt")
      public void testKt14258_2() {
        runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_2.kt");
      }

      @Test
      @TestMetadata("kt14258_3.kt")
      public void testKt14258_3() {
        runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_3.kt");
      }

      @Test
      @TestMetadata("kt14258_4.kt")
      public void testKt14258_4() {
        runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_4.kt");
      }

      @Test
      @TestMetadata("kt14258_5.kt")
      public void testKt14258_5() {
        runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_5.kt");
      }

      @Test
      @TestMetadata("nonDefaultAccessors.kt")
      public void testNonDefaultAccessors() {
        runTest("compiler/testData/codegen/bytecodeText/companion/nonDefaultAccessors.kt");
      }

      @Test
      @TestMetadata("privateCompanionObjectAccessors_after.kt")
      public void testPrivateCompanionObjectAccessors_after() {
        runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_after.kt");
      }

      @Test
      @TestMetadata("privateCompanionObjectAccessors_before.kt")
      public void testPrivateCompanionObjectAccessors_before() {
        runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_before.kt");
      }

      @Test
      @TestMetadata("protectedCompanionObjectAccessors_after.kt")
      public void testProtectedCompanionObjectAccessors_after() {
        runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_after.kt");
      }

      @Test
      @TestMetadata("protectedCompanionObjectAccessors_before.kt")
      public void testProtectedCompanionObjectAccessors_before() {
        runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_before.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/conditions")
    @TestDataPath("$PROJECT_ROOT")
    public class Conditions {
      @Test
      public void testAllFilesPresentInConditions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/conditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("conjunction.kt")
      public void testConjunction() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/conjunction.kt");
      }

      @Test
      @TestMetadata("conjunctionInDoWhile.kt")
      public void testConjunctionInDoWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInDoWhile.kt");
      }

      @Test
      @TestMetadata("conjunctionInWhile.kt")
      public void testConjunctionInWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInWhile.kt");
      }

      @Test
      @TestMetadata("disjunction.kt")
      public void testDisjunction() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/disjunction.kt");
      }

      @Test
      @TestMetadata("negatedConjuction.kt")
      public void testNegatedConjuction() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedConjuction.kt");
      }

      @Test
      @TestMetadata("negatedDisjunction.kt")
      public void testNegatedDisjunction() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedDisjunction.kt");
      }

      @Test
      @TestMetadata("negatedNonZeroCompareInDoWhile.kt")
      public void testNegatedNonZeroCompareInDoWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInDoWhile.kt");
      }

      @Test
      @TestMetadata("negatedNonZeroCompareInIf.kt")
      public void testNegatedNonZeroCompareInIf() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInIf.kt");
      }

      @Test
      @TestMetadata("negatedNonZeroCompareInWhile.kt")
      public void testNegatedNonZeroCompareInWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInWhile.kt");
      }

      @Test
      @TestMetadata("negatedNullCompareInDoWhile.kt")
      public void testNegatedNullCompareInDoWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInDoWhile.kt");
      }

      @Test
      @TestMetadata("negatedNullCompareInIf.kt")
      public void testNegatedNullCompareInIf() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInIf.kt");
      }

      @Test
      @TestMetadata("negatedNullCompareInWhile.kt")
      public void testNegatedNullCompareInWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInWhile.kt");
      }

      @Test
      @TestMetadata("negatedZeroCompareInDoWhile.kt")
      public void testNegatedZeroCompareInDoWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInDoWhile.kt");
      }

      @Test
      @TestMetadata("negatedZeroCompareInIf.kt")
      public void testNegatedZeroCompareInIf() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInIf.kt");
      }

      @Test
      @TestMetadata("negatedZeroCompareInWhile.kt")
      public void testNegatedZeroCompareInWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInWhile.kt");
      }

      @Test
      @TestMetadata("noBoxingForBoxedEqPrimitive.kt")
      public void testNoBoxingForBoxedEqPrimitive() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForBoxedEqPrimitive.kt");
      }

      @Test
      @TestMetadata("noBoxingForPrimitiveEqBoxed.kt")
      public void testNoBoxingForPrimitiveEqBoxed() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqBoxed.kt");
      }

      @Test
      @TestMetadata("noBoxingForPrimitiveEqObject.kt")
      public void testNoBoxingForPrimitiveEqObject() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqObject.kt");
      }

      @Test
      @TestMetadata("nonZeroCompareInDoWhile.kt")
      public void testNonZeroCompareInDoWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInDoWhile.kt");
      }

      @Test
      @TestMetadata("nonZeroCompareInIf.kt")
      public void testNonZeroCompareInIf() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInIf.kt");
      }

      @Test
      @TestMetadata("nonZeroCompareInWhile.kt")
      public void testNonZeroCompareInWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInWhile.kt");
      }

      @Test
      @TestMetadata("nullCompareConst.kt")
      public void testNullCompareConst() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareConst.kt");
      }

      @Test
      @TestMetadata("nullCompareInDoWhile.kt")
      public void testNullCompareInDoWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInDoWhile.kt");
      }

      @Test
      @TestMetadata("nullCompareInIf.kt")
      public void testNullCompareInIf() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInIf.kt");
      }

      @Test
      @TestMetadata("nullCompareInWhile.kt")
      public void testNullCompareInWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInWhile.kt");
      }

      @Test
      @TestMetadata("zeroCompareInDoWhile.kt")
      public void testZeroCompareInDoWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInDoWhile.kt");
      }

      @Test
      @TestMetadata("zeroCompareInIf.kt")
      public void testZeroCompareInIf() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInIf.kt");
      }

      @Test
      @TestMetadata("zeroCompareInWhile.kt")
      public void testZeroCompareInWhile() {
        runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInWhile.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/constProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstProperty {
      @Test
      public void testAllFilesPresentInConstProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("noAccessorsForPrivateConstants.kt")
      public void testNoAccessorsForPrivateConstants() {
        runTest("compiler/testData/codegen/bytecodeText/constProperty/noAccessorsForPrivateConstants.kt");
      }

      @Test
      @TestMetadata("nonConstValHasNoDefaultValue_after.kt")
      public void testNonConstValHasNoDefaultValue_after() {
        runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_after.kt");
      }

      @Test
      @TestMetadata("nonConstValHasNoDefaultValue_before.kt")
      public void testNonConstValHasNoDefaultValue_before() {
        runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_before.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/constantConditions")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstantConditions {
      @Test
      public void testAllFilesPresentInConstantConditions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constantConditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("cmpIntWith0.kt")
      public void testCmpIntWith0() {
        runTest("compiler/testData/codegen/bytecodeText/constantConditions/cmpIntWith0.kt");
      }

      @Test
      @TestMetadata("constantFlag.kt")
      public void testConstantFlag() {
        runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantFlag.kt");
      }

      @Test
      @TestMetadata("constantInt.kt")
      public void testConstantInt() {
        runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantInt.kt");
      }

      @Test
      @TestMetadata("inlineIfFalse.kt")
      public void testInlineIfFalse() {
        runTest("compiler/testData/codegen/bytecodeText/constantConditions/inlineIfFalse.kt");
      }

      @Test
      @TestMetadata("kt3098.kt")
      public void testKt3098() {
        runTest("compiler/testData/codegen/bytecodeText/constantConditions/kt3098.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/constants")
    @TestDataPath("$PROJECT_ROOT")
    public class Constants {
      @Test
      public void testAllFilesPresentInConstants() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("byte.kt")
      public void testByte() {
        runTest("compiler/testData/codegen/bytecodeText/constants/byte.kt");
      }

      @Test
      @TestMetadata("comparisonFalse.kt")
      public void testComparisonFalse() {
        runTest("compiler/testData/codegen/bytecodeText/constants/comparisonFalse.kt");
      }

      @Test
      @TestMetadata("comparisonTrue.kt")
      public void testComparisonTrue() {
        runTest("compiler/testData/codegen/bytecodeText/constants/comparisonTrue.kt");
      }

      @Test
      @TestMetadata("floatingPoints.kt")
      public void testFloatingPoints() {
        runTest("compiler/testData/codegen/bytecodeText/constants/floatingPoints.kt");
      }

      @Test
      @TestMetadata("inlineUnsignedIntConstant.kt")
      public void testInlineUnsignedIntConstant() {
        runTest("compiler/testData/codegen/bytecodeText/constants/inlineUnsignedIntConstant.kt");
      }

      @Test
      @TestMetadata("kt9532.kt")
      public void testKt9532() {
        runTest("compiler/testData/codegen/bytecodeText/constants/kt9532.kt");
      }

      @Test
      @TestMetadata("noInlineNonConst.kt")
      public void testNoInlineNonConst() {
        runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonConst.kt");
      }

      @Test
      @TestMetadata("noInlineNonStaticJavaField.kt")
      public void testNoInlineNonStaticJavaField() {
        runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonStaticJavaField.kt");
      }

      @Test
      @TestMetadata("nullableByteAndShort.kt")
      public void testNullableByteAndShort() {
        runTest("compiler/testData/codegen/bytecodeText/constants/nullableByteAndShort.kt");
      }

      @Test
      @TestMetadata("partialString.kt")
      public void testPartialString() {
        runTest("compiler/testData/codegen/bytecodeText/constants/partialString.kt");
      }

      @Test
      @TestMetadata("short.kt")
      public void testShort() {
        runTest("compiler/testData/codegen/bytecodeText/constants/short.kt");
      }

      @Test
      @TestMetadata("string.kt")
      public void testString() {
        runTest("compiler/testData/codegen/bytecodeText/constants/string.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/constructors")
    @TestDataPath("$PROJECT_ROOT")
    public class Constructors {
      @Test
      public void testAllFilesPresentInConstructors() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constructors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("enumPrimaryDefaults.kt")
      public void testEnumPrimaryDefaults() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/enumPrimaryDefaults.kt");
      }

      @Test
      @TestMetadata("inlineArgumentPrimaryDefaults.kt")
      public void testInlineArgumentPrimaryDefaults() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/inlineArgumentPrimaryDefaults.kt");
      }

      @Test
      @TestMetadata("inlinePrimaryDefaults.kt")
      public void testInlinePrimaryDefaults() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/inlinePrimaryDefaults.kt");
      }

      @Test
      @TestMetadata("innerClassConstructor.kt")
      public void testInnerClassConstructor() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/innerClassConstructor.kt");
      }

      @Test
      @TestMetadata("innerPrimaryDefaults.kt")
      public void testInnerPrimaryDefaults() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/innerPrimaryDefaults.kt");
      }

      @Test
      @TestMetadata("internalPrimaryDefaults.kt")
      public void testInternalPrimaryDefaults() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/internalPrimaryDefaults.kt");
      }

      @Test
      @TestMetadata("localPrimaryDefaults.kt")
      public void testLocalPrimaryDefaults() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/localPrimaryDefaults.kt");
      }

      @Test
      @TestMetadata("parameterlessPrimary.kt")
      public void testParameterlessPrimary() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/parameterlessPrimary.kt");
      }

      @Test
      @TestMetadata("privatePrimaryDefaults.kt")
      public void testPrivatePrimaryDefaults() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/privatePrimaryDefaults.kt");
      }

      @Test
      @TestMetadata("protectedPrimaryDefaults.kt")
      public void testProtectedPrimaryDefaults() {
        runTest("compiler/testData/codegen/bytecodeText/constructors/protectedPrimaryDefaults.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    public class ControlStructures {
      @Test
      public void testAllFilesPresentInControlStructures() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("ifConsts.kt")
      public void testIfConsts() {
        runTest("compiler/testData/codegen/bytecodeText/controlStructures/ifConsts.kt");
      }

      @Test
      @TestMetadata("kt17110.kt")
      public void testKt17110() {
        runTest("compiler/testData/codegen/bytecodeText/controlStructures/kt17110.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    public class Coroutines {
      @Test
      public void testAllFilesPresentInCoroutines() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("crossinlineSuspendContinuation_1_3.kt")
      public void testCrossinlineSuspendContinuation_1_3() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/crossinlineSuspendContinuation_1_3.kt");
      }

      @Test
      @TestMetadata("doNotReassignContinuation.kt")
      public void testDoNotReassignContinuation() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/doNotReassignContinuation.kt");
      }

      @Test
      @TestMetadata("effectivelyInlineOnly.kt")
      public void testEffectivelyInlineOnly() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/effectivelyInlineOnly.kt");
      }

      @Test
      @TestMetadata("internalInlineSuspend.kt")
      public void testInternalInlineSuspend() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/internalInlineSuspend.kt");
      }

      @Test
      @TestMetadata("mergeLvt.kt")
      public void testMergeLvt() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/mergeLvt.kt");
      }

      @Test
      @TestMetadata("nonLocalReturn.kt")
      public void testNonLocalReturn() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/nonLocalReturn.kt");
      }

      @Test
      @TestMetadata("returnUnitInLambda.kt")
      public void testReturnUnitInLambda() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/returnUnitInLambda.kt");
      }

      @Test
      @TestMetadata("suspendMain.kt")
      public void testSuspendMain() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/suspendMain.kt");
      }

      @Test
      @TestMetadata("throwOnFailure.kt")
      public void testThrowOnFailure() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/throwOnFailure.kt");
      }

      @Test
      @TestMetadata("varValueConflictsWithTable.kt")
      public void testVarValueConflictsWithTable() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable.kt");
      }

      @Test
      @TestMetadata("varValueConflictsWithTableSameSort.kt")
      public void testVarValueConflictsWithTableSameSort() {
        runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/debug")
      @TestDataPath("$PROJECT_ROOT")
      public class Debug {
        @Test
        public void testAllFilesPresentInDebug() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("continuationInLvt.kt")
        public void testContinuationInLvt() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/continuationInLvt.kt");
        }

        @Test
        @TestMetadata("localVariableCorrectLabel.kt")
        public void testLocalVariableCorrectLabel() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/localVariableCorrectLabel.kt");
        }

        @Test
        @TestMetadata("probeCoroutineSuspended.kt")
        public void testProbeCoroutineSuspended() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/probeCoroutineSuspended.kt");
        }

        @Test
        @TestMetadata("shrinkLvtTopLevel.kt")
        public void testShrinkLvtTopLevel() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/shrinkLvtTopLevel.kt");
        }

        @Test
        @TestMetadata("thisAndResultInLvt.kt")
        public void testThisAndResultInLvt() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/thisAndResultInLvt.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda")
      @TestDataPath("$PROJECT_ROOT")
      public class DestructuringInLambda {
        @Test
        public void testAllFilesPresentInDestructuringInLambda() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineSeparateFiles.kt")
        public void testInlineSeparateFiles() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda/inlineSeparateFiles.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses")
      @TestDataPath("$PROJECT_ROOT")
      public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineClassBoxingInSuspendFunReturn_Primitive.kt")
        public void testInlineClassBoxingInSuspendFunReturn_Primitive() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/inlineClassBoxingInSuspendFunReturn_Primitive.kt");
        }

        @Test
        @TestMetadata("noInlineClassBoxingInSuspendFunReturn_Any.kt")
        public void testNoInlineClassBoxingInSuspendFunReturn_Any() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_Any.kt");
        }

        @Test
        @TestMetadata("noInlineClassBoxingInSuspendFunReturn_InlineAny.kt")
        public void testNoInlineClassBoxingInSuspendFunReturn_InlineAny() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_InlineAny.kt");
        }

        @Test
        @TestMetadata("noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt")
        public void testNoInlineClassBoxingInSuspendFunReturn_SameJvmType() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt");
        }

        @Test
        @TestMetadata("noInlineClassBoxingInSuspendFunReturn_String.kt")
        public void testNoInlineClassBoxingInSuspendFunReturn_String() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_String.kt");
        }

        @Test
        @TestMetadata("returnResult.kt")
        public void testReturnResult() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnResult.kt");
        }

        @Test
        @TestMetadata("returnStringOverride.kt")
        public void testReturnStringOverride() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnStringOverride.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling")
      @TestDataPath("$PROJECT_ROOT")
      public class IntLikeVarSpilling {
        @Test
        public void testAllFilesPresentInIntLikeVarSpilling() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("complicatedMerge.kt")
        public void testComplicatedMerge() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt");
        }

        @Test
        @TestMetadata("i2bResult.kt")
        public void testI2bResult() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt");
        }

        @Test
        @TestMetadata("loadFromBooleanArray.kt")
        public void testLoadFromBooleanArray() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
        }

        @Test
        @TestMetadata("loadFromByteArray.kt")
        public void testLoadFromByteArray() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
        }

        @Test
        @TestMetadata("noVariableInTable.kt")
        public void testNoVariableInTable() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt");
        }

        @Test
        @TestMetadata("sameIconst1ManyVars.kt")
        public void testSameIconst1ManyVars() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
        }

        @Test
        @TestMetadata("usedInArrayStore.kt")
        public void testUsedInArrayStore() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
        }

        @Test
        @TestMetadata("usedInMethodCall.kt")
        public void testUsedInMethodCall() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
        }

        @Test
        @TestMetadata("usedInPutfield.kt")
        public void testUsedInPutfield() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt");
        }

        @Test
        @TestMetadata("usedInVarStore.kt")
        public void testUsedInVarStore() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/stateMachine")
      @TestDataPath("$PROJECT_ROOT")
      public class StateMachine {
        @Test
        public void testAllFilesPresentInStateMachine() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt25893.kt")
        public void testKt25893() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/kt25893.kt");
        }

        @Test
        @TestMetadata("withTypeParameter.kt")
        public void testWithTypeParameter() {
          runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/withTypeParameter.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    public class DeadCodeElimination {
      @Test
      public void testAllFilesPresentInDeadCodeElimination() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayConstructor.kt")
      public void testArrayConstructor() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/arrayConstructor.kt");
      }

      @Test
      @TestMetadata("boxing.kt")
      public void testBoxing() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxing.kt");
      }

      @Test
      @TestMetadata("boxingNotOptimizable.kt")
      public void testBoxingNotOptimizable() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxingNotOptimizable.kt");
      }

      @Test
      @TestMetadata("emptyVariableRange.kt")
      public void testEmptyVariableRange() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/emptyVariableRange.kt");
      }

      @Test
      @TestMetadata("kt14357.kt")
      public void testKt14357() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/kt14357.kt");
      }

      @Test
      @TestMetadata("lastReturn.kt")
      public void testLastReturn() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/lastReturn.kt");
      }

      @Test
      @TestMetadata("literal.kt")
      public void testLiteral() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/literal.kt");
      }

      @Test
      @TestMetadata("simpleConstructor.kt")
      public void testSimpleConstructor() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructor.kt");
      }

      @Test
      @TestMetadata("simpleConstructorNotRedundant.kt")
      public void testSimpleConstructorNotRedundant() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundant.kt");
      }

      @Test
      @TestMetadata("simpleConstructorNotRedundantNotOptimizable.kt")
      public void testSimpleConstructorNotRedundantNotOptimizable() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundantNotOptimizable.kt");
      }

      @Test
      @TestMetadata("unusedPrimitiveAndObjectEquals.kt")
      public void testUnusedPrimitiveAndObjectEquals() {
        runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/unusedPrimitiveAndObjectEquals.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultArguments {
      @Test
      public void testAllFilesPresentInDefaultArguments() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("inheritedInterfaceFunction.kt")
      public void testInheritedInterfaceFunction() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/inheritedInterfaceFunction.kt");
      }

      @Test
      @TestMetadata("kt11962.kt")
      public void testKt11962() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/kt11962.kt");
      }

      @Test
      @TestMetadata("localVariablesInInlinedDefaultStubs.kt")
      public void testLocalVariablesInInlinedDefaultStubs() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/localVariablesInInlinedDefaultStubs.kt");
      }

      @Test
      @TestMetadata("maskAndArgumentElimination.kt")
      public void testMaskAndArgumentElimination() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskAndArgumentElimination.kt");
      }

      @Test
      @TestMetadata("maskCheckSequence.kt")
      public void testMaskCheckSequence() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskCheckSequence.kt");
      }

      @Test
      @TestMetadata("methodHandlerElimination.kt")
      public void testMethodHandlerElimination() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/methodHandlerElimination.kt");
      }

      @Test
      @TestMetadata("noAccessorForDefault.kt")
      public void testNoAccessorForDefault() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAccessorForDefault.kt");
      }

      @Test
      @TestMetadata("noAnonymousObjectRegenerationInDefaultStub.kt")
      public void testNoAnonymousObjectRegenerationInDefaultStub() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAnonymousObjectRegenerationInDefaultStub.kt");
      }

      @Test
      @TestMetadata("noEmptyArray.kt")
      public void testNoEmptyArray() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noEmptyArray.kt");
      }

      @Test
      @TestMetadata("noSyntheticParameters.kt")
      public void testNoSyntheticParameters() {
        runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noSyntheticParameters.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/directInvoke")
    @TestDataPath("$PROJECT_ROOT")
    public class DirectInvoke {
      @Test
      public void testAllFilesPresentInDirectInvoke() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/directInvoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("callableReference.kt")
      public void testCallableReference() {
        runTest("compiler/testData/codegen/bytecodeText/directInvoke/callableReference.kt");
      }

      @Test
      @TestMetadata("inplaceClosure.kt")
      public void testInplaceClosure() {
        runTest("compiler/testData/codegen/bytecodeText/directInvoke/inplaceClosure.kt");
      }

      @Test
      @TestMetadata("localFun.kt")
      public void testLocalFun() {
        runTest("compiler/testData/codegen/bytecodeText/directInvoke/localFun.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/disabledOptimizations")
    @TestDataPath("$PROJECT_ROOT")
    public class DisabledOptimizations {
      @Test
      public void testAllFilesPresentInDisabledOptimizations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/disabledOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("noJumpInLastBranch.kt")
      public void testNoJumpInLastBranch() {
        runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInLastBranch.kt");
      }

      @Test
      @TestMetadata("noJumpInSingleBranch.kt")
      public void testNoJumpInSingleBranch() {
        runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInSingleBranch.kt");
      }

      @Test
      @TestMetadata("noObjectCastAfterReification.kt")
      public void testNoObjectCastAfterReification() {
        runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noObjectCastAfterReification.kt");
      }

      @Test
      @TestMetadata("noUnitInstanceInDefaultParameterInitialization.kt")
      public void testNoUnitInstanceInDefaultParameterInitialization() {
        runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceInDefaultParameterInitialization.kt");
      }

      @Test
      @TestMetadata("noUnitInstanceOnVoidFunctionCall.kt")
      public void testNoUnitInstanceOnVoidFunctionCall() {
        runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceOnVoidFunctionCall.kt");
      }

      @Test
      @TestMetadata("noUnusedLabel.kt")
      public void testNoUnusedLabel() {
        runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnusedLabel.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/enum")
    @TestDataPath("$PROJECT_ROOT")
    public class Enum {
      @Test
      public void testAllFilesPresentInEnum() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("constructorAccessors.kt")
      public void testConstructorAccessors() {
        runTest("compiler/testData/codegen/bytecodeText/enum/constructorAccessors.kt");
      }

      @Test
      @TestMetadata("enumCheckcasts.kt")
      public void testEnumCheckcasts() {
        runTest("compiler/testData/codegen/bytecodeText/enum/enumCheckcasts.kt");
      }

      @Test
      @TestMetadata("enumEntries.kt")
      public void testEnumEntries() {
        runTest("compiler/testData/codegen/bytecodeText/enum/enumEntries.kt");
      }

      @Test
      @TestMetadata("enumEntriesIntrinsic.kt")
      public void testEnumEntriesIntrinsic() {
        runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesIntrinsic.kt");
      }

      @Test
      @TestMetadata("enumEntriesIntrinsicForJava.kt")
      public void testEnumEntriesIntrinsicForJava() {
        runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesIntrinsicForJava.kt");
      }

      @Test
      @TestMetadata("enumEntriesMapping.kt")
      public void testEnumEntriesMapping() {
        runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesMapping.kt");
      }

      @Test
      @TestMetadata("enumEntriesMultiMapping.kt")
      public void testEnumEntriesMultiMapping() {
        runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesMultiMapping.kt");
      }

      @Test
      @TestMetadata("enumEntriesNoMapping.kt")
      public void testEnumEntriesNoMapping() {
        runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesNoMapping.kt");
      }

      @Test
      @TestMetadata("kt18731.kt")
      public void testKt18731() {
        runTest("compiler/testData/codegen/bytecodeText/enum/kt18731.kt");
      }

      @Test
      @TestMetadata("kt18731_2.kt")
      public void testKt18731_2() {
        runTest("compiler/testData/codegen/bytecodeText/enum/kt18731_2.kt");
      }

      @Test
      @TestMetadata("kt57671_1.kt")
      public void testKt57671_1() {
        runTest("compiler/testData/codegen/bytecodeText/enum/kt57671_1.kt");
      }

      @Test
      @TestMetadata("kt57671_2.kt")
      public void testKt57671_2() {
        runTest("compiler/testData/codegen/bytecodeText/enum/kt57671_2.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/exclExcl")
    @TestDataPath("$PROJECT_ROOT")
    public class ExclExcl {
      @Test
      public void testAllFilesPresentInExclExcl() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("exclExclOnPlatformType.kt")
      public void testExclExclOnPlatformType() {
        runTest("compiler/testData/codegen/bytecodeText/exclExcl/exclExclOnPlatformType.kt");
      }

      @Test
      @TestMetadata("primitive.kt")
      public void testPrimitive() {
        runTest("compiler/testData/codegen/bytecodeText/exclExcl/primitive.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues")
    @TestDataPath("$PROJECT_ROOT")
    public class FieldsForCapturedValues {
      @Test
      public void testAllFilesPresentInFieldsForCapturedValues() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("constructorOnly.kt")
      public void testConstructorOnly() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/constructorOnly.kt");
      }

      @Test
      @TestMetadata("extensionLambdaExtensionReceiver.kt")
      public void testExtensionLambdaExtensionReceiver() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionLambdaExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("extensionReceiver.kt")
      public void testExtensionReceiver() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionReceiver.kt");
      }

      @Test
      @TestMetadata("innerAndOuterThis.kt")
      public void testInnerAndOuterThis() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/innerAndOuterThis.kt");
      }

      @Test
      @TestMetadata("labeledExtensionLambdaExtensionReceiver.kt")
      public void testLabeledExtensionLambdaExtensionReceiver() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/labeledExtensionLambdaExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("multipleExtensionReceivers.kt")
      public void testMultipleExtensionReceivers() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/multipleExtensionReceivers.kt");
      }

      @Test
      @TestMetadata("outerThis.kt")
      public void testOuterThis() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThis.kt");
      }

      @Test
      @TestMetadata("outerThisInInnerConstructor.kt")
      public void testOuterThisInInnerConstructor() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerConstructor.kt");
      }

      @Test
      @TestMetadata("outerThisInInnerInitBlock.kt")
      public void testOuterThisInInnerInitBlock() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerInitBlock.kt");
      }

      @Test
      @TestMetadata("this.kt")
      public void testThis() {
        runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/this.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop")
    @TestDataPath("$PROJECT_ROOT")
    public class ForLoop {
      @Test
      public void testAllFilesPresentInForLoop() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("forInCharSequence.kt")
      public void testForInCharSequence() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequence.kt");
      }

      @Test
      @TestMetadata("forInCharSequenceTypeParameter.kt")
      public void testForInCharSequenceTypeParameter() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceTypeParameter.kt");
      }

      @Test
      @TestMetadata("forInDownToCharMinValue.kt")
      public void testForInDownToCharMinValue() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToCharMinValue.kt");
      }

      @Test
      @TestMetadata("forInDownToIntMinValue.kt")
      public void testForInDownToIntMinValue() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToIntMinValue.kt");
      }

      @Test
      @TestMetadata("forInDownToLongConstNoUnderflow.kt")
      public void testForInDownToLongConstNoUnderflow() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongConstNoUnderflow.kt");
      }

      @Test
      @TestMetadata("forInDownToLongMinValue.kt")
      public void testForInDownToLongMinValue() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongMinValue.kt");
      }

      @Test
      @TestMetadata("forInObjectArray.kt")
      public void testForInObjectArray() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInObjectArray.kt");
      }

      @Test
      @TestMetadata("forInPrimitiveArray.kt")
      public void testForInPrimitiveArray() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInPrimitiveArray.kt");
      }

      @Test
      @TestMetadata("forInRangeInlinedFromStdlib.kt")
      public void testForInRangeInlinedFromStdlib() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeInlinedFromStdlib.kt");
      }

      @Test
      @TestMetadata("forInRangeSpecializedToUntil.kt")
      public void testForInRangeSpecializedToUntil() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeSpecializedToUntil.kt");
      }

      @Test
      @TestMetadata("forInRangeToCharConst.kt")
      public void testForInRangeToCharConst() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharConst.kt");
      }

      @Test
      @TestMetadata("forInRangeToCharMaxValue.kt")
      public void testForInRangeToCharMaxValue() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharMaxValue.kt");
      }

      @Test
      @TestMetadata("forInRangeToConst.kt")
      public void testForInRangeToConst() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToConst.kt");
      }

      @Test
      @TestMetadata("forInRangeToIntMaxValue.kt")
      public void testForInRangeToIntMaxValue() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToIntMaxValue.kt");
      }

      @Test
      @TestMetadata("forInRangeToLongConst.kt")
      public void testForInRangeToLongConst() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongConst.kt");
      }

      @Test
      @TestMetadata("forInRangeToLongMaxValue.kt")
      public void testForInRangeToLongMaxValue() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongMaxValue.kt");
      }

      @Test
      @TestMetadata("forInRangeToQualifiedConst.kt")
      public void testForInRangeToQualifiedConst() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToQualifiedConst.kt");
      }

      @Test
      @TestMetadata("forInRangeWithImplicitReceiver.kt")
      public void testForInRangeWithImplicitReceiver() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithImplicitReceiver.kt");
      }

      @Test
      @TestMetadata("forInStringSpecialized.kt")
      public void testForInStringSpecialized() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forInStringSpecialized.kt");
      }

      @Test
      @TestMetadata("forIntInDownTo.kt")
      public void testForIntInDownTo() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/forIntInDownTo.kt");
      }

      @Test
      @TestMetadata("iincGeneration.kt")
      public void testIincGeneration() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/iincGeneration.kt");
      }

      @Test
      @TestMetadata("intrinsicArrayConstructorsUseCounterLoop.kt")
      public void testIntrinsicArrayConstructorsUseCounterLoop() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/intrinsicArrayConstructorsUseCounterLoop.kt");
      }

      @Test
      @TestMetadata("loopVarInterval.kt")
      public void testLoopVarInterval() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/loopVarInterval.kt");
      }

      @Test
      @TestMetadata("primitiveLiteralRange1.kt")
      public void testPrimitiveLiteralRange1() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange1.kt");
      }

      @Test
      @TestMetadata("primitiveLiteralRange2.kt")
      public void testPrimitiveLiteralRange2() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange2.kt");
      }

      @Test
      @TestMetadata("primitiveProgression.kt")
      public void testPrimitiveProgression() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveProgression.kt");
      }

      @Test
      @TestMetadata("primitiveRange.kt")
      public void testPrimitiveRange() {
        runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveRange.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInArrayWithIndex {
        @Test
        public void testAllFilesPresentInForInArrayWithIndex() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInArrayWithIndexNoElementVar.kt")
        public void testForInArrayWithIndexNoElementVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
        }

        @Test
        @TestMetadata("forInArrayWithIndexNoIndexVar.kt")
        public void testForInArrayWithIndexNoIndexVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
        }

        @Test
        @TestMetadata("forInEmptyArrayWithIndex.kt")
        public void testForInEmptyArrayWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
        }

        @Test
        @TestMetadata("forInIntArrayWithIndex.kt")
        public void testForInIntArrayWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInIntArrayWithIndex.kt");
        }

        @Test
        @TestMetadata("forInObjectArrayWithIndex.kt")
        public void testForInObjectArrayWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInCharSequenceWithIndex {
        @Test
        public void testAllFilesPresentInForInCharSequenceWithIndex() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInCharSequenceWithIndex.kt")
        public void testForInCharSequenceWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
        }

        @Test
        @TestMetadata("forInEmptyStringWithIndex.kt")
        public void testForInEmptyStringWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
        }

        @Test
        @TestMetadata("forInStringWithIndex.kt")
        public void testForInStringWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndex.kt");
        }

        @Test
        @TestMetadata("forInStringWithIndexNoElementVar.kt")
        public void testForInStringWithIndexNoElementVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
        }

        @Test
        @TestMetadata("forInStringWithIndexNoIndexVar.kt")
        public void testForInStringWithIndexNoIndexVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
        }

        @Test
        @TestMetadata("forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
        public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInIndices {
        @Test
        public void testAllFilesPresentInForInIndices() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIndices"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInArrayListIndices.kt")
        public void testForInArrayListIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInArrayListIndices.kt");
        }

        @Test
        @TestMetadata("forInCharSequenceIndices.kt")
        public void testForInCharSequenceIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceIndices.kt");
        }

        @Test
        @TestMetadata("forInCharSequenceTypeParameterIndices.kt")
        public void testForInCharSequenceTypeParameterIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceTypeParameterIndices.kt");
        }

        @Test
        @TestMetadata("forInCollectionImplicitReceiverIndices.kt")
        public void testForInCollectionImplicitReceiverIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionImplicitReceiverIndices.kt");
        }

        @Test
        @TestMetadata("forInCollectionIndices.kt")
        public void testForInCollectionIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionIndices.kt");
        }

        @Test
        @TestMetadata("forInCollectionTypeParameterIndices.kt")
        public void testForInCollectionTypeParameterIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionTypeParameterIndices.kt");
        }

        @Test
        @TestMetadata("forInNonOptimizedIndices.kt")
        public void testForInNonOptimizedIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInNonOptimizedIndices.kt");
        }

        @Test
        @TestMetadata("forInObjectArrayIndices.kt")
        public void testForInObjectArrayIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInObjectArrayIndices.kt");
        }

        @Test
        @TestMetadata("forInPrimitiveArrayIndices.kt")
        public void testForInPrimitiveArrayIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInPrimitiveArrayIndices.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInIterableWithIndex {
        @Test
        public void testAllFilesPresentInForInIterableWithIndex() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInEmptyListWithIndex.kt")
        public void testForInEmptyListWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInEmptyListWithIndex.kt");
        }

        @Test
        @TestMetadata("forInIterableTypeParameterWithIndex.kt")
        public void testForInIterableTypeParameterWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
        }

        @Test
        @TestMetadata("forInListWithIndex.kt")
        public void testForInListWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndex.kt");
        }

        @Test
        @TestMetadata("forInListWithIndexNoElementVar.kt")
        public void testForInListWithIndexNoElementVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
        }

        @Test
        @TestMetadata("forInListWithIndexNoIndexVar.kt")
        public void testForInListWithIndexNoIndexVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
        }

        @Test
        @TestMetadata("forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
        public void testForInListWithIndexWithExplicitlyTypedIndexVariable() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInProgressionWithIndex {
        @Test
        public void testAllFilesPresentInForInProgressionWithIndex() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInDownToWithIndex.kt")
        public void testForInDownToWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInDownToWithIndex.kt");
        }

        @Test
        @TestMetadata("forInIndicesWithIndex.kt")
        public void testForInIndicesWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInIndicesWithIndex.kt");
        }

        @Test
        @TestMetadata("forInRangeToWithIndex.kt")
        public void testForInRangeToWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInRangeToWithIndex.kt");
        }

        @Test
        @TestMetadata("forInReversedStepWithIndex.kt")
        public void testForInReversedStepWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedStepWithIndex.kt");
        }

        @Test
        @TestMetadata("forInReversedWithIndex.kt")
        public void testForInReversedWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedWithIndex.kt");
        }

        @Test
        @TestMetadata("forInStepReversedWithIndex.kt")
        public void testForInStepReversedWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepReversedWithIndex.kt");
        }

        @Test
        @TestMetadata("forInStepWithIndex.kt")
        public void testForInStepWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepWithIndex.kt");
        }

        @Test
        @TestMetadata("forInUntilWithIndex.kt")
        public void testForInUntilWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInUntilWithIndex.kt");
        }

        @Test
        @TestMetadata("forInWithIndexNoIndexOrElementVar.kt")
        public void testForInWithIndexNoIndexOrElementVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNoIndexOrElementVar.kt");
        }

        @Test
        @TestMetadata("forInWithIndexNotDestructured.kt")
        public void testForInWithIndexNotDestructured() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNotDestructured.kt");
        }

        @Test
        @TestMetadata("forInWithIndexReversed.kt")
        public void testForInWithIndexReversed() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexReversed.kt");
        }

        @Test
        @TestMetadata("forInWithIndexWithIndex.kt")
        public void testForInWithIndexWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexWithIndex.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInRangeUntil {
        @Test
        public void testAllFilesPresentInForInRangeUntil() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInRangeUntilChar.kt")
        public void testForInRangeUntilChar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilChar.kt");
        }

        @Test
        @TestMetadata("forInRangeUntilCharMaxValue.kt")
        public void testForInRangeUntilCharMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMaxValue.kt");
        }

        @Test
        @TestMetadata("forInRangeUntilCharMinValue.kt")
        public void testForInRangeUntilCharMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMinValue.kt");
        }

        @Test
        @TestMetadata("forInRangeUntilInt.kt")
        public void testForInRangeUntilInt() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilInt.kt");
        }

        @Test
        @TestMetadata("forInRangeUntilIntMaxValue.kt")
        public void testForInRangeUntilIntMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMaxValue.kt");
        }

        @Test
        @TestMetadata("forInRangeUntilIntMinValue.kt")
        public void testForInRangeUntilIntMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMinValue.kt");
        }

        @Test
        @TestMetadata("forInRangeUntilLong.kt")
        public void testForInRangeUntilLong() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLong.kt");
        }

        @Test
        @TestMetadata("forInRangeUntilLongMaxValue.kt")
        public void testForInRangeUntilLongMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMaxValue.kt");
        }

        @Test
        @TestMetadata("forInRangeUntilLongMinValue.kt")
        public void testForInRangeUntilLongMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMinValue.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInRangeWithUpperBoundMinus1 {
        @Test
        public void testAllFilesPresentInForInRangeWithUpperBoundMinus1() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("booleanArray.kt")
        public void testBooleanArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/booleanArray.kt");
        }

        @Test
        @TestMetadata("byteArray.kt")
        public void testByteArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/byteArray.kt");
        }

        @Test
        @TestMetadata("charArray.kt")
        public void testCharArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charArray.kt");
        }

        @Test
        @TestMetadata("charSequence.kt")
        public void testCharSequence() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charSequence.kt");
        }

        @Test
        @TestMetadata("doubleArray.kt")
        public void testDoubleArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/doubleArray.kt");
        }

        @Test
        @TestMetadata("emptyList.kt")
        public void testEmptyList() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyList.kt");
        }

        @Test
        @TestMetadata("emptyMap.kt")
        public void testEmptyMap() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyMap.kt");
        }

        @Test
        @TestMetadata("emptySet.kt")
        public void testEmptySet() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptySet.kt");
        }

        @Test
        @TestMetadata("floatArray.kt")
        public void testFloatArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/floatArray.kt");
        }

        @Test
        @TestMetadata("intArray.kt")
        public void testIntArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/intArray.kt");
        }

        @Test
        @TestMetadata("list.kt")
        public void testList() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/list.kt");
        }

        @Test
        @TestMetadata("longArray.kt")
        public void testLongArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/longArray.kt");
        }

        @Test
        @TestMetadata("map.kt")
        public void testMap() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/map.kt");
        }

        @Test
        @TestMetadata("mutableList.kt")
        public void testMutableList() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableList.kt");
        }

        @Test
        @TestMetadata("mutableMap.kt")
        public void testMutableMap() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableMap.kt");
        }

        @Test
        @TestMetadata("mutableSet.kt")
        public void testMutableSet() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableSet.kt");
        }

        @Test
        @TestMetadata("set.kt")
        public void testSet() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/set.kt");
        }

        @Test
        @TestMetadata("shortArray.kt")
        public void testShortArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/shortArray.kt");
        }

        @Test
        @TestMetadata("string.kt")
        public void testString() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/string.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInReversed")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInReversed {
        @Test
        public void testAllFilesPresentInForInReversed() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInReversedArrayIndices.kt")
        public void testForInReversedArrayIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedArrayIndices.kt");
        }

        @Test
        @TestMetadata("forInReversedCharSequenceIndices.kt")
        public void testForInReversedCharSequenceIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCharSequenceIndices.kt");
        }

        @Test
        @TestMetadata("forInReversedCollectionIndices.kt")
        public void testForInReversedCollectionIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCollectionIndices.kt");
        }

        @Test
        @TestMetadata("forInReversedDownTo.kt")
        public void testForInReversedDownTo() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedDownTo.kt");
        }

        @Test
        @TestMetadata("forInReversedEmptyRangeLiteral.kt")
        public void testForInReversedEmptyRangeLiteral() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedEmptyRangeLiteral.kt");
        }

        @Test
        @TestMetadata("forInReversedRange.kt")
        public void testForInReversedRange() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRange.kt");
        }

        @Test
        @TestMetadata("forInReversedRangeLiteral.kt")
        public void testForInReversedRangeLiteral() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRangeLiteral.kt");
        }

        @Test
        @TestMetadata("forInReversedReversedArrayIndices.kt")
        public void testForInReversedReversedArrayIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedArrayIndices.kt");
        }

        @Test
        @TestMetadata("forInReversedReversedDownTo.kt")
        public void testForInReversedReversedDownTo() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedDownTo.kt");
        }

        @Test
        @TestMetadata("forInReversedReversedRange.kt")
        public void testForInReversedReversedRange() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedRange.kt");
        }

        @Test
        @TestMetadata("forInReversedReversedReversedRange.kt")
        public void testForInReversedReversedReversedRange() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedReversedRange.kt");
        }

        @Test
        @TestMetadata("forInReversedReversedUntil.kt")
        public void testForInReversedReversedUntil() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedUntil.kt");
        }

        @Test
        @TestMetadata("forInReversedUntil.kt")
        public void testForInReversedUntil() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedUntil.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInSequenceWithIndex {
        @Test
        public void testAllFilesPresentInForInSequenceWithIndex() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInEmptySequenceWithIndex.kt")
        public void testForInEmptySequenceWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
        }

        @Test
        @TestMetadata("forInSequenceTypeParameterWithIndex.kt")
        public void testForInSequenceTypeParameterWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
        }

        @Test
        @TestMetadata("forInSequenceWithIndex.kt")
        public void testForInSequenceWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndex.kt");
        }

        @Test
        @TestMetadata("forInSequenceWithIndexNoElementVar.kt")
        public void testForInSequenceWithIndexNoElementVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
        }

        @Test
        @TestMetadata("forInSequenceWithIndexNoIndexVar.kt")
        public void testForInSequenceWithIndexNoIndexVar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
        }

        @Test
        @TestMetadata("forInSequenceWithIndexThrowsCME.kt")
        public void testForInSequenceWithIndexThrowsCME() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
        }

        @Test
        @TestMetadata("forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
        public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInUntil")
      @TestDataPath("$PROJECT_ROOT")
      public class ForInUntil {
        @Test
        public void testAllFilesPresentInForInUntil() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInUntilChar.kt")
        public void testForInUntilChar() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilChar.kt");
        }

        @Test
        @TestMetadata("forInUntilCharMaxValue.kt")
        public void testForInUntilCharMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMaxValue.kt");
        }

        @Test
        @TestMetadata("forInUntilCharMinValue.kt")
        public void testForInUntilCharMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMinValue.kt");
        }

        @Test
        @TestMetadata("forInUntilInt.kt")
        public void testForInUntilInt() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilInt.kt");
        }

        @Test
        @TestMetadata("forInUntilIntMaxValue.kt")
        public void testForInUntilIntMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMaxValue.kt");
        }

        @Test
        @TestMetadata("forInUntilIntMinValue.kt")
        public void testForInUntilIntMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMinValue.kt");
        }

        @Test
        @TestMetadata("forInUntilLong.kt")
        public void testForInUntilLong() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLong.kt");
        }

        @Test
        @TestMetadata("forInUntilLongMaxValue.kt")
        public void testForInUntilLongMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMaxValue.kt");
        }

        @Test
        @TestMetadata("forInUntilLongMinValue.kt")
        public void testForInUntilLongMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMinValue.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/stepped")
      @TestDataPath("$PROJECT_ROOT")
      public class Stepped {
        @Test
        public void testAllFilesPresentInStepped() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/stepped"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("illegalStepConst.kt")
        public void testIllegalStepConst() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/illegalStepConst.kt");
        }

        @Test
        @TestMetadata("reversedThenStep.kt")
        public void testReversedThenStep() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/reversedThenStep.kt");
        }

        @Test
        @TestMetadata("stepConst.kt")
        public void testStepConst() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConst.kt");
        }

        @Test
        @TestMetadata("stepConstOnNonLiteralProgression.kt")
        public void testStepConstOnNonLiteralProgression() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConstOnNonLiteralProgression.kt");
        }

        @Test
        @TestMetadata("stepNonConst.kt")
        public void testStepNonConst() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConst.kt");
        }

        @Test
        @TestMetadata("stepNonConstOnNonLiteralProgression.kt")
        public void testStepNonConstOnNonLiteralProgression() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConstOnNonLiteralProgression.kt");
        }

        @Test
        @TestMetadata("stepOnNonLiteralRange.kt")
        public void testStepOnNonLiteralRange() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOnNonLiteralRange.kt");
        }

        @Test
        @TestMetadata("stepOne.kt")
        public void testStepOne() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOne.kt");
        }

        @Test
        @TestMetadata("stepOneThenStepOne.kt")
        public void testStepOneThenStepOne() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOneThenStepOne.kt");
        }

        @Test
        @TestMetadata("stepThenDifferentStep.kt")
        public void testStepThenDifferentStep() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenDifferentStep.kt");
        }

        @Test
        @TestMetadata("stepThenReversed.kt")
        public void testStepThenReversed() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenReversed.kt");
        }

        @Test
        @TestMetadata("stepThenSameStep.kt")
        public void testStepThenSameStep() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenSameStep.kt");
        }

        @Test
        @TestMetadata("stepThenStepNonConst.kt")
        public void testStepThenStepNonConst() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepNonConst.kt");
        }

        @Test
        @TestMetadata("stepThenStepOne.kt")
        public void testStepThenStepOne() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepOne.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/unsigned")
      @TestDataPath("$PROJECT_ROOT")
      public class Unsigned {
        @Test
        public void testAllFilesPresentInUnsigned() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/unsigned"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInConstBoundUnsignedRange.kt")
        public void testForInConstBoundUnsignedRange() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInConstBoundUnsignedRange.kt");
        }

        @Test
        @TestMetadata("forInDownToUIntMinValue.kt")
        public void testForInDownToUIntMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToUIntMinValue.kt");
        }

        @Test
        @TestMetadata("forInDownToULongMinValue.kt")
        public void testForInDownToULongMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToULongMinValue.kt");
        }

        @Test
        @TestMetadata("forInOptimizableUnsignedRange.kt")
        public void testForInOptimizableUnsignedRange() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInOptimizableUnsignedRange.kt");
        }

        @Test
        @TestMetadata("forInRangeToUIntMaxValue.kt")
        public void testForInRangeToUIntMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToUIntMaxValue.kt");
        }

        @Test
        @TestMetadata("forInRangeToULongMaxValue.kt")
        public void testForInRangeToULongMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToULongMaxValue.kt");
        }

        @Test
        @TestMetadata("forInUnsignedArray.kt")
        public void testForInUnsignedArray() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArray.kt");
        }

        @Test
        @TestMetadata("forInUnsignedArrayIndices.kt")
        public void testForInUnsignedArrayIndices() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayIndices.kt");
        }

        @Test
        @TestMetadata("forInUnsignedArrayWithIndex.kt")
        public void testForInUnsignedArrayWithIndex() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayWithIndex.kt");
        }

        @Test
        @TestMetadata("forInUntilUIntMaxValue.kt")
        public void testForInUntilUIntMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMaxValue.kt");
        }

        @Test
        @TestMetadata("forInUntilUIntMinValue.kt")
        public void testForInUntilUIntMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMinValue.kt");
        }

        @Test
        @TestMetadata("forInUntilULongMaxValue.kt")
        public void testForInUntilULongMaxValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMaxValue.kt");
        }

        @Test
        @TestMetadata("forInUntilULongMinValue.kt")
        public void testForInUntilULongMinValue() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMinValue.kt");
        }

        @Test
        @TestMetadata("illegalStepConst.kt")
        public void testIllegalStepConst() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/illegalStepConst.kt");
        }

        @Test
        @TestMetadata("reversedThenStep.kt")
        public void testReversedThenStep() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/reversedThenStep.kt");
        }

        @Test
        @TestMetadata("stepConstOnNonLiteralProgression.kt")
        public void testStepConstOnNonLiteralProgression() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepConstOnNonLiteralProgression.kt");
        }

        @Test
        @TestMetadata("stepNonConstOnNonLiteralProgression.kt")
        public void testStepNonConstOnNonLiteralProgression() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepNonConstOnNonLiteralProgression.kt");
        }

        @Test
        @TestMetadata("stepOnNonLiteralRange.kt")
        public void testStepOnNonLiteralRange() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepOnNonLiteralRange.kt");
        }

        @Test
        @TestMetadata("stepThenDifferentStep.kt")
        public void testStepThenDifferentStep() {
          runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepThenDifferentStep.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/hashCode")
    @TestDataPath("$PROJECT_ROOT")
    public class HashCode {
      @Test
      public void testAllFilesPresentInHashCode() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("interfaceHashCode.kt")
      public void testInterfaceHashCode() {
        runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCode.kt");
      }

      @Test
      @TestMetadata("interfaceHashCodeWithSmartCast.kt")
      public void testInterfaceHashCodeWithSmartCast() {
        runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCodeWithSmartCast.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/ieee754")
    @TestDataPath("$PROJECT_ROOT")
    public class Ieee754 {
      @Test
      public void testAllFilesPresentInIeee754() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("nullableDoubleEquals.kt")
      public void testNullableDoubleEquals() {
        runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleEquals.kt");
      }

      @Test
      @TestMetadata("nullableDoubleNotEquals.kt")
      public void testNullableDoubleNotEquals() {
        runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleNotEquals.kt");
      }

      @Test
      @TestMetadata("nullableFloatEquals.kt")
      public void testNullableFloatEquals() {
        runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatEquals.kt");
      }

      @Test
      @TestMetadata("nullableFloatNotEquals.kt")
      public void testNullableFloatNotEquals() {
        runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatNotEquals.kt");
      }

      @Test
      @TestMetadata("smartCastsForDouble.kt")
      public void testSmartCastsForDouble() {
        runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForDouble.kt");
      }

      @Test
      @TestMetadata("smartCastsForFloat.kt")
      public void testSmartCastsForFloat() {
        runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForFloat.kt");
      }

      @Test
      @TestMetadata("when.kt")
      public void testWhen() {
        runTest("compiler/testData/codegen/bytecodeText/ieee754/when.kt");
      }

      @Test
      @TestMetadata("whenNullableSmartCast.kt")
      public void testWhenNullableSmartCast() {
        runTest("compiler/testData/codegen/bytecodeText/ieee754/whenNullableSmartCast.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/inline")
    @TestDataPath("$PROJECT_ROOT")
    public class Inline {
      @Test
      public void testAllFilesPresentInInline() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("defaultLambda.kt")
      public void testDefaultLambda() {
        runTest("compiler/testData/codegen/bytecodeText/inline/defaultLambda.kt");
      }

      @Test
      @TestMetadata("deleteClassOnTransformation.kt")
      public void testDeleteClassOnTransformation() {
        runTest("compiler/testData/codegen/bytecodeText/inline/deleteClassOnTransformation.kt");
      }

      @Test
      @TestMetadata("entriesMappingOnCallSite.kt")
      public void testEntriesMappingOnCallSite() {
        runTest("compiler/testData/codegen/bytecodeText/inline/entriesMappingOnCallSite.kt");
      }

      @Test
      @TestMetadata("finallyMarkers.kt")
      public void testFinallyMarkers() {
        runTest("compiler/testData/codegen/bytecodeText/inline/finallyMarkers.kt");
      }

      @Test
      @TestMetadata("inlineArgumentSlots.kt")
      public void testInlineArgumentSlots() {
        runTest("compiler/testData/codegen/bytecodeText/inline/inlineArgumentSlots.kt");
      }

      @Test
      @TestMetadata("inlineReturnsNothing1.kt")
      public void testInlineReturnsNothing1() {
        runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing1.kt");
      }

      @Test
      @TestMetadata("inlineReturnsNothing2.kt")
      public void testInlineReturnsNothing2() {
        runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing2.kt");
      }

      @Test
      @TestMetadata("inlineReturnsNothing3.kt")
      public void testInlineReturnsNothing3() {
        runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing3.kt");
      }

      @Test
      @TestMetadata("inlineSuspendReifiedNoSpilling.kt")
      public void testInlineSuspendReifiedNoSpilling() {
        runTest("compiler/testData/codegen/bytecodeText/inline/inlineSuspendReifiedNoSpilling.kt");
      }

      @Test
      @TestMetadata("interfaceDefaultMethod.kt")
      public void testInterfaceDefaultMethod() {
        runTest("compiler/testData/codegen/bytecodeText/inline/interfaceDefaultMethod.kt");
      }

      @Test
      @TestMetadata("linenumberForOneParametersArgumentCall.kt")
      public void testLinenumberForOneParametersArgumentCall() {
        runTest("compiler/testData/codegen/bytecodeText/inline/linenumberForOneParametersArgumentCall.kt");
      }

      @Test
      @TestMetadata("noFakeVariableForInlineOnlyFun.kt")
      public void testNoFakeVariableForInlineOnlyFun() {
        runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFun.kt");
      }

      @Test
      @TestMetadata("noFakeVariableForInlineOnlyFunFromStdlib.kt")
      public void testNoFakeVariableForInlineOnlyFunFromStdlib() {
        runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunFromStdlib.kt");
      }

      @Test
      @TestMetadata("noFakeVariableForInlineOnlyFunMap.kt")
      public void testNoFakeVariableForInlineOnlyFunMap() {
        runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunMap.kt");
      }

      @Test
      @TestMetadata("noFakeVariableForInlineOnlyFunWithLambda.kt")
      public void testNoFakeVariableForInlineOnlyFunWithLambda() {
        runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunWithLambda.kt");
      }

      @Test
      @TestMetadata("noSynAccessor.kt")
      public void testNoSynAccessor() {
        runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessor.kt");
      }

      @Test
      @TestMetadata("noSynAccessorToDirectFieldAccess.kt")
      public void testNoSynAccessorToDirectFieldAccess() {
        runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToDirectFieldAccess.kt");
      }

      @Test
      @TestMetadata("noSynAccessorToSuper.kt")
      public void testNoSynAccessorToSuper() {
        runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToSuper.kt");
      }

      @Test
      @TestMetadata("notSplitedExceptionTable.kt")
      public void testNotSplitedExceptionTable() {
        runTest("compiler/testData/codegen/bytecodeText/inline/notSplitedExceptionTable.kt");
      }

      @Test
      @TestMetadata("reifiedSafeAsWithMutable.kt")
      public void testReifiedSafeAsWithMutable() {
        runTest("compiler/testData/codegen/bytecodeText/inline/reifiedSafeAsWithMutable.kt");
      }

      @Test
      @TestMetadata("remappedLocalVar.kt")
      public void testRemappedLocalVar() {
        runTest("compiler/testData/codegen/bytecodeText/inline/remappedLocalVar.kt");
      }

      @Test
      @TestMetadata("removedFinallyMarkers.kt")
      public void testRemovedFinallyMarkers() {
        runTest("compiler/testData/codegen/bytecodeText/inline/removedFinallyMarkers.kt");
      }

      @Test
      @TestMetadata("specialEnumFunction.kt")
      public void testSpecialEnumFunction() {
        runTest("compiler/testData/codegen/bytecodeText/inline/specialEnumFunction.kt");
      }

      @Test
      @TestMetadata("splitedExceptionTable.kt")
      public void testSplitedExceptionTable() {
        runTest("compiler/testData/codegen/bytecodeText/inline/splitedExceptionTable.kt");
      }

      @Test
      @TestMetadata("syntheticPropertyReference.kt")
      public void testSyntheticPropertyReference() {
        runTest("compiler/testData/codegen/bytecodeText/inline/syntheticPropertyReference.kt");
      }

      @Test
      @TestMetadata("whenMappingOnCallSite.kt")
      public void testWhenMappingOnCallSite() {
        runTest("compiler/testData/codegen/bytecodeText/inline/whenMappingOnCallSite.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/inline/property")
      @TestDataPath("$PROJECT_ROOT")
      public class Property {
        @Test
        public void testAllFilesPresentInProperty() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/bytecodeText/inline/property/simple.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/inlineArgsInPlace")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineArgsInPlace {
      @Test
      public void testAllFilesPresentInInlineArgsInPlace() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kotlinMathMax.kt")
      public void testKotlinMathMax() {
        runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/kotlinMathMax.kt");
      }

      @Test
      @TestMetadata("println.kt")
      public void testPrintln() {
        runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/println.kt");
      }

      @Test
      @TestMetadata("sin.kt")
      public void testSin() {
        runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/sin.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
      @Test
      public void testAllFilesPresentInInlineClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("asCastForInlineClass.kt")
      public void testAsCastForInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/asCastForInlineClass.kt");
      }

      @Test
      @TestMetadata("assertionsForParametersOfInlineClassTypes.kt")
      public void testAssertionsForParametersOfInlineClassTypes() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/assertionsForParametersOfInlineClassTypes.kt");
      }

      @Test
      @TestMetadata("boxInlineClassInsideElvisWithNullConstant.kt")
      public void testBoxInlineClassInsideElvisWithNullConstant() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassInsideElvisWithNullConstant.kt");
      }

      @Test
      @TestMetadata("boxInlineClassesOnPassingToVarargs.kt")
      public void testBoxInlineClassesOnPassingToVarargs() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassesOnPassingToVarargs.kt");
      }

      @Test
      @TestMetadata("boxMethodCalledByInlineClass.kt")
      public void testBoxMethodCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxMethodCalledByInlineClass.kt");
      }

      @Test
      @TestMetadata("boxResultAfterConstructorCall.kt")
      public void testBoxResultAfterConstructorCall() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultAfterConstructorCall.kt");
      }

      @Test
      @TestMetadata("boxResultInlineClassOfConstructorCall.kt")
      public void testBoxResultInlineClassOfConstructorCall() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultInlineClassOfConstructorCall.kt");
      }

      @Test
      @TestMetadata("boxThisOfInlineClass.kt")
      public void testBoxThisOfInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxThisOfInlineClass.kt");
      }

      @Test
      @TestMetadata("boxUnboxInlineClassFromMethodReturnType.kt")
      public void testBoxUnboxInlineClassFromMethodReturnType() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInlineClassFromMethodReturnType.kt");
      }

      @Test
      @TestMetadata("boxUnboxInsideLambdaAsLastExpression.kt")
      public void testBoxUnboxInsideLambdaAsLastExpression() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInsideLambdaAsLastExpression.kt");
      }

      @Test
      @TestMetadata("boxUnboxOfInlineClassesWithFunctionalTypes.kt")
      public void testBoxUnboxOfInlineClassesWithFunctionalTypes() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOfInlineClassesWithFunctionalTypes.kt");
      }

      @Test
      @TestMetadata("boxUnboxOnInlinedParameters.kt")
      public void testBoxUnboxOnInlinedParameters() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOnInlinedParameters.kt");
      }

      @Test
      @TestMetadata("boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt")
      public void testBoxingForNonLocalAndLabeledReturnsOfInlineClasses() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt");
      }

      @Test
      @TestMetadata("callMemberMethodsInsideInlineClass.kt")
      public void testCallMemberMethodsInsideInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/callMemberMethodsInsideInlineClass.kt");
      }

      @Test
      @TestMetadata("checkBoxingInInlineClass.kt")
      public void testCheckBoxingInInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkBoxingInInlineClass.kt");
      }

      @Test
      @TestMetadata("checkOuterInlineFunctionCall.kt")
      public void testCheckOuterInlineFunctionCall() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkOuterInlineFunctionCall.kt");
      }

      @Test
      @TestMetadata("constructorBridge.kt")
      public void testConstructorBridge() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorBridge.kt");
      }

      @Test
      @TestMetadata("constructorWithDefaultArguments.kt")
      public void testConstructorWithDefaultArguments() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorWithDefaultArguments.kt");
      }

      @Test
      @TestMetadata("defaultParametersDontBox.kt")
      public void testDefaultParametersDontBox() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/defaultParametersDontBox.kt");
      }

      @Test
      @TestMetadata("delegatedPropertyMangling.kt")
      public void testDelegatedPropertyMangling() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/delegatedPropertyMangling.kt");
      }

      @Test
      @TestMetadata("equalsDoesNotBox.kt")
      public void testEqualsDoesNotBox() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsDoesNotBox.kt");
      }

      @Test
      @TestMetadata("equalsIsCalledByInlineClass.kt")
      public void testEqualsIsCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsIsCalledByInlineClass.kt");
      }

      @Test
      @TestMetadata("factoryMethodForSecondaryConstructorsCalledByInlineClass.kt")
      public void testFactoryMethodForSecondaryConstructorsCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/factoryMethodForSecondaryConstructorsCalledByInlineClass.kt");
      }

      @Test
      @TestMetadata("functionsWithInlineClassParametersHaveStableMangledNames.kt")
      public void testFunctionsWithInlineClassParametersHaveStableMangledNames() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/functionsWithInlineClassParametersHaveStableMangledNames.kt");
      }

      @Test
      @TestMetadata("generationOfAccessorToUnderlyingValue.kt")
      public void testGenerationOfAccessorToUnderlyingValue() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/generationOfAccessorToUnderlyingValue.kt");
      }

      @Test
      @TestMetadata("genericNoUnbox.kt")
      public void testGenericNoUnbox() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/genericNoUnbox.kt");
      }

      @Test
      @TestMetadata("hashCodeIsCalledByInlineClass.kt")
      public void testHashCodeIsCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/hashCodeIsCalledByInlineClass.kt");
      }

      @Test
      @TestMetadata("inlineClassBoxingOnAssignment.kt")
      public void testInlineClassBoxingOnAssignment() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnAssignment.kt");
      }

      @Test
      @TestMetadata("inlineClassBoxingOnFunctionCall.kt")
      public void testInlineClassBoxingOnFunctionCall() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnFunctionCall.kt");
      }

      @Test
      @TestMetadata("inlineClassBoxingUnboxingInsideInlinedLambda.kt")
      public void testInlineClassBoxingUnboxingInsideInlinedLambda() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingUnboxingInsideInlinedLambda.kt");
      }

      @Test
      @TestMetadata("inlineClassInGeneratedToString.kt")
      public void testInlineClassInGeneratedToString() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInGeneratedToString.kt");
      }

      @Test
      @TestMetadata("inlineClassInStringTemplate.kt")
      public void testInlineClassInStringTemplate() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInStringTemplate.kt");
      }

      @Test
      @TestMetadata("inlineClassesUnboxingAfterAssertionOperator.kt")
      public void testInlineClassesUnboxingAfterAssertionOperator() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassesUnboxingAfterAssertionOperator.kt");
      }

      @Test
      @TestMetadata("interfaceDefaultImplStubs.kt")
      public void testInterfaceDefaultImplStubs() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/interfaceDefaultImplStubs.kt");
      }

      @Test
      @TestMetadata("isCheckForInlineClass.kt")
      public void testIsCheckForInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/isCheckForInlineClass.kt");
      }

      @Test
      @TestMetadata("kt33722.kt")
      public void testKt33722() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/kt33722.kt");
      }

      @Test
      @TestMetadata("mangledInlineClassInterfaceImplementation.kt")
      public void testMangledInlineClassInterfaceImplementation() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledInlineClassInterfaceImplementation.kt");
      }

      @Test
      @TestMetadata("mangledSamWrappers.kt")
      public void testMangledSamWrappers() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappers.kt");
      }

      @Test
      @TestMetadata("mangledSamWrappersIndy.kt")
      public void testMangledSamWrappersIndy() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersIndy.kt");
      }

      @Test
      @TestMetadata("mangledSamWrappersOld.kt")
      public void testMangledSamWrappersOld() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersOld.kt");
      }

      @Test
      @TestMetadata("noActualCallsOfInlineFunctionsOfInlineClass.kt")
      public void testNoActualCallsOfInlineFunctionsOfInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noActualCallsOfInlineFunctionsOfInlineClass.kt");
      }

      @Test
      @TestMetadata("noAssertionsForInlineClassesBasedOnNullableTypes.kt")
      public void testNoAssertionsForInlineClassesBasedOnNullableTypes() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noAssertionsForInlineClassesBasedOnNullableTypes.kt");
      }

      @Test
      @TestMetadata("noBoxingInMethod.kt")
      public void testNoBoxingInMethod() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingInMethod.kt");
      }

      @Test
      @TestMetadata("noBoxingOnCastOperations.kt")
      public void testNoBoxingOnCastOperations() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOnCastOperations.kt");
      }

      @Test
      @TestMetadata("noBoxingOperationsOnNonTrivialSpread.kt")
      public void testNoBoxingOperationsOnNonTrivialSpread() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOperationsOnNonTrivialSpread.kt");
      }

      @Test
      @TestMetadata("noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt")
      public void testNoBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt");
      }

      @Test
      @TestMetadata("noManglingForFunctionsWithJvmName.kt")
      public void testNoManglingForFunctionsWithJvmName() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noManglingForFunctionsWithJvmName.kt");
      }

      @Test
      @TestMetadata("noReturnTypeMangling.kt")
      public void testNoReturnTypeMangling() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noReturnTypeMangling.kt");
      }

      @Test
      @TestMetadata("nonOverridingMethodsAreCalledByInlineClass.kt")
      public void testNonOverridingMethodsAreCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/nonOverridingMethodsAreCalledByInlineClass.kt");
      }

      @Test
      @TestMetadata("overridingMethodsAreCalledByInlineClass.kt")
      public void testOverridingMethodsAreCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/overridingMethodsAreCalledByInlineClass.kt");
      }

      @Test
      @TestMetadata("passInlineClassesWithSpreadOperatorToVarargs.kt")
      public void testPassInlineClassesWithSpreadOperatorToVarargs() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/passInlineClassesWithSpreadOperatorToVarargs.kt");
      }

      @Test
      @TestMetadata("primaryConstructorCalledByInlineClass.kt")
      public void testPrimaryConstructorCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/primaryConstructorCalledByInlineClass.kt");
      }

      @Test
      @TestMetadata("propertyAccessorsAreCalledByInlineClass.kt")
      public void testPropertyAccessorsAreCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertyAccessorsAreCalledByInlineClass.kt");
      }

      @Test
      @TestMetadata("propertySetterWithInlineClassTypeArgument.kt")
      public void testPropertySetterWithInlineClassTypeArgument() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertySetterWithInlineClassTypeArgument.kt");
      }

      @Test
      @TestMetadata("resultApiDoesntCallSpecializedEquals.kt")
      public void testResultApiDoesntCallSpecializedEquals() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntCallSpecializedEquals.kt");
      }

      @Test
      @TestMetadata("resultApiDoesntUseBox.kt")
      public void testResultApiDoesntUseBox() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntUseBox.kt");
      }

      @Test
      @TestMetadata("resultApiEqualsDoesntBox.kt")
      public void testResultApiEqualsDoesntBox() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiEqualsDoesntBox.kt");
      }

      @Test
      @TestMetadata("resultApiRunCatchingDoesntBox.kt")
      public void testResultApiRunCatchingDoesntBox() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiRunCatchingDoesntBox.kt");
      }

      @Test
      @TestMetadata("resultApiStringInterpolationDoesntBox.kt")
      public void testResultApiStringInterpolationDoesntBox() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiStringInterpolationDoesntBox.kt");
      }

      @Test
      @TestMetadata("resultMangling.kt")
      public void testResultMangling() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultMangling.kt");
      }

      @Test
      @TestMetadata("skipCallToUnderlyingValueOfInlineClass.kt")
      public void testSkipCallToUnderlyingValueOfInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/skipCallToUnderlyingValueOfInlineClass.kt");
      }

      @Test
      @TestMetadata("suspendFunctionMangling.kt")
      public void testSuspendFunctionMangling() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/suspendFunctionMangling.kt");
      }

      @Test
      @TestMetadata("toStringOfInlineClassValue.kt")
      public void testToStringOfInlineClassValue() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfInlineClassValue.kt");
      }

      @Test
      @TestMetadata("toStringOfReferenceInlineClassValue.kt")
      public void testToStringOfReferenceInlineClassValue() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfReferenceInlineClassValue.kt");
      }

      @Test
      @TestMetadata("uIntArrayIteratorWithoutBoxing.kt")
      public void testUIntArrayIteratorWithoutBoxing() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArrayIteratorWithoutBoxing.kt");
      }

      @Test
      @TestMetadata("uIntArraySwapBoxing.kt")
      public void testUIntArraySwapBoxing() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArraySwapBoxing.kt");
      }

      @Test
      @TestMetadata("unboxInlineClassAfterElvis.kt")
      public void testUnboxInlineClassAfterElvis() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterElvis.kt");
      }

      @Test
      @TestMetadata("unboxInlineClassAfterSafeCall.kt")
      public void testUnboxInlineClassAfterSafeCall() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterSafeCall.kt");
      }

      @Test
      @TestMetadata("unboxInlineClassFromParameterizedType.kt")
      public void testUnboxInlineClassFromParameterizedType() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassFromParameterizedType.kt");
      }

      @Test
      @TestMetadata("unboxInlineClassesAfterSmartCasts.kt")
      public void testUnboxInlineClassesAfterSmartCasts() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassesAfterSmartCasts.kt");
      }

      @Test
      @TestMetadata("unboxMethodCalledByInlineClass.kt")
      public void testUnboxMethodCalledByInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxMethodCalledByInlineClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/innerClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InnerClasses {
      @Test
      public void testAllFilesPresentInInnerClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt27936.kt")
      public void testKt27936() {
        runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt27936.kt");
      }

      @Test
      @TestMetadata("kt53804.kt")
      public void testKt53804() {
        runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt53804.kt");
      }

      @Test
      @TestMetadata("kt56104.kt")
      public void testKt56104() {
        runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt56104.kt");
      }

      @Test
      @TestMetadata("kt57714.kt")
      public void testKt57714() {
        runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt57714.kt");
      }

      @Test
      @TestMetadata("nestedClassInAnnotationArgument.kt")
      public void testNestedClassInAnnotationArgument() {
        runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgument.kt");
      }

      @Test
      @TestMetadata("nestedClassInAnnotationArgumentOldMode.kt")
      public void testNestedClassInAnnotationArgumentOldMode() {
        runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgumentOldMode.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/interfaces")
    @TestDataPath("$PROJECT_ROOT")
    public class Interfaces {
      @Test
      @TestMetadata("addedInterfaceBridge.kt")
      public void testAddedInterfaceBridge() {
        runTest("compiler/testData/codegen/bytecodeText/interfaces/addedInterfaceBridge.kt");
      }

      @Test
      public void testAllFilesPresentInInterfaces() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/interfaces"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("firstInheritedMethodIsAbstract.kt")
      public void testFirstInheritedMethodIsAbstract() {
        runTest("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstract.kt");
      }

      @Test
      @TestMetadata("noAnyMethodsOnInterfaceInheritance.kt")
      public void testNoAnyMethodsOnInterfaceInheritance() {
        runTest("compiler/testData/codegen/bytecodeText/interfaces/noAnyMethodsOnInterfaceInheritance.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnThisInDefaultMethod.kt")
      public void testNoNullCheckOnThisInDefaultMethod() {
        runTest("compiler/testData/codegen/bytecodeText/interfaces/noNullCheckOnThisInDefaultMethod.kt");
      }

      @Test
      @TestMetadata("noPrivateMemberInJavaInterface.kt")
      public void testNoPrivateMemberInJavaInterface() {
        runTest("compiler/testData/codegen/bytecodeText/interfaces/noPrivateMemberInJavaInterface.kt");
      }

      @Test
      @TestMetadata("traitImplGeneratedOnce.kt")
      public void testTraitImplGeneratedOnce() {
        runTest("compiler/testData/codegen/bytecodeText/interfaces/traitImplGeneratedOnce.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/intrinsics")
    @TestDataPath("$PROJECT_ROOT")
    public class Intrinsics {
      @Test
      public void testAllFilesPresentInIntrinsics() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("javaObjectType.kt")
      public void testJavaObjectType() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaObjectType.kt");
      }

      @Test
      @TestMetadata("javaPrimitiveType.kt")
      public void testJavaPrimitiveType() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaPrimitiveType.kt");
      }

      @Test
      @TestMetadata("postfixIncrDecr.kt")
      public void testPostfixIncrDecr() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsics/postfixIncrDecr.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/intrinsicsCompare")
    @TestDataPath("$PROJECT_ROOT")
    public class IntrinsicsCompare {
      @Test
      public void testAllFilesPresentInIntrinsicsCompare() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsCompare"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("byteSmartCast_after.kt")
      public void testByteSmartCast_after() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_after.kt");
      }

      @Test
      @TestMetadata("byteSmartCast_before.kt")
      public void testByteSmartCast_before() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_before.kt");
      }

      @Test
      @TestMetadata("charSmartCast.kt")
      public void testCharSmartCast() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/charSmartCast.kt");
      }

      @Test
      @TestMetadata("differentTypes_after.kt")
      public void testDifferentTypes_after() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_after.kt");
      }

      @Test
      @TestMetadata("differentTypes_before.kt")
      public void testDifferentTypes_before() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_before.kt");
      }

      @Test
      @TestMetadata("intSmartCast_after.kt")
      public void testIntSmartCast_after() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_after.kt");
      }

      @Test
      @TestMetadata("intSmartCast_before.kt")
      public void testIntSmartCast_before() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_before.kt");
      }

      @Test
      @TestMetadata("longSmartCast.kt")
      public void testLongSmartCast() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/longSmartCast.kt");
      }

      @Test
      @TestMetadata("shortSmartCast_after.kt")
      public void testShortSmartCast_after() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_after.kt");
      }

      @Test
      @TestMetadata("shortSmartCast_before.kt")
      public void testShortSmartCast_before() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_before.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/intrinsicsTrim")
    @TestDataPath("$PROJECT_ROOT")
    public class IntrinsicsTrim {
      @Test
      public void testAllFilesPresentInIntrinsicsTrim() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsTrim"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("trimIndentNegative.kt")
      public void testTrimIndentNegative() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentNegative.kt");
      }

      @Test
      @TestMetadata("trimIndentPositive.kt")
      public void testTrimIndentPositive() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentPositive.kt");
      }

      @Test
      @TestMetadata("trimMarginNegative.kt")
      public void testTrimMarginNegative() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginNegative.kt");
      }

      @Test
      @TestMetadata("trimMarginPositive.kt")
      public void testTrimMarginPositive() {
        runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginPositive.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/invokedynamic")
    @TestDataPath("$PROJECT_ROOT")
    public class Invokedynamic {
      @Test
      public void testAllFilesPresentInInvokedynamic() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("extensionReceiversNames.kt")
      public void testExtensionReceiversNames() {
        runTest("compiler/testData/codegen/bytecodeText/invokedynamic/extensionReceiversNames.kt");
      }

      @Test
      @TestMetadata("functionRefToJavaInterface.kt")
      public void testFunctionRefToJavaInterface() {
        runTest("compiler/testData/codegen/bytecodeText/invokedynamic/functionRefToJavaInterface.kt");
      }

      @Test
      @TestMetadata("lambdas.kt")
      public void testLambdas() {
        runTest("compiler/testData/codegen/bytecodeText/invokedynamic/lambdas.kt");
      }

      @Test
      @TestMetadata("streamApi.kt")
      public void testStreamApi() {
        runTest("compiler/testData/codegen/bytecodeText/invokedynamic/streamApi.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    public class Jvm8 {
      @Test
      public void testAllFilesPresentInJvm8() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/hashCode")
      @TestDataPath("$PROJECT_ROOT")
      public class HashCode {
        @Test
        public void testAllFilesPresentInHashCode() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("dataClass.kt")
        public void testDataClass() {
          runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/dataClass.kt");
        }

        @Test
        @TestMetadata("hashCode.kt")
        public void testHashCode() {
          runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/hashCode.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault")
      @TestDataPath("$PROJECT_ROOT")
      public class JvmDefault {
        @Test
        public void testAllFilesPresentInJvmDefault() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility")
        @TestDataPath("$PROJECT_ROOT")
        public class AllCompatibility {
          @Test
          public void testAllFilesPresentInAllCompatibility() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("defaultArgs.kt")
          public void testDefaultArgs() {
            runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/defaultArgs.kt");
          }

          @Test
          @TestMetadata("simpleDiamond.kt")
          public void testSimpleDiamond() {
            runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleDiamond.kt");
          }

          @Test
          @TestMetadata("simpleFunction.kt")
          public void testSimpleFunction() {
            runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunction.kt");
          }

          @Test
          @TestMetadata("simpleFunctionWithAbstractOverride.kt")
          public void testSimpleFunctionWithAbstractOverride() {
            runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunctionWithAbstractOverride.kt");
          }

          @Test
          @TestMetadata("simpleProperty.kt")
          public void testSimpleProperty() {
            runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleProperty.kt");
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen")
    @TestDataPath("$PROJECT_ROOT")
    public class LazyCodegen {
      @Test
      public void testAllFilesPresentInLazyCodegen() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("inlineConstInsideComparison.kt")
      public void testInlineConstInsideComparison() {
        runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/inlineConstInsideComparison.kt");
      }

      @Test
      @TestMetadata("negateConst.kt")
      public void testNegateConst() {
        runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConst.kt");
      }

      @Test
      @TestMetadata("negateObjectComp.kt")
      public void testNegateObjectComp() {
        runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectComp.kt");
      }

      @Test
      @TestMetadata("negateObjectCompChaing.kt")
      public void testNegateObjectCompChaing() {
        runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectCompChaing.kt");
      }

      @Test
      @TestMetadata("negateVar.kt")
      public void testNegateVar() {
        runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVar.kt");
      }

      @Test
      @TestMetadata("negateVarChain.kt")
      public void testNegateVarChain() {
        runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVarChain.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/lineNumbers")
    @TestDataPath("$PROJECT_ROOT")
    public class LineNumbers {
      @Test
      public void testAllFilesPresentInLineNumbers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lineNumbers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("delegationToList.kt")
      public void testDelegationToList() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/delegationToList.kt");
      }

      @Test
      @TestMetadata("ifConsts.kt")
      public void testIfConsts() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifConsts.kt");
      }

      @Test
      @TestMetadata("ifElse.kt")
      public void testIfElse() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifElse.kt");
      }

      @Test
      @TestMetadata("ifFalse.kt")
      public void testIfFalse() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalse.kt");
      }

      @Test
      @TestMetadata("ifFalseElse.kt")
      public void testIfFalseElse() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalseElse.kt");
      }

      @Test
      @TestMetadata("ifTrue.kt")
      public void testIfTrue() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrue.kt");
      }

      @Test
      @TestMetadata("ifTrueElse.kt")
      public void testIfTrueElse() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrueElse.kt");
      }

      @Test
      @TestMetadata("inlineCondition.kt")
      public void testInlineCondition() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition.kt");
      }

      @Test
      @TestMetadata("inlineCondition2.kt")
      public void testInlineCondition2() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition2.kt");
      }

      @Test
      @TestMetadata("inlineLambdaObjectInit.kt")
      public void testInlineLambdaObjectInit() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineLambdaObjectInit.kt");
      }

      @Test
      @TestMetadata("kt61768.kt")
      public void testKt61768() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/kt61768.kt");
      }

      @Test
      @TestMetadata("singleThen.kt")
      public void testSingleThen() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/singleThen.kt");
      }

      @Test
      @TestMetadata("tryCatch.kt")
      public void testTryCatch() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryCatch.kt");
      }

      @Test
      @TestMetadata("tryFinally.kt")
      public void testTryFinally() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryFinally.kt");
      }

      @Test
      @TestMetadata("when.kt")
      public void testWhen() {
        runTest("compiler/testData/codegen/bytecodeText/lineNumbers/when.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/localInitializationLVT")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalInitializationLVT {
      @Test
      public void testAllFilesPresentInLocalInitializationLVT() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/localInitializationLVT"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("boxing.kt")
      public void testBoxing() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxing.kt");
      }

      @Test
      @TestMetadata("boxingVar.kt")
      public void testBoxingVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxingVar.kt");
      }

      @Test
      @TestMetadata("contract.kt")
      public void testContract() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contract.kt");
      }

      @Test
      @TestMetadata("contractVar.kt")
      public void testContractVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contractVar.kt");
      }

      @Test
      @TestMetadata("generics.kt")
      public void testGenerics() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/generics.kt");
      }

      @Test
      @TestMetadata("genericsVar.kt")
      public void testGenericsVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/genericsVar.kt");
      }

      @Test
      @TestMetadata("ifStatement.kt")
      public void testIfStatement() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatement.kt");
      }

      @Test
      @TestMetadata("ifStatementVar.kt")
      public void testIfStatementVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementVar.kt");
      }

      @Test
      @TestMetadata("ifStatementWithoutBlock.kt")
      public void testIfStatementWithoutBlock() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlock.kt");
      }

      @Test
      @TestMetadata("ifStatementWithoutBlockVar.kt")
      public void testIfStatementWithoutBlockVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlockVar.kt");
      }

      @Test
      @TestMetadata("inlineClass.kt")
      public void testInlineClass() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClass.kt");
      }

      @Test
      @TestMetadata("inlineClassVar.kt")
      public void testInlineClassVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClassVar.kt");
      }

      @Test
      @TestMetadata("lateinit.kt")
      public void testLateinit() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/lateinit.kt");
      }

      @Test
      @TestMetadata("run.kt")
      public void testRun() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/run.kt");
      }

      @Test
      @TestMetadata("runVar.kt")
      public void testRunVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/runVar.kt");
      }

      @Test
      @TestMetadata("singleBlock.kt")
      public void testSingleBlock() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlock.kt");
      }

      @Test
      @TestMetadata("singleBlockVar.kt")
      public void testSingleBlockVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlockVar.kt");
      }

      @Test
      @TestMetadata("whenStatement.kt")
      public void testWhenStatement() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatement.kt");
      }

      @Test
      @TestMetadata("whenStatementVar.kt")
      public void testWhenStatementVar() {
        runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatementVar.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/mangling")
    @TestDataPath("$PROJECT_ROOT")
    public class Mangling {
      @Test
      public void testAllFilesPresentInMangling() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/mangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("parentheses.kt")
      public void testParentheses() {
        runTest("compiler/testData/codegen/bytecodeText/mangling/parentheses.kt");
      }

      @Test
      @TestMetadata("parenthesesNoSanitize.kt")
      public void testParenthesesNoSanitize() {
        runTest("compiler/testData/codegen/bytecodeText/mangling/parenthesesNoSanitize.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class MultifileClasses {
      @Test
      public void testAllFilesPresentInMultifileClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("defaultFunctionInMultifileClass.kt")
      public void testDefaultFunctionInMultifileClass() {
        runTest("compiler/testData/codegen/bytecodeText/multifileClasses/defaultFunctionInMultifileClass.kt");
      }

      @Test
      @TestMetadata("optimizedMultifileClassFacadeMethods.kt")
      public void testOptimizedMultifileClassFacadeMethods() {
        runTest("compiler/testData/codegen/bytecodeText/multifileClasses/optimizedMultifileClassFacadeMethods.kt");
      }

      @Test
      @TestMetadata("privateFunctionName.kt")
      public void testPrivateFunctionName() {
        runTest("compiler/testData/codegen/bytecodeText/multifileClasses/privateFunctionName.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/notNullAssertions")
    @TestDataPath("$PROJECT_ROOT")
    public class NotNullAssertions {
      @Test
      public void testAllFilesPresentInNotNullAssertions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayListGet.kt")
      public void testArrayListGet() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/arrayListGet.kt");
      }

      @Test
      @TestMetadata("assertionForNotNullCaptured.kt")
      public void testAssertionForNotNullCaptured() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullCaptured.kt");
      }

      @Test
      @TestMetadata("assertionForNotNullTypeParam.kt")
      public void testAssertionForNotNullTypeParam() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam.kt");
      }

      @Test
      @TestMetadata("assertionForNotNullTypeParam_1_4.kt")
      public void testAssertionForNotNullTypeParam_1_4() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam_1_4.kt");
      }

      @Test
      @TestMetadata("doNotGenerateParamAssertions.kt")
      public void testDoNotGenerateParamAssertions() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/doNotGenerateParamAssertions.kt");
      }

      @Test
      @TestMetadata("javaMultipleSubstitutions.kt")
      public void testJavaMultipleSubstitutions() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/javaMultipleSubstitutions.kt");
      }

      @Test
      @TestMetadata("noAssertionForNullableCaptured.kt")
      public void testNoAssertionForNullableCaptured() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableCaptured.kt");
      }

      @Test
      @TestMetadata("noAssertionForNullableGenericMethod.kt")
      public void testNoAssertionForNullableGenericMethod() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethod.kt");
      }

      @Test
      @TestMetadata("noAssertionForNullableGenericMethodCall.kt")
      public void testNoAssertionForNullableGenericMethodCall() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethodCall.kt");
      }

      @Test
      @TestMetadata("noAssertionForPrivateMethod.kt")
      public void testNoAssertionForPrivateMethod() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForPrivateMethod.kt");
      }

      @Test
      @TestMetadata("noAssertionsForKotlin.kt")
      public void testNoAssertionsForKotlin() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionsForKotlin.kt");
      }

      @Test
      @TestMetadata("noTemporaryVariableInNullCheckOnExpression.kt")
      public void testNoTemporaryVariableInNullCheckOnExpression() {
        runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noTemporaryVariableInNullCheckOnExpression.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/nullCheckOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class NullCheckOptimization {
      @Test
      public void testAllFilesPresentInNullCheckOptimization() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("alreadyCheckedForIs.kt")
      public void testAlreadyCheckedForIs() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForIs.kt");
      }

      @Test
      @TestMetadata("alreadyCheckedForNull.kt")
      public void testAlreadyCheckedForNull() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForNull.kt");
      }

      @Test
      @TestMetadata("deterministicNotNullChecks.kt")
      public void testDeterministicNotNullChecks() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/deterministicNotNullChecks.kt");
      }

      @Test
      @TestMetadata("exclExclAsNotNullType.kt")
      public void testExclExclAsNotNullType() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/exclExclAsNotNullType.kt");
      }

      @Test
      @TestMetadata("expressionValueIsNotNull.kt")
      public void testExpressionValueIsNotNull() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNull.kt");
      }

      @Test
      @TestMetadata("expressionValueIsNotNullAfterExclExcl.kt")
      public void testExpressionValueIsNotNullAfterExclExcl() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullAfterExclExcl.kt");
      }

      @Test
      @TestMetadata("expressionValueIsNotNullTwice.kt")
      public void testExpressionValueIsNotNullTwice() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullTwice.kt");
      }

      @Test
      @TestMetadata("ifNullEqualsNull.kt")
      public void testIfNullEqualsNull() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNull.kt");
      }

      @Test
      @TestMetadata("ifNullEqualsNullInline.kt")
      public void testIfNullEqualsNullInline() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNullInline.kt");
      }

      @Test
      @TestMetadata("ifUnitEqualsNull.kt")
      public void testIfUnitEqualsNull() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNull.kt");
      }

      @Test
      @TestMetadata("ifUnitEqualsNullInline.kt")
      public void testIfUnitEqualsNullInline() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNullInline.kt");
      }

      @Test
      @TestMetadata("kt12839.kt")
      public void testKt12839() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/kt12839.kt");
      }

      @Test
      @TestMetadata("multipleExclExcl_1_4.kt")
      public void testMultipleExclExcl_1_4() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/multipleExclExcl_1_4.kt");
      }

      @Test
      @TestMetadata("noNullCheckAfterCast.kt")
      public void testNoNullCheckAfterCast() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/noNullCheckAfterCast.kt");
      }

      @Test
      @TestMetadata("notNullAsNotNullable.kt")
      public void testNotNullAsNotNullable() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullAsNotNullable.kt");
      }

      @Test
      @TestMetadata("notNullExpressionValueTwice_1_4.kt")
      public void testNotNullExpressionValueTwice_1_4() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullExpressionValueTwice_1_4.kt");
      }

      @Test
      @TestMetadata("nullCheckAfterExclExcl_1_4.kt")
      public void testNullCheckAfterExclExcl_1_4() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullCheckAfterExclExcl_1_4.kt");
      }

      @Test
      @TestMetadata("nullabilityAssertionOnDispatchReceiver.kt")
      public void testNullabilityAssertionOnDispatchReceiver() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullabilityAssertionOnDispatchReceiver.kt");
      }

      @Test
      @TestMetadata("primitiveCheck.kt")
      public void testPrimitiveCheck() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/primitiveCheck.kt");
      }

      @Test
      @TestMetadata("redundantSafeCall.kt")
      public void testRedundantSafeCall() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall.kt");
      }

      @Test
      @TestMetadata("redundantSafeCall_1_4.kt")
      public void testRedundantSafeCall_1_4() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall_1_4.kt");
      }

      @Test
      @TestMetadata("reifiedIs.kt")
      public void testReifiedIs() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedIs.kt");
      }

      @Test
      @TestMetadata("reifiedNullIs.kt")
      public void testReifiedNullIs() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedNullIs.kt");
      }

      @Test
      @TestMetadata("safeCallAndElvisChains.kt")
      public void testSafeCallAndElvisChains() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/safeCallAndElvisChains.kt");
      }

      @Test
      @TestMetadata("trivialInstanceOf.kt")
      public void testTrivialInstanceOf() {
        runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/trivialInstanceOf.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit")
      @TestDataPath("$PROJECT_ROOT")
      public class LocalLateinit {
        @Test
        public void testAllFilesPresentInLocalLateinit() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("checkedAlways.kt")
        public void testCheckedAlways() {
          runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedAlways.kt");
        }

        @Test
        @TestMetadata("checkedOnce.kt")
        public void testCheckedOnce() {
          runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedOnce.kt");
        }

        @Test
        @TestMetadata("initialized.kt")
        public void testInitialized() {
          runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/initialized.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties")
    @TestDataPath("$PROJECT_ROOT")
    public class OptimizedDelegatedProperties {
      @Test
      public void testAllFilesPresentInOptimizedDelegatedProperties() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("definedInSources.kt")
      public void testDefinedInSources() {
        runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/definedInSources.kt");
      }

      @Test
      @TestMetadata("delegateToAnother.kt")
      public void testDelegateToAnother() {
        runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/delegateToAnother.kt");
      }

      @Test
      @TestMetadata("inSeparateModule.kt")
      public void testInSeparateModule() {
        runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/inSeparateModule.kt");
      }

      @Test
      @TestMetadata("lazy.kt")
      public void testLazy() {
        runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/lazy.kt");
      }

      @Test
      @TestMetadata("withNonNullMetadataParameter.kt")
      public void testWithNonNullMetadataParameter() {
        runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/withNonNullMetadataParameter.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/outerClass")
    @TestDataPath("$PROJECT_ROOT")
    public class OuterClass {
      @Test
      public void testAllFilesPresentInOuterClass() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/outerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("classInClinit.kt")
      public void testClassInClinit() {
        runTest("compiler/testData/codegen/bytecodeText/outerClass/classInClinit.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/parameterlessMain")
    @TestDataPath("$PROJECT_ROOT")
    public class ParameterlessMain {
      @Test
      public void testAllFilesPresentInParameterlessMain() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/parameterlessMain"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("dontGenerateOnExtensionReceiver.kt")
      public void testDontGenerateOnExtensionReceiver() {
        runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("dontGenerateOnJvmNameMain.kt")
      public void testDontGenerateOnJvmNameMain() {
        runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmNameMain.kt");
      }

      @Test
      @TestMetadata("dontGenerateOnJvmOverloads.kt")
      public void testDontGenerateOnJvmOverloads() {
        runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmOverloads.kt");
      }

      @Test
      @TestMetadata("dontGenerateOnMain.kt")
      public void testDontGenerateOnMain() {
        runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMain.kt");
      }

      @Test
      @TestMetadata("dontGenerateOnMainExtension.kt")
      public void testDontGenerateOnMainExtension() {
        runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMainExtension.kt");
      }

      @Test
      @TestMetadata("dontGenerateOnNullableArray.kt")
      public void testDontGenerateOnNullableArray() {
        runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableArray.kt");
      }

      @Test
      @TestMetadata("dontGenerateOnNullableString.kt")
      public void testDontGenerateOnNullableString() {
        runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableString.kt");
      }

      @Test
      @TestMetadata("dontGenerateOnVarargsString.kt")
      public void testDontGenerateOnVarargsString() {
        runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnVarargsString.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/properties")
    @TestDataPath("$PROJECT_ROOT")
    public class Properties {
      @Test
      public void testAllFilesPresentInProperties() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("dataClass.kt")
      public void testDataClass() {
        runTest("compiler/testData/codegen/bytecodeText/properties/dataClass.kt");
      }

      @Test
      @TestMetadata("openDataClass.kt")
      public void testOpenDataClass() {
        runTest("compiler/testData/codegen/bytecodeText/properties/openDataClass.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeText/properties/lateinit")
      @TestDataPath("$PROJECT_ROOT")
      public class Lateinit {
        @Test
        public void testAllFilesPresentInLateinit() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("companionObject.kt")
        public void testCompanionObject() {
          runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObject.kt");
        }

        @Test
        @TestMetadata("companionObjectFromLambda.kt")
        public void testCompanionObjectFromLambda() {
          runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObjectFromLambda.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/ranges")
    @TestDataPath("$PROJECT_ROOT")
    public class Ranges {
      @Test
      public void testAllFilesPresentInRanges() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ranges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("ifNotInRange.kt")
      public void testIfNotInRange() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/ifNotInRange.kt");
      }

      @Test
      @TestMetadata("inArrayIndices.kt")
      public void testInArrayIndices() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inArrayIndices.kt");
      }

      @Test
      @TestMetadata("inCharSequenceIndices.kt")
      public void testInCharSequenceIndices() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inCharSequenceIndices.kt");
      }

      @Test
      @TestMetadata("inCollectionIndices.kt")
      public void testInCollectionIndices() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inCollectionIndices.kt");
      }

      @Test
      @TestMetadata("inComparableRangeLiteral.kt")
      public void testInComparableRangeLiteral() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inComparableRangeLiteral.kt");
      }

      @Test
      @TestMetadata("inMixedUnsignedRange.kt")
      public void testInMixedUnsignedRange() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange.kt");
      }

      @Test
      @TestMetadata("inMixedUnsignedRange_2.kt")
      public void testInMixedUnsignedRange_2() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange_2.kt");
      }

      @Test
      @TestMetadata("inNonMatchingRangeIntrinsified.kt")
      public void testInNonMatchingRangeIntrinsified() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRangeIntrinsified.kt");
      }

      @Test
      @TestMetadata("inOptimizableRange.kt")
      public void testInOptimizableRange() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableRange.kt");
      }

      @Test
      @TestMetadata("inOptimizableUnsignedRange.kt")
      public void testInOptimizableUnsignedRange() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableUnsignedRange.kt");
      }

      @Test
      @TestMetadata("inRangeUntil.kt")
      public void testInRangeUntil() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inRangeUntil.kt");
      }

      @Test
      @TestMetadata("inUntil.kt")
      public void testInUntil() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/inUntil.kt");
      }

      @Test
      @TestMetadata("noDupXForLiteralRangeContains.kt")
      public void testNoDupXForLiteralRangeContains() {
        runTest("compiler/testData/codegen/bytecodeText/ranges/noDupXForLiteralRangeContains.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/sam")
    @TestDataPath("$PROJECT_ROOT")
    public class Sam {
      @Test
      public void testAllFilesPresentInSam() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("samWrapperForNullInitialization.kt")
      public void testSamWrapperForNullInitialization() {
        runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullInitialization.kt");
      }

      @Test
      @TestMetadata("samWrapperForNullableInitialization.kt")
      public void testSamWrapperForNullableInitialization() {
        runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullableInitialization.kt");
      }

      @Test
      @TestMetadata("samWrapperInInlineLambda.kt")
      public void testSamWrapperInInlineLambda() {
        runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda.kt");
      }

      @Test
      @TestMetadata("samWrapperInInlineLambda2.kt")
      public void testSamWrapperInInlineLambda2() {
        runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda2.kt");
      }

      @Test
      @TestMetadata("samWrapperOfLambda.kt")
      public void testSamWrapperOfLambda() {
        runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfLambda.kt");
      }

      @Test
      @TestMetadata("samWrapperOfReference.kt")
      public void testSamWrapperOfReference() {
        runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfReference.kt");
      }

      @Test
      @TestMetadata("samWrapperRawTypes.kt")
      public void testSamWrapperRawTypes() {
        runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperRawTypes.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/statements")
    @TestDataPath("$PROJECT_ROOT")
    public class Statements {
      @Test
      public void testAllFilesPresentInStatements() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/statements"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("ifSingleBranch.kt")
      public void testIfSingleBranch() {
        runTest("compiler/testData/codegen/bytecodeText/statements/ifSingleBranch.kt");
      }

      @Test
      @TestMetadata("ifThenElse.kt")
      public void testIfThenElse() {
        runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElse.kt");
      }

      @Test
      @TestMetadata("ifThenElseEmpty.kt")
      public void testIfThenElseEmpty() {
        runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElseEmpty.kt");
      }

      @Test
      @TestMetadata("labeled.kt")
      public void testLabeled() {
        runTest("compiler/testData/codegen/bytecodeText/statements/labeled.kt");
      }

      @Test
      @TestMetadata("statementsComposition.kt")
      public void testStatementsComposition() {
        runTest("compiler/testData/codegen/bytecodeText/statements/statementsComposition.kt");
      }

      @Test
      @TestMetadata("tryCatchFinally.kt")
      public void testTryCatchFinally() {
        runTest("compiler/testData/codegen/bytecodeText/statements/tryCatchFinally.kt");
      }

      @Test
      @TestMetadata("when.kt")
      public void testWhen() {
        runTest("compiler/testData/codegen/bytecodeText/statements/when.kt");
      }

      @Test
      @TestMetadata("whenSubject.kt")
      public void testWhenSubject() {
        runTest("compiler/testData/codegen/bytecodeText/statements/whenSubject.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/staticFields")
    @TestDataPath("$PROJECT_ROOT")
    public class StaticFields {
      @Test
      public void testAllFilesPresentInStaticFields() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/staticFields"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("classObject.kt")
      public void testClassObject() {
        runTest("compiler/testData/codegen/bytecodeText/staticFields/classObject.kt");
      }

      @Test
      @TestMetadata("object.kt")
      public void testObject() {
        runTest("compiler/testData/codegen/bytecodeText/staticFields/object.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline")
    @TestDataPath("$PROJECT_ROOT")
    public class StoreStackBeforeInline {
      @Test
      public void testAllFilesPresentInStoreStackBeforeInline() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayConstructor.kt")
      public void testArrayConstructor() {
        runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/arrayConstructor.kt");
      }

      @Test
      @TestMetadata("differentTypes.kt")
      public void testDifferentTypes() {
        runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/differentTypes.kt");
      }

      @Test
      @TestMetadata("primitiveMerge.kt")
      public void testPrimitiveMerge() {
        runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/primitiveMerge.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/simple.kt");
      }

      @Test
      @TestMetadata("unreachableMarker.kt")
      public void testUnreachableMarker() {
        runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/unreachableMarker.kt");
      }

      @Test
      @TestMetadata("withLambda.kt")
      public void testWithLambda() {
        runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/withLambda.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/stringOperations")
    @TestDataPath("$PROJECT_ROOT")
    public class StringOperations {
      @Test
      public void testAllFilesPresentInStringOperations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/stringOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("concat.kt")
      public void testConcat() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concat.kt");
      }

      @Test
      @TestMetadata("concatDynamic.kt")
      public void testConcatDynamic() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic.kt");
      }

      @Test
      @TestMetadata("concatDynamic199.kt")
      public void testConcatDynamic199() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic199.kt");
      }

      @Test
      @TestMetadata("concatDynamic200.kt")
      public void testConcatDynamic200() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic200.kt");
      }

      @Test
      @TestMetadata("concatDynamic201.kt")
      public void testConcatDynamic201() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic201.kt");
      }

      @Test
      @TestMetadata("concatDynamicConstants.kt")
      public void testConcatDynamicConstants() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicConstants.kt");
      }

      @Test
      @TestMetadata("concatDynamicDataClass.kt")
      public void testConcatDynamicDataClass() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicDataClass.kt");
      }

      @Test
      @TestMetadata("concatDynamicIndy.kt")
      public void testConcatDynamicIndy() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy.kt");
      }

      @Test
      @TestMetadata("concatDynamicIndy201.kt")
      public void testConcatDynamicIndy201() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy201.kt");
      }

      @Test
      @TestMetadata("concatDynamicIndyDataClass.kt")
      public void testConcatDynamicIndyDataClass() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndyDataClass.kt");
      }

      @Test
      @TestMetadata("concatDynamicSpecialSymbols.kt")
      public void testConcatDynamicSpecialSymbols() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicSpecialSymbols.kt");
      }

      @Test
      @TestMetadata("concatDynamicUnit.kt")
      public void testConcatDynamicUnit() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicUnit.kt");
      }

      @Test
      @TestMetadata("concatNotDynamic.kt")
      public void testConcatNotDynamic() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatNotDynamic.kt");
      }

      @Test
      @TestMetadata("constConcat.kt")
      public void testConstConcat() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/constConcat.kt");
      }

      @Test
      @TestMetadata("constValConcat.kt")
      public void testConstValConcat() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/constValConcat.kt");
      }

      @Test
      @TestMetadata("doNotAppendEmptyString.kt")
      public void testDoNotAppendEmptyString() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/doNotAppendEmptyString.kt");
      }

      @Test
      @TestMetadata("interpolation.kt")
      public void testInterpolation() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/interpolation.kt");
      }

      @Test
      @TestMetadata("kt15235.kt")
      public void testKt15235() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt15235.kt");
      }

      @Test
      @TestMetadata("kt19037.kt")
      public void testKt19037() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt19037.kt");
      }

      @Test
      @TestMetadata("kt42457_old.kt")
      public void testKt42457_old() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt42457_old.kt");
      }

      @Test
      @TestMetadata("multipleNestedConcat.kt")
      public void testMultipleNestedConcat() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/multipleNestedConcat.kt");
      }

      @Test
      @TestMetadata("nestedConcat.kt")
      public void testNestedConcat() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/nestedConcat.kt");
      }

      @Test
      @TestMetadata("nonNullableStringPlus.kt")
      public void testNonNullableStringPlus() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/nonNullableStringPlus.kt");
      }

      @Test
      @TestMetadata("nullableStringPlus.kt")
      public void testNullableStringPlus() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/nullableStringPlus.kt");
      }

      @Test
      @TestMetadata("partiallyConstConcat.kt")
      public void testPartiallyConstConcat() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/partiallyConstConcat.kt");
      }

      @Test
      @TestMetadata("plusAssign.kt")
      public void testPlusAssign() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/plusAssign.kt");
      }

      @Test
      @TestMetadata("primitiveToString.kt")
      public void testPrimitiveToString() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToString.kt");
      }

      @Test
      @TestMetadata("primitiveToStringNotOptimizable.kt")
      public void testPrimitiveToStringNotOptimizable() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToStringNotOptimizable.kt");
      }

      @Test
      @TestMetadata("primitivesAsStringTemplates.kt")
      public void testPrimitivesAsStringTemplates() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitivesAsStringTemplates.kt");
      }

      @Test
      @TestMetadata("singleConcat.kt")
      public void testSingleConcat() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/singleConcat.kt");
      }

      @Test
      @TestMetadata("stringBuilderToString.kt")
      public void testStringBuilderToString() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringBuilderToString.kt");
      }

      @Test
      @TestMetadata("stringPlus.kt")
      public void testStringPlus() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringPlus.kt");
      }

      @Test
      @TestMetadata("useAppendCharForOneCharStringInTemplate.kt")
      public void testUseAppendCharForOneCharStringInTemplate() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate.kt");
      }

      @Test
      @TestMetadata("useAppendCharForOneCharStringInTemplate_2.kt")
      public void testUseAppendCharForOneCharStringInTemplate_2() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate_2.kt");
      }

      @Test
      @TestMetadata("useAppendCharForOneCharStringUsingPlus.kt")
      public void testUseAppendCharForOneCharStringUsingPlus() {
        runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringUsingPlus.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/temporaryVals")
    @TestDataPath("$PROJECT_ROOT")
    public class TemporaryVals {
      @Test
      public void testAllFilesPresentInTemporaryVals() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/temporaryVals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayCompoundAssignment.kt")
      public void testArrayCompoundAssignment() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/arrayCompoundAssignment.kt");
      }

      @Test
      @TestMetadata("elvisChain.kt")
      public void testElvisChain() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/elvisChain.kt");
      }

      @Test
      @TestMetadata("noTemporaryInCheckedCast.kt")
      public void testNoTemporaryInCheckedCast() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/noTemporaryInCheckedCast.kt");
      }

      @Test
      @TestMetadata("notNullReceiversInChain.kt")
      public void testNotNullReceiversInChain() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/notNullReceiversInChain.kt");
      }

      @Test
      @TestMetadata("safeCallChain1.kt")
      public void testSafeCallChain1() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain1.kt");
      }

      @Test
      @TestMetadata("safeCallChain2.kt")
      public void testSafeCallChain2() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain2.kt");
      }

      @Test
      @TestMetadata("safeCallChainMemberExt1.kt")
      public void testSafeCallChainMemberExt1() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt1.kt");
      }

      @Test
      @TestMetadata("safeCallChainMemberExt2.kt")
      public void testSafeCallChainMemberExt2() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt2.kt");
      }

      @Test
      @TestMetadata("safeCallElvisSafeCallElvisSomething.kt")
      public void testSafeCallElvisSafeCallElvisSomething() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallElvisSafeCallElvisSomething.kt");
      }

      @Test
      @TestMetadata("safeCallWithElvis.kt")
      public void testSafeCallWithElvis() {
        runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallWithElvis.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/toArray")
    @TestDataPath("$PROJECT_ROOT")
    public class ToArray {
      @Test
      public void testAllFilesPresentInToArray() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("noAccessorForToArray.kt")
      public void testNoAccessorForToArray() {
        runTest("compiler/testData/codegen/bytecodeText/toArray/noAccessorForToArray.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/unsignedTypes")
    @TestDataPath("$PROJECT_ROOT")
    public class UnsignedTypes {
      @Test
      public void testAllFilesPresentInUnsignedTypes() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/unsignedTypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("unsignedIntCompare_jvm18.kt")
      public void testUnsignedIntCompare_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntCompare_jvm18.kt");
      }

      @Test
      @TestMetadata("unsignedIntDivide_jvm18.kt")
      public void testUnsignedIntDivide_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntDivide_jvm18.kt");
      }

      @Test
      @TestMetadata("unsignedIntRemainder_jvm18.kt")
      public void testUnsignedIntRemainder_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntRemainder_jvm18.kt");
      }

      @Test
      @TestMetadata("unsignedIntSmartCasts_jvm18.kt")
      public void testUnsignedIntSmartCasts_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntSmartCasts_jvm18.kt");
      }

      @Test
      @TestMetadata("unsignedIntToString_jvm18.kt")
      public void testUnsignedIntToString_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntToString_jvm18.kt");
      }

      @Test
      @TestMetadata("unsignedLongCompare_jvm18.kt")
      public void testUnsignedLongCompare_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongCompare_jvm18.kt");
      }

      @Test
      @TestMetadata("unsignedLongDivide_jvm18.kt")
      public void testUnsignedLongDivide_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongDivide_jvm18.kt");
      }

      @Test
      @TestMetadata("unsignedLongRemainder_jvm18.kt")
      public void testUnsignedLongRemainder_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongRemainder_jvm18.kt");
      }

      @Test
      @TestMetadata("unsignedLongToString_jvm18.kt")
      public void testUnsignedLongToString_jvm18() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongToString_jvm18.kt");
      }

      @Test
      @TestMetadata("whenByUnsigned.kt")
      public void testWhenByUnsigned() {
        runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/whenByUnsigned.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/valueClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class ValueClasses {
      @Test
      public void testAllFilesPresentInValueClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("conditionalExpressions.kt")
      public void testConditionalExpressions() {
        runTest("compiler/testData/codegen/bytecodeText/valueClasses/conditionalExpressions.kt");
      }

      @Test
      @TestMetadata("equalsBoxTest.kt")
      public void testEqualsBoxTest() {
        runTest("compiler/testData/codegen/bytecodeText/valueClasses/equalsBoxTest.kt");
      }

      @Test
      @TestMetadata("mfvcDeclaration.kt")
      public void testMfvcDeclaration() {
        runTest("compiler/testData/codegen/bytecodeText/valueClasses/mfvcDeclaration.kt");
      }

      @Test
      @TestMetadata("mfvcReassignments.kt")
      public void testMfvcReassignments() {
        runTest("compiler/testData/codegen/bytecodeText/valueClasses/mfvcReassignments.kt");
      }

      @Test
      @TestMetadata("passingMFVC2Functions.kt")
      public void testPassingMFVC2Functions() {
        runTest("compiler/testData/codegen/bytecodeText/valueClasses/passingMFVC2Functions.kt");
      }

      @Test
      @TestMetadata("regularClassWithMFVC.kt")
      public void testRegularClassWithMFVC() {
        runTest("compiler/testData/codegen/bytecodeText/valueClasses/regularClassWithMFVC.kt");
      }

      @Test
      @TestMetadata("tryExpressions.kt")
      public void testTryExpressions() {
        runTest("compiler/testData/codegen/bytecodeText/valueClasses/tryExpressions.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/varargs")
    @TestDataPath("$PROJECT_ROOT")
    public class Varargs {
      @Test
      public void testAllFilesPresentInVarargs() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("doNotCopyImmediatelyCreatedArrays.kt")
      public void testDoNotCopyImmediatelyCreatedArrays() {
        runTest("compiler/testData/codegen/bytecodeText/varargs/doNotCopyImmediatelyCreatedArrays.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/when")
    @TestDataPath("$PROJECT_ROOT")
    public class When {
      @Test
      public void testAllFilesPresentInWhen() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/when"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("edgeCases.kt")
      public void testEdgeCases() {
        runTest("compiler/testData/codegen/bytecodeText/when/edgeCases.kt");
      }

      @Test
      @TestMetadata("exhaustiveWhenInitialization.kt")
      public void testExhaustiveWhenInitialization() {
        runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenInitialization.kt");
      }

      @Test
      @TestMetadata("exhaustiveWhenReturn.kt")
      public void testExhaustiveWhenReturn() {
        runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenReturn.kt");
      }

      @Test
      @TestMetadata("exhaustiveWhenSpecialCases.kt")
      public void testExhaustiveWhenSpecialCases() {
        runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenSpecialCases.kt");
      }

      @Test
      @TestMetadata("exhaustiveWhenUnit.kt")
      public void testExhaustiveWhenUnit() {
        runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnit.kt");
      }

      @Test
      @TestMetadata("exhaustiveWhenUnitStatement.kt")
      public void testExhaustiveWhenUnitStatement() {
        runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnitStatement.kt");
      }

      @Test
      @TestMetadata("inlineConstValsInsideWhen.kt")
      public void testInlineConstValsInsideWhen() {
        runTest("compiler/testData/codegen/bytecodeText/when/inlineConstValsInsideWhen.kt");
      }

      @Test
      @TestMetadata("innerWhenEnumTableSwitch.kt")
      public void testInnerWhenEnumTableSwitch() {
        runTest("compiler/testData/codegen/bytecodeText/when/innerWhenEnumTableSwitch.kt");
      }

      @Test
      @TestMetadata("integralWhenWithNoInlinedConstants.kt")
      public void testIntegralWhenWithNoInlinedConstants() {
        runTest("compiler/testData/codegen/bytecodeText/when/integralWhenWithNoInlinedConstants.kt");
      }

      @Test
      @TestMetadata("kt18818.kt")
      public void testKt18818() {
        runTest("compiler/testData/codegen/bytecodeText/when/kt18818.kt");
      }

      @Test
      @TestMetadata("lookupSwitch.kt")
      public void testLookupSwitch() {
        runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitch.kt");
      }

      @Test
      @TestMetadata("lookupSwitchWithSubjectVal.kt")
      public void testLookupSwitchWithSubjectVal() {
        runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitchWithSubjectVal.kt");
      }

      @Test
      @TestMetadata("noBoxingInDefaultWhenWithSpecialCases.kt")
      public void testNoBoxingInDefaultWhenWithSpecialCases() {
        runTest("compiler/testData/codegen/bytecodeText/when/noBoxingInDefaultWhenWithSpecialCases.kt");
      }

      @Test
      @TestMetadata("qualifiedConstValsInsideWhen.kt")
      public void testQualifiedConstValsInsideWhen() {
        runTest("compiler/testData/codegen/bytecodeText/when/qualifiedConstValsInsideWhen.kt");
      }

      @Test
      @TestMetadata("sealedWhenInitialization.kt")
      public void testSealedWhenInitialization() {
        runTest("compiler/testData/codegen/bytecodeText/when/sealedWhenInitialization.kt");
      }

      @Test
      @TestMetadata("simpleConstValsInsideWhen.kt")
      public void testSimpleConstValsInsideWhen() {
        runTest("compiler/testData/codegen/bytecodeText/when/simpleConstValsInsideWhen.kt");
      }

      @Test
      @TestMetadata("stringSwitchWithSubjectVal.kt")
      public void testStringSwitchWithSubjectVal() {
        runTest("compiler/testData/codegen/bytecodeText/when/stringSwitchWithSubjectVal.kt");
      }

      @Test
      @TestMetadata("subjectValHasLocalVariableSlot.kt")
      public void testSubjectValHasLocalVariableSlot() {
        runTest("compiler/testData/codegen/bytecodeText/when/subjectValHasLocalVariableSlot.kt");
      }

      @Test
      @TestMetadata("subjectValInEnumWhenHasLocalVariableSlot.kt")
      public void testSubjectValInEnumWhenHasLocalVariableSlot() {
        runTest("compiler/testData/codegen/bytecodeText/when/subjectValInEnumWhenHasLocalVariableSlot.kt");
      }

      @Test
      @TestMetadata("subjectValInIntWhenHasLocalVariableSlot.kt")
      public void testSubjectValInIntWhenHasLocalVariableSlot() {
        runTest("compiler/testData/codegen/bytecodeText/when/subjectValInIntWhenHasLocalVariableSlot.kt");
      }

      @Test
      @TestMetadata("subjectValInStringWhenHasLocalVariableSlot.kt")
      public void testSubjectValInStringWhenHasLocalVariableSlot() {
        runTest("compiler/testData/codegen/bytecodeText/when/subjectValInStringWhenHasLocalVariableSlot.kt");
      }

      @Test
      @TestMetadata("switchOptimizationDuplicates.kt")
      public void testSwitchOptimizationDuplicates() {
        runTest("compiler/testData/codegen/bytecodeText/when/switchOptimizationDuplicates.kt");
      }

      @Test
      @TestMetadata("tableSwitch.kt")
      public void testTableSwitch() {
        runTest("compiler/testData/codegen/bytecodeText/when/tableSwitch.kt");
      }

      @Test
      @TestMetadata("tableSwitchWithSubjectVal.kt")
      public void testTableSwitchWithSubjectVal() {
        runTest("compiler/testData/codegen/bytecodeText/when/tableSwitchWithSubjectVal.kt");
      }

      @Test
      @TestMetadata("whenNull.kt")
      public void testWhenNull() {
        runTest("compiler/testData/codegen/bytecodeText/when/whenNull.kt");
      }

      @Test
      @TestMetadata("whenZero.kt")
      public void testWhenZero() {
        runTest("compiler/testData/codegen/bytecodeText/when/whenZero.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class WhenEnumOptimization {
      @Test
      public void testAllFilesPresentInWhenEnumOptimization() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenEnumOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("bigEnum.kt")
      public void testBigEnum() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/bigEnum.kt");
      }

      @Test
      @TestMetadata("differentEnumClasses.kt")
      public void testDifferentEnumClasses() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses.kt");
      }

      @Test
      @TestMetadata("differentEnumClasses2.kt")
      public void testDifferentEnumClasses2() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses2.kt");
      }

      @Test
      @TestMetadata("duplicatingItems.kt")
      public void testDuplicatingItems() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/duplicatingItems.kt");
      }

      @Test
      @TestMetadata("expression.kt")
      public void testExpression() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/expression.kt");
      }

      @Test
      @TestMetadata("functionLiteralInTopLevel.kt")
      public void testFunctionLiteralInTopLevel() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/functionLiteralInTopLevel.kt");
      }

      @Test
      @TestMetadata("importedEnumEntry.kt")
      public void testImportedEnumEntry() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/importedEnumEntry.kt");
      }

      @Test
      @TestMetadata("kt14597_full.kt")
      public void testKt14597_full() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14597_full.kt");
      }

      @Test
      @TestMetadata("kt14802.kt")
      public void testKt14802() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14802.kt");
      }

      @Test
      @TestMetadata("manyWhensWithinClass.kt")
      public void testManyWhensWithinClass() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/manyWhensWithinClass.kt");
      }

      @Test
      @TestMetadata("nestedWhenInCondition.kt")
      public void testNestedWhenInCondition() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nestedWhenInCondition.kt");
      }

      @Test
      @TestMetadata("nonConstantEnum.kt")
      public void testNonConstantEnum() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nonConstantEnum.kt");
      }

      @Test
      @TestMetadata("nullability.kt")
      public void testNullability() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nullability.kt");
      }

      @Test
      @TestMetadata("subjectAny.kt")
      public void testSubjectAny() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/subjectAny.kt");
      }

      @Test
      @TestMetadata("whenOr.kt")
      public void testWhenOr() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/whenOr.kt");
      }

      @Test
      @TestMetadata("withoutElse.kt")
      public void testWithoutElse() {
        runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/withoutElse.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class WhenStringOptimization {
      @Test
      public void testAllFilesPresentInWhenStringOptimization() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenStringOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("denseHashCode.kt")
      public void testDenseHashCode() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/denseHashCode.kt");
      }

      @Test
      @TestMetadata("duplicatingItems.kt")
      public void testDuplicatingItems() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItems.kt");
      }

      @Test
      @TestMetadata("duplicatingItemsSameHashCodeFewBranches.kt")
      public void testDuplicatingItemsSameHashCodeFewBranches() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeFewBranches.kt");
      }

      @Test
      @TestMetadata("duplicatingItemsSameHashCodeMoreBranches.kt")
      public void testDuplicatingItemsSameHashCodeMoreBranches() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeMoreBranches.kt");
      }

      @Test
      @TestMetadata("expression.kt")
      public void testExpression() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/expression.kt");
      }

      @Test
      @TestMetadata("inlineStringConstInsideWhen.kt")
      public void testInlineStringConstInsideWhen() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/inlineStringConstInsideWhen.kt");
      }

      @Test
      @TestMetadata("nullability.kt")
      public void testNullability() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/nullability.kt");
      }

      @Test
      @TestMetadata("sameHashCode.kt")
      public void testSameHashCode() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/sameHashCode.kt");
      }

      @Test
      @TestMetadata("statement.kt")
      public void testStatement() {
        runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/statement.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing")
  @TestDataPath("$PROJECT_ROOT")
  public class BytecodeListing {
    @Test
    @TestMetadata("accessorForProtectedPropertyWithPrivateSetter.kt")
    public void testAccessorForProtectedPropertyWithPrivateSetter() {
      runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetter.kt");
    }

    @Test
    @TestMetadata("accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt")
    public void testAccessorForProtectedPropertyWithPrivateSetterInObjectLiteral() {
      runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt");
    }

    @Test
    @TestMetadata("accessorForTopLevelMembers.kt")
    public void testAccessorForTopLevelMembers() {
      runTest("compiler/testData/codegen/bytecodeListing/accessorForTopLevelMembers.kt");
    }

    @Test
    @TestMetadata("accessorsForProtectedStaticJavaFieldInOtherPackage.kt")
    public void testAccessorsForProtectedStaticJavaFieldInOtherPackage() {
      runTest("compiler/testData/codegen/bytecodeListing/accessorsForProtectedStaticJavaFieldInOtherPackage.kt");
    }

    @Test
    public void testAllFilesPresentInBytecodeListing() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("anonymousObjectInGenericFun.kt")
    public void testAnonymousObjectInGenericFun() {
      runTest("compiler/testData/codegen/bytecodeListing/anonymousObjectInGenericFun.kt");
    }

    @Test
    @TestMetadata("callableNameIntrinsic.kt")
    public void testCallableNameIntrinsic() {
      runTest("compiler/testData/codegen/bytecodeListing/callableNameIntrinsic.kt");
    }

    @Test
    @TestMetadata("callableReferenceArrayConstructorArguments.kt")
    public void testCallableReferenceArrayConstructorArguments() {
      runTest("compiler/testData/codegen/bytecodeListing/callableReferenceArrayConstructorArguments.kt");
    }

    @Test
    @TestMetadata("cloneable.kt")
    public void testCloneable() {
      runTest("compiler/testData/codegen/bytecodeListing/cloneable.kt");
    }

    @Test
    @TestMetadata("companionObjectVisibility_after.kt")
    public void testCompanionObjectVisibility_after() {
      runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_after.kt");
    }

    @Test
    @TestMetadata("companionObjectVisibility_before.kt")
    public void testCompanionObjectVisibility_before() {
      runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_before.kt");
    }

    @Test
    @TestMetadata("defaultImpls.kt")
    public void testDefaultImpls() {
      runTest("compiler/testData/codegen/bytecodeListing/defaultImpls.kt");
    }

    @Test
    @TestMetadata("delegationToJavaInterfaceWithWildcardType.kt")
    public void testDelegationToJavaInterfaceWithWildcardType() {
      runTest("compiler/testData/codegen/bytecodeListing/delegationToJavaInterfaceWithWildcardType.kt");
    }

    @Test
    @TestMetadata("deprecatedConstantPropertyInterfaceCompanion.kt")
    public void testDeprecatedConstantPropertyInterfaceCompanion() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecatedConstantPropertyInterfaceCompanion.kt");
    }

    @Test
    @TestMetadata("deserializeLambdaMethod.kt")
    public void testDeserializeLambdaMethod() {
      runTest("compiler/testData/codegen/bytecodeListing/deserializeLambdaMethod.kt");
    }

    @Test
    @TestMetadata("enum.kt")
    public void testEnum() {
      runTest("compiler/testData/codegen/bytecodeListing/enum.kt");
    }

    @Test
    @TestMetadata("enumEntries.kt")
    public void testEnumEntries() {
      runTest("compiler/testData/codegen/bytecodeListing/enumEntries.kt");
    }

    @Test
    @TestMetadata("extension.kt")
    public void testExtension() {
      runTest("compiler/testData/codegen/bytecodeListing/extension.kt");
    }

    @Test
    @TestMetadata("fileClassWithPrivateDeclarationsOnly_after.kt")
    public void testFileClassWithPrivateDeclarationsOnly_after() {
      runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_after.kt");
    }

    @Test
    @TestMetadata("fileClassWithPrivateDeclarationsOnly_before.kt")
    public void testFileClassWithPrivateDeclarationsOnly_before() {
      runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_before.kt");
    }

    @Test
    @TestMetadata("immutableCollection.kt")
    public void testImmutableCollection() {
      runTest("compiler/testData/codegen/bytecodeListing/immutableCollection.kt");
    }

    @Test
    @TestMetadata("javaDeprecated.kt")
    public void testJavaDeprecated() {
      runTest("compiler/testData/codegen/bytecodeListing/javaDeprecated.kt");
    }

    @Test
    @TestMetadata("jvmOverloadsAndParametersAnnotations.kt")
    public void testJvmOverloadsAndParametersAnnotations() {
      runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsAndParametersAnnotations.kt");
    }

    @Test
    @TestMetadata("jvmOverloadsExternal.kt")
    public void testJvmOverloadsExternal() {
      runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsExternal.kt");
    }

    @Test
    @TestMetadata("jvmRecordStructure.kt")
    public void testJvmRecordStructure() {
      runTest("compiler/testData/codegen/bytecodeListing/jvmRecordStructure.kt");
    }

    @Test
    @TestMetadata("kt42137.kt")
    public void testKt42137() {
      runTest("compiler/testData/codegen/bytecodeListing/kt42137.kt");
    }

    @Test
    @TestMetadata("kt42879.kt")
    public void testKt42879() {
      runTest("compiler/testData/codegen/bytecodeListing/kt42879.kt");
    }

    @Test
    @TestMetadata("kt43217.kt")
    public void testKt43217() {
      runTest("compiler/testData/codegen/bytecodeListing/kt43217.kt");
    }

    @Test
    @TestMetadata("kt43440.kt")
    public void testKt43440() {
      runTest("compiler/testData/codegen/bytecodeListing/kt43440.kt");
    }

    @Test
    @TestMetadata("kt45853.kt")
    public void testKt45853() {
      runTest("compiler/testData/codegen/bytecodeListing/kt45853.kt");
    }

    @Test
    @TestMetadata("kt45853a.kt")
    public void testKt45853a() {
      runTest("compiler/testData/codegen/bytecodeListing/kt45853a.kt");
    }

    @Test
    @TestMetadata("kt45934.kt")
    public void testKt45934() {
      runTest("compiler/testData/codegen/bytecodeListing/kt45934.kt");
    }

    @Test
    @TestMetadata("kt47328.kt")
    public void testKt47328() {
      runTest("compiler/testData/codegen/bytecodeListing/kt47328.kt");
    }

    @Test
    @TestMetadata("kt55769.kt")
    public void testKt55769() {
      runTest("compiler/testData/codegen/bytecodeListing/kt55769.kt");
    }

    @Test
    @TestMetadata("noCollectionStubMethodsInInterface.kt")
    public void testNoCollectionStubMethodsInInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/noCollectionStubMethodsInInterface.kt");
    }

    @Test
    @TestMetadata("noDelegationsToPrivateInterfaceMembers.kt")
    public void testNoDelegationsToPrivateInterfaceMembers() {
      runTest("compiler/testData/codegen/bytecodeListing/noDelegationsToPrivateInterfaceMembers.kt");
    }

    @Test
    @TestMetadata("noReceiverInCallableReferenceClasses.kt")
    public void testNoReceiverInCallableReferenceClasses() {
      runTest("compiler/testData/codegen/bytecodeListing/noReceiverInCallableReferenceClasses.kt");
    }

    @Test
    @TestMetadata("noRemoveAtInReadOnly.kt")
    public void testNoRemoveAtInReadOnly() {
      runTest("compiler/testData/codegen/bytecodeListing/noRemoveAtInReadOnly.kt");
    }

    @Test
    @TestMetadata("nullabilityAnnotationInInnerClasses.kt")
    public void testNullabilityAnnotationInInnerClasses() {
      runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotationInInnerClasses.kt");
    }

    @Test
    @TestMetadata("overrideWithPrimitiveUpperBound.kt")
    public void testOverrideWithPrimitiveUpperBound() {
      runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound.kt");
    }

    @Test
    @TestMetadata("overrideWithPrimitiveUpperBound2.kt")
    public void testOverrideWithPrimitiveUpperBound2() {
      runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound2.kt");
    }

    @Test
    @TestMetadata("privateCompanionFields.kt")
    public void testPrivateCompanionFields() {
      runTest("compiler/testData/codegen/bytecodeListing/privateCompanionFields.kt");
    }

    @Test
    @TestMetadata("privateDefaultImpls.kt")
    public void testPrivateDefaultImpls() {
      runTest("compiler/testData/codegen/bytecodeListing/privateDefaultImpls.kt");
    }

    @Test
    @TestMetadata("privateDefaultSetter.kt")
    public void testPrivateDefaultSetter() {
      runTest("compiler/testData/codegen/bytecodeListing/privateDefaultSetter.kt");
    }

    @Test
    @TestMetadata("privateNestedClassInInterface.kt")
    public void testPrivateNestedClassInInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/privateNestedClassInInterface.kt");
    }

    @Test
    @TestMetadata("rawTypeInSignature.kt")
    public void testRawTypeInSignature() {
      runTest("compiler/testData/codegen/bytecodeListing/rawTypeInSignature.kt");
    }

    @Test
    @TestMetadata("strictfpFlag.kt")
    public void testStrictfpFlag() {
      runTest("compiler/testData/codegen/bytecodeListing/strictfpFlag.kt");
    }

    @Test
    @TestMetadata("synchronizedFlag.kt")
    public void testSynchronizedFlag() {
      runTest("compiler/testData/codegen/bytecodeListing/synchronizedFlag.kt");
    }

    @Test
    @TestMetadata("varargsBridge.kt")
    public void testVarargsBridge() {
      runTest("compiler/testData/codegen/bytecodeListing/varargsBridge.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
      @Test
      public void testAllFilesPresentInAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotationCtorCallGenerateSynthetic.kt")
      public void testAnnotationCtorCallGenerateSynthetic() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallGenerateSynthetic.kt");
      }

      @Test
      @TestMetadata("annotationCtorCallNoSynthetic.kt")
      public void testAnnotationCtorCallNoSynthetic() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallNoSynthetic.kt");
      }

      @Test
      @TestMetadata("annotationMixedTargeting.kt")
      public void testAnnotationMixedTargeting() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationMixedTargeting.kt");
      }

      @Test
      @TestMetadata("annotationsOnDelegatedMembers.kt")
      public void testAnnotationsOnDelegatedMembers() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationsOnDelegatedMembers.kt");
      }

      @Test
      @TestMetadata("defaultTargets.kt")
      public void testDefaultTargets() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/defaultTargets.kt");
      }

      @Test
      @TestMetadata("deprecatedJvmOverloads.kt")
      public void testDeprecatedJvmOverloads() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/deprecatedJvmOverloads.kt");
      }

      @Test
      @TestMetadata("internalPropertyOrTypealias.kt")
      public void testInternalPropertyOrTypealias() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/internalPropertyOrTypealias.kt");
      }

      @Test
      @TestMetadata("JvmSynthetic.kt")
      public void testJvmSynthetic() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/JvmSynthetic.kt");
      }

      @Test
      @TestMetadata("kt27895.kt")
      public void testKt27895() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/kt27895.kt");
      }

      @Test
      @TestMetadata("kt43399.kt")
      public void testKt43399() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43399.kt");
      }

      @Test
      @TestMetadata("kt43459.kt")
      public void testKt43459() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43459.kt");
      }

      @Test
      @TestMetadata("kt62788.kt")
      public void testKt62788() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/kt62788.kt");
      }

      @Test
      @TestMetadata("kt9320.kt")
      public void testKt9320() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/kt9320.kt");
      }

      @Test
      @TestMetadata("literals.kt")
      public void testLiterals() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/literals.kt");
      }

      @Test
      @TestMetadata("localClassWithCapturedParams.kt")
      public void testLocalClassWithCapturedParams() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/localClassWithCapturedParams.kt");
      }

      @Test
      @TestMetadata("noAdditionalAnnotationsInAccessors.kt")
      public void testNoAdditionalAnnotationsInAccessors() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/noAdditionalAnnotationsInAccessors.kt");
      }

      @Test
      @TestMetadata("noAnnotationsInSyntheticAccessors.kt")
      public void testNoAnnotationsInSyntheticAccessors() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/noAnnotationsInSyntheticAccessors.kt");
      }

      @Test
      @TestMetadata("onProperties.kt")
      public void testOnProperties() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/onProperties.kt");
      }

      @Test
      @TestMetadata("onReceiver.kt")
      public void testOnReceiver() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/onReceiver.kt");
      }

      @Test
      @TestMetadata("unsignedTypes.kt")
      public void testUnsignedTypes() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/unsignedTypes.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/annotations/repeatable")
      @TestDataPath("$PROJECT_ROOT")
      public class Repeatable {
        @Test
        public void testAllFilesPresentInRepeatable() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("javaAnnotation.kt")
        public void testJavaAnnotation() {
          runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/javaAnnotation.kt");
        }

        @Test
        @TestMetadata("kotlinAnnotation.kt")
        public void testKotlinAnnotation() {
          runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotation.kt");
        }

        @Test
        @TestMetadata("kotlinAnnotationWithBothRepeatables.kt")
        public void testKotlinAnnotationWithBothRepeatables() {
          runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotationWithBothRepeatables.kt");
        }

        @Test
        @TestMetadata("kotlinSpecificTargets.kt")
        public void testKotlinSpecificTargets() {
          runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinSpecificTargets.kt");
        }

        @Test
        @TestMetadata("multipleRepeatableOrder.kt")
        public void testMultipleRepeatableOrder() {
          runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/multipleRepeatableOrder.kt");
        }

        @Test
        @TestMetadata("nonRepeatedAnnotationWithItsContainer.kt")
        public void testNonRepeatedAnnotationWithItsContainer() {
          runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/nonRepeatedAnnotationWithItsContainer.kt");
        }

        @Test
        @TestMetadata("propertyGetterUseSiteTarget.kt")
        public void testPropertyGetterUseSiteTarget() {
          runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/propertyGetterUseSiteTarget.kt");
        }

        @Test
        @TestMetadata("retentionAndTarget.kt")
        public void testRetentionAndTarget() {
          runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/retentionAndTarget.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReference {
      @Test
      @TestMetadata("adaptedReference.kt")
      public void testAdaptedReference() {
        runTest("compiler/testData/codegen/bytecodeListing/callableReference/adaptedReference.kt");
      }

      @Test
      public void testAllFilesPresentInCallableReference() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs")
    @TestDataPath("$PROJECT_ROOT")
    public class CollectionStubs {
      @Test
      @TestMetadata("abstractMapRedefiningGetAny.kt")
      public void testAbstractMapRedefiningGetAny() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractMapRedefiningGetAny.kt");
      }

      @Test
      public void testAllFilesPresentInCollectionStubs() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("collectionByDelegation.kt")
      public void testCollectionByDelegation() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation.kt");
      }

      @Test
      @TestMetadata("collectionByDelegation2.kt")
      public void testCollectionByDelegation2() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2.kt");
      }

      @Test
      @TestMetadata("collectionByDelegation2WithFullJdk.kt")
      public void testCollectionByDelegation2WithFullJdk() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2WithFullJdk.kt");
      }

      @Test
      @TestMetadata("collectionByDelegation3.kt")
      public void testCollectionByDelegation3() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3.kt");
      }

      @Test
      @TestMetadata("collectionByDelegation3WithFullJdk.kt")
      public void testCollectionByDelegation3WithFullJdk() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3WithFullJdk.kt");
      }

      @Test
      @TestMetadata("collectionByDelegationWithFullJdk.kt")
      public void testCollectionByDelegationWithFullJdk() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegationWithFullJdk.kt");
      }

      @Test
      @TestMetadata("collectionWithInternalRemove.kt")
      public void testCollectionWithInternalRemove() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionWithInternalRemove.kt");
      }

      @Test
      @TestMetadata("collectionsWithFullJdk.kt")
      public void testCollectionsWithFullJdk() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionsWithFullJdk.kt");
      }

      @Test
      @TestMetadata("customListIterator.kt")
      public void testCustomListIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customListIterator.kt");
      }

      @Test
      @TestMetadata("customMutableListIterator.kt")
      public void testCustomMutableListIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customMutableListIterator.kt");
      }

      @Test
      @TestMetadata("emptyList.kt")
      public void testEmptyList() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/emptyList.kt");
      }

      @Test
      @TestMetadata("extendingAbstractCollection.kt")
      public void testExtendingAbstractCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/extendingAbstractCollection.kt");
      }

      @Test
      @TestMetadata("inheritingFromAbstractCollections.kt")
      public void testInheritingFromAbstractCollections() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractCollections.kt");
      }

      @Test
      @TestMetadata("inheritingFromAbstractMap.kt")
      public void testInheritingFromAbstractMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMap.kt");
      }

      @Test
      @TestMetadata("inheritingFromAbstractMutableList.kt")
      public void testInheritingFromAbstractMutableList() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMutableList.kt");
      }

      @Test
      @TestMetadata("intArrayList.kt")
      public void testIntArrayList() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/intArrayList.kt");
      }

      @Test
      @TestMetadata("kt44233.kt")
      public void testKt44233() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/kt44233.kt");
      }

      @Test
      @TestMetadata("ListAndSet.kt")
      public void testListAndSet() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/ListAndSet.kt");
      }

      @Test
      @TestMetadata("mapOfPrimitivesFullJdk.kt")
      public void testMapOfPrimitivesFullJdk() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/mapOfPrimitivesFullJdk.kt");
      }

      @Test
      @TestMetadata("noStubsForCollection.kt")
      public void testNoStubsForCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForCollection.kt");
      }

      @Test
      @TestMetadata("noStubsForMapImplementations.kt")
      public void testNoStubsForMapImplementations() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMapImplementations.kt");
      }

      @Test
      @TestMetadata("noStubsForMutableSetIterators.kt")
      public void testNoStubsForMutableSetIterators() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMutableSetIterators.kt");
      }

      @Test
      @TestMetadata("noStubsForSetIterators.kt")
      public void testNoStubsForSetIterators() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForSetIterators.kt");
      }

      @Test
      @TestMetadata("noStubsInIterable.kt")
      public void testNoStubsInIterable() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInIterable.kt");
      }

      @Test
      @TestMetadata("noStubsInJavaSuperClass.kt")
      public void testNoStubsInJavaSuperClass() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInJavaSuperClass.kt");
      }

      @Test
      @TestMetadata("noStubsInMutableIterable.kt")
      public void testNoStubsInMutableIterable() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInMutableIterable.kt");
      }

      @Test
      @TestMetadata("observableMutableMap.kt")
      public void testObservableMutableMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/observableMutableMap.kt");
      }

      @Test
      @TestMetadata("stubForAbstractFun.kt")
      public void testStubForAbstractFun() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFun.kt");
      }

      @Test
      @TestMetadata("stubForAbstractFunInAbstractClass.kt")
      public void testStubForAbstractFunInAbstractClass() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClass.kt");
      }

      @Test
      @TestMetadata("stubForAbstractFunInAbstractClassWithCovariantOverride.kt")
      public void testStubForAbstractFunInAbstractClassWithCovariantOverride() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClassWithCovariantOverride.kt");
      }

      @Test
      @TestMetadata("stubForAbstractFunWithCovariantOverride.kt")
      public void testStubForAbstractFunWithCovariantOverride() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunWithCovariantOverride.kt");
      }

      @Test
      @TestMetadata("stubLikeMethodSignatures.kt")
      public void testStubLikeMethodSignatures() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubLikeMethodSignatures.kt");
      }

      @Test
      @TestMetadata("stubsFromSuperclass.kt")
      public void testStubsFromSuperclass() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclass.kt");
      }

      @Test
      @TestMetadata("stubsFromSuperclassNoBridges.kt")
      public void testStubsFromSuperclassNoBridges() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclassNoBridges.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures")
      @TestDataPath("$PROJECT_ROOT")
      public class AbstractStubSignatures {
        @Test
        public void testAllFilesPresentInAbstractStubSignatures() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("byteShortMap.kt")
        public void testByteShortMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMap.kt");
        }

        @Test
        @TestMetadata("byteShortMutableMap.kt")
        public void testByteShortMutableMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMutableMap.kt");
        }

        @Test
        @TestMetadata("collection.kt")
        public void testCollection() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/collection.kt");
        }

        @Test
        @TestMetadata("genericCollection.kt")
        public void testGenericCollection() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericCollection.kt");
        }

        @Test
        @TestMetadata("genericMap.kt")
        public void testGenericMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMap.kt");
        }

        @Test
        @TestMetadata("genericMutableCollection.kt")
        public void testGenericMutableCollection() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableCollection.kt");
        }

        @Test
        @TestMetadata("genericMutableList.kt")
        public void testGenericMutableList() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableList.kt");
        }

        @Test
        @TestMetadata("genericMutableMap.kt")
        public void testGenericMutableMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableMap.kt");
        }

        @Test
        @TestMetadata("genericStringMap.kt")
        public void testGenericStringMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMap.kt");
        }

        @Test
        @TestMetadata("genericStringMutableMap.kt")
        public void testGenericStringMutableMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMutableMap.kt");
        }

        @Test
        @TestMetadata("iterable.kt")
        public void testIterable() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterable.kt");
        }

        @Test
        @TestMetadata("iterator.kt")
        public void testIterator() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterator.kt");
        }

        @Test
        @TestMetadata("list.kt")
        public void testList() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/list.kt");
        }

        @Test
        @TestMetadata("listIterator.kt")
        public void testListIterator() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/listIterator.kt");
        }

        @Test
        @TestMetadata("mapEntry.kt")
        public void testMapEntry() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mapEntry.kt");
        }

        @Test
        @TestMetadata("mutableCollection.kt")
        public void testMutableCollection() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableCollection.kt");
        }

        @Test
        @TestMetadata("mutableIterable.kt")
        public void testMutableIterable() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterable.kt");
        }

        @Test
        @TestMetadata("mutableIterator.kt")
        public void testMutableIterator() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterator.kt");
        }

        @Test
        @TestMetadata("mutableList.kt")
        public void testMutableList() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableList.kt");
        }

        @Test
        @TestMetadata("mutableListIterator.kt")
        public void testMutableListIterator() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableListIterator.kt");
        }

        @Test
        @TestMetadata("mutableMapEntry.kt")
        public void testMutableMapEntry() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableMapEntry.kt");
        }

        @Test
        @TestMetadata("numberStringMap.kt")
        public void testNumberStringMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMap.kt");
        }

        @Test
        @TestMetadata("numberStringMutableMap.kt")
        public void testNumberStringMutableMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMutableMap.kt");
        }

        @Test
        @TestMetadata("set.kt")
        public void testSet() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/set.kt");
        }

        @Test
        @TestMetadata("specializedGenericMap.kt")
        public void testSpecializedGenericMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/specializedGenericMap.kt");
        }

        @Test
        @TestMetadata("stringGenericMap.kt")
        public void testStringGenericMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMap.kt");
        }

        @Test
        @TestMetadata("stringGenericMutableMap.kt")
        public void testStringGenericMutableMap() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMutableMap.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray")
      @TestDataPath("$PROJECT_ROOT")
      public class ToArray {
        @Test
        public void testAllFilesPresentInToArray() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("customNonGenericToArray.kt")
        public void testCustomNonGenericToArray() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/customNonGenericToArray.kt");
        }

        @Test
        @TestMetadata("internalGenericToArray.kt")
        public void testInternalGenericToArray() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/internalGenericToArray.kt");
        }

        @Test
        @TestMetadata("noToArrayInJava.kt")
        public void testNoToArrayInJava() {
          runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/noToArrayInJava.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/contextReceivers")
    @TestDataPath("$PROJECT_ROOT")
    public class ContextReceivers {
      @Test
      public void testAllFilesPresentInContextReceivers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("class.kt")
      public void testClass() {
        runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/class.kt");
      }

      @Test
      @TestMetadata("function.kt")
      public void testFunction() {
        runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/function.kt");
      }

      @Test
      @TestMetadata("property.kt")
      public void testProperty() {
        runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/property.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP")
      @TestDataPath("$PROJECT_ROOT")
      public class FromKEEP {
        @Test
        public void testAllFilesPresentInFromKEEP() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("canvas.kt")
        public void testCanvas() {
          runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/canvas.kt");
        }

        @Test
        @TestMetadata("compareTo.kt")
        public void testCompareTo() {
          runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/compareTo.kt");
        }

        @Test
        @TestMetadata("dp.kt")
        public void testDp() {
          runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/dp.kt");
        }

        @Test
        @TestMetadata("functionalType.kt")
        public void testFunctionalType() {
          runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/functionalType.kt");
        }

        @Test
        @TestMetadata("monoidSum.kt")
        public void testMonoidSum() {
          runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/monoidSum.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    public class Coroutines {
      @Test
      public void testAllFilesPresentInCoroutines() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("coroutineContextIntrinsic.kt")
      public void testCoroutineContextIntrinsic() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineContextIntrinsic.kt");
      }

      @Test
      @TestMetadata("coroutineFields.kt")
      public void testCoroutineFields() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineFields.kt");
      }

      @Test
      @TestMetadata("oomInReturnUnit.kt")
      public void testOomInReturnUnit() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/oomInReturnUnit.kt");
      }

      @Test
      @TestMetadata("privateAccessor.kt")
      public void testPrivateAccessor() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateAccessor.kt");
      }

      @Test
      @TestMetadata("privateSuspendFun.kt")
      public void testPrivateSuspendFun() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateSuspendFun.kt");
      }

      @Test
      @TestMetadata("suspendConversion.kt")
      public void testSuspendConversion() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendConversion.kt");
      }

      @Test
      @TestMetadata("suspendImpl.kt")
      public void testSuspendImpl() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendImpl.kt");
      }

      @Test
      @TestMetadata("suspendReifiedFun.kt")
      public void testSuspendReifiedFun() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendReifiedFun.kt");
      }

      @Test
      @TestMetadata("tcoContinuation.kt")
      public void testTcoContinuation() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/tcoContinuation.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/coroutines/spilling")
      @TestDataPath("$PROJECT_ROOT")
      public class Spilling {
        @Test
        public void testAllFilesPresentInSpilling() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines/spilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("booleanParameter.kt")
        public void testBooleanParameter() {
          runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/booleanParameter.kt");
        }

        @Test
        @TestMetadata("component1.kt")
        public void testComponent1() {
          runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/component1.kt");
        }

        @Test
        @TestMetadata("destructured.kt")
        public void testDestructured() {
          runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/destructured.kt");
        }

        @Test
        @TestMetadata("field.kt")
        public void testField() {
          runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/field.kt");
        }

        @Test
        @TestMetadata("lambda.kt")
        public void testLambda() {
          runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/lambda.kt");
        }

        @Test
        @TestMetadata("select.kt")
        public void testSelect() {
          runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/select.kt");
        }

        @Test
        @TestMetadata("unreachable.kt")
        public void testUnreachable() {
          runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/unreachable.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultArguments {
      @Test
      public void testAllFilesPresentInDefaultArguments() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("functionInMultifileClass.kt")
      public void testFunctionInMultifileClass() {
        runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClass.kt");
      }

      @Test
      @TestMetadata("functionInMultifileClassWithInheritedParts.kt")
      public void testFunctionInMultifileClassWithInheritedParts() {
        runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClassWithInheritedParts.kt");
      }

      @Test
      @TestMetadata("internalNameMangling.kt")
      public void testInternalNameMangling() {
        runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/internalNameMangling.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegatedProperty {
      @Test
      public void testAllFilesPresentInDelegatedProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("delegateMethodIsNonOverridable.kt")
      public void testDelegateMethodIsNonOverridable() {
        runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegateMethodIsNonOverridable.kt");
      }

      @Test
      @TestMetadata("delegatedPropertiesInCompanionObject.kt")
      public void testDelegatedPropertiesInCompanionObject() {
        runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegatedPropertiesInCompanionObject.kt");
      }

      @Test
      @TestMetadata("localDelegatedProperty.kt")
      public void testLocalDelegatedProperty() {
        runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/localDelegatedProperty.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/deprecated")
    @TestDataPath("$PROJECT_ROOT")
    public class Deprecated {
      @Test
      public void testAllFilesPresentInDeprecated() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("deprecatedClass.kt")
      public void testDeprecatedClass() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedClass.kt");
      }

      @Test
      @TestMetadata("deprecatedEnumEntryFields.kt")
      public void testDeprecatedEnumEntryFields() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedEnumEntryFields.kt");
      }

      @Test
      @TestMetadata("deprecatedInMultifileClass.kt")
      public void testDeprecatedInMultifileClass() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedInMultifileClass.kt");
      }

      @Test
      @TestMetadata("deprecatedLateinitVar.kt")
      public void testDeprecatedLateinitVar() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedLateinitVar.kt");
      }

      @Test
      @TestMetadata("deprecatedProperty.kt")
      public void testDeprecatedProperty() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedProperty.kt");
      }

      @Test
      @TestMetadata("hidden.kt")
      public void testHidden() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/hidden.kt");
      }

      @Test
      @TestMetadata("inheritingDeprecation.kt")
      public void testInheritingDeprecation() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/inheritingDeprecation.kt");
      }

      @Test
      @TestMetadata("inlineClassTypesInSignature.kt")
      public void testInlineClassTypesInSignature() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/inlineClassTypesInSignature.kt");
      }

      @Test
      @TestMetadata("jvmStaticDeprecatedProperty.kt")
      public void testJvmStaticDeprecatedProperty() {
        runTest("compiler/testData/codegen/bytecodeListing/deprecated/jvmStaticDeprecatedProperty.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inline")
    @TestDataPath("$PROJECT_ROOT")
    public class Inline {
      @Test
      public void testAllFilesPresentInInline() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("genericReified.kt")
      public void testGenericReified() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/genericReified.kt");
      }

      @Test
      @TestMetadata("inlineOnly.kt")
      public void testInlineOnly() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnly.kt");
      }

      @Test
      @TestMetadata("InlineOnlyMultifile.kt")
      public void testInlineOnlyMultifile() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyMultifile.kt");
      }

      @Test
      @TestMetadata("inlineOnlyProperty.kt")
      public void testInlineOnlyProperty() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnlyProperty.kt");
      }

      @Test
      @TestMetadata("InlineOnlyPropertyMultifile.kt")
      public void testInlineOnlyPropertyMultifile() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyPropertyMultifile.kt");
      }

      @Test
      @TestMetadata("inlineReified.kt")
      public void testInlineReified() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReified.kt");
      }

      @Test
      @TestMetadata("InlineReifiedMultifile.kt")
      public void testInlineReifiedMultifile() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedMultifile.kt");
      }

      @Test
      @TestMetadata("inlineReifiedProperty.kt")
      public void testInlineReifiedProperty() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedProperty.kt");
      }

      @Test
      @TestMetadata("InlineReifiedPropertyMultifile.kt")
      public void testInlineReifiedPropertyMultifile() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedPropertyMultifile.kt");
      }

      @Test
      @TestMetadata("inlineReifiedPropertyVisibility.kt")
      public void testInlineReifiedPropertyVisibility() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedPropertyVisibility.kt");
      }

      @Test
      @TestMetadata("inlineReifiedVisibility.kt")
      public void testInlineReifiedVisibility() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedVisibility.kt");
      }

      @Test
      @TestMetadata("simpleNamed.kt")
      public void testSimpleNamed() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/simpleNamed.kt");
      }

      @Test
      @TestMetadata("suspendInlineReified.kt")
      public void testSuspendInlineReified() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/suspendInlineReified.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo")
      @TestDataPath("$PROJECT_ROOT")
      public class EnclosingInfo {
        @Test
        public void testAllFilesPresentInEnclosingInfo() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("crossinlineLambdaChain.kt")
        public void testCrossinlineLambdaChain() {
          runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/crossinlineLambdaChain.kt");
        }

        @Test
        @TestMetadata("kt10259.kt")
        public void testKt10259() {
          runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/kt10259.kt");
        }

        @Test
        @TestMetadata("lambdaInInitBlockNoPrimaryConstructor.kt")
        public void testLambdaInInitBlockNoPrimaryConstructor() {
          runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInitBlockNoPrimaryConstructor.kt");
        }

        @Test
        @TestMetadata("lambdaInInnerClassConstructor.kt")
        public void testLambdaInInnerClassConstructor() {
          runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInnerClassConstructor.kt");
        }

        @Test
        @TestMetadata("transformedConstructor.kt")
        public void testTransformedConstructor() {
          runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructor.kt");
        }

        @Test
        @TestMetadata("transformedConstructorWithNestedInline.kt")
        public void testTransformedConstructorWithNestedInline() {
          runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructorWithNestedInline.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
      @Test
      public void testAllFilesPresentInInlineClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotatedPropertyWithInlineClassTypeInSignature.kt")
      public void testAnnotatedPropertyWithInlineClassTypeInSignature() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotatedPropertyWithInlineClassTypeInSignature.kt");
      }

      @Test
      @TestMetadata("annotationGetters.kt")
      public void testAnnotationGetters() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationGetters.kt");
      }

      @Test
      @TestMetadata("annotationsOnHiddenConstructor.kt")
      public void testAnnotationsOnHiddenConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationsOnHiddenConstructor.kt");
      }

      @Test
      @TestMetadata("companionObjectInsideInlineClass.kt")
      public void testCompanionObjectInsideInlineClass() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/companionObjectInsideInlineClass.kt");
      }

      @Test
      @TestMetadata("computablePropertiesInsideInlineClass.kt")
      public void testComputablePropertiesInsideInlineClass() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/computablePropertiesInsideInlineClass.kt");
      }

      @Test
      @TestMetadata("constructor.kt")
      public void testConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructor.kt");
      }

      @Test
      @TestMetadata("constructorsWithDefaultParameterValues.kt")
      public void testConstructorsWithDefaultParameterValues() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructorsWithDefaultParameterValues.kt");
      }

      @Test
      @TestMetadata("defaultInterfaceMethodsInInlineClass.kt")
      public void testDefaultInterfaceMethodsInInlineClass() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMethodsInInlineClass.kt");
      }

      @Test
      @TestMetadata("genericChild.kt")
      public void testGenericChild() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/genericChild.kt");
      }

      @Test
      @TestMetadata("hiddenConstructor.kt")
      public void testHiddenConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/hiddenConstructor.kt");
      }

      @Test
      @TestMetadata("inlineCharSequence.kt")
      public void testInlineCharSequence() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCharSequence.kt");
      }

      @Test
      @TestMetadata("inlineClassMembersVisibility.kt")
      public void testInlineClassMembersVisibility() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassMembersVisibility.kt");
      }

      @Test
      @TestMetadata("inlineClassTypeParametersInConstructor.kt")
      public void testInlineClassTypeParametersInConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassTypeParametersInConstructor.kt");
      }

      @Test
      @TestMetadata("inlineClassWithInlineClassUnderlyingType.kt")
      public void testInlineClassWithInlineClassUnderlyingType() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithInlineClassUnderlyingType.kt");
      }

      @Test
      @TestMetadata("inlineClassWithManyKindsOfMembers.kt")
      public void testInlineClassWithManyKindsOfMembers() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithManyKindsOfMembers.kt");
      }

      @Test
      @TestMetadata("jvmName.kt")
      public void testJvmName() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmName.kt");
      }

      @Test
      @TestMetadata("jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
      public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValue() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt");
      }

      @Test
      @TestMetadata("memberExtensionProperty.kt")
      public void testMemberExtensionProperty() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/memberExtensionProperty.kt");
      }

      @Test
      @TestMetadata("noArgConstructorForInlineClassParameter.kt")
      public void testNoArgConstructorForInlineClassParameter() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noArgConstructorForInlineClassParameter.kt");
      }

      @Test
      @TestMetadata("noBridgesForErasedInlineClass.kt")
      public void testNoBridgesForErasedInlineClass() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noBridgesForErasedInlineClass.kt");
      }

      @Test
      @TestMetadata("nullabilityAnnotationsOnInlineClassMembers.kt")
      public void testNullabilityAnnotationsOnInlineClassMembers() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
      }

      @Test
      @TestMetadata("nullabilityInExpansion.kt")
      public void testNullabilityInExpansion() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityInExpansion.kt");
      }

      @Test
      @TestMetadata("nullableAndNotNullPrimitive.kt")
      public void testNullableAndNotNullPrimitive() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullableAndNotNullPrimitive.kt");
      }

      @Test
      @TestMetadata("overridingGenericMethodWithInlineClassParameterType.kt")
      public void testOverridingGenericMethodWithInlineClassParameterType() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassParameterType.kt");
      }

      @Test
      @TestMetadata("overridingGenericMethodWithInlineClassReturnType.kt")
      public void testOverridingGenericMethodWithInlineClassReturnType() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassReturnType.kt");
      }

      @Test
      @TestMetadata("primaryValsWithDifferentVisibilities.kt")
      public void testPrimaryValsWithDifferentVisibilities() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/primaryValsWithDifferentVisibilities.kt");
      }

      @Test
      @TestMetadata("publishedApiAnnotationOnInlineClassConstructor.kt")
      public void testPublishedApiAnnotationOnInlineClassConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/publishedApiAnnotationOnInlineClassConstructor.kt");
      }

      @Test
      @TestMetadata("shapeOfInlineClassWithPrimitive.kt")
      public void testShapeOfInlineClassWithPrimitive() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/shapeOfInlineClassWithPrimitive.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers")
      @TestDataPath("$PROJECT_ROOT")
      public class DefaultInterfaceMembers {
        @Test
        public void testAllFilesPresentInDefaultInterfaceMembers() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("javaDefaultInterfaceMember.kt")
        public void testJavaDefaultInterfaceMember() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/javaDefaultInterfaceMember.kt");
        }

        @Test
        @TestMetadata("jvmDefaultAll.kt")
        public void testJvmDefaultAll() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/jvmDefaultAll.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection")
      @TestDataPath("$PROJECT_ROOT")
      public class InlineCollection {
        @Test
        public void testAllFilesPresentInInlineCollection() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("collection.kt")
        public void testCollection() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/collection.kt");
        }

        @Test
        @TestMetadata("iterable.kt")
        public void testIterable() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterable.kt");
        }

        @Test
        @TestMetadata("iterator.kt")
        public void testIterator() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterator.kt");
        }

        @Test
        @TestMetadata("list.kt")
        public void testList() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/list.kt");
        }

        @Test
        @TestMetadata("map.kt")
        public void testMap() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/map.kt");
        }

        @Test
        @TestMetadata("mapEntry.kt")
        public void testMapEntry() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mapEntry.kt");
        }

        @Test
        @TestMetadata("mutableCollection.kt")
        public void testMutableCollection() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableCollection.kt");
        }

        @Test
        @TestMetadata("mutableIterable.kt")
        public void testMutableIterable() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterable.kt");
        }

        @Test
        @TestMetadata("mutableIterator.kt")
        public void testMutableIterator() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterator.kt");
        }

        @Test
        @TestMetadata("mutableList.kt")
        public void testMutableList() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableList.kt");
        }

        @Test
        @TestMetadata("mutableMap.kt")
        public void testMutableMap() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMap.kt");
        }

        @Test
        @TestMetadata("mutableMapEntry.kt")
        public void testMutableMapEntry() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMapEntry.kt");
        }

        @Test
        @TestMetadata("mutableSet.kt")
        public void testMutableSet() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableSet.kt");
        }

        @Test
        @TestMetadata("set.kt")
        public void testSet() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/set.kt");
        }

        @Test
        @TestMetadata("UIntArrayWithFullJdk.kt")
        public void testUIntArrayWithFullJdk() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/UIntArrayWithFullJdk.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass")
      @TestDataPath("$PROJECT_ROOT")
      public class InlineCollectionOfInlineClass {
        @Test
        public void testAllFilesPresentInInlineCollectionOfInlineClass() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("collection.kt")
        public void testCollection() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/collection.kt");
        }

        @Test
        @TestMetadata("iterable.kt")
        public void testIterable() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterable.kt");
        }

        @Test
        @TestMetadata("iterator.kt")
        public void testIterator() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterator.kt");
        }

        @Test
        @TestMetadata("list.kt")
        public void testList() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/list.kt");
        }

        @Test
        @TestMetadata("map.kt")
        public void testMap() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/map.kt");
        }

        @Test
        @TestMetadata("mapEntry.kt")
        public void testMapEntry() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mapEntry.kt");
        }

        @Test
        @TestMetadata("mutableCollection.kt")
        public void testMutableCollection() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableCollection.kt");
        }

        @Test
        @TestMetadata("mutableIterable.kt")
        public void testMutableIterable() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterable.kt");
        }

        @Test
        @TestMetadata("mutableIterator.kt")
        public void testMutableIterator() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterator.kt");
        }

        @Test
        @TestMetadata("mutableList.kt")
        public void testMutableList() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableList.kt");
        }

        @Test
        @TestMetadata("mutableMap.kt")
        public void testMutableMap() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMap.kt");
        }

        @Test
        @TestMetadata("mutableMapEntry.kt")
        public void testMutableMapEntry() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMapEntry.kt");
        }

        @Test
        @TestMetadata("mutableSet.kt")
        public void testMutableSet() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet.kt");
        }

        @Test
        @TestMetadata("mutableSet2.kt")
        public void testMutableSet2() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet2.kt");
        }

        @Test
        @TestMetadata("set.kt")
        public void testSet() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/set.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult")
      @TestDataPath("$PROJECT_ROOT")
      public class ReturnResult {
        @Test
        public void testAllFilesPresentInReturnResult() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("class.kt")
        public void testClass() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/class.kt");
        }

        @Test
        @TestMetadata("classAnyOverride.kt")
        public void testClassAnyOverride() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classAnyOverride.kt");
        }

        @Test
        @TestMetadata("classGenericOverride.kt")
        public void testClassGenericOverride() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classGenericOverride.kt");
        }

        @Test
        @TestMetadata("classResultOverride.kt")
        public void testClassResultOverride() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classResultOverride.kt");
        }

        @Test
        @TestMetadata("interface.kt")
        public void testInterface() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/interface.kt");
        }

        @Test
        @TestMetadata("topLevel.kt")
        public void testTopLevel() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/topLevel.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430")
      @TestDataPath("$PROJECT_ROOT")
      public class StdlibManglingIn1430 {
        @Test
        public void testAllFilesPresentInStdlibManglingIn1430() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("new.kt")
        public void testNew() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/new.kt");
        }

        @Test
        @TestMetadata("old.kt")
        public void testOld() {
          runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/old.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    public class Jvm8 {
      @Test
      public void testAllFilesPresentInJvm8() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults")
      @TestDataPath("$PROJECT_ROOT")
      public class Defaults {
        @Test
        public void testAllFilesPresentInDefaults() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility")
        @TestDataPath("$PROJECT_ROOT")
        public class AllCompatibility {
          @Test
          public void testAllFilesPresentInAllCompatibility() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("deprecation.kt")
          public void testDeprecation() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecation.kt");
          }

          @Test
          @TestMetadata("deprecationWithDefault.kt")
          public void testDeprecationWithDefault() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecationWithDefault.kt");
          }

          @Test
          @TestMetadata("interfaceProperty.kt")
          public void testInterfaceProperty() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/interfaceProperty.kt");
          }

          @Test
          @TestMetadata("jvmDefaultWithoutCompatibility.kt")
          public void testJvmDefaultWithoutCompatibility() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/jvmDefaultWithoutCompatibility.kt");
          }

          @Test
          @TestMetadata("noDefaultImplsOnEmptySubInterface.kt")
          public void testNoDefaultImplsOnEmptySubInterface() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/noDefaultImplsOnEmptySubInterface.kt");
          }

          @Nested
          @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization")
          @TestDataPath("$PROJECT_ROOT")
          public class Specialization {
            @Test
            public void testAllFilesPresentInSpecialization() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("primitiveAndAny.kt")
            public void testPrimitiveAndAny() {
              runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndAny.kt");
            }

            @Test
            @TestMetadata("primitiveAndNullable.kt")
            public void testPrimitiveAndNullable() {
              runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndNullable.kt");
            }
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl")
        @TestDataPath("$PROJECT_ROOT")
        public class NoDefaultImpl {
          @Test
          public void testAllFilesPresentInNoDefaultImpl() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("interfaceProperty.kt")
          public void testInterfaceProperty() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/interfaceProperty.kt");
          }

          @Test
          @TestMetadata("privateAccessorNaming.kt")
          public void testPrivateAccessorNaming() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/privateAccessorNaming.kt");
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/jvmStatic")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmStatic {
      @Test
      public void testAllFilesPresentInJvmStatic() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("jvmStaticExternal.kt")
      public void testJvmStaticExternal() {
        runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticExternal.kt");
      }

      @Test
      @TestMetadata("jvmStaticPrivate.kt")
      public void testJvmStaticPrivate() {
        runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticPrivate.kt");
      }

      @Test
      @TestMetadata("jvmStaticWithDefaultParameters.kt")
      public void testJvmStaticWithDefaultParameters() {
        runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticWithDefaultParameters.kt");
      }

      @Test
      @TestMetadata("kt31389.kt")
      public void testKt31389() {
        runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/kt31389.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/localFunctions")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalFunctions {
      @Test
      public void testAllFilesPresentInLocalFunctions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("genericClass.kt")
      public void testGenericClass() {
        runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericClass.kt");
      }

      @Test
      @TestMetadata("genericInnerClass.kt")
      public void testGenericInnerClass() {
        runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericInnerClass.kt");
      }

      @Test
      @TestMetadata("genericLocalClass.kt")
      public void testGenericLocalClass() {
        runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericLocalClass.kt");
      }

      @Test
      @TestMetadata("inInitBlock.kt")
      public void testInInitBlock() {
        runTest("compiler/testData/codegen/bytecodeListing/localFunctions/inInitBlock.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/bytecodeListing/localFunctions/simple.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/main")
    @TestDataPath("$PROJECT_ROOT")
    public class Main {
      @Test
      public void testAllFilesPresentInMain() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/main"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("multifileSuspend.kt")
      public void testMultifileSuspend() {
        runTest("compiler/testData/codegen/bytecodeListing/main/multifileSuspend.kt");
      }

      @Test
      @TestMetadata("parameterlessMain.kt")
      public void testParameterlessMain() {
        runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain.kt");
      }

      @Test
      @TestMetadata("parameterlessMain_before.kt")
      public void testParameterlessMain_before() {
        runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain_before.kt");
      }

      @Test
      @TestMetadata("suspendMain.kt")
      public void testSuspendMain() {
        runTest("compiler/testData/codegen/bytecodeListing/main/suspendMain.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class MultifileClasses {
      @Test
      public void testAllFilesPresentInMultifileClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("emptyMultifileFacade.kt")
      public void testEmptyMultifileFacade() {
        runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/emptyMultifileFacade.kt");
      }

      @Test
      @TestMetadata("jvmSynthetic.kt")
      public void testJvmSynthetic() {
        runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/jvmSynthetic.kt");
      }

      @Test
      @TestMetadata("kt43519.kt")
      public void testKt43519() {
        runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/kt43519.kt");
      }

      @Test
      @TestMetadata("multiClassPartSourceMultipleParts.kt")
      public void testMultiClassPartSourceMultipleParts() {
        runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceMultipleParts.kt");
      }

      @Test
      @TestMetadata("multiClassPartSourceSinglePart.kt")
      public void testMultiClassPartSourceSinglePart() {
        runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceSinglePart.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/multiplatform")
    @TestDataPath("$PROJECT_ROOT")
    public class Multiplatform {
      @Test
      public void testAllFilesPresentInMultiplatform() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("optionalExpectation.kt")
      public void testOptionalExpectation() {
        runTest("compiler/testData/codegen/bytecodeListing/multiplatform/optionalExpectation.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations")
    @TestDataPath("$PROJECT_ROOT")
    public class NullabilityAnnotations {
      @Test
      public void testAllFilesPresentInNullabilityAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("lateInitNotNull.kt")
      public void testLateInitNotNull() {
        runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/lateInitNotNull.kt");
      }

      @Test
      @TestMetadata("nullabilityAnnotationsForReturnType.kt")
      public void testNullabilityAnnotationsForReturnType() {
        runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsForReturnType.kt");
      }

      @Test
      @TestMetadata("nullabilityAnnotationsOnDelegatedMembers.kt")
      public void testNullabilityAnnotationsOnDelegatedMembers() {
        runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsOnDelegatedMembers.kt");
      }

      @Test
      @TestMetadata("platformTypes.kt")
      public void testPlatformTypes() {
        runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/platformTypes.kt");
      }

      @Test
      @TestMetadata("samAdapterForJavaInterfaceWithNullability.kt")
      public void testSamAdapterForJavaInterfaceWithNullability() {
        runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/samAdapterForJavaInterfaceWithNullability.kt");
      }

      @Test
      @TestMetadata("suspendFunction.kt")
      public void testSuspendFunction() {
        runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/suspendFunction.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/properties")
    @TestDataPath("$PROJECT_ROOT")
    public class Properties {
      @Test
      public void testAllFilesPresentInProperties() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/properties/backingField")
      @TestDataPath("$PROJECT_ROOT")
      public class BackingField {
        @Test
        public void testAllFilesPresentInBackingField() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/properties/backingField"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("explicitBackingFieldsInJava.kt")
        public void testExplicitBackingFieldsInJava() {
          runTest("compiler/testData/codegen/bytecodeListing/properties/backingField/explicitBackingFieldsInJava.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/sam")
    @TestDataPath("$PROJECT_ROOT")
    public class Sam {
      @Test
      public void testAllFilesPresentInSam() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("callableRefGenericFunInterface.kt")
      public void testCallableRefGenericFunInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericFunInterface.kt");
      }

      @Test
      @TestMetadata("callableRefGenericSamInterface.kt")
      public void testCallableRefGenericSamInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericSamInterface.kt");
      }

      @Test
      @TestMetadata("callableRefSpecializedFunInterface.kt")
      public void testCallableRefSpecializedFunInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedFunInterface.kt");
      }

      @Test
      @TestMetadata("callableRefSpecializedSamInterface.kt")
      public void testCallableRefSpecializedSamInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedSamInterface.kt");
      }

      @Test
      @TestMetadata("genericFunInterface.kt")
      public void testGenericFunInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/genericFunInterface.kt");
      }

      @Test
      @TestMetadata("genericSamInterface.kt")
      public void testGenericSamInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/genericSamInterface.kt");
      }

      @Test
      @TestMetadata("indySamConversionViaProxyFun.kt")
      public void testIndySamConversionViaProxyFun() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/indySamConversionViaProxyFun.kt");
      }

      @Test
      @TestMetadata("kt16650.kt")
      public void testKt16650() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/kt16650.kt");
      }

      @Test
      @TestMetadata("lambdaGenericFunInterface.kt")
      public void testLambdaGenericFunInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericFunInterface.kt");
      }

      @Test
      @TestMetadata("lambdaGenericSamInterface.kt")
      public void testLambdaGenericSamInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericSamInterface.kt");
      }

      @Test
      @TestMetadata("lambdaSpecializedFunInterface.kt")
      public void testLambdaSpecializedFunInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedFunInterface.kt");
      }

      @Test
      @TestMetadata("lambdaSpecializedSamInterface.kt")
      public void testLambdaSpecializedSamInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedSamInterface.kt");
      }

      @Test
      @TestMetadata("nonApproxToValidSupertype.kt")
      public void testNonApproxToValidSupertype() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype.kt");
      }

      @Test
      @TestMetadata("nonApproxToValidSupertype2.kt")
      public void testNonApproxToValidSupertype2() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype2.kt");
      }

      @Test
      @TestMetadata("privateInlineSamAdapter.kt")
      public void testPrivateInlineSamAdapter() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/privateInlineSamAdapter.kt");
      }

      @Test
      @TestMetadata("reusedSamWrapperClasses.kt")
      public void testReusedSamWrapperClasses() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/reusedSamWrapperClasses.kt");
      }

      @Test
      @TestMetadata("samAdapterAndInlinedOne.kt")
      public void testSamAdapterAndInlinedOne() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterAndInlinedOne.kt");
      }

      @Test
      @TestMetadata("samAdapterInInlineLambda.kt")
      public void testSamAdapterInInlineLambda() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterInInlineLambda.kt");
      }

      @Test
      @TestMetadata("samWithContravariantProjection.kt")
      public void testSamWithContravariantProjection() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/samWithContravariantProjection.kt");
      }

      @Test
      @TestMetadata("severalProxyFunsInInit.kt")
      public void testSeveralProxyFunsInInit() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/severalProxyFunsInInit.kt");
      }

      @Test
      @TestMetadata("specializedFunInterface.kt")
      public void testSpecializedFunInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/specializedFunInterface.kt");
      }

      @Test
      @TestMetadata("specializedSamInterface.kt")
      public void testSpecializedSamInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/specializedSamInterface.kt");
      }

      @Test
      @TestMetadata("wrapperInlinedFromAnotherClass.kt")
      public void testWrapperInlinedFromAnotherClass() {
        runTest("compiler/testData/codegen/bytecodeListing/sam/wrapperInlinedFromAnotherClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/sealed")
    @TestDataPath("$PROJECT_ROOT")
    public class Sealed {
      @Test
      public void testAllFilesPresentInSealed() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotationsOnSealedConstructor.kt")
      public void testAnnotationsOnSealedConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/sealed/annotationsOnSealedConstructor.kt");
      }

      @Test
      @TestMetadata("permittedSubclasses_1_7.kt")
      public void testPermittedSubclasses_1_7() {
        runTest("compiler/testData/codegen/bytecodeListing/sealed/permittedSubclasses_1_7.kt");
      }

      @Test
      @TestMetadata("sealedClassConstructor_1_4.kt")
      public void testSealedClassConstructor_1_4() {
        runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_4.kt");
      }

      @Test
      @TestMetadata("sealedClassConstructor_1_5.kt")
      public void testSealedClassConstructor_1_5() {
        runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_5.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/specialBridges")
    @TestDataPath("$PROJECT_ROOT")
    public class SpecialBridges {
      @Test
      @TestMetadata("abstractCollections.kt")
      public void testAbstractCollections() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractCollections.kt");
      }

      @Test
      @TestMetadata("abstractIterables.kt")
      public void testAbstractIterables() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractIterables.kt");
      }

      @Test
      @TestMetadata("abstractLists.kt")
      public void testAbstractLists() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractLists.kt");
      }

      @Test
      @TestMetadata("abstractListsWithJavaBase.kt")
      public void testAbstractListsWithJavaBase() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractListsWithJavaBase.kt");
      }

      @Test
      @TestMetadata("abstractMutableCollectionOfPrimitive.kt")
      public void testAbstractMutableCollectionOfPrimitive() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableCollectionOfPrimitive.kt");
      }

      @Test
      @TestMetadata("abstractMutableListOfPrimitive.kt")
      public void testAbstractMutableListOfPrimitive() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableListOfPrimitive.kt");
      }

      @Test
      @TestMetadata("abstractMutableLists.kt")
      public void testAbstractMutableLists() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableLists.kt");
      }

      @Test
      @TestMetadata("abstractSets.kt")
      public void testAbstractSets() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractSets.kt");
      }

      @Test
      public void testAllFilesPresentInSpecialBridges() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("bridgeForIntersectionBetweenRenamedMethodAndProperty.kt")
      public void testBridgeForIntersectionBetweenRenamedMethodAndProperty() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/bridgeForIntersectionBetweenRenamedMethodAndProperty.kt");
      }

      @Test
      @TestMetadata("charSequence.kt")
      public void testCharSequence() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/charSequence.kt");
      }

      @Test
      @TestMetadata("contains.kt")
      public void testContains() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/contains.kt");
      }

      @Test
      @TestMetadata("kt41123.kt")
      public void testKt41123() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt41123.kt");
      }

      @Test
      @TestMetadata("kt48945.kt")
      public void testKt48945() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt48945.kt");
      }

      @Test
      @TestMetadata("mutableCollectionOfPrimitive.kt")
      public void testMutableCollectionOfPrimitive() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableCollectionOfPrimitive.kt");
      }

      @Test
      @TestMetadata("mutableListOfPrimitive.kt")
      public void testMutableListOfPrimitive() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableListOfPrimitive.kt");
      }

      @Test
      @TestMetadata("noDefaultImplsOnEmptySubInterface.kt")
      public void testNoDefaultImplsOnEmptySubInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noDefaultImplsOnEmptySubInterface.kt");
      }

      @Test
      @TestMetadata("noSpecialBridgeIfPresentInSuperClass.kt")
      public void testNoSpecialBridgeIfPresentInSuperClass() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noSpecialBridgeIfPresentInSuperClass.kt");
      }

      @Test
      @TestMetadata("number.kt")
      public void testNumber() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/number.kt");
      }

      @Test
      @TestMetadata("redundantStubForSize.kt")
      public void testRedundantStubForSize() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/redundantStubForSize.kt");
      }

      @Test
      @TestMetadata("removeAtTwoSpecialBridges.kt")
      public void testRemoveAtTwoSpecialBridges() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/removeAtTwoSpecialBridges.kt");
      }

      @Test
      @TestMetadata("specialBridgeForGet.kt")
      public void testSpecialBridgeForGet() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/specialBridgeForGet.kt");
      }

      @Test
      @TestMetadata("unsignedArray.kt")
      public void testUnsignedArray() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/unsignedArray.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/specialBridges/signatures")
      @TestDataPath("$PROJECT_ROOT")
      public class Signatures {
        @Test
        public void testAllFilesPresentInSignatures() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges/signatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("genericClass.kt")
        public void testGenericClass() {
          runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/genericClass.kt");
        }

        @Test
        @TestMetadata("implementsJavaMap.kt")
        public void testImplementsJavaMap() {
          runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMap.kt");
        }

        @Test
        @TestMetadata("implementsJavaMapWithCustomEntries.kt")
        public void testImplementsJavaMapWithCustomEntries() {
          runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMapWithCustomEntries.kt");
        }

        @Test
        @TestMetadata("implementsMap.kt")
        public void testImplementsMap() {
          runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsMap.kt");
        }

        @Test
        @TestMetadata("implementsSortedMap.kt")
        public void testImplementsSortedMap() {
          runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsSortedMap.kt");
        }

        @Test
        @TestMetadata("kt43610.kt")
        public void testKt43610() {
          runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/kt43610.kt");
        }

        @Test
        @TestMetadata("nonGenericClass.kt")
        public void testNonGenericClass() {
          runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/nonGenericClass.kt");
        }

        @Test
        @TestMetadata("partiallySpecializedClass.kt")
        public void testPartiallySpecializedClass() {
          runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/partiallySpecializedClass.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/valueClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class ValueClasses {
      @Test
      public void testAllFilesPresentInValueClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotations.kt")
      public void testAnnotations() {
        runTest("compiler/testData/codegen/bytecodeListing/valueClasses/annotations.kt");
      }

      @Test
      @TestMetadata("nullabilityAnnotationsOnInlineClassMembers.kt")
      public void testNullabilityAnnotationsOnInlineClassMembers() {
        runTest("compiler/testData/codegen/bytecodeListing/valueClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/composeLike")
  @TestDataPath("$PROJECT_ROOT")
  public class ComposeLike {
    @Test
    public void testAllFilesPresentInComposeLike() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/composeLike"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("default.kt")
    public void testDefault() {
      runTest("compiler/testData/codegen/composeLike/default.kt");
    }

    @Test
    @TestMetadata("defaultInline.kt")
    public void testDefaultInline() {
      runTest("compiler/testData/codegen/composeLike/defaultInline.kt");
    }

    @Test
    @TestMetadata("defaultLocal.kt")
    public void testDefaultLocal() {
      runTest("compiler/testData/codegen/composeLike/defaultLocal.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/composeLikeBytecodeText")
  @TestDataPath("$PROJECT_ROOT")
  public class ComposeLikeBytecodeText {
    @Test
    public void testAllFilesPresentInComposeLikeBytecodeText() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/composeLikeBytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("default.kt")
    public void testDefault() {
      runTest("compiler/testData/codegen/composeLikeBytecodeText/default.kt");
    }

    @Test
    @TestMetadata("defaultInline.kt")
    public void testDefaultInline() {
      runTest("compiler/testData/codegen/composeLikeBytecodeText/defaultInline.kt");
    }

    @Test
    @TestMetadata("defaultLocal.kt")
    public void testDefaultLocal() {
      runTest("compiler/testData/codegen/composeLikeBytecodeText/defaultLocal.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/defaultArguments")
  @TestDataPath("$PROJECT_ROOT")
  public class DefaultArguments {
    @Test
    public void testAllFilesPresentInDefaultArguments() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/defaultArguments/reflection")
    @TestDataPath("$PROJECT_ROOT")
    public class Reflection {
      @Test
      public void testAllFilesPresentInReflection() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/defaultArguments/reflection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("classInClassObject.kt")
      public void testClassInClassObject() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/classInClassObject.kt");
      }

      @Test
      @TestMetadata("classInObject.kt")
      public void testClassInObject() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/classInObject.kt");
      }

      @Test
      @TestMetadata("classWithTwoDefaultArgs.kt")
      public void testClassWithTwoDefaultArgs() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/classWithTwoDefaultArgs.kt");
      }

      @Test
      @TestMetadata("classWithVararg.kt")
      public void testClassWithVararg() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/classWithVararg.kt");
      }

      @Test
      @TestMetadata("enum.kt")
      public void testEnum() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/enum.kt");
      }

      @Test
      @TestMetadata("internalClass.kt")
      public void testInternalClass() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/internalClass.kt");
      }

      @Test
      @TestMetadata("privateClass.kt")
      public void testPrivateClass() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/privateClass.kt");
      }

      @Test
      @TestMetadata("privateConstructor.kt")
      public void testPrivateConstructor() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/privateConstructor.kt");
      }

      @Test
      @TestMetadata("publicClass.kt")
      public void testPublicClass() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/publicClass.kt");
      }

      @Test
      @TestMetadata("publicClassWoDefArgs.kt")
      public void testPublicClassWoDefArgs() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/publicClassWoDefArgs.kt");
      }

      @Test
      @TestMetadata("publicInnerClass.kt")
      public void testPublicInnerClass() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/publicInnerClass.kt");
      }

      @Test
      @TestMetadata("publicInnerClassInPrivateClass.kt")
      public void testPublicInnerClassInPrivateClass() {
        runTest("compiler/testData/codegen/defaultArguments/reflection/publicInnerClassInPrivateClass.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/script")
  @TestDataPath("$PROJECT_ROOT")
  public class Script {
    @Test
    @TestMetadata("adder.kts")
    public void testAdder() {
      runTest("compiler/testData/codegen/script/adder.kts");
    }

    @Test
    public void testAllFilesPresentInScript() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/script"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("classLiteralInsideFunction.kts")
    public void testClassLiteralInsideFunction() {
      runTest("compiler/testData/codegen/script/classLiteralInsideFunction.kts");
    }

    @Test
    @TestMetadata("destructuringDeclaration.kts")
    public void testDestructuringDeclaration() {
      runTest("compiler/testData/codegen/script/destructuringDeclaration.kts");
    }

    @Test
    @TestMetadata("destructuringDeclarationUnderscore.kts")
    public void testDestructuringDeclarationUnderscore() {
      runTest("compiler/testData/codegen/script/destructuringDeclarationUnderscore.kts");
    }

    @Test
    @TestMetadata("empty.kts")
    public void testEmpty() {
      runTest("compiler/testData/codegen/script/empty.kts");
    }

    @Test
    @TestMetadata("helloWorld.kts")
    public void testHelloWorld() {
      runTest("compiler/testData/codegen/script/helloWorld.kts");
    }

    @Test
    @TestMetadata("inline.kts")
    public void testInline() {
      runTest("compiler/testData/codegen/script/inline.kts");
    }

    @Test
    @TestMetadata("innerClass.kts")
    public void testInnerClass() {
      runTest("compiler/testData/codegen/script/innerClass.kts");
    }

    @Test
    @TestMetadata("kt20707.kts")
    public void testKt20707() {
      runTest("compiler/testData/codegen/script/kt20707.kts");
    }

    @Test
    @TestMetadata("kt22029.kts")
    public void testKt22029() {
      runTest("compiler/testData/codegen/script/kt22029.kts");
    }

    @Test
    @TestMetadata("kt48025.kts")
    public void testKt48025() {
      runTest("compiler/testData/codegen/script/kt48025.kts");
    }

    @Test
    @TestMetadata("localDelegatedProperty.kts")
    public void testLocalDelegatedProperty() {
      runTest("compiler/testData/codegen/script/localDelegatedProperty.kts");
    }

    @Test
    @TestMetadata("localDelegatedPropertyInLambda.kts")
    public void testLocalDelegatedPropertyInLambda() {
      runTest("compiler/testData/codegen/script/localDelegatedPropertyInLambda.kts");
    }

    @Test
    @TestMetadata("localDelegatedPropertyNoExplicitType.kts")
    public void testLocalDelegatedPropertyNoExplicitType() {
      runTest("compiler/testData/codegen/script/localDelegatedPropertyNoExplicitType.kts");
    }

    @Test
    @TestMetadata("localFunction.kts")
    public void testLocalFunction() {
      runTest("compiler/testData/codegen/script/localFunction.kts");
    }

    @Test
    @TestMetadata("MultiDollarInterpolation.kts")
    public void testMultiDollarInterpolation() {
      runTest("compiler/testData/codegen/script/MultiDollarInterpolation.kts");
    }

    @Test
    @TestMetadata("outerCapture.kts")
    public void testOuterCapture() {
      runTest("compiler/testData/codegen/script/outerCapture.kts");
    }

    @Test
    @TestMetadata("parameter.kts")
    public void testParameter() {
      runTest("compiler/testData/codegen/script/parameter.kts");
    }

    @Test
    @TestMetadata("parameterArray.kts")
    public void testParameterArray() {
      runTest("compiler/testData/codegen/script/parameterArray.kts");
    }

    @Test
    @TestMetadata("parameterClosure.kts")
    public void testParameterClosure() {
      runTest("compiler/testData/codegen/script/parameterClosure.kts");
    }

    @Test
    @TestMetadata("parameterLong.kts")
    public void testParameterLong() {
      runTest("compiler/testData/codegen/script/parameterLong.kts");
    }

    @Test
    @TestMetadata("secondLevelFunction.kts")
    public void testSecondLevelFunction() {
      runTest("compiler/testData/codegen/script/secondLevelFunction.kts");
    }

    @Test
    @TestMetadata("secondLevelFunctionClosure.kts")
    public void testSecondLevelFunctionClosure() {
      runTest("compiler/testData/codegen/script/secondLevelFunctionClosure.kts");
    }

    @Test
    @TestMetadata("secondLevelVal.kts")
    public void testSecondLevelVal() {
      runTest("compiler/testData/codegen/script/secondLevelVal.kts");
    }

    @Test
    @TestMetadata("simpleClass.kts")
    public void testSimpleClass() {
      runTest("compiler/testData/codegen/script/simpleClass.kts");
    }

    @Test
    @TestMetadata("string.kts")
    public void testString() {
      runTest("compiler/testData/codegen/script/string.kts");
    }

    @Test
    @TestMetadata("topLevelFunction.kts")
    public void testTopLevelFunction() {
      runTest("compiler/testData/codegen/script/topLevelFunction.kts");
    }

    @Test
    @TestMetadata("topLevelFunctionClosure.kts")
    public void testTopLevelFunctionClosure() {
      runTest("compiler/testData/codegen/script/topLevelFunctionClosure.kts");
    }

    @Test
    @TestMetadata("topLevelLocalDelegatedProperty.kts")
    public void testTopLevelLocalDelegatedProperty() {
      runTest("compiler/testData/codegen/script/topLevelLocalDelegatedProperty.kts");
    }

    @Test
    @TestMetadata("topLevelPropertiesWithGetSet.kts")
    public void testTopLevelPropertiesWithGetSet() {
      runTest("compiler/testData/codegen/script/topLevelPropertiesWithGetSet.kts");
    }

    @Test
    @TestMetadata("topLevelProperty.kts")
    public void testTopLevelProperty() {
      runTest("compiler/testData/codegen/script/topLevelProperty.kts");
    }

    @Test
    @TestMetadata("topLevelPropertyWithProvideDelegate.kts")
    public void testTopLevelPropertyWithProvideDelegate() {
      runTest("compiler/testData/codegen/script/topLevelPropertyWithProvideDelegate.kts");
    }

    @Test
    @TestMetadata("topLevelTypealias.kts")
    public void testTopLevelTypealias() {
      runTest("compiler/testData/codegen/script/topLevelTypealias.kts");
    }

    @Test
    @TestMetadata("twoDestructuringDeclarations.kts")
    public void testTwoDestructuringDeclarations() {
      runTest("compiler/testData/codegen/script/twoDestructuringDeclarations.kts");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/script/scriptInstanceCapturing")
    @TestDataPath("$PROJECT_ROOT")
    public class ScriptInstanceCapturing {
      @Test
      public void testAllFilesPresentInScriptInstanceCapturing() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/script/scriptInstanceCapturing"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("anonymousObjectCapturesProperty.kts")
      public void testAnonymousObjectCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/anonymousObjectCapturesProperty.kts");
      }

      @Test
      @TestMetadata("classCapturesExtensionIndirect.kts")
      public void testClassCapturesExtensionIndirect() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesExtensionIndirect.kts");
      }

      @Test
      @TestMetadata("classCapturesExtensionIndirect2x.kts")
      public void testClassCapturesExtensionIndirect2x() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesExtensionIndirect2x.kts");
      }

      @Test
      @TestMetadata("classCapturesFunction.kts")
      public void testClassCapturesFunction() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesFunction.kts");
      }

      @Test
      @TestMetadata("classCapturesProperty.kts")
      public void testClassCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesProperty.kts");
      }

      @Test
      @TestMetadata("classCapturesPropertyInStringTemplate.kts")
      public void testClassCapturesPropertyInStringTemplate() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyInStringTemplate.kts");
      }

      @Test
      @TestMetadata("classCapturesPropertyIndirect.kts")
      public void testClassCapturesPropertyIndirect() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyIndirect.kts");
      }

      @Test
      @TestMetadata("classCapturesPropertyIndirect2x.kts")
      public void testClassCapturesPropertyIndirect2x() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyIndirect2x.kts");
      }

      @Test
      @TestMetadata("companionCapturesProperty.kts")
      public void testCompanionCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/companionCapturesProperty.kts");
      }

      @Test
      @TestMetadata("enumCapturesProperty.kts")
      public void testEnumCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/enumCapturesProperty.kts");
      }

      @Test
      @TestMetadata("enumEntryCapturesProperty.kts")
      public void testEnumEntryCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/enumEntryCapturesProperty.kts");
      }

      @Test
      @TestMetadata("innerClassesHierarchyCaptureProperty.kts")
      public void testInnerClassesHierarchyCaptureProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/innerClassesHierarchyCaptureProperty.kts");
      }

      @Test
      @TestMetadata("interfaceCapturesProperty.kts")
      public void testInterfaceCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/interfaceCapturesProperty.kts");
      }

      @Test
      @TestMetadata("nestedAndOuterClassesCaptureProperty.kts")
      public void testNestedAndOuterClassesCaptureProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedAndOuterClassesCaptureProperty.kts");
      }

      @Test
      @TestMetadata("nestedClassCapturesProperty.kts")
      public void testNestedClassCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedClassCapturesProperty.kts");
      }

      @Test
      @TestMetadata("nestedInnerClassCapturesProperty.kts")
      public void testNestedInnerClassCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedInnerClassCapturesProperty.kts");
      }

      @Test
      @TestMetadata("nestedToObjectClassCapturesProperty.kts")
      public void testNestedToObjectClassCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedToObjectClassCapturesProperty.kts");
      }

      @Test
      @TestMetadata("objectCapturesProperty.kts")
      public void testObjectCapturesProperty() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesProperty.kts");
      }

      @Test
      @TestMetadata("objectCapturesPropertyIndirect.kts")
      public void testObjectCapturesPropertyIndirect() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesPropertyIndirect.kts");
      }

      @Test
      @TestMetadata("objectCapturesPropertyViaExtension.kts")
      public void testObjectCapturesPropertyViaExtension() {
        runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesPropertyViaExtension.kts");
      }
    }
  }
}
