/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.test.generators.GenerateCompilerTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/bytecodeListing")
@TestDataPath("$PROJECT_ROOT")
public class IrBytecodeListingTestGenerated extends AbstractIrBytecodeListingTest {
  @Test
  @TestMetadata("accessorForProtectedPropertyWithPrivateSetter.kt")
  public void testAccessorForProtectedPropertyWithPrivateSetter() {
    runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetter.kt");
  }

  @Test
  @TestMetadata("accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt")
  public void testAccessorForProtectedPropertyWithPrivateSetterInObjectLiteral() {
    runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt");
  }

  @Test
  @TestMetadata("accessorForTopLevelMembers.kt")
  public void testAccessorForTopLevelMembers() {
    runTest("compiler/testData/codegen/bytecodeListing/accessorForTopLevelMembers.kt");
  }

  @Test
  @TestMetadata("accessorsForProtectedStaticJavaFieldInOtherPackage.kt")
  public void testAccessorsForProtectedStaticJavaFieldInOtherPackage() {
    runTest("compiler/testData/codegen/bytecodeListing/accessorsForProtectedStaticJavaFieldInOtherPackage.kt");
  }

  @Test
  public void testAllFilesPresentInBytecodeListing() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
  }

  @Test
  @TestMetadata("anonymousObjectInGenericFun.kt")
  public void testAnonymousObjectInGenericFun() {
    runTest("compiler/testData/codegen/bytecodeListing/anonymousObjectInGenericFun.kt");
  }

  @Test
  @TestMetadata("callableNameIntrinsic.kt")
  public void testCallableNameIntrinsic() {
    runTest("compiler/testData/codegen/bytecodeListing/callableNameIntrinsic.kt");
  }

  @Test
  @TestMetadata("callableReferenceArrayConstructorArguments.kt")
  public void testCallableReferenceArrayConstructorArguments() {
    runTest("compiler/testData/codegen/bytecodeListing/callableReferenceArrayConstructorArguments.kt");
  }

  @Test
  @TestMetadata("cloneable.kt")
  public void testCloneable() {
    runTest("compiler/testData/codegen/bytecodeListing/cloneable.kt");
  }

  @Test
  @TestMetadata("companionObjectVisibility_after.kt")
  public void testCompanionObjectVisibility_after() {
    runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_after.kt");
  }

  @Test
  @TestMetadata("companionObjectVisibility_before.kt")
  public void testCompanionObjectVisibility_before() {
    runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_before.kt");
  }

  @Test
  @TestMetadata("defaultImpls.kt")
  public void testDefaultImpls() {
    runTest("compiler/testData/codegen/bytecodeListing/defaultImpls.kt");
  }

  @Test
  @TestMetadata("delegationToJavaInterfaceWithWildcardType.kt")
  public void testDelegationToJavaInterfaceWithWildcardType() {
    runTest("compiler/testData/codegen/bytecodeListing/delegationToJavaInterfaceWithWildcardType.kt");
  }

  @Test
  @TestMetadata("deprecatedConstantPropertyInterfaceCompanion.kt")
  public void testDeprecatedConstantPropertyInterfaceCompanion() {
    runTest("compiler/testData/codegen/bytecodeListing/deprecatedConstantPropertyInterfaceCompanion.kt");
  }

  @Test
  @TestMetadata("deserializeLambdaMethod.kt")
  public void testDeserializeLambdaMethod() {
    runTest("compiler/testData/codegen/bytecodeListing/deserializeLambdaMethod.kt");
  }

  @Test
  @TestMetadata("enum.kt")
  public void testEnum() {
    runTest("compiler/testData/codegen/bytecodeListing/enum.kt");
  }

  @Test
  @TestMetadata("enumEntries.kt")
  public void testEnumEntries() {
    runTest("compiler/testData/codegen/bytecodeListing/enumEntries.kt");
  }

  @Test
  @TestMetadata("extension.kt")
  public void testExtension() {
    runTest("compiler/testData/codegen/bytecodeListing/extension.kt");
  }

  @Test
  @TestMetadata("fileClassWithPrivateDeclarationsOnly_after.kt")
  public void testFileClassWithPrivateDeclarationsOnly_after() {
    runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_after.kt");
  }

  @Test
  @TestMetadata("fileClassWithPrivateDeclarationsOnly_before.kt")
  public void testFileClassWithPrivateDeclarationsOnly_before() {
    runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_before.kt");
  }

  @Test
  @TestMetadata("immutableCollection.kt")
  public void testImmutableCollection() {
    runTest("compiler/testData/codegen/bytecodeListing/immutableCollection.kt");
  }

  @Test
  @TestMetadata("javaDeprecated.kt")
  public void testJavaDeprecated() {
    runTest("compiler/testData/codegen/bytecodeListing/javaDeprecated.kt");
  }

  @Test
  @TestMetadata("jvmOverloadsAndParametersAnnotations.kt")
  public void testJvmOverloadsAndParametersAnnotations() {
    runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsAndParametersAnnotations.kt");
  }

  @Test
  @TestMetadata("jvmOverloadsExternal.kt")
  public void testJvmOverloadsExternal() {
    runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsExternal.kt");
  }

  @Test
  @TestMetadata("jvmRecordStructure.kt")
  public void testJvmRecordStructure() {
    runTest("compiler/testData/codegen/bytecodeListing/jvmRecordStructure.kt");
  }

  @Test
  @TestMetadata("kt42137.kt")
  public void testKt42137() {
    runTest("compiler/testData/codegen/bytecodeListing/kt42137.kt");
  }

  @Test
  @TestMetadata("kt42879.kt")
  public void testKt42879() {
    runTest("compiler/testData/codegen/bytecodeListing/kt42879.kt");
  }

  @Test
  @TestMetadata("kt43217.kt")
  public void testKt43217() {
    runTest("compiler/testData/codegen/bytecodeListing/kt43217.kt");
  }

  @Test
  @TestMetadata("kt43440.kt")
  public void testKt43440() {
    runTest("compiler/testData/codegen/bytecodeListing/kt43440.kt");
  }

  @Test
  @TestMetadata("kt45853.kt")
  public void testKt45853() {
    runTest("compiler/testData/codegen/bytecodeListing/kt45853.kt");
  }

  @Test
  @TestMetadata("kt45853a.kt")
  public void testKt45853a() {
    runTest("compiler/testData/codegen/bytecodeListing/kt45853a.kt");
  }

  @Test
  @TestMetadata("kt45934.kt")
  public void testKt45934() {
    runTest("compiler/testData/codegen/bytecodeListing/kt45934.kt");
  }

  @Test
  @TestMetadata("kt47328.kt")
  public void testKt47328() {
    runTest("compiler/testData/codegen/bytecodeListing/kt47328.kt");
  }

  @Test
  @TestMetadata("kt55769.kt")
  public void testKt55769() {
    runTest("compiler/testData/codegen/bytecodeListing/kt55769.kt");
  }

  @Test
  @TestMetadata("noCollectionStubMethodsInInterface.kt")
  public void testNoCollectionStubMethodsInInterface() {
    runTest("compiler/testData/codegen/bytecodeListing/noCollectionStubMethodsInInterface.kt");
  }

  @Test
  @TestMetadata("noDelegationsToPrivateInterfaceMembers.kt")
  public void testNoDelegationsToPrivateInterfaceMembers() {
    runTest("compiler/testData/codegen/bytecodeListing/noDelegationsToPrivateInterfaceMembers.kt");
  }

  @Test
  @TestMetadata("noReceiverInCallableReferenceClasses.kt")
  public void testNoReceiverInCallableReferenceClasses() {
    runTest("compiler/testData/codegen/bytecodeListing/noReceiverInCallableReferenceClasses.kt");
  }

  @Test
  @TestMetadata("noRemoveAtInReadOnly.kt")
  public void testNoRemoveAtInReadOnly() {
    runTest("compiler/testData/codegen/bytecodeListing/noRemoveAtInReadOnly.kt");
  }

  @Test
  @TestMetadata("nullabilityAnnotationInInnerClasses.kt")
  public void testNullabilityAnnotationInInnerClasses() {
    runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotationInInnerClasses.kt");
  }

  @Test
  @TestMetadata("overrideWithPrimitiveUpperBound.kt")
  public void testOverrideWithPrimitiveUpperBound() {
    runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound.kt");
  }

  @Test
  @TestMetadata("overrideWithPrimitiveUpperBound2.kt")
  public void testOverrideWithPrimitiveUpperBound2() {
    runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound2.kt");
  }

  @Test
  @TestMetadata("privateCompanionFields.kt")
  public void testPrivateCompanionFields() {
    runTest("compiler/testData/codegen/bytecodeListing/privateCompanionFields.kt");
  }

  @Test
  @TestMetadata("privateDefaultImpls.kt")
  public void testPrivateDefaultImpls() {
    runTest("compiler/testData/codegen/bytecodeListing/privateDefaultImpls.kt");
  }

  @Test
  @TestMetadata("privateDefaultSetter.kt")
  public void testPrivateDefaultSetter() {
    runTest("compiler/testData/codegen/bytecodeListing/privateDefaultSetter.kt");
  }

  @Test
  @TestMetadata("privateNestedClassInInterface.kt")
  public void testPrivateNestedClassInInterface() {
    runTest("compiler/testData/codegen/bytecodeListing/privateNestedClassInInterface.kt");
  }

  @Test
  @TestMetadata("rawTypeInSignature.kt")
  public void testRawTypeInSignature() {
    runTest("compiler/testData/codegen/bytecodeListing/rawTypeInSignature.kt");
  }

  @Test
  @TestMetadata("strictfpFlag.kt")
  public void testStrictfpFlag() {
    runTest("compiler/testData/codegen/bytecodeListing/strictfpFlag.kt");
  }

  @Test
  @TestMetadata("synchronizedFlag.kt")
  public void testSynchronizedFlag() {
    runTest("compiler/testData/codegen/bytecodeListing/synchronizedFlag.kt");
  }

  @Test
  @TestMetadata("varargsBridge.kt")
  public void testVarargsBridge() {
    runTest("compiler/testData/codegen/bytecodeListing/varargsBridge.kt");
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/annotations")
  @TestDataPath("$PROJECT_ROOT")
  public class Annotations {
    @Test
    public void testAllFilesPresentInAnnotations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotationCtorCallGenerateSynthetic.kt")
    public void testAnnotationCtorCallGenerateSynthetic() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallGenerateSynthetic.kt");
    }

    @Test
    @TestMetadata("annotationCtorCallNoSynthetic.kt")
    public void testAnnotationCtorCallNoSynthetic() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallNoSynthetic.kt");
    }

    @Test
    @TestMetadata("annotationMixedTargeting.kt")
    public void testAnnotationMixedTargeting() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationMixedTargeting.kt");
    }

    @Test
    @TestMetadata("annotationsOnDelegatedMembers.kt")
    public void testAnnotationsOnDelegatedMembers() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationsOnDelegatedMembers.kt");
    }

    @Test
    @TestMetadata("defaultTargets.kt")
    public void testDefaultTargets() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/defaultTargets.kt");
    }

    @Test
    @TestMetadata("deprecatedJvmOverloads.kt")
    public void testDeprecatedJvmOverloads() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/deprecatedJvmOverloads.kt");
    }

    @Test
    @TestMetadata("internalPropertyOrTypealias.kt")
    public void testInternalPropertyOrTypealias() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/internalPropertyOrTypealias.kt");
    }

    @Test
    @TestMetadata("JvmSynthetic.kt")
    public void testJvmSynthetic() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/JvmSynthetic.kt");
    }

    @Test
    @TestMetadata("kt27895.kt")
    public void testKt27895() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/kt27895.kt");
    }

    @Test
    @TestMetadata("kt43399.kt")
    public void testKt43399() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43399.kt");
    }

    @Test
    @TestMetadata("kt43459.kt")
    public void testKt43459() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43459.kt");
    }

    @Test
    @TestMetadata("kt62788.kt")
    public void testKt62788() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/kt62788.kt");
    }

    @Test
    @TestMetadata("kt9320.kt")
    public void testKt9320() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/kt9320.kt");
    }

    @Test
    @TestMetadata("literals.kt")
    public void testLiterals() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/literals.kt");
    }

    @Test
    @TestMetadata("localClassWithCapturedParams.kt")
    public void testLocalClassWithCapturedParams() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/localClassWithCapturedParams.kt");
    }

    @Test
    @TestMetadata("noAdditionalAnnotationsInAccessors.kt")
    public void testNoAdditionalAnnotationsInAccessors() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/noAdditionalAnnotationsInAccessors.kt");
    }

    @Test
    @TestMetadata("noAnnotationsInSyntheticAccessors.kt")
    public void testNoAnnotationsInSyntheticAccessors() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/noAnnotationsInSyntheticAccessors.kt");
    }

    @Test
    @TestMetadata("onProperties.kt")
    public void testOnProperties() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/onProperties.kt");
    }

    @Test
    @TestMetadata("onReceiver.kt")
    public void testOnReceiver() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/onReceiver.kt");
    }

    @Test
    @TestMetadata("unsignedTypes.kt")
    public void testUnsignedTypes() {
      runTest("compiler/testData/codegen/bytecodeListing/annotations/unsignedTypes.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/annotations/repeatable")
    @TestDataPath("$PROJECT_ROOT")
    public class Repeatable {
      @Test
      public void testAllFilesPresentInRepeatable() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("javaAnnotation.kt")
      public void testJavaAnnotation() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/javaAnnotation.kt");
      }

      @Test
      @TestMetadata("kotlinAnnotation.kt")
      public void testKotlinAnnotation() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotation.kt");
      }

      @Test
      @TestMetadata("kotlinAnnotationWithBothRepeatables.kt")
      public void testKotlinAnnotationWithBothRepeatables() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotationWithBothRepeatables.kt");
      }

      @Test
      @TestMetadata("kotlinSpecificTargets.kt")
      public void testKotlinSpecificTargets() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinSpecificTargets.kt");
      }

      @Test
      @TestMetadata("multipleRepeatableOrder.kt")
      public void testMultipleRepeatableOrder() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/multipleRepeatableOrder.kt");
      }

      @Test
      @TestMetadata("nonRepeatedAnnotationWithItsContainer.kt")
      public void testNonRepeatedAnnotationWithItsContainer() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/nonRepeatedAnnotationWithItsContainer.kt");
      }

      @Test
      @TestMetadata("propertyGetterUseSiteTarget.kt")
      public void testPropertyGetterUseSiteTarget() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/propertyGetterUseSiteTarget.kt");
      }

      @Test
      @TestMetadata("retentionAndTarget.kt")
      public void testRetentionAndTarget() {
        runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/retentionAndTarget.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/callableReference")
  @TestDataPath("$PROJECT_ROOT")
  public class CallableReference {
    @Test
    @TestMetadata("adaptedReference.kt")
    public void testAdaptedReference() {
      runTest("compiler/testData/codegen/bytecodeListing/callableReference/adaptedReference.kt");
    }

    @Test
    public void testAllFilesPresentInCallableReference() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs")
  @TestDataPath("$PROJECT_ROOT")
  public class CollectionStubs {
    @Test
    @TestMetadata("abstractMapRedefiningGetAny.kt")
    public void testAbstractMapRedefiningGetAny() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractMapRedefiningGetAny.kt");
    }

    @Test
    public void testAllFilesPresentInCollectionStubs() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("collectionByDelegation.kt")
    public void testCollectionByDelegation() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation.kt");
    }

    @Test
    @TestMetadata("collectionByDelegation2.kt")
    public void testCollectionByDelegation2() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2.kt");
    }

    @Test
    @TestMetadata("collectionByDelegation2WithFullJdk.kt")
    public void testCollectionByDelegation2WithFullJdk() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2WithFullJdk.kt");
    }

    @Test
    @TestMetadata("collectionByDelegation3.kt")
    public void testCollectionByDelegation3() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3.kt");
    }

    @Test
    @TestMetadata("collectionByDelegation3WithFullJdk.kt")
    public void testCollectionByDelegation3WithFullJdk() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3WithFullJdk.kt");
    }

    @Test
    @TestMetadata("collectionByDelegationWithFullJdk.kt")
    public void testCollectionByDelegationWithFullJdk() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegationWithFullJdk.kt");
    }

    @Test
    @TestMetadata("collectionWithInternalRemove.kt")
    public void testCollectionWithInternalRemove() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionWithInternalRemove.kt");
    }

    @Test
    @TestMetadata("collectionsWithFullJdk.kt")
    public void testCollectionsWithFullJdk() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionsWithFullJdk.kt");
    }

    @Test
    @TestMetadata("customListIterator.kt")
    public void testCustomListIterator() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customListIterator.kt");
    }

    @Test
    @TestMetadata("customMutableListIterator.kt")
    public void testCustomMutableListIterator() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customMutableListIterator.kt");
    }

    @Test
    @TestMetadata("emptyList.kt")
    public void testEmptyList() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/emptyList.kt");
    }

    @Test
    @TestMetadata("extendingAbstractCollection.kt")
    public void testExtendingAbstractCollection() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/extendingAbstractCollection.kt");
    }

    @Test
    @TestMetadata("inheritingFromAbstractCollections.kt")
    public void testInheritingFromAbstractCollections() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractCollections.kt");
    }

    @Test
    @TestMetadata("inheritingFromAbstractMap.kt")
    public void testInheritingFromAbstractMap() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMap.kt");
    }

    @Test
    @TestMetadata("inheritingFromAbstractMutableList.kt")
    public void testInheritingFromAbstractMutableList() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMutableList.kt");
    }

    @Test
    @TestMetadata("intArrayList.kt")
    public void testIntArrayList() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/intArrayList.kt");
    }

    @Test
    @TestMetadata("kt44233.kt")
    public void testKt44233() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/kt44233.kt");
    }

    @Test
    @TestMetadata("ListAndSet.kt")
    public void testListAndSet() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/ListAndSet.kt");
    }

    @Test
    @TestMetadata("mapOfPrimitivesFullJdk.kt")
    public void testMapOfPrimitivesFullJdk() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/mapOfPrimitivesFullJdk.kt");
    }

    @Test
    @TestMetadata("noStubsForCollection.kt")
    public void testNoStubsForCollection() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForCollection.kt");
    }

    @Test
    @TestMetadata("noStubsForMapImplementations.kt")
    public void testNoStubsForMapImplementations() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMapImplementations.kt");
    }

    @Test
    @TestMetadata("noStubsForMutableSetIterators.kt")
    public void testNoStubsForMutableSetIterators() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMutableSetIterators.kt");
    }

    @Test
    @TestMetadata("noStubsForSetIterators.kt")
    public void testNoStubsForSetIterators() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForSetIterators.kt");
    }

    @Test
    @TestMetadata("noStubsInIterable.kt")
    public void testNoStubsInIterable() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInIterable.kt");
    }

    @Test
    @TestMetadata("noStubsInJavaSuperClass.kt")
    public void testNoStubsInJavaSuperClass() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInJavaSuperClass.kt");
    }

    @Test
    @TestMetadata("noStubsInMutableIterable.kt")
    public void testNoStubsInMutableIterable() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInMutableIterable.kt");
    }

    @Test
    @TestMetadata("observableMutableMap.kt")
    public void testObservableMutableMap() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/observableMutableMap.kt");
    }

    @Test
    @TestMetadata("stubForAbstractFun.kt")
    public void testStubForAbstractFun() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFun.kt");
    }

    @Test
    @TestMetadata("stubForAbstractFunInAbstractClass.kt")
    public void testStubForAbstractFunInAbstractClass() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClass.kt");
    }

    @Test
    @TestMetadata("stubForAbstractFunInAbstractClassWithCovariantOverride.kt")
    public void testStubForAbstractFunInAbstractClassWithCovariantOverride() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClassWithCovariantOverride.kt");
    }

    @Test
    @TestMetadata("stubForAbstractFunWithCovariantOverride.kt")
    public void testStubForAbstractFunWithCovariantOverride() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunWithCovariantOverride.kt");
    }

    @Test
    @TestMetadata("stubLikeMethodSignatures.kt")
    public void testStubLikeMethodSignatures() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubLikeMethodSignatures.kt");
    }

    @Test
    @TestMetadata("stubsFromSuperclass.kt")
    public void testStubsFromSuperclass() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclass.kt");
    }

    @Test
    @TestMetadata("stubsFromSuperclassNoBridges.kt")
    public void testStubsFromSuperclassNoBridges() {
      runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclassNoBridges.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures")
    @TestDataPath("$PROJECT_ROOT")
    public class AbstractStubSignatures {
      @Test
      public void testAllFilesPresentInAbstractStubSignatures() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("byteShortMap.kt")
      public void testByteShortMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMap.kt");
      }

      @Test
      @TestMetadata("byteShortMutableMap.kt")
      public void testByteShortMutableMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMutableMap.kt");
      }

      @Test
      @TestMetadata("collection.kt")
      public void testCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/collection.kt");
      }

      @Test
      @TestMetadata("genericCollection.kt")
      public void testGenericCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericCollection.kt");
      }

      @Test
      @TestMetadata("genericMap.kt")
      public void testGenericMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMap.kt");
      }

      @Test
      @TestMetadata("genericMutableCollection.kt")
      public void testGenericMutableCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableCollection.kt");
      }

      @Test
      @TestMetadata("genericMutableList.kt")
      public void testGenericMutableList() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableList.kt");
      }

      @Test
      @TestMetadata("genericMutableMap.kt")
      public void testGenericMutableMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableMap.kt");
      }

      @Test
      @TestMetadata("genericStringMap.kt")
      public void testGenericStringMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMap.kt");
      }

      @Test
      @TestMetadata("genericStringMutableMap.kt")
      public void testGenericStringMutableMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMutableMap.kt");
      }

      @Test
      @TestMetadata("iterable.kt")
      public void testIterable() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterable.kt");
      }

      @Test
      @TestMetadata("iterator.kt")
      public void testIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterator.kt");
      }

      @Test
      @TestMetadata("list.kt")
      public void testList() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/list.kt");
      }

      @Test
      @TestMetadata("listIterator.kt")
      public void testListIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/listIterator.kt");
      }

      @Test
      @TestMetadata("mapEntry.kt")
      public void testMapEntry() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mapEntry.kt");
      }

      @Test
      @TestMetadata("mutableCollection.kt")
      public void testMutableCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableCollection.kt");
      }

      @Test
      @TestMetadata("mutableIterable.kt")
      public void testMutableIterable() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterable.kt");
      }

      @Test
      @TestMetadata("mutableIterator.kt")
      public void testMutableIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterator.kt");
      }

      @Test
      @TestMetadata("mutableList.kt")
      public void testMutableList() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableList.kt");
      }

      @Test
      @TestMetadata("mutableListIterator.kt")
      public void testMutableListIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableListIterator.kt");
      }

      @Test
      @TestMetadata("mutableMapEntry.kt")
      public void testMutableMapEntry() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableMapEntry.kt");
      }

      @Test
      @TestMetadata("numberStringMap.kt")
      public void testNumberStringMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMap.kt");
      }

      @Test
      @TestMetadata("numberStringMutableMap.kt")
      public void testNumberStringMutableMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMutableMap.kt");
      }

      @Test
      @TestMetadata("set.kt")
      public void testSet() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/set.kt");
      }

      @Test
      @TestMetadata("specializedGenericMap.kt")
      public void testSpecializedGenericMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/specializedGenericMap.kt");
      }

      @Test
      @TestMetadata("stringGenericMap.kt")
      public void testStringGenericMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMap.kt");
      }

      @Test
      @TestMetadata("stringGenericMutableMap.kt")
      public void testStringGenericMutableMap() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMutableMap.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray")
    @TestDataPath("$PROJECT_ROOT")
    public class ToArray {
      @Test
      public void testAllFilesPresentInToArray() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("customNonGenericToArray.kt")
      public void testCustomNonGenericToArray() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/customNonGenericToArray.kt");
      }

      @Test
      @TestMetadata("internalGenericToArray.kt")
      public void testInternalGenericToArray() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/internalGenericToArray.kt");
      }

      @Test
      @TestMetadata("noToArrayInJava.kt")
      public void testNoToArrayInJava() {
        runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/noToArrayInJava.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/contextReceivers")
  @TestDataPath("$PROJECT_ROOT")
  public class ContextReceivers {
    @Test
    public void testAllFilesPresentInContextReceivers() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("class.kt")
    public void testClass() {
      runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/class.kt");
    }

    @Test
    @TestMetadata("function.kt")
    public void testFunction() {
      runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/function.kt");
    }

    @Test
    @TestMetadata("property.kt")
    public void testProperty() {
      runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/property.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP")
    @TestDataPath("$PROJECT_ROOT")
    public class FromKEEP {
      @Test
      public void testAllFilesPresentInFromKEEP() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("canvas.kt")
      public void testCanvas() {
        runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/canvas.kt");
      }

      @Test
      @TestMetadata("compareTo.kt")
      public void testCompareTo() {
        runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/compareTo.kt");
      }

      @Test
      @TestMetadata("dp.kt")
      public void testDp() {
        runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/dp.kt");
      }

      @Test
      @TestMetadata("functionalType.kt")
      public void testFunctionalType() {
        runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/functionalType.kt");
      }

      @Test
      @TestMetadata("monoidSum.kt")
      public void testMonoidSum() {
        runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/monoidSum.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/coroutines")
  @TestDataPath("$PROJECT_ROOT")
  public class Coroutines {
    @Test
    public void testAllFilesPresentInCoroutines() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("coroutineContextIntrinsic.kt")
    public void testCoroutineContextIntrinsic() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineContextIntrinsic.kt");
    }

    @Test
    @TestMetadata("coroutineFields.kt")
    public void testCoroutineFields() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineFields.kt");
    }

    @Test
    @TestMetadata("oomInReturnUnit.kt")
    public void testOomInReturnUnit() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/oomInReturnUnit.kt");
    }

    @Test
    @TestMetadata("privateAccessor.kt")
    public void testPrivateAccessor() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateAccessor.kt");
    }

    @Test
    @TestMetadata("privateSuspendFun.kt")
    public void testPrivateSuspendFun() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateSuspendFun.kt");
    }

    @Test
    @TestMetadata("suspendConversion.kt")
    public void testSuspendConversion() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendConversion.kt");
    }

    @Test
    @TestMetadata("suspendImpl.kt")
    public void testSuspendImpl() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendImpl.kt");
    }

    @Test
    @TestMetadata("suspendReifiedFun.kt")
    public void testSuspendReifiedFun() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendReifiedFun.kt");
    }

    @Test
    @TestMetadata("tcoContinuation.kt")
    public void testTcoContinuation() {
      runTest("compiler/testData/codegen/bytecodeListing/coroutines/tcoContinuation.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/coroutines/spilling")
    @TestDataPath("$PROJECT_ROOT")
    public class Spilling {
      @Test
      public void testAllFilesPresentInSpilling() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines/spilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("booleanParameter.kt")
      public void testBooleanParameter() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/booleanParameter.kt");
      }

      @Test
      @TestMetadata("component1.kt")
      public void testComponent1() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/component1.kt");
      }

      @Test
      @TestMetadata("destructured.kt")
      public void testDestructured() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/destructured.kt");
      }

      @Test
      @TestMetadata("field.kt")
      public void testField() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/field.kt");
      }

      @Test
      @TestMetadata("lambda.kt")
      public void testLambda() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/lambda.kt");
      }

      @Test
      @TestMetadata("select.kt")
      public void testSelect() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/select.kt");
      }

      @Test
      @TestMetadata("unreachable.kt")
      public void testUnreachable() {
        runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/unreachable.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/defaultArguments")
  @TestDataPath("$PROJECT_ROOT")
  public class DefaultArguments {
    @Test
    public void testAllFilesPresentInDefaultArguments() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("functionInMultifileClass.kt")
    public void testFunctionInMultifileClass() {
      runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClass.kt");
    }

    @Test
    @TestMetadata("functionInMultifileClassWithInheritedParts.kt")
    public void testFunctionInMultifileClassWithInheritedParts() {
      runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClassWithInheritedParts.kt");
    }

    @Test
    @TestMetadata("internalNameMangling.kt")
    public void testInternalNameMangling() {
      runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/internalNameMangling.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/delegatedProperty")
  @TestDataPath("$PROJECT_ROOT")
  public class DelegatedProperty {
    @Test
    public void testAllFilesPresentInDelegatedProperty() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("delegateMethodIsNonOverridable.kt")
    public void testDelegateMethodIsNonOverridable() {
      runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegateMethodIsNonOverridable.kt");
    }

    @Test
    @TestMetadata("delegatedPropertiesInCompanionObject.kt")
    public void testDelegatedPropertiesInCompanionObject() {
      runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegatedPropertiesInCompanionObject.kt");
    }

    @Test
    @TestMetadata("localDelegatedProperty.kt")
    public void testLocalDelegatedProperty() {
      runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/localDelegatedProperty.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/deprecated")
  @TestDataPath("$PROJECT_ROOT")
  public class Deprecated {
    @Test
    public void testAllFilesPresentInDeprecated() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("deprecatedClass.kt")
    public void testDeprecatedClass() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedClass.kt");
    }

    @Test
    @TestMetadata("deprecatedEnumEntryFields.kt")
    public void testDeprecatedEnumEntryFields() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedEnumEntryFields.kt");
    }

    @Test
    @TestMetadata("deprecatedInMultifileClass.kt")
    public void testDeprecatedInMultifileClass() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedInMultifileClass.kt");
    }

    @Test
    @TestMetadata("deprecatedLateinitVar.kt")
    public void testDeprecatedLateinitVar() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedLateinitVar.kt");
    }

    @Test
    @TestMetadata("deprecatedProperty.kt")
    public void testDeprecatedProperty() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedProperty.kt");
    }

    @Test
    @TestMetadata("hidden.kt")
    public void testHidden() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/hidden.kt");
    }

    @Test
    @TestMetadata("inheritingDeprecation.kt")
    public void testInheritingDeprecation() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/inheritingDeprecation.kt");
    }

    @Test
    @TestMetadata("inlineClassTypesInSignature.kt")
    public void testInlineClassTypesInSignature() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/inlineClassTypesInSignature.kt");
    }

    @Test
    @TestMetadata("jvmStaticDeprecatedProperty.kt")
    public void testJvmStaticDeprecatedProperty() {
      runTest("compiler/testData/codegen/bytecodeListing/deprecated/jvmStaticDeprecatedProperty.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/inline")
  @TestDataPath("$PROJECT_ROOT")
  public class Inline {
    @Test
    public void testAllFilesPresentInInline() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("genericReified.kt")
    public void testGenericReified() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/genericReified.kt");
    }

    @Test
    @TestMetadata("inlineOnly.kt")
    public void testInlineOnly() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnly.kt");
    }

    @Test
    @TestMetadata("InlineOnlyMultifile.kt")
    public void testInlineOnlyMultifile() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyMultifile.kt");
    }

    @Test
    @TestMetadata("inlineOnlyProperty.kt")
    public void testInlineOnlyProperty() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnlyProperty.kt");
    }

    @Test
    @TestMetadata("InlineOnlyPropertyMultifile.kt")
    public void testInlineOnlyPropertyMultifile() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyPropertyMultifile.kt");
    }

    @Test
    @TestMetadata("inlineReified.kt")
    public void testInlineReified() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReified.kt");
    }

    @Test
    @TestMetadata("InlineReifiedMultifile.kt")
    public void testInlineReifiedMultifile() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedMultifile.kt");
    }

    @Test
    @TestMetadata("inlineReifiedProperty.kt")
    public void testInlineReifiedProperty() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedProperty.kt");
    }

    @Test
    @TestMetadata("InlineReifiedPropertyMultifile.kt")
    public void testInlineReifiedPropertyMultifile() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedPropertyMultifile.kt");
    }

    @Test
    @TestMetadata("inlineReifiedPropertyVisibility.kt")
    public void testInlineReifiedPropertyVisibility() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedPropertyVisibility.kt");
    }

    @Test
    @TestMetadata("inlineReifiedVisibility.kt")
    public void testInlineReifiedVisibility() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedVisibility.kt");
    }

    @Test
    @TestMetadata("simpleNamed.kt")
    public void testSimpleNamed() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/simpleNamed.kt");
    }

    @Test
    @TestMetadata("suspendInlineReified.kt")
    public void testSuspendInlineReified() {
      runTest("compiler/testData/codegen/bytecodeListing/inline/suspendInlineReified.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo")
    @TestDataPath("$PROJECT_ROOT")
    public class EnclosingInfo {
      @Test
      public void testAllFilesPresentInEnclosingInfo() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("crossinlineLambdaChain.kt")
      public void testCrossinlineLambdaChain() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/crossinlineLambdaChain.kt");
      }

      @Test
      @TestMetadata("kt10259.kt")
      public void testKt10259() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/kt10259.kt");
      }

      @Test
      @TestMetadata("lambdaInInitBlockNoPrimaryConstructor.kt")
      public void testLambdaInInitBlockNoPrimaryConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInitBlockNoPrimaryConstructor.kt");
      }

      @Test
      @TestMetadata("lambdaInInnerClassConstructor.kt")
      public void testLambdaInInnerClassConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInnerClassConstructor.kt");
      }

      @Test
      @TestMetadata("transformedConstructor.kt")
      public void testTransformedConstructor() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructor.kt");
      }

      @Test
      @TestMetadata("transformedConstructorWithNestedInline.kt")
      public void testTransformedConstructorWithNestedInline() {
        runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructorWithNestedInline.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class InlineClasses {
    @Test
    public void testAllFilesPresentInInlineClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotatedPropertyWithInlineClassTypeInSignature.kt")
    public void testAnnotatedPropertyWithInlineClassTypeInSignature() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotatedPropertyWithInlineClassTypeInSignature.kt");
    }

    @Test
    @TestMetadata("annotationGetters.kt")
    public void testAnnotationGetters() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationGetters.kt");
    }

    @Test
    @TestMetadata("annotationsOnHiddenConstructor.kt")
    public void testAnnotationsOnHiddenConstructor() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationsOnHiddenConstructor.kt");
    }

    @Test
    @TestMetadata("companionObjectInsideInlineClass.kt")
    public void testCompanionObjectInsideInlineClass() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/companionObjectInsideInlineClass.kt");
    }

    @Test
    @TestMetadata("computablePropertiesInsideInlineClass.kt")
    public void testComputablePropertiesInsideInlineClass() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/computablePropertiesInsideInlineClass.kt");
    }

    @Test
    @TestMetadata("constructor.kt")
    public void testConstructor() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructor.kt");
    }

    @Test
    @TestMetadata("constructorsWithDefaultParameterValues.kt")
    public void testConstructorsWithDefaultParameterValues() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructorsWithDefaultParameterValues.kt");
    }

    @Test
    @TestMetadata("defaultInterfaceMethodsInInlineClass.kt")
    public void testDefaultInterfaceMethodsInInlineClass() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMethodsInInlineClass.kt");
    }

    @Test
    @TestMetadata("genericChild.kt")
    public void testGenericChild() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/genericChild.kt");
    }

    @Test
    @TestMetadata("hiddenConstructor.kt")
    public void testHiddenConstructor() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/hiddenConstructor.kt");
    }

    @Test
    @TestMetadata("inlineCharSequence.kt")
    public void testInlineCharSequence() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCharSequence.kt");
    }

    @Test
    @TestMetadata("inlineClassMembersVisibility.kt")
    public void testInlineClassMembersVisibility() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassMembersVisibility.kt");
    }

    @Test
    @TestMetadata("inlineClassTypeParametersInConstructor.kt")
    public void testInlineClassTypeParametersInConstructor() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassTypeParametersInConstructor.kt");
    }

    @Test
    @TestMetadata("inlineClassWithInlineClassUnderlyingType.kt")
    public void testInlineClassWithInlineClassUnderlyingType() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithInlineClassUnderlyingType.kt");
    }

    @Test
    @TestMetadata("inlineClassWithManyKindsOfMembers.kt")
    public void testInlineClassWithManyKindsOfMembers() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithManyKindsOfMembers.kt");
    }

    @Test
    @TestMetadata("jvmName.kt")
    public void testJvmName() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmName.kt");
    }

    @Test
    @TestMetadata("jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
    public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValue() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt");
    }

    @Test
    @TestMetadata("memberExtensionProperty.kt")
    public void testMemberExtensionProperty() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/memberExtensionProperty.kt");
    }

    @Test
    @TestMetadata("noArgConstructorForInlineClassParameter.kt")
    public void testNoArgConstructorForInlineClassParameter() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noArgConstructorForInlineClassParameter.kt");
    }

    @Test
    @TestMetadata("noBridgesForErasedInlineClass.kt")
    public void testNoBridgesForErasedInlineClass() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noBridgesForErasedInlineClass.kt");
    }

    @Test
    @TestMetadata("nullabilityAnnotationsOnInlineClassMembers.kt")
    public void testNullabilityAnnotationsOnInlineClassMembers() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
    }

    @Test
    @TestMetadata("nullabilityInExpansion.kt")
    public void testNullabilityInExpansion() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityInExpansion.kt");
    }

    @Test
    @TestMetadata("nullableAndNotNullPrimitive.kt")
    public void testNullableAndNotNullPrimitive() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullableAndNotNullPrimitive.kt");
    }

    @Test
    @TestMetadata("overridingGenericMethodWithInlineClassParameterType.kt")
    public void testOverridingGenericMethodWithInlineClassParameterType() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassParameterType.kt");
    }

    @Test
    @TestMetadata("overridingGenericMethodWithInlineClassReturnType.kt")
    public void testOverridingGenericMethodWithInlineClassReturnType() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassReturnType.kt");
    }

    @Test
    @TestMetadata("primaryValsWithDifferentVisibilities.kt")
    public void testPrimaryValsWithDifferentVisibilities() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/primaryValsWithDifferentVisibilities.kt");
    }

    @Test
    @TestMetadata("publishedApiAnnotationOnInlineClassConstructor.kt")
    public void testPublishedApiAnnotationOnInlineClassConstructor() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/publishedApiAnnotationOnInlineClassConstructor.kt");
    }

    @Test
    @TestMetadata("shapeOfInlineClassWithPrimitive.kt")
    public void testShapeOfInlineClassWithPrimitive() {
      runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/shapeOfInlineClassWithPrimitive.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultInterfaceMembers {
      @Test
      public void testAllFilesPresentInDefaultInterfaceMembers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("javaDefaultInterfaceMember.kt")
      public void testJavaDefaultInterfaceMember() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/javaDefaultInterfaceMember.kt");
      }

      @Test
      @TestMetadata("jvmDefaultAll.kt")
      public void testJvmDefaultAll() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/jvmDefaultAll.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineCollection {
      @Test
      public void testAllFilesPresentInInlineCollection() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("collection.kt")
      public void testCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/collection.kt");
      }

      @Test
      @TestMetadata("iterable.kt")
      public void testIterable() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterable.kt");
      }

      @Test
      @TestMetadata("iterator.kt")
      public void testIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterator.kt");
      }

      @Test
      @TestMetadata("list.kt")
      public void testList() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/list.kt");
      }

      @Test
      @TestMetadata("map.kt")
      public void testMap() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/map.kt");
      }

      @Test
      @TestMetadata("mapEntry.kt")
      public void testMapEntry() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mapEntry.kt");
      }

      @Test
      @TestMetadata("mutableCollection.kt")
      public void testMutableCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableCollection.kt");
      }

      @Test
      @TestMetadata("mutableIterable.kt")
      public void testMutableIterable() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterable.kt");
      }

      @Test
      @TestMetadata("mutableIterator.kt")
      public void testMutableIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterator.kt");
      }

      @Test
      @TestMetadata("mutableList.kt")
      public void testMutableList() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableList.kt");
      }

      @Test
      @TestMetadata("mutableMap.kt")
      public void testMutableMap() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMap.kt");
      }

      @Test
      @TestMetadata("mutableMapEntry.kt")
      public void testMutableMapEntry() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMapEntry.kt");
      }

      @Test
      @TestMetadata("mutableSet.kt")
      public void testMutableSet() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableSet.kt");
      }

      @Test
      @TestMetadata("set.kt")
      public void testSet() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/set.kt");
      }

      @Test
      @TestMetadata("UIntArrayWithFullJdk.kt")
      public void testUIntArrayWithFullJdk() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/UIntArrayWithFullJdk.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineCollectionOfInlineClass {
      @Test
      public void testAllFilesPresentInInlineCollectionOfInlineClass() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("collection.kt")
      public void testCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/collection.kt");
      }

      @Test
      @TestMetadata("iterable.kt")
      public void testIterable() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterable.kt");
      }

      @Test
      @TestMetadata("iterator.kt")
      public void testIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterator.kt");
      }

      @Test
      @TestMetadata("list.kt")
      public void testList() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/list.kt");
      }

      @Test
      @TestMetadata("map.kt")
      public void testMap() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/map.kt");
      }

      @Test
      @TestMetadata("mapEntry.kt")
      public void testMapEntry() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mapEntry.kt");
      }

      @Test
      @TestMetadata("mutableCollection.kt")
      public void testMutableCollection() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableCollection.kt");
      }

      @Test
      @TestMetadata("mutableIterable.kt")
      public void testMutableIterable() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterable.kt");
      }

      @Test
      @TestMetadata("mutableIterator.kt")
      public void testMutableIterator() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterator.kt");
      }

      @Test
      @TestMetadata("mutableList.kt")
      public void testMutableList() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableList.kt");
      }

      @Test
      @TestMetadata("mutableMap.kt")
      public void testMutableMap() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMap.kt");
      }

      @Test
      @TestMetadata("mutableMapEntry.kt")
      public void testMutableMapEntry() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMapEntry.kt");
      }

      @Test
      @TestMetadata("mutableSet.kt")
      public void testMutableSet() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet.kt");
      }

      @Test
      @TestMetadata("mutableSet2.kt")
      public void testMutableSet2() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet2.kt");
      }

      @Test
      @TestMetadata("set.kt")
      public void testSet() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/set.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult")
    @TestDataPath("$PROJECT_ROOT")
    public class ReturnResult {
      @Test
      public void testAllFilesPresentInReturnResult() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("class.kt")
      public void testClass() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/class.kt");
      }

      @Test
      @TestMetadata("classAnyOverride.kt")
      public void testClassAnyOverride() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classAnyOverride.kt");
      }

      @Test
      @TestMetadata("classGenericOverride.kt")
      public void testClassGenericOverride() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classGenericOverride.kt");
      }

      @Test
      @TestMetadata("classResultOverride.kt")
      public void testClassResultOverride() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classResultOverride.kt");
      }

      @Test
      @TestMetadata("interface.kt")
      public void testInterface() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/interface.kt");
      }

      @Test
      @TestMetadata("topLevel.kt")
      public void testTopLevel() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/topLevel.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430")
    @TestDataPath("$PROJECT_ROOT")
    public class StdlibManglingIn1430 {
      @Test
      public void testAllFilesPresentInStdlibManglingIn1430() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("new.kt")
      public void testNew() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/new.kt");
      }

      @Test
      @TestMetadata("old.kt")
      public void testOld() {
        runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/old.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8")
  @TestDataPath("$PROJECT_ROOT")
  public class Jvm8 {
    @Test
    public void testAllFilesPresentInJvm8() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults")
    @TestDataPath("$PROJECT_ROOT")
    public class Defaults {
      @Test
      public void testAllFilesPresentInDefaults() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility")
      @TestDataPath("$PROJECT_ROOT")
      public class AllCompatibility {
        @Test
        public void testAllFilesPresentInAllCompatibility() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("deprecation.kt")
        public void testDeprecation() {
          runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecation.kt");
        }

        @Test
        @TestMetadata("deprecationWithDefault.kt")
        public void testDeprecationWithDefault() {
          runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecationWithDefault.kt");
        }

        @Test
        @TestMetadata("interfaceProperty.kt")
        public void testInterfaceProperty() {
          runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/interfaceProperty.kt");
        }

        @Test
        @TestMetadata("jvmDefaultWithoutCompatibility.kt")
        public void testJvmDefaultWithoutCompatibility() {
          runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/jvmDefaultWithoutCompatibility.kt");
        }

        @Test
        @TestMetadata("noDefaultImplsOnEmptySubInterface.kt")
        public void testNoDefaultImplsOnEmptySubInterface() {
          runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/noDefaultImplsOnEmptySubInterface.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization")
        @TestDataPath("$PROJECT_ROOT")
        public class Specialization {
          @Test
          public void testAllFilesPresentInSpecialization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("primitiveAndAny.kt")
          public void testPrimitiveAndAny() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndAny.kt");
          }

          @Test
          @TestMetadata("primitiveAndNullable.kt")
          public void testPrimitiveAndNullable() {
            runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndNullable.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl")
      @TestDataPath("$PROJECT_ROOT")
      public class NoDefaultImpl {
        @Test
        public void testAllFilesPresentInNoDefaultImpl() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("interfaceProperty.kt")
        public void testInterfaceProperty() {
          runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/interfaceProperty.kt");
        }

        @Test
        @TestMetadata("privateAccessorNaming.kt")
        public void testPrivateAccessorNaming() {
          runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/privateAccessorNaming.kt");
        }
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/jvmStatic")
  @TestDataPath("$PROJECT_ROOT")
  public class JvmStatic {
    @Test
    public void testAllFilesPresentInJvmStatic() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("jvmStaticExternal.kt")
    public void testJvmStaticExternal() {
      runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticExternal.kt");
    }

    @Test
    @TestMetadata("jvmStaticPrivate.kt")
    public void testJvmStaticPrivate() {
      runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticPrivate.kt");
    }

    @Test
    @TestMetadata("jvmStaticWithDefaultParameters.kt")
    public void testJvmStaticWithDefaultParameters() {
      runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticWithDefaultParameters.kt");
    }

    @Test
    @TestMetadata("kt31389.kt")
    public void testKt31389() {
      runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/kt31389.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/localFunctions")
  @TestDataPath("$PROJECT_ROOT")
  public class LocalFunctions {
    @Test
    public void testAllFilesPresentInLocalFunctions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("genericClass.kt")
    public void testGenericClass() {
      runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericClass.kt");
    }

    @Test
    @TestMetadata("genericInnerClass.kt")
    public void testGenericInnerClass() {
      runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericInnerClass.kt");
    }

    @Test
    @TestMetadata("genericLocalClass.kt")
    public void testGenericLocalClass() {
      runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericLocalClass.kt");
    }

    @Test
    @TestMetadata("inInitBlock.kt")
    public void testInInitBlock() {
      runTest("compiler/testData/codegen/bytecodeListing/localFunctions/inInitBlock.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/bytecodeListing/localFunctions/simple.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/main")
  @TestDataPath("$PROJECT_ROOT")
  public class Main {
    @Test
    public void testAllFilesPresentInMain() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/main"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("multifileSuspend.kt")
    public void testMultifileSuspend() {
      runTest("compiler/testData/codegen/bytecodeListing/main/multifileSuspend.kt");
    }

    @Test
    @TestMetadata("parameterlessMain.kt")
    public void testParameterlessMain() {
      runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain.kt");
    }

    @Test
    @TestMetadata("parameterlessMain_before.kt")
    public void testParameterlessMain_before() {
      runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain_before.kt");
    }

    @Test
    @TestMetadata("suspendMain.kt")
    public void testSuspendMain() {
      runTest("compiler/testData/codegen/bytecodeListing/main/suspendMain.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/multifileClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class MultifileClasses {
    @Test
    public void testAllFilesPresentInMultifileClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("emptyMultifileFacade.kt")
    public void testEmptyMultifileFacade() {
      runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/emptyMultifileFacade.kt");
    }

    @Test
    @TestMetadata("jvmSynthetic.kt")
    public void testJvmSynthetic() {
      runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/jvmSynthetic.kt");
    }

    @Test
    @TestMetadata("kt43519.kt")
    public void testKt43519() {
      runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/kt43519.kt");
    }

    @Test
    @TestMetadata("multiClassPartSourceMultipleParts.kt")
    public void testMultiClassPartSourceMultipleParts() {
      runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceMultipleParts.kt");
    }

    @Test
    @TestMetadata("multiClassPartSourceSinglePart.kt")
    public void testMultiClassPartSourceSinglePart() {
      runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceSinglePart.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/multiplatform")
  @TestDataPath("$PROJECT_ROOT")
  public class Multiplatform {
    @Test
    public void testAllFilesPresentInMultiplatform() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("optionalExpectation.kt")
    public void testOptionalExpectation() {
      runTest("compiler/testData/codegen/bytecodeListing/multiplatform/optionalExpectation.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations")
  @TestDataPath("$PROJECT_ROOT")
  public class NullabilityAnnotations {
    @Test
    public void testAllFilesPresentInNullabilityAnnotations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("lateInitNotNull.kt")
    public void testLateInitNotNull() {
      runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/lateInitNotNull.kt");
    }

    @Test
    @TestMetadata("nullabilityAnnotationsForReturnType.kt")
    public void testNullabilityAnnotationsForReturnType() {
      runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsForReturnType.kt");
    }

    @Test
    @TestMetadata("nullabilityAnnotationsOnDelegatedMembers.kt")
    public void testNullabilityAnnotationsOnDelegatedMembers() {
      runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsOnDelegatedMembers.kt");
    }

    @Test
    @TestMetadata("platformTypes.kt")
    public void testPlatformTypes() {
      runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/platformTypes.kt");
    }

    @Test
    @TestMetadata("samAdapterForJavaInterfaceWithNullability.kt")
    public void testSamAdapterForJavaInterfaceWithNullability() {
      runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/samAdapterForJavaInterfaceWithNullability.kt");
    }

    @Test
    @TestMetadata("suspendFunction.kt")
    public void testSuspendFunction() {
      runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/suspendFunction.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/properties")
  @TestDataPath("$PROJECT_ROOT")
  public class Properties {
    @Test
    public void testAllFilesPresentInProperties() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/properties/backingField")
    @TestDataPath("$PROJECT_ROOT")
    public class BackingField {
      @Test
      public void testAllFilesPresentInBackingField() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/properties/backingField"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("explicitBackingFieldsInJava.kt")
      public void testExplicitBackingFieldsInJava() {
        runTest("compiler/testData/codegen/bytecodeListing/properties/backingField/explicitBackingFieldsInJava.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/sam")
  @TestDataPath("$PROJECT_ROOT")
  public class Sam {
    @Test
    public void testAllFilesPresentInSam() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("callableRefGenericFunInterface.kt")
    public void testCallableRefGenericFunInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericFunInterface.kt");
    }

    @Test
    @TestMetadata("callableRefGenericSamInterface.kt")
    public void testCallableRefGenericSamInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericSamInterface.kt");
    }

    @Test
    @TestMetadata("callableRefSpecializedFunInterface.kt")
    public void testCallableRefSpecializedFunInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedFunInterface.kt");
    }

    @Test
    @TestMetadata("callableRefSpecializedSamInterface.kt")
    public void testCallableRefSpecializedSamInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedSamInterface.kt");
    }

    @Test
    @TestMetadata("genericFunInterface.kt")
    public void testGenericFunInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/genericFunInterface.kt");
    }

    @Test
    @TestMetadata("genericSamInterface.kt")
    public void testGenericSamInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/genericSamInterface.kt");
    }

    @Test
    @TestMetadata("indySamConversionViaProxyFun.kt")
    public void testIndySamConversionViaProxyFun() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/indySamConversionViaProxyFun.kt");
    }

    @Test
    @TestMetadata("kt16650.kt")
    public void testKt16650() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/kt16650.kt");
    }

    @Test
    @TestMetadata("lambdaGenericFunInterface.kt")
    public void testLambdaGenericFunInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericFunInterface.kt");
    }

    @Test
    @TestMetadata("lambdaGenericSamInterface.kt")
    public void testLambdaGenericSamInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericSamInterface.kt");
    }

    @Test
    @TestMetadata("lambdaSpecializedFunInterface.kt")
    public void testLambdaSpecializedFunInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedFunInterface.kt");
    }

    @Test
    @TestMetadata("lambdaSpecializedSamInterface.kt")
    public void testLambdaSpecializedSamInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedSamInterface.kt");
    }

    @Test
    @TestMetadata("nonApproxToValidSupertype.kt")
    public void testNonApproxToValidSupertype() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype.kt");
    }

    @Test
    @TestMetadata("nonApproxToValidSupertype2.kt")
    public void testNonApproxToValidSupertype2() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype2.kt");
    }

    @Test
    @TestMetadata("privateInlineSamAdapter.kt")
    public void testPrivateInlineSamAdapter() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/privateInlineSamAdapter.kt");
    }

    @Test
    @TestMetadata("reusedSamWrapperClasses.kt")
    public void testReusedSamWrapperClasses() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/reusedSamWrapperClasses.kt");
    }

    @Test
    @TestMetadata("samAdapterAndInlinedOne.kt")
    public void testSamAdapterAndInlinedOne() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterAndInlinedOne.kt");
    }

    @Test
    @TestMetadata("samAdapterInInlineLambda.kt")
    public void testSamAdapterInInlineLambda() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterInInlineLambda.kt");
    }

    @Test
    @TestMetadata("samWithContravariantProjection.kt")
    public void testSamWithContravariantProjection() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/samWithContravariantProjection.kt");
    }

    @Test
    @TestMetadata("severalProxyFunsInInit.kt")
    public void testSeveralProxyFunsInInit() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/severalProxyFunsInInit.kt");
    }

    @Test
    @TestMetadata("specializedFunInterface.kt")
    public void testSpecializedFunInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/specializedFunInterface.kt");
    }

    @Test
    @TestMetadata("specializedSamInterface.kt")
    public void testSpecializedSamInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/specializedSamInterface.kt");
    }

    @Test
    @TestMetadata("wrapperInlinedFromAnotherClass.kt")
    public void testWrapperInlinedFromAnotherClass() {
      runTest("compiler/testData/codegen/bytecodeListing/sam/wrapperInlinedFromAnotherClass.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/sealed")
  @TestDataPath("$PROJECT_ROOT")
  public class Sealed {
    @Test
    public void testAllFilesPresentInSealed() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotationsOnSealedConstructor.kt")
    public void testAnnotationsOnSealedConstructor() {
      runTest("compiler/testData/codegen/bytecodeListing/sealed/annotationsOnSealedConstructor.kt");
    }

    @Test
    @TestMetadata("permittedSubclasses_1_7.kt")
    public void testPermittedSubclasses_1_7() {
      runTest("compiler/testData/codegen/bytecodeListing/sealed/permittedSubclasses_1_7.kt");
    }

    @Test
    @TestMetadata("sealedClassConstructor_1_4.kt")
    public void testSealedClassConstructor_1_4() {
      runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_4.kt");
    }

    @Test
    @TestMetadata("sealedClassConstructor_1_5.kt")
    public void testSealedClassConstructor_1_5() {
      runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_5.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/specialBridges")
  @TestDataPath("$PROJECT_ROOT")
  public class SpecialBridges {
    @Test
    @TestMetadata("abstractCollections.kt")
    public void testAbstractCollections() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractCollections.kt");
    }

    @Test
    @TestMetadata("abstractIterables.kt")
    public void testAbstractIterables() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractIterables.kt");
    }

    @Test
    @TestMetadata("abstractLists.kt")
    public void testAbstractLists() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractLists.kt");
    }

    @Test
    @TestMetadata("abstractListsWithJavaBase.kt")
    public void testAbstractListsWithJavaBase() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractListsWithJavaBase.kt");
    }

    @Test
    @TestMetadata("abstractMutableCollectionOfPrimitive.kt")
    public void testAbstractMutableCollectionOfPrimitive() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableCollectionOfPrimitive.kt");
    }

    @Test
    @TestMetadata("abstractMutableListOfPrimitive.kt")
    public void testAbstractMutableListOfPrimitive() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableListOfPrimitive.kt");
    }

    @Test
    @TestMetadata("abstractMutableLists.kt")
    public void testAbstractMutableLists() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableLists.kt");
    }

    @Test
    @TestMetadata("abstractSets.kt")
    public void testAbstractSets() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractSets.kt");
    }

    @Test
    public void testAllFilesPresentInSpecialBridges() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("bridgeForIntersectionBetweenRenamedMethodAndProperty.kt")
    public void testBridgeForIntersectionBetweenRenamedMethodAndProperty() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/bridgeForIntersectionBetweenRenamedMethodAndProperty.kt");
    }

    @Test
    @TestMetadata("charSequence.kt")
    public void testCharSequence() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/charSequence.kt");
    }

    @Test
    @TestMetadata("contains.kt")
    public void testContains() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/contains.kt");
    }

    @Test
    @TestMetadata("kt41123.kt")
    public void testKt41123() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt41123.kt");
    }

    @Test
    @TestMetadata("kt48945.kt")
    public void testKt48945() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt48945.kt");
    }

    @Test
    @TestMetadata("mutableCollectionOfPrimitive.kt")
    public void testMutableCollectionOfPrimitive() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableCollectionOfPrimitive.kt");
    }

    @Test
    @TestMetadata("mutableListOfPrimitive.kt")
    public void testMutableListOfPrimitive() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableListOfPrimitive.kt");
    }

    @Test
    @TestMetadata("noDefaultImplsOnEmptySubInterface.kt")
    public void testNoDefaultImplsOnEmptySubInterface() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noDefaultImplsOnEmptySubInterface.kt");
    }

    @Test
    @TestMetadata("noSpecialBridgeIfPresentInSuperClass.kt")
    public void testNoSpecialBridgeIfPresentInSuperClass() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noSpecialBridgeIfPresentInSuperClass.kt");
    }

    @Test
    @TestMetadata("number.kt")
    public void testNumber() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/number.kt");
    }

    @Test
    @TestMetadata("redundantStubForSize.kt")
    public void testRedundantStubForSize() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/redundantStubForSize.kt");
    }

    @Test
    @TestMetadata("removeAtTwoSpecialBridges.kt")
    public void testRemoveAtTwoSpecialBridges() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/removeAtTwoSpecialBridges.kt");
    }

    @Test
    @TestMetadata("specialBridgeForGet.kt")
    public void testSpecialBridgeForGet() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/specialBridgeForGet.kt");
    }

    @Test
    @TestMetadata("unsignedArray.kt")
    public void testUnsignedArray() {
      runTest("compiler/testData/codegen/bytecodeListing/specialBridges/unsignedArray.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeListing/specialBridges/signatures")
    @TestDataPath("$PROJECT_ROOT")
    public class Signatures {
      @Test
      public void testAllFilesPresentInSignatures() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges/signatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("genericClass.kt")
      public void testGenericClass() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/genericClass.kt");
      }

      @Test
      @TestMetadata("implementsJavaMap.kt")
      public void testImplementsJavaMap() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMap.kt");
      }

      @Test
      @TestMetadata("implementsJavaMapWithCustomEntries.kt")
      public void testImplementsJavaMapWithCustomEntries() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMapWithCustomEntries.kt");
      }

      @Test
      @TestMetadata("implementsMap.kt")
      public void testImplementsMap() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsMap.kt");
      }

      @Test
      @TestMetadata("implementsSortedMap.kt")
      public void testImplementsSortedMap() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsSortedMap.kt");
      }

      @Test
      @TestMetadata("kt43610.kt")
      public void testKt43610() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/kt43610.kt");
      }

      @Test
      @TestMetadata("nonGenericClass.kt")
      public void testNonGenericClass() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/nonGenericClass.kt");
      }

      @Test
      @TestMetadata("partiallySpecializedClass.kt")
      public void testPartiallySpecializedClass() {
        runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/partiallySpecializedClass.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/bytecodeListing/valueClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class ValueClasses {
    @Test
    public void testAllFilesPresentInValueClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotations.kt")
    public void testAnnotations() {
      runTest("compiler/testData/codegen/bytecodeListing/valueClasses/annotations.kt");
    }

    @Test
    @TestMetadata("nullabilityAnnotationsOnInlineClassMembers.kt")
    public void testNullabilityAnnotationsOnInlineClassMembers() {
      runTest("compiler/testData/codegen/bytecodeListing/valueClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
    }
  }
}
