/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.AssertionsKt;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.FileInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bH\u0016J:\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016J`\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000bH\u0002J`\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000bJ,\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\b\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fH\u0016J,\u0010\u0017\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\b\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fH\u0016J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00052\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fH\u0016J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00052\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fH\u0016J\u0016\u0010\u001b\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u001c\u0010\u001f\u001a\u00020\r2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000f0\u001dH\u0016J\"\u0010!\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fH\u0016J:\u0010\"\u001a\u00020\r\"\u0004\b\u0000\u0010#2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H#0$2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H#0$2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fH\u0016J\u0016\u0010%\u001a\u00020&2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/test/services/JUnit5Assertions;", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "<init>", "()V", "doesEqualToFile", "", "expectedFile", "Ljava/io/File;", "actual", "", "sanitizer", "Lkotlin/Function1;", "assertEqualsToFile", "", "message", "Lkotlin/Function0;", "Lkotlin/Pair;", "fileNotFoundMessageTeamCity", "fileNotFoundMessageLocal", "differenceObtainedMessage", "assertEquals", "expected", "", "assertNotEquals", "assertTrue", "value", "assertFalse", "failAll", "exceptions", "", "", "assertAll", "conditions", "assertNotNull", "assertSameElements", "T", "", "fail", "", "AssertionFailedErrorFirst", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJUnit5Assertions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnit5Assertions.kt\norg/jetbrains/kotlin/test/services/JUnit5Assertions\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n108#2:133\n80#2,22:134\n108#2:156\n80#2,22:157\n1#3:179\n1557#4:180\n1628#4,3:181\n1557#4:184\n1628#4,3:185\n*S KotlinDebug\n*F\n+ 1 JUnit5Assertions.kt\norg/jetbrains/kotlin/test/services/JUnit5Assertions\n*L\n47#1:133\n47#1:134,22\n58#1:156\n58#1:157,22\n102#1:180\n102#1:181,3\n106#1:184\n106#1:185,3\n*E\n"})
public final class JUnit5Assertions
extends AssertionsService {
    @NotNull
    public static final JUnit5Assertions INSTANCE = new JUnit5Assertions();

    private JUnit5Assertions() {
    }

    @Override
    public boolean doesEqualToFile(@NotNull File expectedFile, @NotNull String actual, @NotNull Function1<? super String, String> sanitizer) {
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        return (Boolean)this.doesEqualToFile(expectedFile, actual, sanitizer, (Function1<? super File, String>)((Function1)arg_0 -> JUnit5Assertions.doesEqualToFile$lambda$0(expectedFile, arg_0)), (Function1<? super File, String>)((Function1)arg_0 -> JUnit5Assertions.doesEqualToFile$lambda$1(expectedFile, arg_0))).getFirst();
    }

    @Override
    public void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual, @NotNull Function1<? super String, String> sanitizer, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.assertEqualsToFile(expectedFile, actual, sanitizer, message, (Function1<? super File, String>)((Function1)arg_0 -> JUnit5Assertions.assertEqualsToFile$lambda$2(expectedFile, arg_0)), (Function1<? super File, String>)((Function1)arg_0 -> JUnit5Assertions.assertEqualsToFile$lambda$3(expectedFile, arg_0)));
    }

    private final Pair<Boolean, String> doesEqualToFile(File expectedFile, String actual, Function1<? super String, String> sanitizer, Function1<? super File, String> fileNotFoundMessageTeamCity, Function1<? super File, String> fileNotFoundMessageLocal) {
        try {
            String expected;
            String $this$trim$iv = actual;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String actualText = StringUtilsKt.trimTrailingWhitespacesAndAddNewlineAtEOF(StringUtilsKt.convertLineSeparators$default(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), null, 1, null));
            if (!expectedFile.exists()) {
                if (this.isTeamCityBuild()) {
                    AssertionsKt.fail$default((String)((String)fileNotFoundMessageTeamCity.invoke((Object)expectedFile)), null, (int)2, null);
                    throw null;
                }
                expectedFile.getParentFile().mkdirs();
                FilesKt.writeText$default((File)expectedFile, (String)actualText, null, (int)2, null);
                AssertionsKt.fail$default((String)((String)fileNotFoundMessageLocal.invoke((Object)expectedFile)), null, (int)2, null);
                throw null;
            }
            String $this$trim$iv2 = expected = StringUtilsKt.convertLineSeparators$default(FilesKt.readText$default((File)expectedFile, null, (int)1, null), null, 1, null);
            $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim3 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            String expectedText = StringUtilsKt.trimTrailingWhitespacesAndAddNewlineAtEOF(((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString());
            return new Pair((Object)Intrinsics.areEqual((Object)sanitizer.invoke((Object)expectedText), (Object)sanitizer.invoke((Object)actualText)), (Object)expected);
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    public final void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual, @NotNull Function1<? super String, String> sanitizer, @NotNull Function0<String> differenceObtainedMessage, @NotNull Function1<? super File, String> fileNotFoundMessageTeamCity, @NotNull Function1<? super File, String> fileNotFoundMessageLocal) {
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        Intrinsics.checkNotNullParameter(differenceObtainedMessage, (String)"differenceObtainedMessage");
        Intrinsics.checkNotNullParameter(fileNotFoundMessageTeamCity, (String)"fileNotFoundMessageTeamCity");
        Intrinsics.checkNotNullParameter(fileNotFoundMessageLocal, (String)"fileNotFoundMessageLocal");
        Pair<Boolean, String> pair = this.doesEqualToFile(expectedFile, actual, sanitizer, fileNotFoundMessageTeamCity, fileNotFoundMessageLocal);
        boolean equalsToFile = (Boolean)pair.component1();
        String expected = (String)pair.component2();
        if (!equalsToFile) {
            String string = (String)differenceObtainedMessage.invoke() + ": " + expectedFile.getName();
            String string2 = expectedFile.getAbsolutePath();
            String string3 = expected;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            throw new AssertionFailedError(string, (Object)new FileInfo(string2, byArray), (Object)actual);
        }
    }

    @Override
    public void assertEquals(@Nullable Object expected, @Nullable Object actual, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertEquals((Object)expected, (Object)actual, function0 != null ? () -> JUnit5Assertions.assertEquals$lambda$6(function0) : null);
    }

    @Override
    public void assertNotEquals(@Nullable Object expected, @Nullable Object actual, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertNotEquals((Object)expected, (Object)actual, function0 != null ? () -> JUnit5Assertions.assertNotEquals$lambda$7(function0) : null);
    }

    @Override
    public void assertTrue(boolean value, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertTrue((boolean)value, function0 != null ? () -> JUnit5Assertions.assertTrue$lambda$8(function0) : null);
    }

    @Override
    public void assertFalse(boolean value, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertFalse((boolean)value, function0 != null ? () -> JUnit5Assertions.assertFalse$lambda$9(function0) : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void failAll(@NotNull List<? extends Throwable> exceptions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        Throwable throwable = (Throwable)CollectionsKt.singleOrNull(exceptions);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw it;
        }
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)exceptions, (Comparator)AssertionFailedErrorFirst.INSTANCE);
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Throwable throwable2 = (Throwable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(() -> JUnit5Assertions.failAll$lambda$12$lambda$11((Throwable)it2));
        }
        Assertions.assertAll((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void assertAll(@NotNull List<? extends Function0<Unit>> conditions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Iterable $this$map$iv = conditions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Function0 function0 = (Function0)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(() -> JUnit5Assertions.assertAll$lambda$14$lambda$13((Function0)it));
        }
        Assertions.assertAll((Collection)((List)destination$iv$iv));
    }

    @Override
    public void assertNotNull(@Nullable Object value, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertNotNull((Object)value, function0 != null ? () -> JUnit5Assertions.assertNotNull$lambda$15(function0) : null);
    }

    @Override
    public <T> void assertSameElements(@NotNull Collection<? extends T> expected, @NotNull Collection<? extends T> actual, @Nullable Function0<String> message) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Function0<String> function0 = message;
        Assertions.assertIterableEquals((Iterable)expected, (Iterable)actual, function0 != null ? () -> JUnit5Assertions.assertSameElements$lambda$16(function0) : null);
    }

    @Override
    @NotNull
    public Void fail(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        AssertionsKt.fail(message);
        throw null;
    }

    private static final String doesEqualToFile$lambda$0(File $expectedFile, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Expected data file did not exist `" + $expectedFile + '`';
    }

    private static final String doesEqualToFile$lambda$1(File $expectedFile, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Expected data file did not exist. Generating: " + $expectedFile;
    }

    private static final String assertEqualsToFile$lambda$2(File $expectedFile, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Expected data file did not exist `" + $expectedFile + '`';
    }

    private static final String assertEqualsToFile$lambda$3(File $expectedFile, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Expected data file did not exist. Generating: " + $expectedFile;
    }

    private static final String assertEquals$lambda$6(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final String assertNotEquals$lambda$7(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final String assertTrue$lambda$8(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final String assertFalse$lambda$9(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final void failAll$lambda$12$lambda$11(Throwable $it) {
        throw $it;
    }

    private static final void assertAll$lambda$14$lambda$13(Function0 $it) {
        $it.invoke();
    }

    private static final String assertNotNull$lambda$15(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final String assertSameElements$lambda$16(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/services/JUnit5Assertions$AssertionFailedErrorFirst;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "tests-common-new_test"})
    private static final class AssertionFailedErrorFirst
    implements Comparator<Throwable> {
        @NotNull
        public static final AssertionFailedErrorFirst INSTANCE = new AssertionFailedErrorFirst();

        private AssertionFailedErrorFirst() {
        }

        @Override
        public int compare(@NotNull Throwable o1, @NotNull Throwable o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return o1 instanceof AssertionFailedError && o2 instanceof AssertionFailedError ? 0 : (o1 instanceof AssertionFailedError ? -1 : (o2 instanceof AssertionFailedError ? 1 : 0));
        }
    }
}

