/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CommonSMAPTestUtil;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SMAPDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "processAfterAllModules", "someAssertionWasFailed", "", "isSeparateCompilation", "separateDumpsEnabled", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nSMAPDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMAPDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/SMAPDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,121:1\n1557#2:122\n1628#2,3:123\n1611#2,9:126\n1863#2:135\n1864#2:137\n1620#2:138\n1053#2:139\n1557#2:140\n1628#2,3:141\n1485#2:144\n1510#2,3:145\n1513#2,3:155\n1062#2:161\n1611#2,9:162\n1863#2:171\n1864#2:173\n1620#2:174\n1202#2,2:176\n1230#2,4:178\n1#3:136\n1#3:172\n381#4,7:148\n126#5:158\n153#5,2:159\n155#5:175\n*S KotlinDebug\n*F\n+ 1 SMAPDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/SMAPDumpHandler\n*L\n41#1:122\n41#1:123,3\n43#1:126,9\n43#1:135\n43#1:137\n43#1:138\n49#1:139\n49#1:140\n49#1:141,3\n53#1:144\n53#1:145,3\n53#1:155,3\n56#1:161\n56#1:162,9\n56#1:171\n56#1:173\n56#1:174\n58#1:176,2\n58#1:178,4\n43#1:136\n56#1:172\n53#1:148,7\n55#1:158\n55#1:159,2\n55#1:175\n*E\n"})
public final class SMAPDumpHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper dumper;
    @NotNull
    public static final String SMAP_EXT = "smap";
    @NotNull
    public static final String SMAP_SEP_EXT = "smap-separate-compilation";
    @NotNull
    public static final String SMAP_NON_SEP_EXT = "smap-nonseparate-compilation";

    public SMAPDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
        this.dumper = new MultiModuleInfoDumper(null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        StringBuilder stringBuilder;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$groupByTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_SMAP())) {
            return;
        }
        Iterable $this$map$iv3 = module.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv3;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getName());
        }
        List originalFileNames = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = CommonSMAPTestUtil.INSTANCE.extractSMAPFromClasses(ClassFileUtilsKt.getClassFiles((ClassFileFactory)info.getClassFileFactory()));
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            CommonSMAPTestUtil.SMAPAndFile it = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
            boolean bl3 = false;
            String name = new File(it.getSourceFile()).getName();
            int index = originalFileNames.indexOf(name);
            TestFile testFile = module.getFiles().get(index);
            if ((testFile.getDirectives().contains(CodegenTestDirectives.INSTANCE.getNO_SMAP_DUMP()) ? null : TuplesKt.to((Object)index, (Object)it)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        boolean $i$f$map2 = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            bl = (Pair)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl5 = false;
            object.add((CommonSMAPTestUtil.SMAPAndFile)it.getSecond());
        }
        List compiledSmaps = (List)destination$iv$iv2;
        CommonSMAPTestUtil.INSTANCE.checkNoConflictMappings(compiledSmaps, this.getAssertions());
        Object $this$groupBy$iv = compiledSmaps;
        boolean $i$f$groupBy = false;
        destination$iv$iv2 = $this$groupBy$iv;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            CommonSMAPTestUtil.SMAPAndFile it = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
            boolean bl6 = false;
            String key$iv$iv = it.getSourceFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl7 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo3 = false;
        Iterator<Object> item$iv$iv = $this$mapTo$iv$iv.entrySet().iterator();
        while (item$iv$iv.hasNext()) {
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            void it;
            Map.Entry item$iv$iv2;
            Map.Entry list$iv$iv = item$iv$iv2 = (Map.Entry)item$iv$iv.next();
            object = destination$iv$iv3;
            boolean bl8 = false;
            Iterable $this$sortedByDescending$iv = (Iterable)it.getValue();
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CommonSMAPTestUtil.SMAPAndFile p0 = (CommonSMAPTestUtil.SMAPAndFile)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getOutputFile());
                    p0 = (CommonSMAPTestUtil.SMAPAndFile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getOutputFile())));
                }
            });
            boolean $i$f$mapNotNull2 = false;
            void $i$f$getOrPut = $this$mapNotNull$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl9 = false;
                CommonSMAPTestUtil.SMAPAndFile p0 = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
                boolean bl10 = false;
                if (p0.getSmap() == null) continue;
                boolean bl11 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            String smap = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv4), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            object.add(new CommonSMAPTestUtil.SMAPAndFile(((CharSequence)smap).length() > 0 ? smap : null, (String)it.getKey(), "NOT_SORTED"));
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv3 = $this$associateBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            CommonSMAPTestUtil.SMAPAndFile bl8 = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
            object = destination$iv$iv5;
            boolean bl12 = false;
            object.put(it.getSourceFile(), element$iv$iv);
        }
        Map compiledData = destination$iv$iv5;
        StringBuilder $this$processModule_u24lambda_u248 = stringBuilder = this.dumper.builderForModule(module);
        boolean bl13 = false;
        for (CommonSMAPTestUtil.SMAPAndFile source : compiledData.values()) {
            $this$processModule_u24lambda_u248.append("// FILE: " + new File(source.getSourceFile()).getName()).append('\n');
            StringBuilder stringBuilder2 = $this$processModule_u24lambda_u248;
            String string = source.getSmap();
            if (string == null) {
                string = "";
            }
            stringBuilder2.append(string).append('\n');
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        File expectedFile;
        boolean separateDumpEnabled = this.separateDumpsEnabled();
        boolean isSeparateCompilation = this.isSeparateCompilation();
        String extension = !separateDumpEnabled ? SMAP_EXT : (isSeparateCompilation ? SMAP_SEP_EXT : SMAP_NON_SEP_EXT);
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File firExpectedFile = FileUtilsKt.withExtension(testDataFile, "fir." + extension);
        File file = expectedFile = Intrinsics.areEqual(((TestModule)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules())).getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE) && firExpectedFile.exists() ? firExpectedFile : FileUtilsKt.withExtension(testDataFile, extension);
        if (this.dumper.isEmpty()) {
            HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), expectedFile, CodegenTestDirectives.INSTANCE.getDUMP_SMAP());
            return;
        }
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, this.dumper.generateResultingDump(), null, 4, null);
        if (separateDumpEnabled && isSeparateCompilation) {
            String otherExtension = isSeparateCompilation ? SMAP_NON_SEP_EXT : SMAP_SEP_EXT;
            File otherFile = FileUtilsKt.withExtension(expectedFile, otherExtension);
            if (!otherFile.exists()) {
                return;
            }
            String expectedText = FilesKt.readText$default((File)expectedFile, null, (int)1, null);
            if (Intrinsics.areEqual((Object)expectedText, (Object)FilesKt.readText$default((File)otherFile, null, (int)1, null))) {
                File smapFile = FileUtilsKt.withExtension(expectedFile, SMAP_EXT);
                FilesKt.writeText$default((File)smapFile, (String)expectedText, null, (int)2, null);
                expectedFile.delete();
                otherFile.delete();
                this.getAssertions().fail((Function0<String>)((Function0)() -> SMAPDumpHandler.processAfterAllModules$lambda$9(expectedFile, otherFile, smapFile, testDataFile)));
                throw new KotlinNothingValueException();
            }
        }
    }

    private final boolean isSeparateCompilation() {
        return TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules().size() > 1;
    }

    private final boolean separateDumpsEnabled() {
        return TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getSEPARATE_SMAP_DUMPS());
    }

    private static final String processAfterAllModules$lambda$9(File $expectedFile, File $otherFile, File $smapFile, File $testDataFile) {
        return StringsKt.trimIndent((String)("\n                    Contents of " + $expectedFile.getName() + " and " + $otherFile.getName() + " are equals, so they are deleted\n                     and joined to " + $smapFile.getName() + ". Please remove " + CodegenTestDirectives.INSTANCE.getSEPARATE_SMAP_DUMPS() + " directive from\n                     " + $testDataFile.getName() + " and rerun test\n                    "));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SMAPDumpHandler$Companion;", "", "<init>", "()V", "SMAP_EXT", "", "SMAP_SEP_EXT", "SMAP_NON_SEP_EXT", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

