/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DependencyProvider;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J5\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\u000e\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u00132\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0012H\u0016\u00a2\u0006\u0002\u0010\u001aJ3\u0010\u001b\u001a\u0002H\u001c\"\u000e\b\u0000\u0010\u001c*\b\u0012\u0004\u0012\u0002H\u001c0\u00132\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u0012H\u0016\u00a2\u0006\u0002\u0010\u001aJ,\u0010\u001d\u001a\u00020\u001e\"\u000e\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u00132\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0013J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u0001H\u0016JO\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002H$0\u0011\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010#\"\u0004\b\u0002\u0010$*\u001a\u0012\u0004\u0012\u0002H%\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002H$0\u00110\u00112\u0006\u0010&\u001a\u0002H%H\u0002\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0010\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/test/services/DependencyProviderImpl;", "Lorg/jetbrains/kotlin/test/services/DependencyProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testModules", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "getAssertions", "()Lorg/jetbrains/kotlin/test/Assertions;", "testModulesByName", "", "", "artifactsByModule", "", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "getTestModule", "name", "getArtifactSafe", "OutputArtifact", "module", "kind", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/TestArtifactKind;)Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "getArtifact", "A", "registerArtifact", "", "artifact", "unregisterAllArtifacts", "copy", "getMap", "V", "R", "K", "key", "(Ljava/util/Map;Ljava/lang/Object;)Ljava/util/Map;", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nDependencyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyProvider.kt\norg/jetbrains/kotlin/test/services/DependencyProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,73:1\n1202#2,2:74\n1230#2,4:76\n1246#2,4:82\n462#3:80\n412#3:81\n381#3,7:86\n*S KotlinDebug\n*F\n+ 1 DependencyProvider.kt\norg/jetbrains/kotlin/test/services/DependencyProviderImpl\n*L\n30#1:74,2\n30#1:76,4\n65#1:82,4\n65#1:80\n65#1:81\n70#1:86,7\n*E\n"})
public final class DependencyProviderImpl
extends DependencyProvider {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final List<TestModule> testModules;
    @NotNull
    private final Map<String, TestModule> testModulesByName;
    @NotNull
    private final Map<TestModule, Map<TestArtifactKind<?>, ResultingArtifact<?>>> artifactsByModule;

    /*
     * WARNING - void declaration
     */
    public DependencyProviderImpl(@NotNull TestServices testServices, @NotNull List<TestModule> testModules) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(testModules, (String)"testModules");
        this.testServices = testServices;
        this.testModules = testModules;
        Iterable iterable = this.testModules;
        DependencyProviderImpl dependencyProviderImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            TestModule testModule = (TestModule)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        dependencyProviderImpl.testModulesByName = destination$iv$iv;
        this.artifactsByModule = new LinkedHashMap();
    }

    private final Assertions getAssertions() {
        return AssertionsKt.getAssertions(this.testServices);
    }

    @Override
    @NotNull
    public TestModule getTestModule(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TestModule testModule = this.testModulesByName.get(name);
        if (testModule == null) {
            this.getAssertions().fail((Function0<String>)((Function0)() -> DependencyProviderImpl.getTestModule$lambda$1(name)));
            throw new KotlinNothingValueException();
        }
        return testModule;
    }

    @Nullable
    public <OutputArtifact extends ResultingArtifact<OutputArtifact>> OutputArtifact getArtifactSafe(@NotNull TestModule module, @NotNull TestArtifactKind<OutputArtifact> kind) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        return (OutputArtifact)this.getMap(this.artifactsByModule, module).get(kind);
    }

    @Override
    @NotNull
    public <A extends ResultingArtifact<A>> A getArtifact(@NotNull TestModule module, @NotNull TestArtifactKind<A> kind) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        A a = this.getArtifactSafe(module, (TestArtifactKind)kind);
        if (a == null) {
            throw new IllegalStateException(("Artifact with kind " + kind + " is not registered for module " + module.getName()).toString());
        }
        return a;
    }

    public final <OutputArtifact extends ResultingArtifact<OutputArtifact>> void registerArtifact(@NotNull TestModule module, @NotNull ResultingArtifact<OutputArtifact> artifact) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(artifact, (String)"artifact");
        this.getMap(this.artifactsByModule, module).put(artifact.getKind(), artifact);
    }

    @Override
    public void unregisterAllArtifacts(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.artifactsByModule.remove(module);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DependencyProvider copy() {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        DependencyProviderImpl dependencyProviderImpl;
        DependencyProviderImpl it = dependencyProviderImpl = new DependencyProviderImpl(this.testServices, this.testModules);
        boolean bl = false;
        Map<TestModule, Map<TestArtifactKind<?>, ResultingArtifact<?>>> map = this.artifactsByModule;
        Map<TestModule, Map<TestArtifactKind<?>, ResultingArtifact<?>>> map2 = this.artifactsByModule;
        boolean $i$f$mapValues = false;
        void var7_7 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl3 = false;
            Map map5 = (Map)entry2.getValue();
            Map map6 = MapsKt.toMutableMap((Map)map5);
            map4.put(k, map6);
        }
        map2.putAll(destination$iv$iv);
        return dependencyProviderImpl;
    }

    private final <K, V, R> Map<V, R> getMap(Map<K, Map<V, R>> $this$getMap, K key) {
        Map map;
        Map<K, Map<Map, R>> $this$getOrPut$iv = $this$getMap;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        return map;
    }

    private static final String getTestModule$lambda$1(String $name) {
        return "Module " + $name + " is not defined";
    }
}

