/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.codegen.inlineScopes;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.utils.TransformersFunctions;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.test.generators.GenerateCompilerTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/box")
@TestDataPath("$PROJECT_ROOT")
public class FirBlackBoxCodegenTestWithInlineScopesGenerated extends AbstractFirBlackBoxCodegenTestWithInlineScopes {
  @Test
  public void testAllFilesPresentInBox() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, "multiplatform/k1", "script");
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/annotations")
  @TestDataPath("$PROJECT_ROOT")
  public class Annotations {
    @Test
    public void testAllFilesPresentInAnnotations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("allowedTargets.kt")
    public void testAllowedTargets() {
      runTest("compiler/testData/codegen/box/annotations/allowedTargets.kt");
    }

    @Test
    @TestMetadata("annotatedAnnotationParameter.kt")
    public void testAnnotatedAnnotationParameter() {
      runTest("compiler/testData/codegen/box/annotations/annotatedAnnotationParameter.kt");
    }

    @Test
    @TestMetadata("annotatedEnumEntry.kt")
    public void testAnnotatedEnumEntry() {
      runTest("compiler/testData/codegen/box/annotations/annotatedEnumEntry.kt");
    }

    @Test
    @TestMetadata("annotatedObjectLiteral.kt")
    public void testAnnotatedObjectLiteral() {
      runTest("compiler/testData/codegen/box/annotations/annotatedObjectLiteral.kt");
    }

    @Test
    @TestMetadata("annotationDefaultValueOfUnsigned.kt")
    public void testAnnotationDefaultValueOfUnsigned() {
      runTest("compiler/testData/codegen/box/annotations/annotationDefaultValueOfUnsigned.kt");
    }

    @Test
    @TestMetadata("annotationOnWhen.kt")
    public void testAnnotationOnWhen() {
      runTest("compiler/testData/codegen/box/annotations/annotationOnWhen.kt");
    }

    @Test
    @TestMetadata("annotationProperty.kt")
    public void testAnnotationProperty() {
      runTest("compiler/testData/codegen/box/annotations/annotationProperty.kt");
    }

    @Test
    @TestMetadata("annotationTargets.kt")
    public void testAnnotationTargets() {
      runTest("compiler/testData/codegen/box/annotations/annotationTargets.kt");
    }

    @Test
    @TestMetadata("annotationWithDefaultArgInDifferentModule.kt")
    public void testAnnotationWithDefaultArgInDifferentModule() {
      runTest("compiler/testData/codegen/box/annotations/annotationWithDefaultArgInDifferentModule.kt");
    }

    @Test
    @TestMetadata("annotationWithKotlinProperty.kt")
    public void testAnnotationWithKotlinProperty() {
      runTest("compiler/testData/codegen/box/annotations/annotationWithKotlinProperty.kt");
    }

    @Test
    @TestMetadata("annotationWithKotlinPropertyFromInterfaceCompanion.kt")
    public void testAnnotationWithKotlinPropertyFromInterfaceCompanion() {
      runTest("compiler/testData/codegen/box/annotations/annotationWithKotlinPropertyFromInterfaceCompanion.kt");
    }

    @Test
    @TestMetadata("annotationWithVarargAsDefaultValue.kt")
    public void testAnnotationWithVarargAsDefaultValue() {
      runTest("compiler/testData/codegen/box/annotations/annotationWithVarargAsDefaultValue.kt");
    }

    @Test
    @TestMetadata("annotations0.kt")
    public void testAnnotations0() {
      runTest("compiler/testData/codegen/box/annotations/annotations0.kt");
    }

    @Test
    @TestMetadata("annotationsOnDefault.kt")
    public void testAnnotationsOnDefault() {
      runTest("compiler/testData/codegen/box/annotations/annotationsOnDefault.kt");
    }

    @Test
    @TestMetadata("annotationsOnLateinitAccessors.kt")
    public void testAnnotationsOnLateinitAccessors() {
      runTest("compiler/testData/codegen/box/annotations/annotationsOnLateinitAccessors.kt");
    }

    @Test
    @TestMetadata("annotationsOnLateinitFields.kt")
    public void testAnnotationsOnLateinitFields() {
      runTest("compiler/testData/codegen/box/annotations/annotationsOnLateinitFields.kt");
    }

    @Test
    @TestMetadata("annotationsOnNonExistentAccessors.kt")
    public void testAnnotationsOnNonExistentAccessors() {
      runTest("compiler/testData/codegen/box/annotations/annotationsOnNonExistentAccessors.kt");
    }

    @Test
    @TestMetadata("annotationsOnTypeAliases.kt")
    public void testAnnotationsOnTypeAliases() {
      runTest("compiler/testData/codegen/box/annotations/annotationsOnTypeAliases.kt");
    }

    @Test
    @TestMetadata("constValInAnnotation.kt")
    public void testConstValInAnnotation() {
      runTest("compiler/testData/codegen/box/annotations/constValInAnnotation.kt");
    }

    @Test
    @TestMetadata("correctTypeForClassReferenceExpressionInAnnotation.kt")
    public void testCorrectTypeForClassReferenceExpressionInAnnotation() {
      runTest("compiler/testData/codegen/box/annotations/correctTypeForClassReferenceExpressionInAnnotation.kt");
    }

    @Test
    @TestMetadata("defaultParameterValues.kt")
    public void testDefaultParameterValues() {
      runTest("compiler/testData/codegen/box/annotations/defaultParameterValues.kt");
    }

    @Test
    @TestMetadata("delegatedPropertySetter.kt")
    public void testDelegatedPropertySetter() {
      runTest("compiler/testData/codegen/box/annotations/delegatedPropertySetter.kt");
    }

    @Test
    @TestMetadata("deserializationOfNestedAnnotationOnType_1.kt")
    public void testDeserializationOfNestedAnnotationOnType_1() {
      runTest("compiler/testData/codegen/box/annotations/deserializationOfNestedAnnotationOnType_1.kt");
    }

    @Test
    @TestMetadata("deserializationOfNestedAnnotationOnType_2.kt")
    public void testDeserializationOfNestedAnnotationOnType_2() {
      runTest("compiler/testData/codegen/box/annotations/deserializationOfNestedAnnotationOnType_2.kt");
    }

    @Test
    @TestMetadata("deserializedLocalClassArgument.kt")
    public void testDeserializedLocalClassArgument() {
      runTest("compiler/testData/codegen/box/annotations/deserializedLocalClassArgument.kt");
    }

    @Test
    @TestMetadata("divisionByZeroInJava.kt")
    public void testDivisionByZeroInJava() {
      runTest("compiler/testData/codegen/box/annotations/divisionByZeroInJava.kt");
    }

    @Test
    @TestMetadata("fileClassWithFileAnnotation.kt")
    public void testFileClassWithFileAnnotation() {
      runTest("compiler/testData/codegen/box/annotations/fileClassWithFileAnnotation.kt");
    }

    @Test
    @TestMetadata("genericAnnotations.kt")
    public void testGenericAnnotations() {
      runTest("compiler/testData/codegen/box/annotations/genericAnnotations.kt");
    }

    @Test
    @TestMetadata("intrinsicConstEvaluationInSources.kt")
    public void testIntrinsicConstEvaluationInSources() {
      runTest("compiler/testData/codegen/box/annotations/intrinsicConstEvaluationInSources.kt");
    }

    @Test
    @TestMetadata("invisibleFunctionWithReceiverWithSuppress.kt")
    public void testInvisibleFunctionWithReceiverWithSuppress() {
      runTest("compiler/testData/codegen/box/annotations/invisibleFunctionWithReceiverWithSuppress.kt");
    }

    @Test
    @TestMetadata("javaAnnotationArrayValueDefault.kt")
    public void testJavaAnnotationArrayValueDefault() {
      runTest("compiler/testData/codegen/box/annotations/javaAnnotationArrayValueDefault.kt");
    }

    @Test
    @TestMetadata("javaAnnotationArrayValueNoDefault.kt")
    public void testJavaAnnotationArrayValueNoDefault() {
      runTest("compiler/testData/codegen/box/annotations/javaAnnotationArrayValueNoDefault.kt");
    }

    @Test
    @TestMetadata("javaAnnotationCall.kt")
    public void testJavaAnnotationCall() {
      runTest("compiler/testData/codegen/box/annotations/javaAnnotationCall.kt");
    }

    @Test
    @TestMetadata("javaAnnotationDefault.kt")
    public void testJavaAnnotationDefault() {
      runTest("compiler/testData/codegen/box/annotations/javaAnnotationDefault.kt");
    }

    @Test
    @TestMetadata("javaAnnotationOnProperty.kt")
    public void testJavaAnnotationOnProperty() {
      runTest("compiler/testData/codegen/box/annotations/javaAnnotationOnProperty.kt");
    }

    @Test
    @TestMetadata("javaAnnotationOnSecondaryConstructorOfLocalClass.kt")
    public void testJavaAnnotationOnSecondaryConstructorOfLocalClass() {
      runTest("compiler/testData/codegen/box/annotations/javaAnnotationOnSecondaryConstructorOfLocalClass.kt");
    }

    @Test
    @TestMetadata("javaAnnotationWithSingleArrayArgument.kt")
    public void testJavaAnnotationWithSingleArrayArgument() {
      runTest("compiler/testData/codegen/box/annotations/javaAnnotationWithSingleArrayArgument.kt");
    }

    @Test
    @TestMetadata("javaConstAnnotationArguments.kt")
    public void testJavaConstAnnotationArguments() {
      runTest("compiler/testData/codegen/box/annotations/javaConstAnnotationArguments.kt");
    }

    @Test
    @TestMetadata("javaNegativePropertyAsAnnotationParameter.kt")
    public void testJavaNegativePropertyAsAnnotationParameter() {
      runTest("compiler/testData/codegen/box/annotations/javaNegativePropertyAsAnnotationParameter.kt");
    }

    @Test
    @TestMetadata("javaPropertyAsAnnotationParameter.kt")
    public void testJavaPropertyAsAnnotationParameter() {
      runTest("compiler/testData/codegen/box/annotations/javaPropertyAsAnnotationParameter.kt");
    }

    @Test
    @TestMetadata("javaPropertyWithIntInitializer.kt")
    public void testJavaPropertyWithIntInitializer() {
      runTest("compiler/testData/codegen/box/annotations/javaPropertyWithIntInitializer.kt");
    }

    @Test
    @TestMetadata("javaTargetOnPrimaryCtorParameter.kt")
    public void testJavaTargetOnPrimaryCtorParameter() {
      runTest("compiler/testData/codegen/box/annotations/javaTargetOnPrimaryCtorParameter.kt");
    }

    @Test
    @TestMetadata("jvmAnnotationFlags.kt")
    public void testJvmAnnotationFlags() {
      runTest("compiler/testData/codegen/box/annotations/jvmAnnotationFlags.kt");
    }

    @Test
    @TestMetadata("kotlinPropertyFromClassObjectAsParameter.kt")
    public void testKotlinPropertyFromClassObjectAsParameter() {
      runTest("compiler/testData/codegen/box/annotations/kotlinPropertyFromClassObjectAsParameter.kt");
    }

    @Test
    @TestMetadata("kotlinTopLevelPropertyAsParameter.kt")
    public void testKotlinTopLevelPropertyAsParameter() {
      runTest("compiler/testData/codegen/box/annotations/kotlinTopLevelPropertyAsParameter.kt");
    }

    @Test
    @TestMetadata("kt10136.kt")
    public void testKt10136() {
      runTest("compiler/testData/codegen/box/annotations/kt10136.kt");
    }

    @Test
    @TestMetadata("kt25489.kt")
    public void testKt25489() {
      runTest("compiler/testData/codegen/box/annotations/kt25489.kt");
    }

    @Test
    @TestMetadata("mustBeDocumented.kt")
    public void testMustBeDocumented() {
      runTest("compiler/testData/codegen/box/annotations/mustBeDocumented.kt");
    }

    @Test
    @TestMetadata("nestedAnnotation.kt")
    public void testNestedAnnotation() {
      runTest("compiler/testData/codegen/box/annotations/nestedAnnotation.kt");
    }

    @Test
    @TestMetadata("nestedClassPropertyAsParameter.kt")
    public void testNestedClassPropertyAsParameter() {
      runTest("compiler/testData/codegen/box/annotations/nestedClassPropertyAsParameter.kt");
    }

    @Test
    @TestMetadata("nestedClassesInAnnotations.kt")
    public void testNestedClassesInAnnotations() {
      runTest("compiler/testData/codegen/box/annotations/nestedClassesInAnnotations.kt");
    }

    @Test
    @TestMetadata("noTypeUseIfDependOnJvm6.kt")
    public void testNoTypeUseIfDependOnJvm6() {
      runTest("compiler/testData/codegen/box/annotations/noTypeUseIfDependOnJvm6.kt");
    }

    @Test
    @TestMetadata("noTypeUseIfFlagIsSpecified.kt")
    public void testNoTypeUseIfFlagIsSpecified() {
      runTest("compiler/testData/codegen/box/annotations/noTypeUseIfFlagIsSpecified.kt");
    }

    @Test
    @TestMetadata("parameterAnnotationInDefaultImpls.kt")
    public void testParameterAnnotationInDefaultImpls() {
      runTest("compiler/testData/codegen/box/annotations/parameterAnnotationInDefaultImpls.kt");
    }

    @Test
    @TestMetadata("parameterWithPrimitiveType.kt")
    public void testParameterWithPrimitiveType() {
      runTest("compiler/testData/codegen/box/annotations/parameterWithPrimitiveType.kt");
    }

    @Test
    @TestMetadata("parameters.kt")
    public void testParameters() {
      runTest("compiler/testData/codegen/box/annotations/parameters.kt");
    }

    @Test
    @TestMetadata("platformDependent.kt")
    public void testPlatformDependent() {
      runTest("compiler/testData/codegen/box/annotations/platformDependent.kt");
    }

    @Test
    @TestMetadata("propertyWithPropertyInInitializerAsParameter.kt")
    public void testPropertyWithPropertyInInitializerAsParameter() {
      runTest("compiler/testData/codegen/box/annotations/propertyWithPropertyInInitializerAsParameter.kt");
    }

    @Test
    @TestMetadata("resolveWithLowPriorityAnnotation.kt")
    public void testResolveWithLowPriorityAnnotation() {
      runTest("compiler/testData/codegen/box/annotations/resolveWithLowPriorityAnnotation.kt");
    }

    @Test
    @TestMetadata("resolvedReturnTypeForJavaEnumEntryAfterDeserialization.kt")
    public void testResolvedReturnTypeForJavaEnumEntryAfterDeserialization() {
      runTest("compiler/testData/codegen/box/annotations/resolvedReturnTypeForJavaEnumEntryAfterDeserialization.kt");
    }

    @Test
    @TestMetadata("retentionInJava.kt")
    public void testRetentionInJava() {
      runTest("compiler/testData/codegen/box/annotations/retentionInJava.kt");
    }

    @Test
    @TestMetadata("selfReferentialAnnotation.kt")
    public void testSelfReferentialAnnotation() {
      runTest("compiler/testData/codegen/box/annotations/selfReferentialAnnotation.kt");
    }

    @Test
    @TestMetadata("singleAssignmentToVarargInAnnotation.kt")
    public void testSingleAssignmentToVarargInAnnotation() {
      runTest("compiler/testData/codegen/box/annotations/singleAssignmentToVarargInAnnotation.kt");
    }

    @Test
    @TestMetadata("spreadOperatorInAnnotationArguments.kt")
    public void testSpreadOperatorInAnnotationArguments() {
      runTest("compiler/testData/codegen/box/annotations/spreadOperatorInAnnotationArguments.kt");
    }

    @Test
    @TestMetadata("suppressInvisibleMember.kt")
    public void testSuppressInvisibleMember() {
      runTest("compiler/testData/codegen/box/annotations/suppressInvisibleMember.kt");
    }

    @Test
    @TestMetadata("syntheticMethodForJvmStaticProperty.kt")
    public void testSyntheticMethodForJvmStaticProperty() {
      runTest("compiler/testData/codegen/box/annotations/syntheticMethodForJvmStaticProperty.kt");
    }

    @Test
    @TestMetadata("syntheticMethodForProperty.kt")
    public void testSyntheticMethodForProperty() {
      runTest("compiler/testData/codegen/box/annotations/syntheticMethodForProperty.kt");
    }

    @Test
    @TestMetadata("targetOnPrimaryCtorParameter.kt")
    public void testTargetOnPrimaryCtorParameter() {
      runTest("compiler/testData/codegen/box/annotations/targetOnPrimaryCtorParameter.kt");
    }

    @Test
    @TestMetadata("targetOnPrimaryCtorParameterMultiModule.kt")
    public void testTargetOnPrimaryCtorParameterMultiModule() {
      runTest("compiler/testData/codegen/box/annotations/targetOnPrimaryCtorParameterMultiModule.kt");
    }

    @Test
    @TestMetadata("typealiasAnnotationWithNonTrivialTypeArguments.kt")
    public void testTypealiasAnnotationWithNonTrivialTypeArguments() {
      runTest("compiler/testData/codegen/box/annotations/typealiasAnnotationWithNonTrivialTypeArguments.kt");
    }

    @Test
    @TestMetadata("useTypeParameterAnnotationFromJava.kt")
    public void testUseTypeParameterAnnotationFromJava() {
      runTest("compiler/testData/codegen/box/annotations/useTypeParameterAnnotationFromJava.kt");
    }

    @Test
    @TestMetadata("useTypeUseAnnotationFromJava.kt")
    public void testUseTypeUseAnnotationFromJava() {
      runTest("compiler/testData/codegen/box/annotations/useTypeUseAnnotationFromJava.kt");
    }

    @Test
    @TestMetadata("varargInAnnotationParameter.kt")
    public void testVarargInAnnotationParameter() {
      runTest("compiler/testData/codegen/box/annotations/varargInAnnotationParameter.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/annotations/annotatedLambda")
    @TestDataPath("$PROJECT_ROOT")
    public class AnnotatedLambda {
      @Test
      public void testAllFilesPresentInAnnotatedLambda() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/annotatedLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("funExpression.kt")
      public void testFunExpression() {
        runTest("compiler/testData/codegen/box/annotations/annotatedLambda/funExpression.kt");
      }

      @Test
      @TestMetadata("lambda.kt")
      public void testLambda() {
        runTest("compiler/testData/codegen/box/annotations/annotatedLambda/lambda.kt");
      }

      @Test
      @TestMetadata("samFunExpression.kt")
      public void testSamFunExpression() {
        runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samFunExpression.kt");
      }

      @Test
      @TestMetadata("samFunReference.kt")
      public void testSamFunReference() {
        runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samFunReference.kt");
      }

      @Test
      @TestMetadata("samLambda.kt")
      public void testSamLambda() {
        runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samLambda.kt");
      }

      @Test
      @TestMetadata("suspendLambda.kt")
      public void testSuspendLambda() {
        runTest("compiler/testData/codegen/box/annotations/annotatedLambda/suspendLambda.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/annotations/instances")
    @TestDataPath("$PROJECT_ROOT")
    public class Instances {
      @Test
      public void testAllFilesPresentInInstances() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/instances"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotationEnclosingName.kt")
      public void testAnnotationEnclosingName() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationEnclosingName.kt");
      }

      @Test
      @TestMetadata("annotationEqHc.kt")
      public void testAnnotationEqHc() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationEqHc.kt");
      }

      @Test
      @TestMetadata("annotationFromStdlib.kt")
      public void testAnnotationFromStdlib() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationFromStdlib.kt");
      }

      @Test
      @TestMetadata("annotationInstances.kt")
      public void testAnnotationInstances() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationInstances.kt");
      }

      @Test
      @TestMetadata("annotationInstancesEmptyDefault.kt")
      public void testAnnotationInstancesEmptyDefault() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationInstancesEmptyDefault.kt");
      }

      @Test
      @TestMetadata("annotationInstancesEmptyDefaultLowered.kt")
      public void testAnnotationInstancesEmptyDefaultLowered() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationInstancesEmptyDefaultLowered.kt");
      }

      @Test
      @TestMetadata("AnnotationInstantiationWithArray.kt")
      public void testAnnotationInstantiationWithArray() {
        runTest("compiler/testData/codegen/box/annotations/instances/AnnotationInstantiationWithArray.kt");
      }

      @Test
      @TestMetadata("annotationJvmHashCode.kt")
      public void testAnnotationJvmHashCode() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationJvmHashCode.kt");
      }

      @Test
      @TestMetadata("annotationToString.kt")
      public void testAnnotationToString() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationToString.kt");
      }

      @Test
      @TestMetadata("annotationType.kt")
      public void testAnnotationType() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationType.kt");
      }

      @Test
      @TestMetadata("annotationWithTypeParameters.kt")
      public void testAnnotationWithTypeParameters() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationWithTypeParameters.kt");
      }

      @Test
      @TestMetadata("annotationWithTypeParametersJvm.kt")
      public void testAnnotationWithTypeParametersJvm() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationWithTypeParametersJvm.kt");
      }

      @Test
      @TestMetadata("annotationsUnsignedTypes.kt")
      public void testAnnotationsUnsignedTypes() {
        runTest("compiler/testData/codegen/box/annotations/instances/annotationsUnsignedTypes.kt");
      }

      @Test
      @TestMetadata("inInlineFunction.kt")
      public void testInInlineFunction() {
        runTest("compiler/testData/codegen/box/annotations/instances/inInlineFunction.kt");
      }

      @Test
      @TestMetadata("innerAnnotationInstantiation.kt")
      public void testInnerAnnotationInstantiation() {
        runTest("compiler/testData/codegen/box/annotations/instances/innerAnnotationInstantiation.kt");
      }

      @Test
      @TestMetadata("javaAnnotation.kt")
      public void testJavaAnnotation() {
        runTest("compiler/testData/codegen/box/annotations/instances/javaAnnotation.kt");
      }

      @Test
      @TestMetadata("javaAnnotationDefault.kt")
      public void testJavaAnnotationDefault() {
        runTest("compiler/testData/codegen/box/annotations/instances/javaAnnotationDefault.kt");
      }

      @Test
      @TestMetadata("javaExistingAnnotation.kt")
      public void testJavaExistingAnnotation() {
        runTest("compiler/testData/codegen/box/annotations/instances/javaExistingAnnotation.kt");
      }

      @Test
      @TestMetadata("kotlinExistingAnnotation.kt")
      public void testKotlinExistingAnnotation() {
        runTest("compiler/testData/codegen/box/annotations/instances/kotlinExistingAnnotation.kt");
      }

      @Test
      @TestMetadata("multifileEqHc.kt")
      public void testMultifileEqHc() {
        runTest("compiler/testData/codegen/box/annotations/instances/multifileEqHc.kt");
      }

      @Test
      @TestMetadata("multimoduleCreation.kt")
      public void testMultimoduleCreation() {
        runTest("compiler/testData/codegen/box/annotations/instances/multimoduleCreation.kt");
      }

      @Test
      @TestMetadata("multimoduleInlining.kt")
      public void testMultimoduleInlining() {
        runTest("compiler/testData/codegen/box/annotations/instances/multimoduleInlining.kt");
      }

      @Test
      @TestMetadata("multimoduleTypeParams.kt")
      public void testMultimoduleTypeParams() {
        runTest("compiler/testData/codegen/box/annotations/instances/multimoduleTypeParams.kt");
      }

      @Test
      @TestMetadata("multiplatformInstantiation.kt")
      public void testMultiplatformInstantiation() {
        runTest("compiler/testData/codegen/box/annotations/instances/multiplatformInstantiation.kt");
      }

      @Test
      @TestMetadata("nestedAnnotationInstances.kt")
      public void testNestedAnnotationInstances() {
        runTest("compiler/testData/codegen/box/annotations/instances/nestedAnnotationInstances.kt");
      }

      @Test
      @TestMetadata("rearrangedArgumentsInAnnotationCall.kt")
      public void testRearrangedArgumentsInAnnotationCall() {
        runTest("compiler/testData/codegen/box/annotations/instances/rearrangedArgumentsInAnnotationCall.kt");
      }

      @Test
      @TestMetadata("varargInAnnotationParameterInstantiation.kt")
      public void testVarargInAnnotationParameterInstantiation() {
        runTest("compiler/testData/codegen/box/annotations/instances/varargInAnnotationParameterInstantiation.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/annotations/kClassMapping")
    @TestDataPath("$PROJECT_ROOT")
    public class KClassMapping {
      @Test
      public void testAllFilesPresentInKClassMapping() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/kClassMapping"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayClassParameter.kt")
      public void testArrayClassParameter() {
        runTest("compiler/testData/codegen/box/annotations/kClassMapping/arrayClassParameter.kt");
      }

      @Test
      @TestMetadata("arrayClassParameterOnJavaClass.kt")
      public void testArrayClassParameterOnJavaClass() {
        runTest("compiler/testData/codegen/box/annotations/kClassMapping/arrayClassParameterOnJavaClass.kt");
      }

      @Test
      @TestMetadata("classParameter.kt")
      public void testClassParameter() {
        runTest("compiler/testData/codegen/box/annotations/kClassMapping/classParameter.kt");
      }

      @Test
      @TestMetadata("classParameterOnJavaClass.kt")
      public void testClassParameterOnJavaClass() {
        runTest("compiler/testData/codegen/box/annotations/kClassMapping/classParameterOnJavaClass.kt");
      }

      @Test
      @TestMetadata("varargClassParameter.kt")
      public void testVarargClassParameter() {
        runTest("compiler/testData/codegen/box/annotations/kClassMapping/varargClassParameter.kt");
      }

      @Test
      @TestMetadata("varargClassParameterOnJavaClass.kt")
      public void testVarargClassParameterOnJavaClass() {
        runTest("compiler/testData/codegen/box/annotations/kClassMapping/varargClassParameterOnJavaClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/annotations/repeatable")
    @TestDataPath("$PROJECT_ROOT")
    public class Repeatable {
      @Test
      public void testAllFilesPresentInRepeatable() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("javaAnnotation.kt")
      public void testJavaAnnotation() {
        runTest("compiler/testData/codegen/box/annotations/repeatable/javaAnnotation.kt");
      }

      @Test
      @TestMetadata("jvmRepeatableKotlinAnnotation.kt")
      public void testJvmRepeatableKotlinAnnotation() {
        runTest("compiler/testData/codegen/box/annotations/repeatable/jvmRepeatableKotlinAnnotation.kt");
      }

      @Test
      @TestMetadata("kotlinAnnotation.kt")
      public void testKotlinAnnotation() {
        runTest("compiler/testData/codegen/box/annotations/repeatable/kotlinAnnotation.kt");
      }

      @Test
      @TestMetadata("kotlinAnnotationInJava.kt")
      public void testKotlinAnnotationInJava() {
        runTest("compiler/testData/codegen/box/annotations/repeatable/kotlinAnnotationInJava.kt");
      }

      @Test
      @TestMetadata("kotlinAnnotationWithBothRepeatables.kt")
      public void testKotlinAnnotationWithBothRepeatables() {
        runTest("compiler/testData/codegen/box/annotations/repeatable/kotlinAnnotationWithBothRepeatables.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/annotations/typeAnnotations")
    @TestDataPath("$PROJECT_ROOT")
    public class TypeAnnotations {
      @Test
      public void testAllFilesPresentInTypeAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/typeAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotationOnSecondParameter.kt")
      public void testAnnotationOnSecondParameter() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/annotationOnSecondParameter.kt");
      }

      @Test
      @TestMetadata("annotationWithTypeParameterOnReturnType.kt")
      public void testAnnotationWithTypeParameterOnReturnType() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/annotationWithTypeParameterOnReturnType.kt");
      }

      @Test
      @TestMetadata("checkingNotincorporatedInputTypes.kt")
      public void testCheckingNotincorporatedInputTypes() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/checkingNotincorporatedInputTypes.kt");
      }

      @Test
      @TestMetadata("classTypeParameterBound.kt")
      public void testClassTypeParameterBound() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/classTypeParameterBound.kt");
      }

      @Test
      @TestMetadata("classTypeParameterBoundsJava.kt")
      public void testClassTypeParameterBoundsJava() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/classTypeParameterBoundsJava.kt");
      }

      @Test
      @TestMetadata("functionTypeParameterBound.kt")
      public void testFunctionTypeParameterBound() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/functionTypeParameterBound.kt");
      }

      @Test
      @TestMetadata("implicitReturn.kt")
      public void testImplicitReturn() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/implicitReturn.kt");
      }

      @Test
      @TestMetadata("implicitReturnAgainstCompiled.kt")
      public void testImplicitReturnAgainstCompiled() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/implicitReturnAgainstCompiled.kt");
      }

      @Test
      @TestMetadata("kt41484.kt")
      public void testKt41484() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/kt41484.kt");
      }

      @Test
      @TestMetadata("methodParameters.kt")
      public void testMethodParameters() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/methodParameters.kt");
      }

      @Test
      @TestMetadata("methodTypeParameters.kt")
      public void testMethodTypeParameters() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/methodTypeParameters.kt");
      }

      @Test
      @TestMetadata("supertype.kt")
      public void testSupertype() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/supertype.kt");
      }

      @Test
      @TestMetadata("typeAnnotationTarget6.kt")
      public void testTypeAnnotationTarget6() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/typeAnnotationTarget6.kt");
      }

      @Test
      @TestMetadata("typeUseAnnotation.kt")
      public void testTypeUseAnnotation() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/typeUseAnnotation.kt");
      }

      @Test
      @TestMetadata("unsafeVarianceInDependency.kt")
      public void testUnsafeVarianceInDependency() {
        runTest("compiler/testData/codegen/box/annotations/typeAnnotations/unsafeVarianceInDependency.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/argumentOrder")
  @TestDataPath("$PROJECT_ROOT")
  public class ArgumentOrder {
    @Test
    public void testAllFilesPresentInArgumentOrder() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("argumentOrderInObjectSuperCall.kt")
    public void testArgumentOrderInObjectSuperCall() {
      runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInObjectSuperCall.kt");
    }

    @Test
    @TestMetadata("argumentOrderInObjectSuperCallWithPlatformType.kt")
    public void testArgumentOrderInObjectSuperCallWithPlatformType() {
      runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInObjectSuperCallWithPlatformType.kt");
    }

    @Test
    @TestMetadata("argumentOrderInSuperCall.kt")
    public void testArgumentOrderInSuperCall() {
      runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInSuperCall.kt");
    }

    @Test
    @TestMetadata("arguments.kt")
    public void testArguments() {
      runTest("compiler/testData/codegen/box/argumentOrder/arguments.kt");
    }

    @Test
    @TestMetadata("captured.kt")
    public void testCaptured() {
      runTest("compiler/testData/codegen/box/argumentOrder/captured.kt");
    }

    @Test
    @TestMetadata("capturedInExtension.kt")
    public void testCapturedInExtension() {
      runTest("compiler/testData/codegen/box/argumentOrder/capturedInExtension.kt");
    }

    @Test
    @TestMetadata("defaults.kt")
    public void testDefaults() {
      runTest("compiler/testData/codegen/box/argumentOrder/defaults.kt");
    }

    @Test
    @TestMetadata("extension.kt")
    public void testExtension() {
      runTest("compiler/testData/codegen/box/argumentOrder/extension.kt");
    }

    @Test
    @TestMetadata("extensionInClass.kt")
    public void testExtensionInClass() {
      runTest("compiler/testData/codegen/box/argumentOrder/extensionInClass.kt");
    }

    @Test
    @TestMetadata("kt17691WithEnabledFeature.kt")
    public void testKt17691WithEnabledFeature() {
      runTest("compiler/testData/codegen/box/argumentOrder/kt17691WithEnabledFeature.kt");
    }

    @Test
    @TestMetadata("kt9277.kt")
    public void testKt9277() {
      runTest("compiler/testData/codegen/box/argumentOrder/kt9277.kt");
    }

    @Test
    @TestMetadata("lambdaMigration.kt")
    public void testLambdaMigration() {
      runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigration.kt");
    }

    @Test
    @TestMetadata("lambdaMigrationInClass.kt")
    public void testLambdaMigrationInClass() {
      runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigrationInClass.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/argumentOrder/simple.kt");
    }

    @Test
    @TestMetadata("simpleInClass.kt")
    public void testSimpleInClass() {
      runTest("compiler/testData/codegen/box/argumentOrder/simpleInClass.kt");
    }

    @Test
    @TestMetadata("singleSideEffect.kt")
    public void testSingleSideEffect() {
      runTest("compiler/testData/codegen/box/argumentOrder/singleSideEffect.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/arithmetic")
  @TestDataPath("$PROJECT_ROOT")
  public class Arithmetic {
    @Test
    public void testAllFilesPresentInArithmetic() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arithmetic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("basic_charConversions.kt")
    public void testBasic_charConversions() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_charConversions.kt");
    }

    @Test
    @TestMetadata("basic_charCornerCases.kt")
    public void testBasic_charCornerCases() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_charCornerCases.kt");
    }

    @Test
    @TestMetadata("basic_compareIntToFloat.kt")
    public void testBasic_compareIntToFloat() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_compareIntToFloat.kt");
    }

    @Test
    @TestMetadata("basic_doubleBasic.kt")
    public void testBasic_doubleBasic() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_doubleBasic.kt");
    }

    @Test
    @TestMetadata("basic_integralToFloat.kt")
    public void testBasic_integralToFloat() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_integralToFloat.kt");
    }

    @Test
    @TestMetadata("basic_kt37412.kt")
    public void testBasic_kt37412() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_kt37412.kt");
    }

    @Test
    @TestMetadata("basic_selfComparison.kt")
    public void testBasic_selfComparison() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_selfComparison.kt");
    }

    @Test
    @TestMetadata("basic_shifts.kt")
    public void testBasic_shifts() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_shifts.kt");
    }

    @Test
    @TestMetadata("basic_uintTests.kt")
    public void testBasic_uintTests() {
      runTest("compiler/testData/codegen/box/arithmetic/basic_uintTests.kt");
    }

    @Test
    @TestMetadata("division.kt")
    public void testDivision() {
      runTest("compiler/testData/codegen/box/arithmetic/division.kt");
    }

    @Test
    @TestMetadata("github1856.kt")
    public void testGithub1856() {
      runTest("compiler/testData/codegen/box/arithmetic/github1856.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/arrays")
  @TestDataPath("$PROJECT_ROOT")
  public class Arrays {
    @Test
    public void testAllFilesPresentInArrays() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arrayConstructorWithNonInlineLambda.kt")
    public void testArrayConstructorWithNonInlineLambda() {
      runTest("compiler/testData/codegen/box/arrays/arrayConstructorWithNonInlineLambda.kt");
    }

    @Test
    @TestMetadata("arrayConstructorsSimple.kt")
    public void testArrayConstructorsSimple() {
      runTest("compiler/testData/codegen/box/arrays/arrayConstructorsSimple.kt");
    }

    @Test
    @TestMetadata("arrayGetAssignMultiIndex.kt")
    public void testArrayGetAssignMultiIndex() {
      runTest("compiler/testData/codegen/box/arrays/arrayGetAssignMultiIndex.kt");
    }

    @Test
    @TestMetadata("arrayGetMultiIndex.kt")
    public void testArrayGetMultiIndex() {
      runTest("compiler/testData/codegen/box/arrays/arrayGetMultiIndex.kt");
    }

    @Test
    @TestMetadata("arrayInstanceOf.kt")
    public void testArrayInstanceOf() {
      runTest("compiler/testData/codegen/box/arrays/arrayInstanceOf.kt");
    }

    @Test
    @TestMetadata("arrayPlusAssign.kt")
    public void testArrayPlusAssign() {
      runTest("compiler/testData/codegen/box/arrays/arrayPlusAssign.kt");
    }

    @Test
    @TestMetadata("arraysAreCloneable.kt")
    public void testArraysAreCloneable() {
      runTest("compiler/testData/codegen/box/arrays/arraysAreCloneable.kt");
    }

    @Test
    @TestMetadata("cloneArray.kt")
    public void testCloneArray() {
      runTest("compiler/testData/codegen/box/arrays/cloneArray.kt");
    }

    @Test
    @TestMetadata("clonePrimitiveArrays.kt")
    public void testClonePrimitiveArrays() {
      runTest("compiler/testData/codegen/box/arrays/clonePrimitiveArrays.kt");
    }

    @Test
    @TestMetadata("collectionAssignGetMultiIndex.kt")
    public void testCollectionAssignGetMultiIndex() {
      runTest("compiler/testData/codegen/box/arrays/collectionAssignGetMultiIndex.kt");
    }

    @Test
    @TestMetadata("collectionGetMultiIndex.kt")
    public void testCollectionGetMultiIndex() {
      runTest("compiler/testData/codegen/box/arrays/collectionGetMultiIndex.kt");
    }

    @Test
    @TestMetadata("constantArrayOfAny.kt")
    public void testConstantArrayOfAny() {
      runTest("compiler/testData/codegen/box/arrays/constantArrayOfAny.kt");
    }

    @Test
    @TestMetadata("emptyArrayDesugaring.kt")
    public void testEmptyArrayDesugaring() {
      runTest("compiler/testData/codegen/box/arrays/emptyArrayDesugaring.kt");
    }

    @Test
    @TestMetadata("forEachBooleanArray.kt")
    public void testForEachBooleanArray() {
      runTest("compiler/testData/codegen/box/arrays/forEachBooleanArray.kt");
    }

    @Test
    @TestMetadata("forEachByteArray.kt")
    public void testForEachByteArray() {
      runTest("compiler/testData/codegen/box/arrays/forEachByteArray.kt");
    }

    @Test
    @TestMetadata("forEachCharArray.kt")
    public void testForEachCharArray() {
      runTest("compiler/testData/codegen/box/arrays/forEachCharArray.kt");
    }

    @Test
    @TestMetadata("forEachDoubleArray.kt")
    public void testForEachDoubleArray() {
      runTest("compiler/testData/codegen/box/arrays/forEachDoubleArray.kt");
    }

    @Test
    @TestMetadata("forEachFloatArray.kt")
    public void testForEachFloatArray() {
      runTest("compiler/testData/codegen/box/arrays/forEachFloatArray.kt");
    }

    @Test
    @TestMetadata("forEachIntArray.kt")
    public void testForEachIntArray() {
      runTest("compiler/testData/codegen/box/arrays/forEachIntArray.kt");
    }

    @Test
    @TestMetadata("forEachLongArray.kt")
    public void testForEachLongArray() {
      runTest("compiler/testData/codegen/box/arrays/forEachLongArray.kt");
    }

    @Test
    @TestMetadata("forEachShortArray.kt")
    public void testForEachShortArray() {
      runTest("compiler/testData/codegen/box/arrays/forEachShortArray.kt");
    }

    @Test
    @TestMetadata("genericArrayInObjectLiteralConstructor.kt")
    public void testGenericArrayInObjectLiteralConstructor() {
      runTest("compiler/testData/codegen/box/arrays/genericArrayInObjectLiteralConstructor.kt");
    }

    @Test
    @TestMetadata("hashMap.kt")
    public void testHashMap() {
      runTest("compiler/testData/codegen/box/arrays/hashMap.kt");
    }

    @Test
    @TestMetadata("inProjectionAsParameter.kt")
    public void testInProjectionAsParameter() {
      runTest("compiler/testData/codegen/box/arrays/inProjectionAsParameter.kt");
    }

    @Test
    @TestMetadata("inProjectionOfArray.kt")
    public void testInProjectionOfArray() {
      runTest("compiler/testData/codegen/box/arrays/inProjectionOfArray.kt");
    }

    @Test
    @TestMetadata("inProjectionOfList.kt")
    public void testInProjectionOfList() {
      runTest("compiler/testData/codegen/box/arrays/inProjectionOfList.kt");
    }

    @Test
    @TestMetadata("indices.kt")
    public void testIndices() {
      runTest("compiler/testData/codegen/box/arrays/indices.kt");
    }

    @Test
    @TestMetadata("indicesChar.kt")
    public void testIndicesChar() {
      runTest("compiler/testData/codegen/box/arrays/indicesChar.kt");
    }

    @Test
    @TestMetadata("inlineInitializer.kt")
    public void testInlineInitializer() {
      runTest("compiler/testData/codegen/box/arrays/inlineInitializer.kt");
    }

    @Test
    @TestMetadata("iterator.kt")
    public void testIterator() {
      runTest("compiler/testData/codegen/box/arrays/iterator.kt");
    }

    @Test
    @TestMetadata("iteratorBooleanArray.kt")
    public void testIteratorBooleanArray() {
      runTest("compiler/testData/codegen/box/arrays/iteratorBooleanArray.kt");
    }

    @Test
    @TestMetadata("iteratorByteArray.kt")
    public void testIteratorByteArray() {
      runTest("compiler/testData/codegen/box/arrays/iteratorByteArray.kt");
    }

    @Test
    @TestMetadata("iteratorByteArrayNextByte.kt")
    public void testIteratorByteArrayNextByte() {
      runTest("compiler/testData/codegen/box/arrays/iteratorByteArrayNextByte.kt");
    }

    @Test
    @TestMetadata("iteratorCharArray.kt")
    public void testIteratorCharArray() {
      runTest("compiler/testData/codegen/box/arrays/iteratorCharArray.kt");
    }

    @Test
    @TestMetadata("iteratorDoubleArray.kt")
    public void testIteratorDoubleArray() {
      runTest("compiler/testData/codegen/box/arrays/iteratorDoubleArray.kt");
    }

    @Test
    @TestMetadata("iteratorFloatArray.kt")
    public void testIteratorFloatArray() {
      runTest("compiler/testData/codegen/box/arrays/iteratorFloatArray.kt");
    }

    @Test
    @TestMetadata("iteratorIntArray.kt")
    public void testIteratorIntArray() {
      runTest("compiler/testData/codegen/box/arrays/iteratorIntArray.kt");
    }

    @Test
    @TestMetadata("iteratorLongArray.kt")
    public void testIteratorLongArray() {
      runTest("compiler/testData/codegen/box/arrays/iteratorLongArray.kt");
    }

    @Test
    @TestMetadata("iteratorLongArrayNextLong.kt")
    public void testIteratorLongArrayNextLong() {
      runTest("compiler/testData/codegen/box/arrays/iteratorLongArrayNextLong.kt");
    }

    @Test
    @TestMetadata("iteratorShortArray.kt")
    public void testIteratorShortArray() {
      runTest("compiler/testData/codegen/box/arrays/iteratorShortArray.kt");
    }

    @Test
    @TestMetadata("kt1291.kt")
    public void testKt1291() {
      runTest("compiler/testData/codegen/box/arrays/kt1291.kt");
    }

    @Test
    @TestMetadata("kt17134.kt")
    public void testKt17134() {
      runTest("compiler/testData/codegen/box/arrays/kt17134.kt");
    }

    @Test
    @TestMetadata("kt238.kt")
    public void testKt238() {
      runTest("compiler/testData/codegen/box/arrays/kt238.kt");
    }

    @Test
    @TestMetadata("kt2997.kt")
    public void testKt2997() {
      runTest("compiler/testData/codegen/box/arrays/kt2997.kt");
    }

    @Test
    @TestMetadata("kt33.kt")
    public void testKt33() {
      runTest("compiler/testData/codegen/box/arrays/kt33.kt");
    }

    @Test
    @TestMetadata("kt34291_16dimensions.kt")
    public void testKt34291_16dimensions() {
      runTest("compiler/testData/codegen/box/arrays/kt34291_16dimensions.kt");
    }

    @Test
    @TestMetadata("kt3771.kt")
    public void testKt3771() {
      runTest("compiler/testData/codegen/box/arrays/kt3771.kt");
    }

    @Test
    @TestMetadata("kt4118.kt")
    public void testKt4118() {
      runTest("compiler/testData/codegen/box/arrays/kt4118.kt");
    }

    @Test
    @TestMetadata("kt42932.kt")
    public void testKt42932() {
      runTest("compiler/testData/codegen/box/arrays/kt42932.kt");
    }

    @Test
    @TestMetadata("kt4348.kt")
    public void testKt4348() {
      runTest("compiler/testData/codegen/box/arrays/kt4348.kt");
    }

    @Test
    @TestMetadata("kt4357.kt")
    public void testKt4357() {
      runTest("compiler/testData/codegen/box/arrays/kt4357.kt");
    }

    @Test
    @TestMetadata("kt45410.kt")
    public void testKt45410() {
      runTest("compiler/testData/codegen/box/arrays/kt45410.kt");
    }

    @Test
    @TestMetadata("kt47483.kt")
    public void testKt47483() {
      runTest("compiler/testData/codegen/box/arrays/kt47483.kt");
    }

    @Test
    @TestMetadata("kt47499.kt")
    public void testKt47499() {
      runTest("compiler/testData/codegen/box/arrays/kt47499.kt");
    }

    @Test
    @TestMetadata("kt503.kt")
    public void testKt503() {
      runTest("compiler/testData/codegen/box/arrays/kt503.kt");
    }

    @Test
    @TestMetadata("kt55984.kt")
    public void testKt55984() {
      runTest("compiler/testData/codegen/box/arrays/kt55984.kt");
    }

    @Test
    @TestMetadata("kt594.kt")
    public void testKt594() {
      runTest("compiler/testData/codegen/box/arrays/kt594.kt");
    }

    @Test
    @TestMetadata("kt602.kt")
    public void testKt602() {
      runTest("compiler/testData/codegen/box/arrays/kt602.kt");
    }

    @Test
    @TestMetadata("kt7009.kt")
    public void testKt7009() {
      runTest("compiler/testData/codegen/box/arrays/kt7009.kt");
    }

    @Test
    @TestMetadata("kt7288.kt")
    public void testKt7288() {
      runTest("compiler/testData/codegen/box/arrays/kt7288.kt");
    }

    @Test
    @TestMetadata("kt7338.kt")
    public void testKt7338() {
      runTest("compiler/testData/codegen/box/arrays/kt7338.kt");
    }

    @Test
    @TestMetadata("kt779.kt")
    public void testKt779() {
      runTest("compiler/testData/codegen/box/arrays/kt779.kt");
    }

    @Test
    @TestMetadata("kt945.kt")
    public void testKt945() {
      runTest("compiler/testData/codegen/box/arrays/kt945.kt");
    }

    @Test
    @TestMetadata("kt950.kt")
    public void testKt950() {
      runTest("compiler/testData/codegen/box/arrays/kt950.kt");
    }

    @Test
    @TestMetadata("longAsIndex.kt")
    public void testLongAsIndex() {
      runTest("compiler/testData/codegen/box/arrays/longAsIndex.kt");
    }

    @Test
    @TestMetadata("multiArrayConstructors.kt")
    public void testMultiArrayConstructors() {
      runTest("compiler/testData/codegen/box/arrays/multiArrayConstructors.kt");
    }

    @Test
    @TestMetadata("nonLocalReturnArrayConstructor.kt")
    public void testNonLocalReturnArrayConstructor() {
      runTest("compiler/testData/codegen/box/arrays/nonLocalReturnArrayConstructor.kt");
    }

    @Test
    @TestMetadata("nonNullArray.kt")
    public void testNonNullArray() {
      runTest("compiler/testData/codegen/box/arrays/nonNullArray.kt");
    }

    @Test
    @TestMetadata("primitiveArrays.kt")
    public void testPrimitiveArrays() {
      runTest("compiler/testData/codegen/box/arrays/primitiveArrays.kt");
    }

    @Test
    @TestMetadata("stdlib.kt")
    public void testStdlib() {
      runTest("compiler/testData/codegen/box/arrays/stdlib.kt");
    }

    @Test
    @TestMetadata("varargsWithJava.kt")
    public void testVarargsWithJava() {
      runTest("compiler/testData/codegen/box/arrays/varargsWithJava.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/arrays/arraysOfInlineClass")
    @TestDataPath("$PROJECT_ROOT")
    public class ArraysOfInlineClass {
      @Test
      @TestMetadata("accessArrayOfInlineClass.kt")
      public void testAccessArrayOfInlineClass() {
        runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfInlineClass.kt");
      }

      @Test
      @TestMetadata("accessArrayOfUnsigned.kt")
      public void testAccessArrayOfUnsigned() {
        runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfUnsigned.kt");
      }

      @Test
      public void testAllFilesPresentInArraysOfInlineClass() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/arraysOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayOfInlineClassOfArrayOfInlineClass.kt")
      public void testArrayOfInlineClassOfArrayOfInlineClass() {
        runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/arrayOfInlineClassOfArrayOfInlineClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/arrays/forInReversed")
    @TestDataPath("$PROJECT_ROOT")
    public class ForInReversed {
      @Test
      public void testAllFilesPresentInForInReversed() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("reversedArray.kt")
      public void testReversedArray() {
        runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArray.kt");
      }

      @Test
      @TestMetadata("reversedArrayOriginalUpdatedInLoopBody.kt")
      public void testReversedArrayOriginalUpdatedInLoopBody() {
        runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArrayOriginalUpdatedInLoopBody.kt");
      }

      @Test
      @TestMetadata("reversedArrayReversedArrayOriginalUpdatedInLoopBody.kt")
      public void testReversedArrayReversedArrayOriginalUpdatedInLoopBody() {
        runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArrayReversedArrayOriginalUpdatedInLoopBody.kt");
      }

      @Test
      @TestMetadata("reversedOriginalUpdatedInLoopBody.kt")
      public void testReversedOriginalUpdatedInLoopBody() {
        runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedOriginalUpdatedInLoopBody.kt");
      }

      @Test
      @TestMetadata("reversedReversedOriginalUpdatedInLoopBody.kt")
      public void testReversedReversedOriginalUpdatedInLoopBody() {
        runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedReversedOriginalUpdatedInLoopBody.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/arrays/forInUnsignedArray")
    @TestDataPath("$PROJECT_ROOT")
    public class ForInUnsignedArray {
      @Test
      public void testAllFilesPresentInForInUnsignedArray() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/forInUnsignedArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("forInUnsignedArray.kt")
      public void testForInUnsignedArray() {
        runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArray.kt");
      }

      @Test
      @TestMetadata("forInUnsignedArrayIndices.kt")
      public void testForInUnsignedArrayIndices() {
        runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayIndices.kt");
      }

      @Test
      @TestMetadata("forInUnsignedArrayIndicesReversed.kt")
      public void testForInUnsignedArrayIndicesReversed() {
        runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayIndicesReversed.kt");
      }

      @Test
      @TestMetadata("forInUnsignedArrayReversed.kt")
      public void testForInUnsignedArrayReversed() {
        runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayReversed.kt");
      }

      @Test
      @TestMetadata("forInUnsignedArrayWithIndex.kt")
      public void testForInUnsignedArrayWithIndex() {
        runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInUnsignedArrayWithIndexNoElementVar.kt")
      public void testForInUnsignedArrayWithIndexNoElementVar() {
        runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexNoElementVar.kt");
      }

      @Test
      @TestMetadata("forInUnsignedArrayWithIndexNoIndexVar.kt")
      public void testForInUnsignedArrayWithIndexNoIndexVar() {
        runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexNoIndexVar.kt");
      }

      @Test
      @TestMetadata("forInUnsignedArrayWithIndexReversed.kt")
      public void testForInUnsignedArrayWithIndexReversed() {
        runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexReversed.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl")
    @TestDataPath("$PROJECT_ROOT")
    public class MultiDecl {
      @Test
      public void testAllFilesPresentInMultiDecl() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt15560.kt")
      public void testKt15560() {
        runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15560.kt");
      }

      @Test
      @TestMetadata("kt15568.kt")
      public void testKt15568() {
        runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15568.kt");
      }

      @Test
      @TestMetadata("kt15575.kt")
      public void testKt15575() {
        runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15575.kt");
      }

      @Test
      @TestMetadata("MultiDeclFor.kt")
      public void testMultiDeclFor() {
        runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclFor.kt");
      }

      @Test
      @TestMetadata("MultiDeclForComponentExtensions.kt")
      public void testMultiDeclForComponentExtensions() {
        runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentExtensions.kt");
      }

      @Test
      @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
      public void testMultiDeclForComponentMemberExtensions() {
        runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensions.kt");
      }

      @Test
      @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
      public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() {
        runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
      }

      @Test
      @TestMetadata("MultiDeclForValCaptured.kt")
      public void testMultiDeclForValCaptured() {
        runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForValCaptured.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/int")
      @TestDataPath("$PROJECT_ROOT")
      public class Int {
        @Test
        public void testAllFilesPresentInInt() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/int"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("MultiDeclForComponentExtensions.kt")
        public void testMultiDeclForComponentExtensions() {
          runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensions.kt");
        }

        @Test
        @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
        public void testMultiDeclForComponentExtensionsValCaptured() {
          runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensionsValCaptured.kt");
        }

        @Test
        @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
        public void testMultiDeclForComponentMemberExtensions() {
          runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensions.kt");
        }

        @Test
        @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
        public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() {
          runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/long")
      @TestDataPath("$PROJECT_ROOT")
      public class Long {
        @Test
        public void testAllFilesPresentInLong() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/long"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("MultiDeclForComponentExtensions.kt")
        public void testMultiDeclForComponentExtensions() {
          runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensions.kt");
        }

        @Test
        @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
        public void testMultiDeclForComponentExtensionsValCaptured() {
          runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensionsValCaptured.kt");
        }

        @Test
        @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
        public void testMultiDeclForComponentMemberExtensions() {
          runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensions.kt");
        }

        @Test
        @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
        public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() {
          runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
        }
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/assert")
  @TestDataPath("$PROJECT_ROOT")
  public class Assert {
    @Test
    public void testAllFilesPresentInAssert() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("alwaysDisable.kt")
    public void testAlwaysDisable() {
      runTest("compiler/testData/codegen/box/assert/alwaysDisable.kt");
    }

    @Test
    @TestMetadata("alwaysEnable.kt")
    public void testAlwaysEnable() {
      runTest("compiler/testData/codegen/box/assert/alwaysEnable.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/assert/jvm")
    @TestDataPath("$PROJECT_ROOT")
    public class Jvm {
      @Test
      public void testAllFilesPresentInJvm() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/assert/jvm"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("assertionsEnabledBeforeClassInitializers.kt")
      public void testAssertionsEnabledBeforeClassInitializers() {
        runTest("compiler/testData/codegen/box/assert/jvm/assertionsEnabledBeforeClassInitializers.kt");
      }

      @Test
      @TestMetadata("classAssertions.kt")
      public void testClassAssertions() {
        runTest("compiler/testData/codegen/box/assert/jvm/classAssertions.kt");
      }

      @Test
      @TestMetadata("classAssertionsForCompanion.kt")
      public void testClassAssertionsForCompanion() {
        runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForCompanion.kt");
      }

      @Test
      @TestMetadata("classAssertionsForInnerClasses.kt")
      public void testClassAssertionsForInnerClasses() {
        runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForInnerClasses.kt");
      }

      @Test
      @TestMetadata("classAssertionsForLocalClasses.kt")
      public void testClassAssertionsForLocalClasses() {
        runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForLocalClasses.kt");
      }

      @Test
      @TestMetadata("classAssertionsForNestedClasses.kt")
      public void testClassAssertionsForNestedClasses() {
        runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForNestedClasses.kt");
      }

      @Test
      @TestMetadata("interfaceAssertionsDisabled.kt")
      public void testInterfaceAssertionsDisabled() {
        runTest("compiler/testData/codegen/box/assert/jvm/interfaceAssertionsDisabled.kt");
      }

      @Test
      @TestMetadata("interfaceAssertionsEnabled.kt")
      public void testInterfaceAssertionsEnabled() {
        runTest("compiler/testData/codegen/box/assert/jvm/interfaceAssertionsEnabled.kt");
      }

      @Test
      @TestMetadata("lambdaNotEvaluated.kt")
      public void testLambdaNotEvaluated() {
        runTest("compiler/testData/codegen/box/assert/jvm/lambdaNotEvaluated.kt");
      }

      @Test
      @TestMetadata("localAnonymousFunction.kt")
      public void testLocalAnonymousFunction() {
        runTest("compiler/testData/codegen/box/assert/jvm/localAnonymousFunction.kt");
      }

      @Test
      @TestMetadata("localClass.kt")
      public void testLocalClass() {
        runTest("compiler/testData/codegen/box/assert/jvm/localClass.kt");
      }

      @Test
      @TestMetadata("localFunction.kt")
      public void testLocalFunction() {
        runTest("compiler/testData/codegen/box/assert/jvm/localFunction.kt");
      }

      @Test
      @TestMetadata("localLambda.kt")
      public void testLocalLambda() {
        runTest("compiler/testData/codegen/box/assert/jvm/localLambda.kt");
      }

      @Test
      @TestMetadata("localObject.kt")
      public void testLocalObject() {
        runTest("compiler/testData/codegen/box/assert/jvm/localObject.kt");
      }

      @Test
      @TestMetadata("noUnnecessaryClassInitialization.kt")
      public void testNoUnnecessaryClassInitialization() {
        runTest("compiler/testData/codegen/box/assert/jvm/noUnnecessaryClassInitialization.kt");
      }

      @Test
      @TestMetadata("nonLocalReturn.kt")
      public void testNonLocalReturn() {
        runTest("compiler/testData/codegen/box/assert/jvm/nonLocalReturn.kt");
      }

      @Test
      @TestMetadata("ordinary.kt")
      public void testOrdinary() {
        runTest("compiler/testData/codegen/box/assert/jvm/ordinary.kt");
      }

      @Test
      @TestMetadata("superClassInitializer.kt")
      public void testSuperClassInitializer() {
        runTest("compiler/testData/codegen/box/assert/jvm/superClassInitializer.kt");
      }

      @Test
      @TestMetadata("suspendFunctionAssertionDisabled.kt")
      public void testSuspendFunctionAssertionDisabled() {
        runTest("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionDisabled.kt");
      }

      @Test
      @TestMetadata("suspendFunctionAssertionsEnabled.kt")
      public void testSuspendFunctionAssertionsEnabled() {
        runTest("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionsEnabled.kt");
      }

      @Test
      @TestMetadata("suspendLambdaAssertionsDisabled.kt")
      public void testSuspendLambdaAssertionsDisabled() {
        runTest("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsDisabled.kt");
      }

      @Test
      @TestMetadata("suspendLambdaAssertionsEnabled.kt")
      public void testSuspendLambdaAssertionsEnabled() {
        runTest("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsEnabled.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/basics")
  @TestDataPath("$PROJECT_ROOT")
  public class Basics {
    @Test
    public void testAllFilesPresentInBasics() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/basics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("array_to_any.kt")
    public void testArray_to_any() {
      runTest("compiler/testData/codegen/box/basics/array_to_any.kt");
    }

    @Test
    @TestMetadata("canonical_name.kt")
    public void testCanonical_name() {
      runTest("compiler/testData/codegen/box/basics/canonical_name.kt");
    }

    @Test
    @TestMetadata("cast_null.kt")
    public void testCast_null() {
      runTest("compiler/testData/codegen/box/basics/cast_null.kt");
    }

    @Test
    @TestMetadata("cast_simple.kt")
    public void testCast_simple() {
      runTest("compiler/testData/codegen/box/basics/cast_simple.kt");
    }

    @Test
    @TestMetadata("check_type.kt")
    public void testCheck_type() {
      runTest("compiler/testData/codegen/box/basics/check_type.kt");
    }

    @Test
    @TestMetadata("companion.kt")
    public void testCompanion() {
      runTest("compiler/testData/codegen/box/basics/companion.kt");
    }

    @Test
    @TestMetadata("concatenation.kt")
    public void testConcatenation() {
      runTest("compiler/testData/codegen/box/basics/concatenation.kt");
    }

    @Test
    @TestMetadata("const_infinity.kt")
    public void testConst_infinity() {
      runTest("compiler/testData/codegen/box/basics/const_infinity.kt");
    }

    @Test
    @TestMetadata("expression_as_statement.kt")
    public void testExpression_as_statement() {
      runTest("compiler/testData/codegen/box/basics/expression_as_statement.kt");
    }

    @Test
    @TestMetadata("k42000_1.kt")
    public void testK42000_1() {
      runTest("compiler/testData/codegen/box/basics/k42000_1.kt");
    }

    @Test
    @TestMetadata("k42000_2.kt")
    public void testK42000_2() {
      runTest("compiler/testData/codegen/box/basics/k42000_2.kt");
    }

    @Test
    @TestMetadata("kt7972.kt")
    public void testKt7972() {
      runTest("compiler/testData/codegen/box/basics/kt7972.kt");
    }

    @Test
    @TestMetadata("local_variable.kt")
    public void testLocal_variable() {
      runTest("compiler/testData/codegen/box/basics/local_variable.kt");
    }

    @Test
    @TestMetadata("null_check.kt")
    public void testNull_check() {
      runTest("compiler/testData/codegen/box/basics/null_check.kt");
    }

    @Test
    @TestMetadata("safe_cast.kt")
    public void testSafe_cast() {
      runTest("compiler/testData/codegen/box/basics/safe_cast.kt");
    }

    @Test
    @TestMetadata("spread_operator_0.kt")
    public void testSpread_operator_0() {
      runTest("compiler/testData/codegen/box/basics/spread_operator_0.kt");
    }

    @Test
    @TestMetadata("statements0.kt")
    public void testStatements0() {
      runTest("compiler/testData/codegen/box/basics/statements0.kt");
    }

    @Test
    @TestMetadata("superFunCall.kt")
    public void testSuperFunCall() {
      runTest("compiler/testData/codegen/box/basics/superFunCall.kt");
    }

    @Test
    @TestMetadata("superGetterCall.kt")
    public void testSuperGetterCall() {
      runTest("compiler/testData/codegen/box/basics/superGetterCall.kt");
    }

    @Test
    @TestMetadata("superSetterCall.kt")
    public void testSuperSetterCall() {
      runTest("compiler/testData/codegen/box/basics/superSetterCall.kt");
    }

    @Test
    @TestMetadata("typealias1.kt")
    public void testTypealias1() {
      runTest("compiler/testData/codegen/box/basics/typealias1.kt");
    }

    @Test
    @TestMetadata("unchecked_cast1.kt")
    public void testUnchecked_cast1() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast1.kt");
    }

    @Test
    @TestMetadata("unchecked_cast10.kt")
    public void testUnchecked_cast10() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast10.kt");
    }

    @Test
    @TestMetadata("unchecked_cast11.kt")
    public void testUnchecked_cast11() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast11.kt");
    }

    @Test
    @TestMetadata("unchecked_cast12.kt")
    public void testUnchecked_cast12() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast12.kt");
    }

    @Test
    @TestMetadata("unchecked_cast13.kt")
    public void testUnchecked_cast13() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast13.kt");
    }

    @Test
    @TestMetadata("unchecked_cast2.kt")
    public void testUnchecked_cast2() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast2.kt");
    }

    @Test
    @TestMetadata("unchecked_cast3.kt")
    public void testUnchecked_cast3() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast3.kt");
    }

    @Test
    @TestMetadata("unchecked_cast4.kt")
    public void testUnchecked_cast4() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast4.kt");
    }

    @Test
    @TestMetadata("unchecked_cast5.kt")
    public void testUnchecked_cast5() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast5.kt");
    }

    @Test
    @TestMetadata("unchecked_cast6.kt")
    public void testUnchecked_cast6() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast6.kt");
    }

    @Test
    @TestMetadata("unchecked_cast6x.kt")
    public void testUnchecked_cast6x() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast6x.kt");
    }

    @Test
    @TestMetadata("unchecked_cast7.kt")
    public void testUnchecked_cast7() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast7.kt");
    }

    @Test
    @TestMetadata("unchecked_cast8.kt")
    public void testUnchecked_cast8() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast8.kt");
    }

    @Test
    @TestMetadata("unchecked_cast9.kt")
    public void testUnchecked_cast9() {
      runTest("compiler/testData/codegen/box/basics/unchecked_cast9.kt");
    }

    @Test
    @TestMetadata("unit1.kt")
    public void testUnit1() {
      runTest("compiler/testData/codegen/box/basics/unit1.kt");
    }

    @Test
    @TestMetadata("unit2.kt")
    public void testUnit2() {
      runTest("compiler/testData/codegen/box/basics/unit2.kt");
    }

    @Test
    @TestMetadata("unit3.kt")
    public void testUnit3() {
      runTest("compiler/testData/codegen/box/basics/unit3.kt");
    }

    @Test
    @TestMetadata("unit4.kt")
    public void testUnit4() {
      runTest("compiler/testData/codegen/box/basics/unit4.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/bce")
  @TestDataPath("$PROJECT_ROOT")
  public class Bce {
    @Test
    public void testAllFilesPresentInBce() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bce"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("bceCases.kt")
    public void testBceCases() {
      runTest("compiler/testData/codegen/box/bce/bceCases.kt");
    }

    @Test
    @TestMetadata("customGetter.kt")
    public void testCustomGetter() {
      runTest("compiler/testData/codegen/box/bce/customGetter.kt");
    }

    @Test
    @TestMetadata("delegatedProperty.kt")
    public void testDelegatedProperty() {
      runTest("compiler/testData/codegen/box/bce/delegatedProperty.kt");
    }

    @Test
    @TestMetadata("differentArrays.kt")
    public void testDifferentArrays() {
      runTest("compiler/testData/codegen/box/bce/differentArrays.kt");
    }

    @Test
    @TestMetadata("differentObjects.kt")
    public void testDifferentObjects() {
      runTest("compiler/testData/codegen/box/bce/differentObjects.kt");
    }

    @Test
    @TestMetadata("forDownToSize.kt")
    public void testForDownToSize() {
      runTest("compiler/testData/codegen/box/bce/forDownToSize.kt");
    }

    @Test
    @TestMetadata("forDownToWithStep.kt")
    public void testForDownToWithStep() {
      runTest("compiler/testData/codegen/box/bce/forDownToWithStep.kt");
    }

    @Test
    @TestMetadata("forEachIndexedTest.kt")
    public void testForEachIndexedTest() {
      runTest("compiler/testData/codegen/box/bce/forEachIndexedTest.kt");
    }

    @Test
    @TestMetadata("forEachIndicies.kt")
    public void testForEachIndicies() {
      runTest("compiler/testData/codegen/box/bce/forEachIndicies.kt");
    }

    @Test
    @TestMetadata("forIndiciesWithStep.kt")
    public void testForIndiciesWithStep() {
      runTest("compiler/testData/codegen/box/bce/forIndiciesWithStep.kt");
    }

    @Test
    @TestMetadata("forRangeToSize.kt")
    public void testForRangeToSize() {
      runTest("compiler/testData/codegen/box/bce/forRangeToSize.kt");
    }

    @Test
    @TestMetadata("forRangeToWithStep.kt")
    public void testForRangeToWithStep() {
      runTest("compiler/testData/codegen/box/bce/forRangeToWithStep.kt");
    }

    @Test
    @TestMetadata("forReversed.kt")
    public void testForReversed() {
      runTest("compiler/testData/codegen/box/bce/forReversed.kt");
    }

    @Test
    @TestMetadata("forUntilSize.kt")
    public void testForUntilSize() {
      runTest("compiler/testData/codegen/box/bce/forUntilSize.kt");
    }

    @Test
    @TestMetadata("forUntilWithStep.kt")
    public void testForUntilWithStep() {
      runTest("compiler/testData/codegen/box/bce/forUntilWithStep.kt");
    }

    @Test
    @TestMetadata("forWithIndex.kt")
    public void testForWithIndex() {
      runTest("compiler/testData/codegen/box/bce/forWithIndex.kt");
    }

    @Test
    @TestMetadata("inheritance.kt")
    public void testInheritance() {
      runTest("compiler/testData/codegen/box/bce/inheritance.kt");
    }

    @Test
    @TestMetadata("withGetter.kt")
    public void testWithGetter() {
      runTest("compiler/testData/codegen/box/bce/withGetter.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/binaryOp")
  @TestDataPath("$PROJECT_ROOT")
  public class BinaryOp {
    @Test
    public void testAllFilesPresentInBinaryOp() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/binaryOp"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("bitwiseOp.kt")
    public void testBitwiseOp() {
      runTest("compiler/testData/codegen/box/binaryOp/bitwiseOp.kt");
    }

    @Test
    @TestMetadata("bitwiseOpAny.kt")
    public void testBitwiseOpAny() {
      runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpAny.kt");
    }

    @Test
    @TestMetadata("bitwiseOpNullable.kt")
    public void testBitwiseOpNullable() {
      runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpNullable.kt");
    }

    @Test
    @TestMetadata("boxingOfLiteralReceiverWithIntegerValueType.kt")
    public void testBoxingOfLiteralReceiverWithIntegerValueType() {
      runTest("compiler/testData/codegen/box/binaryOp/boxingOfLiteralReceiverWithIntegerValueType.kt");
    }

    @Test
    @TestMetadata("call.kt")
    public void testCall() {
      runTest("compiler/testData/codegen/box/binaryOp/call.kt");
    }

    @Test
    @TestMetadata("callAny.kt")
    public void testCallAny() {
      runTest("compiler/testData/codegen/box/binaryOp/callAny.kt");
    }

    @Test
    @TestMetadata("callNullable.kt")
    public void testCallNullable() {
      runTest("compiler/testData/codegen/box/binaryOp/callNullable.kt");
    }

    @Test
    @TestMetadata("compareBoxedChars.kt")
    public void testCompareBoxedChars() {
      runTest("compiler/testData/codegen/box/binaryOp/compareBoxedChars.kt");
    }

    @Test
    @TestMetadata("compareWithBoxedDouble.kt")
    public void testCompareWithBoxedDouble() {
      runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedDouble.kt");
    }

    @Test
    @TestMetadata("compareWithBoxedLong.kt")
    public void testCompareWithBoxedLong() {
      runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedLong.kt");
    }

    @Test
    @TestMetadata("compareWithBoxedNotNullDouble.kt")
    public void testCompareWithBoxedNotNullDouble() {
      runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedNotNullDouble.kt");
    }

    @Test
    @TestMetadata("compareWithBoxedNotNullLong.kt")
    public void testCompareWithBoxedNotNullLong() {
      runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedNotNullLong.kt");
    }

    @Test
    @TestMetadata("divisionByZero.kt")
    public void testDivisionByZero() {
      runTest("compiler/testData/codegen/box/binaryOp/divisionByZero.kt");
    }

    @Test
    @TestMetadata("eqNullableDoubles.kt")
    public void testEqNullableDoubles() {
      runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoubles.kt");
    }

    @Test
    @TestMetadata("eqNullableDoublesToInt.kt")
    public void testEqNullableDoublesToInt() {
      runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesToInt.kt");
    }

    @Test
    @TestMetadata("eqNullableDoublesToIntWithTP.kt")
    public void testEqNullableDoublesToIntWithTP() {
      runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesToIntWithTP.kt");
    }

    @Test
    @TestMetadata("eqNullableDoublesWithTP.kt")
    public void testEqNullableDoublesWithTP() {
      runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesWithTP.kt");
    }

    @Test
    @TestMetadata("eqNullableShortToShort.kt")
    public void testEqNullableShortToShort() {
      runTest("compiler/testData/codegen/box/binaryOp/eqNullableShortToShort.kt");
    }

    @Test
    @TestMetadata("eqNullableToPrimitiveWithSideEffects.kt")
    public void testEqNullableToPrimitiveWithSideEffects() {
      runTest("compiler/testData/codegen/box/binaryOp/eqNullableToPrimitiveWithSideEffects.kt");
    }

    @Test
    @TestMetadata("intrinsic.kt")
    public void testIntrinsic() {
      runTest("compiler/testData/codegen/box/binaryOp/intrinsic.kt");
    }

    @Test
    @TestMetadata("intrinsicAny.kt")
    public void testIntrinsicAny() {
      runTest("compiler/testData/codegen/box/binaryOp/intrinsicAny.kt");
    }

    @Test
    @TestMetadata("intrinsicNullable.kt")
    public void testIntrinsicNullable() {
      runTest("compiler/testData/codegen/box/binaryOp/intrinsicNullable.kt");
    }

    @Test
    @TestMetadata("kt11163.kt")
    public void testKt11163() {
      runTest("compiler/testData/codegen/box/binaryOp/kt11163.kt");
    }

    @Test
    @TestMetadata("kt11163_properIeee754comparisons.kt")
    public void testKt11163_properIeee754comparisons() {
      runTest("compiler/testData/codegen/box/binaryOp/kt11163_properIeee754comparisons.kt");
    }

    @Test
    @TestMetadata("kt23030_properIeee754comparisons.kt")
    public void testKt23030_properIeee754comparisons() {
      runTest("compiler/testData/codegen/box/binaryOp/kt23030_properIeee754comparisons.kt");
    }

    @Test
    @TestMetadata("kt44402.kt")
    public void testKt44402() {
      runTest("compiler/testData/codegen/box/binaryOp/kt44402.kt");
    }

    @Test
    @TestMetadata("kt6747_identityEquals.kt")
    public void testKt6747_identityEquals() {
      runTest("compiler/testData/codegen/box/binaryOp/kt6747_identityEquals.kt");
    }

    @Test
    @TestMetadata("overflowChar.kt")
    public void testOverflowChar() {
      runTest("compiler/testData/codegen/box/binaryOp/overflowChar.kt");
    }

    @Test
    @TestMetadata("overflowInt.kt")
    public void testOverflowInt() {
      runTest("compiler/testData/codegen/box/binaryOp/overflowInt.kt");
    }

    @Test
    @TestMetadata("overflowLong.kt")
    public void testOverflowLong() {
      runTest("compiler/testData/codegen/box/binaryOp/overflowLong.kt");
    }

    @Test
    @TestMetadata("primitiveEqualsSafeCall.kt")
    public void testPrimitiveEqualsSafeCall() {
      runTest("compiler/testData/codegen/box/binaryOp/primitiveEqualsSafeCall.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/boxing")
  @TestDataPath("$PROJECT_ROOT")
  public class Boxing {
    @Test
    public void testAllFilesPresentInBoxing() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/boxing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("box_cache0.kt")
    public void testBox_cache0() {
      runTest("compiler/testData/codegen/box/boxing/box_cache0.kt");
    }

    @Test
    @TestMetadata("boxing0.kt")
    public void testBoxing0() {
      runTest("compiler/testData/codegen/box/boxing/boxing0.kt");
    }

    @Test
    @TestMetadata("boxing1.kt")
    public void testBoxing1() {
      runTest("compiler/testData/codegen/box/boxing/boxing1.kt");
    }

    @Test
    @TestMetadata("boxing10.kt")
    public void testBoxing10() {
      runTest("compiler/testData/codegen/box/boxing/boxing10.kt");
    }

    @Test
    @TestMetadata("boxing11.kt")
    public void testBoxing11() {
      runTest("compiler/testData/codegen/box/boxing/boxing11.kt");
    }

    @Test
    @TestMetadata("boxing12.kt")
    public void testBoxing12() {
      runTest("compiler/testData/codegen/box/boxing/boxing12.kt");
    }

    @Test
    @TestMetadata("boxing13.kt")
    public void testBoxing13() {
      runTest("compiler/testData/codegen/box/boxing/boxing13.kt");
    }

    @Test
    @TestMetadata("boxing14.kt")
    public void testBoxing14() {
      runTest("compiler/testData/codegen/box/boxing/boxing14.kt");
    }

    @Test
    @TestMetadata("boxing15.kt")
    public void testBoxing15() {
      runTest("compiler/testData/codegen/box/boxing/boxing15.kt");
    }

    @Test
    @TestMetadata("boxing2.kt")
    public void testBoxing2() {
      runTest("compiler/testData/codegen/box/boxing/boxing2.kt");
    }

    @Test
    @TestMetadata("boxing3.kt")
    public void testBoxing3() {
      runTest("compiler/testData/codegen/box/boxing/boxing3.kt");
    }

    @Test
    @TestMetadata("boxing4.kt")
    public void testBoxing4() {
      runTest("compiler/testData/codegen/box/boxing/boxing4.kt");
    }

    @Test
    @TestMetadata("boxing5.kt")
    public void testBoxing5() {
      runTest("compiler/testData/codegen/box/boxing/boxing5.kt");
    }

    @Test
    @TestMetadata("boxing6.kt")
    public void testBoxing6() {
      runTest("compiler/testData/codegen/box/boxing/boxing6.kt");
    }

    @Test
    @TestMetadata("boxing7.kt")
    public void testBoxing7() {
      runTest("compiler/testData/codegen/box/boxing/boxing7.kt");
    }

    @Test
    @TestMetadata("boxing8.kt")
    public void testBoxing8() {
      runTest("compiler/testData/codegen/box/boxing/boxing8.kt");
    }

    @Test
    @TestMetadata("boxing9.kt")
    public void testBoxing9() {
      runTest("compiler/testData/codegen/box/boxing/boxing9.kt");
    }

    @Test
    @TestMetadata("kt53100_casts.kt")
    public void testKt53100_casts() {
      runTest("compiler/testData/codegen/box/boxing/kt53100_casts.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/boxingOptimization")
  @TestDataPath("$PROJECT_ROOT")
  public class BoxingOptimization {
    @Test
    public void testAllFilesPresentInBoxingOptimization() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("boxedBooleanIdentity.kt")
    public void testBoxedBooleanIdentity() {
      runTest("compiler/testData/codegen/box/boxingOptimization/boxedBooleanIdentity.kt");
    }

    @Test
    @TestMetadata("boxedIntegersCmp.kt")
    public void testBoxedIntegersCmp() {
      runTest("compiler/testData/codegen/box/boxingOptimization/boxedIntegersCmp.kt");
    }

    @Test
    @TestMetadata("boxedPrimitivesAreEqual.kt")
    public void testBoxedPrimitivesAreEqual() {
      runTest("compiler/testData/codegen/box/boxingOptimization/boxedPrimitivesAreEqual.kt");
    }

    @Test
    @TestMetadata("boxedRealsCmp.kt")
    public void testBoxedRealsCmp() {
      runTest("compiler/testData/codegen/box/boxingOptimization/boxedRealsCmp.kt");
    }

    @Test
    @TestMetadata("casts.kt")
    public void testCasts() {
      runTest("compiler/testData/codegen/box/boxingOptimization/casts.kt");
    }

    @Test
    @TestMetadata("checkcastAndInstanceOf.kt")
    public void testCheckcastAndInstanceOf() {
      runTest("compiler/testData/codegen/box/boxingOptimization/checkcastAndInstanceOf.kt");
    }

    @Test
    @TestMetadata("checkcastAndInstanceOf2.kt")
    public void testCheckcastAndInstanceOf2() {
      runTest("compiler/testData/codegen/box/boxingOptimization/checkcastAndInstanceOf2.kt");
    }

    @Test
    @TestMetadata("explicitEqualsOnDouble.kt")
    public void testExplicitEqualsOnDouble() {
      runTest("compiler/testData/codegen/box/boxingOptimization/explicitEqualsOnDouble.kt");
    }

    @Test
    @TestMetadata("fold.kt")
    public void testFold() {
      runTest("compiler/testData/codegen/box/boxingOptimization/fold.kt");
    }

    @Test
    @TestMetadata("foldRange.kt")
    public void testFoldRange() {
      runTest("compiler/testData/codegen/box/boxingOptimization/foldRange.kt");
    }

    @Test
    @TestMetadata("intCompareTo.kt")
    public void testIntCompareTo() {
      runTest("compiler/testData/codegen/box/boxingOptimization/intCompareTo.kt");
    }

    @Test
    @TestMetadata("kClassEquals.kt")
    public void testKClassEquals() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kClassEquals.kt");
    }

    @Test
    @TestMetadata("kt15871.kt")
    public void testKt15871() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt15871.kt");
    }

    @Test
    @TestMetadata("kt17748.kt")
    public void testKt17748() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt17748.kt");
    }

    @Test
    @TestMetadata("kt19767.kt")
    public void testKt19767() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt19767.kt");
    }

    @Test
    @TestMetadata("kt19767_2.kt")
    public void testKt19767_2() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_2.kt");
    }

    @Test
    @TestMetadata("kt19767_3.kt")
    public void testKt19767_3() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_3.kt");
    }

    @Test
    @TestMetadata("kt19767_chain.kt")
    public void testKt19767_chain() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_chain.kt");
    }

    @Test
    @TestMetadata("kt46859.kt")
    public void testKt46859() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt46859.kt");
    }

    @Test
    @TestMetadata("kt48394.kt")
    public void testKt48394() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt48394.kt");
    }

    @Test
    @TestMetadata("kt49092a.kt")
    public void testKt49092a() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt49092a.kt");
    }

    @Test
    @TestMetadata("kt49092b.kt")
    public void testKt49092b() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt49092b.kt");
    }

    @Test
    @TestMetadata("kt49092c.kt")
    public void testKt49092c() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt49092c.kt");
    }

    @Test
    @TestMetadata("kt49092d.kt")
    public void testKt49092d() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt49092d.kt");
    }

    @Test
    @TestMetadata("kt49092e.kt")
    public void testKt49092e() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt49092e.kt");
    }

    @Test
    @TestMetadata("kt49092f.kt")
    public void testKt49092f() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt49092f.kt");
    }

    @Test
    @TestMetadata("kt49548.kt")
    public void testKt49548() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt49548.kt");
    }

    @Test
    @TestMetadata("kt49548a.kt")
    public void testKt49548a() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt49548a.kt");
    }

    @Test
    @TestMetadata("kt5493.kt")
    public void testKt5493() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt5493.kt");
    }

    @Test
    @TestMetadata("kt5588.kt")
    public void testKt5588() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt5588.kt");
    }

    @Test
    @TestMetadata("kt5844.kt")
    public void testKt5844() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt5844.kt");
    }

    @Test
    @TestMetadata("kt6047.kt")
    public void testKt6047() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt6047.kt");
    }

    @Test
    @TestMetadata("kt6842.kt")
    public void testKt6842() {
      runTest("compiler/testData/codegen/box/boxingOptimization/kt6842.kt");
    }

    @Test
    @TestMetadata("maxMinByOrNull.kt")
    public void testMaxMinByOrNull() {
      runTest("compiler/testData/codegen/box/boxingOptimization/maxMinByOrNull.kt");
    }

    @Test
    @TestMetadata("nullCheck.kt")
    public void testNullCheck() {
      runTest("compiler/testData/codegen/box/boxingOptimization/nullCheck.kt");
    }

    @Test
    @TestMetadata("progressions.kt")
    public void testProgressions() {
      runTest("compiler/testData/codegen/box/boxingOptimization/progressions.kt");
    }

    @Test
    @TestMetadata("safeCallWithElvis.kt")
    public void testSafeCallWithElvis() {
      runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvis.kt");
    }

    @Test
    @TestMetadata("safeCallWithElvisAndEnhancedNullability.kt")
    public void testSafeCallWithElvisAndEnhancedNullability() {
      runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvisAndEnhancedNullability.kt");
    }

    @Test
    @TestMetadata("safeCallWithElvisMultipleFiles.kt")
    public void testSafeCallWithElvisMultipleFiles() {
      runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/boxingOptimization/simple.kt");
    }

    @Test
    @TestMetadata("simpleUninitializedMerge.kt")
    public void testSimpleUninitializedMerge() {
      runTest("compiler/testData/codegen/box/boxingOptimization/simpleUninitializedMerge.kt");
    }

    @Test
    @TestMetadata("taintedValues.kt")
    public void testTaintedValues() {
      runTest("compiler/testData/codegen/box/boxingOptimization/taintedValues.kt");
    }

    @Test
    @TestMetadata("taintedValuesBox.kt")
    public void testTaintedValuesBox() {
      runTest("compiler/testData/codegen/box/boxingOptimization/taintedValuesBox.kt");
    }

    @Test
    @TestMetadata("unsafeRemoving.kt")
    public void testUnsafeRemoving() {
      runTest("compiler/testData/codegen/box/boxingOptimization/unsafeRemoving.kt");
    }

    @Test
    @TestMetadata("unsignedArrayForEach.kt")
    public void testUnsignedArrayForEach() {
      runTest("compiler/testData/codegen/box/boxingOptimization/unsignedArrayForEach.kt");
    }

    @Test
    @TestMetadata("variables.kt")
    public void testVariables() {
      runTest("compiler/testData/codegen/box/boxingOptimization/variables.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/branching")
  @TestDataPath("$PROJECT_ROOT")
  public class Branching {
    @Test
    @TestMetadata("advanced_when2.kt")
    public void testAdvanced_when2() {
      runTest("compiler/testData/codegen/box/branching/advanced_when2.kt");
    }

    @Test
    @TestMetadata("advanced_when5.kt")
    public void testAdvanced_when5() {
      runTest("compiler/testData/codegen/box/branching/advanced_when5.kt");
    }

    @Test
    public void testAllFilesPresentInBranching() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/branching"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("if_else.kt")
    public void testIf_else() {
      runTest("compiler/testData/codegen/box/branching/if_else.kt");
    }

    @Test
    @TestMetadata("when2.kt")
    public void testWhen2() {
      runTest("compiler/testData/codegen/box/branching/when2.kt");
    }

    @Test
    @TestMetadata("when4.kt")
    public void testWhen4() {
      runTest("compiler/testData/codegen/box/branching/when4.kt");
    }

    @Test
    @TestMetadata("when5.kt")
    public void testWhen5() {
      runTest("compiler/testData/codegen/box/branching/when5.kt");
    }

    @Test
    @TestMetadata("when6.kt")
    public void testWhen6() {
      runTest("compiler/testData/codegen/box/branching/when6.kt");
    }

    @Test
    @TestMetadata("when7.kt")
    public void testWhen7() {
      runTest("compiler/testData/codegen/box/branching/when7.kt");
    }

    @Test
    @TestMetadata("when8.kt")
    public void testWhen8() {
      runTest("compiler/testData/codegen/box/branching/when8.kt");
    }

    @Test
    @TestMetadata("when9.kt")
    public void testWhen9() {
      runTest("compiler/testData/codegen/box/branching/when9.kt");
    }

    @Test
    @TestMetadata("when_through.kt")
    public void testWhen_through() {
      runTest("compiler/testData/codegen/box/branching/when_through.kt");
    }

    @Test
    @TestMetadata("when_with_try1.kt")
    public void testWhen_with_try1() {
      runTest("compiler/testData/codegen/box/branching/when_with_try1.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/bridges")
  @TestDataPath("$PROJECT_ROOT")
  public class Bridges {
    @Test
    @TestMetadata("abstractOverrideBridge.kt")
    public void testAbstractOverrideBridge() {
      runTest("compiler/testData/codegen/box/bridges/abstractOverrideBridge.kt");
    }

    @Test
    public void testAllFilesPresentInBridges() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("bridgeInInterface.kt")
    public void testBridgeInInterface() {
      runTest("compiler/testData/codegen/box/bridges/bridgeInInterface.kt");
    }

    @Test
    @TestMetadata("bridgeInInterfaceWithProperties.kt")
    public void testBridgeInInterfaceWithProperties() {
      runTest("compiler/testData/codegen/box/bridges/bridgeInInterfaceWithProperties.kt");
    }

    @Test
    @TestMetadata("complexMultiInheritance.kt")
    public void testComplexMultiInheritance() {
      runTest("compiler/testData/codegen/box/bridges/complexMultiInheritance.kt");
    }

    @Test
    @TestMetadata("complexTraitImpl.kt")
    public void testComplexTraitImpl() {
      runTest("compiler/testData/codegen/box/bridges/complexTraitImpl.kt");
    }

    @Test
    @TestMetadata("covariantGenericDiamond.kt")
    public void testCovariantGenericDiamond() {
      runTest("compiler/testData/codegen/box/bridges/covariantGenericDiamond.kt");
    }

    @Test
    @TestMetadata("delegation.kt")
    public void testDelegation() {
      runTest("compiler/testData/codegen/box/bridges/delegation.kt");
    }

    @Test
    @TestMetadata("delegationComplex.kt")
    public void testDelegationComplex() {
      runTest("compiler/testData/codegen/box/bridges/delegationComplex.kt");
    }

    @Test
    @TestMetadata("delegationComplexWithList.kt")
    public void testDelegationComplexWithList() {
      runTest("compiler/testData/codegen/box/bridges/delegationComplexWithList.kt");
    }

    @Test
    @TestMetadata("delegationProperty.kt")
    public void testDelegationProperty() {
      runTest("compiler/testData/codegen/box/bridges/delegationProperty.kt");
    }

    @Test
    @TestMetadata("diamond.kt")
    public void testDiamond() {
      runTest("compiler/testData/codegen/box/bridges/diamond.kt");
    }

    @Test
    @TestMetadata("fakeCovariantOverride.kt")
    public void testFakeCovariantOverride() {
      runTest("compiler/testData/codegen/box/bridges/fakeCovariantOverride.kt");
    }

    @Test
    @TestMetadata("fakeGenericCovariantOverride.kt")
    public void testFakeGenericCovariantOverride() {
      runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverride.kt");
    }

    @Test
    @TestMetadata("fakeGenericCovariantOverrideWithDelegation.kt")
    public void testFakeGenericCovariantOverrideWithDelegation() {
      runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverrideWithDelegation.kt");
    }

    @Test
    @TestMetadata("fakeOverrideFromInterfaceThroughIntermediateClass.kt")
    public void testFakeOverrideFromInterfaceThroughIntermediateClass() {
      runTest("compiler/testData/codegen/box/bridges/fakeOverrideFromInterfaceThroughIntermediateClass.kt");
    }

    @Test
    @TestMetadata("fakeOverrideMultiFile.kt")
    public void testFakeOverrideMultiFile() {
      runTest("compiler/testData/codegen/box/bridges/fakeOverrideMultiFile.kt");
    }

    @Test
    @TestMetadata("fakeOverrideOfTraitImpl.kt")
    public void testFakeOverrideOfTraitImpl() {
      runTest("compiler/testData/codegen/box/bridges/fakeOverrideOfTraitImpl.kt");
    }

    @Test
    @TestMetadata("fakeOverrideThroughGenericSuperclass.kt")
    public void testFakeOverrideThroughGenericSuperclass() {
      runTest("compiler/testData/codegen/box/bridges/fakeOverrideThroughGenericSuperclass.kt");
    }

    @Test
    @TestMetadata("fakeOverrideWithSeveralSuperDeclarations.kt")
    public void testFakeOverrideWithSeveralSuperDeclarations() {
      runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSeveralSuperDeclarations.kt");
    }

    @Test
    @TestMetadata("fakeOverrideWithSynthesizedImplementation.kt")
    public void testFakeOverrideWithSynthesizedImplementation() {
      runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSynthesizedImplementation.kt");
    }

    @Test
    @TestMetadata("genericProperty.kt")
    public void testGenericProperty() {
      runTest("compiler/testData/codegen/box/bridges/genericProperty.kt");
    }

    @Test
    @TestMetadata("innerClassTypeParameters.kt")
    public void testInnerClassTypeParameters() {
      runTest("compiler/testData/codegen/box/bridges/innerClassTypeParameters.kt");
    }

    @Test
    @TestMetadata("internalMethodFakeOverrideInFriendModule.kt")
    public void testInternalMethodFakeOverrideInFriendModule() {
      runTest("compiler/testData/codegen/box/bridges/internalMethodFakeOverrideInFriendModule.kt");
    }

    @Test
    @TestMetadata("internalMethodOverrideInFriendModule.kt")
    public void testInternalMethodOverrideInFriendModule() {
      runTest("compiler/testData/codegen/box/bridges/internalMethodOverrideInFriendModule.kt");
    }

    @Test
    @TestMetadata("internalMethodOverrideInOtherModule.kt")
    public void testInternalMethodOverrideInOtherModule() {
      runTest("compiler/testData/codegen/box/bridges/internalMethodOverrideInOtherModule.kt");
    }

    @Test
    @TestMetadata("internalMethodOverrideMultipleInheritance.kt")
    public void testInternalMethodOverrideMultipleInheritance() {
      runTest("compiler/testData/codegen/box/bridges/internalMethodOverrideMultipleInheritance.kt");
    }

    @Test
    @TestMetadata("internalMethodOverridePublishedApi.kt")
    public void testInternalMethodOverridePublishedApi() {
      runTest("compiler/testData/codegen/box/bridges/internalMethodOverridePublishedApi.kt");
    }

    @Test
    @TestMetadata("kt12416.kt")
    public void testKt12416() {
      runTest("compiler/testData/codegen/box/bridges/kt12416.kt");
    }

    @Test
    @TestMetadata("kt1939.kt")
    public void testKt1939() {
      runTest("compiler/testData/codegen/box/bridges/kt1939.kt");
    }

    @Test
    @TestMetadata("kt1959.kt")
    public void testKt1959() {
      runTest("compiler/testData/codegen/box/bridges/kt1959.kt");
    }

    @Test
    @TestMetadata("kt24193.kt")
    public void testKt24193() {
      runTest("compiler/testData/codegen/box/bridges/kt24193.kt");
    }

    @Test
    @TestMetadata("kt2498.kt")
    public void testKt2498() {
      runTest("compiler/testData/codegen/box/bridges/kt2498.kt");
    }

    @Test
    @TestMetadata("kt2702.kt")
    public void testKt2702() {
      runTest("compiler/testData/codegen/box/bridges/kt2702.kt");
    }

    @Test
    @TestMetadata("kt2833.kt")
    public void testKt2833() {
      runTest("compiler/testData/codegen/box/bridges/kt2833.kt");
    }

    @Test
    @TestMetadata("kt2920.kt")
    public void testKt2920() {
      runTest("compiler/testData/codegen/box/bridges/kt2920.kt");
    }

    @Test
    @TestMetadata("kt318.kt")
    public void testKt318() {
      runTest("compiler/testData/codegen/box/bridges/kt318.kt");
    }

    @Test
    @TestMetadata("kt42137.kt")
    public void testKt42137() {
      runTest("compiler/testData/codegen/box/bridges/kt42137.kt");
    }

    @Test
    @TestMetadata("kt46389.kt")
    public void testKt46389() {
      runTest("compiler/testData/codegen/box/bridges/kt46389.kt");
    }

    @Test
    @TestMetadata("kt46389_jvmDefault.kt")
    public void testKt46389_jvmDefault() {
      runTest("compiler/testData/codegen/box/bridges/kt46389_jvmDefault.kt");
    }

    @Test
    @TestMetadata("kt52929.kt")
    public void testKt52929() {
      runTest("compiler/testData/codegen/box/bridges/kt52929.kt");
    }

    @Test
    @TestMetadata("kt52929_platformDependent.kt")
    public void testKt52929_platformDependent() {
      runTest("compiler/testData/codegen/box/bridges/kt52929_platformDependent.kt");
    }

    @Test
    @TestMetadata("kt74377.kt")
    public void testKt74377() {
      runTest("compiler/testData/codegen/box/bridges/kt74377.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("longChainOneBridge.kt")
    public void testLongChainOneBridge() {
      runTest("compiler/testData/codegen/box/bridges/longChainOneBridge.kt");
    }

    @Test
    @TestMetadata("manyTypeArgumentsSubstitutedSuccessively.kt")
    public void testManyTypeArgumentsSubstitutedSuccessively() {
      runTest("compiler/testData/codegen/box/bridges/manyTypeArgumentsSubstitutedSuccessively.kt");
    }

    @Test
    @TestMetadata("methodFromTrait.kt")
    public void testMethodFromTrait() {
      runTest("compiler/testData/codegen/box/bridges/methodFromTrait.kt");
    }

    @Test
    @TestMetadata("methodWithDefaultParameter.kt")
    public void testMethodWithDefaultParameter() {
      runTest("compiler/testData/codegen/box/bridges/methodWithDefaultParameter.kt");
    }

    @Test
    @TestMetadata("multipleModules1.kt")
    public void testMultipleModules1() {
      runTest("compiler/testData/codegen/box/bridges/multipleModules1.kt");
    }

    @Test
    @TestMetadata("multipleModules2.kt")
    public void testMultipleModules2() {
      runTest("compiler/testData/codegen/box/bridges/multipleModules2.kt");
    }

    @Test
    @TestMetadata("nestedClassTypeParameters.kt")
    public void testNestedClassTypeParameters() {
      runTest("compiler/testData/codegen/box/bridges/nestedClassTypeParameters.kt");
    }

    @Test
    @TestMetadata("noBridgeOnMutableCollectionInheritance.kt")
    public void testNoBridgeOnMutableCollectionInheritance() {
      runTest("compiler/testData/codegen/box/bridges/noBridgeOnMutableCollectionInheritance.kt");
    }

    @Test
    @TestMetadata("objectClone.kt")
    public void testObjectClone() {
      runTest("compiler/testData/codegen/box/bridges/objectClone.kt");
    }

    @Test
    @TestMetadata("overrideAbstractProperty.kt")
    public void testOverrideAbstractProperty() {
      runTest("compiler/testData/codegen/box/bridges/overrideAbstractProperty.kt");
    }

    @Test
    @TestMetadata("overrideReturnType.kt")
    public void testOverrideReturnType() {
      runTest("compiler/testData/codegen/box/bridges/overrideReturnType.kt");
    }

    @Test
    @TestMetadata("overrideWithValueClassReturn.kt")
    public void testOverrideWithValueClassReturn() {
      runTest("compiler/testData/codegen/box/bridges/overrideWithValueClassReturn.kt");
    }

    @Test
    @TestMetadata("propertyAccessorsWithoutBody.kt")
    public void testPropertyAccessorsWithoutBody() {
      runTest("compiler/testData/codegen/box/bridges/propertyAccessorsWithoutBody.kt");
    }

    @Test
    @TestMetadata("propertyDiamond.kt")
    public void testPropertyDiamond() {
      runTest("compiler/testData/codegen/box/bridges/propertyDiamond.kt");
    }

    @Test
    @TestMetadata("propertyDiamondFakeOverride.kt")
    public void testPropertyDiamondFakeOverride() {
      runTest("compiler/testData/codegen/box/bridges/propertyDiamondFakeOverride.kt");
    }

    @Test
    @TestMetadata("propertyInConstructor.kt")
    public void testPropertyInConstructor() {
      runTest("compiler/testData/codegen/box/bridges/propertyInConstructor.kt");
    }

    @Test
    @TestMetadata("propertySetter.kt")
    public void testPropertySetter() {
      runTest("compiler/testData/codegen/box/bridges/propertySetter.kt");
    }

    @Test
    @TestMetadata("returnTypeSignature.kt")
    public void testReturnTypeSignature() {
      runTest("compiler/testData/codegen/box/bridges/returnTypeSignature.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/bridges/simple.kt");
    }

    @Test
    @TestMetadata("simpleEnum.kt")
    public void testSimpleEnum() {
      runTest("compiler/testData/codegen/box/bridges/simpleEnum.kt");
    }

    @Test
    @TestMetadata("simpleGenericMethod.kt")
    public void testSimpleGenericMethod() {
      runTest("compiler/testData/codegen/box/bridges/simpleGenericMethod.kt");
    }

    @Test
    @TestMetadata("simpleObject.kt")
    public void testSimpleObject() {
      runTest("compiler/testData/codegen/box/bridges/simpleObject.kt");
    }

    @Test
    @TestMetadata("simpleReturnType.kt")
    public void testSimpleReturnType() {
      runTest("compiler/testData/codegen/box/bridges/simpleReturnType.kt");
    }

    @Test
    @TestMetadata("simpleTraitImpl.kt")
    public void testSimpleTraitImpl() {
      runTest("compiler/testData/codegen/box/bridges/simpleTraitImpl.kt");
    }

    @Test
    @TestMetadata("simpleUpperBound.kt")
    public void testSimpleUpperBound() {
      runTest("compiler/testData/codegen/box/bridges/simpleUpperBound.kt");
    }

    @Test
    @TestMetadata("special.kt")
    public void testSpecial() {
      runTest("compiler/testData/codegen/box/bridges/special.kt");
    }

    @Test
    @TestMetadata("specialBridgeTypesJava.kt")
    public void testSpecialBridgeTypesJava() {
      runTest("compiler/testData/codegen/box/bridges/specialBridgeTypesJava.kt");
    }

    @Test
    @TestMetadata("specialGeneric.kt")
    public void testSpecialGeneric() {
      runTest("compiler/testData/codegen/box/bridges/specialGeneric.kt");
    }

    @Test
    @TestMetadata("strListContains.kt")
    public void testStrListContains() {
      runTest("compiler/testData/codegen/box/bridges/strListContains.kt");
    }

    @Test
    @TestMetadata("strListRemove.kt")
    public void testStrListRemove() {
      runTest("compiler/testData/codegen/box/bridges/strListRemove.kt");
    }

    @Test
    @TestMetadata("test0.kt")
    public void testTest0() {
      runTest("compiler/testData/codegen/box/bridges/test0.kt");
    }

    @Test
    @TestMetadata("test1.kt")
    public void testTest1() {
      runTest("compiler/testData/codegen/box/bridges/test1.kt");
    }

    @Test
    @TestMetadata("test10.kt")
    public void testTest10() {
      runTest("compiler/testData/codegen/box/bridges/test10.kt");
    }

    @Test
    @TestMetadata("test11.kt")
    public void testTest11() {
      runTest("compiler/testData/codegen/box/bridges/test11.kt");
    }

    @Test
    @TestMetadata("test12.kt")
    public void testTest12() {
      runTest("compiler/testData/codegen/box/bridges/test12.kt");
    }

    @Test
    @TestMetadata("test13.kt")
    public void testTest13() {
      runTest("compiler/testData/codegen/box/bridges/test13.kt");
    }

    @Test
    @TestMetadata("test14.kt")
    public void testTest14() {
      runTest("compiler/testData/codegen/box/bridges/test14.kt");
    }

    @Test
    @TestMetadata("test15.kt")
    public void testTest15() {
      runTest("compiler/testData/codegen/box/bridges/test15.kt");
    }

    @Test
    @TestMetadata("test16.kt")
    public void testTest16() {
      runTest("compiler/testData/codegen/box/bridges/test16.kt");
    }

    @Test
    @TestMetadata("test17.kt")
    public void testTest17() {
      runTest("compiler/testData/codegen/box/bridges/test17.kt");
    }

    @Test
    @TestMetadata("test18.kt")
    public void testTest18() {
      runTest("compiler/testData/codegen/box/bridges/test18.kt");
    }

    @Test
    @TestMetadata("test19.kt")
    public void testTest19() {
      runTest("compiler/testData/codegen/box/bridges/test19.kt");
    }

    @Test
    @TestMetadata("test2.kt")
    public void testTest2() {
      runTest("compiler/testData/codegen/box/bridges/test2.kt");
    }

    @Test
    @TestMetadata("test20.kt")
    public void testTest20() {
      runTest("compiler/testData/codegen/box/bridges/test20.kt");
    }

    @Test
    @TestMetadata("test21.kt")
    public void testTest21() {
      runTest("compiler/testData/codegen/box/bridges/test21.kt");
    }

    @Test
    @TestMetadata("test22.kt")
    public void testTest22() {
      runTest("compiler/testData/codegen/box/bridges/test22.kt");
    }

    @Test
    @TestMetadata("test23.kt")
    public void testTest23() {
      runTest("compiler/testData/codegen/box/bridges/test23.kt");
    }

    @Test
    @TestMetadata("test24.kt")
    public void testTest24() {
      runTest("compiler/testData/codegen/box/bridges/test24.kt");
    }

    @Test
    @TestMetadata("test25.kt")
    public void testTest25() {
      runTest("compiler/testData/codegen/box/bridges/test25.kt");
    }

    @Test
    @TestMetadata("test3.kt")
    public void testTest3() {
      runTest("compiler/testData/codegen/box/bridges/test3.kt");
    }

    @Test
    @TestMetadata("test4.kt")
    public void testTest4() {
      runTest("compiler/testData/codegen/box/bridges/test4.kt");
    }

    @Test
    @TestMetadata("test5.kt")
    public void testTest5() {
      runTest("compiler/testData/codegen/box/bridges/test5.kt");
    }

    @Test
    @TestMetadata("test6.kt")
    public void testTest6() {
      runTest("compiler/testData/codegen/box/bridges/test6.kt");
    }

    @Test
    @TestMetadata("test7.kt")
    public void testTest7() {
      runTest("compiler/testData/codegen/box/bridges/test7.kt");
    }

    @Test
    @TestMetadata("test8.kt")
    public void testTest8() {
      runTest("compiler/testData/codegen/box/bridges/test8.kt");
    }

    @Test
    @TestMetadata("test9.kt")
    public void testTest9() {
      runTest("compiler/testData/codegen/box/bridges/test9.kt");
    }

    @Test
    @TestMetadata("traitImplInheritsTraitImpl.kt")
    public void testTraitImplInheritsTraitImpl() {
      runTest("compiler/testData/codegen/box/bridges/traitImplInheritsTraitImpl.kt");
    }

    @Test
    @TestMetadata("twoParentsWithDifferentMethodsTwoBridges.kt")
    public void testTwoParentsWithDifferentMethodsTwoBridges() {
      runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges.kt");
    }

    @Test
    @TestMetadata("twoParentsWithDifferentMethodsTwoBridges2.kt")
    public void testTwoParentsWithDifferentMethodsTwoBridges2() {
      runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges2.kt");
    }

    @Test
    @TestMetadata("twoParentsWithTheSameMethodOneBridge.kt")
    public void testTwoParentsWithTheSameMethodOneBridge() {
      runTest("compiler/testData/codegen/box/bridges/twoParentsWithTheSameMethodOneBridge.kt");
    }

    @Test
    @TestMetadata("typeParameterInExtensionReceiver.kt")
    public void testTypeParameterInExtensionReceiver() {
      runTest("compiler/testData/codegen/box/bridges/typeParameterInExtensionReceiver.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass")
    @TestDataPath("$PROJECT_ROOT")
    public class SubstitutionInSuperClass {
      @Test
      @TestMetadata("abstractFun.kt")
      public void testAbstractFun() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/abstractFun.kt");
      }

      @Test
      public void testAllFilesPresentInSubstitutionInSuperClass() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bridges/substitutionInSuperClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("boundedTypeArguments.kt")
      public void testBoundedTypeArguments() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/boundedTypeArguments.kt");
      }

      @Test
      @TestMetadata("delegation.kt")
      public void testDelegation() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/delegation.kt");
      }

      @Test
      @TestMetadata("differentErasureInSuperClass.kt")
      public void testDifferentErasureInSuperClass() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClass.kt");
      }

      @Test
      @TestMetadata("differentErasureInSuperClassComplex.kt")
      public void testDifferentErasureInSuperClassComplex() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClassComplex.kt");
      }

      @Test
      @TestMetadata("enum.kt")
      public void testEnum() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/enum.kt");
      }

      @Test
      @TestMetadata("genericMethod.kt")
      public void testGenericMethod() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/genericMethod.kt");
      }

      @Test
      @TestMetadata("object.kt")
      public void testObject() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/object.kt");
      }

      @Test
      @TestMetadata("property.kt")
      public void testProperty() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/property.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/simple.kt");
      }

      @Test
      @TestMetadata("upperBound.kt")
      public void testUpperBound() {
        runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/upperBound.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/builtinStubMethods")
  @TestDataPath("$PROJECT_ROOT")
  public class BuiltinStubMethods {
    @Test
    @TestMetadata("abstractMember.kt")
    public void testAbstractMember() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/abstractMember.kt");
    }

    @Test
    public void testAllFilesPresentInBuiltinStubMethods() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("Collection.kt")
    public void testCollection() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/Collection.kt");
    }

    @Test
    @TestMetadata("customReadOnlyIterator.kt")
    public void testCustomReadOnlyIterator() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/customReadOnlyIterator.kt");
    }

    @Test
    @TestMetadata("delegationToArrayList.kt")
    public void testDelegationToArrayList() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/delegationToArrayList.kt");
    }

    @Test
    @TestMetadata("immutableRemove.kt")
    public void testImmutableRemove() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/immutableRemove.kt");
    }

    @Test
    @TestMetadata("implementationInTrait.kt")
    public void testImplementationInTrait() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/implementationInTrait.kt");
    }

    @Test
    @TestMetadata("inheritedImplementations.kt")
    public void testInheritedImplementations() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/inheritedImplementations.kt");
    }

    @Test
    @TestMetadata("int2IntMap.kt")
    public void testInt2IntMap() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/int2IntMap.kt");
    }

    @Test
    @TestMetadata("Iterator.kt")
    public void testIterator() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/Iterator.kt");
    }

    @Test
    @TestMetadata("IteratorWithRemove.kt")
    public void testIteratorWithRemove() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/IteratorWithRemove.kt");
    }

    @Test
    @TestMetadata("List.kt")
    public void testList() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/List.kt");
    }

    @Test
    @TestMetadata("ListIterator.kt")
    public void testListIterator() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/ListIterator.kt");
    }

    @Test
    @TestMetadata("ListWithAllImplementations.kt")
    public void testListWithAllImplementations() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/ListWithAllImplementations.kt");
    }

    @Test
    @TestMetadata("ListWithAllInheritedImplementations.kt")
    public void testListWithAllInheritedImplementations() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/ListWithAllInheritedImplementations.kt");
    }

    @Test
    @TestMetadata("manyTypeParametersWithUpperBounds.kt")
    public void testManyTypeParametersWithUpperBounds() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/manyTypeParametersWithUpperBounds.kt");
    }

    @Test
    @TestMetadata("Map.kt")
    public void testMap() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/Map.kt");
    }

    @Test
    @TestMetadata("MapEntry.kt")
    public void testMapEntry() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/MapEntry.kt");
    }

    @Test
    @TestMetadata("MapEntryWithSetValue.kt")
    public void testMapEntryWithSetValue() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/MapEntryWithSetValue.kt");
    }

    @Test
    @TestMetadata("MapWithAllImplementations.kt")
    public void testMapWithAllImplementations() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/MapWithAllImplementations.kt");
    }

    @Test
    @TestMetadata("nonTrivialSubstitution.kt")
    public void testNonTrivialSubstitution() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/nonTrivialSubstitution.kt");
    }

    @Test
    @TestMetadata("nonTrivialUpperBound.kt")
    public void testNonTrivialUpperBound() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/nonTrivialUpperBound.kt");
    }

    @Test
    @TestMetadata("substitutedIterable.kt")
    public void testSubstitutedIterable() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/substitutedIterable.kt");
    }

    @Test
    @TestMetadata("SubstitutedList.kt")
    public void testSubstitutedList() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/SubstitutedList.kt");
    }

    @Test
    @TestMetadata("substitutedListWithExtraSuperInterface.kt")
    public void testSubstitutedListWithExtraSuperInterface() {
      runTest("compiler/testData/codegen/box/builtinStubMethods/substitutedListWithExtraSuperInterface.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs")
    @TestDataPath("$PROJECT_ROOT")
    public class BridgesForStubs {
      @Test
      public void testAllFilesPresentInBridgesForStubs() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("derivedEmptyListAdd.kt")
      public void testDerivedEmptyListAdd() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyListAdd.kt");
      }

      @Test
      @TestMetadata("derivedEmptyListSeveralModulesAdd.kt")
      public void testDerivedEmptyListSeveralModulesAdd() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyListSeveralModulesAdd.kt");
      }

      @Test
      @TestMetadata("derivedEmptyStringListAdd.kt")
      public void testDerivedEmptyStringListAdd() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyStringListAdd.kt");
      }

      @Test
      @TestMetadata("emptyListAdd.kt")
      public void testEmptyListAdd() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListAdd.kt");
      }

      @Test
      @TestMetadata("emptyListAddWithIndex.kt")
      public void testEmptyListAddWithIndex() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListAddWithIndex.kt");
      }

      @Test
      @TestMetadata("emptyListSet.kt")
      public void testEmptyListSet() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListSet.kt");
      }

      @Test
      @TestMetadata("emptyStringListAdd.kt")
      public void testEmptyStringListAdd() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyStringListAdd.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class ExtendJavaClasses {
      @Test
      @TestMetadata("abstractList.kt")
      public void testAbstractList() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractList.kt");
      }

      @Test
      @TestMetadata("abstractMap.kt")
      public void testAbstractMap() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractMap.kt");
      }

      @Test
      @TestMetadata("abstractSet.kt")
      public void testAbstractSet() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractSet.kt");
      }

      @Test
      public void testAllFilesPresentInExtendJavaClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayList.kt")
      public void testArrayList() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/arrayList.kt");
      }

      @Test
      @TestMetadata("charSequenceGetOverriddenInJavaSuperClass.kt")
      public void testCharSequenceGetOverriddenInJavaSuperClass() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/charSequenceGetOverriddenInJavaSuperClass.kt");
      }

      @Test
      @TestMetadata("extendArrayListThroughKotlin.kt")
      public void testExtendArrayListThroughKotlin() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/extendArrayListThroughKotlin.kt");
      }

      @Test
      @TestMetadata("hashMap.kt")
      public void testHashMap() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/hashMap.kt");
      }

      @Test
      @TestMetadata("hashSet.kt")
      public void testHashSet() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/hashSet.kt");
      }

      @Test
      @TestMetadata("kt61548.kt")
      public void testKt61548() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/kt61548.kt");
      }

      @Test
      @TestMetadata("mapEntry.kt")
      public void testMapEntry() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/mapEntry.kt");
      }

      @Test
      @TestMetadata("numberMixedHierarchy.kt")
      public void testNumberMixedHierarchy() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/numberMixedHierarchy.kt");
      }

      @Test
      @TestMetadata("overrideAbstractSetMethod.kt")
      public void testOverrideAbstractSetMethod() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/overrideAbstractSetMethod.kt");
      }

      @Test
      @TestMetadata("removeAtBridgeToJavaClass.kt")
      public void testRemoveAtBridgeToJavaClass() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaClass.kt");
      }

      @Test
      @TestMetadata("removeAtBridgeToJavaDefault.kt")
      public void testRemoveAtBridgeToJavaDefault() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaDefault.kt");
      }

      @Test
      @TestMetadata("removeAtBridgeToJavaSuperClass.kt")
      public void testRemoveAtBridgeToJavaSuperClass() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaSuperClass.kt");
      }

      @Test
      @TestMetadata("superCallToFakeRemoveAt.kt")
      public void testSuperCallToFakeRemoveAt() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToFakeRemoveAt.kt");
      }

      @Test
      @TestMetadata("superCallToRemoveAt.kt")
      public void testSuperCallToRemoveAt() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToRemoveAt.kt");
      }

      @Test
      @TestMetadata("superCallToRemoveAtInJavaDefault.kt")
      public void testSuperCallToRemoveAtInJavaDefault() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToRemoveAtInJavaDefault.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault")
    @TestDataPath("$PROJECT_ROOT")
    public class MapGetOrDefault {
      @Test
      public void testAllFilesPresentInMapGetOrDefault() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("noTypeSafeBridge.kt")
      public void testNoTypeSafeBridge() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/noTypeSafeBridge.kt");
      }

      @Test
      @TestMetadata("typeSafeBridge.kt")
      public void testTypeSafeBridge() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/typeSafeBridge.kt");
      }

      @Test
      @TestMetadata("typeSafeBridgeNotNullAny.kt")
      public void testTypeSafeBridgeNotNullAny() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/typeSafeBridgeNotNullAny.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapRemove")
    @TestDataPath("$PROJECT_ROOT")
    public class MapRemove {
      @Test
      public void testAllFilesPresentInMapRemove() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapRemove"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("noDefaultImpls.kt")
      public void testNoDefaultImpls() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/noDefaultImpls.kt");
      }

      @Test
      @TestMetadata("readOnlyMap.kt")
      public void testReadOnlyMap() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/readOnlyMap.kt");
      }

      @Test
      @TestMetadata("typeSafeBridge.kt")
      public void testTypeSafeBridge() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/typeSafeBridge.kt");
      }

      @Test
      @TestMetadata("typeSafeBridgeNotNullAny.kt")
      public void testTypeSafeBridgeNotNullAny() {
        runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/typeSafeBridgeNotNullAny.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/callableReference")
  @TestDataPath("$PROJECT_ROOT")
  public class CallableReference {
    @Test
    public void testAllFilesPresentInCallableReference() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arrayConstructor.kt")
    public void testArrayConstructor() {
      runTest("compiler/testData/codegen/box/callableReference/arrayConstructor.kt");
    }

    @Test
    @TestMetadata("arrayConstructorArgument.kt")
    public void testArrayConstructorArgument() {
      runTest("compiler/testData/codegen/box/callableReference/arrayConstructorArgument.kt");
    }

    @Test
    @TestMetadata("arrayOf.kt")
    public void testArrayOf() {
      runTest("compiler/testData/codegen/box/callableReference/arrayOf.kt");
    }

    @Test
    @TestMetadata("arrayOfNulls.kt")
    public void testArrayOfNulls() {
      runTest("compiler/testData/codegen/box/callableReference/arrayOfNulls.kt");
    }

    @Test
    @TestMetadata("builtinFunctionReferenceOwner.kt")
    public void testBuiltinFunctionReferenceOwner() {
      runTest("compiler/testData/codegen/box/callableReference/builtinFunctionReferenceOwner.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfCompanionConst.kt")
    public void testCallableReferenceOfCompanionConst() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionConst.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfCompanionMethod.kt")
    public void testCallableReferenceOfCompanionMethod() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionMethod.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfCompanionProperty.kt")
    public void testCallableReferenceOfCompanionProperty() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionProperty.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfJavaNestedClass.kt")
    public void testCallableReferenceOfJavaNestedClass() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfJavaNestedClass.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfKotlinNestedClass.kt")
    public void testCallableReferenceOfKotlinNestedClass() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfKotlinNestedClass.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfNestedClass.kt")
    public void testCallableReferenceOfNestedClass() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfNestedClass.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfObjectMethod.kt")
    public void testCallableReferenceOfObjectMethod() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfObjectMethod.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfStaticField.kt")
    public void testCallableReferenceOfStaticField() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfStaticField.kt");
    }

    @Test
    @TestMetadata("callableReferenceOfStaticMethod.kt")
    public void testCallableReferenceOfStaticMethod() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfStaticMethod.kt");
    }

    @Test
    @TestMetadata("callableReferencetoInnerAndLocal.kt")
    public void testCallableReferencetoInnerAndLocal() {
      runTest("compiler/testData/codegen/box/callableReference/callableReferencetoInnerAndLocal.kt");
    }

    @Test
    @TestMetadata("charArrayOf.kt")
    public void testCharArrayOf() {
      runTest("compiler/testData/codegen/box/callableReference/charArrayOf.kt");
    }

    @Test
    @TestMetadata("classesAreSynthetic.kt")
    public void testClassesAreSynthetic() {
      runTest("compiler/testData/codegen/box/callableReference/classesAreSynthetic.kt");
    }

    @Test
    @TestMetadata("constructor.kt")
    public void testConstructor() {
      runTest("compiler/testData/codegen/box/callableReference/constructor.kt");
    }

    @Test
    @TestMetadata("genericConstructorReference.kt")
    public void testGenericConstructorReference() {
      runTest("compiler/testData/codegen/box/callableReference/genericConstructorReference.kt");
    }

    @Test
    @TestMetadata("genericLocalClassConstructorReference.kt")
    public void testGenericLocalClassConstructorReference() {
      runTest("compiler/testData/codegen/box/callableReference/genericLocalClassConstructorReference.kt");
    }

    @Test
    @TestMetadata("inlineArrayConstructors.kt")
    public void testInlineArrayConstructors() {
      runTest("compiler/testData/codegen/box/callableReference/inlineArrayConstructors.kt");
    }

    @Test
    @TestMetadata("interfaceMethodReference.kt")
    public void testInterfaceMethodReference() {
      runTest("compiler/testData/codegen/box/callableReference/interfaceMethodReference.kt");
    }

    @Test
    @TestMetadata("javaField.kt")
    public void testJavaField() {
      runTest("compiler/testData/codegen/box/callableReference/javaField.kt");
    }

    @Test
    @TestMetadata("kt16412.kt")
    public void testKt16412() {
      runTest("compiler/testData/codegen/box/callableReference/kt16412.kt");
    }

    @Test
    @TestMetadata("kt16752.kt")
    public void testKt16752() {
      runTest("compiler/testData/codegen/box/callableReference/kt16752.kt");
    }

    @Test
    @TestMetadata("kt21014.kt")
    public void testKt21014() {
      runTest("compiler/testData/codegen/box/callableReference/kt21014.kt");
    }

    @Test
    @TestMetadata("kt21092a.kt")
    public void testKt21092a() {
      runTest("compiler/testData/codegen/box/callableReference/kt21092a.kt");
    }

    @Test
    @TestMetadata("kt21092b.kt")
    public void testKt21092b() {
      runTest("compiler/testData/codegen/box/callableReference/kt21092b.kt");
    }

    @Test
    @TestMetadata("kt37604.kt")
    public void testKt37604() {
      runTest("compiler/testData/codegen/box/callableReference/kt37604.kt");
    }

    @Test
    @TestMetadata("kt44483.kt")
    public void testKt44483() {
      runTest("compiler/testData/codegen/box/callableReference/kt44483.kt");
    }

    @Test
    @TestMetadata("kt46902.kt")
    public void testKt46902() {
      runTest("compiler/testData/codegen/box/callableReference/kt46902.kt");
    }

    @Test
    @TestMetadata("kt47988.kt")
    public void testKt47988() {
      runTest("compiler/testData/codegen/box/callableReference/kt47988.kt");
    }

    @Test
    @TestMetadata("kt49526.kt")
    public void testKt49526() {
      runTest("compiler/testData/codegen/box/callableReference/kt49526.kt");
    }

    @Test
    @TestMetadata("kt49526_sam.kt")
    public void testKt49526_sam() {
      runTest("compiler/testData/codegen/box/callableReference/kt49526_sam.kt");
    }

    @Test
    @TestMetadata("kt49526a.kt")
    public void testKt49526a() {
      runTest("compiler/testData/codegen/box/callableReference/kt49526a.kt");
    }

    @Test
    @TestMetadata("kt49526b.kt")
    public void testKt49526b() {
      runTest("compiler/testData/codegen/box/callableReference/kt49526b.kt");
    }

    @Test
    @TestMetadata("kt50172.kt")
    public void testKt50172() {
      runTest("compiler/testData/codegen/box/callableReference/kt50172.kt");
    }

    @Test
    @TestMetadata("kt51844.kt")
    public void testKt51844() {
      runTest("compiler/testData/codegen/box/callableReference/kt51844.kt");
    }

    @Test
    @TestMetadata("kt52270.kt")
    public void testKt52270() {
      runTest("compiler/testData/codegen/box/callableReference/kt52270.kt");
    }

    @Test
    @TestMetadata("kt55138.kt")
    public void testKt55138() {
      runTest("compiler/testData/codegen/box/callableReference/kt55138.kt");
    }

    @Test
    @TestMetadata("kt62550.kt")
    public void testKt62550() {
      runTest("compiler/testData/codegen/box/callableReference/kt62550.kt");
    }

    @Test
    @TestMetadata("nested.kt")
    public void testNested() {
      runTest("compiler/testData/codegen/box/callableReference/nested.kt");
    }

    @Test
    @TestMetadata("optimizedSuperclasses.kt")
    public void testOptimizedSuperclasses() {
      runTest("compiler/testData/codegen/box/callableReference/optimizedSuperclasses.kt");
    }

    @Test
    @TestMetadata("publicFinalField.kt")
    public void testPublicFinalField() {
      runTest("compiler/testData/codegen/box/callableReference/publicFinalField.kt");
    }

    @Test
    @TestMetadata("publicMutableField.kt")
    public void testPublicMutableField() {
      runTest("compiler/testData/codegen/box/callableReference/publicMutableField.kt");
    }

    @Test
    @TestMetadata("referenceToGenericSyntheticProperty.kt")
    public void testReferenceToGenericSyntheticProperty() {
      runTest("compiler/testData/codegen/box/callableReference/referenceToGenericSyntheticProperty.kt");
    }

    @Test
    @TestMetadata("referenceToTypealiasConstructorInLet.kt")
    public void testReferenceToTypealiasConstructorInLet() {
      runTest("compiler/testData/codegen/box/callableReference/referenceToTypealiasConstructorInLet.kt");
    }

    @Test
    @TestMetadata("returnNullFromFlexibleUnitLambda.kt")
    public void testReturnNullFromFlexibleUnitLambda() {
      runTest("compiler/testData/codegen/box/callableReference/returnNullFromFlexibleUnitLambda.kt");
    }

    @Test
    @TestMetadata("starProjectionCallableReference.kt")
    public void testStarProjectionCallableReference() {
      runTest("compiler/testData/codegen/box/callableReference/starProjectionCallableReference.kt");
    }

    @Test
    @TestMetadata("staticMethod.kt")
    public void testStaticMethod() {
      runTest("compiler/testData/codegen/box/callableReference/staticMethod.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/callableReference/adaptedReferences")
    @TestDataPath("$PROJECT_ROOT")
    public class AdaptedReferences {
      @Test
      @TestMetadata("adaptedArrayOf.kt")
      public void testAdaptedArrayOf() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/adaptedArrayOf.kt");
      }

      @Test
      @TestMetadata("adaptedVarargFunImportedFromObject.kt")
      public void testAdaptedVarargFunImportedFromObject() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/adaptedVarargFunImportedFromObject.kt");
      }

      @Test
      public void testAllFilesPresentInAdaptedReferences() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("bothWithCoercionToUnit.kt")
      public void testBothWithCoercionToUnit() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/bothWithCoercionToUnit.kt");
      }

      @Test
      @TestMetadata("boundReferences.kt")
      public void testBoundReferences() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/boundReferences.kt");
      }

      @Test
      @TestMetadata("defaultAfterVararg.kt")
      public void testDefaultAfterVararg() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/defaultAfterVararg.kt");
      }

      @Test
      @TestMetadata("defaultWithGenericExpectedType.kt")
      public void testDefaultWithGenericExpectedType() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/defaultWithGenericExpectedType.kt");
      }

      @Test
      @TestMetadata("emptyVarargAndDefault.kt")
      public void testEmptyVarargAndDefault() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/emptyVarargAndDefault.kt");
      }

      @Test
      @TestMetadata("extensionFunctionAdaptedReferences.kt")
      public void testExtensionFunctionAdaptedReferences() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionFunctionAdaptedReferences.kt");
      }

      @Test
      @TestMetadata("extensionFunctionAnonymous.kt")
      public void testExtensionFunctionAnonymous() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionFunctionAnonymous.kt");
      }

      @Test
      @TestMetadata("extensionFunctionWithNestedReceiver.kt")
      public void testExtensionFunctionWithNestedReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionFunctionWithNestedReceiver.kt");
      }

      @Test
      @TestMetadata("extensionFunctionWithPassedSupertype.kt")
      public void testExtensionFunctionWithPassedSupertype() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionFunctionWithPassedSupertype.kt");
      }

      @Test
      @TestMetadata("extensionInSamWithPassedSupertype.kt")
      public void testExtensionInSamWithPassedSupertype() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionInSamWithPassedSupertype.kt");
      }

      @Test
      @TestMetadata("extensionParameterToValueParameter.kt")
      public void testExtensionParameterToValueParameter() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionParameterToValueParameter.kt");
      }

      @Test
      @TestMetadata("extensionPropertyToFun.kt")
      public void testExtensionPropertyToFun() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionPropertyToFun.kt");
      }

      @Test
      @TestMetadata("extensionPropertyToJavaFun.kt")
      public void testExtensionPropertyToJavaFun() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionPropertyToJavaFun.kt");
      }

      @Test
      @TestMetadata("extensionPropertyWithAnonymousExtensionFun.kt")
      public void testExtensionPropertyWithAnonymousExtensionFun() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/extensionPropertyWithAnonymousExtensionFun.kt");
      }

      @Test
      @TestMetadata("inlineBound.kt")
      public void testInlineBound() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineBound.kt");
      }

      @Test
      @TestMetadata("inlineDefault.kt")
      public void testInlineDefault() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineDefault.kt");
      }

      @Test
      @TestMetadata("inlineVararg.kt")
      public void testInlineVararg() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVararg.kt");
      }

      @Test
      @TestMetadata("inlineVarargAndDefault.kt")
      public void testInlineVarargAndDefault() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
      }

      @Test
      @TestMetadata("inlineVarargInts.kt")
      public void testInlineVarargInts() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVarargInts.kt");
      }

      @Test
      @TestMetadata("innerConstructorToExtensionFun.kt")
      public void testInnerConstructorToExtensionFun() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/innerConstructorToExtensionFun.kt");
      }

      @Test
      @TestMetadata("innerConstructorToExtensionWithTypeParam.kt")
      public void testInnerConstructorToExtensionWithTypeParam() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/innerConstructorToExtensionWithTypeParam.kt");
      }

      @Test
      @TestMetadata("innerConstructorWithVararg.kt")
      public void testInnerConstructorWithVararg() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/innerConstructorWithVararg.kt");
      }

      @Test
      @TestMetadata("jvmStatic.kt")
      public void testJvmStatic() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/jvmStatic.kt");
      }

      @Test
      @TestMetadata("largeVararg.kt")
      public void testLargeVararg() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/largeVararg.kt");
      }

      @Test
      @TestMetadata("localFunctionWithDefault.kt")
      public void testLocalFunctionWithDefault() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/localFunctionWithDefault.kt");
      }

      @Test
      @TestMetadata("manyDefaultsAndVararg.kt")
      public void testManyDefaultsAndVararg() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/manyDefaultsAndVararg.kt");
      }

      @Test
      @TestMetadata("nestedClassConstructorWithDefault.kt")
      public void testNestedClassConstructorWithDefault() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/nestedClassConstructorWithDefault.kt");
      }

      @Test
      @TestMetadata("noNameClashForReferencesToSameFunction.kt")
      public void testNoNameClashForReferencesToSameFunction() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noNameClashForReferencesToSameFunction.kt");
      }

      @Test
      @TestMetadata("noReflectionForAdaptedCallableReferences.kt")
      public void testNoReflectionForAdaptedCallableReferences() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noReflectionForAdaptedCallableReferences.kt");
      }

      @Test
      @TestMetadata("noReflectionForAdaptedCallableReferencesWithSuspendConversion.kt")
      public void testNoReflectionForAdaptedCallableReferencesWithSuspendConversion() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noReflectionForAdaptedCallableReferencesWithSuspendConversion.kt");
      }

      @Test
      @TestMetadata("referenceToFakeOverrideWithTypeParameter.kt")
      public void testReferenceToFakeOverrideWithTypeParameter() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/referenceToFakeOverrideWithTypeParameter.kt");
      }

      @Test
      @TestMetadata("referenceToVarargWithDefaults.kt")
      public void testReferenceToVarargWithDefaults() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/referenceToVarargWithDefaults.kt");
      }

      @Test
      @TestMetadata("reflectionForVarargAsArray.kt")
      public void testReflectionForVarargAsArray() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/reflectionForVarargAsArray.kt");
      }

      @Test
      @TestMetadata("simpleDefaultArgument.kt")
      public void testSimpleDefaultArgument() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/simpleDefaultArgument.kt");
      }

      @Test
      @TestMetadata("simpleEmptyVararg.kt")
      public void testSimpleEmptyVararg() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/simpleEmptyVararg.kt");
      }

      @Test
      @TestMetadata("suspendUnitConversion.kt")
      public void testSuspendUnitConversion() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendUnitConversion.kt");
      }

      @Test
      @TestMetadata("toStringNoReflect.kt")
      public void testToStringNoReflect() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/toStringNoReflect.kt");
      }

      @Test
      @TestMetadata("unboundReferences.kt")
      public void testUnboundReferences() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/unboundReferences.kt");
      }

      @Test
      @TestMetadata("unitCoercionOverloads.kt")
      public void testUnitCoercionOverloads() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/unitCoercionOverloads.kt");
      }

      @Test
      @TestMetadata("varargFromBaseClass.kt")
      public void testVarargFromBaseClass() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargFromBaseClass.kt");
      }

      @Test
      @TestMetadata("varargOverloads.kt")
      public void testVarargOverloads() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargOverloads.kt");
      }

      @Test
      @TestMetadata("varargViewedAsArray.kt")
      public void testVarargViewedAsArray() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargViewedAsArray.kt");
      }

      @Test
      @TestMetadata("varargViewedAsPrimitiveArray.kt")
      public void testVarargViewedAsPrimitiveArray() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargViewedAsPrimitiveArray.kt");
      }

      @Test
      @TestMetadata("varargWithDefaultValue.kt")
      public void testVarargWithDefaultValue() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargWithDefaultValue.kt");
      }

      @Test
      @TestMetadata("withReceiver.kt")
      public void testWithReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/withReceiver.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion")
      @TestDataPath("$PROJECT_ROOT")
      public class SuspendConversion {
        @Test
        @TestMetadata("adaptedWithCoercionToUnit.kt")
        public void testAdaptedWithCoercionToUnit() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithCoercionToUnit.kt");
        }

        @Test
        @TestMetadata("adaptedWithDefaultArguments.kt")
        public void testAdaptedWithDefaultArguments() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithDefaultArguments.kt");
        }

        @Test
        @TestMetadata("adaptedWithVarargs.kt")
        public void testAdaptedWithVarargs() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithVarargs.kt");
        }

        @Test
        public void testAllFilesPresentInSuspendConversion() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("bound.kt")
        public void testBound() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/bound.kt");
        }

        @Test
        @TestMetadata("boundExtension.kt")
        public void testBoundExtension() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/boundExtension.kt");
        }

        @Test
        @TestMetadata("crossInline.kt")
        public void testCrossInline() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/crossInline.kt");
        }

        @Test
        @TestMetadata("extensionFunction.kt")
        public void testExtensionFunction() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/extensionFunction.kt");
        }

        @Test
        @TestMetadata("extensionFunctionAndJavaStatic.kt")
        public void testExtensionFunctionAndJavaStatic() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/extensionFunctionAndJavaStatic.kt");
        }

        @Test
        @TestMetadata("extensionFunctionAsASuperType.kt")
        public void testExtensionFunctionAsASuperType() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/extensionFunctionAsASuperType.kt");
        }

        @Test
        @TestMetadata("extensionTypeProperty.kt")
        public void testExtensionTypeProperty() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/extensionTypeProperty.kt");
        }

        @Test
        @TestMetadata("inlineAdaptedWithCoercionToUnit.kt")
        public void testInlineAdaptedWithCoercionToUnit() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithCoercionToUnit.kt");
        }

        @Test
        @TestMetadata("inlineAdaptedWithDefaultArguments.kt")
        public void testInlineAdaptedWithDefaultArguments() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithDefaultArguments.kt");
        }

        @Test
        @TestMetadata("inlineAdaptedWithVarargs.kt")
        public void testInlineAdaptedWithVarargs() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithVarargs.kt");
        }

        @Test
        @TestMetadata("inlineBound.kt")
        public void testInlineBound() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineBound.kt");
        }

        @Test
        @TestMetadata("inlineSimple.kt")
        public void testInlineSimple() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineSimple.kt");
        }

        @Test
        @TestMetadata("inlineWithContextParameter.kt")
        public void testInlineWithContextParameter() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithContextParameter.kt");
        }

        @Test
        @TestMetadata("inlineWithContextParameterAsAPropertyType.kt")
        public void testInlineWithContextParameterAsAPropertyType() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithContextParameterAsAPropertyType.kt");
        }

        @Test
        @TestMetadata("inlineWithContextParameterAsASupertype.kt")
        public void testInlineWithContextParameterAsASupertype() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithContextParameterAsASupertype.kt");
        }

        @Test
        @TestMetadata("inlineWithExtensionAsASuperType.kt")
        public void testInlineWithExtensionAsASuperType() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithExtensionAsASuperType.kt");
        }

        @Test
        @TestMetadata("inlineWithExtensionFunction.kt")
        public void testInlineWithExtensionFunction() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithExtensionFunction.kt");
        }

        @Test
        @TestMetadata("inlineWithExtensionProperty.kt")
        public void testInlineWithExtensionProperty() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithExtensionProperty.kt");
        }

        @Test
        @TestMetadata("inlineWithParameters.kt")
        public void testInlineWithParameters() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithParameters.kt");
        }

        @Test
        @TestMetadata("isAs.kt")
        public void testIsAs() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/isAs.kt");
        }

        @Test
        @TestMetadata("nullableParameter.kt")
        public void testNullableParameter() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/nullableParameter.kt");
        }

        @Test
        @TestMetadata("propertyReferenceToSuspendFunction.kt")
        public void testPropertyReferenceToSuspendFunction() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/propertyReferenceToSuspendFunction.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/simple.kt");
        }

        @Test
        @TestMetadata("withContextParameterAsAPropertyType.kt")
        public void testWithContextParameterAsAPropertyType() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/withContextParameterAsAPropertyType.kt");
        }

        @Test
        @TestMetadata("withContextParameters.kt")
        public void testWithContextParameters() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/withContextParameters.kt");
        }

        @Test
        @TestMetadata("withContextParametersAsASupertype.kt")
        public void testWithContextParametersAsASupertype() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/withContextParametersAsASupertype.kt");
        }

        @Test
        @TestMetadata("withParameters.kt")
        public void testWithParameters() {
          runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/withParameters.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/callableReference/bound")
    @TestDataPath("$PROJECT_ROOT")
    public class Bound {
      @Test
      @TestMetadata("adapted.kt")
      public void testAdapted() {
        runTest("compiler/testData/codegen/box/callableReference/bound/adapted.kt");
      }

      @Test
      public void testAllFilesPresentInBound() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("array.kt")
      public void testArray() {
        runTest("compiler/testData/codegen/box/callableReference/bound/array.kt");
      }

      @Test
      @TestMetadata("arrayConstructorArgument.kt")
      public void testArrayConstructorArgument() {
        runTest("compiler/testData/codegen/box/callableReference/bound/arrayConstructorArgument.kt");
      }

      @Test
      @TestMetadata("arrayGetIntrinsic.kt")
      public void testArrayGetIntrinsic() {
        runTest("compiler/testData/codegen/box/callableReference/bound/arrayGetIntrinsic.kt");
      }

      @Test
      @TestMetadata("boundJvmFieldInInterfaceCompanion.kt")
      public void testBoundJvmFieldInInterfaceCompanion() {
        runTest("compiler/testData/codegen/box/callableReference/bound/boundJvmFieldInInterfaceCompanion.kt");
      }

      @Test
      @TestMetadata("boundReferenceToOverloadedFunction.kt")
      public void testBoundReferenceToOverloadedFunction() {
        runTest("compiler/testData/codegen/box/callableReference/bound/boundReferenceToOverloadedFunction.kt");
      }

      @Test
      @TestMetadata("captureVarInInitBlock.kt")
      public void testCaptureVarInInitBlock() {
        runTest("compiler/testData/codegen/box/callableReference/bound/captureVarInInitBlock.kt");
      }

      @Test
      @TestMetadata("captureVarInPropertyInit.kt")
      public void testCaptureVarInPropertyInit() {
        runTest("compiler/testData/codegen/box/callableReference/bound/captureVarInPropertyInit.kt");
      }

      @Test
      @TestMetadata("coercionToUnit.kt")
      public void testCoercionToUnit() {
        runTest("compiler/testData/codegen/box/callableReference/bound/coercionToUnit.kt");
      }

      @Test
      @TestMetadata("companionObjectReceiver.kt")
      public void testCompanionObjectReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/bound/companionObjectReceiver.kt");
      }

      @Test
      @TestMetadata("companionObjectReceiverInheritsFromOuter.kt")
      public void testCompanionObjectReceiverInheritsFromOuter() {
        runTest("compiler/testData/codegen/box/callableReference/bound/companionObjectReceiverInheritsFromOuter.kt");
      }

      @Test
      @TestMetadata("dontShareReceiver.kt")
      public void testDontShareReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/bound/dontShareReceiver.kt");
      }

      @Test
      @TestMetadata("emptyLHS.kt")
      public void testEmptyLHS() {
        runTest("compiler/testData/codegen/box/callableReference/bound/emptyLHS.kt");
      }

      @Test
      @TestMetadata("enumEntryMember.kt")
      public void testEnumEntryMember() {
        runTest("compiler/testData/codegen/box/callableReference/bound/enumEntryMember.kt");
      }

      @Test
      @TestMetadata("genericBoundPropertyAsCrossinline.kt")
      public void testGenericBoundPropertyAsCrossinline() {
        runTest("compiler/testData/codegen/box/callableReference/bound/genericBoundPropertyAsCrossinline.kt");
      }

      @Test
      @TestMetadata("genericValOnLHS.kt")
      public void testGenericValOnLHS() {
        runTest("compiler/testData/codegen/box/callableReference/bound/genericValOnLHS.kt");
      }

      @Test
      @TestMetadata("javaField.kt")
      public void testJavaField() {
        runTest("compiler/testData/codegen/box/callableReference/bound/javaField.kt");
      }

      @Test
      @TestMetadata("kCallableNameIntrinsic.kt")
      public void testKCallableNameIntrinsic() {
        runTest("compiler/testData/codegen/box/callableReference/bound/kCallableNameIntrinsic.kt");
      }

      @Test
      @TestMetadata("kt12738.kt")
      public void testKt12738() {
        runTest("compiler/testData/codegen/box/callableReference/bound/kt12738.kt");
      }

      @Test
      @TestMetadata("kt15446.kt")
      public void testKt15446() {
        runTest("compiler/testData/codegen/box/callableReference/bound/kt15446.kt");
      }

      @Test
      @TestMetadata("kt44636_localExtension.kt")
      public void testKt44636_localExtension() {
        runTest("compiler/testData/codegen/box/callableReference/bound/kt44636_localExtension.kt");
      }

      @Test
      @TestMetadata("localUnitFunction.kt")
      public void testLocalUnitFunction() {
        runTest("compiler/testData/codegen/box/callableReference/bound/localUnitFunction.kt");
      }

      @Test
      @TestMetadata("multiCase.kt")
      public void testMultiCase() {
        runTest("compiler/testData/codegen/box/callableReference/bound/multiCase.kt");
      }

      @Test
      @TestMetadata("nullReceiver.kt")
      public void testNullReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/bound/nullReceiver.kt");
      }

      @Test
      @TestMetadata("objectReceiver.kt")
      public void testObjectReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/bound/objectReceiver.kt");
      }

      @Test
      @TestMetadata("primitiveReceiver.kt")
      public void testPrimitiveReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/bound/primitiveReceiver.kt");
      }

      @Test
      @TestMetadata("receiverEvaluatedOnce.kt")
      public void testReceiverEvaluatedOnce() {
        runTest("compiler/testData/codegen/box/callableReference/bound/receiverEvaluatedOnce.kt");
      }

      @Test
      @TestMetadata("referenceToGetSetMethodsFromVararg.kt")
      public void testReferenceToGetSetMethodsFromVararg() {
        runTest("compiler/testData/codegen/box/callableReference/bound/referenceToGetSetMethodsFromVararg.kt");
      }

      @Test
      @TestMetadata("simpleFunction.kt")
      public void testSimpleFunction() {
        runTest("compiler/testData/codegen/box/callableReference/bound/simpleFunction.kt");
      }

      @Test
      @TestMetadata("simpleProperty.kt")
      public void testSimpleProperty() {
        runTest("compiler/testData/codegen/box/callableReference/bound/simpleProperty.kt");
      }

      @Test
      @TestMetadata("smartCastForExtensionReceiver.kt")
      public void testSmartCastForExtensionReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/bound/smartCastForExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("syntheticExtensionOnLHS.kt")
      public void testSyntheticExtensionOnLHS() {
        runTest("compiler/testData/codegen/box/callableReference/bound/syntheticExtensionOnLHS.kt");
      }

      @Test
      @TestMetadata("typeAliasObjectBoundReference.kt")
      public void testTypeAliasObjectBoundReference() {
        runTest("compiler/testData/codegen/box/callableReference/bound/typeAliasObjectBoundReference.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/callableReference/bound/equals")
      @TestDataPath("$PROJECT_ROOT")
      public class Equals {
        @Test
        public void testAllFilesPresentInEquals() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound/equals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("nullableReceiverInEquals.kt")
        public void testNullableReceiverInEquals() {
          runTest("compiler/testData/codegen/box/callableReference/bound/equals/nullableReceiverInEquals.kt");
        }

        @Test
        @TestMetadata("receiverInEquals.kt")
        public void testReceiverInEquals() {
          runTest("compiler/testData/codegen/box/callableReference/bound/equals/receiverInEquals.kt");
        }

        @Test
        @TestMetadata("reflectionReference.kt")
        public void testReflectionReference() {
          runTest("compiler/testData/codegen/box/callableReference/bound/equals/reflectionReference.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/callableReference/equality")
    @TestDataPath("$PROJECT_ROOT")
    public class Equality {
      @Test
      public void testAllFilesPresentInEquality() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/equality"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("capturedDefaults.kt")
      public void testCapturedDefaults() {
        runTest("compiler/testData/codegen/box/callableReference/equality/capturedDefaults.kt");
      }

      @Test
      @TestMetadata("capturedVararg.kt")
      public void testCapturedVararg() {
        runTest("compiler/testData/codegen/box/callableReference/equality/capturedVararg.kt");
      }

      @Test
      @TestMetadata("coercionToUnit.kt")
      public void testCoercionToUnit() {
        runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnit.kt");
      }

      @Test
      @TestMetadata("coercionToUnitWithDefaults.kt")
      public void testCoercionToUnitWithDefaults() {
        runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnitWithDefaults.kt");
      }

      @Test
      @TestMetadata("coercionToUnitWithVararg.kt")
      public void testCoercionToUnitWithVararg() {
        runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnitWithVararg.kt");
      }

      @Test
      @TestMetadata("conversionCombinations.kt")
      public void testConversionCombinations() {
        runTest("compiler/testData/codegen/box/callableReference/equality/conversionCombinations.kt");
      }

      @Test
      @TestMetadata("extensionReceiverVsDefault.kt")
      public void testExtensionReceiverVsDefault() {
        runTest("compiler/testData/codegen/box/callableReference/equality/extensionReceiverVsDefault.kt");
      }

      @Test
      @TestMetadata("kproperty.kt")
      public void testKproperty() {
        runTest("compiler/testData/codegen/box/callableReference/equality/kproperty.kt");
      }

      @Test
      @TestMetadata("kpropertyWithCapturingEquality.kt")
      public void testKpropertyWithCapturingEquality() {
        runTest("compiler/testData/codegen/box/callableReference/equality/kpropertyWithCapturingEquality.kt");
      }

      @Test
      @TestMetadata("kpropertyWithCapturingInequality.kt")
      public void testKpropertyWithCapturingInequality() {
        runTest("compiler/testData/codegen/box/callableReference/equality/kpropertyWithCapturingInequality.kt");
      }

      @Test
      @TestMetadata("noCoercionToUnitIfFunctionAlreadyReturnsUnit.kt")
      public void testNoCoercionToUnitIfFunctionAlreadyReturnsUnit() {
        runTest("compiler/testData/codegen/box/callableReference/equality/noCoercionToUnitIfFunctionAlreadyReturnsUnit.kt");
      }

      @Test
      @TestMetadata("simpleEquality.kt")
      public void testSimpleEquality() {
        runTest("compiler/testData/codegen/box/callableReference/equality/simpleEquality.kt");
      }

      @Test
      @TestMetadata("suspendConversion.kt")
      public void testSuspendConversion() {
        runTest("compiler/testData/codegen/box/callableReference/equality/suspendConversion.kt");
      }

      @Test
      @TestMetadata("varargAsArrayMemberOrExtension.kt")
      public void testVarargAsArrayMemberOrExtension() {
        runTest("compiler/testData/codegen/box/callableReference/equality/varargAsArrayMemberOrExtension.kt");
      }

      @Test
      @TestMetadata("varargAsArrayWithDefaults.kt")
      public void testVarargAsArrayWithDefaults() {
        runTest("compiler/testData/codegen/box/callableReference/equality/varargAsArrayWithDefaults.kt");
      }

      @Test
      @TestMetadata("varargWithDefaults.kt")
      public void testVarargWithDefaults() {
        runTest("compiler/testData/codegen/box/callableReference/equality/varargWithDefaults.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/callableReference/funInterfaceConstructor")
    @TestDataPath("$PROJECT_ROOT")
    public class FunInterfaceConstructor {
      @Test
      public void testAllFilesPresentInFunInterfaceConstructor() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/funInterfaceConstructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("funInterfaceConstructedObjectsEquality.kt")
      public void testFunInterfaceConstructedObjectsEquality() {
        runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructedObjectsEquality.kt");
      }

      @Test
      @TestMetadata("funInterfaceConstructor.kt")
      public void testFunInterfaceConstructor() {
        runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructor.kt");
      }

      @Test
      @TestMetadata("funInterfaceConstructorEquality.kt")
      public void testFunInterfaceConstructorEquality() {
        runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorEquality.kt");
      }

      @Test
      @TestMetadata("funInterfaceConstructorIsKFunction.kt")
      public void testFunInterfaceConstructorIsKFunction() {
        runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorIsKFunction.kt");
      }

      @Test
      @TestMetadata("funInterfaceConstructorOfImplicitKFunctionType.kt")
      public void testFunInterfaceConstructorOfImplicitKFunctionType() {
        runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorOfImplicitKFunctionType.kt");
      }

      @Test
      @TestMetadata("funInterfaceConstructorThrowsNpe.kt")
      public void testFunInterfaceConstructorThrowsNpe() {
        runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorThrowsNpe.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/callableReference/function")
    @TestDataPath("$PROJECT_ROOT")
    public class Function {
      @Test
      @TestMetadata("abstractClassMember.kt")
      public void testAbstractClassMember() {
        runTest("compiler/testData/codegen/box/callableReference/function/abstractClassMember.kt");
      }

      @Test
      public void testAllFilesPresentInFunction() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("argumentTypes.kt")
      public void testArgumentTypes() {
        runTest("compiler/testData/codegen/box/callableReference/function/argumentTypes.kt");
      }

      @Test
      @TestMetadata("argumentTypesNoinline.kt")
      public void testArgumentTypesNoinline() {
        runTest("compiler/testData/codegen/box/callableReference/function/argumentTypesNoinline.kt");
      }

      @Test
      @TestMetadata("booleanNotIntrinsic.kt")
      public void testBooleanNotIntrinsic() {
        runTest("compiler/testData/codegen/box/callableReference/function/booleanNotIntrinsic.kt");
      }

      @Test
      @TestMetadata("classMemberFromClass.kt")
      public void testClassMemberFromClass() {
        runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromClass.kt");
      }

      @Test
      @TestMetadata("classMemberFromCompanionObject.kt")
      public void testClassMemberFromCompanionObject() {
        runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromCompanionObject.kt");
      }

      @Test
      @TestMetadata("classMemberFromExtension.kt")
      public void testClassMemberFromExtension() {
        runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromExtension.kt");
      }

      @Test
      @TestMetadata("classMemberFromTopLevelStringNoArgs.kt")
      public void testClassMemberFromTopLevelStringNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringNoArgs.kt");
      }

      @Test
      @TestMetadata("classMemberFromTopLevelStringOneStringArg.kt")
      public void testClassMemberFromTopLevelStringOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringOneStringArg.kt");
      }

      @Test
      @TestMetadata("classMemberFromTopLevelUnitNoArgs.kt")
      public void testClassMemberFromTopLevelUnitNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitNoArgs.kt");
      }

      @Test
      @TestMetadata("classMemberFromTopLevelUnitOneStringArg.kt")
      public void testClassMemberFromTopLevelUnitOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitOneStringArg.kt");
      }

      @Test
      @TestMetadata("coercionToUnit.kt")
      public void testCoercionToUnit() {
        runTest("compiler/testData/codegen/box/callableReference/function/coercionToUnit.kt");
      }

      @Test
      @TestMetadata("constructorFromInnerClass.kt")
      public void testConstructorFromInnerClass() {
        runTest("compiler/testData/codegen/box/callableReference/function/constructorFromInnerClass.kt");
      }

      @Test
      @TestMetadata("constructorFromInnerClassWithTypeParam.kt")
      public void testConstructorFromInnerClassWithTypeParam() {
        runTest("compiler/testData/codegen/box/callableReference/function/constructorFromInnerClassWithTypeParam.kt");
      }

      @Test
      @TestMetadata("constructorFromTopLevelNoArgs.kt")
      public void testConstructorFromTopLevelNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelNoArgs.kt");
      }

      @Test
      @TestMetadata("constructorFromTopLevelOneStringArg.kt")
      public void testConstructorFromTopLevelOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelOneStringArg.kt");
      }

      @Test
      @TestMetadata("dispatchReceiverType.kt")
      public void testDispatchReceiverType() {
        runTest("compiler/testData/codegen/box/callableReference/function/dispatchReceiverType.kt");
      }

      @Test
      @TestMetadata("enumValueOfMethod.kt")
      public void testEnumValueOfMethod() {
        runTest("compiler/testData/codegen/box/callableReference/function/enumValueOfMethod.kt");
      }

      @Test
      @TestMetadata("equalsIntrinsic.kt")
      public void testEqualsIntrinsic() {
        runTest("compiler/testData/codegen/box/callableReference/function/equalsIntrinsic.kt");
      }

      @Test
      @TestMetadata("extensionFromClass.kt")
      public void testExtensionFromClass() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFromClass.kt");
      }

      @Test
      @TestMetadata("extensionFromCompanion.kt")
      public void testExtensionFromCompanion() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFromCompanion.kt");
      }

      @Test
      @TestMetadata("extensionFromExtension.kt")
      public void testExtensionFromExtension() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFromExtension.kt");
      }

      @Test
      @TestMetadata("extensionFromTopLevelStringNoArgs.kt")
      public void testExtensionFromTopLevelStringNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringNoArgs.kt");
      }

      @Test
      @TestMetadata("extensionFromTopLevelStringOneStringArg.kt")
      public void testExtensionFromTopLevelStringOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringOneStringArg.kt");
      }

      @Test
      @TestMetadata("extensionFromTopLevelUnitNoArgs.kt")
      public void testExtensionFromTopLevelUnitNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitNoArgs.kt");
      }

      @Test
      @TestMetadata("extensionFromTopLevelUnitOneStringArg.kt")
      public void testExtensionFromTopLevelUnitOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitOneStringArg.kt");
      }

      @Test
      @TestMetadata("extensionFunctionAsASuperTypePassToSAMInterface.kt")
      public void testExtensionFunctionAsASuperTypePassToSAMInterface() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFunctionAsASuperTypePassToSAMInterface.kt");
      }

      @Test
      @TestMetadata("extensionFunctionInJavaSAM.kt")
      public void testExtensionFunctionInJavaSAM() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFunctionInJavaSAM.kt");
      }

      @Test
      @TestMetadata("extensionFunctionInSAMInterface.kt")
      public void testExtensionFunctionInSAMInterface() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFunctionInSAMInterface.kt");
      }

      @Test
      @TestMetadata("extensionFunctionLocal.kt")
      public void testExtensionFunctionLocal() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFunctionLocal.kt");
      }

      @Test
      @TestMetadata("extensionFunctionPassToSAMInterface.kt")
      public void testExtensionFunctionPassToSAMInterface() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFunctionPassToSAMInterface.kt");
      }

      @Test
      @TestMetadata("extensionFunctionToJavaFun.kt")
      public void testExtensionFunctionToJavaFun() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFunctionToJavaFun.kt");
      }

      @Test
      @TestMetadata("extensionFunctionWithExtensionInSAMInterface.kt")
      public void testExtensionFunctionWithExtensionInSAMInterface() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionFunctionWithExtensionInSAMInterface.kt");
      }

      @Test
      @TestMetadata("extensionInDelegatedJavaSam.kt")
      public void testExtensionInDelegatedJavaSam() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionInDelegatedJavaSam.kt");
      }

      @Test
      @TestMetadata("extensionInDelegatedSam.kt")
      public void testExtensionInDelegatedSam() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionInDelegatedSam.kt");
      }

      @Test
      @TestMetadata("extensionPassedToDelegatedSam.kt")
      public void testExtensionPassedToDelegatedSam() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionPassedToDelegatedSam.kt");
      }

      @Test
      @TestMetadata("extensionProperty.kt")
      public void testExtensionProperty() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionProperty.kt");
      }

      @Test
      @TestMetadata("extensionWithNestedFunction.kt")
      public void testExtensionWithNestedFunction() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionWithNestedFunction.kt");
      }

      @Test
      @TestMetadata("extensionWithTypeParam.kt")
      public void testExtensionWithTypeParam() {
        runTest("compiler/testData/codegen/box/callableReference/function/extensionWithTypeParam.kt");
      }

      @Test
      @TestMetadata("genericCallableReferenceArguments.kt")
      public void testGenericCallableReferenceArguments() {
        runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferenceArguments.kt");
      }

      @Test
      @TestMetadata("genericCallableReferenceWithReifiedTypeParam.kt")
      public void testGenericCallableReferenceWithReifiedTypeParam() {
        runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferenceWithReifiedTypeParam.kt");
      }

      @Test
      @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
      public void testGenericCallableReferencesWithNullableTypes() {
        runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
      }

      @Test
      @TestMetadata("genericCallableReferencesWithOverload.kt")
      public void testGenericCallableReferencesWithOverload() {
        runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithOverload.kt");
      }

      @Test
      @TestMetadata("genericMember.kt")
      public void testGenericMember() {
        runTest("compiler/testData/codegen/box/callableReference/function/genericMember.kt");
      }

      @Test
      @TestMetadata("genericWithDependentType.kt")
      public void testGenericWithDependentType() {
        runTest("compiler/testData/codegen/box/callableReference/function/genericWithDependentType.kt");
      }

      @Test
      @TestMetadata("getArityViaFunctionImpl.kt")
      public void testGetArityViaFunctionImpl() {
        runTest("compiler/testData/codegen/box/callableReference/function/getArityViaFunctionImpl.kt");
      }

      @Test
      @TestMetadata("innerClassConstructorWithTwoReceivers.kt")
      public void testInnerClassConstructorWithTwoReceivers() {
        runTest("compiler/testData/codegen/box/callableReference/function/innerClassConstructorWithTwoReceivers.kt");
      }

      @Test
      @TestMetadata("innerConstructorFromClass.kt")
      public void testInnerConstructorFromClass() {
        runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromClass.kt");
      }

      @Test
      @TestMetadata("innerConstructorFromExtension.kt")
      public void testInnerConstructorFromExtension() {
        runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromExtension.kt");
      }

      @Test
      @TestMetadata("innerConstructorFromTopLevelNoArgs.kt")
      public void testInnerConstructorFromTopLevelNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelNoArgs.kt");
      }

      @Test
      @TestMetadata("innerConstructorFromTopLevelOneStringArg.kt")
      public void testInnerConstructorFromTopLevelOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelOneStringArg.kt");
      }

      @Test
      @TestMetadata("javaCollectionsStaticMethod.kt")
      public void testJavaCollectionsStaticMethod() {
        runTest("compiler/testData/codegen/box/callableReference/function/javaCollectionsStaticMethod.kt");
      }

      @Test
      @TestMetadata("javaStaticFunctionToExtensionFunction.kt")
      public void testJavaStaticFunctionToExtensionFunction() {
        runTest("compiler/testData/codegen/box/callableReference/function/javaStaticFunctionToExtensionFunction.kt");
      }

      @Test
      @TestMetadata("javaStaticFunctionToExtensionFunctionWithTypeParameter.kt")
      public void testJavaStaticFunctionToExtensionFunctionWithTypeParameter() {
        runTest("compiler/testData/codegen/box/callableReference/function/javaStaticFunctionToExtensionFunctionWithTypeParameter.kt");
      }

      @Test
      @TestMetadata("kt21787.kt")
      public void testKt21787() {
        runTest("compiler/testData/codegen/box/callableReference/function/kt21787.kt");
      }

      @Test
      @TestMetadata("kt32462.kt")
      public void testKt32462() {
        runTest("compiler/testData/codegen/box/callableReference/function/kt32462.kt");
      }

      @Test
      @TestMetadata("kt47741.kt")
      public void testKt47741() {
        runTest("compiler/testData/codegen/box/callableReference/function/kt47741.kt");
      }

      @Test
      @TestMetadata("kt53794_protectedJavaMember.kt")
      public void testKt53794_protectedJavaMember() {
        runTest("compiler/testData/codegen/box/callableReference/function/kt53794_protectedJavaMember.kt");
      }

      @Test
      @TestMetadata("nestedConstructorFromClass.kt")
      public void testNestedConstructorFromClass() {
        runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromClass.kt");
      }

      @Test
      @TestMetadata("nestedConstructorFromTopLevelNoArgs.kt")
      public void testNestedConstructorFromTopLevelNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelNoArgs.kt");
      }

      @Test
      @TestMetadata("nestedConstructorFromTopLevelOneStringArg.kt")
      public void testNestedConstructorFromTopLevelOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelOneStringArg.kt");
      }

      @Test
      @TestMetadata("nestedExtensionInSAMInterface.kt")
      public void testNestedExtensionInSAMInterface() {
        runTest("compiler/testData/codegen/box/callableReference/function/nestedExtensionInSAMInterface.kt");
      }

      @Test
      @TestMetadata("nestedExtensionToJavaFun.kt")
      public void testNestedExtensionToJavaFun() {
        runTest("compiler/testData/codegen/box/callableReference/function/nestedExtensionToJavaFun.kt");
      }

      @Test
      @TestMetadata("newArray.kt")
      public void testNewArray() {
        runTest("compiler/testData/codegen/box/callableReference/function/newArray.kt");
      }

      @Test
      @TestMetadata("nullableExtension.kt")
      public void testNullableExtension() {
        runTest("compiler/testData/codegen/box/callableReference/function/nullableExtension.kt");
      }

      @Test
      @TestMetadata("overloadedFun.kt")
      public void testOverloadedFun() {
        runTest("compiler/testData/codegen/box/callableReference/function/overloadedFun.kt");
      }

      @Test
      @TestMetadata("overloadedFunVsVal.kt")
      public void testOverloadedFunVsVal() {
        runTest("compiler/testData/codegen/box/callableReference/function/overloadedFunVsVal.kt");
      }

      @Test
      @TestMetadata("privateClassMember.kt")
      public void testPrivateClassMember() {
        runTest("compiler/testData/codegen/box/callableReference/function/privateClassMember.kt");
      }

      @Test
      @TestMetadata("referenceToCompanionMember.kt")
      public void testReferenceToCompanionMember() {
        runTest("compiler/testData/codegen/box/callableReference/function/referenceToCompanionMember.kt");
      }

      @Test
      @TestMetadata("sortListOfStrings.kt")
      public void testSortListOfStrings() {
        runTest("compiler/testData/codegen/box/callableReference/function/sortListOfStrings.kt");
      }

      @Test
      @TestMetadata("specialCalls.kt")
      public void testSpecialCalls() {
        runTest("compiler/testData/codegen/box/callableReference/function/specialCalls.kt");
      }

      @Test
      @TestMetadata("staticFunctionReference.kt")
      public void testStaticFunctionReference() {
        runTest("compiler/testData/codegen/box/callableReference/function/staticFunctionReference.kt");
      }

      @Test
      @TestMetadata("topLevelFromClass.kt")
      public void testTopLevelFromClass() {
        runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromClass.kt");
      }

      @Test
      @TestMetadata("topLevelFromExtension.kt")
      public void testTopLevelFromExtension() {
        runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromExtension.kt");
      }

      @Test
      @TestMetadata("topLevelFromTopLevelStringNoArgs.kt")
      public void testTopLevelFromTopLevelStringNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringNoArgs.kt");
      }

      @Test
      @TestMetadata("topLevelFromTopLevelStringOneStringArg.kt")
      public void testTopLevelFromTopLevelStringOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringOneStringArg.kt");
      }

      @Test
      @TestMetadata("topLevelFromTopLevelUnitManyArgs.kt")
      public void testTopLevelFromTopLevelUnitManyArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitManyArgs.kt");
      }

      @Test
      @TestMetadata("topLevelFromTopLevelUnitNoArgs.kt")
      public void testTopLevelFromTopLevelUnitNoArgs() {
        runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitNoArgs.kt");
      }

      @Test
      @TestMetadata("topLevelFromTopLevelUnitOneStringArg.kt")
      public void testTopLevelFromTopLevelUnitOneStringArg() {
        runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitOneStringArg.kt");
      }

      @Test
      @TestMetadata("traitImplMethodWithClassReceiver.kt")
      public void testTraitImplMethodWithClassReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/function/traitImplMethodWithClassReceiver.kt");
      }

      @Test
      @TestMetadata("traitMember.kt")
      public void testTraitMember() {
        runTest("compiler/testData/codegen/box/callableReference/function/traitMember.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/callableReference/function/local")
      @TestDataPath("$PROJECT_ROOT")
      public class Local {
        @Test
        public void testAllFilesPresentInLocal() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("captureOuter.kt")
        public void testCaptureOuter() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/captureOuter.kt");
        }

        @Test
        @TestMetadata("classMember.kt")
        public void testClassMember() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/classMember.kt");
        }

        @Test
        @TestMetadata("closureWithSideEffect.kt")
        public void testClosureWithSideEffect() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/closureWithSideEffect.kt");
        }

        @Test
        @TestMetadata("constructor.kt")
        public void testConstructor() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/constructor.kt");
        }

        @Test
        @TestMetadata("constructorWithInitializer.kt")
        public void testConstructorWithInitializer() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/constructorWithInitializer.kt");
        }

        @Test
        @TestMetadata("enumExtendsTrait.kt")
        public void testEnumExtendsTrait() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/enumExtendsTrait.kt");
        }

        @Test
        @TestMetadata("equalsHashCode.kt")
        public void testEqualsHashCode() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/equalsHashCode.kt");
        }

        @Test
        @TestMetadata("extension.kt")
        public void testExtension() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/extension.kt");
        }

        @Test
        @TestMetadata("extensionToLocalClass.kt")
        public void testExtensionToLocalClass() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToLocalClass.kt");
        }

        @Test
        @TestMetadata("extensionToPrimitive.kt")
        public void testExtensionToPrimitive() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToPrimitive.kt");
        }

        @Test
        @TestMetadata("extensionWithClosure.kt")
        public void testExtensionWithClosure() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/extensionWithClosure.kt");
        }

        @Test
        @TestMetadata("genericMember.kt")
        public void testGenericMember() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/genericMember.kt");
        }

        @Test
        @TestMetadata("localClassMember.kt")
        public void testLocalClassMember() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/localClassMember.kt");
        }

        @Test
        @TestMetadata("localFunctionName.kt")
        public void testLocalFunctionName() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/localFunctionName.kt");
        }

        @Test
        @TestMetadata("localLocal.kt")
        public void testLocalLocal() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/localLocal.kt");
        }

        @Test
        @TestMetadata("recursiveClosure.kt")
        public void testRecursiveClosure() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/recursiveClosure.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/simple.kt");
        }

        @Test
        @TestMetadata("simpleClosure.kt")
        public void testSimpleClosure() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/simpleClosure.kt");
        }

        @Test
        @TestMetadata("simpleWithArg.kt")
        public void testSimpleWithArg() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/simpleWithArg.kt");
        }

        @Test
        @TestMetadata("unitWithSideEffect.kt")
        public void testUnitWithSideEffect() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/unitWithSideEffect.kt");
        }

        @Test
        @TestMetadata("withValueArguments.kt")
        public void testWithValueArguments() {
          runTest("compiler/testData/codegen/box/callableReference/function/local/withValueArguments.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/callableReference/property")
    @TestDataPath("$PROJECT_ROOT")
    public class Property {
      @Test
      @TestMetadata("accessViaSubclass.kt")
      public void testAccessViaSubclass() {
        runTest("compiler/testData/codegen/box/callableReference/property/accessViaSubclass.kt");
      }

      @Test
      @TestMetadata("accessorForPropertyWithPrivateSetter.kt")
      public void testAccessorForPropertyWithPrivateSetter() {
        runTest("compiler/testData/codegen/box/callableReference/property/accessorForPropertyWithPrivateSetter.kt");
      }

      @Test
      public void testAllFilesPresentInProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("delegated.kt")
      public void testDelegated() {
        runTest("compiler/testData/codegen/box/callableReference/property/delegated.kt");
      }

      @Test
      @TestMetadata("delegatedMutable.kt")
      public void testDelegatedMutable() {
        runTest("compiler/testData/codegen/box/callableReference/property/delegatedMutable.kt");
      }

      @Test
      @TestMetadata("enumNameOrdinal.kt")
      public void testEnumNameOrdinal() {
        runTest("compiler/testData/codegen/box/callableReference/property/enumNameOrdinal.kt");
      }

      @Test
      @TestMetadata("extensionProperty.kt")
      public void testExtensionProperty() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionProperty.kt");
      }

      @Test
      @TestMetadata("extensionPropertyInDelegatedJavaSam.kt")
      public void testExtensionPropertyInDelegatedJavaSam() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyInDelegatedJavaSam.kt");
      }

      @Test
      @TestMetadata("extensionPropertyInDelegatedSam.kt")
      public void testExtensionPropertyInDelegatedSam() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyInDelegatedSam.kt");
      }

      @Test
      @TestMetadata("extensionPropertyInSamInterface.kt")
      public void testExtensionPropertyInSamInterface() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyInSamInterface.kt");
      }

      @Test
      @TestMetadata("extensionPropertyPassedToDelegatedSam.kt")
      public void testExtensionPropertyPassedToDelegatedSam() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyPassedToDelegatedSam.kt");
      }

      @Test
      @TestMetadata("extensionPropertyReferenceWithExplicitType.kt")
      public void testExtensionPropertyReferenceWithExplicitType() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyReferenceWithExplicitType.kt");
      }

      @Test
      @TestMetadata("extensionPropertyReferenceWithTypeParameter.kt")
      public void testExtensionPropertyReferenceWithTypeParameter() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyReferenceWithTypeParameter.kt");
      }

      @Test
      @TestMetadata("extensionPropertyToJavaSAM.kt")
      public void testExtensionPropertyToJavaSAM() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyToJavaSAM.kt");
      }

      @Test
      @TestMetadata("extensionPropertyWithExtensionReceiver.kt")
      public void testExtensionPropertyWithExtensionReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyWithExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("extensionPropertyWithExtensionType.kt")
      public void testExtensionPropertyWithExtensionType() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionPropertyWithExtensionType.kt");
      }

      @Test
      @TestMetadata("extensionToArray.kt")
      public void testExtensionToArray() {
        runTest("compiler/testData/codegen/box/callableReference/property/extensionToArray.kt");
      }

      @Test
      @TestMetadata("genericProperty.kt")
      public void testGenericProperty() {
        runTest("compiler/testData/codegen/box/callableReference/property/genericProperty.kt");
      }

      @Test
      @TestMetadata("inEnum.kt")
      public void testInEnum() {
        runTest("compiler/testData/codegen/box/callableReference/property/inEnum.kt");
      }

      @Test
      @TestMetadata("inReceiverOfAnother.kt")
      public void testInReceiverOfAnother() {
        runTest("compiler/testData/codegen/box/callableReference/property/inReceiverOfAnother.kt");
      }

      @Test
      @TestMetadata("invokePropertyReference.kt")
      public void testInvokePropertyReference() {
        runTest("compiler/testData/codegen/box/callableReference/property/invokePropertyReference.kt");
      }

      @Test
      @TestMetadata("javaBeanConvention.kt")
      public void testJavaBeanConvention() {
        runTest("compiler/testData/codegen/box/callableReference/property/javaBeanConvention.kt");
      }

      @Test
      @TestMetadata("kClassInstanceIsInitializedFirst.kt")
      public void testKClassInstanceIsInitializedFirst() {
        runTest("compiler/testData/codegen/box/callableReference/property/kClassInstanceIsInitializedFirst.kt");
      }

      @Test
      @TestMetadata("kt12044.kt")
      public void testKt12044() {
        runTest("compiler/testData/codegen/box/callableReference/property/kt12044.kt");
      }

      @Test
      @TestMetadata("kt12982_protectedPropertyReference.kt")
      public void testKt12982_protectedPropertyReference() {
        runTest("compiler/testData/codegen/box/callableReference/property/kt12982_protectedPropertyReference.kt");
      }

      @Test
      @TestMetadata("kt14330.kt")
      public void testKt14330() {
        runTest("compiler/testData/codegen/box/callableReference/property/kt14330.kt");
      }

      @Test
      @TestMetadata("kt14330_2.kt")
      public void testKt14330_2() {
        runTest("compiler/testData/codegen/box/callableReference/property/kt14330_2.kt");
      }

      @Test
      @TestMetadata("kt15447.kt")
      public void testKt15447() {
        runTest("compiler/testData/codegen/box/callableReference/property/kt15447.kt");
      }

      @Test
      @TestMetadata("kt6870_privatePropertyReference.kt")
      public void testKt6870_privatePropertyReference() {
        runTest("compiler/testData/codegen/box/callableReference/property/kt6870_privatePropertyReference.kt");
      }

      @Test
      @TestMetadata("kt74104.kt")
      public void testKt74104() {
        runTest("compiler/testData/codegen/box/callableReference/property/kt74104.kt");
      }

      @Test
      @TestMetadata("listOfStringsMapLength.kt")
      public void testListOfStringsMapLength() {
        runTest("compiler/testData/codegen/box/callableReference/property/listOfStringsMapLength.kt");
      }

      @Test
      @TestMetadata("localClassVar.kt")
      public void testLocalClassVar() {
        runTest("compiler/testData/codegen/box/callableReference/property/localClassVar.kt");
      }

      @Test
      @TestMetadata("nullableExtensionProperty.kt")
      public void testNullableExtensionProperty() {
        runTest("compiler/testData/codegen/box/callableReference/property/nullableExtensionProperty.kt");
      }

      @Test
      @TestMetadata("overriddenInSubclass.kt")
      public void testOverriddenInSubclass() {
        runTest("compiler/testData/codegen/box/callableReference/property/overriddenInSubclass.kt");
      }

      @Test
      @TestMetadata("privateSetOuterClass.kt")
      public void testPrivateSetOuterClass() {
        runTest("compiler/testData/codegen/box/callableReference/property/privateSetOuterClass.kt");
      }

      @Test
      @TestMetadata("privateSetterInsideClass.kt")
      public void testPrivateSetterInsideClass() {
        runTest("compiler/testData/codegen/box/callableReference/property/privateSetterInsideClass.kt");
      }

      @Test
      @TestMetadata("privateSetterOutsideClass.kt")
      public void testPrivateSetterOutsideClass() {
        runTest("compiler/testData/codegen/box/callableReference/property/privateSetterOutsideClass.kt");
      }

      @Test
      @TestMetadata("receiverEvaluatedOnce.kt")
      public void testReceiverEvaluatedOnce() {
        runTest("compiler/testData/codegen/box/callableReference/property/receiverEvaluatedOnce.kt");
      }

      @Test
      @TestMetadata("simpleExtension.kt")
      public void testSimpleExtension() {
        runTest("compiler/testData/codegen/box/callableReference/property/simpleExtension.kt");
      }

      @Test
      @TestMetadata("simpleMember.kt")
      public void testSimpleMember() {
        runTest("compiler/testData/codegen/box/callableReference/property/simpleMember.kt");
      }

      @Test
      @TestMetadata("simpleMutableExtension.kt")
      public void testSimpleMutableExtension() {
        runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableExtension.kt");
      }

      @Test
      @TestMetadata("simpleMutableMember.kt")
      public void testSimpleMutableMember() {
        runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableMember.kt");
      }

      @Test
      @TestMetadata("simpleMutableTopLevel.kt")
      public void testSimpleMutableTopLevel() {
        runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableTopLevel.kt");
      }

      @Test
      @TestMetadata("simpleTopLevel.kt")
      public void testSimpleTopLevel() {
        runTest("compiler/testData/codegen/box/callableReference/property/simpleTopLevel.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/callableReference/serializability")
    @TestDataPath("$PROJECT_ROOT")
    public class Serializability {
      @Test
      @TestMetadata("adaptedReferences.kt")
      public void testAdaptedReferences() {
        runTest("compiler/testData/codegen/box/callableReference/serializability/adaptedReferences.kt");
      }

      @Test
      public void testAllFilesPresentInSerializability() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/serializability"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("boundWithNotSerializableReceiver.kt")
      public void testBoundWithNotSerializableReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/serializability/boundWithNotSerializableReceiver.kt");
      }

      @Test
      @TestMetadata("boundWithSerializableReceiver.kt")
      public void testBoundWithSerializableReceiver() {
        runTest("compiler/testData/codegen/box/callableReference/serializability/boundWithSerializableReceiver.kt");
      }

      @Test
      @TestMetadata("noReflect.kt")
      public void testNoReflect() {
        runTest("compiler/testData/codegen/box/callableReference/serializability/noReflect.kt");
      }

      @Test
      @TestMetadata("referenceToCompanionFunction.kt")
      public void testReferenceToCompanionFunction() {
        runTest("compiler/testData/codegen/box/callableReference/serializability/referenceToCompanionFunction.kt");
      }

      @Test
      @TestMetadata("reflectedIsNotSerialized.kt")
      public void testReflectedIsNotSerialized() {
        runTest("compiler/testData/codegen/box/callableReference/serializability/reflectedIsNotSerialized.kt");
      }

      @Test
      @TestMetadata("withReflect.kt")
      public void testWithReflect() {
        runTest("compiler/testData/codegen/box/callableReference/serializability/withReflect.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/casts")
  @TestDataPath("$PROJECT_ROOT")
  public class Casts {
    @Test
    public void testAllFilesPresentInCasts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arrayDowncastingContravariant.kt")
    public void testArrayDowncastingContravariant() {
      runTest("compiler/testData/codegen/box/casts/arrayDowncastingContravariant.kt");
    }

    @Test
    @TestMetadata("arrayDowncatingInvariant.kt")
    public void testArrayDowncatingInvariant() {
      runTest("compiler/testData/codegen/box/casts/arrayDowncatingInvariant.kt");
    }

    @Test
    @TestMetadata("arrayDownctingCovariant.kt")
    public void testArrayDownctingCovariant() {
      runTest("compiler/testData/codegen/box/casts/arrayDownctingCovariant.kt");
    }

    @Test
    @TestMetadata("as.kt")
    public void testAs() {
      runTest("compiler/testData/codegen/box/casts/as.kt");
    }

    @Test
    @TestMetadata("asForConstants.kt")
    public void testAsForConstants() {
      runTest("compiler/testData/codegen/box/casts/asForConstants.kt");
    }

    @Test
    @TestMetadata("asSafe.kt")
    public void testAsSafe() {
      runTest("compiler/testData/codegen/box/casts/asSafe.kt");
    }

    @Test
    @TestMetadata("asSafeFail.kt")
    public void testAsSafeFail() {
      runTest("compiler/testData/codegen/box/casts/asSafeFail.kt");
    }

    @Test
    @TestMetadata("asSafeForConstants.kt")
    public void testAsSafeForConstants() {
      runTest("compiler/testData/codegen/box/casts/asSafeForConstants.kt");
    }

    @Test
    @TestMetadata("asThrowsNpe_1_4.kt")
    public void testAsThrowsNpe_1_4() {
      runTest("compiler/testData/codegen/box/casts/asThrowsNpe_1_4.kt");
    }

    @Test
    @TestMetadata("asUnit.kt")
    public void testAsUnit() {
      runTest("compiler/testData/codegen/box/casts/asUnit.kt");
    }

    @Test
    @TestMetadata("asWithGeneric.kt")
    public void testAsWithGeneric() {
      runTest("compiler/testData/codegen/box/casts/asWithGeneric.kt");
    }

    @Test
    @TestMetadata("castGenericNull.kt")
    public void testCastGenericNull() {
      runTest("compiler/testData/codegen/box/casts/castGenericNull.kt");
    }

    @Test
    @TestMetadata("castToDefinitelyNotNullType.kt")
    public void testCastToDefinitelyNotNullType() {
      runTest("compiler/testData/codegen/box/casts/castToDefinitelyNotNullType.kt");
    }

    @Test
    @TestMetadata("dontCreateInconsistentTypeDuringStarProjectionSubstitution.kt")
    public void testDontCreateInconsistentTypeDuringStarProjectionSubstitution() {
      runTest("compiler/testData/codegen/box/casts/dontCreateInconsistentTypeDuringStarProjectionSubstitution.kt");
    }

    @Test
    @TestMetadata("genericReturnCast.kt")
    public void testGenericReturnCast() {
      runTest("compiler/testData/codegen/box/casts/genericReturnCast.kt");
    }

    @Test
    @TestMetadata("intersectionTypeMultipleBounds.kt")
    public void testIntersectionTypeMultipleBounds() {
      runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBounds.kt");
    }

    @Test
    @TestMetadata("intersectionTypeMultipleBoundsImplicitReceiver.kt")
    public void testIntersectionTypeMultipleBoundsImplicitReceiver() {
      runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBoundsImplicitReceiver.kt");
    }

    @Test
    @TestMetadata("intersectionTypeSmartcast.kt")
    public void testIntersectionTypeSmartcast() {
      runTest("compiler/testData/codegen/box/casts/intersectionTypeSmartcast.kt");
    }

    @Test
    @TestMetadata("intersectionTypeWithMultipleBoundsAsReceiver.kt")
    public void testIntersectionTypeWithMultipleBoundsAsReceiver() {
      runTest("compiler/testData/codegen/box/casts/intersectionTypeWithMultipleBoundsAsReceiver.kt");
    }

    @Test
    @TestMetadata("intersectionTypeWithoutGenericsAsReceiver.kt")
    public void testIntersectionTypeWithoutGenericsAsReceiver() {
      runTest("compiler/testData/codegen/box/casts/intersectionTypeWithoutGenericsAsReceiver.kt");
    }

    @Test
    @TestMetadata("is.kt")
    public void testIs() {
      runTest("compiler/testData/codegen/box/casts/is.kt");
    }

    @Test
    @TestMetadata("isNullablePrimitive.kt")
    public void testIsNullablePrimitive() {
      runTest("compiler/testData/codegen/box/casts/isNullablePrimitive.kt");
    }

    @Test
    @TestMetadata("kt22714.kt")
    public void testKt22714() {
      runTest("compiler/testData/codegen/box/casts/kt22714.kt");
    }

    @Test
    @TestMetadata("kt48927_privateMethodOnDerivedCastToBase.kt")
    public void testKt48927_privateMethodOnDerivedCastToBase() {
      runTest("compiler/testData/codegen/box/casts/kt48927_privateMethodOnDerivedCastToBase.kt");
    }

    @Test
    @TestMetadata("kt50577.kt")
    public void testKt50577() {
      runTest("compiler/testData/codegen/box/casts/kt50577.kt");
    }

    @Test
    @TestMetadata("kt53146.kt")
    public void testKt53146() {
      runTest("compiler/testData/codegen/box/casts/kt53146.kt");
    }

    @Test
    @TestMetadata("kt53677.kt")
    public void testKt53677() {
      runTest("compiler/testData/codegen/box/casts/kt53677.kt");
    }

    @Test
    @TestMetadata("kt54318.kt")
    public void testKt54318() {
      runTest("compiler/testData/codegen/box/casts/kt54318.kt");
    }

    @Test
    @TestMetadata("kt54581.kt")
    public void testKt54581() {
      runTest("compiler/testData/codegen/box/casts/kt54581.kt");
    }

    @Test
    @TestMetadata("kt54707.kt")
    public void testKt54707() {
      runTest("compiler/testData/codegen/box/casts/kt54707.kt");
    }

    @Test
    @TestMetadata("kt54802.kt")
    public void testKt54802() {
      runTest("compiler/testData/codegen/box/casts/kt54802.kt");
    }

    @Test
    @TestMetadata("kt55005.kt")
    public void testKt55005() {
      runTest("compiler/testData/codegen/box/casts/kt55005.kt");
    }

    @Test
    @TestMetadata("kt58707.kt")
    public void testKt58707() {
      runTest("compiler/testData/codegen/box/casts/kt58707.kt");
    }

    @Test
    @TestMetadata("kt59022.kt")
    public void testKt59022() {
      runTest("compiler/testData/codegen/box/casts/kt59022.kt");
    }

    @Test
    @TestMetadata("kt65197.kt")
    public void testKt65197() {
      runTest("compiler/testData/codegen/box/casts/kt65197.kt");
    }

    @Test
    @TestMetadata("kt68509.kt")
    public void testKt68509() {
      runTest("compiler/testData/codegen/box/casts/kt68509.kt");
    }

    @Test
    @TestMetadata("lambdaToUnitCast.kt")
    public void testLambdaToUnitCast() {
      runTest("compiler/testData/codegen/box/casts/lambdaToUnitCast.kt");
    }

    @Test
    @TestMetadata("notIs.kt")
    public void testNotIs() {
      runTest("compiler/testData/codegen/box/casts/notIs.kt");
    }

    @Test
    @TestMetadata("nullableSafeCastToTypeParameterWithInterfaceUpperBound.kt")
    public void testNullableSafeCastToTypeParameterWithInterfaceUpperBound() {
      runTest("compiler/testData/codegen/box/casts/nullableSafeCastToTypeParameterWithInterfaceUpperBound.kt");
    }

    @Test
    @TestMetadata("objectToPrimitiveWithAssertion.kt")
    public void testObjectToPrimitiveWithAssertion() {
      runTest("compiler/testData/codegen/box/casts/objectToPrimitiveWithAssertion.kt");
    }

    @Test
    @TestMetadata("unitAsAny.kt")
    public void testUnitAsAny() {
      runTest("compiler/testData/codegen/box/casts/unitAsAny.kt");
    }

    @Test
    @TestMetadata("unitAsInt.kt")
    public void testUnitAsInt() {
      runTest("compiler/testData/codegen/box/casts/unitAsInt.kt");
    }

    @Test
    @TestMetadata("unitAsSafeAny.kt")
    public void testUnitAsSafeAny() {
      runTest("compiler/testData/codegen/box/casts/unitAsSafeAny.kt");
    }

    @Test
    @TestMetadata("unitNullableCast.kt")
    public void testUnitNullableCast() {
      runTest("compiler/testData/codegen/box/casts/unitNullableCast.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/casts/functions")
    @TestDataPath("$PROJECT_ROOT")
    public class Functions {
      @Test
      public void testAllFilesPresentInFunctions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("asFunKBig.kt")
      public void testAsFunKBig() {
        runTest("compiler/testData/codegen/box/casts/functions/asFunKBig.kt");
      }

      @Test
      @TestMetadata("asFunKSmall.kt")
      public void testAsFunKSmall() {
        runTest("compiler/testData/codegen/box/casts/functions/asFunKSmall.kt");
      }

      @Test
      @TestMetadata("isFunKBig.kt")
      public void testIsFunKBig() {
        runTest("compiler/testData/codegen/box/casts/functions/isFunKBig.kt");
      }

      @Test
      @TestMetadata("isFunKSmall.kt")
      public void testIsFunKSmall() {
        runTest("compiler/testData/codegen/box/casts/functions/isFunKSmall.kt");
      }

      @Test
      @TestMetadata("isFunKSmallJVM.kt")
      public void testIsFunKSmallJVM() {
        runTest("compiler/testData/codegen/box/casts/functions/isFunKSmallJVM.kt");
      }

      @Test
      @TestMetadata("isFunKSmallNonJS.kt")
      public void testIsFunKSmallNonJS() {
        runTest("compiler/testData/codegen/box/casts/functions/isFunKSmallNonJS.kt");
      }

      @Test
      @TestMetadata("javaTypeIsFunK.kt")
      public void testJavaTypeIsFunK() {
        runTest("compiler/testData/codegen/box/casts/functions/javaTypeIsFunK.kt");
      }

      @Test
      @TestMetadata("reifiedAsFunKBig.kt")
      public void testReifiedAsFunKBig() {
        runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKBig.kt");
      }

      @Test
      @TestMetadata("reifiedAsFunKSmall.kt")
      public void testReifiedAsFunKSmall() {
        runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKSmall.kt");
      }

      @Test
      @TestMetadata("reifiedIsFunKBig.kt")
      public void testReifiedIsFunKBig() {
        runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKBig.kt");
      }

      @Test
      @TestMetadata("reifiedIsFunKSmall.kt")
      public void testReifiedIsFunKSmall() {
        runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKSmall.kt");
      }

      @Test
      @TestMetadata("reifiedSafeAsFunKBig.kt")
      public void testReifiedSafeAsFunKBig() {
        runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKBig.kt");
      }

      @Test
      @TestMetadata("reifiedSafeAsFunKSmall.kt")
      public void testReifiedSafeAsFunKSmall() {
        runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKSmall.kt");
      }

      @Test
      @TestMetadata("safeAsFunKBig.kt")
      public void testSafeAsFunKBig() {
        runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKBig.kt");
      }

      @Test
      @TestMetadata("safeAsFunKSmall.kt")
      public void testSafeAsFunKSmall() {
        runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKSmall.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/casts/javaInterop")
    @TestDataPath("$PROJECT_ROOT")
    public class JavaInterop {
      @Test
      public void testAllFilesPresentInJavaInterop() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/javaInterop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("castWithWrongType.kt")
      public void testCastWithWrongType() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/castWithWrongType.kt");
      }

      @Test
      @TestMetadata("implicitNotNullWithWrongType.kt")
      public void testImplicitNotNullWithWrongType() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/implicitNotNullWithWrongType.kt");
      }

      @Test
      @TestMetadata("instanceOfWithWrongType.kt")
      public void testInstanceOfWithWrongType() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/instanceOfWithWrongType.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnCollectionContains.kt")
      public void testNoNullCheckOnCollectionContains() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnCollectionContains.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnCollectionRemove.kt")
      public void testNoNullCheckOnCollectionRemove() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnCollectionRemove.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnListIndexOf.kt")
      public void testNoNullCheckOnListIndexOf() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnListIndexOf.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnListLastIndexOf.kt")
      public void testNoNullCheckOnListLastIndexOf() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnListLastIndexOf.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnMapContainsKey.kt")
      public void testNoNullCheckOnMapContainsKey() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapContainsKey.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnMapContainsValue.kt")
      public void testNoNullCheckOnMapContainsValue() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapContainsValue.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnMapGet.kt")
      public void testNoNullCheckOnMapGet() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapGet.kt");
      }

      @Test
      @TestMetadata("noNullCheckOnMapRemove.kt")
      public void testNoNullCheckOnMapRemove() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapRemove.kt");
      }

      @Test
      @TestMetadata("nullCheckOnMapGetOrDefault.kt")
      public void testNullCheckOnMapGetOrDefault() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/nullCheckOnMapGetOrDefault.kt");
      }

      @Test
      @TestMetadata("nullCheckOnMapRemove2.kt")
      public void testNullCheckOnMapRemove2() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/nullCheckOnMapRemove2.kt");
      }

      @Test
      @TestMetadata("safeCastWithWrongType.kt")
      public void testSafeCastWithWrongType() {
        runTest("compiler/testData/codegen/box/casts/javaInterop/safeCastWithWrongType.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument")
    @TestDataPath("$PROJECT_ROOT")
    public class LiteralExpressionAsGenericArgument {
      @Test
      public void testAllFilesPresentInLiteralExpressionAsGenericArgument() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("binaryExpressionCast.kt")
      public void testBinaryExpressionCast() {
        runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/binaryExpressionCast.kt");
      }

      @Test
      @TestMetadata("javaBox.kt")
      public void testJavaBox() {
        runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/javaBox.kt");
      }

      @Test
      @TestMetadata("labeledExpressionCast.kt")
      public void testLabeledExpressionCast() {
        runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/labeledExpressionCast.kt");
      }

      @Test
      @TestMetadata("parenthesizedExpressionCast.kt")
      public void testParenthesizedExpressionCast() {
        runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/parenthesizedExpressionCast.kt");
      }

      @Test
      @TestMetadata("superConstructor.kt")
      public void testSuperConstructor() {
        runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/superConstructor.kt");
      }

      @Test
      @TestMetadata("unaryExpressionCast.kt")
      public void testUnaryExpressionCast() {
        runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/unaryExpressionCast.kt");
      }

      @Test
      @TestMetadata("vararg.kt")
      public void testVararg() {
        runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/vararg.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/casts/mutableCollections")
    @TestDataPath("$PROJECT_ROOT")
    public class MutableCollections {
      @Test
      public void testAllFilesPresentInMutableCollections() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/mutableCollections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("asWithMutable.kt")
      public void testAsWithMutable() {
        runTest("compiler/testData/codegen/box/casts/mutableCollections/asWithMutable.kt");
      }

      @Test
      @TestMetadata("isWithMutable.kt")
      public void testIsWithMutable() {
        runTest("compiler/testData/codegen/box/casts/mutableCollections/isWithMutable.kt");
      }

      @Test
      @TestMetadata("mutabilityMarkerInterfaces.kt")
      public void testMutabilityMarkerInterfaces() {
        runTest("compiler/testData/codegen/box/casts/mutableCollections/mutabilityMarkerInterfaces.kt");
      }

      @Test
      @TestMetadata("reifiedAsWithMutable.kt")
      public void testReifiedAsWithMutable() {
        runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedAsWithMutable.kt");
      }

      @Test
      @TestMetadata("reifiedIsWithMutable.kt")
      public void testReifiedIsWithMutable() {
        runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedIsWithMutable.kt");
      }

      @Test
      @TestMetadata("reifiedSafeAsWithMutable.kt")
      public void testReifiedSafeAsWithMutable() {
        runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedSafeAsWithMutable.kt");
      }

      @Test
      @TestMetadata("safeAsWithMutable.kt")
      public void testSafeAsWithMutable() {
        runTest("compiler/testData/codegen/box/casts/mutableCollections/safeAsWithMutable.kt");
      }

      @Test
      @TestMetadata("weirdMutableCasts.kt")
      public void testWeirdMutableCasts() {
        runTest("compiler/testData/codegen/box/casts/mutableCollections/weirdMutableCasts.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/casts/nativeCCEMessage")
    @TestDataPath("$PROJECT_ROOT")
    public class NativeCCEMessage {
      @Test
      public void testAllFilesPresentInNativeCCEMessage() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/nativeCCEMessage"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/checkcastOptimization")
  @TestDataPath("$PROJECT_ROOT")
  public class CheckcastOptimization {
    @Test
    public void testAllFilesPresentInCheckcastOptimization() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/checkcastOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("kt19128.kt")
    public void testKt19128() {
      runTest("compiler/testData/codegen/box/checkcastOptimization/kt19128.kt");
    }

    @Test
    @TestMetadata("kt19246.kt")
    public void testKt19246() {
      runTest("compiler/testData/codegen/box/checkcastOptimization/kt19246.kt");
    }

    @Test
    @TestMetadata("kt47851.kt")
    public void testKt47851() {
      runTest("compiler/testData/codegen/box/checkcastOptimization/kt47851.kt");
    }

    @Test
    @TestMetadata("kt47851a.kt")
    public void testKt47851a() {
      runTest("compiler/testData/codegen/box/checkcastOptimization/kt47851a.kt");
    }

    @Test
    @TestMetadata("kt50215.kt")
    public void testKt50215() {
      runTest("compiler/testData/codegen/box/checkcastOptimization/kt50215.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/classDelegation")
  @TestDataPath("$PROJECT_ROOT")
  public class ClassDelegation {
    @Test
    public void testAllFilesPresentInClassDelegation() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classDelegation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("delegationAndJavaInterfaceWithDefault.kt")
    public void testDelegationAndJavaInterfaceWithDefault() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationAndJavaInterfaceWithDefault.kt");
    }

    @Test
    @TestMetadata("delegationInJJKHierarchy.kt")
    public void testDelegationInJJKHierarchy() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationInJJKHierarchy.kt");
    }

    @Test
    @TestMetadata("delegationInKJJHierarchy.kt")
    public void testDelegationInKJJHierarchy() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationInKJJHierarchy.kt");
    }

    @Test
    @TestMetadata("delegationToInOutTypeParameters.kt")
    public void testDelegationToInOutTypeParameters() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToInOutTypeParameters.kt");
    }

    @Test
    @TestMetadata("delegationToInTypeParameter.kt")
    public void testDelegationToInTypeParameter() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToInTypeParameter.kt");
    }

    @Test
    @TestMetadata("delegationToJavaImplementation.kt")
    public void testDelegationToJavaImplementation() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToJavaImplementation.kt");
    }

    @Test
    @TestMetadata("delegationToJavaWithInheritance.kt")
    public void testDelegationToJavaWithInheritance() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToJavaWithInheritance.kt");
    }

    @Test
    @TestMetadata("delegationToJavaWithIntersection.kt")
    public void testDelegationToJavaWithIntersection() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToJavaWithIntersection.kt");
    }

    @Test
    @TestMetadata("delegationToJavaWithTypeParameter.kt")
    public void testDelegationToJavaWithTypeParameter() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToJavaWithTypeParameter.kt");
    }

    @Test
    @TestMetadata("delegationToOutTypeParameter.kt")
    public void testDelegationToOutTypeParameter() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToOutTypeParameter.kt");
    }

    @Test
    @TestMetadata("delegationToStarProjectedType.kt")
    public void testDelegationToStarProjectedType() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToStarProjectedType.kt");
    }

    @Test
    @TestMetadata("delegationToTypeParameter.kt")
    public void testDelegationToTypeParameter() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToTypeParameter.kt");
    }

    @Test
    @TestMetadata("delegationToTypeParameterWithRecursiveBond.kt")
    public void testDelegationToTypeParameterWithRecursiveBond() {
      runTest("compiler/testData/codegen/box/classDelegation/delegationToTypeParameterWithRecursiveBond.kt");
    }

    @Test
    @TestMetadata("generic.kt")
    public void testGeneric() {
      runTest("compiler/testData/codegen/box/classDelegation/generic.kt");
    }

    @Test
    @TestMetadata("hiddenDelegateAndLateinitVar.kt")
    public void testHiddenDelegateAndLateinitVar() {
      runTest("compiler/testData/codegen/box/classDelegation/hiddenDelegateAndLateinitVar.kt");
    }

    @Test
    @TestMetadata("method.kt")
    public void testMethod() {
      runTest("compiler/testData/codegen/box/classDelegation/method.kt");
    }

    @Test
    @TestMetadata("multipleModules.kt")
    public void testMultipleModules() {
      runTest("compiler/testData/codegen/box/classDelegation/multipleModules.kt");
    }

    @Test
    @TestMetadata("property.kt")
    public void testProperty() {
      runTest("compiler/testData/codegen/box/classDelegation/property.kt");
    }

    @Test
    @TestMetadata("withBridge.kt")
    public void testWithBridge() {
      runTest("compiler/testData/codegen/box/classDelegation/withBridge.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/classLiteral")
  @TestDataPath("$PROJECT_ROOT")
  public class ClassLiteral {
    @Test
    public void testAllFilesPresentInClassLiteral() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("bareArray.kt")
    public void testBareArray() {
      runTest("compiler/testData/codegen/box/classLiteral/bareArray.kt");
    }

    @Test
    @TestMetadata("classEquality.kt")
    public void testClassEquality() {
      runTest("compiler/testData/codegen/box/classLiteral/classEquality.kt");
    }

    @Test
    @TestMetadata("primitiveClassEquality.kt")
    public void testPrimitiveClassEquality() {
      runTest("compiler/testData/codegen/box/classLiteral/primitiveClassEquality.kt");
    }

    @Test
    @TestMetadata("primitiveKClassEquality.kt")
    public void testPrimitiveKClassEquality() {
      runTest("compiler/testData/codegen/box/classLiteral/primitiveKClassEquality.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/classLiteral/bound")
    @TestDataPath("$PROJECT_ROOT")
    public class Bound {
      @Test
      public void testAllFilesPresentInBound() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("javaIntrinsicWithSideEffect.kt")
      public void testJavaIntrinsicWithSideEffect() {
        runTest("compiler/testData/codegen/box/classLiteral/bound/javaIntrinsicWithSideEffect.kt");
      }

      @Test
      @TestMetadata("primitives.kt")
      public void testPrimitives() {
        runTest("compiler/testData/codegen/box/classLiteral/bound/primitives.kt");
      }

      @Test
      @TestMetadata("sideEffect.kt")
      public void testSideEffect() {
        runTest("compiler/testData/codegen/box/classLiteral/bound/sideEffect.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/classLiteral/bound/simple.kt");
      }

      @Test
      @TestMetadata("smartCast.kt")
      public void testSmartCast() {
        runTest("compiler/testData/codegen/box/classLiteral/bound/smartCast.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/classLiteral/java")
    @TestDataPath("$PROJECT_ROOT")
    public class Java {
      @Test
      public void testAllFilesPresentInJava() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/java"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("java.kt")
      public void testJava() {
        runTest("compiler/testData/codegen/box/classLiteral/java/java.kt");
      }

      @Test
      @TestMetadata("javaObjectType.kt")
      public void testJavaObjectType() {
        runTest("compiler/testData/codegen/box/classLiteral/java/javaObjectType.kt");
      }

      @Test
      @TestMetadata("javaObjectTypeReified.kt")
      public void testJavaObjectTypeReified() {
        runTest("compiler/testData/codegen/box/classLiteral/java/javaObjectTypeReified.kt");
      }

      @Test
      @TestMetadata("javaPrimitiveType.kt")
      public void testJavaPrimitiveType() {
        runTest("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveType.kt");
      }

      @Test
      @TestMetadata("javaPrimitiveTypeReified.kt")
      public void testJavaPrimitiveTypeReified() {
        runTest("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveTypeReified.kt");
      }

      @Test
      @TestMetadata("javaReified.kt")
      public void testJavaReified() {
        runTest("compiler/testData/codegen/box/classLiteral/java/javaReified.kt");
      }

      @Test
      @TestMetadata("kt11943.kt")
      public void testKt11943() {
        runTest("compiler/testData/codegen/box/classLiteral/java/kt11943.kt");
      }

      @Test
      @TestMetadata("objectSuperConstructorCall.kt")
      public void testObjectSuperConstructorCall() {
        runTest("compiler/testData/codegen/box/classLiteral/java/objectSuperConstructorCall.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/classes")
  @TestDataPath("$PROJECT_ROOT")
  public class Classes {
    @Test
    public void testAllFilesPresentInClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("boxPrimitiveTypeInClinitOfClassObject.kt")
    public void testBoxPrimitiveTypeInClinitOfClassObject() {
      runTest("compiler/testData/codegen/box/classes/boxPrimitiveTypeInClinitOfClassObject.kt");
    }

    @Test
    @TestMetadata("classCompanionInitializationWithJava.kt")
    public void testClassCompanionInitializationWithJava() {
      runTest("compiler/testData/codegen/box/classes/classCompanionInitializationWithJava.kt");
    }

    @Test
    @TestMetadata("classNamedAsOldPackageFacade.kt")
    public void testClassNamedAsOldPackageFacade() {
      runTest("compiler/testData/codegen/box/classes/classNamedAsOldPackageFacade.kt");
    }

    @Test
    @TestMetadata("classObject.kt")
    public void testClassObject() {
      runTest("compiler/testData/codegen/box/classes/classObject.kt");
    }

    @Test
    @TestMetadata("classObjectAsExtensionReceiver.kt")
    public void testClassObjectAsExtensionReceiver() {
      runTest("compiler/testData/codegen/box/classes/classObjectAsExtensionReceiver.kt");
    }

    @Test
    @TestMetadata("classObjectAsStaticInitializer.kt")
    public void testClassObjectAsStaticInitializer() {
      runTest("compiler/testData/codegen/box/classes/classObjectAsStaticInitializer.kt");
    }

    @Test
    @TestMetadata("classObjectField.kt")
    public void testClassObjectField() {
      runTest("compiler/testData/codegen/box/classes/classObjectField.kt");
    }

    @Test
    @TestMetadata("classObjectInTrait.kt")
    public void testClassObjectInTrait() {
      runTest("compiler/testData/codegen/box/classes/classObjectInTrait.kt");
    }

    @Test
    @TestMetadata("classObjectNotOfEnum.kt")
    public void testClassObjectNotOfEnum() {
      runTest("compiler/testData/codegen/box/classes/classObjectNotOfEnum.kt");
    }

    @Test
    @TestMetadata("classObjectToString.kt")
    public void testClassObjectToString() {
      runTest("compiler/testData/codegen/box/classes/classObjectToString.kt");
    }

    @Test
    @TestMetadata("classObjectWithPrivateGenericMember.kt")
    public void testClassObjectWithPrivateGenericMember() {
      runTest("compiler/testData/codegen/box/classes/classObjectWithPrivateGenericMember.kt");
    }

    @Test
    @TestMetadata("classObjectsWithParentClasses.kt")
    public void testClassObjectsWithParentClasses() {
      runTest("compiler/testData/codegen/box/classes/classObjectsWithParentClasses.kt");
    }

    @Test
    @TestMetadata("comanionObjectFieldVsClassField.kt")
    public void testComanionObjectFieldVsClassField() {
      runTest("compiler/testData/codegen/box/classes/comanionObjectFieldVsClassField.kt");
    }

    @Test
    @TestMetadata("defaultObjectSameNamesAsInOuter.kt")
    public void testDefaultObjectSameNamesAsInOuter() {
      runTest("compiler/testData/codegen/box/classes/defaultObjectSameNamesAsInOuter.kt");
    }

    @Test
    @TestMetadata("delegateConstructorCallWithKeywords.kt")
    public void testDelegateConstructorCallWithKeywords() {
      runTest("compiler/testData/codegen/box/classes/delegateConstructorCallWithKeywords.kt");
    }

    @Test
    @TestMetadata("delegation2.kt")
    public void testDelegation2() {
      runTest("compiler/testData/codegen/box/classes/delegation2.kt");
    }

    @Test
    @TestMetadata("delegation3.kt")
    public void testDelegation3() {
      runTest("compiler/testData/codegen/box/classes/delegation3.kt");
    }

    @Test
    @TestMetadata("delegation4.kt")
    public void testDelegation4() {
      runTest("compiler/testData/codegen/box/classes/delegation4.kt");
    }

    @Test
    @TestMetadata("delegationGenericArg.kt")
    public void testDelegationGenericArg() {
      runTest("compiler/testData/codegen/box/classes/delegationGenericArg.kt");
    }

    @Test
    @TestMetadata("delegationGenericArgUpperBound.kt")
    public void testDelegationGenericArgUpperBound() {
      runTest("compiler/testData/codegen/box/classes/delegationGenericArgUpperBound.kt");
    }

    @Test
    @TestMetadata("delegationGenericLongArg.kt")
    public void testDelegationGenericLongArg() {
      runTest("compiler/testData/codegen/box/classes/delegationGenericLongArg.kt");
    }

    @Test
    @TestMetadata("delegationJava.kt")
    public void testDelegationJava() {
      runTest("compiler/testData/codegen/box/classes/delegationJava.kt");
    }

    @Test
    @TestMetadata("delegationMethodsWithArgs.kt")
    public void testDelegationMethodsWithArgs() {
      runTest("compiler/testData/codegen/box/classes/delegationMethodsWithArgs.kt");
    }

    @Test
    @TestMetadata("exceptionConstructor.kt")
    public void testExceptionConstructor() {
      runTest("compiler/testData/codegen/box/classes/exceptionConstructor.kt");
    }

    @Test
    @TestMetadata("extensionFunWithDefaultParam.kt")
    public void testExtensionFunWithDefaultParam() {
      runTest("compiler/testData/codegen/box/classes/extensionFunWithDefaultParam.kt");
    }

    @Test
    @TestMetadata("extensionOnNamedClassObject.kt")
    public void testExtensionOnNamedClassObject() {
      runTest("compiler/testData/codegen/box/classes/extensionOnNamedClassObject.kt");
    }

    @Test
    @TestMetadata("funDelegation.kt")
    public void testFunDelegation() {
      runTest("compiler/testData/codegen/box/classes/funDelegation.kt");
    }

    @Test
    @TestMetadata("implementComparableInSubclass.kt")
    public void testImplementComparableInSubclass() {
      runTest("compiler/testData/codegen/box/classes/implementComparableInSubclass.kt");
    }

    @Test
    @TestMetadata("inheritSetAndHashSet.kt")
    public void testInheritSetAndHashSet() {
      runTest("compiler/testData/codegen/box/classes/inheritSetAndHashSet.kt");
    }

    @Test
    @TestMetadata("inheritance.kt")
    public void testInheritance() {
      runTest("compiler/testData/codegen/box/classes/inheritance.kt");
    }

    @Test
    @TestMetadata("inheritedInnerClass.kt")
    public void testInheritedInnerClass() {
      runTest("compiler/testData/codegen/box/classes/inheritedInnerClass.kt");
    }

    @Test
    @TestMetadata("inheritedMethod.kt")
    public void testInheritedMethod() {
      runTest("compiler/testData/codegen/box/classes/inheritedMethod.kt");
    }

    @Test
    @TestMetadata("initializerBlock.kt")
    public void testInitializerBlock() {
      runTest("compiler/testData/codegen/box/classes/initializerBlock.kt");
    }

    @Test
    @TestMetadata("initializerBlockDImpl.kt")
    public void testInitializerBlockDImpl() {
      runTest("compiler/testData/codegen/box/classes/initializerBlockDImpl.kt");
    }

    @Test
    @TestMetadata("initializerBlockResetToDefault.kt")
    public void testInitializerBlockResetToDefault() {
      runTest("compiler/testData/codegen/box/classes/initializerBlockResetToDefault.kt");
    }

    @Test
    @TestMetadata("innerClass.kt")
    public void testInnerClass() {
      runTest("compiler/testData/codegen/box/classes/innerClass.kt");
    }

    @Test
    @TestMetadata("interfaceCompanionInitializationWithJava.kt")
    public void testInterfaceCompanionInitializationWithJava() {
      runTest("compiler/testData/codegen/box/classes/interfaceCompanionInitializationWithJava.kt");
    }

    @Test
    @TestMetadata("kt1018.kt")
    public void testKt1018() {
      runTest("compiler/testData/codegen/box/classes/kt1018.kt");
    }

    @Test
    @TestMetadata("kt1120.kt")
    public void testKt1120() {
      runTest("compiler/testData/codegen/box/classes/kt1120.kt");
    }

    @Test
    @TestMetadata("kt1134.kt")
    public void testKt1134() {
      runTest("compiler/testData/codegen/box/classes/kt1134.kt");
    }

    @Test
    @TestMetadata("kt1157.kt")
    public void testKt1157() {
      runTest("compiler/testData/codegen/box/classes/kt1157.kt");
    }

    @Test
    @TestMetadata("kt1247.kt")
    public void testKt1247() {
      runTest("compiler/testData/codegen/box/classes/kt1247.kt");
    }

    @Test
    @TestMetadata("kt1345.kt")
    public void testKt1345() {
      runTest("compiler/testData/codegen/box/classes/kt1345.kt");
    }

    @Test
    @TestMetadata("kt1439.kt")
    public void testKt1439() {
      runTest("compiler/testData/codegen/box/classes/kt1439.kt");
    }

    @Test
    @TestMetadata("kt1535.kt")
    public void testKt1535() {
      runTest("compiler/testData/codegen/box/classes/kt1535.kt");
    }

    @Test
    @TestMetadata("kt1538.kt")
    public void testKt1538() {
      runTest("compiler/testData/codegen/box/classes/kt1538.kt");
    }

    @Test
    @TestMetadata("kt1578.kt")
    public void testKt1578() {
      runTest("compiler/testData/codegen/box/classes/kt1578.kt");
    }

    @Test
    @TestMetadata("kt1611.kt")
    public void testKt1611() {
      runTest("compiler/testData/codegen/box/classes/kt1611.kt");
    }

    @Test
    @TestMetadata("kt1721.kt")
    public void testKt1721() {
      runTest("compiler/testData/codegen/box/classes/kt1721.kt");
    }

    @Test
    @TestMetadata("kt1726.kt")
    public void testKt1726() {
      runTest("compiler/testData/codegen/box/classes/kt1726.kt");
    }

    @Test
    @TestMetadata("kt1759.kt")
    public void testKt1759() {
      runTest("compiler/testData/codegen/box/classes/kt1759.kt");
    }

    @Test
    @TestMetadata("kt1891.kt")
    public void testKt1891() {
      runTest("compiler/testData/codegen/box/classes/kt1891.kt");
    }

    @Test
    @TestMetadata("kt1918.kt")
    public void testKt1918() {
      runTest("compiler/testData/codegen/box/classes/kt1918.kt");
    }

    @Test
    @TestMetadata("kt1976.kt")
    public void testKt1976() {
      runTest("compiler/testData/codegen/box/classes/kt1976.kt");
    }

    @Test
    @TestMetadata("kt1980.kt")
    public void testKt1980() {
      runTest("compiler/testData/codegen/box/classes/kt1980.kt");
    }

    @Test
    @TestMetadata("kt2224.kt")
    public void testKt2224() {
      runTest("compiler/testData/codegen/box/classes/kt2224.kt");
    }

    @Test
    @TestMetadata("kt2288.kt")
    public void testKt2288() {
      runTest("compiler/testData/codegen/box/classes/kt2288.kt");
    }

    @Test
    @TestMetadata("kt2384.kt")
    public void testKt2384() {
      runTest("compiler/testData/codegen/box/classes/kt2384.kt");
    }

    @Test
    @TestMetadata("kt2390.kt")
    public void testKt2390() {
      runTest("compiler/testData/codegen/box/classes/kt2390.kt");
    }

    @Test
    @TestMetadata("kt2391.kt")
    public void testKt2391() {
      runTest("compiler/testData/codegen/box/classes/kt2391.kt");
    }

    @Test
    @TestMetadata("kt2395.kt")
    public void testKt2395() {
      runTest("compiler/testData/codegen/box/classes/kt2395.kt");
    }

    @Test
    @TestMetadata("kt2417.kt")
    public void testKt2417() {
      runTest("compiler/testData/codegen/box/classes/kt2417.kt");
    }

    @Test
    @TestMetadata("kt2477.kt")
    public void testKt2477() {
      runTest("compiler/testData/codegen/box/classes/kt2477.kt");
    }

    @Test
    @TestMetadata("kt2480.kt")
    public void testKt2480() {
      runTest("compiler/testData/codegen/box/classes/kt2480.kt");
    }

    @Test
    @TestMetadata("kt2482.kt")
    public void testKt2482() {
      runTest("compiler/testData/codegen/box/classes/kt2482.kt");
    }

    @Test
    @TestMetadata("kt2485.kt")
    public void testKt2485() {
      runTest("compiler/testData/codegen/box/classes/kt2485.kt");
    }

    @Test
    @TestMetadata("kt249.kt")
    public void testKt249() {
      runTest("compiler/testData/codegen/box/classes/kt249.kt");
    }

    @Test
    @TestMetadata("kt2532.kt")
    public void testKt2532() {
      runTest("compiler/testData/codegen/box/classes/kt2532.kt");
    }

    @Test
    @TestMetadata("kt2566.kt")
    public void testKt2566() {
      runTest("compiler/testData/codegen/box/classes/kt2566.kt");
    }

    @Test
    @TestMetadata("kt2566_2.kt")
    public void testKt2566_2() {
      runTest("compiler/testData/codegen/box/classes/kt2566_2.kt");
    }

    @Test
    @TestMetadata("kt2607.kt")
    public void testKt2607() {
      runTest("compiler/testData/codegen/box/classes/kt2607.kt");
    }

    @Test
    @TestMetadata("kt2626.kt")
    public void testKt2626() {
      runTest("compiler/testData/codegen/box/classes/kt2626.kt");
    }

    @Test
    @TestMetadata("kt2711.kt")
    public void testKt2711() {
      runTest("compiler/testData/codegen/box/classes/kt2711.kt");
    }

    @Test
    @TestMetadata("kt2784.kt")
    public void testKt2784() {
      runTest("compiler/testData/codegen/box/classes/kt2784.kt");
    }

    @Test
    @TestMetadata("kt285.kt")
    public void testKt285() {
      runTest("compiler/testData/codegen/box/classes/kt285.kt");
    }

    @Test
    @TestMetadata("kt3001.kt")
    public void testKt3001() {
      runTest("compiler/testData/codegen/box/classes/kt3001.kt");
    }

    @Test
    @TestMetadata("kt3114.kt")
    public void testKt3114() {
      runTest("compiler/testData/codegen/box/classes/kt3114.kt");
    }

    @Test
    @TestMetadata("kt3414.kt")
    public void testKt3414() {
      runTest("compiler/testData/codegen/box/classes/kt3414.kt");
    }

    @Test
    @TestMetadata("kt343.kt")
    public void testKt343() {
      runTest("compiler/testData/codegen/box/classes/kt343.kt");
    }

    @Test
    @TestMetadata("kt3546.kt")
    public void testKt3546() {
      runTest("compiler/testData/codegen/box/classes/kt3546.kt");
    }

    @Test
    @TestMetadata("kt40332.kt")
    public void testKt40332() {
      runTest("compiler/testData/codegen/box/classes/kt40332.kt");
    }

    @Test
    @TestMetadata("kt454.kt")
    public void testKt454() {
      runTest("compiler/testData/codegen/box/classes/kt454.kt");
    }

    @Test
    @TestMetadata("kt471.kt")
    public void testKt471() {
      runTest("compiler/testData/codegen/box/classes/kt471.kt");
    }

    @Test
    @TestMetadata("kt48.kt")
    public void testKt48() {
      runTest("compiler/testData/codegen/box/classes/kt48.kt");
    }

    @Test
    @TestMetadata("kt496.kt")
    public void testKt496() {
      runTest("compiler/testData/codegen/box/classes/kt496.kt");
    }

    @Test
    @TestMetadata("kt500.kt")
    public void testKt500() {
      runTest("compiler/testData/codegen/box/classes/kt500.kt");
    }

    @Test
    @TestMetadata("kt501.kt")
    public void testKt501() {
      runTest("compiler/testData/codegen/box/classes/kt501.kt");
    }

    @Test
    @TestMetadata("kt504.kt")
    public void testKt504() {
      runTest("compiler/testData/codegen/box/classes/kt504.kt");
    }

    @Test
    @TestMetadata("kt508.kt")
    public void testKt508() {
      runTest("compiler/testData/codegen/box/classes/kt508.kt");
    }

    @Test
    @TestMetadata("kt53007.kt")
    public void testKt53007() {
      runTest("compiler/testData/codegen/box/classes/kt53007.kt");
    }

    @Test
    @TestMetadata("kt5347.kt")
    public void testKt5347() {
      runTest("compiler/testData/codegen/box/classes/kt5347.kt");
    }

    @Test
    @TestMetadata("kt6136.kt")
    public void testKt6136() {
      runTest("compiler/testData/codegen/box/classes/kt6136.kt");
    }

    @Test
    @TestMetadata("kt633.kt")
    public void testKt633() {
      runTest("compiler/testData/codegen/box/classes/kt633.kt");
    }

    @Test
    @TestMetadata("kt6816.kt")
    public void testKt6816() {
      runTest("compiler/testData/codegen/box/classes/kt6816.kt");
    }

    @Test
    @TestMetadata("kt707.kt")
    public void testKt707() {
      runTest("compiler/testData/codegen/box/classes/kt707.kt");
    }

    @Test
    @TestMetadata("kt723.kt")
    public void testKt723() {
      runTest("compiler/testData/codegen/box/classes/kt723.kt");
    }

    @Test
    @TestMetadata("kt725.kt")
    public void testKt725() {
      runTest("compiler/testData/codegen/box/classes/kt725.kt");
    }

    @Test
    @TestMetadata("kt8011.kt")
    public void testKt8011() {
      runTest("compiler/testData/codegen/box/classes/kt8011.kt");
    }

    @Test
    @TestMetadata("kt8011a.kt")
    public void testKt8011a() {
      runTest("compiler/testData/codegen/box/classes/kt8011a.kt");
    }

    @Test
    @TestMetadata("kt903.kt")
    public void testKt903() {
      runTest("compiler/testData/codegen/box/classes/kt903.kt");
    }

    @Test
    @TestMetadata("kt940.kt")
    public void testKt940() {
      runTest("compiler/testData/codegen/box/classes/kt940.kt");
    }

    @Test
    @TestMetadata("kt9642.kt")
    public void testKt9642() {
      runTest("compiler/testData/codegen/box/classes/kt9642.kt");
    }

    @Test
    @TestMetadata("namedClassObject.kt")
    public void testNamedClassObject() {
      runTest("compiler/testData/codegen/box/classes/namedClassObject.kt");
    }

    @Test
    @TestMetadata("nestedInitBlocksWithLambda.kt")
    public void testNestedInitBlocksWithLambda() {
      runTest("compiler/testData/codegen/box/classes/nestedInitBlocksWithLambda.kt");
    }

    @Test
    @TestMetadata("outerThis.kt")
    public void testOuterThis() {
      runTest("compiler/testData/codegen/box/classes/outerThis.kt");
    }

    @Test
    @TestMetadata("overloadBinaryOperator.kt")
    public void testOverloadBinaryOperator() {
      runTest("compiler/testData/codegen/box/classes/overloadBinaryOperator.kt");
    }

    @Test
    @TestMetadata("overloadPlusAssign.kt")
    public void testOverloadPlusAssign() {
      runTest("compiler/testData/codegen/box/classes/overloadPlusAssign.kt");
    }

    @Test
    @TestMetadata("overloadPlusAssignReturn.kt")
    public void testOverloadPlusAssignReturn() {
      runTest("compiler/testData/codegen/box/classes/overloadPlusAssignReturn.kt");
    }

    @Test
    @TestMetadata("overloadPlusToPlusAssign.kt")
    public void testOverloadPlusToPlusAssign() {
      runTest("compiler/testData/codegen/box/classes/overloadPlusToPlusAssign.kt");
    }

    @Test
    @TestMetadata("overloadUnaryOperator.kt")
    public void testOverloadUnaryOperator() {
      runTest("compiler/testData/codegen/box/classes/overloadUnaryOperator.kt");
    }

    @Test
    @TestMetadata("privateOuterFunctions.kt")
    public void testPrivateOuterFunctions() {
      runTest("compiler/testData/codegen/box/classes/privateOuterFunctions.kt");
    }

    @Test
    @TestMetadata("privateOuterProperty.kt")
    public void testPrivateOuterProperty() {
      runTest("compiler/testData/codegen/box/classes/privateOuterProperty.kt");
    }

    @Test
    @TestMetadata("privateToThis.kt")
    public void testPrivateToThis() {
      runTest("compiler/testData/codegen/box/classes/privateToThis.kt");
    }

    @Test
    @TestMetadata("propertyDelegation.kt")
    public void testPropertyDelegation() {
      runTest("compiler/testData/codegen/box/classes/propertyDelegation.kt");
    }

    @Test
    @TestMetadata("propertyInInitializer.kt")
    public void testPropertyInInitializer() {
      runTest("compiler/testData/codegen/box/classes/propertyInInitializer.kt");
    }

    @Test
    @TestMetadata("quotedClassName.kt")
    public void testQuotedClassName() {
      runTest("compiler/testData/codegen/box/classes/quotedClassName.kt");
    }

    @Test
    @TestMetadata("rightHandOverride.kt")
    public void testRightHandOverride() {
      runTest("compiler/testData/codegen/box/classes/rightHandOverride.kt");
    }

    @Test
    @TestMetadata("selfcreate.kt")
    public void testSelfcreate() {
      runTest("compiler/testData/codegen/box/classes/selfcreate.kt");
    }

    @Test
    @TestMetadata("simpleBox.kt")
    public void testSimpleBox() {
      runTest("compiler/testData/codegen/box/classes/simpleBox.kt");
    }

    @Test
    @TestMetadata("superConstructorCallWithComplexArg.kt")
    public void testSuperConstructorCallWithComplexArg() {
      runTest("compiler/testData/codegen/box/classes/superConstructorCallWithComplexArg.kt");
    }

    @Test
    @TestMetadata("typedDelegation.kt")
    public void testTypedDelegation() {
      runTest("compiler/testData/codegen/box/classes/typedDelegation.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/classes/inner")
    @TestDataPath("$PROJECT_ROOT")
    public class Inner {
      @Test
      public void testAllFilesPresentInInner() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classes/inner"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("extensionWithOuter.kt")
      public void testExtensionWithOuter() {
        runTest("compiler/testData/codegen/box/classes/inner/extensionWithOuter.kt");
      }

      @Test
      @TestMetadata("innerClassDerivedFromOuterClass.kt")
      public void testInnerClassDerivedFromOuterClass() {
        runTest("compiler/testData/codegen/box/classes/inner/innerClassDerivedFromOuterClass.kt");
      }

      @Test
      @TestMetadata("instantiateInDerived.kt")
      public void testInstantiateInDerived() {
        runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerived.kt");
      }

      @Test
      @TestMetadata("instantiateInDerivedLabeled.kt")
      public void testInstantiateInDerivedLabeled() {
        runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerivedLabeled.kt");
      }

      @Test
      @TestMetadata("instantiateInSameClass.kt")
      public void testInstantiateInSameClass() {
        runTest("compiler/testData/codegen/box/classes/inner/instantiateInSameClass.kt");
      }

      @Test
      @TestMetadata("kt6708.kt")
      public void testKt6708() {
        runTest("compiler/testData/codegen/box/classes/inner/kt6708.kt");
      }

      @Test
      @TestMetadata("properOuter.kt")
      public void testProperOuter() {
        runTest("compiler/testData/codegen/box/classes/inner/properOuter.kt");
      }

      @Test
      @TestMetadata("properSuperLinking.kt")
      public void testProperSuperLinking() {
        runTest("compiler/testData/codegen/box/classes/inner/properSuperLinking.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/closures")
  @TestDataPath("$PROJECT_ROOT")
  public class Closures {
    @Test
    public void testAllFilesPresentInClosures() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("anonymousObjectAsLastExpressionInLambda.kt")
    public void testAnonymousObjectAsLastExpressionInLambda() {
      runTest("compiler/testData/codegen/box/closures/anonymousObjectAsLastExpressionInLambda.kt");
    }

    @Test
    @TestMetadata("captureExtensionReceiver.kt")
    public void testCaptureExtensionReceiver() {
      runTest("compiler/testData/codegen/box/closures/captureExtensionReceiver.kt");
    }

    @Test
    @TestMetadata("captureExtensionReceiverX2.kt")
    public void testCaptureExtensionReceiverX2() {
      runTest("compiler/testData/codegen/box/closures/captureExtensionReceiverX2.kt");
    }

    @Test
    @TestMetadata("capturedLocalGenericFun.kt")
    public void testCapturedLocalGenericFun() {
      runTest("compiler/testData/codegen/box/closures/capturedLocalGenericFun.kt");
    }

    @Test
    @TestMetadata("closureCapturingGenericParam.kt")
    public void testClosureCapturingGenericParam() {
      runTest("compiler/testData/codegen/box/closures/closureCapturingGenericParam.kt");
    }

    @Test
    @TestMetadata("closureInsideConstrucor.kt")
    public void testClosureInsideConstrucor() {
      runTest("compiler/testData/codegen/box/closures/closureInsideConstrucor.kt");
    }

    @Test
    @TestMetadata("closureOnTopLevel1.kt")
    public void testClosureOnTopLevel1() {
      runTest("compiler/testData/codegen/box/closures/closureOnTopLevel1.kt");
    }

    @Test
    @TestMetadata("closureOnTopLevel2.kt")
    public void testClosureOnTopLevel2() {
      runTest("compiler/testData/codegen/box/closures/closureOnTopLevel2.kt");
    }

    @Test
    @TestMetadata("closureWithParameter.kt")
    public void testClosureWithParameter() {
      runTest("compiler/testData/codegen/box/closures/closureWithParameter.kt");
    }

    @Test
    @TestMetadata("closureWithParameterAndBoxing.kt")
    public void testClosureWithParameterAndBoxing() {
      runTest("compiler/testData/codegen/box/closures/closureWithParameterAndBoxing.kt");
    }

    @Test
    @TestMetadata("closuresAsSingleton.kt")
    public void testClosuresAsSingleton() {
      runTest("compiler/testData/codegen/box/closures/closuresAsSingleton.kt");
    }

    @Test
    @TestMetadata("crossinlineLocalDeclaration.kt")
    public void testCrossinlineLocalDeclaration() {
      runTest("compiler/testData/codegen/box/closures/crossinlineLocalDeclaration.kt");
    }

    @Test
    @TestMetadata("doubleEnclosedLocalVariable.kt")
    public void testDoubleEnclosedLocalVariable() {
      runTest("compiler/testData/codegen/box/closures/doubleEnclosedLocalVariable.kt");
    }

    @Test
    @TestMetadata("enclosingLocalVariable.kt")
    public void testEnclosingLocalVariable() {
      runTest("compiler/testData/codegen/box/closures/enclosingLocalVariable.kt");
    }

    @Test
    @TestMetadata("enclosingThis.kt")
    public void testEnclosingThis() {
      runTest("compiler/testData/codegen/box/closures/enclosingThis.kt");
    }

    @Test
    @TestMetadata("extensionClosure.kt")
    public void testExtensionClosure() {
      runTest("compiler/testData/codegen/box/closures/extensionClosure.kt");
    }

    @Test
    @TestMetadata("kt10044.kt")
    public void testKt10044() {
      runTest("compiler/testData/codegen/box/closures/kt10044.kt");
    }

    @Test
    @TestMetadata("kt11634.kt")
    public void testKt11634() {
      runTest("compiler/testData/codegen/box/closures/kt11634.kt");
    }

    @Test
    @TestMetadata("kt11634_2.kt")
    public void testKt11634_2() {
      runTest("compiler/testData/codegen/box/closures/kt11634_2.kt");
    }

    @Test
    @TestMetadata("kt11634_3.kt")
    public void testKt11634_3() {
      runTest("compiler/testData/codegen/box/closures/kt11634_3.kt");
    }

    @Test
    @TestMetadata("kt11634_4.kt")
    public void testKt11634_4() {
      runTest("compiler/testData/codegen/box/closures/kt11634_4.kt");
    }

    @Test
    @TestMetadata("kt19389.kt")
    public void testKt19389() {
      runTest("compiler/testData/codegen/box/closures/kt19389.kt");
    }

    @Test
    @TestMetadata("kt19389_set.kt")
    public void testKt19389_set() {
      runTest("compiler/testData/codegen/box/closures/kt19389_set.kt");
    }

    @Test
    @TestMetadata("kt2151.kt")
    public void testKt2151() {
      runTest("compiler/testData/codegen/box/closures/kt2151.kt");
    }

    @Test
    @TestMetadata("kt23881.kt")
    public void testKt23881() {
      runTest("compiler/testData/codegen/box/closures/kt23881.kt");
    }

    @Test
    @TestMetadata("kt3152.kt")
    public void testKt3152() {
      runTest("compiler/testData/codegen/box/closures/kt3152.kt");
    }

    @Test
    @TestMetadata("kt3523.kt")
    public void testKt3523() {
      runTest("compiler/testData/codegen/box/closures/kt3523.kt");
    }

    @Test
    @TestMetadata("kt3738.kt")
    public void testKt3738() {
      runTest("compiler/testData/codegen/box/closures/kt3738.kt");
    }

    @Test
    @TestMetadata("kt3905.kt")
    public void testKt3905() {
      runTest("compiler/testData/codegen/box/closures/kt3905.kt");
    }

    @Test
    @TestMetadata("kt4106.kt")
    public void testKt4106() {
      runTest("compiler/testData/codegen/box/closures/kt4106.kt");
    }

    @Test
    @TestMetadata("kt4137.kt")
    public void testKt4137() {
      runTest("compiler/testData/codegen/box/closures/kt4137.kt");
    }

    @Test
    @TestMetadata("kt47120.kt")
    public void testKt47120() {
      runTest("compiler/testData/codegen/box/closures/kt47120.kt");
    }

    @Test
    @TestMetadata("kt47120a.kt")
    public void testKt47120a() {
      runTest("compiler/testData/codegen/box/closures/kt47120a.kt");
    }

    @Test
    @TestMetadata("kt47840.kt")
    public void testKt47840() {
      runTest("compiler/testData/codegen/box/closures/kt47840.kt");
    }

    @Test
    @TestMetadata("kt47894_inlineFunWithObjectWithNothing.kt")
    public void testKt47894_inlineFunWithObjectWithNothing() {
      runTest("compiler/testData/codegen/box/closures/kt47894_inlineFunWithObjectWithNothing.kt");
    }

    @Test
    @TestMetadata("kt5589.kt")
    public void testKt5589() {
      runTest("compiler/testData/codegen/box/closures/kt5589.kt");
    }

    @Test
    @TestMetadata("localClassFunClosure.kt")
    public void testLocalClassFunClosure() {
      runTest("compiler/testData/codegen/box/closures/localClassFunClosure.kt");
    }

    @Test
    @TestMetadata("localClassLambdaClosure.kt")
    public void testLocalClassLambdaClosure() {
      runTest("compiler/testData/codegen/box/closures/localClassLambdaClosure.kt");
    }

    @Test
    @TestMetadata("localFunInInit.kt")
    public void testLocalFunInInit() {
      runTest("compiler/testData/codegen/box/closures/localFunInInit.kt");
    }

    @Test
    @TestMetadata("localFunctionInFunction.kt")
    public void testLocalFunctionInFunction() {
      runTest("compiler/testData/codegen/box/closures/localFunctionInFunction.kt");
    }

    @Test
    @TestMetadata("localFunctionInInitBlock.kt")
    public void testLocalFunctionInInitBlock() {
      runTest("compiler/testData/codegen/box/closures/localFunctionInInitBlock.kt");
    }

    @Test
    @TestMetadata("localFunctionInInitializer.kt")
    public void testLocalFunctionInInitializer() {
      runTest("compiler/testData/codegen/box/closures/localFunctionInInitializer.kt");
    }

    @Test
    @TestMetadata("localGenericFun.kt")
    public void testLocalGenericFun() {
      runTest("compiler/testData/codegen/box/closures/localGenericFun.kt");
    }

    @Test
    @TestMetadata("localReturn.kt")
    public void testLocalReturn() {
      runTest("compiler/testData/codegen/box/closures/localReturn.kt");
    }

    @Test
    @TestMetadata("localReturnWithAutolabel.kt")
    public void testLocalReturnWithAutolabel() {
      runTest("compiler/testData/codegen/box/closures/localReturnWithAutolabel.kt");
    }

    @Test
    @TestMetadata("noRefToOuter.kt")
    public void testNoRefToOuter() {
      runTest("compiler/testData/codegen/box/closures/noRefToOuter.kt");
    }

    @Test
    @TestMetadata("recursiveClosure.kt")
    public void testRecursiveClosure() {
      runTest("compiler/testData/codegen/box/closures/recursiveClosure.kt");
    }

    @Test
    @TestMetadata("refsAreSerializable.kt")
    public void testRefsAreSerializable() {
      runTest("compiler/testData/codegen/box/closures/refsAreSerializable.kt");
    }

    @Test
    @TestMetadata("simplestClosure.kt")
    public void testSimplestClosure() {
      runTest("compiler/testData/codegen/box/closures/simplestClosure.kt");
    }

    @Test
    @TestMetadata("simplestClosureAndBoxing.kt")
    public void testSimplestClosureAndBoxing() {
      runTest("compiler/testData/codegen/box/closures/simplestClosureAndBoxing.kt");
    }

    @Test
    @TestMetadata("staticLambda.kt")
    public void testStaticLambda() {
      runTest("compiler/testData/codegen/box/closures/staticLambda.kt");
    }

    @Test
    @TestMetadata("subclosuresWithinInitializers.kt")
    public void testSubclosuresWithinInitializers() {
      runTest("compiler/testData/codegen/box/closures/subclosuresWithinInitializers.kt");
    }

    @Test
    @TestMetadata("underscoreParameters.kt")
    public void testUnderscoreParameters() {
      runTest("compiler/testData/codegen/box/closures/underscoreParameters.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/closures/captureInSuperConstructorCall")
    @TestDataPath("$PROJECT_ROOT")
    public class CaptureInSuperConstructorCall {
      @Test
      public void testAllFilesPresentInCaptureInSuperConstructorCall() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/captureInSuperConstructorCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("constructorParameterAndLocalCapturedInLambdaInLocalClass.kt")
      public void testConstructorParameterAndLocalCapturedInLambdaInLocalClass() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterAndLocalCapturedInLambdaInLocalClass.kt");
      }

      @Test
      @TestMetadata("constructorParameterCapturedInLambdaInLocalClass.kt")
      public void testConstructorParameterCapturedInLambdaInLocalClass() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass.kt");
      }

      @Test
      @TestMetadata("constructorParameterCapturedInLambdaInLocalClass2.kt")
      public void testConstructorParameterCapturedInLambdaInLocalClass2() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass2.kt");
      }

      @Test
      @TestMetadata("kt13454.kt")
      public void testKt13454() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt13454.kt");
      }

      @Test
      @TestMetadata("kt14148.kt")
      public void testKt14148() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt14148.kt");
      }

      @Test
      @TestMetadata("kt4174.kt")
      public void testKt4174() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174.kt");
      }

      @Test
      @TestMetadata("kt4174a.kt")
      public void testKt4174a() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174a.kt");
      }

      @Test
      @TestMetadata("localCapturedInAnonymousObjectInLocalClass.kt")
      public void testLocalCapturedInAnonymousObjectInLocalClass() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass.kt");
      }

      @Test
      @TestMetadata("localCapturedInAnonymousObjectInLocalClass2.kt")
      public void testLocalCapturedInAnonymousObjectInLocalClass2() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass2.kt");
      }

      @Test
      @TestMetadata("localCapturedInLambdaInInnerClassInLocalClass.kt")
      public void testLocalCapturedInLambdaInInnerClassInLocalClass() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInInnerClassInLocalClass.kt");
      }

      @Test
      @TestMetadata("localCapturedInLambdaInLocalClass.kt")
      public void testLocalCapturedInLambdaInLocalClass() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInLocalClass.kt");
      }

      @Test
      @TestMetadata("localFunctionCapturedInLambda.kt")
      public void testLocalFunctionCapturedInLambda() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localFunctionCapturedInLambda.kt");
      }

      @Test
      @TestMetadata("outerAndLocalCapturedInLocalClass.kt")
      public void testOuterAndLocalCapturedInLocalClass() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerAndLocalCapturedInLocalClass.kt");
      }

      @Test
      @TestMetadata("outerCapturedAsImplicitThisInBoundReference.kt")
      public void testOuterCapturedAsImplicitThisInBoundReference() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedAsImplicitThisInBoundReference.kt");
      }

      @Test
      @TestMetadata("outerCapturedInFunctionLiteral.kt")
      public void testOuterCapturedInFunctionLiteral() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInFunctionLiteral.kt");
      }

      @Test
      @TestMetadata("outerCapturedInInlineLambda.kt")
      public void testOuterCapturedInInlineLambda() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda.kt");
      }

      @Test
      @TestMetadata("outerCapturedInInlineLambda2.kt")
      public void testOuterCapturedInInlineLambda2() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda2.kt");
      }

      @Test
      @TestMetadata("outerCapturedInLambda.kt")
      public void testOuterCapturedInLambda() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda.kt");
      }

      @Test
      @TestMetadata("outerCapturedInLambda2.kt")
      public void testOuterCapturedInLambda2() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda2.kt");
      }

      @Test
      @TestMetadata("outerCapturedInLambdaInSecondaryConstructor.kt")
      public void testOuterCapturedInLambdaInSecondaryConstructor() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSecondaryConstructor.kt");
      }

      @Test
      @TestMetadata("outerCapturedInLambdaInSubExpression.kt")
      public void testOuterCapturedInLambdaInSubExpression() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSubExpression.kt");
      }

      @Test
      @TestMetadata("outerCapturedInLocalClass.kt")
      public void testOuterCapturedInLocalClass() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLocalClass.kt");
      }

      @Test
      @TestMetadata("outerCapturedInNestedLambda.kt")
      public void testOuterCapturedInNestedLambda() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedLambda.kt");
      }

      @Test
      @TestMetadata("outerCapturedInNestedObject.kt")
      public void testOuterCapturedInNestedObject() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedObject.kt");
      }

      @Test
      @TestMetadata("outerCapturedInObject.kt")
      public void testOuterCapturedInObject() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject.kt");
      }

      @Test
      @TestMetadata("outerCapturedInObject2.kt")
      public void testOuterCapturedInObject2() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject2.kt");
      }

      @Test
      @TestMetadata("outerCapturedInPrimaryConstructorDefaultParameter.kt")
      public void testOuterCapturedInPrimaryConstructorDefaultParameter() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInPrimaryConstructorDefaultParameter.kt");
      }

      @Test
      @TestMetadata("outerCapturedInSecondaryConstructorDefaultParameter.kt")
      public void testOuterCapturedInSecondaryConstructorDefaultParameter() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInSecondaryConstructorDefaultParameter.kt");
      }

      @Test
      @TestMetadata("outerEnumEntryCapturedInLambdaInInnerClass.kt")
      public void testOuterEnumEntryCapturedInLambdaInInnerClass() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerEnumEntryCapturedInLambdaInInnerClass.kt");
      }

      @Test
      @TestMetadata("properValueCapturedByClosure1.kt")
      public void testProperValueCapturedByClosure1() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure1.kt");
      }

      @Test
      @TestMetadata("properValueCapturedByClosure2.kt")
      public void testProperValueCapturedByClosure2() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure2.kt");
      }

      @Test
      @TestMetadata("referenceToCapturedVariablesInMultipleLambdas.kt")
      public void testReferenceToCapturedVariablesInMultipleLambdas() {
        runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/referenceToCapturedVariablesInMultipleLambdas.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/closures/captureOuterProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class CaptureOuterProperty {
      @Test
      public void testAllFilesPresentInCaptureOuterProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/captureOuterProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("captureFunctionInProperty.kt")
      public void testCaptureFunctionInProperty() {
        runTest("compiler/testData/codegen/box/closures/captureOuterProperty/captureFunctionInProperty.kt");
      }

      @Test
      @TestMetadata("inFunction.kt")
      public void testInFunction() {
        runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inFunction.kt");
      }

      @Test
      @TestMetadata("inProperty.kt")
      public void testInProperty() {
        runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inProperty.kt");
      }

      @Test
      @TestMetadata("inPropertyDeepObjectChain.kt")
      public void testInPropertyDeepObjectChain() {
        runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyDeepObjectChain.kt");
      }

      @Test
      @TestMetadata("inPropertyFromSuperClass.kt")
      public void testInPropertyFromSuperClass() {
        runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperClass.kt");
      }

      @Test
      @TestMetadata("inPropertyFromSuperSuperClass.kt")
      public void testInPropertyFromSuperSuperClass() {
        runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperSuperClass.kt");
      }

      @Test
      @TestMetadata("kt4176.kt")
      public void testKt4176() {
        runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4176.kt");
      }

      @Test
      @TestMetadata("kt4656.kt")
      public void testKt4656() {
        runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4656.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/closures/capturedVarsOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class CapturedVarsOptimization {
      @Test
      public void testAllFilesPresentInCapturedVarsOptimization() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("capturedInCrossinline.kt")
      public void testCapturedInCrossinline() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInCrossinline.kt");
      }

      @Test
      @TestMetadata("capturedInInlineOnlyAssign.kt")
      public void testCapturedInInlineOnlyAssign() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyAssign.kt");
      }

      @Test
      @TestMetadata("capturedInInlineOnlyCAO.kt")
      public void testCapturedInInlineOnlyCAO() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyCAO.kt");
      }

      @Test
      @TestMetadata("capturedInInlineOnlyIncrDecr.kt")
      public void testCapturedInInlineOnlyIncrDecr() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIncrDecr.kt");
      }

      @Test
      @TestMetadata("capturedInInlineOnlyIndexedCAO.kt")
      public void testCapturedInInlineOnlyIndexedCAO() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIndexedCAO.kt");
      }

      @Test
      @TestMetadata("capturedVarsOfSize2.kt")
      public void testCapturedVarsOfSize2() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedVarsOfSize2.kt");
      }

      @Test
      @TestMetadata("kt17200.kt")
      public void testKt17200() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17200.kt");
      }

      @Test
      @TestMetadata("kt17588.kt")
      public void testKt17588() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17588.kt");
      }

      @Test
      @TestMetadata("kt44347.kt")
      public void testKt44347() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt44347.kt");
      }

      @Test
      @TestMetadata("kt45446.kt")
      public void testKt45446() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt45446.kt");
      }

      @Test
      @TestMetadata("sharedSlotsWithCapturedVars.kt")
      public void testSharedSlotsWithCapturedVars() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
      }

      @Test
      @TestMetadata("withCoroutines.kt")
      public void testWithCoroutines() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutines.kt");
      }

      @Test
      @TestMetadata("withCoroutinesNoStdLib.kt")
      public void testWithCoroutinesNoStdLib() {
        runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutinesNoStdLib.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/closures/closureInsideClosure")
    @TestDataPath("$PROJECT_ROOT")
    public class ClosureInsideClosure {
      @Test
      public void testAllFilesPresentInClosureInsideClosure() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/closureInsideClosure"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("localFunInsideLocalFun.kt")
      public void testLocalFunInsideLocalFun() {
        runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFun.kt");
      }

      @Test
      @TestMetadata("localFunInsideLocalFunDifferentSignatures.kt")
      public void testLocalFunInsideLocalFunDifferentSignatures() {
        runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFunDifferentSignatures.kt");
      }

      @Test
      @TestMetadata("propertyAndFunctionNameClash.kt")
      public void testPropertyAndFunctionNameClash() {
        runTest("compiler/testData/codegen/box/closures/closureInsideClosure/propertyAndFunctionNameClash.kt");
      }

      @Test
      @TestMetadata("threeLevels.kt")
      public void testThreeLevels() {
        runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevels.kt");
      }

      @Test
      @TestMetadata("threeLevelsDifferentSignatures.kt")
      public void testThreeLevelsDifferentSignatures() {
        runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevelsDifferentSignatures.kt");
      }

      @Test
      @TestMetadata("varAsFunInsideLocalFun.kt")
      public void testVarAsFunInsideLocalFun() {
        runTest("compiler/testData/codegen/box/closures/closureInsideClosure/varAsFunInsideLocalFun.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/collectionLiterals")
  @TestDataPath("$PROJECT_ROOT")
  public class CollectionLiterals {
    @Test
    public void testAllFilesPresentInCollectionLiterals() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/collectionLiterals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("collectionLiteralsInArgumentPosition.kt")
    public void testCollectionLiteralsInArgumentPosition() {
      runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsInArgumentPosition.kt");
    }

    @Test
    @TestMetadata("collectionLiteralsWithConstants.kt")
    public void testCollectionLiteralsWithConstants() {
      runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsWithConstants.kt");
    }

    @Test
    @TestMetadata("collectionLiteralsWithVarargs.kt")
    public void testCollectionLiteralsWithVarargs() {
      runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsWithVarargs.kt");
    }

    @Test
    @TestMetadata("defaultAnnotationParameterValues.kt")
    public void testDefaultAnnotationParameterValues() {
      runTest("compiler/testData/codegen/box/collectionLiterals/defaultAnnotationParameterValues.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/collections")
  @TestDataPath("$PROJECT_ROOT")
  public class Collections {
    @Test
    @TestMetadata("addCollectionStubWithCovariantOverride.kt")
    public void testAddCollectionStubWithCovariantOverride() {
      runTest("compiler/testData/codegen/box/collections/addCollectionStubWithCovariantOverride.kt");
    }

    @Test
    public void testAllFilesPresentInCollections() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/collections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("charSequence.kt")
    public void testCharSequence() {
      runTest("compiler/testData/codegen/box/collections/charSequence.kt");
    }

    @Test
    @TestMetadata("clashWithInternalMapMethod.kt")
    public void testClashWithInternalMapMethod() {
      runTest("compiler/testData/codegen/box/collections/clashWithInternalMapMethod.kt");
    }

    @Test
    @TestMetadata("implementCollectionThroughKotlin.kt")
    public void testImplementCollectionThroughKotlin() {
      runTest("compiler/testData/codegen/box/collections/implementCollectionThroughKotlin.kt");
    }

    @Test
    @TestMetadata("inSetWithSmartCast.kt")
    public void testInSetWithSmartCast() {
      runTest("compiler/testData/codegen/box/collections/inSetWithSmartCast.kt");
    }

    @Test
    @TestMetadata("inheritFromAbstractMutableListInt.kt")
    public void testInheritFromAbstractMutableListInt() {
      runTest("compiler/testData/codegen/box/collections/inheritFromAbstractMutableListInt.kt");
    }

    @Test
    @TestMetadata("inheritFromHashtable.kt")
    public void testInheritFromHashtable() {
      runTest("compiler/testData/codegen/box/collections/inheritFromHashtable.kt");
    }

    @Test
    @TestMetadata("internalRemove.kt")
    public void testInternalRemove() {
      runTest("compiler/testData/codegen/box/collections/internalRemove.kt");
    }

    @Test
    @TestMetadata("internalRemoveFromJava.kt")
    public void testInternalRemoveFromJava() {
      runTest("compiler/testData/codegen/box/collections/internalRemoveFromJava.kt");
    }

    @Test
    @TestMetadata("irrelevantImplCharSequence.kt")
    public void testIrrelevantImplCharSequence() {
      runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequence.kt");
    }

    @Test
    @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
    public void testIrrelevantImplCharSequenceKotlin() {
      runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequenceKotlin.kt");
    }

    @Test
    @TestMetadata("irrelevantImplCharSequenceWithExtraSupertype.kt")
    public void testIrrelevantImplCharSequenceWithExtraSupertype() {
      runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequenceWithExtraSupertype.kt");
    }

    @Test
    @TestMetadata("irrelevantImplMutableList.kt")
    public void testIrrelevantImplMutableList() {
      runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableList.kt");
    }

    @Test
    @TestMetadata("irrelevantImplMutableListKotlin.kt")
    public void testIrrelevantImplMutableListKotlin() {
      runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableListKotlin.kt");
    }

    @Test
    @TestMetadata("irrelevantImplMutableListSubstitution.kt")
    public void testIrrelevantImplMutableListSubstitution() {
      runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableListSubstitution.kt");
    }

    @Test
    @TestMetadata("irrelevantRemoveAtOverrideInJava.kt")
    public void testIrrelevantRemoveAtOverrideInJava() {
      runTest("compiler/testData/codegen/box/collections/irrelevantRemoveAtOverrideInJava.kt");
    }

    @Test
    @TestMetadata("irrelevantSizeOverrideInJava.kt")
    public void testIrrelevantSizeOverrideInJava() {
      runTest("compiler/testData/codegen/box/collections/irrelevantSizeOverrideInJava.kt");
    }

    @Test
    @TestMetadata("javaCollectionWithRemovePrimitiveInt.kt")
    public void testJavaCollectionWithRemovePrimitiveInt() {
      runTest("compiler/testData/codegen/box/collections/javaCollectionWithRemovePrimitiveInt.kt");
    }

    @Test
    @TestMetadata("kt40305.kt")
    public void testKt40305() {
      runTest("compiler/testData/codegen/box/collections/kt40305.kt");
    }

    @Test
    @TestMetadata("kt41123.kt")
    public void testKt41123() {
      runTest("compiler/testData/codegen/box/collections/kt41123.kt");
    }

    @Test
    @TestMetadata("kt44233.kt")
    public void testKt44233() {
      runTest("compiler/testData/codegen/box/collections/kt44233.kt");
    }

    @Test
    @TestMetadata("kt48945.kt")
    public void testKt48945() {
      runTest("compiler/testData/codegen/box/collections/kt48945.kt");
    }

    @Test
    @TestMetadata("kt48945a.kt")
    public void testKt48945a() {
      runTest("compiler/testData/codegen/box/collections/kt48945a.kt");
    }

    @Test
    @TestMetadata("kt48945b.kt")
    public void testKt48945b() {
      runTest("compiler/testData/codegen/box/collections/kt48945b.kt");
    }

    @Test
    @TestMetadata("kt48945c.kt")
    public void testKt48945c() {
      runTest("compiler/testData/codegen/box/collections/kt48945c.kt");
    }

    @Test
    @TestMetadata("kt65555.kt")
    public void testKt65555() {
      runTest("compiler/testData/codegen/box/collections/kt65555.kt");
    }

    @Test
    @TestMetadata("mutableList.kt")
    public void testMutableList() {
      runTest("compiler/testData/codegen/box/collections/mutableList.kt");
    }

    @Test
    @TestMetadata("noStubsInJavaSuperClass.kt")
    public void testNoStubsInJavaSuperClass() {
      runTest("compiler/testData/codegen/box/collections/noStubsInJavaSuperClass.kt");
    }

    @Test
    @TestMetadata("notErasedMapGetMap_boxedTypes.kt")
    public void testNotErasedMapGetMap_boxedTypes() {
      runTest("compiler/testData/codegen/box/collections/notErasedMapGetMap_boxedTypes.kt");
    }

    @Test
    @TestMetadata("notErasedMapGetMap_declared.kt")
    public void testNotErasedMapGetMap_declared() {
      runTest("compiler/testData/codegen/box/collections/notErasedMapGetMap_declared.kt");
    }

    @Test
    @TestMetadata("notErasedMapGetMap_inherited.kt")
    public void testNotErasedMapGetMap_inherited() {
      runTest("compiler/testData/codegen/box/collections/notErasedMapGetMap_inherited.kt");
    }

    @Test
    @TestMetadata("platformValueContains.kt")
    public void testPlatformValueContains() {
      runTest("compiler/testData/codegen/box/collections/platformValueContains.kt");
    }

    @Test
    @TestMetadata("readOnlyList.kt")
    public void testReadOnlyList() {
      runTest("compiler/testData/codegen/box/collections/readOnlyList.kt");
    }

    @Test
    @TestMetadata("readOnlyMap.kt")
    public void testReadOnlyMap() {
      runTest("compiler/testData/codegen/box/collections/readOnlyMap.kt");
    }

    @Test
    @TestMetadata("removeAtBridgeClashWithJava.kt")
    public void testRemoveAtBridgeClashWithJava() {
      runTest("compiler/testData/codegen/box/collections/removeAtBridgeClashWithJava.kt");
    }

    @Test
    @TestMetadata("removeAtInJava.kt")
    public void testRemoveAtInJava() {
      runTest("compiler/testData/codegen/box/collections/removeAtInJava.kt");
    }

    @Test
    @TestMetadata("removeAtInt.kt")
    public void testRemoveAtInt() {
      runTest("compiler/testData/codegen/box/collections/removeAtInt.kt");
    }

    @Test
    @TestMetadata("removeAtIntOverrideInJava.kt")
    public void testRemoveAtIntOverrideInJava() {
      runTest("compiler/testData/codegen/box/collections/removeAtIntOverrideInJava.kt");
    }

    @Test
    @TestMetadata("removeAtIntOverrideInJava2.kt")
    public void testRemoveAtIntOverrideInJava2() {
      runTest("compiler/testData/codegen/box/collections/removeAtIntOverrideInJava2.kt");
    }

    @Test
    @TestMetadata("removeClash.kt")
    public void testRemoveClash() {
      runTest("compiler/testData/codegen/box/collections/removeClash.kt");
    }

    @Test
    @TestMetadata("removeClashJava.kt")
    public void testRemoveClashJava() {
      runTest("compiler/testData/codegen/box/collections/removeClashJava.kt");
    }

    @Test
    @TestMetadata("removeClashKotlin.kt")
    public void testRemoveClashKotlin() {
      runTest("compiler/testData/codegen/box/collections/removeClashKotlin.kt");
    }

    @Test
    @TestMetadata("removeClashWithGenerics.kt")
    public void testRemoveClashWithGenerics() {
      runTest("compiler/testData/codegen/box/collections/removeClashWithGenerics.kt");
    }

    @Test
    @TestMetadata("removeNullFromList.kt")
    public void testRemoveNullFromList() {
      runTest("compiler/testData/codegen/box/collections/removeNullFromList.kt");
    }

    @Test
    @TestMetadata("removeOverriddenInJava.kt")
    public void testRemoveOverriddenInJava() {
      runTest("compiler/testData/codegen/box/collections/removeOverriddenInJava.kt");
    }

    @Test
    @TestMetadata("removeOverriddenInJava_Map.kt")
    public void testRemoveOverriddenInJava_Map() {
      runTest("compiler/testData/codegen/box/collections/removeOverriddenInJava_Map.kt");
    }

    @Test
    @TestMetadata("specialBridgeForGet.kt")
    public void testSpecialBridgeForGet() {
      runTest("compiler/testData/codegen/box/collections/specialBridgeForGet.kt");
    }

    @Test
    @TestMetadata("strList.kt")
    public void testStrList() {
      runTest("compiler/testData/codegen/box/collections/strList.kt");
    }

    @Test
    @TestMetadata("toArrayInJavaClass.kt")
    public void testToArrayInJavaClass() {
      runTest("compiler/testData/codegen/box/collections/toArrayInJavaClass.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/companion")
  @TestDataPath("$PROJECT_ROOT")
  public class Companion {
    @Test
    public void testAllFilesPresentInCompanion() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("delegatedPropertyOnCompanion.kt")
    public void testDelegatedPropertyOnCompanion() {
      runTest("compiler/testData/codegen/box/companion/delegatedPropertyOnCompanion.kt");
    }

    @Test
    @TestMetadata("genericLambdaOnStringCompanion.kt")
    public void testGenericLambdaOnStringCompanion() {
      runTest("compiler/testData/codegen/box/companion/genericLambdaOnStringCompanion.kt");
    }

    @Test
    @TestMetadata("inlineFunctionCompanionPropertyAccess.kt")
    public void testInlineFunctionCompanionPropertyAccess() {
      runTest("compiler/testData/codegen/box/companion/inlineFunctionCompanionPropertyAccess.kt");
    }

    @Test
    @TestMetadata("kt54645.kt")
    public void testKt54645() {
      runTest("compiler/testData/codegen/box/companion/kt54645.kt");
    }

    @Test
    @TestMetadata("protectedConstValFromSuperCompanion.kt")
    public void testProtectedConstValFromSuperCompanion() {
      runTest("compiler/testData/codegen/box/companion/protectedConstValFromSuperCompanion.kt");
    }

    @Test
    @TestMetadata("protectedJvmFieldValFromSuperCompanion.kt")
    public void testProtectedJvmFieldValFromSuperCompanion() {
      runTest("compiler/testData/codegen/box/companion/protectedJvmFieldValFromSuperCompanion.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/compatibility")
  @TestDataPath("$PROJECT_ROOT")
  public class Compatibility {
    @Test
    public void testAllFilesPresentInCompatibility() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("privateCompanionObject.kt")
    public void testPrivateCompanionObject() {
      runTest("compiler/testData/codegen/box/compatibility/privateCompanionObject.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin")
  @TestDataPath("$PROJECT_ROOT")
  public class CompileKotlinAgainstKotlin {
    @Test
    @TestMetadata("adaptedSuspendFunctionReference.kt")
    public void testAdaptedSuspendFunctionReference() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/adaptedSuspendFunctionReference.kt");
    }

    @Test
    public void testAllFilesPresentInCompileKotlinAgainstKotlin() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotationInInterface.kt")
    public void testAnnotationInInterface() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/annotationInInterface.kt");
    }

    @Test
    @TestMetadata("annotationOnTypeUseInTypeAlias.kt")
    public void testAnnotationOnTypeUseInTypeAlias() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/annotationOnTypeUseInTypeAlias.kt");
    }

    @Test
    @TestMetadata("annotationsOnTypeAliases.kt")
    public void testAnnotationsOnTypeAliases() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/annotationsOnTypeAliases.kt");
    }

    @Test
    @TestMetadata("callsToMultifileClassFromOtherPackage.kt")
    public void testCallsToMultifileClassFromOtherPackage() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/callsToMultifileClassFromOtherPackage.kt");
    }

    @Test
    @TestMetadata("clashingFakeOverrideSignatures.kt")
    public void testClashingFakeOverrideSignatures() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/clashingFakeOverrideSignatures.kt");
    }

    @Test
    @TestMetadata("classInObject.kt")
    public void testClassInObject() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/classInObject.kt");
    }

    @Test
    @TestMetadata("companionObjectInEnum.kt")
    public void testCompanionObjectInEnum() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/companionObjectInEnum.kt");
    }

    @Test
    @TestMetadata("companionObjectMember.kt")
    public void testCompanionObjectMember() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/companionObjectMember.kt");
    }

    @Test
    @TestMetadata("constPropertyReferenceFromMultifileClass.kt")
    public void testConstPropertyReferenceFromMultifileClass() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/constPropertyReferenceFromMultifileClass.kt");
    }

    @Test
    @TestMetadata("constructorVararg.kt")
    public void testConstructorVararg() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/constructorVararg.kt");
    }

    @Test
    @TestMetadata("copySamOnInline.kt")
    public void testCopySamOnInline() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/copySamOnInline.kt");
    }

    @Test
    @TestMetadata("copySamOnInline2.kt")
    public void testCopySamOnInline2() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/copySamOnInline2.kt");
    }

    @Test
    @TestMetadata("coroutinesBinary.kt")
    public void testCoroutinesBinary() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/coroutinesBinary.kt");
    }

    @Test
    @TestMetadata("defaultConstructor.kt")
    public void testDefaultConstructor() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/defaultConstructor.kt");
    }

    @Test
    @TestMetadata("defaultLambdaRegeneration.kt")
    public void testDefaultLambdaRegeneration() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/defaultLambdaRegeneration.kt");
    }

    @Test
    @TestMetadata("defaultLambdaRegeneration2.kt")
    public void testDefaultLambdaRegeneration2() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/defaultLambdaRegeneration2.kt");
    }

    @Test
    @TestMetadata("delegatedDefault.kt")
    public void testDelegatedDefault() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/delegatedDefault.kt");
    }

    @Test
    @TestMetadata("delegationAndAnnotations.kt")
    public void testDelegationAndAnnotations() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/delegationAndAnnotations.kt");
    }

    @Test
    @TestMetadata("doublyNestedClass.kt")
    public void testDoublyNestedClass() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/doublyNestedClass.kt");
    }

    @Test
    @TestMetadata("enum.kt")
    public void testEnum() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/enum.kt");
    }

    @Test
    @TestMetadata("fakeOverridesForIntersectionTypes.kt")
    public void testFakeOverridesForIntersectionTypes() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fakeOverridesForIntersectionTypes.kt");
    }

    @Test
    @TestMetadata("genericSetter.kt")
    public void testGenericSetter() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/genericSetter.kt");
    }

    @Test
    @TestMetadata("importCompanion.kt")
    public void testImportCompanion() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/importCompanion.kt");
    }

    @Test
    @TestMetadata("inlinedConstants.kt")
    public void testInlinedConstants() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlinedConstants.kt");
    }

    @Test
    @TestMetadata("innerClassConstructor.kt")
    public void testInnerClassConstructor() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/innerClassConstructor.kt");
    }

    @Test
    @TestMetadata("interfaceDelegationAndBridgesProcessing.kt")
    public void testInterfaceDelegationAndBridgesProcessing() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/interfaceDelegationAndBridgesProcessing.kt");
    }

    @Test
    @TestMetadata("internalLeakBug.kt")
    public void testInternalLeakBug() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalLeakBug.kt");
    }

    @Test
    @TestMetadata("internalOpenLateinit_defaultModule.kt")
    public void testInternalOpenLateinit_defaultModule() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalOpenLateinit_defaultModule.kt");
    }

    @Test
    @TestMetadata("internalOpenLateinit_nonDefaultModule.kt")
    public void testInternalOpenLateinit_nonDefaultModule() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalOpenLateinit_nonDefaultModule.kt");
    }

    @Test
    @TestMetadata("internalSetterOverridden.kt")
    public void testInternalSetterOverridden() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalSetterOverridden.kt");
    }

    @Test
    @TestMetadata("internalWithDefaultArgs.kt")
    public void testInternalWithDefaultArgs() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalWithDefaultArgs.kt");
    }

    @Test
    @TestMetadata("internalWithOtherModuleName.kt")
    public void testInternalWithOtherModuleName() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalWithOtherModuleName.kt");
    }

    @Test
    @TestMetadata("intersectionOverrideProperies.kt")
    public void testIntersectionOverrideProperies() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/intersectionOverrideProperies.kt");
    }

    @Test
    @TestMetadata("jvmField.kt")
    public void testJvmField() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmField.kt");
    }

    @Test
    @TestMetadata("jvmFieldInAnnotationCompanion.kt")
    public void testJvmFieldInAnnotationCompanion() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmFieldInAnnotationCompanion.kt");
    }

    @Test
    @TestMetadata("jvmFieldInConstructor.kt")
    public void testJvmFieldInConstructor() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmFieldInConstructor.kt");
    }

    @Test
    @TestMetadata("jvmFieldInConstructor2.kt")
    public void testJvmFieldInConstructor2() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmFieldInConstructor2.kt");
    }

    @Test
    @TestMetadata("jvmFieldInInterfaceCompanion.kt")
    public void testJvmFieldInInterfaceCompanion() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmFieldInInterfaceCompanion.kt");
    }

    @Test
    @TestMetadata("jvmNames.kt")
    public void testJvmNames() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmNames.kt");
    }

    @Test
    @TestMetadata("jvmPackageName.kt")
    public void testJvmPackageName() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmPackageName.kt");
    }

    @Test
    @TestMetadata("jvmPackageNameInRootPackage.kt")
    public void testJvmPackageNameInRootPackage() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmPackageNameInRootPackage.kt");
    }

    @Test
    @TestMetadata("jvmPackageNameMultifileClass.kt")
    public void testJvmPackageNameMultifileClass() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmPackageNameMultifileClass.kt");
    }

    @Test
    @TestMetadata("jvmPackageNameWithJvmName.kt")
    public void testJvmPackageNameWithJvmName() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmPackageNameWithJvmName.kt");
    }

    @Test
    @TestMetadata("jvmStaticInObject.kt")
    public void testJvmStaticInObject() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmStaticInObject.kt");
    }

    @Test
    @TestMetadata("jvmStaticInObjectPropertyReference.kt")
    public void testJvmStaticInObjectPropertyReference() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmStaticInObjectPropertyReference.kt");
    }

    @Test
    @TestMetadata("kotlinPropertyAsAnnotationParameter.kt")
    public void testKotlinPropertyAsAnnotationParameter() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/kotlinPropertyAsAnnotationParameter.kt");
    }

    @Test
    @TestMetadata("kt14012.kt")
    public void testKt14012() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/kt14012.kt");
    }

    @Test
    @TestMetadata("kt14012_multi.kt")
    public void testKt14012_multi() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/kt14012_multi.kt");
    }

    @Test
    @TestMetadata("kt21775.kt")
    public void testKt21775() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/kt21775.kt");
    }

    @Test
    @TestMetadata("metadataForMembersInLocalClassInInitializer.kt")
    public void testMetadataForMembersInLocalClassInInitializer() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/metadataForMembersInLocalClassInInitializer.kt");
    }

    @Test
    @TestMetadata("multifileClassInlineFunctionAccessingProperty.kt")
    public void testMultifileClassInlineFunctionAccessingProperty() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/multifileClassInlineFunctionAccessingProperty.kt");
    }

    @Test
    @TestMetadata("multifileClassWithTypealias.kt")
    public void testMultifileClassWithTypealias() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/multifileClassWithTypealias.kt");
    }

    @Test
    @TestMetadata("nestedClass.kt")
    public void testNestedClass() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedClass.kt");
    }

    @Test
    @TestMetadata("nestedClassAsBound.kt")
    public void testNestedClassAsBound() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedClassAsBound.kt");
    }

    @Test
    @TestMetadata("nestedClassInAnnotationArgument.kt")
    public void testNestedClassInAnnotationArgument() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedClassInAnnotationArgument.kt");
    }

    @Test
    @TestMetadata("nestedEnum.kt")
    public void testNestedEnum() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedEnum.kt");
    }

    @Test
    @TestMetadata("nestedFunctionTypeAliasExpansion.kt")
    public void testNestedFunctionTypeAliasExpansion() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedFunctionTypeAliasExpansion.kt");
    }

    @Test
    @TestMetadata("nestedObject.kt")
    public void testNestedObject() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedObject.kt");
    }

    @Test
    @TestMetadata("nestedTypeAliasExpansion.kt")
    public void testNestedTypeAliasExpansion() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedTypeAliasExpansion.kt");
    }

    @Test
    @TestMetadata("noExplicitOverrideForDelegatedFromSupertype.kt")
    public void testNoExplicitOverrideForDelegatedFromSupertype() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/noExplicitOverrideForDelegatedFromSupertype.kt");
    }

    @Test
    @TestMetadata("optionalAnnotation.kt")
    public void testOptionalAnnotation() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/optionalAnnotation.kt");
    }

    @Test
    @TestMetadata("platformTypes.kt")
    public void testPlatformTypes() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/platformTypes.kt");
    }

    @Test
    @TestMetadata("privateSuperType.kt")
    public void testPrivateSuperType() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/privateSuperType.kt");
    }

    @Test
    @TestMetadata("propertyReference.kt")
    public void testPropertyReference() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/propertyReference.kt");
    }

    @Test
    @TestMetadata("recursiveGeneric.kt")
    public void testRecursiveGeneric() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/recursiveGeneric.kt");
    }

    @Test
    @TestMetadata("reflectTopLevelFunctionOtherFile.kt")
    public void testReflectTopLevelFunctionOtherFile() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/reflectTopLevelFunctionOtherFile.kt");
    }

    @Test
    @TestMetadata("repeatableAnnotation.kt")
    public void testRepeatableAnnotation() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/repeatableAnnotation.kt");
    }

    @Test
    @TestMetadata("sealedClass.kt")
    public void testSealedClass() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/sealedClass.kt");
    }

    @Test
    @TestMetadata("secondaryConstructors.kt")
    public void testSecondaryConstructors() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/secondaryConstructors.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/simple.kt");
    }

    @Test
    @TestMetadata("simpleValAnonymousObject.kt")
    public void testSimpleValAnonymousObject() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/simpleValAnonymousObject.kt");
    }

    @Test
    @TestMetadata("specialBridgesInDependencies.kt")
    public void testSpecialBridgesInDependencies() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/specialBridgesInDependencies.kt");
    }

    @Test
    @TestMetadata("starImportEnum.kt")
    public void testStarImportEnum() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/starImportEnum.kt");
    }

    @Test
    @TestMetadata("targetedJvmName.kt")
    public void testTargetedJvmName() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/targetedJvmName.kt");
    }

    @Test
    @TestMetadata("typeAliasesKt13181.kt")
    public void testTypeAliasesKt13181() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/typeAliasesKt13181.kt");
    }

    @Test
    @TestMetadata("unsignedTypesInAnnotations.kt")
    public void testUnsignedTypesInAnnotations() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/unsignedTypesInAnnotations.kt");
    }

    @Test
    @TestMetadata("useDeserializedFunInterface.kt")
    public void testUseDeserializedFunInterface() {
      runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/useDeserializedFunInterface.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir")
    @TestDataPath("$PROJECT_ROOT")
    public class Fir {
      @Test
      public void testAllFilesPresentInFir() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("AnonymousObjectInProperty.kt")
      public void testAnonymousObjectInProperty() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/AnonymousObjectInProperty.kt");
      }

      @Test
      @TestMetadata("ExistingSymbolInFakeOverride.kt")
      public void testExistingSymbolInFakeOverride() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/ExistingSymbolInFakeOverride.kt");
      }

      @Test
      @TestMetadata("IncrementalCompilerRunner.kt")
      public void testIncrementalCompilerRunner() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/IncrementalCompilerRunner.kt");
      }

      @Test
      @TestMetadata("IrConstAcceptMultiModule.kt")
      public void testIrConstAcceptMultiModule() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/IrConstAcceptMultiModule.kt");
      }

      @Test
      @TestMetadata("javaTypeParameterBy.kt")
      public void testJavaTypeParameterBy() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/javaTypeParameterBy.kt");
      }

      @Test
      @TestMetadata("LibraryProperty.kt")
      public void testLibraryProperty() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/LibraryProperty.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
      @Test
      public void testAllFilesPresentInInlineClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("callDeserializedPropertyOnInlineClassType.kt")
      public void testCallDeserializedPropertyOnInlineClassType() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/callDeserializedPropertyOnInlineClassType.kt");
      }

      @Test
      @TestMetadata("constructorWithInlineClassParametersInBinaryDependencies.kt")
      public void testConstructorWithInlineClassParametersInBinaryDependencies() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/constructorWithInlineClassParametersInBinaryDependencies.kt");
      }

      @Test
      @TestMetadata("defaultWithInlineClassAndReceivers.kt")
      public void testDefaultWithInlineClassAndReceivers() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/defaultWithInlineClassAndReceivers.kt");
      }

      @Test
      @TestMetadata("extensionPropertyWithSameName.kt")
      public void testExtensionPropertyWithSameName() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/extensionPropertyWithSameName.kt");
      }

      @Test
      @TestMetadata("funInterface.kt")
      public void testFunInterface() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/funInterface.kt");
      }

      @Test
      @TestMetadata("inlineClassFakeOverrideMangling.kt")
      public void testInlineClassFakeOverrideMangling() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/inlineClassFakeOverrideMangling.kt");
      }

      @Test
      @TestMetadata("inlineClassFromBinaryDependencies.kt")
      public void testInlineClassFromBinaryDependencies() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/inlineClassFromBinaryDependencies.kt");
      }

      @Test
      @TestMetadata("inlineClassInlineFunctionCall.kt")
      public void testInlineClassInlineFunctionCall() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/inlineClassInlineFunctionCall.kt");
      }

      @Test
      @TestMetadata("inlineClassInlineProperty.kt")
      public void testInlineClassInlineProperty() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/inlineClassInlineProperty.kt");
      }

      @Test
      @TestMetadata("internalWithInlineClass.kt")
      public void testInternalWithInlineClass() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/internalWithInlineClass.kt");
      }

      @Test
      @TestMetadata("privateCompanionObjectValInDifferentModule.kt")
      public void testPrivateCompanionObjectValInDifferentModule() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateCompanionObjectValInDifferentModule.kt");
      }

      @Test
      @TestMetadata("privateConstructor.kt")
      public void testPrivateConstructor() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateConstructor.kt");
      }

      @Test
      @TestMetadata("privateConstructorWithPrivateField.kt")
      public void testPrivateConstructorWithPrivateField() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateConstructorWithPrivateField.kt");
      }

      @Test
      @TestMetadata("privateConstructorWithPrivateFieldUsingTypeTable.kt")
      public void testPrivateConstructorWithPrivateFieldUsingTypeTable() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateConstructorWithPrivateFieldUsingTypeTable.kt");
      }

      @Test
      @TestMetadata("privateTopLevelValInDifferentModule.kt")
      public void testPrivateTopLevelValInDifferentModule() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateTopLevelValInDifferentModule.kt");
      }

      @Test
      @TestMetadata("suspendFunWithDefaultMangling.kt")
      public void testSuspendFunWithDefaultMangling() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/suspendFunWithDefaultMangling.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling")
      @TestDataPath("$PROJECT_ROOT")
      public class OldMangling {
        @Test
        public void testAllFilesPresentInOldMangling() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callDeserializedPropertyOnInlineClassType.kt")
        public void testCallDeserializedPropertyOnInlineClassType() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/callDeserializedPropertyOnInlineClassType.kt");
        }

        @Test
        @TestMetadata("constructorWithInlineClassParametersInBinaryDependencies.kt")
        public void testConstructorWithInlineClassParametersInBinaryDependencies() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/constructorWithInlineClassParametersInBinaryDependencies.kt");
        }

        @Test
        @TestMetadata("defaultWithInlineClassAndReceivers.kt")
        public void testDefaultWithInlineClassAndReceivers() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/defaultWithInlineClassAndReceivers.kt");
        }

        @Test
        @TestMetadata("extensionPropertyWithSameName.kt")
        public void testExtensionPropertyWithSameName() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/extensionPropertyWithSameName.kt");
        }

        @Test
        @TestMetadata("inlineClassFakeOverrideMangling.kt")
        public void testInlineClassFakeOverrideMangling() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/inlineClassFakeOverrideMangling.kt");
        }

        @Test
        @TestMetadata("inlineClassFromBinaryDependencies.kt")
        public void testInlineClassFromBinaryDependencies() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/inlineClassFromBinaryDependencies.kt");
        }

        @Test
        @TestMetadata("inlineClassInlineFunctionCall.kt")
        public void testInlineClassInlineFunctionCall() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/inlineClassInlineFunctionCall.kt");
        }

        @Test
        @TestMetadata("inlineClassInlineProperty.kt")
        public void testInlineClassInlineProperty() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/inlineClassInlineProperty.kt");
        }

        @Test
        @TestMetadata("privateCompanionObjectValInDifferentModule.kt")
        public void testPrivateCompanionObjectValInDifferentModule() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/privateCompanionObjectValInDifferentModule.kt");
        }

        @Test
        @TestMetadata("privateConstructor.kt")
        public void testPrivateConstructor() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/privateConstructor.kt");
        }

        @Test
        @TestMetadata("privateConstructorWithPrivateField.kt")
        public void testPrivateConstructorWithPrivateField() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/privateConstructorWithPrivateField.kt");
        }

        @Test
        @TestMetadata("privateTopLevelValInDifferentModule.kt")
        public void testPrivateTopLevelValInDifferentModule() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/privateTopLevelValInDifferentModule.kt");
        }

        @Test
        @TestMetadata("suspendFunWithDefaultOldMangling.kt")
        public void testSuspendFunWithDefaultOldMangling() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/suspendFunWithDefaultOldMangling.kt");
        }

        @Test
        @TestMetadata("useOldMangling.kt")
        public void testUseOldMangling() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/useOldMangling.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    public class Jvm8 {
      @Test
      public void testAllFilesPresentInJvm8() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults")
      @TestDataPath("$PROJECT_ROOT")
      public class Defaults {
        @Test
        public void testAllFilesPresentInDefaults() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callStackTrace.kt")
        public void testCallStackTrace() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/callStackTrace.kt");
        }

        @Test
        @TestMetadata("superCall.kt")
        public void testSuperCall() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superCall.kt");
        }

        @Test
        @TestMetadata("superCallFromInterface.kt")
        public void testSuperCallFromInterface() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superCallFromInterface.kt");
        }

        @Test
        @TestMetadata("superCallToKotlinInterfaceDefaultMethodFromDisabled.kt")
        public void testSuperCallToKotlinInterfaceDefaultMethodFromDisabled() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superCallToKotlinInterfaceDefaultMethodFromDisabled.kt");
        }

        @Test
        @TestMetadata("superCallToKotlinInterfaceOverriddenDefaultMethodFromDisabled.kt")
        public void testSuperCallToKotlinInterfaceOverriddenDefaultMethodFromDisabled() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superCallToKotlinInterfaceOverriddenDefaultMethodFromDisabled.kt");
        }

        @Test
        @TestMetadata("superPropAccess.kt")
        public void testSuperPropAccess() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superPropAccess.kt");
        }

        @Test
        @TestMetadata("superPropAccessFromInterface.kt")
        public void testSuperPropAccessFromInterface() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superPropAccessFromInterface.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility")
        @TestDataPath("$PROJECT_ROOT")
        public class AllCompatibility {
          @Test
          public void testAllFilesPresentInAllCompatibility() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("callStackTrace.kt")
          public void testCallStackTrace() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/callStackTrace.kt");
          }

          @Test
          @TestMetadata("superCall.kt")
          public void testSuperCall() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superCall.kt");
          }

          @Test
          @TestMetadata("superCallFromInterface.kt")
          public void testSuperCallFromInterface() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superCallFromInterface.kt");
          }

          @Test
          @TestMetadata("superCallFromInterface2.kt")
          public void testSuperCallFromInterface2() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superCallFromInterface2.kt");
          }

          @Test
          @TestMetadata("superCallToKotlinInterfaceDefaultMethodFromDisabled.kt")
          public void testSuperCallToKotlinInterfaceDefaultMethodFromDisabled() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superCallToKotlinInterfaceDefaultMethodFromDisabled.kt");
          }

          @Test
          @TestMetadata("superCallToKotlinInterfaceOverriddenDefaultMethodFromDisabled.kt")
          public void testSuperCallToKotlinInterfaceOverriddenDefaultMethodFromDisabled() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superCallToKotlinInterfaceOverriddenDefaultMethodFromDisabled.kt");
          }

          @Test
          @TestMetadata("superPropAccess.kt")
          public void testSuperPropAccess() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superPropAccess.kt");
          }

          @Test
          @TestMetadata("superPropAccessFromInterface.kt")
          public void testSuperPropAccessFromInterface() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superPropAccessFromInterface.kt");
          }

          @Test
          @TestMetadata("superPropAccessFromInterface2.kt")
          public void testSuperPropAccessFromInterface2() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superPropAccessFromInterface2.kt");
          }

          @Nested
          @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/delegationBy")
          @TestDataPath("$PROJECT_ROOT")
          public class DelegationBy {
            @Test
            public void testAllFilesPresentInDelegationBy() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/delegationBy"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() {
              runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/delegationBy/simple.kt");
            }

            @Test
            @TestMetadata("simpleProperty.kt")
            public void testSimpleProperty() {
              runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/delegationBy/simpleProperty.kt");
            }
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop")
        @TestDataPath("$PROJECT_ROOT")
        public class Interop {
          @Test
          @TestMetadata("allAgainsAllCompatibility.kt")
          public void testAllAgainsAllCompatibility() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/allAgainsAllCompatibility.kt");
          }

          @Test
          @TestMetadata("allCompatibilityAgainsAll.kt")
          public void testAllCompatibilityAgainsAll() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/allCompatibilityAgainsAll.kt");
          }

          @Test
          public void testAllFilesPresentInInterop() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("likeMemberClash.kt")
          public void testLikeMemberClash() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/likeMemberClash.kt");
          }

          @Test
          @TestMetadata("likeSpecialization.kt")
          public void testLikeSpecialization() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/likeSpecialization.kt");
          }

          @Test
          @TestMetadata("newAndOldSchemes.kt")
          public void testNewAndOldSchemes() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newAndOldSchemes.kt");
          }

          @Test
          @TestMetadata("newAndOldSchemes2.kt")
          public void testNewAndOldSchemes2() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newAndOldSchemes2.kt");
          }

          @Test
          @TestMetadata("newAndOldSchemes2Compatibility.kt")
          public void testNewAndOldSchemes2Compatibility() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newAndOldSchemes2Compatibility.kt");
          }

          @Test
          @TestMetadata("newAndOldSchemes3.kt")
          public void testNewAndOldSchemes3() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newAndOldSchemes3.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6")
      @TestDataPath("$PROJECT_ROOT")
      public class Jvm8against6 {
        @Test
        public void testAllFilesPresentInJvm8against6() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("jdk8Against6.kt")
        public void testJdk8Against6() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/jdk8Against6.kt");
        }

        @Test
        @TestMetadata("simpleCall.kt")
        public void testSimpleCall() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simpleCall.kt");
        }

        @Test
        @TestMetadata("simpleCallWithBigHierarchy.kt")
        public void testSimpleCallWithBigHierarchy() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simpleCallWithBigHierarchy.kt");
        }

        @Test
        @TestMetadata("simpleCallWithHierarchy.kt")
        public void testSimpleCallWithHierarchy() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simpleCallWithHierarchy.kt");
        }

        @Test
        @TestMetadata("simpleProp.kt")
        public void testSimpleProp() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simpleProp.kt");
        }

        @Test
        @TestMetadata("simplePropWithHierarchy.kt")
        public void testSimplePropWithHierarchy() {
          runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simplePropWithHierarchy.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation")
        @TestDataPath("$PROJECT_ROOT")
        public class Delegation {
          @Test
          public void testAllFilesPresentInDelegation() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("diamond.kt")
          public void testDiamond() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation/diamond.kt");
          }

          @Test
          @TestMetadata("diamond2.kt")
          public void testDiamond2() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation/diamond2.kt");
          }

          @Test
          @TestMetadata("diamond3.kt")
          public void testDiamond3() {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation/diamond3.kt");
          }
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/typeAnnotations")
    @TestDataPath("$PROJECT_ROOT")
    public class TypeAnnotations {
      @Test
      public void testAllFilesPresentInTypeAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/typeAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("implicitReturn.kt")
      public void testImplicitReturn() {
        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/typeAnnotations/implicitReturn.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/constants")
  @TestDataPath("$PROJECT_ROOT")
  public class Constants {
    @Test
    public void testAllFilesPresentInConstants() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("comparisonFalse.kt")
    public void testComparisonFalse() {
      runTest("compiler/testData/codegen/box/constants/comparisonFalse.kt");
    }

    @Test
    @TestMetadata("comparisonTrue.kt")
    public void testComparisonTrue() {
      runTest("compiler/testData/codegen/box/constants/comparisonTrue.kt");
    }

    @Test
    @TestMetadata("constValFromAnotherModuleInConsVal.kt")
    public void testConstValFromAnotherModuleInConsVal() {
      runTest("compiler/testData/codegen/box/constants/constValFromAnotherModuleInConsVal.kt");
    }

    @Test
    @TestMetadata("constantsInWhen.kt")
    public void testConstantsInWhen() {
      runTest("compiler/testData/codegen/box/constants/constantsInWhen.kt");
    }

    @Test
    @TestMetadata("divisionByZero.kt")
    public void testDivisionByZero() {
      runTest("compiler/testData/codegen/box/constants/divisionByZero.kt");
    }

    @Test
    @TestMetadata("doNotTriggerInit.kt")
    public void testDoNotTriggerInit() {
      runTest("compiler/testData/codegen/box/constants/doNotTriggerInit.kt");
    }

    @Test
    @TestMetadata("float.kt")
    public void testFloat() {
      runTest("compiler/testData/codegen/box/constants/float.kt");
    }

    @Test
    @TestMetadata("foldingBinaryOpsUnsigned.kt")
    public void testFoldingBinaryOpsUnsigned() {
      runTest("compiler/testData/codegen/box/constants/foldingBinaryOpsUnsigned.kt");
    }

    @Test
    @TestMetadata("foldingBinaryOpsUnsignedConst.kt")
    public void testFoldingBinaryOpsUnsignedConst() {
      runTest("compiler/testData/codegen/box/constants/foldingBinaryOpsUnsignedConst.kt");
    }

    @Test
    @TestMetadata("kt9532.kt")
    public void testKt9532() {
      runTest("compiler/testData/codegen/box/constants/kt9532.kt");
    }

    @Test
    @TestMetadata("literalToLongConversion.kt")
    public void testLiteralToLongConversion() {
      runTest("compiler/testData/codegen/box/constants/literalToLongConversion.kt");
    }

    @Test
    @TestMetadata("long.kt")
    public void testLong() {
      runTest("compiler/testData/codegen/box/constants/long.kt");
    }

    @Test
    @TestMetadata("numberLiteralCoercionToInferredType.kt")
    public void testNumberLiteralCoercionToInferredType() {
      runTest("compiler/testData/codegen/box/constants/numberLiteralCoercionToInferredType.kt");
    }

    @Test
    @TestMetadata("privateConst.kt")
    public void testPrivateConst() {
      runTest("compiler/testData/codegen/box/constants/privateConst.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/constructor")
  @TestDataPath("$PROJECT_ROOT")
  public class Constructor {
    @Test
    public void testAllFilesPresentInConstructor() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("genericConstructor.kt")
    public void testGenericConstructor() {
      runTest("compiler/testData/codegen/box/constructor/genericConstructor.kt");
    }

    @Test
    @TestMetadata("secondaryConstructor.kt")
    public void testSecondaryConstructor() {
      runTest("compiler/testData/codegen/box/constructor/secondaryConstructor.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/constructorCall")
  @TestDataPath("$PROJECT_ROOT")
  public class ConstructorCall {
    @Test
    public void testAllFilesPresentInConstructorCall() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constructorCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("breakInConstructorArguments.kt")
    public void testBreakInConstructorArguments() {
      runTest("compiler/testData/codegen/box/constructorCall/breakInConstructorArguments.kt");
    }

    @Test
    @TestMetadata("continueInConstructorArguments.kt")
    public void testContinueInConstructorArguments() {
      runTest("compiler/testData/codegen/box/constructorCall/continueInConstructorArguments.kt");
    }

    @Test
    @TestMetadata("earlyReturnInConstructorArguments.kt")
    public void testEarlyReturnInConstructorArguments() {
      runTest("compiler/testData/codegen/box/constructorCall/earlyReturnInConstructorArguments.kt");
    }

    @Test
    @TestMetadata("inlineFunInConstructorCall.kt")
    public void testInlineFunInConstructorCall() {
      runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCall.kt");
    }

    @Test
    @TestMetadata("inlineFunInConstructorCallEvaluationOrder.kt")
    public void testInlineFunInConstructorCallEvaluationOrder() {
      runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCallEvaluationOrder.kt");
    }

    @Test
    @TestMetadata("inlineFunInInnerClassConstructorCall.kt")
    public void testInlineFunInInnerClassConstructorCall() {
      runTest("compiler/testData/codegen/box/constructorCall/inlineFunInInnerClassConstructorCall.kt");
    }

    @Test
    @TestMetadata("inlineFunInLocalClassConstructorCall.kt")
    public void testInlineFunInLocalClassConstructorCall() {
      runTest("compiler/testData/codegen/box/constructorCall/inlineFunInLocalClassConstructorCall.kt");
    }

    @Test
    @TestMetadata("kt49615.kt")
    public void testKt49615() {
      runTest("compiler/testData/codegen/box/constructorCall/kt49615.kt");
    }

    @Test
    @TestMetadata("kt49615a.kt")
    public void testKt49615a() {
      runTest("compiler/testData/codegen/box/constructorCall/kt49615a.kt");
    }

    @Test
    @TestMetadata("loopInInlineFun.kt")
    public void testLoopInInlineFun() {
      runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFun.kt");
    }

    @Test
    @TestMetadata("loopInInlineFunInSuperConstructorCall.kt")
    public void testLoopInInlineFunInSuperConstructorCall() {
      runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFunInSuperConstructorCall.kt");
    }

    @Test
    @TestMetadata("nestedConstructorCallWithJumpOutInConstructorArguments.kt")
    public void testNestedConstructorCallWithJumpOutInConstructorArguments() {
      runTest("compiler/testData/codegen/box/constructorCall/nestedConstructorCallWithJumpOutInConstructorArguments.kt");
    }

    @Test
    @TestMetadata("nonLocalReturnInConstructorArguments.kt")
    public void testNonLocalReturnInConstructorArguments() {
      runTest("compiler/testData/codegen/box/constructorCall/nonLocalReturnInConstructorArguments.kt");
    }

    @Test
    @TestMetadata("possiblyPoppedUnitializedValueInArguments.kt")
    public void testPossiblyPoppedUnitializedValueInArguments() {
      runTest("compiler/testData/codegen/box/constructorCall/possiblyPoppedUnitializedValueInArguments.kt");
    }

    @Test
    @TestMetadata("regularConstructorCallEvaluationOrder.kt")
    public void testRegularConstructorCallEvaluationOrder() {
      runTest("compiler/testData/codegen/box/constructorCall/regularConstructorCallEvaluationOrder.kt");
    }

    @Test
    @TestMetadata("tryCatchInConstructorCallEvaluationOrder.kt")
    public void testTryCatchInConstructorCallEvaluationOrder() {
      runTest("compiler/testData/codegen/box/constructorCall/tryCatchInConstructorCallEvaluationOrder.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/contextParameters")
  @TestDataPath("$PROJECT_ROOT")
  public class ContextParameters {
    @Test
    public void testAllFilesPresentInContextParameters() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/contextParameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("contextParameterToDefaultArgument.kt")
    public void testContextParameterToDefaultArgument() {
      runTest("compiler/testData/codegen/box/contextParameters/contextParameterToDefaultArgument.kt");
    }

    @Test
    @TestMetadata("propertyWithContextAndWithout.kt")
    public void testPropertyWithContextAndWithout() {
      runTest("compiler/testData/codegen/box/contextParameters/propertyWithContextAndWithout.kt");
    }

    @Test
    @TestMetadata("sameNameWithGlobalProperty.kt")
    public void testSameNameWithGlobalProperty() {
      runTest("compiler/testData/codegen/box/contextParameters/sameNameWithGlobalProperty.kt");
    }

    @Test
    @TestMetadata("sameNameWithLocalArguments.kt")
    public void testSameNameWithLocalArguments() {
      runTest("compiler/testData/codegen/box/contextParameters/sameNameWithLocalArguments.kt");
    }

    @Test
    @TestMetadata("sameNameWithLocalProperty.kt")
    public void testSameNameWithLocalProperty() {
      runTest("compiler/testData/codegen/box/contextParameters/sameNameWithLocalProperty.kt");
    }

    @Test
    @TestMetadata("sameNameWithMemberProperty.kt")
    public void testSameNameWithMemberProperty() {
      runTest("compiler/testData/codegen/box/contextParameters/sameNameWithMemberProperty.kt");
    }

    @Test
    @TestMetadata("sameNameWithPropertyName.kt")
    public void testSameNameWithPropertyName() {
      runTest("compiler/testData/codegen/box/contextParameters/sameNameWithPropertyName.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/contextParameters/simple.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/contracts")
  @TestDataPath("$PROJECT_ROOT")
  public class Contracts {
    @Test
    public void testAllFilesPresentInContracts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("constructorArgument.kt")
    public void testConstructorArgument() {
      runTest("compiler/testData/codegen/box/contracts/constructorArgument.kt");
    }

    @Test
    @TestMetadata("contractAndRawField.kt")
    public void testContractAndRawField() {
      runTest("compiler/testData/codegen/box/contracts/contractAndRawField.kt");
    }

    @Test
    @TestMetadata("contractForCast.kt")
    public void testContractForCast() {
      runTest("compiler/testData/codegen/box/contracts/contractForCast.kt");
    }

    @Test
    @TestMetadata("destructuredVariable.kt")
    public void testDestructuredVariable() {
      runTest("compiler/testData/codegen/box/contracts/destructuredVariable.kt");
    }

    @Test
    @TestMetadata("exactlyOnceNotInline.kt")
    public void testExactlyOnceNotInline() {
      runTest("compiler/testData/codegen/box/contracts/exactlyOnceNotInline.kt");
    }

    @Test
    @TestMetadata("exception.kt")
    public void testException() {
      runTest("compiler/testData/codegen/box/contracts/exception.kt");
    }

    @Test
    @TestMetadata("fieldInConstructorParens.kt")
    public void testFieldInConstructorParens() {
      runTest("compiler/testData/codegen/box/contracts/fieldInConstructorParens.kt");
    }

    @Test
    @TestMetadata("fieldReadInConstructor.kt")
    public void testFieldReadInConstructor() {
      runTest("compiler/testData/codegen/box/contracts/fieldReadInConstructor.kt");
    }

    @Test
    @TestMetadata("forLoop.kt")
    public void testForLoop() {
      runTest("compiler/testData/codegen/box/contracts/forLoop.kt");
    }

    @Test
    @TestMetadata("functionParameter.kt")
    public void testFunctionParameter() {
      runTest("compiler/testData/codegen/box/contracts/functionParameter.kt");
    }

    @Test
    @TestMetadata("isNullString.kt")
    public void testIsNullString() {
      runTest("compiler/testData/codegen/box/contracts/isNullString.kt");
    }

    @Test
    @TestMetadata("kt39374.kt")
    public void testKt39374() {
      runTest("compiler/testData/codegen/box/contracts/kt39374.kt");
    }

    @Test
    @TestMetadata("kt45236.kt")
    public void testKt45236() {
      runTest("compiler/testData/codegen/box/contracts/kt45236.kt");
    }

    @Test
    @TestMetadata("kt47168.kt")
    public void testKt47168() {
      runTest("compiler/testData/codegen/box/contracts/kt47168.kt");
    }

    @Test
    @TestMetadata("kt47300.kt")
    public void testKt47300() {
      runTest("compiler/testData/codegen/box/contracts/kt47300.kt");
    }

    @Test
    @TestMetadata("lambdaParameter.kt")
    public void testLambdaParameter() {
      runTest("compiler/testData/codegen/box/contracts/lambdaParameter.kt");
    }

    @Test
    @TestMetadata("listAppend.kt")
    public void testListAppend() {
      runTest("compiler/testData/codegen/box/contracts/listAppend.kt");
    }

    @Test
    @TestMetadata("nestedLambdaInNonInlineCallExactlyOnce.kt")
    public void testNestedLambdaInNonInlineCallExactlyOnce() {
      runTest("compiler/testData/codegen/box/contracts/nestedLambdaInNonInlineCallExactlyOnce.kt");
    }

    @Test
    @TestMetadata("nonNullSmartCast.kt")
    public void testNonNullSmartCast() {
      runTest("compiler/testData/codegen/box/contracts/nonNullSmartCast.kt");
    }

    @Test
    @TestMetadata("require.kt")
    public void testRequire() {
      runTest("compiler/testData/codegen/box/contracts/require.kt");
    }

    @Test
    @TestMetadata("runLambdaForVal.kt")
    public void testRunLambdaForVal() {
      runTest("compiler/testData/codegen/box/contracts/runLambdaForVal.kt");
    }

    @Test
    @TestMetadata("valInWhen.kt")
    public void testValInWhen() {
      runTest("compiler/testData/codegen/box/contracts/valInWhen.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/controlStructures")
  @TestDataPath("$PROJECT_ROOT")
  public class ControlStructures {
    @Test
    public void testAllFilesPresentInControlStructures() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("bottles.kt")
    public void testBottles() {
      runTest("compiler/testData/codegen/box/controlStructures/bottles.kt");
    }

    @Test
    @TestMetadata("breakInDoWhile.kt")
    public void testBreakInDoWhile() {
      runTest("compiler/testData/codegen/box/controlStructures/breakInDoWhile.kt");
    }

    @Test
    @TestMetadata("breakInFinally.kt")
    public void testBreakInFinally() {
      runTest("compiler/testData/codegen/box/controlStructures/breakInFinally.kt");
    }

    @Test
    @TestMetadata("breakInWhen.kt")
    public void testBreakInWhen() {
      runTest("compiler/testData/codegen/box/controlStructures/breakInWhen.kt");
    }

    @Test
    @TestMetadata("compareBoxedIntegerToZero.kt")
    public void testCompareBoxedIntegerToZero() {
      runTest("compiler/testData/codegen/box/controlStructures/compareBoxedIntegerToZero.kt");
    }

    @Test
    @TestMetadata("conditionOfEmptyIf.kt")
    public void testConditionOfEmptyIf() {
      runTest("compiler/testData/codegen/box/controlStructures/conditionOfEmptyIf.kt");
    }

    @Test
    @TestMetadata("continueInExpr.kt")
    public void testContinueInExpr() {
      runTest("compiler/testData/codegen/box/controlStructures/continueInExpr.kt");
    }

    @Test
    @TestMetadata("continueInFor.kt")
    public void testContinueInFor() {
      runTest("compiler/testData/codegen/box/controlStructures/continueInFor.kt");
    }

    @Test
    @TestMetadata("continueInForCondition.kt")
    public void testContinueInForCondition() {
      runTest("compiler/testData/codegen/box/controlStructures/continueInForCondition.kt");
    }

    @Test
    @TestMetadata("continueInWhen.kt")
    public void testContinueInWhen() {
      runTest("compiler/testData/codegen/box/controlStructures/continueInWhen.kt");
    }

    @Test
    @TestMetadata("continueInWhile.kt")
    public void testContinueInWhile() {
      runTest("compiler/testData/codegen/box/controlStructures/continueInWhile.kt");
    }

    @Test
    @TestMetadata("continueToLabelInFor.kt")
    public void testContinueToLabelInFor() {
      runTest("compiler/testData/codegen/box/controlStructures/continueToLabelInFor.kt");
    }

    @Test
    @TestMetadata("doWhile.kt")
    public void testDoWhile() {
      runTest("compiler/testData/codegen/box/controlStructures/doWhile.kt");
    }

    @Test
    @TestMetadata("doWhileFib.kt")
    public void testDoWhileFib() {
      runTest("compiler/testData/codegen/box/controlStructures/doWhileFib.kt");
    }

    @Test
    @TestMetadata("doWhileWithContinue.kt")
    public void testDoWhileWithContinue() {
      runTest("compiler/testData/codegen/box/controlStructures/doWhileWithContinue.kt");
    }

    @Test
    @TestMetadata("emptyDoWhile.kt")
    public void testEmptyDoWhile() {
      runTest("compiler/testData/codegen/box/controlStructures/emptyDoWhile.kt");
    }

    @Test
    @TestMetadata("emptyFor.kt")
    public void testEmptyFor() {
      runTest("compiler/testData/codegen/box/controlStructures/emptyFor.kt");
    }

    @Test
    @TestMetadata("emptyWhile.kt")
    public void testEmptyWhile() {
      runTest("compiler/testData/codegen/box/controlStructures/emptyWhile.kt");
    }

    @Test
    @TestMetadata("factorialTest.kt")
    public void testFactorialTest() {
      runTest("compiler/testData/codegen/box/controlStructures/factorialTest.kt");
    }

    @Test
    @TestMetadata("finallyOnEmptyReturn.kt")
    public void testFinallyOnEmptyReturn() {
      runTest("compiler/testData/codegen/box/controlStructures/finallyOnEmptyReturn.kt");
    }

    @Test
    @TestMetadata("forArrayList.kt")
    public void testForArrayList() {
      runTest("compiler/testData/codegen/box/controlStructures/forArrayList.kt");
    }

    @Test
    @TestMetadata("forArrayListMultiDecl.kt")
    public void testForArrayListMultiDecl() {
      runTest("compiler/testData/codegen/box/controlStructures/forArrayListMultiDecl.kt");
    }

    @Test
    @TestMetadata("forInCharSequence.kt")
    public void testForInCharSequence() {
      runTest("compiler/testData/codegen/box/controlStructures/forInCharSequence.kt");
    }

    @Test
    @TestMetadata("forInCharSequenceMut.kt")
    public void testForInCharSequenceMut() {
      runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceMut.kt");
    }

    @Test
    @TestMetadata("forInSmartCastToArray.kt")
    public void testForInSmartCastToArray() {
      runTest("compiler/testData/codegen/box/controlStructures/forInSmartCastToArray.kt");
    }

    @Test
    @TestMetadata("forLoopMemberExtensionAll.kt")
    public void testForLoopMemberExtensionAll() {
      runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionAll.kt");
    }

    @Test
    @TestMetadata("forLoopMemberExtensionHasNext.kt")
    public void testForLoopMemberExtensionHasNext() {
      runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionHasNext.kt");
    }

    @Test
    @TestMetadata("forLoopMemberExtensionNext.kt")
    public void testForLoopMemberExtensionNext() {
      runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionNext.kt");
    }

    @Test
    @TestMetadata("forNullableCharInString.kt")
    public void testForNullableCharInString() {
      runTest("compiler/testData/codegen/box/controlStructures/forNullableCharInString.kt");
    }

    @Test
    @TestMetadata("forUserType.kt")
    public void testForUserType() {
      runTest("compiler/testData/codegen/box/controlStructures/forUserType.kt");
    }

    @Test
    @TestMetadata("ifConst1.kt")
    public void testIfConst1() {
      runTest("compiler/testData/codegen/box/controlStructures/ifConst1.kt");
    }

    @Test
    @TestMetadata("ifConst2.kt")
    public void testIfConst2() {
      runTest("compiler/testData/codegen/box/controlStructures/ifConst2.kt");
    }

    @Test
    @TestMetadata("ifIncompatibleBranches.kt")
    public void testIfIncompatibleBranches() {
      runTest("compiler/testData/codegen/box/controlStructures/ifIncompatibleBranches.kt");
    }

    @Test
    @TestMetadata("inRangeConditionsInWhen.kt")
    public void testInRangeConditionsInWhen() {
      runTest("compiler/testData/codegen/box/controlStructures/inRangeConditionsInWhen.kt");
    }

    @Test
    @TestMetadata("kt12908.kt")
    public void testKt12908() {
      runTest("compiler/testData/codegen/box/controlStructures/kt12908.kt");
    }

    @Test
    @TestMetadata("kt12908_2.kt")
    public void testKt12908_2() {
      runTest("compiler/testData/codegen/box/controlStructures/kt12908_2.kt");
    }

    @Test
    @TestMetadata("kt1441.kt")
    public void testKt1441() {
      runTest("compiler/testData/codegen/box/controlStructures/kt1441.kt");
    }

    @Test
    @TestMetadata("kt14839.kt")
    public void testKt14839() {
      runTest("compiler/testData/codegen/box/controlStructures/kt14839.kt");
    }

    @Test
    @TestMetadata("kt15726.kt")
    public void testKt15726() {
      runTest("compiler/testData/codegen/box/controlStructures/kt15726.kt");
    }

    @Test
    @TestMetadata("kt1688.kt")
    public void testKt1688() {
      runTest("compiler/testData/codegen/box/controlStructures/kt1688.kt");
    }

    @Test
    @TestMetadata("kt17110.kt")
    public void testKt17110() {
      runTest("compiler/testData/codegen/box/controlStructures/kt17110.kt");
    }

    @Test
    @TestMetadata("kt1742.kt")
    public void testKt1742() {
      runTest("compiler/testData/codegen/box/controlStructures/kt1742.kt");
    }

    @Test
    @TestMetadata("kt17590.kt")
    public void testKt17590() {
      runTest("compiler/testData/codegen/box/controlStructures/kt17590.kt");
    }

    @Test
    @TestMetadata("kt17590_long.kt")
    public void testKt17590_long() {
      runTest("compiler/testData/codegen/box/controlStructures/kt17590_long.kt");
    }

    @Test
    @TestMetadata("kt1899.kt")
    public void testKt1899() {
      runTest("compiler/testData/codegen/box/controlStructures/kt1899.kt");
    }

    @Test
    @TestMetadata("kt2147.kt")
    public void testKt2147() {
      runTest("compiler/testData/codegen/box/controlStructures/kt2147.kt");
    }

    @Test
    @TestMetadata("kt2259.kt")
    public void testKt2259() {
      runTest("compiler/testData/codegen/box/controlStructures/kt2259.kt");
    }

    @Test
    @TestMetadata("kt2291.kt")
    public void testKt2291() {
      runTest("compiler/testData/codegen/box/controlStructures/kt2291.kt");
    }

    @Test
    @TestMetadata("kt237.kt")
    public void testKt237() {
      runTest("compiler/testData/codegen/box/controlStructures/kt237.kt");
    }

    @Test
    @TestMetadata("kt2416.kt")
    public void testKt2416() {
      runTest("compiler/testData/codegen/box/controlStructures/kt2416.kt");
    }

    @Test
    @TestMetadata("kt2423.kt")
    public void testKt2423() {
      runTest("compiler/testData/codegen/box/controlStructures/kt2423.kt");
    }

    @Test
    @TestMetadata("kt2577.kt")
    public void testKt2577() {
      runTest("compiler/testData/codegen/box/controlStructures/kt2577.kt");
    }

    @Test
    @TestMetadata("kt2597.kt")
    public void testKt2597() {
      runTest("compiler/testData/codegen/box/controlStructures/kt2597.kt");
    }

    @Test
    @TestMetadata("kt299.kt")
    public void testKt299() {
      runTest("compiler/testData/codegen/box/controlStructures/kt299.kt");
    }

    @Test
    @TestMetadata("kt3087.kt")
    public void testKt3087() {
      runTest("compiler/testData/codegen/box/controlStructures/kt3087.kt");
    }

    @Test
    @TestMetadata("kt3203_1.kt")
    public void testKt3203_1() {
      runTest("compiler/testData/codegen/box/controlStructures/kt3203_1.kt");
    }

    @Test
    @TestMetadata("kt3203_2.kt")
    public void testKt3203_2() {
      runTest("compiler/testData/codegen/box/controlStructures/kt3203_2.kt");
    }

    @Test
    @TestMetadata("kt3273.kt")
    public void testKt3273() {
      runTest("compiler/testData/codegen/box/controlStructures/kt3273.kt");
    }

    @Test
    @TestMetadata("kt3280.kt")
    public void testKt3280() {
      runTest("compiler/testData/codegen/box/controlStructures/kt3280.kt");
    }

    @Test
    @TestMetadata("kt3574.kt")
    public void testKt3574() {
      runTest("compiler/testData/codegen/box/controlStructures/kt3574.kt");
    }

    @Test
    @TestMetadata("kt416.kt")
    public void testKt416() {
      runTest("compiler/testData/codegen/box/controlStructures/kt416.kt");
    }

    @Test
    @TestMetadata("kt42455.kt")
    public void testKt42455() {
      runTest("compiler/testData/codegen/box/controlStructures/kt42455.kt");
    }

    @Test
    @TestMetadata("kt47245.kt")
    public void testKt47245() {
      runTest("compiler/testData/codegen/box/controlStructures/kt47245.kt");
    }

    @Test
    @TestMetadata("kt513.kt")
    public void testKt513() {
      runTest("compiler/testData/codegen/box/controlStructures/kt513.kt");
    }

    @Test
    @TestMetadata("kt628.kt")
    public void testKt628() {
      runTest("compiler/testData/codegen/box/controlStructures/kt628.kt");
    }

    @Test
    @TestMetadata("kt769.kt")
    public void testKt769() {
      runTest("compiler/testData/codegen/box/controlStructures/kt769.kt");
    }

    @Test
    @TestMetadata("kt772.kt")
    public void testKt772() {
      runTest("compiler/testData/codegen/box/controlStructures/kt772.kt");
    }

    @Test
    @TestMetadata("kt773.kt")
    public void testKt773() {
      runTest("compiler/testData/codegen/box/controlStructures/kt773.kt");
    }

    @Test
    @TestMetadata("kt8148.kt")
    public void testKt8148() {
      runTest("compiler/testData/codegen/box/controlStructures/kt8148.kt");
    }

    @Test
    @TestMetadata("kt8148_break.kt")
    public void testKt8148_break() {
      runTest("compiler/testData/codegen/box/controlStructures/kt8148_break.kt");
    }

    @Test
    @TestMetadata("kt8148_continue.kt")
    public void testKt8148_continue() {
      runTest("compiler/testData/codegen/box/controlStructures/kt8148_continue.kt");
    }

    @Test
    @TestMetadata("kt870.kt")
    public void testKt870() {
      runTest("compiler/testData/codegen/box/controlStructures/kt870.kt");
    }

    @Test
    @TestMetadata("kt9022Return.kt")
    public void testKt9022Return() {
      runTest("compiler/testData/codegen/box/controlStructures/kt9022Return.kt");
    }

    @Test
    @TestMetadata("kt9022Throw.kt")
    public void testKt9022Throw() {
      runTest("compiler/testData/codegen/box/controlStructures/kt9022Throw.kt");
    }

    @Test
    @TestMetadata("kt910.kt")
    public void testKt910() {
      runTest("compiler/testData/codegen/box/controlStructures/kt910.kt");
    }

    @Test
    @TestMetadata("kt958.kt")
    public void testKt958() {
      runTest("compiler/testData/codegen/box/controlStructures/kt958.kt");
    }

    @Test
    @TestMetadata("longRange.kt")
    public void testLongRange() {
      runTest("compiler/testData/codegen/box/controlStructures/longRange.kt");
    }

    @Test
    @TestMetadata("parameterWithNameForFunctionType.kt")
    public void testParameterWithNameForFunctionType() {
      runTest("compiler/testData/codegen/box/controlStructures/parameterWithNameForFunctionType.kt");
    }

    @Test
    @TestMetadata("quicksort.kt")
    public void testQuicksort() {
      runTest("compiler/testData/codegen/box/controlStructures/quicksort.kt");
    }

    @Test
    @TestMetadata("tcbInEliminatedCondition.kt")
    public void testTcbInEliminatedCondition() {
      runTest("compiler/testData/codegen/box/controlStructures/tcbInEliminatedCondition.kt");
    }

    @Test
    @TestMetadata("tryCatchExpression.kt")
    public void testTryCatchExpression() {
      runTest("compiler/testData/codegen/box/controlStructures/tryCatchExpression.kt");
    }

    @Test
    @TestMetadata("tryCatchFinally.kt")
    public void testTryCatchFinally() {
      runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinally.kt");
    }

    @Test
    @TestMetadata("tryCatchFinallyChain.kt")
    public void testTryCatchFinallyChain() {
      runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinallyChain.kt");
    }

    @Test
    @TestMetadata("tryFinally.kt")
    public void testTryFinally() {
      runTest("compiler/testData/codegen/box/controlStructures/tryFinally.kt");
    }

    @Test
    @TestMetadata("tryFinallyGeneric.kt")
    public void testTryFinallyGeneric() {
      runTest("compiler/testData/codegen/box/controlStructures/tryFinallyGeneric.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions")
    @TestDataPath("$PROJECT_ROOT")
    public class BreakContinueInExpressions {
      @Test
      public void testAllFilesPresentInBreakContinueInExpressions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("breakFromOuter.kt")
      public void testBreakFromOuter() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakFromOuter.kt");
      }

      @Test
      @TestMetadata("breakInDoWhile.kt")
      public void testBreakInDoWhile() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInDoWhile.kt");
      }

      @Test
      @TestMetadata("breakInExpr.kt")
      public void testBreakInExpr() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInExpr.kt");
      }

      @Test
      @TestMetadata("breakInLoopConditions.kt")
      public void testBreakInLoopConditions() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInLoopConditions.kt");
      }

      @Test
      @TestMetadata("continueInDoWhile.kt")
      public void testContinueInDoWhile() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInDoWhile.kt");
      }

      @Test
      @TestMetadata("continueInExpr.kt")
      public void testContinueInExpr() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInExpr.kt");
      }

      @Test
      @TestMetadata("inlineWithStack.kt")
      public void testInlineWithStack() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlineWithStack.kt");
      }

      @Test
      @TestMetadata("innerLoopWithStack.kt")
      public void testInnerLoopWithStack() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/innerLoopWithStack.kt");
      }

      @Test
      @TestMetadata("kt14581.kt")
      public void testKt14581() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt14581.kt");
      }

      @Test
      @TestMetadata("kt16713.kt")
      public void testKt16713() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713.kt");
      }

      @Test
      @TestMetadata("kt16713_2.kt")
      public void testKt16713_2() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713_2.kt");
      }

      @Test
      @TestMetadata("kt17384.kt")
      public void testKt17384() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt17384.kt");
      }

      @Test
      @TestMetadata("kt45704_elvisInInlineFun.kt")
      public void testKt45704_elvisInInlineFun() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt45704_elvisInInlineFun.kt");
      }

      @Test
      @TestMetadata("kt9022And.kt")
      public void testKt9022And() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022And.kt");
      }

      @Test
      @TestMetadata("kt9022Or.kt")
      public void testKt9022Or() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022Or.kt");
      }

      @Test
      @TestMetadata("pathologicalDoWhile.kt")
      public void testPathologicalDoWhile() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/pathologicalDoWhile.kt");
      }

      @Test
      @TestMetadata("popSizes.kt")
      public void testPopSizes() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/popSizes.kt");
      }

      @Test
      @TestMetadata("tryFinally1.kt")
      public void testTryFinally1() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally1.kt");
      }

      @Test
      @TestMetadata("tryFinally2.kt")
      public void testTryFinally2() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally2.kt");
      }

      @Test
      @TestMetadata("whileTrueBreak.kt")
      public void testWhileTrueBreak() {
        runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/whileTrueBreak.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue")
      @TestDataPath("$PROJECT_ROOT")
      public class InlinedBreakContinue {
        @Test
        public void testAllFilesPresentInInlinedBreakContinue() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("continueInTryBlock.kt")
        public void testContinueInTryBlock() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/continueInTryBlock.kt");
        }

        @Test
        @TestMetadata("initializerBlock.kt")
        public void testInitializerBlock() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/initializerBlock.kt");
        }

        @Test
        @TestMetadata("inlineConstructor.kt")
        public void testInlineConstructor() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/inlineConstructor.kt");
        }

        @Test
        @TestMetadata("inlineFunctionWithMultipleParameters.kt")
        public void testInlineFunctionWithMultipleParameters() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/inlineFunctionWithMultipleParameters.kt");
        }

        @Test
        @TestMetadata("lambdaPassedToInlineFunction.kt")
        public void testLambdaPassedToInlineFunction() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/lambdaPassedToInlineFunction.kt");
        }

        @Test
        @TestMetadata("loopWithinInlineFunction.kt")
        public void testLoopWithinInlineFunction() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/loopWithinInlineFunction.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/simple.kt");
        }

        @Test
        @TestMetadata("simpleDoWhile.kt")
        public void testSimpleDoWhile() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/simpleDoWhile.kt");
        }

        @Test
        @TestMetadata("stdlibFunctions.kt")
        public void testStdlibFunctions() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/stdlibFunctions.kt");
        }

        @Test
        @TestMetadata("withReturnValue.kt")
        public void testWithReturnValue() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/withReturnValue.kt");
        }

        @Test
        @TestMetadata("withReturnValueDoWhileContinue.kt")
        public void testWithReturnValueDoWhileContinue() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/withReturnValueDoWhileContinue.kt");
        }

        @Test
        @TestMetadata("withReturnValueNested.kt")
        public void testWithReturnValueNested() {
          runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlinedBreakContinue/withReturnValueNested.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArray")
    @TestDataPath("$PROJECT_ROOT")
    public class ForInArray {
      @Test
      public void testAllFilesPresentInForInArray() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("forInArraySpecializedToUntil.kt")
      public void testForInArraySpecializedToUntil() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArraySpecializedToUntil.kt");
      }

      @Test
      @TestMetadata("forInArrayWithArrayPropertyUpdatedInLoopBody.kt")
      public void testForInArrayWithArrayPropertyUpdatedInLoopBody() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayPropertyUpdatedInLoopBody.kt");
      }

      @Test
      @TestMetadata("forInArrayWithArrayVarUpdatedInLoopBody13.kt")
      public void testForInArrayWithArrayVarUpdatedInLoopBody13() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayVarUpdatedInLoopBody13.kt");
      }

      @Test
      @TestMetadata("forInDelegatedPropertyUpdatedInLoopBody.kt")
      public void testForInDelegatedPropertyUpdatedInLoopBody() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDelegatedPropertyUpdatedInLoopBody.kt");
      }

      @Test
      @TestMetadata("forInDoubleArrayWithUpcast.kt")
      public void testForInDoubleArrayWithUpcast() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDoubleArrayWithUpcast.kt");
      }

      @Test
      @TestMetadata("forInFieldUpdatedInLoopBody.kt")
      public void testForInFieldUpdatedInLoopBody() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInFieldUpdatedInLoopBody.kt");
      }

      @Test
      @TestMetadata("forInInlineClassArrayWithUpcast.kt")
      public void testForInInlineClassArrayWithUpcast() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInInlineClassArrayWithUpcast.kt");
      }

      @Test
      @TestMetadata("forIntArray.kt")
      public void testForIntArray() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forIntArray.kt");
      }

      @Test
      @TestMetadata("forNullableIntArray.kt")
      public void testForNullableIntArray() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forNullableIntArray.kt");
      }

      @Test
      @TestMetadata("forPrimitiveIntArray.kt")
      public void testForPrimitiveIntArray() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArray/forPrimitiveIntArray.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex")
    @TestDataPath("$PROJECT_ROOT")
    public class ForInArrayWithIndex {
      @Test
      public void testAllFilesPresentInForInArrayWithIndex() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("forInArrayOfObjectArrayWithIndex.kt")
      public void testForInArrayOfObjectArrayWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfObjectArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInArrayOfPrimArrayWithIndex.kt")
      public void testForInArrayOfPrimArrayWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfPrimArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInArrayWithIndexBreakAndContinue.kt")
      public void testForInArrayWithIndexBreakAndContinue() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexBreakAndContinue.kt");
      }

      @Test
      @TestMetadata("forInArrayWithIndexContinuesAsUnmodified.kt")
      public void testForInArrayWithIndexContinuesAsUnmodified() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexContinuesAsUnmodified.kt");
      }

      @Test
      @TestMetadata("forInArrayWithIndexNoElementVar.kt")
      public void testForInArrayWithIndexNoElementVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
      }

      @Test
      @TestMetadata("forInArrayWithIndexNoIndexOrElementVar.kt")
      public void testForInArrayWithIndexNoIndexOrElementVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoIndexOrElementVar.kt");
      }

      @Test
      @TestMetadata("forInArrayWithIndexNoIndexVar.kt")
      public void testForInArrayWithIndexNoIndexVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
      }

      @Test
      @TestMetadata("forInArrayWithIndexNotDestructured.kt")
      public void testForInArrayWithIndexNotDestructured() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNotDestructured.kt");
      }

      @Test
      @TestMetadata("forInArrayWithIndexWithExplicitlyTypedIndexVariable.kt")
      public void testForInArrayWithIndexWithExplicitlyTypedIndexVariable() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexWithExplicitlyTypedIndexVariable.kt");
      }

      @Test
      @TestMetadata("forInByteArrayWithIndex.kt")
      public void testForInByteArrayWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInByteArrayWithIndexWithSmartCast.kt")
      public void testForInByteArrayWithIndexWithSmartCast() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndexWithSmartCast.kt");
      }

      @Test
      @TestMetadata("forInEmptyArrayWithIndex.kt")
      public void testForInEmptyArrayWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInGenericArrayOfIntsWithIndex.kt")
      public void testForInGenericArrayOfIntsWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndex.kt");
      }

      @Test
      @TestMetadata("forInGenericArrayOfIntsWithIndexWithSmartCast.kt")
      public void testForInGenericArrayOfIntsWithIndexWithSmartCast() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndexWithSmartCast.kt");
      }

      @Test
      @TestMetadata("forInGenericArrayWithIndex.kt")
      public void testForInGenericArrayWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInIntArrayWithIndex.kt")
      public void testForInIntArrayWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInIntArrayWithIndexWithSmartCast.kt")
      public void testForInIntArrayWithIndexWithSmartCast() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndexWithSmartCast.kt");
      }

      @Test
      @TestMetadata("forInObjectArrayWithIndex.kt")
      public void testForInObjectArrayWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInShortArrayWithIndex.kt")
      public void testForInShortArrayWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndex.kt");
      }

      @Test
      @TestMetadata("forInShortArrayWithIndexWithSmartCast.kt")
      public void testForInShortArrayWithIndexWithSmartCast() {
        runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndexWithSmartCast.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex")
    @TestDataPath("$PROJECT_ROOT")
    public class ForInCharSequenceWithIndex {
      @Test
      public void testAllFilesPresentInForInCharSequenceWithIndex() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("forInCharSeqWithIndexStops.kt")
      public void testForInCharSeqWithIndexStops() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSeqWithIndexStops.kt");
      }

      @Test
      @TestMetadata("forInCharSequenceTypeParameterWithIndex.kt")
      public void testForInCharSequenceTypeParameterWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceTypeParameterWithIndex.kt");
      }

      @Test
      @TestMetadata("forInCharSequenceWithIndex.kt")
      public void testForInCharSequenceWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
      }

      @Test
      @TestMetadata("forInCharSequenceWithIndexBreakAndContinue.kt")
      public void testForInCharSequenceWithIndexBreakAndContinue() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexBreakAndContinue.kt");
      }

      @Test
      @TestMetadata("forInCharSequenceWithIndexCheckSideEffects.kt")
      public void testForInCharSequenceWithIndexCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInCharSequenceWithIndexNoElementVarCheckSideEffects.kt")
      public void testForInCharSequenceWithIndexNoElementVarCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexNoElementVarCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInCharSequenceWithIndexNoIndexVarCheckSideEffects.kt")
      public void testForInCharSequenceWithIndexNoIndexVarCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexNoIndexVarCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInEmptyStringWithIndex.kt")
      public void testForInEmptyStringWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
      }

      @Test
      @TestMetadata("forInStringWithIndex.kt")
      public void testForInStringWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndex.kt");
      }

      @Test
      @TestMetadata("forInStringWithIndexNoElementVar.kt")
      public void testForInStringWithIndexNoElementVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
      }

      @Test
      @TestMetadata("forInStringWithIndexNoIndexOrElementVar.kt")
      public void testForInStringWithIndexNoIndexOrElementVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexOrElementVar.kt");
      }

      @Test
      @TestMetadata("forInStringWithIndexNoIndexVar.kt")
      public void testForInStringWithIndexNoIndexVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
      }

      @Test
      @TestMetadata("forInStringWithIndexNotDestructured.kt")
      public void testForInStringWithIndexNotDestructured() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNotDestructured.kt");
      }

      @Test
      @TestMetadata("forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
      public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() {
        runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex")
    @TestDataPath("$PROJECT_ROOT")
    public class ForInIterableWithIndex {
      @Test
      public void testAllFilesPresentInForInIterableWithIndex() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("forInEmptyListWithIndex.kt")
      public void testForInEmptyListWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInEmptyListWithIndex.kt");
      }

      @Test
      @TestMetadata("forInIterableTypeParameterWithIndex.kt")
      public void testForInIterableTypeParameterWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
      }

      @Test
      @TestMetadata("forInIterableWithIndexCheckSideEffects.kt")
      public void testForInIterableWithIndexCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInIterableWithIndexNoElementVarCheckSideEffects.kt")
      public void testForInIterableWithIndexNoElementVarCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexNoElementVarCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInIterableWithIndexNoIndexVarCheckSideEffects.kt")
      public void testForInIterableWithIndexNoIndexVarCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexNoIndexVarCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInListWithIndex.kt")
      public void testForInListWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndex.kt");
      }

      @Test
      @TestMetadata("forInListWithIndexBreak.kt")
      public void testForInListWithIndexBreak() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexBreak.kt");
      }

      @Test
      @TestMetadata("forInListWithIndexBreakAndContinue.kt")
      public void testForInListWithIndexBreakAndContinue() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexBreakAndContinue.kt");
      }

      @Test
      @TestMetadata("forInListWithIndexContinue.kt")
      public void testForInListWithIndexContinue() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexContinue.kt");
      }

      @Test
      @TestMetadata("forInListWithIndexNoElementVar.kt")
      public void testForInListWithIndexNoElementVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
      }

      @Test
      @TestMetadata("forInListWithIndexNoIndexVar.kt")
      public void testForInListWithIndexNoIndexVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
      }

      @Test
      @TestMetadata("forInListWithIndexThrowsCME.kt")
      public void testForInListWithIndexThrowsCME() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexThrowsCME.kt");
      }

      @Test
      @TestMetadata("forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
      public void testForInListWithIndexWithExplicitlyTypedIndexVariable() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterator")
    @TestDataPath("$PROJECT_ROOT")
    public class ForInIterator {
      @Test
      @TestMetadata("abstractNext.kt")
      public void testAbstractNext() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterator/abstractNext.kt");
      }

      @Test
      public void testAllFilesPresentInForInIterator() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterator"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("primitiveIterator.kt")
      public void testPrimitiveIterator() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterator/primitiveIterator.kt");
      }

      @Test
      @TestMetadata("uintIterator.kt")
      public void testUintIterator() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterator/uintIterator.kt");
      }

      @Test
      @TestMetadata("unrelatedExtensionFunctionNext.kt")
      public void testUnrelatedExtensionFunctionNext() {
        runTest("compiler/testData/codegen/box/controlStructures/forInIterator/unrelatedExtensionFunctionNext.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex")
    @TestDataPath("$PROJECT_ROOT")
    public class ForInSequenceWithIndex {
      @Test
      public void testAllFilesPresentInForInSequenceWithIndex() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("forInEmptySequenceWithIndex.kt")
      public void testForInEmptySequenceWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
      }

      @Test
      @TestMetadata("forInSequenceTypeParameterWithIndex.kt")
      public void testForInSequenceTypeParameterWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndex.kt")
      public void testForInSequenceWithIndex() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndex.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndexBreakAndContinue.kt")
      public void testForInSequenceWithIndexBreakAndContinue() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexBreakAndContinue.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndexCheckSideEffects.kt")
      public void testForInSequenceWithIndexCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndexNoElementVar.kt")
      public void testForInSequenceWithIndexNoElementVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndexNoElementVarCheckSideEffects.kt")
      public void testForInSequenceWithIndexNoElementVarCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVarCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndexNoIndexVar.kt")
      public void testForInSequenceWithIndexNoIndexVar() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndexNoIndexVarCheckSideEffects.kt")
      public void testForInSequenceWithIndexNoIndexVarCheckSideEffects() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVarCheckSideEffects.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndexThrowsCME.kt")
      public void testForInSequenceWithIndexThrowsCME() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
      }

      @Test
      @TestMetadata("forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
      public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() {
        runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing")
    @TestDataPath("$PROJECT_ROOT")
    public class ReturnsNothing {
      @Test
      public void testAllFilesPresentInReturnsNothing() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/returnsNothing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("ifElse.kt")
      public void testIfElse() {
        runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/ifElse.kt");
      }

      @Test
      @TestMetadata("inlineMethod.kt")
      public void testInlineMethod() {
        runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/inlineMethod.kt");
      }

      @Test
      @TestMetadata("propertyGetter.kt")
      public void testPropertyGetter() {
        runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/propertyGetter.kt");
      }

      @Test
      @TestMetadata("tryCatch.kt")
      public void testTryCatch() {
        runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/tryCatch.kt");
      }

      @Test
      @TestMetadata("when.kt")
      public void testWhen() {
        runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/when.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/slowDsl")
    @TestDataPath("$PROJECT_ROOT")
    public class SlowDsl {
      @Test
      public void testAllFilesPresentInSlowDsl() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/slowDsl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("slowHtmlLikeDsl.kt")
      public void testSlowHtmlLikeDsl() {
        runTest("compiler/testData/codegen/box/controlStructures/slowDsl/slowHtmlLikeDsl.kt");
      }

      @Test
      @TestMetadata("slowHtmlLikeDslNoInline.kt")
      public void testSlowHtmlLikeDslNoInline() {
        runTest("compiler/testData/codegen/box/controlStructures/slowDsl/slowHtmlLikeDslNoInline.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions")
    @TestDataPath("$PROJECT_ROOT")
    public class TryCatchInExpressions {
      @Test
      public void testAllFilesPresentInTryCatchInExpressions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("catch.kt")
      public void testCatch() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/catch.kt");
      }

      @Test
      @TestMetadata("complexChain.kt")
      public void testComplexChain() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/complexChain.kt");
      }

      @Test
      @TestMetadata("deadTryCatch.kt")
      public void testDeadTryCatch() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/deadTryCatch.kt");
      }

      @Test
      @TestMetadata("differentTypes.kt")
      public void testDifferentTypes() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/differentTypes.kt");
      }

      @Test
      @TestMetadata("expectException.kt")
      public void testExpectException() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/expectException.kt");
      }

      @Test
      @TestMetadata("finally.kt")
      public void testFinally() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/finally.kt");
      }

      @Test
      @TestMetadata("inlineTryCatch.kt")
      public void testInlineTryCatch() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryCatch.kt");
      }

      @Test
      @TestMetadata("inlineTryExpr.kt")
      public void testInlineTryExpr() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryExpr.kt");
      }

      @Test
      @TestMetadata("inlineTryFinally.kt")
      public void testInlineTryFinally() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryFinally.kt");
      }

      @Test
      @TestMetadata("kt17572.kt")
      public void testKt17572() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572.kt");
      }

      @Test
      @TestMetadata("kt17572_2.kt")
      public void testKt17572_2() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2.kt");
      }

      @Test
      @TestMetadata("kt17572_2_ext.kt")
      public void testKt17572_2_ext() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2_ext.kt");
      }

      @Test
      @TestMetadata("kt17572_ext.kt")
      public void testKt17572_ext() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_ext.kt");
      }

      @Test
      @TestMetadata("kt17572_nested.kt")
      public void testKt17572_nested() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_nested.kt");
      }

      @Test
      @TestMetadata("kt17573.kt")
      public void testKt17573() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573.kt");
      }

      @Test
      @TestMetadata("kt17573_nested.kt")
      public void testKt17573_nested() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573_nested.kt");
      }

      @Test
      @TestMetadata("kt8608.kt")
      public void testKt8608() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt8608.kt");
      }

      @Test
      @TestMetadata("kt9644try.kt")
      public void testKt9644try() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt9644try.kt");
      }

      @Test
      @TestMetadata("multipleCatchBlocks.kt")
      public void testMultipleCatchBlocks() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/multipleCatchBlocks.kt");
      }

      @Test
      @TestMetadata("nonLocalReturnInTryFinally.kt")
      public void testNonLocalReturnInTryFinally() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/nonLocalReturnInTryFinally.kt");
      }

      @Test
      @TestMetadata("splitTry.kt")
      public void testSplitTry() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTry.kt");
      }

      @Test
      @TestMetadata("try.kt")
      public void testTry() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/try.kt");
      }

      @Test
      @TestMetadata("tryAfterTry.kt")
      public void testTryAfterTry() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAfterTry.kt");
      }

      @Test
      @TestMetadata("tryAndBreak.kt")
      public void testTryAndBreak() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndBreak.kt");
      }

      @Test
      @TestMetadata("tryAndContinue.kt")
      public void testTryAndContinue() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndContinue.kt");
      }

      @Test
      @TestMetadata("tryCatchAfterWhileTrue.kt")
      public void testTryCatchAfterWhileTrue() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryCatchAfterWhileTrue.kt");
      }

      @Test
      @TestMetadata("tryFinallyOfTypeUnit.kt")
      public void testTryFinallyOfTypeUnit() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryFinallyOfTypeUnit.kt");
      }

      @Test
      @TestMetadata("tryInsideCatch.kt")
      public void testTryInsideCatch() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideCatch.kt");
      }

      @Test
      @TestMetadata("tryInsideTry.kt")
      public void testTryInsideTry() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideTry.kt");
      }

      @Test
      @TestMetadata("unmatchedInlineMarkers.kt")
      public void testUnmatchedInlineMarkers() {
        runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/unmatchedInlineMarkers.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/controlflow")
  @TestDataPath("$PROJECT_ROOT")
  public class Controlflow {
    @Test
    public void testAllFilesPresentInControlflow() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlflow"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("break.kt")
    public void testBreak() {
      runTest("compiler/testData/codegen/box/controlflow/break.kt");
    }

    @Test
    @TestMetadata("break1.kt")
    public void testBreak1() {
      runTest("compiler/testData/codegen/box/controlflow/break1.kt");
    }

    @Test
    @TestMetadata("callOnSmarcastedNothing.kt")
    public void testCallOnSmarcastedNothing() {
      runTest("compiler/testData/codegen/box/controlflow/callOnSmarcastedNothing.kt");
    }

    @Test
    @TestMetadata("for_loops.kt")
    public void testFor_loops() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops.kt");
    }

    @Test
    @TestMetadata("for_loops_array_break_continue.kt")
    public void testFor_loops_array_break_continue() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_array_break_continue.kt");
    }

    @Test
    @TestMetadata("for_loops_array_indices.kt")
    public void testFor_loops_array_indices() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_array_indices.kt");
    }

    @Test
    @TestMetadata("for_loops_array_mutation.kt")
    public void testFor_loops_array_mutation() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_array_mutation.kt");
    }

    @Test
    @TestMetadata("for_loops_array_nested.kt")
    public void testFor_loops_array_nested() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_array_nested.kt");
    }

    @Test
    @TestMetadata("for_loops_array_nullable.kt")
    public void testFor_loops_array_nullable() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_array_nullable.kt");
    }

    @Test
    @TestMetadata("for_loops_array_side_effects.kt")
    public void testFor_loops_array_side_effects() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_array_side_effects.kt");
    }

    @Test
    @TestMetadata("for_loops_call_order.kt")
    public void testFor_loops_call_order() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_call_order.kt");
    }

    @Test
    @TestMetadata("for_loops_coroutines.kt")
    public void testFor_loops_coroutines() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_coroutines.kt");
    }

    @Test
    @TestMetadata("for_loops_empty_range.kt")
    public void testFor_loops_empty_range() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_empty_range.kt");
    }

    @Test
    @TestMetadata("for_loops_errors.kt")
    public void testFor_loops_errors() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_errors.kt");
    }

    @Test
    @TestMetadata("for_loops_let_with_nullable.kt")
    public void testFor_loops_let_with_nullable() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_let_with_nullable.kt");
    }

    @Test
    @TestMetadata("for_loops_nested.kt")
    public void testFor_loops_nested() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_nested.kt");
    }

    @Test
    @TestMetadata("for_loops_overflow.kt")
    public void testFor_loops_overflow() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_overflow.kt");
    }

    @Test
    @TestMetadata("for_loops_types.kt")
    public void testFor_loops_types() {
      runTest("compiler/testData/codegen/box/controlflow/for_loops_types.kt");
    }

    @Test
    @TestMetadata("smartcastOnThisInInitializationSection.kt")
    public void testSmartcastOnThisInInitializationSection() {
      runTest("compiler/testData/codegen/box/controlflow/smartcastOnThisInInitializationSection.kt");
    }

    @Test
    @TestMetadata("unreachable1.kt")
    public void testUnreachable1() {
      runTest("compiler/testData/codegen/box/controlflow/unreachable1.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/coroutines")
  @TestDataPath("$PROJECT_ROOT")
  public class Coroutines {
    @Test
    @TestMetadata("32defaultParametersInSuspend.kt")
    public void test32defaultParametersInSuspend() {
      runTest("compiler/testData/codegen/box/coroutines/32defaultParametersInSuspend.kt");
    }

    @Test
    @TestMetadata("accessorForSuspend.kt")
    public void testAccessorForSuspend() {
      runTest("compiler/testData/codegen/box/coroutines/accessorForSuspend.kt");
    }

    @Test
    public void testAllFilesPresentInCoroutines() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("anonymousObject.kt")
    public void testAnonymousObject() {
      runTest("compiler/testData/codegen/box/coroutines/anonymousObject.kt");
    }

    @Test
    @TestMetadata("async.kt")
    public void testAsync() {
      runTest("compiler/testData/codegen/box/coroutines/async.kt");
    }

    @Test
    @TestMetadata("asyncException.kt")
    public void testAsyncException() {
      runTest("compiler/testData/codegen/box/coroutines/asyncException.kt");
    }

    @Test
    @TestMetadata("asyncIteratorNullMerge_1_3.kt")
    public void testAsyncIteratorNullMerge_1_3() {
      runTest("compiler/testData/codegen/box/coroutines/asyncIteratorNullMerge_1_3.kt");
    }

    @Test
    @TestMetadata("asyncIteratorToList_1_3.kt")
    public void testAsyncIteratorToList_1_3() {
      runTest("compiler/testData/codegen/box/coroutines/asyncIteratorToList_1_3.kt");
    }

    @Test
    @TestMetadata("asyncIterator_1_3.kt")
    public void testAsyncIterator_1_3() {
      runTest("compiler/testData/codegen/box/coroutines/asyncIterator_1_3.kt");
    }

    @Test
    @TestMetadata("await.kt")
    public void testAwait() {
      runTest("compiler/testData/codegen/box/coroutines/await.kt");
    }

    @Test
    @TestMetadata("beginWithException.kt")
    public void testBeginWithException() {
      runTest("compiler/testData/codegen/box/coroutines/beginWithException.kt");
    }

    @Test
    @TestMetadata("beginWithExceptionNoHandleException.kt")
    public void testBeginWithExceptionNoHandleException() {
      runTest("compiler/testData/codegen/box/coroutines/beginWithExceptionNoHandleException.kt");
    }

    @Test
    @TestMetadata("builderInferenceAndGenericArrayAcessCall.kt")
    public void testBuilderInferenceAndGenericArrayAcessCall() {
      runTest("compiler/testData/codegen/box/coroutines/builderInferenceAndGenericArrayAcessCall.kt");
    }

    @Test
    @TestMetadata("captureInfixFun.kt")
    public void testCaptureInfixFun() {
      runTest("compiler/testData/codegen/box/coroutines/captureInfixFun.kt");
    }

    @Test
    @TestMetadata("captureMutableLocalVariableInsideCoroutineBlock.kt")
    public void testCaptureMutableLocalVariableInsideCoroutineBlock() {
      runTest("compiler/testData/codegen/box/coroutines/captureMutableLocalVariableInsideCoroutineBlock.kt");
    }

    @Test
    @TestMetadata("captureUnaryOperator.kt")
    public void testCaptureUnaryOperator() {
      runTest("compiler/testData/codegen/box/coroutines/captureUnaryOperator.kt");
    }

    @Test
    @TestMetadata("capturedVarInSuspendLambda.kt")
    public void testCapturedVarInSuspendLambda() {
      runTest("compiler/testData/codegen/box/coroutines/capturedVarInSuspendLambda.kt");
    }

    @Test
    @TestMetadata("castWithSuspend.kt")
    public void testCastWithSuspend() {
      runTest("compiler/testData/codegen/box/coroutines/castWithSuspend.kt");
    }

    @Test
    @TestMetadata("catchWithInlineInsideSuspend.kt")
    public void testCatchWithInlineInsideSuspend() {
      runTest("compiler/testData/codegen/box/coroutines/catchWithInlineInsideSuspend.kt");
    }

    @Test
    @TestMetadata("coercionToUnit.kt")
    public void testCoercionToUnit() {
      runTest("compiler/testData/codegen/box/coroutines/coercionToUnit.kt");
    }

    @Test
    @TestMetadata("controlFlow_chain.kt")
    public void testControlFlow_chain() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_chain.kt");
    }

    @Test
    @TestMetadata("controlFlow_finally1.kt")
    public void testControlFlow_finally1() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_finally1.kt");
    }

    @Test
    @TestMetadata("controlFlow_finally2.kt")
    public void testControlFlow_finally2() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_finally2.kt");
    }

    @Test
    @TestMetadata("controlFlow_finally3.kt")
    public void testControlFlow_finally3() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_finally3.kt");
    }

    @Test
    @TestMetadata("controlFlow_finally4.kt")
    public void testControlFlow_finally4() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_finally4.kt");
    }

    @Test
    @TestMetadata("controlFlow_finally5.kt")
    public void testControlFlow_finally5() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_finally5.kt");
    }

    @Test
    @TestMetadata("controlFlow_finally6.kt")
    public void testControlFlow_finally6() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_finally6.kt");
    }

    @Test
    @TestMetadata("controlFlow_finally7.kt")
    public void testControlFlow_finally7() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_finally7.kt");
    }

    @Test
    @TestMetadata("controlFlow_if1.kt")
    public void testControlFlow_if1() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_if1.kt");
    }

    @Test
    @TestMetadata("controlFlow_if2.kt")
    public void testControlFlow_if2() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_if2.kt");
    }

    @Test
    @TestMetadata("controlFlow_inline1.kt")
    public void testControlFlow_inline1() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_inline1.kt");
    }

    @Test
    @TestMetadata("controlFlow_inline2.kt")
    public void testControlFlow_inline2() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_inline2.kt");
    }

    @Test
    @TestMetadata("controlFlow_inline3.kt")
    public void testControlFlow_inline3() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_inline3.kt");
    }

    @Test
    @TestMetadata("controlFlow_tryCatch1.kt")
    public void testControlFlow_tryCatch1() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_tryCatch1.kt");
    }

    @Test
    @TestMetadata("controlFlow_tryCatch2.kt")
    public void testControlFlow_tryCatch2() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_tryCatch2.kt");
    }

    @Test
    @TestMetadata("controlFlow_tryCatch3.kt")
    public void testControlFlow_tryCatch3() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_tryCatch3.kt");
    }

    @Test
    @TestMetadata("controlFlow_tryCatch4.kt")
    public void testControlFlow_tryCatch4() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_tryCatch4.kt");
    }

    @Test
    @TestMetadata("controlFlow_tryCatch5.kt")
    public void testControlFlow_tryCatch5() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_tryCatch5.kt");
    }

    @Test
    @TestMetadata("controlFlow_while1.kt")
    public void testControlFlow_while1() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_while1.kt");
    }

    @Test
    @TestMetadata("controlFlow_while2.kt")
    public void testControlFlow_while2() {
      runTest("compiler/testData/codegen/box/coroutines/controlFlow_while2.kt");
    }

    @Test
    @TestMetadata("controllerAccessFromInnerLambda.kt")
    public void testControllerAccessFromInnerLambda() {
      runTest("compiler/testData/codegen/box/coroutines/controllerAccessFromInnerLambda.kt");
    }

    @Test
    @TestMetadata("coroutineContext1.kt")
    public void testCoroutineContext1() {
      runTest("compiler/testData/codegen/box/coroutines/coroutineContext1.kt");
    }

    @Test
    @TestMetadata("coroutineContext2.kt")
    public void testCoroutineContext2() {
      runTest("compiler/testData/codegen/box/coroutines/coroutineContext2.kt");
    }

    @Test
    @TestMetadata("coroutineContextInInlinedLambda.kt")
    public void testCoroutineContextInInlinedLambda() {
      runTest("compiler/testData/codegen/box/coroutines/coroutineContextInInlinedLambda.kt");
    }

    @Test
    @TestMetadata("coroutineToString.kt")
    public void testCoroutineToString() {
      runTest("compiler/testData/codegen/box/coroutines/coroutineToString.kt");
    }

    @Test
    @TestMetadata("correctOrder1.kt")
    public void testCorrectOrder1() {
      runTest("compiler/testData/codegen/box/coroutines/correctOrder1.kt");
    }

    @Test
    @TestMetadata("createCoroutineSafe.kt")
    public void testCreateCoroutineSafe() {
      runTest("compiler/testData/codegen/box/coroutines/createCoroutineSafe.kt");
    }

    @Test
    @TestMetadata("createCoroutinesOnManualInstances.kt")
    public void testCreateCoroutinesOnManualInstances() {
      runTest("compiler/testData/codegen/box/coroutines/createCoroutinesOnManualInstances.kt");
    }

    @Test
    @TestMetadata("crossInlineWithCapturedOuterReceiver.kt")
    public void testCrossInlineWithCapturedOuterReceiver() {
      runTest("compiler/testData/codegen/box/coroutines/crossInlineWithCapturedOuterReceiver.kt");
    }

    @Test
    @TestMetadata("defaultParameterLambdaInSuspend.kt")
    public void testDefaultParameterLambdaInSuspend() {
      runTest("compiler/testData/codegen/box/coroutines/defaultParameterLambdaInSuspend.kt");
    }

    @Test
    @TestMetadata("defaultParametersInSuspend.kt")
    public void testDefaultParametersInSuspend() {
      runTest("compiler/testData/codegen/box/coroutines/defaultParametersInSuspend.kt");
    }

    @Test
    @TestMetadata("defaultParametersInSuspendWithJvmOverloads.kt")
    public void testDefaultParametersInSuspendWithJvmOverloads() {
      runTest("compiler/testData/codegen/box/coroutines/defaultParametersInSuspendWithJvmOverloads.kt");
    }

    @Test
    @TestMetadata("degenerate1.kt")
    public void testDegenerate1() {
      runTest("compiler/testData/codegen/box/coroutines/degenerate1.kt");
    }

    @Test
    @TestMetadata("degenerate2.kt")
    public void testDegenerate2() {
      runTest("compiler/testData/codegen/box/coroutines/degenerate2.kt");
    }

    @Test
    @TestMetadata("delegatedSuspendMember.kt")
    public void testDelegatedSuspendMember() {
      runTest("compiler/testData/codegen/box/coroutines/delegatedSuspendMember.kt");
    }

    @Test
    @TestMetadata("deserializedSuspendFunctionProperty.kt")
    public void testDeserializedSuspendFunctionProperty() {
      runTest("compiler/testData/codegen/box/coroutines/deserializedSuspendFunctionProperty.kt");
    }

    @Test
    @TestMetadata("dispatchResume.kt")
    public void testDispatchResume() {
      runTest("compiler/testData/codegen/box/coroutines/dispatchResume.kt");
    }

    @Test
    @TestMetadata("doubleColonExpressionsGenerationInBuilderInference.kt")
    public void testDoubleColonExpressionsGenerationInBuilderInference() {
      runTest("compiler/testData/codegen/box/coroutines/doubleColonExpressionsGenerationInBuilderInference.kt");
    }

    @Test
    @TestMetadata("emptyClosure.kt")
    public void testEmptyClosure() {
      runTest("compiler/testData/codegen/box/coroutines/emptyClosure.kt");
    }

    @Test
    @TestMetadata("emptyCommonConstraintSystemForCoroutineInferenceCall.kt")
    public void testEmptyCommonConstraintSystemForCoroutineInferenceCall() {
      runTest("compiler/testData/codegen/box/coroutines/emptyCommonConstraintSystemForCoroutineInferenceCall.kt");
    }

    @Test
    @TestMetadata("epam.kt")
    public void testEpam() {
      runTest("compiler/testData/codegen/box/coroutines/epam.kt");
    }

    @Test
    @TestMetadata("falseUnitCoercion.kt")
    public void testFalseUnitCoercion() {
      runTest("compiler/testData/codegen/box/coroutines/falseUnitCoercion.kt");
    }

    @Test
    @TestMetadata("functionReference_eqeq_name.kt")
    public void testFunctionReference_eqeq_name() {
      runTest("compiler/testData/codegen/box/coroutines/functionReference_eqeq_name.kt");
    }

    @Test
    @TestMetadata("functionReference_invokeAsFunction.kt")
    public void testFunctionReference_invokeAsFunction() {
      runTest("compiler/testData/codegen/box/coroutines/functionReference_invokeAsFunction.kt");
    }

    @Test
    @TestMetadata("functionReference_lambdaAsSuspendLambda.kt")
    public void testFunctionReference_lambdaAsSuspendLambda() {
      runTest("compiler/testData/codegen/box/coroutines/functionReference_lambdaAsSuspendLambda.kt");
    }

    @Test
    @TestMetadata("functionReference_simple.kt")
    public void testFunctionReference_simple() {
      runTest("compiler/testData/codegen/box/coroutines/functionReference_simple.kt");
    }

    @Test
    @TestMetadata("generate.kt")
    public void testGenerate() {
      runTest("compiler/testData/codegen/box/coroutines/generate.kt");
    }

    @Test
    @TestMetadata("genericSignatureForSuspendImpl.kt")
    public void testGenericSignatureForSuspendImpl() {
      runTest("compiler/testData/codegen/box/coroutines/genericSignatureForSuspendImpl.kt");
    }

    @Test
    @TestMetadata("handleException.kt")
    public void testHandleException() {
      runTest("compiler/testData/codegen/box/coroutines/handleException.kt");
    }

    @Test
    @TestMetadata("handleResultCallEmptyBody.kt")
    public void testHandleResultCallEmptyBody() {
      runTest("compiler/testData/codegen/box/coroutines/handleResultCallEmptyBody.kt");
    }

    @Test
    @TestMetadata("handleResultNonUnitExpression.kt")
    public void testHandleResultNonUnitExpression() {
      runTest("compiler/testData/codegen/box/coroutines/handleResultNonUnitExpression.kt");
    }

    @Test
    @TestMetadata("handleResultSuspended.kt")
    public void testHandleResultSuspended() {
      runTest("compiler/testData/codegen/box/coroutines/handleResultSuspended.kt");
    }

    @Test
    @TestMetadata("illegalState.kt")
    public void testIllegalState() {
      runTest("compiler/testData/codegen/box/coroutines/illegalState.kt");
    }

    @Test
    @TestMetadata("indirectInlineUsedAsNonInline.kt")
    public void testIndirectInlineUsedAsNonInline() {
      runTest("compiler/testData/codegen/box/coroutines/indirectInlineUsedAsNonInline.kt");
    }

    @Test
    @TestMetadata("infiniteLoopInNextMeaningful.kt")
    public void testInfiniteLoopInNextMeaningful() {
      runTest("compiler/testData/codegen/box/coroutines/infiniteLoopInNextMeaningful.kt");
    }

    @Test
    @TestMetadata("inlineCallWithReturns.kt")
    public void testInlineCallWithReturns() {
      runTest("compiler/testData/codegen/box/coroutines/inlineCallWithReturns.kt");
    }

    @Test
    @TestMetadata("inlineFunInGenericClass.kt")
    public void testInlineFunInGenericClass() {
      runTest("compiler/testData/codegen/box/coroutines/inlineFunInGenericClass.kt");
    }

    @Test
    @TestMetadata("inlineFunctionInMultifileClass.kt")
    public void testInlineFunctionInMultifileClass() {
      runTest("compiler/testData/codegen/box/coroutines/inlineFunctionInMultifileClass.kt");
    }

    @Test
    @TestMetadata("inlineFunctionInMultifileClassUnoptimized.kt")
    public void testInlineFunctionInMultifileClassUnoptimized() {
      runTest("compiler/testData/codegen/box/coroutines/inlineFunctionInMultifileClassUnoptimized.kt");
    }

    @Test
    @TestMetadata("inlineGenericFunCalledFromSubclass.kt")
    public void testInlineGenericFunCalledFromSubclass() {
      runTest("compiler/testData/codegen/box/coroutines/inlineGenericFunCalledFromSubclass.kt");
    }

    @Test
    @TestMetadata("inlineSuspendFunction.kt")
    public void testInlineSuspendFunction() {
      runTest("compiler/testData/codegen/box/coroutines/inlineSuspendFunction.kt");
    }

    @Test
    @TestMetadata("inlineSuspendLambdaNonLocalReturn.kt")
    public void testInlineSuspendLambdaNonLocalReturn() {
      runTest("compiler/testData/codegen/box/coroutines/inlineSuspendLambdaNonLocalReturn.kt");
    }

    @Test
    @TestMetadata("inlineSuspendTypealias.kt")
    public void testInlineSuspendTypealias() {
      runTest("compiler/testData/codegen/box/coroutines/inlineSuspendTypealias.kt");
    }

    @Test
    @TestMetadata("inlinedTryCatchFinally.kt")
    public void testInlinedTryCatchFinally() {
      runTest("compiler/testData/codegen/box/coroutines/inlinedTryCatchFinally.kt");
    }

    @Test
    @TestMetadata("innerSuspensionCalls.kt")
    public void testInnerSuspensionCalls() {
      runTest("compiler/testData/codegen/box/coroutines/innerSuspensionCalls.kt");
    }

    @Test
    @TestMetadata("instanceOfContinuation.kt")
    public void testInstanceOfContinuation() {
      runTest("compiler/testData/codegen/box/coroutines/instanceOfContinuation.kt");
    }

    @Test
    @TestMetadata("iterateOverArray.kt")
    public void testIterateOverArray() {
      runTest("compiler/testData/codegen/box/coroutines/iterateOverArray.kt");
    }

    @Test
    @TestMetadata("jvmStaticAndJvmInline.kt")
    public void testJvmStaticAndJvmInline() {
      runTest("compiler/testData/codegen/box/coroutines/jvmStaticAndJvmInline.kt");
    }

    @Test
    @TestMetadata("kt12958.kt")
    public void testKt12958() {
      runTest("compiler/testData/codegen/box/coroutines/kt12958.kt");
    }

    @Test
    @TestMetadata("kt15016.kt")
    public void testKt15016() {
      runTest("compiler/testData/codegen/box/coroutines/kt15016.kt");
    }

    @Test
    @TestMetadata("kt15017.kt")
    public void testKt15017() {
      runTest("compiler/testData/codegen/box/coroutines/kt15017.kt");
    }

    @Test
    @TestMetadata("kt15930.kt")
    public void testKt15930() {
      runTest("compiler/testData/codegen/box/coroutines/kt15930.kt");
    }

    @Test
    @TestMetadata("kt21080.kt")
    public void testKt21080() {
      runTest("compiler/testData/codegen/box/coroutines/kt21080.kt");
    }

    @Test
    @TestMetadata("kt21605.kt")
    public void testKt21605() {
      runTest("compiler/testData/codegen/box/coroutines/kt21605.kt");
    }

    @Test
    @TestMetadata("kt24135.kt")
    public void testKt24135() {
      runTest("compiler/testData/codegen/box/coroutines/kt24135.kt");
    }

    @Test
    @TestMetadata("kt25912.kt")
    public void testKt25912() {
      runTest("compiler/testData/codegen/box/coroutines/kt25912.kt");
    }

    @Test
    @TestMetadata("kt28844.kt")
    public void testKt28844() {
      runTest("compiler/testData/codegen/box/coroutines/kt28844.kt");
    }

    @Test
    @TestMetadata("kt30858.kt")
    public void testKt30858() {
      runTest("compiler/testData/codegen/box/coroutines/kt30858.kt");
    }

    @Test
    @TestMetadata("kt31784.kt")
    public void testKt31784() {
      runTest("compiler/testData/codegen/box/coroutines/kt31784.kt");
    }

    @Test
    @TestMetadata("kt35967.kt")
    public void testKt35967() {
      runTest("compiler/testData/codegen/box/coroutines/kt35967.kt");
    }

    @Test
    @TestMetadata("kt38099.kt")
    public void testKt38099() {
      runTest("compiler/testData/codegen/box/coroutines/kt38099.kt");
    }

    @Test
    @TestMetadata("kt41394.kt")
    public void testKt41394() {
      runTest("compiler/testData/codegen/box/coroutines/kt41394.kt");
    }

    @Test
    @TestMetadata("kt42028.kt")
    public void testKt42028() {
      runTest("compiler/testData/codegen/box/coroutines/kt42028.kt");
    }

    @Test
    @TestMetadata("kt42554.kt")
    public void testKt42554() {
      runTest("compiler/testData/codegen/box/coroutines/kt42554.kt");
    }

    @Test
    @TestMetadata("kt44221.kt")
    public void testKt44221() {
      runTest("compiler/testData/codegen/box/coroutines/kt44221.kt");
    }

    @Test
    @TestMetadata("kt44710.kt")
    public void testKt44710() {
      runTest("compiler/testData/codegen/box/coroutines/kt44710.kt");
    }

    @Test
    @TestMetadata("kt44781.kt")
    public void testKt44781() {
      runTest("compiler/testData/codegen/box/coroutines/kt44781.kt");
    }

    @Test
    @TestMetadata("kt45377.kt")
    public void testKt45377() {
      runTest("compiler/testData/codegen/box/coroutines/kt45377.kt");
    }

    @Test
    @TestMetadata("kt46813.kt")
    public void testKt46813() {
      runTest("compiler/testData/codegen/box/coroutines/kt46813.kt");
    }

    @Test
    @TestMetadata("kt49168.kt")
    public void testKt49168() {
      runTest("compiler/testData/codegen/box/coroutines/kt49168.kt");
    }

    @Test
    @TestMetadata("kt49317.kt")
    public void testKt49317() {
      runTest("compiler/testData/codegen/box/coroutines/kt49317.kt");
    }

    @Test
    @TestMetadata("kt49645.kt")
    public void testKt49645() {
      runTest("compiler/testData/codegen/box/coroutines/kt49645.kt");
    }

    @Test
    @TestMetadata("kt50277.kt")
    public void testKt50277() {
      runTest("compiler/testData/codegen/box/coroutines/kt50277.kt");
    }

    @Test
    @TestMetadata("kt51530.kt")
    public void testKt51530() {
      runTest("compiler/testData/codegen/box/coroutines/kt51530.kt");
    }

    @Test
    @TestMetadata("kt51718.kt")
    public void testKt51718() {
      runTest("compiler/testData/codegen/box/coroutines/kt51718.kt");
    }

    @Test
    @TestMetadata("kt52311_nullOnLeft.kt")
    public void testKt52311_nullOnLeft() {
      runTest("compiler/testData/codegen/box/coroutines/kt52311_nullOnLeft.kt");
    }

    @Test
    @TestMetadata("kt52311_nullOnRight.kt")
    public void testKt52311_nullOnRight() {
      runTest("compiler/testData/codegen/box/coroutines/kt52311_nullOnRight.kt");
    }

    @Test
    @TestMetadata("kt52561.kt")
    public void testKt52561() {
      runTest("compiler/testData/codegen/box/coroutines/kt52561.kt");
    }

    @Test
    @TestMetadata("kt55494.kt")
    public void testKt55494() {
      runTest("compiler/testData/codegen/box/coroutines/kt55494.kt");
    }

    @Test
    @TestMetadata("kt56407.kt")
    public void testKt56407() {
      runTest("compiler/testData/codegen/box/coroutines/kt56407.kt");
    }

    @Test
    @TestMetadata("lastExpressionIsLoop.kt")
    public void testLastExpressionIsLoop() {
      runTest("compiler/testData/codegen/box/coroutines/lastExpressionIsLoop.kt");
    }

    @Test
    @TestMetadata("lastStatementInc.kt")
    public void testLastStatementInc() {
      runTest("compiler/testData/codegen/box/coroutines/lastStatementInc.kt");
    }

    @Test
    @TestMetadata("lastStementAssignment.kt")
    public void testLastStementAssignment() {
      runTest("compiler/testData/codegen/box/coroutines/lastStementAssignment.kt");
    }

    @Test
    @TestMetadata("lastUnitExpression.kt")
    public void testLastUnitExpression() {
      runTest("compiler/testData/codegen/box/coroutines/lastUnitExpression.kt");
    }

    @Test
    @TestMetadata("localCallableRef.kt")
    public void testLocalCallableRef() {
      runTest("compiler/testData/codegen/box/coroutines/localCallableRef.kt");
    }

    @Test
    @TestMetadata("localDelegate.kt")
    public void testLocalDelegate() {
      runTest("compiler/testData/codegen/box/coroutines/localDelegate.kt");
    }

    @Test
    @TestMetadata("longRangeInSuspendCall.kt")
    public void testLongRangeInSuspendCall() {
      runTest("compiler/testData/codegen/box/coroutines/longRangeInSuspendCall.kt");
    }

    @Test
    @TestMetadata("longRangeInSuspendFun.kt")
    public void testLongRangeInSuspendFun() {
      runTest("compiler/testData/codegen/box/coroutines/longRangeInSuspendFun.kt");
    }

    @Test
    @TestMetadata("mergeNullAndString.kt")
    public void testMergeNullAndString() {
      runTest("compiler/testData/codegen/box/coroutines/mergeNullAndString.kt");
    }

    @Test
    @TestMetadata("multipleInvokeCalls.kt")
    public void testMultipleInvokeCalls() {
      runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCalls.kt");
    }

    @Test
    @TestMetadata("multipleInvokeCallsInsideInlineLambda1.kt")
    public void testMultipleInvokeCallsInsideInlineLambda1() {
      runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda1.kt");
    }

    @Test
    @TestMetadata("multipleInvokeCallsInsideInlineLambda2.kt")
    public void testMultipleInvokeCallsInsideInlineLambda2() {
      runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda2.kt");
    }

    @Test
    @TestMetadata("multipleInvokeCallsInsideInlineLambda3.kt")
    public void testMultipleInvokeCallsInsideInlineLambda3() {
      runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda3.kt");
    }

    @Test
    @TestMetadata("nestedTryCatch.kt")
    public void testNestedTryCatch() {
      runTest("compiler/testData/codegen/box/coroutines/nestedTryCatch.kt");
    }

    @Test
    @TestMetadata("noSuspensionPoints.kt")
    public void testNoSuspensionPoints() {
      runTest("compiler/testData/codegen/box/coroutines/noSuspensionPoints.kt");
    }

    @Test
    @TestMetadata("nonLocalReturn.kt")
    public void testNonLocalReturn() {
      runTest("compiler/testData/codegen/box/coroutines/nonLocalReturn.kt");
    }

    @Test
    @TestMetadata("nonLocalReturnFromInlineLambda.kt")
    public void testNonLocalReturnFromInlineLambda() {
      runTest("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambda.kt");
    }

    @Test
    @TestMetadata("nonLocalReturnFromInlineLambdaDeep.kt")
    public void testNonLocalReturnFromInlineLambdaDeep() {
      runTest("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambdaDeep.kt");
    }

    @Test
    @TestMetadata("nullableSuspendFunctionType.kt")
    public void testNullableSuspendFunctionType() {
      runTest("compiler/testData/codegen/box/coroutines/nullableSuspendFunctionType.kt");
    }

    @Test
    @TestMetadata("overrideDefaultArgument.kt")
    public void testOverrideDefaultArgument() {
      runTest("compiler/testData/codegen/box/coroutines/overrideDefaultArgument.kt");
    }

    @Test
    @TestMetadata("recursiveSuspend.kt")
    public void testRecursiveSuspend() {
      runTest("compiler/testData/codegen/box/coroutines/recursiveSuspend.kt");
    }

    @Test
    @TestMetadata("restrictedSuspendLambda.kt")
    public void testRestrictedSuspendLambda() {
      runTest("compiler/testData/codegen/box/coroutines/restrictedSuspendLambda.kt");
    }

    @Test
    @TestMetadata("returnByLabel.kt")
    public void testReturnByLabel() {
      runTest("compiler/testData/codegen/box/coroutines/returnByLabel.kt");
    }

    @Test
    @TestMetadata("returnsNothing1.kt")
    public void testReturnsNothing1() {
      runTest("compiler/testData/codegen/box/coroutines/returnsNothing1.kt");
    }

    @Test
    @TestMetadata("returnsUnit1.kt")
    public void testReturnsUnit1() {
      runTest("compiler/testData/codegen/box/coroutines/returnsUnit1.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/coroutines/simple.kt");
    }

    @Test
    @TestMetadata("simple2.kt")
    public void testSimple2() {
      runTest("compiler/testData/codegen/box/coroutines/simple2.kt");
    }

    @Test
    @TestMetadata("simpleException.kt")
    public void testSimpleException() {
      runTest("compiler/testData/codegen/box/coroutines/simpleException.kt");
    }

    @Test
    @TestMetadata("simpleSuspendCallableReference.kt")
    public void testSimpleSuspendCallableReference() {
      runTest("compiler/testData/codegen/box/coroutines/simpleSuspendCallableReference.kt");
    }

    @Test
    @TestMetadata("simpleWithDefaultValue.kt")
    public void testSimpleWithDefaultValue() {
      runTest("compiler/testData/codegen/box/coroutines/simpleWithDefaultValue.kt");
    }

    @Test
    @TestMetadata("simpleWithHandleResult.kt")
    public void testSimpleWithHandleResult() {
      runTest("compiler/testData/codegen/box/coroutines/simpleWithHandleResult.kt");
    }

    @Test
    @TestMetadata("statementLikeLastExpression.kt")
    public void testStatementLikeLastExpression() {
      runTest("compiler/testData/codegen/box/coroutines/statementLikeLastExpression.kt");
    }

    @Test
    @TestMetadata("stopAfter.kt")
    public void testStopAfter() {
      runTest("compiler/testData/codegen/box/coroutines/stopAfter.kt");
    }

    @Test
    @TestMetadata("suspendCallInSuperInterfaceCallArguments.kt")
    public void testSuspendCallInSuperInterfaceCallArguments() {
      runTest("compiler/testData/codegen/box/coroutines/suspendCallInSuperInterfaceCallArguments.kt");
    }

    @Test
    @TestMetadata("suspendCallsInArguments.kt")
    public void testSuspendCallsInArguments() {
      runTest("compiler/testData/codegen/box/coroutines/suspendCallsInArguments.kt");
    }

    @Test
    @TestMetadata("suspendConversion.kt")
    public void testSuspendConversion() {
      runTest("compiler/testData/codegen/box/coroutines/suspendConversion.kt");
    }

    @Test
    @TestMetadata("suspendCoroutineFromStateMachine.kt")
    public void testSuspendCoroutineFromStateMachine() {
      runTest("compiler/testData/codegen/box/coroutines/suspendCoroutineFromStateMachine.kt");
    }

    @Test
    @TestMetadata("suspendCovariantJavaOverrides.kt")
    public void testSuspendCovariantJavaOverrides() {
      runTest("compiler/testData/codegen/box/coroutines/suspendCovariantJavaOverrides.kt");
    }

    @Test
    @TestMetadata("suspendDefaultImpl.kt")
    public void testSuspendDefaultImpl() {
      runTest("compiler/testData/codegen/box/coroutines/suspendDefaultImpl.kt");
    }

    @Test
    @TestMetadata("suspendDelegation.kt")
    public void testSuspendDelegation() {
      runTest("compiler/testData/codegen/box/coroutines/suspendDelegation.kt");
    }

    @Test
    @TestMetadata("suspendFromInlineLambda.kt")
    public void testSuspendFromInlineLambda() {
      runTest("compiler/testData/codegen/box/coroutines/suspendFromInlineLambda.kt");
    }

    @Test
    @TestMetadata("suspendFunImportedFromObject.kt")
    public void testSuspendFunImportedFromObject() {
      runTest("compiler/testData/codegen/box/coroutines/suspendFunImportedFromObject.kt");
    }

    @Test
    @TestMetadata("suspendFunctionAsSupertype.kt")
    public void testSuspendFunctionAsSupertype() {
      runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsSupertype.kt");
    }

    @Test
    @TestMetadata("suspendFunctionAsSupertypeCall.kt")
    public void testSuspendFunctionAsSupertypeCall() {
      runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsSupertypeCall.kt");
    }

    @Test
    @TestMetadata("suspendFunctionMethodReference.kt")
    public void testSuspendFunctionMethodReference() {
      runTest("compiler/testData/codegen/box/coroutines/suspendFunctionMethodReference.kt");
    }

    @Test
    @TestMetadata("suspendImplBridge.kt")
    public void testSuspendImplBridge() {
      runTest("compiler/testData/codegen/box/coroutines/suspendImplBridge.kt");
    }

    @Test
    @TestMetadata("suspendImplTypeParameters.kt")
    public void testSuspendImplTypeParameters() {
      runTest("compiler/testData/codegen/box/coroutines/suspendImplTypeParameters.kt");
    }

    @Test
    @TestMetadata("suspendImplTypeParametersOuterClass.kt")
    public void testSuspendImplTypeParametersOuterClass() {
      runTest("compiler/testData/codegen/box/coroutines/suspendImplTypeParametersOuterClass.kt");
    }

    @Test
    @TestMetadata("suspendInCycle.kt")
    public void testSuspendInCycle() {
      runTest("compiler/testData/codegen/box/coroutines/suspendInCycle.kt");
    }

    @Test
    @TestMetadata("suspendInTheMiddleOfObjectConstruction.kt")
    public void testSuspendInTheMiddleOfObjectConstruction() {
      runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstruction.kt");
    }

    @Test
    @TestMetadata("suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt")
    public void testSuspendInTheMiddleOfObjectConstructionEvaluationOrder() {
      runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt");
    }

    @Test
    @TestMetadata("suspendInTheMiddleOfObjectConstructionWithJumpOut.kt")
    public void testSuspendInTheMiddleOfObjectConstructionWithJumpOut() {
      runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionWithJumpOut.kt");
    }

    @Test
    @TestMetadata("suspendInlineReference.kt")
    public void testSuspendInlineReference() {
      runTest("compiler/testData/codegen/box/coroutines/suspendInlineReference.kt");
    }

    @Test
    @TestMetadata("suspendJavaOverrides.kt")
    public void testSuspendJavaOverrides() {
      runTest("compiler/testData/codegen/box/coroutines/suspendJavaOverrides.kt");
    }

    @Test
    @TestMetadata("suspendLambdaInInterface.kt")
    public void testSuspendLambdaInInterface() {
      runTest("compiler/testData/codegen/box/coroutines/suspendLambdaInInterface.kt");
    }

    @Test
    @TestMetadata("suspendLambdaWithArgumentRearrangement.kt")
    public void testSuspendLambdaWithArgumentRearrangement() {
      runTest("compiler/testData/codegen/box/coroutines/suspendLambdaWithArgumentRearrangement.kt");
    }

    @Test
    @TestMetadata("suspendReturningPlatformType.kt")
    public void testSuspendReturningPlatformType() {
      runTest("compiler/testData/codegen/box/coroutines/suspendReturningPlatformType.kt");
    }

    @Test
    @TestMetadata("suspensionInsideSafeCall.kt")
    public void testSuspensionInsideSafeCall() {
      runTest("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCall.kt");
    }

    @Test
    @TestMetadata("suspensionInsideSafeCallWithElvis.kt")
    public void testSuspensionInsideSafeCallWithElvis() {
      runTest("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCallWithElvis.kt");
    }

    @Test
    @TestMetadata("tailCallToNothing.kt")
    public void testTailCallToNothing() {
      runTest("compiler/testData/codegen/box/coroutines/tailCallToNothing.kt");
    }

    @Test
    @TestMetadata("tryCatchFinallyWithHandleResult.kt")
    public void testTryCatchFinallyWithHandleResult() {
      runTest("compiler/testData/codegen/box/coroutines/tryCatchFinallyWithHandleResult.kt");
    }

    @Test
    @TestMetadata("tryCatchWithHandleResult.kt")
    public void testTryCatchWithHandleResult() {
      runTest("compiler/testData/codegen/box/coroutines/tryCatchWithHandleResult.kt");
    }

    @Test
    @TestMetadata("tryFinallyInsideInlineLambda.kt")
    public void testTryFinallyInsideInlineLambda() {
      runTest("compiler/testData/codegen/box/coroutines/tryFinallyInsideInlineLambda.kt");
    }

    @Test
    @TestMetadata("tryFinallyWithHandleResult.kt")
    public void testTryFinallyWithHandleResult() {
      runTest("compiler/testData/codegen/box/coroutines/tryFinallyWithHandleResult.kt");
    }

    @Test
    @TestMetadata("varCaptuedInCoroutineIntrinsic.kt")
    public void testVarCaptuedInCoroutineIntrinsic() {
      runTest("compiler/testData/codegen/box/coroutines/varCaptuedInCoroutineIntrinsic.kt");
    }

    @Test
    @TestMetadata("varValueConflictsWithTable.kt")
    public void testVarValueConflictsWithTable() {
      runTest("compiler/testData/codegen/box/coroutines/varValueConflictsWithTable.kt");
    }

    @Test
    @TestMetadata("varValueConflictsWithTableSameSort.kt")
    public void testVarValueConflictsWithTableSameSort() {
      runTest("compiler/testData/codegen/box/coroutines/varValueConflictsWithTableSameSort.kt");
    }

    @Test
    @TestMetadata("varargCallFromSuspend.kt")
    public void testVarargCallFromSuspend() {
      runTest("compiler/testData/codegen/box/coroutines/varargCallFromSuspend.kt");
    }

    @Test
    @TestMetadata("withReceiver.kt")
    public void testWithReceiver() {
      runTest("compiler/testData/codegen/box/coroutines/withReceiver.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/bridges")
    @TestDataPath("$PROJECT_ROOT")
    public class Bridges {
      @Test
      public void testAllFilesPresentInBridges() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/bridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("interfaceGenericDefault.kt")
      public void testInterfaceGenericDefault() {
        runTest("compiler/testData/codegen/box/coroutines/bridges/interfaceGenericDefault.kt");
      }

      @Test
      @TestMetadata("interfaceSpecialization.kt")
      public void testInterfaceSpecialization() {
        runTest("compiler/testData/codegen/box/coroutines/bridges/interfaceSpecialization.kt");
      }

      @Test
      @TestMetadata("lambdaWithLongReceiver.kt")
      public void testLambdaWithLongReceiver() {
        runTest("compiler/testData/codegen/box/coroutines/bridges/lambdaWithLongReceiver.kt");
      }

      @Test
      @TestMetadata("lambdaWithMultipleParameters.kt")
      public void testLambdaWithMultipleParameters() {
        runTest("compiler/testData/codegen/box/coroutines/bridges/lambdaWithMultipleParameters.kt");
      }

      @Test
      @TestMetadata("mapSuspendAbstractClear.kt")
      public void testMapSuspendAbstractClear() {
        runTest("compiler/testData/codegen/box/coroutines/bridges/mapSuspendAbstractClear.kt");
      }

      @Test
      @TestMetadata("mapSuspendClear.kt")
      public void testMapSuspendClear() {
        runTest("compiler/testData/codegen/box/coroutines/bridges/mapSuspendClear.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/controlFlow")
    @TestDataPath("$PROJECT_ROOT")
    public class ControlFlow {
      @Test
      public void testAllFilesPresentInControlFlow() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/controlFlow"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("breakFinally.kt")
      public void testBreakFinally() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/breakFinally.kt");
      }

      @Test
      @TestMetadata("breakStatement.kt")
      public void testBreakStatement() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/breakStatement.kt");
      }

      @Test
      @TestMetadata("complexChainSuspend.kt")
      public void testComplexChainSuspend() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/complexChainSuspend.kt");
      }

      @Test
      @TestMetadata("doWhileStatement.kt")
      public void testDoWhileStatement() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/doWhileStatement.kt");
      }

      @Test
      @TestMetadata("doWhileWithInline.kt")
      public void testDoWhileWithInline() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/doWhileWithInline.kt");
      }

      @Test
      @TestMetadata("doubleBreak.kt")
      public void testDoubleBreak() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/doubleBreak.kt");
      }

      @Test
      @TestMetadata("finallyCatch.kt")
      public void testFinallyCatch() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/finallyCatch.kt");
      }

      @Test
      @TestMetadata("forContinue.kt")
      public void testForContinue() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/forContinue.kt");
      }

      @Test
      @TestMetadata("forStatement.kt")
      public void testForStatement() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/forStatement.kt");
      }

      @Test
      @TestMetadata("forWithStep.kt")
      public void testForWithStep() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/forWithStep.kt");
      }

      @Test
      @TestMetadata("ifStatement.kt")
      public void testIfStatement() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/ifStatement.kt");
      }

      @Test
      @TestMetadata("kt22694_1_3.kt")
      public void testKt22694_1_3() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/kt22694_1_3.kt");
      }

      @Test
      @TestMetadata("labeledWhile.kt")
      public void testLabeledWhile() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/labeledWhile.kt");
      }

      @Test
      @TestMetadata("multipleCatchBlocksSuspend.kt")
      public void testMultipleCatchBlocksSuspend() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/multipleCatchBlocksSuspend.kt");
      }

      @Test
      @TestMetadata("returnFromFinally.kt")
      public void testReturnFromFinally() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/returnFromFinally.kt");
      }

      @Test
      @TestMetadata("returnWithFinally.kt")
      public void testReturnWithFinally() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/returnWithFinally.kt");
      }

      @Test
      @TestMetadata("suspendInStringTemplate.kt")
      public void testSuspendInStringTemplate() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/suspendInStringTemplate.kt");
      }

      @Test
      @TestMetadata("switchLikeWhen.kt")
      public void testSwitchLikeWhen() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/switchLikeWhen.kt");
      }

      @Test
      @TestMetadata("throwFromCatch.kt")
      public void testThrowFromCatch() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwFromCatch.kt");
      }

      @Test
      @TestMetadata("throwFromFinally.kt")
      public void testThrowFromFinally() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwFromFinally.kt");
      }

      @Test
      @TestMetadata("throwInTryWithHandleResult.kt")
      public void testThrowInTryWithHandleResult() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwInTryWithHandleResult.kt");
      }

      @Test
      @TestMetadata("whenWithSuspensions.kt")
      public void testWhenWithSuspensions() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/whenWithSuspensions.kt");
      }

      @Test
      @TestMetadata("whileStatement.kt")
      public void testWhileStatement() {
        runTest("compiler/testData/codegen/box/coroutines/controlFlow/whileStatement.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/debug")
    @TestDataPath("$PROJECT_ROOT")
    public class Debug {
      @Test
      public void testAllFilesPresentInDebug() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("debuggerMetadata.kt")
      public void testDebuggerMetadata() {
        runTest("compiler/testData/codegen/box/coroutines/debug/debuggerMetadata.kt");
      }

      @Test
      @TestMetadata("elvisLineNumber.kt")
      public void testElvisLineNumber() {
        runTest("compiler/testData/codegen/box/coroutines/debug/elvisLineNumber.kt");
      }

      @Test
      @TestMetadata("firstSuspensionPoint.kt")
      public void testFirstSuspensionPoint() {
        runTest("compiler/testData/codegen/box/coroutines/debug/firstSuspensionPoint.kt");
      }

      @Test
      @TestMetadata("fqName.kt")
      public void testFqName() {
        runTest("compiler/testData/codegen/box/coroutines/debug/fqName.kt");
      }

      @Test
      @TestMetadata("multipleSuspendCallsOnSameLine.kt")
      public void testMultipleSuspendCallsOnSameLine() {
        runTest("compiler/testData/codegen/box/coroutines/debug/multipleSuspendCallsOnSameLine.kt");
      }

      @Test
      @TestMetadata("runtimeDebugMetadata.kt")
      public void testRuntimeDebugMetadata() {
        runTest("compiler/testData/codegen/box/coroutines/debug/runtimeDebugMetadata.kt");
      }

      @Test
      @TestMetadata("throwsOnSameLine.kt")
      public void testThrowsOnSameLine() {
        runTest("compiler/testData/codegen/box/coroutines/debug/throwsOnSameLine.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection")
    @TestDataPath("$PROJECT_ROOT")
    public class FeatureIntersection {
      @Test
      public void testAllFilesPresentInFeatureIntersection() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("breakWithNonEmptyStack.kt")
      public void testBreakWithNonEmptyStack() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/breakWithNonEmptyStack.kt");
      }

      @Test
      @TestMetadata("defaultExpect.kt")
      public void testDefaultExpect() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/defaultExpect.kt");
      }

      @Test
      @TestMetadata("delegate.kt")
      public void testDelegate() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/delegate.kt");
      }

      @Test
      @TestMetadata("destructuringInLambdas.kt")
      public void testDestructuringInLambdas() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/destructuringInLambdas.kt");
      }

      @Test
      @TestMetadata("funInterface.kt")
      public void testFunInterface() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface.kt");
      }

      @Test
      @TestMetadata("inlineSuspendFinally.kt")
      public void testInlineSuspendFinally() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/inlineSuspendFinally.kt");
      }

      @Test
      @TestMetadata("interfaceMethodWithBody.kt")
      public void testInterfaceMethodWithBody() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/interfaceMethodWithBody.kt");
      }

      @Test
      @TestMetadata("interfaceMethodWithBodyGeneric.kt")
      public void testInterfaceMethodWithBodyGeneric() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/interfaceMethodWithBodyGeneric.kt");
      }

      @Test
      @TestMetadata("overrideInInlineClass.kt")
      public void testOverrideInInlineClass() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/overrideInInlineClass.kt");
      }

      @Test
      @TestMetadata("overrideInInnerClass.kt")
      public void testOverrideInInnerClass() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/overrideInInnerClass.kt");
      }

      @Test
      @TestMetadata("safeCallOnTwoReceivers.kt")
      public void testSafeCallOnTwoReceivers() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceivers.kt");
      }

      @Test
      @TestMetadata("safeCallOnTwoReceiversLong.kt")
      public void testSafeCallOnTwoReceiversLong() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceiversLong.kt");
      }

      @Test
      @TestMetadata("suspendDestructuringInLambdas.kt")
      public void testSuspendDestructuringInLambdas() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendDestructuringInLambdas.kt");
      }

      @Test
      @TestMetadata("suspendFunctionAsSupertypeIsCheck.kt")
      public void testSuspendFunctionAsSupertypeIsCheck() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionAsSupertypeIsCheck.kt");
      }

      @Test
      @TestMetadata("suspendFunctionAsSupertypeIsCheckWithArity.kt")
      public void testSuspendFunctionAsSupertypeIsCheckWithArity() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionAsSupertypeIsCheckWithArity.kt");
      }

      @Test
      @TestMetadata("suspendFunctionIsAs.kt")
      public void testSuspendFunctionIsAs() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionIsAs.kt");
      }

      @Test
      @TestMetadata("suspendInlineSuspendFinally.kt")
      public void testSuspendInlineSuspendFinally() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendInlineSuspendFinally.kt");
      }

      @Test
      @TestMetadata("suspendOperatorPlus.kt")
      public void testSuspendOperatorPlus() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlus.kt");
      }

      @Test
      @TestMetadata("suspendOperatorPlusAssign.kt")
      public void testSuspendOperatorPlusAssign() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusAssign.kt");
      }

      @Test
      @TestMetadata("suspendOperatorPlusCallFromLambda.kt")
      public void testSuspendOperatorPlusCallFromLambda() {
        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusCallFromLambda.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference")
      @TestDataPath("$PROJECT_ROOT")
      public class CallableReference {
        @Test
        public void testAllFilesPresentInCallableReference() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("bigArity.kt")
        public void testBigArity() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bigArity.kt");
        }

        @Test
        @TestMetadata("fromJava.kt")
        public void testFromJava() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/fromJava.kt");
        }

        @Test
        @TestMetadata("kt48732_genericSignature.kt")
        public void testKt48732_genericSignature() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/kt48732_genericSignature.kt");
        }

        @Test
        @TestMetadata("lambdaParameterUsed.kt")
        public void testLambdaParameterUsed() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/lambdaParameterUsed.kt");
        }

        @Test
        @TestMetadata("longArgs.kt")
        public void testLongArgs() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/longArgs.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        public class Bound {
          @Test
          public void testAllFilesPresentInBound() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("emptyLHS.kt")
          public void testEmptyLHS() {
            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound/emptyLHS.kt");
          }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function")
        @TestDataPath("$PROJECT_ROOT")
        public class Function {
          @Test
          @TestMetadata("adapted.kt")
          public void testAdapted() {
            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/adapted.kt");
          }

          @Test
          public void testAllFilesPresentInFunction() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("genericCallableReferenceArguments.kt")
          public void testGenericCallableReferenceArguments() {
            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferenceArguments.kt");
          }

          @Test
          @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
          public void testGenericCallableReferencesWithNullableTypes() {
            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
          }

          @Test
          @TestMetadata("getArityViaFunctionImpl.kt")
          public void testGetArityViaFunctionImpl() {
            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/getArityViaFunctionImpl.kt");
          }

          @Nested
          @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local")
          @TestDataPath("$PROJECT_ROOT")
          public class Local {
            @Test
            public void testAllFilesPresentInLocal() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("equalsHashCode.kt")
            public void testEqualsHashCode() {
              runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local/equalsHashCode.kt");
            }
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface")
      @TestDataPath("$PROJECT_ROOT")
      public class FunInterface {
        @Test
        public void testAllFilesPresentInFunInterface() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt47549.kt")
        public void testKt47549() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt47549.kt");
        }

        @Test
        @TestMetadata("kt47549_1.kt")
        public void testKt47549_1() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt47549_1.kt");
        }

        @Test
        @TestMetadata("kt49294.kt")
        public void testKt49294() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt49294.kt");
        }

        @Test
        @TestMetadata("kt50950.kt")
        public void testKt50950() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt50950.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault")
      @TestDataPath("$PROJECT_ROOT")
      public class JvmDefault {
        @Test
        @TestMetadata("all.kt")
        public void testAll() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/all.kt");
        }

        @Test
        public void testAllFilesPresentInJvmDefault() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007")
        @TestDataPath("$PROJECT_ROOT")
        public class Kt46007 {
          @Test
          @TestMetadata("all.kt")
          public void testAll() {
            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/all.kt");
          }

          @Test
          public void testAllFilesPresentInKt46007() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("all-compatibility.kt")
          public void testAll_compatibility() {
            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/all-compatibility.kt");
          }

          @Test
          @TestMetadata("disable.kt")
          public void testDisable() {
            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/disable.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec")
      @TestDataPath("$PROJECT_ROOT")
      public class Tailrec {
        @Test
        public void testAllFilesPresentInTailrec() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("controlFlowIf.kt")
        public void testControlFlowIf() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowIf.kt");
        }

        @Test
        @TestMetadata("controlFlowWhen.kt")
        public void testControlFlowWhen() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowWhen.kt");
        }

        @Test
        @TestMetadata("extention.kt")
        public void testExtention() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/extention.kt");
        }

        @Test
        @TestMetadata("infixCall.kt")
        public void testInfixCall() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixCall.kt");
        }

        @Test
        @TestMetadata("infixRecursiveCall.kt")
        public void testInfixRecursiveCall() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixRecursiveCall.kt");
        }

        @Test
        @TestMetadata("kt38920_localTailrec.kt")
        public void testKt38920_localTailrec() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/kt38920_localTailrec.kt");
        }

        @Test
        @TestMetadata("realIteratorFoldl.kt")
        public void testRealIteratorFoldl() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realIteratorFoldl.kt");
        }

        @Test
        @TestMetadata("realStringEscape.kt")
        public void testRealStringEscape() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringEscape.kt");
        }

        @Test
        @TestMetadata("realStringRepeat.kt")
        public void testRealStringRepeat() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringRepeat.kt");
        }

        @Test
        @TestMetadata("returnInParentheses.kt")
        public void testReturnInParentheses() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/returnInParentheses.kt");
        }

        @Test
        @TestMetadata("sum.kt")
        public void testSum() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/sum.kt");
        }

        @Test
        @TestMetadata("tailCallInBlockInParentheses.kt")
        public void testTailCallInBlockInParentheses() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInBlockInParentheses.kt");
        }

        @Test
        @TestMetadata("tailCallInParentheses.kt")
        public void testTailCallInParentheses() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInParentheses.kt");
        }

        @Test
        @TestMetadata("whenWithIs.kt")
        public void testWhenWithIs() {
          runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/whenWithIs.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
      @Test
      public void testAllFilesPresentInInlineClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("genericParameterResult.kt")
      public void testGenericParameterResult() {
        runTest("compiler/testData/codegen/box/coroutines/inlineClasses/genericParameterResult.kt");
      }

      @Test
      @TestMetadata("kt47129.kt")
      public void testKt47129() {
        runTest("compiler/testData/codegen/box/coroutines/inlineClasses/kt47129.kt");
      }

      @Test
      @TestMetadata("nonLocalReturn.kt")
      public void testNonLocalReturn() {
        runTest("compiler/testData/codegen/box/coroutines/inlineClasses/nonLocalReturn.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/direct")
      @TestDataPath("$PROJECT_ROOT")
      public class Direct {
        @Test
        public void testAllFilesPresentInDirect() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/direct"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
        public void testBoxReturnValueOfSuspendFunctionReference() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxReturnValueOfSuspendFunctionReference.kt");
        }

        @Test
        @TestMetadata("boxReturnValueOfSuspendLambda.kt")
        public void testBoxReturnValueOfSuspendLambda() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxReturnValueOfSuspendLambda.kt");
        }

        @Test
        @TestMetadata("boxTypeParameterOfSuperType.kt")
        public void testBoxTypeParameterOfSuperType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxTypeParameterOfSuperType.kt");
        }

        @Test
        @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
        public void testBoxTypeParameterOfSuperTypeResult() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxTypeParameterOfSuperTypeResult.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine.kt")
        public void testBoxUnboxInsideCoroutine() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
        public void testBoxUnboxInsideCoroutine_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Any.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
        public void testBoxUnboxInsideCoroutine_InlineAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_InlineAny.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
        public void testBoxUnboxInsideCoroutine_InlineInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_InlineInt.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
        public void testBoxUnboxInsideCoroutine_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Int.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
        public void testBoxUnboxInsideCoroutine_Long() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Long.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
        public void testBoxUnboxInsideCoroutine_NAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_NAny.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
        public void testBoxUnboxInsideCoroutine_nonLocalReturn() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_nonLocalReturn.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
        public void testBoxUnboxInsideCoroutine_suspendFunType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_suspendFunType.kt");
        }

        @Test
        @TestMetadata("bridgeGenerationCrossinline.kt")
        public void testBridgeGenerationCrossinline() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/bridgeGenerationCrossinline.kt");
        }

        @Test
        @TestMetadata("bridgeGenerationNonInline.kt")
        public void testBridgeGenerationNonInline() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/bridgeGenerationNonInline.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun.kt")
        public void testCovariantOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
        public void testCovariantOverrideSuspendFunSameJvmType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunSameJvmType.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun_Any.kt")
        public void testCovariantOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun_Int.kt")
        public void testCovariantOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("createMangling.kt")
        public void testCreateMangling() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/createMangling.kt");
        }

        @Test
        @TestMetadata("createOverride.kt")
        public void testCreateOverride() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/createOverride.kt");
        }

        @Test
        @TestMetadata("defaultStub.kt")
        public void testDefaultStub() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/defaultStub.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun.kt")
        public void testGenericOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Any.kt")
        public void testGenericOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
        public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Int.kt")
        public void testGenericOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
        public void testGenericOverrideSuspendFun_NullableAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableAny.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableAny_null.kt")
        public void testGenericOverrideSuspendFun_NullableAny_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableAny_null.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
        public void testGenericOverrideSuspendFun_NullableInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableInt.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableInt_null.kt")
        public void testGenericOverrideSuspendFun_NullableInt_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableInt_null.kt");
        }

        @Test
        @TestMetadata("interfaceDelegateWithInlineClass.kt")
        public void testInterfaceDelegateWithInlineClass() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/interfaceDelegateWithInlineClass.kt");
        }

        @Test
        @TestMetadata("invokeOperator.kt")
        public void testInvokeOperator() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/invokeOperator.kt");
        }

        @Test
        @TestMetadata("multifileBridge.kt")
        public void testMultifileBridge() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/multifileBridge.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun.kt")
        public void testOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any.kt")
        public void testOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any_itf.kt")
        public void testOverrideSuspendFun_Any_itf() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any_itf.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any_this.kt")
        public void testOverrideSuspendFun_Any_this() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any_this.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Int.kt")
        public void testOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("returnResult.kt")
        public void testReturnResult() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/returnResult.kt");
        }

        @Test
        @TestMetadata("syntheticAccessor.kt")
        public void testSyntheticAccessor() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/syntheticAccessor.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/resume")
      @TestDataPath("$PROJECT_ROOT")
      public class Resume {
        @Test
        public void testAllFilesPresentInResume() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/resume"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
        public void testBoxReturnValueOfSuspendFunctionReference() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxReturnValueOfSuspendFunctionReference.kt");
        }

        @Test
        @TestMetadata("boxReturnValueOfSuspendLambda.kt")
        public void testBoxReturnValueOfSuspendLambda() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxReturnValueOfSuspendLambda.kt");
        }

        @Test
        @TestMetadata("boxTypeParameterOfSuperType.kt")
        public void testBoxTypeParameterOfSuperType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxTypeParameterOfSuperType.kt");
        }

        @Test
        @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
        public void testBoxTypeParameterOfSuperTypeResult() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxTypeParameterOfSuperTypeResult.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine.kt")
        public void testBoxUnboxInsideCoroutine() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
        public void testBoxUnboxInsideCoroutine_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Any.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
        public void testBoxUnboxInsideCoroutine_InlineAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_InlineAny.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
        public void testBoxUnboxInsideCoroutine_InlineInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_InlineInt.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
        public void testBoxUnboxInsideCoroutine_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Int.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
        public void testBoxUnboxInsideCoroutine_Long() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Long.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
        public void testBoxUnboxInsideCoroutine_NAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_NAny.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
        public void testBoxUnboxInsideCoroutine_nonLocalReturn() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_nonLocalReturn.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
        public void testBoxUnboxInsideCoroutine_suspendFunType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_suspendFunType.kt");
        }

        @Test
        @TestMetadata("bridgeGenerationCrossinline.kt")
        public void testBridgeGenerationCrossinline() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/bridgeGenerationCrossinline.kt");
        }

        @Test
        @TestMetadata("bridgeGenerationNonInline.kt")
        public void testBridgeGenerationNonInline() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/bridgeGenerationNonInline.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun.kt")
        public void testCovariantOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
        public void testCovariantOverrideSuspendFunSameJvmType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunSameJvmType.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun_Any.kt")
        public void testCovariantOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun_Int.kt")
        public void testCovariantOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("createMangling.kt")
        public void testCreateMangling() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/createMangling.kt");
        }

        @Test
        @TestMetadata("createOverride.kt")
        public void testCreateOverride() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/createOverride.kt");
        }

        @Test
        @TestMetadata("defaultStub.kt")
        public void testDefaultStub() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/defaultStub.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun.kt")
        public void testGenericOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Any.kt")
        public void testGenericOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
        public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Int.kt")
        public void testGenericOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
        public void testGenericOverrideSuspendFun_NullableAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableAny.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableAny_null.kt")
        public void testGenericOverrideSuspendFun_NullableAny_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableAny_null.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
        public void testGenericOverrideSuspendFun_NullableInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableInt.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableInt_null.kt")
        public void testGenericOverrideSuspendFun_NullableInt_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableInt_null.kt");
        }

        @Test
        @TestMetadata("interfaceDelegateWithInlineClass.kt")
        public void testInterfaceDelegateWithInlineClass() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/interfaceDelegateWithInlineClass.kt");
        }

        @Test
        @TestMetadata("invokeOperator.kt")
        public void testInvokeOperator() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/invokeOperator.kt");
        }

        @Test
        @TestMetadata("multifileBridge.kt")
        public void testMultifileBridge() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/multifileBridge.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun.kt")
        public void testOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any.kt")
        public void testOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any_itf.kt")
        public void testOverrideSuspendFun_Any_itf() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any_itf.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any_this.kt")
        public void testOverrideSuspendFun_Any_this() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any_this.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Int.kt")
        public void testOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("returnResult.kt")
        public void testReturnResult() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/returnResult.kt");
        }

        @Test
        @TestMetadata("syntheticAccessor.kt")
        public void testSyntheticAccessor() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/syntheticAccessor.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException")
      @TestDataPath("$PROJECT_ROOT")
      public class ResumeWithException {
        @Test
        public void testAllFilesPresentInResumeWithException() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
        public void testBoxReturnValueOfSuspendFunctionReference() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxReturnValueOfSuspendFunctionReference.kt");
        }

        @Test
        @TestMetadata("boxReturnValueOfSuspendLambda.kt")
        public void testBoxReturnValueOfSuspendLambda() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxReturnValueOfSuspendLambda.kt");
        }

        @Test
        @TestMetadata("boxTypeParameterOfSuperType.kt")
        public void testBoxTypeParameterOfSuperType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxTypeParameterOfSuperType.kt");
        }

        @Test
        @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
        public void testBoxTypeParameterOfSuperTypeResult() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxTypeParameterOfSuperTypeResult.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine.kt")
        public void testBoxUnboxInsideCoroutine() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
        public void testBoxUnboxInsideCoroutine_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Any.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
        public void testBoxUnboxInsideCoroutine_InlineAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_InlineAny.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
        public void testBoxUnboxInsideCoroutine_InlineInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_InlineInt.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
        public void testBoxUnboxInsideCoroutine_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Int.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
        public void testBoxUnboxInsideCoroutine_Long() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Long.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
        public void testBoxUnboxInsideCoroutine_NAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_NAny.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
        public void testBoxUnboxInsideCoroutine_nonLocalReturn() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_nonLocalReturn.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
        public void testBoxUnboxInsideCoroutine_suspendFunType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_suspendFunType.kt");
        }

        @Test
        @TestMetadata("bridgeGenerationCrossinline.kt")
        public void testBridgeGenerationCrossinline() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/bridgeGenerationCrossinline.kt");
        }

        @Test
        @TestMetadata("bridgeGenerationNonInline.kt")
        public void testBridgeGenerationNonInline() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/bridgeGenerationNonInline.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun.kt")
        public void testCovariantOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
        public void testCovariantOverrideSuspendFunSameJvmType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunSameJvmType.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
        public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun_Any.kt")
        public void testCovariantOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("covariantOverrideSuspendFun_Int.kt")
        public void testCovariantOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("createMangling.kt")
        public void testCreateMangling() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/createMangling.kt");
        }

        @Test
        @TestMetadata("createOverride.kt")
        public void testCreateOverride() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/createOverride.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun.kt")
        public void testGenericOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Any.kt")
        public void testGenericOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
        public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_Int.kt")
        public void testGenericOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
        public void testGenericOverrideSuspendFun_NullableAny() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_NullableAny.kt");
        }

        @Test
        @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
        public void testGenericOverrideSuspendFun_NullableInt() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_NullableInt.kt");
        }

        @Test
        @TestMetadata("interfaceDelegateWithInlineClass.kt")
        public void testInterfaceDelegateWithInlineClass() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/interfaceDelegateWithInlineClass.kt");
        }

        @Test
        @TestMetadata("invokeOperator.kt")
        public void testInvokeOperator() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/invokeOperator.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun.kt")
        public void testOverrideSuspendFun() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any.kt")
        public void testOverrideSuspendFun_Any() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any_itf.kt")
        public void testOverrideSuspendFun_Any_itf() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any_itf.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Any_this.kt")
        public void testOverrideSuspendFun_Any_this() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any_this.kt");
        }

        @Test
        @TestMetadata("overrideSuspendFun_Int.kt")
        public void testOverrideSuspendFun_Int() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Int.kt");
        }

        @Test
        @TestMetadata("returnResult.kt")
        public void testReturnResult() {
          runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/returnResult.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling")
    @TestDataPath("$PROJECT_ROOT")
    public class IntLikeVarSpilling {
      @Test
      public void testAllFilesPresentInIntLikeVarSpilling() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("complicatedMerge.kt")
      public void testComplicatedMerge() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/complicatedMerge.kt");
      }

      @Test
      @TestMetadata("i2bResult.kt")
      public void testI2bResult() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/i2bResult.kt");
      }

      @Test
      @TestMetadata("listThrowablePairInOneSlot.kt")
      public void testListThrowablePairInOneSlot() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/listThrowablePairInOneSlot.kt");
      }

      @Test
      @TestMetadata("loadFromBooleanArray.kt")
      public void testLoadFromBooleanArray() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
      }

      @Test
      @TestMetadata("loadFromByteArray.kt")
      public void testLoadFromByteArray() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
      }

      @Test
      @TestMetadata("noVariableInTable.kt")
      public void testNoVariableInTable() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/noVariableInTable.kt");
      }

      @Test
      @TestMetadata("sameIconst1ManyVars.kt")
      public void testSameIconst1ManyVars() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
      }

      @Test
      @TestMetadata("unusedCatchVar.kt")
      public void testUnusedCatchVar() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/unusedCatchVar.kt");
      }

      @Test
      @TestMetadata("usedInArrayStore.kt")
      public void testUsedInArrayStore() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
      }

      @Test
      @TestMetadata("usedInMethodCall.kt")
      public void testUsedInMethodCall() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
      }

      @Test
      @TestMetadata("usedInPutfield.kt")
      public void testUsedInPutfield() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInPutfield.kt");
      }

      @Test
      @TestMetadata("usedInVarStore.kt")
      public void testUsedInVarStore() {
        runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInVarStore.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/intrinsicSemantics")
    @TestDataPath("$PROJECT_ROOT")
    public class IntrinsicSemantics {
      @Test
      public void testAllFilesPresentInIntrinsicSemantics() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intrinsicSemantics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("coroutineContext.kt")
      public void testCoroutineContext() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContext.kt");
      }

      @Test
      @TestMetadata("coroutineContextReceiver.kt")
      public void testCoroutineContextReceiver() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiver.kt");
      }

      @Test
      @TestMetadata("coroutineContextReceiverNotIntrinsic.kt")
      public void testCoroutineContextReceiverNotIntrinsic() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiverNotIntrinsic.kt");
      }

      @Test
      @TestMetadata("intercepted.kt")
      public void testIntercepted() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/intercepted.kt");
      }

      @Test
      @TestMetadata("releaseIntercepted.kt")
      public void testReleaseIntercepted() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/releaseIntercepted.kt");
      }

      @Test
      @TestMetadata("resultExceptionOrNullInLambda.kt")
      public void testResultExceptionOrNullInLambda() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/resultExceptionOrNullInLambda.kt");
      }

      @Test
      @TestMetadata("startCoroutine.kt")
      public void testStartCoroutine() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutine.kt");
      }

      @Test
      @TestMetadata("startCoroutineUninterceptedOrReturn.kt")
      public void testStartCoroutineUninterceptedOrReturn() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturn.kt");
      }

      @Test
      @TestMetadata("startCoroutineUninterceptedOrReturnInterception.kt")
      public void testStartCoroutineUninterceptedOrReturnInterception() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturnInterception.kt");
      }

      @Test
      @TestMetadata("suspendCoroutineUninterceptedOrReturn.kt")
      public void testSuspendCoroutineUninterceptedOrReturn() {
        runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/suspendCoroutineUninterceptedOrReturn.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/javaInterop")
    @TestDataPath("$PROJECT_ROOT")
    public class JavaInterop {
      @Test
      public void testAllFilesPresentInJavaInterop() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/javaInterop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("objectWithSeveralSuspends.kt")
      public void testObjectWithSeveralSuspends() {
        runTest("compiler/testData/codegen/box/coroutines/javaInterop/objectWithSeveralSuspends.kt");
      }

      @Test
      @TestMetadata("returnLambda.kt")
      public void testReturnLambda() {
        runTest("compiler/testData/codegen/box/coroutines/javaInterop/returnLambda.kt");
      }

      @Test
      @TestMetadata("returnObject.kt")
      public void testReturnObject() {
        runTest("compiler/testData/codegen/box/coroutines/javaInterop/returnObject.kt");
      }

      @Test
      @TestMetadata("severalCaptures.kt")
      public void testSeveralCaptures() {
        runTest("compiler/testData/codegen/box/coroutines/javaInterop/severalCaptures.kt");
      }

      @Test
      @TestMetadata("suspendInlineWithCrossinline.kt")
      public void testSuspendInlineWithCrossinline() {
        runTest("compiler/testData/codegen/box/coroutines/javaInterop/suspendInlineWithCrossinline.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalFunctions {
      @Test
      public void testAllFilesPresentInLocalFunctions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/named")
      @TestDataPath("$PROJECT_ROOT")
      public class Named {
        @Test
        public void testAllFilesPresentInNamed() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/named"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callTopLevelFromLocal.kt")
        public void testCallTopLevelFromLocal() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/callTopLevelFromLocal.kt");
        }

        @Test
        @TestMetadata("capturedParameters.kt")
        public void testCapturedParameters() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedParameters.kt");
        }

        @Test
        @TestMetadata("capturedVariables.kt")
        public void testCapturedVariables() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedVariables.kt");
        }

        @Test
        @TestMetadata("defaultArgument.kt")
        public void testDefaultArgument() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/defaultArgument.kt");
        }

        @Test
        @TestMetadata("extension.kt")
        public void testExtension() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/extension.kt");
        }

        @Test
        @TestMetadata("infix.kt")
        public void testInfix() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/infix.kt");
        }

        @Test
        @TestMetadata("insideLambda.kt")
        public void testInsideLambda() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/insideLambda.kt");
        }

        @Test
        @TestMetadata("nestedLocals.kt")
        public void testNestedLocals() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/nestedLocals.kt");
        }

        @Test
        @TestMetadata("rec.kt")
        public void testRec() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/rec.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/simple.kt");
        }

        @Test
        @TestMetadata("simpleSuspensionPoint.kt")
        public void testSimpleSuspensionPoint() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/simpleSuspensionPoint.kt");
        }

        @Test
        @TestMetadata("stateMachine.kt")
        public void testStateMachine() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/stateMachine.kt");
        }

        @Test
        @TestMetadata("withArguments.kt")
        public void testWithArguments() {
          runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/withArguments.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/multiModule")
    @TestDataPath("$PROJECT_ROOT")
    public class MultiModule {
      @Test
      public void testAllFilesPresentInMultiModule() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("inheritFromAnotherModule.kt")
      public void testInheritFromAnotherModule() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inheritFromAnotherModule.kt");
      }

      @Test
      @TestMetadata("inlineCrossModule.kt")
      public void testInlineCrossModule() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineCrossModule.kt");
      }

      @Test
      @TestMetadata("inlineFunctionWithOptionalParam.kt")
      public void testInlineFunctionWithOptionalParam() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineFunctionWithOptionalParam.kt");
      }

      @Test
      @TestMetadata("inlineMultiModule.kt")
      public void testInlineMultiModule() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModule.kt");
      }

      @Test
      @TestMetadata("inlineMultiModuleOverride.kt")
      public void testInlineMultiModuleOverride() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleOverride.kt");
      }

      @Test
      @TestMetadata("inlineMultiModuleWithController.kt")
      public void testInlineMultiModuleWithController() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithController.kt");
      }

      @Test
      @TestMetadata("inlineMultiModuleWithInnerInlining.kt")
      public void testInlineMultiModuleWithInnerInlining() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithInnerInlining.kt");
      }

      @Test
      @TestMetadata("inlineTailCall.kt")
      public void testInlineTailCall() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineTailCall.kt");
      }

      @Test
      @TestMetadata("inlineWithJava.kt")
      public void testInlineWithJava() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineWithJava.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/coroutines/multiModule/simple.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/redundantLocalsElimination")
    @TestDataPath("$PROJECT_ROOT")
    public class RedundantLocalsElimination {
      @Test
      public void testAllFilesPresentInRedundantLocalsElimination() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/redundantLocalsElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("ktor_receivedMessage.kt")
      public void testKtor_receivedMessage() {
        runTest("compiler/testData/codegen/box/coroutines/redundantLocalsElimination/ktor_receivedMessage.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/reflect")
    @TestDataPath("$PROJECT_ROOT")
    public class Reflect {
      @Test
      public void testAllFilesPresentInReflect() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/reflect"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("bigArity.kt")
      public void testBigArity() {
        runTest("compiler/testData/codegen/box/coroutines/reflect/bigArity.kt");
      }

      @Test
      @TestMetadata("bigArityLambda.kt")
      public void testBigArityLambda() {
        runTest("compiler/testData/codegen/box/coroutines/reflect/bigArityLambda.kt");
      }

      @Test
      @TestMetadata("callSuspend.kt")
      public void testCallSuspend() {
        runTest("compiler/testData/codegen/box/coroutines/reflect/callSuspend.kt");
      }

      @Test
      @TestMetadata("callSuspendBy.kt")
      public void testCallSuspendBy() {
        runTest("compiler/testData/codegen/box/coroutines/reflect/callSuspendBy.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/stackUnwinding")
    @TestDataPath("$PROJECT_ROOT")
    public class StackUnwinding {
      @Test
      public void testAllFilesPresentInStackUnwinding() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/stackUnwinding"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("exception.kt")
      public void testException() {
        runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/exception.kt");
      }

      @Test
      @TestMetadata("inlineSuspendFunction.kt")
      public void testInlineSuspendFunction() {
        runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/inlineSuspendFunction.kt");
      }

      @Test
      @TestMetadata("rethrowInFinally.kt")
      public void testRethrowInFinally() {
        runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinally.kt");
      }

      @Test
      @TestMetadata("rethrowInFinallyWithSuspension.kt")
      public void testRethrowInFinallyWithSuspension() {
        runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinallyWithSuspension.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/simple.kt");
      }

      @Test
      @TestMetadata("suspendInCycle.kt")
      public void testSuspendInCycle() {
        runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/suspendInCycle.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/suspendConversion")
    @TestDataPath("$PROJECT_ROOT")
    public class SuspendConversion {
      @Test
      public void testAllFilesPresentInSuspendConversion() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendConversion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("intersectionTypeToSubtypeConversion.kt")
      public void testIntersectionTypeToSubtypeConversion() {
        runTest("compiler/testData/codegen/box/coroutines/suspendConversion/intersectionTypeToSubtypeConversion.kt");
      }

      @Test
      @TestMetadata("onArgument.kt")
      public void testOnArgument() {
        runTest("compiler/testData/codegen/box/coroutines/suspendConversion/onArgument.kt");
      }

      @Test
      @TestMetadata("onInlineArgument.kt")
      public void testOnInlineArgument() {
        runTest("compiler/testData/codegen/box/coroutines/suspendConversion/onInlineArgument.kt");
      }

      @Test
      @TestMetadata("subtypeOfFunctionalTypeToSuspendConversion.kt")
      public void testSubtypeOfFunctionalTypeToSuspendConversion() {
        runTest("compiler/testData/codegen/box/coroutines/suspendConversion/subtypeOfFunctionalTypeToSuspendConversion.kt");
      }

      @Test
      @TestMetadata("suspendConversionBetweenFunInterfaces.kt")
      public void testSuspendConversionBetweenFunInterfaces() {
        runTest("compiler/testData/codegen/box/coroutines/suspendConversion/suspendConversionBetweenFunInterfaces.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine")
    @TestDataPath("$PROJECT_ROOT")
    public class SuspendFunctionAsCoroutine {
      @Test
      public void testAllFilesPresentInSuspendFunctionAsCoroutine() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("dispatchResume.kt")
      public void testDispatchResume() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/dispatchResume.kt");
      }

      @Test
      @TestMetadata("handleException.kt")
      public void testHandleException() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/handleException.kt");
      }

      @Test
      @TestMetadata("ifExpressionInsideCoroutine_1_3.kt")
      public void testIfExpressionInsideCoroutine_1_3() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/ifExpressionInsideCoroutine_1_3.kt");
      }

      @Test
      @TestMetadata("inline.kt")
      public void testInline() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inline.kt");
      }

      @Test
      @TestMetadata("inlineTwoReceivers.kt")
      public void testInlineTwoReceivers() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inlineTwoReceivers.kt");
      }

      @Test
      @TestMetadata("member.kt")
      public void testMember() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/member.kt");
      }

      @Test
      @TestMetadata("noinlineTwoReceivers.kt")
      public void testNoinlineTwoReceivers() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/noinlineTwoReceivers.kt");
      }

      @Test
      @TestMetadata("openFunWithJava.kt")
      public void testOpenFunWithJava() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/openFunWithJava.kt");
      }

      @Test
      @TestMetadata("operators.kt")
      public void testOperators() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/operators.kt");
      }

      @Test
      @TestMetadata("privateFunctions.kt")
      public void testPrivateFunctions() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateFunctions.kt");
      }

      @Test
      @TestMetadata("privateInFile.kt")
      public void testPrivateInFile() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateInFile.kt");
      }

      @Test
      @TestMetadata("returnNoSuspend.kt")
      public void testReturnNoSuspend() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/returnNoSuspend.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/simple.kt");
      }

      @Test
      @TestMetadata("superCall.kt")
      public void testSuperCall() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCall.kt");
      }

      @Test
      @TestMetadata("superCallAbstractClass.kt")
      public void testSuperCallAbstractClass() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallAbstractClass.kt");
      }

      @Test
      @TestMetadata("superCallInterface.kt")
      public void testSuperCallInterface() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallInterface.kt");
      }

      @Test
      @TestMetadata("superCallOverload.kt")
      public void testSuperCallOverload() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallOverload.kt");
      }

      @Test
      @TestMetadata("withVariables.kt")
      public void testWithVariables() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/withVariables.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall")
    @TestDataPath("$PROJECT_ROOT")
    public class SuspendFunctionTypeCall {
      @Test
      public void testAllFilesPresentInSuspendFunctionTypeCall() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("localVal.kt")
      public void testLocalVal() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/localVal.kt");
      }

      @Test
      @TestMetadata("manyParameters.kt")
      public void testManyParameters() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParameters.kt");
      }

      @Test
      @TestMetadata("manyParametersNoCapture.kt")
      public void testManyParametersNoCapture() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParametersNoCapture.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/simple.kt");
      }

      @Test
      @TestMetadata("suspendModifier.kt")
      public void testSuspendModifier() {
        runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/suspendModifier.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations")
    @TestDataPath("$PROJECT_ROOT")
    public class TailCallOptimizations {
      @Test
      public void testAllFilesPresentInTailCallOptimizations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("also.kt")
      public void testAlso() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/also.kt");
      }

      @Test
      @TestMetadata("checkcast.kt")
      public void testCheckcast() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/checkcast.kt");
      }

      @Test
      @TestMetadata("checkcast2.kt")
      public void testCheckcast2() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/checkcast2.kt");
      }

      @Test
      @TestMetadata("crossinline.kt")
      public void testCrossinline() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/crossinline.kt");
      }

      @Test
      @TestMetadata("deferredAwaitSuspendImpl.kt")
      public void testDeferredAwaitSuspendImpl() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/deferredAwaitSuspendImpl.kt");
      }

      @Test
      @TestMetadata("inlineWithStateMachine.kt")
      public void testInlineWithStateMachine() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithStateMachine.kt");
      }

      @Test
      @TestMetadata("inlineWithoutStateMachine.kt")
      public void testInlineWithoutStateMachine() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithoutStateMachine.kt");
      }

      @Test
      @TestMetadata("innerObjectRetransformation.kt")
      public void testInnerObjectRetransformation() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/innerObjectRetransformation.kt");
      }

      @Test
      @TestMetadata("interfaceDelegation.kt")
      public void testInterfaceDelegation() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/interfaceDelegation.kt");
      }

      @Test
      @TestMetadata("lambdaParameterInlining.kt")
      public void testLambdaParameterInlining() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/lambdaParameterInlining.kt");
      }

      @Test
      @TestMetadata("returnInlineClass.kt")
      public void testReturnInlineClass() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/returnInlineClass.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/simple.kt");
      }

      @Test
      @TestMetadata("tailCallIfReturnUnit.kt")
      public void testTailCallIfReturnUnit() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailCallIfReturnUnit.kt");
      }

      @Test
      @TestMetadata("tailCallIntrinsics.kt")
      public void testTailCallIntrinsics() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailCallIntrinsics.kt");
      }

      @Test
      @TestMetadata("tailSuspendUnitFun.kt")
      public void testTailSuspendUnitFun() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailSuspendUnitFun.kt");
      }

      @Test
      @TestMetadata("tryCatch.kt")
      public void testTryCatch() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatch.kt");
      }

      @Test
      @TestMetadata("tryCatchTailCall.kt")
      public void testTryCatchTailCall() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatchTailCall.kt");
      }

      @Test
      @TestMetadata("unreachable.kt")
      public void testUnreachable() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unreachable.kt");
      }

      @Test
      @TestMetadata("whenUnit.kt")
      public void testWhenUnit() {
        runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/whenUnit.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit")
      @TestDataPath("$PROJECT_ROOT")
      public class Unit {
        @Test
        public void testAllFilesPresentInUnit() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("functionReference.kt")
        public void testFunctionReference() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/functionReference.kt");
        }

        @Test
        @TestMetadata("inline.kt")
        public void testInline() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/inline.kt");
        }

        @Test
        @TestMetadata("override.kt")
        public void testOverride() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override.kt");
        }

        @Test
        @TestMetadata("override2.kt")
        public void testOverride2() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override2.kt");
        }

        @Test
        @TestMetadata("override3.kt")
        public void testOverride3() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override3.kt");
        }

        @Test
        @TestMetadata("override4.kt")
        public void testOverride4() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override4.kt");
        }

        @Test
        @TestMetadata("override5.kt")
        public void testOverride5() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override5.kt");
        }

        @Test
        @TestMetadata("override6.kt")
        public void testOverride6() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override6.kt");
        }

        @Test
        @TestMetadata("overrideCrossinline.kt")
        public void testOverrideCrossinline() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/overrideCrossinline.kt");
        }

        @Test
        @TestMetadata("overrideOverriden.kt")
        public void testOverrideOverriden() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/overrideOverriden.kt");
        }

        @Test
        @TestMetadata("reflection.kt")
        public void testReflection() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/reflection.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/simple.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/tailOperations")
    @TestDataPath("$PROJECT_ROOT")
    public class TailOperations {
      @Test
      public void testAllFilesPresentInTailOperations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("suspendWithIf.kt")
      public void testSuspendWithIf() {
        runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithIf.kt");
      }

      @Test
      @TestMetadata("suspendWithTryCatch.kt")
      public void testSuspendWithTryCatch() {
        runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithTryCatch.kt");
      }

      @Test
      @TestMetadata("suspendWithWhen.kt")
      public void testSuspendWithWhen() {
        runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithWhen.kt");
      }

      @Test
      @TestMetadata("tailInlining.kt")
      public void testTailInlining() {
        runTest("compiler/testData/codegen/box/coroutines/tailOperations/tailInlining.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/unitTypeReturn")
    @TestDataPath("$PROJECT_ROOT")
    public class UnitTypeReturn {
      @Test
      public void testAllFilesPresentInUnitTypeReturn() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/unitTypeReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("coroutineNonLocalReturn.kt")
      public void testCoroutineNonLocalReturn() {
        runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineNonLocalReturn.kt");
      }

      @Test
      @TestMetadata("coroutineReturn.kt")
      public void testCoroutineReturn() {
        runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineReturn.kt");
      }

      @Test
      @TestMetadata("inlineUnitFunction.kt")
      public void testInlineUnitFunction() {
        runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/inlineUnitFunction.kt");
      }

      @Test
      @TestMetadata("interfaceDelegation.kt")
      public void testInterfaceDelegation() {
        runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/interfaceDelegation.kt");
      }

      @Test
      @TestMetadata("suspendNonLocalReturn.kt")
      public void testSuspendNonLocalReturn() {
        runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendNonLocalReturn.kt");
      }

      @Test
      @TestMetadata("suspendReturn.kt")
      public void testSuspendReturn() {
        runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendReturn.kt");
      }

      @Test
      @TestMetadata("unitSafeCall.kt")
      public void testUnitSafeCall() {
        runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/unitSafeCall.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling")
    @TestDataPath("$PROJECT_ROOT")
    public class VarSpilling {
      @Test
      public void testAllFilesPresentInVarSpilling() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("fakeInlinerVariables.kt")
      public void testFakeInlinerVariables() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/fakeInlinerVariables.kt");
      }

      @Test
      @TestMetadata("kt19475.kt")
      public void testKt19475() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt19475.kt");
      }

      @Test
      @TestMetadata("kt38925.kt")
      public void testKt38925() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt38925.kt");
      }

      @Test
      @TestMetadata("kt49834.kt")
      public void testKt49834() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt49834.kt");
      }

      @Test
      @TestMetadata("kt64139.kt")
      public void testKt64139() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt64139.kt");
      }

      @Test
      @TestMetadata("lvtWithInlineOnly.kt")
      public void testLvtWithInlineOnly() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/lvtWithInlineOnly.kt");
      }

      @Test
      @TestMetadata("nullSpilling.kt")
      public void testNullSpilling() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/nullSpilling.kt");
      }

      @Test
      @TestMetadata("refinedIntTypesAnalysis.kt")
      public void testRefinedIntTypesAnalysis() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/refinedIntTypesAnalysis.kt");
      }

      @Test
      @TestMetadata("safeCallElvis.kt")
      public void testSafeCallElvis() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/safeCallElvis.kt");
      }

      @Test
      @TestMetadata("thisUnspill.kt")
      public void testThisUnspill() {
        runTest("compiler/testData/codegen/box/coroutines/varSpilling/thisUnspill.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling/cleanup")
      @TestDataPath("$PROJECT_ROOT")
      public class Cleanup {
        @Test
        public void testAllFilesPresentInCleanup() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling/cleanup"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("backEdge.kt")
        public void testBackEdge() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanup/backEdge.kt");
        }

        @Test
        @TestMetadata("if.kt")
        public void testIf() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanup/if.kt");
        }

        @Test
        @TestMetadata("nullCleanup.kt")
        public void testNullCleanup() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanup/nullCleanup.kt");
        }

        @Test
        @TestMetadata("nullNotSpill.kt")
        public void testNullNotSpill() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanup/nullNotSpill.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanup/simple.kt");
        }

        @Test
        @TestMetadata("twoRefs.kt")
        public void testTwoRefs() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanup/twoRefs.kt");
        }

        @Test
        @TestMetadata("unusedParamNotSpill.kt")
        public void testUnusedParamNotSpill() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanup/unusedParamNotSpill.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanup/when.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction")
      @TestDataPath("$PROJECT_ROOT")
      public class CleanupWithoutStdlibFunction {
        @Test
        public void testAllFilesPresentInCleanupWithoutStdlibFunction() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("backEdge.kt")
        public void testBackEdge() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/backEdge.kt");
        }

        @Test
        @TestMetadata("deadArgument.kt")
        public void testDeadArgument() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/deadArgument.kt");
        }

        @Test
        @TestMetadata("if.kt")
        public void testIf() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/if.kt");
        }

        @Test
        @TestMetadata("nullCleanup.kt")
        public void testNullCleanup() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/nullCleanup.kt");
        }

        @Test
        @TestMetadata("nullNotSpill.kt")
        public void testNullNotSpill() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/nullNotSpill.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/simple.kt");
        }

        @Test
        @TestMetadata("twoRefs.kt")
        public void testTwoRefs() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/twoRefs.kt");
        }

        @Test
        @TestMetadata("unusedParamNotSpill.kt")
        public void testUnusedParamNotSpill() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/unusedParamNotSpill.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/cleanupWithoutStdlibFunction/when.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling/debugMode")
      @TestDataPath("$PROJECT_ROOT")
      public class DebugMode {
        @Test
        public void testAllFilesPresentInDebugMode() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling/debugMode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("backEdge.kt")
        public void testBackEdge() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/backEdge.kt");
        }

        @Test
        @TestMetadata("if.kt")
        public void testIf() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/if.kt");
        }

        @Test
        @TestMetadata("inlineOnly.kt")
        public void testInlineOnly() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/inlineOnly.kt");
        }

        @Test
        @TestMetadata("kt63954.kt")
        public void testKt63954() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/kt63954.kt");
        }

        @Test
        @TestMetadata("nullCleanup.kt")
        public void testNullCleanup() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/nullCleanup.kt");
        }

        @Test
        @TestMetadata("nullNotSpill.kt")
        public void testNullNotSpill() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/nullNotSpill.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/simple.kt");
        }

        @Test
        @TestMetadata("twoRefs.kt")
        public void testTwoRefs() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/twoRefs.kt");
        }

        @Test
        @TestMetadata("unusedParamNotSpill.kt")
        public void testUnusedParamNotSpill() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/unusedParamNotSpill.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/debugMode/when.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup")
      @TestDataPath("$PROJECT_ROOT")
      public class NoCleanup {
        @Test
        public void testAllFilesPresentInNoCleanup() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("backEdge.kt")
        public void testBackEdge() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/backEdge.kt");
        }

        @Test
        @TestMetadata("if.kt")
        public void testIf() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/if.kt");
        }

        @Test
        @TestMetadata("inlineOnly.kt")
        public void testInlineOnly() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/inlineOnly.kt");
        }

        @Test
        @TestMetadata("kt63954.kt")
        public void testKt63954() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/kt63954.kt");
        }

        @Test
        @TestMetadata("nullCleanup.kt")
        public void testNullCleanup() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/nullCleanup.kt");
        }

        @Test
        @TestMetadata("nullNotSpill.kt")
        public void testNullNotSpill() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/nullNotSpill.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/simple.kt");
        }

        @Test
        @TestMetadata("twoRefs.kt")
        public void testTwoRefs() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/twoRefs.kt");
        }

        @Test
        @TestMetadata("unusedParamNotSpill.kt")
        public void testUnusedParamNotSpill() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/unusedParamNotSpill.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() {
          runTest("compiler/testData/codegen/box/coroutines/varSpilling/noCleanup/when.kt");
        }
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/correctFrontendCode")
  @TestDataPath("$PROJECT_ROOT")
  public class CorrectFrontendCode {
    @Test
    public void testAllFilesPresentInCorrectFrontendCode() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/correctFrontendCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("privateNestedClassInSuper.kt")
    public void testPrivateNestedClassInSuper() {
      runTest("compiler/testData/codegen/box/correctFrontendCode/privateNestedClassInSuper.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/cycles")
  @TestDataPath("$PROJECT_ROOT")
  public class Cycles {
    @Test
    public void testAllFilesPresentInCycles() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/cycles"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("cycle.kt")
    public void testCycle() {
      runTest("compiler/testData/codegen/box/cycles/cycle.kt");
    }

    @Test
    @TestMetadata("cycle_do.kt")
    public void testCycle_do() {
      runTest("compiler/testData/codegen/box/cycles/cycle_do.kt");
    }

    @Test
    @TestMetadata("cycle_for.kt")
    public void testCycle_for() {
      runTest("compiler/testData/codegen/box/cycles/cycle_for.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/dataClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class DataClasses {
    @Test
    public void testAllFilesPresentInDataClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arrayParams.kt")
    public void testArrayParams() {
      runTest("compiler/testData/codegen/box/dataClasses/arrayParams.kt");
    }

    @Test
    @TestMetadata("changingVarParam.kt")
    public void testChangingVarParam() {
      runTest("compiler/testData/codegen/box/dataClasses/changingVarParam.kt");
    }

    @Test
    @TestMetadata("dataClassWithManyFields.kt")
    public void testDataClassWithManyFields() {
      runTest("compiler/testData/codegen/box/dataClasses/dataClassWithManyFields.kt");
    }

    @Test
    @TestMetadata("doubleParam.kt")
    public void testDoubleParam() {
      runTest("compiler/testData/codegen/box/dataClasses/doubleParam.kt");
    }

    @Test
    @TestMetadata("equalityChecksPrimitiveUnboxed.kt")
    public void testEqualityChecksPrimitiveUnboxed() {
      runTest("compiler/testData/codegen/box/dataClasses/equalityChecksPrimitiveUnboxed.kt");
    }

    @Test
    @TestMetadata("floatParam.kt")
    public void testFloatParam() {
      runTest("compiler/testData/codegen/box/dataClasses/floatParam.kt");
    }

    @Test
    @TestMetadata("fromOtherModule.kt")
    public void testFromOtherModule() {
      runTest("compiler/testData/codegen/box/dataClasses/fromOtherModule.kt");
    }

    @Test
    @TestMetadata("genericParam.kt")
    public void testGenericParam() {
      runTest("compiler/testData/codegen/box/dataClasses/genericParam.kt");
    }

    @Test
    @TestMetadata("kt49715.kt")
    public void testKt49715() {
      runTest("compiler/testData/codegen/box/dataClasses/kt49715.kt");
    }

    @Test
    @TestMetadata("kt49715_behaviorChange.kt")
    public void testKt49715_behaviorChange() {
      runTest("compiler/testData/codegen/box/dataClasses/kt49715_behaviorChange.kt");
    }

    @Test
    @TestMetadata("kt5002.kt")
    public void testKt5002() {
      runTest("compiler/testData/codegen/box/dataClasses/kt5002.kt");
    }

    @Test
    @TestMetadata("mixedParams.kt")
    public void testMixedParams() {
      runTest("compiler/testData/codegen/box/dataClasses/mixedParams.kt");
    }

    @Test
    @TestMetadata("multiDeclaration.kt")
    public void testMultiDeclaration() {
      runTest("compiler/testData/codegen/box/dataClasses/multiDeclaration.kt");
    }

    @Test
    @TestMetadata("multiDeclarationFor.kt")
    public void testMultiDeclarationFor() {
      runTest("compiler/testData/codegen/box/dataClasses/multiDeclarationFor.kt");
    }

    @Test
    @TestMetadata("nonTrivialFinalMemberInSuperClass.kt")
    public void testNonTrivialFinalMemberInSuperClass() {
      runTest("compiler/testData/codegen/box/dataClasses/nonTrivialFinalMemberInSuperClass.kt");
    }

    @Test
    @TestMetadata("nonTrivialMemberInSuperClass.kt")
    public void testNonTrivialMemberInSuperClass() {
      runTest("compiler/testData/codegen/box/dataClasses/nonTrivialMemberInSuperClass.kt");
    }

    @Test
    @TestMetadata("privateValParams.kt")
    public void testPrivateValParams() {
      runTest("compiler/testData/codegen/box/dataClasses/privateValParams.kt");
    }

    @Test
    @TestMetadata("propertyOfDnnType.kt")
    public void testPropertyOfDnnType() {
      runTest("compiler/testData/codegen/box/dataClasses/propertyOfDnnType.kt");
    }

    @Test
    @TestMetadata("twoValParams.kt")
    public void testTwoValParams() {
      runTest("compiler/testData/codegen/box/dataClasses/twoValParams.kt");
    }

    @Test
    @TestMetadata("twoVarParams.kt")
    public void testTwoVarParams() {
      runTest("compiler/testData/codegen/box/dataClasses/twoVarParams.kt");
    }

    @Test
    @TestMetadata("typeParameterWithNonTrivialBound.kt")
    public void testTypeParameterWithNonTrivialBound() {
      runTest("compiler/testData/codegen/box/dataClasses/typeParameterWithNonTrivialBound.kt");
    }

    @Test
    @TestMetadata("unitComponent.kt")
    public void testUnitComponent() {
      runTest("compiler/testData/codegen/box/dataClasses/unitComponent.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/dataClasses/components")
    @TestDataPath("$PROJECT_ROOT")
    public class Components {
      @Test
      public void testAllFilesPresentInComponents() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/components"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt49812.kt")
      public void testKt49812() {
        runTest("compiler/testData/codegen/box/dataClasses/components/kt49812.kt");
      }

      @Test
      @TestMetadata("kt49936.kt")
      public void testKt49936() {
        runTest("compiler/testData/codegen/box/dataClasses/components/kt49936.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/dataClasses/copy")
    @TestDataPath("$PROJECT_ROOT")
    public class Copy {
      @Test
      public void testAllFilesPresentInCopy() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/copy"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("constructorWithDefaultParam.kt")
      public void testConstructorWithDefaultParam() {
        runTest("compiler/testData/codegen/box/dataClasses/copy/constructorWithDefaultParam.kt");
      }

      @Test
      @TestMetadata("copyInObjectNestedDataClass.kt")
      public void testCopyInObjectNestedDataClass() {
        runTest("compiler/testData/codegen/box/dataClasses/copy/copyInObjectNestedDataClass.kt");
      }

      @Test
      @TestMetadata("kt12708.kt")
      public void testKt12708() {
        runTest("compiler/testData/codegen/box/dataClasses/copy/kt12708.kt");
      }

      @Test
      @TestMetadata("kt3033.kt")
      public void testKt3033() {
        runTest("compiler/testData/codegen/box/dataClasses/copy/kt3033.kt");
      }

      @Test
      @TestMetadata("valInConstructorParams.kt")
      public void testValInConstructorParams() {
        runTest("compiler/testData/codegen/box/dataClasses/copy/valInConstructorParams.kt");
      }

      @Test
      @TestMetadata("varInConstructorParams.kt")
      public void testVarInConstructorParams() {
        runTest("compiler/testData/codegen/box/dataClasses/copy/varInConstructorParams.kt");
      }

      @Test
      @TestMetadata("withGenericParameter.kt")
      public void testWithGenericParameter() {
        runTest("compiler/testData/codegen/box/dataClasses/copy/withGenericParameter.kt");
      }

      @Test
      @TestMetadata("withSecondaryConstructor.kt")
      public void testWithSecondaryConstructor() {
        runTest("compiler/testData/codegen/box/dataClasses/copy/withSecondaryConstructor.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/dataClasses/equals")
    @TestDataPath("$PROJECT_ROOT")
    public class Equals {
      @Test
      public void testAllFilesPresentInEquals() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/equals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("alreadyDeclared.kt")
      public void testAlreadyDeclared() {
        runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclared.kt");
      }

      @Test
      @TestMetadata("alreadyDeclaredWrongSignature.kt")
      public void testAlreadyDeclaredWrongSignature() {
        runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclaredWrongSignature.kt");
      }

      @Test
      @TestMetadata("genericarray.kt")
      public void testGenericarray() {
        runTest("compiler/testData/codegen/box/dataClasses/equals/genericarray.kt");
      }

      @Test
      @TestMetadata("intarray.kt")
      public void testIntarray() {
        runTest("compiler/testData/codegen/box/dataClasses/equals/intarray.kt");
      }

      @Test
      @TestMetadata("null.kt")
      public void testNull() {
        runTest("compiler/testData/codegen/box/dataClasses/equals/null.kt");
      }

      @Test
      @TestMetadata("nullother.kt")
      public void testNullother() {
        runTest("compiler/testData/codegen/box/dataClasses/equals/nullother.kt");
      }

      @Test
      @TestMetadata("sameinstance.kt")
      public void testSameinstance() {
        runTest("compiler/testData/codegen/box/dataClasses/equals/sameinstance.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/dataClasses/hashCode")
    @TestDataPath("$PROJECT_ROOT")
    public class HashCode {
      @Test
      public void testAllFilesPresentInHashCode() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("alreadyDeclared.kt")
      public void testAlreadyDeclared() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclared.kt");
      }

      @Test
      @TestMetadata("alreadyDeclaredWrongSignature.kt")
      public void testAlreadyDeclaredWrongSignature() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclaredWrongSignature.kt");
      }

      @Test
      @TestMetadata("array.kt")
      public void testArray() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/array.kt");
      }

      @Test
      @TestMetadata("boolean.kt")
      public void testBoolean() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/boolean.kt");
      }

      @Test
      @TestMetadata("byte.kt")
      public void testByte() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/byte.kt");
      }

      @Test
      @TestMetadata("char.kt")
      public void testChar() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/char.kt");
      }

      @Test
      @TestMetadata("double.kt")
      public void testDouble() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/double.kt");
      }

      @Test
      @TestMetadata("float.kt")
      public void testFloat() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/float.kt");
      }

      @Test
      @TestMetadata("genericNull.kt")
      public void testGenericNull() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/genericNull.kt");
      }

      @Test
      @TestMetadata("int.kt")
      public void testInt() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/int.kt");
      }

      @Test
      @TestMetadata("long.kt")
      public void testLong() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/long.kt");
      }

      @Test
      @TestMetadata("null.kt")
      public void testNull() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/null.kt");
      }

      @Test
      @TestMetadata("short.kt")
      public void testShort() {
        runTest("compiler/testData/codegen/box/dataClasses/hashCode/short.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/dataClasses/toString")
    @TestDataPath("$PROJECT_ROOT")
    public class ToString {
      @Test
      public void testAllFilesPresentInToString() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/toString"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("alreadyDeclared.kt")
      public void testAlreadyDeclared() {
        runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclared.kt");
      }

      @Test
      @TestMetadata("alreadyDeclaredWrongSignature.kt")
      public void testAlreadyDeclaredWrongSignature() {
        runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclaredWrongSignature.kt");
      }

      @Test
      @TestMetadata("arrayParams.kt")
      public void testArrayParams() {
        runTest("compiler/testData/codegen/box/dataClasses/toString/arrayParams.kt");
      }

      @Test
      @TestMetadata("changingVarParam.kt")
      public void testChangingVarParam() {
        runTest("compiler/testData/codegen/box/dataClasses/toString/changingVarParam.kt");
      }

      @Test
      @TestMetadata("genericParam.kt")
      public void testGenericParam() {
        runTest("compiler/testData/codegen/box/dataClasses/toString/genericParam.kt");
      }

      @Test
      @TestMetadata("mixedParams.kt")
      public void testMixedParams() {
        runTest("compiler/testData/codegen/box/dataClasses/toString/mixedParams.kt");
      }

      @Test
      @TestMetadata("primitiveArrays.kt")
      public void testPrimitiveArrays() {
        runTest("compiler/testData/codegen/box/dataClasses/toString/primitiveArrays.kt");
      }

      @Test
      @TestMetadata("unitComponent.kt")
      public void testUnitComponent() {
        runTest("compiler/testData/codegen/box/dataClasses/toString/unitComponent.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/dataObjects")
  @TestDataPath("$PROJECT_ROOT")
  public class DataObjects {
    @Test
    public void testAllFilesPresentInDataObjects() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataObjects"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("equals.kt")
    public void testEquals() {
      runTest("compiler/testData/codegen/box/dataObjects/equals.kt");
    }

    @Test
    @TestMetadata("hashCode.kt")
    public void testHashCode() {
      runTest("compiler/testData/codegen/box/dataObjects/hashCode.kt");
    }

    @Test
    @TestMetadata("multipleInstances.kt")
    public void testMultipleInstances() {
      runTest("compiler/testData/codegen/box/dataObjects/multipleInstances.kt");
    }

    @Test
    @TestMetadata("serialization.kt")
    public void testSerialization() {
      runTest("compiler/testData/codegen/box/dataObjects/serialization.kt");
    }

    @Test
    @TestMetadata("toString.kt")
    public void testToString() {
      runTest("compiler/testData/codegen/box/dataObjects/toString.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/dataflow")
  @TestDataPath("$PROJECT_ROOT")
  public class Dataflow {
    @Test
    public void testAllFilesPresentInDataflow() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataflow"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("scope1.kt")
    public void testScope1() {
      runTest("compiler/testData/codegen/box/dataflow/scope1.kt");
    }

    @Test
    @TestMetadata("uninitialized_val.kt")
    public void testUninitialized_val() {
      runTest("compiler/testData/codegen/box/dataflow/uninitialized_val.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/deadCodeElimination")
  @TestDataPath("$PROJECT_ROOT")
  public class DeadCodeElimination {
    @Test
    public void testAllFilesPresentInDeadCodeElimination() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("emptyVariableRange.kt")
    public void testEmptyVariableRange() {
      runTest("compiler/testData/codegen/box/deadCodeElimination/emptyVariableRange.kt");
    }

    @Test
    @TestMetadata("intersectingVariableRange.kt")
    public void testIntersectingVariableRange() {
      runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRange.kt");
    }

    @Test
    @TestMetadata("intersectingVariableRangeInFinally.kt")
    public void testIntersectingVariableRangeInFinally() {
      runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRangeInFinally.kt");
    }

    @Test
    @TestMetadata("kt14357.kt")
    public void testKt14357() {
      runTest("compiler/testData/codegen/box/deadCodeElimination/kt14357.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/defaultArguments")
  @TestDataPath("$PROJECT_ROOT")
  public class DefaultArguments {
    @Test
    public void testAllFilesPresentInDefaultArguments() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("callDefaultFromInitializer.kt")
    public void testCallDefaultFromInitializer() {
      runTest("compiler/testData/codegen/box/defaultArguments/callDefaultFromInitializer.kt");
    }

    @Test
    @TestMetadata("captureInTailrec.kt")
    public void testCaptureInTailrec() {
      runTest("compiler/testData/codegen/box/defaultArguments/captureInTailrec.kt");
    }

    @Test
    @TestMetadata("complexInheritance.kt")
    public void testComplexInheritance() {
      runTest("compiler/testData/codegen/box/defaultArguments/complexInheritance.kt");
    }

    @Test
    @TestMetadata("implementedByFake.kt")
    public void testImplementedByFake() {
      runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake.kt");
    }

    @Test
    @TestMetadata("implementedByFake2.kt")
    public void testImplementedByFake2() {
      runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake2.kt");
    }

    @Test
    @TestMetadata("implementedByFake3.kt")
    public void testImplementedByFake3() {
      runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake3.kt");
    }

    @Test
    @TestMetadata("inheritedFromInterfaceViaAbstractSuperclass.kt")
    public void testInheritedFromInterfaceViaAbstractSuperclass() {
      runTest("compiler/testData/codegen/box/defaultArguments/inheritedFromInterfaceViaAbstractSuperclass.kt");
    }

    @Test
    @TestMetadata("kt36853.kt")
    public void testKt36853() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt36853.kt");
    }

    @Test
    @TestMetadata("kt36853_fibonacci.kt")
    public void testKt36853_fibonacci() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt36853_fibonacci.kt");
    }

    @Test
    @TestMetadata("kt36853_nestedObject.kt")
    public void testKt36853_nestedObject() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt36853_nestedObject.kt");
    }

    @Test
    @TestMetadata("kt36853a.kt")
    public void testKt36853a() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt36853a.kt");
    }

    @Test
    @TestMetadata("kt36972_companion.kt")
    public void testKt36972_companion() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt36972_companion.kt");
    }

    @Test
    @TestMetadata("kt36972_object.kt")
    public void testKt36972_object() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt36972_object.kt");
    }

    @Test
    @TestMetadata("kt46189.kt")
    public void testKt46189() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt46189.kt");
    }

    @Test
    @TestMetadata("kt47073.kt")
    public void testKt47073() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt47073.kt");
    }

    @Test
    @TestMetadata("kt47073_nested.kt")
    public void testKt47073_nested() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt47073_nested.kt");
    }

    @Test
    @TestMetadata("kt48391.kt")
    public void testKt48391() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt48391.kt");
    }

    @Test
    @TestMetadata("kt52702.kt")
    public void testKt52702() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt52702.kt");
    }

    @Test
    @TestMetadata("kt6382.kt")
    public void testKt6382() {
      runTest("compiler/testData/codegen/box/defaultArguments/kt6382.kt");
    }

    @Test
    @TestMetadata("protected.kt")
    public void testProtected() {
      runTest("compiler/testData/codegen/box/defaultArguments/protected.kt");
    }

    @Test
    @TestMetadata("recursiveDefaultArguments.kt")
    public void testRecursiveDefaultArguments() {
      runTest("compiler/testData/codegen/box/defaultArguments/recursiveDefaultArguments.kt");
    }

    @Test
    @TestMetadata("referenceAsArg.kt")
    public void testReferenceAsArg() {
      runTest("compiler/testData/codegen/box/defaultArguments/referenceAsArg.kt");
    }

    @Test
    @TestMetadata("simpleFromOtherFile.kt")
    public void testSimpleFromOtherFile() {
      runTest("compiler/testData/codegen/box/defaultArguments/simpleFromOtherFile.kt");
    }

    @Test
    @TestMetadata("superCallCheck.kt")
    public void testSuperCallCheck() {
      runTest("compiler/testData/codegen/box/defaultArguments/superCallCheck.kt");
    }

    @Test
    @TestMetadata("superCallHandlerOrder.kt")
    public void testSuperCallHandlerOrder() {
      runTest("compiler/testData/codegen/box/defaultArguments/superCallHandlerOrder.kt");
    }

    @Test
    @TestMetadata("useNextParamInLambda.kt")
    public void testUseNextParamInLambda() {
      runTest("compiler/testData/codegen/box/defaultArguments/useNextParamInLambda.kt");
    }

    @Test
    @TestMetadata("useNextParamInLambdaTailrec.kt")
    public void testUseNextParamInLambdaTailrec() {
      runTest("compiler/testData/codegen/box/defaultArguments/useNextParamInLambdaTailrec.kt");
    }

    @Test
    @TestMetadata("useThisInLambda.kt")
    public void testUseThisInLambda() {
      runTest("compiler/testData/codegen/box/defaultArguments/useThisInLambda.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/defaultArguments/constructor")
    @TestDataPath("$PROJECT_ROOT")
    public class Constructor {
      @Test
      public void testAllFilesPresentInConstructor() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/constructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotation.kt")
      public void testAnnotation() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotation.kt");
      }

      @Test
      @TestMetadata("annotationWithEmptyArray.kt")
      public void testAnnotationWithEmptyArray() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotationWithEmptyArray.kt");
      }

      @Test
      @TestMetadata("checkIfConstructorIsSynthetic.kt")
      public void testCheckIfConstructorIsSynthetic() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/checkIfConstructorIsSynthetic.kt");
      }

      @Test
      @TestMetadata("defArgs1.kt")
      public void testDefArgs1() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1.kt");
      }

      @Test
      @TestMetadata("defArgs1InnerClass.kt")
      public void testDefArgs1InnerClass() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1InnerClass.kt");
      }

      @Test
      @TestMetadata("defArgs2.kt")
      public void testDefArgs2() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs2.kt");
      }

      @Test
      @TestMetadata("doubleDefArgs1InnerClass.kt")
      public void testDoubleDefArgs1InnerClass() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/doubleDefArgs1InnerClass.kt");
      }

      @Test
      @TestMetadata("enum.kt")
      public void testEnum() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/enum.kt");
      }

      @Test
      @TestMetadata("enumWithOneDefArg.kt")
      public void testEnumWithOneDefArg() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithOneDefArg.kt");
      }

      @Test
      @TestMetadata("enumWithTwoDefArgs.kt")
      public void testEnumWithTwoDefArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDefArgs.kt");
      }

      @Test
      @TestMetadata("enumWithTwoDoubleDefArgs.kt")
      public void testEnumWithTwoDoubleDefArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDoubleDefArgs.kt");
      }

      @Test
      @TestMetadata("innerClass32Args.kt")
      public void testInnerClass32Args() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/innerClass32Args.kt");
      }

      @Test
      @TestMetadata("kt2852.kt")
      public void testKt2852() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt2852.kt");
      }

      @Test
      @TestMetadata("kt30517.kt")
      public void testKt30517() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt30517.kt");
      }

      @Test
      @TestMetadata("kt3060.kt")
      public void testKt3060() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt3060.kt");
      }

      @Test
      @TestMetadata("manyArgs.kt")
      public void testManyArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/manyArgs.kt");
      }

      @Test
      @TestMetadata("objectExpressionDelegatingToSecondaryConstructor.kt")
      public void testObjectExpressionDelegatingToSecondaryConstructor() {
        runTest("compiler/testData/codegen/box/defaultArguments/constructor/objectExpressionDelegatingToSecondaryConstructor.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/defaultArguments/convention")
    @TestDataPath("$PROJECT_ROOT")
    public class Convention {
      @Test
      public void testAllFilesPresentInConvention() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/convention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("incWithDefaultInGetter.kt")
      public void testIncWithDefaultInGetter() {
        runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaultInGetter.kt");
      }

      @Test
      @TestMetadata("incWithDefaults.kt")
      public void testIncWithDefaults() {
        runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaults.kt");
      }

      @Test
      @TestMetadata("kt16520.kt")
      public void testKt16520() {
        runTest("compiler/testData/codegen/box/defaultArguments/convention/kt16520.kt");
      }

      @Test
      @TestMetadata("kt9140.kt")
      public void testKt9140() {
        runTest("compiler/testData/codegen/box/defaultArguments/convention/kt9140.kt");
      }

      @Test
      @TestMetadata("plusAssignWithDefaultInGetter.kt")
      public void testPlusAssignWithDefaultInGetter() {
        runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaultInGetter.kt");
      }

      @Test
      @TestMetadata("plusAssignWithDefaults.kt")
      public void testPlusAssignWithDefaults() {
        runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaults.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/defaultArguments/function")
    @TestDataPath("$PROJECT_ROOT")
    public class Function {
      @Test
      @TestMetadata("abstractClass.kt")
      public void testAbstractClass() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/abstractClass.kt");
      }

      @Test
      public void testAllFilesPresentInFunction() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("complexInheritance.kt")
      public void testComplexInheritance() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/complexInheritance.kt");
      }

      @Test
      @TestMetadata("covariantOverride.kt")
      public void testCovariantOverride() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverride.kt");
      }

      @Test
      @TestMetadata("covariantOverrideGeneric.kt")
      public void testCovariantOverrideGeneric() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverrideGeneric.kt");
      }

      @Test
      @TestMetadata("defaultLambdaInline.kt")
      public void testDefaultLambdaInline() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/defaultLambdaInline.kt");
      }

      @Test
      @TestMetadata("extensionFunctionManyArgs.kt")
      public void testExtensionFunctionManyArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/extensionFunctionManyArgs.kt");
      }

      @Test
      @TestMetadata("extentionFunction.kt")
      public void testExtentionFunction() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunction.kt");
      }

      @Test
      @TestMetadata("extentionFunctionDouble.kt")
      public void testExtentionFunctionDouble() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDouble.kt");
      }

      @Test
      @TestMetadata("extentionFunctionDoubleTwoArgs.kt")
      public void testExtentionFunctionDoubleTwoArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDoubleTwoArgs.kt");
      }

      @Test
      @TestMetadata("extentionFunctionInClassObject.kt")
      public void testExtentionFunctionInClassObject() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInClassObject.kt");
      }

      @Test
      @TestMetadata("extentionFunctionInObject.kt")
      public void testExtentionFunctionInObject() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInObject.kt");
      }

      @Test
      @TestMetadata("extentionFunctionWithOneDefArg.kt")
      public void testExtentionFunctionWithOneDefArg() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionWithOneDefArg.kt");
      }

      @Test
      @TestMetadata("funInTrait.kt")
      public void testFunInTrait() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/funInTrait.kt");
      }

      @Test
      @TestMetadata("funInTraitChain.kt")
      public void testFunInTraitChain() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/funInTraitChain.kt");
      }

      @Test
      @TestMetadata("innerExtentionFunction.kt")
      public void testInnerExtentionFunction() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunction.kt");
      }

      @Test
      @TestMetadata("innerExtentionFunctionDouble.kt")
      public void testInnerExtentionFunctionDouble() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDouble.kt");
      }

      @Test
      @TestMetadata("innerExtentionFunctionDoubleTwoArgs.kt")
      public void testInnerExtentionFunctionDoubleTwoArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDoubleTwoArgs.kt");
      }

      @Test
      @TestMetadata("innerExtentionFunctionManyArgs.kt")
      public void testInnerExtentionFunctionManyArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionManyArgs.kt");
      }

      @Test
      @TestMetadata("kt15971.kt")
      public void testKt15971() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971.kt");
      }

      @Test
      @TestMetadata("kt15971_2.kt")
      public void testKt15971_2() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971_2.kt");
      }

      @Test
      @TestMetadata("kt15971_3.kt")
      public void testKt15971_3() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971_3.kt");
      }

      @Test
      @TestMetadata("kt36188.kt")
      public void testKt36188() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/kt36188.kt");
      }

      @Test
      @TestMetadata("kt36188_2.kt")
      public void testKt36188_2() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/kt36188_2.kt");
      }

      @Test
      @TestMetadata("kt5232.kt")
      public void testKt5232() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/kt5232.kt");
      }

      @Test
      @TestMetadata("memberFunctionManyArgs.kt")
      public void testMemberFunctionManyArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/memberFunctionManyArgs.kt");
      }

      @Test
      @TestMetadata("mixingNamedAndPositioned.kt")
      public void testMixingNamedAndPositioned() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/mixingNamedAndPositioned.kt");
      }

      @Test
      @TestMetadata("topLevelManyArgs.kt")
      public void testTopLevelManyArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/topLevelManyArgs.kt");
      }

      @Test
      @TestMetadata("trait.kt")
      public void testTrait() {
        runTest("compiler/testData/codegen/box/defaultArguments/function/trait.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/defaultArguments/private")
    @TestDataPath("$PROJECT_ROOT")
    public class Private {
      @Test
      public void testAllFilesPresentInPrivate() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("memberExtensionFunction.kt")
      public void testMemberExtensionFunction() {
        runTest("compiler/testData/codegen/box/defaultArguments/private/memberExtensionFunction.kt");
      }

      @Test
      @TestMetadata("memberFunction.kt")
      public void testMemberFunction() {
        runTest("compiler/testData/codegen/box/defaultArguments/private/memberFunction.kt");
      }

      @Test
      @TestMetadata("primaryConstructor.kt")
      public void testPrimaryConstructor() {
        runTest("compiler/testData/codegen/box/defaultArguments/private/primaryConstructor.kt");
      }

      @Test
      @TestMetadata("secondaryConstructor.kt")
      public void testSecondaryConstructor() {
        runTest("compiler/testData/codegen/box/defaultArguments/private/secondaryConstructor.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/defaultArguments/reflection")
    @TestDataPath("$PROJECT_ROOT")
    public class Reflection {
      @Test
      public void testAllFilesPresentInReflection() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/reflection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("classInClassObject.kt")
      public void testClassInClassObject() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/classInClassObject.kt");
      }

      @Test
      @TestMetadata("classInObject.kt")
      public void testClassInObject() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/classInObject.kt");
      }

      @Test
      @TestMetadata("classWithTwoDefaultArgs.kt")
      public void testClassWithTwoDefaultArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/classWithTwoDefaultArgs.kt");
      }

      @Test
      @TestMetadata("classWithVararg.kt")
      public void testClassWithVararg() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/classWithVararg.kt");
      }

      @Test
      @TestMetadata("enum.kt")
      public void testEnum() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/enum.kt");
      }

      @Test
      @TestMetadata("internalClass.kt")
      public void testInternalClass() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/internalClass.kt");
      }

      @Test
      @TestMetadata("privateClass.kt")
      public void testPrivateClass() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/privateClass.kt");
      }

      @Test
      @TestMetadata("privateConstructor.kt")
      public void testPrivateConstructor() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/privateConstructor.kt");
      }

      @Test
      @TestMetadata("publicClass.kt")
      public void testPublicClass() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/publicClass.kt");
      }

      @Test
      @TestMetadata("publicClassWoDefArgs.kt")
      public void testPublicClassWoDefArgs() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/publicClassWoDefArgs.kt");
      }

      @Test
      @TestMetadata("publicInnerClass.kt")
      public void testPublicInnerClass() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/publicInnerClass.kt");
      }

      @Test
      @TestMetadata("publicInnerClassInPrivateClass.kt")
      public void testPublicInnerClassInPrivateClass() {
        runTest("compiler/testData/codegen/box/defaultArguments/reflection/publicInnerClassInPrivateClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/defaultArguments/signature")
    @TestDataPath("$PROJECT_ROOT")
    public class Signature {
      @Test
      public void testAllFilesPresentInSignature() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt2789.kt")
      public void testKt2789() {
        runTest("compiler/testData/codegen/box/defaultArguments/signature/kt2789.kt");
      }

      @Test
      @TestMetadata("kt9428.kt")
      public void testKt9428() {
        runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9428.kt");
      }

      @Test
      @TestMetadata("kt9924.kt")
      public void testKt9924() {
        runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9924.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/delegatedProperty")
  @TestDataPath("$PROJECT_ROOT")
  public class DelegatedProperty {
    @Test
    @TestMetadata("accessTopLevelDelegatedPropertyInClinit.kt")
    public void testAccessTopLevelDelegatedPropertyInClinit() {
      runTest("compiler/testData/codegen/box/delegatedProperty/accessTopLevelDelegatedPropertyInClinit.kt");
    }

    @Test
    public void testAllFilesPresentInDelegatedProperty() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("beforeDeclarationContainerOptimization.kt")
    public void testBeforeDeclarationContainerOptimization() {
      runTest("compiler/testData/codegen/box/delegatedProperty/beforeDeclarationContainerOptimization.kt");
    }

    @Test
    @TestMetadata("callableReferenceAsSecondArgumentOfDelegate.kt")
    public void testCallableReferenceAsSecondArgumentOfDelegate() {
      runTest("compiler/testData/codegen/box/delegatedProperty/callableReferenceAsSecondArgumentOfDelegate.kt");
    }

    @Test
    @TestMetadata("capturePropertyInClosure.kt")
    public void testCapturePropertyInClosure() {
      runTest("compiler/testData/codegen/box/delegatedProperty/capturePropertyInClosure.kt");
    }

    @Test
    @TestMetadata("castGetReturnType.kt")
    public void testCastGetReturnType() {
      runTest("compiler/testData/codegen/box/delegatedProperty/castGetReturnType.kt");
    }

    @Test
    @TestMetadata("castSetParameter.kt")
    public void testCastSetParameter() {
      runTest("compiler/testData/codegen/box/delegatedProperty/castSetParameter.kt");
    }

    @Test
    @TestMetadata("correctFieldsOrder.kt")
    public void testCorrectFieldsOrder() {
      runTest("compiler/testData/codegen/box/delegatedProperty/correctFieldsOrder.kt");
    }

    @Test
    @TestMetadata("delegateAsInnerClass.kt")
    public void testDelegateAsInnerClass() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateAsInnerClass.kt");
    }

    @Test
    @TestMetadata("delegateByOtherProperty.kt")
    public void testDelegateByOtherProperty() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateByOtherProperty.kt");
    }

    @Test
    @TestMetadata("delegateByTopLevelFun.kt")
    public void testDelegateByTopLevelFun() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelFun.kt");
    }

    @Test
    @TestMetadata("delegateByTopLevelProperty.kt")
    public void testDelegateByTopLevelProperty() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelProperty.kt");
    }

    @Test
    @TestMetadata("delegateForExtProperty.kt")
    public void testDelegateForExtProperty() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtProperty.kt");
    }

    @Test
    @TestMetadata("delegateForExtPropertyInClass.kt")
    public void testDelegateForExtPropertyInClass() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtPropertyInClass.kt");
    }

    @Test
    @TestMetadata("delegateToConstVal.kt")
    public void testDelegateToConstVal() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateToConstVal.kt");
    }

    @Test
    @TestMetadata("delegateToConstructorParameter.kt")
    public void testDelegateToConstructorParameter() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateToConstructorParameter.kt");
    }

    @Test
    @TestMetadata("delegateToJavaFinalStaticField.kt")
    public void testDelegateToJavaFinalStaticField() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateToJavaFinalStaticField.kt");
    }

    @Test
    @TestMetadata("delegateWithPrivateSet.kt")
    public void testDelegateWithPrivateSet() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegateWithPrivateSet.kt");
    }

    @Test
    @TestMetadata("delegatedOverride.kt")
    public void testDelegatedOverride() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegatedOverride.kt");
    }

    @Test
    @TestMetadata("delegatedPropertyInEnum.kt")
    public void testDelegatedPropertyInEnum() {
      runTest("compiler/testData/codegen/box/delegatedProperty/delegatedPropertyInEnum.kt");
    }

    @Test
    @TestMetadata("DelegationByFunctionWithEnumUpperBound.kt")
    public void testDelegationByFunctionWithEnumUpperBound() {
      runTest("compiler/testData/codegen/box/delegatedProperty/DelegationByFunctionWithEnumUpperBound.kt");
    }

    @Test
    @TestMetadata("extensionDelegatesWithSameNames.kt")
    public void testExtensionDelegatesWithSameNames() {
      runTest("compiler/testData/codegen/box/delegatedProperty/extensionDelegatesWithSameNames.kt");
    }

    @Test
    @TestMetadata("extensionPropertyAndExtensionGetValue.kt")
    public void testExtensionPropertyAndExtensionGetValue() {
      runTest("compiler/testData/codegen/box/delegatedProperty/extensionPropertyAndExtensionGetValue.kt");
    }

    @Test
    @TestMetadata("functionRefDelefate.kt")
    public void testFunctionRefDelefate() {
      runTest("compiler/testData/codegen/box/delegatedProperty/functionRefDelefate.kt");
    }

    @Test
    @TestMetadata("genericDelegate.kt")
    public void testGenericDelegate() {
      runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegate.kt");
    }

    @Test
    @TestMetadata("genericDelegateUncheckedCast1.kt")
    public void testGenericDelegateUncheckedCast1() {
      runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast1.kt");
    }

    @Test
    @TestMetadata("genericDelegateUncheckedCast2.kt")
    public void testGenericDelegateUncheckedCast2() {
      runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast2.kt");
    }

    @Test
    @TestMetadata("genericSetValueViaSyntheticAccessor.kt")
    public void testGenericSetValueViaSyntheticAccessor() {
      runTest("compiler/testData/codegen/box/delegatedProperty/genericSetValueViaSyntheticAccessor.kt");
    }

    @Test
    @TestMetadata("getAsExtensionFun.kt")
    public void testGetAsExtensionFun() {
      runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFun.kt");
    }

    @Test
    @TestMetadata("getAsExtensionFunInClass.kt")
    public void testGetAsExtensionFunInClass() {
      runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFunInClass.kt");
    }

    @Test
    @TestMetadata("getDelegateWithoutReflection.kt")
    public void testGetDelegateWithoutReflection() {
      runTest("compiler/testData/codegen/box/delegatedProperty/getDelegateWithoutReflection.kt");
    }

    @Test
    @TestMetadata("inClassVal.kt")
    public void testInClassVal() {
      runTest("compiler/testData/codegen/box/delegatedProperty/inClassVal.kt");
    }

    @Test
    @TestMetadata("inClassVar.kt")
    public void testInClassVar() {
      runTest("compiler/testData/codegen/box/delegatedProperty/inClassVar.kt");
    }

    @Test
    @TestMetadata("inTrait.kt")
    public void testInTrait() {
      runTest("compiler/testData/codegen/box/delegatedProperty/inTrait.kt");
    }

    @Test
    @TestMetadata("inferredPropertyType.kt")
    public void testInferredPropertyType() {
      runTest("compiler/testData/codegen/box/delegatedProperty/inferredPropertyType.kt");
    }

    @Test
    @TestMetadata("insideInlinedObjectMultiModule.kt")
    public void testInsideInlinedObjectMultiModule() {
      runTest("compiler/testData/codegen/box/delegatedProperty/insideInlinedObjectMultiModule.kt");
    }

    @Test
    @TestMetadata("javaDelegateTopLevel.kt")
    public void testJavaDelegateTopLevel() {
      runTest("compiler/testData/codegen/box/delegatedProperty/javaDelegateTopLevel.kt");
    }

    @Test
    @TestMetadata("kt35707.kt")
    public void testKt35707() {
      runTest("compiler/testData/codegen/box/delegatedProperty/kt35707.kt");
    }

    @Test
    @TestMetadata("kt37204.kt")
    public void testKt37204() {
      runTest("compiler/testData/codegen/box/delegatedProperty/kt37204.kt");
    }

    @Test
    @TestMetadata("kt4138.kt")
    public void testKt4138() {
      runTest("compiler/testData/codegen/box/delegatedProperty/kt4138.kt");
    }

    @Test
    @TestMetadata("kt45431.kt")
    public void testKt45431() {
      runTest("compiler/testData/codegen/box/delegatedProperty/kt45431.kt");
    }

    @Test
    @TestMetadata("kt6722.kt")
    public void testKt6722() {
      runTest("compiler/testData/codegen/box/delegatedProperty/kt6722.kt");
    }

    @Test
    @TestMetadata("kt9712.kt")
    public void testKt9712() {
      runTest("compiler/testData/codegen/box/delegatedProperty/kt9712.kt");
    }

    @Test
    @TestMetadata("lazy.kt")
    public void testLazy() {
      runTest("compiler/testData/codegen/box/delegatedProperty/lazy.kt");
    }

    @Test
    @TestMetadata("local.kt")
    public void testLocal() {
      runTest("compiler/testData/codegen/box/delegatedProperty/local.kt");
    }

    @Test
    @TestMetadata("map.kt")
    public void testMap() {
      runTest("compiler/testData/codegen/box/delegatedProperty/map.kt");
    }

    @Test
    @TestMetadata("noTypeVariablesLeft.kt")
    public void testNoTypeVariablesLeft() {
      runTest("compiler/testData/codegen/box/delegatedProperty/noTypeVariablesLeft.kt");
    }

    @Test
    @TestMetadata("observable.kt")
    public void testObservable() {
      runTest("compiler/testData/codegen/box/delegatedProperty/observable.kt");
    }

    @Test
    @TestMetadata("packageLevel.kt")
    public void testPackageLevel() {
      runTest("compiler/testData/codegen/box/delegatedProperty/packageLevel.kt");
    }

    @Test
    @TestMetadata("privateInSubClass.kt")
    public void testPrivateInSubClass() {
      runTest("compiler/testData/codegen/box/delegatedProperty/privateInSubClass.kt");
    }

    @Test
    @TestMetadata("privateSetterKPropertyIsNotMutable.kt")
    public void testPrivateSetterKPropertyIsNotMutable() {
      runTest("compiler/testData/codegen/box/delegatedProperty/privateSetterKPropertyIsNotMutable.kt");
    }

    @Test
    @TestMetadata("privateVar.kt")
    public void testPrivateVar() {
      runTest("compiler/testData/codegen/box/delegatedProperty/privateVar.kt");
    }

    @Test
    @TestMetadata("propertyMetadataShouldBeCached.kt")
    public void testPropertyMetadataShouldBeCached() {
      runTest("compiler/testData/codegen/box/delegatedProperty/propertyMetadataShouldBeCached.kt");
    }

    @Test
    @TestMetadata("protectedVarWithPrivateSet.kt")
    public void testProtectedVarWithPrivateSet() {
      runTest("compiler/testData/codegen/box/delegatedProperty/protectedVarWithPrivateSet.kt");
    }

    @Test
    @TestMetadata("referenceEnclosingClassFieldInReceiver.kt")
    public void testReferenceEnclosingClassFieldInReceiver() {
      runTest("compiler/testData/codegen/box/delegatedProperty/referenceEnclosingClassFieldInReceiver.kt");
    }

    @Test
    @TestMetadata("referenceEnclosingClassFieldInReceiver2.kt")
    public void testReferenceEnclosingClassFieldInReceiver2() {
      runTest("compiler/testData/codegen/box/delegatedProperty/referenceEnclosingClassFieldInReceiver2.kt");
    }

    @Test
    @TestMetadata("resolveGetValueWithWholeDelegate.kt")
    public void testResolveGetValueWithWholeDelegate() {
      runTest("compiler/testData/codegen/box/delegatedProperty/resolveGetValueWithWholeDelegate.kt");
    }

    @Test
    @TestMetadata("setAsExtensionFun.kt")
    public void testSetAsExtensionFun() {
      runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFun.kt");
    }

    @Test
    @TestMetadata("setAsExtensionFunInClass.kt")
    public void testSetAsExtensionFunInClass() {
      runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFunInClass.kt");
    }

    @Test
    @TestMetadata("simpleVal.kt")
    public void testSimpleVal() {
      runTest("compiler/testData/codegen/box/delegatedProperty/simpleVal.kt");
    }

    @Test
    @TestMetadata("simpleVar.kt")
    public void testSimpleVar() {
      runTest("compiler/testData/codegen/box/delegatedProperty/simpleVar.kt");
    }

    @Test
    @TestMetadata("stackOverflowOnCallFromGetValue.kt")
    public void testStackOverflowOnCallFromGetValue() {
      runTest("compiler/testData/codegen/box/delegatedProperty/stackOverflowOnCallFromGetValue.kt");
    }

    @Test
    @TestMetadata("topLevelVal.kt")
    public void testTopLevelVal() {
      runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVal.kt");
    }

    @Test
    @TestMetadata("topLevelVar.kt")
    public void testTopLevelVar() {
      runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVar.kt");
    }

    @Test
    @TestMetadata("twoPropByOneDelegete.kt")
    public void testTwoPropByOneDelegete() {
      runTest("compiler/testData/codegen/box/delegatedProperty/twoPropByOneDelegete.kt");
    }

    @Test
    @TestMetadata("typeParameterInDelegatedProperty.kt")
    public void testTypeParameterInDelegatedProperty() {
      runTest("compiler/testData/codegen/box/delegatedProperty/typeParameterInDelegatedProperty.kt");
    }

    @Test
    @TestMetadata("useKPropertyLater.kt")
    public void testUseKPropertyLater() {
      runTest("compiler/testData/codegen/box/delegatedProperty/useKPropertyLater.kt");
    }

    @Test
    @TestMetadata("useReflectionOnKProperty.kt")
    public void testUseReflectionOnKProperty() {
      runTest("compiler/testData/codegen/box/delegatedProperty/useReflectionOnKProperty.kt");
    }

    @Test
    @TestMetadata("valByMapDelegatedProperty.kt")
    public void testValByMapDelegatedProperty() {
      runTest("compiler/testData/codegen/box/delegatedProperty/valByMapDelegatedProperty.kt");
    }

    @Test
    @TestMetadata("valInInnerClass.kt")
    public void testValInInnerClass() {
      runTest("compiler/testData/codegen/box/delegatedProperty/valInInnerClass.kt");
    }

    @Test
    @TestMetadata("varInInnerClass.kt")
    public void testVarInInnerClass() {
      runTest("compiler/testData/codegen/box/delegatedProperty/varInInnerClass.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty/delegateToAnother")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegateToAnother {
      @Test
      public void testAllFilesPresentInDelegateToAnother() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/delegateToAnother"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("custom.kt")
      public void testCustom() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/custom.kt");
      }

      @Test
      @TestMetadata("genericJavaProperty.kt")
      public void testGenericJavaProperty() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/genericJavaProperty.kt");
      }

      @Test
      @TestMetadata("kt49793_companionObject.kt")
      public void testKt49793_companionObject() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_companionObject.kt");
      }

      @Test
      @TestMetadata("kt49793_interfaceCompanionObject.kt")
      public void testKt49793_interfaceCompanionObject() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_interfaceCompanionObject.kt");
      }

      @Test
      @TestMetadata("kt49793_object.kt")
      public void testKt49793_object() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_object.kt");
      }

      @Test
      @TestMetadata("kt57955.kt")
      public void testKt57955() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt57955.kt");
      }

      @Test
      @TestMetadata("mutable.kt")
      public void testMutable() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/mutable.kt");
      }

      @Test
      @TestMetadata("openProperty.kt")
      public void testOpenProperty() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/openProperty.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/simple.kt");
      }

      @Test
      @TestMetadata("withSideEffects.kt")
      public void testWithSideEffects() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/withSideEffects.kt");
      }

      @Test
      @TestMetadata("withSideEffectsFromFileClass.kt")
      public void testWithSideEffectsFromFileClass() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/withSideEffectsFromFileClass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty/delegateToConst")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegateToConst {
      @Test
      public void testAllFilesPresentInDelegateToConst() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/delegateToConst"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("delegateToConst.kt")
      public void testDelegateToConst() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToConst/delegateToConst.kt");
      }

      @Test
      @TestMetadata("delegateToConstProperty.kt")
      public void testDelegateToConstProperty() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToConst/delegateToConstProperty.kt");
      }

      @Test
      @TestMetadata("delegateToNull.kt")
      public void testDelegateToNull() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToConst/delegateToNull.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegateToFinalProperty {
      @Test
      public void testAllFilesPresentInDelegateToFinalProperty() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("chain.kt")
      public void testChain() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/chain.kt");
      }

      @Test
      @TestMetadata("delegateToFinalInstanceProperty.kt")
      public void testDelegateToFinalInstanceProperty() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/delegateToFinalInstanceProperty.kt");
      }

      @Test
      @TestMetadata("delegateToFinalObjectProperty.kt")
      public void testDelegateToFinalObjectProperty() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/delegateToFinalObjectProperty.kt");
      }

      @Test
      @TestMetadata("delegateToFinalProperty.kt")
      public void testDelegateToFinalProperty() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/delegateToFinalProperty.kt");
      }

      @Test
      @TestMetadata("finalPropertyInAnotherFile.kt")
      public void testFinalPropertyInAnotherFile() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/finalPropertyInAnotherFile.kt");
      }

      @Test
      @TestMetadata("initializeContainerOfTopLevelProperties.kt")
      public void testInitializeContainerOfTopLevelProperties() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/initializeContainerOfTopLevelProperties.kt");
      }

      @Test
      @TestMetadata("kt54463_platformType.kt")
      public void testKt54463_platformType() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/kt54463_platformType.kt");
      }

      @Test
      @TestMetadata("memberExtensionPropertyAndImportFromObject.kt")
      public void testMemberExtensionPropertyAndImportFromObject() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/memberExtensionPropertyAndImportFromObject.kt");
      }

      @Test
      @TestMetadata("memberExtensionPropertyAndLocalDelegatedProperty.kt")
      public void testMemberExtensionPropertyAndLocalDelegatedProperty() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/memberExtensionPropertyAndLocalDelegatedProperty.kt");
      }

      @Test
      @TestMetadata("multimodule.kt")
      public void testMultimodule() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToFinalProperty/multimodule.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegateToSingleton {
      @Test
      public void testAllFilesPresentInDelegateToSingleton() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("delegateToEnum.kt")
      public void testDelegateToEnum() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton/delegateToEnum.kt");
      }

      @Test
      @TestMetadata("delegateToEnumInAClass.kt")
      public void testDelegateToEnumInAClass() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton/delegateToEnumInAClass.kt");
      }

      @Test
      @TestMetadata("delegateToSingleton.kt")
      public void testDelegateToSingleton() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton/delegateToSingleton.kt");
      }

      @Test
      @TestMetadata("noInitializationOfOuterClass.kt")
      public void testNoInitializationOfOuterClass() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton/noInitializationOfOuterClass.kt");
      }

      @Test
      @TestMetadata("withSideEffects.kt")
      public void testWithSideEffects() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton/withSideEffects.kt");
      }

      @Test
      @TestMetadata("withSideEffectsFromFileClass.kt")
      public void testWithSideEffectsFromFileClass() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton/withSideEffectsFromFileClass.kt");
      }

      @Test
      @TestMetadata("withSideEffectsToEnum.kt")
      public void testWithSideEffectsToEnum() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToSingleton/withSideEffectsToEnum.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty/delegateToThis")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegateToThis {
      @Test
      public void testAllFilesPresentInDelegateToThis() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/delegateToThis"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("delegateToOuterThis.kt")
      public void testDelegateToOuterThis() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToThis/delegateToOuterThis.kt");
      }

      @Test
      @TestMetadata("delegateToThis.kt")
      public void testDelegateToThis() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToThis/delegateToThis.kt");
      }

      @Test
      @TestMetadata("delegateToThisByExtension.kt")
      public void testDelegateToThisByExtension() {
        runTest("compiler/testData/codegen/box/delegatedProperty/delegateToThis/delegateToThisByExtension.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty/local")
    @TestDataPath("$PROJECT_ROOT")
    public class Local {
      @Test
      public void testAllFilesPresentInLocal() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("capturedLocalVal.kt")
      public void testCapturedLocalVal() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVal.kt");
      }

      @Test
      @TestMetadata("capturedLocalValNoInline.kt")
      public void testCapturedLocalValNoInline() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalValNoInline.kt");
      }

      @Test
      @TestMetadata("capturedLocalVar.kt")
      public void testCapturedLocalVar() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVar.kt");
      }

      @Test
      @TestMetadata("capturedLocalVarNoInline.kt")
      public void testCapturedLocalVarNoInline() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVarNoInline.kt");
      }

      @Test
      @TestMetadata("inlineGetValue.kt")
      public void testInlineGetValue() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineGetValue.kt");
      }

      @Test
      @TestMetadata("inlineOperators.kt")
      public void testInlineOperators() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineOperators.kt");
      }

      @Test
      @TestMetadata("kt12891.kt")
      public void testKt12891() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/kt12891.kt");
      }

      @Test
      @TestMetadata("kt13557.kt")
      public void testKt13557() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/kt13557.kt");
      }

      @Test
      @TestMetadata("kt16864.kt")
      public void testKt16864() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/kt16864.kt");
      }

      @Test
      @TestMetadata("kt19690.kt")
      public void testKt19690() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/kt19690.kt");
      }

      @Test
      @TestMetadata("kt21085.kt")
      public void testKt21085() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/kt21085.kt");
      }

      @Test
      @TestMetadata("kt23117.kt")
      public void testKt23117() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/kt23117.kt");
      }

      @Test
      @TestMetadata("localVal.kt")
      public void testLocalVal() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/localVal.kt");
      }

      @Test
      @TestMetadata("localValNoExplicitType.kt")
      public void testLocalValNoExplicitType() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/localValNoExplicitType.kt");
      }

      @Test
      @TestMetadata("localVar.kt")
      public void testLocalVar() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/localVar.kt");
      }

      @Test
      @TestMetadata("localVarNoExplicitType.kt")
      public void testLocalVarNoExplicitType() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/localVarNoExplicitType.kt");
      }

      @Test
      @TestMetadata("useReflectionForLocalVarInLambda.kt")
      public void testUseReflectionForLocalVarInLambda() {
        runTest("compiler/testData/codegen/box/delegatedProperty/local/useReflectionForLocalVarInLambda.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties")
    @TestDataPath("$PROJECT_ROOT")
    public class OptimizedDelegatedProperties {
      @Test
      public void testAllFilesPresentInOptimizedDelegatedProperties() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("definedInSources.kt")
      public void testDefinedInSources() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/definedInSources.kt");
      }

      @Test
      @TestMetadata("definedInSourcesWithNonNullParameter.kt")
      public void testDefinedInSourcesWithNonNullParameter() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/definedInSourcesWithNonNullParameter.kt");
      }

      @Test
      @TestMetadata("inSeparateModule.kt")
      public void testInSeparateModule() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/inSeparateModule.kt");
      }

      @Test
      @TestMetadata("inSeparateModuleWithNonNullParameter.kt")
      public void testInSeparateModuleWithNonNullParameter() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/inSeparateModuleWithNonNullParameter.kt");
      }

      @Test
      @TestMetadata("kt40815.kt")
      public void testKt40815() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815.kt");
      }

      @Test
      @TestMetadata("kt40815_2.kt")
      public void testKt40815_2() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815_2.kt");
      }

      @Test
      @TestMetadata("kt40815_3.kt")
      public void testKt40815_3() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815_3.kt");
      }

      @Test
      @TestMetadata("kt42253.kt")
      public void testKt42253() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt42253.kt");
      }

      @Test
      @TestMetadata("kt48825.kt")
      public void testKt48825() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt48825.kt");
      }

      @Test
      @TestMetadata("lazy.kt")
      public void testLazy() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/lazy.kt");
      }

      @Test
      @TestMetadata("mixedArgumentSizes.kt")
      public void testMixedArgumentSizes() {
        runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/mixedArgumentSizes.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty/provideDelegate")
    @TestDataPath("$PROJECT_ROOT")
    public class ProvideDelegate {
      @Test
      public void testAllFilesPresentInProvideDelegate() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("commonCaseForInference.kt")
      public void testCommonCaseForInference() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/commonCaseForInference.kt");
      }

      @Test
      @TestMetadata("delegatedPropertyWithIdProvideDelegate.kt")
      public void testDelegatedPropertyWithIdProvideDelegate() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/delegatedPropertyWithIdProvideDelegate.kt");
      }

      @Test
      @TestMetadata("differentReceivers.kt")
      public void testDifferentReceivers() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/differentReceivers.kt");
      }

      @Test
      @TestMetadata("evaluationOrder.kt")
      public void testEvaluationOrder() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrder.kt");
      }

      @Test
      @TestMetadata("evaluationOrderVar.kt")
      public void testEvaluationOrderVar() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrderVar.kt");
      }

      @Test
      @TestMetadata("extensionDelegated.kt")
      public void testExtensionDelegated() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/extensionDelegated.kt");
      }

      @Test
      @TestMetadata("generic.kt")
      public void testGeneric() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/generic.kt");
      }

      @Test
      @TestMetadata("genericDelegateWithNoAdditionalInfo.kt")
      public void testGenericDelegateWithNoAdditionalInfo() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/genericDelegateWithNoAdditionalInfo.kt");
      }

      @Test
      @TestMetadata("genericProvideDelegateOnNumberLiteral.kt")
      public void testGenericProvideDelegateOnNumberLiteral() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/genericProvideDelegateOnNumberLiteral.kt");
      }

      @Test
      @TestMetadata("hostCheck.kt")
      public void testHostCheck() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/hostCheck.kt");
      }

      @Test
      @TestMetadata("inClass.kt")
      public void testInClass() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inClass.kt");
      }

      @Test
      @TestMetadata("inferenceFromReceiver2.kt")
      public void testInferenceFromReceiver2() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inferenceFromReceiver2.kt");
      }

      @Test
      @TestMetadata("inlineProvideDelegate.kt")
      public void testInlineProvideDelegate() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inlineProvideDelegate.kt");
      }

      @Test
      @TestMetadata("jvmStaticInObject.kt")
      public void testJvmStaticInObject() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/jvmStaticInObject.kt");
      }

      @Test
      @TestMetadata("kt15437.kt")
      public void testKt15437() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt15437.kt");
      }

      @Test
      @TestMetadata("kt16441.kt")
      public void testKt16441() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt16441.kt");
      }

      @Test
      @TestMetadata("kt18902.kt")
      public void testKt18902() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt18902.kt");
      }

      @Test
      @TestMetadata("kt39588.kt")
      public void testKt39588() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt39588.kt");
      }

      @Test
      @TestMetadata("local.kt")
      public void testLocal() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/local.kt");
      }

      @Test
      @TestMetadata("localCaptured.kt")
      public void testLocalCaptured() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localCaptured.kt");
      }

      @Test
      @TestMetadata("localDifferentReceivers.kt")
      public void testLocalDifferentReceivers() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localDifferentReceivers.kt");
      }

      @Test
      @TestMetadata("memberExtension.kt")
      public void testMemberExtension() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/memberExtension.kt");
      }

      @Test
      @TestMetadata("notNullAssertionInLocalDelegated.kt")
      public void testNotNullAssertionInLocalDelegated() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/notNullAssertionInLocalDelegated.kt");
      }

      @Test
      @TestMetadata("propertyMetadata.kt")
      public void testPropertyMetadata() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/propertyMetadata.kt");
      }

      @Test
      @TestMetadata("provideDelegateByExtensionFunction.kt")
      public void testProvideDelegateByExtensionFunction() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/provideDelegateByExtensionFunction.kt");
      }

      @Test
      @TestMetadata("setValue.kt")
      public void testSetValue() {
        runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/setValue.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/delegation")
  @TestDataPath("$PROJECT_ROOT")
  public class Delegation {
    @Test
    public void testAllFilesPresentInDelegation() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("byMiddleInterface.kt")
    public void testByMiddleInterface() {
      runTest("compiler/testData/codegen/box/delegation/byMiddleInterface.kt");
    }

    @Test
    @TestMetadata("computeIfAbsent.kt")
    public void testComputeIfAbsent() {
      runTest("compiler/testData/codegen/box/delegation/computeIfAbsent.kt");
    }

    @Test
    @TestMetadata("defaultOverride.kt")
    public void testDefaultOverride() {
      runTest("compiler/testData/codegen/box/delegation/defaultOverride.kt");
    }

    @Test
    @TestMetadata("delegatedAnonymousObject_noParametersOnDelegate.kt")
    public void testDelegatedAnonymousObject_noParametersOnDelegate() {
      runTest("compiler/testData/codegen/box/delegation/delegatedAnonymousObject_noParametersOnDelegate.kt");
    }

    @Test
    @TestMetadata("delegatedAnonymousObject_someParametersOnDelegate.kt")
    public void testDelegatedAnonymousObject_someParametersOnDelegate() {
      runTest("compiler/testData/codegen/box/delegation/delegatedAnonymousObject_someParametersOnDelegate.kt");
    }

    @Test
    @TestMetadata("delegationAndInheritanceFromJava.kt")
    public void testDelegationAndInheritanceFromJava() {
      runTest("compiler/testData/codegen/box/delegation/delegationAndInheritanceFromJava.kt");
    }

    @Test
    @TestMetadata("delegationDifferentModule.kt")
    public void testDelegationDifferentModule() {
      runTest("compiler/testData/codegen/box/delegation/delegationDifferentModule.kt");
    }

    @Test
    @TestMetadata("delegationDifferentModule2.kt")
    public void testDelegationDifferentModule2() {
      runTest("compiler/testData/codegen/box/delegation/delegationDifferentModule2.kt");
    }

    @Test
    @TestMetadata("delegationToIntersectionType.kt")
    public void testDelegationToIntersectionType() {
      runTest("compiler/testData/codegen/box/delegation/delegationToIntersectionType.kt");
    }

    @Test
    @TestMetadata("delegationToIntersectionType2.kt")
    public void testDelegationToIntersectionType2() {
      runTest("compiler/testData/codegen/box/delegation/delegationToIntersectionType2.kt");
    }

    @Test
    @TestMetadata("delegationToMap.kt")
    public void testDelegationToMap() {
      runTest("compiler/testData/codegen/box/delegation/delegationToMap.kt");
    }

    @Test
    @TestMetadata("delegationToVal.kt")
    public void testDelegationToVal() {
      runTest("compiler/testData/codegen/box/delegation/delegationToVal.kt");
    }

    @Test
    @TestMetadata("delegationToVar.kt")
    public void testDelegationToVar() {
      runTest("compiler/testData/codegen/box/delegation/delegationToVar.kt");
    }

    @Test
    @TestMetadata("delegationWithPrivateConstructor.kt")
    public void testDelegationWithPrivateConstructor() {
      runTest("compiler/testData/codegen/box/delegation/delegationWithPrivateConstructor.kt");
    }

    @Test
    @TestMetadata("diamond.kt")
    public void testDiamond() {
      runTest("compiler/testData/codegen/box/delegation/diamond.kt");
    }

    @Test
    @TestMetadata("diamond2.kt")
    public void testDiamond2() {
      runTest("compiler/testData/codegen/box/delegation/diamond2.kt");
    }

    @Test
    @TestMetadata("differentModules.kt")
    public void testDifferentModules() {
      runTest("compiler/testData/codegen/box/delegation/differentModules.kt");
    }

    @Test
    @TestMetadata("doubleDelegationEqualsHashcode.kt")
    public void testDoubleDelegationEqualsHashcode() {
      runTest("compiler/testData/codegen/box/delegation/doubleDelegationEqualsHashcode.kt");
    }

    @Test
    @TestMetadata("genericFunctionInGenericInterface.kt")
    public void testGenericFunctionInGenericInterface() {
      runTest("compiler/testData/codegen/box/delegation/genericFunctionInGenericInterface.kt");
    }

    @Test
    @TestMetadata("genericProperty.kt")
    public void testGenericProperty() {
      runTest("compiler/testData/codegen/box/delegation/genericProperty.kt");
    }

    @Test
    @TestMetadata("hiddenSuperOverrideIn1.0.kt")
    public void testHiddenSuperOverrideIn1_0() {
      runTest("compiler/testData/codegen/box/delegation/hiddenSuperOverrideIn1.0.kt");
    }

    @Test
    @TestMetadata("ifWithCallableReferenceInLazy.kt")
    public void testIfWithCallableReferenceInLazy() {
      runTest("compiler/testData/codegen/box/delegation/ifWithCallableReferenceInLazy.kt");
    }

    @Test
    @TestMetadata("inClassDeclaration.kt")
    public void testInClassDeclaration() {
      runTest("compiler/testData/codegen/box/delegation/inClassDeclaration.kt");
    }

    @Test
    @TestMetadata("inDataClass.kt")
    public void testInDataClass() {
      runTest("compiler/testData/codegen/box/delegation/inDataClass.kt");
    }

    @Test
    @TestMetadata("inlineClassProperty.kt")
    public void testInlineClassProperty() {
      runTest("compiler/testData/codegen/box/delegation/inlineClassProperty.kt");
    }

    @Test
    @TestMetadata("kt30102_comparable.kt")
    public void testKt30102_comparable() {
      runTest("compiler/testData/codegen/box/delegation/kt30102_comparable.kt");
    }

    @Test
    @TestMetadata("kt44199.kt")
    public void testKt44199() {
      runTest("compiler/testData/codegen/box/delegation/kt44199.kt");
    }

    @Test
    @TestMetadata("kt54654.kt")
    public void testKt54654() {
      runTest("compiler/testData/codegen/box/delegation/kt54654.kt");
    }

    @Test
    @TestMetadata("kt8154.kt")
    public void testKt8154() {
      runTest("compiler/testData/codegen/box/delegation/kt8154.kt");
    }

    @Test
    @TestMetadata("mixed.kt")
    public void testMixed() {
      runTest("compiler/testData/codegen/box/delegation/mixed.kt");
    }

    @Test
    @TestMetadata("nestedNameClash.kt")
    public void testNestedNameClash() {
      runTest("compiler/testData/codegen/box/delegation/nestedNameClash.kt");
    }

    @Test
    @TestMetadata("nestedNameClash2.kt")
    public void testNestedNameClash2() {
      runTest("compiler/testData/codegen/box/delegation/nestedNameClash2.kt");
    }

    @Test
    @TestMetadata("sealedClass.kt")
    public void testSealedClass() {
      runTest("compiler/testData/codegen/box/delegation/sealedClass.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/delegation/simple.kt");
    }

    @Test
    @TestMetadata("smartCastedDelegation.kt")
    public void testSmartCastedDelegation() {
      runTest("compiler/testData/codegen/box/delegation/smartCastedDelegation.kt");
    }

    @Test
    @TestMetadata("valueClassImplementingJavaInterfaceWithDefault.kt")
    public void testValueClassImplementingJavaInterfaceWithDefault() {
      runTest("compiler/testData/codegen/box/delegation/valueClassImplementingJavaInterfaceWithDefault.kt");
    }

    @Test
    @TestMetadata("viaTypeAlias.kt")
    public void testViaTypeAlias() {
      runTest("compiler/testData/codegen/box/delegation/viaTypeAlias.kt");
    }

    @Test
    @TestMetadata("withDefaultParameters.kt")
    public void testWithDefaultParameters() {
      runTest("compiler/testData/codegen/box/delegation/withDefaultParameters.kt");
    }

    @Test
    @TestMetadata("withDefaultsMultipleFilesOrder.kt")
    public void testWithDefaultsMultipleFilesOrder() {
      runTest("compiler/testData/codegen/box/delegation/withDefaultsMultipleFilesOrder.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/deprecated")
  @TestDataPath("$PROJECT_ROOT")
  public class Deprecated {
    @Test
    public void testAllFilesPresentInDeprecated() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("deprecatedSinceKotlin.kt")
    public void testDeprecatedSinceKotlin() {
      runTest("compiler/testData/codegen/box/deprecated/deprecatedSinceKotlin.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam")
  @TestDataPath("$PROJECT_ROOT")
  public class DestructuringDeclInLambdaParam {
    @Test
    public void testAllFilesPresentInDestructuringDeclInLambdaParam() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/destructuringDeclInLambdaParam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("extensionComponents.kt")
    public void testExtensionComponents() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/extensionComponents.kt");
    }

    @Test
    @TestMetadata("generic.kt")
    public void testGeneric() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/generic.kt");
    }

    @Test
    @TestMetadata("inline.kt")
    public void testInline() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/inline.kt");
    }

    @Test
    @TestMetadata("lambdaInLambda.kt")
    public void testLambdaInLambda() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/lambdaInLambda.kt");
    }

    @Test
    @TestMetadata("otherParameters.kt")
    public void testOtherParameters() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/otherParameters.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/simple.kt");
    }

    @Test
    @TestMetadata("stdlibUsages.kt")
    public void testStdlibUsages() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/stdlibUsages.kt");
    }

    @Test
    @TestMetadata("underscoreNames.kt")
    public void testUnderscoreNames() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/underscoreNames.kt");
    }

    @Test
    @TestMetadata("withIndexed.kt")
    public void testWithIndexed() {
      runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/withIndexed.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/devirtualization")
  @TestDataPath("$PROJECT_ROOT")
  public class Devirtualization {
    @Test
    public void testAllFilesPresentInDevirtualization() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/devirtualization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("anonymousObject.kt")
    public void testAnonymousObject() {
      runTest("compiler/testData/codegen/box/devirtualization/anonymousObject.kt");
    }

    @Test
    @TestMetadata("getter_looking_as_box_function.kt")
    public void testGetter_looking_as_box_function() {
      runTest("compiler/testData/codegen/box/devirtualization/getter_looking_as_box_function.kt");
    }

    @Test
    @TestMetadata("inline_getter.kt")
    public void testInline_getter() {
      runTest("compiler/testData/codegen/box/devirtualization/inline_getter.kt");
    }

    @Test
    @TestMetadata("kt67218c.kt")
    public void testKt67218c() {
      runTest("compiler/testData/codegen/box/devirtualization/kt67218c.kt");
    }

    @Test
    @TestMetadata("kt67218i.kt")
    public void testKt67218i() {
      runTest("compiler/testData/codegen/box/devirtualization/kt67218i.kt");
    }

    @Test
    @TestMetadata("lateinitInterface.kt")
    public void testLateinitInterface() {
      runTest("compiler/testData/codegen/box/devirtualization/lateinitInterface.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/diagnostics")
  @TestDataPath("$PROJECT_ROOT")
  public class Diagnostics {
    @Test
    public void testAllFilesPresentInDiagnostics() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/diagnostics/functions")
    @TestDataPath("$PROJECT_ROOT")
    public class Functions {
      @Test
      public void testAllFilesPresentInFunctions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/inference")
      @TestDataPath("$PROJECT_ROOT")
      public class Inference {
        @Test
        public void testAllFilesPresentInInference() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/inference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt6176.kt")
        public void testKt6176() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/inference/kt6176.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke")
      @TestDataPath("$PROJECT_ROOT")
      public class Invoke {
        @Test
        public void testAllFilesPresentInInvoke() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects")
        @TestDataPath("$PROJECT_ROOT")
        public class OnObjects {
          @Test
          public void testAllFilesPresentInOnObjects() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Test
          @TestMetadata("invokeOnClassObject1.kt")
          public void testInvokeOnClassObject1() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject1.kt");
          }

          @Test
          @TestMetadata("invokeOnClassObject2.kt")
          public void testInvokeOnClassObject2() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject2.kt");
          }

          @Test
          @TestMetadata("invokeOnClassObjectOfNestedClass1.kt")
          public void testInvokeOnClassObjectOfNestedClass1() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass1.kt");
          }

          @Test
          @TestMetadata("invokeOnClassObjectOfNestedClass2.kt")
          public void testInvokeOnClassObjectOfNestedClass2() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass2.kt");
          }

          @Test
          @TestMetadata("invokeOnEnum1.kt")
          public void testInvokeOnEnum1() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum1.kt");
          }

          @Test
          @TestMetadata("invokeOnEnum2.kt")
          public void testInvokeOnEnum2() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum2.kt");
          }

          @Test
          @TestMetadata("invokeOnImportedEnum1.kt")
          public void testInvokeOnImportedEnum1() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum1.kt");
          }

          @Test
          @TestMetadata("invokeOnImportedEnum2.kt")
          public void testInvokeOnImportedEnum2() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum2.kt");
          }

          @Test
          @TestMetadata("invokeOnObject1.kt")
          public void testInvokeOnObject1() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject1.kt");
          }

          @Test
          @TestMetadata("invokeOnObject2.kt")
          public void testInvokeOnObject2() {
            runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject2.kt");
          }
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion")
      @TestDataPath("$PROJECT_ROOT")
      public class TailRecursion {
        @Test
        public void testAllFilesPresentInTailRecursion() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/tailRecursion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("defaultArgs.kt")
        public void testDefaultArgs() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs.kt");
        }

        @Test
        @TestMetadata("defaultArgs2.kt")
        public void testDefaultArgs2() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs2.kt");
        }

        @Test
        @TestMetadata("defaultArgsOverridden.kt")
        public void testDefaultArgsOverridden() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsOverridden.kt");
        }

        @Test
        @TestMetadata("defaultArgsWithSideEffects.kt")
        public void testDefaultArgsWithSideEffects() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffects.kt");
        }

        @Test
        @TestMetadata("defaultArgsWithSideEffects2.kt")
        public void testDefaultArgsWithSideEffects2() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffects2.kt");
        }

        @Test
        @TestMetadata("extensionTailCall.kt")
        public void testExtensionTailCall() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/extensionTailCall.kt");
        }

        @Test
        @TestMetadata("functionWithNoTails.kt")
        public void testFunctionWithNoTails() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNoTails.kt");
        }

        @Test
        @TestMetadata("functionWithNonTailRecursions.kt")
        public void testFunctionWithNonTailRecursions() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNonTailRecursions.kt");
        }

        @Test
        @TestMetadata("functionWithoutAnnotation.kt")
        public void testFunctionWithoutAnnotation() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithoutAnnotation.kt");
        }

        @Test
        @TestMetadata("infixCall.kt")
        public void testInfixCall() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixCall.kt");
        }

        @Test
        @TestMetadata("infixRecursiveCall.kt")
        public void testInfixRecursiveCall() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixRecursiveCall.kt");
        }

        @Test
        @TestMetadata("insideElvis.kt")
        public void testInsideElvis() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/insideElvis.kt");
        }

        @Test
        @TestMetadata("kt47084_lambdaInDefaultArgument.kt")
        public void testKt47084_lambdaInDefaultArgument() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/kt47084_lambdaInDefaultArgument.kt");
        }

        @Test
        @TestMetadata("labeledThisReferences.kt")
        public void testLabeledThisReferences() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/labeledThisReferences.kt");
        }

        @Test
        @TestMetadata("loops.kt")
        public void testLoops() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/loops.kt");
        }

        @Test
        @TestMetadata("multilevelBlocks.kt")
        public void testMultilevelBlocks() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/multilevelBlocks.kt");
        }

        @Test
        @TestMetadata("realIteratorFoldl.kt")
        public void testRealIteratorFoldl() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realIteratorFoldl.kt");
        }

        @Test
        @TestMetadata("realStringEscape.kt")
        public void testRealStringEscape() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringEscape.kt");
        }

        @Test
        @TestMetadata("realStringRepeat.kt")
        public void testRealStringRepeat() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringRepeat.kt");
        }

        @Test
        @TestMetadata("recursiveCallInInlineLambda.kt")
        public void testRecursiveCallInInlineLambda() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInInlineLambda.kt");
        }

        @Test
        @TestMetadata("recursiveCallInInlineLambdaWithCapture.kt")
        public void testRecursiveCallInInlineLambdaWithCapture() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInInlineLambdaWithCapture.kt");
        }

        @Test
        @TestMetadata("recursiveCallInLambda.kt")
        public void testRecursiveCallInLambda() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLambda.kt");
        }

        @Test
        @TestMetadata("recursiveCallInLocalFunction.kt")
        public void testRecursiveCallInLocalFunction() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLocalFunction.kt");
        }

        @Test
        @TestMetadata("recursiveInnerFunction.kt")
        public void testRecursiveInnerFunction() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveInnerFunction.kt");
        }

        @Test
        @TestMetadata("returnIf.kt")
        public void testReturnIf() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnIf.kt");
        }

        @Test
        @TestMetadata("returnInCatch.kt")
        public void testReturnInCatch() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInCatch.kt");
        }

        @Test
        @TestMetadata("returnInFinally.kt")
        public void testReturnInFinally() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInFinally.kt");
        }

        @Test
        @TestMetadata("returnInIfInFinally.kt")
        public void testReturnInIfInFinally() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInIfInFinally.kt");
        }

        @Test
        @TestMetadata("returnInParentheses.kt")
        public void testReturnInParentheses() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInParentheses.kt");
        }

        @Test
        @TestMetadata("returnInTry.kt")
        public void testReturnInTry() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInTry.kt");
        }

        @Test
        @TestMetadata("simpleBlock.kt")
        public void testSimpleBlock() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleBlock.kt");
        }

        @Test
        @TestMetadata("simpleReturn.kt")
        public void testSimpleReturn() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturn.kt");
        }

        @Test
        @TestMetadata("simpleReturnWithElse.kt")
        public void testSimpleReturnWithElse() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturnWithElse.kt");
        }

        @Test
        @TestMetadata("sum.kt")
        public void testSum() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/sum.kt");
        }

        @Test
        @TestMetadata("tailCallInBlockInParentheses.kt")
        public void testTailCallInBlockInParentheses() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInBlockInParentheses.kt");
        }

        @Test
        @TestMetadata("tailCallInParentheses.kt")
        public void testTailCallInParentheses() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInParentheses.kt");
        }

        @Test
        @TestMetadata("tailRecursionInFinally.kt")
        public void testTailRecursionInFinally() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailRecursionInFinally.kt");
        }

        @Test
        @TestMetadata("tailrecWithExplicitCompanionObjectDispatcher.kt")
        public void testTailrecWithExplicitCompanionObjectDispatcher() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailrecWithExplicitCompanionObjectDispatcher.kt");
        }

        @Test
        @TestMetadata("tailrecWithExplicitObjectDispatcher.kt")
        public void testTailrecWithExplicitObjectDispatcher() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailrecWithExplicitObjectDispatcher.kt");
        }

        @Test
        @TestMetadata("thisReferences.kt")
        public void testThisReferences() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/thisReferences.kt");
        }

        @Test
        @TestMetadata("unitBlocks.kt")
        public void testUnitBlocks() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/unitBlocks.kt");
        }

        @Test
        @TestMetadata("whenWithCondition.kt")
        public void testWhenWithCondition() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithCondition.kt");
        }

        @Test
        @TestMetadata("whenWithInRange.kt")
        public void testWhenWithInRange() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithInRange.kt");
        }

        @Test
        @TestMetadata("whenWithIs.kt")
        public void testWhenWithIs() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithIs.kt");
        }

        @Test
        @TestMetadata("whenWithoutCondition.kt")
        public void testWhenWithoutCondition() {
          runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithoutCondition.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/diagnostics/vararg")
    @TestDataPath("$PROJECT_ROOT")
    public class Vararg {
      @Test
      public void testAllFilesPresentInVararg() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/vararg"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt4172.kt")
      public void testKt4172() {
        runTest("compiler/testData/codegen/box/diagnostics/vararg/kt4172.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/differentDependencyVersion")
  @TestDataPath("$PROJECT_ROOT")
  public class DifferentDependencyVersion {
    @Test
    public void testAllFilesPresentInDifferentDependencyVersion() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/differentDependencyVersion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("kt51194_java.kt")
    public void testKt51194_java() {
      runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_java.kt");
    }

    @Test
    @TestMetadata("kt51194_javaAndKotlin.kt")
    public void testKt51194_javaAndKotlin() {
      runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_javaAndKotlin.kt");
    }

    @Test
    @TestMetadata("kt51194_kotlin.kt")
    public void testKt51194_kotlin() {
      runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_kotlin.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/directInvokeOptimization")
  @TestDataPath("$PROJECT_ROOT")
  public class DirectInvokeOptimization {
    @Test
    public void testAllFilesPresentInDirectInvokeOptimization() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/directInvokeOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("boundInnerContructorRef.kt")
    public void testBoundInnerContructorRef() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/boundInnerContructorRef.kt");
    }

    @Test
    @TestMetadata("boundMemberRef.kt")
    public void testBoundMemberRef() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/boundMemberRef.kt");
    }

    @Test
    @TestMetadata("canary.kt")
    public void testCanary() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/canary.kt");
    }

    @Test
    @TestMetadata("capturingLambda.kt")
    public void testCapturingLambda() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/capturingLambda.kt");
    }

    @Test
    @TestMetadata("contructorRef.kt")
    public void testContructorRef() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/contructorRef.kt");
    }

    @Test
    @TestMetadata("kt53202.kt")
    public void testKt53202() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/kt53202.kt");
    }

    @Test
    @TestMetadata("kt53202_funLiteral.kt")
    public void testKt53202_funLiteral() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/kt53202_funLiteral.kt");
    }

    @Test
    @TestMetadata("kt53202_returns.kt")
    public void testKt53202_returns() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/kt53202_returns.kt");
    }

    @Test
    @TestMetadata("nestedLambdas.kt")
    public void testNestedLambdas() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/nestedLambdas.kt");
    }

    @Test
    @TestMetadata("simpleAnonymousFun.kt")
    public void testSimpleAnonymousFun() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleAnonymousFun.kt");
    }

    @Test
    @TestMetadata("simpleFunRef.kt")
    public void testSimpleFunRef() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleFunRef.kt");
    }

    @Test
    @TestMetadata("simpleLambda.kt")
    public void testSimpleLambda() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleLambda.kt");
    }

    @Test
    @TestMetadata("unboundInnerContructorRef.kt")
    public void testUnboundInnerContructorRef() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/unboundInnerContructorRef.kt");
    }

    @Test
    @TestMetadata("unboundMemberRef.kt")
    public void testUnboundMemberRef() {
      runTest("compiler/testData/codegen/box/directInvokeOptimization/unboundMemberRef.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/elvis")
  @TestDataPath("$PROJECT_ROOT")
  public class Elvis {
    @Test
    public void testAllFilesPresentInElvis() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/elvis"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("genericElvisWithMoreSpecificLHS.kt")
    public void testGenericElvisWithMoreSpecificLHS() {
      runTest("compiler/testData/codegen/box/elvis/genericElvisWithMoreSpecificLHS.kt");
    }

    @Test
    @TestMetadata("genericElvisWithNullLHS.kt")
    public void testGenericElvisWithNullLHS() {
      runTest("compiler/testData/codegen/box/elvis/genericElvisWithNullLHS.kt");
    }

    @Test
    @TestMetadata("genericNull.kt")
    public void testGenericNull() {
      runTest("compiler/testData/codegen/box/elvis/genericNull.kt");
    }

    @Test
    @TestMetadata("kt24209.kt")
    public void testKt24209() {
      runTest("compiler/testData/codegen/box/elvis/kt24209.kt");
    }

    @Test
    @TestMetadata("kt6694ExactAnnotationForElvis.kt")
    public void testKt6694ExactAnnotationForElvis() {
      runTest("compiler/testData/codegen/box/elvis/kt6694ExactAnnotationForElvis.kt");
    }

    @Test
    @TestMetadata("nullNullOk.kt")
    public void testNullNullOk() {
      runTest("compiler/testData/codegen/box/elvis/nullNullOk.kt");
    }

    @Test
    @TestMetadata("ofNonNullableResultType.kt")
    public void testOfNonNullableResultType() {
      runTest("compiler/testData/codegen/box/elvis/ofNonNullableResultType.kt");
    }

    @Test
    @TestMetadata("primitive.kt")
    public void testPrimitive() {
      runTest("compiler/testData/codegen/box/elvis/primitive.kt");
    }

    @Test
    @TestMetadata("withNothingConstraintAndExpectedType.kt")
    public void testWithNothingConstraintAndExpectedType() {
      runTest("compiler/testData/codegen/box/elvis/withNothingConstraintAndExpectedType.kt");
    }

    @Test
    @TestMetadata("withReturn.kt")
    public void testWithReturn() {
      runTest("compiler/testData/codegen/box/elvis/withReturn.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/enum")
  @TestDataPath("$PROJECT_ROOT")
  public class Enum {
    @Test
    @TestMetadata("abstractMethodInEnum.kt")
    public void testAbstractMethodInEnum() {
      runTest("compiler/testData/codegen/box/enum/abstractMethodInEnum.kt");
    }

    @Test
    @TestMetadata("abstractNestedClass.kt")
    public void testAbstractNestedClass() {
      runTest("compiler/testData/codegen/box/enum/abstractNestedClass.kt");
    }

    @Test
    public void testAllFilesPresentInEnum() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotatedParameter.kt")
    public void testAnnotatedParameter() {
      runTest("compiler/testData/codegen/box/enum/annotatedParameter.kt");
    }

    @Test
    @TestMetadata("annotatedParameter2.kt")
    public void testAnnotatedParameter2() {
      runTest("compiler/testData/codegen/box/enum/annotatedParameter2.kt");
    }

    @Test
    @TestMetadata("asReturnExpression.kt")
    public void testAsReturnExpression() {
      runTest("compiler/testData/codegen/box/enum/asReturnExpression.kt");
    }

    @Test
    @TestMetadata("bigEnum.kt")
    public void testBigEnum() {
      runTest("compiler/testData/codegen/box/enum/bigEnum.kt");
    }

    @Test
    @TestMetadata("classForEnumEntry.kt")
    public void testClassForEnumEntry() {
      runTest("compiler/testData/codegen/box/enum/classForEnumEntry.kt");
    }

    @Test
    @TestMetadata("companionAccessingEnumValue.kt")
    public void testCompanionAccessingEnumValue() {
      runTest("compiler/testData/codegen/box/enum/companionAccessingEnumValue.kt");
    }

    @Test
    @TestMetadata("companionObject.kt")
    public void testCompanionObject() {
      runTest("compiler/testData/codegen/box/enum/companionObject.kt");
    }

    @Test
    @TestMetadata("companionObjectInEnum.kt")
    public void testCompanionObjectInEnum() {
      runTest("compiler/testData/codegen/box/enum/companionObjectInEnum.kt");
    }

    @Test
    @TestMetadata("constructorWithReordering.kt")
    public void testConstructorWithReordering() {
      runTest("compiler/testData/codegen/box/enum/constructorWithReordering.kt");
    }

    @Test
    @TestMetadata("declaringClassOnEnumObject.kt")
    public void testDeclaringClassOnEnumObject() {
      runTest("compiler/testData/codegen/box/enum/declaringClassOnEnumObject.kt");
    }

    @Test
    @TestMetadata("deepInnerClassInEnumEntryClass.kt")
    public void testDeepInnerClassInEnumEntryClass() {
      runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass.kt");
    }

    @Test
    @TestMetadata("deepInnerClassInEnumEntryClass2.kt")
    public void testDeepInnerClassInEnumEntryClass2() {
      runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass2.kt");
    }

    @Test
    @TestMetadata("emptyConstructor.kt")
    public void testEmptyConstructor() {
      runTest("compiler/testData/codegen/box/enum/emptyConstructor.kt");
    }

    @Test
    @TestMetadata("emptyEnumValuesValueOf.kt")
    public void testEmptyEnumValuesValueOf() {
      runTest("compiler/testData/codegen/box/enum/emptyEnumValuesValueOf.kt");
    }

    @Test
    @TestMetadata("enumCompanionInit.kt")
    public void testEnumCompanionInit() {
      runTest("compiler/testData/codegen/box/enum/enumCompanionInit.kt");
    }

    @Test
    @TestMetadata("enumConstructorParameterClashWithDefaults.kt")
    public void testEnumConstructorParameterClashWithDefaults() {
      runTest("compiler/testData/codegen/box/enum/enumConstructorParameterClashWithDefaults.kt");
    }

    @Test
    @TestMetadata("enumEntries.kt")
    public void testEnumEntries() {
      runTest("compiler/testData/codegen/box/enum/enumEntries.kt");
    }

    @Test
    @TestMetadata("enumEntriesCompatibilityCheck.kt")
    public void testEnumEntriesCompatibilityCheck() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesCompatibilityCheck.kt");
    }

    @Test
    @TestMetadata("enumEntriesCompatibilityCheckPrioritized.kt")
    public void testEnumEntriesCompatibilityCheckPrioritized() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesCompatibilityCheckPrioritized.kt");
    }

    @Test
    @TestMetadata("enumEntriesFromJava.kt")
    public void testEnumEntriesFromJava() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesFromJava.kt");
    }

    @Test
    @TestMetadata("enumEntriesInCompanion.kt")
    public void testEnumEntriesInCompanion() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesInCompanion.kt");
    }

    @Test
    @TestMetadata("enumEntriesIntrinsicForJava.kt")
    public void testEnumEntriesIntrinsicForJava() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesIntrinsicForJava.kt");
    }

    @Test
    @TestMetadata("enumEntriesIntrinsicMultipleEnums.kt")
    public void testEnumEntriesIntrinsicMultipleEnums() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesIntrinsicMultipleEnums.kt");
    }

    @Test
    @TestMetadata("enumEntriesIntrinsicWithoutFeature.kt")
    public void testEnumEntriesIntrinsicWithoutFeature() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesIntrinsicWithoutFeature.kt");
    }

    @Test
    @TestMetadata("enumEntriesMultimodule.kt")
    public void testEnumEntriesMultimodule() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesMultimodule.kt");
    }

    @Test
    @TestMetadata("enumEntriesMultimoduleMultipleMappings.kt")
    public void testEnumEntriesMultimoduleMultipleMappings() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesMultimoduleMultipleMappings.kt");
    }

    @Test
    @TestMetadata("enumEntriesMultimoduleMultipleMappingsForMultipleClassfiles.kt")
    public void testEnumEntriesMultimoduleMultipleMappingsForMultipleClassfiles() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesMultimoduleMultipleMappingsForMultipleClassfiles.kt");
    }

    @Test
    @TestMetadata("enumEntriesMultimoduleNoMappings.kt")
    public void testEnumEntriesMultimoduleNoMappings() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesMultimoduleNoMappings.kt");
    }

    @Test
    @TestMetadata("enumEntriesNameClashes.kt")
    public void testEnumEntriesNameClashes() {
      runTest("compiler/testData/codegen/box/enum/enumEntriesNameClashes.kt");
    }

    @Test
    @TestMetadata("enumEntryHashCode.kt")
    public void testEnumEntryHashCode() {
      runTest("compiler/testData/codegen/box/enum/enumEntryHashCode.kt");
    }

    @Test
    @TestMetadata("enumEntryMembers.kt")
    public void testEnumEntryMembers() {
      runTest("compiler/testData/codegen/box/enum/enumEntryMembers.kt");
    }

    @Test
    @TestMetadata("enumEntryReferenceFromInnerClassConstructor1.kt")
    public void testEnumEntryReferenceFromInnerClassConstructor1() {
      runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor1.kt");
    }

    @Test
    @TestMetadata("enumEntryReferenceFromInnerClassConstructor2.kt")
    public void testEnumEntryReferenceFromInnerClassConstructor2() {
      runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor2.kt");
    }

    @Test
    @TestMetadata("enumEntryReferenceFromInnerClassConstructor3.kt")
    public void testEnumEntryReferenceFromInnerClassConstructor3() {
      runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor3.kt");
    }

    @Test
    @TestMetadata("enumInheritedFromTrait.kt")
    public void testEnumInheritedFromTrait() {
      runTest("compiler/testData/codegen/box/enum/enumInheritedFromTrait.kt");
    }

    @Test
    @TestMetadata("enumMultiModule.kt")
    public void testEnumMultiModule() {
      runTest("compiler/testData/codegen/box/enum/enumMultiModule.kt");
    }

    @Test
    @TestMetadata("enumShort.kt")
    public void testEnumShort() {
      runTest("compiler/testData/codegen/box/enum/enumShort.kt");
    }

    @Test
    @TestMetadata("enumValueOf.kt")
    public void testEnumValueOf() {
      runTest("compiler/testData/codegen/box/enum/enumValueOf.kt");
    }

    @Test
    @TestMetadata("enumWithLambdaParameter.kt")
    public void testEnumWithLambdaParameter() {
      runTest("compiler/testData/codegen/box/enum/enumWithLambdaParameter.kt");
    }

    @Test
    @TestMetadata("enum_equals.kt")
    public void testEnum_equals() {
      runTest("compiler/testData/codegen/box/enum/enum_equals.kt");
    }

    @Test
    @TestMetadata("getEnumEntityByOrdinal.kt")
    public void testGetEnumEntityByOrdinal() {
      runTest("compiler/testData/codegen/box/enum/getEnumEntityByOrdinal.kt");
    }

    @Test
    @TestMetadata("inPackage.kt")
    public void testInPackage() {
      runTest("compiler/testData/codegen/box/enum/inPackage.kt");
    }

    @Test
    @TestMetadata("inclassobj.kt")
    public void testInclassobj() {
      runTest("compiler/testData/codegen/box/enum/inclassobj.kt");
    }

    @Test
    @TestMetadata("initEntriesInCompanionObject.kt")
    public void testInitEntriesInCompanionObject() {
      runTest("compiler/testData/codegen/box/enum/initEntriesInCompanionObject.kt");
    }

    @Test
    @TestMetadata("initEntriesInCompanionObject2.kt")
    public void testInitEntriesInCompanionObject2() {
      runTest("compiler/testData/codegen/box/enum/initEntriesInCompanionObject2.kt");
    }

    @Test
    @TestMetadata("initEntriesInValueOf.kt")
    public void testInitEntriesInValueOf() {
      runTest("compiler/testData/codegen/box/enum/initEntriesInValueOf.kt");
    }

    @Test
    @TestMetadata("initEnumAfterObjectAccess.kt")
    public void testInitEnumAfterObjectAccess() {
      runTest("compiler/testData/codegen/box/enum/initEnumAfterObjectAccess.kt");
    }

    @Test
    @TestMetadata("inner.kt")
    public void testInner() {
      runTest("compiler/testData/codegen/box/enum/inner.kt");
    }

    @Test
    @TestMetadata("innerClassInEnumEntryClass.kt")
    public void testInnerClassInEnumEntryClass() {
      runTest("compiler/testData/codegen/box/enum/innerClassInEnumEntryClass.kt");
    }

    @Test
    @TestMetadata("innerClassMethodInEnumEntryClass.kt")
    public void testInnerClassMethodInEnumEntryClass() {
      runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass.kt");
    }

    @Test
    @TestMetadata("innerClassMethodInEnumEntryClass2.kt")
    public void testInnerClassMethodInEnumEntryClass2() {
      runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass2.kt");
    }

    @Test
    @TestMetadata("innerWithExistingClassObject.kt")
    public void testInnerWithExistingClassObject() {
      runTest("compiler/testData/codegen/box/enum/innerWithExistingClassObject.kt");
    }

    @Test
    @TestMetadata("interfaceCallNoEntryClass.kt")
    public void testInterfaceCallNoEntryClass() {
      runTest("compiler/testData/codegen/box/enum/interfaceCallNoEntryClass.kt");
    }

    @Test
    @TestMetadata("interfaceCallWithEntryClass.kt")
    public void testInterfaceCallWithEntryClass() {
      runTest("compiler/testData/codegen/box/enum/interfaceCallWithEntryClass.kt");
    }

    @Test
    @TestMetadata("javaClassWithNestedEnum.kt")
    public void testJavaClassWithNestedEnum() {
      runTest("compiler/testData/codegen/box/enum/javaClassWithNestedEnum.kt");
    }

    @Test
    @TestMetadata("javaEnumValueOf.kt")
    public void testJavaEnumValueOf() {
      runTest("compiler/testData/codegen/box/enum/javaEnumValueOf.kt");
    }

    @Test
    @TestMetadata("javaEnumValueOf2.kt")
    public void testJavaEnumValueOf2() {
      runTest("compiler/testData/codegen/box/enum/javaEnumValueOf2.kt");
    }

    @Test
    @TestMetadata("javaEnumValues.kt")
    public void testJavaEnumValues() {
      runTest("compiler/testData/codegen/box/enum/javaEnumValues.kt");
    }

    @Test
    @TestMetadata("javaEnumValues2.kt")
    public void testJavaEnumValues2() {
      runTest("compiler/testData/codegen/box/enum/javaEnumValues2.kt");
    }

    @Test
    @TestMetadata("javaEnumValues3.kt")
    public void testJavaEnumValues3() {
      runTest("compiler/testData/codegen/box/enum/javaEnumValues3.kt");
    }

    @Test
    @TestMetadata("k54079.kt")
    public void testK54079() {
      runTest("compiler/testData/codegen/box/enum/k54079.kt");
    }

    @Test
    @TestMetadata("kt1119.kt")
    public void testKt1119() {
      runTest("compiler/testData/codegen/box/enum/kt1119.kt");
    }

    @Test
    @TestMetadata("kt18731.kt")
    public void testKt18731() {
      runTest("compiler/testData/codegen/box/enum/kt18731.kt");
    }

    @Test
    @TestMetadata("kt18731_2.kt")
    public void testKt18731_2() {
      runTest("compiler/testData/codegen/box/enum/kt18731_2.kt");
    }

    @Test
    @TestMetadata("kt20651.kt")
    public void testKt20651() {
      runTest("compiler/testData/codegen/box/enum/kt20651.kt");
    }

    @Test
    @TestMetadata("kt20651_inlineLambda.kt")
    public void testKt20651_inlineLambda() {
      runTest("compiler/testData/codegen/box/enum/kt20651_inlineLambda.kt");
    }

    @Test
    @TestMetadata("kt20651a.kt")
    public void testKt20651a() {
      runTest("compiler/testData/codegen/box/enum/kt20651a.kt");
    }

    @Test
    @TestMetadata("kt20651b.kt")
    public void testKt20651b() {
      runTest("compiler/testData/codegen/box/enum/kt20651b.kt");
    }

    @Test
    @TestMetadata("kt2350.kt")
    public void testKt2350() {
      runTest("compiler/testData/codegen/box/enum/kt2350.kt");
    }

    @Test
    @TestMetadata("kt38540.kt")
    public void testKt38540() {
      runTest("compiler/testData/codegen/box/enum/kt38540.kt");
    }

    @Test
    @TestMetadata("kt38996.kt")
    public void testKt38996() {
      runTest("compiler/testData/codegen/box/enum/kt38996.kt");
    }

    @Test
    @TestMetadata("kt44744.kt")
    public void testKt44744() {
      runTest("compiler/testData/codegen/box/enum/kt44744.kt");
    }

    @Test
    @TestMetadata("kt44744_innerClass.kt")
    public void testKt44744_innerClass() {
      runTest("compiler/testData/codegen/box/enum/kt44744_innerClass.kt");
    }

    @Test
    @TestMetadata("kt46605.kt")
    public void testKt46605() {
      runTest("compiler/testData/codegen/box/enum/kt46605.kt");
    }

    @Test
    @TestMetadata("kt7257.kt")
    public void testKt7257() {
      runTest("compiler/testData/codegen/box/enum/kt7257.kt");
    }

    @Test
    @TestMetadata("kt7257_anonObjectInit.kt")
    public void testKt7257_anonObjectInit() {
      runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectInit.kt");
    }

    @Test
    @TestMetadata("kt7257_anonObjectMethod.kt")
    public void testKt7257_anonObjectMethod() {
      runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectMethod.kt");
    }

    @Test
    @TestMetadata("kt7257_boundReference1.kt")
    public void testKt7257_boundReference1() {
      runTest("compiler/testData/codegen/box/enum/kt7257_boundReference1.kt");
    }

    @Test
    @TestMetadata("kt7257_boundReference2.kt")
    public void testKt7257_boundReference2() {
      runTest("compiler/testData/codegen/box/enum/kt7257_boundReference2.kt");
    }

    @Test
    @TestMetadata("kt7257_boundReferenceWithImplicitReceiver.kt")
    public void testKt7257_boundReferenceWithImplicitReceiver() {
      runTest("compiler/testData/codegen/box/enum/kt7257_boundReferenceWithImplicitReceiver.kt");
    }

    @Test
    @TestMetadata("kt7257_explicitReceiver.kt")
    public void testKt7257_explicitReceiver() {
      runTest("compiler/testData/codegen/box/enum/kt7257_explicitReceiver.kt");
    }

    @Test
    @TestMetadata("kt7257_fullyQualifiedReceiver.kt")
    public void testKt7257_fullyQualifiedReceiver() {
      runTest("compiler/testData/codegen/box/enum/kt7257_fullyQualifiedReceiver.kt");
    }

    @Test
    @TestMetadata("kt7257_namedLocalFun.kt")
    public void testKt7257_namedLocalFun() {
      runTest("compiler/testData/codegen/box/enum/kt7257_namedLocalFun.kt");
    }

    @Test
    @TestMetadata("kt7257_notInline.kt")
    public void testKt7257_notInline() {
      runTest("compiler/testData/codegen/box/enum/kt7257_notInline.kt");
    }

    @Test
    @TestMetadata("kt9711.kt")
    public void testKt9711() {
      runTest("compiler/testData/codegen/box/enum/kt9711.kt");
    }

    @Test
    @TestMetadata("kt9711_2.kt")
    public void testKt9711_2() {
      runTest("compiler/testData/codegen/box/enum/kt9711_2.kt");
    }

    @Test
    @TestMetadata("lambdaInDefault.kt")
    public void testLambdaInDefault() {
      runTest("compiler/testData/codegen/box/enum/lambdaInDefault.kt");
    }

    @Test
    @TestMetadata("loop.kt")
    public void testLoop() {
      runTest("compiler/testData/codegen/box/enum/loop.kt");
    }

    @Test
    @TestMetadata("manyDefaultParameters.kt")
    public void testManyDefaultParameters() {
      runTest("compiler/testData/codegen/box/enum/manyDefaultParameters.kt");
    }

    @Test
    @TestMetadata("memberNameInJavaEnum.kt")
    public void testMemberNameInJavaEnum() {
      runTest("compiler/testData/codegen/box/enum/memberNameInJavaEnum.kt");
    }

    @Test
    @TestMetadata("modifierFlags.kt")
    public void testModifierFlags() {
      runTest("compiler/testData/codegen/box/enum/modifierFlags.kt");
    }

    @Test
    @TestMetadata("multipleModules.kt")
    public void testMultipleModules() {
      runTest("compiler/testData/codegen/box/enum/multipleModules.kt");
    }

    @Test
    @TestMetadata("nameClashWithCompanion.kt")
    public void testNameClashWithCompanion() {
      runTest("compiler/testData/codegen/box/enum/nameClashWithCompanion.kt");
    }

    @Test
    @TestMetadata("nameConflict.kt")
    public void testNameConflict() {
      runTest("compiler/testData/codegen/box/enum/nameConflict.kt");
    }

    @Test
    @TestMetadata("nested.kt")
    public void testNested() {
      runTest("compiler/testData/codegen/box/enum/nested.kt");
    }

    @Test
    @TestMetadata("noClassForSimpleEnum.kt")
    public void testNoClassForSimpleEnum() {
      runTest("compiler/testData/codegen/box/enum/noClassForSimpleEnum.kt");
    }

    @Test
    @TestMetadata("openMethodNoOverrides.kt")
    public void testOpenMethodNoOverrides() {
      runTest("compiler/testData/codegen/box/enum/openMethodNoOverrides.kt");
    }

    @Test
    @TestMetadata("ordinal.kt")
    public void testOrdinal() {
      runTest("compiler/testData/codegen/box/enum/ordinal.kt");
    }

    @Test
    @TestMetadata("ordinalsWithEnumEntitiesOverrides.kt")
    public void testOrdinalsWithEnumEntitiesOverrides() {
      runTest("compiler/testData/codegen/box/enum/ordinalsWithEnumEntitiesOverrides.kt");
    }

    @Test
    @TestMetadata("overloadedEnumValues.kt")
    public void testOverloadedEnumValues() {
      runTest("compiler/testData/codegen/box/enum/overloadedEnumValues.kt");
    }

    @Test
    @TestMetadata("overloadedEnumValuesStatic.kt")
    public void testOverloadedEnumValuesStatic() {
      runTest("compiler/testData/codegen/box/enum/overloadedEnumValuesStatic.kt");
    }

    @Test
    @TestMetadata("refToThis.kt")
    public void testRefToThis() {
      runTest("compiler/testData/codegen/box/enum/refToThis.kt");
    }

    @Test
    @TestMetadata("reorderedArguments.kt")
    public void testReorderedArguments() {
      runTest("compiler/testData/codegen/box/enum/reorderedArguments.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/enum/simple.kt");
    }

    @Test
    @TestMetadata("simpleJavaEnum.kt")
    public void testSimpleJavaEnum() {
      runTest("compiler/testData/codegen/box/enum/simpleJavaEnum.kt");
    }

    @Test
    @TestMetadata("simpleJavaEnumWithFunction.kt")
    public void testSimpleJavaEnumWithFunction() {
      runTest("compiler/testData/codegen/box/enum/simpleJavaEnumWithFunction.kt");
    }

    @Test
    @TestMetadata("simpleJavaEnumWithStaticImport.kt")
    public void testSimpleJavaEnumWithStaticImport() {
      runTest("compiler/testData/codegen/box/enum/simpleJavaEnumWithStaticImport.kt");
    }

    @Test
    @TestMetadata("simpleJavaInnerEnum.kt")
    public void testSimpleJavaInnerEnum() {
      runTest("compiler/testData/codegen/box/enum/simpleJavaInnerEnum.kt");
    }

    @Test
    @TestMetadata("sortEnumEntries.kt")
    public void testSortEnumEntries() {
      runTest("compiler/testData/codegen/box/enum/sortEnumEntries.kt");
    }

    @Test
    @TestMetadata("staticField.kt")
    public void testStaticField() {
      runTest("compiler/testData/codegen/box/enum/staticField.kt");
    }

    @Test
    @TestMetadata("staticMethod.kt")
    public void testStaticMethod() {
      runTest("compiler/testData/codegen/box/enum/staticMethod.kt");
    }

    @Test
    @TestMetadata("superCallInEnumLiteral.kt")
    public void testSuperCallInEnumLiteral() {
      runTest("compiler/testData/codegen/box/enum/superCallInEnumLiteral.kt");
    }

    @Test
    @TestMetadata("switchLowering.kt")
    public void testSwitchLowering() {
      runTest("compiler/testData/codegen/box/enum/switchLowering.kt");
    }

    @Test
    @TestMetadata("test0.kt")
    public void testTest0() {
      runTest("compiler/testData/codegen/box/enum/test0.kt");
    }

    @Test
    @TestMetadata("test1.kt")
    public void testTest1() {
      runTest("compiler/testData/codegen/box/enum/test1.kt");
    }

    @Test
    @TestMetadata("toString.kt")
    public void testToString() {
      runTest("compiler/testData/codegen/box/enum/toString.kt");
    }

    @Test
    @TestMetadata("vCallNoEntryClass.kt")
    public void testVCallNoEntryClass() {
      runTest("compiler/testData/codegen/box/enum/vCallNoEntryClass.kt");
    }

    @Test
    @TestMetadata("vCallWithEntryClass.kt")
    public void testVCallWithEntryClass() {
      runTest("compiler/testData/codegen/box/enum/vCallWithEntryClass.kt");
    }

    @Test
    @TestMetadata("valueOf2.kt")
    public void testValueOf2() {
      runTest("compiler/testData/codegen/box/enum/valueOf2.kt");
    }

    @Test
    @TestMetadata("valueof.kt")
    public void testValueof() {
      runTest("compiler/testData/codegen/box/enum/valueof.kt");
    }

    @Test
    @TestMetadata("values.kt")
    public void testValues() {
      runTest("compiler/testData/codegen/box/enum/values.kt");
    }

    @Test
    @TestMetadata("varargParam.kt")
    public void testVarargParam() {
      runTest("compiler/testData/codegen/box/enum/varargParam.kt");
    }

    @Test
    @TestMetadata("whenInObject.kt")
    public void testWhenInObject() {
      runTest("compiler/testData/codegen/box/enum/whenInObject.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/enum/defaultCtor")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultCtor {
      @Test
      public void testAllFilesPresentInDefaultCtor() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/enum/defaultCtor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("constructorWithDefaultArguments.kt")
      public void testConstructorWithDefaultArguments() {
        runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithDefaultArguments.kt");
      }

      @Test
      @TestMetadata("constructorWithVararg.kt")
      public void testConstructorWithVararg() {
        runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithVararg.kt");
      }

      @Test
      @TestMetadata("entryClassConstructorWithDefaultArguments.kt")
      public void testEntryClassConstructorWithDefaultArguments() {
        runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithDefaultArguments.kt");
      }

      @Test
      @TestMetadata("entryClassConstructorWithVarargs.kt")
      public void testEntryClassConstructorWithVarargs() {
        runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithVarargs.kt");
      }

      @Test
      @TestMetadata("noPrimaryConstructor.kt")
      public void testNoPrimaryConstructor() {
        runTest("compiler/testData/codegen/box/enum/defaultCtor/noPrimaryConstructor.kt");
      }

      @Test
      @TestMetadata("secondaryConstructorWithDefaultArguments.kt")
      public void testSecondaryConstructorWithDefaultArguments() {
        runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithDefaultArguments.kt");
      }

      @Test
      @TestMetadata("secondaryConstructorWithVararg.kt")
      public void testSecondaryConstructorWithVararg() {
        runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithVararg.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/equivalentCalls")
  @TestDataPath("$PROJECT_ROOT")
  public class EquivalentCalls {
    @Test
    public void testAllFilesPresentInEquivalentCalls() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/equivalentCalls"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("localEquivalentWins.kt")
    public void testLocalEquivalentWins() {
      runTest("compiler/testData/codegen/box/equivalentCalls/localEquivalentWins.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/escapeAnalysis")
  @TestDataPath("$PROJECT_ROOT")
  public class EscapeAnalysis {
    @Test
    public void testAllFilesPresentInEscapeAnalysis() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/escapeAnalysis"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("recursion.kt")
    public void testRecursion() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/recursion.kt");
    }

    @Test
    @TestMetadata("stack_array.kt")
    public void testStack_array() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/stack_array.kt");
    }

    @Test
    @TestMetadata("test1.kt")
    public void testTest1() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test1.kt");
    }

    @Test
    @TestMetadata("test10.kt")
    public void testTest10() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test10.kt");
    }

    @Test
    @TestMetadata("test11.kt")
    public void testTest11() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test11.kt");
    }

    @Test
    @TestMetadata("test12.kt")
    public void testTest12() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test12.kt");
    }

    @Test
    @TestMetadata("test13.kt")
    public void testTest13() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test13.kt");
    }

    @Test
    @TestMetadata("test2.kt")
    public void testTest2() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test2.kt");
    }

    @Test
    @TestMetadata("test3.kt")
    public void testTest3() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test3.kt");
    }

    @Test
    @TestMetadata("test4.kt")
    public void testTest4() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test4.kt");
    }

    @Test
    @TestMetadata("test5.kt")
    public void testTest5() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test5.kt");
    }

    @Test
    @TestMetadata("test6.kt")
    public void testTest6() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test6.kt");
    }

    @Test
    @TestMetadata("test7.kt")
    public void testTest7() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test7.kt");
    }

    @Test
    @TestMetadata("test8.kt")
    public void testTest8() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test8.kt");
    }

    @Test
    @TestMetadata("test9.kt")
    public void testTest9() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/test9.kt");
    }

    @Test
    @TestMetadata("zeroOutObjectOnAlloc.kt")
    public void testZeroOutObjectOnAlloc() {
      runTest("compiler/testData/codegen/box/escapeAnalysis/zeroOutObjectOnAlloc.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/evaluate")
  @TestDataPath("$PROJECT_ROOT")
  public class Evaluate {
    @Test
    public void testAllFilesPresentInEvaluate() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/evaluate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("char.kt")
    public void testChar() {
      runTest("compiler/testData/codegen/box/evaluate/char.kt");
    }

    @Test
    @TestMetadata("divide.kt")
    public void testDivide() {
      runTest("compiler/testData/codegen/box/evaluate/divide.kt");
    }

    @Test
    @TestMetadata("floorDiv.kt")
    public void testFloorDiv() {
      runTest("compiler/testData/codegen/box/evaluate/floorDiv.kt");
    }

    @Test
    @TestMetadata("intrinsics.kt")
    public void testIntrinsics() {
      runTest("compiler/testData/codegen/box/evaluate/intrinsics.kt");
    }

    @Test
    @TestMetadata("kt9443.kt")
    public void testKt9443() {
      runTest("compiler/testData/codegen/box/evaluate/kt9443.kt");
    }

    @Test
    @TestMetadata("maxValue.kt")
    public void testMaxValue() {
      runTest("compiler/testData/codegen/box/evaluate/maxValue.kt");
    }

    @Test
    @TestMetadata("maxValueByte.kt")
    public void testMaxValueByte() {
      runTest("compiler/testData/codegen/box/evaluate/maxValueByte.kt");
    }

    @Test
    @TestMetadata("maxValueInt.kt")
    public void testMaxValueInt() {
      runTest("compiler/testData/codegen/box/evaluate/maxValueInt.kt");
    }

    @Test
    @TestMetadata("minus.kt")
    public void testMinus() {
      runTest("compiler/testData/codegen/box/evaluate/minus.kt");
    }

    @Test
    @TestMetadata("mod.kt")
    public void testMod() {
      runTest("compiler/testData/codegen/box/evaluate/mod.kt");
    }

    @Test
    @TestMetadata("multiply.kt")
    public void testMultiply() {
      runTest("compiler/testData/codegen/box/evaluate/multiply.kt");
    }

    @Test
    @TestMetadata("parenthesized.kt")
    public void testParenthesized() {
      runTest("compiler/testData/codegen/box/evaluate/parenthesized.kt");
    }

    @Test
    @TestMetadata("plus.kt")
    public void testPlus() {
      runTest("compiler/testData/codegen/box/evaluate/plus.kt");
    }

    @Test
    @TestMetadata("rem.kt")
    public void testRem() {
      runTest("compiler/testData/codegen/box/evaluate/rem.kt");
    }

    @Test
    @TestMetadata("simpleCallBinary.kt")
    public void testSimpleCallBinary() {
      runTest("compiler/testData/codegen/box/evaluate/simpleCallBinary.kt");
    }

    @Test
    @TestMetadata("unaryMinus.kt")
    public void testUnaryMinus() {
      runTest("compiler/testData/codegen/box/evaluate/unaryMinus.kt");
    }

    @Test
    @TestMetadata("unaryPlus.kt")
    public void testUnaryPlus() {
      runTest("compiler/testData/codegen/box/evaluate/unaryPlus.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/exceptions")
  @TestDataPath("$PROJECT_ROOT")
  public class Exceptions {
    @Test
    public void testAllFilesPresentInExceptions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/exceptions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("catch1.kt")
    public void testCatch1() {
      runTest("compiler/testData/codegen/box/exceptions/catch1.kt");
    }

    @Test
    @TestMetadata("catch2.kt")
    public void testCatch2() {
      runTest("compiler/testData/codegen/box/exceptions/catch2.kt");
    }

    @Test
    @TestMetadata("catch7.kt")
    public void testCatch7() {
      runTest("compiler/testData/codegen/box/exceptions/catch7.kt");
    }

    @Test
    @TestMetadata("extend0.kt")
    public void testExtend0() {
      runTest("compiler/testData/codegen/box/exceptions/extend0.kt");
    }

    @Test
    @TestMetadata("kt69534.kt")
    public void testKt69534() {
      runTest("compiler/testData/codegen/box/exceptions/kt69534.kt");
    }

    @Test
    @TestMetadata("rethrow.kt")
    public void testRethrow() {
      runTest("compiler/testData/codegen/box/exceptions/rethrow.kt");
    }

    @Test
    @TestMetadata("throw0.kt")
    public void testThrow0() {
      runTest("compiler/testData/codegen/box/exceptions/throw0.kt");
    }

    @Test
    @TestMetadata("throw_from_catch.kt")
    public void testThrow_from_catch() {
      runTest("compiler/testData/codegen/box/exceptions/throw_from_catch.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/exclExcl")
  @TestDataPath("$PROJECT_ROOT")
  public class ExclExcl {
    @Test
    public void testAllFilesPresentInExclExcl() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("genericNull.kt")
    public void testGenericNull() {
      runTest("compiler/testData/codegen/box/exclExcl/genericNull.kt");
    }

    @Test
    @TestMetadata("kt48440.kt")
    public void testKt48440() {
      runTest("compiler/testData/codegen/box/exclExcl/kt48440.kt");
    }

    @Test
    @TestMetadata("kt48440_2.kt")
    public void testKt48440_2() {
      runTest("compiler/testData/codegen/box/exclExcl/kt48440_2.kt");
    }

    @Test
    @TestMetadata("primitive.kt")
    public void testPrimitive() {
      runTest("compiler/testData/codegen/box/exclExcl/primitive.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/extensionClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class ExtensionClasses {
    @Test
    public void testAllFilesPresentInExtensionClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("constructors.kt")
    public void testConstructors() {
      runTest("compiler/testData/codegen/box/extensionClasses/constructors.kt");
    }

    @Test
    @TestMetadata("contextualPrimaryConstructorWithParams.kt")
    public void testContextualPrimaryConstructorWithParams() {
      runTest("compiler/testData/codegen/box/extensionClasses/contextualPrimaryConstructorWithParams.kt");
    }

    @Test
    @TestMetadata("edouble.kt")
    public void testEdouble() {
      runTest("compiler/testData/codegen/box/extensionClasses/edouble.kt");
    }

    @Test
    @TestMetadata("genericCollection.kt")
    public void testGenericCollection() {
      runTest("compiler/testData/codegen/box/extensionClasses/genericCollection.kt");
    }

    @Test
    @TestMetadata("generics.kt")
    public void testGenerics() {
      runTest("compiler/testData/codegen/box/extensionClasses/generics.kt");
    }

    @Test
    @TestMetadata("lambdaReceiverFromContext.kt")
    public void testLambdaReceiverFromContext() {
      runTest("compiler/testData/codegen/box/extensionClasses/lambdaReceiverFromContext.kt");
    }

    @Test
    @TestMetadata("multiple.kt")
    public void testMultiple() {
      runTest("compiler/testData/codegen/box/extensionClasses/multiple.kt");
    }

    @Test
    @TestMetadata("noRedeclaration.kt")
    public void testNoRedeclaration() {
      runTest("compiler/testData/codegen/box/extensionClasses/noRedeclaration.kt");
    }

    @Test
    @TestMetadata("propertyWithContext.kt")
    public void testPropertyWithContext() {
      runTest("compiler/testData/codegen/box/extensionClasses/propertyWithContext.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/extensionClasses/simple.kt");
    }

    @Test
    @TestMetadata("typealiasForContextualClass.kt")
    public void testTypealiasForContextualClass() {
      runTest("compiler/testData/codegen/box/extensionClasses/typealiasForContextualClass.kt");
    }

    @Test
    @TestMetadata("useFromAnotherModule.kt")
    public void testUseFromAnotherModule() {
      runTest("compiler/testData/codegen/box/extensionClasses/useFromAnotherModule.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/extensionFunctions")
  @TestDataPath("$PROJECT_ROOT")
  public class ExtensionFunctions {
    @Test
    public void testAllFilesPresentInExtensionFunctions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("classMethodCallExtensionSuper.kt")
    public void testClassMethodCallExtensionSuper() {
      runTest("compiler/testData/codegen/box/extensionFunctions/classMethodCallExtensionSuper.kt");
    }

    @Test
    @TestMetadata("defaultMethodInterfaceCallExtensionSuper.kt")
    public void testDefaultMethodInterfaceCallExtensionSuper() {
      runTest("compiler/testData/codegen/box/extensionFunctions/defaultMethodInterfaceCallExtensionSuper.kt");
    }

    @Test
    @TestMetadata("delegatedPropertyWithExtensionType.kt")
    public void testDelegatedPropertyWithExtensionType() {
      runTest("compiler/testData/codegen/box/extensionFunctions/delegatedPropertyWithExtensionType.kt");
    }

    @Test
    @TestMetadata("executionOrder.kt")
    public void testExecutionOrder() {
      runTest("compiler/testData/codegen/box/extensionFunctions/executionOrder.kt");
    }

    @Test
    @TestMetadata("extensionFunctionAndSpreadOperator.kt")
    public void testExtensionFunctionAndSpreadOperator() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAndSpreadOperator.kt");
    }

    @Test
    @TestMetadata("extensionFunctionAsADefaultInKotlinInterface.kt")
    public void testExtensionFunctionAsADefaultInKotlinInterface() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsADefaultInKotlinInterface.kt");
    }

    @Test
    @TestMetadata("extensionFunctionAsASupertypeOfValueClass.kt")
    public void testExtensionFunctionAsASupertypeOfValueClass() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsASupertypeOfValueClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("extensionFunctionAsATypeLocal.kt")
    public void testExtensionFunctionAsATypeLocal() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsATypeLocal.kt");
    }

    @Test
    @TestMetadata("extensionFunctionAsAnExpression.kt")
    public void testExtensionFunctionAsAnExpression() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsAnExpression.kt");
    }

    @Test
    @TestMetadata("extensionFunctionAsAnExpressionWithNestedType.kt")
    public void testExtensionFunctionAsAnExpressionWithNestedType() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsAnExpressionWithNestedType.kt");
    }

    @Test
    @TestMetadata("extensionFunctionAsAnonymous.kt")
    public void testExtensionFunctionAsAnonymous() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsAnonymous.kt");
    }

    @Test
    @TestMetadata("extensionFunctionAsSupertype.kt")
    public void testExtensionFunctionAsSupertype() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsSupertype.kt");
    }

    @Test
    @TestMetadata("extensionFunctionAsType.kt")
    public void testExtensionFunctionAsType() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsType.kt");
    }

    @Test
    @TestMetadata("extensionFunctionClassLevelLocal.kt")
    public void testExtensionFunctionClassLevelLocal() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionClassLevelLocal.kt");
    }

    @Test
    @TestMetadata("extensionFunctionDifferentReceivers.kt")
    public void testExtensionFunctionDifferentReceivers() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionDifferentReceivers.kt");
    }

    @Test
    @TestMetadata("extensionFunctionFakeOverride.kt")
    public void testExtensionFunctionFakeOverride() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionFakeOverride.kt");
    }

    @Test
    @TestMetadata("extensionFunctionInDelegatedSam.kt")
    public void testExtensionFunctionInDelegatedSam() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionInDelegatedSam.kt");
    }

    @Test
    @TestMetadata("extensionFunctionInInnerClass.kt")
    public void testExtensionFunctionInInnerClass() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionInInnerClass.kt");
    }

    @Test
    @TestMetadata("extensionFunctionInNestedClass.kt")
    public void testExtensionFunctionInNestedClass() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionInNestedClass.kt");
    }

    @Test
    @TestMetadata("extensionFunctionInSAMInterface.kt")
    public void testExtensionFunctionInSAMInterface() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionInSAMInterface.kt");
    }

    @Test
    @TestMetadata("extensionFunctionInValueClass.kt")
    public void testExtensionFunctionInValueClass() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionInValueClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("extensionFunctionJavaReceiver.kt")
    public void testExtensionFunctionJavaReceiver() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionJavaReceiver.kt");
    }

    @Test
    @TestMetadata("extensionFunctionLocal.kt")
    public void testExtensionFunctionLocal() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionLocal.kt");
    }

    @Test
    @TestMetadata("extensionFunctionNestedInExtensionFunction.kt")
    public void testExtensionFunctionNestedInExtensionFunction() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionNestedInExtensionFunction.kt");
    }

    @Test
    @TestMetadata("extensionFunctionOverride.kt")
    public void testExtensionFunctionOverride() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionOverride.kt");
    }

    @Test
    @TestMetadata("extensionFunctionOverrideAsADefaultInJavaInterface.kt")
    public void testExtensionFunctionOverrideAsADefaultInJavaInterface() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionOverrideAsADefaultInJavaInterface.kt");
    }

    @Test
    @TestMetadata("extensionFunctionWithExtensionAsAReceiver.kt")
    public void testExtensionFunctionWithExtensionAsAReceiver() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionWithExtensionAsAReceiver.kt");
    }

    @Test
    @TestMetadata("extensionFunctionWithExtensionInSAMInterface.kt")
    public void testExtensionFunctionWithExtensionInSAMInterface() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionWithExtensionInSAMInterface.kt");
    }

    @Test
    @TestMetadata("extensionFunctionWithInlineModifier.kt")
    public void testExtensionFunctionWithInlineModifier() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionWithInlineModifier.kt");
    }

    @Test
    @TestMetadata("extensionFunctionWithNestedReceiver.kt")
    public void testExtensionFunctionWithNestedReceiver() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionWithNestedReceiver.kt");
    }

    @Test
    @TestMetadata("extensionFunctionWithReceiverConflict.kt")
    public void testExtensionFunctionWithReceiverConflict() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionWithReceiverConflict.kt");
    }

    @Test
    @TestMetadata("extensionMemberWithTypeParameter.kt")
    public void testExtensionMemberWithTypeParameter() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionMemberWithTypeParameter.kt");
    }

    @Test
    @TestMetadata("extensionReceiverIsNotInlined.kt")
    public void testExtensionReceiverIsNotInlined() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionReceiverIsNotInlined.kt");
    }

    @Test
    @TestMetadata("extensionsAndJavaFunctionsInHierarchy.kt")
    public void testExtensionsAndJavaFunctionsInHierarchy() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionsAndJavaFunctionsInHierarchy.kt");
    }

    @Test
    @TestMetadata("extensionsFakeOverrideInJava.kt")
    public void testExtensionsFakeOverrideInJava() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionsFakeOverrideInJava.kt");
    }

    @Test
    @TestMetadata("extensionsOverrideInJava.kt")
    public void testExtensionsOverrideInJava() {
      runTest("compiler/testData/codegen/box/extensionFunctions/extensionsOverrideInJava.kt");
    }

    @Test
    @TestMetadata("functionWithTheSameDispatchAndExtensionReceiver.kt")
    public void testFunctionWithTheSameDispatchAndExtensionReceiver() {
      runTest("compiler/testData/codegen/box/extensionFunctions/functionWithTheSameDispatchAndExtensionReceiver.kt");
    }

    @Test
    @TestMetadata("kt1061.kt")
    public void testKt1061() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt1061.kt");
    }

    @Test
    @TestMetadata("kt1249.kt")
    public void testKt1249() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt1249.kt");
    }

    @Test
    @TestMetadata("kt1290.kt")
    public void testKt1290() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt1290.kt");
    }

    @Test
    @TestMetadata("kt13312.kt")
    public void testKt13312() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt13312.kt");
    }

    @Test
    @TestMetadata("kt1776.kt")
    public void testKt1776() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt1776.kt");
    }

    @Test
    @TestMetadata("kt1953.kt")
    public void testKt1953() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt1953.kt");
    }

    @Test
    @TestMetadata("kt1953_class.kt")
    public void testKt1953_class() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt1953_class.kt");
    }

    @Test
    @TestMetadata("kt23675.kt")
    public void testKt23675() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt23675.kt");
    }

    @Test
    @TestMetadata("kt3285.kt")
    public void testKt3285() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt3285.kt");
    }

    @Test
    @TestMetadata("kt3298.kt")
    public void testKt3298() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt3298.kt");
    }

    @Test
    @TestMetadata("kt3646.kt")
    public void testKt3646() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt3646.kt");
    }

    @Test
    @TestMetadata("kt3969.kt")
    public void testKt3969() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt3969.kt");
    }

    @Test
    @TestMetadata("kt4228.kt")
    public void testKt4228() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt4228.kt");
    }

    @Test
    @TestMetadata("kt475.kt")
    public void testKt475() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt475.kt");
    }

    @Test
    @TestMetadata("kt5467.kt")
    public void testKt5467() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt5467.kt");
    }

    @Test
    @TestMetadata("kt606.kt")
    public void testKt606() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt606.kt");
    }

    @Test
    @TestMetadata("kt865.kt")
    public void testKt865() {
      runTest("compiler/testData/codegen/box/extensionFunctions/kt865.kt");
    }

    @Test
    @TestMetadata("memberExtensionEqualsHashCodeToStringInInterface.kt")
    public void testMemberExtensionEqualsHashCodeToStringInInterface() {
      runTest("compiler/testData/codegen/box/extensionFunctions/memberExtensionEqualsHashCodeToStringInInterface.kt");
    }

    @Test
    @TestMetadata("nested2.kt")
    public void testNested2() {
      runTest("compiler/testData/codegen/box/extensionFunctions/nested2.kt");
    }

    @Test
    @TestMetadata("nestedExtensionFunctionAsASupertype.kt")
    public void testNestedExtensionFunctionAsASupertype() {
      runTest("compiler/testData/codegen/box/extensionFunctions/nestedExtensionFunctionAsASupertype.kt");
    }

    @Test
    @TestMetadata("shared.kt")
    public void testShared() {
      runTest("compiler/testData/codegen/box/extensionFunctions/shared.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/codegen/box/extensionFunctions/simple.kt");
    }

    @Test
    @TestMetadata("suspendConversionForExtensionFunAsAFunType.kt")
    public void testSuspendConversionForExtensionFunAsAFunType() {
      runTest("compiler/testData/codegen/box/extensionFunctions/suspendConversionForExtensionFunAsAFunType.kt");
    }

    @Test
    @TestMetadata("suspendConversionForExtensionFunAsAPropertyType.kt")
    public void testSuspendConversionForExtensionFunAsAPropertyType() {
      runTest("compiler/testData/codegen/box/extensionFunctions/suspendConversionForExtensionFunAsAPropertyType.kt");
    }

    @Test
    @TestMetadata("suspendConversionForExtensionFunAsASuperType.kt")
    public void testSuspendConversionForExtensionFunAsASuperType() {
      runTest("compiler/testData/codegen/box/extensionFunctions/suspendConversionForExtensionFunAsASuperType.kt");
    }

    @Test
    @TestMetadata("thisMethodInObjectLiteral.kt")
    public void testThisMethodInObjectLiteral() {
      runTest("compiler/testData/codegen/box/extensionFunctions/thisMethodInObjectLiteral.kt");
    }

    @Test
    @TestMetadata("virtual.kt")
    public void testVirtual() {
      runTest("compiler/testData/codegen/box/extensionFunctions/virtual.kt");
    }

    @Test
    @TestMetadata("whenFail.kt")
    public void testWhenFail() {
      runTest("compiler/testData/codegen/box/extensionFunctions/whenFail.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/extensionFunctions/contextReceivers")
    @TestDataPath("$PROJECT_ROOT")
    public class ContextReceivers {
      @Test
      public void testAllFilesPresentInContextReceivers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayAccessCompositeOperators.kt")
      public void testArrayAccessCompositeOperators() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/arrayAccessCompositeOperators.kt");
      }

      @Test
      @TestMetadata("arrayAccessOperators.kt")
      public void testArrayAccessOperators() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/arrayAccessOperators.kt");
      }

      @Test
      @TestMetadata("cceAfterReceiverSmartCast.kt")
      public void testCceAfterReceiverSmartCast() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/cceAfterReceiverSmartCast.kt");
      }

      @Test
      @TestMetadata("compoundAssignmentOperators.kt")
      public void testCompoundAssignmentOperators() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/compoundAssignmentOperators.kt");
      }

      @Test
      @TestMetadata("contextAndExtensionLambdaIndy.kt")
      public void testContextAndExtensionLambdaIndy() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/contextAndExtensionLambdaIndy.kt");
      }

      @Test
      @TestMetadata("contextAndExtensionSameName.kt")
      public void testContextAndExtensionSameName() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/contextAndExtensionSameName.kt");
      }

      @Test
      @TestMetadata("contextAndNoContextOverloads.kt")
      public void testContextAndNoContextOverloads() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/contextAndNoContextOverloads.kt");
      }

      @Test
      @TestMetadata("contextualFunctionConversion.kt")
      public void testContextualFunctionConversion() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/contextualFunctionConversion.kt");
      }

      @Test
      @TestMetadata("contextualInlineCall.kt")
      public void testContextualInlineCall() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/contextualInlineCall.kt");
      }

      @Test
      @TestMetadata("delegatedPropertiesOperators.kt")
      public void testDelegatedPropertiesOperators() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/delegatedPropertiesOperators.kt");
      }

      @Test
      @TestMetadata("inferGenericPropertyType.kt")
      public void testInferGenericPropertyType() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/inferGenericPropertyType.kt");
      }

      @Test
      @TestMetadata("iteratorOperator.kt")
      public void testIteratorOperator() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/iteratorOperator.kt");
      }

      @Test
      @TestMetadata("kt51247.kt")
      public void testKt51247() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt51247.kt");
      }

      @Test
      @TestMetadata("kt51277.kt")
      public void testKt51277() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt51277.kt");
      }

      @Test
      @TestMetadata("kt51284.kt")
      public void testKt51284() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt51284.kt");
      }

      @Test
      @TestMetadata("kt51290.kt")
      public void testKt51290() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt51290.kt");
      }

      @Test
      @TestMetadata("kt51397.kt")
      public void testKt51397() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt51397.kt");
      }

      @Test
      @TestMetadata("kt51475.kt")
      public void testKt51475() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt51475.kt");
      }

      @Test
      @TestMetadata("kt51863.kt")
      public void testKt51863() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt51863.kt");
      }

      @Test
      @TestMetadata("kt51951.kt")
      public void testKt51951() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt51951.kt");
      }

      @Test
      @TestMetadata("kt52207.kt")
      public void testKt52207() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt52207.kt");
      }

      @Test
      @TestMetadata("kt52213.kt")
      public void testKt52213() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt52213.kt");
      }

      @Test
      @TestMetadata("kt52373.kt")
      public void testKt52373() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt52373.kt");
      }

      @Test
      @TestMetadata("kt52459.kt")
      public void testKt52459() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt52459.kt");
      }

      @Test
      @TestMetadata("kt53551.kt")
      public void testKt53551() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt53551.kt");
      }

      @Test
      @TestMetadata("kt53846.kt")
      public void testKt53846() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt53846.kt");
      }

      @Test
      @TestMetadata("kt54357.kt")
      public void testKt54357() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt54357.kt");
      }

      @Test
      @TestMetadata("kt56508.kt")
      public void testKt56508() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt56508.kt");
      }

      @Test
      @TestMetadata("kt58476.kt")
      public void testKt58476() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt58476.kt");
      }

      @Test
      @TestMetadata("kt63430.kt")
      public void testKt63430() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/kt63430.kt");
      }

      @Test
      @TestMetadata("overload.kt")
      public void testOverload() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/overload.kt");
      }

      @Test
      @TestMetadata("overloading.kt")
      public void testOverloading() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/overloading.kt");
      }

      @Test
      @TestMetadata("parameterizedContextualLambda.kt")
      public void testParameterizedContextualLambda() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/parameterizedContextualLambda.kt");
      }

      @Test
      @TestMetadata("passingLambdaToContextualParam.kt")
      public void testPassingLambdaToContextualParam() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/passingLambdaToContextualParam.kt");
      }

      @Test
      @TestMetadata("plusAssign.kt")
      public void testPlusAssign() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/plusAssign.kt");
      }

      @Test
      @TestMetadata("plusMatrix.kt")
      public void testPlusMatrix() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/plusMatrix.kt");
      }

      @Test
      @TestMetadata("propertyCompoundAssignment.kt")
      public void testPropertyCompoundAssignment() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/propertyCompoundAssignment.kt");
      }

      @Test
      @TestMetadata("receiversOrder.kt")
      public void testReceiversOrder() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/receiversOrder.kt");
      }

      @Test
      @TestMetadata("simpleCall.kt")
      public void testSimpleCall() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/simpleCall.kt");
      }

      @Test
      @TestMetadata("substitutedContextReceivers.kt")
      public void testSubstitutedContextReceivers() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/substitutedContextReceivers.kt");
      }

      @Test
      @TestMetadata("superClassAndSubClassWithContextReceiver.kt")
      public void testSuperClassAndSubClassWithContextReceiver() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/superClassAndSubClassWithContextReceiver.kt");
      }

      @Test
      @TestMetadata("superClassAndSubClassWithContextReceiverSubstituted.kt")
      public void testSuperClassAndSubClassWithContextReceiverSubstituted() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/superClassAndSubClassWithContextReceiverSubstituted.kt");
      }

      @Test
      @TestMetadata("suspendContextualWithExtension.kt")
      public void testSuspendContextualWithExtension() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/suspendContextualWithExtension.kt");
      }

      @Test
      @TestMetadata("this.kt")
      public void testThis() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/this.kt");
      }

      @Test
      @TestMetadata("unaryOperators.kt")
      public void testUnaryOperators() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/unaryOperators.kt");
      }

      @Test
      @TestMetadata("useContextReceiverInPropertyInitializer.kt")
      public void testUseContextReceiverInPropertyInitializer() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/useContextReceiverInPropertyInitializer.kt");
      }

      @Test
      @TestMetadata("useFromAnotherModule.kt")
      public void testUseFromAnotherModule() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/useFromAnotherModule.kt");
      }

      @Test
      @TestMetadata("useFromAnotherModuleSuspending.kt")
      public void testUseFromAnotherModuleSuspending() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/useFromAnotherModuleSuspending.kt");
      }

      @Test
      @TestMetadata("useFromAnotherModuleWithDefaultParameterValues.kt")
      public void testUseFromAnotherModuleWithDefaultParameterValues() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/useFromAnotherModuleWithDefaultParameterValues.kt");
      }

      @Test
      @TestMetadata("withTwoContextReceivers.kt")
      public void testWithTwoContextReceivers() {
        runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/withTwoContextReceivers.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP")
      @TestDataPath("$PROJECT_ROOT")
      public class FromKEEP {
        @Test
        public void testAllFilesPresentInFromKEEP() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("canvas.kt")
        public void testCanvas() {
          runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/canvas.kt");
        }

        @Test
        @TestMetadata("compareTo.kt")
        public void testCompareTo() {
          runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/compareTo.kt");
        }

        @Test
        @TestMetadata("decimateEveryEvenThird.kt")
        public void testDecimateEveryEvenThird() {
          runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/decimateEveryEvenThird.kt");
        }

        @Test
        @TestMetadata("dp.kt")
        public void testDp() {
          runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/dp.kt");
        }

        @Test
        @TestMetadata("functionalType.kt")
        public void testFunctionalType() {
          runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/functionalType.kt");
        }

        @Test
        @TestMetadata("monoidSum.kt")
        public void testMonoidSum() {
          runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/monoidSum.kt");
        }

        @Test
        @TestMetadata("structuredConcurrency.kt")
        public void testStructuredConcurrency() {
          runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/structuredConcurrency.kt");
        }
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/extensionProperties")
  @TestDataPath("$PROJECT_ROOT")
  public class ExtensionProperties {
    @Test
    @TestMetadata("accessorForPrivateSetter.kt")
    public void testAccessorForPrivateSetter() {
      runTest("compiler/testData/codegen/box/extensionProperties/accessorForPrivateSetter.kt");
    }

    @Test
    public void testAllFilesPresentInExtensionProperties() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("extensionMemberWithTypeParameter.kt")
    public void testExtensionMemberWithTypeParameter() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionMemberWithTypeParameter.kt");
    }

    @Test
    @TestMetadata("extensionPropertyDelegated.kt")
    public void testExtensionPropertyDelegated() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyDelegated.kt");
    }

    @Test
    @TestMetadata("extensionPropertyDifferentReceiver.kt")
    public void testExtensionPropertyDifferentReceiver() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyDifferentReceiver.kt");
    }

    @Test
    @TestMetadata("extensionPropertyInInnerClass.kt")
    public void testExtensionPropertyInInnerClass() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyInInnerClass.kt");
    }

    @Test
    @TestMetadata("extensionPropertyInNestedClass.kt")
    public void testExtensionPropertyInNestedClass() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyInNestedClass.kt");
    }

    @Test
    @TestMetadata("extensionPropertyInSAMInterface.kt")
    public void testExtensionPropertyInSAMInterface() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyInSAMInterface.kt");
    }

    @Test
    @TestMetadata("extensionPropertyJavaReceiver.kt")
    public void testExtensionPropertyJavaReceiver() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyJavaReceiver.kt");
    }

    @Test
    @TestMetadata("extensionPropertyWithAnonymoesExtensionWithALabel.kt")
    public void testExtensionPropertyWithAnonymoesExtensionWithALabel() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyWithAnonymoesExtensionWithALabel.kt");
    }

    @Test
    @TestMetadata("extensionPropertyWithAnonymousExtensionFun.kt")
    public void testExtensionPropertyWithAnonymousExtensionFun() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyWithAnonymousExtensionFun.kt");
    }

    @Test
    @TestMetadata("extensionPropertyWithAnonymousExtensionFunWithTypeParam.kt")
    public void testExtensionPropertyWithAnonymousExtensionFunWithTypeParam() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyWithAnonymousExtensionFunWithTypeParam.kt");
    }

    @Test
    @TestMetadata("extensionPropertyWithExtensionAsReceiver.kt")
    public void testExtensionPropertyWithExtensionAsReceiver() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyWithExtensionAsReceiver.kt");
    }

    @Test
    @TestMetadata("extensionPropertyWithExtensionNestedType.kt")
    public void testExtensionPropertyWithExtensionNestedType() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyWithExtensionNestedType.kt");
    }

    @Test
    @TestMetadata("extensionPropertyWithInline.kt")
    public void testExtensionPropertyWithInline() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionPropertyWithInline.kt");
    }

    @Test
    @TestMetadata("extensionProperyWithExtensionType.kt")
    public void testExtensionProperyWithExtensionType() {
      runTest("compiler/testData/codegen/box/extensionProperties/extensionProperyWithExtensionType.kt");
    }

    @Test
    @TestMetadata("genericContextOverride.kt")
    public void testGenericContextOverride() {
      runTest("compiler/testData/codegen/box/extensionProperties/genericContextOverride.kt");
    }

    @Test
    @TestMetadata("genericValForPrimitiveType.kt")
    public void testGenericValForPrimitiveType() {
      runTest("compiler/testData/codegen/box/extensionProperties/genericValForPrimitiveType.kt");
    }

    @Test
    @TestMetadata("genericValMultipleUpperBounds.kt")
    public void testGenericValMultipleUpperBounds() {
      runTest("compiler/testData/codegen/box/extensionProperties/genericValMultipleUpperBounds.kt");
    }

    @Test
    @TestMetadata("genericVarForPrimitiveType.kt")
    public void testGenericVarForPrimitiveType() {
      runTest("compiler/testData/codegen/box/extensionProperties/genericVarForPrimitiveType.kt");
    }

    @Test
    @TestMetadata("inClass.kt")
    public void testInClass() {
      runTest("compiler/testData/codegen/box/extensionProperties/inClass.kt");
    }

    @Test
    @TestMetadata("inClassLongTypeInReceiver.kt")
    public void testInClassLongTypeInReceiver() {
      runTest("compiler/testData/codegen/box/extensionProperties/inClassLongTypeInReceiver.kt");
    }

    @Test
    @TestMetadata("inClassWithGetter.kt")
    public void testInClassWithGetter() {
      runTest("compiler/testData/codegen/box/extensionProperties/inClassWithGetter.kt");
    }

    @Test
    @TestMetadata("inClassWithPrivateGetter.kt")
    public void testInClassWithPrivateGetter() {
      runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateGetter.kt");
    }

    @Test
    @TestMetadata("inClassWithPrivateSetter.kt")
    public void testInClassWithPrivateSetter() {
      runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateSetter.kt");
    }

    @Test
    @TestMetadata("inClassWithSetter.kt")
    public void testInClassWithSetter() {
      runTest("compiler/testData/codegen/box/extensionProperties/inClassWithSetter.kt");
    }

    @Test
    @TestMetadata("kt46952.kt")
    public void testKt46952() {
      runTest("compiler/testData/codegen/box/extensionProperties/kt46952.kt");
    }

    @Test
    @TestMetadata("kt9897.kt")
    public void testKt9897() {
      runTest("compiler/testData/codegen/box/extensionProperties/kt9897.kt");
    }

    @Test
    @TestMetadata("kt9897_topLevel.kt")
    public void testKt9897_topLevel() {
      runTest("compiler/testData/codegen/box/extensionProperties/kt9897_topLevel.kt");
    }

    @Test
    @TestMetadata("nonAbstractInInterface.kt")
    public void testNonAbstractInInterface() {
      runTest("compiler/testData/codegen/box/extensionProperties/nonAbstractInInterface.kt");
    }

    @Test
    @TestMetadata("propertyWithExtensionNestedType.kt")
    public void testPropertyWithExtensionNestedType() {
      runTest("compiler/testData/codegen/box/extensionProperties/propertyWithExtensionNestedType.kt");
    }

    @Test
    @TestMetadata("topLevel.kt")
    public void testTopLevel() {
      runTest("compiler/testData/codegen/box/extensionProperties/topLevel.kt");
    }

    @Test
    @TestMetadata("topLevelLongTypeInReceiver.kt")
    public void testTopLevelLongTypeInReceiver() {
      runTest("compiler/testData/codegen/box/extensionProperties/topLevelLongTypeInReceiver.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/external")
  @TestDataPath("$PROJECT_ROOT")
  public class External {
    @Test
    public void testAllFilesPresentInExternal() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/external"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("jvmStaticExternal.kt")
    public void testJvmStaticExternal() {
      runTest("compiler/testData/codegen/box/external/jvmStaticExternal.kt");
    }

    @Test
    @TestMetadata("jvmStaticExternalPrivate.kt")
    public void testJvmStaticExternalPrivate() {
      runTest("compiler/testData/codegen/box/external/jvmStaticExternalPrivate.kt");
    }

    @Test
    @TestMetadata("withDefaultArg.kt")
    public void testWithDefaultArg() {
      runTest("compiler/testData/codegen/box/external/withDefaultArg.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/fakeOverride")
  @TestDataPath("$PROJECT_ROOT")
  public class FakeOverride {
    @Test
    public void testAllFilesPresentInFakeOverride() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fakeOverride"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("complexOverriddensInLazyFunctions.kt")
    public void testComplexOverriddensInLazyFunctions() {
      runTest("compiler/testData/codegen/box/fakeOverride/complexOverriddensInLazyFunctions.kt");
    }

    @Test
    @TestMetadata("diamondFunction.kt")
    public void testDiamondFunction() {
      runTest("compiler/testData/codegen/box/fakeOverride/diamondFunction.kt");
    }

    @Test
    @TestMetadata("diamondWithNullabilityAnnotations.kt")
    public void testDiamondWithNullabilityAnnotations() {
      runTest("compiler/testData/codegen/box/fakeOverride/diamondWithNullabilityAnnotations.kt");
    }

    @Test
    @TestMetadata("fakeOverrideInAnonymousObject.kt")
    public void testFakeOverrideInAnonymousObject() {
      runTest("compiler/testData/codegen/box/fakeOverride/fakeOverrideInAnonymousObject.kt");
    }

    @Test
    @TestMetadata("fakeOverrideOfPrivateSetter.kt")
    public void testFakeOverrideOfPrivateSetter() {
      runTest("compiler/testData/codegen/box/fakeOverride/fakeOverrideOfPrivateSetter.kt");
    }

    @Test
    @TestMetadata("fakeOverrideWithMissingClassInSignature.kt")
    public void testFakeOverrideWithMissingClassInSignature() {
      runTest("compiler/testData/codegen/box/fakeOverride/fakeOverrideWithMissingClassInSignature.kt");
    }

    @Test
    @TestMetadata("fieldInJKJKHierarchy.kt")
    public void testFieldInJKJKHierarchy() {
      runTest("compiler/testData/codegen/box/fakeOverride/fieldInJKJKHierarchy.kt");
    }

    @Test
    @TestMetadata("function.kt")
    public void testFunction() {
      runTest("compiler/testData/codegen/box/fakeOverride/function.kt");
    }

    @Test
    @TestMetadata("hierarchyOfExceptions.kt")
    public void testHierarchyOfExceptions() {
      runTest("compiler/testData/codegen/box/fakeOverride/hierarchyOfExceptions.kt");
    }

    @Test
    @TestMetadata("internalFromFriendModule.kt")
    public void testInternalFromFriendModule() {
      runTest("compiler/testData/codegen/box/fakeOverride/internalFromFriendModule.kt");
    }

    @Test
    @TestMetadata("intersectionInLocal.kt")
    public void testIntersectionInLocal() {
      runTest("compiler/testData/codegen/box/fakeOverride/intersectionInLocal.kt");
    }

    @Test
    @TestMetadata("intersectionOverrideBetweenValAndVar.kt")
    public void testIntersectionOverrideBetweenValAndVar() {
      runTest("compiler/testData/codegen/box/fakeOverride/intersectionOverrideBetweenValAndVar.kt");
    }

    @Test
    @TestMetadata("javaInheritsKotlinIntersectionOverride.kt")
    public void testJavaInheritsKotlinIntersectionOverride() {
      runTest("compiler/testData/codegen/box/fakeOverride/javaInheritsKotlinIntersectionOverride.kt");
    }

    @Test
    @TestMetadata("kjkWithPackagePrivate.kt")
    public void testKjkWithPackagePrivate() {
      runTest("compiler/testData/codegen/box/fakeOverride/kjkWithPackagePrivate.kt");
    }

    @Test
    @TestMetadata("kt40180.kt")
    public void testKt40180() {
      runTest("compiler/testData/codegen/box/fakeOverride/kt40180.kt");
    }

    @Test
    @TestMetadata("kt40180_2.kt")
    public void testKt40180_2() {
      runTest("compiler/testData/codegen/box/fakeOverride/kt40180_2.kt");
    }

    @Test
    @TestMetadata("kt40180_3.kt")
    public void testKt40180_3() {
      runTest("compiler/testData/codegen/box/fakeOverride/kt40180_3.kt");
    }

    @Test
    @TestMetadata("kt49371.kt")
    public void testKt49371() {
      runTest("compiler/testData/codegen/box/fakeOverride/kt49371.kt");
    }

    @Test
    @TestMetadata("kt65116.kt")
    public void testKt65116() {
      runTest("compiler/testData/codegen/box/fakeOverride/kt65116.kt");
    }

    @Test
    @TestMetadata("kt65274.kt")
    public void testKt65274() {
      runTest("compiler/testData/codegen/box/fakeOverride/kt65274.kt");
    }

    @Test
    @TestMetadata("kt65695.kt")
    public void testKt65695() {
      runTest("compiler/testData/codegen/box/fakeOverride/kt65695.kt");
    }

    @Test
    @TestMetadata("kt65707.kt")
    public void testKt65707() {
      runTest("compiler/testData/codegen/box/fakeOverride/kt65707.kt");
    }

    @Test
    @TestMetadata("methodOfAnyFromInterface.kt")
    public void testMethodOfAnyFromInterface() {
      runTest("compiler/testData/codegen/box/fakeOverride/methodOfAnyFromInterface.kt");
    }

    @Test
    @TestMetadata("privateFakeOverrides0.kt")
    public void testPrivateFakeOverrides0() {
      runTest("compiler/testData/codegen/box/fakeOverride/privateFakeOverrides0.kt");
    }

    @Test
    @TestMetadata("privateFakeOverrides1.kt")
    public void testPrivateFakeOverrides1() {
      runTest("compiler/testData/codegen/box/fakeOverride/privateFakeOverrides1.kt");
    }

    @Test
    @TestMetadata("propertyGetter.kt")
    public void testPropertyGetter() {
      runTest("compiler/testData/codegen/box/fakeOverride/propertyGetter.kt");
    }

    @Test
    @TestMetadata("propertySetter.kt")
    public void testPropertySetter() {
      runTest("compiler/testData/codegen/box/fakeOverride/propertySetter.kt");
    }

    @Test
    @TestMetadata("staticFakeOverridesInJKKJKHierarchyMultimodule.kt")
    public void testStaticFakeOverridesInJKKJKHierarchyMultimodule() {
      runTest("compiler/testData/codegen/box/fakeOverride/staticFakeOverridesInJKKJKHierarchyMultimodule.kt");
    }

    @Test
    @TestMetadata("staticFakeOverridesInJKKJKHierarchyMultimodule_additionalInterfaces.kt")
    public void testStaticFakeOverridesInJKKJKHierarchyMultimodule_additionalInterfaces() {
      runTest("compiler/testData/codegen/box/fakeOverride/staticFakeOverridesInJKKJKHierarchyMultimodule_additionalInterfaces.kt");
    }

    @Test
    @TestMetadata("substitutionInLocal.kt")
    public void testSubstitutionInLocal() {
      runTest("compiler/testData/codegen/box/fakeOverride/substitutionInLocal.kt");
    }

    @Test
    @TestMetadata("varianceOverload.kt")
    public void testVarianceOverload() {
      runTest("compiler/testData/codegen/box/fakeOverride/varianceOverload.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/fieldRename")
  @TestDataPath("$PROJECT_ROOT")
  public class FieldRename {
    @Test
    public void testAllFilesPresentInFieldRename() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fieldRename"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("constructorAndClassObject.kt")
    public void testConstructorAndClassObject() {
      runTest("compiler/testData/codegen/box/fieldRename/constructorAndClassObject.kt");
    }

    @Test
    @TestMetadata("delegates.kt")
    public void testDelegates() {
      runTest("compiler/testData/codegen/box/fieldRename/delegates.kt");
    }

    @Test
    @TestMetadata("genericPropertyWithItself.kt")
    public void testGenericPropertyWithItself() {
      runTest("compiler/testData/codegen/box/fieldRename/genericPropertyWithItself.kt");
    }

    @Test
    @TestMetadata("jvmFieldNoClash1.kt")
    public void testJvmFieldNoClash1() {
      runTest("compiler/testData/codegen/box/fieldRename/jvmFieldNoClash1.kt");
    }

    @Test
    @TestMetadata("jvmFieldNoClash2.kt")
    public void testJvmFieldNoClash2() {
      runTest("compiler/testData/codegen/box/fieldRename/jvmFieldNoClash2.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/finally")
  @TestDataPath("$PROJECT_ROOT")
  public class Finally {
    @Test
    public void testAllFilesPresentInFinally() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/finally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("breakAndOuterFinally.kt")
    public void testBreakAndOuterFinally() {
      runTest("compiler/testData/codegen/box/finally/breakAndOuterFinally.kt");
    }

    @Test
    @TestMetadata("continueAndOuterFinally.kt")
    public void testContinueAndOuterFinally() {
      runTest("compiler/testData/codegen/box/finally/continueAndOuterFinally.kt");
    }

    @Test
    @TestMetadata("decrementInFinally.kt")
    public void testDecrementInFinally() {
      runTest("compiler/testData/codegen/box/finally/decrementInFinally.kt");
    }

    @Test
    @TestMetadata("finallyAndFinally.kt")
    public void testFinallyAndFinally() {
      runTest("compiler/testData/codegen/box/finally/finallyAndFinally.kt");
    }

    @Test
    @TestMetadata("kt31923_break.kt")
    public void testKt31923_break() {
      runTest("compiler/testData/codegen/box/finally/kt31923_break.kt");
    }

    @Test
    @TestMetadata("kt31923_continue.kt")
    public void testKt31923_continue() {
      runTest("compiler/testData/codegen/box/finally/kt31923_continue.kt");
    }

    @Test
    @TestMetadata("kt31923_return.kt")
    public void testKt31923_return() {
      runTest("compiler/testData/codegen/box/finally/kt31923_return.kt");
    }

    @Test
    @TestMetadata("kt3549.kt")
    public void testKt3549() {
      runTest("compiler/testData/codegen/box/finally/kt3549.kt");
    }

    @Test
    @TestMetadata("kt3706.kt")
    public void testKt3706() {
      runTest("compiler/testData/codegen/box/finally/kt3706.kt");
    }

    @Test
    @TestMetadata("kt3867.kt")
    public void testKt3867() {
      runTest("compiler/testData/codegen/box/finally/kt3867.kt");
    }

    @Test
    @TestMetadata("kt3874.kt")
    public void testKt3874() {
      runTest("compiler/testData/codegen/box/finally/kt3874.kt");
    }

    @Test
    @TestMetadata("kt3894.kt")
    public void testKt3894() {
      runTest("compiler/testData/codegen/box/finally/kt3894.kt");
    }

    @Test
    @TestMetadata("kt4134.kt")
    public void testKt4134() {
      runTest("compiler/testData/codegen/box/finally/kt4134.kt");
    }

    @Test
    @TestMetadata("loopAndFinally.kt")
    public void testLoopAndFinally() {
      runTest("compiler/testData/codegen/box/finally/loopAndFinally.kt");
    }

    @Test
    @TestMetadata("nestedFinallyAndNonFinallyTry.kt")
    public void testNestedFinallyAndNonFinallyTry() {
      runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry.kt");
    }

    @Test
    @TestMetadata("nestedFinallyAndNonFinallyTry2.kt")
    public void testNestedFinallyAndNonFinallyTry2() {
      runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry2.kt");
    }

    @Test
    @TestMetadata("nestedFinallyAndNonFinallyTry3.kt")
    public void testNestedFinallyAndNonFinallyTry3() {
      runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry3.kt");
    }

    @Test
    @TestMetadata("nestedFinallyAndNonFinallyTry4.kt")
    public void testNestedFinallyAndNonFinallyTry4() {
      runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry4.kt");
    }

    @Test
    @TestMetadata("notChainCatch.kt")
    public void testNotChainCatch() {
      runTest("compiler/testData/codegen/box/finally/notChainCatch.kt");
    }

    @Test
    @TestMetadata("objectInFinally.kt")
    public void testObjectInFinally() {
      runTest("compiler/testData/codegen/box/finally/objectInFinally.kt");
    }

    @Test
    @TestMetadata("returnNullFromInlined.kt")
    public void testReturnNullFromInlined() {
      runTest("compiler/testData/codegen/box/finally/returnNullFromInlined.kt");
    }

    @Test
    @TestMetadata("someStuff.kt")
    public void testSomeStuff() {
      runTest("compiler/testData/codegen/box/finally/someStuff.kt");
    }

    @Test
    @TestMetadata("tryFinally.kt")
    public void testTryFinally() {
      runTest("compiler/testData/codegen/box/finally/tryFinally.kt");
    }

    @Test
    @TestMetadata("tryLoopTry.kt")
    public void testTryLoopTry() {
      runTest("compiler/testData/codegen/box/finally/tryLoopTry.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/fir")
  @TestDataPath("$PROJECT_ROOT")
  public class Fir {
    @Test
    public void testAllFilesPresentInFir() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fir"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("anonymousOverrideWithDefaultInLocalOverridden.kt")
    public void testAnonymousOverrideWithDefaultInLocalOverridden() {
      runTest("compiler/testData/codegen/box/fir/anonymousOverrideWithDefaultInLocalOverridden.kt");
    }

    @Test
    @TestMetadata("anonymousOverrideWithDefaultInOverridden.kt")
    public void testAnonymousOverrideWithDefaultInOverridden() {
      runTest("compiler/testData/codegen/box/fir/anonymousOverrideWithDefaultInOverridden.kt");
    }

    @Test
    @TestMetadata("assertEqualsFakeOverride.kt")
    public void testAssertEqualsFakeOverride() {
      runTest("compiler/testData/codegen/box/fir/assertEqualsFakeOverride.kt");
    }

    @Test
    @TestMetadata("callableReferenceConversionTopLevel.kt")
    public void testCallableReferenceConversionTopLevel() {
      runTest("compiler/testData/codegen/box/fir/callableReferenceConversionTopLevel.kt");
    }

    @Test
    @TestMetadata("callableReferenceToJavaField.kt")
    public void testCallableReferenceToJavaField() {
      runTest("compiler/testData/codegen/box/fir/callableReferenceToJavaField.kt");
    }

    @Test
    @TestMetadata("callableReferenceToStaticFunction.kt")
    public void testCallableReferenceToStaticFunction() {
      runTest("compiler/testData/codegen/box/fir/callableReferenceToStaticFunction.kt");
    }

    @Test
    @TestMetadata("cannotCastToFunctionInIf.kt")
    public void testCannotCastToFunctionInIf() {
      runTest("compiler/testData/codegen/box/fir/cannotCastToFunctionInIf.kt");
    }

    @Test
    @TestMetadata("capitalizationNotEnhanced.kt")
    public void testCapitalizationNotEnhanced() {
      runTest("compiler/testData/codegen/box/fir/capitalizationNotEnhanced.kt");
    }

    @Test
    @TestMetadata("charAtAndOverloadWithAbstractGet.kt")
    public void testCharAtAndOverloadWithAbstractGet() {
      runTest("compiler/testData/codegen/box/fir/charAtAndOverloadWithAbstractGet.kt");
    }

    @Test
    @TestMetadata("charAtAndOverloadWithAbstractGetAndProxy.kt")
    public void testCharAtAndOverloadWithAbstractGetAndProxy() {
      runTest("compiler/testData/codegen/box/fir/charAtAndOverloadWithAbstractGetAndProxy.kt");
    }

    @Test
    @TestMetadata("charAtFinalAndOverload.kt")
    public void testCharAtFinalAndOverload() {
      runTest("compiler/testData/codegen/box/fir/charAtFinalAndOverload.kt");
    }

    @Test
    @TestMetadata("ClassBuilder.kt")
    public void testClassBuilder() {
      runTest("compiler/testData/codegen/box/fir/ClassBuilder.kt");
    }

    @Test
    @TestMetadata("classCanNotBeCastedToVoid.kt")
    public void testClassCanNotBeCastedToVoid() {
      runTest("compiler/testData/codegen/box/fir/classCanNotBeCastedToVoid.kt");
    }

    @Test
    @TestMetadata("ColorValuePanel.kt")
    public void testColorValuePanel() {
      runTest("compiler/testData/codegen/box/fir/ColorValuePanel.kt");
    }

    @Test
    @TestMetadata("complexAnnotations.kt")
    public void testComplexAnnotations() {
      runTest("compiler/testData/codegen/box/fir/complexAnnotations.kt");
    }

    @Test
    @TestMetadata("ConstValAccess.kt")
    public void testConstValAccess() {
      runTest("compiler/testData/codegen/box/fir/ConstValAccess.kt");
    }

    @Test
    @TestMetadata("contextReceiverToExtensionReceiver.kt")
    public void testContextReceiverToExtensionReceiver() {
      runTest("compiler/testData/codegen/box/fir/contextReceiverToExtensionReceiver.kt");
    }

    @Test
    @TestMetadata("copyOnObject.kt")
    public void testCopyOnObject() {
      runTest("compiler/testData/codegen/box/fir/copyOnObject.kt");
    }

    @Test
    @TestMetadata("CustomHashSetSize.kt")
    public void testCustomHashSetSize() {
      runTest("compiler/testData/codegen/box/fir/CustomHashSetSize.kt");
    }

    @Test
    @TestMetadata("CustomThrowableMessage.kt")
    public void testCustomThrowableMessage() {
      runTest("compiler/testData/codegen/box/fir/CustomThrowableMessage.kt");
    }

    @Test
    @TestMetadata("delegatedAndDataTogether.kt")
    public void testDelegatedAndDataTogether() {
      runTest("compiler/testData/codegen/box/fir/delegatedAndDataTogether.kt");
    }

    @Test
    @TestMetadata("deserializedOptInDeprecated.kt")
    public void testDeserializedOptInDeprecated() {
      runTest("compiler/testData/codegen/box/fir/deserializedOptInDeprecated.kt");
    }

    @Test
    @TestMetadata("differentSinceKotlin.kt")
    public void testDifferentSinceKotlin() {
      runTest("compiler/testData/codegen/box/fir/differentSinceKotlin.kt");
    }

    @Test
    @TestMetadata("emptyIntersectionWarning.kt")
    public void testEmptyIntersectionWarning() {
      runTest("compiler/testData/codegen/box/fir/emptyIntersectionWarning.kt");
    }

    @Test
    @TestMetadata("enumEntryInTypeJavaAnnotation.kt")
    public void testEnumEntryInTypeJavaAnnotation() {
      runTest("compiler/testData/codegen/box/fir/enumEntryInTypeJavaAnnotation.kt");
    }

    @Test
    @TestMetadata("ExtensionAlias.kt")
    public void testExtensionAlias() {
      runTest("compiler/testData/codegen/box/fir/ExtensionAlias.kt");
    }

    @Test
    @TestMetadata("externalInDependency.kt")
    public void testExternalInDependency() {
      runTest("compiler/testData/codegen/box/fir/externalInDependency.kt");
    }

    @Test
    @TestMetadata("FakeOverrideBuilder.kt")
    public void testFakeOverrideBuilder() {
      runTest("compiler/testData/codegen/box/fir/FakeOverrideBuilder.kt");
    }

    @Test
    @TestMetadata("falsePositiveBoundSmartcast.kt")
    public void testFalsePositiveBoundSmartcast() {
      runTest("compiler/testData/codegen/box/fir/falsePositiveBoundSmartcast.kt");
    }

    @Test
    @TestMetadata("findAnnotationOnDefaultMethodParameter.kt")
    public void testFindAnnotationOnDefaultMethodParameter() {
      runTest("compiler/testData/codegen/box/fir/findAnnotationOnDefaultMethodParameter.kt");
    }

    @Test
    @TestMetadata("Fir2IrClassifierStorage.kt")
    public void testFir2IrClassifierStorage() {
      runTest("compiler/testData/codegen/box/fir/Fir2IrClassifierStorage.kt");
    }

    @Test
    @TestMetadata("flexibleIntegerLiterals.kt")
    public void testFlexibleIntegerLiterals() {
      runTest("compiler/testData/codegen/box/fir/flexibleIntegerLiterals.kt");
    }

    @Test
    @TestMetadata("flexibleStaticConstantFromJava.kt")
    public void testFlexibleStaticConstantFromJava() {
      runTest("compiler/testData/codegen/box/fir/flexibleStaticConstantFromJava.kt");
    }

    @Test
    @TestMetadata("functionsDifferInTypeParameterBounds.kt")
    public void testFunctionsDifferInTypeParameterBounds() {
      runTest("compiler/testData/codegen/box/fir/functionsDifferInTypeParameterBounds.kt");
    }

    @Test
    @TestMetadata("functionsDifferInTypeParameterBounds2.kt")
    public void testFunctionsDifferInTypeParameterBounds2() {
      runTest("compiler/testData/codegen/box/fir/functionsDifferInTypeParameterBounds2.kt");
    }

    @Test
    @TestMetadata("functionsDifferInTypeParameterBounds3.kt")
    public void testFunctionsDifferInTypeParameterBounds3() {
      runTest("compiler/testData/codegen/box/fir/functionsDifferInTypeParameterBounds3.kt");
    }

    @Test
    @TestMetadata("getOnNullableTypeAlias.kt")
    public void testGetOnNullableTypeAlias() {
      runTest("compiler/testData/codegen/box/fir/getOnNullableTypeAlias.kt");
    }

    @Test
    @TestMetadata("implicitNothingInDelegate.kt")
    public void testImplicitNothingInDelegate() {
      runTest("compiler/testData/codegen/box/fir/implicitNothingInDelegate.kt");
    }

    @Test
    @TestMetadata("inaccessibleLambdaParameter.kt")
    public void testInaccessibleLambdaParameter() {
      runTest("compiler/testData/codegen/box/fir/inaccessibleLambdaParameter.kt");
    }

    @Test
    @TestMetadata("inaccessibleLambdaReceiver.kt")
    public void testInaccessibleLambdaReceiver() {
      runTest("compiler/testData/codegen/box/fir/inaccessibleLambdaReceiver.kt");
    }

    @Test
    @TestMetadata("incorrectBytecodeWithEnhancedNullability.kt")
    public void testIncorrectBytecodeWithEnhancedNullability() {
      runTest("compiler/testData/codegen/box/fir/incorrectBytecodeWithEnhancedNullability.kt");
    }

    @Test
    @TestMetadata("inferenceWithTypeAliasFromOtherModule.kt")
    public void testInferenceWithTypeAliasFromOtherModule() {
      runTest("compiler/testData/codegen/box/fir/inferenceWithTypeAliasFromOtherModule.kt");
    }

    @Test
    @TestMetadata("initializationInLocalInnerClassWithSecondaryConstructor.kt")
    public void testInitializationInLocalInnerClassWithSecondaryConstructor() {
      runTest("compiler/testData/codegen/box/fir/initializationInLocalInnerClassWithSecondaryConstructor.kt");
    }

    @Test
    @TestMetadata("internalPotentialOverride.kt")
    public void testInternalPotentialOverride() {
      runTest("compiler/testData/codegen/box/fir/internalPotentialOverride.kt");
    }

    @Test
    @TestMetadata("intersectionWithCapturedTypeWithRawUpperBound.kt")
    public void testIntersectionWithCapturedTypeWithRawUpperBound() {
      runTest("compiler/testData/codegen/box/fir/intersectionWithCapturedTypeWithRawUpperBound.kt");
    }

    @Test
    @TestMetadata("IrBuiltIns.kt")
    public void testIrBuiltIns() {
      runTest("compiler/testData/codegen/box/fir/IrBuiltIns.kt");
    }

    @Test
    @TestMetadata("JKEnumConstant.kt")
    public void testJKEnumConstant() {
      runTest("compiler/testData/codegen/box/fir/JKEnumConstant.kt");
    }

    @Test
    @TestMetadata("javaAnnotationWithDefaultValueForenumArray.kt")
    public void testJavaAnnotationWithDefaultValueForenumArray() {
      runTest("compiler/testData/codegen/box/fir/javaAnnotationWithDefaultValueForenumArray.kt");
    }

    @Test
    @TestMetadata("jvmFieldInLocalClass.kt")
    public void testJvmFieldInLocalClass() {
      runTest("compiler/testData/codegen/box/fir/jvmFieldInLocalClass.kt");
    }

    @Test
    @TestMetadata("KotlinDocumentationProvider.kt")
    public void testKotlinDocumentationProvider() {
      runTest("compiler/testData/codegen/box/fir/KotlinDocumentationProvider.kt");
    }

    @Test
    @TestMetadata("kotlinJavaKotlin.kt")
    public void testKotlinJavaKotlin() {
      runTest("compiler/testData/codegen/box/fir/kotlinJavaKotlin.kt");
    }

    @Test
    @TestMetadata("kotlinJavaStaticFromInterfaceAccidentalOverride.kt")
    public void testKotlinJavaStaticFromInterfaceAccidentalOverride() {
      runTest("compiler/testData/codegen/box/fir/kotlinJavaStaticFromInterfaceAccidentalOverride.kt");
    }

    @Test
    @TestMetadata("kt61856.kt")
    public void testKt61856() {
      runTest("compiler/testData/codegen/box/fir/kt61856.kt");
    }

    @Test
    @TestMetadata("kt68806.kt")
    public void testKt68806() {
      runTest("compiler/testData/codegen/box/fir/kt68806.kt");
    }

    @Test
    @TestMetadata("linkViaSignatures.kt")
    public void testLinkViaSignatures() {
      runTest("compiler/testData/codegen/box/fir/linkViaSignatures.kt");
    }

    @Test
    @TestMetadata("listAssignmentInWhen.kt")
    public void testListAssignmentInWhen() {
      runTest("compiler/testData/codegen/box/fir/listAssignmentInWhen.kt");
    }

    @Test
    @TestMetadata("localInvokeExtension.kt")
    public void testLocalInvokeExtension() {
      runTest("compiler/testData/codegen/box/fir/localInvokeExtension.kt");
    }

    @Test
    @TestMetadata("localOverrideWithDefaultInLocalOverridden.kt")
    public void testLocalOverrideWithDefaultInLocalOverridden() {
      runTest("compiler/testData/codegen/box/fir/localOverrideWithDefaultInLocalOverridden.kt");
    }

    @Test
    @TestMetadata("localOverrideWithDefaultInOverridden.kt")
    public void testLocalOverrideWithDefaultInOverridden() {
      runTest("compiler/testData/codegen/box/fir/localOverrideWithDefaultInOverridden.kt");
    }

    @Test
    @TestMetadata("LookupTags.kt")
    public void testLookupTags() {
      runTest("compiler/testData/codegen/box/fir/LookupTags.kt");
    }

    @Test
    @TestMetadata("manyImplFromOneJavaInterfaceWithDelegation.kt")
    public void testManyImplFromOneJavaInterfaceWithDelegation() {
      runTest("compiler/testData/codegen/box/fir/manyImplFromOneJavaInterfaceWithDelegation.kt");
    }

    @Test
    @TestMetadata("manyImplFromOneJavaInterfaceWithDelegation2.kt")
    public void testManyImplFromOneJavaInterfaceWithDelegation2() {
      runTest("compiler/testData/codegen/box/fir/manyImplFromOneJavaInterfaceWithDelegation2.kt");
    }

    @Test
    @TestMetadata("missingDependencyClassInTypeArguments.kt")
    public void testMissingDependencyClassInTypeArguments() {
      runTest("compiler/testData/codegen/box/fir/missingDependencyClassInTypeArguments.kt");
    }

    @Test
    @TestMetadata("Mockito.kt")
    public void testMockito() {
      runTest("compiler/testData/codegen/box/fir/Mockito.kt");
    }

    @Test
    @TestMetadata("multipleDefaultsFalsePositiveDelegation.kt")
    public void testMultipleDefaultsFalsePositiveDelegation() {
      runTest("compiler/testData/codegen/box/fir/multipleDefaultsFalsePositiveDelegation.kt");
    }

    @Test
    @TestMetadata("NameHighlighter.kt")
    public void testNameHighlighter() {
      runTest("compiler/testData/codegen/box/fir/NameHighlighter.kt");
    }

    @Test
    @TestMetadata("namedArgumentOnTypeAnnotation.kt")
    public void testNamedArgumentOnTypeAnnotation() {
      runTest("compiler/testData/codegen/box/fir/namedArgumentOnTypeAnnotation.kt");
    }

    @Test
    @TestMetadata("nestedClassTypeParameterDeserialization.kt")
    public void testNestedClassTypeParameterDeserialization() {
      runTest("compiler/testData/codegen/box/fir/nestedClassTypeParameterDeserialization.kt");
    }

    @Test
    @TestMetadata("noInfer.kt")
    public void testNoInfer() {
      runTest("compiler/testData/codegen/box/fir/noInfer.kt");
    }

    @Test
    @TestMetadata("noRecursiveProblemWithProjection.kt")
    public void testNoRecursiveProblemWithProjection() {
      runTest("compiler/testData/codegen/box/fir/noRecursiveProblemWithProjection.kt");
    }

    @Test
    @TestMetadata("noSymbolForIntRangeIterator.kt")
    public void testNoSymbolForIntRangeIterator() {
      runTest("compiler/testData/codegen/box/fir/noSymbolForIntRangeIterator.kt");
    }

    @Test
    @TestMetadata("notFoundClasses.kt")
    public void testNotFoundClasses() {
      runTest("compiler/testData/codegen/box/fir/notFoundClasses.kt");
    }

    @Test
    @TestMetadata("overriddenPropertyInComplexHierarchy.kt")
    public void testOverriddenPropertyInComplexHierarchy() {
      runTest("compiler/testData/codegen/box/fir/overriddenPropertyInComplexHierarchy.kt");
    }

    @Test
    @TestMetadata("publicMethodCallViaPackagePrivateCommon.kt")
    public void testPublicMethodCallViaPackagePrivateCommon() {
      runTest("compiler/testData/codegen/box/fir/publicMethodCallViaPackagePrivateCommon.kt");
    }

    @Test
    @TestMetadata("SamWithReceiverMavenProjectImportHandler.kt")
    public void testSamWithReceiverMavenProjectImportHandler() {
      runTest("compiler/testData/codegen/box/fir/SamWithReceiverMavenProjectImportHandler.kt");
    }

    @Test
    @TestMetadata("selectingLambdas.kt")
    public void testSelectingLambdas() {
      runTest("compiler/testData/codegen/box/fir/selectingLambdas.kt");
    }

    @Test
    @TestMetadata("smartCastToInvisibleClassMember.kt")
    public void testSmartCastToInvisibleClassMember() {
      runTest("compiler/testData/codegen/box/fir/smartCastToInvisibleClassMember.kt");
    }

    @Test
    @TestMetadata("sourceBinarySource.kt")
    public void testSourceBinarySource() {
      runTest("compiler/testData/codegen/box/fir/sourceBinarySource.kt");
    }

    @Test
    @TestMetadata("StackOverflowInAnnotationLoader.kt")
    public void testStackOverflowInAnnotationLoader() {
      runTest("compiler/testData/codegen/box/fir/StackOverflowInAnnotationLoader.kt");
    }

    @Test
    @TestMetadata("starProjectionLambdaNullReturn.kt")
    public void testStarProjectionLambdaNullReturn() {
      runTest("compiler/testData/codegen/box/fir/starProjectionLambdaNullReturn.kt");
    }

    @Test
    @TestMetadata("staticImportFromEnum.kt")
    public void testStaticImportFromEnum() {
      runTest("compiler/testData/codegen/box/fir/staticImportFromEnum.kt");
    }

    @Test
    @TestMetadata("staticImportFromEnumJava.kt")
    public void testStaticImportFromEnumJava() {
      runTest("compiler/testData/codegen/box/fir/staticImportFromEnumJava.kt");
    }

    @Test
    @TestMetadata("staticImportFromObject.kt")
    public void testStaticImportFromObject() {
      runTest("compiler/testData/codegen/box/fir/staticImportFromObject.kt");
    }

    @Test
    @TestMetadata("staticImportViaInheritance.kt")
    public void testStaticImportViaInheritance() {
      runTest("compiler/testData/codegen/box/fir/staticImportViaInheritance.kt");
    }

    @Test
    @TestMetadata("suppressedInvisibleReferenceQualifier.kt")
    public void testSuppressedInvisibleReferenceQualifier() {
      runTest("compiler/testData/codegen/box/fir/suppressedInvisibleReferenceQualifier.kt");
    }

    @Test
    @TestMetadata("SuspendExtension.kt")
    public void testSuspendExtension() {
      runTest("compiler/testData/codegen/box/fir/SuspendExtension.kt");
    }

    @Test
    @TestMetadata("SuspendFunctionReference.kt")
    public void testSuspendFunctionReference() {
      runTest("compiler/testData/codegen/box/fir/SuspendFunctionReference.kt");
    }

    @Test
    @TestMetadata("syntheticPropertyThroughJava.kt")
    public void testSyntheticPropertyThroughJava() {
      runTest("compiler/testData/codegen/box/fir/syntheticPropertyThroughJava.kt");
    }

    @Test
    @TestMetadata("syntheticPropertyThroughJavaMultiModule.kt")
    public void testSyntheticPropertyThroughJavaMultiModule() {
      runTest("compiler/testData/codegen/box/fir/syntheticPropertyThroughJavaMultiModule.kt");
    }

    @Test
    @TestMetadata("syntheticPropertyThroughJavaWithSetter.kt")
    public void testSyntheticPropertyThroughJavaWithSetter() {
      runTest("compiler/testData/codegen/box/fir/syntheticPropertyThroughJavaWithSetter.kt");
    }

    @Test
    @TestMetadata("toLong.kt")
    public void testToLong() {
      runTest("compiler/testData/codegen/box/fir/toLong.kt");
    }

    @Test
    @TestMetadata("typeParameterInClashingAccessor.kt")
    public void testTypeParameterInClashingAccessor() {
      runTest("compiler/testData/codegen/box/fir/typeParameterInClashingAccessor.kt");
    }

    @Test
    @TestMetadata("TypeParameterInNestedClass.kt")
    public void testTypeParameterInNestedClass() {
      runTest("compiler/testData/codegen/box/fir/TypeParameterInNestedClass.kt");
    }

    @Test
    @TestMetadata("TypeParameterInNestedClass2.kt")
    public void testTypeParameterInNestedClass2() {
      runTest("compiler/testData/codegen/box/fir/TypeParameterInNestedClass2.kt");
    }

    @Test
    @TestMetadata("unqualifiedEnum.kt")
    public void testUnqualifiedEnum() {
      runTest("compiler/testData/codegen/box/fir/unqualifiedEnum.kt");
    }

    @Test
    @TestMetadata("vararg.kt")
    public void testVararg() {
      runTest("compiler/testData/codegen/box/fir/vararg.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/fir/primitivesInJava")
    @TestDataPath("$PROJECT_ROOT")
    public class PrimitivesInJava {
      @Test
      public void testAllFilesPresentInPrimitivesInJava() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fir/primitivesInJava"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("primitiveDoubleJavaKotlinIntersection.kt")
      public void testPrimitiveDoubleJavaKotlinIntersection() {
        runTest("compiler/testData/codegen/box/fir/primitivesInJava/primitiveDoubleJavaKotlinIntersection.kt");
      }

      @Test
      @TestMetadata("triangleWithFlexibleType.kt")
      public void testTriangleWithFlexibleType() {
        runTest("compiler/testData/codegen/box/fir/primitivesInJava/triangleWithFlexibleType.kt");
      }

      @Test
      @TestMetadata("triangleWithFlexibleTypeAndSubstitution.kt")
      public void testTriangleWithFlexibleTypeAndSubstitution() {
        runTest("compiler/testData/codegen/box/fir/primitivesInJava/triangleWithFlexibleTypeAndSubstitution.kt");
      }

      @Test
      @TestMetadata("triangleWithFlexibleTypeAndSubstitution2.kt")
      public void testTriangleWithFlexibleTypeAndSubstitution2() {
        runTest("compiler/testData/codegen/box/fir/primitivesInJava/triangleWithFlexibleTypeAndSubstitution2.kt");
      }

      @Test
      @TestMetadata("triangleWithFlexibleTypeAndSubstitution3.kt")
      public void testTriangleWithFlexibleTypeAndSubstitution3() {
        runTest("compiler/testData/codegen/box/fir/primitivesInJava/triangleWithFlexibleTypeAndSubstitution3.kt");
      }

      @Test
      @TestMetadata("triangleWithFlexibleTypeAndSubstitution5.kt")
      public void testTriangleWithFlexibleTypeAndSubstitution5() {
        runTest("compiler/testData/codegen/box/fir/primitivesInJava/triangleWithFlexibleTypeAndSubstitution5.kt");
      }

      @Test
      @TestMetadata("triangleWithNullableType.kt")
      public void testTriangleWithNullableType() {
        runTest("compiler/testData/codegen/box/fir/primitivesInJava/triangleWithNullableType.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/fullJdk")
  @TestDataPath("$PROJECT_ROOT")
  public class FullJdk {
    @Test
    public void testAllFilesPresentInFullJdk() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("charBuffer.kt")
    public void testCharBuffer() {
      runTest("compiler/testData/codegen/box/fullJdk/charBuffer.kt");
    }

    @Test
    @TestMetadata("ifInWhile.kt")
    public void testIfInWhile() {
      runTest("compiler/testData/codegen/box/fullJdk/ifInWhile.kt");
    }

    @Test
    @TestMetadata("intCountDownLatchExtension.kt")
    public void testIntCountDownLatchExtension() {
      runTest("compiler/testData/codegen/box/fullJdk/intCountDownLatchExtension.kt");
    }

    @Test
    @TestMetadata("kt31757.kt")
    public void testKt31757() {
      runTest("compiler/testData/codegen/box/fullJdk/kt31757.kt");
    }

    @Test
    @TestMetadata("kt434.kt")
    public void testKt434() {
      runTest("compiler/testData/codegen/box/fullJdk/kt434.kt");
    }

    @Test
    @TestMetadata("kt46540.kt")
    public void testKt46540() {
      runTest("compiler/testData/codegen/box/fullJdk/kt46540.kt");
    }

    @Test
    @TestMetadata("platformTypeAssertionStackTrace.kt")
    public void testPlatformTypeAssertionStackTrace() {
      runTest("compiler/testData/codegen/box/fullJdk/platformTypeAssertionStackTrace.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/fullJdk/native")
    @TestDataPath("$PROJECT_ROOT")
    public class Native {
      @Test
      public void testAllFilesPresentInNative() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/native"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("nativePropertyAccessors.kt")
      public void testNativePropertyAccessors() {
        runTest("compiler/testData/codegen/box/fullJdk/native/nativePropertyAccessors.kt");
      }

      @Test
      @TestMetadata("simpleNative.kt")
      public void testSimpleNative() {
        runTest("compiler/testData/codegen/box/fullJdk/native/simpleNative.kt");
      }

      @Test
      @TestMetadata("topLevel.kt")
      public void testTopLevel() {
        runTest("compiler/testData/codegen/box/fullJdk/native/topLevel.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/fullJdk/regressions")
    @TestDataPath("$PROJECT_ROOT")
    public class Regressions {
      @Test
      public void testAllFilesPresentInRegressions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/regressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kt15112.kt")
      public void testKt15112() {
        runTest("compiler/testData/codegen/box/fullJdk/regressions/kt15112.kt");
      }

      @Test
      @TestMetadata("kt1770.kt")
      public void testKt1770() {
        runTest("compiler/testData/codegen/box/fullJdk/regressions/kt1770.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/funInterface")
  @TestDataPath("$PROJECT_ROOT")
  public class FunInterface {
    @Test
    public void testAllFilesPresentInFunInterface() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("basicFunInterface.kt")
    public void testBasicFunInterface() {
      runTest("compiler/testData/codegen/box/funInterface/basicFunInterface.kt");
    }

    @Test
    @TestMetadata("basicFunInterfaceConversion.kt")
    public void testBasicFunInterfaceConversion() {
      runTest("compiler/testData/codegen/box/funInterface/basicFunInterfaceConversion.kt");
    }

    @Test
    @TestMetadata("basicFunInterfaceConversionClash.kt")
    public void testBasicFunInterfaceConversionClash() {
      runTest("compiler/testData/codegen/box/funInterface/basicFunInterfaceConversionClash.kt");
    }

    @Test
    @TestMetadata("castFromAny.kt")
    public void testCastFromAny() {
      runTest("compiler/testData/codegen/box/funInterface/castFromAny.kt");
    }

    @Test
    @TestMetadata("contravariantIntersectionType.kt")
    public void testContravariantIntersectionType() {
      runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionType.kt");
    }

    @Test
    @TestMetadata("contravariantIntersectionTypeWithNonTrivialCommonSupertype.kt")
    public void testContravariantIntersectionTypeWithNonTrivialCommonSupertype() {
      runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionTypeWithNonTrivialCommonSupertype.kt");
    }

    @Test
    @TestMetadata("contravariantIntersectionTypeWithNonTrivialCommonSupertype2.kt")
    public void testContravariantIntersectionTypeWithNonTrivialCommonSupertype2() {
      runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionTypeWithNonTrivialCommonSupertype2.kt");
    }

    @Test
    @TestMetadata("funConversionInVararg.kt")
    public void testFunConversionInVararg() {
      runTest("compiler/testData/codegen/box/funInterface/funConversionInVararg.kt");
    }

    @Test
    @TestMetadata("funInterfaceCallInLambda.kt")
    public void testFunInterfaceCallInLambda() {
      runTest("compiler/testData/codegen/box/funInterface/funInterfaceCallInLambda.kt");
    }

    @Test
    @TestMetadata("funInterfaceInheritance.kt")
    public void testFunInterfaceInheritance() {
      runTest("compiler/testData/codegen/box/funInterface/funInterfaceInheritance.kt");
    }

    @Test
    @TestMetadata("funInterfaceTypealias.kt")
    public void testFunInterfaceTypealias() {
      runTest("compiler/testData/codegen/box/funInterface/funInterfaceTypealias.kt");
    }

    @Test
    @TestMetadata("funInterfaceWithReceiver.kt")
    public void testFunInterfaceWithReceiver() {
      runTest("compiler/testData/codegen/box/funInterface/funInterfaceWithReceiver.kt");
    }

    @Test
    @TestMetadata("funInterfaceWithSuspendMethod.kt")
    public void testFunInterfaceWithSuspendMethod() {
      runTest("compiler/testData/codegen/box/funInterface/funInterfaceWithSuspendMethod.kt");
    }

    @Test
    @TestMetadata("implIsNotFunction.kt")
    public void testImplIsNotFunction() {
      runTest("compiler/testData/codegen/box/funInterface/implIsNotFunction.kt");
    }

    @Test
    @TestMetadata("inlinedSamWrapper.kt")
    public void testInlinedSamWrapper() {
      runTest("compiler/testData/codegen/box/funInterface/inlinedSamWrapper.kt");
    }

    @Test
    @TestMetadata("intersectionTypeToFunInterfaceConversion.kt")
    public void testIntersectionTypeToFunInterfaceConversion() {
      runTest("compiler/testData/codegen/box/funInterface/intersectionTypeToFunInterfaceConversion.kt");
    }

    @Test
    @TestMetadata("irrelevantPrivateDeclarations.kt")
    public void testIrrelevantPrivateDeclarations() {
      runTest("compiler/testData/codegen/box/funInterface/irrelevantPrivateDeclarations.kt");
    }

    @Test
    @TestMetadata("kt41670.kt")
    public void testKt41670() {
      runTest("compiler/testData/codegen/box/funInterface/kt41670.kt");
    }

    @Test
    @TestMetadata("kt44827_funInterface.kt")
    public void testKt44827_funInterface() {
      runTest("compiler/testData/codegen/box/funInterface/kt44827_funInterface.kt");
    }

    @Test
    @TestMetadata("kt45444_privateFunInterface.kt")
    public void testKt45444_privateFunInterface() {
      runTest("compiler/testData/codegen/box/funInterface/kt45444_privateFunInterface.kt");
    }

    @Test
    @TestMetadata("kt46512_indyFunInterfaceOverCallableReference.kt")
    public void testKt46512_indyFunInterfaceOverCallableReference() {
      runTest("compiler/testData/codegen/box/funInterface/kt46512_indyFunInterfaceOverCallableReference.kt");
    }

    @Test
    @TestMetadata("kt46908_functionSupertype.kt")
    public void testKt46908_functionSupertype() {
      runTest("compiler/testData/codegen/box/funInterface/kt46908_functionSupertype.kt");
    }

    @Test
    @TestMetadata("kt49384.kt")
    public void testKt49384() {
      runTest("compiler/testData/codegen/box/funInterface/kt49384.kt");
    }

    @Test
    @TestMetadata("kt49384_getSame.kt")
    public void testKt49384_getSame() {
      runTest("compiler/testData/codegen/box/funInterface/kt49384_getSame.kt");
    }

    @Test
    @TestMetadata("multimodule.kt")
    public void testMultimodule() {
      runTest("compiler/testData/codegen/box/funInterface/multimodule.kt");
    }

    @Test
    @TestMetadata("nonAbstractMethod.kt")
    public void testNonAbstractMethod() {
      runTest("compiler/testData/codegen/box/funInterface/nonAbstractMethod.kt");
    }

    @Test
    @TestMetadata("nonTrivialProjectionInSuperType.kt")
    public void testNonTrivialProjectionInSuperType() {
      runTest("compiler/testData/codegen/box/funInterface/nonTrivialProjectionInSuperType.kt");
    }

    @Test
    @TestMetadata("nullableSam.kt")
    public void testNullableSam() {
      runTest("compiler/testData/codegen/box/funInterface/nullableSam.kt");
    }

    @Test
    @TestMetadata("partialSam.kt")
    public void testPartialSam() {
      runTest("compiler/testData/codegen/box/funInterface/partialSam.kt");
    }

    @Test
    @TestMetadata("primitiveConversions.kt")
    public void testPrimitiveConversions() {
      runTest("compiler/testData/codegen/box/funInterface/primitiveConversions.kt");
    }

    @Test
    @TestMetadata("receiverEvaluatedOnce.kt")
    public void testReceiverEvaluatedOnce() {
      runTest("compiler/testData/codegen/box/funInterface/receiverEvaluatedOnce.kt");
    }

    @Test
    @TestMetadata("samConstructorExplicitInvocation.kt")
    public void testSamConstructorExplicitInvocation() {
      runTest("compiler/testData/codegen/box/funInterface/samConstructorExplicitInvocation.kt");
    }

    @Test
    @TestMetadata("samConversionToGenericInterfaceInGenericFun.kt")
    public void testSamConversionToGenericInterfaceInGenericFun() {
      runTest("compiler/testData/codegen/box/funInterface/samConversionToGenericInterfaceInGenericFun.kt");
    }

    @Test
    @TestMetadata("subtypeOfFunctionalTypeToFunInterfaceConversion.kt")
    public void testSubtypeOfFunctionalTypeToFunInterfaceConversion() {
      runTest("compiler/testData/codegen/box/funInterface/subtypeOfFunctionalTypeToFunInterfaceConversion.kt");
    }

    @Test
    @TestMetadata("suspendFunInterfaceConversionCodegen.kt")
    public void testSuspendFunInterfaceConversionCodegen() {
      runTest("compiler/testData/codegen/box/funInterface/suspendFunInterfaceConversionCodegen.kt");
    }

    @Test
    @TestMetadata("typealiasedFunInterface.kt")
    public void testTypealiasedFunInterface() {
      runTest("compiler/testData/codegen/box/funInterface/typealiasedFunInterface.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/funInterface/equality")
    @TestDataPath("$PROJECT_ROOT")
    public class Equality {
      @Test
      public void testAllFilesPresentInEquality() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/funInterface/equality"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("functionReferencesBound.kt")
      public void testFunctionReferencesBound() {
        runTest("compiler/testData/codegen/box/funInterface/equality/functionReferencesBound.kt");
      }

      @Test
      @TestMetadata("functionReferencesUnbound.kt")
      public void testFunctionReferencesUnbound() {
        runTest("compiler/testData/codegen/box/funInterface/equality/functionReferencesUnbound.kt");
      }

      @Test
      @TestMetadata("lambdaRuntimeConversion.kt")
      public void testLambdaRuntimeConversion() {
        runTest("compiler/testData/codegen/box/funInterface/equality/lambdaRuntimeConversion.kt");
      }

      @Test
      @TestMetadata("localFunctionReferences.kt")
      public void testLocalFunctionReferences() {
        runTest("compiler/testData/codegen/box/funInterface/equality/localFunctionReferences.kt");
      }

      @Test
      @TestMetadata("simpleLambdas.kt")
      public void testSimpleLambdas() {
        runTest("compiler/testData/codegen/box/funInterface/equality/simpleLambdas.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/function")
  @TestDataPath("$PROJECT_ROOT")
  public class Function {
    @Test
    public void testAllFilesPresentInFunction() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arithmetic.kt")
    public void testArithmetic() {
      runTest("compiler/testData/codegen/box/function/arithmetic.kt");
    }

    @Test
    @TestMetadata("boolean.kt")
    public void testBoolean() {
      runTest("compiler/testData/codegen/box/function/boolean.kt");
    }

    @Test
    @TestMetadata("defaults.kt")
    public void testDefaults() {
      runTest("compiler/testData/codegen/box/function/defaults.kt");
    }

    @Test
    @TestMetadata("defaults1.kt")
    public void testDefaults1() {
      runTest("compiler/testData/codegen/box/function/defaults1.kt");
    }

    @Test
    @TestMetadata("defaults10.kt")
    public void testDefaults10() {
      runTest("compiler/testData/codegen/box/function/defaults10.kt");
    }

    @Test
    @TestMetadata("defaults2.kt")
    public void testDefaults2() {
      runTest("compiler/testData/codegen/box/function/defaults2.kt");
    }

    @Test
    @TestMetadata("defaults3.kt")
    public void testDefaults3() {
      runTest("compiler/testData/codegen/box/function/defaults3.kt");
    }

    @Test
    @TestMetadata("defaults4.kt")
    public void testDefaults4() {
      runTest("compiler/testData/codegen/box/function/defaults4.kt");
    }

    @Test
    @TestMetadata("defaults5.kt")
    public void testDefaults5() {
      runTest("compiler/testData/codegen/box/function/defaults5.kt");
    }

    @Test
    @TestMetadata("defaults6.kt")
    public void testDefaults6() {
      runTest("compiler/testData/codegen/box/function/defaults6.kt");
    }

    @Test
    @TestMetadata("defaults7.kt")
    public void testDefaults7() {
      runTest("compiler/testData/codegen/box/function/defaults7.kt");
    }

    @Test
    @TestMetadata("defaults8.kt")
    public void testDefaults8() {
      runTest("compiler/testData/codegen/box/function/defaults8.kt");
    }

    @Test
    @TestMetadata("defaults9.kt")
    public void testDefaults9() {
      runTest("compiler/testData/codegen/box/function/defaults9.kt");
    }

    @Test
    @TestMetadata("defaultsFromFakeOverride.kt")
    public void testDefaultsFromFakeOverride() {
      runTest("compiler/testData/codegen/box/function/defaultsFromFakeOverride.kt");
    }

    @Test
    @TestMetadata("defaultsWithInlineClasses.kt")
    public void testDefaultsWithInlineClasses() {
      runTest("compiler/testData/codegen/box/function/defaultsWithInlineClasses.kt");
    }

    @Test
    @TestMetadata("defaultsWithVarArg1.kt")
    public void testDefaultsWithVarArg1() {
      runTest("compiler/testData/codegen/box/function/defaultsWithVarArg1.kt");
    }

    @Test
    @TestMetadata("defaultsWithVarArg2.kt")
    public void testDefaultsWithVarArg2() {
      runTest("compiler/testData/codegen/box/function/defaultsWithVarArg2.kt");
    }

    @Test
    @TestMetadata("eqeq.kt")
    public void testEqeq() {
      runTest("compiler/testData/codegen/box/function/eqeq.kt");
    }

    @Test
    @TestMetadata("extension.kt")
    public void testExtension() {
      runTest("compiler/testData/codegen/box/function/extension.kt");
    }

    @Test
    @TestMetadata("intrinsic.kt")
    public void testIntrinsic() {
      runTest("compiler/testData/codegen/box/function/intrinsic.kt");
    }

    @Test
    @TestMetadata("localFunction.kt")
    public void testLocalFunction() {
      runTest("compiler/testData/codegen/box/function/localFunction.kt");
    }

    @Test
    @TestMetadata("localFunction2.kt")
    public void testLocalFunction2() {
      runTest("compiler/testData/codegen/box/function/localFunction2.kt");
    }

    @Test
    @TestMetadata("localFunction3.kt")
    public void testLocalFunction3() {
      runTest("compiler/testData/codegen/box/function/localFunction3.kt");
    }

    @Test
    @TestMetadata("minus_eq.kt")
    public void testMinus_eq() {
      runTest("compiler/testData/codegen/box/function/minus_eq.kt");
    }

    @Test
    @TestMetadata("named.kt")
    public void testNamed() {
      runTest("compiler/testData/codegen/box/function/named.kt");
    }

    @Test
    @TestMetadata("nothingNReturningSafeCall.kt")
    public void testNothingNReturningSafeCall() {
      runTest("compiler/testData/codegen/box/function/nothingNReturningSafeCall.kt");
    }

    @Test
    @TestMetadata("plus_eq.kt")
    public void testPlus_eq() {
      runTest("compiler/testData/codegen/box/function/plus_eq.kt");
    }

    @Test
    @TestMetadata("referenceBigArity.kt")
    public void testReferenceBigArity() {
      runTest("compiler/testData/codegen/box/function/referenceBigArity.kt");
    }

    @Test
    @TestMetadata("sum.kt")
    public void testSum() {
      runTest("compiler/testData/codegen/box/function/sum.kt");
    }

    @Test
    @TestMetadata("sum_3const.kt")
    public void testSum_3const() {
      runTest("compiler/testData/codegen/box/function/sum_3const.kt");
    }

    @Test
    @TestMetadata("sum_foo_bar.kt")
    public void testSum_foo_bar() {
      runTest("compiler/testData/codegen/box/function/sum_foo_bar.kt");
    }

    @Test
    @TestMetadata("sum_func.kt")
    public void testSum_func() {
      runTest("compiler/testData/codegen/box/function/sum_func.kt");
    }

    @Test
    @TestMetadata("sum_imm.kt")
    public void testSum_imm() {
      runTest("compiler/testData/codegen/box/function/sum_imm.kt");
    }

    @Test
    @TestMetadata("sum_mixed.kt")
    public void testSum_mixed() {
      runTest("compiler/testData/codegen/box/function/sum_mixed.kt");
    }

    @Test
    @TestMetadata("sum_silly.kt")
    public void testSum_silly() {
      runTest("compiler/testData/codegen/box/function/sum_silly.kt");
    }

    @Test
    @TestMetadata("unreachableStatementAfterReturn.kt")
    public void testUnreachableStatementAfterReturn() {
      runTest("compiler/testData/codegen/box/function/unreachableStatementAfterReturn.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/functions")
  @TestDataPath("$PROJECT_ROOT")
  public class Functions {
    @Test
    public void testAllFilesPresentInFunctions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("coerceVoidToArray.kt")
    public void testCoerceVoidToArray() {
      runTest("compiler/testData/codegen/box/functions/coerceVoidToArray.kt");
    }

    @Test
    @TestMetadata("coerceVoidToObject.kt")
    public void testCoerceVoidToObject() {
      runTest("compiler/testData/codegen/box/functions/coerceVoidToObject.kt");
    }

    @Test
    @TestMetadata("constructor.kt")
    public void testConstructor() {
      runTest("compiler/testData/codegen/box/functions/constructor.kt");
    }

    @Test
    @TestMetadata("dataLocalVariable.kt")
    public void testDataLocalVariable() {
      runTest("compiler/testData/codegen/box/functions/dataLocalVariable.kt");
    }

    @Test
    @TestMetadata("defaultargs.kt")
    public void testDefaultargs() {
      runTest("compiler/testData/codegen/box/functions/defaultargs.kt");
    }

    @Test
    @TestMetadata("defaultargs1.kt")
    public void testDefaultargs1() {
      runTest("compiler/testData/codegen/box/functions/defaultargs1.kt");
    }

    @Test
    @TestMetadata("defaultargs2.kt")
    public void testDefaultargs2() {
      runTest("compiler/testData/codegen/box/functions/defaultargs2.kt");
    }

    @Test
    @TestMetadata("defaultargs3.kt")
    public void testDefaultargs3() {
      runTest("compiler/testData/codegen/box/functions/defaultargs3.kt");
    }

    @Test
    @TestMetadata("defaultargs4.kt")
    public void testDefaultargs4() {
      runTest("compiler/testData/codegen/box/functions/defaultargs4.kt");
    }

    @Test
    @TestMetadata("defaultargs5.kt")
    public void testDefaultargs5() {
      runTest("compiler/testData/codegen/box/functions/defaultargs5.kt");
    }

    @Test
    @TestMetadata("defaultargs6.kt")
    public void testDefaultargs6() {
      runTest("compiler/testData/codegen/box/functions/defaultargs6.kt");
    }

    @Test
    @TestMetadata("defaultargs7.kt")
    public void testDefaultargs7() {
      runTest("compiler/testData/codegen/box/functions/defaultargs7.kt");
    }

    @Test
    @TestMetadata("delegatedPropertyWithMultipleOverriddens_generics.kt")
    public void testDelegatedPropertyWithMultipleOverriddens_generics() {
      runTest("compiler/testData/codegen/box/functions/delegatedPropertyWithMultipleOverriddens_generics.kt");
    }

    @Test
    @TestMetadata("delegatedPropertyWithMultipleOverriddens_noGenerics.kt")
    public void testDelegatedPropertyWithMultipleOverriddens_noGenerics() {
      runTest("compiler/testData/codegen/box/functions/delegatedPropertyWithMultipleOverriddens_noGenerics.kt");
    }

    @Test
    @TestMetadata("ea33909.kt")
    public void testEa33909() {
      runTest("compiler/testData/codegen/box/functions/ea33909.kt");
    }

    @Test
    @TestMetadata("fakeDescriptorWithSeveralOverridenOne.kt")
    public void testFakeDescriptorWithSeveralOverridenOne() {
      runTest("compiler/testData/codegen/box/functions/fakeDescriptorWithSeveralOverridenOne.kt");
    }

    @Test
    @TestMetadata("functionNtoString.kt")
    public void testFunctionNtoString() {
      runTest("compiler/testData/codegen/box/functions/functionNtoString.kt");
    }

    @Test
    @TestMetadata("functionNtoStringGeneric.kt")
    public void testFunctionNtoStringGeneric() {
      runTest("compiler/testData/codegen/box/functions/functionNtoStringGeneric.kt");
    }

    @Test
    @TestMetadata("functionNtoStringNoReflect.kt")
    public void testFunctionNtoStringNoReflect() {
      runTest("compiler/testData/codegen/box/functions/functionNtoStringNoReflect.kt");
    }

    @Test
    @TestMetadata("infixRecursiveCall.kt")
    public void testInfixRecursiveCall() {
      runTest("compiler/testData/codegen/box/functions/infixRecursiveCall.kt");
    }

    @Test
    @TestMetadata("kt1038.kt")
    public void testKt1038() {
      runTest("compiler/testData/codegen/box/functions/kt1038.kt");
    }

    @Test
    @TestMetadata("kt1199.kt")
    public void testKt1199() {
      runTest("compiler/testData/codegen/box/functions/kt1199.kt");
    }

    @Test
    @TestMetadata("kt1413.kt")
    public void testKt1413() {
      runTest("compiler/testData/codegen/box/functions/kt1413.kt");
    }

    @Test
    @TestMetadata("kt1649_1.kt")
    public void testKt1649_1() {
      runTest("compiler/testData/codegen/box/functions/kt1649_1.kt");
    }

    @Test
    @TestMetadata("kt1649_2.kt")
    public void testKt1649_2() {
      runTest("compiler/testData/codegen/box/functions/kt1649_2.kt");
    }

    @Test
    @TestMetadata("kt1739.kt")
    public void testKt1739() {
      runTest("compiler/testData/codegen/box/functions/kt1739.kt");
    }

    @Test
    @TestMetadata("kt2270.kt")
    public void testKt2270() {
      runTest("compiler/testData/codegen/box/functions/kt2270.kt");
    }

    @Test
    @TestMetadata("kt2271.kt")
    public void testKt2271() {
      runTest("compiler/testData/codegen/box/functions/kt2271.kt");
    }

    @Test
    @TestMetadata("kt2280.kt")
    public void testKt2280() {
      runTest("compiler/testData/codegen/box/functions/kt2280.kt");
    }

    @Test
    @TestMetadata("kt2481.kt")
    public void testKt2481() {
      runTest("compiler/testData/codegen/box/functions/kt2481.kt");
    }

    @Test
    @TestMetadata("kt2716.kt")
    public void testKt2716() {
      runTest("compiler/testData/codegen/box/functions/kt2716.kt");
    }

    @Test
    @TestMetadata("kt2739.kt")
    public void testKt2739() {
      runTest("compiler/testData/codegen/box/functions/kt2739.kt");
    }

    @Test
    @TestMetadata("kt2929.kt")
    public void testKt2929() {
      runTest("compiler/testData/codegen/box/functions/kt2929.kt");
    }

    @Test
    @TestMetadata("kt3214.kt")
    public void testKt3214() {
      runTest("compiler/testData/codegen/box/functions/kt3214.kt");
    }

    @Test
    @TestMetadata("kt3313.kt")
    public void testKt3313() {
      runTest("compiler/testData/codegen/box/functions/kt3313.kt");
    }

    @Test
    @TestMetadata("kt3573.kt")
    public void testKt3573() {
      runTest("compiler/testData/codegen/box/functions/kt3573.kt");
    }

    @Test
    @TestMetadata("kt3724.kt")
    public void testKt3724() {
      runTest("compiler/testData/codegen/box/functions/kt3724.kt");
    }

    @Test
    @TestMetadata("kt395.kt")
    public void testKt395() {
      runTest("compiler/testData/codegen/box/functions/kt395.kt");
    }

    @Test
    @TestMetadata("kt47449.kt")
    public void testKt47449() {
      runTest("compiler/testData/codegen/box/functions/kt47449.kt");
    }

    @Test
    @TestMetadata("kt47527.kt")
    public void testKt47527() {
      runTest("compiler/testData/codegen/box/functions/kt47527.kt");
    }

    @Test
    @TestMetadata("kt48058.kt")
    public void testKt48058() {
      runTest("compiler/testData/codegen/box/functions/kt48058.kt");
    }

    @Test
    @TestMetadata("kt48989.kt")
    public void testKt48989() {
      runTest("compiler/testData/codegen/box/functions/kt48989.kt");
    }

    @Test
    @TestMetadata("kt58825_arrayOverloads.kt")
    public void testKt58825_arrayOverloads() {
      runTest("compiler/testData/codegen/box/functions/kt58825_arrayOverloads.kt");
    }

    @Test
    @TestMetadata("kt785.kt")
    public void testKt785() {
      runTest("compiler/testData/codegen/box/functions/kt785.kt");
    }

    @Test
    @TestMetadata("kt873.kt")
    public void testKt873() {
      runTest("compiler/testData/codegen/box/functions/kt873.kt");
    }

    @Test
    @TestMetadata("lambdaWithTwoContextReceivers.kt")
    public void testLambdaWithTwoContextReceivers() {
      runTest("compiler/testData/codegen/box/functions/lambdaWithTwoContextReceivers.kt");
    }

    @Test
    @TestMetadata("localFunction.kt")
    public void testLocalFunction() {
      runTest("compiler/testData/codegen/box/functions/localFunction.kt");
    }

    @Test
    @TestMetadata("localReturnInsideFunctionExpression.kt")
    public void testLocalReturnInsideFunctionExpression() {
      runTest("compiler/testData/codegen/box/functions/localReturnInsideFunctionExpression.kt");
    }

    @Test
    @TestMetadata("max.kt")
    public void testMax() {
      runTest("compiler/testData/codegen/box/functions/max.kt");
    }

    @Test
    @TestMetadata("mutualInline.kt")
    public void testMutualInline() {
      runTest("compiler/testData/codegen/box/functions/mutualInline.kt");
    }

    @Test
    @TestMetadata("nothisnoclosure.kt")
    public void testNothisnoclosure() {
      runTest("compiler/testData/codegen/box/functions/nothisnoclosure.kt");
    }

    @Test
    @TestMetadata("overloadByInterfaceType.kt")
    public void testOverloadByInterfaceType() {
      runTest("compiler/testData/codegen/box/functions/overloadByInterfaceType.kt");
    }

    @Test
    @TestMetadata("prefixRecursiveCall.kt")
    public void testPrefixRecursiveCall() {
      runTest("compiler/testData/codegen/box/functions/prefixRecursiveCall.kt");
    }

    @Test
    @TestMetadata("recursiveCompareTo.kt")
    public void testRecursiveCompareTo() {
      runTest("compiler/testData/codegen/box/functions/recursiveCompareTo.kt");
    }

    @Test
    @TestMetadata("recursiveIncrementCall.kt")
    public void testRecursiveIncrementCall() {
      runTest("compiler/testData/codegen/box/functions/recursiveIncrementCall.kt");
    }

    @Test
    @TestMetadata("referencesStaticInnerClassMethod.kt")
    public void testReferencesStaticInnerClassMethod() {
      runTest("compiler/testData/codegen/box/functions/referencesStaticInnerClassMethod.kt");
    }

    @Test
    @TestMetadata("referencesStaticInnerClassMethodL2.kt")
    public void testReferencesStaticInnerClassMethodL2() {
      runTest("compiler/testData/codegen/box/functions/referencesStaticInnerClassMethodL2.kt");
    }

    @Test
    @TestMetadata("typeParameterAsUpperBound.kt")
    public void testTypeParameterAsUpperBound() {
      runTest("compiler/testData/codegen/box/functions/typeParameterAsUpperBound.kt");
    }

    @Test
    @TestMetadata("typeParametersInLocalFunction.kt")
    public void testTypeParametersInLocalFunction() {
      runTest("compiler/testData/codegen/box/functions/typeParametersInLocalFunction.kt");
    }

    @Test
    @TestMetadata("unrelatedUpperBounds.kt")
    public void testUnrelatedUpperBounds() {
      runTest("compiler/testData/codegen/box/functions/unrelatedUpperBounds.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/functions/bigArity")
    @TestDataPath("$PROJECT_ROOT")
    public class BigArity {
      @Test
      public void testAllFilesPresentInBigArity() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/bigArity"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("callFromJava.kt")
      public void testCallFromJava() {
        runTest("compiler/testData/codegen/box/functions/bigArity/callFromJava.kt");
      }

      @Test
      @TestMetadata("callFunViaVararg.kt")
      public void testCallFunViaVararg() {
        runTest("compiler/testData/codegen/box/functions/bigArity/callFunViaVararg.kt");
      }

      @Test
      @TestMetadata("callWithIncorrectNumberOfArguments.kt")
      public void testCallWithIncorrectNumberOfArguments() {
        runTest("compiler/testData/codegen/box/functions/bigArity/callWithIncorrectNumberOfArguments.kt");
      }

      @Test
      @TestMetadata("function255.kt")
      public void testFunction255() {
        runTest("compiler/testData/codegen/box/functions/bigArity/function255.kt");
      }

      @Test
      @TestMetadata("instanceOfCallableReference.kt")
      public void testInstanceOfCallableReference() {
        runTest("compiler/testData/codegen/box/functions/bigArity/instanceOfCallableReference.kt");
      }

      @Test
      @TestMetadata("invokeCallableReference.kt")
      public void testInvokeCallableReference() {
        runTest("compiler/testData/codegen/box/functions/bigArity/invokeCallableReference.kt");
      }

      @Test
      @TestMetadata("invokeLambda.kt")
      public void testInvokeLambda() {
        runTest("compiler/testData/codegen/box/functions/bigArity/invokeLambda.kt");
      }

      @Test
      @TestMetadata("invokeMemberCallableReference.kt")
      public void testInvokeMemberCallableReference() {
        runTest("compiler/testData/codegen/box/functions/bigArity/invokeMemberCallableReference.kt");
      }

      @Test
      @TestMetadata("javaLambda.kt")
      public void testJavaLambda() {
        runTest("compiler/testData/codegen/box/functions/bigArity/javaLambda.kt");
      }

      @Test
      @TestMetadata("nestedBigArityFunCalls.kt")
      public void testNestedBigArityFunCalls() {
        runTest("compiler/testData/codegen/box/functions/bigArity/nestedBigArityFunCalls.kt");
      }

      @Test
      @TestMetadata("subclass.kt")
      public void testSubclass() {
        runTest("compiler/testData/codegen/box/functions/bigArity/subclass.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/functions/functionExpression")
    @TestDataPath("$PROJECT_ROOT")
    public class FunctionExpression {
      @Test
      public void testAllFilesPresentInFunctionExpression() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("functionExpression.kt")
      public void testFunctionExpression() {
        runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpression.kt");
      }

      @Test
      @TestMetadata("functionExpressionWithThisReference.kt")
      public void testFunctionExpressionWithThisReference() {
        runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpressionWithThisReference.kt");
      }

      @Test
      @TestMetadata("functionLiteralExpression.kt")
      public void testFunctionLiteralExpression() {
        runTest("compiler/testData/codegen/box/functions/functionExpression/functionLiteralExpression.kt");
      }

      @Test
      @TestMetadata("insideGenericLambda.kt")
      public void testInsideGenericLambda() {
        runTest("compiler/testData/codegen/box/functions/functionExpression/insideGenericLambda.kt");
      }

      @Test
      @TestMetadata("underscoreParameters.kt")
      public void testUnderscoreParameters() {
        runTest("compiler/testData/codegen/box/functions/functionExpression/underscoreParameters.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/functions/invoke")
    @TestDataPath("$PROJECT_ROOT")
    public class Invoke {
      @Test
      public void testAllFilesPresentInInvoke() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("castFunctionToExtension.kt")
      public void testCastFunctionToExtension() {
        runTest("compiler/testData/codegen/box/functions/invoke/castFunctionToExtension.kt");
      }

      @Test
      @TestMetadata("extensionInvokeOnExpr.kt")
      public void testExtensionInvokeOnExpr() {
        runTest("compiler/testData/codegen/box/functions/invoke/extensionInvokeOnExpr.kt");
      }

      @Test
      @TestMetadata("implicitInvokeInCompanionObjectWithFunctionalArgument.kt")
      public void testImplicitInvokeInCompanionObjectWithFunctionalArgument() {
        runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeInCompanionObjectWithFunctionalArgument.kt");
      }

      @Test
      @TestMetadata("implicitInvokeWithFunctionLiteralArgument.kt")
      public void testImplicitInvokeWithFunctionLiteralArgument() {
        runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeWithFunctionLiteralArgument.kt");
      }

      @Test
      @TestMetadata("invoke.kt")
      public void testInvoke() {
        runTest("compiler/testData/codegen/box/functions/invoke/invoke.kt");
      }

      @Test
      @TestMetadata("invokeOnExprByConvention.kt")
      public void testInvokeOnExprByConvention() {
        runTest("compiler/testData/codegen/box/functions/invoke/invokeOnExprByConvention.kt");
      }

      @Test
      @TestMetadata("invokeOnSyntheticProperty.kt")
      public void testInvokeOnSyntheticProperty() {
        runTest("compiler/testData/codegen/box/functions/invoke/invokeOnSyntheticProperty.kt");
      }

      @Test
      @TestMetadata("kt3189.kt")
      public void testKt3189() {
        runTest("compiler/testData/codegen/box/functions/invoke/kt3189.kt");
      }

      @Test
      @TestMetadata("kt3190.kt")
      public void testKt3190() {
        runTest("compiler/testData/codegen/box/functions/invoke/kt3190.kt");
      }

      @Test
      @TestMetadata("kt3297.kt")
      public void testKt3297() {
        runTest("compiler/testData/codegen/box/functions/invoke/kt3297.kt");
      }

      @Test
      @TestMetadata("kt3450getAndInvoke.kt")
      public void testKt3450getAndInvoke() {
        runTest("compiler/testData/codegen/box/functions/invoke/kt3450getAndInvoke.kt");
      }

      @Test
      @TestMetadata("kt3631invokeOnString.kt")
      public void testKt3631invokeOnString() {
        runTest("compiler/testData/codegen/box/functions/invoke/kt3631invokeOnString.kt");
      }

      @Test
      @TestMetadata("kt3772.kt")
      public void testKt3772() {
        runTest("compiler/testData/codegen/box/functions/invoke/kt3772.kt");
      }

      @Test
      @TestMetadata("kt3821invokeOnThis.kt")
      public void testKt3821invokeOnThis() {
        runTest("compiler/testData/codegen/box/functions/invoke/kt3821invokeOnThis.kt");
      }

      @Test
      @TestMetadata("kt3822invokeOnThis.kt")
      public void testKt3822invokeOnThis() {
        runTest("compiler/testData/codegen/box/functions/invoke/kt3822invokeOnThis.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/functions/localFunctions")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalFunctions {
      @Test
      public void testAllFilesPresentInLocalFunctions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("boundTypeParameterInSupertype.kt")
      public void testBoundTypeParameterInSupertype() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/boundTypeParameterInSupertype.kt");
      }

      @Test
      @TestMetadata("boundTypeParameterInVararg.kt")
      public void testBoundTypeParameterInVararg() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/boundTypeParameterInVararg.kt");
      }

      @Test
      @TestMetadata("callBetweenLocalFunctions.kt")
      public void testCallBetweenLocalFunctions() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/callBetweenLocalFunctions.kt");
      }

      @Test
      @TestMetadata("callInlineLocalInLambda.kt")
      public void testCallInlineLocalInLambda() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/callInlineLocalInLambda.kt");
      }

      @Test
      @TestMetadata("captureUpperBoundedTypeParameter.kt")
      public void testCaptureUpperBoundedTypeParameter() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/captureUpperBoundedTypeParameter.kt");
      }

      @Test
      @TestMetadata("definedWithinLambda.kt")
      public void testDefinedWithinLambda() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambda.kt");
      }

      @Test
      @TestMetadata("definedWithinLambdaInnerUsage1.kt")
      public void testDefinedWithinLambdaInnerUsage1() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage1.kt");
      }

      @Test
      @TestMetadata("definedWithinLambdaInnerUsage2.kt")
      public void testDefinedWithinLambdaInnerUsage2() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage2.kt");
      }

      @Test
      @TestMetadata("kt2895.kt")
      public void testKt2895() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt2895.kt");
      }

      @Test
      @TestMetadata("kt3308.kt")
      public void testKt3308() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt3308.kt");
      }

      @Test
      @TestMetadata("kt3978.kt")
      public void testKt3978() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978.kt");
      }

      @Test
      @TestMetadata("kt3978_2.kt")
      public void testKt3978_2() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978_2.kt");
      }

      @Test
      @TestMetadata("kt4119.kt")
      public void testKt4119() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119.kt");
      }

      @Test
      @TestMetadata("kt4119_2.kt")
      public void testKt4119_2() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119_2.kt");
      }

      @Test
      @TestMetadata("kt4514.kt")
      public void testKt4514() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt4514.kt");
      }

      @Test
      @TestMetadata("kt4777.kt")
      public void testKt4777() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt4777.kt");
      }

      @Test
      @TestMetadata("kt4783.kt")
      public void testKt4783() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt4783.kt");
      }

      @Test
      @TestMetadata("kt4784.kt")
      public void testKt4784() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt4784.kt");
      }

      @Test
      @TestMetadata("kt4989.kt")
      public void testKt4989() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/kt4989.kt");
      }

      @Test
      @TestMetadata("localExtensionOnNullableParameter.kt")
      public void testLocalExtensionOnNullableParameter() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/localExtensionOnNullableParameter.kt");
      }

      @Test
      @TestMetadata("localFunctionInConstructor.kt")
      public void testLocalFunctionInConstructor() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionInConstructor.kt");
      }

      @Test
      @TestMetadata("localFunctionVsLocalVariable.kt")
      public void testLocalFunctionVsLocalVariable() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionVsLocalVariable.kt");
      }

      @Test
      @TestMetadata("nameClash.kt")
      public void testNameClash() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/nameClash.kt");
      }

      @Test
      @TestMetadata("nameClashAcrossDifferentContainers.kt")
      public void testNameClashAcrossDifferentContainers() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/nameClashAcrossDifferentContainers.kt");
      }

      @Test
      @TestMetadata("overloadedLocalFunWithoutClosure.kt")
      public void testOverloadedLocalFunWithoutClosure() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunWithoutClosure.kt");
      }

      @Test
      @TestMetadata("overloadedLocalFunction.kt")
      public void testOverloadedLocalFunction() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction.kt");
      }

      @Test
      @TestMetadata("overloadedLocalFunction1.kt")
      public void testOverloadedLocalFunction1() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction1.kt");
      }

      @Test
      @TestMetadata("overloadedLocalFunction2.kt")
      public void testOverloadedLocalFunction2() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction2.kt");
      }

      @Test
      @TestMetadata("overloadedLocalFunction3.kt")
      public void testOverloadedLocalFunction3() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction3.kt");
      }

      @Test
      @TestMetadata("parameterAsDefaultValue.kt")
      public void testParameterAsDefaultValue() {
        runTest("compiler/testData/codegen/box/functions/localFunctions/parameterAsDefaultValue.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/ieee754")
  @TestDataPath("$PROJECT_ROOT")
  public class Ieee754 {
    @Test
    public void testAllFilesPresentInIeee754() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("anyCastToPrimitiveCompareTo1.kt")
    public void testAnyCastToPrimitiveCompareTo1() {
      runTest("compiler/testData/codegen/box/ieee754/anyCastToPrimitiveCompareTo1.kt");
    }

    @Test
    @TestMetadata("anyCastToPrimitiveCompareTo2.kt")
    public void testAnyCastToPrimitiveCompareTo2() {
      runTest("compiler/testData/codegen/box/ieee754/anyCastToPrimitiveCompareTo2.kt");
    }

    @Test
    @TestMetadata("anyToReal.kt")
    public void testAnyToReal() {
      runTest("compiler/testData/codegen/box/ieee754/anyToReal.kt");
    }

    @Test
    @TestMetadata("anyToReal_AgainstCompiled.kt")
    public void testAnyToReal_AgainstCompiled() {
      runTest("compiler/testData/codegen/box/ieee754/anyToReal_AgainstCompiled.kt");
    }

    @Test
    @TestMetadata("asComparableToDouble.kt")
    public void testAsComparableToDouble() {
      runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble.kt");
    }

    @Test
    @TestMetadata("asComparableToDouble_properIeeeComparisons.kt")
    public void testAsComparableToDouble_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("comparableToTWithT_properIeeeComparisons.kt")
    public void testComparableToTWithT_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/comparableToTWithT_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("comparableTypeCast.kt")
    public void testComparableTypeCast() {
      runTest("compiler/testData/codegen/box/ieee754/comparableTypeCast.kt");
    }

    @Test
    @TestMetadata("comparableTypeCast_AgainstCompiled.kt")
    public void testComparableTypeCast_AgainstCompiled() {
      runTest("compiler/testData/codegen/box/ieee754/comparableTypeCast_AgainstCompiled.kt");
    }

    @Test
    @TestMetadata("dataClass.kt")
    public void testDataClass() {
      runTest("compiler/testData/codegen/box/ieee754/dataClass.kt");
    }

    @Test
    @TestMetadata("differentTypesComparison.kt")
    public void testDifferentTypesComparison() {
      runTest("compiler/testData/codegen/box/ieee754/differentTypesComparison.kt");
    }

    @Test
    @TestMetadata("double.kt")
    public void testDouble() {
      runTest("compiler/testData/codegen/box/ieee754/double.kt");
    }

    @Test
    @TestMetadata("equalsDouble_properIeeeComparisons.kt")
    public void testEqualsDouble_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/equalsDouble_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("equalsFloat_properIeeeComparisons.kt")
    public void testEqualsFloat_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/equalsFloat_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("equalsNaN_properIeeeComparisons.kt")
    public void testEqualsNaN_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/equalsNaN_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("equalsNullableDouble_properIeeeComparisons.kt")
    public void testEqualsNullableDouble_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("equalsNullableFloat_properIeeeComparisons.kt")
    public void testEqualsNullableFloat_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("explicitCompareCall.kt")
    public void testExplicitCompareCall() {
      runTest("compiler/testData/codegen/box/ieee754/explicitCompareCall.kt");
    }

    @Test
    @TestMetadata("explicitCompareCall_AgainstCompiled.kt")
    public void testExplicitCompareCall_AgainstCompiled() {
      runTest("compiler/testData/codegen/box/ieee754/explicitCompareCall_AgainstCompiled.kt");
    }

    @Test
    @TestMetadata("explicitEqualsCall.kt")
    public void testExplicitEqualsCall() {
      runTest("compiler/testData/codegen/box/ieee754/explicitEqualsCall.kt");
    }

    @Test
    @TestMetadata("explicitEqualsCall_AgainstCompiled.kt")
    public void testExplicitEqualsCall_AgainstCompiled() {
      runTest("compiler/testData/codegen/box/ieee754/explicitEqualsCall_AgainstCompiled.kt");
    }

    @Test
    @TestMetadata("float.kt")
    public void testFloat() {
      runTest("compiler/testData/codegen/box/ieee754/float.kt");
    }

    @Test
    @TestMetadata("generic.kt")
    public void testGeneric() {
      runTest("compiler/testData/codegen/box/ieee754/generic.kt");
    }

    @Test
    @TestMetadata("generic_AgainstCompiled.kt")
    public void testGeneric_AgainstCompiled() {
      runTest("compiler/testData/codegen/box/ieee754/generic_AgainstCompiled.kt");
    }

    @Test
    @TestMetadata("greaterDouble_properIeeeComparisons.kt")
    public void testGreaterDouble_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/greaterDouble_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("greaterFloat_properIeeeComparisons.kt")
    public void testGreaterFloat_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/greaterFloat_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("inline.kt")
    public void testInline() {
      runTest("compiler/testData/codegen/box/ieee754/inline.kt");
    }

    @Test
    @TestMetadata("kt48648_genericField.kt")
    public void testKt48648_genericField() {
      runTest("compiler/testData/codegen/box/ieee754/kt48648_genericField.kt");
    }

    @Test
    @TestMetadata("lessDouble_properIeeeAndNewInference.kt")
    public void testLessDouble_properIeeeAndNewInference() {
      runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeAndNewInference.kt");
    }

    @Test
    @TestMetadata("lessDouble_properIeeeComparisons.kt")
    public void testLessDouble_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("lessFloat_properIeeeComparisons.kt")
    public void testLessFloat_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/lessFloat_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("nullableAnyToReal.kt")
    public void testNullableAnyToReal() {
      runTest("compiler/testData/codegen/box/ieee754/nullableAnyToReal.kt");
    }

    @Test
    @TestMetadata("nullableAnyToReal_AgainstCompiled.kt")
    public void testNullableAnyToReal_AgainstCompiled() {
      runTest("compiler/testData/codegen/box/ieee754/nullableAnyToReal_AgainstCompiled.kt");
    }

    @Test
    @TestMetadata("nullableDoubleEquals.kt")
    public void testNullableDoubleEquals() {
      runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEquals.kt");
    }

    @Test
    @TestMetadata("nullableDoubleEqualsLV13.kt")
    public void testNullableDoubleEqualsLV13() {
      runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEqualsLV13.kt");
    }

    @Test
    @TestMetadata("nullableDoubleNotEquals.kt")
    public void testNullableDoubleNotEquals() {
      runTest("compiler/testData/codegen/box/ieee754/nullableDoubleNotEquals.kt");
    }

    @Test
    @TestMetadata("nullableFloatEquals.kt")
    public void testNullableFloatEquals() {
      runTest("compiler/testData/codegen/box/ieee754/nullableFloatEquals.kt");
    }

    @Test
    @TestMetadata("nullableFloatNotEquals.kt")
    public void testNullableFloatNotEquals() {
      runTest("compiler/testData/codegen/box/ieee754/nullableFloatNotEquals.kt");
    }

    @Test
    @TestMetadata("nullableIntEquals.kt")
    public void testNullableIntEquals() {
      runTest("compiler/testData/codegen/box/ieee754/nullableIntEquals.kt");
    }

    @Test
    @TestMetadata("safeCall.kt")
    public void testSafeCall() {
      runTest("compiler/testData/codegen/box/ieee754/safeCall.kt");
    }

    @Test
    @TestMetadata("smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt")
    public void testSmartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt")
    public void testSmartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("smartCastToDifferentTypes_properIeeeComparisons.kt")
    public void testSmartCastToDifferentTypes_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("smartCastToDoubleAndComparableToDouble.kt")
    public void testSmartCastToDoubleAndComparableToDouble() {
      runTest("compiler/testData/codegen/box/ieee754/smartCastToDoubleAndComparableToDouble.kt");
    }

    @Test
    @TestMetadata("smartCastToInt.kt")
    public void testSmartCastToInt() {
      runTest("compiler/testData/codegen/box/ieee754/smartCastToInt.kt");
    }

    @Test
    @TestMetadata("whenNoSubject_properIeeeComparisons.kt")
    public void testWhenNoSubject_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/whenNoSubject_properIeeeComparisons.kt");
    }

    @Test
    @TestMetadata("whenNullableSmartCast.kt")
    public void testWhenNullableSmartCast() {
      runTest("compiler/testData/codegen/box/ieee754/whenNullableSmartCast.kt");
    }

    @Test
    @TestMetadata("when_properIeeeComparisons.kt")
    public void testWhen_properIeeeComparisons() {
      runTest("compiler/testData/codegen/box/ieee754/when_properIeeeComparisons.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/increment")
  @TestDataPath("$PROJECT_ROOT")
  public class Increment {
    @Test
    public void testAllFilesPresentInIncrement() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/increment"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("argumentWithSideEffects.kt")
    public void testArgumentWithSideEffects() {
      runTest("compiler/testData/codegen/box/increment/argumentWithSideEffects.kt");
    }

    @Test
    @TestMetadata("arrayElement.kt")
    public void testArrayElement() {
      runTest("compiler/testData/codegen/box/increment/arrayElement.kt");
    }

    @Test
    @TestMetadata("assignPlusOnSmartCast.kt")
    public void testAssignPlusOnSmartCast() {
      runTest("compiler/testData/codegen/box/increment/assignPlusOnSmartCast.kt");
    }

    @Test
    @TestMetadata("augmentedAssignmentWithComplexRhs.kt")
    public void testAugmentedAssignmentWithComplexRhs() {
      runTest("compiler/testData/codegen/box/increment/augmentedAssignmentWithComplexRhs.kt");
    }

    @Test
    @TestMetadata("classNaryGetSet.kt")
    public void testClassNaryGetSet() {
      runTest("compiler/testData/codegen/box/increment/classNaryGetSet.kt");
    }

    @Test
    @TestMetadata("classVarargGetSet.kt")
    public void testClassVarargGetSet() {
      runTest("compiler/testData/codegen/box/increment/classVarargGetSet.kt");
    }

    @Test
    @TestMetadata("classVarargGetSetEvaluationOrder.kt")
    public void testClassVarargGetSetEvaluationOrder() {
      runTest("compiler/testData/codegen/box/increment/classVarargGetSetEvaluationOrder.kt");
    }

    @Test
    @TestMetadata("classWithGetSet.kt")
    public void testClassWithGetSet() {
      runTest("compiler/testData/codegen/box/increment/classWithGetSet.kt");
    }

    @Test
    @TestMetadata("extOnLong.kt")
    public void testExtOnLong() {
      runTest("compiler/testData/codegen/box/increment/extOnLong.kt");
    }

    @Test
    @TestMetadata("genericClassWithGetSet.kt")
    public void testGenericClassWithGetSet() {
      runTest("compiler/testData/codegen/box/increment/genericClassWithGetSet.kt");
    }

    @Test
    @TestMetadata("incDecWith2Receivers.kt")
    public void testIncDecWith2Receivers() {
      runTest("compiler/testData/codegen/box/increment/incDecWith2Receivers.kt");
    }

    @Test
    @TestMetadata("kt36956.kt")
    public void testKt36956() {
      runTest("compiler/testData/codegen/box/increment/kt36956.kt");
    }

    @Test
    @TestMetadata("memberExtOnLong.kt")
    public void testMemberExtOnLong() {
      runTest("compiler/testData/codegen/box/increment/memberExtOnLong.kt");
    }

    @Test
    @TestMetadata("mutableListElement.kt")
    public void testMutableListElement() {
      runTest("compiler/testData/codegen/box/increment/mutableListElement.kt");
    }

    @Test
    @TestMetadata("nullable.kt")
    public void testNullable() {
      runTest("compiler/testData/codegen/box/increment/nullable.kt");
    }

    @Test
    @TestMetadata("postfixIncrementDoubleSmartCast.kt")
    public void testPostfixIncrementDoubleSmartCast() {
      runTest("compiler/testData/codegen/box/increment/postfixIncrementDoubleSmartCast.kt");
    }

    @Test
    @TestMetadata("postfixIncrementOnClass.kt")
    public void testPostfixIncrementOnClass() {
      runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClass.kt");
    }

    @Test
    @TestMetadata("postfixIncrementOnClassSmartCast.kt")
    public void testPostfixIncrementOnClassSmartCast() {
      runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClassSmartCast.kt");
    }

    @Test
    @TestMetadata("postfixIncrementOnShortSmartCast.kt")
    public void testPostfixIncrementOnShortSmartCast() {
      runTest("compiler/testData/codegen/box/increment/postfixIncrementOnShortSmartCast.kt");
    }

    @Test
    @TestMetadata("postfixIncrementOnSmartCast.kt")
    public void testPostfixIncrementOnSmartCast() {
      runTest("compiler/testData/codegen/box/increment/postfixIncrementOnSmartCast.kt");
    }

    @Test
    @TestMetadata("postfixNullableClassIncrement.kt")
    public void testPostfixNullableClassIncrement() {
      runTest("compiler/testData/codegen/box/increment/postfixNullableClassIncrement.kt");
    }

    @Test
    @TestMetadata("postfixNullableIncrement.kt")
    public void testPostfixNullableIncrement() {
      runTest("compiler/testData/codegen/box/increment/postfixNullableIncrement.kt");
    }

    @Test
    @TestMetadata("prefixIncrementOnClass.kt")
    public void testPrefixIncrementOnClass() {
      runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClass.kt");
    }

    @Test
    @TestMetadata("prefixIncrementOnClassSmartCast.kt")
    public void testPrefixIncrementOnClassSmartCast() {
      runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClassSmartCast.kt");
    }

    @Test
    @TestMetadata("prefixIncrementOnSmartCast.kt")
    public void testPrefixIncrementOnSmartCast() {
      runTest("compiler/testData/codegen/box/increment/prefixIncrementOnSmartCast.kt");
    }

    @Test
    @TestMetadata("prefixNullableClassIncrement.kt")
    public void testPrefixNullableClassIncrement() {
      runTest("compiler/testData/codegen/box/increment/prefixNullableClassIncrement.kt");
    }

    @Test
    @TestMetadata("prefixNullableIncrement.kt")
    public void testPrefixNullableIncrement() {
      runTest("compiler/testData/codegen/box/increment/prefixNullableIncrement.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/inference")
  @TestDataPath("$PROJECT_ROOT")
  public class Inference {
    @Test
    public void testAllFilesPresentInInference() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("approximateNonTopLevelCapturedTypes.kt")
    public void testApproximateNonTopLevelCapturedTypes() {
      runTest("compiler/testData/codegen/box/inference/approximateNonTopLevelCapturedTypes.kt");
    }

    @Test
    @TestMetadata("builderAndDelegateInference.kt")
    public void testBuilderAndDelegateInference() {
      runTest("compiler/testData/codegen/box/inference/builderAndDelegateInference.kt");
    }

    @Test
    @TestMetadata("builderInference.kt")
    public void testBuilderInference() {
      runTest("compiler/testData/codegen/box/inference/builderInference.kt");
    }

    @Test
    @TestMetadata("builderInferenceLeakingVariable.kt")
    public void testBuilderInferenceLeakingVariable() {
      runTest("compiler/testData/codegen/box/inference/builderInferenceLeakingVariable.kt");
    }

    @Test
    @TestMetadata("builderInferenceWithAnnotation.kt")
    public void testBuilderInferenceWithAnnotation() {
      runTest("compiler/testData/codegen/box/inference/builderInferenceWithAnnotation.kt");
    }

    @Test
    @TestMetadata("capturedStarProjection.kt")
    public void testCapturedStarProjection() {
      runTest("compiler/testData/codegen/box/inference/capturedStarProjection.kt");
    }

    @Test
    @TestMetadata("capturedTypesSubstitutionIntoAbbreviation.kt")
    public void testCapturedTypesSubstitutionIntoAbbreviation() {
      runTest("compiler/testData/codegen/box/inference/capturedTypesSubstitutionIntoAbbreviation.kt");
    }

    @Test
    @TestMetadata("coercionToUnitForLambdaReturnTypeWithFlexibleConstraint.kt")
    public void testCoercionToUnitForLambdaReturnTypeWithFlexibleConstraint() {
      runTest("compiler/testData/codegen/box/inference/coercionToUnitForLambdaReturnTypeWithFlexibleConstraint.kt");
    }

    @Test
    @TestMetadata("coercionToUnitWithLastLambdaExpression.kt")
    public void testCoercionToUnitWithLastLambdaExpression() {
      runTest("compiler/testData/codegen/box/inference/coercionToUnitWithLastLambdaExpression.kt");
    }

    @Test
    @TestMetadata("coerctionToUnitForLastExpressionWithStarProjection.kt")
    public void testCoerctionToUnitForLastExpressionWithStarProjection() {
      runTest("compiler/testData/codegen/box/inference/coerctionToUnitForLastExpressionWithStarProjection.kt");
    }

    @Test
    @TestMetadata("earlyReturnInsideCrossinlineLambda.kt")
    public void testEarlyReturnInsideCrossinlineLambda() {
      runTest("compiler/testData/codegen/box/inference/earlyReturnInsideCrossinlineLambda.kt");
    }

    @Test
    @TestMetadata("inferenceWithTypeVariableInsideCapturedType.kt")
    public void testInferenceWithTypeVariableInsideCapturedType() {
      runTest("compiler/testData/codegen/box/inference/inferenceWithTypeVariableInsideCapturedType.kt");
    }

    @Test
    @TestMetadata("integerLiteralTypeInLamdaReturnType.kt")
    public void testIntegerLiteralTypeInLamdaReturnType() {
      runTest("compiler/testData/codegen/box/inference/integerLiteralTypeInLamdaReturnType.kt");
    }

    @Test
    @TestMetadata("intersectionTypeInArguments.kt")
    public void testIntersectionTypeInArguments() {
      runTest("compiler/testData/codegen/box/inference/intersectionTypeInArguments.kt");
    }

    @Test
    @TestMetadata("intersectionWithInvisibleComponent.kt")
    public void testIntersectionWithInvisibleComponent() {
      runTest("compiler/testData/codegen/box/inference/intersectionWithInvisibleComponent.kt");
    }

    @Test
    @TestMetadata("kt10822.kt")
    public void testKt10822() {
      runTest("compiler/testData/codegen/box/inference/kt10822.kt");
    }

    @Test
    @TestMetadata("kt26345.kt")
    public void testKt26345() {
      runTest("compiler/testData/codegen/box/inference/kt26345.kt");
    }

    @Test
    @TestMetadata("kt32429.kt")
    public void testKt32429() {
      runTest("compiler/testData/codegen/box/inference/kt32429.kt");
    }

    @Test
    @TestMetadata("kt35684.kt")
    public void testKt35684() {
      runTest("compiler/testData/codegen/box/inference/kt35684.kt");
    }

    @Test
    @TestMetadata("kt36446.kt")
    public void testKt36446() {
      runTest("compiler/testData/codegen/box/inference/kt36446.kt");
    }

    @Test
    @TestMetadata("kt38664.kt")
    public void testKt38664() {
      runTest("compiler/testData/codegen/box/inference/kt38664.kt");
    }

    @Test
    @TestMetadata("kt39824.kt")
    public void testKt39824() {
      runTest("compiler/testData/codegen/box/inference/kt39824.kt");
    }

    @Test
    @TestMetadata("kt42042.kt")
    public void testKt42042() {
      runTest("compiler/testData/codegen/box/inference/kt42042.kt");
    }

    @Test
    @TestMetadata("kt42130.kt")
    public void testKt42130() {
      runTest("compiler/testData/codegen/box/inference/kt42130.kt");
    }

    @Test
    @TestMetadata("kt45118.kt")
    public void testKt45118() {
      runTest("compiler/testData/codegen/box/inference/kt45118.kt");
    }

    @Test
    @TestMetadata("kt47316.kt")
    public void testKt47316() {
      runTest("compiler/testData/codegen/box/inference/kt47316.kt");
    }

    @Test
    @TestMetadata("kt49838.kt")
    public void testKt49838() {
      runTest("compiler/testData/codegen/box/inference/kt49838.kt");
    }

    @Test
    @TestMetadata("kt51040.kt")
    public void testKt51040() {
      runTest("compiler/testData/codegen/box/inference/kt51040.kt");
    }

    @Test
    @TestMetadata("kt65882.kt")
    public void testKt65882() {
      runTest("compiler/testData/codegen/box/inference/kt65882.kt");
    }

    @Test
    @TestMetadata("kt67609.kt")
    public void testKt67609() {
      runTest("compiler/testData/codegen/box/inference/kt67609.kt");
    }

    @Test
    @TestMetadata("lambdaWithStarReturn.kt")
    public void testLambdaWithStarReturn() {
      runTest("compiler/testData/codegen/box/inference/lambdaWithStarReturn.kt");
    }

    @Test
    @TestMetadata("lambdasWithExtensionFunctionType.kt")
    public void testLambdasWithExtensionFunctionType() {
      runTest("compiler/testData/codegen/box/inference/lambdasWithExtensionFunctionType.kt");
    }

    @Test
    @TestMetadata("lastExpressionOfLambdaWithNothingConstraint.kt")
    public void testLastExpressionOfLambdaWithNothingConstraint() {
      runTest("compiler/testData/codegen/box/inference/lastExpressionOfLambdaWithNothingConstraint.kt");
    }

    @Test
    @TestMetadata("manyConstraintsDueToFlexibleRawTypes.kt")
    public void testManyConstraintsDueToFlexibleRawTypes() {
      runTest("compiler/testData/codegen/box/inference/manyConstraintsDueToFlexibleRawTypes.kt");
    }

    @Test
    @TestMetadata("manyFlexibleTypeParametersFromJavaAndConversions.kt")
    public void testManyFlexibleTypeParametersFromJavaAndConversions() {
      runTest("compiler/testData/codegen/box/inference/manyFlexibleTypeParametersFromJavaAndConversions.kt");
    }

    @Test
    @TestMetadata("mapCollectChainWithNullResult.kt")
    public void testMapCollectChainWithNullResult() {
      runTest("compiler/testData/codegen/box/inference/mapCollectChainWithNullResult.kt");
    }

    @Test
    @TestMetadata("noCoercionToUniForNullableLambdaReturnType.kt")
    public void testNoCoercionToUniForNullableLambdaReturnType() {
      runTest("compiler/testData/codegen/box/inference/noCoercionToUniForNullableLambdaReturnType.kt");
    }

    @Test
    @TestMetadata("noCoercionToUnitWithEqualityConstraintForNullableReturnType.kt")
    public void testNoCoercionToUnitWithEqualityConstraintForNullableReturnType() {
      runTest("compiler/testData/codegen/box/inference/noCoercionToUnitWithEqualityConstraintForNullableReturnType.kt");
    }

    @Test
    @TestMetadata("noNothingValueInsideSpecialCall.kt")
    public void testNoNothingValueInsideSpecialCall() {
      runTest("compiler/testData/codegen/box/inference/noNothingValueInsideSpecialCall.kt");
    }

    @Test
    @TestMetadata("overrideDefaultProperty.kt")
    public void testOverrideDefaultProperty() {
      runTest("compiler/testData/codegen/box/inference/overrideDefaultProperty.kt");
    }

    @Test
    @TestMetadata("overrideGenericDefaultMethod.kt")
    public void testOverrideGenericDefaultMethod() {
      runTest("compiler/testData/codegen/box/inference/overrideGenericDefaultMethod.kt");
    }

    @Test
    @TestMetadata("packagePrivateCst.kt")
    public void testPackagePrivateCst() {
      runTest("compiler/testData/codegen/box/inference/packagePrivateCst.kt");
    }

    @Test
    @TestMetadata("plusAssignInsideLambda.kt")
    public void testPlusAssignInsideLambda() {
      runTest("compiler/testData/codegen/box/inference/plusAssignInsideLambda.kt");
    }

    @Test
    @TestMetadata("recursiveConstraintInsideTypeArgumentWithStarProjection.kt")
    public void testRecursiveConstraintInsideTypeArgumentWithStarProjection() {
      runTest("compiler/testData/codegen/box/inference/recursiveConstraintInsideTypeArgumentWithStarProjection.kt");
    }

    @Test
    @TestMetadata("referenceToCatchParameterFromLambdaExpression.kt")
    public void testReferenceToCatchParameterFromLambdaExpression() {
      runTest("compiler/testData/codegen/box/inference/referenceToCatchParameterFromLambdaExpression.kt");
    }

    @Test
    @TestMetadata("safeCastWithElvis.kt")
    public void testSafeCastWithElvis() {
      runTest("compiler/testData/codegen/box/inference/safeCastWithElvis.kt");
    }

    @Test
    @TestMetadata("substituteIntersectionTypeInsideCapType.kt")
    public void testSubstituteIntersectionTypeInsideCapType() {
      runTest("compiler/testData/codegen/box/inference/substituteIntersectionTypeInsideCapType.kt");
    }

    @Test
    @TestMetadata("subtypingOfIntersectionIltInsideFlexible.kt")
    public void testSubtypingOfIntersectionIltInsideFlexible() {
      runTest("compiler/testData/codegen/box/inference/subtypingOfIntersectionIltInsideFlexible.kt");
    }

    @Test
    @TestMetadata("sumOfOverloads.kt")
    public void testSumOfOverloads() {
      runTest("compiler/testData/codegen/box/inference/sumOfOverloads.kt");
    }

    @Test
    @TestMetadata("suspendExtensionRecevierFromConstraint.kt")
    public void testSuspendExtensionRecevierFromConstraint() {
      runTest("compiler/testData/codegen/box/inference/suspendExtensionRecevierFromConstraint.kt");
    }

    @Test
    @TestMetadata("unsafeVarianceCodegen.kt")
    public void testUnsafeVarianceCodegen() {
      runTest("compiler/testData/codegen/box/inference/unsafeVarianceCodegen.kt");
    }

    @Test
    @TestMetadata("violatingUpperBoundForSelfType.kt")
    public void testViolatingUpperBoundForSelfType() {
      runTest("compiler/testData/codegen/box/inference/violatingUpperBoundForSelfType.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/inference/pcla")
    @TestDataPath("$PROJECT_ROOT")
    public class Pcla {
      @Test
      public void testAllFilesPresentInPcla() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("builderCallAsReturnTypeInLocalClass.kt")
      public void testBuilderCallAsReturnTypeInLocalClass() {
        runTest("compiler/testData/codegen/box/inference/pcla/builderCallAsReturnTypeInLocalClass.kt");
      }

      @Test
      @TestMetadata("callableReferenceAndCoercionToUnit.kt")
      public void testCallableReferenceAndCoercionToUnit() {
        runTest("compiler/testData/codegen/box/inference/pcla/callableReferenceAndCoercionToUnit.kt");
      }

      @Test
      @TestMetadata("callableReferencesProperCompletion.kt")
      public void testCallableReferencesProperCompletion() {
        runTest("compiler/testData/codegen/box/inference/pcla/callableReferencesProperCompletion.kt");
      }

      @Test
      @TestMetadata("capturedTypes.kt")
      public void testCapturedTypes() {
        runTest("compiler/testData/codegen/box/inference/pcla/capturedTypes.kt");
      }

      @Test
      @TestMetadata("changingResolveIfDontUseBuilderInferenceDisabledFeature.kt")
      public void testChangingResolveIfDontUseBuilderInferenceDisabledFeature() {
        runTest("compiler/testData/codegen/box/inference/pcla/changingResolveIfDontUseBuilderInferenceDisabledFeature.kt");
      }

      @Test
      @TestMetadata("commonSuperType.kt")
      public void testCommonSuperType() {
        runTest("compiler/testData/codegen/box/inference/pcla/commonSuperType.kt");
      }

      @Test
      @TestMetadata("commonSuperTypeContravariant.kt")
      public void testCommonSuperTypeContravariant() {
        runTest("compiler/testData/codegen/box/inference/pcla/commonSuperTypeContravariant.kt");
      }

      @Test
      @TestMetadata("commonSuperTypeCovariant.kt")
      public void testCommonSuperTypeCovariant() {
        runTest("compiler/testData/codegen/box/inference/pcla/commonSuperTypeCovariant.kt");
      }

      @Test
      @TestMetadata("commonSuperTypeInvariant.kt")
      public void testCommonSuperTypeInvariant() {
        runTest("compiler/testData/codegen/box/inference/pcla/commonSuperTypeInvariant.kt");
      }

      @Test
      @TestMetadata("commonSuperTypeNullable.kt")
      public void testCommonSuperTypeNullable() {
        runTest("compiler/testData/codegen/box/inference/pcla/commonSuperTypeNullable.kt");
      }

      @Test
      @TestMetadata("constraintsBetweenTwoStubVariables.kt")
      public void testConstraintsBetweenTwoStubVariables() {
        runTest("compiler/testData/codegen/box/inference/pcla/constraintsBetweenTwoStubVariables.kt");
      }

      @Test
      @TestMetadata("contextReceivers.kt")
      public void testContextReceivers() {
        runTest("compiler/testData/codegen/box/inference/pcla/contextReceivers.kt");
      }

      @Test
      @TestMetadata("cstBasedOnTwoBuilderInferenceLambda.kt")
      public void testCstBasedOnTwoBuilderInferenceLambda() {
        runTest("compiler/testData/codegen/box/inference/pcla/cstBasedOnTwoBuilderInferenceLambda.kt");
      }

      @Test
      @TestMetadata("inferFromExpectedType.kt")
      public void testInferFromExpectedType() {
        runTest("compiler/testData/codegen/box/inference/pcla/inferFromExpectedType.kt");
      }

      @Test
      @TestMetadata("intersect.kt")
      public void testIntersect() {
        runTest("compiler/testData/codegen/box/inference/pcla/intersect.kt");
      }

      @Test
      @TestMetadata("labaledCall.kt")
      public void testLabaledCall() {
        runTest("compiler/testData/codegen/box/inference/pcla/labaledCall.kt");
      }

      @Test
      @TestMetadata("lackOfNullCheckOnNullableInsideBuild.kt")
      public void testLackOfNullCheckOnNullableInsideBuild() {
        runTest("compiler/testData/codegen/box/inference/pcla/lackOfNullCheckOnNullableInsideBuild.kt");
      }

      @Test
      @TestMetadata("lambdaParameterHasTVType.kt")
      public void testLambdaParameterHasTVType() {
        runTest("compiler/testData/codegen/box/inference/pcla/lambdaParameterHasTVType.kt");
      }

      @Test
      @TestMetadata("memberScope.kt")
      public void testMemberScope() {
        runTest("compiler/testData/codegen/box/inference/pcla/memberScope.kt");
      }

      @Test
      @TestMetadata("nestedNonExhaustiveIf.kt")
      public void testNestedNonExhaustiveIf() {
        runTest("compiler/testData/codegen/box/inference/pcla/nestedNonExhaustiveIf.kt");
      }

      @Test
      @TestMetadata("nullability.kt")
      public void testNullability() {
        runTest("compiler/testData/codegen/box/inference/pcla/nullability.kt");
      }

      @Test
      @TestMetadata("partiallyResolvedCallInReturnArgument.kt")
      public void testPartiallyResolvedCallInReturnArgument() {
        runTest("compiler/testData/codegen/box/inference/pcla/partiallyResolvedCallInReturnArgument.kt");
      }

      @Test
      @TestMetadata("partiallyResolvedCallInReturnArgumentNonLast.kt")
      public void testPartiallyResolvedCallInReturnArgumentNonLast() {
        runTest("compiler/testData/codegen/box/inference/pcla/partiallyResolvedCallInReturnArgumentNonLast.kt");
      }

      @Test
      @TestMetadata("partiallyResolvedCallInReturnArgumentNonUnit.kt")
      public void testPartiallyResolvedCallInReturnArgumentNonUnit() {
        runTest("compiler/testData/codegen/box/inference/pcla/partiallyResolvedCallInReturnArgumentNonUnit.kt");
      }

      @Test
      @TestMetadata("pcaRootIsDelegatedConstructorCall.kt")
      public void testPcaRootIsDelegatedConstructorCall() {
        runTest("compiler/testData/codegen/box/inference/pcla/pcaRootIsDelegatedConstructorCall.kt");
      }

      @Test
      @TestMetadata("pclaRootIsElvisSynthetic.kt")
      public void testPclaRootIsElvisSynthetic() {
        runTest("compiler/testData/codegen/box/inference/pcla/pclaRootIsElvisSynthetic.kt");
      }

      @Test
      @TestMetadata("pclaRootIsIfWhenSyntheticCall.kt")
      public void testPclaRootIsIfWhenSyntheticCall() {
        runTest("compiler/testData/codegen/box/inference/pcla/pclaRootIsIfWhenSyntheticCall.kt");
      }

      @Test
      @TestMetadata("pclaRootIsTrySyntheticCall.kt")
      public void testPclaRootIsTrySyntheticCall() {
        runTest("compiler/testData/codegen/box/inference/pcla/pclaRootIsTrySyntheticCall.kt");
      }

      @Test
      @TestMetadata("pclaRootIsTrySyntheticCallWithDelegate.kt")
      public void testPclaRootIsTrySyntheticCallWithDelegate() {
        runTest("compiler/testData/codegen/box/inference/pcla/pclaRootIsTrySyntheticCallWithDelegate.kt");
      }

      @Test
      @TestMetadata("posptonedPCLACallInsideStringInterpolation.kt")
      public void testPosptonedPCLACallInsideStringInterpolation() {
        runTest("compiler/testData/codegen/box/inference/pcla/posptonedPCLACallInsideStringInterpolation.kt");
      }

      @Test
      @TestMetadata("propagateInferenceSessionIntoDeclarationAnalyzers.kt")
      public void testPropagateInferenceSessionIntoDeclarationAnalyzers() {
        runTest("compiler/testData/codegen/box/inference/pcla/propagateInferenceSessionIntoDeclarationAnalyzers.kt");
      }

      @Test
      @TestMetadata("propertyInvokeInsidePCLALambda.kt")
      public void testPropertyInvokeInsidePCLALambda() {
        runTest("compiler/testData/codegen/box/inference/pcla/propertyInvokeInsidePCLALambda.kt");
      }

      @Test
      @TestMetadata("receiverUsesOuterTVButReturnTypeIsProper.kt")
      public void testReceiverUsesOuterTVButReturnTypeIsProper() {
        runTest("compiler/testData/codegen/box/inference/pcla/receiverUsesOuterTVButReturnTypeIsProper.kt");
      }

      @Test
      @TestMetadata("specialCallsWithCallableReferencesDontRewriteAtSlice.kt")
      public void testSpecialCallsWithCallableReferencesDontRewriteAtSlice() {
        runTest("compiler/testData/codegen/box/inference/pcla/specialCallsWithCallableReferencesDontRewriteAtSlice.kt");
      }

      @Test
      @TestMetadata("specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt")
      public void testSpecialCallsWithCallableReferencesNonStrictOnlyInputTypes() {
        runTest("compiler/testData/codegen/box/inference/pcla/specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt");
      }

      @Test
      @TestMetadata("specialCallsWithLambdas.kt")
      public void testSpecialCallsWithLambdas() {
        runTest("compiler/testData/codegen/box/inference/pcla/specialCallsWithLambdas.kt");
      }

      @Test
      @TestMetadata("substituteStubTypeIntoCR.kt")
      public void testSubstituteStubTypeIntoCR() {
        runTest("compiler/testData/codegen/box/inference/pcla/substituteStubTypeIntoCR.kt");
      }

      @Test
      @TestMetadata("substituteStubTypeIntolambdaParameterDescriptor.kt")
      public void testSubstituteStubTypeIntolambdaParameterDescriptor() {
        runTest("compiler/testData/codegen/box/inference/pcla/substituteStubTypeIntolambdaParameterDescriptor.kt");
      }

      @Test
      @TestMetadata("substituteTypeVariableIntolambdaParameterDescriptor.kt")
      public void testSubstituteTypeVariableIntolambdaParameterDescriptor() {
        runTest("compiler/testData/codegen/box/inference/pcla/substituteTypeVariableIntolambdaParameterDescriptor.kt");
      }

      @Test
      @TestMetadata("substitutelambdaExtensionReceiverType.kt")
      public void testSubstitutelambdaExtensionReceiverType() {
        runTest("compiler/testData/codegen/box/inference/pcla/substitutelambdaExtensionReceiverType.kt");
      }

      @Test
      @TestMetadata("topDownCompletionBreakedByNonBuilderInferenceSession.kt")
      public void testTopDownCompletionBreakedByNonBuilderInferenceSession() {
        runTest("compiler/testData/codegen/box/inference/pcla/topDownCompletionBreakedByNonBuilderInferenceSession.kt");
      }

      @Test
      @TestMetadata("topDownCompletionWithThreeBuilderInferenceCalls.kt")
      public void testTopDownCompletionWithThreeBuilderInferenceCalls() {
        runTest("compiler/testData/codegen/box/inference/pcla/topDownCompletionWithThreeBuilderInferenceCalls.kt");
      }

      @Test
      @TestMetadata("topDownCompletionWithThreeBuilderInferenceCallsSameLevel.kt")
      public void testTopDownCompletionWithThreeBuilderInferenceCallsSameLevel() {
        runTest("compiler/testData/codegen/box/inference/pcla/topDownCompletionWithThreeBuilderInferenceCallsSameLevel.kt");
      }

      @Test
      @TestMetadata("topDownCompletionWithTwoBuilderInferenceCalls.kt")
      public void testTopDownCompletionWithTwoBuilderInferenceCalls() {
        runTest("compiler/testData/codegen/box/inference/pcla/topDownCompletionWithTwoBuilderInferenceCalls.kt");
      }

      @Test
      @TestMetadata("withExpectedType.kt")
      public void testWithExpectedType() {
        runTest("compiler/testData/codegen/box/inference/pcla/withExpectedType.kt");
      }

      @Test
      @TestMetadata("withoutAnnotation.kt")
      public void testWithoutAnnotation() {
        runTest("compiler/testData/codegen/box/inference/pcla/withoutAnnotation.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/inference/pcla/issues")
      @TestDataPath("$PROJECT_ROOT")
      public class Issues {
        @Test
        public void testAllFilesPresentInIssues() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla/issues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt41164.kt")
        public void testKt41164() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt41164.kt");
        }

        @Test
        @TestMetadata("kt42139.kt")
        public void testKt42139() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt42139.kt");
        }

        @Test
        @TestMetadata("kt43710.kt")
        public void testKt43710() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt43710.kt");
        }

        @Test
        @TestMetadata("kt43710b.kt")
        public void testKt43710b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt43710b.kt");
        }

        @Test
        @TestMetadata("kt44241.kt")
        public void testKt44241() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt44241.kt");
        }

        @Test
        @TestMetadata("kt45083.kt")
        public void testKt45083() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt45083.kt");
        }

        @Test
        @TestMetadata("kt47052.kt")
        public void testKt47052() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt47052.kt");
        }

        @Test
        @TestMetadata("kt47744.kt")
        public void testKt47744() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt47744.kt");
        }

        @Test
        @TestMetadata("kt47989a.kt")
        public void testKt47989a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt47989a.kt");
        }

        @Test
        @TestMetadata("kt47989b.kt")
        public void testKt47989b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt47989b.kt");
        }

        @Test
        @TestMetadata("kt48633.kt")
        public void testKt48633() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt48633.kt");
        }

        @Test
        @TestMetadata("kt49160a.kt")
        public void testKt49160a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt49160a.kt");
        }

        @Test
        @TestMetadata("kt49160b.kt")
        public void testKt49160b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt49160b.kt");
        }

        @Test
        @TestMetadata("kt49160c.kt")
        public void testKt49160c() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt49160c.kt");
        }

        @Test
        @TestMetadata("kt49160d.kt")
        public void testKt49160d() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt49160d.kt");
        }

        @Test
        @TestMetadata("kt49160e.kt")
        public void testKt49160e() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt49160e.kt");
        }

        @Test
        @TestMetadata("kt49263.kt")
        public void testKt49263() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt49263.kt");
        }

        @Test
        @TestMetadata("kt49283.kt")
        public void testKt49283() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt49283.kt");
        }

        @Test
        @TestMetadata("kt49887.kt")
        public void testKt49887() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt49887.kt");
        }

        @Test
        @TestMetadata("kt50453.kt")
        public void testKt50453() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt50453.kt");
        }

        @Test
        @TestMetadata("kt50827a.kt")
        public void testKt50827a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt50827a.kt");
        }

        @Test
        @TestMetadata("kt50827b.kt")
        public void testKt50827b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt50827b.kt");
        }

        @Test
        @TestMetadata("kt51988.kt")
        public void testKt51988() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt51988.kt");
        }

        @Test
        @TestMetadata("kt52757.kt")
        public void testKt52757() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt52757.kt");
        }

        @Test
        @TestMetadata("kt52838a.kt")
        public void testKt52838a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt52838a.kt");
        }

        @Test
        @TestMetadata("kt52838b.kt")
        public void testKt52838b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt52838b.kt");
        }

        @Test
        @TestMetadata("kt52838c.kt")
        public void testKt52838c() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt52838c.kt");
        }

        @Test
        @TestMetadata("kt53109.kt")
        public void testKt53109() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt53109.kt");
        }

        @Test
        @TestMetadata("kt53422a.kt")
        public void testKt53422a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt53422a.kt");
        }

        @Test
        @TestMetadata("kt53422b.kt")
        public void testKt53422b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt53422b.kt");
        }

        @Test
        @TestMetadata("kt53478.kt")
        public void testKt53478() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt53478.kt");
        }

        @Test
        @TestMetadata("kt53553.kt")
        public void testKt53553() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt53553.kt");
        }

        @Test
        @TestMetadata("kt53639.kt")
        public void testKt53639() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt53639.kt");
        }

        @Test
        @TestMetadata("kt53740a.kt")
        public void testKt53740a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt53740a.kt");
        }

        @Test
        @TestMetadata("kt53740b.kt")
        public void testKt53740b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt53740b.kt");
        }

        @Test
        @TestMetadata("kt54400a.kt")
        public void testKt54400a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt54400a.kt");
        }

        @Test
        @TestMetadata("kt54400b.kt")
        public void testKt54400b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt54400b.kt");
        }

        @Test
        @TestMetadata("kt54400c.kt")
        public void testKt54400c() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt54400c.kt");
        }

        @Test
        @TestMetadata("kt54664.kt")
        public void testKt54664() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt54664.kt");
        }

        @Test
        @TestMetadata("kt54767a.kt")
        public void testKt54767a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt54767a.kt");
        }

        @Test
        @TestMetadata("kt54767b.kt")
        public void testKt54767b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt54767b.kt");
        }

        @Test
        @TestMetadata("kt55056.kt")
        public void testKt55056() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt55056.kt");
        }

        @Test
        @TestMetadata("kt55252.kt")
        public void testKt55252() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt55252.kt");
        }

        @Test
        @TestMetadata("kt55281.kt")
        public void testKt55281() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt55281.kt");
        }

        @Test
        @TestMetadata("kt56949.kt")
        public void testKt56949() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt56949.kt");
        }

        @Test
        @TestMetadata("kt57707.kt")
        public void testKt57707() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt57707.kt");
        }

        @Test
        @TestMetadata("kt57709.kt")
        public void testKt57709() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt57709.kt");
        }

        @Test
        @TestMetadata("kt57834.kt")
        public void testKt57834() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt57834.kt");
        }

        @Test
        @TestMetadata("kt59426.kt")
        public void testKt59426() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt59426.kt");
        }

        @Test
        @TestMetadata("kt59798.kt")
        public void testKt59798() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt59798.kt");
        }

        @Test
        @TestMetadata("kt60291a.kt")
        public void testKt60291a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt60291a.kt");
        }

        @Test
        @TestMetadata("kt60291b.kt")
        public void testKt60291b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt60291b.kt");
        }

        @Test
        @TestMetadata("kt60291c.kt")
        public void testKt60291c() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt60291c.kt");
        }

        @Test
        @TestMetadata("kt60447a.kt")
        public void testKt60447a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt60447a.kt");
        }

        @Test
        @TestMetadata("kt60447b.kt")
        public void testKt60447b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt60447b.kt");
        }

        @Test
        @TestMetadata("kt61310.kt")
        public void testKt61310() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt61310.kt");
        }

        @Test
        @TestMetadata("kt63733.kt")
        public void testKt63733() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt63733.kt");
        }

        @Test
        @TestMetadata("kt63840a.kt")
        public void testKt63840a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt63840a.kt");
        }

        @Test
        @TestMetadata("kt63840b.kt")
        public void testKt63840b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt63840b.kt");
        }

        @Test
        @TestMetadata("kt63840c.kt")
        public void testKt63840c() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt63840c.kt");
        }

        @Test
        @TestMetadata("kt64066.kt")
        public void testKt64066() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt64066.kt");
        }

        @Test
        @TestMetadata("kt64069.kt")
        public void testKt64069() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt64069.kt");
        }

        @Test
        @TestMetadata("kt65300a.kt")
        public void testKt65300a() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300a.kt");
        }

        @Test
        @TestMetadata("kt65300b.kt")
        public void testKt65300b() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300b.kt");
        }

        @Test
        @TestMetadata("kt65300c.kt")
        public void testKt65300c() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300c.kt");
        }

        @Test
        @TestMetadata("kt65300d.kt")
        public void testKt65300d() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300d.kt");
        }

        @Test
        @TestMetadata("kt65300e.kt")
        public void testKt65300e() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300e.kt");
        }

        @Test
        @TestMetadata("kt65300f.kt")
        public void testKt65300f() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300f.kt");
        }

        @Test
        @TestMetadata("kt65300g.kt")
        public void testKt65300g() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300g.kt");
        }

        @Test
        @TestMetadata("kt65300h.kt")
        public void testKt65300h() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300h.kt");
        }

        @Test
        @TestMetadata("kt65300i.kt")
        public void testKt65300i() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300i.kt");
        }

        @Test
        @TestMetadata("kt65300j.kt")
        public void testKt65300j() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65300j.kt");
        }

        @Test
        @TestMetadata("kt65341.kt")
        public void testKt65341() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt65341.kt");
        }

        @Test
        @TestMetadata("kt66229.kt")
        public void testKt66229() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt66229.kt");
        }

        @Test
        @TestMetadata("kt66243.kt")
        public void testKt66243() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt66243.kt");
        }

        @Test
        @TestMetadata("kt66272.kt")
        public void testKt66272() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt66272.kt");
        }

        @Test
        @TestMetadata("kt67993.kt")
        public void testKt67993() {
          runTest("compiler/testData/codegen/box/inference/pcla/issues/kt67993.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/codegen/box/inference/pcla/oneParameter")
      @TestDataPath("$PROJECT_ROOT")
      public class OneParameter {
        @Test
        public void testAllFilesPresentInOneParameter() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla/oneParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable")
        @TestDataPath("$PROJECT_ROOT")
        public class OneTypeVariable {
          @Test
          public void testAllFilesPresentInOneTypeVariable() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
          }

          @Nested
          @TestMetadata("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin")
          @TestDataPath("$PROJECT_ROOT")
          public class OneTypeInfoOrigin {
            @Test
            public void testAllFilesPresentInOneTypeInfoOrigin() {
              KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("AnonymousFunctionArgumentAndBuildeeParameter.kt")
            public void testAnonymousFunctionArgumentAndBuildeeParameter() {
              runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/AnonymousFunctionArgumentAndBuildeeParameter.kt");
            }

            @Test
            @TestMetadata("AnonymousFunctionArgumentAndBuildeeReceiver.kt")
            public void testAnonymousFunctionArgumentAndBuildeeReceiver() {
              runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/AnonymousFunctionArgumentAndBuildeeReceiver.kt");
            }

            @Test
            @TestMetadata("LambdaArgumentAndBuildeeParameter.kt")
            public void testLambdaArgumentAndBuildeeParameter() {
              runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/LambdaArgumentAndBuildeeParameter.kt");
            }

            @Test
            @TestMetadata("LambdaArgumentAndBuildeeReceiver.kt")
            public void testLambdaArgumentAndBuildeeReceiver() {
              runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/LambdaArgumentAndBuildeeReceiver.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts")
            @TestDataPath("$PROJECT_ROOT")
            public class SourceSinkFeedContexts {
              @Test
              public void testAllFilesPresentInSourceSinkFeedContexts() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
              }

              @Test
              @TestMetadata("ByAssignmentToALocalVariableMaterializeCase.kt")
              public void testByAssignmentToALocalVariableMaterializeCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ByAssignmentToALocalVariableMaterializeCase.kt");
              }

              @Test
              @TestMetadata("ByAssignmentToALocalVariableYieldCase.kt")
              public void testByAssignmentToALocalVariableYieldCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ByAssignmentToALocalVariableYieldCase.kt");
              }

              @Test
              @TestMetadata("InsideAnonymousObject.kt")
              public void testInsideAnonymousObject() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/InsideAnonymousObject.kt");
              }

              @Test
              @TestMetadata("InsideLocalClass.kt")
              public void testInsideLocalClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/InsideLocalClass.kt");
              }

              @Test
              @TestMetadata("InsideNestedLambda.kt")
              public void testInsideNestedLambda() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/InsideNestedLambda.kt");
              }

              @Test
              @TestMetadata("ThroughDelegatedLocalVariableMaterializeCase.kt")
              public void testThroughDelegatedLocalVariableMaterializeCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ThroughDelegatedLocalVariableMaterializeCase.kt");
              }

              @Test
              @TestMetadata("ThroughDelegatedLocalVariableYieldCase.kt")
              public void testThroughDelegatedLocalVariableYieldCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ThroughDelegatedLocalVariableYieldCase.kt");
              }

              @Test
              @TestMetadata("ThroughGenericFunctionCall.kt")
              public void testThroughGenericFunctionCall() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ThroughGenericFunctionCall.kt");
              }

              @Test
              @TestMetadata("ThroughLocalVariable.kt")
              public void testThroughLocalVariable() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/sourceSinkFeedContexts/ThroughLocalVariable.kt");
              }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes")
            @TestDataPath("$PROJECT_ROOT")
            public class TargetTypes {
              @Test
              public void testAllFilesPresentInTargetTypes() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
              }

              @Test
              @TestMetadata("AnonymousObject.kt")
              public void testAnonymousObject() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/AnonymousObject.kt");
              }

              @Test
              @TestMetadata("DefinitelyNonNullableTypeParameter.kt")
              public void testDefinitelyNonNullableTypeParameter() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/DefinitelyNonNullableTypeParameter.kt");
              }

              @Test
              @TestMetadata("EnclosingClass.kt")
              public void testEnclosingClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/EnclosingClass.kt");
              }

              @Test
              @TestMetadata("EnclosingEnumerationEntryType.kt")
              public void testEnclosingEnumerationEntryType() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/EnclosingEnumerationEntryType.kt");
              }

              @Test
              @TestMetadata("EnclosingEnumerationType.kt")
              public void testEnclosingEnumerationType() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/EnclosingEnumerationType.kt");
              }

              @Test
              @TestMetadata("EnclosingExplicitlyGenericInnerClass.kt")
              public void testEnclosingExplicitlyGenericInnerClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/EnclosingExplicitlyGenericInnerClass.kt");
              }

              @Test
              @TestMetadata("EnclosingGenericClass.kt")
              public void testEnclosingGenericClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/EnclosingGenericClass.kt");
              }

              @Test
              @TestMetadata("EnclosingImplicitlyGenericInnerClass.kt")
              public void testEnclosingImplicitlyGenericInnerClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/EnclosingImplicitlyGenericInnerClass.kt");
              }

              @Test
              @TestMetadata("EnclosingInnerClass.kt")
              public void testEnclosingInnerClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/EnclosingInnerClass.kt");
              }

              @Test
              @TestMetadata("EnumerationType.kt")
              public void testEnumerationType() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/EnumerationType.kt");
              }

              @Test
              @TestMetadata("ExplicitlyGenericInnerClass.kt")
              public void testExplicitlyGenericInnerClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/ExplicitlyGenericInnerClass.kt");
              }

              @Test
              @TestMetadata("FunctionWithParameterToUnit.kt")
              public void testFunctionWithParameterToUnit() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/FunctionWithParameterToUnit.kt");
              }

              @Test
              @TestMetadata("FunctionWithReceiverToUnit.kt")
              public void testFunctionWithReceiverToUnit() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/FunctionWithReceiverToUnit.kt");
              }

              @Test
              @TestMetadata("GenericLocalClass.kt")
              public void testGenericLocalClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/GenericLocalClass.kt");
              }

              @Test
              @TestMetadata("GenericLocalClassWithLeakingTypeParameter.kt")
              public void testGenericLocalClassWithLeakingTypeParameter() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/GenericLocalClassWithLeakingTypeParameter.kt");
              }

              @Test
              @TestMetadata("GenericWithContravariantTypeParameter.kt")
              public void testGenericWithContravariantTypeParameter() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/GenericWithContravariantTypeParameter.kt");
              }

              @Test
              @TestMetadata("GenericWithCovariantTypeParameter.kt")
              public void testGenericWithCovariantTypeParameter() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/GenericWithCovariantTypeParameter.kt");
              }

              @Test
              @TestMetadata("GenericWithInProjectedTypeArgument.kt")
              public void testGenericWithInProjectedTypeArgument() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/GenericWithInProjectedTypeArgument.kt");
              }

              @Test
              @TestMetadata("GenericWithInvariantTypeParameter.kt")
              public void testGenericWithInvariantTypeParameter() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/GenericWithInvariantTypeParameter.kt");
              }

              @Test
              @TestMetadata("GenericWithOutProjectedTypeArgument.kt")
              public void testGenericWithOutProjectedTypeArgument() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/GenericWithOutProjectedTypeArgument.kt");
              }

              @Test
              @TestMetadata("GenericWithStarProjectedTypeArgument.kt")
              public void testGenericWithStarProjectedTypeArgument() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/GenericWithStarProjectedTypeArgument.kt");
              }

              @Test
              @TestMetadata("ImplicitlyGenericInnerClass.kt")
              public void testImplicitlyGenericInnerClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/ImplicitlyGenericInnerClass.kt");
              }

              @Test
              @TestMetadata("InnerClass.kt")
              public void testInnerClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/InnerClass.kt");
              }

              @Test
              @TestMetadata("Int.kt")
              public void testInt() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/Int.kt");
              }

              @Test
              @TestMetadata("IntersectionType.kt")
              public void testIntersectionType() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/IntersectionType.kt");
              }

              @Test
              @TestMetadata("LocalClass.kt")
              public void testLocalClass() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/LocalClass.kt");
              }

              @Test
              @TestMetadata("NothingYieldCase.kt")
              public void testNothingYieldCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NothingYieldCase.kt");
              }

              @Test
              @TestMetadata("NullableNothing.kt")
              public void testNullableNothing() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NullableNothing.kt");
              }

              @Test
              @TestMetadata("NullableNothingNullLiteralYieldCase.kt")
              public void testNullableNothingNullLiteralYieldCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NullableNothingNullLiteralYieldCase.kt");
              }

              @Test
              @TestMetadata("NullableType.kt")
              public void testNullableType() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NullableType.kt");
              }

              @Test
              @TestMetadata("NullableTypeParameter.kt")
              public void testNullableTypeParameter() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NullableTypeParameter.kt");
              }

              @Test
              @TestMetadata("NullaryFunctionToUnit.kt")
              public void testNullaryFunctionToUnit() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NullaryFunctionToUnit.kt");
              }

              @Test
              @TestMetadata("NullaryFunctionWithReturnValue.kt")
              public void testNullaryFunctionWithReturnValue() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/NullaryFunctionWithReturnValue.kt");
              }

              @Test
              @TestMetadata("String.kt")
              public void testString() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/String.kt");
              }

              @Test
              @TestMetadata("SuspendingFunction.kt")
              public void testSuspendingFunction() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/SuspendingFunction.kt");
              }

              @Test
              @TestMetadata("TypeParameter.kt")
              public void testTypeParameter() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/targetTypes/TypeParameter.kt");
              }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks")
            @TestDataPath("$PROJECT_ROOT")
            public class TypeInfoSinks {
              @Test
              public void testAllFilesPresentInTypeInfoSinks() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
              }

              @Test
              @TestMetadata("ExtensionFunctions.kt")
              public void testExtensionFunctions() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ExtensionFunctions.kt");
              }

              @Test
              @TestMetadata("ImmutableExtensionProperties.kt")
              public void testImmutableExtensionProperties() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ImmutableExtensionProperties.kt");
              }

              @Test
              @TestMetadata("ImmutableProperties.kt")
              public void testImmutableProperties() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ImmutableProperties.kt");
              }

              @Test
              @TestMetadata("MutableExtensionPropertiesMaterializeCase.kt")
              public void testMutableExtensionPropertiesMaterializeCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/MutableExtensionPropertiesMaterializeCase.kt");
              }

              @Test
              @TestMetadata("MutableExtensionPropertiesYieldCase.kt")
              public void testMutableExtensionPropertiesYieldCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/MutableExtensionPropertiesYieldCase.kt");
              }

              @Test
              @TestMetadata("MutablePropertiesMaterializeCase.kt")
              public void testMutablePropertiesMaterializeCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/MutablePropertiesMaterializeCase.kt");
              }

              @Test
              @TestMetadata("MutablePropertiesYieldCase.kt")
              public void testMutablePropertiesYieldCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/MutablePropertiesYieldCase.kt");
              }

              @Test
              @TestMetadata("ParametersOfBuilderArguments.kt")
              public void testParametersOfBuilderArguments() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ParametersOfBuilderArguments.kt");
              }

              @Test
              @TestMetadata("ReceiversOfBuilderArguments.kt")
              public void testReceiversOfBuilderArguments() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSinks/ReceiversOfBuilderArguments.kt");
              }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources")
            @TestDataPath("$PROJECT_ROOT")
            public class TypeInfoSources {
              @Test
              public void testAllFilesPresentInTypeInfoSources() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
              }

              @Test
              @TestMetadata("ExtensionFunctions.kt")
              public void testExtensionFunctions() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ExtensionFunctions.kt");
              }

              @Test
              @TestMetadata("ExtensionProperties.kt")
              public void testExtensionProperties() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ExtensionProperties.kt");
              }

              @Test
              @TestMetadata("ParametersOfBuilderArguments.kt")
              public void testParametersOfBuilderArguments() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ParametersOfBuilderArguments.kt");
              }

              @Test
              @TestMetadata("ReceiversOfBuilderArguments.kt")
              public void testReceiversOfBuilderArguments() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ReceiversOfBuilderArguments.kt");
              }

              @Test
              @TestMetadata("ReturnTypesOfBuilderParameters.kt")
              public void testReturnTypesOfBuilderParameters() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/ReturnTypesOfBuilderParameters.kt");
              }

              @Test
              @TestMetadata("UnitReturnTypeOfBuilderParametersExplicitReturnCase.kt")
              public void testUnitReturnTypeOfBuilderParametersExplicitReturnCase() {
                runTest("compiler/testData/codegen/box/inference/pcla/oneParameter/oneTypeVariable/oneTypeInfoOrigin/typeInfoSources/UnitReturnTypeOfBuilderParametersExplicitReturnCase.kt");
              }
            }
          }
        }
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/initializers")
  @TestDataPath("$PROJECT_ROOT")
  public class Initializers {
    @Test
    public void testAllFilesPresentInInitializers() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/initializers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("correctOrder1.kt")
    public void testCorrectOrder1() {
      runTest("compiler/testData/codegen/box/initializers/correctOrder1.kt");
    }

    @Test
    @TestMetadata("correctOrder2.kt")
    public void testCorrectOrder2() {
      runTest("compiler/testData/codegen/box/initializers/correctOrder2.kt");
    }

    @Test
    @TestMetadata("correctOrder3.kt")
    public void testCorrectOrder3() {
      runTest("compiler/testData/codegen/box/initializers/correctOrder3.kt");
    }

    @Test
    @TestMetadata("initializers0.kt")
    public void testInitializers0() {
      runTest("compiler/testData/codegen/box/initializers/initializers0.kt");
    }

    @Test
    @TestMetadata("initializers1.kt")
    public void testInitializers1() {
      runTest("compiler/testData/codegen/box/initializers/initializers1.kt");
    }

    @Test
    @TestMetadata("initializers2.kt")
    public void testInitializers2() {
      runTest("compiler/testData/codegen/box/initializers/initializers2.kt");
    }

    @Test
    @TestMetadata("initializers3.kt")
    public void testInitializers3() {
      runTest("compiler/testData/codegen/box/initializers/initializers3.kt");
    }

    @Test
    @TestMetadata("initializers4.kt")
    public void testInitializers4() {
      runTest("compiler/testData/codegen/box/initializers/initializers4.kt");
    }

    @Test
    @TestMetadata("initializers5.kt")
    public void testInitializers5() {
      runTest("compiler/testData/codegen/box/initializers/initializers5.kt");
    }

    @Test
    @TestMetadata("initializers7.kt")
    public void testInitializers7() {
      runTest("compiler/testData/codegen/box/initializers/initializers7.kt");
    }

    @Test
    @TestMetadata("initializers8.kt")
    public void testInitializers8() {
      runTest("compiler/testData/codegen/box/initializers/initializers8.kt");
    }

    @Test
    @TestMetadata("initializers9.kt")
    public void testInitializers9() {
      runTest("compiler/testData/codegen/box/initializers/initializers9.kt");
    }

    @Test
    @TestMetadata("kt73691.kt")
    public void testKt73691() {
      runTest("compiler/testData/codegen/box/initializers/kt73691.kt");
    }

    @Test
    @TestMetadata("multipleModules1.kt")
    public void testMultipleModules1() {
      runTest("compiler/testData/codegen/box/initializers/multipleModules1.kt");
    }

    @Test
    @TestMetadata("object.kt")
    public void testObject() {
      runTest("compiler/testData/codegen/box/initializers/object.kt");
    }

    @Test
    @TestMetadata("sharedVarInInitBlock.kt")
    public void testSharedVarInInitBlock() {
      runTest("compiler/testData/codegen/box/initializers/sharedVarInInitBlock.kt");
    }

    @Test
    @TestMetadata("static_arrays.kt")
    public void testStatic_arrays() {
      runTest("compiler/testData/codegen/box/initializers/static_arrays.kt");
    }

    @Test
    @TestMetadata("static_list.kt")
    public void testStatic_list() {
      runTest("compiler/testData/codegen/box/initializers/static_list.kt");
    }

    @Test
    @TestMetadata("static_smallIntIdentity.kt")
    public void testStatic_smallIntIdentity() {
      runTest("compiler/testData/codegen/box/initializers/static_smallIntIdentity.kt");
    }

    @Test
    @TestMetadata("static_varargChange.kt")
    public void testStatic_varargChange() {
      runTest("compiler/testData/codegen/box/initializers/static_varargChange.kt");
    }

    @Test
    @TestMetadata("throw1.kt")
    public void testThrow1() {
      runTest("compiler/testData/codegen/box/initializers/throw1.kt");
    }

    @Test
    @TestMetadata("throw2.kt")
    public void testThrow2() {
      runTest("compiler/testData/codegen/box/initializers/throw2.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/initializers/files")
    @TestDataPath("$PROJECT_ROOT")
    public class Files {
      @Test
      public void testAllFilesPresentInFiles() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/initializers/files"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("globalInitedAfterAccessingFile.kt")
      public void testGlobalInitedAfterAccessingFile() {
        runTest("compiler/testData/codegen/box/initializers/files/globalInitedAfterAccessingFile.kt");
      }

      @Test
      @TestMetadata("globalNotInitedAfterAccessingClassInternals.kt")
      public void testGlobalNotInitedAfterAccessingClassInternals() {
        runTest("compiler/testData/codegen/box/initializers/files/globalNotInitedAfterAccessingClassInternals.kt");
      }

      @Test
      @TestMetadata("simple.kt")
      public void testSimple() {
        runTest("compiler/testData/codegen/box/initializers/files/simple.kt");
      }

      @Test
      @TestMetadata("simpleMultiModule.kt")
      public void testSimpleMultiModule() {
        runTest("compiler/testData/codegen/box/initializers/files/simpleMultiModule.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/inline")
  @TestDataPath("$PROJECT_ROOT")
  public class Inline {
    @Test
    public void testAllFilesPresentInInline() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("changingCapturedLocal.kt")
    public void testChangingCapturedLocal() {
      runTest("compiler/testData/codegen/box/inline/changingCapturedLocal.kt");
    }

    @Test
    @TestMetadata("classDeclarationInsideInline.kt")
    public void testClassDeclarationInsideInline() {
      runTest("compiler/testData/codegen/box/inline/classDeclarationInsideInline.kt");
    }

    @Test
    @TestMetadata("coercionToUnit.kt")
    public void testCoercionToUnit() {
      runTest("compiler/testData/codegen/box/inline/coercionToUnit.kt");
    }

    @Test
    @TestMetadata("correctOrderFunctionReference.kt")
    public void testCorrectOrderFunctionReference() {
      runTest("compiler/testData/codegen/box/inline/correctOrderFunctionReference.kt");
    }

    @Test
    @TestMetadata("defaultArgs.kt")
    public void testDefaultArgs() {
      runTest("compiler/testData/codegen/box/inline/defaultArgs.kt");
    }

    @Test
    @TestMetadata("defaultArgsLowering.kt")
    public void testDefaultArgsLowering() {
      runTest("compiler/testData/codegen/box/inline/defaultArgsLowering.kt");
    }

    @Test
    @TestMetadata("defaultArgsMultipleModules.kt")
    public void testDefaultArgsMultipleModules() {
      runTest("compiler/testData/codegen/box/inline/defaultArgsMultipleModules.kt");
    }

    @Test
    @TestMetadata("genericFunctionReference.kt")
    public void testGenericFunctionReference() {
      runTest("compiler/testData/codegen/box/inline/genericFunctionReference.kt");
    }

    @Test
    @TestMetadata("getClass.kt")
    public void testGetClass() {
      runTest("compiler/testData/codegen/box/inline/getClass.kt");
    }

    @Test
    @TestMetadata("inline0.kt")
    public void testInline0() {
      runTest("compiler/testData/codegen/box/inline/inline0.kt");
    }

    @Test
    @TestMetadata("inline1.kt")
    public void testInline1() {
      runTest("compiler/testData/codegen/box/inline/inline1.kt");
    }

    @Test
    @TestMetadata("inline10.kt")
    public void testInline10() {
      runTest("compiler/testData/codegen/box/inline/inline10.kt");
    }

    @Test
    @TestMetadata("inline11.kt")
    public void testInline11() {
      runTest("compiler/testData/codegen/box/inline/inline11.kt");
    }

    @Test
    @TestMetadata("inline12.kt")
    public void testInline12() {
      runTest("compiler/testData/codegen/box/inline/inline12.kt");
    }

    @Test
    @TestMetadata("inline13.kt")
    public void testInline13() {
      runTest("compiler/testData/codegen/box/inline/inline13.kt");
    }

    @Test
    @TestMetadata("inline14.kt")
    public void testInline14() {
      runTest("compiler/testData/codegen/box/inline/inline14.kt");
    }

    @Test
    @TestMetadata("inline15.kt")
    public void testInline15() {
      runTest("compiler/testData/codegen/box/inline/inline15.kt");
    }

    @Test
    @TestMetadata("inline16.kt")
    public void testInline16() {
      runTest("compiler/testData/codegen/box/inline/inline16.kt");
    }

    @Test
    @TestMetadata("inline17.kt")
    public void testInline17() {
      runTest("compiler/testData/codegen/box/inline/inline17.kt");
    }

    @Test
    @TestMetadata("inline19.kt")
    public void testInline19() {
      runTest("compiler/testData/codegen/box/inline/inline19.kt");
    }

    @Test
    @TestMetadata("inline2.kt")
    public void testInline2() {
      runTest("compiler/testData/codegen/box/inline/inline2.kt");
    }

    @Test
    @TestMetadata("inline20.kt")
    public void testInline20() {
      runTest("compiler/testData/codegen/box/inline/inline20.kt");
    }

    @Test
    @TestMetadata("inline21.kt")
    public void testInline21() {
      runTest("compiler/testData/codegen/box/inline/inline21.kt");
    }

    @Test
    @TestMetadata("inline22.kt")
    public void testInline22() {
      runTest("compiler/testData/codegen/box/inline/inline22.kt");
    }

    @Test
    @TestMetadata("inline23.kt")
    public void testInline23() {
      runTest("compiler/testData/codegen/box/inline/inline23.kt");
    }

    @Test
    @TestMetadata("inline24.kt")
    public void testInline24() {
      runTest("compiler/testData/codegen/box/inline/inline24.kt");
    }

    @Test
    @TestMetadata("inline25.kt")
    public void testInline25() {
      runTest("compiler/testData/codegen/box/inline/inline25.kt");
    }

    @Test
    @TestMetadata("inline26.kt")
    public void testInline26() {
      runTest("compiler/testData/codegen/box/inline/inline26.kt");
    }

    @Test
    @TestMetadata("inline3.kt")
    public void testInline3() {
      runTest("compiler/testData/codegen/box/inline/inline3.kt");
    }

    @Test
    @TestMetadata("inline4.kt")
    public void testInline4() {
      runTest("compiler/testData/codegen/box/inline/inline4.kt");
    }

    @Test
    @TestMetadata("inline5.kt")
    public void testInline5() {
      runTest("compiler/testData/codegen/box/inline/inline5.kt");
    }

    @Test
    @TestMetadata("inline6.kt")
    public void testInline6() {
      runTest("compiler/testData/codegen/box/inline/inline6.kt");
    }

    @Test
    @TestMetadata("inline7.kt")
    public void testInline7() {
      runTest("compiler/testData/codegen/box/inline/inline7.kt");
    }

    @Test
    @TestMetadata("inline8.kt")
    public void testInline8() {
      runTest("compiler/testData/codegen/box/inline/inline8.kt");
    }

    @Test
    @TestMetadata("inline9.kt")
    public void testInline9() {
      runTest("compiler/testData/codegen/box/inline/inline9.kt");
    }

    @Test
    @TestMetadata("inlineCtor.kt")
    public void testInlineCtor() {
      runTest("compiler/testData/codegen/box/inline/inlineCtor.kt");
    }

    @Test
    @TestMetadata("inlinedLambdaWithErasedParamType.kt")
    public void testInlinedLambdaWithErasedParamType() {
      runTest("compiler/testData/codegen/box/inline/inlinedLambdaWithErasedParamType.kt");
    }

    @Test
    @TestMetadata("innerInlineFunCapturesOuter.kt")
    public void testInnerInlineFunCapturesOuter() {
      runTest("compiler/testData/codegen/box/inline/innerInlineFunCapturesOuter.kt");
    }

    @Test
    @TestMetadata("kt66017.kt")
    public void testKt66017() {
      runTest("compiler/testData/codegen/box/inline/kt66017.kt");
    }

    @Test
    @TestMetadata("kt66017_inlineFromTheSameModule.kt")
    public void testKt66017_inlineFromTheSameModule() {
      runTest("compiler/testData/codegen/box/inline/kt66017_inlineFromTheSameModule.kt");
    }

    @Test
    @TestMetadata("lambdaAsAny.kt")
    public void testLambdaAsAny() {
      runTest("compiler/testData/codegen/box/inline/lambdaAsAny.kt");
    }

    @Test
    @TestMetadata("lambdaInDefaultValue.kt")
    public void testLambdaInDefaultValue() {
      runTest("compiler/testData/codegen/box/inline/lambdaInDefaultValue.kt");
    }

    @Test
    @TestMetadata("lateinitProperty.kt")
    public void testLateinitProperty() {
      runTest("compiler/testData/codegen/box/inline/lateinitProperty.kt");
    }

    @Test
    @TestMetadata("LocalEntitiesInAnonymousObjectInInlineCallables.kt")
    public void testLocalEntitiesInAnonymousObjectInInlineCallables() {
      runTest("compiler/testData/codegen/box/inline/LocalEntitiesInAnonymousObjectInInlineCallables.kt");
    }

    @Test
    @TestMetadata("localFunctionInInitializerBlock.kt")
    public void testLocalFunctionInInitializerBlock() {
      runTest("compiler/testData/codegen/box/inline/localFunctionInInitializerBlock.kt");
    }

    @Test
    @TestMetadata("localObjectReturnedFromWhen.kt")
    public void testLocalObjectReturnedFromWhen() {
      runTest("compiler/testData/codegen/box/inline/localObjectReturnedFromWhen.kt");
    }

    @Test
    @TestMetadata("propertyAccessorInline.kt")
    public void testPropertyAccessorInline() {
      runTest("compiler/testData/codegen/box/inline/propertyAccessorInline.kt");
    }

    @Test
    @TestMetadata("redundantCoercionsCleaner.kt")
    public void testRedundantCoercionsCleaner() {
      runTest("compiler/testData/codegen/box/inline/redundantCoercionsCleaner.kt");
    }

    @Test
    @TestMetadata("redundantCoercionsCleanerKT48876.kt")
    public void testRedundantCoercionsCleanerKT48876() {
      runTest("compiler/testData/codegen/box/inline/redundantCoercionsCleanerKT48876.kt");
    }

    @Test
    @TestMetadata("redundantCoercionsCleanerKT49356.kt")
    public void testRedundantCoercionsCleanerKT49356() {
      runTest("compiler/testData/codegen/box/inline/redundantCoercionsCleanerKT49356.kt");
    }

    @Test
    @TestMetadata("returnLocalClassFromBlock.kt")
    public void testReturnLocalClassFromBlock() {
      runTest("compiler/testData/codegen/box/inline/returnLocalClassFromBlock.kt");
    }

    @Test
    @TestMetadata("sharedVar.kt")
    public void testSharedVar() {
      runTest("compiler/testData/codegen/box/inline/sharedVar.kt");
    }

    @Test
    @TestMetadata("statementAsLastExprInBlock.kt")
    public void testStatementAsLastExprInBlock() {
      runTest("compiler/testData/codegen/box/inline/statementAsLastExprInBlock.kt");
    }

    @Test
    @TestMetadata("twiceInlinedObject.kt")
    public void testTwiceInlinedObject() {
      runTest("compiler/testData/codegen/box/inline/twiceInlinedObject.kt");
    }

    @Test
    @TestMetadata("typeSubstitutionInFakeOverride.kt")
    public void testTypeSubstitutionInFakeOverride() {
      runTest("compiler/testData/codegen/box/inline/typeSubstitutionInFakeOverride.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/inlineArgsInPlace")
  @TestDataPath("$PROJECT_ROOT")
  public class InlineArgsInPlace {
    @Test
    public void testAllFilesPresentInInlineArgsInPlace() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arrayDequeRemoveAll.kt")
    public void testArrayDequeRemoveAll() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/arrayDequeRemoveAll.kt");
    }

    @Test
    @TestMetadata("breakInArgumentExpression.kt")
    public void testBreakInArgumentExpression() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/breakInArgumentExpression.kt");
    }

    @Test
    @TestMetadata("continueInArgumentExpression.kt")
    public void testContinueInArgumentExpression() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/continueInArgumentExpression.kt");
    }

    @Test
    @TestMetadata("inlineCircularDedepency.kt")
    public void testInlineCircularDedepency() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/inlineCircularDedepency.kt");
    }

    @Test
    @TestMetadata("kotlinReflect.kt")
    public void testKotlinReflect() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/kotlinReflect.kt");
    }

    @Test
    @TestMetadata("kt49370.kt")
    public void testKt49370() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/kt49370.kt");
    }

    @Test
    @TestMetadata("kt49407.kt")
    public void testKt49407() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/kt49407.kt");
    }

    @Test
    @TestMetadata("mapSet.kt")
    public void testMapSet() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/mapSet.kt");
    }

    @Test
    @TestMetadata("mutableCollectionPlusAssign.kt")
    public void testMutableCollectionPlusAssign() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/mutableCollectionPlusAssign.kt");
    }

    @Test
    @TestMetadata("noinlineParameter.kt")
    public void testNoinlineParameter() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/noinlineParameter.kt");
    }

    @Test
    @TestMetadata("suspensionPointInsideArgument.kt")
    public void testSuspensionPointInsideArgument() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/suspensionPointInsideArgument.kt");
    }

    @Test
    @TestMetadata("withLogFile.kt")
    public void testWithLogFile() {
      runTest("compiler/testData/codegen/box/inlineArgsInPlace/withLogFile.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/inlineClass")
  @TestDataPath("$PROJECT_ROOT")
  public class InlineClass {
    @Test
    public void testAllFilesPresentInInlineClass() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("customEquals.kt")
    public void testCustomEquals() {
      runTest("compiler/testData/codegen/box/inlineClass/customEquals.kt");
    }

    @Test
    @TestMetadata("defaultEquals.kt")
    public void testDefaultEquals() {
      runTest("compiler/testData/codegen/box/inlineClass/defaultEquals.kt");
    }

    @Test
    @TestMetadata("nestedInlineClasses.kt")
    public void testNestedInlineClasses() {
      runTest("compiler/testData/codegen/box/inlineClass/nestedInlineClasses.kt");
    }

    @Test
    @TestMetadata("secondaryConstructorWithGenerics.kt")
    public void testSecondaryConstructorWithGenerics() {
      runTest("compiler/testData/codegen/box/inlineClass/secondaryConstructorWithGenerics.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/codegen/box/inlineClasses")
  @TestDataPath("$PROJECT_ROOT")
  public class InlineClasses {
    @Test
    public void testAllFilesPresentInInlineClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotatedMemberExtensionProperty.kt")
    public void testAnnotatedMemberExtensionProperty() {
      runTest("compiler/testData/codegen/box/inlineClasses/annotatedMemberExtensionProperty.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("annotatedMemberExtensionPropertyGeneric.kt")
    public void testAnnotatedMemberExtensionPropertyGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/annotatedMemberExtensionPropertyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("anySuperCall.kt")
    public void testAnySuperCall() {
      runTest("compiler/testData/codegen/box/inlineClasses/anySuperCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("anySuperCallGeneric.kt")
    public void testAnySuperCallGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/anySuperCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boundCallableReferencePassedToInlineFunction.kt")
    public void testBoundCallableReferencePassedToInlineFunction() {
      runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunction.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boundCallableReferencePassedToInlineFunctionGeneric.kt")
    public void testBoundCallableReferencePassedToInlineFunctionGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunctionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boundCallableReferencePassedToInlineFunctionGeneric2.kt")
    public void testBoundCallableReferencePassedToInlineFunctionGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunctionGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxImplDoesNotExecuteInSecondaryConstructor.kt")
    public void testBoxImplDoesNotExecuteInSecondaryConstructor() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInSecondaryConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxImplDoesNotExecuteInSecondaryConstructorGeneric.kt")
    public void testBoxImplDoesNotExecuteInSecondaryConstructorGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInSecondaryConstructorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxImplDoesNotExecuteInitBlock.kt")
    public void testBoxImplDoesNotExecuteInitBlock() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInitBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxImplDoesNotExecuteInitBlockGeneric.kt")
    public void testBoxImplDoesNotExecuteInitBlockGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInitBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableForFakeOverride.kt")
    public void testBoxNullableForFakeOverride() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverride.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableForFakeOverrideGeneric.kt")
    public void testBoxNullableForFakeOverrideGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverrideGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableForFakeOverrideGeneric2.kt")
    public void testBoxNullableForFakeOverrideGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverrideGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
    public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingType() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt")
    public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2.kt")
    public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
    public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingType() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt")
    public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2.kt")
    public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxResultInlineClassOfConstructorCall.kt")
    public void testBoxResultInlineClassOfConstructorCall() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxResultInlineClassOfConstructorCallGeneric.kt")
    public void testBoxResultInlineClassOfConstructorCallGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxResultInlineClassOfConstructorCallGeneric2.kt")
    public void testBoxResultInlineClassOfConstructorCallGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCallGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSet.kt")
    public void testBoxUnboxInlineClassesWithOperatorsGetSet() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSet.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSetGeneric.kt")
    public void testBoxUnboxInlineClassesWithOperatorsGetSetGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSetGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxUnboxOfInlineClassForCapturedVars.kt")
    public void testBoxUnboxOfInlineClassForCapturedVars() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVars.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("boxUnboxOfInlineClassForCapturedVarsGeneric.kt")
    public void testBoxUnboxOfInlineClassForCapturedVarsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVarsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("bridgeForFunctionReturningInlineClass.kt")
    public void testBridgeForFunctionReturningInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("bridgeForFunctionReturningInlineClassGeneric.kt")
    public void testBridgeForFunctionReturningInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("bridgeGenerationWithInlineClassOverAny.kt")
    public void testBridgeGenerationWithInlineClassOverAny() {
      runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("bridgeGenerationWithInlineClassOverAnyGeneric.kt")
    public void testBridgeGenerationWithInlineClassOverAnyGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("bridgeGenerationWithInlineClassOverAnyGeneric2.kt")
    public void testBridgeGenerationWithInlineClassOverAnyGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAnyGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("bridgesWhenInlineClassImplementsGenericInterface.kt")
    public void testBridgesWhenInlineClassImplementsGenericInterface() {
      runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterface.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("bridgesWhenInlineClassImplementsGenericInterfaceGeneric.kt")
    public void testBridgesWhenInlineClassImplementsGenericInterfaceGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterfaceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("callComputablePropertyInsideInlineClass.kt")
    public void testCallComputablePropertyInsideInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/callComputablePropertyInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("callSpecializedEqualsViaReflection.kt")
    public void testCallSpecializedEqualsViaReflection() {
      runTest("compiler/testData/codegen/box/inlineClasses/callSpecializedEqualsViaReflection.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("callSpecializedEqualsViaReflectionGeneric.kt")
    public void testCallSpecializedEqualsViaReflectionGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/callSpecializedEqualsViaReflectionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("callSpeciallyOverriddenPropertyOfInlineClass.kt")
    public void testCallSpeciallyOverriddenPropertyOfInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/callSpeciallyOverriddenPropertyOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("callSpeciallyOverriddenPropertyOfInlineClassGeneric.kt")
    public void testCallSpeciallyOverriddenPropertyOfInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/callSpeciallyOverriddenPropertyOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("callableReferencesWithInlineClasses.kt")
    public void testCallableReferencesWithInlineClasses() {
      runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("callableReferencesWithInlineClassesGeneric.kt")
    public void testCallableReferencesWithInlineClassesGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("castInsideWhenExpression.kt")
    public void testCastInsideWhenExpression() {
      runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpression.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("castInsideWhenExpressionGeneric.kt")
    public void testCastInsideWhenExpressionGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpressionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctions.kt")
    public void testCheckBoxUnboxOfArgumentsOnInlinedFunctions() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctionsGeneric.kt")
    public void testCheckBoxUnboxOfArgumentsOnInlinedFunctionsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingAfterAssertionOperator.kt")
    public void testCheckBoxingAfterAssertionOperator() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperator.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingAfterAssertionOperatorGeneric.kt")
    public void testCheckBoxingAfterAssertionOperatorGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperatorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingForComplexClassHierarchy.kt")
    public void testCheckBoxingForComplexClassHierarchy() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchy.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingForComplexClassHierarchyGeneric.kt")
    public void testCheckBoxingForComplexClassHierarchyGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingForNonLocalAndLabeledReturns.kt")
    public void testCheckBoxingForNonLocalAndLabeledReturns() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturns.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingForNonLocalAndLabeledReturnsGeneric.kt")
    public void testCheckBoxingForNonLocalAndLabeledReturnsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturnsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingFromReturnTypeForInlineClasses.kt")
    public void testCheckBoxingFromReturnTypeForInlineClasses() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingFromReturnTypeForInlineClassesGeneric.kt")
    public void testCheckBoxingFromReturnTypeForInlineClassesGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingOnFunctionCalls.kt")
    public void testCheckBoxingOnFunctionCalls() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCalls.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingOnFunctionCallsGeneric.kt")
    public void testCheckBoxingOnFunctionCallsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCallsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingOnLocalVariableAssignments.kt")
    public void testCheckBoxingOnLocalVariableAssignments() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignments.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingOnLocalVariableAssignmentsGeneric.kt")
    public void testCheckBoxingOnLocalVariableAssignmentsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignmentsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt")
    public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctions() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric.kt")
    public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkCallingMembersInsideInlineClass.kt")
    public void testCheckCallingMembersInsideInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkCallingMembersInsideInlineClassGeneric.kt")
    public void testCheckCallingMembersInsideInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkCastToInlineClass.kt")
    public void testCheckCastToInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkCastToInlineClassGeneric.kt")
    public void testCheckCastToInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkForInstanceOfInlineClass.kt")
    public void testCheckForInstanceOfInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkForInstanceOfInlineClassGeneric.kt")
    public void testCheckForInstanceOfInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkLambdaWithInlineClassesInFunctionalType.kt")
    public void testCheckLambdaWithInlineClassesInFunctionalType() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkLambdaWithInlineClassesInFunctionalTypeGeneric.kt")
    public void testCheckLambdaWithInlineClassesInFunctionalTypeGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkUnboxingResultFromTypeVariable.kt")
    public void testCheckUnboxingResultFromTypeVariable() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkUnboxingResultFromTypeVariableGeneric.kt")
    public void testCheckUnboxingResultFromTypeVariableGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("checkUnboxingResultFromTypeVariableGeneric2.kt")
    public void testCheckUnboxingResultFromTypeVariableGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("classInInlineClassInit.kt")
    public void testClassInInlineClassInit() {
      runTest("compiler/testData/codegen/box/inlineClasses/classInInlineClassInit.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("classInInlineClassInitGeneric.kt")
    public void testClassInInlineClassInitGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/classInInlineClassInitGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("classLiteralOnInlineClass.kt")
    public void testClassLiteralOnInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/classLiteralOnInlineClass.kt");
    }

    @Test
    @TestMetadata("classLiteralOnInlineClassGeneric.kt")
    public void testClassLiteralOnInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/classLiteralOnInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("computablePropertyInsideInlineClass.kt")
    public void testComputablePropertyInsideInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/computablePropertyInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("conformToComparableAndCallInterfaceMethod.kt")
    public void testConformToComparableAndCallInterfaceMethod() {
      runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethod.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("conformToComparableAndCallInterfaceMethodGeneric.kt")
    public void testConformToComparableAndCallInterfaceMethodGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethodGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("constructorCallableReference.kt")
    public void testConstructorCallableReference() {
      runTest("compiler/testData/codegen/box/inlineClasses/constructorCallableReference.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("constructorCallableReferenceGeneric.kt")
    public void testConstructorCallableReferenceGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/constructorCallableReferenceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("constructorImplVisibility.kt")
    public void testConstructorImplVisibility() {
      runTest("compiler/testData/codegen/box/inlineClasses/constructorImplVisibility.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("constructorImplVisibilityGeneric.kt")
    public void testConstructorImplVisibilityGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/constructorImplVisibilityGeneric.kt");
    }

    @Test
    @TestMetadata("correctBoxingForBranchExpressions.kt")
    public void testCorrectBoxingForBranchExpressions() {
      runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("correctBoxingForBranchExpressionsGeneric.kt")
    public void testCorrectBoxingForBranchExpressionsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("createInlineClassInArgumentPosition.kt")
    public void testCreateInlineClassInArgumentPosition() {
      runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPosition.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("createInlineClassInArgumentPositionGeneric.kt")
    public void testCreateInlineClassInArgumentPositionGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPositionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("crossinlineWithInlineClassInParameter.kt")
    public void testCrossinlineWithInlineClassInParameter() {
      runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameter.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("crossinlineWithInlineClassInParameterGeneric.kt")
    public void testCrossinlineWithInlineClassInParameterGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameterGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("crossinlineWithInlineClassInParameterGeneric2.kt")
    public void testCrossinlineWithInlineClassInParameterGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameterGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("customIterator.kt")
    public void testCustomIterator() {
      runTest("compiler/testData/codegen/box/inlineClasses/customIterator.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("defaultFunctionsFromAnyForInlineClass.kt")
    public void testDefaultFunctionsFromAnyForInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("defaultFunctionsFromAnyForInlineClassGeneric.kt")
    public void testDefaultFunctionsFromAnyForInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("defaultInterfaceMethodsInInlineClass.kt")
    public void testDefaultInterfaceMethodsInInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/defaultInterfaceMethodsInInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("defaultInterfaceMethodsInInlineClassGeneric.kt")
    public void testDefaultInterfaceMethodsInInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/defaultInterfaceMethodsInInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("defaultWithInlineClassArgument.kt")
    public void testDefaultWithInlineClassArgument() {
      runTest("compiler/testData/codegen/box/inlineClasses/defaultWithInlineClassArgument.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("defaultWithInlineClassArgumentGeneric.kt")
    public void testDefaultWithInlineClassArgumentGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/defaultWithInlineClassArgumentGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("delegateFromDifferentPackage.kt")
    public void testDelegateFromDifferentPackage() {
      runTest("compiler/testData/codegen/box/inlineClasses/delegateFromDifferentPackage.kt");
    }

    @Test
    @TestMetadata("dnnInValue.kt")
    public void testDnnInValue() {
      runTest("compiler/testData/codegen/box/inlineClasses/dnnInValue.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("elvisWithInlineClassAndNullConstant.kt")
    public void testElvisWithInlineClassAndNullConstant() {
      runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstant.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("elvisWithInlineClassAndNullConstantGeneric.kt")
    public void testElvisWithInlineClassAndNullConstantGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstantGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("emptyConstructorForInlineClass.kt")
    public void testEmptyConstructorForInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("emptyConstructorForInlineClassGeneric.kt")
    public void testEmptyConstructorForInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksInlineClassNonNull.kt")
    public void testEqualityChecksInlineClassNonNull() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksInlineClassNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksInlineClassNonNullGeneric.kt")
    public void testEqualityChecksInlineClassNonNullGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksInlineClassNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksMixedNullability.kt")
    public void testEqualityChecksMixedNullability() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksMixedNullability.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksMixedNullabilityGeneric.kt")
    public void testEqualityChecksMixedNullabilityGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksMixedNullabilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedInlineClassNonNull.kt")
    public void testEqualityChecksNegatedInlineClassNonNull() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedInlineClassNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedInlineClassNonNullGeneric.kt")
    public void testEqualityChecksNegatedInlineClassNonNullGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedInlineClassNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedNonNull.kt")
    public void testEqualityChecksNegatedNonNull() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedNonNullGeneric.kt")
    public void testEqualityChecksNegatedNonNullGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedNullable.kt")
    public void testEqualityChecksNegatedNullable() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedNullableGeneric.kt")
    public void testEqualityChecksNegatedNullableGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedNullableGeneric2.kt")
    public void testEqualityChecksNegatedNullableGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedPrimitive.kt")
    public void testEqualityChecksNegatedPrimitive() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNegatedPrimitiveGeneric.kt")
    public void testEqualityChecksNegatedPrimitiveGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNonNull.kt")
    public void testEqualityChecksNonNull() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNonNullGeneric.kt")
    public void testEqualityChecksNonNullGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNullable.kt")
    public void testEqualityChecksNullable() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNullableGeneric.kt")
    public void testEqualityChecksNullableGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksNullableGeneric2.kt")
    public void testEqualityChecksNullableGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksPrimitive.kt")
    public void testEqualityChecksPrimitive() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksPrimitiveGeneric.kt")
    public void testEqualityChecksPrimitiveGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityChecksPrimitiveUnboxed.kt")
    public void testEqualityChecksPrimitiveUnboxed() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitiveUnboxed.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClass.kt")
    public void testEqualityForBoxesOfNullableValuesOfInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClassGeneric.kt")
    public void testEqualityForBoxesOfNullableValuesOfInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalityForIndyLambdaParameter.kt")
    public void testEqualityForIndyLambdaParameter() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalityForIndyLambdaParameter.kt");
    }

    @Test
    @TestMetadata("equalsCallsLeftArgument.kt")
    public void testEqualsCallsLeftArgument() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsCallsLeftArgument.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsCallsLeftArgumentGeneric.kt")
    public void testEqualsCallsLeftArgumentGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsCallsLeftArgumentGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderInlineClass.kt")
    public void testEqualsEvaluationOrderInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderInlineClassGeneric.kt")
    public void testEqualsEvaluationOrderInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderNonNull.kt")
    public void testEqualsEvaluationOrderNonNull() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderNonNullGeneric.kt")
    public void testEqualsEvaluationOrderNonNullGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderNullable.kt")
    public void testEqualsEvaluationOrderNullable() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderNullableGeneric.kt")
    public void testEqualsEvaluationOrderNullableGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderNullableGeneric2.kt")
    public void testEqualsEvaluationOrderNullableGeneric2() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderPrimitive.kt")
    public void testEqualsEvaluationOrderPrimitive() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsEvaluationOrderPrimitiveGeneric.kt")
    public void testEqualsEvaluationOrderPrimitiveGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsOperatorWithGenericCall.kt")
    public void testEqualsOperatorWithGenericCall() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("equalsOperatorWithGenericCallGeneric.kt")
    public void testEqualsOperatorWithGenericCallGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("extLambdaInInlineClassFun.kt")
    public void testExtLambdaInInlineClassFun() {
      runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("extLambdaInInlineClassFun2.kt")
    public void testExtLambdaInInlineClassFun2() {
      runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("extLambdaInInlineClassFun2Generic.kt")
    public void testExtLambdaInInlineClassFun2Generic() {
      runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("extLambdaInInlineClassFunGeneric.kt")
    public void testExtLambdaInInlineClassFunGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("fieldNameClash.kt")
    public void testFieldNameClash() {
      runTest("compiler/testData/codegen/box/inlineClasses/fieldNameClash.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("fieldNameClashGeneric.kt")
    public void testFieldNameClashGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/fieldNameClashGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("funInterfaceDoubleSuffux.kt")
    public void testFunInterfaceDoubleSuffux() {
      runTest("compiler/testData/codegen/box/inlineClasses/funInterfaceDoubleSuffux.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("funInterfaceDoubleSuffux2.kt")
    public void testFunInterfaceDoubleSuffux2() {
      runTest("compiler/testData/codegen/box/inlineClasses/funInterfaceDoubleSuffux2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("functionExpression.kt")
    public void testFunctionExpression() {
      runTest("compiler/testData/codegen/box/inlineClasses/functionExpression.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("functionExpressionGeneric.kt")
    public void testFunctionExpressionGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/functionExpressionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("genericInlineClassSynthMembers.kt")
    public void testGenericInlineClassSynthMembers() {
      runTest("compiler/testData/codegen/box/inlineClasses/genericInlineClassSynthMembers.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("genericVararg2ndConstructor.kt")
    public void testGenericVararg2ndConstructor() {
      runTest("compiler/testData/codegen/box/inlineClasses/genericVararg2ndConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("implicitCastToNonValueClassType.kt")
    public void testImplicitCastToNonValueClassType() {
      runTest("compiler/testData/codegen/box/inlineClasses/implicitCastToNonValueClassType.kt");
    }

    @Test
    @TestMetadata("infixCompareToOptimization.kt")
    public void testInfixCompareToOptimization() {
      runTest("compiler/testData/codegen/box/inlineClasses/infixCompareToOptimization.kt");
    }

    @Test
    @TestMetadata("initBlock.kt")
    public void testInitBlock() {
      runTest("compiler/testData/codegen/box/inlineClasses/initBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("initBlockGeneric.kt")
    public void testInitBlockGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/initBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("initInCompanion.kt")
    public void testInitInCompanion() {
      runTest("compiler/testData/codegen/box/inlineClasses/initInCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassAsLastExpressionInInLambda.kt")
    public void testInlineClassAsLastExpressionInInLambda() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassAsLastExpressionInInLambdaGeneric.kt")
    public void testInlineClassAsLastExpressionInInLambdaGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassBothEqualsOverride.kt")
    public void testInlineClassBothEqualsOverride() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassBothEqualsOverride.kt");
    }

    @Test
    @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt")
    public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointData() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric.kt")
    public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassEqualsConsistency.kt")
    public void testInlineClassEqualsConsistency() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualsConsistency.kt");
    }

    @Test
    @TestMetadata("inlineClassEqualsOverriddenForCollections.kt")
    public void testInlineClassEqualsOverriddenForCollections() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualsOverriddenForCollections.kt");
    }

    @Test
    @TestMetadata("inlineClassEqualsOverride.kt")
    public void testInlineClassEqualsOverride() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualsOverride.kt");
    }

    @Test
    @TestMetadata("inlineClassFieldHandling.kt")
    public void testInlineClassFieldHandling() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFieldHandling.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassFieldHandlingGeneric.kt")
    public void testInlineClassFieldHandlingGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFieldHandlingGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassFunctionInvoke.kt")
    public void testInlineClassFunctionInvoke() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvoke.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassFunctionInvokeGeneric.kt")
    public void testInlineClassFunctionInvokeGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvokeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassHashCodeOverride.kt")
    public void testInlineClassHashCodeOverride() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassHashCodeOverride.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassImplementsCollection.kt")
    public void testInlineClassImplementsCollection() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassImplementsCollection.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassImplementsCollectionGeneric.kt")
    public void testInlineClassImplementsCollectionGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassImplementsCollectionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassImplementsJavaLangInterface.kt")
    public void testInlineClassImplementsJavaLangInterface() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassImplementsJavaLangInterface.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassInInitBlock.kt")
    public void testInlineClassInInitBlock() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInInitBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassInInitBlockGeneric.kt")
    public void testInlineClassInInitBlockGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInInitBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassInStringTemplate.kt")
    public void testInlineClassInStringTemplate() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplate.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassInStringTemplateGeneric.kt")
    public void testInlineClassInStringTemplateGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplateGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassPropertyReferenceGetAndSet.kt")
    public void testInlineClassPropertyReferenceGetAndSet() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSet.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassPropertyReferenceGetAndSetGeneric.kt")
    public void testInlineClassPropertyReferenceGetAndSetGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSetGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassTypedEqualsGenerics.kt")
    public void testInlineClassTypedEqualsGenerics() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassTypedEqualsGenerics.kt");
    }

    @Test
    @TestMetadata("inlineClassUntypedEqualsOverriden.kt")
    public void testInlineClassUntypedEqualsOverriden() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassUntypedEqualsOverriden.kt");
    }

    @Test
    @TestMetadata("inlineClassValueCapturedInInlineLambda.kt")
    public void testInlineClassValueCapturedInInlineLambda() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassValueCapturedInInlineLambdaGeneric.kt")
    public void testInlineClassValueCapturedInInlineLambdaGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassValueCapturedInNonInlineLambda.kt")
    public void testInlineClassValueCapturedInNonInlineLambda() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassValueCapturedInNonInlineLambdaGeneric.kt")
    public void testInlineClassValueCapturedInNonInlineLambdaGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassValuesInsideStrings.kt")
    public void testInlineClassValuesInsideStrings() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStrings.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassValuesInsideStringsGeneric.kt")
    public void testInlineClassValuesInsideStringsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStringsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassWithCustomEquals.kt")
    public void testInlineClassWithCustomEquals() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEquals.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassWithCustomEqualsGeneric.kt")
    public void testInlineClassWithCustomEqualsGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEqualsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassWithDefaultFunctionsFromAny.kt")
    public void testInlineClassWithDefaultFunctionsFromAny() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassWithDefaultFunctionsFromAnyGeneric.kt")
    public void testInlineClassWithDefaultFunctionsFromAnyGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassesAsInlineFunParameters.kt")
    public void testInlineClassesAsInlineFunParameters() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassesAsInlineFunParametersGeneric.kt")
    public void testInlineClassesAsInlineFunParametersGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassesCheckCast.kt")
    public void testInlineClassesCheckCast() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCast.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassesCheckCastGeneric.kt")
    public void testInlineClassesCheckCastGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCastGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassesInInlineLambdaParameters.kt")
    public void testInlineClassesInInlineLambdaParameters() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassesInInlineLambdaParametersGeneric.kt")
    public void testInlineClassesInInlineLambdaParametersGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassesRefTypesInInlineLambdaParameters.kt")
    public void testInlineClassesRefTypesInInlineLambdaParameters() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineClassesRefTypesInInlineLambdaParametersGeneric.kt")
    public void testInlineClassesRefTypesInInlineLambdaParametersGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineExtLambdaInInlineClassFun.kt")
    public void testInlineExtLambdaInInlineClassFun() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineExtLambdaInInlineClassFun2.kt")
    public void testInlineExtLambdaInInlineClassFun2() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineExtLambdaInInlineClassFun2Generic.kt")
    public void testInlineExtLambdaInInlineClassFun2Generic() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineExtLambdaInInlineClassFunGeneric.kt")
    public void testInlineExtLambdaInInlineClassFunGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineFunctionInsideInlineClass.kt")
    public void testInlineFunctionInsideInlineClass() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineFunctionInsideInlineClassGeneric.kt")
    public void testInlineFunctionInsideInlineClassGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("inlineInCompanion.kt")
    public void testInlineInCompanion() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineInCompanion.kt");
    }

    @Test
    @TestMetadata("inlineInCompanionGeneric.kt")
    public void testInlineInCompanionGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineInCompanionGeneric.kt");
    }

    @Test
    @TestMetadata("inlineOverInlineWithCustomEquals.kt")
    public void testInlineOverInlineWithCustomEquals() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineOverInlineWithCustomEquals.kt");
    }

    @Test
    @TestMetadata("inlineToString.kt")
    public void testInlineToString() {
      runTest("compiler/testData/codegen/box/inlineClasses/inlineToString.kt");
    }

    @Test
    @TestMetadata("iterateOverArrayOfInlineClassValues.kt")
    public void testIterateOverArrayOfInlineClassValues() {
      runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValues.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("iterateOverArrayOfInlineClassValuesGeneric.kt")
    public void testIterateOverArrayOfInlineClassValuesGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValuesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("iterateOverListOfInlineClassValues.kt")
    public void testIterateOverListOfInlineClassValues() {
      runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValues.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("iterateOverListOfInlineClassValuesGeneric.kt")
    public void testIterateOverListOfInlineClassValuesGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValuesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("javaClassIntrinsicOnInlineClasses.kt")
    public void testJavaClassIntrinsicOnInlineClasses() {
      runTest("compiler/testData/codegen/box/inlineClasses/javaClassIntrinsicOnInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("javaClassIntrinsicOnInlineClassesGeneric.kt")
    public void testJavaClassIntrinsicOnInlineClassesGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/javaClassIntrinsicOnInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("javaPrimitiveTypeIC.kt")
    public void testJavaPrimitiveTypeIC() {
      runTest("compiler/testData/codegen/box/inlineClasses/javaPrimitiveTypeIC.kt");
    }

    @Test
    @TestMetadata("javaPrimitiveTypeICGeneric.kt")
    public void testJavaPrimitiveTypeICGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/javaPrimitiveTypeICGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("jvmFieldInInlineClassCompanion.kt")
    public void testJvmFieldInInlineClassCompanion() {
      runTest("compiler/testData/codegen/box/inlineClasses/jvmFieldInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("jvmFieldInInlineClassCompanionGeneric.kt")
    public void testJvmFieldInInlineClassCompanionGeneric() {
      runTest("compiler/testData/codegen/box/inlineClasses/jvmFieldInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("jvmInline.kt")
    public void testJvmInline() {
      runTest("compiler/testData/codegen/box/inlineClasses/jvmInline.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
    }

    @Test
    @TestMetadata("jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
    public v