/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.mutes;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.mutes.AutoMuteKt;
import org.jetbrains.kotlin.test.mutes.MutedSetKt;
import org.jetbrains.kotlin.test.mutes.MutedTest;
import org.jetbrains.kotlin.test.mutes.MutedTestKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0002\u001a\u00020\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\b\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u001a\u0010\u000b\u001a\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\r\u001a\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u001c\u0010\u0013\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\r\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"SKIP_MUTED_TESTS", "", "isMutedInDatabase", "testClass", "Ljava/lang/Class;", "methodKey", "", "isMutedInDatabaseWithLog", "isPresentedInDatabaseWithoutFailMarker", "mutedTest", "Lorg/jetbrains/kotlin/test/mutes/MutedTest;", "mutedMessage", "klass", "testKey", "wrapWithMuteInDatabase", "Lkotlin/Function0;", "", "methodName", "f", "invertMutedTestResultWithLog", "tests-mutes"})
public final class MuteWithDatabaseWrapperKt {
    private static final boolean SKIP_MUTED_TESTS = Boolean.getBoolean("org.jetbrains.kotlin.skip.muted.tests");

    public static final boolean isMutedInDatabase(@NotNull Class<?> testClass, @NotNull String methodKey) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)methodKey, (String)"methodKey");
        MutedTest mutedTest = MutedSetKt.getMutedSet().mutedTest(testClass, methodKey);
        return SKIP_MUTED_TESTS && MuteWithDatabaseWrapperKt.isPresentedInDatabaseWithoutFailMarker(mutedTest);
    }

    public static final boolean isMutedInDatabaseWithLog(@NotNull Class<?> testClass, @NotNull String methodKey) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)methodKey, (String)"methodKey");
        boolean mutedInDatabase = MuteWithDatabaseWrapperKt.isMutedInDatabase(testClass, methodKey);
        if (mutedInDatabase) {
            System.err.println(MuteWithDatabaseWrapperKt.mutedMessage(testClass, methodKey));
        }
        return mutedInDatabase;
    }

    public static final boolean isPresentedInDatabaseWithoutFailMarker(@Nullable MutedTest mutedTest) {
        return mutedTest != null && !mutedTest.getHasFailFile();
    }

    @NotNull
    public static final String mutedMessage(@NotNull Class<?> klass, @NotNull String methodKey) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)methodKey, (String)"methodKey");
        return "MUTED TEST: " + MuteWithDatabaseWrapperKt.testKey(klass, methodKey);
    }

    @NotNull
    public static final String testKey(@NotNull Class<?> klass, @NotNull String methodKey) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)methodKey, (String)"methodKey");
        return klass.getCanonicalName() + '.' + methodKey;
    }

    @NotNull
    public static final Function0<Unit> wrapWithMuteInDatabase(@NotNull Class<?> testClass, @NotNull String methodName, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        MutedTest mutedTest = MutedTestKt.getMutedTest(testClass, methodName);
        String testKey = MuteWithDatabaseWrapperKt.testKey(testClass, methodName);
        if (MuteWithDatabaseWrapperKt.isMutedInDatabase(testClass, methodName)) {
            return () -> MuteWithDatabaseWrapperKt.wrapWithMuteInDatabase$lambda$0(testClass, methodName);
        }
        if (MuteWithDatabaseWrapperKt.isPresentedInDatabaseWithoutFailMarker(mutedTest)) {
            MutedTest mutedTest2 = mutedTest;
            boolean bl = mutedTest2 != null ? mutedTest2.isFlaky() : false;
            if (bl) {
                return AutoMuteKt.wrapWithAutoMute(f, testKey);
            }
            return () -> MuteWithDatabaseWrapperKt.wrapWithMuteInDatabase$lambda$1(f, testKey);
        }
        return f;
    }

    public static final void invertMutedTestResultWithLog(@NotNull Function0<Unit> f, @NotNull String testKey) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)testKey, (String)"testKey");
        boolean isTestGreen = true;
        try {
            f.invoke();
        }
        catch (Throwable throwable) {
            System.out.println((Object)("MUTED TEST STILL FAILS: " + testKey));
            isTestGreen = false;
        }
        if (isTestGreen) {
            System.err.println("SUCCESS RESULT OF MUTED TEST: " + testKey);
            throw new Exception("Muted non-flaky test " + testKey + " finished successfully. Please remove it from csv file");
        }
    }

    private static final Unit wrapWithMuteInDatabase$lambda$0(Class $testClass, String $methodName) {
        System.err.println(MuteWithDatabaseWrapperKt.mutedMessage($testClass, $methodName));
        return Unit.INSTANCE;
    }

    private static final Unit wrapWithMuteInDatabase$lambda$1(Function0 $f, String $testKey) {
        MuteWithDatabaseWrapperKt.invertMutedTestResultWithLog((Function0<Unit>)$f, $testKey);
        return Unit.INSTANCE;
    }
}

