/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.test.generators.GenerateCompilerTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/diagnostics/testsWithConverter")
@TestDataPath("$PROJECT_ROOT")
public class ClassicDiagnosticsTestWithConverterGenerated extends AbstractClassicDiagnosticsTestWithConverter {
  @Test
  public void testAllFilesPresentInTestsWithConverter() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithConverter"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true);
  }

  @Nested
  @TestMetadata("compiler/testData/diagnostics/testsWithConverter/scripts")
  @TestDataPath("$PROJECT_ROOT")
  public class Scripts {
    @Test
    public void testAllFilesPresentInScripts() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithConverter/scripts"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("enumCapturesProperty.kts")
    public void testEnumCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/enumCapturesProperty.kts");
    }

    @Test
    @TestMetadata("enumEntryCapturesProperty.kts")
    public void testEnumEntryCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/enumEntryCapturesProperty.kts");
    }

    @Test
    @TestMetadata("interfaceCapturesProperty.kts")
    public void testInterfaceCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/interfaceCapturesProperty.kts");
    }

    @Test
    @TestMetadata("nestedAndOuterClassesCaptureProperty.kts")
    public void testNestedAndOuterClassesCaptureProperty() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/nestedAndOuterClassesCaptureProperty.kts");
    }

    @Test
    @TestMetadata("nestedClassCapturesProperty.kts")
    public void testNestedClassCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/nestedClassCapturesProperty.kts");
    }

    @Test
    @TestMetadata("nestedToObjectClassCapturesProperty.kts")
    public void testNestedToObjectClassCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/nestedToObjectClassCapturesProperty.kts");
    }

    @Test
    @TestMetadata("objectCapturesProperty.kts")
    public void testObjectCapturesProperty() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/objectCapturesProperty.kts");
    }

    @Test
    @TestMetadata("objectCapturesPropertyIndirect.kts")
    public void testObjectCapturesPropertyIndirect() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/objectCapturesPropertyIndirect.kts");
    }

    @Test
    @TestMetadata("objectCapturesPropertyViaExtension1.kts")
    public void testObjectCapturesPropertyViaExtension1() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/objectCapturesPropertyViaExtension1.kts");
    }

    @Test
    @TestMetadata("objectCapturesPropertyViaExtension2.kts")
    public void testObjectCapturesPropertyViaExtension2() {
      runTest("compiler/testData/diagnostics/testsWithConverter/scripts/objectCapturesPropertyViaExtension2.kts");
    }
  }
}
