/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.test.generators.GenerateCompilerTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/debug/stepping")
@TestDataPath("$PROJECT_ROOT")
public class IrSteppingWithIrInlinerTestGenerated extends AbstractIrSteppingWithIrInlinerTest {
  @Test
  public void testAllFilesPresentInStepping() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/debug/stepping"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
  }

  @Test
  @TestMetadata("anonymousFunction.kt")
  public void testAnonymousFunction() {
    runTest("compiler/testData/debug/stepping/anonymousFunction.kt");
  }

  @Test
  @TestMetadata("anonymousFunctionDirect.kt")
  public void testAnonymousFunctionDirect() {
    runTest("compiler/testData/debug/stepping/anonymousFunctionDirect.kt");
  }

  @Test
  @TestMetadata("assertion.kt")
  public void testAssertion() {
    runTest("compiler/testData/debug/stepping/assertion.kt");
  }

  @Test
  @TestMetadata("beforeGotoToWhileStart.kt")
  public void testBeforeGotoToWhileStart() {
    runTest("compiler/testData/debug/stepping/beforeGotoToWhileStart.kt");
  }

  @Test
  @TestMetadata("callWithCallInArguments.kt")
  public void testCallWithCallInArguments() {
    runTest("compiler/testData/debug/stepping/callWithCallInArguments.kt");
  }

  @Test
  @TestMetadata("callWithReceiver.kt")
  public void testCallWithReceiver() {
    runTest("compiler/testData/debug/stepping/callWithReceiver.kt");
  }

  @Test
  @TestMetadata("callableReference.kt")
  public void testCallableReference() {
    runTest("compiler/testData/debug/stepping/callableReference.kt");
  }

  @Test
  @TestMetadata("chainCall.kt")
  public void testChainCall() {
    runTest("compiler/testData/debug/stepping/chainCall.kt");
  }

  @Test
  @TestMetadata("class.kt")
  public void testClass() {
    runTest("compiler/testData/debug/stepping/class.kt");
  }

  @Test
  @TestMetadata("classObject.kt")
  public void testClassObject() {
    runTest("compiler/testData/debug/stepping/classObject.kt");
  }

  @Test
  @TestMetadata("closingBracketOfCrossinlineInsideCrossinline.kt")
  public void testClosingBracketOfCrossinlineInsideCrossinline() {
    runTest("compiler/testData/debug/stepping/closingBracketOfCrossinlineInsideCrossinline.kt");
  }

  @Test
  @TestMetadata("closingBracketOfLambdaOfInlineOnlyFunction.kt")
  public void testClosingBracketOfLambdaOfInlineOnlyFunction() {
    runTest("compiler/testData/debug/stepping/closingBracketOfLambdaOfInlineOnlyFunction.kt");
  }

  @Test
  @TestMetadata("closingBracketOfObjectInsideCrossinline.kt")
  public void testClosingBracketOfObjectInsideCrossinline() {
    runTest("compiler/testData/debug/stepping/closingBracketOfObjectInsideCrossinline.kt");
  }

  @Test
  @TestMetadata("commentBeforeClass.kt")
  public void testCommentBeforeClass() {
    runTest("compiler/testData/debug/stepping/commentBeforeClass.kt");
  }

  @Test
  @TestMetadata("commentBeforeCompanionProperty.kt")
  public void testCommentBeforeCompanionProperty() {
    runTest("compiler/testData/debug/stepping/commentBeforeCompanionProperty.kt");
  }

  @Test
  @TestMetadata("commentBeforeFunctionWithDefault.kt")
  public void testCommentBeforeFunctionWithDefault() {
    runTest("compiler/testData/debug/stepping/commentBeforeFunctionWithDefault.kt");
  }

  @Test
  @TestMetadata("comments.kt")
  public void testComments() {
    runTest("compiler/testData/debug/stepping/comments.kt");
  }

  @Test
  @TestMetadata("compileTimeConstant.kt")
  public void testCompileTimeConstant() {
    runTest("compiler/testData/debug/stepping/compileTimeConstant.kt");
  }

  @Test
  @TestMetadata("conjunction.kt")
  public void testConjunction() {
    runTest("compiler/testData/debug/stepping/conjunction.kt");
  }

  @Test
  @TestMetadata("constantConditions.kt")
  public void testConstantConditions() {
    runTest("compiler/testData/debug/stepping/constantConditions.kt");
  }

  @Test
  @TestMetadata("constructorCall.kt")
  public void testConstructorCall() {
    runTest("compiler/testData/debug/stepping/constructorCall.kt");
  }

  @Test
  @TestMetadata("constructors.kt")
  public void testConstructors() {
    runTest("compiler/testData/debug/stepping/constructors.kt");
  }

  @Test
  @TestMetadata("continue.kt")
  public void testContinue() {
    runTest("compiler/testData/debug/stepping/continue.kt");
  }

  @Test
  @TestMetadata("dataClass.kt")
  public void testDataClass() {
    runTest("compiler/testData/debug/stepping/dataClass.kt");
  }

  @Test
  @TestMetadata("defaultParameter.kt")
  public void testDefaultParameter() {
    runTest("compiler/testData/debug/stepping/defaultParameter.kt");
  }

  @Test
  @TestMetadata("delegation.kt")
  public void testDelegation() {
    runTest("compiler/testData/debug/stepping/delegation.kt");
  }

  @Test
  @TestMetadata("enum.kt")
  public void testEnum() {
    runTest("compiler/testData/debug/stepping/enum.kt");
  }

  @Test
  @TestMetadata("for.kt")
  public void testFor() {
    runTest("compiler/testData/debug/stepping/for.kt");
  }

  @Test
  @TestMetadata("functionCallWithDefault.kt")
  public void testFunctionCallWithDefault() {
    runTest("compiler/testData/debug/stepping/functionCallWithDefault.kt");
  }

  @Test
  @TestMetadata("functionCallWithInlinedLambdaParam.kt")
  public void testFunctionCallWithInlinedLambdaParam() {
    runTest("compiler/testData/debug/stepping/functionCallWithInlinedLambdaParam.kt");
  }

  @Test
  @TestMetadata("functionCallWithLambdaParam.kt")
  public void testFunctionCallWithLambdaParam() {
    runTest("compiler/testData/debug/stepping/functionCallWithLambdaParam.kt");
  }

  @Test
  @TestMetadata("functionInAnotherFile.kt")
  public void testFunctionInAnotherFile() {
    runTest("compiler/testData/debug/stepping/functionInAnotherFile.kt");
  }

  @Test
  @TestMetadata("if.kt")
  public void testIf() {
    runTest("compiler/testData/debug/stepping/if.kt");
  }

  @Test
  @TestMetadata("if2.kt")
  public void testIf2() {
    runTest("compiler/testData/debug/stepping/if2.kt");
  }

  @Test
  @TestMetadata("ifThen.kt")
  public void testIfThen() {
    runTest("compiler/testData/debug/stepping/ifThen.kt");
  }

  @Test
  @TestMetadata("ifThenElse.kt")
  public void testIfThenElse() {
    runTest("compiler/testData/debug/stepping/ifThenElse.kt");
  }

  @Test
  @TestMetadata("ifThenElseFalse.kt")
  public void testIfThenElseFalse() {
    runTest("compiler/testData/debug/stepping/ifThenElseFalse.kt");
  }

  @Test
  @TestMetadata("IfTrueThenFalse.kt")
  public void testIfTrueThenFalse() {
    runTest("compiler/testData/debug/stepping/IfTrueThenFalse.kt");
  }

  @Test
  @TestMetadata("ifWithInlineInCondition.kt")
  public void testIfWithInlineInCondition() {
    runTest("compiler/testData/debug/stepping/ifWithInlineInCondition.kt");
  }

  @Test
  @TestMetadata("iincStepping.kt")
  public void testIincStepping() {
    runTest("compiler/testData/debug/stepping/iincStepping.kt");
  }

  @Test
  @TestMetadata("implicitThis.kt")
  public void testImplicitThis() {
    runTest("compiler/testData/debug/stepping/implicitThis.kt");
  }

  @Test
  @TestMetadata("implicitThisOnInvoke.kt")
  public void testImplicitThisOnInvoke() {
    runTest("compiler/testData/debug/stepping/implicitThisOnInvoke.kt");
  }

  @Test
  @TestMetadata("inTheEndOfLambdaArgumentOfInlineCall.kt")
  public void testInTheEndOfLambdaArgumentOfInlineCall() {
    runTest("compiler/testData/debug/stepping/inTheEndOfLambdaArgumentOfInlineCall.kt");
  }

  @Test
  @TestMetadata("initBlocks.kt")
  public void testInitBlocks() {
    runTest("compiler/testData/debug/stepping/initBlocks.kt");
  }

  @Test
  @TestMetadata("initBlocksCompanion.kt")
  public void testInitBlocksCompanion() {
    runTest("compiler/testData/debug/stepping/initBlocksCompanion.kt");
  }

  @Test
  @TestMetadata("inlineCallableReference.kt")
  public void testInlineCallableReference() {
    runTest("compiler/testData/debug/stepping/inlineCallableReference.kt");
  }

  @Test
  @TestMetadata("inlineNamedCallableReference.kt")
  public void testInlineNamedCallableReference() {
    runTest("compiler/testData/debug/stepping/inlineNamedCallableReference.kt");
  }

  @Test
  @TestMetadata("inlineOnlyFunction.kt")
  public void testInlineOnlyFunction() {
    runTest("compiler/testData/debug/stepping/inlineOnlyFunction.kt");
  }

  @Test
  @TestMetadata("inlineSimpleCall.kt")
  public void testInlineSimpleCall() {
    runTest("compiler/testData/debug/stepping/inlineSimpleCall.kt");
  }

  @Test
  @TestMetadata("javaSam.kt")
  public void testJavaSam() {
    runTest("compiler/testData/debug/stepping/javaSam.kt");
  }

  @Test
  @TestMetadata("kt15259.kt")
  public void testKt15259() {
    runTest("compiler/testData/debug/stepping/kt15259.kt");
  }

  @Test
  @TestMetadata("kt29179.kt")
  public void testKt29179() {
    runTest("compiler/testData/debug/stepping/kt29179.kt");
  }

  @Test
  @TestMetadata("kt42208.kt")
  public void testKt42208() {
    runTest("compiler/testData/debug/stepping/kt42208.kt");
  }

  @Test
  @TestMetadata("kt42208b.kt")
  public void testKt42208b() {
    runTest("compiler/testData/debug/stepping/kt42208b.kt");
  }

  @Test
  @TestMetadata("kt42208c.kt")
  public void testKt42208c() {
    runTest("compiler/testData/debug/stepping/kt42208c.kt");
  }

  @Test
  @TestMetadata("lambdaStepInline.kt")
  public void testLambdaStepInline() {
    runTest("compiler/testData/debug/stepping/lambdaStepInline.kt");
  }

  @Test
  @TestMetadata("lambdaStepInlineWithDefaults.kt")
  public void testLambdaStepInlineWithDefaults() {
    runTest("compiler/testData/debug/stepping/lambdaStepInlineWithDefaults.kt");
  }

  @Test
  @TestMetadata("lineNumberAfterInline.kt")
  public void testLineNumberAfterInline() {
    runTest("compiler/testData/debug/stepping/lineNumberAfterInline.kt");
  }

  @Test
  @TestMetadata("linenumberForOneParametersArgumentCall.kt")
  public void testLinenumberForOneParametersArgumentCall() {
    runTest("compiler/testData/debug/stepping/linenumberForOneParametersArgumentCall.kt");
  }

  @Test
  @TestMetadata("localFunction.kt")
  public void testLocalFunction() {
    runTest("compiler/testData/debug/stepping/localFunction.kt");
  }

  @Test
  @TestMetadata("localFunctionWIthOnelineExpressionBody.kt")
  public void testLocalFunctionWIthOnelineExpressionBody() {
    runTest("compiler/testData/debug/stepping/localFunctionWIthOnelineExpressionBody.kt");
  }

  @Test
  @TestMetadata("localProperty.kt")
  public void testLocalProperty() {
    runTest("compiler/testData/debug/stepping/localProperty.kt");
  }

  @Test
  @TestMetadata("multiModule.kt")
  public void testMultiModule() {
    runTest("compiler/testData/debug/stepping/multiModule.kt");
  }

  @Test
  @TestMetadata("multilineExpression.kt")
  public void testMultilineExpression() {
    runTest("compiler/testData/debug/stepping/multilineExpression.kt");
  }

  @Test
  @TestMetadata("multilineFunctionCall.kt")
  public void testMultilineFunctionCall() {
    runTest("compiler/testData/debug/stepping/multilineFunctionCall.kt");
  }

  @Test
  @TestMetadata("multilineInfixCall.kt")
  public void testMultilineInfixCall() {
    runTest("compiler/testData/debug/stepping/multilineInfixCall.kt");
  }

  @Test
  @TestMetadata("namedCallableReference.kt")
  public void testNamedCallableReference() {
    runTest("compiler/testData/debug/stepping/namedCallableReference.kt");
  }

  @Test
  @TestMetadata("nestedInline.kt")
  public void testNestedInline() {
    runTest("compiler/testData/debug/stepping/nestedInline.kt");
  }

  @Test
  @TestMetadata("noLinenumberInInvokeOfSuspendLambda.kt")
  public void testNoLinenumberInInvokeOfSuspendLambda() {
    runTest("compiler/testData/debug/stepping/noLinenumberInInvokeOfSuspendLambda.kt");
  }

  @Test
  @TestMetadata("noParametersArgumentCallInExpression.kt")
  public void testNoParametersArgumentCallInExpression() {
    runTest("compiler/testData/debug/stepping/noParametersArgumentCallInExpression.kt");
  }

  @Test
  @TestMetadata("nullcheck.kt")
  public void testNullcheck() {
    runTest("compiler/testData/debug/stepping/nullcheck.kt");
  }

  @Test
  @TestMetadata("overridenGetterSetter.kt")
  public void testOverridenGetterSetter() {
    runTest("compiler/testData/debug/stepping/overridenGetterSetter.kt");
  }

  @Test
  @TestMetadata("primitiveNullChecks.kt")
  public void testPrimitiveNullChecks() {
    runTest("compiler/testData/debug/stepping/primitiveNullChecks.kt");
  }

  @Test
  @TestMetadata("propertyAccessor.kt")
  public void testPropertyAccessor() {
    runTest("compiler/testData/debug/stepping/propertyAccessor.kt");
  }

  @Test
  @TestMetadata("propertyInvokeInsidePCLALambda.kt")
  public void testPropertyInvokeInsidePCLALambda() {
    runTest("compiler/testData/debug/stepping/propertyInvokeInsidePCLALambda.kt");
  }

  @Test
  @TestMetadata("psvm.kt")
  public void testPsvm() {
    runTest("compiler/testData/debug/stepping/psvm.kt");
  }

  @Test
  @TestMetadata("recursion.kt")
  public void testRecursion() {
    runTest("compiler/testData/debug/stepping/recursion.kt");
  }

  @Test
  @TestMetadata("simpleDefaultArg.kt")
  public void testSimpleDefaultArg() {
    runTest("compiler/testData/debug/stepping/simpleDefaultArg.kt");
  }

  @Test
  @TestMetadata("simpleDefaultArgWithInline.kt")
  public void testSimpleDefaultArgWithInline() {
    runTest("compiler/testData/debug/stepping/simpleDefaultArgWithInline.kt");
  }

  @Test
  @TestMetadata("simpleInlineDefaultArg.kt")
  public void testSimpleInlineDefaultArg() {
    runTest("compiler/testData/debug/stepping/simpleInlineDefaultArg.kt");
  }

  @Test
  @TestMetadata("simpleSmap.kt")
  public void testSimpleSmap() {
    runTest("compiler/testData/debug/stepping/simpleSmap.kt");
  }

  @Test
  @TestMetadata("smapInlineAsArgument.kt")
  public void testSmapInlineAsArgument() {
    runTest("compiler/testData/debug/stepping/smapInlineAsArgument.kt");
  }

  @Test
  @TestMetadata("smapInlineAsInfixArgument.kt")
  public void testSmapInlineAsInfixArgument() {
    runTest("compiler/testData/debug/stepping/smapInlineAsInfixArgument.kt");
  }

  @Test
  @TestMetadata("smapInlineAsInlineArgument.kt")
  public void testSmapInlineAsInlineArgument() {
    runTest("compiler/testData/debug/stepping/smapInlineAsInlineArgument.kt");
  }

  @Test
  @TestMetadata("smapInlineInIntrinsicArgument.kt")
  public void testSmapInlineInIntrinsicArgument() {
    runTest("compiler/testData/debug/stepping/smapInlineInIntrinsicArgument.kt");
  }

  @Test
  @TestMetadata("stringSwitches.kt")
  public void testStringSwitches() {
    runTest("compiler/testData/debug/stepping/stringSwitches.kt");
  }

  @Test
  @TestMetadata("stringSwitchesSmall.kt")
  public void testStringSwitchesSmall() {
    runTest("compiler/testData/debug/stepping/stringSwitchesSmall.kt");
  }

  @Test
  @TestMetadata("suspendFunWithLambdaParameter.kt")
  public void testSuspendFunWithLambdaParameter() {
    runTest("compiler/testData/debug/stepping/suspendFunWithLambdaParameter.kt");
  }

  @Test
  @TestMetadata("suspendFunWithSuspendLambdaParameter.kt")
  public void testSuspendFunWithSuspendLambdaParameter() {
    runTest("compiler/testData/debug/stepping/suspendFunWithSuspendLambdaParameter.kt");
  }

  @Test
  @TestMetadata("throwException.kt")
  public void testThrowException() {
    runTest("compiler/testData/debug/stepping/throwException.kt");
  }

  @Test
  @TestMetadata("topLevel.kt")
  public void testTopLevel() {
    runTest("compiler/testData/debug/stepping/topLevel.kt");
  }

  @Test
  @TestMetadata("trait.kt")
  public void testTrait() {
    runTest("compiler/testData/debug/stepping/trait.kt");
  }

  @Test
  @TestMetadata("tryCatch.kt")
  public void testTryCatch() {
    runTest("compiler/testData/debug/stepping/tryCatch.kt");
  }

  @Test
  @TestMetadata("tryCatchExpression.kt")
  public void testTryCatchExpression() {
    runTest("compiler/testData/debug/stepping/tryCatchExpression.kt");
  }

  @Test
  @TestMetadata("tryCatchFinally.kt")
  public void testTryCatchFinally() {
    runTest("compiler/testData/debug/stepping/tryCatchFinally.kt");
  }

  @Test
  @TestMetadata("tryFinally.kt")
  public void testTryFinally() {
    runTest("compiler/testData/debug/stepping/tryFinally.kt");
  }

  @Test
  @TestMetadata("variablesWithoutInitializer.kt")
  public void testVariablesWithoutInitializer() {
    runTest("compiler/testData/debug/stepping/variablesWithoutInitializer.kt");
  }

  @Test
  @TestMetadata("voidLambdaStepInline.kt")
  public void testVoidLambdaStepInline() {
    runTest("compiler/testData/debug/stepping/voidLambdaStepInline.kt");
  }

  @Test
  @TestMetadata("when.kt")
  public void testWhen() {
    runTest("compiler/testData/debug/stepping/when.kt");
  }

  @Test
  @TestMetadata("whenComplicatedSubject.kt")
  public void testWhenComplicatedSubject() {
    runTest("compiler/testData/debug/stepping/whenComplicatedSubject.kt");
  }

  @Test
  @TestMetadata("whenConstant.kt")
  public void testWhenConstant() {
    runTest("compiler/testData/debug/stepping/whenConstant.kt");
  }

  @Test
  @TestMetadata("whenExpr.kt")
  public void testWhenExpr() {
    runTest("compiler/testData/debug/stepping/whenExpr.kt");
  }

  @Test
  @TestMetadata("whenInConjunction.kt")
  public void testWhenInConjunction() {
    runTest("compiler/testData/debug/stepping/whenInConjunction.kt");
  }

  @Test
  @TestMetadata("whenInDisjunction.kt")
  public void testWhenInDisjunction() {
    runTest("compiler/testData/debug/stepping/whenInDisjunction.kt");
  }

  @Test
  @TestMetadata("whenInGeneralObjectComparison.kt")
  public void testWhenInGeneralObjectComparison() {
    runTest("compiler/testData/debug/stepping/whenInGeneralObjectComparison.kt");
  }

  @Test
  @TestMetadata("whenInNegation.kt")
  public void testWhenInNegation() {
    runTest("compiler/testData/debug/stepping/whenInNegation.kt");
  }

  @Test
  @TestMetadata("whenInNullComparison.kt")
  public void testWhenInNullComparison() {
    runTest("compiler/testData/debug/stepping/whenInNullComparison.kt");
  }

  @Test
  @TestMetadata("whenInPrimitiveToObjectComparison.kt")
  public void testWhenInPrimitiveToObjectComparison() {
    runTest("compiler/testData/debug/stepping/whenInPrimitiveToObjectComparison.kt");
  }

  @Test
  @TestMetadata("whenInZeroComparison.kt")
  public void testWhenInZeroComparison() {
    runTest("compiler/testData/debug/stepping/whenInZeroComparison.kt");
  }

  @Test
  @TestMetadata("whenIsChecks.kt")
  public void testWhenIsChecks() {
    runTest("compiler/testData/debug/stepping/whenIsChecks.kt");
  }

  @Test
  @TestMetadata("whenMultiLine.kt")
  public void testWhenMultiLine() {
    runTest("compiler/testData/debug/stepping/whenMultiLine.kt");
  }

  @Test
  @TestMetadata("whenMultiLineSubject.kt")
  public void testWhenMultiLineSubject() {
    runTest("compiler/testData/debug/stepping/whenMultiLineSubject.kt");
  }

  @Test
  @TestMetadata("whenNullalbeSubject.kt")
  public void testWhenNullalbeSubject() {
    runTest("compiler/testData/debug/stepping/whenNullalbeSubject.kt");
  }

  @Test
  @TestMetadata("whenSubject.kt")
  public void testWhenSubject() {
    runTest("compiler/testData/debug/stepping/whenSubject.kt");
  }

  @Test
  @TestMetadata("whenSubject2.kt")
  public void testWhenSubject2() {
    runTest("compiler/testData/debug/stepping/whenSubject2.kt");
  }

  @Test
  @TestMetadata("whenWithInlineInCondition.kt")
  public void testWhenWithInlineInCondition() {
    runTest("compiler/testData/debug/stepping/whenWithInlineInCondition.kt");
  }

  @Test
  @TestMetadata("while.kt")
  public void testWhile() {
    runTest("compiler/testData/debug/stepping/while.kt");
  }
}
