/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.ir.interpreter;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.test.generators.GenerateCompilerTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/ir/interpreter")
@TestDataPath("$PROJECT_ROOT")
public class JvmIrInterpreterAfterFirPsi2IrTestGenerated extends AbstractJvmIrInterpreterAfterFirPsi2IrTest {
  @Test
  @TestMetadata("abstract1.kt")
  public void testAbstract1() {
    runTest("compiler/testData/ir/interpreter/abstract1.kt");
  }

  @Test
  @TestMetadata("abstract2.kt")
  public void testAbstract2() {
    runTest("compiler/testData/ir/interpreter/abstract2.kt");
  }

  @Test
  @TestMetadata("abstract3.kt")
  public void testAbstract3() {
    runTest("compiler/testData/ir/interpreter/abstract3.kt");
  }

  @Test
  @TestMetadata("abstract4.kt")
  public void testAbstract4() {
    runTest("compiler/testData/ir/interpreter/abstract4.kt");
  }

  @Test
  public void testAllFilesPresentInInterpreter() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/interpreter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, "helpers");
  }

  @Test
  @TestMetadata("arrayClassCast.kt")
  public void testArrayClassCast() {
    runTest("compiler/testData/ir/interpreter/arrayClassCast.kt");
  }

  @Test
  @TestMetadata("branches.kt")
  public void testBranches() {
    runTest("compiler/testData/ir/interpreter/branches.kt");
  }

  @Test
  @TestMetadata("companionOverride.kt")
  public void testCompanionOverride() {
    runTest("compiler/testData/ir/interpreter/companionOverride.kt");
  }

  @Test
  @TestMetadata("complexReturn.kt")
  public void testComplexReturn() {
    runTest("compiler/testData/ir/interpreter/complexReturn.kt");
  }

  @Test
  @TestMetadata("composition.kt")
  public void testComposition() {
    runTest("compiler/testData/ir/interpreter/composition.kt");
  }

  @Test
  @TestMetadata("copyReceivedValue.kt")
  public void testCopyReceivedValue() {
    runTest("compiler/testData/ir/interpreter/copyReceivedValue.kt");
  }

  @Test
  @TestMetadata("dataClass.kt")
  public void testDataClass() {
    runTest("compiler/testData/ir/interpreter/dataClass.kt");
  }

  @Test
  @TestMetadata("defaultArgs.kt")
  public void testDefaultArgs() {
    runTest("compiler/testData/ir/interpreter/defaultArgs.kt");
  }

  @Test
  @TestMetadata("defaultEquals.kt")
  public void testDefaultEquals() {
    runTest("compiler/testData/ir/interpreter/defaultEquals.kt");
  }

  @Test
  @TestMetadata("defaultHashCode.kt")
  public void testDefaultHashCode() {
    runTest("compiler/testData/ir/interpreter/defaultHashCode.kt");
  }

  @Test
  @TestMetadata("defaultToString.kt")
  public void testDefaultToString() {
    runTest("compiler/testData/ir/interpreter/defaultToString.kt");
  }

  @Test
  @TestMetadata("doWhileLoop.kt")
  public void testDoWhileLoop() {
    runTest("compiler/testData/ir/interpreter/doWhileLoop.kt");
  }

  @Test
  @TestMetadata("elvis.kt")
  public void testElvis() {
    runTest("compiler/testData/ir/interpreter/elvis.kt");
  }

  @Test
  @TestMetadata("enums1.kt")
  public void testEnums1() {
    runTest("compiler/testData/ir/interpreter/enums1.kt");
  }

  @Test
  @TestMetadata("enums2.kt")
  public void testEnums2() {
    runTest("compiler/testData/ir/interpreter/enums2.kt");
  }

  @Test
  @TestMetadata("enums3.kt")
  public void testEnums3() {
    runTest("compiler/testData/ir/interpreter/enums3.kt");
  }

  @Test
  @TestMetadata("extensionReceiver.kt")
  public void testExtensionReceiver() {
    runTest("compiler/testData/ir/interpreter/extensionReceiver.kt");
  }

  @Test
  @TestMetadata("fib.kt")
  public void testFib() {
    runTest("compiler/testData/ir/interpreter/fib.kt");
  }

  @Test
  @TestMetadata("genericListOfPairs.kt")
  public void testGenericListOfPairs() {
    runTest("compiler/testData/ir/interpreter/genericListOfPairs.kt");
  }

  @Test
  @TestMetadata("inKeyword.kt")
  public void testInKeyword() {
    runTest("compiler/testData/ir/interpreter/inKeyword.kt");
  }

  @Test
  @TestMetadata("inlineReturn.kt")
  public void testInlineReturn() {
    runTest("compiler/testData/ir/interpreter/inlineReturn.kt");
  }

  @Test
  @TestMetadata("innerClass.kt")
  public void testInnerClass() {
    runTest("compiler/testData/ir/interpreter/innerClass.kt");
  }

  @Test
  @TestMetadata("instanceOf.kt")
  public void testInstanceOf() {
    runTest("compiler/testData/ir/interpreter/instanceOf.kt");
  }

  @Test
  @TestMetadata("instanceOfWithTypeParameters.kt")
  public void testInstanceOfWithTypeParameters() {
    runTest("compiler/testData/ir/interpreter/instanceOfWithTypeParameters.kt");
  }

  @Test
  @TestMetadata("interface.kt")
  public void testInterface() {
    runTest("compiler/testData/ir/interpreter/interface.kt");
  }

  @Test
  @TestMetadata("interfaceDefault.kt")
  public void testInterfaceDefault() {
    runTest("compiler/testData/ir/interpreter/interfaceDefault.kt");
  }

  @Test
  @TestMetadata("lambda.kt")
  public void testLambda() {
    runTest("compiler/testData/ir/interpreter/lambda.kt");
  }

  @Test
  @TestMetadata("localFunction.kt")
  public void testLocalFunction() {
    runTest("compiler/testData/ir/interpreter/localFunction.kt");
  }

  @Test
  @TestMetadata("localObject.kt")
  public void testLocalObject() {
    runTest("compiler/testData/ir/interpreter/localObject.kt");
  }

  @Test
  @TestMetadata("logIntrinsic.kt")
  public void testLogIntrinsic() {
    runTest("compiler/testData/ir/interpreter/logIntrinsic.kt");
  }

  @Test
  @TestMetadata("loop.kt")
  public void testLoop() {
    runTest("compiler/testData/ir/interpreter/loop.kt");
  }

  @Test
  @TestMetadata("multipleOverridden.kt")
  public void testMultipleOverridden() {
    runTest("compiler/testData/ir/interpreter/multipleOverridden.kt");
  }

  @Test
  @TestMetadata("object.kt")
  public void testObject() {
    runTest("compiler/testData/ir/interpreter/object.kt");
  }

  @Test
  @TestMetadata("objectOverride.kt")
  public void testObjectOverride() {
    runTest("compiler/testData/ir/interpreter/objectOverride.kt");
  }

  @Test
  @TestMetadata("overrideDifferentName.kt")
  public void testOverrideDifferentName() {
    runTest("compiler/testData/ir/interpreter/overrideDifferentName.kt");
  }

  @Test
  @TestMetadata("overrideExtension.kt")
  public void testOverrideExtension() {
    runTest("compiler/testData/ir/interpreter/overrideExtension.kt");
  }

  @Test
  @TestMetadata("progressionFromClosedRange.kt")
  public void testProgressionFromClosedRange() {
    runTest("compiler/testData/ir/interpreter/progressionFromClosedRange.kt");
  }

  @Test
  @TestMetadata("rangeTo.kt")
  public void testRangeTo() {
    runTest("compiler/testData/ir/interpreter/rangeTo.kt");
  }

  @Test
  @TestMetadata("regex.kt")
  public void testRegex() {
    runTest("compiler/testData/ir/interpreter/regex.kt");
  }

  @Test
  @TestMetadata("safeClassCast.kt")
  public void testSafeClassCast() {
    runTest("compiler/testData/ir/interpreter/safeClassCast.kt");
  }

  @Test
  @TestMetadata("samConversion.kt")
  public void testSamConversion() {
    runTest("compiler/testData/ir/interpreter/samConversion.kt");
  }

  @Test
  @TestMetadata("scopeFunctions.kt")
  public void testScopeFunctions() {
    runTest("compiler/testData/ir/interpreter/scopeFunctions.kt");
  }

  @Test
  @TestMetadata("secondaryConstructor.kt")
  public void testSecondaryConstructor() {
    runTest("compiler/testData/ir/interpreter/secondaryConstructor.kt");
  }

  @Test
  @TestMetadata("spreadOperator.kt")
  public void testSpreadOperator() {
    runTest("compiler/testData/ir/interpreter/spreadOperator.kt");
  }

  @Test
  @TestMetadata("stringBuilder.kt")
  public void testStringBuilder() {
    runTest("compiler/testData/ir/interpreter/stringBuilder.kt");
  }

  @Test
  @TestMetadata("stringConcatenation.kt")
  public void testStringConcatenation() {
    runTest("compiler/testData/ir/interpreter/stringConcatenation.kt");
  }

  @Test
  @TestMetadata("superClass.kt")
  public void testSuperClass() {
    runTest("compiler/testData/ir/interpreter/superClass.kt");
  }

  @Test
  @TestMetadata("unitResult.kt")
  public void testUnitResult() {
    runTest("compiler/testData/ir/interpreter/unitResult.kt");
  }

  @Test
  @TestMetadata("vararg.kt")
  public void testVararg() {
    runTest("compiler/testData/ir/interpreter/vararg.kt");
  }

  @Test
  @TestMetadata("variableShadowing.kt")
  public void testVariableShadowing() {
    runTest("compiler/testData/ir/interpreter/variableShadowing.kt");
  }

  @Test
  @TestMetadata("variables.kt")
  public void testVariables() {
    runTest("compiler/testData/ir/interpreter/variables.kt");
  }

  @Test
  @TestMetadata("withReceivers.kt")
  public void testWithReceivers() {
    runTest("compiler/testData/ir/interpreter/withReceivers.kt");
  }

  @Nested
  @TestMetadata("compiler/testData/ir/interpreter/collections")
  @TestDataPath("$PROJECT_ROOT")
  public class Collections {
    @Test
    public void testAllFilesPresentInCollections() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/interpreter/collections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arrayConstructor.kt")
    public void testArrayConstructor() {
      runTest("compiler/testData/ir/interpreter/collections/arrayConstructor.kt");
    }

    @Test
    @TestMetadata("arrayOf.kt")
    public void testArrayOf() {
      runTest("compiler/testData/ir/interpreter/collections/arrayOf.kt");
    }

    @Test
    @TestMetadata("doubleArrayOf.kt")
    public void testDoubleArrayOf() {
      runTest("compiler/testData/ir/interpreter/collections/doubleArrayOf.kt");
    }

    @Test
    @TestMetadata("doubleList.kt")
    public void testDoubleList() {
      runTest("compiler/testData/ir/interpreter/collections/doubleList.kt");
    }

    @Test
    @TestMetadata("listOf.kt")
    public void testListOf() {
      runTest("compiler/testData/ir/interpreter/collections/listOf.kt");
    }

    @Test
    @TestMetadata("mapOf.kt")
    public void testMapOf() {
      runTest("compiler/testData/ir/interpreter/collections/mapOf.kt");
    }

    @Test
    @TestMetadata("matrixArray.kt")
    public void testMatrixArray() {
      runTest("compiler/testData/ir/interpreter/collections/matrixArray.kt");
    }

    @Test
    @TestMetadata("matrixList.kt")
    public void testMatrixList() {
      runTest("compiler/testData/ir/interpreter/collections/matrixList.kt");
    }

    @Test
    @TestMetadata("mutableListOf.kt")
    public void testMutableListOf() {
      runTest("compiler/testData/ir/interpreter/collections/mutableListOf.kt");
    }

    @Test
    @TestMetadata("mutableMapOf.kt")
    public void testMutableMapOf() {
      runTest("compiler/testData/ir/interpreter/collections/mutableMapOf.kt");
    }

    @Test
    @TestMetadata("mutableSetOf.kt")
    public void testMutableSetOf() {
      runTest("compiler/testData/ir/interpreter/collections/mutableSetOf.kt");
    }

    @Test
    @TestMetadata("sequenceOf.kt")
    public void testSequenceOf() {
      runTest("compiler/testData/ir/interpreter/collections/sequenceOf.kt");
    }

    @Test
    @TestMetadata("setOf.kt")
    public void testSetOf() {
      runTest("compiler/testData/ir/interpreter/collections/setOf.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/interpreter/exceptions")
  @TestDataPath("$PROJECT_ROOT")
  public class Exceptions {
    @Test
    public void testAllFilesPresentInExceptions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/interpreter/exceptions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arithmeticExceptionThrow.kt")
    public void testArithmeticExceptionThrow() {
      runTest("compiler/testData/ir/interpreter/exceptions/arithmeticExceptionThrow.kt");
    }

    @Test
    @TestMetadata("arithmeticExceptionTryBlock.kt")
    public void testArithmeticExceptionTryBlock() {
      runTest("compiler/testData/ir/interpreter/exceptions/arithmeticExceptionTryBlock.kt");
    }

    @Test
    @TestMetadata("arithmeticExceptionTryCatchFinally.kt")
    public void testArithmeticExceptionTryCatchFinally() {
      runTest("compiler/testData/ir/interpreter/exceptions/arithmeticExceptionTryCatchFinally.kt");
    }

    @Test
    @TestMetadata("classCastException.kt")
    public void testClassCastException() {
      runTest("compiler/testData/ir/interpreter/exceptions/classCastException.kt");
    }

    @Test
    @TestMetadata("commandsOutException.kt")
    public void testCommandsOutException() {
      runTest("compiler/testData/ir/interpreter/exceptions/commandsOutException.kt");
    }

    @Test
    @TestMetadata("divideByZero.kt")
    public void testDivideByZero() {
      runTest("compiler/testData/ir/interpreter/exceptions/divideByZero.kt");
    }

    @Test
    @TestMetadata("exceptionFromWrapper.kt")
    public void testExceptionFromWrapper() {
      runTest("compiler/testData/ir/interpreter/exceptions/exceptionFromWrapper.kt");
    }

    @Test
    @TestMetadata("exceptionWithCause.kt")
    public void testExceptionWithCause() {
      runTest("compiler/testData/ir/interpreter/exceptions/exceptionWithCause.kt");
    }

    @Test
    @TestMetadata("getCauseMessage.kt")
    public void testGetCauseMessage() {
      runTest("compiler/testData/ir/interpreter/exceptions/getCauseMessage.kt");
    }

    @Test
    @TestMetadata("multifileStackTrace.kt")
    public void testMultifileStackTrace() {
      runTest("compiler/testData/ir/interpreter/exceptions/multifileStackTrace.kt");
    }

    @Test
    @TestMetadata("nullPointerException.kt")
    public void testNullPointerException() {
      runTest("compiler/testData/ir/interpreter/exceptions/nullPointerException.kt");
    }

    @Test
    @TestMetadata("stackOverflow.kt")
    public void testStackOverflow() {
      runTest("compiler/testData/ir/interpreter/exceptions/stackOverflow.kt");
    }

    @Test
    @TestMetadata("stackTrace.kt")
    public void testStackTrace() {
      runTest("compiler/testData/ir/interpreter/exceptions/stackTrace.kt");
    }

    @Test
    @TestMetadata("tryFinally.kt")
    public void testTryFinally() {
      runTest("compiler/testData/ir/interpreter/exceptions/tryFinally.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/interpreter/generatedStdlib")
  @TestDataPath("$PROJECT_ROOT")
  public class GeneratedStdlib {
    @Test
    public void testAllFilesPresentInGeneratedStdlib() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/interpreter/generatedStdlib"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("contains.kt")
    public void testContains() {
      runTest("compiler/testData/ir/interpreter/generatedStdlib/contains.kt");
    }

    @Test
    @TestMetadata("elementAtOrElse.kt")
    public void testElementAtOrElse() {
      runTest("compiler/testData/ir/interpreter/generatedStdlib/elementAtOrElse.kt");
    }

    @Test
    @TestMetadata("first.kt")
    public void testFirst() {
      runTest("compiler/testData/ir/interpreter/generatedStdlib/first.kt");
    }

    @Test
    @TestMetadata("joinToString.kt")
    public void testJoinToString() {
      runTest("compiler/testData/ir/interpreter/generatedStdlib/joinToString.kt");
    }

    @Test
    @TestMetadata("toList.kt")
    public void testToList() {
      runTest("compiler/testData/ir/interpreter/generatedStdlib/toList.kt");
    }

    @Test
    @TestMetadata("trim.kt")
    public void testTrim() {
      runTest("compiler/testData/ir/interpreter/generatedStdlib/trim.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/interpreter/jvm")
  @TestDataPath("$PROJECT_ROOT")
  public class Jvm {
    @Test
    public void testAllFilesPresentInJvm() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/interpreter/jvm"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("classReference.kt")
    public void testClassReference() {
      runTest("compiler/testData/ir/interpreter/jvm/classReference.kt");
    }

    @Test
    @TestMetadata("javaStatic.kt")
    public void testJavaStatic() {
      runTest("compiler/testData/ir/interpreter/jvm/javaStatic.kt");
    }

    @Test
    @TestMetadata("kProperty2.kt")
    public void testKProperty2() {
      runTest("compiler/testData/ir/interpreter/jvm/kProperty2.kt");
    }

    @Test
    @TestMetadata("parameterReference.kt")
    public void testParameterReference() {
      runTest("compiler/testData/ir/interpreter/jvm/parameterReference.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/interpreter/primitives")
  @TestDataPath("$PROJECT_ROOT")
  public class Primitives {
    @Test
    public void testAllFilesPresentInPrimitives() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/interpreter/primitives"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("charMethods.kt")
    public void testCharMethods() {
      runTest("compiler/testData/ir/interpreter/primitives/charMethods.kt");
    }

    @Test
    @TestMetadata("intMethods.kt")
    public void testIntMethods() {
      runTest("compiler/testData/ir/interpreter/primitives/intMethods.kt");
    }

    @Test
    @TestMetadata("longMethods.kt")
    public void testLongMethods() {
      runTest("compiler/testData/ir/interpreter/primitives/longMethods.kt");
    }

    @Test
    @TestMetadata("uInt.kt")
    public void testUInt() {
      runTest("compiler/testData/ir/interpreter/primitives/uInt.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/interpreter/proxy")
  @TestDataPath("$PROJECT_ROOT")
  public class Proxy {
    @Test
    public void testAllFilesPresentInProxy() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/interpreter/proxy"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("customCharSequence.kt")
    public void testCustomCharSequence() {
      runTest("compiler/testData/ir/interpreter/proxy/customCharSequence.kt");
    }

    @Test
    @TestMetadata("customEquals.kt")
    public void testCustomEquals() {
      runTest("compiler/testData/ir/interpreter/proxy/customEquals.kt");
    }

    @Test
    @TestMetadata("proxyPair.kt")
    public void testProxyPair() {
      runTest("compiler/testData/ir/interpreter/proxy/proxyPair.kt");
    }

    @Test
    @TestMetadata("superWrapper.kt")
    public void testSuperWrapper() {
      runTest("compiler/testData/ir/interpreter/proxy/superWrapper.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/interpreter/reference")
  @TestDataPath("$PROJECT_ROOT")
  public class Reference {
    @Test
    public void testAllFilesPresentInReference() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/interpreter/reference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("functionReference.kt")
    public void testFunctionReference() {
      runTest("compiler/testData/ir/interpreter/reference/functionReference.kt");
    }

    @Test
    @TestMetadata("functionReferenceCallViaReflection.kt")
    public void testFunctionReferenceCallViaReflection() {
      runTest("compiler/testData/ir/interpreter/reference/functionReferenceCallViaReflection.kt");
    }

    @Test
    @TestMetadata("getClass.kt")
    public void testGetClass() {
      runTest("compiler/testData/ir/interpreter/reference/getClass.kt");
    }

    @Test
    @TestMetadata("javaPropertyReference.kt")
    public void testJavaPropertyReference() {
      runTest("compiler/testData/ir/interpreter/reference/javaPropertyReference.kt");
    }

    @Test
    @TestMetadata("propertyReference.kt")
    public void testPropertyReference() {
      runTest("compiler/testData/ir/interpreter/reference/propertyReference.kt");
    }

    @Test
    @TestMetadata("propertyReferenceAccessors.kt")
    public void testPropertyReferenceAccessors() {
      runTest("compiler/testData/ir/interpreter/reference/propertyReferenceAccessors.kt");
    }
  }
}
