/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.KlibConfigurationKeys;
import org.jetbrains.kotlin.ir.inline.DumpSyntheticAccessors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.KlibBasedCompilerTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.ArtifactKind;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifactHandler;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.ArtifactsProviderKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u0018*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0018B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SyntheticAccessorsDumpHandler;", "A", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact$Binary;", "Lorg/jetbrains/kotlin/test/model/BinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "artifactKind", "Lorg/jetbrains/kotlin/test/model/ArtifactKind;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/ArtifactKind;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact$Binary;)V", "processAfterAllModules", "someAssertionWasFailed", "", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nSyntheticAccessorsDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticAccessorsDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/SyntheticAccessorsDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1617#2,9:137\n1869#2:146\n1870#2:148\n1626#2:149\n1#3:147\n*S KotlinDebug\n*F\n+ 1 SyntheticAccessorsDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/SyntheticAccessorsDumpHandler\n*L\n42#1:137,9\n42#1:146\n42#1:148\n42#1:149\n42#1:147\n*E\n"})
public abstract class SyntheticAccessorsDumpHandler<A extends ResultingArtifact.Binary<A>>
extends BinaryArtifactHandler<A> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SyntheticAccessorsDumpHandler(@NotNull TestServices testServices, @NotNull ArtifactKind<A> artifactKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        super(testServices, artifactKind, false, false);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)KlibBasedCompilerTestDirectives.INSTANCE);
    }

    @Override
    public final void processModule(@NotNull TestModule module, @NotNull A info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(info, (String)"info");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        void $this$mapNotNullTo$iv$iv;
        List<TestModule> testModules = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules();
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration((TestModule)CollectionsKt.first(testModules));
        File file = DumpSyntheticAccessors.Companion.getDumpDirectoryOrNull(configuration2);
        if (file == null) {
            return;
        }
        File dumpDir = file;
        boolean withNarrowedVisibility = configuration2.getBoolean(KlibConfigurationKeys.SYNTHETIC_ACCESSORS_WITH_NARROWED_VISIBILITY);
        Iterable $this$mapNotNull$iv = testModules;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Name it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TestModule testModule = (TestModule)element$iv$iv;
            boolean bl2 = false;
            IrBackendInput irBackendInput = (IrBackendInput)ArtifactsProviderKt.getArtifactsProvider(this.getTestServices()).getArtifactSafe(testModule, BackendKinds.IrBackend.INSTANCE);
            if ((irBackendInput != null && (irBackendInput = irBackendInput.getIrModuleFragment()) != null ? irBackendInput.getName() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set uniqueIrModuleNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Companion.assertSyntheticAccessorDumpIsCorrect(this.getAssertions(), dumpDir, uniqueIrModuleNames, (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles()), withNarrowedVisibility);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u0010\u001a\u00020\b*\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SyntheticAccessorsDumpHandler$Companion;", "", "<init>", "()V", "assertSyntheticAccessorDumpIsCorrect", "", "Lorg/jetbrains/kotlin/test/Assertions;", "dumpDir", "Ljava/io/File;", "moduleNames", "", "Lorg/jetbrains/kotlin/name/Name;", "testDataFile", "withNarrowedVisibility", "", "dumpFile", "checkDumpFilesAndChooseOne", "normalDumpFile", "narrowedDumpFile", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nSyntheticAccessorsDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticAccessorsDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/SyntheticAccessorsDumpHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1617#2,9:137\n1869#2:146\n1870#2:148\n1626#2:149\n1056#2:150\n1869#2,2:151\n1#3:147\n*S KotlinDebug\n*F\n+ 1 SyntheticAccessorsDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/SyntheticAccessorsDumpHandler$Companion\n*L\n61#1:137,9\n61#1:146\n61#1:148\n61#1:149\n72#1:150\n72#1:151,2\n61#1:147\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void assertSyntheticAccessorDumpIsCorrect(@NotNull Assertions $this$assertSyntheticAccessorDumpIsCorrect, @NotNull File dumpDir, @NotNull Set<Name> moduleNames, @NotNull File testDataFile, boolean withNarrowedVisibility) {
            File file;
            String actualDump;
            String string;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$assertSyntheticAccessorDumpIsCorrect, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)dumpDir, (String)"dumpDir");
            Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            Iterable $this$mapNotNull$iv = moduleNames;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Name moduleName = (Name)element$iv$iv;
                boolean bl2 = false;
                File moduleDumpFile = DumpSyntheticAccessors.Companion.getDumpFileForModule(dumpDir, moduleName);
                if ((!moduleDumpFile.isFile() ? null : TuplesKt.to((Object)moduleName, (Object)((Object)StringsKt.trimEnd((CharSequence)FilesKt.readText$default((File)moduleDumpFile, null, (int)1, null))).toString())) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map irModuleDumps = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            if (irModuleDumps.isEmpty()) {
                string = "/* empty dump */\n";
            } else {
                void $this$forEach$iv;
                StringBuilder $this$assertSyntheticAccessorDumpIsCorrect_u24lambda_u243 = $i$f$mapNotNull = new StringBuilder();
                boolean bl = false;
                Iterable $this$sortedBy$iv = irModuleDumps.entrySet();
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Name)it.getKey());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Name)it.getKey())));
                    }
                });
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl4 = false;
                    String moduleDump = (String)entry.getValue();
                    if (((CharSequence)$this$assertSyntheticAccessorDumpIsCorrect_u24lambda_u243).length() > 0) {
                        $this$assertSyntheticAccessorDumpIsCorrect_u24lambda_u243.append('\n').append('\n');
                    }
                    $this$assertSyntheticAccessorDumpIsCorrect_u24lambda_u243.append(moduleDump).append('\n');
                }
                string = actualDump = $i$f$mapNotNull.toString();
            }
            if (withNarrowedVisibility) {
                File normalDumpFile = this.dumpFile(testDataFile, false);
                File narrowedDumpFile = this.dumpFile(testDataFile, true);
                file = this.checkDumpFilesAndChooseOne($this$assertSyntheticAccessorDumpIsCorrect, testDataFile, normalDumpFile, narrowedDumpFile);
            } else {
                file = this.dumpFile(testDataFile, false);
            }
            File expectedDumpFile = file;
            Assertions.assertEqualsToFile$default($this$assertSyntheticAccessorDumpIsCorrect, expectedDumpFile, actualDump, null, 4, null);
        }

        private final File dumpFile(File testDataFile, boolean withNarrowedVisibility) {
            StringBuilder stringBuilder;
            StringBuilder $this$dumpFile_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$dumpFile_u24lambda_u244.append(FilesKt.getNameWithoutExtension((File)testDataFile));
            $this$dumpFile_u24lambda_u244.append(".accessors");
            if (withNarrowedVisibility) {
                $this$dumpFile_u24lambda_u244.append("-narrowed");
            }
            $this$dumpFile_u24lambda_u244.append(".txt");
            String dumpFileName = stringBuilder.toString();
            return FilesKt.resolveSibling((File)testDataFile, (String)dumpFileName);
        }

        private final File checkDumpFilesAndChooseOne(Assertions $this$checkDumpFilesAndChooseOne, File testDataFile, File normalDumpFile, File narrowedDumpFile) {
            boolean shouldBeIdenticalDumps = InTextDirectivesUtils.isDirectiveDefined(FileUtil.loadFile((File)testDataFile), KlibBasedCompilerTestDirectives.INSTANCE.getIDENTICAL_KLIB_SYNTHETIC_ACCESSOR_DUMPS().getName());
            if (normalDumpFile.exists() && narrowedDumpFile.exists()) {
                boolean identicalDumps = Intrinsics.areEqual((Object)((Object)StringsKt.trimEnd((CharSequence)FilesKt.readText$default((File)normalDumpFile, null, (int)1, null))).toString(), (Object)((Object)StringsKt.trimEnd((CharSequence)FilesKt.readText$default((File)narrowedDumpFile, null, (int)1, null))).toString());
                if (identicalDumps) {
                    if (shouldBeIdenticalDumps) {
                        org.jetbrains.kotlin.test.backend.handlers.SyntheticAccessorsDumpHandler$Companion.checkDumpFilesAndChooseOne$fail($this$checkDumpFilesAndChooseOne, "The synthetic accessor dumps are identical.", "Please remove the .accessors-narrowed.txt file.");
                        throw new KotlinNothingValueException();
                    }
                    org.jetbrains.kotlin.test.backend.handlers.SyntheticAccessorsDumpHandler$Companion.checkDumpFilesAndChooseOne$fail($this$checkDumpFilesAndChooseOne, "The synthetic accessor dumps are identical.", "Please remove the .accessors-narrowed.txt file and add the IDENTICAL_KLIB_SYNTHETIC_ACCESSOR_DUMPS directive to the test data file.");
                    throw new KotlinNothingValueException();
                }
                if (shouldBeIdenticalDumps) {
                    org.jetbrains.kotlin.test.backend.handlers.SyntheticAccessorsDumpHandler$Companion.checkDumpFilesAndChooseOne$fail($this$checkDumpFilesAndChooseOne, "The synthetic accessor dumps differ.", "Please remove the IDENTICAL_KLIB_SYNTHETIC_ACCESSOR_DUMPS directive from the test data file.");
                    throw new KotlinNothingValueException();
                }
            }
            return shouldBeIdenticalDumps ? normalDumpFile : narrowedDumpFile;
        }

        private static final String checkDumpFilesAndChooseOne$fail$lambda$5(String $problem, String $actions) {
            return $problem + '\n' + $actions + '\n';
        }

        private static final Void checkDumpFilesAndChooseOne$fail(Assertions $this_checkDumpFilesAndChooseOne, String problem, String actions) {
            $this_checkDumpFilesAndChooseOne.fail((Function0<String>)((Function0)() -> Companion.checkDumpFilesAndChooseOne$fail$lambda$5(problem, actions)));
            throw new KotlinNothingValueException();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

