/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNodeImpl;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JsVars
extends JsNodeImpl
implements JsStatement,
Iterable<JsVar> {
    private final List<JsVar> vars;
    private final boolean multiline;

    public JsVars() {
        this(new SmartList<JsVar>(), false);
    }

    public JsVars(boolean multiline) {
        this(new SmartList<JsVar>(), multiline);
    }

    public JsVars(List<JsVar> vars, boolean multiline) {
        this.vars = vars;
        this.multiline = multiline;
    }

    public JsVars(JsVar var) {
        this(Collections.singletonList(var), false);
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void add(JsVar var) {
        this.vars.add(var);
    }

    public void addIfHasInitializer(JsVar var) {
        if (var.getInitExpression() != null) {
            this.add(var);
        }
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    @Override
    public Iterator<JsVar> iterator() {
        return this.vars.iterator();
    }

    @Override
    public void traverse(JsVisitor v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptWithInsertRemove(this.vars);
        }
        v.endVisit(this, ctx);
    }

    public static class JsVar
    extends JsNodeImpl
    implements HasName {
        private final JsName name;
        private JsExpression initExpression;

        public JsVar(JsName name) {
            this.name = name;
        }

        public JsVar(JsName name, @Nullable JsExpression initExpression) {
            this.name = name;
            this.initExpression = initExpression;
        }

        public JsExpression getInitExpression() {
            return this.initExpression;
        }

        @Override
        public JsName getName() {
            return this.name;
        }

        public void setInitExpression(JsExpression initExpression) {
            this.initExpression = initExpression;
        }

        @Override
        public void traverse(JsVisitor v, JsContext ctx) {
            if (v.visit(this, ctx) && this.initExpression != null) {
                this.initExpression = v.accept(this.initExpression);
            }
            v.endVisit(this, ctx);
        }
    }
}

