/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.WeakFactoryMap;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileDocumentManagerImpl
extends FileDocumentManager {
    private static final Key<VirtualFile> MOCK_VIRTUAL_FILE_KEY = Key.create("MockVirtualFile");
    private final Function<CharSequence, Document> myFactory;
    @Nullable
    private final Key<Reference<Document>> myCachedDocumentKey;
    private final WeakFactoryMap<VirtualFile, Document> myDocuments = new WeakFactoryMap<VirtualFile, Document>(){

        @Override
        protected Document create(VirtualFile key) {
            if (key.isDirectory() || this.isBinaryWithoutDecompiler(key)) {
                return null;
            }
            CharSequence text = LoadTextUtil.loadText(key);
            Document document = (Document)MockFileDocumentManagerImpl.this.myFactory.fun(text);
            document.putUserData(MOCK_VIRTUAL_FILE_KEY, key);
            return document;
        }

        private boolean isBinaryWithoutDecompiler(VirtualFile file) {
            FileType ft = file.getFileType();
            return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) == null;
        }
    };

    public MockFileDocumentManagerImpl(Function<CharSequence, Document> factory, @Nullable Key<Reference<Document>> cachedDocumentKey) {
        this.myFactory = factory;
        this.myCachedDocumentKey = cachedDocumentKey;
    }

    @Override
    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileDocumentManagerImpl.getDocument must not be null");
        }
        return this.myDocuments.get(file);
    }

    @Override
    public Document getCachedDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileDocumentManagerImpl.getCachedDocument must not be null");
        }
        if (this.myCachedDocumentKey != null) {
            Reference<Document> reference = file.getUserData(this.myCachedDocumentKey);
            return reference != null ? reference.get() : null;
        }
        return null;
    }

    @Override
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileDocumentManagerImpl.getFile must not be null");
        }
        return document.getUserData(MOCK_VIRTUAL_FILE_KEY);
    }

    @Override
    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileDocumentManagerImpl.saveDocument must not be null");
        }
    }

    @Override
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileDocumentManagerImpl.saveDocumentAsIs must not be null");
        }
    }

    @Override
    public void reloadFromDisk(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileDocumentManagerImpl.reloadFromDisk must not be null");
        }
    }

    @Override
    @NotNull
    public String getLineSeparator(VirtualFile file, Project project) {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockFileDocumentManagerImpl.getLineSeparator must not return null");
        }
        return "";
    }
}

