/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.SegmentArray;
import org.jetbrains.annotations.NotNull;

public class SegmentArrayWithData
extends SegmentArray {
    private short[] myData = new short[64];

    public void setElementAt(int i, int startOffset, int endOffset, int data) {
        if (data < 0 && data > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("data out of short range" + data);
        }
        super.setElementAt(i, startOffset, endOffset);
        this.myData = SegmentArrayWithData.reallocateArray(this.myData, i + 1);
        this.myData[i] = (short)data;
    }

    @Override
    public void remove(int startIndex, int endIndex) {
        this.myData = this.remove(this.myData, startIndex, endIndex);
        super.remove(startIndex, endIndex);
    }

    public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
        if (segmentArray == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArrayWithData.insert must not be null");
        }
        this.myData = this.insert(this.myData, segmentArray.myData, startIndex, segmentArray.getSegmentCount());
        super.insert(segmentArray, startIndex);
    }

    @NotNull
    private short[] insert(@NotNull short[] array, @NotNull short[] insertArray, int startIndex, int insertLength) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArrayWithData.insert must not be null");
        }
        if (insertArray == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArrayWithData.insert must not be null");
        }
        short[] newArray = SegmentArrayWithData.reallocateArray(array, this.mySegmentCount + insertLength);
        if (startIndex < this.mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArrayWithData.insert must not return null");
        }
        return newArray;
    }

    @NotNull
    private short[] remove(@NotNull short[] array, int startIndex, int endIndex) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArrayWithData.remove must not be null");
        }
        if (endIndex < this.mySegmentCount) {
            System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
        }
        if (array == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArrayWithData.remove must not return null");
        }
        return array;
    }

    public short getSegmentData(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        return this.myData[index];
    }

    public void setSegmentData(int index, int data) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        if (data < 0 && data > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("data out of short range" + data);
        }
        this.myData[index] = (short)data;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static short[] reallocateArray(@NotNull short[] array, int index) {
        short[] sArray;
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/ex/util/SegmentArrayWithData.reallocateArray must not be null");
        }
        if (index < array.length) {
            sArray = array;
            if (array == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArrayWithData.reallocateArray must not return null");
            return sArray;
        }
        short[] newArray = new short[SegmentArrayWithData.calcCapacity(array.length, index)];
        System.arraycopy(array, 0, newArray, 0, array.length);
        sArray = newArray;
        if (newArray != null) return sArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/ex/util/SegmentArrayWithData.reallocateArray must not return null");
    }
}

