/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Key<String> DETECTED_LINE_SEPARATOR_KEY = Key.create("DETECTED_LINE_SEPARATOR_KEY");
    private static final Key<String> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create("CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparators(@NotNull CharBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertLineSeparators must not be null");
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        CharBuffer result = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        Pair<CharSequence, String> pair = Pair.create(result, detectedLineSeparator);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertLineSeparators must not return null");
        }
        return pair;
    }

    private static Charset detectCharset(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharset must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharset must not be null");
        }
        Charset charset = null;
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(virtualFile, content, content.length);
        if (guessed != null && guessed.first != null) {
            charset = (Charset)guessed.first;
        } else {
            FileType fileType = virtualFile.getFileType();
            String charsetName = fileType.getCharset(virtualFile, content);
            if (charsetName == null) {
                Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile, true);
                if (specifiedExplicitly != null) {
                    charset = specifiedExplicitly;
                }
            } else {
                charset = CharsetToolkit.forName(charsetName);
            }
        }
        Charset charset2 = charset = charset == null ? EncodingRegistry.getInstance().getDefaultCharset() : charset;
        if (EncodingRegistry.getInstance().isNative2Ascii(virtualFile)) {
            charset = Native2AsciiCharset.wrap(charset);
        }
        virtualFile.setCharset(charset);
        return charset;
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharsetAndSetBOM must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharsetAndSetBOM must not be null");
        }
        Charset charset = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, content, true).getFirst();
        if (charset == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharsetAndSetBOM must not return null");
        }
        return charset;
    }

    @NotNull
    private static Pair<Charset, byte[]> doDetectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content, boolean saveBOM) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.doDetectCharsetAndSetBOM must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.doDetectCharsetAndSetBOM must not be null");
        }
        Charset charset = virtualFile.isCharsetSet() ? virtualFile.getCharset() : LoadTextUtil.detectCharset(virtualFile, content);
        Pair<Charset, byte[]> bomAndCharset = LoadTextUtil.getBOMAndCharset(content, charset);
        byte[] bom = (byte[])bomAndCharset.second;
        if (saveBOM && bom != null && bom.length != 0) {
            virtualFile.setBOM(bom);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, "auto-detected from BOM");
        }
        Pair<Charset, byte[]> pair = bomAndCharset;
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.doDetectCharsetAndSetBOM must not return null");
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means no luck, otherwise it's tuple(guessed encoding, hint about content if was unable to guess, BOM)")
    public static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int length) {
        String detectedFromBytes;
        block9: {
            CharsetToolkit.GuessedEncoding guessed;
            block11: {
                CharsetToolkit toolkit;
                block10: {
                    if (virtualFile == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.guessFromContent must not be null");
                    }
                    if (content == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.guessFromContent must not be null");
                    }
                    EncodingRegistry settings = EncodingRegistry.getInstance();
                    boolean shouldGuess = settings != null && settings.isUseUTFGuessing(virtualFile);
                    toolkit = shouldGuess ? new CharsetToolkit(content, EncodingRegistry.getInstance().getDefaultCharset()) : null;
                    detectedFromBytes = null;
                    if (!shouldGuess) break block9;
                    toolkit.setEnforce8Bit(true);
                    Charset charset = toolkit.guessFromBOM();
                    if (charset == null) break block10;
                    detectedFromBytes = "auto-detected from BOM";
                    byte[] bom = CharsetToolkit.getMandatoryBom(charset);
                    if (bom == null) {
                        bom = CharsetToolkit.UTF8_BOM;
                    }
                    Trinity<Charset, Object, byte[]> trinity = Trinity.create(charset, null, bom);
                    LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
                    return trinity;
                }
                guessed = toolkit.guessFromContent(length);
                if (guessed != CharsetToolkit.GuessedEncoding.VALID_UTF8) break block11;
                detectedFromBytes = "auto-detected from bytes";
                Trinity<Charset, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(CharsetToolkit.UTF8_CHARSET, guessed, null);
                LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
                return trinity;
            }
            Trinity<Object, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(null, guessed, null);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
            return trinity;
        }
        try {
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = null;
            return trinity;
        }
        finally {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Pair<Charset, byte[]> getBOMAndCharset(@NotNull byte[] content, Charset charset) {
        Pair<Charset, byte[]> pair;
        block9: {
            Pair<Charset, byte[]> pair2;
            if (content == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not be null");
            }
            if (charset != null && charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom(content)) {
                pair = Pair.create(charset, CharsetToolkit.UTF8_BOM);
                if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not return null");
                return pair;
            }
            try {
                Charset fromBOM = CharsetToolkit.guessFromBOM(content);
                if (fromBOM == null) break block9;
                pair2 = Pair.create(fromBOM, CharsetToolkit.getMandatoryBom(fromBOM));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
                break block9;
            }
            pair = pair2;
            if (pair2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not return null");
            return pair;
        }
        if ((pair = Pair.create(charset, ArrayUtil.EMPTY_BYTE_ARRAY)) != null) return pair;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.write must not be null");
        }
        if (requestor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.write must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.write must not be null");
        }
        Charset existing = virtualFile.getCharset();
        Pair<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile, text, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (charset != null && !charset.equals(existing)) {
            virtualFile.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile, buffer);
        OutputStream outputStream = virtualFile.getOutputStream(requestor, newModificationStamp, -1L);
        try {
            outputStream.write(buffer);
        }
        finally {
            outputStream.close();
        }
    }

    @NotNull
    private static Pair<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text, @Nullable Charset existing) {
        Charset fromBom;
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetForWriting must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetForWriting must not be null");
        }
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text);
        Pair<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.create(fromBom, LoadTextUtil.toBytes(text, fromBom));
        }
        Pair<Charset, byte[]> pair = chosen;
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetForWriting must not return null");
        }
        return pair;
    }

    public static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.setDetectedFromBytesFlagBack must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.setDetectedFromBytesFlagBack must not be null");
        }
        if (virtualFile.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile, content, content.length);
        } else {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, "auto-detected from BOM");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Pair<Charset, byte[]> chooseMostlyHarmlessCharset(Charset existing, Charset specified, @NotNull String text) {
        Pair<Charset, byte[]> pair;
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.chooseMostlyHarmlessCharset must not be null");
        }
        if (existing == null) {
            pair = Pair.create(specified, LoadTextUtil.toBytes(text, specified));
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.chooseMostlyHarmlessCharset must not return null");
            return pair;
        }
        if (specified == null || specified.equals(existing)) {
            pair = Pair.create(specified, LoadTextUtil.toBytes(text, existing));
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.chooseMostlyHarmlessCharset must not return null");
            return pair;
        }
        byte[] out = LoadTextUtil.isSupported(specified, text);
        if (out != null) {
            pair = Pair.create(specified, out);
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.chooseMostlyHarmlessCharset must not return null");
            return pair;
        }
        out = LoadTextUtil.isSupported(existing, text);
        if (out != null) {
            pair = Pair.create(existing, out);
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.chooseMostlyHarmlessCharset must not return null");
            return pair;
        }
        pair = Pair.create(specified, LoadTextUtil.toBytes(text, specified));
        if (pair != null) return pair;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.chooseMostlyHarmlessCharset must not return null");
    }

    @NotNull
    private static byte[] toBytes(@NotNull String text, @Nullable Charset charset) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.toBytes must not be null");
        }
        byte[] byArray = charset == null ? text.getBytes() : text.getBytes(charset);
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.toBytes must not return null");
        }
        return byArray;
    }

    @Nullable(value="null means not supported, otherwise it is converted byte stream")
    private static byte[] isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.isSupported must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.isSupported must not be null");
        }
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.extractCharsetFromFileContent must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.extractCharsetFromFileContent must not be null");
        }
        Charset charset = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text);
        if (charset == null) {
            charset = virtualFile.getCharset();
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetFromContentOrNull must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetFromContentOrNull must not be null");
        }
        FileType fileType = virtualFile.getFileType();
        if (fileType instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile, text);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file) {
        CharSequence charSequence;
        CharSequence charSequence2;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not be null");
        }
        if (file instanceof LightVirtualFile) {
            CharSequence content = ((LightVirtualFile)file).getContent();
            if (StringUtil.indexOf(content, '\r') == -1) {
                charSequence2 = content;
                if (charSequence2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not return null");
                return charSequence2;
            } else {
                CharBuffer buffer = CharBuffer.allocate(content.length());
                buffer.append(content);
                buffer.rewind();
                charSequence2 = (CharSequence)LoadTextUtil.convertLineSeparators((CharBuffer)buffer).first;
                if (charSequence2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not return null");
                return charSequence2;
            }
        }
        assert (!file.isDirectory()) : "'" + file.getPresentableUrl() + "' is directory";
        FileType fileType = file.getFileType();
        if (fileType.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType);
            if (decompiler == null) {
                throw new IllegalArgumentException("Attempt to load text for binary file, that doesn't have decompiler plugged in: " + file.getPresentableUrl());
            }
            CharSequence text = decompiler.decompile(file);
            StringUtil.assertValidSeparators(text);
            charSequence2 = text;
            if (charSequence2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not return null");
            return charSequence2;
        }
        try {
            byte[] bytes = file.contentsToByteArray();
            charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, file);
        }
        catch (IOException e) {
            charSequence2 = ArrayUtil.EMPTY_CHAR_SEQUENCE;
            if (charSequence2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not return null");
            return charSequence2;
        }
        charSequence2 = charSequence;
        if (charSequence == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not return null");
        return charSequence2;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true, true);
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        Pair<Charset, byte[]> pair = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, bytes, saveBOM);
        Charset charset = pair.getFirst();
        byte[] bom = pair.getSecond();
        int offset = bom == null ? 0 : bom.length;
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, charset, offset);
        if (saveDetectedSeparators) {
            virtualFile.putUserData(DETECTED_LINE_SEPARATOR_KEY, result.getSecond());
        }
        CharSequence charSequence = result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        Pair<Charset, byte[]> pair = LoadTextUtil.getBOMAndCharset(bytes, charset);
        byte[] bom = pair.getSecond();
        int offset = bom == null ? 0 : bom.length;
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, charset, offset);
        CharSequence charSequence = result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @NotNull
    private static Pair<CharSequence, String> convertBytes(@NotNull byte[] bytes, Charset charset, int startOffset) {
        CharBuffer charBuffer;
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertBytes must not be null");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        if (charset == null) {
            charset = CharsetToolkit.getDefaultSystemCharset();
        }
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        try {
            charBuffer = charset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparators(charBuffer);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertBytes must not return null");
        }
        return pair;
    }

    public static void setCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile, @Nullable(value="null if was not detected, otherwise the reason it was") String reason) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.setCharsetWasDetectedFromBytes must not be null");
        }
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, reason);
    }
}

