/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.Reflection;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    private static boolean USE_DARK_ICONS = UIUtil.isUnderDarcula();
    private static final ConcurrentHashMap<URL, Icon> ourIconsCache = new ConcurrentHashMap(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = new WeakHashMap<Icon, Icon>(200);
    private static final Map<String, String> ourDeprecatedIconsReplacements = new HashMap<String, String>();
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    @Deprecated
    public static Icon getIcon(@NotNull Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getIcon must not be null");
        }
        return new MyImageIcon(image);
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getIcon must not be null");
        }
        int stackFrameCount = 2;
        Class callerClass = Reflection.getCallerClass((int)stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = Reflection.getCallerClass((int)(++stackFrameCount));
        }
        if (callerClass == null) {
            callerClass = Reflection.getCallerClass((int)1);
        }
        Icon icon = IconLoader.getIcon(path, callerClass);
        if (icon == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader.getIcon must not return null");
        }
        return icon;
    }

    @Nullable
    private static Icon getReflectiveIcon(String path, ClassLoader classLoader) {
        try {
            String pckg = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path.substring(path.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getIcon must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getIcon must not be null");
        }
        Icon icon = IconLoader.findIcon(path, aClass);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader.getIcon must not return null");
        }
        return icon2;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        return IconLoader.findIcon(path, aClass, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        if (IconLoader.isReflectivePath(path = IconLoader.undeprecate(path))) {
            return IconLoader.getReflectiveIcon(path, aClass.getClassLoader());
        }
        ByClass icon = new ByClass(aClass, path);
        if (computeNow || !Registry.is("ide.lazyIconLoading", true)) {
            return icon.getOrComputeIcon();
        }
        return icon;
    }

    private static String undeprecate(String path) {
        String replacement = ourDeprecatedIconsReplacements.get(path);
        return replacement != null ? replacement : path;
    }

    private static boolean isReflectivePath(String path) {
        List<String> paths = StringUtil.split(path, ".");
        return paths.size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    public static Icon findIcon(URL url) {
        if (url == null) {
            return null;
        }
        Icon icon = ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url);
            icon = ourIconsCache.cacheOrGet(url, icon);
        }
        return icon;
    }

    @Nullable
    private static Icon checkIcon(Image image, URL url) {
        if (image == null || image.getHeight(LabelHolder.ourFakeComponent) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (icon != null && !IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        return icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.isGoodSize must not be null");
        }
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    static {
        ourDeprecatedIconsReplacements.put("/general/toolWindowDebugger.png", "AllIcons.Toolwindows.ToolWindowDebugger");
        ourDeprecatedIconsReplacements.put("/general/toolWindowChanges.png", "AllIcons.Toolwindows.ToolWindowChanges");
        ourDeprecatedIconsReplacements.put("/actions/showSettings.png", "AllIcons.General.ProjectSettings");
        ourDeprecatedIconsReplacements.put("/general/ideOptions.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/general/applicationSettings.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/toolbarDecorator/add.png", "AllIcons.General.Add");
        ourDeprecatedIconsReplacements.put("/vcs/customizeView.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/vcs/refresh.png", "AllIcons.Actions.Refresh");
        ourDeprecatedIconsReplacements.put("/actions/sync.png", "AllIcons.Actions.Refresh");
        ourDeprecatedIconsReplacements.put("/actions/refreshUsages.png", "AllIcons.Actions.Rerun");
        ourDeprecatedIconsReplacements.put("/compiler/error.png", "AllIcons.General.Error");
        ourDeprecatedIconsReplacements.put("/compiler/hideWarnings.png", "AllIcons.General.HideWarnings");
        ourDeprecatedIconsReplacements.put("/compiler/information.png", "AllIcons.General.Information");
        ourDeprecatedIconsReplacements.put("/compiler/warning.png", "AllIcons.General.Warning");
        ourDeprecatedIconsReplacements.put("/ide/errorSign.png", "AllIcons.General.Error");
        ourDeprecatedIconsReplacements.put("/ant/filter.png", "AllIcons.General.Filter");
        ourDeprecatedIconsReplacements.put("/inspector/useFilter.png", "AllIcons.General.Filter");
        ourDeprecatedIconsReplacements.put("/actions/showSource.png", "AllIcons.Actions.Preview");
        ourDeprecatedIconsReplacements.put("/actions/consoleHistory.png", "AllIcons.General.MessageHistory");
        ourDeprecatedIconsReplacements.put("/vcs/messageHistory.png", "AllIcons.General.MessageHistory");
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
        ourIsActivated = false;
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();
    }

    private static class ByClass
    extends LazyIcon {
        private final Class myCallerClass;
        private final String myPath;

        public ByClass(Class aClass, String path) {
            this.myCallerClass = aClass;
            this.myPath = path;
        }

        @Override
        protected Icon compute() {
            URL url = this.myCallerClass.getResource(this.myPath);
            return IconLoader.findIcon(url);
        }

        public String toString() {
            return "icon path=" + this.myPath + " class=" + this.myCallerClass;
        }
    }

    public static abstract class LazyIcon
    implements Icon {
        private boolean myWasComputed;
        private Icon myIcon;
        private boolean isDarkVariant = IconLoader.access$400();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = this.getOrComputeIcon();
            if (icon != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconWidth() : 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconHeight() : 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            if (!this.myWasComputed || this.isDarkVariant != USE_DARK_ICONS) {
                this.isDarkVariant = USE_DARK_ICONS;
                this.myWasComputed = true;
                this.myIcon = this.compute();
            }
            return this.myIcon;
        }

        protected abstract Icon compute();
    }

    private static final class MyImageIcon
    extends ImageIcon {
        public MyImageIcon(Image image) {
            super(image);
        }

        @Override
        public final synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(null, g, x, y);
        }
    }

    private static final class CachedImageIcon
    implements Icon {
        private Object myRealIcon;
        private final URL myUrl;

        public CachedImageIcon(URL url) {
            this.myUrl = url;
        }

        private synchronized Icon getRealIcon() {
            Icon icon;
            if (IconLoader.isLoaderDisabled()) {
                return EMPTY_ICON;
            }
            if (this.myRealIcon instanceof Icon) {
                return (Icon)this.myRealIcon;
            }
            if (this.myRealIcon instanceof Reference && (icon = (Icon)((Reference)this.myRealIcon).get()) != null) {
                return icon;
            }
            Image image = ImageLoader.loadFromUrl(this.myUrl);
            icon = IconLoader.checkIcon(image, this.myUrl);
            if (icon != null) {
                this.myRealIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<Icon>(icon);
            }
            return icon != null ? icon : EMPTY_ICON;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getRealIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }
    }
}

