/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ConcurrentWeakValueIntObjectHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private final int myIndex;
    private final String myName;
    private static final ConcurrentWeakValueIntObjectHashMap<Key> allKeys = new ConcurrentWeakValueIntObjectHashMap();

    public Key(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Key.<init> must not be null");
        }
        this.myIndex = ourKeysCounter.getAndIncrement();
        this.myName = name;
        allKeys.put(this.myIndex, (Object)this);
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.myName;
    }

    public static <T> Key<T> create(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Key.create must not be null");
        }
        return new Key<T>(name);
    }

    @Nullable
    public T get(@Nullable UserDataHolder holder) {
        return holder == null ? null : (T)holder.getUserData(this);
    }

    @Nullable
    public T get(@Nullable Map<Key, ?> holder) {
        return holder == null ? null : (T)holder.get(this);
    }

    public T get(@Nullable UserDataHolder holder, T defaultValue) {
        T t = this.get(holder);
        return t == null ? defaultValue : t;
    }

    public boolean isIn(@Nullable UserDataHolder holder) {
        return this.get(holder) != null;
    }

    public void set(@Nullable UserDataHolder holder, @Nullable T value) {
        if (holder != null) {
            holder.putUserData(this, value);
        }
    }

    public void set(@Nullable Map<Key, Object> holder, T value) {
        if (holder != null) {
            holder.put(this, value);
        }
    }

    public static <T> Key<T> getKeyByIndex(int index) {
        return (Key)allKeys.get(index);
    }
}

